<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\BaseController;
use App\Model\AdminUser;
use App\Model\User;
use App\Model\Youtober;
use App\Model\EmailTemplate;
use Carbon\Carbon;
use App\Helpers\Helpers;
use App\Services\Input;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Config;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Support\Facades\Request;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\View;

/**
 * AdminLogin Controller
 *
 * Add your methods in the class below
 *
 * This file will render views\admin\login
 */
class AdminLoginController extends BaseController
{
    /**
     * Function for display admin  login page
     */
    public function login()
    {
        $formData    =    Input::all();
        if (Auth::check()) {
            if (Auth::user()->user_type == SUPER_ADMIN) {
                return Redirect::route('admin_dashboard');
            } elseif (Auth::user()->user_type == SUB_ADMIN) {
                return Redirect::route('admin_dashboard');
            }
        }
        if (Request::isMethod('post')) {
            $userdata = [
                'email' => Input::get('email'),
                'password' => Input::get('password'),
                'activation_status' => ACTIVE_USER,
            ];
            //print_r($userdata);
            if (!empty($formData['remember'])) {
                if (Auth::guard('web')->attempt($userdata)) {
                    Session::flash('flash_notice', trans("Login success"));
                    return Redirect::route('admin_dashboard')->withCookie(cookie('email', $formData['email'], 45000))->withCookie(cookie('remember', $formData['remember'], 45000));
                } elseif (Auth::guard('youtober')->attempt(['email' => Input::get('email'), 'password' => Input::get('password'), 'is_yoububer' => '1'])) {
                    $youtober_data = DB::table('registerusers')->where('email', '=', Input::get('email'))->where('is_yoububer', '1')->select('id', 'email')->first();
                    //Setm Value In Session
                    Session::put('id', $youtober_data->id);
                    //Show Message
                    Session::flash('flash_notice', trans("Login success"));
                    return Redirect::route('admin_dashboard')->withCookie(cookie('email', $youtober_data->email, 45000))->withCookie(cookie('remember', $formData['remember'], 45000));
                } else {
                    //Login Detail
                    Session::flash('error', trans("Login detail incorrect or user has deactivate"));
                    return Redirect::back()->withInput();
                }
            }
            //print_r(Auth::attempt($userdata));die;
            if (Auth::guard('web')->attempt($userdata)) {
                Session::flash('flash_notice', trans("Login success"));
                return Redirect::route('admin_dashboard')->withCookie(cookie('email', $formData['email'], -45000))->withCookie(cookie('remember', '', -45000));
            }
            if (Auth::guard('youtober')->attempt(['email' => Input::get('email'), 'password' => Input::get('password'), 'is_yoububer' => '1'])) {
                $youtober_data = DB::table('registerusers')->where('email', '=', Input::get('email'))->where('is_yoububer', '1')->select('id', 'email')->first();
                //Set Session
                Session::put('id', $youtober_data->id);
                //Show Message
                Session::flash('flash_notice', trans("Login success"));
                return Redirect::route('admin_dashboard')->withCookie(cookie('email', $youtober_data->email, -45000))->withCookie(cookie('remember', '', -45000));
            } else {
                //echo 'hemant';die;
                Session::flash('error', trans("Login detail incorrect or user has deactivate"));
                return Redirect::back()->withInput();
            }
        } else {
            return View::make('admin.Login.index');
        }
    } // end index()

    /**
     * Function for logout admin users
     *
     */
    public function logout()
    {
        Auth::guard('web')->logout();
        Auth::guard('youtober')->logout();
        session()->forget('id');
        session()->forget('name');
        session()->forget('email');
        session()->forget('mobile');
        session()->forget('image');
        Session::flash('flash_notice', "Logout successfully");
        return Redirect::route('Admin.login');
    } //endLogout()

    /**
     * Function is used to display forget password page
     */
    public function forgetPassword()
    {
        return View::make('admin.Login.forgot_password');
    } // end forgetPassword()

    /**
     * Function is used for reset password
     *
     * @param $validate_string as validator string
     *
     */
    public function resetPassword($validate_string = null)
    {
        if ($validate_string != "" && $validate_string != null) {
            $validate_string = unserialize(base64_decode($validate_string));
            $userDetail = AdminUser::where('email', $validate_string)->first();
            if (!empty($userDetail)) {
                return View::make('admin.Login.reset_password', compact('validate_string'));
            } else {
                return Redirect::route('Admin.login')
                    ->with('error', trans('Sorry, you are using wrong link.'));
            }
        } else {
            return Redirect::route('Admin.login')->with('error', trans('Sorry, you are using wrong link.'));
        }
    } // end resetPassword()

    /**
     * Function is used to send email for forgot password process
     */
    public function sendPassword()
    {
        // After 30 minute reset password link will be expired
        $expire_link_time    =    Carbon::now()->addMinutes(30);
        $validator = Validator::make(Input::all(), ['email' => 'required|email',]);
        if ($validator->fails()) {
            return Redirect::back()->withErrors($validator)->withInput();
        } else {
            $email            =    Input::get('email');
            $userDetail        =    AdminUser::where('email', trim($email))->first();
            if (isset($userDetail) && !empty($userDetail)) {
                //$forgot_password_validate_string	= 	md5($userDetail->email);
                $forgot_password_validate_string    =     base64_encode(serialize($userDetail->email));
                $settingsEmail         =      Config::get('Site.email');
                $email                 =      $userDetail->email;
                $username            =      $userDetail->username;
                $full_name            =      $userDetail->name;
                $route_url          =      route('Admin.reset_password', $forgot_password_validate_string);
                $varify_link           =   $route_url;

                //http://dev.rglabs.net/fp11/fantasypoweradmin/images/top-bg-01.png
                //$image_url=WEBSITE_IMAGE_URL.'top-bg-01.png';
                //print_r($image_url);die;
                //Send Email

                $emailTemplates        =    EmailTemplate::where('action', '=', 'forgot password')->get(array('name', 'subject', 'action', 'body'))->toArray();
                $subject      =  $emailTemplates[0]['subject'];
                $rep_Array      = [$full_name, $varify_link, $route_url];
                //Set Fields
                $template = ['{USER_NAME}', '{FORGOT_PASSWORD_LINK}', '{LINK}'];
                //Replase Value
                $messageBody =  str_replace($template, $rep_Array, $emailTemplates[0]['body']);
                $msg = Helpers::mailheader();
                $msg .= $messageBody;
                $msg .= Helpers::mailfooter();
                Helpers::mailsentFormat($email, $subject, $msg);
                //Message
                Session::flash('flash_notice', trans('Reset Password Link Send Your Email Address!'));
                return Redirect::route('Admin.login');
            } else {
                return Redirect::back()->with('error', trans('Login invalid access'));
            }
        }
    } // sendPassword()

    /**
     * Function is used for save reset password
     *
     * @param $validate_string as validator string
     *
     */
    public function resetPasswordSave($validate_string = null)
    {
        $newPassword        =    Input::get('new_password');
        $messages = [
            'new_password.required' => trans('Password rquired'),
            'new_password_confirmation.required' => trans('AdminLogin comfrom rquired'),
            'new_password.confirmed' => trans('confirmed password rquired '),
            'new_password.min' => trans('Password Min 6 char'),
        ];
        $validator = Validator::make(
            Input::all(),
            [
                'new_password' => 'required|min:6|confirmed',
                'new_password_confirmation' => 'required|min:6',
            ],
            $messages
        );
        $newPassword        =    Hash::make($newPassword);
        if ($validator->fails()) {
            return Redirect::back()->withErrors($validator)->withInput()->with(compact(''));
        } else {
            $userInfo = AdminUser::where('email', $validate_string)->first();
            AdminUser::where('email', $validate_string)->update(array(
                'password'    =>    $newPassword
            ));
            Session::flash('flash_notice', trans('password success update'));
            Auth::logout();
            return Redirect::route('Admin.login');
        }
    } // end resetPasswordSave()

}// end AdminLoginController
