<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Http\Requests;
use Illuminate\Http\Request;
use App\Model\Registerusers;
use App\libraries\CustomHelper;
use App\Helpers\Helpers;
use Carbon\Carbon;
use App\Services\Input;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Support\Facades\View;
use Yajra\DataTables\Facades\DataTables;

class AnalyticsController extends Controller
{

    /*
	 * Function for display email detail from database
	 *
	 * @param null
	 *
	 * @return view page.
	 */
    public $model    =    'Analytics';

    public function __construct()
    {
        View::share('modelName', $this->model);
    } //End Function


    public function gstreport()
    {
        $formData = Input::all();
        if (isset($formData) && !empty($formData)) {
            //Get Start Data
            if (!empty($formData['start_date'])) {
                $start_date = $formData['start_date'];
                $start_date = date('Y-m-d H:i:s', strtotime('-1 day', strtotime($start_date)));
            } else {
                $start_date = date('Y-m-d H:i:s', strtotime('-30 day'));
            }

            //Get End Date
            if (!empty($formData['end_date'])) {
                $end_date = $formData['end_date'];
            } else {
                $end_date = date('Y-m-d H:i:s');
            }

            return DataTables::of(DB::table('transactions')
                ->where('transactions.challengeid', '<>', 0)
                ->whereDate('transactions.created', '>=', date('Y-m-d h:i:s', strtotime($start_date)))
                ->whereDate('transactions.created', '<=', date('Y-m-d h:i:s', strtotime($end_date)))
                ->where(function ($query) {
                    $query->where('listmatches.launch_status', 'launched')->where('listmatches.final_status', 'winnerdeclared');
                })->where(function ($query) {
                    $query->where('matchchallenges.maximum_user', '=', DB::raw('matchchallenges.joinedusers'))->orWhere('matchchallenges.confirmed_challenge', 1);
                })->where('matchchallenges.win_amount', '!=', 0)
                ->join('matchchallenges', 'matchchallenges.id', '=', 'transactions.challengeid')
                ->join('listmatches', 'listmatches.matchkey', '=', 'matchchallenges.matchkey')
                ->join('registerusers', 'registerusers.id', '=', 'transactions.userid')
                ->orderBY('transactions.id', 'DESC')
                ->select('transactions.challengeid', 'matchchallenges.matchkey', 'listmatches.final_status', 'matchchallenges.joinedusers', 'matchchallenges.maximum_user', 'matchchallenges.marathon', 'transactions.userid as userid', 'matchchallenges.entryfee', 'matchchallenges.win_amount', 'transactions.created as joineddate', 'transactions.transaction_id', 'registerusers.state')->get())
                ->addIndexColumn()
                ->addColumn('getpoolprize', function ($result) {
                    return $platformfee =  $getpoolprize = $fmatch->win_amount / $fmatch->joinedusers;
                })->addColumn('platformfee', function ($result) {
                    $platformfee = round((($result->entryfee - $getpoolprize) / 1.18), 2);
                    if ($platformfee > 0) {
                        return $platformfee;
                    } else {
                        return 0;
                    }
                })->addColumn('igst', function ($result) {
                    if ($result->state != 'madhya pradesh' && $result->state != 'Madhya Pradesh') {
                        $igst = ($platformfee * 18) / 100;
                        if ($igst < 0) {
                            $igst = 0;
                        }
                        return $igst =  round($igst, 2);
                        $totaligst = $totaligst + $igst;
                    }
                })->addColumn('cgst', function ($result) {
                    if ($result->state == 'Madhya Pradesh' || $result->state == 'madhya pradesh') {
                        $cgst = ($platformfee * 9) / 100;
                        if ($cgst < 0) {
                            $cgst = 0;
                        }
                        return $cgst =  round($cgst, 2);
                        $totalcgst = $totalcgst + $cgst;
                    }
                })->addColumn('sgst', function ($result) {
                    if ($result->state == 'Madhya Pradesh' || $result->state == 'madhya pradesh') {
                        $sgst = ($platformfee * 9) / 100;
                        if ($sgst < 0) {
                            $sgst = 0;
                        }
                        return $sgst =  round($sgst, 2);
                        $totalsgst = $totalsgst + $sgst;
                    }
                })->addColumn('margin', function ($result) {
                    return round(($platformfee / ($result->win_amount / $result->joinedusers)) * 100, 2) . '%';
                })->addColumn('state', function ($result) {
                    return $result->state;
                })
                ->escapeColumns([])
                ->make(true);
        } //end

        return view("admin.$this->model.gstreport");
    }

    // Genrate GST CRON
    public function generateGstByCron($m = "")
    {
        return true;
    }
    // Genrate GST CRON

    public function gstreportcron(Request $request)
    {

        date_default_timezone_set("Asia/Kolkata");
        $formData = $request->all();
        $sport_types_q = DB::table('sport_types')->where('status', 1)->get();
        $sport_type_arr = [];
        foreach ($sport_types_q as $key => $value) {
            $sport_type_arr[$value->id] = $value->sport_key;
        }

        $start_date = @$_GET['start_date'] != "" ? date('Y-m-d 00:00:00', strtotime($formData['start_date'])) : date("Y-m-01 00:00:00");
        $end_date = @$_GET['end_date'] != "" ? date('Y-m-d 23:59:59', strtotime($formData['end_date'])) : date("Y-m-t 23:59:59");


        //for gstreport download in excel
        if (!empty($start_date) && !empty($end_date) && @$formData['download'] != "") {
            $matches = DB::table('listmatches as lm')
                ->where('launch_status', 'launched')
                ->whereIn('final_status', ['IsReviewed', 'pending'])
                ->where('lm.is_gst_generated', 0)
                ->where('start_date', '>=', date('Y-m-d 00:00:00', strtotime($_GET['start_date'])))
                ->where('start_date', '<=', date('Y-m-d 23:59:59', strtotime($_GET['end_date'])))
                // ->count();
                ->selectRaw("GROUP_CONCAT(matchkey) as matchkeys")
                ->first();

            if (!empty($matches)) {
                $matchkeys = $matches->matchkeys;
                // echo "$matchkeys";
                $joining = DB::table("joinedleauges")
                    ->whereIn("matchkey", explode(",", $matchkeys))
                    ->exists();
                // echo "$joining";exit();
                if ($joining) {
                    return Redirect::back()->withError("Some matches are in live mode, so gst has not generated please download tomorrow");
                }
            }

            // exit();
            ini_set('memory_limit', '-1');

            $fileName = 'gst-report-' . date("YmdHis", time());
            header('Content-Encoding: UTF-8');
            header("Content-type:application/vnd.ms-excel;charset=UTF-8");
            header('Content-Disposition: attachment;filename="' . $fileName . '.csv"');

            $tableheader = array(
                'A' => 'CUSTOMER ID',
                'B' => 'STATE OF CUSTOMER',
                'C' => 'REFERER EMAIL',
                'D' => 'REFERER NAME',
                'E' => 'REFERER COMISSSION',
                'F' => 'MATCH TITLE',
                'G' => 'CONTEST FEES',
                'H' => 'TOTAL PLATFORM FEES',
                'I' => 'BEFORE TAX PLATFORM FEES',
                'J' => 'INTEGRATED TAX',
                'K' => 'STATE TAX',
                'L' => 'CENTRAL TAX',
                'M' => 'TOTAL TAX',
                'N' => 'TRANSACTION DATE',
                'O' => 'USER NAME',
                'P' => 'USER EMAIL',
                'Q' => 'USER MOBILE'
            );


            $fp = fopen('php://output', 'a');
            fputcsv($fp, $tableheader);

            $datacount = DB::table('gst_report as gt')
                ->where(function ($q) use ($formData) {
                    if (@$formData['matchkey'] != '')
                        $q->where('gt.matchkey', $formData['matchkey']);
                    if (@$formData['challenge_id'] != '')
                        $q->where('gt.challenge_id', $formData['challenge_id']);
                    if (@$formData['sport_type'] > 0) {
                        $q->where('gt.sport_type', $formData['sport_type']);
                    }
                })
                ->whereBetween('gt.match_date', [$start_date, $end_date])
                // ->whereDate('gt.match_date','>=', $start_date)
                // ->whereDate('gt.match_date','<=', $end_date)
                ->count();

            // echo $datacount;die();

            $loopcount = ceil($datacount / 10000);

            for ($i = 0; $i < $loopcount; $i++) {
                $query = DB::table('gst_report as gt')
                    ->leftJoin('registerusers as r', 'r.id', '=', 'gt.referer_id')
                    ->leftJoin('registerusers as r1', 'r1.id', '=', 'gt.user_id')
                    ->where(function ($q) use ($formData) {
                        if (@$formData['matchkey'] != '')
                            $q->where('gt.matchkey', $formData['matchkey']);
                        if (@$formData['challenge_id'] != '')
                            $q->where('gt.challenge_id', $formData['challenge_id']);
                        if (@$formData['sport_type'] > 0) {
                            $q->where('gt.sport_type', $formData['sport_type']);
                        }
                    })
                    // ->join('matchchallenges as m', 'm.id', '=', 'gt.challenge_id')
                    // ->where('m.status', '<>', 'canceled')
                    ->whereNotExists(function ($q) {
                        $q->select(DB::raw(1))->from('matchchallenges')
                            ->whereRaw('matchchallenges.id=gt.challenge_id and matchchallenges.status="canceled"');
                    })
                    ->whereBetween('gt.match_date', [$start_date, $end_date])
                    // ->where('gt.transaction_at','>=', $start_date)
                    // ->where('gt.transaction_at','<=', $end_date)
                    ->select('gt.match_title as title', 'r.email', 'r.username', 'gt.referer_bonus as commission', 'gt.user_id as CustomerID', 'gt.transaction_at as InvoiceDate', 'gt.state', 'gt.entry_fees as contestfees', 'gt.total_platform_fees', 'gt.before_tax_platform_fees', 'gt.igst', 'gt.cgst', 'gt.sgst', 'r1.username as user_username', 'r1.email as user_email', 'r1.mobile as user_mobile')
                    ->orderBy('gt.id', 'ASC')
                    ->offset($i * 10000)->limit(10000)
                    ->get();

                if (!$query->isEmpty()) {
                    foreach ($query as $key => $value) {

                        $row = [];
                        $row['CUSTOMER ID'] = $value->CustomerID;
                        $row['STATE OF CUSTOMER'] = $value->state;
                        $row['REFERER EMAIL'] = $value->email;
                        $row['REFERER NAME'] = $value->username;
                        $row['REFERER COMISSSION'] = $value->commission;
                        $row['MATCH TITLE'] = $value->title;
                        $row['CONTEST FEES'] = $value->contestfees;
                        $row['TOTAL PLATFORM FEES'] = $value->total_platform_fees;
                        $row['BEFORE TAX PLATFORM FEES'] = $value->before_tax_platform_fees;
                        $row['INTEGRATED TAX'] = $value->igst;
                        $row['STATE TAX'] = $value->sgst;
                        $row['CENTRAL TAX'] = $value->cgst;
                        $row['TOTAL TAX'] = round(($value->cgst + $value->sgst + $value->igst), 2);
                        $row['TRANSACTION DATE'] = date('d-m-Y h:i a', strtotime($value->InvoiceDate));
                        $row['USER NAME'] = $value->user_username;
                        $row['USER EMAIL'] = $value->user_email;
                        $row['USER MOBILE'] = $value->user_mobile;

                        fputcsv($fp, $row);
                    }
                }
                ob_flush();
                flush();
            }

            ob_end_clean();
            exit();
        }
        //end gst report download for excel

        if ($request->isMethod('post') && !empty($start_date) && !empty($end_date)) {

            $columns = array(
                0 =>     "gt.id",
                1 => 'gt.id',
                2 =>     "gt.id",
                3 =>     "gt.transaction_at",
                4 =>     "gt.user_id",
                5 =>     "gt.state",
                6 =>     "r.email",
                7 =>     "r.username",
                8 =>     "gt.referer_bonus",
                9 =>     "gt.sport_type",
                10 =>     "lm.title",
                11 =>     "gt.matchkey",
                12 =>     "gt.challenge_id",
                13 =>     "gt.entry_fees",
                14 =>     "mc.status",
                15 =>     "gt.gst_rate",
                16 =>     "gt.total_platform_fees",
                17 =>     "gt.before_tax_platform_fees",
                18 =>     "gt.igst",
                19 =>     "gt.sgst",
                20 =>     "gt.cgst"
            );

            $limit = $request->input('length');
            //echo $limit;exit;
            $start = $request->input('start');
            $order = $columns[@$request->input('order.0.column')];
            $dir = $request->input('order.0.dir');

            $query = DB::table('gst_report as gt')
                ->leftJoin('registerusers as r', 'r.id', '=', 'gt.referer_id')
                ->where(function ($q) use ($formData) {
                    if (@$formData['matchkey'] != '')
                        $q->where('gt.matchkey', $formData['matchkey']);
                    if (@$formData['challenge_id'] != '')
                        $q->where('gt.challenge_id', $formData['challenge_id']);
                    if (@$formData['sport_type'] > 0) {
                        $q->where('gt.sport_type', $formData['sport_type']);
                    }
                })
                ->whereBetween('gt.match_date', [$start_date, $end_date]);

            $totalTitles = $query->count();
            $totalFiltered = $totalTitles;
            $titles = $query
                ->offset($start)->limit($limit)
                ->select('gt.match_title as title', 'r.email', 'r.username', 'gt.referer_bonus as commission', 'gt.matchkey', 'gt.sport_type', 'gt.challenge_id', 'gt.match_status as status', 'gt.id as invoiceno', 'gt.user_id as CustomerID', 'gt.transaction_at as InvoiceDate', 'gt.state', 'gt.entry_fees as contestfees', 'gt.gst_rate as rate', 'gt.total_platform_fees', 'gt.before_tax_platform_fees', 'gt.igst', 'gt.cgst', 'gt.sgst', 'gt.created_at', 'gt.updated_at')
                ->orderBy($order, $dir)->get();

            $data = [];
            if (!empty($titles)) {
                $s_no = $start + 1;
                foreach ($titles as $title) {

                    $sport_type = $sport_type_arr[$title->sport_type];

                    if ($title->status == 'canceled')
                        $mc_status = '<label style="color:red;">Canceled</label>';
                    else
                        $mc_status = '<label style="color:green;">' . ucwords($title->status) . '</label>';

                    $nestedData['s_no'] = $s_no;
                    $nestedData['invoiceno'] = $title->invoiceno;
                    $nestedData['InvoiceDate'] = $title->InvoiceDate;
                    $nestedData['CustomerID'] = $title->CustomerID;
                    $nestedData['state'] = ucwords($title->state);
                    $nestedData['email'] = $title->email;
                    $nestedData['username'] = $title->username;
                    $nestedData['comisssion'] = $title->commission;
                    $nestedData['sport_type'] = $sport_type;
                    $nestedData['title'] = $title->title;
                    $nestedData['matchkey'] = $title->matchkey;
                    $nestedData['challenge_id'] = $title->challenge_id;
                    $nestedData['contestfees'] = $title->contestfees;
                    $nestedData['status'] = $mc_status; //$title->status;
                    $nestedData['rate'] = $title->rate;
                    $nestedData['total_platform_fees'] = $title->total_platform_fees;
                    $nestedData['before_tax_platform_fees'] = $title->before_tax_platform_fees;
                    $nestedData['igst'] = $title->igst;
                    $nestedData['sgst'] = $title->sgst;
                    $nestedData['cgst'] = $title->cgst;
                    $nestedData['total_tax'] = round(($title->igst + $title->sgst + $title->cgst), 2);

                    $data[] = $nestedData;
                    $s_no++;
                }
            }
            $json_data = array(
                "draw" => intval($request->input('draw')),
                "recordsTotal" => intval($totalTitles),
                "recordsFiltered" => intval($totalFiltered),
                "data" => $data,
            );
            //echo '<pre>'; print_r($json_data);exit;
            echo json_encode($json_data);
            die();
        }

        $totalTax = DB::table('gst_report as gt')
            ->where(function ($q) use ($formData) {
                if (@$formData['matchkey'] != '')
                    $q->where('gt.matchkey', $formData['matchkey']);
                if (@$formData['challenge_id'] != '')
                    $q->where('gt.challenge_id', $formData['challenge_id']);
                if (@$formData['sport_type'] > 0) {
                    $q->where('gt.sport_type', $formData['sport_type']);
                }
            })
            // ->join('matchchallenges as m', 'm.id', '=', 'gt.challenge_id')
            // ->where('m.status', '<>', 'canceled')
            ->whereNotExists(function ($q) {
                $q->select(DB::raw(1))->from('matchchallenges')
                    ->whereRaw('matchchallenges.id=gt.challenge_id and matchchallenges.status="canceled"');
            })
            ->whereBetween('gt.match_date', [$start_date, $end_date])
            ->selectRaw('ROUND(SUM(gt.igst),2) as igst, ROUND(SUM(gt.cgst),2) as cgst, ROUND(SUM(gt.sgst),2) as sgst')
            ->first();


        return view("admin.$this->model.gst-report2-new", compact('totalTax', 'sport_type_arr'));
    }

    //GST By deposit

    public function gstreportdeposit(Request $request)
    {
        date_default_timezone_set("Asia/Kolkata");
        $formData = $request->all();
        $sport_types_q = DB::table('sport_types')->where('status', 1)->get();
        $sport_type_arr = [];
        foreach ($sport_types_q as $key => $value) {
            $sport_type_arr[$value->id] = $value->sport_key;
        }

        $start_date = @$_GET['start_date'] != "" ? date('Y-m-d 00:00:00', strtotime($formData['start_date'])) : date("Y-m-01 00:00:00");
        $end_date = @$_GET['end_date'] != "" ? date('Y-m-d 23:59:59', strtotime($formData['end_date'])) : date("Y-m-t 23:59:59");


        //for gstreport download in excel
        if (!empty($start_date) && !empty($end_date) && @$formData['download'] != "") {

            ini_set('memory_limit', '-1');
            $fileName = 'gst-report-' . date("YmdHis", time());
            header('Content-Encoding: UTF-8');
            header("Content-type:application/vnd.ms-excel;charset=UTF-8");
            header('Content-Disposition: attachment;filename="' . $fileName . '.csv"');


            $tableheader = array(
                'A' => 'CUSTOMER ID',
                'B' => 'NAME CUSTOMER',
                'C' => 'EMAIL',
                'D' => 'MOBILE',
                'E' => 'STATE',
                'F' => 'PAN NUMBER',
                'G' => 'TEAM NAME',
                'H' => 'ADD FUND',
                'I' => 'GST AMOUNT',
                // 'J' => 'IGST',
                // 'K' => 'SGST',
                // 'L' => 'CGST',
                //	'M' => 'TOTAL TAX',
                'N' => 'WALLET AMOUNT',
                'O' => 'TRANSACTION BY',
                'P' => 'TRANSACTION DATE',
                'Q' => 'TOTAL TAX TO PAY'
            );

            $fp = fopen('php://output', 'a');
            fputcsv($fp, $tableheader);

            $datacount = DB::table('deposit_gst as gt')
                //->leftJoin('transactions as t', 't.userid', '=', 'gt.user_id')
                ->where(function ($q) use ($formData) {
                    if (@$formData['transaction_by'] != "") {
                        $q->where('gt.transaction_by', $formData['transaction_by']);
                    }
                })
                ->whereBetween('gt.transactions_date', [$start_date, $end_date])
                ->groupby('user_id')
                ->count();

            // echo $datacount;die();

            $loopcount = ceil($datacount / 10000);

            for ($i = 0; $i < $loopcount; $i++) {
                $query = DB::table('deposit_gst as gt')
                    ->Join('registerusers as r1', 'r1.id', '=', 'gt.user_id')
                    //->Join('transactions as t', 't.userid', '=', 'gt.user_id')
                    //	->where('t.type','Add Fund')
                    //	->where('t.paymentstatus','confirmed')
                    ->where(function ($q) use ($formData) {
                        if (@$formData['transaction_by'] != "") {
                            $q->where('gt.transaction_by', $formData['transaction_by']);
                        }
                    })
                    ->whereBetween('gt.transactions_date', [$start_date, $end_date])
                    //	->whereBetween('gt.transactions_date', [$start_date, $end_date])
                    ->select('gt.id as invoiceno', 'gt.user_id as CustomerID', 'gt.transactions_date as InvoiceDate', 'gt.deposit_amount', 'gt.gst_amount', 'gt.wallet_amount', 'gt.igst', 'gt.cgst', 'gt.sgst', 'r1.username as user_username', 'r1.email as user_email', 'r1.mobile as user_mobile', 'r1.team as teamname', 'gt.transaction_by', 'r1.state', DB::raw('SUM(deposit_amount) as totaldeposite'), DB::raw('SUM(gst_amount) as totalgstamount'))
                    ->orderBy('gt.id', 'DESC')
                    //	->offset($i * 10000)
                    //->limit(10000)
                    ->groupby('user_id')
                    ->get();

                if (!$query->isEmpty()) {
                    foreach ($query as $key => $value) {
                        $panCard = DB::table('pancard')
                            ->where('pancard.userid', $value->CustomerID)
                            ->select('pan_number')->first();
                        $row = [];
                        //	$row['INVOICE NO'] = $value->invoiceno;
                        $row['CUSTOMER ID'] = $value->CustomerID;
                        $row['NAME CUSTOMER'] = $value->user_username;
                        $row['EMAIL'] = $value->user_email;
                        $row['MOBILE'] = $value->user_mobile;
                        $row['STATE'] = $value->state;
                        $row['PAN NUMBER'] = @$panCard->pan_number;
                        $row['TEAM NAME'] = $value->teamname;
                        //$row['AddFUND'] = $value->deposit_amount;
                        $row['AddFUND'] = $value->totaldeposite;
                        //	$row['GST AMOUNT'] = $value->gst_amount;
                        $row['GST AMOUNT'] = $value->totalgstamount;
                        $row['WALLET AMOUNT'] = $value->wallet_amount;
                        ///	$row['INTEGRATED TAX'] = $value->igst;
                        //	$row['STATE TAX'] = $value->sgst;
                        //	$row['CENTRAL TAX'] = $value->cgst;
                        //	$row['TOTAL TAX'] = round(($value->cgst+$value->sgst+$value->igst),2);
                        $row['TRANSACTION BY'] = $value->transaction_by;
                        $row['TRANSACTION DATE'] = date('d-m-Y h:i a', strtotime($value->InvoiceDate));
                        $row['TOTAL TAX'] = round(($value->sgst + $value->igst), 2);
                        fputcsv($fp, $row);
                    }
                }
                ob_flush();
                flush();
            }

            ob_end_clean();
            exit();
        }
        //end gst report download for excel

        if ($request->isMethod('post') && !empty($start_date) && !empty($end_date)) {

            $columns = [
                0 => "gt.id",
                1 => "gt.user_id",
                2 => "r1.email",
                3 => "r1.mobile",
                4 => "r1.state",
                5 => "r1.mobile",
                6 => "r1.team",
                7 => "gt.deposit_amount",
                8 => "gt.gst_amount",
                9 => "gt.wallet_amount",
                10 => "gt.igst",
                11 => "gt.sgst",
                12 => "gt.cgst",
                13 => "gt.transactions_date",
                14 => "t.transaction_by",
            ];

            $limit = $request->input('length');
            $start = $request->input('start');
            $order = $columns[@$request->input('order.0.column')];
            $dir = $request->input('order.0.dir');
            $query = DB::table('deposit_gst as gt')
                ->where(function ($q) use ($formData) {
                    if (@$formData['transaction_by'] != "") {
                        $q->where('gt.transaction_by', $formData['transaction_by']);
                    }
                })
                ->where(function ($q) use ($start_date, $end_date) {
                    if (@$start_date) {
                        $q->whereBetween('gt.transactions_date', [$start_date, $end_date]);
                    }
                })

                ->groupby('user_id')->get();
            $totalTitles = $query->count();
            $totalFiltered = $totalTitles;
            $query = DB::table('deposit_gst as gt')
                ->Join('registerusers as r1', 'r1.id', '=', 'gt.user_id')
                //	->Join('transactions as t', 't.userid', '=', 'gt.user_id')
                ->where(function ($q) use ($formData) {
                    if (@$formData['transaction_by'] != "") {
                        $q->where('gt.transaction_by', $formData['transaction_by']);
                    }
                })

                ->whereBetween('gt.transactions_date', [$start_date, $end_date]);
            //->where('t.paymentstatus','confirmed')
            //	->where('t.type','Add Fund');

            $titles = $query

                ->offset($start)->limit($limit)
                ->select('gt.id as invoiceno', 'gt.user_id as CustomerID', 'gt.transactions_date as InvoiceDate', 'gt.deposit_amount', 'gt.gst_amount', 'gt.wallet_amount', 'gt.igst', 'gt.cgst', 'gt.sgst', 'gt.transaction_id', 'r1.username as user_username', 'r1.email as user_email', 'r1.mobile as user_mobile', 'r1.team as teamname', 'gt.transaction_by', 'r1.state', 'gt.ip', DB::raw('SUM(deposit_amount) as totaldeposite'), DB::raw('SUM(gst_amount) as totalgstamount'))
                //	->groupBY('gt.transaction_id')
                ->groupBY('gt.user_id')
                ->orderBy($order, $dir)->get();
            //echo '<pre>'; print_r(	$titles );exit;

            $data = [];
            if (!empty($titles)) {
                $s_no = $start + 1;
                foreach ($titles as $title) {
                    $panCard = DB::table('pancard')
                        ->where('pancard.userid', $title->CustomerID)
                        ->select('pan_number')->first();
                    $nestedData['s_no'] = $s_no;
                    $nestedData['invoiceno'] = $title->invoiceno;
                    $nestedData['InvoiceDate'] = $title->InvoiceDate;
                    $nestedData['CustomerID'] = $title->CustomerID;
                    $nestedData['email'] = $title->user_email;
                    $nestedData['user_username'] = $title->user_username;
                    $nestedData['mobile'] = $title->user_mobile;
                    $nestedData['state'] = $title->state;
                    $nestedData['pan_number'] = @$panCard->pan_number;
                    $nestedData['teamname'] = $title->teamname;
                    //	$nestedData['deposit_amount'] = $title->deposit_amount;
                    $nestedData['deposit_amount'] = $title->totaldeposite;
                    //	$nestedData['gst_amount'] = $title->gst_amount;
                    $nestedData['gst_amount'] = $title->totalgstamount;
                    $nestedData['wallet_amount'] = $title->wallet_amount;
                    // $nestedData['igst'] = $title->igst;
                    // $nestedData['sgst'] = $title->sgst;
                    // $nestedData['cgst'] = $title->cgst;
                    $nestedData['total_tax'] = round(($title->igst + $title->sgst), 2);
                    // $nestedData['total_tax'] = round(($title->igst+$title->sgst+$title->cgst),2);
                    $nestedData['transaction_by'] = $title->transaction_by;
                    $nestedData['ip_address'] = @$title->ip;


                    $data[] = $nestedData;
                    $s_no++;
                }
            }
            $json_data = array(
                "draw" => intval($request->input('draw')),
                "recordsTotal" => intval($totalTitles),
                "recordsFiltered" => intval($totalFiltered),
                "data" => $data,
            );
            echo json_encode($json_data);
            die();
        }

        $totalTax = DB::table('deposit_gst as gt')
            //	->Join('transactions as t', 't.userid', '=', 'gt.user_id')
            ->where(function ($q) use ($formData) {
                if (@$formData['transaction_by'] != "") {
                    $q->where('gt.transaction_by', $formData['transaction_by']);
                }
            })
            //->where('t.paymentstatus','confirmed')
            //	->where('t.type','Add Fund')
            ->whereBetween('gt.transactions_date', [$start_date, $end_date])
            ->selectRaw('ROUND(SUM(gt.igst),2) as igst, ROUND(SUM(gt.cgst),2) as cgst, ROUND(SUM(gt.sgst),2) as sgst')
            ->first();
        //print_r(	$totalTax);exit;
        return view("admin.$this->model.gst_deposit", compact('totalTax', 'sport_type_arr'));
    }

    public function profitloss_old()
    {
        $formData = Input::all();
        if (isset($formData) && !empty($formData)) {
            //Get Start Data
            $start_date = date('Y-m-d H:i:s', strtotime('+10 minutes', strtotime($formData['start_date'])));
            //Get End Date
            $end_date = $formData['end_date'];
            //Get Match  Key
            $matchkey = $formData['matchkey'];

            return Datatables::of(DB::table('joinedleauges as jol')
                ->whereDate('jol.created_at', '>=', date('Y-m-d h:i:s', strtotime($start_date)))
                ->whereDate('jol.created_at', '<=', date('Y-m-d h:i:s', strtotime($end_date)))
                ->where('jol.matchkey', $matchkey)
                ->where(function ($query) {
                    $query->where('listmatches.launch_status', 'launched')
                        ->where('listmatches.final_status', 'winnerdeclared');
                })->where(function ($query) {
                    $query->where('matchchallenges.maximum_user', '=', DB::raw('matchchallenges.joinedusers'))
                        ->orWhere('matchchallenges.confirmed_challenge', 1);
                })->where('listmatches.final_status', 'winnerdeclared')
                ->where(function ($query) {
                    $query->where('matchchallenges.maximum_user', '=', DB::raw('matchchallenges.joinedusers'))
                        ->orWhere('matchchallenges.confirmed_challenge', 1);
                })->where('matchchallenges.win_amount', '!=', 0)
                ->join('matchchallenges', 'matchchallenges.id', '=', 'jol.challengeid')
                ->join('listmatches', 'listmatches.matchkey', '=', 'jol.matchkey')
                ->orderBY('jol.id', 'DESC')
                ->select('jol.matchkey', 'jol.challengeid', 'matchchallenges.joinedusers', 'matchchallenges.win_amount')
                ->groupBy('jol.challengeid')
                ->leftJoin('leaugestransactions as lt', 'lt.challengeid', '=', 'jol.challengeid')
                ->selectRaw('sum(lt.bonus) as totalbonus')
                ->selectRaw('sum(lt.winning) as totalwining')
                ->selectRaw('sum(lt.balance) as totalbalance')->limit(1000)->get())
                ->addIndexColumn()
                ->addColumn('totbal', function ($result) {
                    return $totbal = $result->totalbalance + $result->totalwining + $result->totalbonus;
                })->addColumn('age', function ($result) {
                    if ($totbal - $result->win_amount > 0) {
                        $a = round((($totbal - $result->win_amount) / $totbal) * 100, 2);
                    } else {
                        $a = 0;
                    }
                    return $a . '%';
                })->addColumn('bonus', function ($result) {
                    if ($result->totalbonus > 0) {
                        $b = round(($result->totalbonus / $totbal) * 100, 2);
                    } else {
                        $b = 0;
                    }
                    return $b . '%';
                })->addColumn('paid_by', function ($result) {
                    $c = round((($b - $a) * $totbal) / 100, 2);
                    return $c;
                    $totalpaid += $c;
                })
                ->escapeColumns([])
                ->make(true);
        } //end
        return view("admin.$this->model.profitloss");
    }


    public function totalProfitLoss_olddd()
    {
        $formData = Input::all();
        if (isset($formData) && !empty($formData)) {
            // $matchkey=$formData['matchkey'];
            //$totalamount = 0;
            $AllMatch = DB::table('listmatches')->select('matchkey')->get();
            $i = 0;
            $All = array();
            foreach ($AllMatch as $a) {
                $All[$i] = $a->matchkey;
                $i++;
            }
            //  		echo '<pre/>';
            // print_r($All);die;
            $totalamount = DB::table('finalresults')->whereIn('matchkey', $All)->sum('amount');
            // print_r($totalamount);die;

            if (empty($totalamount))
                $totalamount = 0;

            return Datatables::of(DB::table('leaugestransactions as lt')
                ->whereIn('lt.matchkey', $All)
                ->select('lt.matchkey')
                ->selectRaw('sum(lt.bonus) as bonus')
                ->selectRaw('sum(lt.winning) as winning')
                ->selectRaw('sum(lt.balance) as balance')
                ->selectRaw("$totalamount as amount")
                ->get())
                ->addIndexColumn()
                ->addColumn('balance', function ($result) {
                    return round($result->balance, 2);
                })
                ->addColumn('winning', function ($result) {
                    return round($result->winning, 2);
                })
                ->addColumn('bonus', function ($result) {
                    return round($result->bonus, 2);
                })
                ->addColumn('amount', function ($result) {
                    return round($result->amount, 2);
                })
                ->addColumn('totalwinning', function ($result) {
                    return round(($result->balance + $result->winning), 2);
                })
                ->addColumn('totaldistributed', function ($result) {
                    return round(($result->bonus + $result->amount), 2);
                })->addColumn('profit', function ($result) {
                    $profit = (($result->balance + $result->winning) - ($result->bonus + $result->amount));
                    $loss = (($result->bonus + $result->amount) - ($result->balance + $result->winning));


                    if ($loss < 0) {
                        return 0;
                    } else {
                        if ($profit > 0)
                            return  round($profit, 2);
                        else
                            return 0;
                    }
                })->addColumn('loss', function ($result) {
                    $loss = (($result->bonus + $result->amount) - ($result->balance + $result->winning));

                    if ($loss < 0)
                        return round($loss, 2);
                    else
                        return 0;
                })
                ->escapeColumns([])
                ->make(true);
        } //end

        // print_r($totalamount);die;
        ### Breadcrumb Start ###
        return view("admin.$this->model.profitloss", compact('allSeries'));
    }

    public function totalProfitLoss()
    {
        $formData = Input::all();
        if (isset($formData) && !empty($formData)) {
            $AllMatch = DB::table('listmatches')
                ->join('finalresults', 'finalresults.matchkey', '=', 'listmatches.matchkey')
                ->select('listmatches.matchkey')->groupBy('finalresults.matchkey')->get();
            $i = 0;
            $All = array();
            foreach ($AllMatch as $a) {
                $All[$i] = $a->matchkey;
                $i++;
            }
            $totalamount = DB::table('finalresults')->whereIn('matchkey', $All)->sum('amount');

            if (empty($totalamount))
                $totalamount = 0;

            return Datatables::of(DB::table('leaugestransactions as lt')
                ->join('matchchallenges as mc', function ($join) {
                    $join->on('mc.id', '=', 'lt.challengeid')
                        ->where('mc.status', '!=', 'canceled');
                })
                ->whereIn('lt.matchkey', $All)
                ->select('lt.matchkey')
                ->selectRaw('sum(lt.bonus) as bonus')
                ->selectRaw('sum(lt.winning) as winning')
                ->selectRaw('sum(lt.balance) as balance')
                ->selectRaw("$totalamount as amount")
                ->get())
                ->addIndexColumn()
                ->addColumn('balance', function ($result) {
                    return round($result->balance, 2);
                })
                ->addColumn('winning', function ($result) {
                    return round($result->winning, 2);
                })
                ->addColumn('bonus', function ($result) {
                    return round($result->bonus, 2);
                })
                ->addColumn('amount', function ($result) {
                    return round($result->amount, 2);
                })
                ->addColumn('totalwinning', function ($result) {
                    return round(($result->amount), 2);
                })
                ->addColumn('totaldistributed', function ($result) {
                    return round(($result->bonus + $result->amount), 2);
                })
                ->addColumn('profit', function ($result) {
                    $profit = (($result->balance + $result->winning) - ($result->bonus + $result->amount));
                    if ($profit > 0)
                        return  round($profit, 2);
                    else
                        return 0;
                })->addColumn('loss', function ($result) {
                    $loss = (($result->bonus + $result->amount) - ($result->balance + $result->winning));
                    if ($loss > 0)
                        return round($loss, 2);
                    else
                        return 0;
                })
                ->escapeColumns([])
                ->make(true);
        } //end
        return view("admin.$this->model.profitloss", compact('allSeries'));
    }



    public function profitloss()
    {
        $allSeries = DB::table('series as s')
            ->where('series_status', 'opened')
            ->select('s.name as series_name', 's.id as series_id')
            ->orderBY('s.id', 'DESC')
            ->groupBY('s.id')->get();

        $formData = Input::all();
        if (isset($formData) && !empty($formData)) {
            $matchkey = $formData['matchkey'];
            //$totalamount = 0;
            $totalamount = DB::table('finalresults')->where('matchkey', $matchkey)->sum('amount');
            if (empty($totalamount))
                $totalamount = 0;

            return Datatables::of(DB::table('leaugestransactions as lt')
                ->leftJoin('refunds', function ($join) {
                    // $join->on('refunds.userid', '!=', 'lt.user_id');
                    $join->on('refunds.joinid', '=', 'lt.joinid');
                })
                ->whereNull('refunds.joinid')
                ->where('lt.matchkey', $matchkey)
                ->select('lt.matchkey')
                ->selectRaw('sum(lt.bonus) as bonus')
                ->selectRaw('sum(lt.winning) as winning')
                ->selectRaw('sum(lt.balance) as balance')
                ->selectRaw("$totalamount as amount")
                ->get())
                ->addIndexColumn()
                ->addColumn('balance', function ($result) {
                    return round($result->balance, 2);
                })
                ->addColumn('winning', function ($result) {
                    return round($result->winning, 2);
                })
                ->addColumn('bonus', function ($result) {
                    return round($result->bonus, 2);
                })
                ->addColumn('amount', function ($result) {
                    return round($result->amount, 2);
                })
                ->addColumn('totalwinning', function ($result) {
                    return round(($result->balance + $result->winning), 2);
                })
                ->addColumn('totaldistributed', function ($result) {
                    return round(($result->bonus + $result->amount), 2);
                })
                ->addColumn('profit', function ($result) {
                    $profit = (($result->balance + $result->winning) - ($result->bonus + $result->amount));
                    if ($profit > 0)
                        return  round($profit, 2);
                    else
                        return 0;
                })->addColumn('loss', function ($result) {
                    $loss = (($result->bonus + $result->amount) - ($result->balance + $result->winning));
                    if ($loss > 0)
                        return round($loss, 2);
                    else
                        return 0;
                })
                ->escapeColumns([])
                ->make(true);
        } //end
        return view("admin.$this->model.profitloss", compact('allSeries'));
    }

    public function winningreport()
    {
        $query = DB::table('finalresults');
        $getdata = array();
        if (isset($_GET['start_date'])) {
            $start_date = $_GET['start_date'];
            $start_date = date('Y-m-d H:i:s', strtotime('+10 minutes', strtotime($_GET['start_date'])));
            if ($start_date != "") {
                $query->whereDate('finalresults.created', '>=', date('Y-m-d h:i:s', strtotime($start_date)));
            }
        }
        if (isset($_GET['end_date'])) {
            $end_date = $_GET['end_date'];
            if ($end_date != "") {
                $query->whereDate('finalresults.created', '<=', date('Y-m-d h:i:s', strtotime($end_date)));
            }
        }
        if (isset($_GET['team'])) {
            $team = $_GET['team'];
            if ($team != "") {
                $query->where('registerusers.team', 'like', '%' . $team . '%');
            }
        }
        if (isset($_GET['start_date']) || isset($_GET['end_date']) || isset($_GET['team'])) {
            $getdata =     $query->join('registerusers', 'registerusers.id', '=', 'finalresults.userid')->select('finalresults.userid', 'finalresults.amount as win_amt', 'registerusers.team', 'registerusers.id')->where('finalresults.amount', '>', 0)->get();
        }
        return view('analytics.winningreport', compact('getdata'));
    }

    public function downloadgstreport()
    {

        $output1 = "";
        $output1 .= '"Challange Id",';
        $output1 .= '"IsMarthon",';
        $output1 .= '"Match Key",';
        $output1 .= '"Match Status",';
        $output1 .= '"Max Allowed Users",';
        $output1 .= '"Joined Users",';
        $output1 .= '"User ID",';
        $output1 .= '"Entry Fee",';
        $output1 .= '"Win Amount",';
        $output1 .= '"Date",';
        $output1 .= '"Invoice No",';
        $output1 .= '"Pool Prize",';
        $output1 .= '"Plate Form Fee",';
        $output1 .= '"iGST",';
        $output1 .= '"CGST",';
        $output1 .= '"SGST",';
        $output1 .= '"Margin %",';
        $output1 .= '"User State",';
        $output1 .= "\n";
        $query = DB::table('transactions');
        $getlist = array();
        $query->where('transactions.challengeid', '<>', 0);
        if (isset($_GET['start_date'])) {
            $start_date = $_GET['start_date'];
            $start_date = date('Y-m-d H:i:s', strtotime('-1 day', strtotime($_GET['start_date'])));
            if ($start_date != "") {
                $query->whereDate('transactions.created', '>=', date('Y-m-d h:i:s', strtotime($start_date)));
            }
        }
        if (isset($_GET['end_date'])) {
            $end_date = $_GET['end_date'];
            if ($end_date != "") {
                $query->whereDate('transactions.created', '<=', date('Y-m-d h:i:s', strtotime($end_date)));
            }
        }
        if (isset($_GET['start_date']) || isset($_GET['end_date'])) {
            $getlist = $query->where(function ($query) {
                $query->where('listmatches.launch_status', 'launched')->where('listmatches.final_status', 'winnerdeclared');
            })->where(function ($query) {
                $query->where('matchchallenges.maximum_user', '=', DB::raw('matchchallenges.joinedusers'))->orWhere('matchchallenges.confirmed_challenge', 1);
            })->where('matchchallenges.win_amount', '!=', 0)->join('matchchallenges', 'matchchallenges.id', '=', 'transactions.challengeid')->join('listmatches', 'listmatches.matchkey', '=', 'matchchallenges.matchkey')->join('registerusers', 'registerusers.id', '=', 'transactions.userid')->orderBY('transactions.id', 'DESC')->select('transactions.challengeid', 'matchchallenges.matchkey', 'listmatches.final_status', 'matchchallenges.joinedusers', 'matchchallenges.maximum_user', 'matchchallenges.marathon', 'transactions.userid as userid', 'matchchallenges.entryfee', 'matchchallenges.win_amount', 'transactions.created as joineddate', 'transactions.transaction_id', 'registerusers.state')->get();
        }
        if (!empty($getlist)) {
            $totalbonusget = 0;
            $totalbalanceget = 0;
            $totalwiningget = 0;
            $totaligst = 0;
            $totalcgst = 0;
            $totalsgst = 0;
            foreach ($getlist as $fmatch) {

                $poolprize = 0;
                $platformfee = 0;
                $poolprize = $fmatch->win_amount / $fmatch->joinedusers;
                $platformfee = round((($fmatch->entryfee - $poolprize) / 1.18), 2);
                if ($platformfee <= 0) {
                    continue;
                }
                $output1 .= '"' . ucwords($fmatch->challengeid) . '",';
                $output1 .= '"' . ucwords($fmatch->marathon) . '",';
                $output1 .= '"' . ucwords($fmatch->matchkey) . '",';
                $output1 .= '"' . ucwords($fmatch->final_status) . '",';
                $output1 .= '"' . ucwords($fmatch->maximum_user) . '",';
                $output1 .= '"' . ucwords($fmatch->joinedusers) . '",';
                $output1 .= '"' . ucwords($fmatch->userid) . '",';
                $output1 .= '"' . ucwords($fmatch->entryfee) . '",';
                $output1 .= '"' . ucwords($fmatch->win_amount) . '",';
                $output1 .= '"' . $fmatch->joineddate . '",';
                $output1 .= '"' . $fmatch->transaction_id . '",';
                $igst = 0;
                $cgst = 0;
                $sgst = 0;
                if ($fmatch->state != 'madhya pradesh' && $fmatch->state != 'Madhya Pradesh') {
                    $igst = ($platformfee * 18) / 100;
                    if ($igst < 0) {
                        $igst = 0;
                    }
                    $igst =  round($igst, 2);
                    $totaligst = $totaligst + $igst;
                }
                if ($fmatch->state == 'madhya pradesh' || $fmatch->state == 'Madhya Pradesh') {
                    $cgst = ($platformfee * 9) / 100;
                    if ($cgst < 0) {
                        $cgst = 0;
                    }
                    $cgst =  round($cgst, 2);
                    $totalcgst = $totalcgst + $cgst;
                }
                if ($fmatch->state == 'madhya pradesh' || $fmatch->state == 'Madhya Pradesh') {
                    $sgst = ($platformfee * 9) / 100;
                    if ($sgst < 0) {
                        $sgst = 0;
                    }
                    $sgst =  round($sgst, 2);
                    $totalsgst = $totalsgst + $sgst;
                }
                $output1 .= '"' . $poolprize . '",';
                $output1 .= '"' . $platformfee . '",';
                $output1 .= '"' . $igst . '",';
                $output1 .= '"' . $cgst . '",';
                $output1 .= '"' . $sgst . '",';
                $output1 .= '"' . round(($platformfee / $poolprize) * 100, 2) . '%' . '",';
                $output1 .= '"' . $fmatch->state . '",';
                $output1 .= "\n";
            }
        }
        $filename =  "gst-report.csv";
        header('Content-type: application/csv');
        header('Content-Disposition: attachment; filename=' . $filename);
        echo $output1;
        exit;
    }

    public function getAllSeriesMatches(Request $request)
    {
        $formData = $request->all();
        $seriesId = $formData['seriesId'];
        // print_r(unserialize(base64_decode($seriesId)));
        if ($seriesId) {
            $findAllMatch = DB::table('listmatches')
                ->where('listmatches.series', unserialize(base64_decode($seriesId)))
                ->where('listmatches.launch_status', 'launched')
                ->where('listmatches.final_status', 'winnerdeclared')
                ->select('listmatches.matchkey', 'listmatches.name')
                ->get();
            $res = array('status' => 500, 'message' => 'Please select match.', 'AllMatch' => $findAllMatch);
            echo json_encode($res);
            die();
        } else {
            $res = array('status' => 500, 'message' => 'Please select match.');
            echo json_encode($res);
            die();
        }
    }


    //GST By deposit

    public function gstreportnewdeposit(Request $request)
    {

        date_default_timezone_set("Asia/Kolkata");
        $formData = $request->all();
        $sport_types_q = DB::table('sport_types')->where('status', 1)->get();
        $sport_type_arr = [];
        foreach ($sport_types_q as $key => $value) {
            $sport_type_arr[$value->id] = $value->sport_key;
        }

        // $start_date = @$_GET['start_date'] != "" ? date('Y-m-d 00:00:00', strtotime($formData['start_date'])) : date("Y-m-01 00:00:00");
        // $end_date = @$_GET['end_date'] != "" ? date('Y-m-d 23:59:59', strtotime($formData['end_date'])) : date("Y-m-t 23:59:59");
        $start_date = @$_GET['start_date'] != "" ? date('Y-m-d 00:00:00', strtotime($formData['start_date'])) : '';
        $end_date = @$_GET['end_date'] != "" ? date('Y-m-d 23:59:59', strtotime($formData['end_date'])) : '';

        //for gstreport download in excel
        //	if(!empty($start_date) && !empty($end_date) && @$formData['download'] != "")
        if (@$formData['download'] != "") {

            // exit();
            ini_set('memory_limit', '-1');

            $fileName = 'gst-report-' . date("YmdHis", time());
            header('Content-Encoding: UTF-8');
            header("Content-type:application/vnd.ms-excel;charset=UTF-8");
            header('Content-Disposition: attachment;filename="' . $fileName . '.csv"');

            $tableheader = array(
                'A' => 'CUSTOMER ID',
                'B' => 'STATE OF CUSTOMER',
                'C' => 'REFERER EMAIL',
                'D' => 'REFERER NAME',
                'E' => 'REFERER COMISSSION',
                'F' => 'MATCH TITLE',
                'G' => 'CONTEST FEES',
                'H' => 'TOTAL PLATFORM FEES',
                'I' => 'BEFORE TAX PLATFORM FEES',
                //	'J' => 'INTEGRATED TAX',
                //	'K' => 'STATE TAX',
                //'L' => 'CENTRAL TAX',
                'M' => 'TOTAL TAX',
                'N' => 'TRANSACTION DATE',
                'O' => 'TRANSACTION BY',
            );


            $fp = fopen('php://output', 'a');
            fputcsv($fp, $tableheader);

            $datacount = DB::table('deposit_gst as gt')
                ->Join('registerusers as r1', 'r1.id', '=', 'gt.user_id')
                //	->leftJoin('transactions as t', 't.userid', '=', 'gt.user_id')
                ->where(function ($q) use ($formData) {
                    if (@$formData['transaction_by'] != "") {
                        $q->where('gt.transaction_by', $formData['transaction_by']);
                    }
                })
                ->where(function ($q) use ($formData) {
                    if (@$formData['mobile'] != "") {
                        $q->where('r1.mobile', $formData['mobile']);
                    }
                })
                ->where(function ($q) use ($formData) {
                    if (@$formData['email'] != "") {
                        $q->where('r1.email', $formData['email']);
                    }
                })

                ->where(function ($q) use ($start_date, $end_date) {
                    if (@$start_date != "" &&  @$end_date != "") {
                        $q->whereBetween('gt.transactions_date', [$start_date, $end_date]);
                    }
                })
                //	->whereBetween('gt.transactions_date', [$start_date, $end_date])
                ->count();

            //	 echo $datacount;die();

            $loopcount = ceil($datacount / 10000);

            for ($i = 0; $i < $loopcount; $i++) {
                $query = DB::table('deposit_gst as gt')
                    ->Join('registerusers as r1', 'r1.id', '=', 'gt.user_id')
                    //	->Join('transactions as t', 't.userid', '=', 'gt.user_id')
                    //	->where('t.type','Add Fund')
                    //	->where('t.paymentstatus','confirmed')
                    ->where(function ($q) use ($formData) {
                        if (@$formData['transaction_by'] != "") {
                            $q->where('gt.transaction_by', $formData['transaction_by']);
                        }
                    })
                    ->where(function ($q) use ($formData) {
                        if (@$formData['mobile'] != "") {
                            $q->where('r1.mobile', $formData['mobile']);
                        }
                    })
                    ->where(function ($q) use ($formData) {
                        if (@$formData['email'] != "") {
                            $q->where('r1.email', $formData['email']);
                        }
                    })
                    ->where(function ($q) use ($start_date, $end_date) {
                        if (@$start_date != "" &&  @$end_date != "") {
                            $q->whereBetween('gt.transactions_date', [$start_date, $end_date]);
                        }
                    })
                    //	->whereBetween('gt.transactions_date', [$start_date, $end_date])
                    //	->whereBetween('gt.transactions_date', [$start_date, $end_date])
                    ->select('gt.id as invoiceno', 'gt.user_id as CustomerID', 'gt.transactions_date as InvoiceDate', 'gt.deposit_amount', 'gt.gst_amount', 'gt.wallet_amount', 'gt.igst', 'gt.cgst', 'gt.sgst', 'r1.username as user_username', 'r1.email as user_email', 'r1.mobile as user_mobile', 'r1.team as teamname', 'gt.transaction_by')
                    ->orderBy('gt.id', 'DESC')
                    ->offset($i * 10000)->limit(10000)
                    ->get();

                if (!$query->isEmpty()) {
                    foreach ($query as $key => $value) {

                        $row = [];
                        $row['INVOICE NO'] = $value->invoiceno;
                        $row['CUSTOMER ID'] = $value->CustomerID;
                        $row['USER NAME'] = $value->user_username;
                        $row['USER EMAIL'] = $value->user_email;
                        $row['USER MOBILE'] = $value->user_mobile;
                        $row['TEAM NAME'] = $value->teamname;
                        $row['AddFUND'] = $value->deposit_amount;
                        $row['GST AMOUNT'] = $value->gst_amount;
                        $row['REAL CASH'] = $value->wallet_amount;
                        //	$row['INTEGRATED TAX'] = $value->igst;
                        //	$row['STATE TAX'] = $value->sgst;
                        //	$row['CENTRAL TAX'] = $value->cgst;
                        //	$row['TOTAL TAX'] = round(($value->cgst+$value->sgst+$value->igst),2);
                        $row['TOTAL TAX'] = round((+$value->sgst), 2);
                        $row['TRANSACTION DATE'] = date('d-m-Y h:i a', strtotime($value->InvoiceDate));
                        $row['TRANSACTION TYPE'] = $value->transaction_by;

                        fputcsv($fp, $row);
                    }
                }
                ob_flush();
                flush();
            }

            ob_end_clean();
            exit();
        }
        //end gst report download for excel

        //if($request->isMethod('post') && !empty($start_date) && !empty($end_date)) {
        if ($request->isMethod('post')) {

            $columns = array(
                0 =>     "gt.id",
                1 =>     "gt.user_id",
                2 =>     "r1.email",
                3 =>     "r1.mobile",
                4 =>     "r1.team",
                5 =>     "gt.deposit_amount",
                6 =>     "gt.gst_amount",
                7 =>     "gt.wallet_amount",
                8 =>     "gt.igst",
                9 =>     "gt.sgst",
                10 =>    "gt.cgst",
                11 =>    "gt.transactions_date",
                12 =>    "t.transaction_by",
            );

            $limit = $request->input('length');
            $start = $request->input('start');
            $order = $columns[@$request->input('order.0.column')];
            $dir = $request->input('order.0.dir');
            $query = DB::table('deposit_gst as gt')
                ->Join('registerusers as r1', 'r1.id', '=', 'gt.user_id')
                //	->Join('transactions as t', 't.userid', '=', 'gt.user_id')
                ->where(function ($q) use ($formData) {
                    if (@$formData['transaction_by'] != "") {
                        $q->where('gt.transaction_by', $formData['transaction_by']);
                    }
                })
                ->where(function ($q) use ($formData) {

                    if (@$formData['mobile'] != "") {
                        $q->where('r1.mobile', $formData['mobile']);
                    }
                })
                ->where(function ($q) use ($formData) {

                    if (@$formData['email'] != "") {
                        $q->where('r1.email', $formData['email']);
                    }
                });
            if (!empty($start_date) && !empty($end_date)) {
                $query->whereBetween('gt.transactions_date', [$start_date, $end_date]);
            }
            $query = $query->get();
            // 	$query = DB::table('deposit_gst as gt')->get();
            $totalTitles = $query->count();

            $totalFiltered = $totalTitles;
            $query = DB::table('deposit_gst as gt')
                ->Join('registerusers as r1', 'r1.id', '=', 'gt.user_id')
                //	->Join('transactions as t', 't.userid', '=', 'gt.user_id')
                ->where(function ($q) use ($formData) {
                    if (@$formData['transaction_by'] != "") {
                        $q->where('gt.transaction_by', $formData['transaction_by']);
                    }
                })
                ->where(function ($q) use ($formData) {

                    if (@$formData['mobile'] != "") {
                        $q->where('r1.mobile', $formData['mobile']);
                    }
                })
                ->where(function ($q) use ($formData) {

                    if (@$formData['email'] != "") {
                        $q->where('r1.email', $formData['email']);
                    }
                });
            if (!empty($start_date) && !empty($end_date)) {
                $query->whereBetween('gt.transactions_date', [$start_date, $end_date]);
            }

            //	$query->where('t.paymentstatus','confirmed')
            //	->where('t.type','Add Fund');

            $titles = $query

                ->offset($start)->limit($limit)
                ->select('gt.id as invoiceno', 'gt.user_id as CustomerID', 'gt.transactions_date as InvoiceDate', 'gt.deposit_amount', 'gt.gst_amount', 'gt.wallet_amount', 'gt.igst', 'gt.cgst', 'gt.sgst', 'gt.transaction_id', 'r1.username as user_username', 'r1.email as user_email', 'r1.mobile as user_mobile', 'r1.team as teamname', 'gt.transaction_by')
                ->groupBY('gt.transaction_id')
                ->orderBy($order, $dir)->get();
            //echo '<pre>'; print_r(	$titles );exit;

            $data = [];
            if (!empty($titles)) {
                $s_no = $start + 1;
                foreach ($titles as $title) {
                    $nestedData['s_no'] = $s_no;
                    $nestedData['invoiceno'] = $title->invoiceno;
                    $nestedData['InvoiceDate'] = $title->InvoiceDate;
                    $nestedData['CustomerID'] = $title->CustomerID;
                    $nestedData['email'] = $title->user_email;
                    $nestedData['user_username'] = $title->user_username;
                    $nestedData['mobile'] = $title->user_mobile;
                    $nestedData['teamname'] = $title->teamname;
                    $nestedData['deposit_amount'] = $title->deposit_amount;
                    $nestedData['gst_amount'] = $title->gst_amount;
                    $nestedData['wallet_amount'] = $title->wallet_amount;
                    // $nestedData['igst'] = $title->igst;
                    // $nestedData['sgst'] = $title->sgst;
                    // $nestedData['cgst'] = $title->cgst;
                    //	$nestedData['total_tax'] = round(($title->igst+$title->sgst+$title->cgst),2);
                    $nestedData['total_tax'] = round(($title->sgst), 2);
                    $nestedData['transaction_by'] = $title->transaction_by;

                    $data[] = $nestedData;
                    $s_no++;
                }
            }
            $json_data = array(
                //		"draw" => intval($request->input('draw')),
                "recordsTotal" => intval($totalTitles),
                "recordsFiltered" => intval($totalFiltered),
                "data" => $data,
            );
            echo json_encode($json_data);
            die();
        }

        $totalTax = DB::table('deposit_gst as gt')
            //	->Join('transactions as t', 't.userid', '=', 'gt.user_id')
            ->where(function ($q) use ($formData) {
                if (@$formData['transaction_by'] != "") {
                    $q->where('gt.transaction_by', $formData['transaction_by']);
                }
            })
            //->where('t.paymentstatus','confirmed')
            //	->where('t.type','Add Fund')
            ->whereBetween('gt.transactions_date', [$start_date, $end_date])
            ->selectRaw('ROUND(SUM(gt.igst),2) as igst, ROUND(SUM(gt.cgst),2) as cgst, ROUND(SUM(gt.sgst),2) as sgst')
            ->first();
        //print_r(	$totalTax);exit;
        $totalgstcount = DB::table('deposit_gst as gt')->sum('gst_amount');
        return view("admin.$this->model.gst_new_deposit", compact('totalTax', 'sport_type_arr', 'totalgstcount'));
    }

    //GST By TOTAL ADD deposit

    public function gstReportTotalAddCash(Request $request)
    {

        date_default_timezone_set("Asia/Kolkata");
        $formData = $request->all();
        $sport_types_q = DB::table('sport_types')->where('status', 1)->get();
        $sport_type_arr = [];
        foreach ($sport_types_q as $key => $value) {
            $sport_type_arr[$value->id] = $value->sport_key;
        }

        // $start_date = @$_GET['start_date'] != "" ? date('Y-m-d 00:00:00', strtotime($formData['start_date'])) : date("Y-m-01 00:00:00");
        // $end_date = @$_GET['end_date'] != "" ? date('Y-m-d 23:59:59', strtotime($formData['end_date'])) : date("Y-m-t 23:59:59");
        $start_date = @$_GET['start_date'] != "" ? date('Y-m-d 00:00:00', strtotime($formData['start_date'])) : '';
        $end_date = @$_GET['end_date'] != "" ? date('Y-m-d 23:59:59', strtotime($formData['end_date'])) : '';

        //for gstreport download in excel
        //	if(!empty($start_date) && !empty($end_date) && @$formData['download'] != "")
        if (@$formData['download'] != "") {

            // exit();
            ini_set('memory_limit', '-1');

            $fileName = 'gst-report-' . date("YmdHis", time());
            header('Content-Encoding: UTF-8');
            header("Content-type:application/vnd.ms-excel;charset=UTF-8");
            header('Content-Disposition: attachment;filename="' . $fileName . '.csv"');

            $tableheader = array(
                'A' => 'CUSTOMER ID',
                'B' => 'CUSTOMER NAME',
                'C' => 'EMAIL',
                'D' => 'MOBILE',
                'E' => 'STATE',
                'F' => 'PAN NUMBER',
                'G' => 'TOTAL DEPOSIT',
                'H' => 'TOTAL GST',
                'I' => 'ADD CASH STATE',
                //	'I' => 'BEFORE TAX PLATFORM FEES',
                //	'J' => 'INTEGRATED TAX',
                //	'K' => 'STATE TAX',
                //'L' => 'CENTRAL TAX',
                //	'M' => 'TOTAL TAX',
                //	'N' => 'TRANSACTION DATE',
                //	'O' => 'TRANSACTION BY',
            );


            $fp = fopen('php://output', 'a');
            fputcsv($fp, $tableheader);

            $datacount = DB::table('deposit_gst as gt')
                ->Join('registerusers as r1', 'r1.id', '=', 'gt.user_id')
                //	->leftJoin('transactions as t', 't.userid', '=', 'gt.user_id')
                ->where(function ($q) use ($formData) {
                    if (@$formData['transaction_by'] != "") {
                        $q->where('gt.transaction_by', $formData['transaction_by']);
                    }
                })
                ->where(function ($q) use ($formData) {
                    if (@$formData['mobile'] != "") {
                        $q->where('r1.mobile', $formData['mobile']);
                    }
                })
                ->where(function ($q) use ($formData) {
                    if (@$formData['email'] != "") {
                        $q->where('r1.email', $formData['email']);
                    }
                })

                ->where(function ($q) use ($start_date, $end_date) {
                    if (@$start_date != "" &&  @$end_date != "") {
                        $q->whereBetween('gt.transactions_date', [$start_date, $end_date]);
                    }
                })
                //	->whereBetween('gt.transactions_date', [$start_date, $end_date])
                ->groupBY('gt.user_id')
                ->count();

            //	 echo $datacount;die();

            $loopcount = ceil($datacount / 10000);

            for ($i = 0; $i < $loopcount; $i++) {
                $query = DB::table('deposit_gst as gt')
                    ->Join('registerusers as r1', 'r1.id', '=', 'gt.user_id')
                    //	->Join('transactions as t', 't.userid', '=', 'gt.user_id')
                    //	->where('t.type','Add Fund')
                    //	->where('t.paymentstatus','confirmed')
                    ->where(function ($q) use ($formData) {
                        if (@$formData['transaction_by'] != "") {
                            $q->where('gt.transaction_by', $formData['transaction_by']);
                        }
                    })
                    ->where(function ($q) use ($formData) {
                        if (@$formData['mobile'] != "") {
                            $q->where('r1.mobile', $formData['mobile']);
                        }
                    })
                    ->where(function ($q) use ($formData) {
                        if (@$formData['email'] != "") {
                            $q->where('r1.email', $formData['email']);
                        }
                    })
                    ->where(function ($q) use ($start_date, $end_date) {
                        if (@$start_date != "" &&  @$end_date != "") {
                            $q->whereBetween('gt.transactions_date', [$start_date, $end_date]);
                        }
                    })
                    //	->whereBetween('gt.transactions_date', [$start_date, $end_date])
                    //	->whereBetween('gt.transactions_date', [$start_date, $end_date])
                    ->select('gt.id as invoiceno', 'gt.user_id as CustomerID', 'gt.transactions_date as InvoiceDate', 'gt.deposit_amount', 'gt.gst_amount', 'gt.wallet_amount', 'gt.igst', 'gt.cgst', 'gt.sgst', 'r1.username as user_username', 'r1.email as user_email', 'r1.mobile as user_mobile', 'r1.team as teamname', 'gt.transaction_by', 'gt.state as add_cash_state', 'r1.state', DB::raw('SUM(deposit_amount) AS totalDeposite'), DB::raw('SUM(gst_amount) AS totalgst'))
                    ->orderBy('gt.id', 'DESC')
                    ->offset($i * 10000)
                    ->groupBY('gt.user_id')
                    ->limit(1000000)
                    ->get();

                if (!$query->isEmpty()) {
                    foreach ($query as $key => $value) {
                        $panCard = DB::table('pancard')
                            ->where('pancard.userid', $value->CustomerID)
                            ->select('pan_number')->first();
                        $row = [];
                        //	$row['INVOICE NO'] = $value->invoiceno;
                        //	$row['CUSTOMER ID'] = $value->CustomerID;
                        $row['USER NAME'] = $value->user_username;
                        $row['USER EMAIL'] = $value->user_email;
                        $row['USER MOBILE'] = $value->user_mobile;
                        $row['USER STATE'] = $value->state;
                        $row['USER PAN NUMBER'] = @$panCard->pan_number;
                        $row['TOTAL DEPOSITE'] = @$value->totalDeposite;
                        $row['TOTAL GST'] = @$value->totalgst;
                        $row['ADD CASH STATE'] = @$value->add_cash_state;
                        // $row['TEAM NAME'] = $value->teamname;
                        // $row['AddFUND'] = $value->deposit_amount;
                        // $row['GST AMOUNT'] = $value->gst_amount;
                        // $row['REAL CASH'] = $value->wallet_amount;
                        //	$row['INTEGRATED TAX'] = $value->igst;
                        //	$row['STATE TAX'] = $value->sgst;
                        //	$row['CENTRAL TAX'] = $value->cgst;
                        //	$row['TOTAL TAX'] = round(($value->cgst+$value->sgst+$value->igst),2);
                        // $row['TOTAL TAX'] = round((+$value->sgst),2);
                        // $row['TRANSACTION DATE'] = date('d-m-Y h:i a', strtotime($value->InvoiceDate));
                        // $row['TRANSACTION TYPE'] = $value->transaction_by;

                        fputcsv($fp, $row);
                    }
                }
                ob_flush();
                flush();
            }

            ob_end_clean();
            exit();
        }
        //end gst report download for excel

        //if($request->isMethod('post') && !empty($start_date) && !empty($end_date)) {
        if ($request->isMethod('post')) {

            $columns = array(
                0 =>     "gt.id",
                1 =>     "gt.user_id",
                2 =>     "r1.email",
                3 =>     "r1.mobile",
                4 =>     "r1.team",
                5 =>     "gt.deposit_amount",
                6 =>     "gt.gst_amount",
                7 =>     "gt.wallet_amount",
                8 =>     "gt.igst",
                9 =>     "gt.sgst",
                10 =>    "gt.cgst",
                11 =>    "gt.transactions_date",
                12 =>    "t.transaction_by",
            );

            $limit = $request->input('length');
            $start = $request->input('start');
            $order = $columns[@$request->input('order.0.column')];
            $dir = $request->input('order.0.dir');
            $query = DB::table('deposit_gst as gt')
                ->Join('registerusers as r1', 'r1.id', '=', 'gt.user_id')
                //	->Join('transactions as t', 't.userid', '=', 'gt.user_id')
                ->where(function ($q) use ($formData) {
                    if (@$formData['transaction_by'] != "") {
                        $q->where('gt.transaction_by', $formData['transaction_by']);
                    }
                })
                ->where(function ($q) use ($formData) {

                    if (@$formData['mobile'] != "") {
                        $q->where('r1.mobile', $formData['mobile']);
                    }
                })
                ->where(function ($q) use ($formData) {

                    if (@$formData['email'] != "") {
                        $q->where('r1.email', $formData['email']);
                    }
                });
            if (!empty($start_date) && !empty($end_date)) {
                $query->whereBetween('gt.transactions_date', [$start_date, $end_date]);
            }
            $query = $query->orderBy('gt.id', 'desc')
                ->groupBY('gt.user_id')
                ->get();
            // 	$query = DB::table('deposit_gst as gt')->get();
            $totalTitles = $query->count();

            $totalFiltered = $totalTitles;
            $query = DB::table('deposit_gst as gt')
                ->Join('registerusers as r1', 'r1.id', '=', 'gt.user_id')
                //	->Join('transactions as t', 't.userid', '=', 'gt.user_id')
                ->where(function ($q) use ($formData) {
                    if (@$formData['transaction_by'] != "") {
                        $q->where('gt.transaction_by', $formData['transaction_by']);
                    }
                })
                ->where(function ($q) use ($formData) {

                    if (@$formData['mobile'] != "") {
                        $q->where('r1.mobile', $formData['mobile']);
                    }
                })
                ->where(function ($q) use ($formData) {

                    if (@$formData['email'] != "") {
                        $q->where('r1.email', $formData['email']);
                    }
                });
            if (!empty($start_date) && !empty($end_date)) {
                $query->whereBetween('gt.transactions_date', [$start_date, $end_date]);
            }

            //	$query->where('t.paymentstatus','confirmed')
            //	->where('t.type','Add Fund');

            $titles = $query

                ->offset($start)->limit($limit)
                ->select('gt.id as invoiceno', 'gt.user_id as CustomerID', 'gt.transactions_date as InvoiceDate', 'gt.deposit_amount', 'gt.gst_amount', 'gt.wallet_amount', 'gt.igst', 'gt.cgst', 'gt.sgst', 'gt.transaction_id', 'r1.username as user_username', 'r1.email as user_email', 'r1.mobile as user_mobile', 'r1.team as teamname', 'gt.transaction_by', 'gt.state as add_cash_state', 'r1.state', DB::raw('SUM(deposit_amount) AS totalDeposite'), DB::raw('SUM(gst_amount) AS totalgst'))
                //	->groupBY('gt.transaction_id')
                ->groupBY('gt.user_id')
                ->orderBy('gt.id', 'desc')
                //->orderBy($order, $dir)
                ->get();
            //echo '<pre>'; print_r(	$titles );exit;

            $data = [];
            if (!empty($titles)) {
                $s_no = $start + 1;
                foreach ($titles as $title) {
                    $panCard = DB::table('pancard')
                        ->where('pancard.userid', $title->CustomerID)
                        ->select('pan_number')->first();
                    $nestedData['s_no'] = $s_no;
                    $nestedData['invoiceno'] = $title->invoiceno;
                    $nestedData['InvoiceDate'] = $title->InvoiceDate;
                    $nestedData['CustomerID'] = $title->CustomerID;
                    $nestedData['email'] = $title->user_email;
                    $nestedData['user_username'] = $title->user_username;
                    $nestedData['mobile'] = $title->user_mobile;
                    $nestedData['state'] = $title->state;
                    $nestedData['add_cash_state'] = $title->add_cash_state;
                    $nestedData['pan_number'] = @$panCard->pan_number;
                    $nestedData['teamname'] = $title->teamname;
                    $nestedData['deposit_amount'] = $title->deposit_amount;
                    $nestedData['gst_amount'] = $title->gst_amount;
                    $nestedData['wallet_amount'] = $title->wallet_amount;
                    $nestedData['total_deposite'] = $title->totalDeposite;
                    $nestedData['total_gst'] = $title->totalgst;
                    // $nestedData['igst'] = $title->igst;
                    // $nestedData['sgst'] = $title->sgst;
                    // $nestedData['cgst'] = $title->cgst;
                    //	$nestedData['total_tax'] = round(($title->igst+$title->sgst+$title->cgst),2);
                    $nestedData['total_tax'] = round(($title->sgst), 2);
                    $nestedData['transaction_by'] = $title->transaction_by;

                    $data[] = $nestedData;
                    $s_no++;
                }
            }
            $json_data = array(
                //		"draw" => intval($request->input('draw')),
                "recordsTotal" => intval($totalTitles),
                "recordsFiltered" => intval($totalFiltered),
                "data" => $data,
            );
            echo json_encode($json_data);
            die();
        }

        $totalTax = DB::table('deposit_gst as gt')
            //	->Join('transactions as t', 't.userid', '=', 'gt.user_id')
            ->where(function ($q) use ($formData) {
                if (@$formData['transaction_by'] != "") {
                    $q->where('gt.transaction_by', $formData['transaction_by']);
                }
            })
            //->where('t.paymentstatus','confirmed')
            //	->where('t.type','Add Fund')
            ->whereBetween('gt.transactions_date', [$start_date, $end_date])
            ->selectRaw('ROUND(SUM(gt.igst),2) as igst, ROUND(SUM(gt.cgst),2) as cgst, ROUND(SUM(gt.sgst),2) as sgst')
            ->first();
        //print_r(	$totalTax);exit;
        $totalgstcount = DB::table('deposit_gst as gt')->sum('deposit_amount');
        return view("admin.$this->model.gst_total_add_cash", compact('totalTax', 'sport_type_arr', 'totalgstcount'));
    }
    public function userTransactionsReconcilation(Request $request)
    {

        date_default_timezone_set("Asia/Kolkata");
        if ($request->isMethod('post')) {

            $request->validate([
                'email'           => 'required',
                'start_date'      => 'required|date',
                'end_date'        => 'required|date',
            ]);

            $email     = $request->email;
            $start     = $request->start_date;
            $end     = $request->end_date;

            $startDate         = \Carbon\Carbon::parse($request->start_date);
            $endDate         = \Carbon\Carbon::parse($request->end_date);

            $days             = $startDate->diffInDays($endDate);


            if ($startDate > $endDate) {
                return redirect()->route('Analytics.user_transactions_reconcilation')->with('success', 'start Date should be less than end date')->withInput();
            }
            if ($days > 30) {
                return redirect()->route('Analytics.user_transactions_reconcilation')->with('success', 'start Date and end Date difference not be greater than 1 month.')->withInput();
            }


            $query = DB::table('registerusers')->where('email', $request->email);

            $query->orWhere(function ($query) use ($request) {

                $query->where('mobile', '!=', 0);

                $query->where('mobile', $request->email);
            });

            $user = $query->first();

            if (empty($user)) {
                return redirect()->route('Analytics.user_transactions_reconcilation')->with('success', 'entered email/mobile not registered.')->withInput();
            }

            //if we found a user with entered email/mobile then get his/her primary key
            $userId     = $user->id;

            $endDate    = $request->end_date . " 23:59:59";
            // echo $endDate;die;

            $query = DB::table('transactions')
                ->where('userid', $userId)
                ->whereBetween('created', [$startDate, $endDate])
                ->where("paymentstatus", "confirmed")
                // ->Where("paymentstatus", "ACTIVE")
                ->select('type', DB::raw('SUM(amount) as amount'), 'transaction_by')
                ->groupBy('type')
                ->get();


            if (empty($query)) {
                return redirect()->route('Analytics.user_transactions_reconcilation')->with('success', 'No data found fot this user.')->withInput();
            }

            $closingBalance = 0;

            foreach ($query as $row) {

                if ($row->transaction_by == "wallet" || $row->transaction_by == "Wallet") {
                    $closingBalance -= round($row->amount, 2);
                } else {
                    $closingBalance += round($row->amount, 2);
                }
            }
            // dd($closingBalance);
            // echo $startDate;die;
            $openingBalance = DB::table('transactions')
                ->where('userid', $userId)
                ->where("paymentstatus", "confirmed")
                ->where('created', '<', $startDate)
                ->select('total_available_amt')
                ->orderBy('id', 'DESC')
                ->first();
            // ->toSql();


            $currentBalance = DB::table('transactions')
                ->where('userid', $userId)
                ->where('created', '<=', $endDate)
                ->where("paymentstatus", "confirmed")
                ->select('total_available_amt')
                ->orderBy('id', 'DESC')
                ->first();

            session()->flashInput($request->input());
            return view("admin.$this->model.userReportByMonth", compact('query', 'openingBalance', 'closingBalance', 'currentBalance'));
        }
        return view("admin.$this->model.userReportByMonth");
    }
}
