<?php
namespace App\Http\Controllers\Admin;

use App\Models\Block;
use App\Model\BlockDescription;
use App\Http\Controllers\BaseController;
use App\Services\Input;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\View;

/**
 * BlockController Controller
 *
 * Add your methods in the class below
 *
 * This file will render views from views/admin/Block
 */

class BlockController extends BaseController {

	public $model	=	'Block';

	public function __construct() {

		parent::__construct();
		View::share('modelName',$this->model);
	}

	/**
	 * Function for display all Block
	 */
	public function listBlock(){

		$DB				=	Block::query();
		$searchVariable	=	array();
		$inputGet		=	Input::get();
		$param 			= 	array();

		if(Input::get() && isset($inputGet['display'])|| isset($inputGet['page']) || isset($inputGet['records_per_page'])){
			$searchData	=	Input::get();
			unset($searchData['display']);
			unset($searchData['_token']);

			if(isset($searchData['page'])){
				unset($searchData['page']);
			}

			if(isset($searchData['sortBy'])){
				$param['sortBy'] = $searchData['sortBy'];
				unset($searchData['sortBy']);
			}
			if(isset($searchData['order'])){
				$param['order'] = $searchData['order'];
				unset($searchData['order']);
			}
			if(Input::get('records_per_page') !=null){
				$param['records_per_page'] = Input::get('records_per_page');
				unset($searchData['records_per_page']);
			}

			foreach($searchData as $fieldName => $fieldValue){
				if(!empty($fieldValue)){
					if($fieldName=='category_id'){
						$DB->where("category_id",$fieldValue);
					}else{
						$fieldValue	=	trim($fieldValue);
						$DB->where("$fieldName",'like','%'.$fieldValue.'%');
					}
					$searchVariable	=	array_merge($searchVariable,array($fieldName => $fieldValue));
				}
			}
		}

		foreach($param as $key => $value) {
			if (!empty($value)) {
				$searchVariable	=	array_merge($searchVariable,array($key => $value));
			}
		}

		$sortBy 		= (Input::get('sortBy')) ? Input::get('sortBy') : 'updated_at';
	    $order  		= (Input::get('order')) ? Input::get('order')   : 'DESC';

		$recordPerPage	=	(Input::get('records_per_page')!='') ? Input::get('records_per_page'):Config::get("Reading.records_per_page");

		$model 			= 	$DB->orderBy($sortBy, $order)->get();


		return  View::make("admin.$this->model.index",compact('breadcrumbs','model','searchVariable','sortBy','order'));

	}// end listBlock()

	 /**
	 * Function for display page  for add new Block
	 *
	 * @param null
	 *
	 * @return view page.
	 */

	public function addBlock(){

		### breadcrumbs Start ###
		// Breadcrums   is  added   here dynamically
		Breadcrumb::addBreadcrumb(trans("messages.global.breadcrumbs_dashboard"),route('admin_dashboard'));
		Breadcrumb::addBreadcrumb(trans("messages.$this->model.breadcrumbs_module"),route($this->model.'.index'));;
		Breadcrumb::addBreadcrumb(trans("messages.$this->model.breadcrumbs_add"),'');
		$breadcrumbs 	= 	Breadcrumb::generate();
		### breadcrumbs End ###

		//~ $languages	        =	Language::where('is_active','=',ACTIVE)->get(array('title','id'));
		//~ $language_code		=	Config::get('default_language.language_code');

		return  View::make("admin.$this->model.add",compact('languages' ,'language_code','breadcrumbs'));
	} //end addBlock()

	 /**
	 * Function for save added Block page
	 *
	 * @param null
	 *
	 * @return redirect page.
	 */


	function saveBlock(){

		$thisData				=	Input::all();
		$language_code			=	Config::get('default_language.language_code');
		$dafaultLanguageArray	=	$thisData['data'][$language_code];

		$validator = Validator::make(

			array(
				'page_name' 		=> Input::get('page_name'),
				'block_name' 		=> Input::get('block_name'),
				'short_name' 		=> $dafaultLanguageArray['short_name'],
				'description' 		=> $dafaultLanguageArray['description'],
			),
			array(
				'page_name' 		=> 'required',
				'block_name' 		=> 'required',
				'short_name' 		=> 'required',
				'description' 		=> 'required',
			)
		);

		if ($validator->fails()){
			return Redirect::back()
				->withErrors($validator)->withInput();
		}else{
			$model = new Block;
			$pageName    				= 	strip_tags(Input::get('page_name'));
			$blockName  		  		= 	strip_tags(Input::get('block_name'));
			$model->page_name    		= 	$pageName;
			$model->block_name    		= 	strip_tags(Input::get('block_name'));
			$model->page    			= 	$this->getSlug($pageName,'page','blocks');
			$model->block    			= 	$this->getSlug($blockName,'block','blocks');
			$model->short_name   		= 	$dafaultLanguageArray['short_name'];
			$model->description   		= 	$dafaultLanguageArray['description'];
			$model->save();

			$modelId	=	$model->id;
			foreach ($thisData['data'] as $language_id => $descriptionResult) {
				$modelDescription					=  new BlockDescription();
				$modelDescription->language_id		=	$language_id;
				$modelDescription->parent_id		=	$modelId;
				$modelDescription->short_name		=	$descriptionResult['short_name'];
				$modelDescription->description		=	$descriptionResult['description'];
				$modelDescription->save();
			}

			Session::flash('flash_notice',  trans("messages.$this->model.added_message"));
			return Redirect::route("$this->model.index");
		}
	}//end saveBlock()

	 /**
	 * Function for display page  for edit Block page
	 *
	 * @param $modelId as id of Block page
	 *
	 * @return view page.
	 */

	public function editBlock($modelId, $page=''){

		$model				=	Block::find($modelId);
		if($model)
		{
			// Breadcrums   is  added   here dynamically
			Breadcrumb::addBreadcrumb(trans("messages.global.breadcrumbs_dashboard"),route('admin_dashboard'));
			Breadcrumb::addBreadcrumb(trans("messages.$this->model.breadcrumbs_module"),route($this->model.'.index'));
			Breadcrumb::addBreadcrumb(trans("messages.$this->model.breadcrumbs_edit"),'');
			$breadcrumbs 	= 	Breadcrumb::generate();
			### breadcrumbs End ###
			$modelDescriptions	=	BlockDescription::where('parent_id','=',$modelId)->get();
			$multiLanguage		=	array();

			if(!empty($modelDescriptions)){
				foreach($modelDescriptions as $modelDescription) {
					$multiLanguage[$modelDescription->language_id]['short_name']	=	$modelDescription->short_name;
					$multiLanguage[$modelDescription->language_id]['description']	=	$modelDescription->description;
				}
			}

			//~ $languages				=	Language::where('is_active', '=', ACTIVE)->get(array('title','id'));
			//~ $language_code			=	Config::get('default_language.language_code');
			return  View::make("admin.$this->model.edit",compact('breadcrumbs','languages','language_code','model','multiLanguage','page'));
		}
		else{
			Session::flash('error', trans("messages.global.invalid_access"));
			return Redirect::route("$this->model.index");
		}
	}// end editBlock()

	 /**
	 * Function for update Block
	 *
	 * @param $modelId as id of Block
	 *
	 * @return redirect page.
	 */

	function updateBlock($modelId){

		$this_data				=	Input::all();
		$model 					= 	Block:: findorFail($modelId);
		$activeLanguageCode		=	Config::get('default_language.language_code');
		$dafaultLanguageArray	=	$this_data['data'][$activeLanguageCode];

		$validator = Validator::make(
			array(
				'page_name' 		=> Input::get('page_name'),
				'block_name' 		=> Input::get('block_name'),
				'short_name' 		=> $dafaultLanguageArray['short_name'],
				'description' 		=> $dafaultLanguageArray['description'],
			),
			array(
				'page_name' 		=> 'required',
				'block_name' 		=> 'required',
				'short_name' 		=> 'required',
				'description' 		=> 'required',
			)
		);

		if ($validator->fails())
		{
			return Redirect::back()
				->withErrors($validator)->withInput();
		}else{

			$model->page_name    		= strip_tags(Input::get('page_name'));
			$model->block_name    		= strip_tags(Input::get('block_name'));
			$model->short_name			=	$dafaultLanguageArray['short_name'];
			$model->description   		= 	$dafaultLanguageArray['description'];
			$model->save();
			$pageNo = Input::get('page');
			BlockDescription::where('parent_id', '=', $modelId)->delete();

			foreach ($this_data['data'] as $languageId => $descriptionResult) {
				$modelDescription				=  new BlockDescription();
				$modelDescription->language_id	=	$languageId;
				$modelDescription->parent_id	=	$modelId;
				$modelDescription->short_name	=	$descriptionResult['short_name'];
				$modelDescription->description	=	$descriptionResult['description'];
				$modelDescription->save();
			}
			Session::flash('flash_notice',  trans("messages.$this->model.updated_message"));
			if ($pageNo == '') {
				return Redirect::route("$this->model.index");
			}else{
				return Redirect::route("$this->model.index", "$pageNo");
			}
		}
	}// end updateBlock()

	/**
	 * Function for update Block  status
	 *
	 * @param $modelId as id of Block
	 * @param $modelStatus as status of Block
	 *
	 * @return redirect page.
	 */

	public function updateBlockStatus($modelId = 0, $modelStatus = 0){
		Block::where('id', '=', $modelId)->update(array('is_active' => $modelStatus));
		Session::flash('flash_notice', trans("messages.$this->model.status_updated_message"));
		return Redirect::route("$this->model.index");
	}// end updateBlockStatus()

	/**
	 * Function for delete Block
	 *
	 * @param $modelId as id of Block
	 *
	 * @return redirect page.
	 */

	public function deleteBlock($modelId = 0){
		if($modelId){
			$model = Block::findorFail($modelId);
			$model->description()->delete();
			$model->delete();
			Session::flash('flash_notice',trans("messages.$this->model.deleted_message"));
		}
		return Redirect::route("$this->model.index");
	} // end deleteBlock()


	/**
	 * Function for delete multiple Block
	 *
	 * @param null
	 *
	 * @return view page.
	 */

	public function performMultipleAction(){
		if(Request::ajax()){
			$actionType = ((Input::get('type'))) ? Input::get('type') : '';
			if(!empty($actionType) && !empty(Input::get('ids'))){
				if($actionType	==	'delete'){
					BlockDescription::whereIn('parent_id', Input::get('ids'))->delete();
					Block::whereIn('id', Input::get('ids'))->delete();
				}
				Session::flash('success', trans("messages.global.action_performed_message"));
			}
		}
	}//end performMultipleAction()

}// end BlockController
