<?php

namespace App\Http\Controllers\Admin;

use App\Model\AdminUser;
use App\Http\Controllers\BaseController;
use App\Model\Players;
use App\Models\Bonus;
use App\Helpers\Helpers;
use App\libraries\CustomHelper;
use App\RegisterUser;
use Illuminate\Http\Request;
use Carbon\Carbon;
use App\Services\Input;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\View;
use Yajra\DataTables\Facades\DataTables;

class BonusController extends BaseController
{
    /*
	 * Function for display email detail from database
	 *
	 * @param null
	 *
	 * @return view page.
	 */
    public $model    =    'Bonus';

    //First time Lode Function
    public function __construct()
    {
        View::share('modelName', $this->model);
    } //End Function

    //View Players
    public function viewplayers_oldd()
    {
        // $findallteams= Db::table('teams')->select('id','team')->get();
        $formData = Input::all();
        if (isset($formData) && !empty($formData)) {
            return Datatables::of(
                DB::table('playerdetails')
                    // ->join('players','players.player_key','=','playerdetails.player_key')
                    // ->join('players','players.player_key','=','playerdetails.player_key')
                    ->join('players', function ($join) {
                        $join->on('players.player_key', '=', 'playerdetails.player_key')
                            ->on('players.sport_type', '=', 'playerdetails.sport_type');
                    })
                    ->join('teams', 'teams.id', '=', 'players.team')
                    ->select('teams.team as teamname', 'playerdetails.*', 'playerdetails.player_key as player_key', 'players.id as id', 'players.role', 'players.credit')
                    ->orderBy('fullname', 'ASC')
                    ->groupBy('playerdetails.player_key')
                    ->groupBy('playerdetails.sport_type')
                    ->limit('1000')
                    ->get()
            )
                ->addIndexColumn()
                ->addColumn('id', function ($result) {
                    return $result->id;
                })
                ->editColumn('credit', function ($result) {
                    return '<td id="credittd' . $result->id . '">
							' . $result->credit . '
							</td>';
                })
                ->addColumn('fullname', function ($result) {
                    return ucwords($result->fullname);
                })
                ->addColumn('image', function ($result) {
                    if ($result->image != "") {
                        $image = '<img src="' . url()->asset("uploads/players/" . $result->image) . '" style="width:50px; height:50px; border-radius:2px;">';
                    } else {
                        $image = '<img src="' . DEFAULT_PLAYER_IMAGE_URL . '" style="width:50px; height:50px; border-radius:2px;">';
                    }
                    return $image;
                })
                ->addColumn('role', function ($result) {
                    return '<td id="roletd<?php echo $player->id;?>">' . $result->role . '</td>';
                })
                ->addColumn('player_key', function ($result) {
                    return $result->player_key;
                })
                ->addColumn('credit', function ($result) {
                    return $result->credit;
                })
                ->addColumn('teamname', function ($result) {
                    return $result->teamname;
                })
                ->addColumn('sport_type', function ($result) {
                    if ($result->sport_type == 1) {
                        return 'Cricket';
                    } else if ($result->sport_type == 2) {
                        return 'Football';
                    } else if ($result->sport_type == 3) {
                        return 'Basketball';
                    }
                    return $result->sport_type;
                })
                ->addColumn('action', function ($result) {
                    $bowler = $result->role;
                    return '<a href="' . route($this->model . '.edit', [base64_encode(serialize($result->id)), $result->sport_type]) . '" data-toggle="tooltip" title="Edit" class="btn btn-rg mr-1 mt-1" data-original-title="Edit"><i class="fa fa-pencil" aria-hidden="true"></i></a>'
                        . '<a onclick="updateplayer(' . $result->id . ',' . $result->credit . ')" id="updateplayer' . $result->id . '" class="btn btn-rg mr-1 mt-1" aria-hidden="true" data-toggle="tooltip" title="Change Credits" data-original-title="Refresh"><i class="fa fa-refresh"></i></a>'
                        . '<a id="saveplayer' . $result->id . '" class="btn btn-rg mr-1 mt-1" style="display:none;cursor:pointer" data-toggle="tooltip" title="" data-original-title="Save" ><i class="fa fa-floppy-o" aria-hidden="true"></i></a>'
                        . '<a href="' . route($this->model . '.delete', base64_encode(serialize($result->id))) . '" data-toggle="tooltip" title="delete" class="btn btn-danger action-players"><i class="fa fa-times mr-2" aria-hidden="true" data-original-title="Delete"></i>Delete</a>';
                    // onclick="saveplayer('.$result->id.')"
                })
                ->escapeColumns([])
                ->make(true);
        } //end

        return view("admin.$this->model.viewplayers");
    } //End Function

    //View Players
    public function viewbonus()
    {

        // $findallteams= Db::table('teams')->select('id','team')->get();
        $formData = Input::all();
        if (isset($formData) && !empty($formData)) {
            return Datatables::of(
                DB::table('bonus_amount')

                    ->select('bonus_amount.*')

                    ->get()
            )
                ->addIndexColumn()
                ->addColumn('id', function ($result) {
                    return $result->id;
                })
                ->editColumn('type', function ($result) {
                    return $result->type;
                })
                ->addColumn('bonus_type', function ($result) {
                    return $result->bonus_type;
                })
                ->addColumn('price', function ($result) {
                    return $result->price;
                })

                ->addColumn('status', function ($result) {
                    return $result->status;
                })

                ->addColumn('action', function ($result) {
                    $activation_status = '';
                    if (strtolower($result->status) != '0') {
                        $activation_status = '<a href="' . route($this->model . '.update_subadmin_status', [base64_encode(serialize($result->id)), '0']) . '" class="btn btn-success mr-1 mt-1 action-userss">Active</a></br>';
                    } else {
                        $activation_status = '<a href="' . route($this->model . '.update_subadmin_status', [base64_encode(serialize($result->id)), '1']) . '" class="btn btn-warning mr-1 mt-1 action-users">Inactivate</a></br>';
                    }


                    // $bowler=$result->role;
                    return '<a href="' . route($this->model . '.edit', [base64_encode(serialize($result->id))]) . '" data-toggle="tooltip" title="Edit" class="btn btn-rg mr-1 mt-1" data-original-title="Edit"><i class="fa fa-pencil" aria-hidden="true"></i></a>'

                        . '<a id="saveplayer' . $result->id . '" class="btn btn-rg mr-1 mt-1" style="display:none;cursor:pointer" data-toggle="tooltip" title="" data-original-title="Save" ><i class="fa fa-floppy-o" aria-hidden="true"></i></a>'
                        . '<a href="' . route($this->model . '.delete', base64_encode(serialize($result->id))) . '" data-toggle="tooltip" title="delete" class="btn btn-danger action-players"><i class="fa fa-times mr-2" aria-hidden="true" data-original-title="Delete"></i>Delete</a>'
                        . $activation_status;

                    // onclick="saveplayer('.$result->id.')"
                })
                ->escapeColumns([])
                ->make(true);
        } //end

        return view("admin.$this->model.viewbonus");
    } //End Function


    public function deleteplayer($id)
    {
        // dd('dd');
        $id = unserialize(base64_decode($id));
        $findPlayer = DB::table('bonus_amount')->where('id', $id)->first();
        if (!empty($findPlayer)) {
            DB::table('bonus_amount')->where('id', $id)->delete();
            Session::flash('flash_notice', 'Successfully Deleted Bonus!');
            Helpers::logActivity('Successfully Deleted Bonus!', $findPlayer->id);
            Session::flash('alert-class', 'alert-success');
        } else {
            Session::flash('flash_notice', 'Invalid bonus id');
            Session::flash('alert-class', 'alert-error');
        }
        return Redirect::back();
    }

    public function editbonus(Request $request, $id, $sport_type = 1)
    {
        // dd($request->all());
        $id = unserialize(base64_decode($id));
        $player = Bonus::find($id);
        // dd($id);
        $sport_types = DB::table('sport_types')->select('id', 'sport_name')->where('sport_name', '!=', 'Basketball')->where('status', 1)->get();

        // dd($player);
        return view("admin.$this->model.editbonus", compact('player', 'sport_types'));
    }

    public function updatebonus(Request $request, $id)
    {
        // dd($request->all());
        $Bonus = Bonus::find($id);
        // dd($Bonus);
        $bonusname = str_replace(' ', '_', strtoupper($request->input('type')));
        $Bonus->type = $bonusname;
        $Bonus->price = $request->input('price');
        $Bonus->bonus_type = $request->input('bonus_type');
        $Bonus->status = $request->input('status');
        $Bonus->first_deposit_condition = $request->input('first_deposit_condition');

        if (!empty($request->input('first_deposit'))) {
            $Bonus['first_deposit'] = 1;
        } else {
            $Bonus['first_deposit'] = 0;
        }
        if ($Bonus->first_deposit = $request->input('first_deposit') == 1) {
            $Bonus->max_deposit_limit = $request->input('max_deposit_limit');
        } else {
            $Bonus->max_deposit_limit = 0;
        }
        $Bonus->update();
        // Session::flash('flash_notice',  trans("Player Successfully updated!"));
        // Helpers::logActivity('Player successfully updated!',$fplay->player_name);
        return Redirect::route("$this->model.view");
        // return redirect()->back()->with('status','Student Updated Successfully');
    }

    public function updatesubadminstatus($id, $status)
    {
        $id = unserialize(base64_decode($id));
        $input['id'] = $id;
        $input['status'] = $status;
        // dd($input['status']);
        DB::table('bonus_amount')->where('id', $id)->update($input);
        Session::flash('flash_notice', 'User ' . $status . ' successfully!');
        return Redirect::back();
    } //End Function






    public function editplayerhk(Request $request, $id, $sport_type = 1)
    {
        // dd('dd');
        // dd($id);
        $id = unserialize(base64_decode($id));
        // var_dump($id);exit;
        // Get Player Data
        $playerskeyget = DB::table('players')->where('id', $id)->select('id', 'player_key', 'sport_type')->first();
        $player = DB::table('bonus_amount')
            ->select('bonus_amount.*')

            ->get();
        // print_r($player);die;
        $formData    =    Input::all();
        if (!empty($formData)) {
            unset($formData['_token']);
            $playerdetail['fullname'] = $formData['player_name'];
            $playerdetail['country'] = $formData['country'];
            $playerdetail['bowling_style'] = $formData['bowling_style'];
            $playerdetail['batting_style'] = $formData['batting_style'];
            if ($formData['dob'] != '') {
                $playerdetail['dob'] = date('Y-m-d', strtotime($formData['dob']));
            }
            $playerdetail['sport_type'] = $formData['sport_type'];







            $input = $request->all();
            if ($input['base64image'] || $input['base64image'] != '0') {
                // echo "string"; die();
                $folderPath = PLAYER_IMAGE_ROOT_PATH;
                // dd($folderPath);
                // $folderPath = public_path('images/');
                $image_parts = explode(";base64,", $input['base64image']);
                if ($image_parts[0] === "") {
                    // echo "string"; die();
                    if (input::hasFile('image')) {
                        // echo "string"; die();
                        $extension  =   Input::file('image')->getClientOriginalExtension();
                        $img_ext    =   explode(",", IMAGE_EXTENSION);
                        if (in_array($extension, $img_ext)) {
                            $fileName           =   time() . '-user-image.' . $extension;
                            if (Input::file('image')->move(PLAYER_IMAGE_ROOT_PATH, $fileName)) {
                                $playerdetail['image']     =   $fileName;
                                // dd($obj['image']);
                            }
                            @unlink(PLAYER_IMAGE_ROOT_PATH . $oldimage);
                        } else {
                            Session::flash('error',  trans("$this->model.INVALID_IMAGE_EXTENSION"));
                            return Redirect::back();
                        }
                    }
                } else {
                    $image_type_aux = explode("image/", $image_parts[0]);
                    // dd($image_parts);
                    $image_type = $image_type_aux[1];
                    // dd($image_type);
                    $image_base64 = base64_decode($image_parts[1]);
                    // $file = $folderPath . uniqid() . '.png';
                    $filename           =   time() . '-user-image.' . $image_type;
                    // $filename = time() . '.'. $image_type;
                    $file = $folderPath . $filename;
                    $playerdetail['image'] = $filename;
                    // dd($file);
                    file_put_contents($file, $image_base64);
                    // dd($file);

                    // $playerdetail = new Players;
                    $playerdetail['image'] = $filename;
                    // dd($playerdetail);
                    // $playerdetail->save();
                }
            }







            // print_r($playerskeyget->player_key);die;
            DB::table('playerdetails')->where('player_key', $playerskeyget->player_key)->where('sport_type', $playerskeyget->sport_type)->update($playerdetail);
            /* to update credits and roles */
            $playerd['credit'] = $formData['credit'];
            $playerd['role'] = $formData['role'];
            $playerd['player_name'] = $formData['player_name'];
            $playerd['sport_type'] = $formData['sport_type'];
            // $playerd['image'] = $playerdetail['image'];
            $findallplay = DB::table('players')->where('player_key', $playerskeyget->player_key)->get();

            if (!empty($findallplay)) {
                foreach ($findallplay as $fplay) {
                    DB::table('players');
                    DB::table('players')->where('id', $fplay->id)->update($playerd);
                }
            }
            //die;
            // Session::flash('message', 'Successfully updated series!');
            // Session::flash('alert-class', 'alert-success');
            Session::flash('flash_notice',  trans("Player Successfully updated!"));
            Helpers::logActivity('Player successfully updated!', $fplay->player_name);
            return Redirect::route("$this->model.view");
        }
        dd('dd');
        $sport_types = DB::table('sport_types')->select('id', 'sport_name')->where('sport_name', '!=', 'Basketball')->where('status', 1)->get();

        //Session::flash('flash_notice',  trans("Invalid Id Provided!"));
        return view("admin.$this->model.editbonus", compact('player', 'playerskeyget', 'sport_types'));
    } //End Function

    //Save  Player Roles
    // public function saveplayerroles(Request $request){
    // 	if ($request->isMethod('post')){
    // 		$input = Input::all();
    // 		$data['credit'] = $input['credit'];
    // 		$findplayerkey = DB::table('players')->where('id',$input['id'])->select('player_key')->first();
    // 		$playerkey= $findplayerkey->player_key;
    // 		$findplayers = DB::table('players')->where('player_key',$playerkey)->get();
    // 		if(!empty($findplayers)){
    // 			foreach($findplayers as $pl){
    // 				DB::table('players');
    // 				DB::table('players')->where('id',$pl->id)->update($data);
    // 			}
    // 		}
    // 		echo 1;die;
    // 	}
    // }//End Function

    //Save  Player Roles
    public function saveplayerroles(Request $request)
    {
        if ($request->isMethod('post')) {
            $input = Input::all();
            if ($input['credit'] > 0) {
                $data['credit'] = $input['credit'];
                $findplayerkey = DB::table('players')->where('id', $input['id'])->select('player_key')->first();
                $playerkey = $findplayerkey->player_key;
                $findplayers = DB::table('players')->where('player_key', $playerkey)->get();
                if (!empty($findplayers)) {
                    foreach ($findplayers as $pl) {
                        DB::table('players');
                        DB::table('players')->where('id', $pl->id)->update($data);
                    }
                }
            } else {
                Session::flash('flash_notice',  trans("You cannot enter credit of a player more than 0."));
            }
            return Redirect::back();
        }
    } //End Function

    public function addplayermanually(Request $request)
    {
        if ($request->isMethod('post')) {
            $input = Input::all();
            $matchkikey = $input['matchkey'];
            $findplayerexist = DB::table('players')->where('player_key', $input['player_key'])->where('team', $input['team'])->first();
            $data['player_name'] = $input['player_name'];
            $data['player_key'] = $input['player_key'];
            $data['role'] =  $input['role'];
            if (empty($findplayerexist)) {
                $data['team'] = $input['team'];
                $playerid = DB::table('players')->insertGetId($data);
                $credit = $input['credit'];
            } else {
                $playerid = $findplayerexist->id;
                $credit = $input['credit'];
            }
            /* insert in player details */
            $findplayerdetails = DB::table('playerdetails')->where('player_key', $input['player_key'])->first();
            if (empty($findplayerdetails)) {
                $fdata['fullname'] = $input['player_name'];
                $fdata['player_key'] = $input['player_key'];
                DB::table('playerdetails')->insert($fdata);
            }
            // insert players for a match//
            $findplayer1entry = DB::table('matchplayers')->where('matchkey', $matchkikey)->where('playerid', $playerid)->first();
            if (empty($findplayer1entry)) {
                $matchplayerdata['matchkey'] = $matchkikey;
                $matchplayerdata['playerid'] = $playerid;
                $matchplayerdata['role'] = $data['role'];
                $matchplayerdata['name'] = $data['player_name'];
                $matchplayerdata['credit'] = $credit;
                DB::table('matchplayers')->insert($matchplayerdata);
            }
            Session::flash('flash_notice', 'Successfully added the player!');
            //Session::flash('alert-class', 'alert-success');
            return Redirect::back();
        }
    }

    //add player
    public function add_bonus(Request $request)
    {
        // dd('dd');
        $teams = DB::table('teams')->select('id', 'team')->orderBy('team', 'ASC')->get();
        $formData    =    Input::all();
        if (!empty($formData)) {

            $validate    =    array(
                'type'     =>    'required',
                'price'    =>    'required',
                'bonus_type' => 'required',
                'status' => 'required',
            );
            $validator = Validator::make(Input::all(), $validate);
            if ($validator->fails()) {
                return Redirect::back()->withErrors($validator)->withInput();
            } else {
                unset($formData['_token']);

                $bonusname = str_replace(' ', '_', strtoupper($formData['type']));
                $bonusData['type'] = $bonusname;
                $bonusData['price'] = $formData['price'];
                $bonusData['bonus_type'] = $formData['bonus_type'];
                $bonusData['status'] = $formData['status'];
                $bonusData['max_deposit_limit'] = $formData['max_deposit_limit'];

                $bonusData['first_deposit'] = $formData['first_deposit'] ? $bonusData['first_deposit'] = $formData['first_deposit'] : '0';

                $bonusData['first_deposit_condition'] = $formData['first_deposit_condition'];
                DB::table('bonus_amount')->insert($bonusData);
                return Redirect::route("$this->model.view");
            }
        }
        $sport_types = DB::table('sport_types')->select('id', 'sport_name')->where('sport_name', '!=', 'Basketball')->where('status', 1)->get();

        return view("admin.$this->model.add_bonus", compact('teams', 'sport_types'));
    }


    public function usepromocode(Request $req)
    {
        if ($req->isMethod('post')) {
            $formData = Input::all();
            if (isset($formData) && !empty($formData)) {
                return Datatables::of($query = DB::table('user_promo')
                    ->orderBy('user_promo.id', 'DESC')
                    ->select('promo_code', 'created')
                    ->selectRaw('sum(user_promo.amount) as amount')
                    ->where('user_promo.status', 1)
                    ->groupby('promo_code')
                    ->get())
                    ->addIndexColumn()
                    ->addColumn('promo_code', function ($result) {
                        if ($result->promo_code != "") {
                            return '<a href="' . route($this->model . '.bonususe', base64_encode(serialize($result->promo_code))) . '">' . $result->promo_code . '</a>';
                        }
                    })
                    ->addColumn('amount', function ($result) {
                        if ($result->amount != "") {
                            return $result->amount;
                        }
                    })
                    ->escapeColumns([])
                    ->make(true);
            } //end
        }
        return view("admin.$this->model.use_promocode_list");
    }
    public function userusebonuslist(Request $req, $promo_code)
    {
        if ($req->isMethod('post')) {
            $formData = Input::post();
            $promo_code = unserialize(base64_decode($promo_code));

            if (isset($formData) && !empty($formData)) {
                return \Datatables::of($query = DB::table('user_promo')->orderBy('id', 'DESC')
                    ->join('registerusers', 'registerusers.id', '=', 'user_promo.user_id')
                    //	->join('transactions','transactions.userid','=','user_promo.user_id')
                    ->select('user_promo.*', 'registerusers.mobile', 'user_promo.amount as offeramount', 'registerusers.team')
                    ->where('user_promo.status', 1)
                    ->where('user_promo.promo_code', $promo_code)
                    //	->where('transactions.type','Offer Bonus add during add fund')

                    ->where(function ($query) use ($formData) {
                        if (isset($formData['filter_columns'])) {
                            if (isset($formData['filter_columns']['filter_email'])) {
                                $query->where('.email', 'like', '%' . $formData['filter_columns']['filter_email'] . '%');
                            }
                            if (isset($formData['filter_columns']['filter_mobile'])) {
                                $query->where('registerusers.mobile', 'like', '%' . $formData['filter_columns']['filter_mobile'] . '%');
                            }
                            if (isset($formData['filter_columns']['filter_username'])) {
                                $query->where('registerusers.team', 'like', '%' . $formData['filter_columns']['filter_username'] . '%');
                            }
                            if (isset($formData['filter_columns']['filter_bonus_type'])) {
                                $query->where('adminwallets.bonustype', 'like', '%' . $formData['filter_columns']['filter_bonus_type'] . '%');
                            }
                        }
                    })
                    ->get())
                    ->addIndexColumn()
                    ->addColumn('username', function ($result) {
                        if ($result->team != "") {
                            return $result->team;
                        } else {
                            return $result->team;
                        }
                    })
                    ->addColumn('amount', function ($result) {
                        if ($result->offeramount != "") {
                            return $result->offeramount;
                        }
                    })
                    ->escapeColumns([])
                    ->make(true);
            } //end
        }
        return view("admin.$this->model.use_bonus_list", compact('promo_code'));
    }
    public function usepromocodedownload()
    {
        $output1 = "";
        $output1 .= '"Promo Code",';
        $output1 .= '"Amount",';
        $output1 .= '"Created",';
        $output1 .= "\n";
        $query = DB::table('user_promo')
            ->orderBy('user_promo.id', 'DESC')
            ->select('promo_code', 'created')
            ->selectRaw('sum(user_promo.amount) as amount')
            ->where('user_promo.status', 1)
            ->groupby('promo_code')
            ->get();

        if (!empty($query)) {
            foreach ($query as $get) {
                $output1 .= '"' . $get->promo_code . '",';
                $output1 .= '"' . $get->amount . '",';
                $output1 .= '"' . $get->created . '",';
                $output1 .= "\n";
            }
        }
        $filename =  "use_promocode_list.csv";
        header('Content-type: application/csv');
        header('Content-Disposition: attachment; filename=' . $filename);
        echo $output1;
        exit;
    }

    public function userusebonuslistDownload($promo_code)
    {
        $output1 = "";
        $output1 .= '"Team name",';
        $output1 .= '"User Mobile",';
        $output1 .= '"Promo Code",';
        $output1 .= '"Amount",';
        $output1 .= '"Created",';
        $output1 .= "\n";
        $promo_code = unserialize(base64_decode($promo_code));
        $query = DB::table('user_promo')->orderBy('id', 'DESC')
            ->join('registerusers', 'registerusers.id', '=', 'user_promo.user_id')->select('user_promo.*', 'registerusers.mobile', 'user_promo.amount as offeramount', 'registerusers.team')
            ->where('user_promo.status', 1)
            ->where('user_promo.promo_code', $promo_code)
            ->get();

        if (!empty($query)) {
            foreach ($query as $get) {
                $output1 .= '"' . $get->team . '",';
                $output1 .= '"' . $get->mobile . '",';
                $output1 .= '"' . $get->promo_code . '",';
                $output1 .= '"' . $get->amount . '",';
                $output1 .= '"' . $get->created . '",';
                $output1 .= "\n";
            }
        }
        $filename =  "use_promocode_detail.csv";
        header('Content-type: application/csv');
        header('Content-Disposition: attachment; filename=' . $filename);
        echo $output1;
        exit;
    }

    public function userwisereport(Request $request)
    {
        if ($request->isMethod('post')) {
            $columns = array(
                0 => 'id',
                1 => 'team',
                2 => 'mobile',
                3 => 'addcash',
                4 => 'withdraw',
                5 => 'affiliation',
                6 => 'extra_earn',
                7 => 'bonus',
                8 => 'gst',
                9 => 'tds',
                10 => 'total_wallet',
                11 => 'total_investment',
                12 => 'total_winning',
                13 => 'profit',
                14 => 'loss',
                15 => 'commission_pay',
                16 => 'company_earn',
            );
            $limit = $request->input('length');
            $start = $request->input('start');
            $order = $columns[$request->input('order.0.column')];
            $dir = $request->input('order.0.dir');

            $session_year = Helpers::getCurrentSessionYear();
            $query =    DB::table('registerusers as ru')
                ->leftjoin('registerusers_session as rs', 'ru.id', '=', 'rs.user_id')
                ->select('rs.total_deposit', 'rs.total_withdraw', 'rs.total_tds_dedcuted', 'ru.team', 'ru.mobile', 'ru.id')
                //->where("rs.session_year", $session_year)
                //->where("ru.id", 6)
                ->groupBy('ru.id');
            if (request()->has('team')) {
                $team = request('team');
                if ($team != "") {
                    $query->where("ru.team", $team);
                }
            }
            if (request()->has('mobile')) {
                $mobile = request('mobile');
                if ($mobile != "") {
                    $query->where("ru.mobile", $mobile);
                }
            }


            $totalTitles = $query->get()->count();
            $totalFiltered = $totalTitles;
            $titles = $query->offset($start)
                ->limit($limit)
                ->orderBy($order, $dir)
                ->get();
            $data = array();
            if (!empty($titles)) {
                $count = 1;
                foreach ($titles as $title) {


                    $alldata =    DB::table('listmatches')
                        ->join('leaugestransactions as lt', 'lt.matchkey', '=', 'listmatches.matchkey')
                        //	->join('registerusers as rs','rs.id','=','lt.user_id')
                        ->leftJoin('refunds', function ($join) {
                            $join->on('refunds.joinid', '=', 'lt.joinid')
                                ->whereNotIn('refunds.reason', ['Winning reversed', 'Winning reversed point issue']);
                        })
                        ->whereNull('refunds.joinid')

                        ->where('listmatches.launch_status', 'launched')
                        ->where('listmatches.final_status', 'winnerdeclared')
                        ->where('lt.user_id', $title->id)
                        ->select('listmatches.matchkey')
                        ->selectRaw('count(lt.id) as joincontest')
                        ->selectRaw('sum(lt.bonus) as bonus')
                        ->selectRaw('sum(lt.winning) as winning')
                        ->selectRaw('sum(lt.balance) as balance')
                        ->first();
                    $totalwinning = DB::table('finalresults')->where('userid', $title->id)->sum('amount');

                    $refercommi = DB::table('league_refer_bonus')->where('refer_id', $title->id)->sum('amount');
                    $referamount = DB::table('league_refer_bonus')->where('user_id', $title->id)->sum('amount');
                    $totalrefercomm = $refercommi;
                    $totalreferamount = $referamount;
                    // if($refercommi>0){
                    // 	$commission= $refercommi*0.05;
                    // 	$totalrefercomm= $refercommi-$commission;
                    // }

                    // if($referamount>0){
                    // 	$commission= $referamount*0.05;
                    // 	$totalreferamount= $referamount-$commission;
                    // }

                    $bonususe = DB::table('leaugestransactions')
                        ->join('matchchallenges', 'matchchallenges.id', '=', 'leaugestransactions.challengeid')->where('matchchallenges.status', '!=', 'canceled')
                        ->where('user_id', $title->id)->sum('leaugestransactions.bonus');

                    $gstamount = DB::table('deposit_gst')->where('user_id', $title->id)->sum('gst_amount');

                    $wininncomm = DB::table('winning_commission')->where('userid', $title->id)->sum('commission');


                    $totalbaalnce = DB::table('userbalances')->where('user_id', $title->id)->first();
                    $nestedData['id'] = $count;
                    $nestedData['team'] =  $title->team;
                    $nestedData['mobile'] = '<a href="' . route($this->model . '.user_wise_report', base64_encode(serialize($title->id))) . '" data-toggle="tooltip" title="Click to see detail" class="" style="text-decoration:underline;">' . $title->mobile . '</a>';
                    $nestedData['addcash'] = isset($title->total_deposit) ? $title->total_deposit : 0.00;
                    $nestedData['withdraw'] =  isset($title->total_withdraw) ? $title->total_withdraw : 0.00;
                    $nestedData['affiliation'] = number_format($totalrefercomm, 2);
                    $nestedData['extra_earn'] = number_format($wininncomm, 2);
                    $nestedData['bonus'] = number_format($bonususe, 2);
                    $nestedData['gst'] = $gstamount;
                    $nestedData['tds'] =    isset($title->total_tds_dedcuted) ? $title->total_tds_dedcuted : 0.00;
                    $nestedData['total_wallet'] = $totalbaalnce->balance + $totalbaalnce->winning + $totalbaalnce->bonus;
                    $nestedData['total_investment'] = number_format($alldata->balance + $alldata->winning, 2);
                    $nestedData['total_winning'] = $totalwinning;
                    if ($totalwinning >= $alldata->balance + $alldata->winning) {
                        $nestedData['profit'] = number_format($totalwinning - ($alldata->balance + $alldata->winning), 2);
                    } else {
                        $nestedData['profit'] = 0;
                    }

                    if ($totalwinning <= ($alldata->balance + $alldata->winning)) {
                        $lossdata = (($alldata->balance + $alldata->winning) - $totalwinning);
                        $nestedData['loss'] = number_format($lossdata, 2);
                    } else {
                        $lossdata = 0;
                        $nestedData['loss'] = 0;
                    }

                    $nestedData['commission_pay'] =    number_format($totalreferamount, 3);
                    if ($lossdata > 0) {
                        $nestedData['company_earn'] =    number_format($lossdata - $totalreferamount, 3);
                    } else {
                        $nestedData['company_earn'] = 0;
                    }

                    $data[] = $nestedData;
                    $count++;
                }
            }
            $json_data = array(
                "draw" => intval($request->input('draw')),
                "recordsTotal" => intval($totalFiltered),
                "recordsFiltered" => intval($totalFiltered),
                "data" => $data,
            );
            echo json_encode($json_data);
            exit;
        }
        return view("admin.$this->model.use_wise_report");

        exit;
        $report =    DB::table('listmatches')
            ->join('leaugestransactions as lt', 'lt.matchkey', '=', 'listmatches.matchkey')
            ->join('registerusers as rs', 'rs.id', '=', 'lt.user_id')
            ->leftJoin('refunds', function ($join) {
                $join->on('refunds.joinid', '=', 'lt.joinid')
                    ->whereNotIn('refunds.reason', ['Winning reversed', 'Winning reversed point issue']);
            })
            ->whereNull('refunds.joinid')

            ->where('listmatches.launch_status', 'launched')
            ->where('listmatches.final_status', 'winnerdeclared')
            //->where('lt.user_id',2)
            ->select('listmatches.matchkey', 'rs.team', 'rs.mobile', 'rs.id')
            ->selectRaw('sum(lt.bonus) as bonus')
            ->selectRaw('sum(lt.winning) as winning')
            ->selectRaw('sum(lt.balance) as balance')
            ->orderBy('listmatches.start_date', 'DESC')
            ->groupBy('lt.user_id')
            //->limit(500)
            ->get();
        echo '<pre>';
        print_r($report);
        exit;
    }

    public function userwisereport_old(Request $request)
    {

        if ($request->isMethod('post')) {
            $columns = array(
                0 => 'id',
                1 => 'team',
                2 => 'mobile',
                3 => 'joincontest',
                4 => 'total_investment',
                5 => 'total_winning',
                6 => 'profit',
                7 => 'loss',
                8 => 'company_earn',
            );
            $limit = $request->input('length');
            $start = $request->input('start');
            $order = $columns[$request->input('order.0.column')];
            $dir = $request->input('order.0.dir');
            $query =    DB::table('listmatches')
                ->join('leaugestransactions as lt', 'lt.matchkey', '=', 'listmatches.matchkey')
                ->join('registerusers as rs', 'rs.id', '=', 'lt.user_id')
                ->leftJoin('refunds', function ($join) {
                    $join->on('refunds.joinid', '=', 'lt.joinid')
                        ->whereNotIn('refunds.reason', ['Winning reversed', 'Winning reversed point issue']);
                })
                ->whereNull('refunds.joinid')

                ->where('listmatches.launch_status', 'launched')
                ->where('listmatches.final_status', 'winnerdeclared')
                //->where('lt.user_id',2)
                ->select('listmatches.matchkey', 'rs.team', 'rs.mobile', 'rs.id')
                ->selectRaw('count(lt.id) as joincontest')
                ->selectRaw('sum(lt.bonus) as bonus')
                ->selectRaw('sum(lt.winning) as winning')
                ->selectRaw('sum(lt.balance) as balance')
                ->orderBy('listmatches.start_date', 'DESC')
                ->groupBy('lt.user_id');

            $totalTitles = $query->get()->count();
            $totalFiltered = $totalTitles;
            $titles = $query->offset($start)
                ->limit($limit)
                ->orderBy($order, $dir)
                ->get();
            if (!empty($titles)) {
                $count = 1;
                foreach ($titles as $title) {
                    $totalwinning = DB::table('finalresults')->where('userid', $title->id)->sum('amount');

                    $nestedData['id'] = $count;
                    $nestedData['team'] =  $title->team;
                    $nestedData['mobile'] = $title->mobile;
                    $nestedData['joincontest'] = $title->joincontest;
                    $nestedData['total_investment'] = number_format($title->balance + $title->winning, 2);
                    $nestedData['total_winning'] = $totalwinning;
                    if ($totalwinning >= $title->balance + $title->winning) {
                        $nestedData['profit'] = number_format($totalwinning - ($title->balance + $title->winning), 2);
                    } else {
                        $nestedData['profit'] = 0;
                    }

                    if ($totalwinning <= ($title->balance + $title->winning)) {
                        $nestedData['loss'] = number_format((($title->balance + $title->winning) - $totalwinning), 2);
                    } else {
                        $nestedData['loss'] = 0;
                    }

                    $nestedData['company_earn'] = $nestedData['loss'];
                    $data[] = $nestedData;
                    $count++;
                }
            }
            $json_data = array(
                "draw" => intval($request->input('draw')),
                "recordsTotal" => intval($totalFiltered),
                "recordsFiltered" => intval($totalFiltered),
                "data" => $data,
            );
            echo json_encode($json_data);
            exit;
        }
        return view("admin.$this->model.use_wise_report");

        exit;
        $report =    DB::table('listmatches')
            ->join('leaugestransactions as lt', 'lt.matchkey', '=', 'listmatches.matchkey')
            ->join('registerusers as rs', 'rs.id', '=', 'lt.user_id')
            ->leftJoin('refunds', function ($join) {
                $join->on('refunds.joinid', '=', 'lt.joinid')
                    ->whereNotIn('refunds.reason', ['Winning reversed', 'Winning reversed point issue']);
            })
            ->whereNull('refunds.joinid')

            ->where('listmatches.launch_status', 'launched')
            ->where('listmatches.final_status', 'winnerdeclared')
            //->where('lt.user_id',2)
            ->select('listmatches.matchkey', 'rs.team', 'rs.mobile', 'rs.id')
            ->selectRaw('sum(lt.bonus) as bonus')
            ->selectRaw('sum(lt.winning) as winning')
            ->selectRaw('sum(lt.balance) as balance')
            ->orderBy('listmatches.start_date', 'DESC')
            ->groupBy('lt.user_id')
            //->limit(500)
            ->get();
        echo '<pre>';
        print_r($report);
        exit;
    }
    public function userwisereportdata(Request $request, $userid)
    {
        $user_id = unserialize(base64_decode($userid));

        if ($request->isMethod('post')) {
            $columns = array(
                0 => 'id',
                1 => 'match',
                2 => 'matchkey',
                3 => 'date',
                4 => 'winning',
                5 => 'balance',
                6 => 'bonus',
                7 => 'invest',
                8 => 'total_winning',
                9 => 'profit',
                10 => 'loss',
            );
            $limit = $request->input('length');
            $start = $request->input('start');
            $order = $columns[$request->input('order.0.column')];
            $dir = $request->input('order.0.dir');

            $query =    DB::table('listmatches')
                ->join('leaugestransactions as lt', 'lt.matchkey', '=', 'listmatches.matchkey')
                ->join('registerusers as rs', 'rs.id', '=', 'lt.user_id')
                ->leftJoin('refunds', function ($join) {
                    $join->on('refunds.joinid', '=', 'lt.joinid')
                        ->whereNotIn('refunds.reason', ['Winning reversed', 'Winning reversed point issue']);
                })
                ->whereNull('refunds.joinid')
                ->where('lt.user_id', $user_id)
                ->where('listmatches.launch_status', 'launched')
                ->where('listmatches.final_status', 'winnerdeclared')
                ->select('listmatches.*')
                ->selectRaw('sum(lt.bonus) as bonus')
                ->selectRaw('sum(lt.coins) as gstbonus')
                ->selectRaw('sum(lt.winning) as winning')
                ->selectRaw('sum(lt.balance) as balance')
                ->orderBy('listmatches.start_date', 'DESC')
                ->groupBy('lt.matchkey');
            if (request()->has('team')) {
                $team = request('team');
                if ($team != "") {
                    $query->where("rs.team", $team);
                }
            }
            if (request()->has('mobile')) {
                $mobile = request('mobile');
                if ($mobile != "") {
                    $query->where("rs.mobile", $mobile);
                }
            }
            $totalTitles = $query->get()->count();

            $totalFiltered = $totalTitles;
            $titles = $query->offset($start)
                ->limit($limit)
                ->orderBy($order, $dir)
                ->get();
            $data = array();
            if (!empty($titles)) {
                $count = 1;
                foreach ($titles as $title) {

                    $totalwinning = DB::table('finalresults')
                        ->where('matchkey', $title->matchkey)
                        ->where('userid', $user_id)
                        ->select('amount')->sum('amount');

                    $totalinvest = $title->winning + $title->balance + $title->bonus;
                    $affiliation = DB::table('league_refer_bonus')
                        ->where('matchkey', $title->matchkey)
                        ->where('user_id', $user_id)
                        ->select('amount')->sum('amount');

                    $nestedData['id'] = $count;
                    $nestedData['match'] = $title->name;
                    $nestedData['matchkey'] = $title->matchkey;
                    $nestedData['date'] = $title->start_date;
                    $nestedData['winning'] = round($title->winning, 2);
                    $nestedData['balance'] = round($title->balance, 2);
                    $nestedData['bonus'] = round($title->bonus, 2);
                    $nestedData['invest'] = round($title->winning + $title->balance + $title->bonus, 2);
                    $nestedData['total_winning'] = round($totalwinning, 2);
                    // $nestedData['affiliation'] = round($affiliation,2);
                    $nestedData['profit'] = 0;
                    if ($totalinvest <= $totalwinning) {
                        $nestedData['profit'] = number_format($totalwinning - $totalinvest, 2);
                    }
                    $nestedData['loss'] = 0;
                    if ($totalinvest >= $totalwinning) {
                        $nestedData['loss'] = $totalinvest - $totalwinning;
                    }
                    $data[] = $nestedData;
                    $count++;
                }
            }
            $json_data = array(
                "draw" => intval($request->input('draw')),
                "recordsTotal" => intval($totalFiltered),
                "recordsFiltered" => intval($totalFiltered),
                "data" => $data,
            );
            echo json_encode($json_data);
            exit;
        }

        return view("admin.$this->model.use_wise_report_data", compact('userid'));

        exit;
        $report =    DB::table('listmatches')
            ->join('leaugestransactions as lt', 'lt.matchkey', '=', 'listmatches.matchkey')
            ->join('registerusers as rs', 'rs.id', '=', 'lt.user_id')
            ->leftJoin('refunds', function ($join) {
                $join->on('refunds.joinid', '=', 'lt.joinid')
                    ->whereNotIn('refunds.reason', ['Winning reversed', 'Winning reversed point issue']);
            })
            ->whereNull('refunds.joinid')

            ->where('listmatches.launch_status', 'launched')
            ->where('listmatches.final_status', 'winnerdeclared')
            //->where('lt.user_id',2)
            ->select('listmatches.matchkey', 'rs.team', 'rs.mobile', 'rs.id')
            ->selectRaw('sum(lt.bonus) as bonus')
            ->selectRaw('sum(lt.winning) as winning')
            ->selectRaw('sum(lt.balance) as balance')
            ->orderBy('listmatches.start_date', 'DESC')
            ->groupBy('lt.user_id')
            //->limit(500)
            ->get();
        echo '<pre>';
        print_r($report);
        exit;
    }
    public function userreportDownload()
    {
        $output1 = "";
        $output1 .= '"Team name",';
        $output1 .= '"User Mobile",';
        $output1 .= '"join contest",';
        $output1 .= '"Total InvestMent",';
        $output1 .= '"Total Winning",';
        $output1 .= '"Profit",';
        $output1 .= '"Loss",';
        $output1 .= '"Company Earn",';
        $output1 .= "\n";
        $query =    DB::table('listmatches')
            ->join('leaugestransactions as lt', 'lt.matchkey', '=', 'listmatches.matchkey')
            ->join('registerusers as rs', 'rs.id', '=', 'lt.user_id')
            ->leftJoin('refunds', function ($join) {
                $join->on('refunds.joinid', '=', 'lt.joinid')
                    ->whereNotIn('refunds.reason', ['Winning reversed', 'Winning reversed point issue']);
            })
            ->whereNull('refunds.joinid')

            ->where('listmatches.launch_status', 'launched')
            ->where('listmatches.final_status', 'winnerdeclared')
            //->where('lt.user_id',2)
            ->select('listmatches.matchkey', 'rs.team', 'rs.mobile', 'rs.id')
            ->selectRaw('count(lt.id) as joincontest')
            ->selectRaw('sum(lt.bonus) as bonus')
            ->selectRaw('sum(lt.winning) as winning')
            ->selectRaw('sum(lt.balance) as balance')
            ->orderBy('listmatches.start_date', 'DESC')
            ->groupBy('lt.user_id')->get();

        if (!empty($query)) {
            foreach ($query as $get) {
                $totalwinning = DB::table('finalresults')->where('userid', $get->id)->sum('amount');

                if ($totalwinning >= $get->balance + $get->winning) {
                    $nestedData['profit'] = number_format($totalwinning - ($get->balance + $get->winning), 2);
                } else {
                    $nestedData['profit'] = 0;
                }

                if ($totalwinning <= ($get->balance + $get->winning)) {
                    $nestedData['loss'] = number_format((($get->balance + $get->winning) - $totalwinning), 2);
                } else {
                    $nestedData['loss'] = 0;
                }
                $nestedData['company_earn'] = $nestedData['loss'];

                $output1 .= '"' . $get->team . '",';
                $output1 .= '"' . $get->mobile . '",';
                $output1 .= '"' . $get->joincontest . '",';
                $output1 .= '"' . number_format($get->balance + $get->winning, 2) . '",';
                $output1 .= '"' . $totalwinning . '",';
                $output1 .= '"' .    $nestedData['profit'] . '",';
                $output1 .= '"' .    $nestedData['loss'] . '",';
                $output1 .= '"' .    $nestedData['company_earn'] . '",';
                $output1 .= "\n";
            }
        }
        $filename =  "use_wise_report.csv";
        header('Content-type: application/csv');
        header('Content-Disposition: attachment; filename=' . $filename);
        echo $output1;
        exit;
    }

    public function userreportDownload_old()
    {
        $output1 = "";
        $output1 .= '"Team name",';
        $output1 .= '"User Mobile",';
        $output1 .= '"join contest",';
        $output1 .= '"Total InvestMent",';
        $output1 .= '"Total Winning",';
        $output1 .= '"Profit",';
        $output1 .= '"Loss",';
        $output1 .= '"Company Earn",';
        $output1 .= "\n";
        $query =    DB::table('listmatches')
            ->join('leaugestransactions as lt', 'lt.matchkey', '=', 'listmatches.matchkey')
            ->join('registerusers as rs', 'rs.id', '=', 'lt.user_id')
            ->leftJoin('refunds', function ($join) {
                $join->on('refunds.joinid', '=', 'lt.joinid')
                    ->whereNotIn('refunds.reason', ['Winning reversed', 'Winning reversed point issue']);
            })
            ->whereNull('refunds.joinid')

            ->where('listmatches.launch_status', 'launched')
            ->where('listmatches.final_status', 'winnerdeclared')
            //->where('lt.user_id',2)
            ->select('listmatches.matchkey', 'rs.team', 'rs.mobile', 'rs.id')
            ->selectRaw('count(lt.id) as joincontest')
            ->selectRaw('sum(lt.bonus) as bonus')
            ->selectRaw('sum(lt.winning) as winning')
            ->selectRaw('sum(lt.balance) as balance')
            ->orderBy('listmatches.start_date', 'DESC')
            ->groupBy('lt.user_id')->get();

        if (!empty($query)) {
            foreach ($query as $get) {
                $totalwinning = DB::table('finalresults')->where('userid', $get->id)->sum('amount');

                if ($totalwinning >= $get->balance + $get->winning) {
                    $nestedData['profit'] = number_format($totalwinning - ($get->balance + $get->winning), 2);
                } else {
                    $nestedData['profit'] = 0;
                }

                if ($totalwinning <= ($get->balance + $get->winning)) {
                    $nestedData['loss'] = number_format((($get->balance + $get->winning) - $totalwinning), 2);
                } else {
                    $nestedData['loss'] = 0;
                }
                $nestedData['company_earn'] = $nestedData['loss'];

                $output1 .= '"' . $get->team . '",';
                $output1 .= '"' . $get->mobile . '",';
                $output1 .= '"' . $get->joincontest . '",';
                $output1 .= '"' . number_format($get->balance + $get->winning, 2) . '",';
                $output1 .= '"' . $totalwinning . '",';
                $output1 .= '"' .    $nestedData['profit'] . '",';
                $output1 .= '"' .    $nestedData['loss'] . '",';
                $output1 .= '"' .    $nestedData['company_earn'] . '",';
                $output1 .= "\n";
            }
        }
        $filename =  "use_wise_report.csv";
        header('Content-type: application/csv');
        header('Content-Disposition: attachment; filename=' . $filename);
        echo $output1;
        exit;
    }

    public function profitlossreport(Request $request)
    {
        $data = [];
        $formData = Input::all();
        if ($request->isMethod('post')) {

            $columns = array(
                0 => 'id',
                1 => 'start_date',
                2 => 'company_loss',
                3 => 'company_earn',
                //  4 => 'promocodeamount',
                5 => 'affiliation_commission',
                6 => 'bot_loss',
                7 => 'total_investment',
                8 => 'total_winning',
            );
            $limit = $request->input('length');
            $start = $request->input('start');
            $order = $columns[$request->input('order.0.column')];
            $dir = $request->input('order.0.dir');

            $query =    DB::table('listmatches')
                ->join('leaugestransactions as lt', 'lt.matchkey', '=', 'listmatches.matchkey')
                ->leftJoin('refunds', function ($join) {
                    $join->on('refunds.joinid', '=', 'lt.joinid')
                        ->whereNotIn('refunds.reason', ['Winning reversed', 'Winning reversed point issue']);
                })
                ->whereNull('refunds.joinid')

                ->where('listmatches.launch_status', 'launched')
                ->where('listmatches.final_status', 'winnerdeclared')
                //->where('lt.user_id',2)
                ->select('listmatches.matchkey', 'listmatches.start_date')
                //	->select(DB::raw('DATE_FORMAT(listmatches.start_date, "%Y-%m-%d") as formatted_dob'))
                ->selectRaw('count(lt.id) as joincontest')
                ->selectRaw('sum(lt.bonus) as bonus')
                ->selectRaw('sum(lt.winning) as winning')
                ->selectRaw('sum(lt.balance) as balance');
            if (request()->has('start_date') && request()->has('end_date')) {

                $start_date = request('start_date');
                $end_date = request('end_date');
                if ($start_date != "") {
                    $query->where("listmatches.start_date", '>=', date("Y-m-d 00:00:00", strtotime($start_date)));
                }
                if ($end_date != "") {
                    $query->where("listmatches.start_date", '<=', date("Y-m-d 23:59:59", strtotime($end_date)));
                }
            }
            // ->where(function ($query) use ($formData) {
            // 	if (!empty($formData['start_date']) || !empty($formData['end_date']) ) {
            // 		if(@$formData['start_date'] != "")
            // 		$query->where("listmatches.start_date",'>=', date("Y-m-d 00:00:00", strtotime($formData['start_date'])) );
            // 		if(@$formData['end_date'] != "")
            // 		$query->where("listmatches.start_date",'<=', date("Y-m-d 23:59:59", strtotime($formData['end_date'])) );
            // 	}
            // })
            $query->orderBy('listmatches.start_date', 'DESC')
                ->groupBy('listmatches.matchkey');
            $totalTitles = $query->get()->count();
            $totalFiltered = $totalTitles;
            $titles = $query->offset($start)
                ->limit($limit)
                ->orderBy($order, $dir)
                ->get();


            $query =    DB::table('user_promo');
            if (request()->has('start_date') && request()->has('end_date')) {
                $start_date = request('start_date');
                $end_date = request('end_date');
                if ($start_date != "") {
                    $query->where("created", '>=', date("Y-m-d 00:00:00", strtotime($start_date)));
                }
                if ($end_date != "") {
                    $query->where("created", '<=', date("Y-m-d 23:59:59", strtotime($end_date)));
                }
            }
            $promoamount =    $query->where('status', 1)
                ->sum('amount');

            $userid =    DB::table('registerusers')->where('is_bot', 1)->select('id')->pluck('id');
            if (!empty($titles)) {
                $count = 1;
                foreach ($titles as $title) {
                    $nestedData['id'] = $count;
                    $nestedData['start_date'] = $title->start_date;
                    $totalwinning = DB::table('finalresults')->where('matchkey', $title->matchkey)->sum('amount');

                    $botamount = DB::table('matchchallenges')
                        ->where('matchkey', $title->matchkey)
                        ->where('is_manual_bot', 1)->select('win_amount')
                        ->first();
                    $giveawayamount =    DB::table('finalresults')->where('matchkey', $title->matchkey)->whereIn('userid', $userid)->select('amount')
                        ->sum('amount');
                    $nestedData['bot_loss'] = @$botamount->win_amount -    $giveawayamount;

                    $nestedData['total_investment'] = number_format($title->balance + $title->winning, 2);
                    $nestedData['total_winning'] = $totalwinning;
                    $company_earn = 0;

                    $affiliationTotalamount =    DB::table('league_refer_bonus')->where('matchkey', $title->matchkey)->select('league_refer_bonus.amount')
                        ->sum('league_refer_bonus.amount');
                    $Affiliation =    number_format($affiliationTotalamount, 2);
                    $nestedData['affiliation_commission'] =    $Affiliation;
                    $nestedData['company_loss'] = 0;
                    $nestedData['company_earn'] = 0;
                    if ($totalwinning >= $title->balance + $title->winning) {
                        $company_earn = ($title->balance + $title->winning - $totalwinning);
                        $nestedData['company_loss'] = number_format($affiliationTotalamount - $company_earn, 2);
                    }

                    if ($totalwinning <= ($title->balance + $title->winning)) {
                        $company_earn = (($title->balance + $title->winning) - $totalwinning);
                        $nestedData['company_earn'] = number_format($company_earn - $affiliationTotalamount, 2);
                    }



                    $data[] = $nestedData;
                    $count++;
                }
            }

            $json_data = array(
                "draw" => intval($request->input('draw')),
                "recordsTotal" => intval($totalFiltered),
                "recordsFiltered" => intval($totalFiltered),
                "data" => $data,
            );
            echo json_encode($json_data);
            exit;
        }

        $query =    DB::table('listmatches')
            ->join('leaugestransactions as lt', 'lt.matchkey', '=', 'listmatches.matchkey')
            ->leftJoin('refunds', function ($join) {
                $join->on('refunds.joinid', '=', 'lt.joinid')
                    ->whereNotIn('refunds.reason', ['Winning reversed', 'Winning reversed point issue']);
            })
            ->whereNull('refunds.joinid')

            ->where('listmatches.launch_status', 'launched')
            ->where('listmatches.final_status', 'winnerdeclared')
            ->select('listmatches.matchkey', 'listmatches.start_date')
            ->selectRaw('count(lt.id) as joincontest')
            ->selectRaw('sum(lt.bonus) as bonus')
            ->selectRaw('sum(lt.winning) as winning')
            ->selectRaw('sum(lt.balance) as balance');
        if (isset($_GET['start_date']) && isset($_GET['end_date'])) {

            $start_date = $_GET['start_date'];
            $end_date = $_GET['end_date'];
            if ($start_date != "") {
                $query->where("listmatches.start_date", '>=', date("Y-m-d 00:00:00", strtotime($start_date)));
            }
            if ($end_date != "") {
                $query->where("listmatches.start_date", '<=', date("Y-m-d 23:59:59", strtotime($end_date)));
            }
        }

        $query->orderBy('listmatches.start_date', 'DESC')
            ->groupBy('listmatches.matchkey');
        $totalTitles = $query->get();

        $userid =    DB::table('registerusers')->where('is_bot', 1)->select('id')->pluck('id');
        $query =    DB::table('user_promo');
        if (isset($_GET['start_date']) && isset($_GET['end_date'])) {
            $start_date = $_GET['start_date'];
            $end_date = $_GET['end_date'];
            if ($start_date != "") {
                $query->where("Created", '>=', date("Y-m-d 00:00:00", strtotime($start_date)));
            }
            if ($end_date != "") {
                $query->where("Created", '<=', date("Y-m-d 23:59:59", strtotime($end_date)));
            }
        }
        $promoamount =    $query->where('status', 1)
            ->sum('amount');
        $totalloss = 0;
        $totalprofit = 0;
        $totalaff = 0;
        $totalbotloss = 0;
        foreach ($totalTitles as $key => $title) {
            $totalwinning = DB::table('finalresults')->where('matchkey', $title->matchkey)->sum('amount');

            $botamount = DB::table('matchchallenges')
                ->where('matchkey', $title->matchkey)
                ->where('is_manual_bot', 1)->select('win_amount')
                ->first();
            $giveawayamount =    DB::table('finalresults')->where('matchkey', $title->matchkey)->whereIn('userid', $userid)->select('amount')
                ->sum('amount');
            $nestedData['bot_loss'] = @$botamount->win_amount -    $giveawayamount;

            $nestedData['total_investment'] = number_format($title->balance + $title->winning, 2);
            $nestedData['total_winning'] = $totalwinning;
            $company_earn = 0;

            $affiliationTotalamount =    DB::table('league_refer_bonus')->where('matchkey', $title->matchkey)->select('league_refer_bonus.amount')
                ->sum('league_refer_bonus.amount');

            $nestedData['company_loss'] = 0;
            $nestedData['company_earn'] = 0;
            if ($totalwinning >= $title->balance + $title->winning) {
                $company_earn = ($title->balance + $title->winning - $totalwinning);
                $nestedData['company_loss'] = $affiliationTotalamount - $company_earn;
            }

            if ($totalwinning <= ($title->balance + $title->winning)) {
                $company_earn = (($title->balance + $title->winning) - $totalwinning);
                $nestedData['company_earn'] = $company_earn - $affiliationTotalamount;
            }
            $totalloss = $totalloss + $nestedData['company_loss'];
            $totalprofit = $totalprofit + $nestedData['company_earn'];
            $totalaff =    $totalaff + $affiliationTotalamount;
            $totalbotloss = $totalbotloss + $nestedData['bot_loss'];
        }
        return view("admin.$this->model.company_profit_loss", compact('totalloss', 'totalprofit', 'totalaff', 'totalbotloss', 'promoamount'));
    }

    public function profitlossreportDownload(Request $request)
    {
        $output1 = "";
        $output1 .= '"Date",';
        $output1 .= '"Company Loss",';
        $output1 .= '"Company Profit",';
        $output1 .= '"Affiliation Commission",';
        $output1 .= '"Bot Loss",';
        $output1 .= '"Total Investment",';
        $output1 .= '"Total Winning",';
        $output1 .= "\n";

        $query =    DB::table('listmatches')
            ->join('leaugestransactions as lt', 'lt.matchkey', '=', 'listmatches.matchkey')
            ->leftJoin('refunds', function ($join) {
                $join->on('refunds.joinid', '=', 'lt.joinid')
                    ->whereNotIn('refunds.reason', ['Winning reversed', 'Winning reversed point issue']);
            })
            ->whereNull('refunds.joinid')
            ->where('listmatches.launch_status', 'launched')
            ->where('listmatches.final_status', 'winnerdeclared')
            ->select('listmatches.matchkey', 'listmatches.start_date')
            ->selectRaw('count(lt.id) as joincontest')
            ->selectRaw('sum(lt.bonus) as bonus')
            ->selectRaw('sum(lt.winning) as winning')
            ->selectRaw('sum(lt.balance) as balance');

        if (isset($_GET['start_date']) && isset($_GET['end_date'])) {

            $start_date = $_GET['start_date'];
            $end_date = $_GET['end_date'];
            if ($start_date != "") {
                $query->where("listmatches.start_date", '>=', date("Y-m-d 00:00:00", strtotime($start_date)));
            }
            if ($end_date != "") {
                $query->where("listmatches.start_date", '<=', date("Y-m-d 23:59:59", strtotime($end_date)));
            }
        }
        $query1 =    $query->orderBy('listmatches.start_date', 'DESC')
            ->groupBy('listmatches.matchkey')
            ->get();

        $userid =    DB::table('registerusers')->where('is_bot', 1)->select('id')->pluck('id');
        if (!empty($query1)) {
            foreach ($query1 as $get) {
                $totalwinning = DB::table('finalresults')->where('matchkey', $get->matchkey)->sum('amount');

                $botamount = DB::table('matchchallenges')
                    ->where('matchkey', $get->matchkey)
                    ->where('is_manual_bot', 1)->select('win_amount')
                    ->first();
                $giveawayamount =    DB::table('finalresults')->where('matchkey', $get->matchkey)->whereIn('userid', $userid)->select('amount')
                    ->sum('amount');
                $nestedData['bot_loss'] = @$botamount->win_amount -    $giveawayamount;

                $nestedData['total_investment'] = number_format($get->balance + $get->winning, 2);
                $nestedData['total_winning'] = $totalwinning;


                $affiliationTotalamount =    DB::table('league_refer_bonus')->where('matchkey', $get->matchkey)->select('league_refer_bonus.amount')
                    ->sum('league_refer_bonus.amount');
                $Affiliation =    number_format($affiliationTotalamount, 2);

                $nestedData['company_loss'] = 0;
                $nestedData['company_earn'] = 0;
                if ($totalwinning >= $get->balance + $get->winning) {
                    $company_earn = ($get->balance + $get->winning - $totalwinning);
                    $nestedData['company_loss'] = number_format($affiliationTotalamount - $company_earn, 2);
                }

                if ($totalwinning <= ($get->balance + $get->winning)) {
                    $company_earn = (($get->balance + $get->winning) - $totalwinning);
                    $nestedData['company_earn'] = number_format($company_earn - $affiliationTotalamount, 2);
                }


                $output1 .= '"' . $get->start_date . '",';
                $output1 .= '"' . $nestedData['company_loss'] . '",';
                $output1 .= '"' .    $nestedData['company_earn'] . '",';
                $output1 .= '"' .    $Affiliation . '",';
                $output1 .= '"' .    $nestedData['bot_loss'] . '",';
                $output1 .= '"' .    $nestedData['total_investment'] . '",';
                $output1 .= '"' .    $nestedData['total_winning'] . '",';
                $output1 .= "\n";
            }
        }
        $filename =  "use_wise_report.csv";
        header('Content-type: application/csv');
        header('Content-Disposition: attachment; filename=' . $filename);
        echo $output1;
        exit;
    }


    //End Function
    public function wrongbalance()
    { //die;

        $user = DB::table('registerusers')->where('is_bot', 1)
            //	->join('userbalances','userbalances.user_id','=','registerusers.id')
            //	->whereNull('registerusers.mobile')
            ->limit(60)
            // ->select('registerusers.id','userbalances.user_id','registerusers.email','registerusers.mobile')
            ->get();

        foreach ($user as $key => $value) {
            // DB::table('userbalances')->where('user_id',$value->id)->delete();

        }

        $array = array('4000000000', '4000000001', '4000000002', '4000000003', '4000000004', '4000000005', '4000000006', '4000000007', '4000000008', '4000000009', '4000000010', '4000000011', '4000000012', '4000000013', '4000000014', '4000000015', '4000000016', '4000000017', '4000000018', '4000000019', '4000000020', '4000000021', '4000000022', '4000000023', '4000000024', '4000000025', '4000000026', '4000000027', '4000000028', '4000000029', '4000000030', '4000000031', '4000000032', '4000000033', '4000000034', '4000000035', '4000000036', '4000000037', '4000000038', '4000000039', '4000000040', '4000000041', '4000000042', '4000000043', '4000000044', '4000000045', '4000000046', '4000000047', '4000000048', '4000000049', '4000000050', '4000000051', '4000000052', '4000000053', '4000000054', '4000000055', '4000000056', '4000000057', '4000000058', '4000000059');

        foreach ($user as $key => $value) {

            $array2 = array('mobile' => $array[$key], 'password' => '$2y$10$CI2/sYK5HF3czH1yqeiHC.kTQEp4qccqGis47FGKh2L1IWYjPX8r6');

            //	DB::table('registerusers')->where('id',$value->id)->update($array2);
            $cehck =    DB::table('userbalances')->where('user_id', $value->id)->first();

            if (empty($cehck)) {
                $array2 = array('user_id' => $value->id, 'balance' => 00);
                DB::table('userbalances')->insert($array2);
            } else {
                $array2 = array('user_id' => $value->id, 'balance' => 00);
                DB::table('userbalances')->where('user_id', $value->id)->update($array2);
            }
        }

        dd($user);




        ini_set('memory_limit', '-1');

        $current_date = date('Y-m-d H:i:s');
        $date_before_thirty_days = date('Y-m-d', strtotime('-30 days'));
        $date_exclude = date('Y-m-d', strtotime('-29 days'));
        //new query
        $bonus_txns = DB::table('transactions')
            ->select(
                'userid',
                DB::raw('SUM(CASE
                      WHEN created_at LIKE "' . $date_before_thirty_days . '%"
                      THEN amount
                      ELSE 0
                  END) as total_amount'),
                DB::raw('SUM(CASE
                      WHEN created_at >= "' . $date_exclude . ' 00:00:00"
                      AND created_at < "' . $current_date . '"
                      THEN amount
                      ELSE 0
                  END) as ignore_amount')
            )
            ->whereIn('type', [
                'SIGN UP BONUS (Valid For 30 Days)',
                'REFER BONUS AMOUNT (Valid For 30 Days)'
            ])
            ->groupBy('userid')
            ->havingRaw('total_amount > 0 OR ignore_amount > 0')
            ->get();

        $txn_log = [];
        $bonus_deduct_log = [];
        $count = 0;
        $dedcucttype = 'Bonus';

        DB::beginTransaction();
        try {
            if (!$bonus_txns->isEmpty()) {
                foreach ($bonus_txns as $v) {
                    $user_id = $v->userid;

                    $userBalance = DB::table('userbalances')->where('user_id', $user_id)->first();

                    if (!$userBalance) {
                        echo "User balance not found for user ID: $user_id";
                        continue;
                    }

                    if ($userBalance->bonus != 0) {

                        $deductable_amt = 0;
                        if ($v->ignore_amount > 0) {

                            $ignore_amt = $v->ignore_amount;

                            $deductable_amt = $userBalance->bonus - $ignore_amt;
                        } else {
                            if ($v->total_amount > $userBalance->bonus) {
                                $deductable_amt = $userBalance->bonus;
                            } else {
                                $deductable_amt = $v->total_amount;
                            }
                        }

                        if ($deductable_amt > 0) {
                            $obj['bonus'] = $userBalance->bonus - $deductable_amt;
                            DB::table('userbalances')->where('user_id', $user_id)->update($obj);


                            $userBalances = DB::table('userbalances')->where('user_id', $user_id)->first();


                            $trans_id = 'PlaynWin11-BONUSEXP' . time() . '' . $user_id;
                            $txn_log[$count] = [
                                'userid' => $user_id,
                                'type' => "Bonus Expired",
                                'transaction_id' => $trans_id,
                                'transaction_by' => "wallet",
                                'amount' =>  $deductable_amt,
                                'paymentstatus' => "confirmed",
                                'bal_bonus_amt' => $userBalances->bonus,
                                'bal_win_amt' => $userBalances->winning,
                                'bal_fund_amt' => $userBalances->balance,
                                'cons_bonus' => $deductable_amt,
                                'cons_win' =>  0,
                                'cons_amount' => 0,
                                'total_available_amt' => $userBalances->balance + $userBalances->winning + $userBalances->bonus,
                            ];

                            $bonus_deduct_log[$count] = [
                                'user_id' => $user_id,
                                'deduct_amt' => $deductable_amt,
                                'available_bonus' => $userBalances->bonus,
                                'created_date' => $current_date,
                            ];

                            $count++;
                        }
                    }
                }

                try {
                    DB::table('transactions')->insert($txn_log);
                } catch (\Illuminate\Database\QueryException $ex) {
                    dd($ex->getMessage());
                }

                try {
                    DB::table('bonus_deduct_log')->insert($bonus_deduct_log);
                } catch (\Illuminate\Database\QueryException $ex) {
                    dd($ex->getMessage());
                }
            }

            // Commit the transaction
            DB::commit();
        } catch (\Exception $e) {
            // Rollback the transaction in case of any error
            DB::rollBack();
            echo "Error: " . $e->getMessage();
        }
    }

    public function updatePendingPhonepayStatus()
    {

        date_default_timezone_set("Asia/Kolkata");
        $prev_date = Carbon::now()->subMinutes(5)->format("Y-m-d H:i:s");

        $phonepayPendingData = DB::table('transactions')
            ->where('type', 'Add Fund')
            ->where('transaction_by', 'PHONEPAY')
            ->where('paymentstatus', 'pending')
            ->where('updated_at', '<', $prev_date)
            ->where('updated_at', '>', date("Y-m-d 00:00:00", strtotime("-10 days")))
            ->select('id', 'transaction_id', 'updated_at')
            ->orderBy('updated_at', 'desc')
            ->limit(1)
            ->get();

        //echo "<pre>"; print_r($phonepayPendingData); die;

        if (!empty($phonepayPendingData)) {
            foreach ($phonepayPendingData as $key => $value) {
                // echo 'yes';
                $this->checkPaymentStatus($value->transaction_id);
            }
        }
    }

    public function checkPaymentStatus($return_transaction_id)
    {

        date_default_timezone_set("Asia/Kolkata");

        $transaction_row = DB::table('transactions')
            ->where('type', 'Add Fund')
            ->where('transaction_id', $return_transaction_id)
            ->where('transaction_by', 'PHONEPAY')
            ->where('paymentstatus', 'pending')->first();
        //print_r($transaction_row); exit;

        if (!empty($transaction_row)) {
            DB::table('transactions')->where('id', $transaction_row->id)->update(array('updated_at' => date('Y-m-d H:i:s')));
            // call to check status api to check transaction status
            $finalresult = $this->checkStatusApi($return_transaction_id);
            $finalresult    = json_decode($finalresult);
            $paymentStatus = $finalresult->code;
            $orderId = $txnid = $finalresult->data->merchantTransactionId;
            $orderAmount =  ($finalresult->data->amount) / 100;
            $txStatus = $finalresult->data->responseCode;
            $paymentId =  $finalresult->data->transactionId;
            $GST_ORDER_ID = 'GST-' . $orderId;
            $signature = '';
            print_r($finalresult);
            exit;

            $amount = $orderAmount;
            $TotalOrderAmount  = $orderAmount;
            $add_Fund     = round(($orderAmount / 128) * 100, 2);
            $GSTAmount    = round($orderAmount - $add_Fund, 2);
            $OrderAmount = $add_Fund;

            if (1) {
                if ($paymentStatus == 'PAYMENT_SUCCESS') {
                    $add_fund_respose = array(
                        "transaction_id" => $orderId,
                        "sonicpay_id" => $paymentId,
                        "amount" => $orderAmount,
                        "sonic_status" => $txStatus,
                        "Response" => json_encode($request->all()),
                    );
                    try {
                        DB::table('sonicpay_add_fund_respose')->insert($add_fund_respose);
                    } catch (\Exception $e) {
                        echo   $e->getMessage();
                        exit;
                    }

                    $transaction_row = DB::table('transactions')->where('transaction_id', $orderId)->where('paymentstatus', 'pending')->first();

                    if (!empty($transaction_row)) {


                        $userBalance1 = DB::table('userbalances')->where('user_id', $transaction_row->userid)->first();
                        if (empty($userBalance1)) {
                            DB::table('userbalances')->insert(['user_id' => $transaction_row->userid]);
                        }
                        $userBalance1 = DB::table('userbalances')->where('user_id', $transaction_row->userid)->first();

                        $updatetrans = array(
                            'paymentstatus' => 'confirmed',
                            'phonepay_id' => $paymentId,
                            'bal_gst_bonus_amt' => $userBalance1->gst_bonus,
                            'bal_bonus_amt' => $userBalance1->bonus,
                            'bal_win_amt' => $userBalance1->winning,
                            'bal_fund_amt' => $userBalance1->balance,
                            'bal_affi_amt' => $userBalance1->affiliation_commission,
                            'addfund_amt' => $transaction_row->amount,
                            'total_available_amt' => $userBalance1->bonus + $userBalance1->gst_bonus + $userBalance1->winning + $userBalance1->balance + $userBalance1->affiliation_commission + $transaction_row->amount,
                        );

                        DB::table('transactions')->where('id', $transaction_row->id)->where('transaction_id', $orderId)->update($updatetrans);
                        //TDS Calculation
                        // $session_year = date("Y");
                        $session_year = Helpers::getCurrentSessionYear();
                        // if(date("Y-m-d H:i:s") > '2024-03-31 23:59:59')
                        // {
                        //   $session_year = "2024";
                        // }
                        $registerusers_session = DB::table("registerusers_session")
                            ->where("user_id", $transaction_row->userid)
                            ->where("session_year", $session_year)
                            ->first();
                        if (empty($registerusers_session)) {
                            DB::table("registerusers_session")->insert([
                                "session_year" => $session_year,
                                "user_id" => $transaction_row->userid,
                            ]);
                            sleep(1);
                            $registerusers_session = DB::table("registerusers_session")
                                ->where("user_id", $transaction_row->userid)
                                ->where("session_year", $session_year)
                                ->first();
                        }
                        $amount = $orderAmount;
                        $add_Fund     = round(($amount / 128) * 100, 2);
                        $GSTAmount    = round($orderAmount - $add_Fund, 2);
                        $gstamount =  $GSTAmount;

                        DB::table("registerusers_session")
                            ->where("id", $registerusers_session->id)
                            ->update([
                                "total_deposit" => $registerusers_session->total_deposit + $transaction_row->amount
                            ]);

                        $user_id = $getdata['userid'] = $transaction_row->userid;

                        $add_Fund     = round(($amount / 128) * 100, 2);
                        $userBalance = DB::table('userbalances')->where('user_id', $user_id)->first();
                        $userdata = DB::table('registerusers')->where('id', $getdata['userid'])->first();
                        $referid = $userdata->refer_id;
                        $userBalanceReffred = DB::table('userbalances')->where('user_id', $referid)->first();
                        $referdata = DB::table('registerusers')->where('id', $referid)->where('refer_to_join', 0)->first();
                        /* Insert IN Bonus */
                        $promo = DB::table('user_promo')->where('user_id', $user_id)->orderBy('id', 'DESC')->first();

                        $bonusAmount = 0;
                        $first_deposit = 0;
                        $add_fund_count = 0;
                        $promocode = "";

                        //FEFER BONUS AMOUNT
                        $is_code_exist = RegisterUser::where('id', $transaction_row->userid)->first();
                        if (!empty($is_code_exist) && $is_code_exist->refer_to_join != 1) {
                            if (1) {
                                $refer_bal = DB::table('userbalances')->where('user_id', $is_code_exist->id)->first();
                                $bns_amt['bonus'] = $refer_bal->bonus + 250;
                                // DB::table('userbalances')->where('user_id', $is_code_exist->id)->update($bns_amt);
                                // DB::table('registerusers')->where('id',$referid)->update(['refer_to_join'=>1]);
                                $trans = DB::table('transactions');
                                $ins_tran['userid'] = $is_code_exist->id;
                                $ins_tran['refer_id'] = $transaction_row->userid;
                                $ins_tran['transaction_id'] = BRAND['name'] . '-Refer-' . time();
                                $ins_tran['type'] = 'Refer Bonus';
                                $ins_tran['transaction_by'] = BRAND['name'];
                                $ins_tran['paymentstatus'] = CONFIRMED;
                                $ins_tran['total_available_amt'] = $refer_bal->winning + $refer_bal->balance + $refer_bal->bonus;
                                $ins_tran['bal_bonus_amt'] = $refer_bal->bonus;
                                $ins_tran['bonus_amt'] = 250;
                                $ins_tran['amount'] = 250;
                                //$trans->insert($ins_tran);
                            }
                        }

                        $countFund = $trans = DB::table('transactions')->where('userid', $user_id)->where('paymentstatus', 'confirmed')->where('type', 'add fund')->count();
                        if ($countFund == 1) {
                            //  if($add_Fund>=1 && $add_Fund>=5000) {
                            // if($amount>=1 && $amount>=5000) {
                            //   $bonusAmount = 5000;
                            // }
                            if ($amount >= 1 && $amount >= 500) {
                                $bonusAmount = 500;
                            } elseif ($amount >= 1 && $amount < 500) {
                                $bonusAmount = $transaction_row->amount;
                            }
                        }

                        if ($bonusAmount != 0) {
                            // find balance details //
                            $finduser_bal = DB::table('userbalances')->where('user_id', $user_id)->first();
                            if (!empty($finduser_bal)) {
                                $new_total_available_amt = $finduser_bal->balance + $finduser_bal->winning + $finduser_bal->bonus + $finduser_bal->gst_bonus + $finduser_bal->affiliation_commission;
                                $new_bal_fund_amt = $finduser_bal->balance;
                                $new_bal_win_amt = $finduser_bal->winning;
                                $new_bal_bonus_amt = $finduser_bal->bonus;
                                $new_bal_gst_bonus_amt = $finduser_bal->gst_bonus;
                                $new_bal_affi_amt = $finduser_bal->affiliation_commission;
                                // $datainseert2['user_id'] = $user_id;
                                // $datainseert2['refer_id']= $referid;
                                // $datainseert['balance'] = $userBalance->balance+$amount;

                                $datainseert2['bonus'] = $finduser_bal->bonus + $bonusAmount;

                                // if($promocode != '' && ($promocode == 'GURUJI3' || $promocode == 'GURUJI2' || $promocode == 'GURUJI1' || strtolower($promocode) == 'ganesha' || @$offers->btype == 'deposit')){
                                //   $datainseert2['balance'] = $finduser_bal->balance+$bonusAmount;
                                // }else{
                                //   $datainseert2['bonus'] = $finduser_bal->bonus+$bonusAmount;
                                // }


                                //if($getdata['paymentby']=='cashfree') {
                                if ($first_deposit == 0) //for first deposit
                                {
                                    DB::table('userbalances')->where('user_id', $user_id)->update($datainseert2);
                                }
                                //}
                                $ntxnid = strtoupper(BRAND['name']) . 'BONUS-' . time();
                                $newtransactionsdata['userid'] = $user_id;
                                $newtransactionsdata['type'] = 'Bonus add during add fund';
                                $newtransactionsdata['transaction_id'] = $ntxnid;
                                $newtransactionsdata['transaction_by'] = 'PlaynWin11';
                                $newtransactionsdata['amount'] = $bonusAmount;
                                $newtransactionsdata['bonus_amt'] = $bonusAmount;
                                $newtransactionsdata['paymentstatus'] = 'confirmed';
                                $newtransactionsdata['bal_fund_amt'] = $new_bal_fund_amt;
                                $newtransactionsdata['bal_win_amt'] = $new_bal_win_amt;
                                $newtransactionsdata['bal_bonus_amt'] = $new_bal_bonus_amt + $bonusAmount;
                                $newtransactionsdata['bal_gst_bonus_amt'] = $new_bal_gst_bonus_amt;
                                $newtransactionsdata['bal_affi_amt'] = $new_bal_affi_amt;
                                $newtransactionsdata['total_available_amt'] = $new_total_available_amt + $bonusAmount;
                                //print_r($newtransactionsdata); exit;

                                if ($first_deposit == 0) //for first deposit
                                {
                                    DB::table('transactions')->insert($newtransactionsdata);
                                }
                            }
                        }
                        /* Bonus Credit */
                        /* Insert IN Balance */
                        if (!empty($userBalance)) {
                            $userBalance = DB::table('userbalances')->where('user_id', $user_id)->first();
                            $datainseert['user_id'] = $user_id;
                            $datainseert['refer_id'] = $referid;
                            $datainseert['balance'] = $userBalance->balance + $amount;
                            // $datainseert['bonus'] = $userBalance->bonus+$bonusAmount;
                            DB::table('userbalances')->where('user_id', $getdata['userid'])->update($datainseert);

                            $findlastow = DB::table('userbalances')->where('user_id', $user_id)->first();

                            $add_Fund     = round(($amount / 128) * 100, 2);
                            $GSTAmount    = round($orderAmount - $add_Fund, 2);
                            $gstamount = $GSTAmount;
                            if (!empty($findlastow)) {
                                $total_available_amt = $findlastow->balance + $findlastow->winning + $findlastow->bonus + $findlastow->gst_bonus + $findlastow->affiliation_commission - $gstamount;

                                $bal_fund_amt = $findlastow->balance - $gstamount;
                                $bal_win_amt = $findlastow->winning;
                                $bal_gst_bonus_amt = $findlastow->gst_bonus;
                                $bal_bonus_amt = $findlastow->bonus;
                                $bal_affi_amt = $findlastow->affiliation_commission;
                            }

                            $transactionsdata['userid'] = $user_id;
                            $transactionsdata['paymentstatus'] = 'confirmed';
                            $transactionsdata['type'] = 'GST Deduction as per new government rule';
                            $transactionsdata['transaction_id'] = 'PlaynWin11-GSTDEDUCT-' . rand(0000, 9999) . $user_id;
                            $transactionsdata['transaction_by'] = 'wallet';
                            $transactionsdata['amount'] = $gstamount;
                            $transactionsdata['bal_fund_amt'] = $bal_fund_amt;
                            $transactionsdata['bal_win_amt'] = $bal_win_amt;
                            $transactionsdata['bal_bonus_amt'] = $bal_bonus_amt;
                            $transactionsdata['bal_gst_bonus_amt'] = $bal_gst_bonus_amt;
                            $transactionsdata['bal_affi_amt'] = $bal_affi_amt;
                            $transactionsdata['cons_amount'] = $gstamount;
                            $transactionsdata['total_available_amt'] = $total_available_amt;

                            DB::table('transactions')->insert($transactionsdata);

                            $datainseert['balance'] = $findlastow->balance - $gstamount;
                            DB::table('userbalances')->where('user_id', $getdata['userid'])->update($datainseert);
                            //GST Report
                            $user_data = DB::table('registerusers')->where('id', $user_id)->first();
                            $igst = 0;
                            $cgst = 0;
                            $sgst = 0;
                            if (!empty($user_data) || strtolower($user_data->state) == 'Gujarat') {
                                $igst = 0;
                                $cgst = $gstamount;
                                $sgst = $gstamount;
                            } else {
                                $igst = $gstamount;
                                $cgst = 0;
                                $sgst = 0;
                            }
                            $GST_entry = array(
                                //"league_tran_id"=>$user_id.rand(11,999),
                                "user_id" => $user_id,
                                "deposit_amount" => $amount,
                                "gst_amount" => $gstamount,
                                "wallet_amount" => $amount,
                                "order_id" => $paymentId,
                                "transaction_id" => $transaction_row->id,
                                //"transaction_id"=>$user_id.time().rand(11,99),
                                // "state"=> $user_data->state,
                                "igst" => $igst,
                                "cgst" => $cgst,
                                "sgst" =>  $sgst,
                                "transaction_by" => 'PHONEPAY',
                                "ip" => @$transaction_row->ip,
                                "transactions_date" => date('Y-m-d H:i:s'),
                            );
                            DB::table('deposit_gst')->insert($GST_entry);

                            //GST Rebat
                            $findlastow = DB::table('userbalances')->where('user_id', $user_id)->first();
                            if (!empty($findlastow)) {
                                $total_available_amt = $findlastow->balance + $findlastow->winning + $findlastow->bonus + $findlastow->gst_bonus + $findlastow->affiliation_commission + $gstamount;
                                $bal_fund_amt = $findlastow->balance;
                                $bal_win_amt = $findlastow->winning;
                                $bal_gst_bonus_amt = $findlastow->gst_bonus + $gstamount;
                                $bal_bonus_amt = $findlastow->bonus;
                                $bal_affi_amt = $findlastow->affiliation_commission;
                            }

                            // $transactionsgstrebat['userid'] = $user_id;
                            // $transactionsgstrebat['paymentstatus'] = 'confirmed';
                            // $transactionsgstrebat['type'] = 'GST Real cash rebate from Fantasy World 11';
                            // $transactionsgstrebat['transaction_id'] = 'PlaynWin11-GSTREBAT-' . rand(0000, 9999) . $user_id;
                            // $transactionsgstrebat['transaction_by'] = 'PlaynWin11';
                            // $transactionsgstrebat['amount'] = $gstamount;
                            // $transactionsgstrebat['bal_win_amt'] = $bal_win_amt;
                            // $transactionsgstrebat['bal_bonus_amt'] = $bal_bonus_amt;
                            // $transactionsgstrebat['bal_fund_amt'] = $bal_fund_amt;
                            // $transactionsgstrebat['bal_gst_bonus_amt'] = $bal_gst_bonus_amt;
                            // $transactionsgstrebat['bal_affi_amt'] = $bal_affi_amt;
                            // $transactionsgstrebat['addfund_amt'] = $gstamount;
                            // // $transactionsgstrebat['gst_bonus_amt'] = $gstamount;
                            // $transactionsgstrebat['total_available_amt'] = $total_available_amt;
                            // DB::table('transactions')->insert($transactionsgstrebat);

                            $datainseert['balance'] = $findlastow->balance;
                            $datainseert['gst_bonus'] = $findlastow->gst_bonus;
                            DB::table('userbalances')->where('user_id', $getdata['userid'])->update($datainseert);
                        }


                        //Offer Promo code//

                        if (!empty($promo) && @$promo->status == 0) {
                            $promocode = $promo->promo_code;

                            $offerAmount = 0;
                            if ($promocode != "") {
                                $offers = DB::table('offers')
                                    ->where('code', $promocode)
                                    ->where('minamount', '<=', $amount)
                                    ->where('maxamount', '>=', $amount)
                                    ->where('expire_date', '>=', date('Y-m-d H:i:s'))
                                    ->where('status', 1)->first();

                                //check first deposit
                                if (!empty($offers->first_deposit) && @$offers->first_deposit == 1) {
                                    $user_first_deposit_check = DB::table('transactions')->where('userid', $user_id)->where('type', 'add fund')->where('paymentstatus', 'confirmed')->get();

                                    $add_fund_count = $user_first_deposit_check->count();
                                    if ($add_fund_count > 1) {
                                        $first_deposit = 1;
                                    }
                                }
                                // foreach($offers as $o){
                                if (!empty($offers)) {

                                    $bonusAmount1 = $offers->bonus;
                                    $bonus_type = $offers->bonus_type;
                                    if ($bonus_type == 'rs') {
                                        $offerAmount = $bonusAmount1;
                                    } else {
                                        $offerAmount = (($amount * $bonusAmount1) / 100);
                                    }

                                    if ($offerAmount) {
                                        $usedoffer['offer_id'] = $promocode;
                                        $usedoffer['user_id'] = $user_id;
                                        DB::table('usedoffers')->insert($usedoffer);
                                        DB::table('user_promo')->where('id', $promo->id)->update(array("status" => 1));
                                    }
                                }
                            }


                            if ($offerAmount != 0) {
                                // find balance details //
                                $finduser_bal = DB::table('userbalances')->where('user_id', $user_id)->first();
                                if (!empty($finduser_bal)) {
                                    $new_total_available_amt = $finduser_bal->balance + $finduser_bal->winning + $finduser_bal->bonus + $finduser_bal->gst_bonus + $finduser_bal->affiliation_commission;
                                    $new_bal_fund_amt = $finduser_bal->balance;
                                    $new_bal_win_amt = $finduser_bal->winning;
                                    $new_bal_bonus_amt = $finduser_bal->bonus;
                                    $new_bal_gst_bonus_amt = $finduser_bal->gst_bonus;
                                    $new_bal_affi_amt = $finduser_bal->affiliation_commission;

                                    $bonusAmountoffer1 = 0;
                                    $bonusAmountoffer = 0;
                                    if ($promocode != '' &&  @$offers->btype == 'deposit') {
                                        $datainseert2['balance'] = $finduser_bal->balance + $offerAmount;
                                        $bonusAmountoffer1 = $offerAmount;
                                    } else {
                                        $datainseert2['bonus'] = $finduser_bal->bonus + $offerAmount;
                                        $bonusAmountoffer = $offerAmount;
                                    }

                                    if ($first_deposit == 0) //for first deposit
                                    {
                                        DB::table('userbalances')->where('user_id', $user_id)->update($datainseert2);
                                    }
                                    //}
                                    $ntxnid =  'PlaynWin11-OFFERBONUS-' . time();
                                    $newtransactionsdata['userid'] = $user_id;
                                    $newtransactionsdata['type'] = 'Offer Bonus add during add fund';
                                    $newtransactionsdata['transaction_id'] = $ntxnid;
                                    $newtransactionsdata['transaction_by'] = 'PlaynWin11';
                                    $newtransactionsdata['amount'] = $offerAmount;
                                    $newtransactionsdata['bonus_amt'] = $offerAmount;
                                    $newtransactionsdata['paymentstatus'] = 'confirmed';
                                    $newtransactionsdata['bal_fund_amt'] = $new_bal_fund_amt + $bonusAmountoffer1;
                                    $newtransactionsdata['bal_win_amt'] = $new_bal_win_amt;
                                    $newtransactionsdata['bal_bonus_amt'] = $new_bal_bonus_amt + $bonusAmountoffer;
                                    $newtransactionsdata['bal_gst_bonus_amt'] = $new_bal_gst_bonus_amt;
                                    $newtransactionsdata['bal_affi_amt'] = $new_bal_affi_amt;
                                    $newtransactionsdata['total_available_amt'] = $new_total_available_amt + $offerAmount;

                                    if ($first_deposit == 0) //for first deposit
                                    {
                                        DB::table('transactions')->insert($newtransactionsdata);
                                    }
                                }
                            }
                        }

                        echo json_encode(array("status" => "OK"));
                        exit;
                    } else {
                        echo 0;
                    }
                    echo 'Success';
                } else if ($txStatus == 'Failed' || $txStatus == 'Dropped') {
                    $transaction_row = DB::table('transactions')->where('transaction_id', $orderId)->where('paymentstatus', 'pending')->first();

                    //add history
                    $userBalance = DB::table('userbalances')->where('user_id', @$transaction_row->userid)->first();
                    $updatetrans = array(
                        'paymentstatus' => 'pending',
                        'phonepay_id' => $paymentId,
                        'bonus_amt' => @$userBalance->bonus,
                        'win_amt' => @$userBalance->winning,
                        'addfund_amt' => 0,
                        'total_available_amt' => $userBalance->bonus + $userBalance->winning + $userBalance->balance + @$userBalance->gst_bonus + @$userBalance->affiliation_commission,
                    );

                    DB::table('transactions')->where('id', $transaction_row->id)->where('transaction_id', $orderId)->update($updatetrans);
                    echo 0;
                } else if ($txStatus == 'PENDING') {
                    echo 0;
                }
            } else {
                echo 0;
            }
        }
    }

    public function checkStatusApi($orderId)
    {
        // \Log::info("this is check status api ".$orderId);

        $apiKey = $saltkey  = "949c8603-4d8b-4323-a335-eb1a90f20af0";
        $salt_index      = 1;
        $merchantId      = "PlaynWin11ONLINE";
        $final_x_header  = hash('sha256', "/pg/v1/status/" . $merchantId . "/" . $orderId . $saltkey) . "###" . $salt_index;

        $url              = "https://api.phonepe.com/apis/hermes/pg/v1/status/$merchantId/$orderId";
        $header           =  array(
            "Content-Type:application/json",
            "X-VERIFY:$final_x_header",
            "X-MERCHANT-ID:$merchantId"
        );
        // echo "<pre>"; print_r($header); die;
        $curl = curl_init();
        curl_setopt_array($curl, array(
            CURLOPT_URL => $url,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => "",
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 30,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => "GET",
            CURLOPT_HTTPHEADER => $header
        ));

        $response = curl_exec($curl);
        $err = curl_error($curl);
        curl_close($curl);
        if ($err) {
            echo "cURL Error #:" . $err;
        } else {

            //echo '<pre>';print_r($response); exit;
            //\Log::info("response1 ".$response);
            //   $phonepe_response = json_decode($response, true);
            return $response;
        }
        die;
    }
}
