<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Http\Requests;
use Illuminate\Http\Request;
use App\Model\Challenges;
use Aws\S3\S3Client;
use App\Helpers\Helpers;
use App\Services\Input;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\View;
use Yajra\DataTables\Facades\DataTables;

class ChallengesController extends Controller
{

    /*
	 * Function for display email detail from database
	 *
	 * @param null
	 *
	 * @return view page.
	 */
    public $model    =    'Challenges';

    public function __construct()
    {
        View::share('modelName', $this->model);
    }

    /* -----------------Start Challenges-------------------------------*/
    public function challenges_category()
    {
        $formData = Input::all();
        if (isset($formData) && !empty($formData)) {
            return Datatables::of(DB::table('challenges_category')->get())
                ->addIndexColumn()
                ->addColumn('status', function ($result) {
                    $status = '';
                    if ($result->status == 1) {
                        $status = 'Active';
                    } else {
                        $status = 'Inactive';
                    }
                    return $status;
                })
                ->addColumn('sport_type', function ($result) {
                    return DB::table('sport_types')->where('id', $result->sport_type)->first()->sport_name;
                })
                ->addColumn('action', function ($result) {
                    $status = '';
                    if ($result->status == 0) {
                        $status = '<a href="' . route($this->model . '.update_status_category', [base64_encode(serialize($result->id)), 1]) . '" data-toggle="tooltip" title="Activate" class="btn btn-success mr-1 mt-1 action-users"><i class="fa fa-check-square-o"></i></a>';
                    } else {
                        $status = '<a href="' . route($this->model . '.update_status_category', [base64_encode(serialize($result->id)), 0]) . '" data-toggle="tooltip" title="Deactivate" class="btn btn-danger mr-1 mt-1 action-users"><i class="fa fa-ban"></i></a>';
                    }
                    return '<a href="' . route($this->model . '.category_edit', base64_encode(serialize($result->id))) . '" data-toggle="tooltip" title="" class="btn btn-rg mr-1 mt-1" data-original-title="Edit"><i class="fa fa-pencil mr-2" aria-hidden="true"></i>Edit</a>' . $status;
                })
                ->escapeColumns([])
                ->make(true);
        } //end
        return view("admin.$this->model.categories");
    }

    ///add match challenge
    public function addmatchBots(Request $request, $mKey)
    {
        //Get Current Date
        $currentdate = date('Y-m-d h:i:s');
        $thisMatch = DB::table('listmatches')->where('matchkey', $mKey)->first();

        $assumptionBots = DB::table("bots_teams")->where('matchkey', $mKey)->where('is_lineup', 0)->where('is_used', 0)->count();
        $assumptionBotstenplus = DB::table("bots_teams")->where('matchkey', $mKey)->where('is_lineup', 0)->where('is_used', 0)->where('fantasy_type_id', 7)->count();
        $lineupBots = DB::table("bots_teams")->where('matchkey', $mKey)->where('is_lineup', 1)->where('is_used', 0)->where('fantasy_type_id', 0)->count();
        $lineupBotstenplus = DB::table("bots_teams")->where('matchkey', $mKey)->where('is_lineup', 1)->where('is_used', 0)->where('fantasy_type_id', 7)->count();
        $joinbots = DB::table("matchchallenges")->where('matchkey', $mKey)->where('every_minutes_bots', '!=', 0)->where('number_of_bots', '!=', 0)->select('total_join_bot')->first();

        //Get Challenges Category
        //Show Page
        return view("admin.$this->model.addmatchBots", compact('mKey', 'thisMatch', 'lineupBots', 'assumptionBots', 'lineupBotstenplus', 'assumptionBotstenplus', 'joinbots'));
    } //End Function

    public function addBotsInChallenges($id, Request $request)
    {
        //Get Id

        // Session::flash('flash_notice', 'Successfully updated challenges!');
        // Session::flash('alert-class', 'alert-success');
        // return Redirect::route("$this->model.create_challenge",$challenge->matchkey);

        //Get Challenges Category
        $category = DB::table('challenges_category')->get();
        $challenge = DB::table('matchchallenges')->where('id', $id)->first();
        $mKey = $challenge->matchkey;
        $botsAvailble = DB::table('bots_teams')->where('matchkey', $mKey)->where('is_used', 0)->count();
        $regDB = DB::table('registerusers')->where('is_bot', 1)->pluck('id');
        $botsUsed = DB::table('joinedleauges')->where('challengeid', $id)
            ->whereIn('userid', $regDB)
            ->count();
        $findmatchnames = DB::table('listmatches')->where('matchkey', $challenge->matchkey)->select('listmatches.name', 'listmatches.start_date')->first();

        return view("admin.$this->model.addBotsInChallenges", compact('challenge', 'findmatchnames', 'category', 'botsAvailble', 'botsUsed'));
    }

    public function add_challenges_category(Request $request)
    {
        // dd(CHALLENGE_IMAGE_URL_ROOT_PATH);
        //Get Data
        $formData    =    Input::all();
        if (!empty($formData)) {
            $rules = array(
                'name' => 'required',
                'category_sub_text' => 'required',
                'contest_type_image' => 'required',
                'status' => 'required',
                'sport_type' => 'required',
            );
            $validator = Validator::make(Input::all(), $rules);
            if ($validator->fails()) {
                return Redirect::back()->withErrors($validator)->withInput();
            } else {

                if (empty($formData['is_used_gst_bonus'])) {
                    $formData['is_used_gst_bonus'] = 0;
                }
                $insertData = array(
                    "name" => $formData['name'],
                    "contest_sub_text" => $formData['category_sub_text'],
                    "sort_order" => $formData['sort_order'],
                    "status" => $formData['status'],
                    "sport_type" => $formData['sport_type'],
                    "is_used_gst_bonus" => $formData['is_used_gst_bonus'],
                );

                $file = $request->all();
                if (!empty($file)) {
                    if ($file['base64image'] || $file['base64image'] != '0') {

                        $folderPath = 'uploads/categories/';

                        $image_parts = explode(";base64,", $formData['base64image']);
                        $image_type_aux = explode("image/", $image_parts[0]);

                        if (!isset($image_type_aux[1]) && empty($image_type_aux[1])) {
                            Session::flash('error',  trans("Image failed Please again upload"));
                            return Redirect::back();
                        }
                        $image_type = $image_type_aux[1];

                        $image_base64 = base64_decode($image_parts[1]);
                        // $file = $folderPath . uniqid() . '.png';
                        // $filename = time() . '.'. $image_type;

                        // $filename = BRAND['name'].'-player-'.$image_type;


                        // Generate filename
                        $filename = BRAND['name'] . '-player-' . rand(1000, 9999) . "." . $image_type;
                        $file = $folderPath . $filename;

                        // Save file
                        file_put_contents($file, $image_base64);

                        $fileName =    $this->aws_upload_image(CHALLENGE_IMAGE_URL_ROOT_PATH . $filename, $folderPath, $filename);
                        @unlink('uploads/categories/' . $filename);

                        //$imageName= $this->aws_upload_image($file,$folderPath,$fileName);
                        $insertData['contest_type_image'] = $filename;
                        unset($formData['_token']);
                        DB::table('challenges_category')->insert($insertData);
                        Session::flash('flash_notice', 'Successfully added category!');
                        Helpers::logActivity('Challenges Category added!', $formData['name']);
                        return Redirect::route("$this->model.category");
                    }
                }
            }
        } else {

            // $get_sports=DB::table('sport_types')->Where('sport_name','Cricket')->get();
            $get_sports = DB::table('sport_types')->where('admin_status', 1)->get();
            return view("admin.$this->model.addchallengecategory", compact('get_sports'));
        }
    }

    public function edit_challenge_category($id = null, Request $request)
    {
        // dd(ADVERTISMENTS_PROFILE_IMAGE_ROOT_PATH);
        //Decode Id
        $id = unserialize(base64_decode($id));
        //Get Data
        $formData    =    Input::all();
        //Edit Challenge Category
        if (!empty($formData)) {
            $rules = array(
                'name' => 'required',
                'category_sub_text' => 'required',
                'status' => 'required',
                'sport_type' => 'required',
            );
            $validator = Validator::make(Input::all(), $rules);
            if ($validator->fails()) {
                return Redirect::back()->withErrors($validator)->withInput();
            } else {
                $formData = Input::all();
                //echo '<pre>'; print_r($formData);exit;
                if (empty($formData['is_used_gst_bonus'])) {
                    $formData['is_used_gst_bonus'] = 0;
                }
                $insertData = array(
                    "name" => $formData['name'],
                    "contest_sub_text" => $formData['category_sub_text'],
                    "sort_order" => $formData['sort_order'],
                    "status" => $formData['status'],
                    "sport_type" => $formData['sport_type'],
                    "is_used_gst_bonus" => $formData['is_used_gst_bonus'],
                );

                $input = $request->all();
                // $file = isset($input['base64image']) ? $input['base64image'] : '';

                if ($input['base64image'] || $input['base64image'] != '0') {

                    $folderPath  = 'uploads/categories/';
                    $image_parts = explode(";base64,", $input['base64image']);
                    if ($image_parts[0] === "") {
                        if (Input::hasFile('contest_type_image')) {
                            $extension  =   Input::file('contest_type_image')->getClientOriginalExtension();
                            $img_ext    =   explode(",", IMAGE_EXTENSION);
                            if (in_array($extension, $img_ext)) {;
                                $fileName = BRAND['name'] . '-banner-match-' . rand(1000, 9999) . $extension;
                                if (Input::file('contest_type_image')->move('uploads/categories/', $fileName)) {
                                    $input['contest_type_image']     =   $fileName;
                                }
                                //File::delete($folderPath.'/'.$matchDetail->banner_image);
                                @unlink('uploads/matches/' . $oldimage);
                                Helpers::aws_upload_image(ADVERTISMENTS_PROFILE_IMAGE_ROOT_PATH . $fileName, "uploads/categories/", $fileName);
                            } else {
                                Session::flash('error',  trans("$this->model.INVALID_IMAGE_EXTENSION"));
                                return Redirect::back();
                            }
                        }
                    } else {
                        $image_type_aux = explode("image/", $image_parts[0]);
                        $image_type = $image_type_aux[1];
                        $image_base64 = base64_decode($image_parts[1]);
                        // $file = $folderPath . uniqid() . '.png';
                        $filename           =   BRAND['name'] . '-banner-match-' . rand(1000, 9999) . "." . $image_type;
                        // $filename = time() . '.'. $image_type;
                        $file = $folderPath . $filename;
                        //	$imageName= $this->aws_upload_image($formData,$folderPath,$filename);
                        //	$input['contest_type_image'] = $imageName;
                        //	$input['contest_type_image'] = $filename;

                        file_put_contents($file, $image_base64);
                        $fileName =    $this->aws_upload_image(CHALLENGE_IMAGE_URL_ROOT_PATH . $filename, $folderPath, $filename);
                        @unlink('uploads/categories/' . $filename);

                        $input['contest_type_image'] = $filename;
                    }
                }
                if (!empty($input['contest_type_image'])) {
                    if (!empty($input)) {
                        $input = [
                            'contest_type_image' => $input['contest_type_image'],
                            "name" => $formData['name'],
                            "contest_sub_text" => $formData['category_sub_text'],
                            "sort_order" => $formData['sort_order'],
                            "status" => $formData['status'],
                            "sport_type" => $formData['sport_type'],
                            "is_used_gst_bonus" => $formData['is_used_gst_bonus'],
                        ];
                    }
                } else {
                    $input = [
                        "name" => $formData['name'],
                        "contest_sub_text" => $formData['category_sub_text'],
                        "sort_order" => $formData['sort_order'],
                        "status" => $formData['status'],
                        "sport_type" => $formData['sport_type'],
                        "is_used_gst_bonus" => $formData['is_used_gst_bonus'],
                    ];
                }
                unset($formData['_token']);
                DB::table('challenges_category')->where('id', $id)->update($input);
                Session::flash('flash_notice',  trans("Successfully updated category!"));
                Helpers::logActivity('Challenges Category Updated!', $formData['name']);
                return Redirect::route("$this->model.category");
            }
        }
        $league_info = DB::table('challenges_category')->where('id', $id)->first();
        $get_sports = DB::table('sport_types')->where('admin_status', 1)->get();
        return view("admin.$this->model.editchallengecategory", compact('league_info', 'get_sports'));
    }



    /* ----------------End--------------------------------*/
    /* ----------------Start Global--------------------------------*/
    public function addglobalchallenge()
    {
        $input    =    Input::all();
        //Get Post Val
        //dd($input);
        if (!empty($input)) {
            $rules = array(
                'entryfee' => 'required',
                'win_amount' => 'required',
                'challenge_type' => 'required',
                'challenge_category_id' => 'required',
                'sport_type' => 'required',
                'maximum_user' => 'required',
                'minimum_user' => 'required',
                'bonus_precent' => @$input['bonus'] ? 'required|numeric|min:0' : 'nullable|numeric|min:0',
                'max_team_limit' => @$input['multi_entry'] ? 'required|numeric|min:1' : 'nullable|numeric|min:1',


            );
            $validator = Validator::make(Input::all(), $rules);
            if ($validator->fails()) {
                return Redirect::back()->withErrors($validator)->withInput(Input::except('password'));
            } else {
                if ($input['challenge_type'] == "money") {
                    if ($input['entryfee'] <= $input['win_amount'] &&  $input['win_amount'] >= $input['entryfee']) {
                        $findchallenge = DB::table('challenges')->where('entryfee', $input['entryfee'])->where('win_amount', $input['win_amount'])->where('maximum_user', $input['maximum_user'])->first();
                        unset($input['winning_percentage']);
                    }
                    // else{
                    // 	return back()->with('error', 'win amount less then entry fee');
                    // }
                    if ($input['entryfee'] != 0) {
                        if ($input['entryfee'] <= $input['discount_price']) {
                            return back()->with('error', 'Discount fee less then Entry fee');
                        }
                    }

                    if (isset($input['is_promotor']) && $input['is_promotor'] == 1 && $input['challenge_category_id'] != 17) {
                        return back()->with('error', 'Challenge Category select only Promotor users');
                    }
                } else {
                    $findchallenge = DB::table('challenges')->where('entryfee', $input['entryfee'])->where('win_amount', $input['win_amount'])->where('winning_percentage', $input['winning_percentage'])->first();
                    unset($input['maximum_user']);
                }
                if (Input::hasFile('gadgets_image')) {
                    $extension = Input::file('gadgets_image')->getClientOriginalExtension();
                    $img_ext = explode(",", IMAGE_EXTENSION);

                    if (in_array($extension, $img_ext)) {
                        $destinationPath = 'uploads/players';
                        // $fileName='11caps-player-'.time();
                        $fileName = 'PlaynWin11-gadgets_image-' . rand(10000, 99999);


                        if (Input::file('gadgets_image')->move(ADVERTISMENTS_PROFILE_IMAGE_ROOT_PATH, $fileName)) {
                            $input['gadgets_image'] = $fileName;
                        }
                        Helpers::aws_upload_image(ADVERTISMENTS_PROFILE_IMAGE_ROOT_PATH . $fileName, "uploads/players/", $fileName);
                    } else {
                        Session::flash('error',  trans("messages.$this->model.INVALID_IMAGE_EXTENSION"));
                        return Redirect::back()->withInput();
                    }
                }
                if (!empty($findchallenge)) {
                    // return Redirect::back()->withErrors('This challenge already exits with the same details')->withInput(Input::except('password'));
                }
                unset($input['_token']);
                if (isset($input['multi_entry'])) {
                    $input['multi_entry'] = 1;
                } else {
                    $input['multi_entry'] = 0;
                }
                if ($input['challenge_type'] != "money") {
                    $input['confirmed_challenge'] = 1;
                }
                if (isset($input['bonus']) && !empty($input['bonus']) && $input['bonus'] == 1) {
                    $input['bonus'] = 1;
                    $input['gst_bonus'] = 0;
                } elseif (isset($input['bonus']) && !empty($input['bonus']) && $input['bonus'] == 2) {
                    $input['gst_bonus'] = 1;
                    $input['bonus'] = 0;
                } else {
                    $input['gst_bonus'] = 0;
                    $input['bonus'] = 0;
                }
                if (empty($input['bonus_precent'])) {
                    $input['bonus_precent'] = 0;
                }
                if (empty($input['dis_price'])) {
                    $input['dis_price'] = 0;
                }

                if (empty($input['max_team_limit'])) {
                    //	$input['max_team_limit'] = 2;
                    $input['max_team_limit'] = 1;
                }
                if (isset($input['confirmed_challenge'])) {
                    $input['confirmed_challenge'] = 1;
                } else {
                    $input['confirmed_challenge'] = 0;
                }

                if (isset($input['is_manual_bot'])) {
                    $input['is_manual_bot'] = 1;
                } else {
                    $input['is_manual_bot'] = 0;
                }
                if (isset($input['is_offer_team'])) {
                    $input['is_offer_team'];
                } else {
                    $input['is_offer_team'] = 0;
                }
                if (isset($input['offer_team_no'])) {
                    $input['offer_team_no'];
                } else {
                    $input['offer_team_no'] = 0;
                }

                if (isset($input['is_promotor'])) {
                    $input['is_promotor'];
                } else {
                    $input['is_promotor'] = 0;
                }
                if (isset($input['is_promotor']) && isset($input['promotor_id'])) {
                    $input['promotor_id'] = implode(',', $input['promotor_id']);
                } else {
                    $input['promotor_id'] = 0;
                }
                $entyfee = $input['entryfee'];
                if (isset($input['discount_price']) && $input['discount_price'] > 0) {
                    $input['entryfee'] = $input['discount_price'];
                    $input['real_entry_fees'] = $entyfee;
                    $input['discount_price'] = $input['discount_price'];
                }

                if (!empty($input['is_free_for_referrer'])) {
                    $input['is_free_for_referrer'] = 1;
                } else {
                    $input['is_free_for_referrer'] = 0;
                }
                if (isset($input['is_join_similar_contest'])) {
                    $input['is_join_similar_contest'] = 1;
                } else {
                    $input['is_join_similar_contest'] = 0;
                }
                // if(isset($input['join_similar_contest_limit'])){
                //  $input['join_similar_contest_limit'];
                // }else{
                //  $input['join_similar_contest_limit'] = 0;
                // }

                DB::table('challenges')->insert($input);
                $id = DB::getPdo()->lastInsertId();

                Session::flash('flash_notice', 'Successfully added global challenge!');
                Session::flash('alert-class', 'alert-success');
                return Redirect::route("$this->model.add_pricecard", base64_encode(serialize($id)));
                return Redirect::route("$this->model.view_challenges");
            }
        }
        //Get category
        $category = DB::table('challenges_category')->where('status', 1)->get();
        $sport_types = DB::table('sport_types')->select('id', 'sport_name')->where('admin_status', 1)->get();
        $user_promotor = DB::table('registerusers')->where('player_percentage', '!=', 0)->where('is_yoububer', 1)->select('id', 'email', 'refercode', 'team', 'mobile')->get();

        return view("admin.$this->model.addglobalchallenge", compact('category', 'sport_types', 'user_promotor'));
    }
    public function update_status_category($id, $status)
    {
        $id = unserialize(base64_decode($id));
        $input['id'] = $id;
        $input['status'] = $status;
        $category = DB::table('challenges_category')->where('id', $id)->first();
        if (!empty($category)) {
            DB::table('challenges_category')->where('id', $id)->update($input);
            Session::flash('flash_notice', 'Successfully updated status');
            Session::flash('alert-class', 'alert-success');
            return Redirect::back();
        } else {
            return Redirect::route("$this->model.category");
        }
    }
    //Edit global Challenge
    public function editglobalchallenge($id = null)
    {

        $id = unserialize(base64_decode($id));
        //Get Data
        $challenge = DB::table('challenges')->where('id', $id)->first();
        //Get Post Data
        $input = Input::all();
        //Ckeck Post Value
        if (count($input) > 0) {

            //Set
            $rules = array(
                'entryfee' => 'required',
                'win_amount' => 'required',
                'challenge_type' => 'required',
                'challenge_category_id' => 'required',
                'sport_type' => 'required',
                'maximum_user' => 'required',
                'minimum_user' => 'required',
                'bonus_precent' => $input['bonus'] ? 'required|numeric|min:0' : 'nullable|numeric|min:0',
            );
            $validator = Validator::make(Input::all(), $rules);
            //Ckeck Validation
            if ($validator->fails()) {
                return Redirect::back()->withErrors($validator)->withInput(Input::except('password'));
                //Validation is Comp
            } else {

                if ($input['challenge_type'] == "money") {
                    $findseries = DB::table('challenges')->where('entryfee', $input['entryfee'])->where('win_amount', $input['win_amount'])->where('maximum_user', $input['maximum_user'])->where('id', '!=', $id)->first();
                    unset($input['winning_percentage']);
                } else {
                    $findseries = DB::table('challenges')->where('entryfee', $input['entryfee'])->where('win_amount', $input['win_amount'])->where('winning_percentage', $input['winning_percentage'])->where('id', '!=', $id)->first();
                    unset($input['maximum_user']);
                }

                if (!empty($findseries)) {
                    // return Redirect::back()
                    // ->withErrors('This challenge is already exist.')
                    // ->withInput(Input::except('password'));
                }

                if ($input['entryfee'] != 0) {
                    if ($input['entryfee'] <= $input['discount_price']) {
                        return back()->with('error', 'Discount fee less then Entry fee');
                    }
                }

                if (isset($input['is_promotor']) && $input['is_promotor'] == 1 && $input['challenge_category_id'] != 17) {
                    return back()->with('error', 'Challenge Category select only Promotor users');
                }
                unset($input['_token']);
                if (isset($input['multi_entry'])) {
                    $input['multi_entry'] = 1;
                } else {
                    $input['multi_entry'] = 0;
                }
                if (isset($input['confirmed_challenge'])) {
                    $input['confirmed_challenge'] = 1;
                } else {
                    $input['confirmed_challenge'] = 0;
                }
                if (isset($input['bonus'])) {
                    $input['bonus'] = 1;
                } else {
                    $input['bonus'] = 0;
                }
                if (isset($input['is_running'])) {
                    $input['is_running'] = 1;
                } else {
                    $input['is_running'] = 0;
                }
                if (isset($input['is_flexible'])) {
                    $input['is_flexible'] = 1;
                } else {
                    $input['is_flexible'] = 0;
                }
                if (isset($input['loops'])) {
                    $input['loops'] = 1;
                } else {
                    $input['loops'] = 0;
                }
                if (isset($input['is_offer_team'])) {
                    $input['is_offer_team'];
                } else {
                    $input['is_offer_team'] = 0;
                }
                if (isset($input['offer_team_no'])) {
                    $input['offer_team_no'];
                } else {
                    $input['offer_team_no'] = 0;
                }
                if (isset($input['max_team_limit'])) {
                    $input['max_team_limit'];
                } else {
                    $input['max_team_limit'] = 0;
                }
                if (isset($input['is_join_similar_contest'])) {
                    $input['is_join_similar_contest'] = 1;
                } else {
                    $input['is_join_similar_contest'] = 0;
                }
                if (!empty($input['is_free_for_referrer'])) {
                    $input['is_free_for_referrer'] = 1;
                } else {
                    $input['is_free_for_referrer'] = 0;
                }


                if (isset($input['is_promotor'])) {
                    $input['is_promotor'];
                } else {
                    $input['is_promotor'] = 0;
                }
                if (isset($input['is_promotor']) && isset($input['promotor_id'])) {
                    $input['promotor_id'] = implode(',', $input['promotor_id']);
                } else {
                    $input['promotor_id'] = 0;
                }

                if (isset($input['is_manual_bot'])) {
                    $input['is_manual_bot'] = 1;
                } else {
                    $input['is_manual_bot'] = 0;
                }
                if ($input['challenge_type'] != "money") {
                    $input['confirmed_challenge'] = 1;
                }

                // image Upload //
                if (Input::hasFile('gadgets_image')) {
                    $extension = Input::file('gadgets_image')->getClientOriginalExtension();
                    $img_ext = explode(",", IMAGE_EXTENSION);

                    if (in_array($extension, $img_ext)) {
                        $destinationPath = 'uploads/players';
                        // $fileName='11caps-player-'.time();
                        $fileName = 'PlaynWin11-gadgets_image-' . rand(10000, 99999);

                        if (Input::file('gadgets_image')->move(ADVERTISMENTS_PROFILE_IMAGE_ROOT_PATH, $fileName)) {
                            $input['gadgets_image'] = $fileName;
                        }
                        Helpers::aws_upload_image(ADVERTISMENTS_PROFILE_IMAGE_ROOT_PATH . $fileName, "uploads/players/", $fileName);
                    } else {
                        Session::flash('error',  trans("messages.$this->model.INVALID_IMAGE_EXTENSION"));
                        return Redirect::back()->withInput();
                    }
                }
                // unset($input['gadgets_image']);

                //image Upload //


                $entyfee = $input['entryfee'];
                if (isset($input['discount_price']) && $input['discount_price'] > 0) {
                    $input['entryfee'] = $input['discount_price'];
                    $input['real_entry_fees'] = $entyfee;
                }

                //echo '<pre>';print_r($input);die;
                $rowCOllection = DB::table('challenges')->where('id', $id)->update($input);
                Session::flash('flash_notice', 'Successfully updated challenges!');
                Helpers::logActivity('Global Challenge Updated!');
                Session::flash('alert-class', 'alert-success');
                return Redirect::route("$this->model.view_challenges");
            }
        }
        if (!empty($challenge)) {
            $challenges_category = DB::table('challenges_category')->where('status', 1)->get();

            $challenge = array(
                "challenge" => $challenge,
                "challenges_category" => $challenges_category
            );

            $sport_types = DB::table('sport_types')->select('id', 'sport_name')->where('admin_status', 1)->get();

            $user_promotor = DB::table('registerusers')->where('player_percentage', '!=', 0)->where('is_yoububer', 1)->select('id', 'email', 'refercode', 'team', 'mobile')->get();
            $user_addcheck = DB::table('challenges')->where('id', $id)->select('promotor_id')->first();
            $is_setuserid = array();
            if (!empty($user_addcheck)) {
                $is_setuserid =    explode(',', $user_addcheck->promotor_id);
            }
            return view("admin.$this->model.editglobalchallenge", compact('sport_types', 'challenge', 'user_promotor', 'is_setuserid'));
        } else {
            return Redirect::route("$this->model.view_challenges")->withErrors('Invalid Id Provided');
        }
    }
    //Edit global Challenge
    public function editglobalchallenge_old($id = null)
    {
        $id = unserialize(base64_decode($id));
        //Get Data
        $challenge = DB::table('challenges')->where('id', $id)->first();
        //Get Post Data
        $input = Input::all();
        //Ckeck Post Value
        if (count($input) > 0) {
            //Set
            $rules = array(
                'entryfee' => 'required',
                'win_amount' => 'required',
                'challenge_type' => 'required',
                'challenge_category_id' => 'required',
            );
            $validator = Validator::make(Input::all(), $rules);
            //Ckeck Validation
            if ($validator->fails()) {
                return Redirect::back()->withErrors($validator)->withInput(Input::except('password'));
                //Validation is Comp
            } else {

                if ($input['challenge_type'] == "money") {
                    $findseries = DB::table('challenges')->where('entryfee', $input['entryfee'])->where('win_amount', $input['win_amount'])->where('maximum_user', $input['maximum_user'])->where('id', '!=', $id)->first();
                    unset($input['winning_percentage']);
                } else {
                    $findseries = DB::table('challenges')->where('entryfee', $input['entryfee'])->where('win_amount', $input['win_amount'])->where('winning_percentage', $input['winning_percentage'])->where('id', '!=', $id)->first();
                    unset($input['maximum_user']);
                }

                if (!empty($findseries)) {
                    // return Redirect::back()
                    // ->withErrors('This challenge is already exist.')
                    // ->withInput(Input::except('password'));
                }

                unset($input['_token']);
                if (isset($input['multi_entry'])) {
                    $input['multi_entry'] = 1;
                } else {
                    $input['multi_entry'] = 0;
                }
                if (isset($input['confirmed_challenge'])) {
                    $input['confirmed_challenge'] = 1;
                } else {
                    $input['confirmed_challenge'] = 0;
                }
                if (isset($input['bonus'])) {
                    $input['bonus'] = 1;
                } else {
                    $input['bonus'] = 0;
                }
                if (isset($input['is_running'])) {
                    $input['is_running'] = 1;
                } else {
                    $input['is_running'] = 0;
                }
                if (isset($input['is_flexible'])) {
                    $input['is_flexible'] = 1;
                } else {
                    $input['is_flexible'] = 0;
                }
                if (isset($input['loops'])) {
                    $input['loops'] = 1;
                } else {
                    $input['loops'] = 0;
                }

                if (isset($input['is_manual_bot'])) {
                    $input['is_manual_bot'] = 1;
                } else {
                    $input['is_manual_bot'] = 0;
                }
                if ($input['challenge_type'] != "money")
                    $input['confirmed_challenge'] = 1;

                $rowCOllection = DB::table('challenges')->where('id', $id)->update($input);
                Session::flash('flash_notice', 'Successfully updated challenges!');
                Helpers::logActivity('Global Challenge Updated!');
                Session::flash('alert-class', 'alert-success');
                return Redirect::route("$this->model.view_challenges");
            }
        }
        if (!empty($challenge)) {
            $challenges_category = DB::table('challenges_category')->get();
            $challenge = array(
                "challenge" => $challenge,
                "challenges_category" => $challenges_category
            );
            $sport_types = DB::table('sport_types')->select('id', 'sport_name')->where('status', 1)->get();

            return view("admin.$this->model.editglobalchallenge", compact('sport_types', 'challenge'));
        } else {
            return Redirect::route("$this->model.view_challenges")->withErrors('Invalid Id Provided');
        }
    } //End Function

    //Delete Global Challenge
    public function deleteglobalchallenge($id = null)
    {
        $id = unserialize(base64_decode($id));
        //Get Data
        $challenge = DB::table('challenges')->where('id', $id)->first();
        if (!empty($challenge)) {
            DB::table('challenges')->where('id', $id)->delete();
            Session::flash('flash_notice', 'Successfully deleted challenges!');
            //	Helpers::logActivity('Global Challenge Deleted!',$data['name']);
            Session::flash('alert-class', 'alert-success');
            return Redirect::back();
        } else {
            return Redirect::route("$this->model.view_challenges");
        }
    }

    //View
    public function viewchallenges()
    {

        $formData = Input::all();
        if (isset($formData) && !empty($formData)) {
            return Datatables::of(DB::table('challenges')
                ->leftJoin('challenges_category', 'challenges_category.id', '=', 'challenges.challenge_category_id')
                ->select('challenges.*', 'challenges_category.name', 'challenges_category.sport_type')
                ->get())
                ->addIndexColumn()
                ->addColumn('sport_type', function ($result) {
                    // return DB::table('sport_types')->where('id',$result->sport_type)->first()->sport_name;
                    $sportname =  DB::table('sport_types')->where('id', $result->sport_type)->select('sport_name')->first();
                    if (!empty($sportname)) {
                        return $sportname->sport_name;
                    } else {
                        return '';
                    }
                })
                ->addColumn('challenge_type', function ($result) {
                    $challenge_type = '';
                    if ($result->challenge_type == 'money') {
                        $challenge_type = ucwords('Fixed Challenge');
                    } else {
                        $challenge_type = ucwords('Percentage based');
                    }
                    return $challenge_type;
                })
                ->addColumn('maximum_user', function ($result) {
                    $maximum_user = '';
                    if ($result->challenge_type == 'money') {
                        $maximum_user = $result->maximum_user;
                    } else {
                        $maximum_user = '-';
                    }
                    return $maximum_user;
                })
                ->addColumn('winning_percentage', function ($result) {
                    $winning_percentage = '';
                    if ($result->challenge_type != 'money') {
                        $winning_percentage = $result->winning_percentage . ' %';
                    } else {
                        $winning_percentage = '-';
                    }
                    return $winning_percentage;
                })
                ->addColumn('multi_entry', function ($result) {
                    $multi_entry = '';
                    if ($result->multi_entry == 1) {
                        $multi_entry = '<i class="fa fa-check" style="color:green">';
                    } else {
                        $multi_entry = '<i class="fa fa-times" style="color:red">';
                    }
                    return $multi_entry;
                })
                ->addColumn('bonus', function ($result) {
                    $bonus = '';
                    if ($result->bonus == 1) {
                        $bonus = '<i class="fa fa-check" style="color:green">';
                    } else {
                        $bonus = '<i class="fa fa-times" style="color:red">';
                    }
                    return $bonus;
                })
                ->addColumn('is_running', function ($result) {
                    $is_running = '';
                    if ($result->is_running == 1) {
                        $is_running = '<i class="fa fa-check" style="color:green">';
                    } else {
                        $is_running = '<i class="fa fa-times" style="color:red">';
                    }
                    return $is_running;
                })
                ->addColumn('confirmed_challenge', function ($result) {
                    $confirmed_challenge = '';
                    if ($result->confirmed_challenge == 1) {
                        $confirmed_challenge = '<i class="fa fa-check" style="color:green">';
                    } else {
                        $confirmed_challenge = '<i class="fa fa-times" style="color:red">';
                    }
                    return $confirmed_challenge;
                })
                ->addColumn('action', function ($result) {
                    $add_price = '';
                    if ($result->challenge_type == 'money') {
                        $add_price = '<a href="' . route($this->model . '.add_pricecard', base64_encode(serialize($result->id))) . '" class="btn btn-rg mr-1 mt-1" data-toggle="tooltip" title="Add Price Card" data-original-title="Inr"><i class="fa fa-inr" aria-hidden="true"></i></a>';
                    }
                    return     $add_price
                        . '<a href="' . route($this->model . '.edit_global_challenge', base64_encode(serialize($result->id))) . '" class="btn btn-rg mr-1 mt-1" data-toggle="tooltip" title="Edit" data-original-title="Edit" ><i class="fa fa-pencil" aria-hidden = "true" ></i></a>'
                        . '<a href="' . route($this->model . '.delete_global_challenge', base64_encode(serialize($result->id))) . '" class="btn btn-rg mr-1 mt-1 deleteChallanges" title="Delete" data-original-title="Delete"><i class="fa fa-trash" aria-hidden = "true" ></i></a>';
                })
                ->escapeColumns([])
                ->make(true);
        } //end
        return view("admin.$this->model.viewchallenges");
    }

    //Add Price Card
    public function addpricecard($id = null)
    {
        $addcardid = unserialize(base64_decode($id));
        //print_r($addcardid);die;
        //Total Price
        $totalpriceamounts = DB::table('pricecards')->where('challenge_id', $addcardid)->select(DB::raw('sum(pricecards.total) as totalpriceamount'))->get();
        //Find all Price Card
        $findallpricecards = DB::table('pricecards')->where('challenge_id', $addcardid)->select('pricecards.*')->get();
        //Find Challenge
        $findchallenge = DB::table('challenges')->where('id', $addcardid)->get();
        //
        if (!empty($findchallenge)) {
            $min_position = 0;
            $totalpriceamount = 0;
            if (!empty($findallpricecards)) {
                $findminposition = DB::table('pricecards')->where('challenge_id', $addcardid)->orderBY('id', 'DESC')->select('max_position')->first();
                $min_position = isset($findminposition->max_position) && !empty($findminposition->max_position) ? $findminposition->max_position : 0;
                $totalpriceamount = $totalpriceamounts[0]->totalpriceamount;
            }
            ///Get Post All Data
            $input    =    Input::all();
            if (!empty($input)) {
                $rules = array(
                    'min_position' => 'required',
                    'winners' => 'required',
                    //	'price' => 'required',
                );
                $validator = Validator::make(Input::all(), $rules);
                if ($validator->fails()) {
                    return Redirect::back()->withErrors($validator)->withInput();
                } else {
                    unset($input['_token']);
                    $input['max_position'] = $input['min_position'] + $input['winners'];

                    // if($input['is_gadget'] == 1)
                    // {
                    // 	$input['total'] = 0;
                    // }
                    // else
                    // {
                    // 	$input['total'] = $input['price']*$input['winners'];
                    // }

                    if (!empty($input['is_gadget'])) {
                        if ($input['is_gadget'] == 1) {
                            $input['total'] = 0;
                        }
                    } else {
                        'is_gadget' == 0;
                        $input['total'] = $input['price'] * $input['winners'];
                    }

                    $input['challenge_id'] = $addcardid;

                    $countamount = $totalpriceamount + $input['total'];
                    if ($countamount > $findchallenge[0]->win_amount) {

                        Session::flash('flash_notice', 'Your price cards amount is greater than the total wining amount!');
                        return Redirect::back();
                    }
                    if ($input['max_position'] > $findchallenge[0]->maximum_user) {
                        Session::flash('flash_notice', 'You cannot add more winners.');
                        return Redirect::back();
                    }
                    if (Input::hasFile('gadget_image')) {
                        $extension =    Input::file('gadget_image')->getClientOriginalExtension();
                        $img_ext = explode(",", IMAGE_EXTENSION);
                        if (in_array($extension, $img_ext)) {
                            $destinationPath = 'uploads/banners';
                            $fileName = 'PlaynWin11-match-challange' . rand(1000, 9999) . '.' . $extension;
                            if (Input::file('gadget_image')->move(ADVERTISMENTS_PROFILE_IMAGE_ROOT_PATH, $fileName)) {
                                $input['gadget_image'] = $fileName;
                            }
                            Helpers::aws_upload_image(ADVERTISMENTS_PROFILE_IMAGE_ROOT_PATH . $fileName, "uploads/banners", $fileName);
                        } else {
                            Session::flash('error',  trans("messages.$this->model.INVALID_IMAGE_EXTENSION"));
                            return Redirect::back()->withInput();
                        }
                    }
                    DB::table('pricecards')->insert($input);
                    // Session::flash('flash_notice', 'Price Card Successfully add');
                    // Session::flash('alert-class', 'alert-success');
                    Session::flash('flash_notice', 'Price Card Successfully add!');
                    return Redirect::back();
                }
            }
        } else {
            Session::flash('flash_notice', 'Invalid match Provided!');
            return Redirect::route("$this->model.view_challenges");
        }

        return view("admin.$this->model.addpricecard", compact('findallpricecards', 'addcardid', 'min_position', 'findchallenge'));
    } //End Add Price Function
    //Add Price Card
    public function addpricecard_old($id = null)
    {
        //Get Id
        $addcardid = unserialize(base64_decode($id));
        //Total Price
        $totalpriceamounts = DB::table('pricecards')->where('challenge_id', $addcardid)->select(DB::raw('sum(pricecards.total) as totalpriceamount'))->get();
        //Find all Price Card
        $findallpricecards = DB::table('pricecards')->where('challenge_id', $addcardid)->select('pricecards.*')->get();
        //Find Challenge
        $findchallenge = DB::table('challenges')->where('id', $addcardid)->get();
        if (!empty($findchallenge)) {
            $min_position = 0;
            $totalpriceamount = 0;
            if (!empty($findallpricecards)) {
                $findminposition = DB::table('pricecards')->where('challenge_id', $addcardid)->orderBY('id', 'DESC')->select('max_position')->first();
                $min_position = isset($findminposition->max_position) && !empty($findminposition->max_position) ? $findminposition->max_position : 0;
                $totalpriceamount = $totalpriceamounts[0]->totalpriceamount;
            }
            ///Get Post All Data
            $input    =    Input::all();
            if (!empty($input)) {
                $rules = array(
                    'min_position' => 'required',
                    'winners' => 'required',
                    'price' => 'required',
                );
                $validator = Validator::make(Input::all(), $rules);
                if ($validator->fails()) {
                    return Redirect::back()->withErrors($validator)->withInput();
                } else {
                    unset($input['_token']);
                    $input['max_position'] = $input['min_position'] + $input['winners'];
                    $input['total'] = $input['price'] * $input['winners'];
                    $input['challenge_id'] = $addcardid;
                    $countamount = $totalpriceamount + $input['total'];
                    if ($countamount > $findchallenge[0]->win_amount) {
                        Session::flash('flash_notice', 'Your price cards amount is greater than the total wining amount!');
                        return Redirect::back();
                    }
                    if ($input['max_position'] > $findchallenge[0]->maximum_user) {
                        Session::flash('flash_notice', 'You cannot add more winners.');
                        return Redirect::back();
                    }
                    DB::table('pricecards')->insert($input);
                    // Session::flash('flash_notice', 'Price Card Successfully add');
                    // Session::flash('alert-class', 'alert-success');
                    Session::flash('flash_notice', 'Price Card Successfully add!');
                    return Redirect::back();
                }
            }
        } else {
            Session::flash('flash_notice', 'Invalid match Provided!');
            return Redirect::route("$this->model.view_challenges");
        }

        return view("admin.$this->model.addpricecard", compact('findallpricecards', 'addcardid', 'min_position', 'findchallenge'));
    } //End Add Price Function

    //Delete Price Card
    public function deletepricecard($id)
    {
        $id = unserialize(base64_decode($id));
        $findallpricecards = DB::table('pricecards')->where('id', $id)->orderBy('id', 'DESC')->first();
        if (!empty($findallpricecards)) {
            //Delete Data In Table
            DB::table('pricecards')->where('id', $id)->delete();
            // Session::flash('flash_notice', 'Price Card Successfully deleted');
            // Session::flash('alert-class', 'alert-success');
            Session::flash('flash_notice', 'Price Card Successfully deleted!');
            return Redirect::back();
        } else {
            Session::flash('flash_notice', 'Invalid match Provided!');
            return Redirect::route("$this->model.view_challenges");
        }
    } //End Function

    //create challenge
    public function createchallenge()
    {
        $match_status = 'pending';
        $allchallenges = array();
        //current date
        $currentdate = date('Y-m-d h:i:s');
        $data = explode(',', request('matchid'));
        // print_r($data); exit;
        $matchid = '';
        $sport_type = '';

        if (request()->has('matchid')) {
            $query = DB::table('matchchallenges')
                ->join('sport_types', 'sport_types.id', '=', 'matchchallenges.sport_type');
            // $matchid=request('matchid');
            $matchid = $data[0];
            $sport_type = @$data[1];
            if ($matchid != "") {
                $query->where('matchkey', $matchid);
            }
            if ($sport_type != "") {
                $query->where('sport_type', $sport_type);
            }
            $allchallenges = $query->select('matchchallenges.*')
                ->where('name', '=', NULL)
                ->orderBy('marathon', 'ASC')->orderBy('grand', 'ASC')->get();
            $match_status = DB::table('listmatches')->where('matchkey', $matchid)->first()->status;
            $match_status = !empty($match_status) ? $match_status : 'pending';
        }

        $findalllistmatches = DB::table('listmatches')
            ->select('listmatches.name as matchname', 'listmatches.matchkey as matchkey', 'listmatches.sport_type', 'listmatches.status')
            ->Where('launch_status', 'launched')
            ->Where('final_status', 'pending')
            // ->Where('matchkey',$matchid)
            // ->where('start_date','>=',$currentdate)
            ->orderBY('start_date', 'ASC')->get();


        return view("admin.$this->model.createchallenge", compact('findalllistmatches', 'allchallenges', 'matchid', 'sport_type', 'match_status'));
    }
    public function createchallenge_old()
    {

        $allchallenges = array();
        //current date
        $currentdate = date('Y-m-d h:i:s');
        $data = explode(',', request('matchid'));
        $matchid = '';
        $sport_type = '';
        if (request()->has('matchid')) {
            $query = DB::table('matchchallenges')->join('sport_types', 'sport_types.id', '=', 'matchchallenges.sport_type');
            // $matchid=request('matchid');
            $matchid = $data[0];
            $sport_type = @$data[1];
            if ($matchid != "") {
                $query->where('matchkey', $matchid);
            }
            if ($sport_type != "") {
                $query->where('sport_type', $sport_type);
            }
            $allchallenges = $query->select('matchchallenges.*')->orderBy('marathon', 1)->orderBy('grand', 1)->get();
        }
        $findalllistmatches = DB::table('listmatches')
            ->select('listmatches.name as matchname', 'listmatches.matchkey as matchkey', 'listmatches.sport_type')
            ->Where('launch_status', 'launched')
            ->Where('final_status', 'pending')
            // ->where('start_date','>=',$currentdate)
            ->orderBY('start_date', 'ASC')->get();

        return view("admin.$this->model.createchallenge", compact('findalllistmatches', 'allchallenges', 'matchid', 'sport_type'));
    }
    //add match pricecard
    public function addmatchpricecard($id = null)
    {
        $addcardid = $id;
        //Get Id
        $id = unserialize(base64_decode($id));
        //unserialize(base64_decode($id));
        $totalpriceamounts = DB::table('matchpricecards')->where('challenge_id', $id)->select(DB::raw('sum(matchpricecards.total) as totalpriceamount'))->get();
        //Get Data
        $findallpricecards = DB::table('matchpricecards')->where('challenge_id', $id)->select('matchpricecards.*')->get();
        //Get Data
        $findchallenge = DB::table('matchchallenges')->where('id', $id)->get();
        //Ckeck Val
        if (count($findchallenge) > 0) {
            $min_position = 0;
            $totalpriceamount = 0;
            if (count($findallpricecards) > 0) {
                $findminposition = DB::table('matchpricecards')->where('challenge_id', $id)->orderBY('id', 'DESC')->select('max_position')->first();
                $min_position = $findminposition->max_position;
                $totalpriceamount = $totalpriceamounts[0]->totalpriceamount;
            }
            ///Get Post All Data
            $input    =    Input::all();
            if (!empty($input)) {
                $rules = array(
                    'min_position' => 'required',
                    'winners' => 'required',
                    'price' => 'required',
                );
                $validator = Validator::make(Input::all(), $rules);
                if ($validator->fails()) {
                    return Redirect::back()->withErrors($validator)->withInput();
                } else {


                    $input = Input::all();
                    $input['max_position'] = $input['min_position'] + $input['winners'];
                    // if($input['is_gadget'] == 1)
                    // {
                    // 	$input['total'] = 0;
                    // }
                    // else
                    // {
                    // 	$input['total'] = $input['price']*$input['winners'];
                    // }
                    if (!empty($input['is_gadget'])) {
                        if ($input['is_gadget'] == 1) {
                            $input['total'] = 0;
                        }
                    } else {
                        'is_gadget' == 0;
                        $input['total'] = $input['price'] * $input['winners'];
                    }
                    $input['challenge_id'] = $id;
                    $input['matchkey'] = $findchallenge[0]->matchkey;
                    unset($input['_token']);
                    $countamount = $totalpriceamount + $input['total'];
                    if ($countamount > $findchallenge[0]->win_amount) {
                        // return redirect::back()->withErrors('Your price cards amount is greater than the total wining amount');
                    }
                    // if($input['max_position'] > $findchallenge[0]->maximum_user){
                    // 	Session::flash('flash_notice', 'You cannot add more winners.');
                    // 	// return Redirect::route("$this->model.add_match_pricecard",$addcardid);
                    // 	return Redirect::back();
                    // }
                    if (Input::hasFile('gadget_image')) {
                        $extension =    Input::file('gadget_image')->getClientOriginalExtension();
                        $img_ext = explode(",", IMAGE_EXTENSION);
                        if (in_array($extension, $img_ext)) {
                            $destinationPath = 'uploads/banners';
                            $fileName = 'PlaynWin11-match-challange' . rand(1000, 9999) . '.' . $extension;
                            if (Input::file('gadget_image')->move(ADVERTISMENTS_PROFILE_IMAGE_ROOT_PATH, $fileName)) {
                                $input['gadget_image'] = $fileName;
                                //$playerd['image'] = $fileName;
                            }
                            Helpers::aws_upload_image(ADVERTISMENTS_PROFILE_IMAGE_ROOT_PATH . $fileName, "uploads/banners", $fileName);
                        } else {
                            Session::flash('error',  trans("messages.$this->model.INVALID_IMAGE_EXTENSION"));
                            return Redirect::back()->withInput();
                        }
                    }
                    DB::table('matchpricecards')->insert($input);
                    Session::flash('flash_notice', 'Price Card Successfully add');
                    Session::flash('alert-class', 'alert-success');

                    // return Redirect::route("$this->model.add_match_pricecard",$addcardid);
                    return Redirect::back();
                }
            }
        } else {
            Session::flash('flash_notice', 'Invalid match Provided');
            return Redirect::route("$this->model.create_challenge");
        }
        return view("admin.$this->model.addmatchpricecard", compact('findallpricecards', 'addcardid', 'min_position', 'findchallenge'));
    } //End Function
    //add match pricecard
    public function addmatchpricecard_old($id = null)
    {

        $addcardid = $id;
        //Get Id
        $id = unserialize(base64_decode($id));

        //Get Data
        $totalpriceamounts = DB::table('matchpricecards')->where('challenge_id', $id)->select(DB::raw('sum(matchpricecards.total) as totalpriceamount'))->get();
        //Get Data
        $findallpricecards = DB::table('matchpricecards')->where('challenge_id', $id)->select('matchpricecards.*')->get();
        //Get Data
        $findchallenge = DB::table('matchchallenges')->where('id', $id)->get();
        //Ckeck Val
        if (count($findchallenge) > 0) {
            $min_position = 0;
            $totalpriceamount = 0;
            if (count($findallpricecards) > 0) {
                $findminposition = DB::table('matchpricecards')->where('challenge_id', $id)->orderBY('id', 'DESC')->select('max_position')->first();
                $min_position = $findminposition->max_position;
                $totalpriceamount = $totalpriceamounts[0]->totalpriceamount;
            }
            ///Get Post All Data
            $input    =    Input::all();
            if (!empty($input)) {
                $rules = array(
                    'min_position' => 'required',
                    'winners' => 'required',
                    'price' => 'required',
                );
                $validator = Validator::make(Input::all(), $rules);
                if ($validator->fails()) {
                    echo 2;
                    exit;
                } else {
                    $input = Input::all();
                    $input['max_position'] = $input['min_position'] + $input['winners'];
                    $input['total'] = $input['price'] * $input['winners'];
                    $input['challenge_id'] = $id;
                    $input['matchkey'] = $findchallenge[0]->matchkey;
                    unset($input['_token']);
                    $countamount = $totalpriceamount + $input['total'];
                    if ($countamount > $findchallenge[0]->win_amount) {
                        // return redirect::back()->withErrors('Your price cards amount is greater than the total wining amount');
                    }
                    if ($input['max_position'] > $findchallenge[0]->maximum_user) {
                        Session::flash('flash_notice', 'You cannot add more winners.');
                        // return Redirect::route("$this->model.add_match_pricecard",$addcardid);
                        return Redirect::back();
                    }
                    DB::table('matchpricecards')->insert($input);
                    Session::flash('flash_notice', 'Price Card Successfully add');
                    Session::flash('alert-class', 'alert-success');

                    // return Redirect::route("$this->model.add_match_pricecard",$addcardid);
                    return Redirect::back();
                }
            }
        } else {
            Session::flash('flash_notice', 'Invalid match Provided');
            return Redirect::route("$this->model.create_challenge");
        }
        return view("admin.$this->model.addmatchpricecard", compact('findallpricecards', 'addcardid', 'min_position', 'findchallenge'));
    } //End Function

    ///add match challenge
    public function add_private_contest(Request $request)
    {
        //Get Current Date
        $currentdate = date('Y-m-d h:i:s');
        //Get Data In Data Base
        $findalllistmatches = DB::table('listmatches')->select('listmatches.name as matchname', 'listmatches.matchkey as matchkey')->Where('launch_status', 'launched')->where('start_date', '>=', $currentdate)->orderBY('start_date', 'ASC')->get();
        if ($request->isMethod('post')) {
            $input = Input::all();
            unset($input['_token']);

            //Message
            Session::flash('flash_notice', 'Successfully added challenges!');
            Session::flash('alert-class', 'alert-success');
            return Redirect::route("$this->model.create_challenge");
        }
        //Get Challenges Category
        $category = DB::table('challenges_category')->get();
        //Show Page
        return view("admin.$this->model.add_private_contest", compact('findalllistmatches', 'category'));
    } //End Function

    public function fetchContestData(Request $req)
    {
        $datasss = DB::table('joinedleauges')->where('joinedleauges.refercode', $req->id)
            ->join('matchchallenges', 'matchchallenges.id', '=', 'joinedleauges.challengeid')
            ->orderBy('id', 'DESC')
            ->select('matchchallenges.id', 'matchchallenges.name', 'matchchallenges.entryfee', 'matchchallenges.win_amount', 'joinedleauges.id as joinId', 'joinedleauges.refercode as JoinContestCode')->first();
        if (!empty($datasss)) {
            $datasss->serializeId = base64_encode(serialize($datasss->id));
            return (array)$datasss;
        }
        return array();
    }
    public function updateContestInviteCode(Request $req)
    {
        $upRef['refercode'] = $req->ContestUpdateCode;
        DB::table('joinedleauges')->where('id', $req->joinId)->update($upRef);
        echo "done";
    }



    ///add match challenge
    public function addmatchchallenge(Request $request, $id)
    {


        //Get Current Date
        $currentdate = date('Y-m-d h:i:s');
        $thisMatch = DB::table('listmatches')->where('matchkey', $id)->first();
        //Get Data In Data Base
        $findalllistmatches = DB::table('listmatches')->select('listmatches.name as matchname', 'listmatches.matchkey as matchkey')->Where('launch_status', 'launched')->where('start_date', '>=', $currentdate)->orderBY('start_date', 'ASC')->get();
        if ($request->isMethod('post')) {
            $rules = array(
                'entryfee' => 'required',
                'win_amount' => 'required',
                'challenge_type' => 'required',
                'challenge_category_id' => 'required',
                'sport_type' => 'required',
                'maximum_user' => 'required',
                'minimum_user' => 'required',


            );
            $validator = Validator::make(Input::all(), $rules);
            if ($validator->fails()) {
                return Redirect::back()->withErrors($validator)->withInput(Input::except('password'));
            } else {
                $input = Input::all();
                unset($input['_token']);

                if (isset($input['is_promotor']) && $input['is_promotor'] == 1 && $input['challenge_category_id'] != 17) {
                    return back()->with('error', 'Challenge Category select only Promotor users');
                }
                if (isset($input['minimum_user'])) {
                    $input['minimum_user'] = $input['minimum_user'];
                } else {
                    $input['minimum_user'] = 2;
                }

                if (isset($input['is_promotor'])) {
                    $input['is_promotor'];
                } else {
                    $input['is_promotor'] = 0;
                }
                if (isset($input['is_promotor']) && isset($input['promotor_id'])) {
                    $input['promotor_id'] = implode(',', $input['promotor_id']);
                } else {
                    $input['promotor_id'] = 0;
                }

                //Set Val
                if ($input['challenge_type'] != "money") {
                    // $input['confirmed_challenge'] = 1;
                }
                $input['fantasy_type_id'] = 7;

                if (empty($input['bonus_precent'])) {
                    $input['bonus_precent'] = 0;
                }

                if (empty($input['confirmed_challenge'])) {
                    $input['confirmed_challenge'] = 0;
                }

                if (empty($input['dis_price'])) {
                    $input['dis_price'] = 0;
                }
                if (empty($input['max_team_limit'])) {
                    $input['max_team_limit'] = 2;
                }
                if (!empty($input['is_free_for_referrer'])) {
                    $input['is_free_for_referrer'] = 1;
                } else {
                    $input['is_free_for_referrer'] = 0;
                }
                if (isset($input['is_join_similar_contest'])) {
                    $input['is_join_similar_contest'] = 1;
                } else {
                    $input['is_join_similar_contest'] = 0;
                }
                // if(isset($input['join_similar_contest_limit'])){
                //  $input['join_similar_contest_limit'];
                // }else{
                //  $input['join_similar_contest_limit'] = 0;
                // }
                if (Input::hasFile('gadget_image')) {

                    $extension =    Input::file('gadget_image')->getClientOriginalExtension();
                    $img_ext = explode(",", IMAGE_EXTENSION);
                    if (in_array($extension, $img_ext)) {
                        $destinationPath = 'uploads/banners';
                        $fileName = 'PlaynWin11-match-challange' . rand(1000, 9999) . '.' . $extension;

                        //	echo ADVERTISMENTS_PROFILE_IMAGE_ROOT_PATH;
                        //	die;
                        //print_r(PLAYER_IMAGE_ROOT_PATH);die;
                        if (Input::file('gadget_image')->move(ADVERTISMENTS_PROFILE_IMAGE_ROOT_PATH, $fileName)) {

                            $input['gadget_image'] = $fileName;
                            //$playerd['image'] = $fileName;
                        }

                        Helpers::aws_upload_image(ADVERTISMENTS_PROFILE_IMAGE_ROOT_PATH . $fileName, "uploads/banners/", $fileName);
                    } else {
                        Session::flash('error',  trans("messages.$this->model.INVALID_IMAGE_EXTENSION"));
                        return Redirect::back()->withInput();
                    }
                }
                //Insert Value
                $mchallengeid = DB::table('matchchallenges')->insertGetId($input);
                $input1 = array();
                $input1['real_challenge_id'] = $mchallengeid;
                $rowCOllection = DB::table('matchchallenges')->where('id', $mchallengeid)->update($input1);
                //Message
                Session::flash('flash_notice', 'Successfully added challenges!');
                Session::flash('alert-class', 'alert-success');
                return Redirect::route("$this->model.create_challenge");
            }
        }
        //Get Challenges Category
        $category = DB::table('challenges_category')->where('status', 1)->get();
        $user_promotor = DB::table('registerusers')->where('player_percentage', '!=', 0)->where('is_yoububer', 1)->select('id', 'email', 'refercode', 'team', 'mobile')->get();

        //Show Page
        return view("admin.$this->model.addmatchchallenge", compact('findalllistmatches', 'category', 'thisMatch', 'user_promotor'));
    } //End Function

    //Edit Match Challenge
    public function editmatchchallenge($id, Request $request)
    {
        //Get Id
        $id = unserialize(base64_decode($id));
        $challenge = DB::table('matchchallenges')->where('id', $id)->first();
        if (!empty($challenge)) {
            $findmatchnames = DB::table('listmatches')->where('matchkey', @$challenge->matchkey)->select('listmatches.name', 'listmatches.start_date')->first();
            $input = Input::all();
            if (!empty($input)) {
                unset($input['_token']);

                if (isset($input['is_promotor']) && $input['is_promotor'] == 1 && $input['challenge_category_id'] != 17) {
                    return back()->with('error', 'Challenge Category select only Promotor users');
                }

                if (isset($input['is_promotor'])) {
                    $input['is_promotor'];
                } else {
                    $input['is_promotor'] = 0;
                }
                if (isset($input['is_promotor']) && isset($input['promotor_id'])) {
                    $input['promotor_id'] = implode(',', $input['promotor_id']);
                } else {
                    $input['promotor_id'] = 0;
                }

                if (isset($input['multi_entry'])) {
                    $input['multi_entry'] = 1;
                } else {
                    $input['multi_entry'] = 0;
                }
                if (isset($input['confirmed_challenge'])) {
                    $input['confirmed_challenge'] = 1;
                } else {
                    $input['confirmed_challenge'] = 0;
                }

                if (isset($input['bonus']) && !empty($input['bonus']) && $input['bonus'] == 1) {
                    $input['bonus'] = 1;
                    $input['gst_bonus'] = 0;
                } elseif (isset($input['bonus']) && !empty($input['bonus'])) {
                    $input['gst_bonus'] = 1;
                    $input['bonus'] = 0;
                } else {
                    $input['gst_bonus'] = 0;
                    $input['bonus'] = 0;
                }
                // if(isset($input['bonus'])){
                // 	$input['bonus'] = 1;
                // }else{
                // 	$input['bonus'] = 0;
                // }
                if (isset($input['is_running'])) {
                    $input['is_running'] = 1;
                } else {
                    $input['is_running'] = 0;
                }
                if (isset($input['is_flexible'])) {
                    $input['is_flexible'] = 1;
                } else {
                    $input['is_flexible'] = 0;
                }

                if (isset($input['loops'])) {
                    $input['loops'] = 1;
                } else {
                    $input['loops'] = 0;
                }
                if (isset($input['is_offer_team'])) {
                    $input['is_offer_team'];
                } else {
                    $input['is_offer_team'] = 0;
                }
                if (isset($input['offer_team_no'])) {
                    $input['offer_team_no'];
                } else {
                    $input['offer_team_no'] = 0;
                }
                //	print_r(; die();
                if (empty($challenge->max_team_limit)) {
                    $input['max_team_limit'] = 2;
                } else {
                    $input['max_team_limit'] = $challenge->max_team_limit;
                }


                if (isset($input['is_unlimited_credit_contest'])) {
                    $input['is_unlimited_credit_contest'] = 1;
                } else {
                    $input['is_unlimited_credit_contest'] = 0;
                }
                if (isset($input['is_join_similar_contest'])) {
                    $input['is_join_similar_contest'] = 1;
                } else {
                    $input['is_join_similar_contest'] = 0;
                }
                if (!empty($input['is_free_for_referrer'])) {
                    $input['is_free_for_referrer'] = 1;
                } else {
                    $input['is_free_for_referrer'] = 0;
                }


                // if(isset($input['join_similar_contest_limit'])){
                //  $input['join_similar_contest_limit'];
                // }else{
                //  $input['join_similar_contest_limit'] = 0;
                // }
                // dd($input);
                // if(isset($input['loops'])){
                // 	$input['loops'] = 1;
                // }else{
                // 	$input['loops'] = 0;
                // }
                //
                // if(isset($input['is_unlimited_credits'])){
                // 	// dd('dd');
                // 	$input['is_unlimited_credit_contest'] = 1;
                // }else{
                // 	$input['is_unlimited_credit_contest'] = 0;
                // }
                // if(empty($challenge['is_unlimited_credits'])) {
                // 	$input['is_unlimited_credits'] = 0;
                // }

                if (Input::hasFile('gadget_image')) {

                    $extension =    Input::file('gadget_image')->getClientOriginalExtension();
                    $img_ext = explode(",", IMAGE_EXTENSION);
                    if (in_array($extension, $img_ext)) {
                        $destinationPath = 'uploads/banners';
                        $fileName = 'PlaynWin11-match-challange' . rand(1000, 9999) . '.' . $extension;

                        //	echo ADVERTISMENTS_PROFILE_IMAGE_ROOT_PATH;
                        //	die;
                        //print_r(PLAYER_IMAGE_ROOT_PATH);die;
                        if (Input::file('gadget_image')->move(ADVERTISMENTS_PROFILE_IMAGE_ROOT_PATH, $fileName)) {

                            $input['gadget_image'] = $fileName;
                            //$playerd['image'] = $fileName;
                        }

                        Helpers::aws_upload_image(ADVERTISMENTS_PROFILE_IMAGE_ROOT_PATH . $fileName, "uploads/banners/", $fileName);
                    } else {
                        Session::flash('error',  trans("messages.$this->model.INVALID_IMAGE_EXTENSION"));
                        return Redirect::back()->withInput();
                    }
                }

                $findjoinedleauges = DB::table('joinedleauges')->where('challengeid', $id)->get();

                if (count($findjoinedleauges) > 0) {
                    // Session::flash('flash_notice', 'You cannot edit this challenge now!');
                    // Session::flash('alert-class', 'alert-danger');
                    // return redirect()->back();
                }
                if ($input['challenge_type'] != "money")
                    $input['confirmed_challenge'] = 1;
                $rowCOllection = DB::table('matchchallenges')->where('id', $id)->update($input);
                Session::flash('flash_notice', 'Successfully updated challenges!');
                Session::flash('alert-class', 'alert-success');
                return Redirect::route("$this->model.create_challenge", $challenge->matchkey);
            }
            //Get Challenges Category
            $category = DB::table('challenges_category')->where('status', 1)->get();
            // $listmatches = DB::table('listmatches')->where('is_unlimited_credits','=',$id)->select('listmatches.is_unlimited_credits')->get();
            $user_promotor = DB::table('registerusers')->where('player_percentage', '!=', 0)->where('is_yoububer', 1)->select('id', 'email', 'refercode', 'team', 'mobile')->get();


            $listmatches = DB::table('listmatches')->where('matchkey', $challenge->matchkey)->where('listmatches.is_unlimited_credits', '=', 1)->select('listmatches.is_unlimited_credits')->first();
            $user_addcheck = DB::table('challenges')->where('id', $id)->select('promotor_id')->first();
            $is_setuserid = array();
            if (!empty($user_addcheck)) {
                $is_setuserid =    explode(',', $user_addcheck->promotor_id);
            }
            return view("admin.$this->model.editmatchchallenge", compact('challenge', 'findmatchnames', 'category', 'listmatches', 'user_promotor', 'is_setuserid'));
        } else {
            Session::flash('flash_notice', 'Invalid match Provided!');
            Session::flash('alert-class', 'alert-danger');
            return Redirect::route("$this->model.create_challenge", $challenge->matchkey);
        }
    }

    /* Edit Bot Details */

    public function edit_bots_data($id, Request $request)
    {
        //Get Id
        $id = unserialize(base64_decode($id));
        $challenge = DB::table('matchchallenges')->where('id', $id)->first();
        if (!empty($challenge)) {
            $findmatchnames = DB::table('listmatches')->where('matchkey', $challenge->matchkey)->select('listmatches.name', 'listmatches.start_date')->first();
            $input = Input::all();
            if (!empty($input)) {
                unset($input['_token']);
                if (!empty($input['number_of_bots']) && $input['number_of_bots'] == 0) {
                    Session::flash('flash_notice', 'Please Enter Bot Value more then 0 !');
                    Session::flash('alert-class', 'alert-danger');
                    return Redirect::route("$this->model.create_challenge", $challenge->matchkey);
                }
                $rowCOllection = DB::table('matchchallenges')->where('id', $id)->update($input);

                Session::flash('flash_notice', 'Successfully updated challenges!');
                Session::flash('alert-class', 'alert-success');
                return Redirect::route("$this->model.create_challenge", $challenge->matchkey);
            }
            //Get Challenges Category
            $category = DB::table('challenges_category')->get();
            return view("admin.$this->model.edit_bots_data", compact('challenge', 'findmatchnames', 'category'));
        } else {
            Session::flash('flash_notice', 'Invalid match Provided!');
            Session::flash('alert-class', 'alert-danger');
            return Redirect::route("$this->model.create_challenge", $challenge->matchkey);
        }
    }

    public function edit_bots_data_old($id, Request $request)
    {
        //Get Id
        $id = unserialize(base64_decode($id));
        $challenge = DB::table('matchchallenges')->where('id', $id)->first();
        if (!empty($challenge)) {
            $findmatchnames = DB::table('listmatches')->where('matchkey', $challenge->matchkey)->select('listmatches.name', 'listmatches.start_date')->first();
            $input = Input::all();
            if (!empty($input)) {
                unset($input['_token']);

                $rowCOllection = DB::table('matchchallenges')->where('id', $id)->update($input);

                Session::flash('flash_notice', 'Successfully updated challenges!');
                Session::flash('alert-class', 'alert-success');
                return Redirect::route("$this->model.create_challenge", $challenge->matchkey);
            }
            //Get Challenges Category
            $category = DB::table('challenges_category')->get();
            return view("admin.$this->model.edit_bots_data", compact('challenge', 'findmatchnames', 'category'));
        } else {
            Session::flash('flash_notice', 'Invalid match Provided!');
            Session::flash('alert-class', 'alert-danger');
            return Redirect::route("$this->model.create_challenge", $challenge->matchkey);
        }
    }




    /* Edit Bot Details */


    //Del
    public function delmatchchallenge($id = null)
    {
        $id = unserialize(base64_decode($id));
        $challenge = DB::table('matchchallenges')->where('id', $id)->first();
        if (!empty($challenge)) {
            $findpricecards = DB::table('matchpricecards')->where('challenge_id', $id)->get();
            if (!empty($findpricecards)) {
                foreach ($findpricecards as $pp) {
                    DB::table('matchpricecards')->where('id', $pp->id)->delete();
                }
            }
            DB::table('matchchallenges')->where('id', $id)->delete();
            Session::flash('flash_notice', 'Successfully deleted challenges!');
            Session::flash('alert-class', 'alert-success');
            return Redirect::route("$this->model.create_challenge", 'matchid=' . $challenge->matchkey);
        } else {
            Session::flash('flash_notice', 'Invalid match Provided!');
            Session::flash('alert-class', 'alert-danger');
            return Redirect::route("$this->model.create_challenge", 'matchid=' . $challenge->matchkey);
        }
    }


    public function addtogrand(Request $request)
    {
        if ($request->isMethod('post')) {
            $input = Input::all();
            // $input['id'] = '17';
            // $input['matchkey'] = 'bblt20_2017_g20';

            $matchid = $input['matchkey'];
            $query = DB::table('matchchallenges');
            $query->where('matchkey', $matchid);
            $allchallenges = $query->get();
            $findallchallenge = DB::table('matchchallenges')->where('matchkey', $matchid)->where('grand', 1)->first();
            // if(!empty($findallchallenge)){
            // $findjoinedleauges = DB::table('joinedleauges')->where('challengeid',$findallchallenge->id)->get();
            // if(!empty($findjoinedleauges)){
            // }
            // }
            if (!empty($allchallenges)) {
                foreach ($allchallenges as $challenge) {

                    if ($input['id'] == $challenge->id) {
                        $data['grand'] = 1;
                    } else {
                        $data['grand'] = 0;
                    }
                    Session::flash('flash_notice', 'Successfully created grand challenge!');
                    Session::flash('alert-class', 'alert-success');
                    DB::table('matchchallenges')->where('id', $challenge->id)->update($data);
                }
            }

            echo 1;
            die;
        }
    }

    //to getChallangesBySportType
    public function getChallangesBySportType(Request $request)
    {
        $sport_type = $request->sport_type;
        if ($sport_type != '') {
            return $challenges_category = DB::table('challenges_category')->select('name', 'id')->where('sport_type', $sport_type)->get();
        } else {
            return '';
        }
    }

    public function getChallangesByGSTType(Request $request)
    {
        //echo '<pre>'; print_r($request->all());exit;
        $gst_type = $request->category_id;
        if ($gst_type != '') {
            $challenges_category = DB::table('challenges_category')->select('is_used_gst_bonus', 'id')->where('id', $gst_type)->first();
            if ($challenges_category->is_used_gst_bonus == 1) {
                return 'yes';
            }
            return 'no';
        } else {
            return 'no';
        }
    }
    public function deletematchpricecard($id)
    {
        $id = unserialize(base64_decode($id));
        //echo $id;die();
        //$id = base64_decode(   $id)
        $findallpricecards = DB::table('matchpricecards')->where('id', $id)->first();
        if (!empty($findallpricecards)) {
            DB::table('matchpricecards')->where('id', $id)->delete();
            Session::flash('message', 'Price Card Successfully deleted');
            Session::flash('alert-class', 'alert-success');
            return Redirect::back();
        } else {
            // return Redirect::back();
            Session::flash('message', 'Invalid match Provided');
            Session::flash('alert-class', 'alert-danger');
            return Redirect::route($this->model . ".view_challenges")->withErrors('Invalid match Provided');
            // return redirect()->action('ChallengesController@viewchallenges')->withErrors('Invalid match Provided');
        }
    }

    public static function aws_upload_image($path_to_file, $upload_path, $file_name)
    {

        // require_once(APP . 'Vendor' . DS . 'autoload.php');

        try {

            //Create a S3Client

            //  print_r($path_to_file);die;

            $s3 = new S3Client([

                'version' => 'latest',

                'region'  => env('REGION'),

                'endpoint' => env('ENDPOINT'),

                'credentials' => [

                    'key'    => env('S3_KEY'),

                    'secret' => env('S3_SECRET'),

                ],

            ]);

            $result = $s3->putObject([

                'Bucket' => env('S3_NAME'),

                'Key' => $upload_path . $file_name,

                'SourceFile' => $path_to_file,

                'Body' => $path_to_file,

                'ACL'          => 'public-read'

                //'x-amz-acl' => 'public-read'

            ]);

            // print_r($result); exit;

            return $file_name;
        } catch (S3Exception $e) {

            return false;

            echo $e->getMessage() . "\n";
        }
    }
}
