<?php

namespace App\Http\Controllers\Admin;

use Carbon\Carbon;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Http\Requests;
use Illuminate\Support\Facades\Validator;
use App\Helpers\Helpers;
use App\libraries\CustomHelper;
use App\Http\Controllers\BaseController;
use App\Services\Input;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\View;
use Yajra\DataTables\Facades\DataTables;

class ContentsController extends BaseController
{

    /*
	 * Function for display email detail from database
	 *
	 * @param null
	 *
	 * @return view page.
	 */
    public $model    =    'Contrents';


    public function __construct()
    {
        View::share('modelName', $this->model);
    }

    public function add_pages(Request $req)
    {
        if ($req->isMethod('post')) {
            $formData = Input::all();
            if (!empty($formData)) {
                unset($formData['_token']);

                $validatedData = $req->validate([
                    'page_name' => 'required|max:255',
                    'title' => 'required|max:255',
                    'content' => 'required|max:6000000',
                    'page_url' => 'required|max:255',
                ]);
                $pagedetails['title'] = htmlentities($formData['title']);

                $pagedetails['content'] = htmlentities($formData['content']);

                $pagedetails['page_name'] = htmlentities($formData['page_name']);

                $pagedetails['page_url'] = htmlentities($formData['page_url']);

                $pagedetails['is_header'] = $formData['is_header'];

                $pagedetails['is_footer'] = $formData['is_footer'];

                if (isset($formData['web_title']) && !empty($formData['web_title'])) {
                    $pagedetails['web_title'] = htmlentities($formData['web_title']);
                }
                if (isset($formData['meta_content']) && !empty($formData['meta_content'])) {
                    $pagedetails['meta_content'] = htmlentities($formData['meta_content']);
                }

                DB::table('contents')->insert($pagedetails);

                Session::flash('flash_notice', trans("Page Successfully Add!"));
                Helpers::logActivity('PPage Successfully Add!', $pagedetails['page_name']);
                return Redirect::route("$this->model.view_pages");
            }
        }
        return view("admin.$this->model.add_pages");
    }
    public function update_pages($id, Request $req)
    {

        $id = unserialize(base64_decode($id));

        //Get Page Data
        $pagedata = DB::table('contents')->where('id', $id)->first();

        if ($req->isMethod('post')) {
            $formData    =    Input::all();

            if (!empty($formData)) {
                unset($formData['_token']);

                $validatedData = $req->validate([
                    'title' => 'required|max:255',
                    'content' => 'required|max:6000000',
                    'page_name' => 'required|max:10000',
                    'page_url' => 'required|max:255',
                ]);

                $pagedetails['title'] = htmlentities($formData['title']);

                $pagedetails['content'] = htmlentities($formData['content']);

                $pagedetails['page_name'] = htmlentities($formData['page_name']);

                $pagedetails['page_url'] = htmlentities($formData['page_url']);

                if (isset($formData['web_title']) && !empty($formData['web_title'])) {
                    $pagedetails['web_title'] = htmlentities($formData['web_title']);
                } else {
                    $pagedetails['web_title'] = '';
                }
                if (isset($formData['meta_content']) && !empty($formData['meta_content'])) {
                    $pagedetails['meta_content'] = htmlentities($formData['meta_content']);
                } else {
                    $pagedetails['meta_content'] = '';
                }

                $pagedetails['is_header'] = $formData['is_header'];

                $pagedetails['is_footer'] = $formData['is_footer'];

                DB::table('contents')->where('id', $id)->update($pagedetails);

                Session::flash('flash_notice', trans("Page Successfully updated!"));
                Helpers::logActivity('Page Successfully updated!', $pagedetails['page_name']);
                return Redirect::route("$this->model.view_pages");
            }
        }
        return view("admin.$this->model.update_pages", compact( 'pagedata'));
    }
    public function view_pages(Request $req)
    {
        if ($req->isMethod('post')) {
            $formData = Input::all();
            if (isset($formData) && !empty($formData)) {
                return Datatables::of(
                    DB::table('contents')
                        ->where(function ($query) use ($formData) {
                            if (isset($formData['filter_columns'])) {
                                if (isset($formData['filter_columns']['filter_pagename'])) {
                                    $query->where('page_name', 'like', '%' . $formData['filter_columns']['filter_pagename'] . '%');
                                }
                                if (isset($formData['filter_columns']['filter_pagetitle'])) {
                                    $query->where('title', 'like', '%' . $formData['filter_columns']['filter_pagetitle'] . '%');
                                }
                                if (isset($formData['filter_columns']['filter_pagecontent'])) {
                                    $query->where('content', 'like', '%' . $formData['filter_columns']['filter_pagecontent'] . '%');
                                }
                            }
                        })
                        ->orderBy('id', 'ASC')
                        ->get()
                )
                    ->addIndexColumn()
                    ->addColumn('content', function ($result) {
                        //$id=$result->id;
                        $db_content =  substr($result->content, 0, 100) . '...';
                        return $db_content;
                        // onclick="saveplayer('.$result->id.')"
                    })
                    ->addColumn('meta_content', function ($result) {
                        //$id=$result->id;
                        $db_content =  substr($result->meta_content, 0, 100) . '...';
                        return $db_content;
                        // onclick="saveplayer('.$result->id.')"
                    })
                    ->addColumn('action', function ($result) {
                        //$id=$result->id;
                        return '<a href="' . route($this->model . '.update_pages', base64_encode(serialize($result->id))) . '" data-toggle="tooltip" title="Edit" class="btn btn-rg mr-1 mt-1" data-original-title="Edit"><i class="fa fa-pencil" aria-hidden="true"></i></a>'
                            . '<a href="' . route($this->model . '.delete_page', base64_encode(serialize($result->id))) . '" data-toggle="tooltip" title="delete" class="btn btn-danger action-players"><i class="fa fa-times mr-2" aria-hidden="true" data-original-title="Delete"></i>Delete</a>';
                        // onclick="saveplayer('.$result->id.')"
                    })
                    ->escapeColumns([])
                    ->make(true);
            } //end
        }
        return view("admin.$this->model.view_pages");
    }

    public function delete_page($id)
    {
        $id = unserialize(base64_decode($id));

        $findpage = DB::table('contents')->where('id', $id)->get();
        if (!empty($findpage)) {
            DB::table('contents')->where('id', $id)->delete();
            Session::flash('flash_notice', 'Successfully Deleted Page!');
            Session::flash('alert-class', 'alert-success');
        } else {
            Session::flash('flash_notice', 'Invalid Page id');
            Session::flash('alert-class', 'alert-error');
        }
        return Redirect::back();
    }
    function terms_conditions_refer()
    {
        $formData = Input::all();
        //Get Data
        $content = DB::table('contents')->where('name', 'Refer and earn terms and condition')->first();
        if (!empty($formData)) {
            $validate    =    array(
                'content'        =>    'required',
            );
            $validator = Validator::make(Input::all(), $validate);
            if ($validator->fails()) {
                return Redirect::back()->withErrors($validator)->withInput();
            } else {
                unset($formData['_token']);
                $input['content'] = $formData['content'];
                DB::table('contents')->where('name', 'Refer and earn terms and condition')->update($input);
                Session::flash('flash_notice', 'Successfully updated terms and conditions');
                Session::flash('alert-class', 'alert-success');
            }
        }
        return view("admin.$this->model.terms_and_conditions_refer", compact( 'content'));
    }
}
