<?php

namespace App\Http\Controllers\Admin;

use Illuminate\Support\Facades\Storage;

use App\Http\Controllers\Controller;
use App\Models\User;
use App\Models\Yoububer;
use App\Model\Address;
use App\Model\City;
use App\libraries\CustomHelper;
use App\Services\Input;
use Illuminate\Http\Request;
use Carbon\Carbon;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\View;

date_default_timezone_set('Asia/Kolkata');
class DashboardController extends Controller
{
  public $model   =   'User';
  public function __construct()
  {
    View::share('modelName', $this->model);
  }

  /**
   * Function to render view page of dashboard.
   *
   */


  public function dashboard(Request $req)
  {
    // dd('sdfas');
    date_default_timezone_set("Asia/Kolkata");
    //Get Login User Id
    if (empty(Auth::user())) {
      $id = Session::get('id');
      //Get User Data
      $youtoberDetails  = Yoububer::where('id', $id)->first();
      $name =  session()->put('name', $youtoberDetails->username);
      $email = session()->put('email', $youtoberDetails->email);
      $mobile = session()->put('mobile', $youtoberDetails->mobile);
      $image =  session()->put('image', $youtoberDetails->image);
      //Total Youtober Users
      $youtober_total_user  = Yoububer::where('refer_id', $id)->count('id');
      //Youtober Total Amount
      $totalAmount  = DB::table('userbalances')->where('user_id', $id)->sum('balance');
      return view('admin.dashboard.youtober', compact('youtober_total_user', 'totalAmount'));
    } else if (Auth::user()->user_type == 0) {
      //User Table Id
      $user_id = Auth::user()->id;
      $datawithdraw = DB::table('withdraw')->where('status', '=', 0)->get();
      $withdraw = count($datawithdraw);

      $addAmount = 0;
      $addAmount_db = DB::table('dashboard_view')
        ->where('name', '=', 'todays_total_add_amount')
        ->first();
      if (!empty($addAmount_db)) {
        $addAmount = $addAmount_db->value;
      }

      $withdrawAmount = 0;
      $withdrawAmount_db = DB::table('dashboard_view')
        ->where('name', '=', 'todays_total_withdraw')->first();

      if (!empty($withdrawAmount_db)) {
        $withdrawAmount = number_format($withdrawAmount_db->value, 2);
      }

      $string_date = Carbon::now();
      $today_date = explode(' ', $string_date);
      // print_r($today_date[0]);die;
      $count_total_user_join = 0;
      $today_join_user_db = DB::table('dashboard_view')
        // ->where('created_at', '<=', $string_date)
        ->where('name', '=', 'todays_total_user_join')->first();
      // ->select(DB::raw("COUNT(id) as total_user"))
      // ->get();


      if (!empty($today_join_user_db)) {
        $count_total_user_join = $today_join_user_db->value;
      }

      $user_total_amount = 0;

      $user_total_amount_db = DB::table('dashboard_view')
        ->where('name', '=', 'Total_add_cash')
        ->first();
      if (!empty($user_total_amount_db)) {
        $user_total_amount = $user_total_amount_db->value;
      }

      $user_total_affiliation = 0;
      $user_total_affili_db = DB::table('dashboard_view')
        ->where('name', '=', 'total_user_affiliation')
        ->first();
      if (!empty($user_total_affili_db)) {
        $user_total_affiliation = $user_total_affili_db->value;
      }
      //Get Amount Month Wise

      $user_add_amount =   DB::table('month_wise_report_add_joinuser')->select('add_amount as user_add_amount', 'year', 'month')
        ->get();

      $month = date('n');
      $user_count =   DB::table('month_wise_report_add_joinuser')->select('add_user as user_data', 'year', 'month')
        ->limit($month)->orderBY('month', 'asc')
        ->get();
      //Count Total User
      $total_user_count = DB::table('registerusers')->where('email', '!=', null)->count();

      $total_user_count = 0;
      $total_user_count_db = DB::table('dashboard_view')->where('name', 'Total_user')
        ->first();

      if (!empty($total_user_count_db)) {
        $total_user_count = $total_user_count_db->value;
      }

      $paytm_amount = array();

      $cashfree_amount = DB::table('userdata_month_wises')->select('cashfree_amount')->orderBy('id', 'desc')->first();
      if (!empty($cashfree_amount)) {
        $cashfree_amount = $cashfree_amount->cashfree_amount;
      }

      // //razorpay
      $razorpay_amount = DB::table('userdata_month_wises')->select('razorpay_amount')->orderBy('id', 'desc')->first();
      if (!empty($razorpay_amount)) {
        $razorpay_amount = $razorpay_amount->razorpay_amount;
      }


      //Paytem
      $paytm_amount = '0';

      $paytm_amount_db = DB::table('dashboard_view')->where('name', 'Paytm_amount')->first();

      if (!empty($paytm_amount_db)) {
        $paytm_amount = $paytm_amount_db->value;
      }

      //Cash Free
      $cashfree_amount = '0';

      //razor pay
      $razorpay_amount = '0';

      $user_amount = DB::table('withdraw')
        ->join('registerusers', 'registerusers.id', '=', 'withdraw.user_id')
        ->select('withdraw.id', 'withdraw.amount', 'withdraw.approved_date', 'registerusers.username', 'registerusers.email')
        ->where('status', '=', 0)
        ->orderBy('withdraw.amount', 'DESC')
        ->limit(10)->get();


      $user_tota_amount = 0;
      $user_tota_amount_db = DB::table('dashboard_view')
        ->where('name', '=', 'total_user_balance')->first();
      if (!empty($user_tota_amount_db)) {
        // echo $user_tota_amount_db->value; exit;
        $user_tota_amount = !empty($user_tota_amount_db->value) ? @$user_tota_amount_db->value : 0;
      }
      // dd($user_tota_amount);

      $user_tota_amount1 = 0;
      $user_tota_amount_db = DB::table('dashboard_view')
        ->where('name', '=', 'total_user_winning')->first();

      if (!empty($user_tota_amount_db)) {
        $user_tota_amount1 = !empty($user_tota_amount_db->value) ? number_format(@$user_tota_amount_db->value, 2) : 0;
      }
      $user_tota_amount2 = 0;
      $user_tota_amount_db = DB::table('dashboard_view')
        ->where('name', '=', 'total_user_bonus')->first();

      if (!empty($user_tota_amount_db)) {
        $user_tota_amount2 = !empty($user_tota_amount_db->value) ? number_format(@$user_tota_amount_db->value, 2) : 0;
      }
      //GST Coin
      $user_tota_gst_tds = 0;
      $user_tota_amount_db = DB::table('dashboard_view')
        ->where('name', '=', 'total_user_gst_tds')->first();

      if (!empty($user_tota_amount_db)) {
        $user_tota_gst_tds = !empty($user_tota_amount_db->value) ? number_format(@$user_tota_amount_db->value, 2) : 0;
      }


      /*new code */
      $total_paytm_withdraw = '0';
      $paytm_withdraw_db =  DB::table('dashboard_view')->where('name', 'total_paytm_withdraw')->first();


      if (!empty($paytm_withdraw_db)) {
        $total_paytm_withdraw = $paytm_withdraw_db->value;
      }

      $total_bank_withdraw = '0';
      $bank_withdraw_db =  DB::table('dashboard_view')->where('name', 'Cashfree_amount')->first();

      //echo "<pre>"; print_r($bank_withdraw_db); exit;
      if (!empty($bank_withdraw_db)) {
        $total_bank_withdraw = $bank_withdraw_db->value;
      }
      /* new code */


      $total_active_user = '0';
      $total_active_user =  DB::table('dashboard_view')->where('name', 'todays_total_active_user')->first();
      if (!empty($total_active_user)) {
        $total_active_user = $total_active_user->value;
      }


      /*--------End User Total  Amount------*/
      //Get User Data
      $userDetails  =   User::where('id', $user_id)->first();
      //Set Val In Session
      $id =  session()->put('id', $user_id);
      $name =  session()->put('name', $userDetails->name);
      $email = session()->put('email', $userDetails->email);
      $mobile = session()->put('mobile', $userDetails->mobile);
      $image =  session()->put('image', $userDetails->image);
      //Show Page
      //dd($user_total_amount);
      //dd($user_tota_amount);
      $totalgstbalance =  DB::table('deposit_gst')->sum('gst_amount');
      $totalrealcash =  DB::table('winning_commission')->sum('commission');

      $user_withdraw_amount = 0;
      $user_total_add_amount = 0;
      $totalamount_affi = 0;
      $total_registers = 0;
      $total_gst_amount = 0;
      $total_active_users = 0;
      if (isset($req->start_date) && isset($req->end_date)) {
        if (!empty($req->start_date) && !empty($req->end_date)) {

          $user_withdraw_amount = DB::table('withdraw')
            // ->select(DB::raw('SUM(amount) as user_withdraw_amount'),
            //  DB::raw('DATE(approved_date) date'))
            // ->where('status','1')
            ->whereIn('status', ['1', '3'])
            // ->whereRaw('DATE(`created`) = ?',array(date('d')))
            // ->where('created', '<=', date('Y-m-d' , strtotime('-0 day', strtotime(date('Y-m-d')))).' 23:59:00')
            ->where('approved_date', '>=', date('Y-m-d 00:00:00', strtotime($req->start_date)))
            ->where('approved_date', '<=', date('Y-m-d 23:59:00', strtotime($req->end_date)))
            //->groupby('date')
            // ->orderByDesc('created')
            // ->limit(10)
            ->sum('amount');

          $user_total_add_amount = DB::table('transactions')
            // ->select(DB::raw('SUM(amount) as user_add_amount'),
            // DB::raw('DATE(created) date'))
            ->where('type', '=', 'Add Fund')
            ->whereIn('paymentstatus', ['confirmed', 'authorized'])
            ->where('created_at', '>=', date('Y-m-d 00:00:00', strtotime($req->start_date)))
            ->where('created_at', '<=', date('Y-m-d 23:59:00', strtotime($req->end_date)))
            ->sum('amount');


          $total_registers = DB::table('registerusers')
            //	->select(DB::raw('COUNT(*) as total_registers'),DB::raw('DATE(created_at) date'))
            ->whereBetween('created_at', [date('Y-m-d 00:00:00', strtotime($req->start_date)), date('Y-m-d 23:59:00', strtotime($req->end_date))])
            //	->groupby('date')
            ->orderByDesc('created_at')
            ->count();

          $total_gst_amount = DB::table('deposit_gst')
            //		->select(DB::raw('COUNT(*) as total_active_users'),DB::raw('DATE(created) date'))
            ->where('created_at', '>=', date('Y-m-d 00:00:00', strtotime($req->start_date)))
            ->where('created_at', '<=', date('Y-m-d 23:59:00', strtotime($req->end_date)))
            //->groupby('transactions.userid')
            ->orderByDesc('deposit_gst.created_at')
            ->sum('gst_amount');

          $affiliation_total_amount =  DB::table('listmatches')
            ->join('series as s', 's.id', '=', 'listmatches.series')
            ->join('leaugestransactions as lt', 'lt.matchkey', '=', 'listmatches.matchkey')
            ->leftJoin('refunds', function ($join) {
              $join->on('refunds.joinid', '=', 'lt.joinid');
            })
            ->whereNull('refunds.joinid')
            ->where('listmatches.launch_status', 'launched')
            ->where('listmatches.final_status', 'winnerdeclared')
            ->select('listmatches.matchkey')
            ->where(function ($query) use ($req) {
              if (!empty($req->start_date) || !empty($req->end_date)) {
                if (@$req->start_date != "")

                  $query->where("listmatches.start_date", '>=', date("Y-m-d 00:00:00", strtotime($req->start_date)));
                if (@$req->end_date != "")
                  $query->where("listmatches.start_date", '<=', date("Y-m-d 23:59:59", strtotime($req->end_date)));
              }
            })
            ->orderBy('listmatches.start_date', 'DESC')
            ->groupBy('lt.matchkey')
            ->get();

          $totalamount_affi = 0;
          if (!empty($affiliation_total_amount)) {
            foreach ($affiliation_total_amount as $key => $result) {
              $challangeid =  DB::table('finalresults')->where('matchkey', $result->matchkey)->select('challengeid')->pluck('challengeid');
              $affiliationTotalamount =  DB::table('league_refer_bonus')->whereIn('challenge_id', $challangeid)->select('league_refer_bonus.amount')
                ->sum('league_refer_bonus.amount');
              $totalamount_affi += $affiliationTotalamount;
            }
          }

          $startdate = $req->start_date . ' 00:00:01';
          $enddate = $req->end_date . ' 23:59:59';
          $total_active_users = DB::table('registerusers')
            ->join('transactions', 'registerusers.id', '=', 'transactions.userid')
            ->select(DB::raw('COUNT(*) as total_active_users'), DB::raw('DATE(created) date'))
            // ->whereDate("created",'>=', date("Y-m-d 00:00:00", strtotime($req->start_date)) )
            //
            //  ->whereDate("created",'<=', date("Y-m-d 23:59:59", strtotime($req->end_date)) )
            // ->where('created', '<=', date('Y-m-d' , strtotime('-0 day', strtotime(date('Y-m-d')))).' 23:59:00')
            ->whereBetween('created', [$startdate, $enddate])
            ->where('transactions.paymentstatus', '=', 'confirmed')
            //  ->groupby('date')
            //  ->orderByDesc('transactions.created')
            ->count();
          // ->limit(2)
          // ->get();


        }
      }
      $allinvestmentamount = 0;
      $threeinvestmentamount = 0;
      $allinvestmentamount2 = 0;
      $threeinvestmentamount2 = 0;
      $arrowtypeinvestmentafert = '';
      $arrowtypeinvestment = '';
      $percentageamount = 0;
      $percenttageafter = 0;
      $allinvestment = DB::table('dashboard_view')->where('name', 'investment_include_all_wallet')
        ->first();
      if (!empty($allinvestment)) {
        $allinvestmentamount = $allinvestment->value;
      }
      $threeinvestment =  DB::table('dashboard_view')->where('name', 'investment_without_rebate_bonus')
        ->first();

      if (!empty($threeinvestment)) {
        $threeinvestmentamount = $threeinvestment->value;
      }
      // 2days left
      $allinvestment2 = DB::table('dashboard_view')->where('name', 'investment_include_all_wallet_2day')
        ->first();
      if (!empty($allinvestment2)) {
        $allinvestmentamount2 = $allinvestment2->value;
      }
      $threeinvestment2 =  DB::table('dashboard_view')->where('name', 'investment_without_rebate_bonus_2days')
        ->first();

      if (!empty($threeinvestment2)) {
        $threeinvestmentamount2 = $threeinvestment2->value;
      }

      if ($allinvestmentamount2 > 0) {
        $investmentcard = (($allinvestmentamount / $allinvestmentamount2) - 1) / 100;

        if ($investmentcard > 0) {
          $arrowtypeinvestment = 'up';
          $percentageamount = number_format($investmentcard);
        } else {
          $arrowtypeinvestment = 'down';
          $percentageamount = number_format($investmentcard);
        }
      }


      if ($threeinvestmentamount2 > 0) {
        $investmentaftercard = (($threeinvestmentamount / $threeinvestmentamount2) - 1) / 100;


        if ($investmentaftercard > 0) {
          $arrowtypeinvestmentafert = 'up';
          $percenttageafter = number_format($investmentaftercard);
        } else {
          $arrowtypeinvestmentafert = 'down';
          $percenttageafter = number_format($investmentaftercard);
        }
      }


      return view('admin.dashboard.index', compact('total_bank_withdraw', 'total_paytm_withdraw', 'userDetails', 'withdraw', 'addAmount', 'withdrawAmount', 'user_total_amount', 'user_tota_amount1', 'count_total_user_join', 'user_tota_amount2', 'user_add_amount', 'user_count', 'total_user_count', 'paytm_amount', 'cashfree_amount', 'user_amount', 'user_tota_amount', 'razorpay_amount', 'user_tota_gst_tds', 'user_total_affiliation', 'totalgstbalance', 'totalrealcash', 'total_active_user', 'user_withdraw_amount', 'user_total_add_amount', 'total_registers', 'total_gst_amount', 'totalamount_affi', 'total_active_users', 'allinvestmentamount', 'threeinvestmentamount', 'arrowtypeinvestmentafert', 'percenttageafter', 'arrowtypeinvestment', 'percentageamount'));
    } else {
      $user_id = Auth::user()->id;
      //dd($user_id);
      /*Breadcrums start here*/
      /*Breadcrums end*/
      //Get User Data
      $userDetails  =   User::where('id', $user_id)->first();
      //Set Val In Session
      $id =  session()->put('id', $user_id);
      $name =  session()->put('name', $userDetails->name);
      $email = session()->put('email', $userDetails->email);
      $mobile = session()->put('mobile', $userDetails->mobile);
      $image =  session()->put('image', $userDetails->image);


      $panApp = DB::table('sub_admin_activity')->where('activity', 'Pancard Approved')->where('user_id', $user_id);
      $panApp = $panApp->count();
      $panRej = DB::table('sub_admin_activity')->where('activity', 'Pancard Rejected')->where('user_id', $user_id);
      $panRej = $panRej->count();
      $panVerifyCount =  $panApp + $panRej;

      $bankReqApp = DB::table('sub_admin_activity')->where('activity', 'Bank Request Approved')->where('user_id', $user_id);
      $bankReqApp = $bankReqApp->count();
      $bankReqRej = DB::table('sub_admin_activity')->where('activity', 'Bank Request Rejected')->where('user_id', $user_id);
      $bankReqRej = $bankReqRej->count();
      $bankVerifyCount =  $bankReqApp + $bankReqRej;

      $aadharReqApp = DB::table('sub_admin_activity')->where('activity', 'Aadhar Request Approved')->where('user_id', $user_id);
      $aadharReqApp = $aadharReqApp->count();
      $aadahrReqRej = DB::table('sub_admin_activity')->where('activity', 'Aadhar Request Rejected')->where('user_id', $user_id);
      $aadgharReqRej = $aadahrReqRej->count();
      $aadharVerifyCount =  $aadharReqApp + $aadgharReqRej;

      $paytmWithdrawCount = DB::table('sub_admin_activity')->where('activity', 'Withdraw Request Processed successfully!')->where('user_id', $user_id);
      $paytmWithdrawCount = $paytmWithdrawCount->count();

      $bankWithdrawReq = DB::table('sub_admin_activity')->where('activity', 'Bank Withdraw Request Processed successfully')->where('user_id', $user_id);
      $bankWithdrawReq = $bankWithdrawReq->count();

      $withdrawReject = DB::table('sub_admin_activity')->where('activity', 'Withdraw Request Rejected successfully')->where('user_id', $user_id);
      $withdrawReject = $withdrawReject->count();

      //Show Page
      return view('admin.dashboard.sub_admin', compact('panVerifyCount', 'bankVerifyCount', 'paytmWithdrawCount', 'bankWithdrawReq', 'withdrawReject', 'aadharVerifyCount'));
    }
  }

  public function updatedashboarddata()
  {

    $startOfMonth = Carbon::now()->startOfMonth();

    // Get the current date
    $currentDate = Carbon::now();

    $totalAmount = DB::table('transactions')->where('type', '=', 'Add Fund')->where('paymentstatus', '=', 'confirmed')
      ->whereBetween('created', [$startOfMonth, $currentDate])
      ->sum('amount');

    $totaluserjoin = DB::table('registerusers')
      ->whereBetween('created_at', [$startOfMonth, $currentDate])
      ->count();

    $checkmonthdata = DB::table('month_wise_report_add_joinuser')
      ->where('year', date('Y'))
      ->where('month', date('n'))
      ->first();
    if (!empty($checkmonthdata)) {
      DB::table('month_wise_report_add_joinuser')
        ->where('year', date('Y'))
        ->where('month', date('n'))
        ->where('id', $checkmonthdata->id)->update(['add_user' => $totaluserjoin, 'add_amount' => $totalAmount]);
    } else {
      DB::table('month_wise_report_add_joinuser')
        ->insert([
          'add_user' => $totaluserjoin,
          'add_amount' => $totalAmount,
          'month' => date('n'),
          'year' => date('Y')
        ]);
    }

    //Investment Amount Previous date
    $previousdate = date('Y-m-d', strtotime('-1 days'));
    $previousdate2 = date('Y-m-d', strtotime('-2 days'));
    $investmetamount =  DB::table('listmatches')
      ->join('series as s', 's.id', '=', 'listmatches.series')
      ->join('sport_types as sp', 'sp.id', '=', 'listmatches.sport_type')
      ->join('leaugestransactions as lt', 'lt.matchkey', '=', 'listmatches.matchkey')
      ->leftJoin('refunds', function ($join) {
        $join->on('refunds.joinid', '=', 'lt.joinid')
          ->whereNotIn('refunds.reason', ['Winning reversed']);
      })
      ->whereNull('refunds.joinid')
      ->where('lt.created_at', 'like', '%' . $previousdate . '%')
      ->selectRaw('sum(lt.bonus+lt.balance+lt.winning+lt.gst_bonus+lt.affiliation_commission) as allwalletbanance')
      ->selectRaw('sum(lt.balance+lt.winning+lt.affiliation_commission) as threewalletbaalnce')
      ->first();


    DB::table('dashboard_view')->where('name', 'investment_include_all_wallet')
      ->update(['value' => isset($investmetamount->allwalletbanance) ? $investmetamount->allwalletbanance : 0]);

    DB::table('dashboard_view')->where('name', 'investment_without_rebate_bonus')
      ->update(['value' => isset($investmetamount->threewalletbaalnce) ? $investmetamount->threewalletbaalnce : 0]);


    $investmetamount2 =  DB::table('listmatches')
      ->join('series as s', 's.id', '=', 'listmatches.series')
      ->join('sport_types as sp', 'sp.id', '=', 'listmatches.sport_type')
      ->join('leaugestransactions as lt', 'lt.matchkey', '=', 'listmatches.matchkey')
      ->leftJoin('refunds', function ($join) {
        $join->on('refunds.joinid', '=', 'lt.joinid')
          ->whereNotIn('refunds.reason', ['Winning reversed']);
      })
      ->whereNull('refunds.joinid')
      ->where('lt.created_at', 'like', '%' . $previousdate2 . '%')
      ->selectRaw('sum(lt.bonus+lt.balance+lt.winning+lt.gst_bonus+lt.affiliation_commission) as allwalletbanance')
      ->selectRaw('sum(lt.balance+lt.winning+lt.affiliation_commission) as threewalletbaalnce')
      ->first();

    DB::table('dashboard_view')->where('name', 'investment_include_all_wallet_2day')
      ->update(['value' => isset($investmetamount2->allwalletbanance) ? $investmetamount2->allwalletbanance : 0]);

    DB::table('dashboard_view')->where('name', 'investment_without_rebate_bonus_2days')
      ->update(['value' => isset($investmetamount2->threewalletbaalnce) ? $investmetamount2->threewalletbaalnce : 0]);

    // $user_add_amount=DB::table('transactions')
    //                  ->select(DB::raw('SUM(amount) as user_add_amount'),DB::raw('YEAR(created) year, MONTH(created) month'))
    //                  ->where('type','=','Add Fund')
    //                  ->where('paymentstatus','=','confirmed')
    //                  ->orWhere('paymentstatus','=','authorized')
    //                  ->whereRaw('year(`created`) = ?', array(date('Y')))
    //                  ->groupby('year','month')
    //                  ->get();

    // $user_count=DB::table('registerusers')
    //                 ->select(DB::raw('count(id) as `user_data`'),DB::raw('YEAR(created_at) year, MONTH(created_at) month'))
    //                 ->whereRaw('year(`created_at`) = ?', array(date('Y')))
    //                 ->groupby('year','month')
    //                 ->limit(10)
    //                 ->get();
    //
    //
    // foreach ($user_count as $key => $value) {
    //     $checkdata= DB::table('month_wise_report_add_joinuser')->where('month',$value->month)->where('year',$value->year)->first();
    //          if(!empty($checkdata))
    //         {
    //            DB::table('month_wise_report_add_joinuser')->where('id',$checkdata->id)->update(['add_user'=>$value->user_data]);
    //         }else{
    //               // DB::table('month_wise_report_add_joinuser')->insert(['add_user'=>0,'add_amount'=>$value->user_add_amount,'year'=>$value->year,'month'=>$value->month]);
    //         }
    // }
    // exit;

    // dd("dd");
    // Storage::append('dashboardcron.txt', 'Dashboard Cron '.date('Y-m-d'));

    $datawithdraw = DB::table('withdraw')->where('status', '=', 0)->get();
    $withdraw = count($datawithdraw);


    DB::table('dashboard_view')->where('name', 'pending_withdrawal_request')
      ->update(['value' => $withdraw]);

    $addAmount = DB::table('transactions')
      ->where('type', '=', 'Add Fund')
      ->where('paymentstatus', '=', 'confirmed')
      // ->join('registerusers', 'registerusers.id', '=', 'transactions.userid')
      // ->orWhere('paymentstatus','=','authorized')
      // ->where('created', '>=', date('Y-m-d' , strtotime('-1 day', strtotime(date('Y-m-d')))).' 18:30:00')
      ->where('created', 'LIKE', '%' . date('Y-m-d') . '%')
      ->sum('amount');
    //print_r($addAmount);die();

    DB::table('dashboard_view')->where('name', 'todays_total_add_amount')
      ->update(['value' => $addAmount]);

    // $total_active_users_old= DB::table('registerusers')
    //  ->join('transactions','registerusers.id','=','transactions.userid')
    // ->select(DB::raw('COUNT(*) as total_active_users'),DB::raw('DATE(created) date'))
    // ->where('created', '<=', date('Y-m-d' , strtotime('-0 day', strtotime(date('Y-m-d')))).' 23:59:00')
    // ->where('transactions.paymentstatus','=','confirmed')
    // ->groupby('date')
    // ->orderByDesc('transactions.created')
    // ->limit(1)
    // ->get()
    // ->reverse()->values();


    $startdate = date('Y-m-d') . ' 00:00:01';
    $enddate = date('Y-m-d') . ' 23:59:59';

    // $total_active_users= DB::table('registerusers')
    //   ->join('transactions','registerusers.id','=','transactions.userid')
    //  ->select(DB::raw('COUNT(*) as total_active_users'),DB::raw('DATE(created) date'))
    // // ->where('created', '<=', date('Y-m-d' , strtotime('-0 day', strtotime(date('Y-m-d')))).' 23:59:00')
    //  ->whereBetween('created', [$startdate, $enddate])
    //  ->where('transactions.paymentstatus','=','confirmed')
    //  ->groupby('date')
    //  ->orderByDesc('transactions.created')
    //  ->limit(1)
    //  ->get();

    $total_active_users = DB::table('transactions')
      ->select(DB::raw('COUNT(*) as total_active_users'), DB::raw('DATE(created) date'))
      // ->where('created', '<=', date('Y-m-d' , strtotime('-0 day', strtotime(date('Y-m-d')))).' 23:59:00')
      ->whereBetween('created', [$startdate, $enddate])
      ->where('transactions.paymentstatus', '=', 'confirmed')
      ->groupby('date')
      // ->orderByDesc('transactions.created')
      // ->limit(1)
      ->get();
    if (!empty($total_active_users) && count($total_active_users) > 0) {

      DB::table('dashboard_view')->where('name', 'todays_total_active_user')
        ->update(['value' => $total_active_users[0]->total_active_users]);
    }


    $withdrawAmount = DB::table('withdraw')
      //->where('approved_date', '>=', date('Y-m-d' , strtotime('-0 day', strtotime(date('Y-m-d')))).' 00:00:00')
      ->join('registerusers', 'registerusers.id', '=', 'withdraw.user_id')
      // ->where('created', 'LIKE', '%'.date('Y-m-d').'%')
      ->where('approved_date', 'LIKE', '%' . date('Y-m-d') . '%')
      // ->where('status',1)
      ->whereIn('status', ['1', '3'])
      ->sum('amount');

    DB::table('dashboard_view')->where('name', 'todays_total_withdraw')
      ->update(['value' => $withdrawAmount]);

    $string_date = Carbon::now();

    $today_date = explode(' ', $string_date);
    // dd($today_date);
    $today_join_user = DB::table('registerusers')
      ->where('created_at', 'like', '%' . $today_date[0] . '%')
      ->where('is_bot', 0)
      ->where('email', '!=', null)
      ->where('activation_status', '!=', 'pending')
      ->select(DB::raw("COUNT(id) as total_user"))
      ->get();
    // print_r($today_join_user);die();

    $count_total_user_join = $today_join_user[0]->total_user;

    DB::table('dashboard_view')->where('name', 'todays_total_user_join')
      ->update(['value' => $count_total_user_join]);

    // echo "string";die;

    // $user_tota_amount=DB::table('userbalances')
    //              ->join('registerusers', 'registerusers.id', '=', 'userbalances.user_id')
    //              ->select(DB::raw('SUM(balance) as user_balance'))->get();

    // Total balance amount start//
    // $user_tota_amount=DB::table('userbalances')
    //              ->select(DB::raw('SUM(balance) as user_balance'))->get();
    //
    //    DB::table('dashboard_view')->where('name','total_user_balance')
    //    ->update(['value'=>$user_tota_amount[0]->user_balance]);

    $user_tota_balance_amount = DB::table('userbalances')->sum('balance');

    DB::table('dashboard_view')->where('name', 'total_user_balance')
      ->update(['value' => $user_tota_balance_amount]);


    // Total balance amount end//



    // Total winning amount start//

    // $user_tota_amount=DB::table('userbalances')
    //               ->join('registerusers', 'registerusers.id', '=', 'userbalances.user_id')
    //               ->select(DB::raw('SUM(winning) as user_winning'))->get();

    $user_tota_winnamount = DB::table('userbalances')->sum('winning');


    // DB::table('dashboard_view')->where('name','total_user_winning')
    //  ->update(['value'=>$user_tota_amount[0]->user_winning]);
    DB::table('dashboard_view')->where('name', 'total_user_winning')
      ->update(['value' => $user_tota_winnamount]);

    // Total winning amount end//

    // total bonus amount start//

    // $user_tota_amount=DB::table('userbalances')
    //              ->join('registerusers', 'registerusers.id', '=', 'userbalances.user_id')
    //              ->select(DB::raw('SUM(balance) as user_balance'),DB::raw('SUM(winning) as user_winning'),DB::raw('SUM(bonus) as user_bonus'))->get();

    $user_tota_bonus_amount = DB::table('userbalances')->sum('bonus');

    // DB::table('dashboard_view')->where('name','total_user_bonus')
    // ->update(['value'=>$user_tota_amount[0]->user_bonus]);
    DB::table('dashboard_view')->where('name', 'total_user_bonus')
      ->update(['value' => $user_tota_bonus_amount]);

    // Total bonus amount end


    // Total gst bonus amount start
    // $user_tota_amount=DB::table('userbalances')
    //              ->join('registerusers', 'registerusers.id', '=', 'userbalances.user_id')
    //              ->select(DB::raw('SUM(balance) as user_balance'),DB::raw('SUM(winning) as user_winning'),DB::raw('SUM(bonus) as user_bonus'),DB::raw('SUM(gst_bonus) as user_gstbonus'))->get();
    //
    //
    //     DB::table('dashboard_view')->where('name','total_user_coin')
    //     ->update(['value'=>$user_tota_amount[0]->user_gstbonus]);

    $user_tota_gst_amount = DB::table('userbalances')->sum('gst_bonus');


    DB::table('dashboard_view')->where('name', 'total_user_coin')
      ->update(['value' => $user_tota_gst_amount]);

    // Total gst bonus amount end

    //Affiliation amount
    // $user_tota_amount=DB::table('userbalances')
    //              ->join('registerusers', 'registerusers.id', '=', 'userbalances.user_id')
    // ->select(DB::raw('SUM(affiliation_commission) as user_affiliation_commission'))
    //->get();
    $user_tota_amount = DB::table('userbalances')
      ->sum('affiliation_commission');
    //  dd($user_tota_amount);


    // DB::table('dashboard_view')->where('name','total_user_affiliation')
    // ->update(['value'=>$user_tota_amount[0]->user_affiliation_commission]);
    DB::table('dashboard_view')->where('name', 'total_user_affiliation')
      ->update(['value' => $user_tota_amount]);


    //Total add cash ganesh updagte
    /* $user_total_amount=DB::table('transactions')
                         ->where('type','=','Add Fund')
                         ->where('paymentstatus','=','confirmed')
                         // ->orWhere('paymentstatus','=','authorized')
                         ->sum('amount');
                         // dd($user_total_amount);


              DB::table('dashboard_view')->where('name','Total_add_cash')->update(['value'=>$user_total_amount]);
          */

    //end add cash

    $total_user_count = DB::table('registerusers')->where('email', '!=', null)->count();


    DB::table('dashboard_view')->where('name', 'Total_user')->update(['value' => $total_user_count]);

    // $paytm_amount=DB::table('transactions')
    //               ->where('transaction_by','LIKE','%paytm%')
    //               ->where('type','LIKE','add fund')
    //               ->where('paymentstatus','LIKE','confirmed')
    //               ->sum('amount');
    //
    //
    //   DB::table('dashboard_view')->where('name','Paytm_amount')->update(['value'=>$paytm_amount]);

    // $cashfree_amount=DB::table('transactions')
    //             ->where('transaction_by','LIKE','%cashfree%')
    //             ->where('type','LIKE','add fund')
    //             ->where('paymentstatus','LIKE','confirmed')
    //             ->sum('amount');
    //
    //
    //   DB::table('dashboard_view')->where('name','Cashfree_amount')->update(['value'=>$cashfree_amount]);

    // $razorpay_amount=DB::table('transactions')
    //               ->where('transaction_by','LIKE','%razorPay%')
    //               ->where('paymentstatus','LIKE','%authorized%')
    //               ->sum('amount');
    //
    //    DB::table('dashboard_view')->where('name','Razorpay_amount')->update(['value'=>$razorpay_amount]);

    // $user_amount=DB::table('withdraw')
    //           ->join('registerusers', 'registerusers.id', '=', 'withdraw.user_id')
    //           ->select('withdraw.id','withdraw.amount','withdraw.approved_date','registerusers.username','registerusers.email')
    //           ->where('status','=',0)
    //           ->orderBy('withdraw.amount', 'DESC')
    //           ->limit(10)->get();

    //            // print_r($user_amount);die();

    //     DB::table('dashboard_view')->where('name','User_withraw_payment')->update(['value'=>$user_amount]);
    $this->get_userdata_month_wise();
    echo 'done';
  }

  public function get_userdata_month_wise()
  {

    $startdate = date('Y-m-d') . ' 00:00:01';
    $enddate = date('Y-m-d') . ' 23:53:00';
    if (date('Y-m-d H:i:s') > $enddate) {
      $user_total_amount = DB::table('transactions')
        ->where('type', '=', 'Add Fund')
        ->where('paymentstatus', '=', 'confirmed')
        // ->orWhere('paymentstatus','=','authorized')
        ->sum('amount');
      // dd($user_total_amount);

      DB::table('dashboard_view')->where('name', 'Total_add_cash')->update(['value' => $user_total_amount]);

      $checkmonthdata = DB::table('userdata_month_wises')
        // ->where('year',date('Y'))
        //   ->where('month',date('n'))
        ->whereBetween('updated_at', [$startdate, $enddate])
        ->orderBY('id', 'desc')
        ->first();


      if (empty($checkmonthdata)) {
        $user_add_amount = DB::table('transactions')
          ->select(DB::raw('SUM(amount) as user_add_amount'), DB::raw('YEAR(created) year, MONTH(created) month'))
          ->where('type', '=', 'Add Fund')
          ->where('paymentstatus', '=', 'confirmed')
          ->orWhere('paymentstatus', '=', 'authorized')
          ->whereRaw('year(`created`) = ?', array(date('Y')))

          ->groupby('year', 'month')
          ->orderByDesc('created')
          ->limit(1)
          ->get();
        //Paytem
        // $paytm_amount=DB::table('transactions')
        //                ->where('transaction_by', 'LIKE', '%paytm%')
        //                ->where('type', 'LIKE', 'add fund')
        //                ->where('paymentstatus', 'LIKE', 'confirmed')
        //                ->sum('amount');
        //Cash Free
        // $cashfree_amount=DB::table('transactions')
        //             ->where('transaction_by', 'LIKE', '%cashfree%')
        //             ->where('type', 'LIKE', 'add fund')
        //             ->where('paymentstatus', 'LIKE', 'confirmed')
        //             ->sum('amount');

        //razor pay
        // $razorpay_amount=DB::table('transactions')
        //               ->where('transaction_by', 'LIKE', '%razorPay%')
        //               ->where('paymentstatus', 'LIKE', '%authorized%')
        //               ->sum('amount');

        foreach ($user_add_amount as $key => $value) {
          $value = (array) $value;
          // $value['paytm_amount'] = $paytm_amount;
          // $value['cashfree_amount'] = $cashfree_amount;
          // $value['razorpay_amount'] = $razorpay_amount;

          DB::table('userdata_month_wises')->insert($value);
        }
      }
    }
  }

  /**
   * Function to render view page of profile.
   *
   */
  public function myprofile()
  {
    return view('admin.dashboard.myaccount');
  }

  /**
   * Function to update profile.
   *
   */
  public function updateMyProfile(Request $request)
  {
    // dd('d');
    $formData   =   Input::all();
    $userId     =   $formData['id'];
    if (!empty($formData)) {
      $message  =   array(
        'image.max'   =>  MAX_IMAGE_SIZE,
      );
      $validate =   array(
        'name'        =>  'required',
        //  'email'       =>  "required|email|unique:users,email,$userId,id",
        'mobile'      =>  "required|integer",
        // 'image'       =>  'max:2048|mimes:'.IMAGE_EXTENSION,
      );

      $validator = Validator::make(Input::all(), $validate, $message);
      if ($validator->fails()) {

        return Redirect::back()->withErrors($validator)->withInput();
      } else {
        $name   =   ucwords($formData['name']);

        if (!empty(Auth::user())) {

          $obj  =   User::findOrFail($userId);

          $obj->name     =   $name;
        } else {
          $obj  =   Yoububer::findOrFail($userId);
          $obj->username =   $name;
        }

        $oldimage                   =   $obj['image'];
        $obj->email                 =   strip_tags($formData['email']);
        $obj->mobile                =   strip_tags($formData['mobile']);

        $input = $request->all();
        if ($input['base64image'] || $input['base64image'] != '0') {
          // echo "string"; die();
          $folderPath = USER_PROFILE_IMAGE_ROOT_PATH;

          // Check if the directory already exists
          if (!is_dir($folderPath)) {
            mkdir($folderPath, 0777, true);
          } else {
            echo "Directory already exists.";
          }
          // dd($folderPath);
          // $folderPath = public_path('images/');
          $image_parts = explode(";base64,", $input['base64image']);
          if ($image_parts[0] === "") {

            if (input::hasFile('image')) {
              // echo "string"; die();
              $extension  =   Input::file('image')->getClientOriginalExtension();
              $img_ext    =   explode(",", IMAGE_EXTENSION);
              if (in_array($extension, $img_ext)) {
                $fileName           =   time() . '-user-image.' . $extension;
                if (Input::file('image')->move(USER_PROFILE_IMAGE_ROOT_PATH, $fileName)) {
                  $obj['image']     =   $fileName;
                  // dd($obj['image']);
                }
                @unlink(USER_PROFILE_IMAGE_ROOT_PATH . $oldimage);
              } else {
                Session::flash('error',  trans("$this->model.INVALID_IMAGE_EXTENSION"));
                return Redirect::back();
              }
            }
          } else {
            $image_type_aux = explode("image/", $image_parts[0]);
            // dd($image_parts);
            $image_type = $image_type_aux[1];
            // dd($image_type);
            $image_base64 = base64_decode($image_parts[1]);
            // $file = $folderPath . uniqid() . '.png';
            $filename           =   time() . '-user-image.' . $image_type;
            // $filename = time() . '.'. $image_type;
            $file = $folderPath . $filename;
            $obj['image'] = $filename;
            // dd($file);
            file_put_contents($file, $image_base64);
            // dd($file);

            // $playerdetail = new Players;
            //  $obj['image'] = $filename;
            // dd($playerdetail);
            // $playerdetail->save();
          }
        }
        // if(input::hasFile('image')){
        //     $extension  =   Input::file('image')->getClientOriginalExtension();
        //     $img_ext    =   explode(",",IMAGE_EXTENSION);
        //     if(in_array($extension,$img_ext)){
        //         $fileName           =   time().'-user-image.'.$extension;
        //         if(Input::file('image')->move(USER_PROFILE_IMAGE_ROOT_PATH, $fileName)){
        //             $obj->image     =   $fileName;
        //         }
        //         @unlink(USER_PROFILE_IMAGE_ROOT_PATH.$oldimage);
        //     }else{
        //         Session::flash('error',  trans("$this->model.INVALID_IMAGE_EXTENSION"));
        //         return Redirect::back();
        //     }
        // }
        //Save

        $obj->save();

        /*########### End #############*/
        Session::flash('flash_notice',  trans("Admin Profile Successfully Update!"));
        if (!empty(Auth::user())) {
          return Redirect::route("admin_dashboard");
        } else {
          return Redirect::route("youtober_dashboard");
        }
      }
    }
  }

  /**
   * Function to render view page of profile.
   *
   */
  public function changePassword()
  {
    return view('admin.dashboard.changePassword');
  }

  /**
   * Function to update profile.
   *
   */
  public function change_passwordProfile()
  {
    $formData   =   Input::all();
    $userId     =   $formData['id'];
    if (!empty($formData)) {
      $message  =   array(
        'n_password.required'   =>  'Enter New Password',
        'c_password.required'   =>  'Enter Confirm Password',
        'c_password.same'   =>  'Enter Confirm Password Same New Password',
      );
      $validate = array(
        'password'    =>  'required',
        'n_password'  =>  'required|min:6',
        'c_password'  =>  'required|same:n_password',
      );
      $validator = Validator::make(Input::all(), $validate, $message);
      if ($validator->fails()) {
        return Redirect::back()->withErrors($validator)->withInput();
      } else {
        $password = Hash::make($formData['n_password']);
        if (!empty(Auth::user())) {
          $userDetails  =   User::where('id', $userId)->first();
        } else {
          $userDetails  =   Yoububer::where('id', $userId)->first();
        }
        if (Hash::check($formData['password'], $userDetails->password)) {
          if (!empty(Auth::user())) {
            $obj  =   User::findOrFail($userId);
          } else {
            $obj  =   Yoububer::findOrFail($userId);
          }
          $obj->password  = strip_tags($password);
          //Save
          $obj->save();
          /*########### End #############*/
          Session::flash('flash_notice',  trans("Password Change Successfully!"));
          if (!empty(Auth::user())) {
            return Redirect::route("admin_dashboard");
          } else {
            return Redirect::route("youtober_dashboard");
          }
        } else {
          Session::flash('flash_notice',  trans("Password Not Match!"));
          if (!empty(Auth::user())) {
            return Redirect::route("admin_dashboard");
          } else {
            return Redirect::route("youtober_dashboard");
          }
        }
      } //Validation
    } //Post Value Not Empty
  } //End Function

}
