<?php
namespace App\Http\Controllers\Admin;

use App\Model\Series;
use App\Model\AdminUser;
use App\Http\Controllers\BaseController;
use Illuminate\Http\Request;
use App\Helpers\Helpers;
use App\Services\Input;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\View;
use App\Transaction;
use Illuminate\Support\Facades\DB;
use Yajra\DataTables\Facades\DataTables;

 date_default_timezone_set("Asia/Kolkata");
class LeaderboardController extends BaseController {

    /*
     * Function for display email detail from database
     *
     * @param null
     *
     * @return view page.
     */
    public $model   =   'Leaderboard';

    public function __construct() {
        View::share('modelName',$this->model);
    }


    public function seriesList(){
        $formData = Input::all();
        if(isset($formData) && !empty($formData)){
            return Datatables::of(DB::table('series')
                        ->select('*')
                        ->where('is_leaderboard',1)
                        ->get())
               ->addIndexColumn()
               ->addColumn('matches',function ($result){
                    $findmatches=DB::table('listmatches')->where('series',$result->id)->count();
                    return $findmatches;
               })
               ->addColumn('series_win_status', function($result) {
                    if($result->is_leaderboard_win_distribute == 1)
                        return 'Declared';
                    else
                        return 'Not Declare';
               })
               ->addColumn('action', function ($result) {
                    $pricecards = '<a href="'.route($this->model.'.seriesLeaderboardPricecards',base64_encode(serialize($result->id))).'" class="btn btn-rg icon mr-1 mt-1" data-toggle="tooltip" title="Pricecards"><i class="fa fa-rupee" aria-hidden="true" data-original-title="Pricecards" ></i></a>';
                    $leaderboard = '<a href="'.route($this->model.'.seriesLeaderboard',base64_encode(serialize($result->id))).'" class="btn btn-rg icon mr-1 mt-1" data-toggle="tooltip" title="Leaderboard"><i class="fa fa-trophy" aria-hidden="true" data-original-title="Leaderboard" ></i></a>';

                    $winningDistribute = '';
                    if($result->is_leaderboard_win_distribute == 0)
                        $winningDistribute = '<a href="'.route($this->model.'.seriesLeaderboardWinningDistribute',base64_encode(serialize($result->id))).'" class="btn btn-rg icon mr-1 mt-1" data-toggle="tooltip" title="Winning distribute"><i class="fa fa-gift" aria-hidden="true" data-original-title="Winning distribute" ></i></a>';

                    return $leaderboard.' '.$pricecards.' '.$winningDistribute;
                })
                ->escapeColumns([])
                ->make(true);
            }//end

        return  View::make("admin.$this->model.series-list");
    }

    public function seriesLeaderboard_old($series_id) {
        $name = DB::table('series')->where('id',unserialize(base64_decode($series_id)))->first()->name;
        $input = Input::all();
        if(isset($input) && !empty($input)){
            $s_id = unserialize(base64_decode($input['series_id']));
            // $s_id = 94;
            return Datatables::of(DB::table('series_leaderboard as sl')
                        ->join('registerusers as r','r.id', '=', 'sl.user_id')
                        ->where('sl.series_id',$s_id)
                        ->where(function($q) use($input){
                            if(isset($input['username']))
                               $q->where('r.username', 'LIKE', '%'.$input['username'].'%');
                            if(isset($input['email']))
                               $q->where('r.email', 'LIKE', '%'.$input['email'].'%');
                            if(isset($input['mobile']))
                               $q->where('r.mobile', 'LIKE', '%'.$input['mobile'].'%');
                            if(isset($input['team']))
                               $q->where('r.team', 'LIKE', '%'.$input['team'].'%');
                        })
                        ->select('sl.amount', 'sl.rank' , 'sl.points', 'r.team', 'r.email', 'r.mobile', 'r.username')
                        ->orderBy('sl.rank','ASC')
                        ->get())
                        ->addIndexColumn()
                        ->escapeColumns([])
                        ->make(true);
            }//end

        return  View::make("admin.$this->model.series-leaderboard", compact('series_id','name'));
    }
    public function seriesLeaderboard($series_id) {
        $name = DB::table('promoter_leaderboard_series')->where('id',unserialize(base64_decode($series_id)))->first();
        $input = Input::all();
        if(isset($input) && !empty($input)){
            $s_id = unserialize(base64_decode($input['series_id']));
            // $s_id = 94;
            return Datatables::of(DB::table('promoter_series_leaderboard as sl')
                        ->join('registerusers as r','r.id', '=', 'sl.user_id')
                        ->where('sl.series_id',$s_id)
                        ->where(function($q) use($input){
                            if(isset($input['username']))
                               $q->where('r.username', 'LIKE', '%'.$input['username'].'%');
                            if(isset($input['email']))
                               $q->where('r.email', 'LIKE', '%'.$input['email'].'%');
                            if(isset($input['mobile']))
                               $q->where('r.mobile', 'LIKE', '%'.$input['mobile'].'%');
                            if(isset($input['team']))
                               $q->where('r.team', 'LIKE', '%'.$input['team'].'%');
                        })
                        ->select('sl.amount', 'sl.rank' , 'sl.points', 'r.team', 'r.email', 'r.mobile', 'r.username')
                        ->orderBy('sl.rank','ASC')
                        ->get())
                        ->addIndexColumn()
                        ->escapeColumns([])
                        ->make(true);
            }//end

        return  View::make("admin.$this->model.series-leaderboard", compact('series_id','name'));
    }

    public function seriesLeaderboardPricecards($series_id) {
        $id = unserialize(base64_decode($series_id));
        $name = DB::table('series')->where('id',$id)->first()->name;
        $query = DB::table('series_leaderboard_pricecards')->where('series_id',$id)->orderBy('id', 'DESC')->first();
        if(!empty($query))
            $min_position = $query->max_position;
        else
            $min_position = 0;

        $findallpricecards = DB::table('series_leaderboard_pricecards')->where('series_id',$id)->get();
          // var_dump('$min_position');exit;
        return  View::make("admin.$this->model.series-leaderboard-pricecards", compact('series_id', 'min_position', 'findallpricecards','name'));
    }

    public function addSeriesLeaderboardPricecard(Request $request) {
        if($request->isMethod('post')) {
            $input = $request->all();
            $insert['min_position'] = $input['min_position'];
            $insert['max_position'] = $input['min_position']+$input['winners'];
            if(!empty($input['winners'])){
              $insert['winners'] = $input['winners'];
            }else{
              $insert['winners'] = "";
            }
             // $insert['winners'] = $input['winners'];
             if(!empty($input['price'])){
            $insert['price'] = $input['price'];
              }else{
                $insert['price'] = 0;


              }
            $insert['total'] = $input['price']*$input['winners'];
            $insert['series_id'] = unserialize(base64_decode($input['series_id']));
            DB::table('series_leaderboard_pricecards')->insert($insert);
            Session::flash('success', 'Added breakup.');
            return Redirect::back();
        }
    }

    public function deleteSeriesLeaderboardPricecard($id) {
        $d_id = unserialize(base64_decode($id));
        DB::table('series_leaderboard_pricecards')->where('id',$d_id)->delete();
        Session::flash('success', 'Deleted record.');
        return Redirect::back();
    }

    public function seriesLeaderboardWinningDistribute($series_id) {
$s_id = unserialize(base64_decode($series_id));
$exists = DB::table('listmatches')->where('series',$s_id)->whereIn('final_status',['pending','IsReviewed'])->where('launch_status','launched')->exists();
if($exists) {
Session::flash('success', "Winner can't declare, as some matches is still in pending/under reviewed.");
return Redirect::back();
}
else {
$check = DB::table('series')->where('id',$s_id)->first()->is_leaderboard_win_distribute;
if($check) {
Session::flash('success', "Amount distributed already.");
return Redirect::back();
}


$breakup = DB::table('series_leaderboard_pricecards')->where('series_id',$s_id)->orderBy('id','DESC')->first();
if(!empty($breakup)) {
$max_rank = $breakup->max_position;
$allBreakup = DB::table('series_leaderboard_pricecards')->where('series_id',$s_id)->get();
$breakup_arr = array();
foreach($allBreakup as $key => $value) {
$min_position = $value->min_position;
$max_position = $value->max_position;
for($i = $min_position; $i < $max_position; $i++){
$breakup_arr[$i+1]=$value->price;
}
}

$allWinners = DB::table('series_leaderboard')->where('series_id',$s_id)->where('rank','<=',$max_rank)
->orderBy('rank','ASC')
->select('user_id','rank','points','is_win_credited')
->get();

$same_rank_count = 1; $same_amount = 0; $rank = 1; $win_arr = array();
foreach ($allWinners as $key => $value) {
if($key > 0 && $value->rank > $allWinners[$key-1]->rank) {
$same_rank_count = 1;
$rank = $value->rank;
}
if($key > 0 && $value->rank == $allWinners[$key-1]->rank) {
$same_rank_count++;
$amount = $key < $max_rank ? $breakup_arr[$key+1] : 0;
$same_amount = $same_amount + $amount;
}
else {
$same_amount = $breakup_arr[$value->rank];
}
$win_arr[$rank]['count'] = $same_rank_count;
$win_arr[$rank]['amount'] = $same_amount;
}

foreach ($allWinners as $key => $value) {
    $amt = $win_arr[$value->rank]['amount'] / $win_arr[$value->rank]['count'];
    $amount = number_format($amt,2,'.','');
    $update['amount'] = $amount;
    DB::table('series_leaderboard')->where('series_id',$s_id)->where('user_id',$value->user_id)->update($update);
}
$this->seriesLeaderboardWinningUpdate($s_id);
DB::table('series')->where('id',$s_id)->update(['is_leaderboard_win_distribute'=>1]);
Session::flash('success', "Winning distribute successfully.");
return Redirect::back();

}
else {
Session::flash('success', "First set series winning breakup");
return Redirect::back();
}
}
}

public function seriesLeaderboardWinningUpdate($series_id) {
// die();
$breakup = DB::table('series_leaderboard_pricecards')->where('series_id',$series_id)->orderBy('id','DESC')->first();
$max_rank = $breakup->max_position;
$allWinners = DB::table('series_leaderboard')->where('series_id',$series_id)
->where('rank','<=',$max_rank)
->where('amount','>',0)
->where('is_win_credited',0)
->orderBy('rank','ASC')
->select('user_id','rank','amount')
->get();
// echo "<pre>";print_r($allWinners);die();
if(!$allWinners->isEmpty()) {
foreach ($allWinners as $key => $value) {
//update userbalance
$amount = $value->amount;
$user_id = $value->user_id;

$update_is_win_credited['is_win_credited'] = 1;
DB::table('series_leaderboard')->where('series_id',$series_id)->where('user_id',$user_id)->update($update_is_win_credited);

if($amount >= 10000) {
$tds_amount = $amount*30/100;
$new_amount = $amount - $tds_amount;

$userBalance = DB::table('userbalances')->where('user_id',$user_id)->first();
$updateBalance['winning'] = $userBalance->winning + $new_amount;
DB::table('userbalances')->where('user_id',$user_id)->update($updateBalance);


$bal_bonus_amt = number_format($userBalance->bonus,2,'.','');
$bal_win_amt = number_format($updateBalance['winning'],2,'.','');
$bal_fund_amt = number_format($userBalance->balance,2,'.','');
$bal_total_amt = $bal_bonus_amt+$bal_win_amt+$bal_fund_amt;

//winning amount transaction entry
$trans_id = "SERIES-WIN-AM" .FLOOR(RAND() * 90000). $user_id . (int)$new_amount;
$transaciton = new Transaction();
$transaciton->userid = $user_id;
$transaciton->type = "Series Leaderboard Winning";
$transaciton->transaction_id = $trans_id;
$transaciton->transaction_by = "Wizard11";
$transaciton->amount = $new_amount;
$transaciton->paymentstatus = "confirmed";
// $transaction->seriesid = $series_id;
$transaciton->win_amt = $new_amount;
$transaciton->bal_bonus_amt = $bal_bonus_amt;
$transaciton->bal_win_amt = $bal_win_amt;
$transaciton->bal_fund_amt = $bal_fund_amt;
$transaciton->total_available_amt = $bal_total_amt;
$transaciton->save();
//end /winning amount transaction entry

$tds_tdsdetails['userid'] = $user_id;
$tds_tdsdetails['tds_amount'] = $tds_amount;
$tds_tdsdetails['amount'] = $amount;
$tds_tdsdetails['seriesid'] = $series_id;
DB::table('tdsdetails')->insert($tds_tdsdetails);

//winning tds amount transaction entry
$trans_tds_id = "SERIES-WIN-TDS" .FLOOR(RAND() * 90000). $user_id . (int)$tds_amount;
$transaciton_tds = new Transaction();
$transaciton_tds->userid = $user_id;
$transaciton_tds->type = "Series Leaderboard Winning";
$transaciton_tds->transaction_id = $trans_tds_id;
$transaciton_tds->transaction_by = "Wizard11";
$transaciton_tds->amount = $tds_amount;
$transaciton_tds->paymentstatus = "confirmed";
// $transaction_tds->seriesid = $series_id;
$transaciton_tds->bal_bonus_amt = $bal_bonus_amt;
$transaciton_tds->bal_win_amt = $bal_win_amt;
$transaciton_tds->bal_fund_amt = $bal_fund_amt;
$transaciton_tds->total_available_amt = $bal_total_amt;
$transaciton_tds->cons_win = $tds_amount;
$transaciton_tds->save();
//end /winning tds amount transaction entry
}
else {
$userBalance = DB::table('userbalances')->where('user_id',$user_id)->first();
$updateBalance['winning'] = $userBalance->winning + $amount;
DB::table('userbalances')->where('user_id',$user_id)->update($updateBalance);

$bal_bonus_amt = number_format($userBalance->bonus,2,'.','');
$bal_win_amt = number_format($updateBalance['winning'],2,'.','');
$bal_fund_amt = number_format($userBalance->balance,2,'.','');
$bal_total_amt = $bal_bonus_amt+$bal_win_amt+$bal_fund_amt;

//update transaction
$trans_id = "SERIES-WIN-AM" .FLOOR(RAND() * 90000). $user_id . (int)$amount;
$transaciton = new Transaction();
$transaciton->userid = $user_id;
$transaciton->type = "Series Leaderboard Winning";
$transaciton->transaction_id = $trans_id;
$transaciton->transaction_by = "Ex";
$transaciton->amount = $amount;
$transaciton->paymentstatus = "confirmed";
// $transaction->seriesid = $series_id;
$transaciton->win_amt = $amount;
$transaciton->bal_bonus_amt = $bal_bonus_amt;
$transaciton->bal_win_amt = $bal_win_amt;
$transaciton->bal_fund_amt = $bal_fund_amt;
$transaciton->total_available_amt = $bal_total_amt;
$transaciton->save();
}
}
}
}


//New InvestMent Series

    public function InvestMentseriesList(){
        $formData = Input::all();
        if(isset($formData) && !empty($formData)){
            return Datatables::of(DB::table('series')
                        ->select('*')
                        ->where('is_investment',1)
                        ->get())
               ->addIndexColumn()
               ->addColumn('matches',function ($result){
                    $findmatches=DB::table('listmatches')->where('series',$result->id)->count();
                    return $findmatches;
               })
               ->addColumn('series_win_status', function($result) {
                    if($result->is_leaderboard_win_distribute == 1)
                        return 'Declared';
                    else
                        return 'Not Declare';
               })
               ->addColumn('action', function ($result) {
                    $pricecards = '<a href="'.route($this->model.'.investmentLeaderboardPricecards',base64_encode(serialize($result->id))).'" class="btn btn-rg icon mr-1 mt-1" data-toggle="tooltip" title="Pricecards"><i class="fa fa-rupee" aria-hidden="true" data-original-title="Pricecards" ></i></a>';
                    $leaderboard = '<a href="'.route($this->model.'.investmentLeaderboard',base64_encode(serialize($result->id))).'" class="btn btn-rg icon mr-1 mt-1" data-toggle="tooltip" title="Leaderboard"><i class="fa fa-trophy" aria-hidden="true" data-original-title="Leaderboard" ></i></a>';

                    $winningDistribute = '';
                    $adduserinvestment = '';
                    if($result->is_leaderboard_win_distribute == 0){
                        $winningDistribute = '<a href="'.route($this->model.'.investmentLeaderboardWinningDistribute',base64_encode(serialize($result->id))).'" class="btn btn-rg icon mr-1 mt-1" data-toggle="tooltip" title="Winning distribute"><i class="fa fa-gift" aria-hidden="true" data-original-title="Winning distribute" ></i></a>';

                          $adduserinvestment = '<a href="'.route($this->model.'.investmentLeaderboardUseAdd',base64_encode(serialize($result->id))).'" class="btn btn-primary icon mr-1 mt-1" data-toggle="tooltip" title="Add Investments user">Add User</a>';
                        }

                    return $leaderboard.' '.$pricecards.' '.$winningDistribute.''.$adduserinvestment;
                })
                ->escapeColumns([])
                ->make(true);
            }//end

        return  View::make("admin.$this->model.investment-list");
    }

    public function investmentLeaderboardPricecards($series_id) {
        $id = unserialize(base64_decode($series_id));

        $name = DB::table('series')->where('id',$id)->first()->name;
        $query = DB::table('investment_leaderboard_pricecards')->where('series_id',$id)->orderBy('id', 'DESC')->first();
        if(!empty($query))
            $min_position = $query->max_position;
        else
            $min_position = 0;

        $findallpricecards = DB::table('investment_leaderboard_pricecards')->where('series_id',$id)->get();
        return  View::make("admin.$this->model.investment-leaderboard-pricecards", compact('series_id', 'min_position', 'findallpricecards','name'));
    }

    public function addInvestmentLeaderboardPricecard(Request $request) {
        if($request->isMethod('post')) {
            $input = $request->all();
            $insert['min_position'] = $input['min_position'];
            $insert['max_position'] = $input['min_position']+$input['winners'];
            if(!empty($input['winners'])){
              $insert['winners'] = $input['winners'];
            }else{
              $insert['winners'] = "";
            }

             // $insert['winners'] = $input['winners'];
            //  if(!empty($input['price'])){
            // $insert['price'] = $input['price'];
            //   }else{
            //     $insert['price'] = 0;
            //
            //
            //   }
           if(isset($input['is_gadgets']) && $input['is_gadgets'] == 1){
             //  $insert['price'] = $input['price'];
               $insert['gadgets_name'] = $input['gadgets_name'];
               $insert['total'] = $input['winners'];
             }else{

           $insert['price'] = $input['price'];
           $insert['total'] = $input['price']*$input['winners'];
           }
           // $insert['total'] = $input['price']*$input['winners'];
            $insert['series_id'] = unserialize(base64_decode($input['series_id']));
					   $file = $request->all();

					if(!empty($file) && !empty($file['base64image'])){
						 if ($file['base64image'] || $file['base64image'] != '0') {

         $folderPath = 'uploads/banners/';

        $image_parts = explode(";base64,", $request->base64image);
        $image_type_aux = explode("image/", $image_parts[0]);

        if(!isset($image_type_aux[1]) && empty($image_type_aux[1]))
        {
              Session::flash('error',  trans("Image failed Please again upload"));
           return Redirect::back();
        }
        			 					$image_type = $image_type_aux[1];

        			 					$image_base64 = base64_decode($image_parts[1]);

        	       //$filename = BRAND['name'].'-player-'.rand(1000,9999).".".$image_type;
        	$filename='PlaynWin11-gadgets_image-'.rand(10000,99999).'.'.$image_type;
          $file =$folderPath.$filename;
          file_put_contents($file, $image_base64);
            // $fileName=	$this->aws_upload_image(CHALLENGE_IMAGE_URL_ROOT_PATH.$filename,$folderPath,$filename);
        	$insert['gadget_image'] = $filename;
         Helpers::aws_upload_image($folderPath.$filename, "uploads/banners/",$filename);
            //@unlink('uploads/categories/'.$filename);
            @unlink(public_path('uploads/banners/'.$filename));

                   /*    if(Input::hasFile('gadget_image')){
               				$extension = Input::file('gadget_image')->getClientOriginalExtension();
               				$img_ext = explode(",",IMAGE_EXTENSION);

               				if(in_array($extension,$img_ext)){
               					// $destinationPath = 'uploads/players';
               					$folderPath = 'uploads/banners/';
               					// $fileName='11caps-player-'.time();
               					$fileName='PlaynWin11-gadgets_image-'.rand(10000,99999).'.'.$extension;
               						// $fileName=time().'life11-banner-'.$formData['title'].'.'.$extension;
               					// dd($destinationPath);


               					if(Input::file('gadget_image')->move($folderPath, $fileName)){
               						$insert['gadget_image'] = $fileName;
               					}
               						 Helpers::aws_upload_image($folderPath.$fileName, "uploads/banners/",$fileName);
        					         @unlink(public_path('uploads/banners/'.$filename));
                        //  @unlink(ADVERTISMENTS_PROFILE_IMAGE_URL.$fileName);
                          //end new added
               					 // Helpers::aws_upload_image(PLAYER_IMAGE_ROOT_PATH.$fileName, "uploads/players/",$fileName);
               				}else{
               					Session::flash('error',  trans("messages.$this->model.INVALID_IMAGE_EXTENSION"));
               					return Redirect::back()->withInput();
               				}
               			}*/
        }}

             if(!empty($input['is_gadgets'])){

               $insert['is_gadgets'] = 1;
             }
             else{
               $insert['is_gadgets'] = 0;
             }

            DB::table('investment_leaderboard_pricecards')->insert($insert);
            Session::flash('success', 'Added breakup.');
            return Redirect::back();
        }
    }

    public function deleteInvestmentLeaderboardPricecard($id) {
        $d_id = unserialize(base64_decode($id));
        DB::table('investment_leaderboard_pricecards')->where('id',$d_id)->delete();
        Session::flash('success', 'Deleted record.');
        return Redirect::back();
    }

    public function investmentLeaderboard($series_id) {
        $name = DB::table('series')->where('id',unserialize(base64_decode($series_id)))->first()->name;

        $input = Input::all();
        if(isset($input) && !empty($input)){
            $s_id = unserialize(base64_decode($input['series_id']));

            // $s_id = 94;
            return Datatables::of(DB::table('investment_leaderboard as sl')
                        ->join('registerusers as r','r.id', '=', 'sl.user_id')
                        ->where('sl.series_id',$s_id)
                        ->where(function($q) use($input){
                            if(isset($input['username']))
                               $q->where('r.username', 'LIKE', '%'.$input['username'].'%');
                            if(isset($input['email']))
                               $q->where('r.email', 'LIKE', '%'.$input['email'].'%');
                            if(isset($input['mobile']))
                               $q->where('r.mobile', 'LIKE', '%'.$input['mobile'].'%');
                            if(isset($input['team']))
                               $q->where('r.team', 'LIKE', '%'.$input['team'].'%');
                        })
                        ->select('sl.amount', 'sl.rank' , 'sl.points', 'r.team', 'r.email', 'r.mobile', 'r.username')
                        ->orderBy('sl.rank','ASC')
                        ->get())
                        ->addIndexColumn()
                        ->escapeColumns([])
                        ->make(true);
            }//end

        return  View::make("admin.$this->model.investment-leaderboard", compact('series_id','name'));
    }


   public function investmentsLeaderboardWinningDistribute($investment_leaderboard_id) {
            $s_id = unserialize(base64_decode($investment_leaderboard_id));

           $exists = DB::table('listmatches')->where('series',$s_id)->whereIn('final_status',['pending','IsReviewed'])->where('launch_status','launched')->exists();

             dd($exists);
           if($exists) {
           Session::flash('success', "Winner can't declare, as some matches is still in pending/under reviewed.");
           return Redirect::back();
           }
           else {

            $existsMatches = DB::table('listmatches')->where('series',$s_id)->where('launch_status','launched')->count();

             if($existsMatches==0) {
             Session::flash('success', "Not Any Matches Launch and Declared for Leaderboard.");
             return Redirect::back();
             }

           $check = DB::table('investment_leaderboard_name')->where('series_id',$s_id)->select('is_leaderboard_win_distribute')->first();


           if($check->is_leaderboard_win_distribute==1) {
           Session::flash('error', "Amount distributed already.");
           return Redirect::back();
           }

           $breakup = DB::table('investment_leaderboard_pricecards')->where('series_id',$s_id)->orderBy('id','DESC')->first();
           if(!empty($breakup)) {
           $max_rank = $breakup->max_position;
           $allBreakup = DB::table('investment_leaderboard_pricecards')->where('series_id',$s_id)->get();
           $breakup_arr = array();
           foreach($allBreakup as $key => $value) {
           $min_position = $value->min_position;
           $max_position = $value->max_position;
           for($i = $min_position; $i < $max_position; $i++){
              if(!empty($value->price)){
                $breakup_arr[$i+1]=$value->price;
                }else{
          $breakup_arr[$i+1]=$value->gadget_image;
            }
           }
           }

           $allWinners = DB::table('investment_leaderboard')->where('series_id',$s_id)->where('rank','<=',$max_rank)
           ->orderBy('rank','ASC')
           ->select('user_id','rank','points','is_win_credited')
           ->get();

           $same_rank_count = 1; $same_amount = 0; $rank = 1; $win_arr = array();
           foreach ($allWinners as $key => $value) {
           if($key > 0 && $value->rank > $allWinners[$key-1]->rank) {
           $same_rank_count = 1;
           $rank = $value->rank;
           }
           if($key > 0 && $value->rank == $allWinners[$key-1]->rank) {
           $same_rank_count++;
           $amount = $key < $max_rank ? $breakup_arr[$key+1] : 0;
           $same_amount = $same_amount + $amount;
           }
           else {
           $same_amount = $breakup_arr[$value->rank];
           }
           $win_arr[$rank]['count'] = $same_rank_count;
           $win_arr[$rank]['amount'] = $same_amount;
           }

          // dd($win_arr[$value->rank]['amount']);
           foreach ($allWinners as $key => $value) {
               $amt = ((int)$win_arr[$value->rank]['amount']) / (int)$win_arr[$value->rank]['count'];
               $amount = number_format($amt,2,'.','');
               $update['amount'] = $amount;
               DB::table('investment_leaderboard')->where('series_id',$s_id)->where('user_id',$value->user_id)->update($update);
           }

           $this->investmentsLeaderboardWinningUpdate($s_id);
      //     $this->seriesLeaderboardWinningUpdate($s_id);
           DB::table('investment_leaderboard_name')->where('series_id',$s_id)->update(['is_leaderboard_win_distribute'=>1]);
            DB::table('series')->where('id',$s_id)->update(['is_leaderboard_win_distribute'=>1]);
           Session::flash('success', "Winning distribute successfully.");
           return Redirect::back();

           }
           else {
           Session::flash('error', "First set Investment leaderboard winning breakup");
           return Redirect::back();
           }
           }
     }


  public function investmentsLeaderboardWinningUpdate($investment_leaderboard_id) {
   // dd($investment_leaderboard_id);
    $breakup = DB::table('investment_leaderboard_pricecards')->where('series_id',$investment_leaderboard_id)->orderBy('id','DESC')->first();
    $max_rank = $breakup->max_position;
    $allWinners = DB::table('investment_leaderboard')->where('series_id',$investment_leaderboard_id)
    ->where('rank','<=',$max_rank)
    ->where('amount','>',0)
    ->where('is_win_credited',0)
    ->orderBy('rank','ASC')
    ->select('user_id','rank','amount')
    ->get();
    // echo "<pre>";print_r($allWinners);die();
    if(!$allWinners->isEmpty()) {
      foreach ($allWinners as $key => $value) {
        //update userbalance
        $amount = $value->amount;
        $user_id = $value->user_id;

        $update_is_win_credited['is_win_credited'] = 1;
        DB::table('investment_leaderboard')->where('series_id',$investment_leaderboard_id)->where('user_id',$user_id)->update($update_is_win_credited);

        if($amount > 10000) {
          // $tds_amount = $amount*30/100;
          $tds_amount = 0;
          $new_amount = $amount - $tds_amount;

          $userBalance = DB::table('userbalances')->where('user_id',$user_id)->first();
          $updateBalance['winning'] = $userBalance->winning + $new_amount;
          DB::table('userbalances')->where('user_id',$user_id)->update($updateBalance);


          $bal_bonus_amt = number_format($userBalance->bonus,2,'.','');
          $bal_win_amt = number_format($updateBalance['winning'],2,'.','');
          $bal_fund_amt = number_format($userBalance->balance,2,'.','');
          $bal_gstbonus_amt = number_format($userBalance->gst_bonus,2,'.','');
          $bal_affi_amt = number_format($userBalance->affiliation_commission,2,'.','');
          $bal_total_amt = $bal_bonus_amt+$bal_win_amt+$bal_fund_amt+ $bal_gstbonus_amt+$bal_affi_amt;

          //winning amount transaction entry
          $trans_id = "INVLDRBRD-WIN-AM" .FLOOR(RAND() * 90000). $user_id . (int)$new_amount;
          $transaciton = new Transaction();
          $transaciton->userid = $user_id;
          $transaciton->type = "Investments Leaderboard Winning";
          $transaciton->transaction_id = $trans_id;
          $transaciton->transaction_by = "PlaynWin11";
          $transaciton->amount = $new_amount;
          $transaciton->paymentstatus = "confirmed";
          // $transaction->seriesid = $series_id;
          $transaciton->win_amt = $new_amount;
          $transaciton->bal_bonus_amt = $bal_bonus_amt;
          $transaciton->bal_win_amt = $bal_win_amt;
          $transaciton->bal_fund_amt = $bal_fund_amt;
          $transaciton->bal_gst_bonus_amt = $bal_gstbonus_amt;
          $transaciton->bal_affi_amt = $bal_affi_amt;
          $transaciton->total_available_amt = $bal_total_amt;
          $transaciton->save();
          //end /winning amount transaction entry

          // $tds_tdsdetails['userid'] = $user_id;
          // $tds_tdsdetails['tds_amount'] = $tds_amount;
          // $tds_tdsdetails['amount'] = $amount;
          // $tds_tdsdetails['seriesid'] = $series_id;
          // DB::table('tdsdetails')->insert($tds_tdsdetails);

          //xxxxxxxxxxxxxx winning tds amount transaction entry xxxxxxxxxxxxxx
          // $trans_tds_id = "INVLDRBRD-WIN-TDS" .FLOOR(RAND() * 90000). $user_id . (int)$tds_amount;
          // $transaciton_tds = new Transaction();
          // $transaciton_tds->userid = $user_id;
          // $transaciton_tds->type = "Investments Leaderboard Winning";
          // $transaciton_tds->transaction_id = $trans_tds_id;
          // $transaciton_tds->transaction_by = "LIFE11";
          // $transaciton_tds->amount = $tds_amount;
          // $transaciton_tds->paymentstatus = "confirmed";
          // // $transaction_tds->seriesid = $series_id;
          // $transaciton_tds->bal_bonus_amt = $bal_bonus_amt;
          // $transaciton_tds->bal_win_amt = $bal_win_amt;
          // $transaciton_tds->bal_fund_amt = $bal_fund_amt;
          // $transaciton_tds->total_available_amt = $bal_total_amt;
          // $transaciton_tds->cons_win = $tds_amount;
          // $transaciton_tds->save();
          //end /winning tds amount transaction entry
        }
        else {
          $userBalance = DB::table('userbalances')->where('user_id',$user_id)->first();
          $updateBalance['winning'] = $userBalance->winning + $amount;
          DB::table('userbalances')->where('user_id',$user_id)->update($updateBalance);

          $bal_bonus_amt = number_format($userBalance->bonus,2,'.','');
          $bal_win_amt = number_format($updateBalance['winning'],2,'.','');
          $bal_fund_amt = number_format($userBalance->balance,2,'.','');
          $bal_gstbonus_amt = number_format($userBalance->gst_bonus,2,'.','');
          $bal_affi_amt = number_format($userBalance->affiliation_commission,2,'.','');
          $bal_total_amt = $bal_bonus_amt+$bal_win_amt+$bal_fund_amt+ $bal_gstbonus_amt+$bal_affi_amt;

          //update transaction
          $trans_id = "INVLDRBRD-WIN-AM" .FLOOR(RAND() * 90000). $user_id . (int)$amount;
          $transaciton = new Transaction();
          $transaciton->userid = $user_id;
          $transaciton->type = "Investments Leaderboard Winning";
          $transaciton->transaction_id = $trans_id;
          $transaciton->transaction_by = "PlaynWin11";
          $transaciton->amount = $amount;
          $transaciton->paymentstatus = "confirmed";
          // $transaction->seriesid = $series_id;
          $transaciton->win_amt = $amount;
          $transaciton->bal_bonus_amt = $bal_bonus_amt;
          $transaciton->bal_win_amt = $bal_win_amt;
          $transaciton->bal_fund_amt = $bal_fund_amt;
          $transaciton->bal_gst_bonus_amt = $bal_gstbonus_amt;
          $transaciton->bal_affi_amt = $bal_affi_amt;
          $transaciton->total_available_amt = $bal_total_amt;
          $transaciton->save();
        }
      }
    }
  }

  public function investmentLeaderboardUseAdd($seriedid)
  {
    $s_id = unserialize(base64_decode($seriedid));
    $matchname= DB::table('listmatches')->where('series',$s_id)->select('id','is_update_investment_leaderboard','name','matchkey','start_date')->get();
    $checkadd= DB::table('investment_match_leaderboard')->where('manul_update',1)->where('series_id',$s_id)->groupBy('match_id')->select('match_id')->pluck('match_id')->toArray();
       // echo '<pre>'; print_r($checkadd);exit;
      $input = Input::all();
        //echo '<pre>'; print_r($input);exit;
      if(isset($input) && !empty($input)){
          $s_id = unserialize(base64_decode($input['series_id']));

          $usercheck= DB::table('registerusers')->where('mobile',$input['mobile'])->first();
          if(empty($usercheck))
          {
            Session::flash('error', 'User does not exits');
            return Redirect::back();
          }


    $checkusermatchadd= DB::table('investment_match_leaderboard')->where('manul_update',1)->where('series_id',$s_id)
    ->where('match_id',$input['match_id'])->where('user_id',$usercheck->id)->first();
        if(!empty($checkusermatchadd))
        {
            Session::flash('error', 'Here the match is already added for this user');
            return Redirect::back();
        }
            $matchinvest= array('series_id'=>$s_id,
                              'match_id'=>$input['match_id'],
                              'user_id'=>$usercheck->id,
                              'points'=>$input['price'],
                              'manul_update'=>1);

            DB::table('investment_match_leaderboard')->insert($matchinvest);
         // $this->update_investments_leaderboard($s_id);

            Session::flash('success', 'Add Investments successfully');
            return Redirect::back();
        }

        $getinvestmentuser=   DB::table('investment_match_leaderboard')
            ->join('registerusers','registerusers.id','=','investment_match_leaderboard.user_id')
            ->join('listmatches','listmatches.matchkey','=','investment_match_leaderboard.match_id')
          ->select('listmatches.name','registerusers.mobile','investment_match_leaderboard.points','investment_match_leaderboard.id')
          ->where('manul_update',1)->where('series_id',$s_id)->get();
         return  View::make("admin.$this->model.investment-leaderboard_add_user", compact('matchname','seriedid','checkadd','getinvestmentuser'));

  }

//Delete User Manual add

   public function investmentDeleteUser($id)
  {
        $investment_id = unserialize(base64_decode($id));
         DB::table('investment_match_leaderboard')->where('id',$investment_id)->delete();

            Session::flash('success', 'User Investments Delete successfully');
           return Redirect::back();

  }

   public function investmentEditUser($seriedid,$investmentid)
  {
        $investment_id = unserialize(base64_decode($investmentid));

       // $seriedid = unserialize(base64_decode($series_id));
        //  $seriedid=$series_id;
          //$seriedid=base64_encode(serialize($investmentid));

          $input = Input::all();
          if(isset($input) && !empty($input)){

          $usercheck= DB::table('registerusers')->where('mobile',$input['mobile'])->first();
          if(empty($usercheck))
          {
            Session::flash('error', 'User does not exits');
            return Redirect::back();
          }

            $matchinvest= array(
                              'user_id'=>$usercheck->id,
                              'match_id'=>$input['match_id'],
                              'points'=>$input['price'],
                              'manul_update'=>1);

            DB::table('investment_match_leaderboard')->where('id',$input['investmentid'])->update($matchinvest);
            Session::flash('success', 'User Investments detail update successfully');
           return Redirect::to('admin/leaderboard/investment-leaderboard-user-add/'.$seriedid);
          }
        $userinvestment=   DB::table('investment_match_leaderboard')
        ->join('registerusers','registerusers.id','=','investment_match_leaderboard.user_id')
        ->where('investment_match_leaderboard.id',$investment_id)
        ->select('investment_match_leaderboard.points','registerusers.mobile','investment_match_leaderboard.series_id','investment_match_leaderboard.id')
            ->first();

        $matchname= DB::table('listmatches')->where('series',$userinvestment->series_id)->select('id','is_update_investment_leaderboard','name','matchkey','start_date')->get();
        $checkadd= DB::table('investment_match_leaderboard')->where('manul_update',1)->where('series_id',$userinvestment->series_id)->groupBy('match_id')->select('match_id')->pluck('match_id')->toArray();

         return  View::make("admin.$this->model.investment-leaderboard_edit_user", compact('matchname','seriedid','checkadd','userinvestment'));

  }

  public function update_investments_leaderboard($series_id) {
      //dd($series_id);
      $match_leaderboard = DB::table('investment_match_leaderboard')->select(DB::raw('SUM(points) as points, user_id, series_id'))->where('series_id', $series_id)->orderByRaw('SUM(points) DESC')->groupBy('user_id')->get();

      $lastpoints = 0; $skip_count = 0;
      $rank = 1;
      $i = 0;

      if(!$match_leaderboard->isEmpty()) {
        foreach ($match_leaderboard as $key => $value) {
          if($value->points == $lastpoints) {
            $skip_count++;
            $data[$i]['rank'] = $rank - $skip_count;
          } else {
            $data[$i]['rank'] = $rank;
            $skip_count = 0;
          }
          $data[$i]['points'] = $value->points;
          $data[$i]['user_id'] = $value->user_id;
          $data[$i]['series_id'] = $value->series_id;
          $data[$i]['status'] = 1;
          $rank++;
          $i++;
          $lastpoints = $value->points;
        }

        $check = DB::table('investment_leaderboard')->where('series_id',$series_id)->exists();

        if($check) {
          DB::table('investment_leaderboard')->where('series_id',$series_id)->delete();
        }
        DB::table('investment_leaderboard')->insert($data);
        // echo "<pre>"; print_r($data); exit;
      }

      return 1;
    }

      //New InvestMent Deposit

  public function DepositInvestMentList(){
        $formData = Input::all();
        if(isset($formData) && !empty($formData)){
            return Datatables::of(DB::table('deposit_investment')
                        ->select('*')
                       // ->where('is_investment',1)
                        ->get())
               ->addIndexColumn()

               ->addColumn('win_status', function($result) {
                    if($result->win_status == 1)
                        return 'Declared';
                    else
                        return 'Not Declare';
               })
               ->addColumn('action', function ($result) {
                    $pricecards = '<a href="'.route($this->model.'.depositInvestmentLeaderboardPricecards',base64_encode(serialize($result->id))).'" class="btn btn-rg icon mr-1 mt-1" data-toggle="tooltip" title="Pricecards"><i class="fa fa-rupee" aria-hidden="true" data-original-title="Pricecards" ></i></a>';
                    $leaderboard = '<a href="'.route($this->model.'.depositInvestmentLeaderboard',base64_encode(serialize($result->id))).'" class="btn btn-rg icon mr-1 mt-1" data-toggle="tooltip" title="Leaderboard"><i class="fa fa-trophy" aria-hidden="true" data-original-title="Leaderboard" ></i></a>';

                    $winningDistribute = '';
                    $adduserinvestment = '';
                    if($result->win_status == 0){
                        $winningDistribute = '<a href="'.route($this->model.'.depositInvestmentLeaderboardWinningDistribute',base64_encode(serialize($result->id))).'" class="btn btn-rg icon mr-1 mt-1" data-toggle="tooltip" title="Winning distribute"><i class="fa fa-gift" aria-hidden="true" data-original-title="Winning distribute" ></i></a>';

                          $adduserinvestment = '<a href="'.route($this->model.'.depositInvestmentLeaderboardUseAdd',base64_encode(serialize($result->id))).'" class="btn btn-primary icon mr-1 mt-1" data-toggle="tooltip" title="Add Investments user">Add User</a>';
                        }

                    return $leaderboard.' '.$pricecards.' '.$winningDistribute.''.$adduserinvestment;
                })
                ->escapeColumns([])
                ->make(true);
            }//end

        return  View::make("admin.$this->model.deposit_investment-list");
    }

  public function depositInvestmentLeaderboardPricecards($depositid) {
        $id = unserialize(base64_decode($depositid));

        $name = DB::table('deposit_investment')->where('id',$id)->first()->name;
        $query = DB::table('investment_leaderboard_deposit_pricecards')->where('deposit_id',$id)->orderBy('id', 'DESC')->first();
        if(!empty($query))
            $min_position = $query->max_position;
        else
            $min_position = 0;

        $findallpricecards = DB::table('investment_leaderboard_deposit_pricecards')->where('deposit_id',$id)->get();
        return  View::make("admin.$this->model.deposit-investment-leaderboard-pricecards", compact('depositid', 'min_position', 'findallpricecards','name'));
    }

  public function deleteDepositInvestmentLeaderboardPricecard($id) {
        $d_id = unserialize(base64_decode($id));
        DB::table('investment_leaderboard_deposit_pricecards')->where('id',$d_id)->delete();
        Session::flash('success', 'Deleted record.');
        return Redirect::back();
    }

  public function addDepositInvestmentLeaderboardPricecard(Request $request) {
        if($request->isMethod('post')) {
            $input = $request->all();
            $insert['min_position'] = $input['min_position'];
            $insert['max_position'] = $input['min_position']+$input['winners'];
            if(!empty($input['winners'])){
              $insert['winners'] = $input['winners'];
            }else{
              $insert['winners'] = "";
            }
             // $insert['winners'] = $input['winners'];
            //  if(!empty($input['price'])){
            // $insert['price'] = $input['price'];
            //   }else{
            //     $insert['price'] = 0;
            //
            //
            //   }
           if(isset($input['is_gadgets']) && $input['is_gadgets'] == 1){
               $insert['price'] = $input['price'];
               $insert['total'] = $input['winners'];
             }else{

           $insert['price'] = $input['price'];
           $insert['total'] = $input['price']*$input['winners'];
           }
           // $insert['total'] = $input['price']*$input['winners'];
            $insert['deposit_id'] = unserialize(base64_decode($input['series_id']));

               if(Input::hasFile('gadget_image')){
       				$extension = Input::file('gadget_image')->getClientOriginalExtension();
       				$img_ext = explode(",",IMAGE_EXTENSION);

       				if(in_array($extension,$img_ext)){
       					// $destinationPath = 'uploads/players';
       					$folderPath = 'uploads/banners/';
       					// $fileName='11caps-player-'.time();
       					$fileName='PlaynWin11-gadgets_image-'.rand(10000,99999).'.'.$extension;
       						// $fileName=time().'life11-banner-'.$formData['title'].'.'.$extension;
       					// dd($destinationPath);


       					if(Input::file('gadget_image')->move($folderPath, $fileName)){
       						$insert['gadget_image'] = $fileName;
       					}
       						 Helpers::aws_upload_image($folderPath.$fileName, "uploads/banners/",$fileName);
					         @unlink(public_path('uploads/banners/'.$filename));
                //  @unlink(ADVERTISMENTS_PROFILE_IMAGE_URL.$fileName);
                  //end new added
       					 // Helpers::aws_upload_image(PLAYER_IMAGE_ROOT_PATH.$fileName, "uploads/players/",$fileName);
       				}else{
       					Session::flash('error',  trans("messages.$this->model.INVALID_IMAGE_EXTENSION"));
       					return Redirect::back()->withInput();
       				}
       			}

             if(!empty($input['is_gadgets'])){

               $insert['is_gadgets'] = 1;
             }
             else{
               $insert['is_gadgets'] = 0;
             }

            DB::table('investment_leaderboard_deposit_pricecards')->insert($insert);
            Session::flash('success', 'Added breakup.');
            return Redirect::back();
        }
    }

  public function depositInvestmentLeaderboard($series_id) {
        $name = DB::table('deposit_investment')->where('id',unserialize(base64_decode($series_id)))->first()->name;
        $input = Input::all();
        if(isset($input) && !empty($input)){
            $s_id = unserialize(base64_decode($input['series_id']));

            // $s_id = 94;
            return Datatables::of(DB::table('investment_leaderboard_deposit as sl')
                        ->join('registerusers as r','r.id', '=', 'sl.user_id')
                        ->where('sl.deposit_id',$s_id)
                        ->where(function($q) use($input){
                            if(isset($input['username']))
                               $q->where('r.username', 'LIKE', '%'.$input['username'].'%');
                            if(isset($input['email']))
                               $q->where('r.email', 'LIKE', '%'.$input['email'].'%');
                            if(isset($input['mobile']))
                               $q->where('r.mobile', 'LIKE', '%'.$input['mobile'].'%');
                            if(isset($input['team']))
                               $q->where('r.team', 'LIKE', '%'.$input['team'].'%');
                        })
                        ->select('sl.amount', 'sl.rank' , 'sl.points', 'r.team', 'r.email', 'r.mobile', 'r.username')
                        ->orderBy('sl.rank','ASC')
                        ->get())
                        ->addIndexColumn()
                        ->escapeColumns([])
                        ->make(true);
            }//end

        return  View::make("admin.$this->model.deposit-investment-leaderboard", compact('series_id','name'));
    }

  public function depositInvestmentLeaderboardUseAdd($seriedid)
  {
      $s_id = unserialize(base64_decode($seriedid));
      $depositname = DB::table('deposit_investment')->where('id',$s_id)->first()->name;

      $checkadd= DB::table('investment_match_leaderboard')->where('manul_update',1)->where('series_id',$s_id)->groupBy('match_id')->select('match_id')->pluck('match_id')->toArray();

        $input = Input::all();
        if(isset($input) && !empty($input)){
            $s_id = unserialize(base64_decode($input['series_id']));

            $usercheck= DB::table('registerusers')->where('email',$input['email'])->first();
            if(empty($usercheck))
            {
              Session::flash('error', 'User does not exits');
              return Redirect::back();
            }

              $matchinvest= array('deposit_id'=>$s_id,
                                'user_id'=>$usercheck->id,
                                'points'=>$input['price']
                                );
              DB::table('investment_deposit_leaderboard')->insert($matchinvest);
            $this->update_depositinvestments_leaderboard($s_id);
              Session::flash('success', 'Add Investments successfully');
              return Redirect::back();
          }


           return  View::make("admin.$this->model.deposit-investment-leaderboard_add_user", compact('depositname','seriedid','checkadd'));

  }
  public function addDepositInvestmentName()
  {
        $input = Input::all();
        if(isset($input) && !empty($input)){
             $checkname=  DB::table('deposit_investment')->where('name',$input['name'])->first();
              if(!empty($checkname))
            {
              Session::flash('error', 'Deposit Investments Name Already Added');
              return Redirect::back();
            }
              $matchinvest= array('name'=>$input['name'],
                                'start_date'=>$input['start_date'],
                                'end_date'=>$input['end_date']
                                );

              DB::table('deposit_investment')->insert($matchinvest);

              Session::flash('success', 'Add Investments Deposit Name successfully');
              return Redirect::to('/admin/leaderboard/deposit-investment-list');
          }


           return  View::make("admin.$this->model.deposit-investment-name");

  }
  public function update_depositinvestments_leaderboard($series_id) {
    //dd($series_id);
    $match_leaderboard = DB::table('investment_deposit_leaderboard')->select(DB::raw('SUM(points) as points, user_id, deposit_id'))->where('deposit_id', $series_id)->orderByRaw('SUM(points) DESC')->groupBy('user_id')->get();

    $lastpoints = 0; $skip_count = 0;
    $rank = 1;
    $i = 0;

    if(!$match_leaderboard->isEmpty()) {
      foreach ($match_leaderboard as $key => $value) {
        if($value->points == $lastpoints) {
          $skip_count++;
          $data[$i]['rank'] = $rank - $skip_count;
        } else {
          $data[$i]['rank'] = $rank;
          $skip_count = 0;
        }
        $data[$i]['points'] = $value->points;
        $data[$i]['user_id'] = $value->user_id;
        $data[$i]['deposit_id'] = $value->deposit_id;
        $data[$i]['status'] = 1;
        $rank++;
        $i++;
        $lastpoints = $value->points;
      }

      $check = DB::table('investment_leaderboard_deposit')->where('deposit_id',$series_id)->exists();

      if($check) {
        DB::table('investment_leaderboard_deposit')->where('deposit_id',$series_id)->delete();
      }
      DB::table('investment_leaderboard_deposit')->insert($data);
      // echo "<pre>"; print_r($data); exit;
    }

  return 1;
  }

   public function depositInvestmentsLeaderboardWinningDistribute($deposit_id) {
            $s_id = unserialize(base64_decode($deposit_id));

           $exists = DB::table('deposit_investment')->where('id',$s_id)
              //->whereIn('final_status',['pending','IsReviewed'])
              ->where('win_status',1)->exists();

            // dd($exists);
           if($exists) {
           Session::flash('success', "Winner can't declare, as some matches is still in pending/under reviewed.");
           return Redirect::back();
           }
           else {

           $check = DB::table('deposit_investment')->where('id',$s_id)->first()->win_status;
           if($check) {
           Session::flash('success', "Amount distributed already.");
           return Redirect::back();
           }


           $breakup = DB::table('investment_leaderboard_deposit_pricecards')->where('deposit_id',$s_id)->orderBy('id','DESC')->first();
           if(!empty($breakup)) {
           $max_rank = $breakup->max_position;
           $allBreakup = DB::table('investment_leaderboard_deposit_pricecards')->where('deposit_id',$s_id)->get();
           $breakup_arr = array();
           foreach($allBreakup as $key => $value) {
           $min_position = $value->min_position;
           $max_position = $value->max_position;
           for($i = $min_position; $i < $max_position; $i++){
           $breakup_arr[$i+1]=$value->price;
           }
           }

           $allWinners = DB::table('investment_leaderboard_deposit')->where('deposit_id',$s_id)->where('rank','<=',$max_rank)
           ->orderBy('rank','ASC')
           ->select('user_id','rank','points','is_win_credited')
           ->get();

           $same_rank_count = 1; $same_amount = 0; $rank = 1; $win_arr = array();
           foreach ($allWinners as $key => $value) {
           if($key > 0 && $value->rank > $allWinners[$key-1]->rank) {
           $same_rank_count = 1;
           $rank = $value->rank;
           }
           if($key > 0 && $value->rank == $allWinners[$key-1]->rank) {
           $same_rank_count++;
           $amount = $key < $max_rank ? $breakup_arr[$key+1] : 0;
           $same_amount = $same_amount + $amount;
           }
           else {
           $same_amount = $breakup_arr[$value->rank];
           }
           $win_arr[$rank]['count'] = $same_rank_count;
           $win_arr[$rank]['amount'] = $same_amount;
           }
          // dd($win_arr[$value->rank]['amount']);
           foreach ($allWinners as $key => $value) {
               $amt = ((int)$win_arr[$value->rank]['amount']) / (int)$win_arr[$value->rank]['count'];
               $amount = number_format($amt,2,'.','');
               $update['amount'] = $amount;
               DB::table('investment_leaderboard_deposit')->where('deposit_id',$s_id)->where('user_id',$value->user_id)->update($update);
           }

           $this->depositInvestmentsLeaderboardWinningUpdate($s_id);
      //     $this->seriesLeaderboardWinningUpdate($s_id);
           DB::table('deposit_investment')->where('id',$s_id)->update(['win_status'=>1]);

           Session::flash('success', "Winning distribute successfully.");
           return Redirect::back();

           }
           else {
           Session::flash('success', "First set series winning breakup");
           return Redirect::back();
           }
           }
     }
  public function depositInvestmentsLeaderboardWinningUpdate($investment_leaderboard_id) {
   // dd($investment_leaderboard_id);
    $breakup = DB::table('investment_leaderboard_deposit_pricecards')->where('deposit_id',$investment_leaderboard_id)->orderBy('id','DESC')->first();
    $max_rank = $breakup->max_position;
    $allWinners = DB::table('investment_leaderboard_deposit')->where('deposit_id',$investment_leaderboard_id)
    ->where('rank','<=',$max_rank)
    ->where('amount','>',0)
    ->where('is_win_credited',0)
    ->orderBy('rank','ASC')
    ->select('user_id','rank','amount')
    ->get();
    // echo "<pre>";print_r($allWinners);die();
    if(!$allWinners->isEmpty()) {
      foreach ($allWinners as $key => $value) {
        //update userbalance
        $amount = $value->amount;
        $user_id = $value->user_id;

        $update_is_win_credited['is_win_credited'] = 1;
        DB::table('investment_leaderboard_deposit')->where('deposit_id',$investment_leaderboard_id)->where('user_id',$user_id)->update($update_is_win_credited);

        if($amount > 10000) {
          // $tds_amount = $amount*30/100;
          $tds_amount = 0;
          $new_amount = $amount - $tds_amount;

          $userBalance = DB::table('userbalances')->where('user_id',$user_id)->first();
          $updateBalance['winning'] = $userBalance->winning + $new_amount;
          DB::table('userbalances')->where('user_id',$user_id)->update($updateBalance);


          $bal_bonus_amt = number_format($userBalance->bonus,2,'.','');
          $bal_win_amt = number_format($updateBalance['winning'],2,'.','');
          $bal_fund_amt = number_format($userBalance->balance,2,'.','');
          $bal_gstbonus_amt = number_format($userBalance->gst_bonus,2,'.','');
          $bal_affi_amt = number_format($userBalance->affiliation_commission,2,'.','');
          $bal_total_amt = $bal_bonus_amt+$bal_win_amt+$bal_fund_amt+ $bal_gstbonus_amt+$bal_affi_amt;

          //winning amount transaction entry
          $trans_id = "INVDEPOSIT-WIN-AM" .FLOOR(RAND() * 90000). $user_id . (int)$new_amount;
          $transaciton = new Transaction();
          $transaciton->userid = $user_id;
          $transaciton->type = "Investments Deposit Winning";
          $transaciton->transaction_id = $trans_id;
          $transaciton->transaction_by = "PlaynWin11";
          $transaciton->amount = $new_amount;
          $transaciton->paymentstatus = "confirmed";
          // $transaction->seriesid = $series_id;
          $transaciton->win_amt = $new_amount;
          $transaciton->bal_bonus_amt = $bal_bonus_amt;
          $transaciton->bal_win_amt = $bal_win_amt;
          $transaciton->bal_fund_amt = $bal_fund_amt;
          $transaciton->bal_gst_bonus_amt = $bal_gstbonus_amt;
          $transaciton->bal_affi_amt = $bal_affi_amt;
          $transaciton->total_available_amt = $bal_total_amt;
          $transaciton->save();
          //end /winning amount transaction entry

          // $tds_tdsdetails['userid'] = $user_id;
          // $tds_tdsdetails['tds_amount'] = $tds_amount;
          // $tds_tdsdetails['amount'] = $amount;
          // $tds_tdsdetails['seriesid'] = $series_id;
          // DB::table('tdsdetails')->insert($tds_tdsdetails);

          //xxxxxxxxxxxxxx winning tds amount transaction entry xxxxxxxxxxxxxx
          // $trans_tds_id = "INVLDRBRD-WIN-TDS" .FLOOR(RAND() * 90000). $user_id . (int)$tds_amount;
          // $transaciton_tds = new Transaction();
          // $transaciton_tds->userid = $user_id;
          // $transaciton_tds->type = "Investments Leaderboard Winning";
          // $transaciton_tds->transaction_id = $trans_tds_id;
          // $transaciton_tds->transaction_by = "LIFE11";
          // $transaciton_tds->amount = $tds_amount;
          // $transaciton_tds->paymentstatus = "confirmed";
          // // $transaction_tds->seriesid = $series_id;
          // $transaciton_tds->bal_bonus_amt = $bal_bonus_amt;
          // $transaciton_tds->bal_win_amt = $bal_win_amt;
          // $transaciton_tds->bal_fund_amt = $bal_fund_amt;
          // $transaciton_tds->total_available_amt = $bal_total_amt;
          // $transaciton_tds->cons_win = $tds_amount;
          // $transaciton_tds->save();
          //end /winning tds amount transaction entry
        }
        else {
          $userBalance = DB::table('userbalances')->where('user_id',$user_id)->first();
          $updateBalance['winning'] = $userBalance->winning + $amount;
          DB::table('userbalances')->where('user_id',$user_id)->update($updateBalance);

          $bal_bonus_amt = number_format($userBalance->bonus,2,'.','');
          $bal_win_amt = number_format($updateBalance['winning'],2,'.','');
          $bal_fund_amt = number_format($userBalance->balance,2,'.','');
          $bal_gstbonus_amt = number_format($userBalance->gst_bonus,2,'.','');
          $bal_affi_amt = number_format($userBalance->affiliation_commission,2,'.','');
          $bal_total_amt = $bal_bonus_amt+$bal_win_amt+$bal_fund_amt+ $bal_gstbonus_amt+$bal_affi_amt;

          //update transaction
          $trans_id = "INVDEPOSIT-WIN-AM" .FLOOR(RAND() * 90000). $user_id . (int)$amount;
          $transaciton = new Transaction();
          $transaciton->userid = $user_id;
          $transaciton->type = "Investments Deposit Winning";
          $transaciton->transaction_id = $trans_id;
          $transaciton->transaction_by = "PlaynWin11";
          $transaciton->amount = $amount;
          $transaciton->paymentstatus = "confirmed";
          // $transaction->seriesid = $series_id;
          $transaciton->win_amt = $amount;
          $transaciton->bal_bonus_amt = $bal_bonus_amt;
          $transaciton->bal_win_amt = $bal_win_amt;
          $transaciton->bal_fund_amt = $bal_fund_amt;
          $transaciton->bal_gst_bonus_amt = $bal_gstbonus_amt;
          $transaciton->bal_affi_amt = $bal_affi_amt;
          $transaciton->total_available_amt = $bal_total_amt;
          $transaciton->save();
        }
      }
    }
  }

    public function promoterSeriesList(){
       // dd('hii');
         $formData = Input::all();
         if(isset($formData) && !empty($formData)){
             return Datatables::of(DB::table('promoter_leaderboard_series')
             ->where('status',1)->get())
                ->addIndexColumn()
                ->addColumn('name',function ($result){
                     return $result->name;
                })
                ->addColumn('start_date',function ($result){
                       return @$result->start_date;
                })
                ->addColumn('end_date',function ($result){
                     return @$result->end_date;
                })
                ->addColumn('matches',function ($result){
                     $findmatches=DB::table('listmatches')
                     ->whereBetween('start_date', [$result->start_date, $result->end_date])
                     ->count();
                       return $findmatches;
                })
                ->addColumn('series',function ($result){
                  $findmatches=DB::table('series')
                  ->wheredate('start_date','>=',$result->start_date)
                  ->wheredate('start_date','>=',$result->end_date)
                  ->count();
                     return $findmatches;
                })
                ->addColumn('series_win_status', function($result) {
                     if($result->win_distrubute == 1)
                         return 'Declared';
                     else
                         return 'Not Declare';
                })
                ->addColumn('action', function ($result) {
                     // $pricecards = '<a href="'.route($this->model.'.seriesLeaderboardPricecards',base64_encode(serialize($result->id))).'" class="btn btn-rg icon mr-1 mt-1" data-toggle="tooltip" title="Pricecards"><i class="fa fa-rupee" aria-hidden="true" data-original-title="Pricecards" ></i></a>';
                     // $leaderboard = '<a href="'.route($this->model.'.seriesLeaderboard',base64_encode(serialize($result->id))).'" class="btn btn-rg icon mr-1 mt-1" data-toggle="tooltip" title="Leaderboard"><i class="fa fa-trophy" aria-hidden="true" data-original-title="Leaderboard" ></i></a>';
                     //
                     // $winningDistribute = '';
                     // if($result->is_promoter_leaderboard_win_distribute == 0)
                     //     $winningDistribute = '<a href="'.route($this->model.'.seriesLeaderboardWinningDistribute',base64_encode(serialize($result->id))).'" class="btn btn-rg icon mr-1 mt-1" data-toggle="tooltip" title="Winning distribute"><i class="fa fa-gift" aria-hidden="true" data-original-title="Winning distribute" ></i></a>';
                     //
                     // return $leaderboard.' '.$pricecards.' '.$winningDistribute;
                     // $pricecards = '<a href="'.route($this->model.'.seriesPromotorLeaderboardPricecards',base64_encode(serialize($result->id))).'" class="btn btn-rg icon mr-1 mt-1" data-toggle="tooltip" title="Pricecards"><i class="fa fa-rupee" aria-hidden="true" data-original-title="Pricecards" ></i></a>';
                     $leaderboard = '<a href="'.route($this->model.'.seriesPromotorLeaderboard',$result->id).'" class="btn btn-rg icon mr-1 mt-1" data-toggle="tooltip" title="Leaderboard"><i class="fa fa-trophy" aria-hidden="true" data-original-title="Leaderboard" ></i></a>';
                     $pricecards = '<a href="'.route($this->model.'.seriesPromotorLeaderboardPricecards',base64_encode(serialize($result->id))).'" class="btn btn-rg icon mr-1 mt-1" data-toggle="tooltip" title="Pricecards"><i class="fa fa-rupee" aria-hidden="true" data-original-title="Pricecards" ></i></a>';

                     $winningDistribute = '';
                     if($result->win_distrubute == 0)
                         $winningDistribute = '<a href="'.route($this->model.'.seriesPromoterLeaderboardWinningDistribute',base64_encode(serialize($result->id))).'" class="btn btn-rg icon mr-1 mt-1" data-toggle="tooltip" title="Winning distribute"><i class="fa fa-gift" aria-hidden="true" data-original-title="Winning distribute" ></i></a>';

                     return $leaderboard.' '.$pricecards.' '.$winningDistribute;
                 })
                 ->escapeColumns([])
                 ->make(true);
             }//end
             $seriesSelect = DB::table('promoter_leaderboard_series')
                         ->join('series','series.id','=','promoter_leaderboard_series.series_id')
                         ->select('series.*')
                         ->where('is_promoter_series_leaderboard',1)
                         ->get();
             return  View::make("admin.$this->model.promotor-series",compact('seriesSelect'));
             //return  View::make("admin.$this->model.series-list");
     }
     public function seriesPromoterLeaderboardWinningDistribute($promoter_leaderboard_id) {
         // dd('winnig');
         $pl_id = unserialize(base64_decode($promoter_leaderboard_id));
         $pl_users = DB::table('promoter_leaderboard_users')
         ->where('id',$pl_id)
         ->first();

         $exists = DB::table('listmatches')->where('series',$pl_users->series_id)->whereIn('final_status',['pending','IsReviewed'])->where('launch_status','launched')->exists();

         if($exists) {
           Session::flash('success', "Winner can't declare, as some matches is still in pending/under reviewed.");
           return Redirect::back();
         }
         else {
           $check = DB::table('promoter_leaderboard_series')->where('id',$pl_id)->first()->win_distrubute;
           if($check) {
             Session::flash('success', "Amount distributed already.");
             return Redirect::back();
           }

           $this->promoterLeaderboardWinningDistribute($pl_id);
           echo 'success';exit;


         }
       }
public function seriesPromoterLeaderboardWinningDistribute_old($series_id) {
    // dd('winnig');
    $s_id = unserialize(base64_decode($series_id));
    $exists = DB::table('listmatches')->where('promoter_leaderboard_id',$s_id)->whereIn('final_status',['pending','IsReviewed'])->where('launch_status','launched')->exists();
    if($exists) {
      Session::flash('success', "Winner can't declare, as some matches is still in pending/under reviewed.");
      return Redirect::back();
    }
    else {
      $check = DB::table('promoter_leaderboard_series')->where('id',$s_id)->first()->win_distrubute;
      $data=array(
        "win_distrubute"=>1
      );
      $this->promoterLeaderboardWinningDistribute($series_id);
      DB :: table('promoter_leaderboard_series')->where('id',$series_id)->update($data);

      if($check) {

        Session::flash('success', "Amount distributed already.");
        return Redirect::back();
      }


      // $breakup = DB::table('series_leaderboard_pricecards')->where('series_id',$s_id)->orderBy('id','DESC')->first();
      // Changed by Aavesh 03-030-23 12:45
      $breakup = DB::table('promoter_leaderboard_pricecards')->where('series_id',$s_id)->orderBy('id','DESC')->first();
      // Changed by Aavesh 03-030-23 12:45 end //
      if(!empty($breakup)) {
        // dd($breakup->max_position);
        $max_rank = $breakup->max_position;

        //  $allBreakup = DB::table('series_leaderboard_pricecards')->where('series_id',$s_id)->get();

        // Changed by Aavesh 03-030-23 12:45
        $allBreakup = DB::table('promoter_leaderboard_pricecards')->where('series_id',$s_id)->get();
        // Changed by Aavesh 03-030-23 12:45 end //

        $breakup_arr = array();
        foreach($allBreakup as $key => $value) {
          $min_position = $value->min_position;
          $max_position = $value->max_position;
          for($i = $min_position; $i < $max_position; $i++){
            $breakup_arr[$i+1]=$value->price;
          }
        }

        // $allWinners = DB::table('series_leaderboard')->where('series_id',$s_id)->where('rank','<=',$max_rank)
        // ->orderBy('rank','ASC')
        // ->select('user_id','rank','points','is_win_credited')
        // ->get();

        // Changed by Aavesh 03-030-23 12:45
        $allWinners = DB::table('promoter_series_leaderboard')->where('series_id',$s_id)->where('rank','<=',$max_rank)
        ->orderBy('rank','ASC')
        ->select('user_id','rank','points','is_win_credited')
        ->get();

        // Changed by Aavesh end //

        $same_rank_count = 1; $same_amount = 0; $rank = 1; $win_arr = array();
        foreach ($allWinners as $key => $value) {
          if($key > 0 && $value->rank > $allWinners[$key-1]->rank) {
            $same_rank_count = 1;
            $rank = $value->rank;
          }
          if($key > 0 && $value->rank == $allWinners[$key-1]->rank) {
            $same_rank_count++;
            $amount = $key < $max_rank ? $breakup_arr[$key+1] : 0;
            $same_amount = $same_amount + $amount;
          }
          else {
            $same_amount = $breakup_arr[$value->rank];
          }
          $win_arr[$rank]['count'] = $same_rank_count;
          $win_arr[$rank]['amount'] = $same_amount;
        }

        foreach ($allWinners as $key => $value) {
          $amt = $win_arr[$value->rank]['amount'] / $win_arr[$value->rank]['count'];
          $amount = number_format($amt,2,'.','');
          $update['amount'] = $amount;
          // DB::table('series_leaderboard')->where('series_id',$s_id)->where('user_id',$value->user_id)->update($update);

          // Changed by Aavesh 03-030-23 12:45
          DB::table('promoter_series_leaderboard')->where('series_id',$s_id)->where('user_id',$value->user_id)->update($update);
          // Changed by Aavesh 03-030-23 12:45 end //
        }
        // $this->seriesLeaderboardWinningUpdate($s_id);
        // changed by Aavesh 03-03-23 1:00pm
      //  $this->PromoterseriesLeaderboardWinningUpdate($s_id);
        // changed by Aavesh 03-03-23 1:00pm end

        DB::table('series')->where('id',$s_id)->update(['is_leaderboard_win_distribute'=>1]);
        Session::flash('success', "Winning distribute successfully.");
        return Redirect::back();

      }
      else {
        Session::flash('success', "First set series winning breakup");
        return Redirect::back();
      }
    }
  }

public function promoterLeaderboardWinningDistribute($promoter_leaderboard_id) {
      $pl_id = unserialize(base64_decode($promoter_leaderboard_id));

      $pl_users = DB::table('promoter_leaderboard_users')
      ->where('id',$pl_id)
      ->first();

      if(!empty($pl_users)){



      $breakup = DB::table('promoter_leaderboard_pricecards')
      ->where('promoter_leaderboard_id',$pl_id)
      ->orderBy('id','DESC')->first();
      // dd($breakup);
      if(!empty($breakup)) {
      $max_rank = $breakup->max_position;
      $allBreakup = DB::table('promoter_leaderboard_pricecards')->where('promoter_leaderboard_id',$pl_id)->get();
      $breakup_arr = array();
      foreach($allBreakup as $key => $value) {
        $min_position = $value->min_position;
        $max_position = $value->max_position;
        for($i = $min_position; $i < $max_position; $i++){
        $breakup_arr[$i+1]=$value->price;
        }
      }

      $allWinners = DB::table('promoter_series_leaderboard')->where('promoter_leaderboard_id',$pl_id)->where('rank','<=',$max_rank)
      ->orderBy('rank','ASC')
      ->select('user_id','rank','points','is_win_credited')
      ->get();
      // dd($allWinners);
      $same_rank_count = 1; $same_amount = 0; $rank = 1; $win_arr = array();
      foreach ($allWinners as $key => $value) {
      if($key > 0 && $value->rank > $allWinners[$key-1]->rank) {
      $same_rank_count = 1;
      $rank = $value->rank;
      }
      if($key > 0 && $value->rank == $allWinners[$key-1]->rank) {
      $same_rank_count++;
      $amount = $key < $max_rank ? $breakup_arr[$key+1] : 0;
      $same_amount = $same_amount + $amount;
      }
      else {
      $same_amount = @$breakup_arr[$value->rank];
      }
      $win_arr[$rank]['count'] = $same_rank_count;
      $win_arr[$rank]['amount'] = $same_amount;
      }

      foreach ($allWinners as $key => $value) {
          $amt = $win_arr[$value->rank]['amount'] / $win_arr[$value->rank]['count'];
          $amount = number_format($amt,2,'.','');
          $update['amount'] = $amount;
          DB::table('promoter_series_leaderboard')->where('promoter_leaderboard_id',$pl_id)->where('user_id',$value->user_id)->update($update);
      }
    //  $this->PromoterseriesLeaderboardWinningUpdate($s_id);
      DB::table('promoter_leaderboard_users')->where('id',$pl_id)->update(['win_distrubute'=>1]);
      Session::flash('success', "Winning distribute successfully.");
      return Redirect::back();

      }
      else {
      Session::flash('success', "First set series winning breakup");
      return Redirect::back();
      }
      }
}



       public function seriesPromotorLeaderboardPricecards($promoter_leaderboard_user_id) {
       $id = unserialize(base64_decode($promoter_leaderboard_user_id));
       //echo $id;die;

       $leaderboard_data=DB::table('promoter_leaderboard_users as sl')
       ->leftjoin('series as psl','sl.series_id','=','psl.id')
       ->leftjoin('registerusers as r','r.id', '=', 'sl.user_id')
       ->select(
         'sl.*',
         'psl.name as series_name','psl.start_date','psl.end_date','psl.start_date','psl.start_date','psl.is_promoter_series_leaderboard','psl.series_status',
         'r.username','r.mobile','r.team','r.refercode'
       )
       ->where('sl.id',$id)
       ->first();
        //dd($leaderboard_data);

       $query = DB::table('promoter_leaderboard_pricecards')->where('promoter_leaderboard_id',$id)
       ->where('sports_type',1)
       ->orderBy('id', 'DESC')
       ->first();
       if(!empty($query))
           $min_position = $query->max_position;
       else
           $min_position = 0;

       $findallpricecards = DB::table('promoter_leaderboard_pricecards')->where('promoter_leaderboard_id',$id)->get();
       // var_dump('$min_position');exit;
       return  View::make("admin.$this->model.promotor-series-pricecard", compact('leaderboard_data', 'min_position', 'findallpricecards'));
   }
    public function addSeriesPromotorLeaderboardPricecard(Request $request) {

      $validatedData = $request->validate([
               'winners' => 'required',
               //'price' => 'required',
           ]);

        if($request->isMethod('post')) {

            $input = $request->all();
            $insert['min_position'] = $input['min_position'];
            $insert['max_position'] = $input['min_position']+$input['winners'];
            $insert['winners'] = $input['winners'];
            //$insert['price'] = $input['price'];
            $insert['sports_type'] =1;
            //$insert['total'] = $input['price']*$input['winners'];
            if(isset($input['is_gadgets']) && $input['is_gadgets'] == 1){
                $insert['gadgets_name'] = $input['gadgets_name'];
                $insert['total'] = $input['winners'];
              }else{

            $insert['price'] = $input['price'];
            $insert['total'] = $input['price']*$input['winners'];
            }

            if(!empty($input) && !empty($input['base64image'])){

            if ($input['base64image'] || $input['base64image'] != '0') {

            $folderPath = 'uploads/banners/';

            $image_parts = explode(";base64,", $request->base64image);
            $image_type_aux = explode("image/", $image_parts[0]);

            if(!isset($image_type_aux[1]) && empty($image_type_aux[1]))
            {
             Session::flash('error',  trans("Image failed Please again upload"));
            return Redirect::back();
            }
                       $image_type = $image_type_aux[1];

                       $image_base64 = base64_decode($image_parts[1]);

                //$filename = BRAND['name'].'-player-'.rand(1000,9999).".".$image_type;
            $filename='PlaynWin11-gadgets_image-'.rand(10000,99999).'.'.$image_type;
            $file =$folderPath.$filename;
            file_put_contents($file, $image_base64);
            // $fileName=	$this->aws_upload_image(CHALLENGE_IMAGE_URL_ROOT_PATH.$filename,$folderPath,$filename);
            $insert['gadgets_image'] = $filename;
            Helpers::aws_upload_image($folderPath.$filename, "uploads/banners/",$filename);
            //@unlink('uploads/categories/'.$filename);
            @unlink(public_path('uploads/banners/'.$filename));

            }}

            if(!empty($input['is_gadgets'])){

              $insert['is_gadgets'] = 1;
            }
            else{
              $insert['is_gadgets'] = 0;
            }

            $insert['series_id'] = $input['series_id'];
            $insert['promoter_leaderboard_id'] = $input['promoter_leaderboard_id'];
            DB::table('promoter_leaderboard_pricecards')->insert($insert);
            Session::flash('success', 'Promoter Leaderboard Price Card Added!.');
            return Redirect::back();
        }


    }
    public function deletepromoterSeriesLeaderboardPricecard($id) {
        $d_id = unserialize(base64_decode($id));
        DB::table('promoter_leaderboard_pricecards')->where('id',$d_id)->delete();
        Session::flash('success', 'Deleted record.');
        return Redirect::back();
    }
    public function seriesPromotorLeaderboard($series_id=20) {
      $leaderboard_data=DB::table('promoter_leaderboard_users as sl')
               ->leftjoin('series as psl','sl.series_id','=','psl.id')
               ->leftjoin('registerusers as r','r.id', '=', 'sl.user_id')
               ->select(
                 'sl.*',
                 'psl.name as series_name','psl.start_date','psl.end_date','psl.start_date','psl.start_date','psl.is_promoter_series_leaderboard','psl.series_status',
                 'r.username','r.mobile','r.team','r.refercode'
               )
               ->where('sl.id',$series_id)
               ->first();

         $formData = Input::all();
         if(isset($formData) && !empty($formData)){

                  $s_id = $formData['series_id'];
                  return Datatables::of(DB::table('promoter_series_leaderboard as sl')
                              ->join('registerusers as r','r.id', '=', 'sl.user_id')
                              ->where('sl.promoter_leaderboard_id',$series_id)
                              //->where('psl.sports_type',1)
                              ->where(function($q) use($formData){
                                  if(isset($formData['username']))
                                     $q->where('r.username', 'LIKE', '%'.$formData['username'].'%');
                                  if(isset($formData['email']))
                                     $q->where('r.email', 'LIKE', '%'.$formData['email'].'%');
                                  if(isset($formData['mobile']))
                                     $q->where('r.mobile', 'LIKE', '%'.$formData['mobile'].'%');
                                  if(isset($formData['team']))
                                     $q->where('r.team', 'LIKE', '%'.$formData['team'].'%');
                              })
                              ->select('amount', 'rank' , 'points', 'team', 'email', 'mobile', 'username')
                              ->orderBy('rank','ASC')
                              // ->limit(5000)
                              ->get())
                              ->addIndexColumn()
                               ->addColumn('username',function ($result){
                                    return $result->username;
                               })
                                ->addColumn('email',function ($result){
                                     return $result->email;
                                })

                                ->addColumn('mobile',function ($result){
                                     return $result->mobile;
                                })
                                ->addColumn('mobile',function ($result){
                                     return $result->mobile;
                                })
                                ->addColumn('points',function ($result){
                                     return $result->points;
                                })
                                ->addColumn('amount',function ($result){
                                     return $result->amount;
                                })

                                ->addColumn('rank',function ($result){
                                     return $result->rank;
                                })
                               ->escapeColumns([])
                              ->make(true);
                  }
        return  View::make("admin.$this->model.promoter-leaderboard", compact('series_id','leaderboard_data'));
      }
     public function seriesPromotorLeaderboard_old($series_id=20) {
         $name = DB::table('promoter_leaderboard_series')->where('id',$series_id)->first()->name;
          $formData = Input::all();
          if(isset($formData) && !empty($formData)){
                 $s_id = $formData['series_id'];
                   return Datatables::of(DB::table('promoter_leaderboard_users as sl')
                               ->join('promoter_series_leaderboard as psl','psl.promoter_leaderboard_id','=','sl.promoter_leaderboard_id')
                               ->join('registerusers as r','r.id', '=', 'sl.user_id')
                               ->where('psl.promoter_leaderboard_id',$s_id)
                               ->where('psl.sports_type',1)
                               ->where(function($q) use($formData){
                                   if(isset($formData['username']))
                                      $q->where('r.username', 'LIKE', '%'.$formData['username'].'%');
                                   if(isset($formData['email']))
                                      $q->where('r.email', 'LIKE', '%'.$formData['email'].'%');
                                   if(isset($formData['mobile']))
                                      $q->where('r.mobile', 'LIKE', '%'.$formData['mobile'].'%');
                                   if(isset($formData['team']))
                                      $q->where('r.team', 'LIKE', '%'.$formData['team'].'%');
                               })
                               ->select('amount', 'rank' , 'points', 'team', 'email', 'mobile', 'username')
                               ->orderBy('rank','ASC')
                               // ->limit(5000)
                               ->get())
                               ->addIndexColumn()
                                ->addColumn('username',function ($result){
                                     return $result->username;
                                })
                                 ->addColumn('email',function ($result){
                                      return $result->email;
                                 })

                                 ->addColumn('mobile',function ($result){
                                      return $result->mobile;
                                 })
                                 ->addColumn('mobile',function ($result){
                                      return $result->mobile;
                                 })
                                 ->addColumn('points',function ($result){
                                      return $result->points;
                                 })
                                 ->addColumn('amount',function ($result){
                                      return $result->amount;
                                 })

                                 ->addColumn('rank',function ($result){
                                      return $result->rank;
                                 })
                                ->escapeColumns([])
                               ->make(true);
                   }
         return  View::make("admin.$this->model.promoter-leaderboard", compact('series_id','name'));
       }


}
?>
