<?php

namespace App\Http\Controllers\Admin;
// use Excel;
use Carbon\Carbon;
use App\Http\Controllers\BaseController;
use App\Http\Controllers\Cricketapi2Controller;
use App\Http\Controllers\CricketapiController;
use App\Http\Controllers\FootballController;
use App\Http\Controllers\BasketBallController;
use App\Http\Controllers\KabaddiController;
use Illuminate\Http\Request;
use App\Helpers\Helpers;
use \stdClass;
use mPDF;
use App\Services\Input;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\File;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\View;
use Yajra\DataTables\Facades\DataTables;

date_default_timezone_set('Asia/Kolkata');
class MatchesController extends BaseController
{

  public $model   =   'Matches';

  public function __construct()
  {
    View::share('modelName', $this->model);
  }

  public function deleteplayernew($id)
  {
    if (!empty($id)) {
      $checkplayer = DB::table('matchplayers')->where('id', $id)->first();
      if (!empty($checkplayer)) {
        DB::table('matchplayers')->where('id', $id)->delete();
      }
      return redirect()->back();
    }
    return redirect()->back();
  }


  public function sendMatchAlerts()
  {
    date_default_timezone_set('Asia/Kolkata');
    $from_time = Carbon::now()->format('Y-m-d H:i:s');
    $to_time = Carbon::now()->addMinutes(30)->format('Y-m-d H:i:s');

    // $findmatchexist = DB::table('listmatches')->whereDate('start_date','<=',date('Y-m-d',strtotime('+30 minutes')))->where('launch_status','launched')->where('final_status','!=','winnerdeclared')->where('final_status','!=','IsCanceled')->where('status','!=','completed')
    // //  ->where('matchkey','63349')
    // ->orderBy('id','DESC')->get();

    $findmatchexist = DB::table('listmatches')
      ->whereBetween('start_date', [$from_time, $to_time])
      ->where('launch_status', 'launched')->where('final_status', '!=', 'winnerdeclared')
      ->where('final_status', '!=', 'IsCanceled')
      ->where('status', '!=', 'completed')
      ->orderBy('id', 'DESC')
      ->get();
    //echo '<pre>'; print_r($findmatchexist);exit;
    if (!empty($findmatchexist)) {
      foreach ($findmatchexist as $val) {
        $match_type = $val->format;
        $getcurrentdate = date('Y-m-d H:i:s');
        $matchtimings = $val->start_date;

        // if(date('Y-m-d H:i:s', strtotime('+30 minutes', strtotime($getcurrentdate))) > $matchtimings && $getcurrentdate <= $matchtimings){
        if (1) {
          $match_key = $val->matchkey;
          $matchalertsDb = DB::table('matchalerts')->where('match_key', $match_key)
            ->where('status', 0)
            ->get();
          // dd($matchalertsDb); exit;
          foreach ($matchalertsDb as $key => $value) {
            $findMatchDetails = DB::table("listmatches")->where('matchkey', $value->match_key)->first();
            $titleget = "Match Alert";
            $short_name = $findMatchDetails->short_name;
            $msg = $short_name . ' match will start in few minutes.';
            //   Helpers::sendnotification($titleget,$msg,'',$value->user_id);
            $dbUpdate['status'] = 1;
            DB::table('matchalerts')->where('id', $value->id)->update($dbUpdate);
          }
        }
      }
    }
  }

  public function teamsscoreupdate()
  {
    $formData  =  Input::all();
    if (!empty($formData)) {
      $matchkey = $formData['matchkey'];
      $sport_type = $formData['sport_type'];
      $rules = array(
        'team1_runs' => 'required',
        'team2_runs' => 'required',
      );
      $validator = Validator::make(Input::all(), $rules);
      if ($validator->fails()) {
        return Redirect::back()->withErrors($validator)->withInput();
      } else {
        $existmatchdetails = DB::table('matchruns')->where('matchkey', $matchkey)
          ->where('sport_type', $sport_type)
          ->first();
        if (empty($existmatchdetails)) {
          $insertData = array();
          $insertData['matchkey'] = $matchkey;
          $insertData['sport_type'] = $sport_type;
          $insertData['teams1'] = $formData['team1_name'];
          $insertData['runs1'] = $formData['team1_runs'];
          $UpdateData['overs1'] = $formData['team1_overs'];
          $UpdateData['wickets1'] = $formData['team1_wickets'];
          $insertData['teams2'] = $formData['team2_name'];
          $insertData['runs2'] = $formData['team2_runs'];
          $UpdateData['overs2'] = $formData['team2_overs'];
          $UpdateData['wickets2'] = $formData['team2_wickets'];
          DB::table('matchruns')->insert($insertData);
        } else {
          $UpdateData = array();
          $UpdateData['teams1'] = $formData['team1_name'];
          $UpdateData['runs1'] = $formData['team1_runs'];
          $UpdateData['overs1'] = $formData['team1_overs'];
          $UpdateData['wickets1'] = $formData['team1_wickets'];
          $UpdateData['teams2'] = $formData['team2_name'];
          $UpdateData['runs2'] = $formData['team2_runs'];
          $UpdateData['overs2'] = $formData['team2_overs'];
          $UpdateData['wickets2'] = $formData['team2_wickets'];
          DB::table('matchruns')->where('matchkey', $matchkey)
            ->where('sport_type', $sport_type)
            ->update($UpdateData);
        }

        Session::flash('flash_notice', 'Match Scores Update Successfully !');
        Session::flash('alert-class', 'alert-success');
        return redirect()->back();
      }
    }
  }

  public function addAssumptionPlayers(Request $request, $id, $sport_id = 1)
  {

    if ($request->isMethod('post')) {
      $post = $request->all(); //print_r($post); exit;
      $matchkey = $post['matchid'];
      $players = isset($post['playing_11_team']) ? $post['playing_11_team'] : array();


      $upStatus['is_assumption'] = 0;
      DB::table('matchplayers')->where('matchkey', $matchkey)->update($upStatus);

      $upStatus['is_assumption'] = 1;
      DB::table('matchplayers')->where('matchkey', $matchkey)->whereIn('playerid', $players)->update($upStatus);

      return redirect()->back()->with('success', 'Assumption Players added successfully');
    }
    $match_detail = DB::table('listmatches')->join('teams as team1', 'team1.id', '=', 'listmatches.team1')->join('teams as team2', 'team2.id', '=', 'listmatches.team2')->where('matchkey', $id)->select('listmatches.*', 'team1.team as team1_name', 'team1.logo as team1_logo', 'team1.short_name as team1_short_name', 'team2.team as team2_name', 'team2.logo as team2_logo', 'team2.short_name as team2_short_name')->first();

    $players = DB::table('players')->join('matchplayers', function ($join) use ($match_detail) {
      $join->on('players.id', '=', 'matchplayers.playerid');
      $join->on('matchplayers.matchkey', '=', DB::raw("'" . $match_detail->matchkey . "'"));
    })
      //->where('matchkey', $id)
      ->whereIn('team', array($match_detail->team1, $match_detail->team2))->select('players.*')->groupBy('players.id')->get();

    $team1_players = array();
    $team2_players = array();
    foreach ($players as $key => $value) {
      if ($value->team == $match_detail->team1) {
        $team1_players[] = $value;
      } else {
        $team2_players[] = $value;
      }
    }

    $selectedPlaying = DB::table('matchplayers')->where('matchkey', $match_detail->matchkey)->where('is_assumption', 1)->pluck('playerid')->toArray();
    if (!$selectedPlaying) {
      $selectedPlaying = array();
    }
    // return view("admin.$this->model.lineup",compact('match_detail','team1_players','team2_players','playing' , 'selectedPlaying'));
    return view("admin.$this->model.addAssumptionPlayers", compact('match_detail', 'team1_players', 'team2_players', 'selectedPlaying', 'sport_id'));
  }

  //Match Mapping
  public function matchmapping($sport_type = 1)
  {
    $formData = Input::all();
    date_default_timezone_set('Asia/Kolkata');
    $locktime = date('Y-m-d H:i:s', strtotime('-60 min'));
    $currentdate = date('Y-m-d H:i:s');

    $sportTypes = DB::table('sport_types')->where('admin_status', 1)->get();
    $sports = [];
    foreach ($sportTypes as $sport) {
      $sports[$sport->id] = $sport->sport_name;
    }

    $sportsKey = [];
    foreach ($sportTypes as $sport) {
      $sportsKey[$sport->id] = $sport->sport_key;
    }
    if (isset($formData) && !empty($formData)) {
      return Datatables::of(DB::table('listmatches')
        ->leftjoin('series', 'listmatches.series', '=', 'series.id')
        ->leftjoin('teams as t1', 't1.id', '=', 'listmatches.team1')
        ->leftjoin('teams as t2', 't2.id', '=', 'listmatches.team2')
        ->select('t1.id as team1id', 't2.id as team2id', 't1.short_name as team1name', 't2.short_name as team2name', 't1.team_key as team1key', 't2.team_key as team2key', 't1.logo as team1logo', 't2.logo as team2logo', 't2.team_key as team2key', 'listmatches.id as listmatchid', 'series.name as seriesname', 'listmatches.*')
        ->where('status', '!=', 'completed')
        ->where('listmatches.sport_type', $sport_type)
        ->where('listmatches.start_date', '>', $currentdate)
        ->orderBY('listmatches.start_date', 'ASC')->get())
        ->addIndexColumn()
        ->addColumn('name', function ($result) {
          return ucwords($result->name) . ' ' . ucwords($result->seriesname);
        })
        ->addColumn('sport_type', function ($result) {
          return DB::table('sport_types')->where('id', $result->sport_type)->first()->sport_name;
        })
        ->addColumn('start_date', function ($result) {
          return date('l, d-M-y h:i:s a', strtotime($result->start_date));
        })
        ->addColumn('teams', function ($result) {
          $team = '<div style= "display:flex; align-items:center;">
                    <div style="float:left; width:45%; text-align: center;">';
          $team .= $result->team1name;
          // if($result->team1logo != ''  && file_exists(TEAM_IMAGE_URL_ROOT_PATH.$result->team1logo) )
          if ($result->team1logo != '') {
            if (strpos($result->team1logo, "images.entitysport.com") !== false) {
              $team .= '<img src="' . $result->team1logo . '" style="width:30px;height:30px;">';
            } elseif (strpos($result->team1logo, "soccer.entitysport.com") !== false) {
              $team .= '<img src="' . $result->team1logo . '" style="width:30px;height:30px;">';
            } elseif (strpos($result->team1logo, "kabaddi.entitysport.com") !== false) {
              $team .= '<img src="' . $result->team1logo . '" style="width:30px;height:30px;">';
            } else {
              // $team .= '<img src="' . TEAM_IMAGE_URL . $result->team1logo . '" style="width:30px;height:30px;">';
              $team .= '<img src="' .  $result->team1logo . '" style="width:30px;height:30px;">';
            }
          } else {
            $team .= '<img src="' . DEFAULT_TEAM_IMAGE_URL . '" style="width:30px;background-color:red;">';
          }
          $team .= '</div>
                      <div> v/s </div>
                      <div style="float:left; width:45%; text-align: center;">';
          $team .= $result->team2name;
          // if($result->team2logo != ''  && file_exists(TEAM_IMAGE_URL_ROOT_PATH.$result->team2logo) )
          if ($result->team2logo != '') {
            if (strpos($result->team2logo, "images.entitysport.com") !== false) {
              $team .= '<img src="' . $result->team2logo . '" style="width:30px;height:30px;">';
            } elseif (strpos($result->team2logo, "soccer.entitysport.com") !== false) {
              $team .= '<img src="' . $result->team2logo . '" style="width:30px;height:30px;">';
            } elseif (strpos($result->team2logo, "kabaddi.entitysport.com") !== false) {
              $team .= '<img src="' . $result->team2logo . '" style="width:30px;height:30px;">';
            } else {
              $team .= '<img src="' .  $result->team2logo . '" style="width:30px;height:30px;">';
            }
          } else {
            $team .= '<img src="' . DEFAULT_TEAM_IMAGE_URL . '"          style="width:30px;background-color:red;">';
          }
          $team .= '</div></div>';
          return $team;
        })
        ->addColumn('action', function ($result) use ($sportsKey) {
          $sprt = DB::table('sport_types')->where('id', $result->sport_type)->first();
          $release = $result->is_release;
          if ($release == 1) {
            $rel_class = 'btn-success';
          } else {
            $rel_class = 'btn-rg';
          }
          $squadstatus = '<a href="' . route($this->model . '.editmatch', [$result->matchkey, $result->sport_type]) . '" class="btn btn-rg mr-1 mt-1" data-toggle="tooltip" title="Edit"><i class="fa fa-pencil" aria-hidden="true"></i></a>';
          if ($result->squadstatus == 'no') {
            $squadstatus .= '<a href= "' . route($this->model . '.importsquad', [$result->matchkey, $sprt->sport_key, $result->matchkey]) . '"  class="btn btn-rg mr-1 mt-1" data-toggle="tooltip" title="Import Players"><i class="fa fa-download" aria-hidden="true"></i></a>';
          } else {

            $squadstatus .= '<a href="' . route($this->model . '.edit_match', $result->matchkey) . '" class="btn btn-rg mr-1 mt-1" data-toggle="tooltip" title="Add Players"><i class="fa fa-plus" aria-hidden="true"></i></a>';
            $findIsSecondInningMatch = DB::table('listmatches')->where('matchkey', $result->matchkey)->first();
            if ($findIsSecondInningMatch->second_inning == 1) {
              $squadstatus .= '<a href= "' . route($this->model . '.importsquad', [$result->matchkey, $sprt->sport_key, rtrim($result->matchkey, "_2")]) . '"  class="btn btn-rg mr-1 mt-1" data-toggle="tooltip" title="Import Players"><i class="fa fa-download" aria-hidden="true"></i></a>';
            } else {
              $squadstatus .= '<a href= "' . route($this->model . '.importsquad', [$result->matchkey, $sprt->sport_key, $result->matchkey]) . '"  class="btn btn-rg mr-1 mt-1" data-toggle="tooltip" title="Import Players"><i class="fa fa-download" aria-hidden="true"></i></a>';
            }

            if ($result->seriesname != "") {
              if ($result->launch_status != 'launched') {
                $squadstatus .= '<a href="' . route($this->model . '.viewmatchdetails', [$result->matchkey, $result->sport_type]) . '" class="btn btn-rg mr-1 mt-1" data-toggle="tooltip" title="Launched"><i class="fa fa-rocket" aria-hidden="true">
                    </i></a>';
              } else {
                $squadstatus .= '<a href="' . route($this->model . '.viewmatchdetails', [$result->matchkey, $result->sport_type]) . '" class="btn btn-rg mr-1 mt-1" data-toggle="tooltip" title="View">
                      <i class="fa fa-eye" aria-hidden="true"></i></a>';
              }
            }
          }
          if ($result->sport_type == 1) {
            //  if($result->is_fiveplusone != 1){
            //   $squadstatus.= '<a href= "'.route($this->model.'.fiveplusone',[$result->matchkey,$result->sport_type]).'"  class="btn btn-primary mr-1 mt-1" data-toggle="tooltip" title="5+1 Functionality">FIVEPLUSONE</a>';
            // }else{
            //   $squadstatus.= '<a href="#"  class="btn btn-success mr-1 mt-1" data-toggle="tooltip" title="5+1 Functionality">FIVEPLUSONE</a>';
            // }
            //  if($result->is_tenplusone != 1){
            //   $squadstatus.= '<a href= "'.route($this->model.'.tenplusone',[$result->matchkey,$result->sport_type]).'"  class="btn btn-primary mr-1 mt-1" data-toggle="tooltip" title="10+1 Functionality">TENPLUSONE</a>';
            // }else{
            //   $squadstatus.= '<a href="#"  class="btn btn-success mr-1 mt-1" data-toggle="tooltip" title="10+1 Functionality">TENPLUSONE</a>';
            // }
          }
          return $squadstatus;
        })
        //->rawColumns(['action'])
        ->escapeColumns([])
        ->make(true);
    } //end



    return  View::make("admin.$this->model.matchmapping", compact('sportTypes', 'sports', 'sport_type'));
  } //End Function



  public function release($id)
  {
    $match = DB::table('listmatches')->where('id', $id)->first();
    $update = array();
    if ($match->is_release == 1) {
      $update['is_release'] = 0;
    } else {
      $update['is_release'] = 1;
    }
    DB::table('listmatches')->where('id', $id)->update($update);
    return Redirect::back();
  }


  public function update_result_football()
  {

    date_default_timezone_set('Asia/Kolkata');
    ini_set('max_execution_time', -1);
    $sport_type = DB::table('sport_types')->where('sport_key', FOOTBALL)->first();
    date_default_timezone_set('Asia/Kolkata');
    $findmatchexist = DB::table('listmatches')->whereDate('start_date', '<=', date('Y-m-d'))->where('sport_type', 2)->whereDate('start_date', '>=', date('Y-m-d', strtotime('-14 days')))->where('launch_status', 'launched')
      ->where('final_status', '!=', 'winnerdeclared')
      ->where('status', '!=', 'completed')
      ->get();

    foreach ($findmatchexist as $match) {
      $getcurrentdate = date('Y-m-d H:i:s');
      $matchtimings = $match->start_date;
      if ($getcurrentdate > $matchtimings) {
        $this->getscoresupdates($match->matchkey, $sport_type->id);
      }

      $matchtimings = date('Y-m-d H:i:s', strtotime('-70 minutes', strtotime($matchtimings)));
      if ($getcurrentdate > $matchtimings) {
      }
    }
  }


  public function get_playing_11_new($matchkey, $sport_type = CRICKET)
  {
    $matchkey = str_replace('_2', '', $matchkey);
    $sportType = DB::table('sport_types')
      ->where('sport_key', $sport_type)
      ->first();
    $finalplayingteams = [];
    switch ($sport_type) {
      case CRICKET:
        // $matchkey='66169';

        $finalplayingteams = Cricketapi2Controller::get_match_playing_players($matchkey);
        // echo "<pre>"; print_r($finalplayingteams); exit;
        break;
      case FOOTBALL:
        $finalplayingteams = FootballController::get_match_playing_players($matchkey);
        break;
      case BASKETBALL:
        $finalplayingteams = BasketBallController::get_match_playing_players($matchkey);
        break;
      case 'KABADDI':
        $finalplayingteams = KabaddiController::get_match_playing_players($matchkey);
        // print_r($finalplayingteams); exit;
        break;
    }

    if ($sport_type == 'CRICKET') {
      if (empty($finalplayingteams)) {
        return true;
      }

      $comp = DB::table('listmatches')->where('matchkey', $matchkey)->first();
      if ($comp->is_lineup_out == 0) {
        $this->importplayerid($matchkey, $comp->competition_id);
      }
      $teamA = $finalplayingteams['response']->teama->squads;
      $teamB = $finalplayingteams['response']->teamb->squads;
      ksort($teamA);
      ksort($teamB);

      if (!empty($finalplayingteams)) {
        $players = array();
        if (!empty($finalplayingteams['lineup_player'])) {
          foreach ($finalplayingteams['lineup_player'] as $fl) {

            $player_details = DB::table('players')
              ->join('matchplayers', 'players.id', '=', 'matchplayers.playerid')
              ->where('players.player_key', $fl)
              ->where('players.sport_type', $sportType->id)
              ->where('matchplayers.sport_type', $sportType->id)
              ->where('matchplayers.matchkey', $matchkey)
              ->select('players.id')
              ->first();

            if (!empty($player_details)) {
              $players[] = $player_details->id;
              $val = DB::table('listmatches')->where('matchkey', $matchkey)->first();
              if ($val->lineup_notification == 0 && $val->is_allow_notification == 2) {
                $title = 'Lineup Out ' . $val->short_name;
                $message = 'Create your team now! Play more & Make more';
                // Helpers::sendnotificationAll($title,$message);
                DB::table('listmatches')->where('matchkey', $val->matchkey)->update(['lineup_notification' => 1]);

                DB::table('matchplayers')->where('matchkey', $matchkey)->where('is_assumption', 1)->update(['is_assumption' => 0]);
                //custom user notification
                $image = "";
                $titleget = $title;
                $msg = $message;
                $userdata = array(1, 3);
                foreach ($userdata as $userid) {
                  //  Helpers::sendnotification($titleget,$msg,$image,$userid);
                }
              } else {
                if ($val->lineup_notification == 0 && count($players) > 20) {
                  //custom user notification
                  DB::table('listmatches')->where('matchkey', $val->matchkey)->update(['lineup_notification' => 1]);

                  $titleget = 'Lineup Out ' . $val->short_name;
                  $msg = 'Create your team now! Play more & Make more';
                  $image = "";
                  $userdata = array(1, 3);
                  foreach ($userdata as $userid) {
                    // Helpers::sendnotification($titleget,$msg,$image,$userid);
                  }
                }
              }
            }
          }

          $getidfirst = DB::table('matchplayers')->where('matchkey', $matchkey)
            ->where('batting_order', 1)
            ->first();
          // echo '<pre>'; print_r($getidfirst);exit;
          if (empty($getidfirst) && !empty($players) && count($players) > 0) {
            foreach ($teamA as $key => $value) {
              if ($value->playing11 == 'true') {
                DB::table('matchplayers')
                  ->where('matchkey', $matchkey)
                  ->where('player_key', $value->player_id)
                  ->update(array(
                    "batting_order" => $key + 1
                  ));
              }
              // elseif($value->substitute == 'true'){
              //      DB :: table('matchplayers')
              //         ->where('matchkey', $matchkey)
              //        ->where('player_key',$value->player_id)
              //        ->update(array(
              //        "is_substitute"=>1
              //      ));
              //   }
            }


            foreach ($teamB as $key => $value) {
              if ($value->playing11 == 'true') {
                DB::table('matchplayers')
                  ->where('matchkey', $matchkey)
                  ->where('player_key', $value->player_id)
                  ->update(array(
                    "batting_order" => $key + 1
                  ));
              }
              // elseif($value->substitute == 'true'){
              //    DB :: table('matchplayers')
              //       ->where('matchkey', $matchkey)
              //      ->where('player_key',$value->player_id)
              //      ->update(array(
              //      "is_substitute"=>1
              //    ));
              // }
            }
          }

          if (!empty($players) && count($players) > 11) {
            foreach ($teamA as $key => $value) {
              if ($value->substitute == 'true') {
                DB::table('matchplayers')
                  ->where('matchkey', $matchkey)
                  ->where('player_key', $value->player_id)
                  ->update(array(
                    "is_substitute" => 1
                  ));
              }
            }
            foreach ($teamB as $key => $value) {
              if ($value->substitute == 'true') {
                DB::table('matchplayers')
                  ->where('matchkey', $matchkey)
                  ->where('player_key', $value->player_id)
                  ->update(array(
                    "is_substitute" => 1
                  ));
              }
            }
          }
        }
        // foreach($finalplayingteams as $fl){
        //
        //   $player_details = DB::table('players')
        //   ->join('matchplayers','players.id','=','matchplayers.playerid')
        //   ->where('players.player_key',$fl)
        //   ->where('players.sport_type',$sportType->id)
        //   ->where('matchplayers.sport_type',$sportType->id)
        //   ->where('matchplayers.matchkey', $matchkey)
        //   ->select('players.id')
        //   ->first();
        //
        //     if(!empty($player_details)) {
        //         $players[] = $player_details->id;
        //       $val= DB::table('listmatches')->where('matchkey',$matchkey)->first();
        //       if($val->lineup_notification==0 && $val->is_allow_notification==1)
        //       {
        //            $title='Lineup Out '.$val->short_name;
        //            $message='Create your team now! Play more & Make more';
        //             Helpers::sendnotificationAll($title,$message);
        //            DB::table('listmatches')->where('matchkey',$val->matchkey)->update(['lineup_notification'=>1]);
        //
        //         DB::table('matchplayers')->where('matchkey',$matchkey)->where('is_assumption',1)->update(['is_assumption'=>0]);
        //       }
        //     }
        // }

        $insert_data = array(
          "match_key" => $matchkey,
          "sport_type" => isset($sportType->id) ? $sportType->id : 1,
          "player_ids" => serialize($players),
        );


        DB::table('match_playing11')->where('match_key', $matchkey)
          ->delete();
        if (count($players) > 11) {
          $getid = DB::table('match_playing11')->insertGetId($insert_data);
        }

        DB::table('matchplayers')
          ->where('matchkey', $matchkey)
          ->whereIn('playerid', $players)
          ->update(array(
            "is_assumption" => 1
          ));
        $matchlineup = DB::table('listmatches')
          ->where('matchkey', $matchkey)
          ->where('final_status', 'pending')
          ->where('status', 'notstarted')
          ->where('is_lineup_out', 0)
          ->first();
        // dd($matchlineup);
        $existsLineup = DB::table('match_playing11')->where('match_key', $matchkey)->exists();

        if ($existsLineup && !empty($matchlineup) && count($players) > 20) {
          $linup_update = array(
            "is_lineup_out" => 1
          );
          DB::table('listmatches')->where('matchkey', $matchkey)->update($linup_update);
        }
        if (!empty($getid)) {
          $title = 'Lineup Out ';
          $message = 'Create your team now! Play more & Make more';
          // Helpers::sendnotificationAll($title,$message);
        }
        if (!empty($getid)  && !empty($players) && count($players) > 20) {
          // $this->update_bots_lineup_outs_teams($matchkey,$getid);
        }

        //Second Inning
        $inningmatches = DB::table('listmatches')->where('matchkey', $matchkey)
          ->select('second_inning_allow')->first();

        if ($inningmatches->second_inning_allow == 1) {
          $matchkey2 = $matchkey . '_2';
          $players_secondinning = array();
          // foreach($finalplayingteams as $fl){
          foreach ($finalplayingteams['lineup_player'] as $fl) {

            $player_details = DB::table('players')->join('matchplayers', 'players.id', '=', 'matchplayers.playerid')->where('players.player_key', $fl)->where('players.sport_type', $sportType->id)->where('matchplayers.sport_type', $sportType->id)->where('matchplayers.matchkey', $matchkey2)->select('players.id')->first();

            if (!empty($player_details)) {
              $players_secondinning[] = $player_details->id;
            }
          }

          $matchlineup = DB::table('listmatches')
            ->where('matchkey', $matchkey2)
            ->where('final_status', 'pending')
            ->where('is_lineup_out', 0)
            ->where('status', 'notstarted')
            ->first();
          $existsLineup = DB::table('match_playing11')->where('match_key', $matchkey2)->exists();
          if (!$existsLineup && !empty($matchlineup)) {
            $title = "Lineup Out!";
            $message = "Lineup Out! of " . $matchlineup->name;
            //  Helpers::sendnotificationAll($title,$message,"",'');
            $linup_update = array(
              "is_lineup_out" => 1
            );
            DB::table('listmatches')->where('matchkey', $matchkey2)->update($linup_update);
          }

          $insert_data = array(
            "match_key" => $matchkey2,

            "player_ids" => serialize($players_secondinning),
          );
          DB::table('match_playing11')->where('match_key', $matchkey2)
            ->delete();
          DB::table('match_playing11')->insert($insert_data);

          DB::table('matchplayers')
            ->where('matchkey', $matchkey2)
            ->whereIn('playerid', $players_secondinning)
            ->update(array(
              "is_assumption" => 1
            ));

          if (!empty($players_secondinning) && count($players_secondinning) > 20) {
            foreach ($teamA as $key => $value) {
              if ($value->substitute == 'true') {
                DB::table('matchplayers')
                  ->where('matchkey', $matchkey2)
                  ->where('player_key', $value->player_id)
                  ->update(array(
                    "is_substitute" => 1
                  ));
              }
            }
            foreach ($teamB as $key => $value) {
              if ($value->substitute == 'true') {
                DB::table('matchplayers')
                  ->where('matchkey', $matchkey2)
                  ->where('player_key', $value->player_id)
                  ->update(array(
                    "is_substitute" => 1
                  ));
              }
            }
          }
        }
        // Second Inning End


        return $players;
      }
    } else {
      if (empty($finalplayingteams)) {
        return true;
      }
      $players = array();
      foreach ($finalplayingteams as $fl) {
        $player_details = DB::table('players')
          ->join('matchplayers', 'players.id', '=', 'matchplayers.playerid')
          ->where('players.player_key', $fl)
          ->where('players.sport_type', $sportType->id)
          ->where('matchplayers.sport_type', $sportType->id)
          ->where('matchplayers.matchkey', $matchkey)
          ->select('players.id')
          ->first();

        if (!empty($player_details)) {
          $players[] = $player_details->id;
          $val = DB::table('listmatches')->where('matchkey', $matchkey)->first();
          if ($val->lineup_notification == 0 && $val->is_allow_notification == 2) {
            $title = 'Lineup Out ' . $val->short_name;
            $message = 'Create your team now! Play more & Make more';
            Helpers::sendnotificationAll($title, $message);
            DB::table('listmatches')->where('matchkey', $val->matchkey)->update(['lineup_notification' => 1]);
          }

          //    $val= DB::table('listmatches')->where('matchkey',$matchkey)->first();

          // if(@$val->lineup_notification==0 && @$val->is_allow_notification==1)
          // {
          //      $title='Lineup Out '.$val->short_name;
          //      $message='Create your team now! Play more & Make more';
          //       Helpers::sendnotificationAll($title,$message);
          //      DB::table('listmatches')->where('matchkey',$val->matchkey)->update(['lineup_notification'=>1]);
          //              DB :: table('matchplayers')
          //                 ->where('matchkey', $matchkey)
          //                  ->whereIn('playerid',$players)
          //                  ->update(array(
          //                  "is_assumption"=>1
          //                ));
          //
          //
          //                $insert_data = array(
          //                    "match_key" => $matchkey,
          //                    "player_ids" => serialize($players),
          //                );
          //                DB::table('match_playing11')->where('match_key',$matchkey)
          //                ->delete();
          //              $getid= DB::table('match_playing11')->insertGetId($insert_data);
          //
          //              if(!empty($getid)){
          //                $title='Lineup Out ';
          //                $message='Create your team now! Play more & Make more';
          //                // Helpers::sendnotificationAll($title,$message);
          //              }
          //                if(!empty($getid)){
          //                // $this->update_bots_lineup_outs_teams($matchkey,$getid);
          //              }
          //                return $players;
          //          // DB::table('matchplayers')->where('matchkey',$matchkey)->where('is_assumption',1)->update(['is_assumption'=>0]);
          // }
        }
      }

      DB::table('matchplayers')
        ->where('matchkey', $matchkey)
        ->whereIn('playerid', $players)
        ->update(array(
          "is_assumption" => 1
        ));


      $insert_data = array(
        "match_key" => $matchkey,
        "sport_type" => isset($sportType->id) ? $sportType->id : 7,
        "player_ids" => serialize($players),
      );
      DB::table('match_playing11')->where('match_key', $matchkey)
        ->delete();
      $getid = DB::table('match_playing11')->insertGetId($insert_data);

      if (!empty($getid)) {
        $title = 'Lineup Out ';
        $message = 'Create your team now! Play more & Make more';
        // Helpers::sendnotificationAll($title,$message);
      }


      return $players;
    }
    return array();
  }

  public function importplayerid($match_id = '', $comp_id)
  {
    $squads = Cricketapi2Controller::get_match_squad($match_id, $comp_id);
    // echo "<pre>"; print_r($squads); exit;
    $sportType =  DB::table('sport_types')->where('sport_key', 'CRICKET')->first();
    if (!empty($squads)) {
      // DB::table('matchplayers')->where('matchkey', $match_id)->where('sport_type',1)->delete();
      $squads1 = $squads->squads;

      foreach ($squads1 as $key2 => $value2) {

        $players = @$value2->players;

        if (!empty(@$players)) {

          $match_data['squadstatus'] = 'yes';

          DB::table('listmatches')->where('matchkey', $match_id)->where('sport_type', $sportType->id)->update($match_data);
        } else {

          $players = array();
        }


        foreach ($players as $key => $value) {

          if (isset($value->pid) && !empty($value->pid)) {

            $teamkey = $value2->team_id;

            $players1 = $value->pid;

            $playerkey = $players1;

            $findmatchexist = DB::table('teams')->where('team_key', $teamkey)->where('sport_type', $sportType->id)->select('id')->first();

            if (!empty($findmatchexist)) {

              $findp1 = DB::table('playerdetails')->where('player_key', $players1)
                ->where('sport_type', $sportType->id)->first();

              $findplayerexist = DB::table('players')->where('player_key', $players1)->where('team', $findmatchexist->id)->where('sport_type', 1)->first();

              $data['player_name'] = $value->title;

              $data['player_key'] = $playerkey;

              $plaerdetailsdata['fullname'] = $value->title;

              $plaerdetailsdata['player_key'] = $playerkey;
              $plaerdetailsdata['sport_type'] = 1;

              if (empty($findplayerexist)) {

                $data['team'] = $findmatchexist->id;

                if ($value->playing_role == "bat") {

                  $data['role'] = 'batsman';
                } elseif ($value->playing_role == "all") {

                  $data['role'] = 'allrounder';
                } elseif ($value->playing_role == "bowl") {

                  $data['role'] = 'bowler';
                } elseif ($value->playing_role == "wk") {

                  $data['role'] = 'keeper';
                } elseif ($value->playing_role == "wkbat") {

                  $data['role'] = 'keeper';
                } else {

                  $data['role'] =  'allrounder';
                }

                // $data['']

                $playerid = DB::table('players')->insertGetId($data);

                $credit = $value->fantasy_player_rating;
              } else {

                $playerid = $findplayerexist->id;

                $credit = $value->fantasy_player_rating;

                if ($value->playing_role == "bat") {

                  $data['role'] = 'batsman';
                } elseif ($value->playing_role == "all") {

                  $data['role'] = 'allrounder';
                } elseif ($value->playing_role == "bowl") {

                  $data['role'] = 'bowler';
                } elseif ($value->playing_role == "wk") {

                  $data['role'] = 'keeper';
                } elseif ($value->playing_role == "wkbat") {

                  $data['role'] = 'keeper';
                } else {

                  $data['role'] =  'allrounder';
                }
              }

              /* insert in player details table*/

              if (empty($findp1)) {

                DB::table('playerdetails')->insert($plaerdetailsdata);
              } else {

                DB::table('playerdetails')->where('id', $findp1->id)->update($plaerdetailsdata);
              }

              // insert players for a match//

              $findplayer1entry = DB::table('matchplayers')->where('matchkey', $match_id)
                ->where('playerid', $playerid)
                ->where('player_key', $playerkey)
                ->where('sport_type', 1)->first();

              // print_r($playerkey);exit;

              if (empty($findplayer1entry) && !empty($playerkey)) {

                $matchplayerdata['matchkey'] = $match_id;

                $matchplayerdata['playerid'] = $playerid;
                $matchplayerdata['player_key'] = $playerkey;

                $matchplayerdata['role'] = $data['role'];

                $matchplayerdata['name'] = $data['player_name'];

                $matchplayerdata['credit'] = $credit;
                $matchplayerdata['fiveplus_credit'] = @$findplayerexist->fiveplus_credit;

                $findplayer1entrycheck = DB::table('matchplayers')->where('matchkey', $match_id)
                  ->where('playerid', $playerid)
                  ->where('sport_type', 1)->first();
                // if(!empty($findplayer1entrycheck)){
                //       DB::table('matchplayers')->where('id', $findplayer1entrycheck->id)->update($matchplayerdata);
                //     }else{

                DB::table('matchplayers')->insert($matchplayerdata);
                //}

              } else {
                $matchplayerdata = array();
                // $matchplayerdata['matchkey'] = $match_id;

                // $matchplayerdata['playerid'] = $playerid;


                // $matchplayerdata['role'] = $data['role'];

                // $matchplayerdata['name'] = $data['player_name'];
                //$matchplayerdata['player_key'] = $playerkey;
                $matchplayerdata['credit'] = $credit;
                $matchplayerdata['fiveplus_credit'] = @$findplayerexist->fiveplus_credit;

                // DB::table('matchplayers')->where('id', $findplayer1entry->id)->where('sport_type',1)->update($matchplayerdata);

              }

              foreach ($squads->squads as $lastmatchp) {
                $findmatchexist = DB::table('teams')->where('team_key', $lastmatchp->team_id)->select('id')->first();

                foreach ($lastmatchp->last_match_played as $key => $value) {

                  if (!empty($findmatchexist)) {
                    $findplayerexist = DB::table('players')->where('player_key', $value->player_id)->where('sport_type', 1)->where('team', $findmatchexist->id)->first();

                    $findLastMatchTeam1 = DB::table('listmatches')
                      //  ->where('status','completed')
                      ->where(function ($query) use ($findmatchexist) {
                        $query->where('team1', $findmatchexist->id)
                          ->orWhere('team2', $findmatchexist->id);
                      })
                      ->select('matchkey')->orderBy('id', 'DESC')->limit(1)->first();
                    //  echo '<pre>'; print_r($findLastMatchTeam1);exit;
                    if (!empty($findLastMatchTeam1)) {
                      $findLastMatchPlayersTeam1 =  DB::table('result_matches')
                        ->where('match_key', $findLastMatchTeam1->matchkey)
                        ->where('player_key', $value->player_id)
                        ->select('player_key')->get();

                      if (!empty($findplayerexist)) {

                        $lastMatchPlayedData['last_match_played'] = 'true';
                        // DB::table('matchplayers')->where('matchkey', $match_id)->where('sport_type', 1)->where('playerid', $findplayerexist->id)->update($lastMatchPlayedData);
                      } else {
                        $lastMatchPlayedData['last_match_played'] = 'false';
                        // DB::table('matchplayers')->where('matchkey', $match_id)->where('sport_type', 1)->where('playerid', @$findplayerexist->id)->update($lastMatchPlayedData);
                      }
                      // if(!empty($findplayerexist)){
                      //     if(!$findLastMatchPlayersTeam1->isEmpty()){
                      //         $lastMatchPlayedData['last_match_played'] = 'true';
                      //         DB::table('matchplayers')->where('matchkey', $findLastMatchTeam1->matchkey)->where('playerid',$findplayerexist->id)->update($lastMatchPlayedData);
                      //     }else{
                      //       $lastMatchPlayedData['last_match_played'] = 'false';
                      //       DB::table('matchplayers')->where('matchkey', $findLastMatchTeam1->matchkey)->where('playerid',$findplayerexist->id)->update($lastMatchPlayedData);
                      //     }
                      //   }
                    }
                  }
                }
              }
            }
          }
        }
      }
    }
  }
  public function update_bots_lineup_outs_teams($matchkey, $matchplayerid = null)
  {
    $botenable = DB::table('listmatches')->where('matchkey', $matchkey)->where('is_bot_enable', 1)
      ->where('update_bots_status', 0)
      ->first();

    // $matchplayerid= DB::table('match_playing11')->where('match_key',$matchkey)->select('player_ids')->first();

    if (!empty($botenable)) {
      // DB::table('matchplayers')->where('matchkey',$matchkey)->where('is_assumption',1)->update(['is_assumption'=>0]);
      DB::table('bots_teams')->where('matchkey', $matchkey)->delete();
      $temp = $this->generateBotsApi_lineup($matchkey);

      $playing11player = DB::table('match_playing11')->where('id', $matchplayerid)->select('player_ids')->first();
      $data = unserialize($playing11player->player_ids);
      // DB::table('matchplayers')->where('matchkey',$matchkey)->whereIn('playerid',$data)->update(['is_assumption'=>1]);
      // $temp = $this->generateBotsApi_lineup($matchkey);
      // $this->update_top_team_captain_voicecaptain($matchkey,1);
      //dd($playing11player);
      $tempdata = $this->update_bot_user_joined_teams($matchkey, 1);
      // dd($tempdata);
      // DB::table('bots_teams')->where('matchkey',$matchkey)->where('is_lineup',0)->delete();
      DB::table('listmatches')->where('matchkey', $matchkey)->where('is_bot_enable', 1)->update(['update_bots_status' => 1]);
      //  echo '<pre>';print_r($data);exit;
      return $data;
      exit;
    }

    return 0;
    echo 'done';
  }

  public  function generateBotsApi_lineup($matchkey)
  {
    $AssumptionCount = DB::table('matchplayers')->where('matchkey', $matchkey)->where('is_assumption', 1)->count();
    $matchPlaying11 = DB::table('match_playing11')->where('match_key', $matchkey)->first();
    $listMac = DB::table('listmatches')->where('matchkey', $matchkey)->first();
    if (empty($matchPlaying11)) {
      if ($listMac->sport_type == 4) {
        if ($AssumptionCount < 14) {
          Session::flash('flash_notice', 'Please add 14 assumption players.');
          Session::flash('alert-class', 'alert-success');
          return Redirect::back();
        }
      } else {
        if ($AssumptionCount < 22) {
          Session::flash('flash_notice', 'Please add 22 assumption players.');
          Session::flash('alert-class', 'alert-success');
          return Redirect::back();
        }
      }
    }
    // echo "saa";exit;
    // var_dump($listMac);exit;
    // if($listMac->sport_type == 4){
    if (0) {
      //$this->kabaddi_autoBotsGenerater(1 , $matchkey , 1);
    } else {
      $this->autoBotsGenerater(1, $matchkey, 1);
    }

    return true;
  }

  public function update_top_team_captain_voicecaptain($matchkey, $sport_type)
  {
    $teamsDB = DB::table('bots_teams')->where('matchkey', $matchkey)
      ->where('is_used', 0)
      ->where('is_lineup', 1)
      ->select('players', 'vicecaptain', 'captain', 'id')
      ->orderBy('selected_percent', 'DESC')->limit(5)->get();

    foreach ($teamsDB as $key => $value) {
      $Hightcaptain = DB::table('matchplayers')
        ->where('matchkey', $matchkey)
        ->where('top_team_update', 0)
        ->where('is_assumption', 1)
        ->orderby('selected_percent', 'desc')
        ->first()->playerid;
      $captainD =  $Hightcaptain;

      DB::table('matchplayers')->where('playerid', $Hightcaptain)->where('matchkey', $matchkey)
        ->update(["top_team_update" => 1]);

      $HightVicecaptain = DB::table('matchplayers')
        ->where('matchkey', $matchkey)
        ->where('top_team_update', 0)
        ->where('is_assumption', 1)
        ->orderby('selected_percent', 'desc')
        ->first()->playerid;
      $VicecaptainD = $HightVicecaptain;

      DB::table('matchplayers')->where('playerid', $HightVicecaptain)->where('matchkey', $matchkey)
        ->update(["top_team_update" => 1]);

      DB::table('bots_teams')
        ->where('matchkey', $matchkey)
        ->where('id', $value->id)
        ->where('is_used', 0)
        ->where('top_team_update', 0)
        ->where('is_lineup', 1)
        ->update(['captain' => $captainD, 'vicecaptain' => $VicecaptainD, 'top_team_update' => 1]);
    }
    return true;
  }
  public function update_bot_user_joined_teams($matchkey, $sport_type)
  {
    $joinbotuser = DB::table('joinedleauges')
      ->join('registerusers', 'registerusers.id', '=', 'joinedleauges.userid')
      ->where('matchkey', $matchkey)
      ->where('registerusers.is_bot', 1)
      //->groupBy('challengeid')
      ->select('registerusers.id', 'joinedleauges.teamid')
      ->get();
    //dd(  $joinbotuser);
    foreach ($joinbotuser as $key => $value) {

      $teamsDB = DB::table('bots_teams')->where('matchkey', $matchkey)
        ->where('is_used', 0)
        ->where('is_lineup', 1)
        ->select('players', 'vicecaptain', 'captain', 'id')
        ->orderBy('selected_percent', 'DESC')->first();

      if (!empty($teamsDB->players)) {
        DB::table('jointeam')->where('userid', $value->id)
          ->where('id', $value->teamid)
          ->update(['players' => @$teamsDB->players, 'vicecaptain' => @$teamsDB->vicecaptain, 'captain' => @$teamsDB->captain, 'is_bot_lineup' => 1, 'fantasy_type_id' => 0]);
      }


      $teamsDB = DB::table('bots_teams')->where('matchkey', $matchkey)
        ->where('id', @$teamsDB->id)
        ->update(['is_used' => 1]);
    }

    return true;
  }

  public function autoBotsGenerater($icu = 1, $matchkey = 'engind_2021_test_01', $is_series_performance = 0, $sportType = 1)
  {

    $series = DB::table('listmatches')->where('matchkey', $matchkey)
      ->where('sport_type', $sportType)
      ->first();

    $playing11_db = DB::table('match_playing11')
      // ->where('sport_type' , $sportType)
      ->where('match_key', $matchkey)->first();

    $players11 = array();
    if (!empty($playing11_db)) {
      $players11 =  unserialize($playing11_db->player_ids);

      // var_dump($players11);
      // exit;
    } else {

      $matchPlayersDb = DB::table('matchplayers')->where('matchkey', $matchkey)->where('is_assumption', 1)
        //->where('sport_type' , $sportType)
        ->pluck('playerid');
      // var_dump($matchPlayersDb);
      // exit;
      if (empty($matchPlayersDb)) {
        $matchPlayersDb = DB::table('matchplayers')->where('matchkey', $matchkey)->pluck('playerid');
      }
      $players11 = DB::table('matchplayers as mp')->join('listmatches as lm', 'lm.matchkey', '=', 'mp.matchkey')->whereIn('mp.playerid', $matchPlayersDb)
        ->where('mp.sport_type',  $sportType)
        ->where('series', $series->series)->groupBy('mp.playerid')
        ->orderBy('points', 'desc')
        ->limit(22)
        ->pluck('mp.playerid');
    }

    $team = DB::table('listmatches')->where('matchkey', $matchkey)
      ->where('sport_type', $sportType)
      ->select('team1', 'team2')->first();

    // $randomNumber = rand(0,2);
    $randomNumber = 1;
    $matchplayingPlayersBatting = DB::table('matchplayers')
      ->where('matchkey', $matchkey)
      ->where('matchplayers.sport_type', $sportType)
      ->whereIn('playerid', $players11)->where('matchplayers.role', 'batsman')
      ->join('players', 'players.id', '=', 'matchplayers.playerid')
      ->select('matchplayers.playerid', 'matchplayers.selected_percent', 'matchplayers.credit', 'players.team')
      ->orderBy('selected_percent', "DESC")
      ->get();

    if ($randomNumber == 1) {
      $matchplayingPlayersBatting = DB::table('matchplayers as mp')->join('listmatches as lm', 'lm.matchkey', '=', 'mp.matchkey')->whereIn('mp.playerid', $matchplayingPlayersBatting->pluck('playerid'))
        ->join('players', 'players.id', '=', 'mp.playerid')
        ->where('mp.sport_type', $sportType)
        ->where('mp.role', 'batsman')
        ->where('series', $series->series)->groupBy('mp.playerid')
        ->orderBy('mp.points', 'desc')
        ->select('mp.playerid', 'mp.selected_percent', 'mp.credit', 'players.team')
        ->get();
      // var_dump($matchplayingPlayersBatting);exit;
    }

    if ($randomNumber == 2) {
      $matchplayingPlayersBatting = DB::table('matchplayers')
        ->where('matchkey', $matchkey)
        ->where('matchplayers.sport_type', $sportType)
        ->whereIn('playerid', $players11)->where('matchplayers.role', 'batsman')
        ->join('players', 'players.id', '=', 'matchplayers.playerid')
        ->select('matchplayers.playerid', 'matchplayers.selected_percent', 'matchplayers.credit', 'players.team')
        ->orderBy(DB::raw("RAND()"))
        ->get();
    }

    $matchplayingPlayersBowler = DB::table('matchplayers')
      ->where('matchkey', $matchkey)
      ->where('matchplayers.sport_type', $sportType)
      ->whereIn('playerid', $players11)->where('matchplayers.role', 'bowler')
      ->join('players', 'players.id', '=', 'matchplayers.playerid')
      ->select('matchplayers.playerid', 'matchplayers.selected_percent', 'matchplayers.credit', 'players.team')
      ->orderBy('selected_percent', "DESC")
      ->get();

    if ($randomNumber == 1) {
      $matchplayingPlayersBowler = DB::table('matchplayers')
        ->where('matchkey', $matchkey)
        ->where('matchplayers.sport_type', $sportType)
        ->whereIn('playerid', $players11)->where('matchplayers.role', 'bowler')
        ->join('players', 'players.id', '=', 'matchplayers.playerid')
        ->select('matchplayers.playerid', 'matchplayers.selected_percent', 'matchplayers.credit', 'players.team')
        ->orderBy(DB::raw("RAND()"))
        ->get();
    }
    if ($randomNumber == 2) {
      $matchplayingPlayersBowler = DB::table('matchplayers as mp')->join('listmatches as lm', 'lm.matchkey', '=', 'mp.matchkey')->whereIn('mp.playerid', $matchplayingPlayersBowler->pluck('playerid'))
        ->join('players', 'players.id', '=', 'mp.playerid')
        ->where('mp.sport_type', $sportType)
        ->where('mp.role', 'bowler')
        ->where('series', $series->series)->groupBy('mp.playerid')
        ->orderBy('mp.points', 'desc')
        ->select('mp.playerid', 'mp.selected_percent', 'mp.credit', 'players.team')
        ->get();
    }

    $matchplayingPlayersAllrounder = DB::table('matchplayers')
      ->where('matchkey', $matchkey)
      ->where('matchplayers.sport_type', $sportType)
      ->whereIn('playerid', $players11)->where('matchplayers.role', 'allrounder')
      ->join('players', 'players.id', '=', 'matchplayers.playerid')
      ->select('matchplayers.playerid', 'matchplayers.selected_percent', 'matchplayers.credit', 'players.team')
      ->orderBy('selected_percent', "DESC")
      ->get();


    if ($randomNumber == 1) {
      $matchplayingPlayersAllrounder = DB::table('matchplayers')
        ->where('matchkey', $matchkey)
        ->where('matchplayers.sport_type', $sportType)
        ->whereIn('playerid', $players11)->where('matchplayers.role', 'allrounder')
        ->join('players', 'players.id', '=', 'matchplayers.playerid')
        ->select('matchplayers.playerid', 'matchplayers.selected_percent', 'matchplayers.credit', 'players.team')
        ->orderBy(DB::raw("RAND()"))
        ->get();
    }

    if ($randomNumber == 2) {
      $matchplayingPlayersAllrounder = DB::table('matchplayers as mp')->join('listmatches as lm', 'lm.matchkey', '=', 'mp.matchkey')->whereIn('mp.playerid', $matchplayingPlayersAllrounder->pluck('playerid'))
        ->join('players', 'players.id', '=', 'mp.playerid')
        ->where('mp.sport_type', $sportType)
        ->where('mp.role', 'allrounder')
        ->where('series', $series->series)->groupBy('mp.playerid')
        ->orderBy('mp.points', 'desc')
        ->select('mp.playerid', 'mp.selected_percent', 'mp.credit', 'players.team')
        ->get();
    }

    $matchplayingPlayersWicketKeeper = DB::table('matchplayers')
      ->where('matchkey', $matchkey)
      ->where('matchplayers.sport_type', $sportType)
      ->whereIn('playerid', $players11)
      ->where('matchplayers.role', 'keeper')
      ->join('players', 'players.id', '=', 'matchplayers.playerid')
      ->select('matchplayers.playerid', 'matchplayers.selected_percent', 'matchplayers.credit', 'players.team')
      ->orderBy('selected_percent', "DESC")
      ->get();


    if ($randomNumber == 1) {
      $matchplayingPlayersWicketKeeper = DB::table('matchplayers')
        ->where('matchkey', $matchkey)
        ->where('matchplayers.sport_type', $sportType)
        ->whereIn('playerid', $players11)
        ->where('matchplayers.role', 'keeper')
        ->join('players', 'players.id', '=', 'matchplayers.playerid')
        ->select('matchplayers.playerid', 'matchplayers.selected_percent', 'matchplayers.credit', 'players.team')
        ->orderBy(DB::raw("RAND()"))
        ->get();
    }

    if ($randomNumber == 2) {
      $matchplayingPlayersWicketKeeper = DB::table('matchplayers as mp')->join('listmatches as lm', 'lm.matchkey', '=', 'mp.matchkey')->whereIn('mp.playerid', $matchplayingPlayersWicketKeeper->pluck('playerid'))
        ->join('players', 'players.id', '=', 'mp.playerid')
        ->where('mp.sport_type', $sportType)
        ->where('mp.role', 'keeper')
        ->where('series', $series->series)->groupBy('mp.playerid')
        ->orderBy('mp.points', 'desc')
        ->select('mp.playerid', 'mp.selected_percent', 'mp.credit', 'players.team')
        ->get();
    }

    $botsTeamInsertBatch = array();
    // var_dump($players11);exit;
    for ($i = 1; $i <= 30000; $i++) {

      // for($t=1;$t<=4;$t++){


      // if($sportType == 7){
      if (0) {

        $player11_data = $this->kabaddi_getValidateTeam(0, $matchkey, $is_series_performance, 1, $icu, $players11, $team, $matchplayingPlayersBatting, $matchplayingPlayersBowler, $matchplayingPlayersAllrounder, $matchplayingPlayersWicketKeeper, $sportType);
      } else {

        $player11_data = $this->getValidateTeam(0, $matchkey, $is_series_performance, 1, $icu, $players11, $team, $matchplayingPlayersBatting, $matchplayingPlayersBowler, $matchplayingPlayersAllrounder, $matchplayingPlayersWicketKeeper, $sportType);
      }

      //echo"<pre>"; print_r($player11_data);exit;
      if (!empty($player11_data)) {
        $player11 = $player11_data->allplayers;
        if (count($player11) > 0) {

          //   $palyer1=DB::table('matchplayers')->where('matchkey',$matchkey)->wherein('playerid',$player11)
          //       ->orderby('selected_percent','desc')
          //       ->orderby('selected_captain_percent','desc')
          //       ->first();
          // $captainD = @$palyer1->playerid;
          // if(empty($captainD))
          // {
          //   $captainD = $player11[0]->playerid;
          // }
          //
          // $palyer2=DB::table('matchplayers')->where('matchkey',$matchkey)->wherein('playerid',$player11)
          //    ->orderby('selected_percent','desc')
          //    ->orderby('selected_vicecaptain_percent','desc')
          //    ->first();
          //  $VicecaptainD = @$palyer2->playerid;
          //    if(empty($VicecaptainD))
          //    {
          //      $VicecaptainD = $player11[1]->playerid;
          //    }

          $capRand = rand(0, 10);
          // echo "Random ".$capRand." --- \n";
          // $captainD = $player11[$capRand]->playerid;
          $captainD = $player11[0]->playerid;

          $viceCArr = $player11;

          // var_dump($captainD);

          // var_dump($viceCArr);

          $viceCountArr = array(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10);
          unset($viceCountArr[$capRand]);
          $viceCapRand = $viceCountArr[array_rand($viceCountArr, 1)];
          //$VicecaptainD = $player11[$viceCapRand]->playerid;
          $VicecaptainD = $player11[1]->playerid;


          $player = array();
          $teamdata = array();
          $teamdata['matchkey'] = $matchkey;
          $teamdata['captain'] = $captainD;
          $teamdata['vicecaptain'] = $VicecaptainD;
          $teamdata['criteria'] = $player11_data->criteria;
          // $teamdata['secret_number']=$player11_data->secret_number;

          $teamdata['selected_percent'] = $player11_data->selected_percent;

          foreach ($player11 as $key => $play) {
            $player[] = $play->playerid;
          }

          sort($player);
          // print_r($player); exit;
          $teamdata['players'] = implode(',', $player);

          $playing11_db = DB::table('match_playing11')->where('match_key', $matchkey)->first();
          if (!empty($playing11_db)) {
            $teamdata['is_lineup'] = 1;
          }


          array_push($botsTeamInsertBatch, $teamdata);
        }
      }
    }
    //echo"<pre>"; print_r($playing11_db);exit;


    if (count($botsTeamInsertBatch) > 0) {

      // var_dump($joinTeamsChampion);exit;
      // $this->insertOrUpdate($finalResultsArr,'finalresults');
      // DB::table('bots_teams')->insertOrUpdate($botsTeamInsertBatch);

      $this->insertOrUpdate($botsTeamInsertBatch, 'bots_teams');
    }
    return 1;
  }

  public function getValidateTeam($userid, $matchkey, $is_series_performance = 0, $is_validTeam = 1, $icu = 1, $players11 = array(), $team = array(),  $matchplayingPlayersBatting = array(), $matchplayingPlayersBowler = array(), $matchplayingPlayersAllrounder = array(), $matchplayingPlayersWicketKeeper = array(), $sportType = 1)
  {

    if ($sportType == 7) {

      $validTeamObj = $this->kabaddi_createValidTeam($matchkey, rand(1, 20), $players11, rand(1, 4), $team, $matchplayingPlayersBatting, $matchplayingPlayersBowler, $matchplayingPlayersAllrounder, $matchplayingPlayersWicketKeeper, $sportType);
    } else {
      $validTeamObj = $this->createValidTeam($matchkey, rand(1, 20), $players11, rand(1, 4), $team, $matchplayingPlayersBatting, $matchplayingPlayersBowler, $matchplayingPlayersAllrounder, $matchplayingPlayersWicketKeeper, $sportType);
    }
    if (!empty($validTeamObj)) {

      if ($validTeamObj->sum < 100) {
        return $validTeamObj;
        // $isExistsTeam = $this->is_exists_team($validTeamObj->allplayers,$validTeamObj->allplayers[0]->playerid, $validTeamObj->allplayers[1]->playerid,$matchkey);
        //
        //  if(!$isExistsTeam){
        // $validTeamObj->criteria = $c;
        // // echo "<pre>"; printf($validTeamObj);
        // return $validTeamObj;
        // }
      }
    }
    // }
    // $object = new stdClass;
    // $object->validTeam = $icu;
    return array();
  }

  public function createValidTeam($matchkey, $criteria = 1, $matchPlayers, $teampetern, $team = array(), $matchplayingPlayersBatting = array(), $matchplayingPlayersBowler = array(), $matchplayingPlayersAllrounder = array(), $matchplayingPlayersWicketKeeper = array(), $sportType = 1)
  {
    // $team=array();
    $criteria = 1;
    $orderby = ['ASC', 'DESC'];
    $orderSeq = rand(0, 1);

    $randomSeq = rand(1, 3);

    $orderbyVal = $orderby[$orderSeq];
    $orderVal = 'id';
    if ($criteria == 2) {
      $battingLimit = 5;
      $bowlingLimit = 3;
      $AllRounderLimit = 2;
      $KeeperLimit = 1;
    } else if ($criteria == 1) {
      $battingLimit = 3;
      $bowlingLimit = 5;
      $AllRounderLimit = 2;
      $KeeperLimit = 1;
    } else if ($criteria == 3) {
      $battingLimit = 4;
      $bowlingLimit = 4;
      $AllRounderLimit = 2;
      $KeeperLimit = 1;
    } else if ($criteria == 4) {
      $battingLimit = 4;
      $bowlingLimit = 3;
      $AllRounderLimit = 3;
      $KeeperLimit = 1;
    } else if ($criteria == 5) {
      $battingLimit = 3;
      $bowlingLimit = 3;
      $AllRounderLimit = 4;
      $KeeperLimit = 1;
    } else if ($criteria == 6) {
      $battingLimit = 6;
      $bowlingLimit = 3;
      $AllRounderLimit = 1;
      $KeeperLimit = 1;
    } else if ($criteria == 7) {
      $battingLimit = 3;
      $bowlingLimit = 6;
      $AllRounderLimit = 1;
      $KeeperLimit = 1;
    } else if ($criteria == 8) {
      $battingLimit = 3;
      $bowlingLimit = 3;
      $AllRounderLimit = 1;
      $KeeperLimit = 4;
    } else if ($criteria == 9) {
      $battingLimit = 3;
      $bowlingLimit = 5;
      $AllRounderLimit = 1;
      $KeeperLimit = 2;
    } else if ($criteria == 10) {
      $battingLimit = 3;
      $bowlingLimit = 3;
      $AllRounderLimit = 2;
      $KeeperLimit = 3;
    } else if ($criteria == 11) {
      $battingLimit = 5;
      $bowlingLimit = 3;
      $AllRounderLimit = 1;
      $KeeperLimit = 2;
    } else if ($criteria == 12) {
      $battingLimit = 4;
      $bowlingLimit = 3;
      $AllRounderLimit = 2;
      $KeeperLimit = 2;
    } else if ($criteria == 13) {
      $battingLimit = 3;
      $bowlingLimit = 3;
      $AllRounderLimit = 3;
      $KeeperLimit = 2;
    } else if ($criteria == 14) {
      $battingLimit = 3;
      $bowlingLimit = 5;
      $AllRounderLimit = 1;
      $KeeperLimit = 2;
    } else if ($criteria == 15) {
      $battingLimit = 4;
      $bowlingLimit = 4;
      $AllRounderLimit = 1;
      $KeeperLimit = 2;
    } else if ($criteria == 16) {
      $battingLimit = 5;
      $bowlingLimit = 3;
      $AllRounderLimit = 1;
      $KeeperLimit = 2;
    } else if ($criteria == 17) {
      $battingLimit = 4;
      $bowlingLimit = 3;
      $AllRounderLimit = 1;
      $KeeperLimit = 3;
    } else if ($criteria == 18) {
      $battingLimit = 3;
      $bowlingLimit = 3;
      $AllRounderLimit = 2;
      $KeeperLimit = 3;
    } else if ($criteria == 19) {
      $battingLimit = 3;
      $bowlingLimit = 4;
      $AllRounderLimit = 1;
      $KeeperLimit = 3;
    } else {
      $battingLimit = 3;
      $bowlingLimit = 3;
      $AllRounderLimit = 3;
      $KeeperLimit = 2;
    }

    // var_dump($criteria);exit;
    // var_dump($matchPlayers);exit;
    if (!empty($matchPlayers)) {

      // $matchplayingPlayersBatting = DB::table('matchplayers')
      // ->where('matchkey' , $matchkey)
      // ->whereIn('playerid' , $matchPlayers)->where('matchplayers.role' , 'batsman')
      // ->join('players' , 'players.id' , '=' , 'matchplayers.playerid')
      // ->select('matchplayers.playerid' , 'matchplayers.selected_percent' , 'matchplayers.credit' , 'players.team')
      // ->get();

      $tlBatting = 0;
      $isRandomedBatting = array();
      $battingDataArr = array();
      $battingSum = 0;

      $battingSelectedPercent = 0;

      if (count($matchplayingPlayersBatting) < $battingLimit) {
        // echo "HEllo"; exit;
        $battingLimit =  count($matchplayingPlayersBatting);
      }

      $totalLengthBatting = count($matchplayingPlayersBatting) - 1;

      if ($orderSeq == 1 && count($matchplayingPlayersBatting) > $battingLimit) {
        $totalLengthBatting = $battingLimit;
      }


      while ($tlBatting < $battingLimit) {

        $randomBatting = rand(0, $totalLengthBatting);
        if (!in_array($randomBatting, $isRandomedBatting)) {
          $object = new stdClass;
          $object->playerid = $matchplayingPlayersBatting[$randomBatting]->playerid;
          $object->credit = $matchplayingPlayersBatting[$randomBatting]->credit;
          $object->team = $matchplayingPlayersBatting[$randomBatting]->team;
          $battingSum = $battingSum + $matchplayingPlayersBatting[$randomBatting]->credit;
          $battingSelectedPercent = $battingSelectedPercent + $matchplayingPlayersBatting[$randomBatting]->selected_percent;
          array_push($battingDataArr, $object);
          array_push($isRandomedBatting, $randomBatting);
          $tlBatting++;
        }
      }




      //
      // $matchplayingPlayersBowler = DB::table('matchplayers')
      // ->where('matchkey' , $matchkey)
      // ->whereIn('playerid' , $matchPlayers)->where('matchplayers.role' , 'bowler')
      // ->join('players' , 'players.id' , '=' , 'matchplayers.playerid')
      // ->select('matchplayers.playerid' , 'matchplayers.selected_percent' , 'matchplayers.credit' , 'players.team')
      // ->get();

      $tlBowling = 0;
      $isRandomedBowling = array();
      $BowlingDataArr = array();
      $BowlingSum = 0;
      $bowlingSelectedPercent = 0;
      if (count($matchplayingPlayersBowler) < $bowlingLimit) {
        // echo "HEllo"; exit;
        $bowlingLimit =  count($matchplayingPlayersBowler);
      }

      $TotalLengthBowling = count($matchplayingPlayersBowler) - 1;


      if ($orderSeq == 1 && count($matchplayingPlayersBowler) > $bowlingLimit) {
        $TotalLengthBowling = $bowlingLimit;
      }



      while ($tlBowling < $bowlingLimit) {

        $randomBowling = rand(0, $TotalLengthBowling);
        if (!in_array($randomBowling, $isRandomedBowling)) {
          $object = new stdClass;
          $object->playerid = $matchplayingPlayersBowler[$randomBowling]->playerid;
          $object->credit = $matchplayingPlayersBowler[$randomBowling]->credit;
          $object->team = $matchplayingPlayersBowler[$randomBowling]->team;
          $BowlingSum = $BowlingSum + $matchplayingPlayersBowler[$randomBowling]->credit;
          $bowlingSelectedPercent = $bowlingSelectedPercent + $matchplayingPlayersBowler[$randomBowling]->selected_percent;
          array_push($BowlingDataArr, $object);
          array_push($isRandomedBowling, $randomBowling);
          $tlBowling++;
        }
      }




      // $matchplayingPlayersAllrounder = DB::table('matchplayers')
      // ->where('matchkey' , $matchkey)
      // ->whereIn('playerid' , $matchPlayers)->where('matchplayers.role' , 'allrounder')
      // ->join('players' , 'players.id' , '=' , 'matchplayers.playerid')
      // ->select('matchplayers.playerid' , 'matchplayers.selected_percent' , 'matchplayers.credit' , 'players.team')
      // ->get();
      //   var_dump(count($matchplayingPlayersAllrounder));
      // var_dump($AllRounderLimit);exit;
      $tlAllRounder = 0;
      $isRandomedAllRounder = array();
      $AllRounderDataArr = array();
      $AllRounderSum = 0;
      $allRounderSelectedPercent = 0;
      if (count($matchplayingPlayersAllrounder) < $AllRounderLimit) {
        // echo "HEllo"; exit;
        $AllRounderLimit =  count($matchplayingPlayersAllrounder);
      }
      $TotalLengthAllRounder = count($matchplayingPlayersAllrounder) - 1;


      if ($orderSeq == 1 && count($matchplayingPlayersAllrounder) > $AllRounderLimit) {
        $TotalLengthAllRounder = $AllRounderLimit;
      }


      while ($tlAllRounder < $AllRounderLimit) {
        $randomAllRounder = rand(0, $TotalLengthAllRounder);
        if (!in_array($randomAllRounder, $isRandomedAllRounder)) {
          $object = new stdClass;
          $object->playerid = $matchplayingPlayersAllrounder[$randomAllRounder]->playerid;
          $object->credit = $matchplayingPlayersAllrounder[$randomAllRounder]->credit;
          $object->team = $matchplayingPlayersAllrounder[$randomAllRounder]->team;
          $AllRounderSum = $AllRounderSum + $matchplayingPlayersAllrounder[$randomAllRounder]->credit;
          $allRounderSelectedPercent = $allRounderSelectedPercent + $matchplayingPlayersAllrounder[$randomAllRounder]->selected_percent;
          array_push($AllRounderDataArr, $object);
          array_push($isRandomedAllRounder, $randomAllRounder);
          $tlAllRounder++;
        }
      }

      //
      //
      //
      // $matchplayingPlayersWicketKeeper = DB::table('matchplayers')
      // ->where('matchkey' , $matchkey)
      // ->whereIn('playerid' , $matchPlayers)->where('matchplayers.role' , 'keeper')
      // ->join('players' , 'players.id' , '=' , 'matchplayers.playerid')
      // ->select('matchplayers.playerid' , 'matchplayers.selected_percent' , 'matchplayers.credit' , 'players.team')
      // ->get();

      $tlKeeper = 0;
      $isRandomedKeeper = array();
      $KeeperDataArr = array();
      $KeeperSum = 0;
      $keeperSelectedPercent = 0;
      if (count($matchplayingPlayersWicketKeeper) < $KeeperLimit) {
        // echo "HEllo"; exit;
        $KeeperLimit =  count($matchplayingPlayersWicketKeeper);
      }

      $totalLengthKeeper = count($matchplayingPlayersWicketKeeper) - 1;


      if ($orderSeq == 1 && count($matchplayingPlayersWicketKeeper) > $KeeperLimit) {
        $totalLengthKeeper = $KeeperLimit;
      }

      while ($tlKeeper < $KeeperLimit) {

        $randomkeeper = rand(0, $totalLengthKeeper);

        if (!in_array($randomkeeper, $isRandomedKeeper)) {
          $object = new stdClass;
          $object->playerid = $matchplayingPlayersWicketKeeper[$randomkeeper]->playerid;
          $object->credit = $matchplayingPlayersWicketKeeper[$randomkeeper]->credit;
          $KeeperSum = $KeeperSum + $matchplayingPlayersWicketKeeper[$randomkeeper]->credit;
          $object->team = $matchplayingPlayersWicketKeeper[$randomkeeper]->team;
          $keeperSelectedPercent = $keeperSelectedPercent + $matchplayingPlayersWicketKeeper[$randomkeeper]->selected_percent;
          array_push($KeeperDataArr, $object);
          array_push($isRandomedKeeper, $randomkeeper);
          $tlKeeper++;
        }
      }


      $allSum = $battingSum + $BowlingSum + $AllRounderSum + $KeeperSum;
      $allSelectedPercent = $battingSelectedPercent + $bowlingSelectedPercent + $allRounderSelectedPercent + $keeperSelectedPercent;

      $allplayers = array_merge($battingDataArr, $BowlingDataArr, $AllRounderDataArr, $KeeperDataArr);
      // var_dump($battingDataArr);
      // var_dump(count($battingDataArr));
      // var_dump(count($battingDataArr) < 3);
      // exit;
      if (count($battingDataArr) < 3) {
        return array();
      }
      if (count($BowlingDataArr) < 3) {
        return array();
      }
      if (count($AllRounderDataArr) < 1) {
        return array();
      }
      if (count($KeeperDataArr) < 1) {
        return array();
      }
      $playerId = array();
      foreach ($allplayers as $key => $value_ss) {
        $playerId[] = $value_ss->playerid;
      }
      // var_dump();
      // exit;
      // var_dump(array_unique($allplayers));
      // exit;
      if (count(array_unique($playerId)) >= 11) {

        $CountTeam = array();
        $CountTeam = array_count_values(array_column($allplayers, 'team'));
        $team1 = 0;
        $team2 = 0;
        if (isset($CountTeam[$team->team1])) {
          $team1 = $CountTeam[$team->team1];
        }
        if (isset($CountTeam[$team->team2])) {
          $team2 = $CountTeam[$team->team2];
        }
        $allplayers = collect($allplayers)->sortBy('playerid')->toArray();
        $object = new stdClass;
        $object->allplayers = $allplayers;
        $object->criteria = $criteria;
        // $object->secret_number = 0;
        $object->sum = $allSum;
        $object->selected_percent = $allSelectedPercent;
        // var_dump($object);exit;
        switch ($teampetern) {
          case 1: {
              if ($team1 <= 7 && $team2 <= 4) return $object;
              else return array();
            }
            break;
          case 2: {
              if ($team1 <= 4 && $team2 <= 7) return $object;
              else return array();
            }
            break;
          case 3: {
              if ($team1 <= 6 && $team2 <= 5) return $object;
              else return array();
            }
            break;
          case 4: {
              if ($team1 <= 5 && $team2 <= 6) return $object;
              else return array();
            }
            break;
          default: {
              return array();
            }
        }
      }
      return array();
    }
  }
  public function update_result_basketball()
  {
    ini_set('max_execution_time', 30000);

    date_default_timezone_set('Asia/Kolkata');
    $sport_type = DB::table('sport_types')->where('sport_key', BASKETBALL)->first();
    $findmatchexist = DB::table('listmatches')->whereDate('start_date', '<=', date('Y-m-d'))->where('sport_type', $sport_type->id)->whereDate('start_date', '>=', date('Y-m-d', strtotime('-14 days')))->where('launch_status', 'launched')->where('final_status', '!=', 'winnerdeclared')->where('status', '!=', 'completed')->get();
    foreach ($findmatchexist as $match) {

      $getcurrentdate = date('Y-m-d H:i:s');
      $matchtimings = $match->start_date;
      if ($getcurrentdate > $matchtimings) {

        $this->getscoresupdates($match->matchkey, $sport_type->id);
      }

      $matchtimings = date('Y-m-d H:i:s', strtotime('-70 minutes', strtotime($matchtimings)));
      if ($getcurrentdate > $matchtimings) {
        // $this->get_playing_11_new($match->matchkey,$sport_type->sport_key);
      }
    }
  }
  //Match Result
  public function match_result()
  {
    $td_dt = date('Y-m-d');
    $formData = Input::all();
    if (isset($formData) && !empty($formData)) {
      return Datatables::of(DB::table('series as s')
        ->where('series_status', 'opened')
        ->leftJoin('listmatches as lm', 'lm.series', '=', 's.id')
        ->select('s.name as series_name', 's.id as series_id', 'lm.title as listmatches_title', 's.created_at as created_at', 's.end_date as end_date', 'lm.matchkey as listmatches_matchkey')
        ->groupBY('s.id')->get())
        ->addIndexColumn()
        ->addColumn('id', function ($result) {
          return $result->series_id;
        })
        ->addColumn('series_name', function ($result) {
          return '<td class="sorting_1" style="width:200px;"><u><a style="" href="' . route($this->model . '.match_detail', base64_encode(serialize($result->series_id))) . '">' . $result->series_name . '</a></u></td>';
        })
        ->addColumn('totalmatch', function ($result) {
          $totalmatch = DB::table('listmatches as lm')
            ->where('series', $result->series_id)
            ->join('matchchallenges as mc', 'mc.matchkey', '=', 'lm.matchkey')
            ->groupBy('mc.matchkey')->get();
          return count($totalmatch);
        })
        ->addColumn('findalllistmatches', function ($result) {
          $findalllistmatches = DB::table('listmatches as lm')
            ->join('matchchallenges as mc', 'mc.matchkey', '=', 'lm.matchkey')
            ->where('lm.series', $result->series_id)
            ->where('lm.final_status', '!=', 'winnerdeclared')
            ->select('lm.id as listmatches_id')
            ->groupBy('mc.matchkey')->get();
          return count($findalllistmatches);
        })
        ->addColumn('created_at', function ($result) {
          return date('d/m/y h:i:s a', strtotime($result->created_at)) . ' TO ' . date('d/m/y h:i:s a', strtotime($result->end_date));
        })
        //->rawColumns(['action'])
        ->escapeColumns([])
        ->make(true);
    } //end


    return view("admin.$this->model.match_result");
  } //End Function


  //Match Result
  public function series_list()
  {

    $findalllistmatches = DB::table('series as s')
      ->where('series_status', 'opened')
      ->select('s.name as series_name', 's.id as series_id')
      ->orderBY('s.id', 'DESC')
      ->groupBY('s.id')->get();
    return view("admin.$this->model.match_results", compact('findalllistmatches'));
  } //End Function

  ///Match Details
  public function match_detail($id = null)
  {


// echo "string";die;
    //Get Id
    // $id = unserialize(base64_decode($id));
    // dd($id);
    //Ajax Post Data
    $formData = Input::all();
    if (isset($formData) && !empty($formData)) {

      /* match filtered with status  */
      $where_condition = '';
      $where_operation = '';
      $where_value = '';
      if ($formData['matchStatus'] == 'pending') {
        $where_condition = "lm.final_status";
        $where_operation = "!=";
        $where_value = "pending";
      } elseif ($formData['matchStatus'] == 'IsReviewed') {
        $where_condition = "lm.final_status";
        $where_operation = "=";
        $where_value = "IsReviewed";
      } elseif ($formData['matchStatus'] == 'winnerdeclared') {
        $where_condition = "lm.final_status";
        $where_operation = "=";
        $where_value = "winnerdeclared";
      } else {
        $where_condition = "lm.final_status";
        $where_operation = "!=";
        $where_value = "";
      }

      // echo DB::table('seriess as s')
      //   ->join('listmatches as lm', 'lm.series', '=', 's.id')
      //   ->join('matchchallenges as mc', 'mc.matchkey', '=', 'lm.matchkey')
      //   ->where('s.id', $id)
      //   ->where([['lm.launch_status', '=', 'launched'], [$where_condition, $where_operation, $where_value]])
      //   ->select('mc.id as matchchallenges_id', 'lm.title as listmatches_title', 'lm.start_date as listmatches_start_date', 'lm.matchkey as listmatches_matchkey', 's.id as series_id', 'lm.status as listmatches_status', 'lm.launch_status as listmatches_launch_status', 'lm.final_status as listmatches_final_status', 'lm.sport_type as listmatches_sport_key', 'lm.is_refer_tdsdeduct as is_refer_tdsdeduct', 'lm.is_update_investment_leaderboard as is_update_investment_leaderboard', 'lm.is_promoter_leaderboard_enable',   DB::raw('count(mc.matchkey) as total_challenge'), DB::raw('sum(mc.joinedusers) as total_joinedusers'))
      //   ->groupBY('lm.matchkey')
      //   ->orderBy('lm.start_date', 'DESC')
      //   ->get(); die;


      return Datatables::of(DB::table('series as s')
        ->join('listmatches as lm', 'lm.series', '=', 's.id')
        ->join('matchchallenges as mc', 'mc.matchkey', '=', 'lm.matchkey')
        ->where('s.id', $id)
        ->where('lm.status','!=', 'notstarted')
        ->where([['lm.launch_status', '=', 'launched'], [$where_condition, $where_operation, $where_value]])
        ->select('mc.id as matchchallenges_id', 'lm.title as listmatches_title', 'lm.start_date as listmatches_start_date', 'lm.matchkey as listmatches_matchkey', 's.id as series_id', 'lm.status as listmatches_status', 'lm.launch_status as listmatches_launch_status', 'lm.final_status as listmatches_final_status', 'lm.sport_type as listmatches_sport_key', 'lm.is_refer_tdsdeduct as is_refer_tdsdeduct', 'lm.is_update_investment_leaderboard as is_update_investment_leaderboard', 'lm.is_promoter_leaderboard_enable',   DB::raw('count(mc.matchkey) as total_challenge'), DB::raw('sum(mc.joinedusers) as total_joinedusers'))
        ->groupBY('lm.matchkey')
        ->orderBy('lm.start_date', 'DESC')
        ->get())
        ->addIndexColumn()
        ->addColumn('id', function ($result) {
          return $result->series_id;
        })
        ->addColumn('match_name', function ($result) {
          $cancelconcount = DB::table('matchchallenges')
            //  ->join('joinedleauges','matchchallenges.id','=','joinedleauges.challengeid')
            ->where('matchchallenges.matchkey', $result->listmatches_matchkey)
            ->where('matchchallenges.status', 'canceled')
            ->count();
          $cancelconcount = !empty($cancelconcount) ? $cancelconcount : 0;
          $statsdata = '';
          $statsdata .= '<p><u><a href="' . route($this->model . '.match_points', [$result->listmatches_matchkey, $result->listmatches_sport_key]) . '">' . $result->listmatches_title . '</a></u></p>
                    <p>' . date('l, d-M-y h:i:s a', strtotime($result->listmatches_start_date)) . '</p>
                    <p><u><a href="' . route('Challenges.create_challenges', $result->listmatches_matchkey) . '">Total Challenges : ' . $result->total_challenge . '</a></p>
                    <p><a href="' . route($this->model . '.join_users', [$result->listmatches_matchkey, $result->listmatches_sport_key]) . '">Join Persons : ' . $result->total_joinedusers . '</a></p>
                    <p><a >Match status :' . $result->listmatches_final_status . '</a></p>
                    <p><a href="' . route($this->model . '.contest_cancel', [$result->listmatches_matchkey, $result->listmatches_sport_key]) . '">Canceled Contest : ' . $cancelconcount . '</a></p>';
          if ($result->listmatches_final_status == 'winnerdeclared') {
            $statsdata .= '<p><a href="' . route($this->model . '.winner_list', [$result->listmatches_matchkey, $result->listmatches_sport_key]) . '">Winning User List</a></p>
                      ';
          }
          return $statsdata;
        })
        ->addColumn('action', function ($result) {
          $promo_matches = '';
          // if ($result->listmatches_final_status == 'winnerdeclared' && $result->is_promoter_leaderboard_enable == 0) {
          //   $promo_matches = '<a class="btn btn-danger ml-2 mt-3 cust-padd" href="' . route('Admin.add_matches_Promoters_leaderboard', [$result->listmatches_matchkey, $result->listmatches_sport_key]) . '"><i class=" mr-2"></i>Update Match Promotors Leaderboard<a/>';
          // }
          if ($result->listmatches_final_status == 'winnerdeclared' && $result->is_refer_tdsdeduct == 0 && $result->listmatches_start_date >= '2023-05-01 00:00:00') {
            // $promo_matches .= '<a class="btn btn-info ml-2 mt-3 cust-padd" href="'.route('Admin.getMatchForReferCommissionAndTds',[$result->listmatches_matchkey, $result->listmatches_sport_key]).'"><i class=" mr-2"></i>TDS on Affiliation Commission<a/>';
          }
          return '
                <a class="btn btn-success action-btn" href="' . route($this->model . '.addlinup', $result->listmatches_matchkey) . '">Add/Edit Lineup</a>
                        <a class="btn btn-success action-btn" href="' . route($this->model . '.viewEditPoints', [$result->listmatches_matchkey, $result->listmatches_sport_key]) . '">View/Edit points</a>
                        <a class="btn btn-success action-btn" href="' . route($this->model . '.launchmatch', [$result->listmatches_matchkey, $result->listmatches_sport_key]) . '">View Players</a>
                          <a class="btn btn-info action-btn" href="' . route($this->model . '.editmatch', [$result->listmatches_matchkey, $result->listmatches_sport_key]) . '">Edit Match</a>' . $promo_matches;
        })
        ->addColumn('match_status', function ($result) {
          $final_status_not_winnerdeclared = '';
          $final_status = '';
          $final_status_investment = '';
          //Set
          /*if($result->listmatches_final_status!='winnerdeclared'){
                $final_status_not_winnerdeclared='<div class="col-md-12 col-sm-12" style="padding:10px;border:1px solid #ddd;">
                        <form action="'.route($this->model.'.update_manually').'" method="post">
                            '.csrf_field().'
                            <input type="hidden" value="'.$result->listmatches_matchkey.'" name="matchkey">
                            <select class="form-control" name="final_status">
                                <option value=""> Select status </option>
                                <option value="pending"> Pending </option>
                                <option value="IsReviewed"> IsReviewed </option>
                            </select>
                            <div class="col-md-12 col-sm-12"  style="margin-top:10px;">
                                <button class="btn btn-info"> Update status </button>
                            </div>
                            </form>
                        </div>';
                }*/
          if ($result->listmatches_final_status != 'winnerdeclared') {
            $final_status_not_winnerdeclared = '<div class="col-md-12 col-sm-12 mb-2" style="padding:0px;">
                        <form action="' . route($this->model . '.update_manually') . '" method="post" class="pt-2">
                            ' . csrf_field() . '
                            <input type="hidden" value="' . $result->listmatches_matchkey . '" name="matchkey">
                            <select class="form-control in_text w-65" name="final_status">
                                <option value=""> Select status </option>
                                <option value="pending"> Pending </option>
                                <option value="IsReviewed"> IsReviewed </option>
                            </select>
                            <button class="btn btn-info ml-2 cust-padd"><i class="fa fa-refresh mr-2"></i>Update Status</button>
                            <div class="col-md-12 col-sm-12"  style="margin-top:10px;">

                            </div>
                            </form>
                        </div>';
          }
          if ($result->listmatches_final_status == 'pending') {

            $final_status = '<p class="mb-0"><u><a style="color:red;" onclick="confirm("Are you sure?")" href="' . route($this->model . '.update_match_final_status', [$result->listmatches_matchkey, $result->listmatches_sport_key, 'IsAbandoned']) . '">IsAbandoned</a></u></p>
                        <p class="mb-0"><u><a style="color:red;" onclick="confirm("Are you sure?")" href="' . route($this->model . '.update_match_final_status', [$result->listmatches_matchkey, $result->listmatches_sport_key, 'IsCanceled']) . '">IsCanceled</a></u></p>';
            if ($result->listmatches_status == 'started') {
              $final_status .= '<p class="mb-0"><u><a style="color:red;" onclick="confirm("Are you sure?")" href="' . route($this->model . '.update_match_final_status', [$result->listmatches_matchkey, $result->listmatches_sport_key, 'IsClosed']) . '">IsClosed</a></u></p>';
            }
          } else if ($result->listmatches_status == 'completed' && $result->listmatches_final_status != 'IsReviewed' && $result->listmatches_final_status != 'winnerdeclared') {
            $final_status = '<p class="mb-0"><u><a style="color:red;" onclick="confirm("Are you sure?")" href="' . route($this->model . '.update_match_final_status', [$result->listmatches_matchkey, $result->listmatches_sport_key, 'IsCanceled']) . '">IsCanceled</a></u></p>
                        <p class="mb-0"><u><a style="color:red;" onclick="confirm("Are you sure?")" href="' . route($this->model . '.update_match_final_status', [$result->listmatches_matchkey, $result->listmatches_sport_key, 'IsReviwed']) . '">IsReviwed</a></u></p>';
          } else if ($result->listmatches_status == 'completed' && $result->listmatches_final_status == 'IsReviewed') {
            $final_status = '<p class="mb-0"><u><a style="color:red;" onclick="confirm("Are you sure?")" href="' . route($this->model . '.match_points', [$result->listmatches_matchkey, $result->listmatches_sport_key]) . '">IsReviwed</a></u></p>
                        <p class="mb-0"><u><a style="color:red;" onclick="confirm("Are you sure?")" href="' . route($this->model . '.update_match_final_status', [$result->listmatches_matchkey, $result->listmatches_sport_key, 'winnerdeclared']) . '">IsWinnerDeclared</a></u></p>';
          } else if ($result->listmatches_status == 'completed' && $result->listmatches_final_status == 'IsClosed') {
            $final_status = '<p class="mb-0"><u><a style="color:red;" onclick="confirm("Are you sure?")" href="' . route($this->model . '.update_match_final_status', [$result->listmatches_matchkey, $result->listmatches_sport_key, 'IsCanceled']) . '">IsCanceled</a></u></p>
                        <p class="mb-0"><u><a style="color:red;" onclick="confirm("Are you sure?")" href="' . route($this->model . '.listmatches_matchkey', $result->listmatches_matchkey) . '">IsReviwed</a></u></p>';
          } else if ($result->listmatches_final_status == 'winnerdeclared') {
            $final_status = '<p class="mb-0 in_text w-65 success_winner"> Winner Declared</p>
                            <p class="mb-0"><a class="btn btn-info ml-2 cust-padd" onclick="confirm("Are you sure?")"  href="' . route($this->model . '.viewwinners', $result->listmatches_matchkey) . '"><i class="fa fa-eye mr-2"></i>View Winners </a></p>';
          }
          if ($result->is_update_investment_leaderboard == 0 && $result->listmatches_final_status == 'winnerdeclared') {
            $final_status_investment = '
                            <p class="mb-0">
                            <a class="btn btn-info ml-2 cust-padd"  href="' . route($this->model . '.update_match_leaderboard', [$result->listmatches_matchkey, $result->listmatches_sport_key]) . '"><i class=" mr-2"></i>Update Match Series Leaderboard</a>
                            </p>';
          }
          // return  $final_status_not_winnerdeclared
          //         .$final_status ;
          return  $final_status_not_winnerdeclared
            . $final_status . $final_status_investment;
        })
        ->escapeColumns([])
        ->make(true);
    } //end
    return view("admin.$this->model.match_detail", compact('id'));
  } //End Function

  //xxxxxxxxxxxxxx TDS deduction on match wise xxxxxxxxxxxxxxxxxxx

  public function getMatchForReferCommissionAndTds($matchkey = '12345', $sport_type = '1')
  {
    $getMatches = DB::table('listmatches')
      ->where("refer_bonus", 1)
      ->where("is_refer_tdsdeduct", 0)
      ->where('final_status', "=", 'winnerdeclared')
      ->where('start_date', '>', date("Y-m-d H:i:s", strtotime("2023-05-01 00:00:00")))
      ->where('matchkey', $matchkey)
      ->where('sport_type', $sport_type)
      ->select('matchkey', 'sport_type')
      ->orderBy('start_date', 'ASC')
      ->first();
    if (!empty($getMatches)) {
      $c = $this->referCommisionAddInWalletAndTdsDeduct($getMatches->matchkey, $getMatches->sport_type);
      Session::flash('message', 'Deducted TDS Amount On Affiliation Commission....');
      Session::flash('alert-class', 'alert-success');
      return redirect()->back();
    } else {
      Session::flash('message', 'Match is already Deducted TDS Amount of Affiliation Commission');
      Session::flash('alert-class', 'alert-danger');
      return redirect()->back();
    }
  }

  public function referCommisionAddInWalletAndTdsDeduct($matchkey, $sport_type)
  {

    date_default_timezone_set("Asia/Kolkata");
    $matchDetail = DB::table("listmatches")
      ->where("matchkey", $matchkey)
      ->where("sport_type", $sport_type)
      ->where("refer_bonus", 1)
      ->where("final_status", '=', 'winnerdeclared')
      ->where("start_date", '>=', '2023-04-30 23:59:59')
      ->where("is_refer_tdsdeduct", 0)
      ->select("start_date", "is_refer_tdsdeduct", 'refer_bonus')
      ->orderBY("id", "DESC")
      ->first();
    // echo "<pre>"; print_r($matchDetail);exit();
    if (empty($matchDetail)) {
      return 1;
    }
    $tds_date = $matchDetail->start_date;
    $league_refer_tds = DB::table('league_refer_bonus as lrb')
      // ->leftJoin("pancard as p", "p.userid", "=", "lrb.refer_id")
      ->whereIn('challenge_id', function ($q) use ($matchkey, $sport_type) {
        $q->selectRaw('id')->from('matchchallenges')
          ->where('matchkey', $matchkey)
          ->where('sport_type', $sport_type)
          ->where('status', '<>', 'canceled')
          ->where('entryfee', '>', 0);
      })
      ->where('lrb.amount', '>', 0)
      ->where('lrb.tds_type', 1)
      ->whereIn('lrb.refer_id', ['30', '36'])
      ->where('lrb.is_promoters_commission', 1)
      ->selectRaw('SUM(lrb.amount) as commision, lrb.refer_id as userid')
      ->groupBy('lrb.refer_id')
      ->get();
    // echo "<pre>"; print_r($league_refer_tds); exit;
    if ($league_refer_tds->isNotEmpty()) {

      foreach ($league_refer_tds as $key => $value) {
        $userid = $value->userid;
        $tds_perc = 5;
        $exists = DB::table('tds_refer_commission')
          ->where("matchkey", $matchkey)
          ->where("sport_type", $sport_type)
          ->where("userid", $userid)
          ->count();
        // echo $exists; exit;
        if ($exists < 1) {
          $amount = $value->commision;

          $tds_amount = $amount * ($tds_perc / 100);
          $net_commission_amount = round(($amount - $tds_amount), 2);
          $tds_transaction_id = 'PlaynWin11-ACTDS' . time() . '' . $userid;

          $tds_refer_commission = array(
            "userid" => $userid,
            "transaction_id" => $tds_transaction_id,
            "matchkey" => $matchkey,
            "sport_type" => $sport_type,
            "amount" => $amount,
            "tds_amount" => round($tds_amount, 2),
            "net_commission_amount"  => $net_commission_amount,
            "tds_date" => $tds_date,
            "tds_perc" => $tds_perc
          );

          DB::table('tds_refer_commission')->insert($tds_refer_commission);

          $userbalance = DB::table('userbalances')->where('user_id', $userid)->first();

          //commision transactions entry

          // $commission_transaction = array(
          //   "userid"=> $userid,
          //   "type"=>'Affiliation Commission',
          //   "transaction_id" => $tds_transaction_id,
          //   "transaction_by" => 'PlaynWin11',
          //   "amount" => $amount,
          //   "win_amt" =>$amount,
          //   "paymentstatus" =>'confirmed',
          //   "bal_win_amt" => round(($userbalance->winning+$amount),2),
          //   "bal_fund_amt" => $userbalance->balance,
          //   "bal_bonus_amt" => $userbalance->bonus,
          //   "total_available_amt" => round(($userbalance->winning + $amount + $userbalance->balance+$userbalance->bonus),2),
          // );
          //  DB::table("transactions")->insert($commission_transaction);

          // echo "transactions commission"; print_r($commission_transaction);

          // $user_wining_balance_after_commission = round($userbalance->winning+$amount,2);
          $user_wining_balance_after_commission = round($userbalance->winning, 2);
          $tds_amount = round($tds_amount, 2);
          //end commission transactions entry

          //tds transactions entry
          if ($tds_amount > 0) {
            $tds_transaction = array(
              "userid" => $userid,
              "type" => 'TDS Amount On Affiliation Commission',
              "transaction_id" => $tds_transaction_id,
              "transaction_by" => 'wallet',
              "amount" => $tds_amount,
              "cons_win" => $tds_amount,
              "paymentstatus" => 'confirmed',
              "bal_win_amt" => round($user_wining_balance_after_commission - $tds_amount, 2),
              "bal_fund_amt" => $userbalance->balance,
              "bal_bonus_amt" => $userbalance->bonus,
              "total_available_amt" => round((($user_wining_balance_after_commission - $tds_amount) + $userbalance->balance + $userbalance->bonus), 2)
            );
            DB::table("transactions")->insert($tds_transaction);
            // echo "transactions tds"; print_r($tds_transaction);
          }
          //end tds transactions entry


          $updateWinning = array();
          $updateWinning["affiliation_commission"] = round($user_wining_balance_after_commission - $tds_amount, 2);
          DB::table('userbalances')->where('user_id', $userid)->update($updateWinning);

          $session_year = date("Y");
          $registerusers_session = DB::table("registerusers_session")
            ->where("user_id", $userid)
            ->where("session_year", $session_year)
            ->first();
          if (!empty($registerusers_session)) {
            DB::table("registerusers_session")
              ->where("id", $registerusers_session->id)
              ->update([
                "total_commission" => $registerusers_session->total_commission + $net_commission_amount
              ]);
          }
        }
      }
      DB::table("listmatches")
        ->where("matchkey", $matchkey)
        ->where("sport_type", $sport_type)
        ->update(["is_refer_tdsdeduct" => 1]);
    }
  }

  //Update Mannually
  public function updatemanually(Request $request)
  {
    if ($request->isMethod('post')) {
      $input = Input::all();
      $matchkey = $input['matchkey'];
      if ($input['final_status'] != "") {
        $data['final_status'] = $input['final_status'];
        DB::table('listmatches')->where('matchkey', $matchkey)->update($data);
        Session::flash('flash_notice',  trans("Match status Update successfully!"));
        return Redirect::back();
      }
      Session::flash('error',  trans("Please Select Option'"));
      return Redirect::back();
    }
    Session::flash('error',  trans("Please Select Option'"));
    return Redirect::back();
  } //End Function

  //Update Match Final Status
  public function updatematchfinalstatus($matchkey = null, $sport_type = null, $status = null)
  {
    $input['final_status'] = $status;
    $findseries = DB::table('listmatches')->where('matchkey', $matchkey)->where('sport_type', $sport_type)->select('series', 'format', 'name', 'flexible_breakup_set')->first();

    if ($status == 'IsAbandoned' || $status == 'IsCanceled') {
      $input["status"] = "completed";
      $resultpoints = MatchesController::refund_allamount($matchkey, $sport_type);
      //  $resultpoints = MatchesController::contest_refund_amount($matchkey,$sport_type);
    }

    if ($status == 'winnerdeclared') {

      $matchchallenges_flaxible = DB::table('matchchallenges')
        ->where('matchkey', $matchkey)
        ->where('sport_type', $sport_type)
        ->where('status', '!=', 'canceled')
        ->where('status', '!=', 'closed')
        ->where('entryfee', '>', 0)
        ->where('joinedusers', '>', 0)
        ->where('is_flexible', 1)
        ->where('is_flexible_updated', 0)
        ->count();
      if ($matchchallenges_flaxible > 0) {
        Session::flash('flash_notice', 'few contests of this match are not flexible, please check after sometime.');
        return Redirect::back();
      }
      $res = MatchesController::distribute_winning_amount($matchkey, $findseries->format, $sport_type);
    }
    DB::table('listmatches')->where('matchkey', $matchkey)->where('sport_type', $sport_type)->update($input);

    $lead = MatchesController::update_match_leaderboard($matchkey);


    // Winner Notifcation final result
    if ($status == 'winnerdeclared') {
      $getwinneruser = DB::table('finalresults')
        ->join('registerusers', 'registerusers.id', '=', 'finalresults.userid')
        ->where('finalresults.matchkey', $matchkey)
        ->select('finalresults.userid', 'registerusers.username', DB::raw('sum(amount) as totalwinning'))
        ->groupBY('userid')
        ->get();
      // if(!empty($getwinneruser))
      // {
      //    foreach ($getwinneruser as $key => $winnerdata)
      //   {
      //      $title= 'Winner declared';
      //      $message= 'Congratulations '.@$winnerdata->username.' you have won '.@$winnerdata->totalwinning.' in '.@$findseries->name;
      //      Helpers::sendnotificationWinning($title,$message,@$winnerdata->userid);
      //    }
      // }
    }

    $investment = MatchesController::update_match_investment_leaderboard($matchkey, $sport_type);
    $promoter_user_leaderboard = MatchesController::update_promoter_match_leaderboard($matchkey);


    Session::flash('flash_notice', 'Match ' . $status . ' Update successfully!');
    Helpers::logActivity('Winner declared successfully!', $matchkey);
    return Redirect::back();
  } //End Function



  //Get All Refund Amount of cancel contest
  public function refund_allamount_of_contest($match_key, $challengeid, $sport_type)
  {

    $joinedleauges = DB::table('joinedleauges')->where('matchkey', $match_key)->where('sport_type', $sport_type)->where('challengeid', $challengeid)->select('challengeid', 'userid', 'id')->get();
    foreach ($joinedleauges as $val1) {
      $matchchallenges = DB::table('matchchallenges')->where('id', $val1->challengeid)->first();
      $leaugestransactions = DB::table('leaugestransactions')->where('matchkey', $match_key)->where('challengeid', $val1->challengeid)->get();
      foreach ($leaugestransactions as $val3) {
        $entryfee = $matchchallenges->entryfee;
        $findlastow = DB::table('userbalances')->where('user_id', $val3->user_id)->first();
        $registeruserdetails = DB::table('registerusers')->where('id', $val3->user_id)->first();
        if (!empty($findlastow)) {
          $dasts['status'] = 'canceled';
          $dasts['highlights'] = 'Contest canceled due to all users have points same';
          DB::table('matchchallenges')->where('id', $matchchallenges->id)->update($dasts);

          $challengeJoinedFee = round($val3->balance + $val3->winning + $val3->bonus + $val3->gst_bonus + $val3->affiliation_commission, 2);
          $challengeJoinedFee = floatval($challengeJoinedFee);
          $refunddata['userid'] = $val3->user_id;
          $refunddata['amount'] = $challengeJoinedFee; //$entryfee;
          $refunddata['joinid'] = $val3->joinid;
          $refunddata['challengeid'] = $val1->challengeid;
          $refunddata['reason'] = 'Contest canceled due to all users have points same';
          $refunddata['matchkey'] = $match_key;
          $findifalreadyrefund = DB::table('refunds')->where('joinid', $val3->joinid)->first();
          try {
            DB::table('refunds')->insert($refunddata);
            $dataq['balance'] =  $findlastow->balance + $val3->balance;
            $dataq['winning'] =  $findlastow->winning + $val3->winning;
            $dataq['bonus'] =  $findlastow->bonus + $val3->bonus;
            $dataq['gst_bonus'] =  $findlastow->gst_bonus + $val3->gst_bonus;
            $dataq['affiliation_commission'] =  $findlastow->affiliation_commission + $val3->affiliation_commission;
            $registeruserdetails = DB::table('registerusers')->where('id', $val3->user_id)->first();
            $datatr['transaction_id'] = BRAND['name'] . '-REFUND-' . rand(100, 999) . $val3->user_id;
            $datatr['type'] = 'Contest Joining Fee Refund';
            $datatr['transaction_by'] = BRAND['name'];
            $datatr['amount'] = $challengeJoinedFee; //$entryfee;
            $datatr['paymentstatus'] = 'confirmed';
            $datatr['challengeid'] = $matchchallenges->id;
            $datatr['bonus_amt'] = $val3->bonus;
            $datatr['gst_bonus_amt'] = $val3->gst_bonus;
            $datatr['affiliation_amount'] = $val3->affiliation_commission;

            $datatr['win_amt'] = $val3->winning;
            $datatr['addfund_amt'] = $val3->balance;
            $datatr['bal_bonus_amt'] = $dataq['bonus'];
            $datatr['bal_win_amt'] = $dataq['winning'];
            $datatr['bal_fund_amt'] = $dataq['balance'];
            $datatr['bal_gst_bonus_amt'] = $dataq['gst_bonus'];
            $datatr['bal_affi_amt'] = $dataq['affiliation_commission'];
            $datatr['userid'] = $val3->user_id;
            $datatr['total_available_amt'] = $dataq['balance'] + $dataq['winning'] + $dataq['bonus'] + $dataq['gst_bonus'] + $dataq['affiliation_commission'];
            DB::table('transactions')->insert($datatr);
            DB::table('userbalances')->where('id', $findlastow->id)->update($dataq);

            $datan['title'] = 'Refund Amount of ₹' . $challengeJoinedFee . ' for contest cancellation';
            $datan['userid'] = $val3->user_id;
            DB::table('notifications')->insert($datan);
            $titleget = 'Refund Amount!';
            //  Helpers::sendnotification($titleget,$datan['title'],'',$val3->user_id);
          } catch (\Illuminate\Database\QueryException $ex) {
          }
        }
      }
    }
    return 1;
  } //End Function


  public function refund_allamount_of_contest_old26_8($match_key, $challengeid, $sport_type)
  {

    $joinedleauges = DB::table('joinedleauges')->where('matchkey', $match_key)->where('sport_type', $sport_type)->where('challengeid', $challengeid)->select('challengeid', 'userid', 'id')->get();
    foreach ($joinedleauges as $val1) {
      $matchchallenges = DB::table('matchchallenges')->where('id', $val1->challengeid)->first();
      $leaugestransactions = DB::table('leaugestransactions')->where('matchkey', $match_key)->where('challengeid', $val1->challengeid)->get();
      foreach ($leaugestransactions as $val3) {
        $entryfee = $matchchallenges->entryfee;
        $findlastow = DB::table('userbalances')->where('user_id', $val3->user_id)->first();
        $registeruserdetails = DB::table('registerusers')->where('id', $val3->user_id)->first();
        if (!empty($findlastow)) {
          $dasts['status'] = 'canceled';
          $dasts['highlights'] = 'Contest canceled due to all users have points same';
          DB::table('matchchallenges')->where('id', $matchchallenges->id)->update($dasts);

          $challengeJoinedFee = round($val3->balance + $val3->winning + $val3->bonus, 2);
          $challengeJoinedFee = floatval($challengeJoinedFee);
          $refunddata['userid'] = $val3->user_id;
          $refunddata['amount'] = $challengeJoinedFee; //$entryfee;
          $refunddata['joinid'] = $val3->joinid;
          $refunddata['challengeid'] = $val1->challengeid;
          $refunddata['reason'] = 'Contest canceled due to all users have points same';
          $refunddata['matchkey'] = $match_key;
          $findifalreadyrefund = DB::table('refunds')->where('joinid', $val3->joinid)->first();
          try {
            DB::table('refunds')->insert($refunddata);
            $dataq['balance'] =  $findlastow->balance + $val3->balance;
            $dataq['winning'] =  $findlastow->winning + $val3->winning;
            $dataq['bonus'] =  $findlastow->bonus + $val3->bonus;
            $dataq['gst_bonus'] =  $findlastow->gst_bonus + $val3->coins;
            $registeruserdetails = DB::table('registerusers')->where('id', $val3->user_id)->first();
            $datatr['transaction_id'] = BRAND['name'] . '-REFUND-' . rand(100, 999) . $val3->user_id;
            $datatr['type'] = 'Contest Joining Fee Refund';
            $datatr['transaction_by'] = BRAND['name'];
            $datatr['amount'] = $challengeJoinedFee; //$entryfee;
            $datatr['paymentstatus'] = 'confirmed';
            $datatr['challengeid'] = $matchchallenges->id;
            $datatr['bonus_amt'] = $val3->bonus;
            $datatr['gst_bonus_amt'] = $val3->coins;
            $datatr['win_amt'] = $val3->winning;
            $datatr['addfund_amt'] = $val3->balance;
            $datatr['bal_bonus_amt'] = $dataq['bonus'];
            $datatr['bal_win_amt'] = $dataq['winning'];
            $datatr['bal_fund_amt'] = $dataq['balance'];
            $datatr['bal_gst_bonus_amt'] = $dataq['gst_bonus'];
            $datatr['userid'] = $val3->user_id;
            $datatr['total_available_amt'] = $dataq['balance'] + $dataq['winning'] + $dataq['bonus'] + $dataq['gst_bonus'];
            DB::table('transactions')->insert($datatr);
            DB::table('userbalances')->where('id', $findlastow->id)->update($dataq);

            $datan['title'] = 'Refund Amount of ₹' . $challengeJoinedFee . ' for contest cancellation';
            $datan['userid'] = $val3->user_id;
            DB::table('notifications')->insert($datan);
            $titleget = 'Refund Amount!';
            //  Helpers::sendnotification($titleget,$datan['title'],'',$val3->user_id);
          } catch (\Illuminate\Database\QueryException $ex) {
          }
        }
      }
    }
    return 1;
  } //End Function

  //Get All Refund Amount
  public function refund_allamount($match_key = null, $sport_type = null)
  {
    $joinedleauges = DB::table('joinedleauges')->where('matchkey', $match_key)->select('challengeid', 'userid', 'id')->get();
    $listmatches = DB::table('listmatches')->where('matchkey', $match_key)->first();

    foreach ($joinedleauges as $val1) {
      $matchchallenges = DB::table('matchchallenges')->where('id', $val1->challengeid)->where('status', '!=', 'canceled')->get();

      foreach ($matchchallenges as $val2) {
        $leaugestransactions = DB::table('leaugestransactions')->where('matchkey', $match_key)->where('challengeid', $val1->challengeid)->get();
        foreach ($leaugestransactions as $val3) {
          $entryfee = $val2->entryfee;
          $findlastow = DB::table('userbalances')->where('user_id', $val3->user_id)->first();
          $registeruserdetails = DB::table('registerusers')->where('id', $val3->user_id)->first();
          if (!empty($findlastow)) {
            $dasts['status'] = 'canceled';
            DB::table('matchchallenges')->where('id', $val2->id)->update($dasts);
            // $findjoinid =
            $refunddata['userid'] = $val3->user_id;
            $refunddata['amount'] = $entryfee;
            $refunddata['joinid'] = $val3->joinid;
            $refunddata['challengeid'] = $val1->challengeid;
            $refunddata['reason'] = 'Match canceled or abandoned';
            $refunddata['matchkey'] = $match_key;
            $findifalreadyrefund = DB::table('refunds')->where('joinid', $val3->joinid)->first();
            try {
              DB::table('refunds')->insert($refunddata);
              $dataq['balance'] =  $findlastow->balance + $val3->balance;
              $dataq['winning'] =  $findlastow->winning + $val3->winning;
              $dataq['bonus'] =  $findlastow->bonus + $val3->bonus;
              $dataq['gst_bonus'] =  $findlastow->gst_bonus + $val3->gst_bonus;
              $dataq['affiliation_commission'] =  $findlastow->affiliation_commission + $val3->affiliation_commission;
              $registeruserdetails = DB::table('registerusers')->where('id', $val3->user_id)->first();
              $datatr['transaction_id'] = BRAND['name'] . '-REFUND-' . rand(100, 999) . $val3->user_id;
              $datatr['type'] = 'Contest Joining Fee Refund';
              $datatr['transaction_by'] = BRAND['name'];
              $datatr['amount'] = $entryfee;
              $datatr['paymentstatus'] = 'confirmed';
              $datatr['challengeid'] = $val2->id;
              $datatr['bonus_amt'] = $val3->bonus;
              $datatr['gst_bonus_amt'] = $val3->gst_bonus;
              $datatr['affiliation_amount'] = $val3->affiliation_commission;
              $datatr['win_amt'] = $val3->winning;
              $datatr['addfund_amt'] = $val3->balance;
              $datatr['bal_bonus_amt'] = $dataq['bonus'];
              $datatr['bal_win_amt'] = $dataq['winning'];
              $datatr['bal_fund_amt'] = $dataq['balance'];
              $datatr['bal_gst_bonus_amt'] = $dataq['gst_bonus'];
              $datatr['bal_affi_amt'] = $dataq['affiliation_commission'];
              $datatr['userid'] = $val3->user_id;
              $datatr['total_available_amt'] = $dataq['balance'] + $dataq['winning'] + $dataq['bonus'] + $dataq['gst_bonus'] + $dataq['affiliation_commission'];
              DB::table('transactions')->insert($datatr);
              DB::table('userbalances')->where('id', $findlastow->id)->update($dataq);
              $email = @$registeruserdetails->email;
              $emailsubject = 'Match Cancelled / Abandoned-Refund initiated!';
              $content = '<p><strong>Dear Challenger </strong></p>';
              $content .= '<p>Unfortunately the ' . date('M d Y h:i:a', strtotime($listmatches->start_date)) . ' ' . $listmatches->title . ' has been Abandoned / cancelled and your entry fee for the match is getting refunded back to your ' . BRAND['name'] . ' wallet.</p>';
              $msg = Helpers::mailheader();
              $msg .= Helpers::mailbody($content);
              $msg .= Helpers::mailfooter();
              $datan['title'] = 'Refund Amount of ₹' . $val2->entryfee . ' for contest cancellation';
              $datan['userid'] = $val3->user_id;
              DB::table('notifications')->insert($datan);
              //push notifications//
              $titleget = 'Refund Amount!';
              // Helpers::sendnotification($titleget,$datan['title'],'',$val3->user_id);
              //end push notifications//
            } catch (\Illuminate\Database\QueryException $ex) {
            }
          }
        }
      }
    }
    //echo 'ffff';exit;
    return 1;
  } //
  public function refund_allamount_old26_8($match_key = null, $sport_type = null)
  {
    $joinedleauges = DB::table('joinedleauges')->where('matchkey', $match_key)->select('challengeid', 'userid', 'id')->get();
    $listmatches = DB::table('listmatches')->where('matchkey', $match_key)->first();

    foreach ($joinedleauges as $val1) {
      $matchchallenges = DB::table('matchchallenges')->where('id', $val1->challengeid)->where('status', '!=', 'canceled')->get();

      foreach ($matchchallenges as $val2) {
        $leaugestransactions = DB::table('leaugestransactions')->where('matchkey', $match_key)->where('challengeid', $val1->challengeid)->get();
        foreach ($leaugestransactions as $val3) {
          $entryfee = $val2->entryfee;
          $findlastow = DB::table('userbalances')->where('user_id', $val3->user_id)->first();
          $registeruserdetails = DB::table('registerusers')->where('id', $val3->user_id)->first();
          if (!empty($findlastow)) {
            $dasts['status'] = 'canceled';
            DB::table('matchchallenges')->where('id', $val2->id)->update($dasts);
            // $findjoinid =
            $refunddata['userid'] = $val3->user_id;
            $refunddata['amount'] = $entryfee;
            $refunddata['joinid'] = $val3->joinid;
            $refunddata['challengeid'] = $val1->challengeid;
            $refunddata['reason'] = 'Match canceled or abandoned';
            $refunddata['matchkey'] = $match_key;
            $findifalreadyrefund = DB::table('refunds')->where('joinid', $val3->joinid)->first();
            try {
              DB::table('refunds')->insert($refunddata);
              $dataq['balance'] =  $findlastow->balance + $val3->balance;
              $dataq['winning'] =  $findlastow->winning + $val3->winning;
              $dataq['bonus'] =  $findlastow->bonus + $val3->bonus;
              $dataq['gst_bonus'] =  $findlastow->gst_bonus + $val3->coins;
              $registeruserdetails = DB::table('registerusers')->where('id', $val3->user_id)->first();
              $datatr['transaction_id'] = BRAND['name'] . '-REFUND-' . rand(100, 999) . $val3->user_id;
              $datatr['type'] = 'Contest Joining Fee Refund';
              $datatr['transaction_by'] = BRAND['name'];
              $datatr['amount'] = $entryfee;
              $datatr['paymentstatus'] = 'confirmed';
              $datatr['challengeid'] = $val2->id;
              $datatr['bonus_amt'] = $val3->bonus;
              $datatr['gst_bonus_amt'] = $val3->coins;
              $datatr['win_amt'] = $val3->winning;
              $datatr['addfund_amt'] = $val3->balance;
              $datatr['bal_bonus_amt'] = $dataq['bonus'];
              $datatr['bal_win_amt'] = $dataq['winning'];
              $datatr['bal_fund_amt'] = $dataq['balance'];
              $datatr['bal_gst_bonus_amt'] = $dataq['gst_bonus'];
              $datatr['bal_affi_amt'] = @$findlastow->affiliation_commission;
              $datatr['userid'] = $val3->user_id;
              $datatr['total_available_amt'] = $dataq['balance'] + $dataq['winning'] + $dataq['bonus'] + $dataq['gst_bonus'] + @$findlastow->affiliation_commission;
              DB::table('transactions')->insert($datatr);
              DB::table('userbalances')->where('id', $findlastow->id)->update($dataq);
              $email = @$registeruserdetails->email;
              $emailsubject = 'Match Cancelled / Abandoned-Refund initiated!';
              $content = '<p><strong>Dear Challenger </strong></p>';
              $content .= '<p>Unfortunately the ' . date('M d Y h:i:a', strtotime($listmatches->start_date)) . ' ' . $listmatches->title . ' has been Abandoned / cancelled and your entry fee for the match is getting refunded back to your ' . BRAND['name'] . ' wallet.</p>';
              $msg = Helpers::mailheader();
              $msg .= Helpers::mailbody($content);
              $msg .= Helpers::mailfooter();
              $datan['title'] = 'Refund Amount of ₹' . $val2->entryfee . ' for contest cancellation';
              $datan['userid'] = $val3->user_id;
              DB::table('notifications')->insert($datan);
              //push notifications//
              $titleget = 'Refund Amount!';
              // Helpers::sendnotification($titleget,$datan['title'],'',$val3->user_id);
              //end push notifications//
            } catch (\Illuminate\Database\QueryException $ex) {
            }
          }
        }
      }
    }
    //echo 'ffff';exit;
    return 1;
  } //End Function

  //Distribute Winning Amount
  public function distribute_winning_amount($matchkey = null, $match_type = null, $sport_type)
  {
    // echo $matchkey; exit;
    // $firstupdate = MatchesController::player_point($matchkey,$match_type);
    $listmatches = DB::table('listmatches')->where('matchkey', $matchkey)->where('final_status', 'IsClosed')->orWhere('status', 'completed')->first();
    $listmatchesname = DB::table('listmatches')->where('matchkey', $matchkey)->first();


    if (!empty($listmatches)) {
      $countCh = DB::table('matchchallenges')
        // ->where('id','74714')
        ->where('matchkey', $matchkey)
        // ->where('challenge_category_id','=',40)

        ->where('status', '!=', 'canceled')->count();
      // echo '<pre>'; print_r($countCh);exit;
      for ($iiii = 0; $iiii <= ceil($countCh / 100); $iiii++) {
        $matchchallenges = DB::table('matchchallenges')->where('matchkey', $matchkey)
          // ->where('challenge_category_id','!=',40)
          // ->where('id','74714')
          ->where('status', '!=', 'canceled')->orderBY('id', 'ASC')->skip($iiii * 100)->take(100)->get();

        $finalresults = array();
        $winneruserid = array();
        if (!empty($matchchallenges)) {
          // dd($matchchallenges);
          foreach ($matchchallenges as $val2) {
            $ratio = 1;
            $flag = 0;
            // echo $val2->confirmed_challenge; exit;
            if ($val2->confirmed_challenge == 1) {
              $flag = 1;
              if ($val2->minimum_user > $val2->joinedusers && $val2->challenge_type == "percentage") {
                $flag = 0;
              }
            } else {
              // echo $val2->maximum_user .'>='. $val2->joinedusers; exit;
              if ($val2->maximum_user >= $val2->joinedusers) {
                $flag = 1;
              }
              if ($val2->minimum_user > $val2->joinedusers && $val2->challenge_type == "percentage") {
                $flag = 0;
              }
            }
            $challengeid = $val2->id;
            // echo   $challengeid=$val2->id;
            // exit;
            $user_points = array();
            // echo $flag; exit;
            if ($flag == 1) {
              // MatchesController::refer_bonus($val2->id, $val2->entryfee);
              $joinedleauges = DB::table('joinedleauges')->where('joinedleauges.matchkey', $matchkey)->where('joinedleauges.challengeid', $val2->id)->select('joinedleauges.userid', 'joinedleauges.teamid', 'points', 'joinedleauges.id as jid')->join('jointeam', 'jointeam.id', '=', 'joinedleauges.teamid')->get();
              // dd($joinedleauges);
              $usersSamePoint = array();
              if (!empty($joinedleauges)) {
                $total_joined_league = count($joinedleauges);

                if ($val2->maximum_user > $total_joined_league) {
                  if (0) {
                    $ratio =  (($total_joined_league * $val2->entryfee) * 0.90) / ($val2->maximum_user * $val2->entryfee);
                    // echo $ratio; exit;
                  } else {
                    $ratio =  1;
                  }
                } else {
                  $ratio = 1;
                }
                // echo "Punit"; exit;
                $lp = 0;
                foreach ($joinedleauges as $jntm) {
                  $user_points[$lp]['id'] = $jntm->userid;
                  $user_points[$lp]['points'] = $jntm->points;
                  $user_points[$lp]['joinedid'] = $jntm->jid;
                  $usersSamePoint[$lp] = $jntm->points;
                  $lp++;
                }
              }
              //               if(count(array_unique($usersSamePoint)) == 1 && count($usersSamePoint) > 1 && $val2->entryfee > 0 && $val2->maximum_user < 4){
              //   $this->refund_allamount_of_contest($matchkey,$val2->id,$sport_type);
              //   continue;
              // }
              if (!empty($user_points)) {
                $prc_arr = array();
                if ($val2->challenge_type == 'percentage') {
                  $gtjnusers = $val2->joinedusers;
                  $userstowin = $val2->winning_percentage;
                  $this->sortBySubArrayValue($user_points, 'points', 'desc');
                  $toWin = floor($gtjnusers * $userstowin / 100);
                  for ($i = 0; $i < $toWin; $i++) {
                    $prc_arr[$i + 1] = $val2->win_amount;
                  }
                  $ratio = 1;
                } else {
                  // echo 2; exit;
                  //echo $val2->id;
                  $matchpricecards = DB::table('matchpricecards')->where('matchkey', $matchkey)->where('challenge_id', $val2->id)->get();
                  // dd($matchpricecards); exit;
                  if (!$matchpricecards->isEmpty()) {
                    foreach ($matchpricecards as $prccrd) {
                      $min_position = $prccrd->min_position;
                      $max_position = $prccrd->max_position;
                      for ($i = $min_position; $i < $max_position; $i++) {
                        $prc_arr[$i + 1] = $prccrd->price;
                      }
                    }
                  } else {
                    $prc_arr[1] = $val2->win_amount;
                  }
                }
                $count = count($prc_arr);
                $poin_user = array();
                foreach ($user_points as $usr) {
                  $ids_str = "";
                  $ids_arr = array();
                  if (array_key_exists("'" . $usr['points'] . "'", $poin_user)) {
                    if (isset($poin_user["'" . $usr['points'] . "'"]['joinedid'])) {
                      $ids_str = implode(',', $poin_user["'" . $usr['points'] . "'"]['joinedid']);
                    }
                    $ids_str = $ids_str . ',' . $usr['joinedid'];
                    $ids_arr = explode(',', $ids_str);
                    $poin_user["'" . $usr['points'] . "'"]['joinedid'] = $ids_arr;
                    $poin_user["'" . $usr['points'] . "'"]['points'] = $usr['points'];
                    $poin_user["'" . $usr['points'] . "'"]['id'] = $usr['id'];
                  } else {
                    $poin_user["'" . $usr['points'] . "'"]['id'] = $usr['id'];
                    $poin_user["'" . $usr['points'] . "'"]['points'] = $usr['points'];
                    $poin_user["'" . $usr['points'] . "'"]['joinedid'][0] = $usr['joinedid'];
                  }
                }
                $this->sortBySubArrayValue($poin_user, 'points', 'desc');
                $win_usr = array();
                $win_cnt = 0;
                foreach ($poin_user as $kk => $pu) {
                  if ($win_cnt < $count) {
                    $win_usr[$kk]['min'] = $win_cnt + 1;
                    $win_cnt = $win_cnt + count($pu['joinedid']);
                    $win_usr[$kk]['max'] = $win_cnt;
                    $win_usr[$kk]['count'] = count($pu['joinedid']);
                    $win_usr[$kk]['joinedid'] = $pu['joinedid'];
                  } else {
                    break;
                  }
                }
                //echo '<pre>';
                // print_r($prc_arr);
                // print_r($win_usr);


                $final_poin_user = array();
                foreach ($win_usr as $ks => $ps) {
                  if ($ps['count'] == 1) {
                    $final_poin_user[$ps['joinedid'][0]]['points'] = $ks;
                    $final_poin_user[$ps['joinedid'][0]]['amount'] = $prc_arr[$ps['min']] * $ratio; //multiply ratio here
                    $final_poin_user[$ps['joinedid'][0]]['rank'] = $ps['min'];
                  } else {
                    $ttl = 0;
                    $avg_ttl = 0;
                    for ($jj = $ps['min']; $jj <= $ps['max']; $jj++) {
                      $sm = 0;
                      if (isset($prc_arr[$jj])) {
                        $sm = $prc_arr[$jj];
                      }
                      $ttl = $ttl + $sm;
                    }
                    $avg_ttl = $ttl / $ps['count'];
                    foreach ($ps['joinedid'] as $fnl) {
                      $final_poin_user[$fnl]['points'] = $ks;
                      $final_poin_user[$fnl]['amount'] = $avg_ttl * $ratio; //multiply ratio here
                      $final_poin_user[$fnl]['rank'] = $ps['min'];
                    }
                  }
                }

                foreach ($final_poin_user as $fpuskjoinid => $fpusv) {
                  $finduserid = DB::table('joinedleauges')->where('id', $fpuskjoinid)->select('userid')->first();
                  $fpusk = $finduserid->userid;
                  $transactionidsave = 'WIN-' . rand(1000, 99999) . $challengeid;
                  $fres['userid'] = $fpusk;
                  $fres['points'] = str_replace("'", "", $fpusv['points']);
                  $fres['amount'] = round($fpusv['amount'], 2);
                  $fres['rank'] = $fpusv['rank'];
                  $fres['matchkey'] = $matchkey;
                  $fres['challengeid'] = $challengeid;
                  $fres['transaction_id'] = $transactionidsave;
                  $fres['joinedid'] = $fpuskjoinid;
                  array_push($winneruserid, $fpusk);
                  $finalresults[] = $fres;
                  //$findalreexist = DB::table('finalresults')->where('matchkey',$matchkey)->where('joinedid',$fpuskjoinid)->first();
                  try {/*
                                    DB::table('finalresults')->insert($fres);
                                    $fpusv['amount'] = round($fpusv['amount'],2);
                                    if($fpusv['amount']>=10000){
                                        $tdsdata['tds_amount'] = (30/100)*$fpusv['amount'];
                                        $tdsdata['amount'] = $fpusv['amount'];
                                        $remainingamount = $fpusv['amount']-$tdsdata['tds_amount'];
                                        $tdsdata['userid'] = $fpusk;
                                        $tdsdata['challengeid'] = $val2->id;
                                        DB::table('tdsdetails')->insert($tdsdata);
                                        $fpusv['amount'] = $remainingamount;
                                        //user balance//
                                        $registeruserdetails = DB::table('registerusers')->where('id',$fpusk)->first();
                                        $findlastow = DB::table('userbalances')->where('user_id',$fpusk)->first();
                                        $dataqs['winning'] =  $findlastow->winning+$fpusv['amount'];
                                        DB::table('userbalances')->where('id',$findlastow->id)->update($dataqs);
                                        //transactions entry//
                                        $datatr['transaction_id'] = $transactionidsave;
                                        $datatr['type'] = 'Challenge Winning Amount';
                                        $datatr['transaction_by'] = 'VISION11';
                                        $datatr['amount'] = $fpusv['amount'];
                                        $datatr['paymentstatus'] = 'confirmed';
                                        $datatr['challengeid'] = $val2->id;
                                        $datatr['win_amt'] = $fpusv['amount'];
                                        $datatr['bal_bonus_amt'] = $findlastow->bonus;
                                        $datatr['bal_win_amt'] = $dataqs['winning'];
                                        $datatr['bal_fund_amt'] = $findlastow->balance;
                                        $datatr['userid'] = $fpusk;
                                        $datatr['total_available_amt'] = $findlastow->balance+$dataqs['winning']+$findlastow->bonus;
                                        DB::table('transactions')->insert($datatr);
                                        //notifications entry//
                                        $datanot['message'] = 'You won amount ₹'.$fpusv['amount'].' and 30% amount of '.$tdsdata['amount'].' deducted due to TDS.';
                                        $datanot['title'] = 'Congrats! You won a match.';
                                        $datanot['userid'] = $fpusk;
                                        $datanot['is_sent'] = 0;
                                        DB::table('notifications')->insert($datanot);
                                        //push notifications//

                                        //Helpers::sendnotification($titleget,$notificationdata['title'],'',$fpusk);
                                        //end push notifications//
                                        //mail//
                                        $challengename = "";
                                        if($val2->name==""){
                                            $challengename = 'Win-'.$val2->win_amount;
                                        }else{
                                            $challengename = $val2->name;
                                        }
                                        $email = $registeruserdetails->email;
                                        $emailsubject = 'Congrats you won a challenge!';
                                        $content='<p><strong>Dear Challenger </strong></p>';
                                        $content.='<p>Congratulations. You have won a challenge of '.$challengename.' for match '.$listmatches->title.'  with points '.$fres['points'].'. An amount of ₹ '.$fpusv['amount'].' is transfered to your wallet and 30% amount is deducted due to Tax deduction as per government regulations. Enjoy!</p>';
                                        $content.='<p> For details , please check account balance.</p>';
                                        $msg = Helpers::mailheader();
                                        $msg.= Helpers::mailbody($content);
                                        $msg.= Helpers::mailfooter();
                                    // Helpers::mailsentFormat($email,$emailsubject,$msg);
                                }else{
                                //user balance//
                                $registeruserdetails = DB::table('registerusers')->where('id',$fpusk)->first();
                                $findlastow = DB::table('userbalances')->where('user_id',$fpusk)->first();
                                $dataqs['winning'] =  $findlastow->winning+$fpusv['amount'];
                                DB::table('userbalances')->where('id',$findlastow->id)->update($dataqs);
                                if($fpusv['amount']>0){
                                    //transactions entry//
                                    $datatr['transaction_id'] = $transactionidsave;
                                    $datatr['type'] = 'Challenge Winning Amount';
                                    $datatr['transaction_by'] = 'VISION11';
                                    $datatr['amount'] = $fpusv['amount'];
                                    $datatr['paymentstatus'] = 'confirmed';
                                    $datatr['challengeid'] = $val2->id;
                                    $datatr['win_amt'] = $fpusv['amount'];
                                    $datatr['bal_bonus_amt'] = $findlastow->bonus;
                                    $datatr['bal_win_amt'] = $dataqs['winning'];
                                    $datatr['bal_fund_amt'] = $findlastow->balance;
                                    $datatr['userid'] = $fpusk;
                                    $datatr['total_available_amt'] = $findlastow->balance+$dataqs['winning']+$findlastow->bonus;
                                    DB::table('transactions')->insert($datatr);
                                    //notifications entry//
                                    $datanot['message'] = 'You won amount ₹'.$fpusv['amount'];
                                    $datanot['title'] = 'Congrats! You Won a match!';
                                    $datanot['userid'] = $fpusk;
                                    $datanot['is_sent'] = 0;
                                    DB::table('notifications')->insert($datanot);
                                    //push notifications//

                                    //Helpers::sendnotification($titleget,$datanot['title'],'',$fpusk);
                                    //end push notifications//
                                    //mail//
                                    $challengename = "";
                                    if($val2->name==""){
                                        $challengename = 'Win-'.$val2->win_amount;
                                    }else{
                                        $challengename = $val2->name;
                                    }
                                    $email = $registeruserdetails->email;
                                    $emailsubject = 'Congrats you won a challenge!';
                                    $content='<p><strong>Dear Challenger </strong></p>';
                                    $content.='<p>Congratulations. You have won a challenge of '.$challengename.' for match '.$listmatches->title.'  with points '.$fres['points'].'. An amount of ₹ '.$fpusv['amount'].' is transfered to your wallet. Enjoy!</p>';
                                    $content.='<p> <strong> Note:- </strong> Winning amount will be credited in your wallet after tax deductions as per government regulations.</p>';
                                    $msg = Helpers::mailheader();
                                    $msg.= Helpers::mailbody($content);
                                    $msg.= Helpers::mailfooter();
                                    // Helpers::mailsentFormat($email,$emailsubject,$msg);
                                 }
                                }
                            */
                  } catch (\Illuminate\Database\QueryException $ex) {
                  }
                }
              }
            }
          }
          //dd($finalresults); exit;
          if (!empty($finalresults)) {
            // $table = \DB::getTablePrefix().with(new self)->getTable(); print_r($table); exit;
            //DB::table('finalresults')->insertOrUpdate($finalresults);
            // echo "<pre>"; print_r($finalresults); exit;
            foreach (array_chunk($finalresults, 1000) as $value)
              $this->insertOrUpdate($finalresults, 'finalresults');

            if (!empty($winneruserid)) {
              $title = 'Winner declared';
              $message = 'You won this match ' . $listmatchesname->title;
              // Helpers::sendnotificationWinning($title,$message,$winneruserid);
            }
          }
        }
      }

      MatchesController::refer_bonus_new($matchkey, $sport_type);
      // MatchesController::refer_bonus($matchkey);
      MatchesController::refer_bonus_users($matchkey);
    }
    // echo 1; exit;
  } //End Function

  public function refer_bonus_users($matchkey)
  {

    $joinedleauges = DB::table('leaugestransactions')

      ->join('registerusers as r1', 'leaugestransactions.user_id', '=', 'r1.id')

      ->join('registerusers as r2', 'r1.refer_id', '=', 'r2.id')

      ->join('matchchallenges as mc', 'mc.id', '=', 'leaugestransactions.challengeid')

      ->where('leaugestransactions.matchkey', $matchkey)

      ->where('r1.refer_id', '!=', 0)

      ->where('r2.refer_to_join', 0)
      // ->where('r1.id','>',192900)

      ->where('mc.status', '!=', 'canceled')

      //->where('leaugestransactions.winning+leaugestransactions.balance','>',0)

      ->where(DB::raw('(leaugestransactions.winning+leaugestransactions.balance)'), '>', 0)

      ->groupBy('leaugestransactions.id')

      ->select('leaugestransactions.*', 'r1.id as user_id', 'r2.id as refer_id', 'r2.player_percentage as refer_percent', 'mc.entryfee', 'mc.joinedusers', 'mc.win_amount')->get();

    $refer_data = array();

    $i = 0;

    foreach ($joinedleauges as $key => $value) {

      $bonusamount = 0;
      if ($value->bonus != 0) {
        $bonusamount = $value->bonus;
      }
      if ($value->coins != 0) {
        $bonusamount = $value->coins;
      }

      $profit = ($value->entryfee * $value->joinedusers) - ($value->win_amount);

      // $per_user_profit = ($profit / $value->joinedusers)-$value->bonus;
      $per_user_profit = ($profit / $value->joinedusers) - $bonusamount;

      if ($per_user_profit < 0) {

        $per_user_profit = 0;
      }



      $refer_data[$i]['user_id'] = $value->user_id;

      $refer_data[$i]['refer_id'] = $value->refer_id;

      $refer_data[$i]['amount'] = ($per_user_profit) ? ($per_user_profit) * 10 / 100 : 0;

      $refer_data[$i]['challenge_id'] = $value->challengeid;

      $refer_data[$i]['join_id'] = $value->joinid;
      $refer_data[$i]['matchkey'] = $matchkey;
      $refer_data[$i]['type'] = 2;


      $i++;
    }

    if (!empty($refer_data)) {

      $this->insertOrUpdate($refer_data, 'league_refer_bonus');
    }

    return 1;
  }

  //Refer Bonus
  public function refer_bonus($matchkey)
  {
    return 1;
    $joinedleauges = DB::table('leaugestransactions')

      ->join('registerusers as r1', 'leaugestransactions.user_id', '=', 'r1.id')

      ->join('registerusers as r2', 'r1.refer_id', '=', 'r2.id')

      ->join('matchchallenges as mc', 'mc.id', '=', 'leaugestransactions.challengeid')

      ->where('leaugestransactions.matchkey', $matchkey)

      ->where('r1.refer_id', '!=', 0)

      ->where('r2.refer_to_join', 2)

      ->where('mc.status', '!=', 'canceled')

      //->where('leaugestransactions.winning+leaugestransactions.balance','>',0)

      ->where(DB::raw('(leaugestransactions.winning+leaugestransactions.balance)'), '>', 0)

      ->groupBy('leaugestransactions.id')

      ->select('leaugestransactions.*', 'r1.id as user_id', 'r2.id as refer_id', 'r2.player_percentage as refer_percent')->get();


    $refer_data = array();

    $i = 0;

    foreach ($joinedleauges as $key => $value) {

      $refer_data[$i]['user_id'] = $value->user_id;

      $refer_data[$i]['refer_id'] = $value->refer_id;

      $refer_data[$i]['amount'] = round(($value->winning + $value->balance) ? ($value->winning + $value->balance) * $value->refer_percent / 100 : 0, 2);

      $refer_data[$i]['challenge_id'] = $value->challengeid;

      $refer_data[$i]['join_id'] = $value->joinid;

      $i++;
    }

    if (!empty($refer_data)) {

      $this->insertOrUpdate($refer_data, 'league_refer_bonus');
    }

    return 1;
  }



  public function refer_bonus_new($matchkey = '2065', $sport_type)
  {

    $joinedleauges = DB::table('leaugestransactions')

      ->join('registerusers as r1', 'leaugestransactions.user_id', '=', 'r1.id')

      ->join('registerusers as r2', 'r1.refer_id', '=', 'r2.id')

      ->join('matchchallenges as mc', 'mc.id', '=', 'leaugestransactions.challengeid')

      ->where('leaugestransactions.matchkey', $matchkey)

      ->where('r1.refer_id', '!=', 0)

      ->where('r2.refer_to_join', 1)

      ->where('mc.status', '!=', 'canceled')

      //->where('leaugestransactions.winning+leaugestransactions.balance','>',0)

      ->where(DB::raw('(leaugestransactions.winning+leaugestransactions.balance)'), '>', 0)

      ->groupBy('leaugestransactions.id')

      ->select('leaugestransactions.*', 'r1.id as user_id', 'r2.id as refer_id', 'r2.player_percentage as refer_percent', 'mc.entryfee', 'mc.joinedusers', 'mc.win_amount', 'mc.bonus as is_bonus', 'mc.gst_bonus as is_gst_bonus', 'mc.id as cid')->get();


    $refer_data = array();

    $i = 0;

    foreach ($joinedleauges as $key => $value) {

      $bonus = 0;
      if ($value->is_bonus == 1) {
        $bonus = $value->bonus;
        // $bonus= DB::table('leaugestransactions')->where('challengeid', $value->cid)->sum('bonus');
      }
      if ($value->is_gst_bonus == 1) {
        $bonus = $value->gst_bonus;
        // $bonus= DB::table('leaugestransactions')->where('challengeid', $value->cid)->sum('gst_bonus');
      }


      $profit = ($value->entryfee * $value->joinedusers) - ($value->win_amount);

      $per_user_profit = ($profit / $value->joinedusers) - $bonus;

      // new Affiliation code
      // if(empty($bonus)){
      //       $bonus=0;
      //   }

      // $totalcollection= ($value->entryfee * $value->joinedusers)-$bonus;
      //
      // $deductfourpercent= ($totalcollection*7)/100;
      // $per_user_profit=$deductfourpercent/$value->joinedusers;
      //End new Affiliation code

      if ($per_user_profit < 0) {

        $per_user_profit = 0;
      }



      $refer_data[$i]['user_id'] = $value->user_id;

      $refer_data[$i]['refer_id'] = $value->refer_id;

      $refer_data[$i]['amount'] = ($per_user_profit) ? ($per_user_profit) * $value->refer_percent / 100 : 0;

      $refer_data[$i]['challenge_id'] = $value->challengeid;
      $refer_data[$i]['matchkey'] = $matchkey;

      $refer_data[$i]['join_id'] = $value->joinid;
      $refer_data[$i]['type'] = 1;

      $i++;
    }

    if (!empty($refer_data)) {

      $this->insertOrUpdate($refer_data, 'league_refer_bonus');
    }
    return 1;
  }

  //insertOrUpdate
  public function insertOrUpdate(array $rows, $table)
  {
    // $table = \DB::getTablePrefix().with(new self)->getTable();
    // $table = 'finalresults';
    $first = reset($rows);
    $columns = implode(
      ',',
      array_map(function ($value) {
        return "`$value`";
      }, array_keys($first))
    );
    $values = implode(
      ',',
      array_map(function ($row) {
        return '(' . implode(
          ',',
          array_map(function ($value) {
            return '"' . str_replace('"', '""', $value) . '"';
          }, $row)
        ) . ')';
      }, $rows)
    );
    $updates = implode(
      ',',
      array_map(function ($value) {
        return "`$value` = VALUES(`$value`)";
      }, array_keys($first))
    );
    $sql = "INSERT INTO `{$table}` ({$columns}) VALUES {$values} ON DUPLICATE KEY UPDATE {$updates}";
    return \DB::statement($sql);
  }
  //View Winners
  public function viewwinners($matchkey, Request $request)
  {

    if ($request->isMethod('post')) {
      $formData = Input::all();
      if (isset($formData) && !empty($formData)) {

        return Datatables::of($query = DB::table('joinedleauges')->where('joinedleauges.matchkey', $matchkey)
          ->join('jointeam', 'jointeam.id', '=', 'joinedleauges.teamid')
          ->join('matchchallenges', 'matchchallenges.id', '=', 'joinedleauges.challengeid')
          ->join('registerusers', 'registerusers.id', '=', 'joinedleauges.userid')
          ->where(function ($query) use ($formData) {
            if (isset($formData['filter_columns'])) {
              if (isset($formData['filter_columns']['filter_teamname'])) {
                $query->where('registerusers.team', 'like', '%' . $formData['filter_columns']['filter_teamname'] . '%');
              }
              if (isset($formData['filter_columns']['filter_email'])) {
                $query->where('registerusers.email', 'like', '%' . $formData['filter_columns']['filter_email'] . '%');
              }
              if (isset($formData['filter_columns']['filter_mobile'])) {
                $query->where('registerusers.mobile', 'like', '%' . $formData['filter_columns']['filter_mobile'] . '%');
              }
              if (isset($formData['filter_columns']['filter_username'])) {
                $query->where('registerusers.username', 'like', '%' . $formData['filter_columns']['filter_username'] . '%');
              }
            }
          })
          ->orderBy('joinedleauges.challengeid', 'ASC')
          ->select('matchchallenges.win_amount', 'matchchallenges.entryfee', 'matchchallenges.joinedusers', 'matchchallenges.name', 'matchchallenges.is_private', 'matchchallenges.confirmed_challenge', 'matchchallenges.maximum_user', 'matchchallenges.grand', 'joinedleauges.*', 'registerusers.username as username', 'registerusers.email', 'registerusers.team', 'registerusers.mobile', 'jointeam.points')
          ->get())

          ->addIndexColumn()

          ->addColumn('username', function ($result) {
            return $result->username;
          })

          ->addColumn('email', function ($result) {
            return $result->email;
          })

          ->addColumn('team', function ($result) {
            return $result->team;
          })

          ->addColumn('mobile', function ($result) {
            return $result->mobile;
          })
          ->addColumn('challengeid', function ($result) {
            return $result->challengeid;
          })

          ->addColumn('isjoin', function ($result) {
            return '1';
          })

          ->addColumn('isrefund', function ($result) {
            $findifrefunds = DB::table('refunds')->where('userid', $result->userid)->where('challengeid', $result->challengeid)->first();
            if (!empty($findifrefunds)) {
              return 1;
            } else {
              return;
            }
          })

          ->addColumn('iswin', function ($result) {

            $findfinalresults = DB::table('finalresults')->where('userid', $result->userid)->where('challengeid', $result->challengeid)->where('joinedid', $result->id)->first();

            if (!empty($findfinalresults)) {
              return 1;
            } else {
              return;
            }
          })

          ->addColumn('userid', function ($result) {
            return $result->userid;
          })

          ->addColumn('refunddate', function ($result) {
            $findifrefunds = DB::table('refunds')->where('userid', $result->userid)->where('challengeid', $result->challengeid)->first();
            if (!empty($findifrefunds)) {
              return $findifrefunds->created;
            } else {
              return;
            }
          })

          ->addColumn('windate', function ($result) {
            $findfinalresults = DB::table('finalresults')->where('userid', $result->userid)->where('challengeid', $result->challengeid)->where('joinedid', $result->id)->first();
            if (!empty($findfinalresults)) {
              return $findfinalresults->created;
            } else {
              return;
            }
          })

          ->addColumn('rank', function ($result) {
            $findfinalresults = DB::table('finalresults')->where('userid', $result->userid)->where('challengeid', $result->challengeid)->where('joinedid', $result->id)->first();
            if (!empty($findfinalresults)) {
              return $findfinalresults->rank;
            } else {
              return;
            }
          })
          ->addColumn('refundamount', function ($result) {
            $findifrefunds = DB::table('refunds')->where('userid', $result->userid)->where('challengeid', $result->challengeid)->first();
            if (!empty($findifrefunds)) {
              return $findifrefunds->amount;
            } else {
              return;
            }
          })
          ->addColumn('winamount', function ($result) {
            $findfinalresults = DB::table('finalresults')->where('userid', $result->userid)->where('challengeid', $result->challengeid)->where('joinedid', $result->id)->first();
            if (!empty($findfinalresults)) {
              return $findfinalresults->amount;
            } else {
              return;
            }
          })

          ->addColumn('points', function ($result) {
            return $result->points;
          })

          ->addColumn('challengename', function ($result) {
            $cname = "";
            if ($result->name == "") {
              if ($result->win_amount == 0) {
                $cname  = 'Net practice';
              } else {
                $cname  = 'Win ₹' . $result->win_amount;
              }
            } else {
              $cname = ucwords($result->name);
            }
            return $cname;
          })

          ->addColumn('entryfee', function ($result) {
            return $result->entryfee;
          })

          ->addColumn('confirmedleauge', function ($result) {

            if ($result->confirmed_challenge == 1) {
              return 'YES';
            } else {
              return 'NO';
            }
          })
          ->addColumn('is_private', function ($result) {

            if ($result->is_private == 1) {
              return 'YES';
            } else {
              return 'NO';
            }
          })

          ->addColumn('maximum_number_of_winners', function ($result) {
            $findpricecards = DB::table('matchpricecards')->where('challenge_id', $result->challengeid)->get();
            $winners = 0;
            if (!empty($findpricecards)) {
              foreach ($findpricecards as $prc) {
                $winners += $prc->winners;
              }
            } else {
              $winners = 1;
            }
            return $winners;
          })
          ->addColumn('joinedusers', function ($result) {
            return $result->joinedusers;
          })

          ->addColumn('isgrand', function ($result) {
            if ($result->grand == 1) {
              return 'YES';
            } else {
              return 'NO';
            }
          })

          ->escapeColumns([])
          ->make(true);
      }
    }

    return view("admin.$this->model.viewwinners", compact('matchkey'));
  } //End Function

  //View Winners
  // public function viewwinners($matchkey){
  //     $findwinners = array();
  //     $finduserjoinedleauges = DB::table('joinedleauges')->where('joinedleauges.matchkey',$matchkey)->join('jointeam','jointeam.id','=','joinedleauges.teamid')->join('matchchallenges','matchchallenges.id','=','joinedleauges.challengeid')->join('registerusers','registerusers.id','=','joinedleauges.userid')->orderBy('joinedleauges.challengeid','ASC')->select('matchchallenges.win_amount','matchchallenges.entryfee','matchchallenges.joinedusers','matchchallenges.name','matchchallenges.is_private','matchchallenges.confirmed_challenge','matchchallenges.maximum_user','matchchallenges.grand','joinedleauges.*','registerusers.username as username','registerusers.email','registerusers.team','jointeam.points')->limit(10)->get();
  //
  //     return view("admin.$this->model.viewwinners",compact('finduserjoinedleauges','matchkey'));
  // }//End Function

  //Join User
  public function join_users($matchkey = null, $sports_type = 1)
  {
    //Get Ajax Data

    $formData = Input::all();
    if (isset($formData) && !empty($formData)) {
      return Datatables::of(DB::table('matchchallenges as mc')
        ->leftjoin('joinedleauges as jl', 'jl.challengeid', '=', 'mc.id')
        ->where('mc.matchkey', $matchkey)
        ->where('jl.sport_type', $sports_type)
        ->where('mc.status', '!=', 'canceled')
        ->select('mc.id as matchchallenges_id', 'mc.challenge_type as challenge_type', 'mc.entryfee as matchchallenges_entryfee', 'mc.win_amount as matchchallenges_win_amount', 'is_manual_bot', 'mc.maximum_user as matchchallenges_maximum_user', 'mc.grand as matchchallenges_grand', 'mc.is_flexible as matchchallenges_is_flexible', 'mc.matchkey as matchchallenges_matchkey', DB::raw('count(jl.userid) as total'))
        ->groupBY('mc.id')
        ->get())
        ->addIndexColumn()
        ->addColumn('matchchallenges_is_flexible', function ($result) {
          if ($result->matchchallenges_is_flexible == 1) {
            return '<label style="color:green;">YES</label>';
          } else {
            return '<label style="color:red;">NO</label>';
          }
        })
        ->addColumn('action', function ($result) {
          // return '<a href="'.route($this->model.'.cancel_contest',base64_encode(serialize($result->matchchallenges_id))).'" class="btn btn-danger">Cancel</a>';
          if ($result->is_manual_bot == 1) {
            return '<a href="' . route($this->model . '.cancel_contest', base64_encode(serialize($result->matchchallenges_id))) . '" class="btn btn-danger">Cancel</a>
                    <a href="' . route($this->model . '.join_bot_details', base64_encode(serialize($result->matchchallenges_id))) . '" class="btn btn-success" > Manually Bot Details</a>
                    ';
          } else {
            $flexi = '';
            if ($result->matchchallenges_is_flexible == '1') {
              $flexi = '<a href="' . route($this->model . '.set_flexy_league_manual', [$result->matchchallenges_matchkey, $result->matchchallenges_id, 'manual']) . '" class="btn btn-info">Set Flexible</a>';

              $flexi .= '<a href="' . url('admin/challenges/add-match-pricecard/' . base64_encode(serialize($result->matchchallenges_id))) . '" class="btn btn-info mt-1">Add Price Card</a>';
            }
            return $flexi . '<a href="' . route($this->model . '.cancel_contest', base64_encode(serialize($result->matchchallenges_id))) . '" class="btn btn-danger mt-1">Cancel</a>
            <a href="' . route($this->model . '.join_users_details', base64_encode(serialize($result->matchchallenges_id))) . '" class="btn btn-success mr-1 mt-1">View Details</a>
                    <a href="' . route($this->model . '.join_bot_details', base64_encode(serialize($result->matchchallenges_id))) . '" class="btn btn-success mr-1 mt-1">View Bots</a>';
          }
        })
        ->escapeColumns([])
        ->make(true);
    } //end

    return view("admin.$this->model.join_users", compact('matchkey', 'sports_type'));
  }
  //End Function

  public function downloadjoinuserdetail($challenge_id)
  {
    $challenge_id = unserialize(base64_decode($challenge_id));
    $checkdata = DB::table('joinedleauges as jl')
      ->leftjoin('registerusers as rg', 'jl.userid', '=', 'rg.id')
      ->leftjoin('pancard', 'pancard.userid', '=', 'rg.id')
      ->leftjoin('finalresults', 'finalresults.joinedid', '=', 'jl.id')
      // ->where('rg.is_bot' , 1)
      ->where('jl.challengeid', $challenge_id)->select('username', 'teamid', 'mobile', 'email', 'pancard.pan_number', 'finalresults.amount as winning')->get();
    $output1    = "";
    $output1 .= '"User Email",';
    $output1 .= '"User Mobile",';
    $output1 .= '"User Pan Number",';
    $output1 .= '"Winning Amount",';
    $output1 .= "\n";
    if (!empty($checkdata)) {
      foreach ($checkdata as $get) {

        $output1 .= '"' . $get->email . '",';
        $output1 .= '"' . @$get->mobile . '",';
        $output1 .= '"' . @$get->pan_number . '",';
        $output1 .= '"' . @$get->winning . '",';
        $output1 .= "\n";
      }
    }
    //  echo '<pre>'; print_r($output1);exit;
    $filename =  "Details-joinusercontest-detail.csv";
    header('Content-type: application/csv');
    header('Content-Disposition: attachment; filename=' . $filename);
    echo $output1;
    exit;
  }


  public function downloadjoinusercontest($matchkey, $sports_type)
  {
    $checkdata = DB::table('matchchallenges as mc')
      ->leftjoin('joinedleauges as jl', 'jl.challengeid', '=', 'mc.id')
      ->leftjoin('registerusers as rg', 'rg.id', '=', 'jl.userid')
      ->leftjoin('pancard', 'pancard.userid', '=', 'rg.id')
      ->leftjoin('finalresults', 'finalresults.joinedid', '=', 'jl.id')
      ->where('mc.matchkey', $matchkey)
      ->where('jl.sport_type', $sports_type)
      ->where('mc.status', '!=', 'canceled')
      //   ->where('mc.challenge_category_id','!=',6)
      ->select('mc.id as matchchallenges_id', 'mc.challenge_type as challenge_type', 'mc.entryfee as matchchallenges_entryfee', 'mc.win_amount as matchchallenges_win_amount', 'is_manual_bot', 'mc.maximum_user as matchchallenges_maximum_user', 'mc.grand as matchchallenges_grand', 'mc.is_flexible as matchchallenges_is_flexible', 'mc.matchkey as matchchallenges_matchkey', 'rg.id as user_id', 'rg.email', 'rg.mobile', 'pancard.pan_number', 'finalresults.amount as winning')
      // ->groupBY('mc.id')
      // ->limit(5000)
      ->get();
    // echo '<pre>'; print_r($checkdata);exit;
    $output1    = "";
    $output1 .= '"User Email",';
    $output1 .= '"User Mobile",';
    $output1 .= '"User Pan Number",';
    $output1 .= '"Winning Amount",';
    $output1 .= "\n";
    if (!empty($checkdata)) {
      foreach ($checkdata as $get) {
        // $winning= DB::table('finalresults')->where('userid',$get->user_id)
        // ->where('challengeid',$get->matchchallenges_id)
        // ->where('matchkey',$matchkey)
        // ->select('amount')->first();

        $output1 .= '"' . $get->email . '",';
        $output1 .= '"' . @$get->mobile . '",';
        $output1 .= '"' . @$get->pan_number . '",';
        $output1 .= '"' . @$get->winning . '",';
        $output1 .= "\n";
      }
    }
    //  echo '<pre>'; print_r($output1);exit;
    //echo "<pre>";print_r($output1);
    $filename =  "Details-joinusercontest.csv";
    header('Content-type: application/csv');
    header('Content-Disposition: attachment; filename=' . $filename);
    echo $output1;
    exit;
  }

  public function contestCancellist($matchkey = null, $sports_type = 1)
  {
    //Get Ajax Data
    $formData = Input::all();
    if (isset($formData) && !empty($formData)) {
      return Datatables::of(DB::table('matchchallenges as mc')
        ->leftjoin('joinedleauges as jl', 'jl.challengeid', '=', 'mc.id')
        ->where('mc.matchkey', $matchkey)
        ->where('jl.sport_type', $sports_type)
        ->where('mc.status', '=', 'canceled')
        ->select('mc.id as matchchallenges_id', 'mc.challenge_type as challenge_type', 'mc.entryfee as matchchallenges_entryfee', 'mc.win_amount as matchchallenges_win_amount', 'is_manual_bot', 'mc.maximum_user as matchchallenges_maximum_user', 'mc.grand as matchchallenges_grand', 'mc.is_flexible as matchchallenges_is_flexible', 'mc.matchkey as matchchallenges_matchkey', DB::raw('count(jl.userid) as total'))
        ->groupBY('mc.id')
        ->get())
        ->addIndexColumn()
        ->addColumn('matchchallenges_is_flexible', function ($result) {
          if ($result->matchchallenges_is_flexible == 1) {
            return '<label style="color:green;">YES</label>';
          } else {
            return '<label style="color:red;">NO</label>';
          }
        })
        ->addColumn('matchchallenges_canceled', function ($result) {
          $reason = '';
          $reason = DB::table('refunds')->where('matchkey', $result->matchchallenges_matchkey)->where('challengeid', $result->matchchallenges_id)->first()->reason;
          return !empty($reason) ? $reason : 'N/A';
        })
        ->addColumn('action', function ($result) {
          // return '<a href="'.route($this->model.'.cancel_contest',base64_encode(serialize($result->matchchallenges_id))).'" class="btn btn-danger">Cancel</a>';

          return '<a href="' . route($this->model . '.refund_list', [$result->matchchallenges_id, $result->matchchallenges_matchkey]) . '" class="btn btn-success">Refund list</a>';
        })
        ->escapeColumns([])
        ->make(true);
    } //end

    //End
    return view("admin.$this->model.contest_cancel", compact('matchkey', 'sports_type'));
  }


  public function join_users_details($challenge_id = null)
  {
    $challenge_id = unserialize(base64_decode($challenge_id));
    $formData = Input::all();
    if (isset($formData) && !empty($formData)) {
      return Datatables::of(DB::table('joinedleauges as jl')
        ->leftjoin('registerusers as rg', 'jl.userid', '=', 'rg.id')
        ->leftjoin('finalresults', 'finalresults.joinedid', '=', 'jl.id')
        // ->where('rg.is_bot' , 0)
        ->where('jl.challengeid', $challenge_id)->select('jl.userid', 'rg.username', 'teamid', 'rg.team as teamname', 'mobile', 'email', 'jl.challengeid', 'jl.matchkey', 'jl.sport_type', 'jl.created_at', 'jl.id', 'finalresults.rank', 'finalresults.amount', 'finalresults.points')
        ->orderBY('rank', 'desc')
        ->get())
        ->addIndexColumn()
        ->addColumn('teamname', function ($result) {
          return $result->teamname;
        })
        ->addColumn('username', function ($result) {
          return $result->username;
        })
        ->addColumn('mobile', function ($result) {
          return $result->mobile;
        })
        ->addColumn('email', function ($result) {
          return $result->email;
        })
        ->addColumn('point', function ($result) use ($challenge_id) {
          // $userpoint= DB::table('finalresults')->where('userid',@$result->userid)
          //   ->where('challengeid',@$challenge_id)
          //   ->where('joinedid',@$result->id)
          // ->select('points','rank','amount')->first();
          if (!empty($result->amount)) {
            return ' Rank: ' . @$result->rank . ' ,Points: ' . @$result->points . ' ,  Amount:  ' . @$result->amount;
          } else {
            return '--';
          }
        })
        ->addColumn('joined_time', function ($result) {

          return date('d M y h:i:s a', strtotime($result->created_at));
        })
        ->addColumn('action', function ($result) {
          $edit = "";
          return '<a href="" class="btn btn-success mr-1 mt-1" id="team_details" data-toggle="modal" data-target="#team_modal" data-id="' . $result->teamid . '"  data-matchkey="' . $result->matchkey . '">View Team</a>';
        })
        ->escapeColumns([])
        ->make(true);
    }

    return view("admin.$this->model.join_users_details", compact('challenge_id'));
  }

  /* Join Bot Details */
  public function join_bot_details($challenge_id = null)
  {
    $challenge_id = unserialize(base64_decode($challenge_id));
    $formData = Input::all();
    if (isset($formData) && !empty($formData)) {
      return Datatables::of(DB::table('joinedleauges as jl')
        ->leftjoin('registerusers as rg', 'jl.userid', '=', 'rg.id')
        ->where("is_bot", 1)
        ->where('jl.challengeid', $challenge_id)->select('userid', 'username', 'teamid', 'rg.team as teamname', 'mobile', 'email', 'challengeid', 'matchkey', 'sport_type')->get())
        ->addIndexColumn()
        ->addColumn('teamname', function ($result) {
          return $result->teamname;
        })
        ->addColumn('username', function ($result) {
          return $result->username;
        })
        ->addColumn('mobile', function ($result) {
          return $result->mobile;
        })
        ->addColumn('email', function ($result) {
          return $result->email;
        })
        ->addColumn('action', function ($result) {
          $edit = '<a href="' . route('Matches.join_bot_details.edit', ['id' => $result->teamid]) . '" class="btn btn-info mr-1 mt-1">Edit Team</a>';
          return '<a href="" class="btn btn-success mr-1 mt-1" id="team_details" data-toggle="modal" data-target="#team_modal" data-id="' . $result->teamid . '">View Team</a>' . $edit;
        })
        ->escapeColumns([])
        ->make(true);
    }

    return view("admin.$this->model.joinbotdetails", compact('challenge_id'));
  }


  public function join_bot_details_edit(Request $request, $id)
  {
    $modelName = $this->model;
    $team_arr = DB::table('jointeam')
      ->where('id', $id)
      ->select('matchkey', 'userid', 'players', 'captain', 'vicecaptain', 'created_at')
      ->first();
    $selplayers = explode(',', $team_arr->players);
    $matchid = DB::table("joinedleauges")->where("teamid", $id)->value("challengeid");
    $matchid = base64_encode(serialize($matchid));
    $allPlayers = DB::table("matchplayers")->where("matchkey", $team_arr->matchkey)->get();
    if ($request->isMethod("POST")) {
      try {
        $selected_players = $request->selected_players ? implode(',', $request->selected_players) : "";
        // Validate the request
        $validatedData = $request->validate([
            'selected_players'   => ['required', 'array', 'size:11'], // Must select exactly 11 players
            'selected_players.*' => ['distinct'], // No duplicate player IDs
            'captain'            => ['required', 'integer', 'in:' . $selected_players], // Captain must be in selected players
            'vicecaptain'        => ['required', 'integer', 'in:' . $selected_players, 'different:captain'], // Vice-captain must be in selected players and different from captain
        ], [
            'selected_players.required' => 'You must select exactly 11 players.',
            'selected_players.size' => 'You must select exactly 11 players.',
            'selected_players.*.distinct' => 'Duplicate players are not allowed.',
            'captain.required' => 'You must select a captain.',
            'captain.in' => 'Captain must be one of the selected players.',
            'vicecaptain.required' => 'You must select a vice-captain.',
            'vicecaptain.in' => 'Vice-captain must be one of the selected players.',
            'vicecaptain.different' => 'Captain and Vice-Captain must be different players.',
        ]);
        $players = implode(',',$request->selected_players);
        $update = [
          'players' => $players,
          'vicecaptain' => $request->vicecaptain,
          'captain' => $request->captain,
        ];

        DB::table('jointeam')->where("id", $id)->update($update);

        // Flash success message
        Session::flash('flash_notice', 'Team updated successfully!');

        return redirect()->back();
    } catch (\Illuminate\Validation\ValidationException $e) {
        // Flash validation error message
        Session::flash('flash_notice', $e->getMessage());

        return redirect()->back();
    }
    }
    return view("admin.$this->model.editbotdetails", compact('id', 'modelName', 'team_arr', 'selplayers', 'allPlayers', 'matchid'));
  }

  /*Join Bot Details */

  /* View Team Bot Details */
  public function view_team_model()
  {
    $players = array();
    $captain = '';
    $visecaptain = '';
    $formdata = Input::all();
    $team_arr = DB::table('jointeam')
      ->where('id', $formdata['teamid'])->select('matchkey', 'userid', 'players', 'captain', 'vicecaptain', 'created_at')->first();
    // echo "<pre>"; print_r($team_arr); exit;
    $players = explode(',', $team_arr->players);

    if (isset($formdata) && !empty($formdata) && !empty($team_arr)) {
      return Datatables::of(DB::table('matchplayers')->where('matchkey', $team_arr->matchkey)->whereIn('playerid', $players)->select('id', 'playerid', 'name as player_name', 'player_key', 'credit', 'role', 'points')
        ->get())
        ->addIndexColumn()
        ->addcolumn('player_name', function ($result) use ($team_arr) {
          if ($team_arr->captain == $result->playerid) {
            return ucwords($result->player_name) . ' / <strong style="color:green"> (Captain) </strong>';
          } else if ($team_arr->vicecaptain == $result->playerid) {
            return ucwords($result->player_name) . ' / <strong style="color:blue"> ( Vice Captain ) </strong>';
          } else {
            return ucwords($result->player_name);
          }
        })
        ->addcolumn('role', function ($result) {
          return $result->role;
        })
        ->addcolumn('credit', function ($result) {
          return $result->credit;
        })
        ->addcolumn('points', function ($result) use ($formdata) {
          // $points = 0;
          // $pointdb = DB::table('matchplayers')->where('matchkey',$formdata['matchkey'])->where('playerid'  , $result->id)->first();
          // if(!empty($pointdb)){
          //   $points  = $pointdb->points;
          // }
          return $result->points;
        })
        ->escapeColumns([])
        ->make(true);
    }
  }

  public function view_team_model_old()
  {
    $players = array();
    $captain = '';
    $visecaptain = '';
    $formdata = Input::all();
    $team_arr = DB::table('jointeam')
      ->where('id', $formdata['teamid'])->select('matchkey', 'userid', 'players', 'captain', 'vicecaptain', 'created_at')->first();

    $players = array();
    if (!empty($team_arr)) {
      $players = explode(',', $team_arr->players);
    }

    if (isset($formdata) && !empty($formdata) && !empty($team_arr)) {

      return Datatables::of(DB::table('players')->whereIn('id', $players)->select('id', 'player_name', 'player_key', 'credit', 'role')
        ->get())
        ->addIndexColumn()
        ->addcolumn('player_name', function ($result) use ($team_arr) {
          if ($team_arr->captain == $result->id) {
            return ucwords($result->player_name) . ' / <strong> (Captain) </strong>';
          } else if ($team_arr->vicecaptain == $result->id) {
            return ucwords($result->player_name) . ' / <strong> ( Vice Captain ) </strong>';
          } else {
            return ucwords($result->player_name);
          }
        })
        ->addcolumn('role', function ($result) {
          return $result->role;
        })
        ->addcolumn('credit', function ($result) {
          return $result->credit;
        })
        ->escapeColumns([])
        ->make(true);
    }
  }
  /* View Team Bot Details */

  public function cancelContestByids()
  {
    echo "test";
    exit;
  }

  //Cancel Contest
  public function cancel_contest($challenge_id = null)
  {

    $challenge_id = unserialize(base64_decode($challenge_id));
    $leaugestransactions = DB::table('leaugestransactions')->where('challengeid', $challenge_id)->get();

    $challenge_detail = DB::table('matchchallenges')->where('id', $challenge_id)->first();
    //dd($leaugestransactions);
    foreach ($leaugestransactions as $val3) {
      $entryfee = $challenge_detail->entryfee;
      $findlastow = DB::table('userbalances')->where('user_id', $val3->user_id)->first();
      if (!empty($findlastow)) {
        $dasts['status'] = 'canceled';
        DB::table('matchchallenges')->where('id', $challenge_id)->update($dasts);
        // entry in refund //
        $refunddata['userid'] = $val3->user_id;
        $refunddata['amount'] = $entryfee;
        $refunddata['joinid'] = $val3->joinid;
        $refunddata['challengeid'] = $val3->challengeid;
        $refunddata['reason'] = 'Contest cancel';
        $refunddata['matchkey'] = $challenge_detail->matchkey;
        $findifalreadyrefund = DB::table('refunds')->where('joinid', $val3->joinid)->first();
        if (empty($findifalreadyrefund)) {

          //Update User Balance
          $dataq['balance'] =  $findlastow->balance + $val3->balance;
          $dataq['winning'] =  $findlastow->winning + $val3->winning;
          $dataq['bonus'] =  $findlastow->bonus + $val3->bonus;
          $dataq['gst_bonus'] =  $findlastow->gst_bonus + $val3->gst_bonus;
          $dataq['affiliation_commission'] = $findlastow->affiliation_commission + $val3->affiliation_commission;
          DB::table('userbalances')->where('id', $findlastow->id)->update($dataq);

          DB::table('refunds')->insert($refunddata);
          // end entry in refund data//
          //transactions//
          $registeruserdetails = DB::table('registerusers')->where('id', $val3->user_id)->first();
          $datatr['transaction_id'] = BRAND['name'] . '-REFUND-' . rand(100, 999) . $val3->user_id;
          $datatr['type'] = 'Refund amount';
          $datatr['transaction_by'] = BRAND['name'];
          $datatr['amount'] = $entryfee;
          $datatr['paymentstatus'] = 'confirmed';
          $datatr['challengeid'] = $val3->challengeid;
          $datatr['bonus_amt'] = $val3->bonus;
          $datatr['gst_bonus_amt'] = $val3->gst_bonus;
          $datatr['win_amt'] = $val3->winning;
          $datatr['addfund_amt'] = $val3->balance;
          $datatr['bal_bonus_amt'] = $dataq['bonus'];
          $datatr['bal_win_amt'] = $dataq['winning'];
          $datatr['bal_fund_amt'] = $dataq['balance'];
          $datatr['bal_gst_bonus_amt'] = $dataq['gst_bonus'];
          $datatr['bal_affi_amt'] = $dataq['affiliation_commission'];
          $datatr['userid'] = $val3->user_id;
          $datatr['total_available_amt'] = $dataq['balance'] + $dataq['winning'] + $dataq['bonus'] + $dataq['gst_bonus'] + $dataq['affiliation_commission'];
          DB::table('transactions')->insert($datatr);
          //mail//
          $challengename = "";
          if ($challenge_detail->name != "") {
            $challengename = $challenge_detail->name;
          } else {
            $challengename = 'Win-' . $challenge_detail->win_amount;
          }

          //notifications//
          $datan['title'] = 'Refund Amount of ₹' . $challenge_detail->entryfee . ' for contest cancellation';
          $datan['userid'] = $val3->user_id;
          DB::table('notifications')->insert($datan);
        }
      }
    }
    Session::flash('flash_notice', 'Contest Cancelled Successfully!');
    return Redirect::back();
  } //End Function

  //Match Pointes
  public function match_points($matchkey = null, $sport_type = 1, Request $req)
  {
    $fantasy_type = 0;
    $slot_type = 0;
    if (isset($req->fantasy_type) && !empty($req->fantasy_type)) {
      $fantasy_type = $req->fantasy_type;
      if ($fantasy_type == 4) {
        $fantasy_type = 0;
      }
    }
    if (isset($req->slot_type) && !empty($req->slot_type)) {
      $slot_type = $req->slot_type;
    }
    $findmatchdetails = DB::table('listmatches')
      ->where('matchkey', $matchkey)
      ->where('sport_type', $sport_type)
      ->first();
    $match_scores = DB::table('result_matches as rm')
      ->join('players as p', 'p.player_key', '=', 'rm.player_key')
      ->join('matchplayers as mp', 'mp.playerid', '=', 'p.id')
      ->join('teams as t', 't.id', '=', 'p.team')
      ->where('rm.match_key', $matchkey)
      ->where('mp.matchkey', $matchkey)
      ->where('mp.sport_type', $sport_type)
      // ->orderBy('rm.innings')
      ->orderBy('p.team')
      ->orderBy('p.id')
      //->groupBy('mp.playerid')
      ->select('rm.*', 'mp.matchkey as matchplayers_matchkey', 'mp.points as matchplayers_points', 'mp.role as matchplayers_role', 'mp.name as matchplayers_name', 'p.player_key as players_player_key', 'p.team as players_team', 't.team as teams_team', 't.short_name as team_short_name', 't.team_key as teams_team_key', 'mp.playerid as matchplayers_playerid')
      ->get();
    $match_points = DB::table('result_points as rp')
      ->join('players as p', 'p.id', '=', 'rp.playerid')
      ->join('result_matches as rm', 'rm.id', '=', 'rp.resultmatch_id')
      ->join('matchplayers as mp', 'mp.playerid', '=', 'p.id')
      ->join('teams as t', 't.id', '=', 'p.team')
      ->where('rp.matchkey', $matchkey)
      ->where('mp.matchkey', $matchkey)
      ->where('mp.sport_type', $sport_type)
      // ->orderBy('rm.innings')
      ->orderBy('p.team')
      ->orderBy('p.id')
      // ->groupBy('rp.playerid')
      ->select('rp.*', 'mp.matchkey as matchplayers_matchkey', 'mp.points as matchplayers_points', 'mp.role as matchplayers_role', 'mp.name as matchplayers_name', 'p.player_key as players_player_key', 'p.team as players_team', 't.team as teams_team', 't.team_key as teams_team_key', 'rm.innings', 't.short_name as team_short_name')
      ->get();

    return view("admin.$this->model.match_points", compact('match_scores', 'match_points', 'findmatchdetails', 'matchkey', 'sport_type'));
  } //End Function



  //Player Point
  public function player_points($matchkey, $playerid, Request $request)
  {
    $match_scores = DB::table('result_matches')
      ->join('players', 'players.player_key', '=', 'result_matches.player_key')
      ->join('matchplayers', 'matchplayers.playerid', '=', 'players.id')
      ->join('teams', 'teams.id', '=', 'players.team')
      ->where('result_matches.match_key', $matchkey)
      ->where('result_matches.player_id', $playerid)
      ->where('matchplayers.matchkey', $matchkey)
      ->select('result_matches.*', 'matchplayers.matchkey as matchplayers_matchkey', 'matchplayers.points as matchplayers_points', 'matchplayers.role as matchplayers_role', 'matchplayers.name as matchplayers_name', 'players.player_key as players_player_key', 'players.team as players_team', 'teams.team as teams_team', 'teams.team_key as teams_team_key', 'matchplayers.playerid as matchplayers_playerid')->get();
    //Update
    if ($request->isMethod('post')) {
      //Update Data
      $input = Input::all();
      //Unset Token
      unset($input['_token']);
      //Update
      $rowCOllection = DB::table('result_matches')->where('match_key', $matchkey)->where('player_id', $playerid)->update($input);
      Session::flash('flash_notice', 'Successfully updated ' . $matchkey . ' Points!');
      return Redirect::route($this->model . '.match_points', $matchkey);
    }

    return view("admin.$this->model.player_points", compact('match_scores'));
  } //End Function

  //Update Player Point
  public function update_player_points($matchkey = null, $playerid = null)
  {
    //Update
    if (request()->isMethod('post')) {
      //Update Data
      $input = Input::all();
      //Unset Token
      unset($input['_token']);
      //Update
      $rowCOllection = DB::table('result_matches')->where('match_key', $matchkey)->where('player_id', $playerid)->update($input);
      Session::flash('flash_notice', 'Successfully updated ' . $matchkey . ' challenges!');
      return Redirect::route($this->model . '.match_points', $matchkey);
    }
  } //End Function

  //Update All Team Name
  public function updateallteamnames()
  {
    $findallteams = DB::table('teams')->get();
    if (!empty($findallteams)) {
      foreach ($findallteams as $team) {
        $data = array();
        $data['short_name'] = $team->team_key;
        DB::table('teams');
        DB::table('teams')->where('id', $team->id)->update($data);
      }
    }
  } //End Function

  //Update Points
  public function updatepoints(Request $request)
  {
    if ($request->isMethod('post')) {
      $input = Input::all();
      $matchkey = $input['matchkey'];
      $playerid = $input['playerid'];
      $field = $input['field'];
      $value = $input['value'];
      $data[$field] = $value;
      DB::table('result_matches')->where('match_key', $matchkey)->where('player_id', $playerid)->update($data);
      $val = DB::table('listmatches')->where('matchkey', $matchkey)->first();
      $match_type = $val->format;
      $sport_type = $val->sport_type;
      $sportTypes = DB::table('sport_types')->where('id', $sport_type)->first();
      $showpoints = MatchesController::player_point($matchkey, $match_type, $sportTypes->sport_key);
      echo 1;
      die;
    }
  } //End Update Points

  //Update Status
  public function updatesquadstatus()
  {
    $allmatches = DB::table('listmatches')->where('status', 'notstarted')->where('launch_status', 'pending')->get();
    if (!empty($allmatches)) {
      foreach ($allmatches as $mm) {
        $findsquaddetials = CricketapiController::getmatchdetails($mm->matchkey);
        if (!empty($findsquaddetials)) {
          $matchadata['squadstatus'] = 'no';
          $squadteam1players = array();
          $squadteam2players = array();
          if (isset($findsquaddetials['data']['card']['teams']['a']['match']['players'])) {
            $squadteam1players = $findsquaddetials['data']['card']['teams']['a']['match']['players'];
          }
          if (isset($findsquaddetials['data']['card']['teams']['b']['match']['players'])) {
            $squadteam2players = $findsquaddetials['data']['card']['teams']['b']['match']['players'];
          }
          if ((!empty($squadteam1players)) && (!empty($squadteam2players))) {
            $matchadata['squadstatus'] = 'yes';
          }
          $matchdate = date('Y-m-d h:i:s', strtotime($findsquaddetials['start_date']['iso']));
          $cuurectdate = Carbon::parse($matchdate)->addHours(5)->addMinutes(30);
          $matchadata['start_date'] = $cuurectdate;
          DB::table('listmatches')->where('id', $mm->id)->update($matchadata);
        }
      }
      die;
    }
  } //End Function

  public function importscheduledatafromapi()
  {
    $getdayslist = CricketapiController::getscedulematches();
    date_default_timezone_set('Asia/Kolkata');
    $getdayslist = $getdayslist['data']['months'][0]['days'];
    if (!empty($getdayslist)) {
      foreach ($getdayslist  as $daylist) {
        $getlist = $daylist['matches'];
        if (!empty($getlist)) {
          foreach ($getlist as $getli) {
            $matchadata = array();
            $findmatchexist = DB::table('listmatches')->where('matchkey', $getli['key'])->first();
            if (empty($findmatchexist)) {
              //find squad details//
              $findsquaddetials = CricketapiController::getmatchdetails_old($getli['key']);
              if (!empty($findsquaddetials)) {
                $squadteam1players = array();
                $squadteam2players = array();
                if (isset($findsquaddetials['data']['card']['teams']['a']['match']['players'])) {
                  $squadteam1players = $findsquaddetials['data']['card']['teams']['a']['match']['players'];
                }
                if (isset($findsquaddetials['data']['card']['teams']['b']['match']['players'])) {
                  $squadteam2players = $findsquaddetials['data']['card']['teams']['b']['match']['players'];
                }
                if ((!empty($squadteam1players)) && (!empty($squadteam2players))) {
                  $matchadata['squadstatus'] = 'yes';
                } else {
                  $matchadata['squadstatus'] = 'no';
                }
              }
              //team details update//
              $team1key = $getli['teams']['a']['key'];
              $team2key = $getli['teams']['b']['key'];
              //insert team 1//
              $findteam1 = DB::table('teams')->where('team_key', $team1key)->select('id')->first();
              if (empty($findteam1)) {
                $data['team_key'] = $team1key;
                $data['team'] = $getli['teams']['a']['name'];
                $data['short_name'] = $team1key;
                $team1id = DB::table('teams')->insertGetId($data);
              } else {
                $team1id = $findteam1->id;
              }
              //insert team 2//
              $findteam2 = DB::table('teams')->where('team_key', $team2key)->select('id')->first();
              if (empty($findteam2)) {
                $data1['team_key'] = $team2key;
                $data1['team'] = $getli['teams']['b']['name'];
                $data1['short_name'] = $team2key;
                $team2id = DB::table('teams')->insertGetId($data1);
              } else {
                $team2id = $findteam2->id;
              }
              //insert match data//
              $matchadata['status'] = $getli['status'];
              $matchadata['name'] = $getli['name'];
              $matchadata['short_name'] = $getli['short_name'];
              $matchadata['season'] = $getli['season']['name'];
              $matchadata['title'] = $getli['title'];
              $matchadata['format'] = $getli['format'];
              $matchadata['team1'] = $team1id;
              $matchadata['team2'] = $team2id;
              $matchadata['team1display'] = $getli['teams']['a']['key'];
              $matchadata['team2display'] = $getli['teams']['b']['key'];
              $matchadata['matchkey'] = $getli['key'];
              $cuurectdate = date('Y-m-d H:i:s', strtotime($getli['start_date']['iso']));
              //$cuurectdate = Carbon::parse($matchdate )->addHours(5)->addMinutes(30);
              $matchadata['start_date'] = $cuurectdate;
              DB::table('listmatches')->insert($matchadata);
            } else if ($findmatchexist->team1display == "tbc" || $findmatchexist->team2display == "tbc") {
              $findsquaddetials = CricketapiController::getmatchdetails($getli['key']);
              if (!empty($findsquaddetials)) {
                $squadteam1players = array();
                $squadteam2players = array();
                if (isset($findsquaddetials['data']['card']['teams']['a']['match']['players'])) {
                  $squadteam1players = $findsquaddetials['data']['card']['teams']['a']['match']['players'];
                }
                if (isset($findsquaddetials['data']['card']['teams']['b']['match']['players'])) {
                  $squadteam2players = $findsquaddetials['data']['card']['teams']['b']['match']['players'];
                }
                if ((!empty($squadteam1players)) && (!empty($squadteam2players))) {
                  $matchadata['squadstatus'] = 'yes';
                } else {
                  $matchadata['squadstatus'] = 'no';
                }
              }
              //team details update//
              $team1key = $getli['teams']['a']['key'];
              $team2key = $getli['teams']['b']['key'];
              //insert team 1//
              $findteam1 = DB::table('teams')->where('team_key', $team1key)->select('id')->first();
              if (empty($findteam1)) {
                $data['team_key'] = $team1key;
                $data['team'] = $getli['teams']['a']['name'];
                $data['short_name'] = $team1key;
                $team1id = DB::table('teams')->insertGetId($data);
              } else {
                $team1id = $findteam1->id;
              }
              //insert team 2//
              $findteam2 = DB::table('teams')->where('team_key', $team2key)->select('id')->first();
              if (empty($findteam2)) {
                $data1['team_key'] = $team2key;
                $data1['team'] = $getli['teams']['b']['name'];
                $data1['short_name'] = $team2key;
                $team2id = DB::table('teams')->insertGetId($data1);
              } else {
                $team2id = $findteam2->id;
              }
              //update match data//
              $matchadata['status'] = $getli['status'];
              $matchadata['name'] = $getli['name'];
              $matchadata['short_name'] = $getli['short_name'];
              $matchadata['season'] = $getli['season']['name'];
              $matchadata['title'] = $getli['title'];
              $matchadata['format'] = $getli['format'];
              $matchadata['team1'] = $team1id;
              $matchadata['team2'] = $team2id;
              $matchadata['team1display'] = $getli['teams']['a']['key'];
              $matchadata['team2display'] = $getli['teams']['b']['key'];
              $matchadata['matchkey'] = $getli['key'];
              $cuurectdate = date('Y-m-d H:i:s', strtotime($getli['start_date']['iso']));
              //$cuurectdate = Carbon::parse($matchdate )->addHours(5)->addMinutes(30);
              $matchadata['start_date'] = $cuurectdate;
              DB::table('listmatches')->where('matchkey', $getli['key'])->update($matchadata);
            }
          }
        }
      }
    }
    return true;
  }

  public function update_live_score_cards($match_id, $sport_type = 1, $comp_id)
  {
    $sportType =  DB::table('sport_types')->where('id', $sport_type)->first();

    $match_format = DB::table("listmatches")->where("matchkey", $match_id)->where("sport_type", $sport_type)->first()->format;
    switch ($sportType->sport_key) {
      case CRICKET:
        $result = Cricketapi2Controller::get_live_score_data($match_id, $comp_id);
        $cricket_return = $this->update_cricket_live_score($result);
        //for commentries innings
        if (strtolower($match_format) == "test") {

          for ($c = 1; $c <= 4; $c++) {
            $commentries = Cricketapi2Controller::get_live_commentries_data($match_id, $c);
          }
        } else {

          for ($c = 1; $c <= 2; $c++) {
            $commentries = Cricketapi2Controller::get_live_commentries_data($match_id, $c);
            $livecommentry_data = $this->livecommentry_data($commentries,  $match_id);
          }
        }
        //end


        // echo "<pre>"; print_r($result); exit;
        //$result = CricketapiController::getmatchdetails($match_id);
        // if(empty($result)) {
        //   echo 1123490; exit;
        //   $result = array();
        //     $result = CricketapiController::getmatchdetails_old($match_id,$comp_id);
        //      // echo "<pre>"; print_r($result); exit;
        //   }
        //  echo "<pre>"; print_r($result); exit;
        //  echo "<pre>"; print_r($result['data']['card']); exit;


        break;
      case FOOTBALL:
        $result = FootballController::get_live_score_data($match_id, $comp_id);
        break;
      case BASKETBALL:
        $result = BasketBallController::get_live_score_data($match_id, $comp_id);
        break;

      default:
        # code...
        break;
    }
  }

  public function livecommentry_data($result, $match_id)
  {
    return 1;

    if (empty($result)) {
      return 1;
    }
    //$insert_arr = [];
    $insert_arr = array();

    if (!empty($result->commentaries)) {

      foreach ($result->commentaries as $ini) {

        if ($ini->event == 'ball' || $ini->score == 'w') {
          $insert = array(

            "matchkey" => !empty($match_id) ? $match_id : 0,
            "inning" => !empty($result->inning->number) ? $result->inning->number : 0,
            "bat_team_id" => !empty($result->inning->batting_team_id) ? $result->inning->batting_team_id : 0,
            "ball_team_id" => !empty($result->inning->fielding_team_id) ? $result->inning->fielding_team_id : 0,
            "strike_bat" => !empty($ini->batsman_id) ? $ini->batsman_id : 0,
            "strike_ball" => !empty($ini->bowler_id) ? $ini->bowler_id : 0,
            "over" => !empty($ini->over) ? $ini->over : 0,
            "balls" => (!empty($ini->over) ? $ini->over : 0) . '.' . (!empty($ini->ball) ? $ini->ball : 0),
            "score" => !empty($ini->score) ? $ini->score : 0,
            "run" => !empty($ini->runs) ? $ini->runs : 0,
            "event" => !empty($ini->event) ? $ini->event : 0,
            "commentry" => !empty($ini->commentary) ? $ini->commentary : 0,


          );
          $getlivecomm_record = DB::table('live_score_commentry')->where('matchkey', $match_id)->where("inning", $result->inning->number)->where('balls', $insert['balls'])->count();
          if ($getlivecomm_record > 0) {
            DB::table('live_score_commentry')->where('matchkey', $match_id)->where("inning", $result->inning->number)->where('balls', $insert['balls'])->delete();
          }
          DB::table('live_score_commentry')->insert($insert);
          //$insert_arr[] = $insert;
          //array_push($insert_arr,$insert);
        } else if ($ini->event == 'overend') {

          $insert_over_end = array(
            "matchkey" => !empty($match_id) ? $match_id : 0,
            "inning" => !empty($result->inning->number) ? $result->inning->number : 0,
            "bat_team_id" => !empty($result->inning->batting_team_id) ? $result->inning->batting_team_id : 0,
            "ball_team_id" => !empty($result->inning->fielding_team_id) ? $result->inning->fielding_team_id : 0,
            "strike_ball" => !empty($ini->bowls[0]->bowler_id) ? $ini->bowls[0]->bowler_id : 0,
            "over" => !empty($ini->over) ? $ini->over : 0,
            "balls" => (!empty($ini->over) ? $ini->over : 0) . '.' . (!empty($ini->ball) ? $ini->ball : 0),
            // "score"=>!empty($ini->score) ? $ini->score : 0,
            "team_score" => !empty($ini->score) ? $ini->score : 0,
            "run" => !empty($ini->runs) ? $ini->runs : 0,
            "event" => !empty($ini->event) ? (string)$ini->event : 0,
            "wickets" => !empty($ini->bowls[0]->wickets) ? $ini->bowls[0]->wickets : 0,
            "overruns" => !empty($ini->bowls[0]->runs_conceded) ? $ini->bowls[0]->runs_conceded : 0,
            "commentry" => !empty($ini->commentary) ? $ini->commentary : 0,
          );

          $getlivecomm_record2 = DB::table('live_score_commentry')->where('matchkey', $match_id)->where("inning", $result->inning->number)->where('balls', $insert_over_end['balls'])->count();
          if ($getlivecomm_record2 > 0) {
            DB::table('live_score_commentry')->where('matchkey', $match_id)->where("inning", $result->inning->number)->where('balls', $insert_over_end['balls'])->delete();
          }
          DB::table('live_score_commentry')->insert($insert_over_end);
        }
      }
    }
  }

  public function delete_all_between($beginning, $end, $string)
  {
    $beginningPos = strpos($string, $beginning);
    $endPos = strpos($string, $end);
    if ($beginningPos === false || $endPos === false) {
      return $string;
    }

    $textToDelete = substr($string, $beginningPos, ($endPos + strlen(@$end)) - $beginningPos);

    return $this->delete_all_between($beginning, $end, str_replace($textToDelete, '', $string)); // recursion to ensure all occurrences are replaced
  }


  public function get_yet_to_bat($matchkey, $yet_to_batting_player = array())
  {

    $yettobat_array = array();
    if (!empty($yet_to_batting_player)) {
      foreach ($yet_to_batting_player as $key => $value) {
        $yettobat_array[] = $value->name;
      }
    }
    return !empty($yettobat_array) ? implode(',', $yettobat_array) : '';
  }

  public function update_cricket_live_score($result)
  {
    if (empty($result)) {
      return 1;
    }

    $matchkey = $result->match_id;


    $teamWinKey = $result->toss->winner;
    $teamDecision = $result->toss->decision;
    $matchData = DB::table("listmatches")->where('matchkey', $matchkey)->first();
    $teamArr = array();
    $teamArr[] = $matchData->team1;
    $teamArr[] = $matchData->team2;

    if ($teamDecision == 1) {
      $teamsWinnerData = DB::table('teams')->whereIn('id', $teamArr)
        ->where('team_key', $teamWinKey)
        ->first();
    } else {
      $teamsWinnerData = DB::table('teams')->whereIn('id', $teamArr)
        ->where('team_key', '!=', $teamWinKey)
        ->first();
    }
    // @@@@ TEAM 1 DATA @@@@
    $team1 = array();
    $team1 = $result->teama;
    $Team1Data = array();
    if (!empty($team1)) {
      $Team1Data = array(
        "team_id" => $team1->team_id,
        "name" => $team1->name,
        "short_name" => $team1->short_name,
        "scores" => isset($team1->scores) ? $team1->scores : '00',
        "overs" => isset($team1->overs) ? $team1->overs : '0.0',
        // "number"=>11,
        "matchkey" => $matchkey,
      );
    }
    $checkTeam1 = array();
    $checkTeam1 = DB::table('live_teams_score')->where('matchkey', $matchkey)->where('team_id', $team1->team_id)->first();
    if (!empty($checkTeam1)) {
      DB::table('live_teams_score')->where('id', $checkTeam1->id)->update($Team1Data);
    } else {
      DB::table('live_teams_score')->insert($Team1Data);
    }
    // @@@@ TEAM 2 DATA @@@@
    $team2 = array();
    $team2 = $result->teamb;
    $Team2Data = array();
    if (!empty($team2)) {
      $Team2Data = array(
        "team_id" => $team2->team_id,
        "name" => $team2->name,
        "short_name" => $team2->short_name,
        "scores" => isset($team2->scores) ? $team2->scores : '00',
        "overs" => isset($team2->overs) ? $team2->overs : '0.0',
        // "number"=>21,
        "matchkey" => $matchkey,
      );
    }
    $checkTeam2 = array();
    $checkTeam2 = DB::table('live_teams_score')->where('matchkey', $matchkey)->where('team_id', $team2->team_id)->first();
    if (!empty($checkTeam2)) {
      DB::table('live_teams_score')->where('id', $checkTeam2->id)->update($Team2Data);
    } else {
      DB::table('live_teams_score')->insert($Team2Data);
    }
    //@@@@@@@@ Inning Code @@@@@@@@
    $innings = array();
    if (isset($result->innings)) {
      $innings = $result->innings;
    }

    if (!empty($innings)) {
      foreach ($innings as $key => $InningVal) {
        $battingTeam_id  = $InningVal->batting_team_id;

        //@@@@@@@@@@ Live Score Team Code @@@@@@@@@@@@@@@@@@@@@
        $yettobat = '';
        $yettobat = $this->get_yet_to_bat($matchkey, $InningVal->did_not_bat);
        $detela_all =  $this->delete_all_between(' (', ')', $InningVal->scores_full);

        $updateTeamScore = array(
          "inning" => $InningVal->number,
          // "number"=>$InningVal->number,
          "scores_full" => !empty($InningVal->scores_full) ? @$detela_all : '00/0',
          "scores_details" => !empty($InningVal->scores_full) ? str_replace('ov', 'Overs', $InningVal->scores_full) : '00/0',
          "extra_bye_run" => !empty($InningVal->extra_runs->byes) ? $InningVal->extra_runs->byes : 0,
          "extra_legbye_run" => !empty($InningVal->extra_runs->legbyes) ? $InningVal->extra_runs->legbyes : 0,
          "extra_wideball_run" => !empty($InningVal->extra_runs->wides) ? $InningVal->extra_runs->wides : 0,
          "extra_noball_run" => !empty($InningVal->extra_runs->noballs) ? $InningVal->extra_runs->noballs : 0,
          "extra_penalty_run" => !empty($InningVal->extra_runs->penalty) ? $InningVal->extra_runs->penalty : 0,
          "extra_run" => !empty($InningVal->extra_runs->total) ? $InningVal->extra_runs->total : 0,
          "yet_to_bat" => !empty($yettobat) ? $yettobat : '0',
        );

        if (!empty($updateTeamScore)) {
          DB::table('live_teams_score')->where('matchkey', $matchkey)->where('team_id', $battingTeam_id)->update($updateTeamScore);
        }
        //@@@@@@@@@@ Live Score Team Code @@@@@@@@@@@@@@@@@@@@@

        //@@@@@@@@@@ Live Score Batting Code @@@@@@@@@@@@@@@@@@@@@
        $live_batting_score = array();
        $live_batting_score = $InningVal->batsmen;
        $batting_data = array();
        if (!empty($live_batting_score)) {
          foreach ($live_batting_score as $key => $batting) {
            $batting_data['matchkey'] = $matchkey;
            $batting_data['batsman_id'] = $batting->batsman_id;
            $batting_data['position'] = (!empty($batting->position) && $batting->position == 'striker') ? 1 : 0;
            $batting_data['bats_pos'] = (!empty($batting->batting) && $batting->batting == 'false') ? 0 : 1;
            $batting_data['name'] = $batting->name;
            $batting_data['team_id'] = $battingTeam_id;
            $batting_data['inning'] = $InningVal->number;
            $batting_data['run'] = $batting->runs;
            $batting_data['ball'] = $batting->balls_faced;
            $batting_data['four'] = $batting->fours;
            $batting_data['six'] = $batting->sixes;
            $batting_data['how_out'] = $batting->how_out;
            $batting_data['dots'] = $batting->run0;
            $batting_data['strike_rate'] = $batting->strike_rate;
            $batting_data['app_points'] = $batting->batsman_id;
            $check_batting = array();
            $check_batting = DB::table("live_players_score")
              ->where('matchkey', $matchkey)
              ->where('team_id', $battingTeam_id)
              ->where('batsman_id', $batting->batsman_id)
              ->where('inning', $InningVal->number)->first();
            if (!empty($check_batting)) {
              DB::table('live_players_score')->where('id', $check_batting->id)->update($batting_data);
            } else {
              DB::table('live_players_score')->insert($batting_data);
              $api_status = DB::Table('listmatches')->where('matchkey', $matchkey)->where('sport_type', 1)->select('scorecard')->first();
              if (strtoupper($api_status->scorecard) != 'TRUE') {
                $update_api = array(
                  "scorecard" => "true"
                );
                DB::table('listmatches')->where('matchkey', $matchkey)->where('sport_type', 1)->update($update_api);
              }
            }
          }
        }
        //@@@@@@@@@@ Live Score Bowling Code @@@@@@@@@@@@@@@@@@@@@
        $bowllingTeam_id = $InningVal->fielding_team_id;
        $live_bowling_score = array();
        $live_bowling_score = $InningVal->bowlers;
        $bowling_data = array();
        // echo "<pre>"; print_r($live_bowling_score); exit;
        if (!empty($live_bowling_score)) {
          foreach ($live_bowling_score as $key => $bowling) {
            $bowling_data['bowler_id'] = $bowling->bowler_id;
            $bowling_data['name'] = $bowling->name;
            $bowling_data['matchkey'] = $matchkey;
            $bowling_data['team_id'] = $bowllingTeam_id;
            $bowling_data['inning'] = $InningVal->number;
            $bowling_data['overs'] = $bowling->overs;
            $bowling_data['maidens'] = $bowling->maidens;
            $bowling_data['runs'] = $bowling->runs_conceded;
            $bowling_data['wickets'] = $bowling->wickets;
            $bowling_data['economy'] = $bowling->econ;
            $bowling_data['dots'] = $bowling->run0;
            $bowling_data['runs'] = $bowling->runs_conceded;
            $bowling_data['position'] = $bowling->position;

            $check_bowling = array();
            $check_bowling = DB::table("live_bowlers_score")
              ->where('matchkey', $matchkey)
              ->where('team_id', $bowllingTeam_id)
              ->where('bowler_id', $bowling->bowler_id)
              ->where('inning', $InningVal->number)->first();
            if (!empty($check_bowling)) {
              DB::table('live_bowlers_score')->where('id', $check_bowling->id)->update($bowling_data);
            } else {
              DB::table('live_bowlers_score')->insert($bowling_data);
              $api_status = DB::Table('listmatches')->where('matchkey', $matchkey)->where('sport_type', 1)->select('scorecard')->first();
              if (strtoupper($api_status->scorecard) != 'TRUE') {
                $update_api = array(
                  "scorecard" => "true"
                );
                DB::table('listmatches')->where('matchkey', $matchkey)->where('sport_type', 1)->update($update_api);
              }
            }
          }
        }
        //@@@@@@@@@@ Live Score Bowling Code @@@@@@@@@@@@@@@@@@@@@

        //@@@@@@@@@  LIve Fowls of Wicket Code @@@@@@@@@@@@@@@@@@@
        $fowls_wicket_data = array();
        $fowls_wicket_data = $InningVal->fows;

        DB::table('fall_of_wickets')->where('matchkey', $matchkey)->where('inning', $InningVal->number)->delete();
        if (!empty($fowls_wicket_data) &&  count($fowls_wicket_data) > 0) {

          foreach ($fowls_wicket_data as $key => $fowls) {
            $fowls_wicket = array();
            $fowls_wicket['matchkey'] = $matchkey;
            $fowls_wicket['team_id'] = $battingTeam_id;
            $fowls_wicket['inning'] = $InningVal->number;
            $fowls_wicket['fall_of_wickets'] = $fowls->name . ' at ' . $fowls->score_at_dismissal . ' runs, in ' . $fowls->overs_at_dismissal . ' overs';

            DB::table('fall_of_wickets')->insert($fowls_wicket);
          }
        }
        //@@@@@@@@@  LIve Fowls of Wicket Code @@@@@@@@@@@@@@@@@@@

        //live_api_data, with commentary

        $commnetyr_return = $this->live_data_with_commentary($matchkey);
      }

      $updateTeamScoreBatsman['number'] = 1;

      DB::table('live_teams_score')->where('matchkey', $matchkey)->where('team_id', $teamsWinnerData->team_key)->update($updateTeamScoreBatsman);


      $updateTeamScoreBatsman['number'] = 2;
      DB::table('live_teams_score')->where('matchkey', $matchkey)->where('team_id', '!=', $teamsWinnerData->team_key)->update($updateTeamScoreBatsman);
    }
  }

  public function live_data_with_commentary($matchkey)
  {
    //return true;
    // $get_live_api_data = Cricketapi2Controller::get_live_api_data('57727');
    $get_live_api_data = Cricketapi2Controller::get_live_api_data($matchkey);

    if (isset($get_live_api_data->live_inning_number)) {
      $inningRunning = $get_live_api_data->live_inning_number;
      $get_commentary_data = Cricketapi2Controller::get_live_commentries_data($matchkey, $inningRunning);

      if (!empty($get_commentary_data->commentaries)) {

        $datas = array_filter($get_commentary_data->commentaries, function ($item)
        use ($get_live_api_data) {
          //return ($item->over == floor($get_live_api_data->live_score->overs) - 1 && $item->event == 'ball');
          return ($item->over == floor($get_live_api_data->live_score->overs)  && $item->event == 'ball');
          //   return ($item->over == $get_live_api_data->live_score->overs && $item->event == 'ball');
        });

        $overArr = array();
        foreach ($datas as $key => $value) {
          $overArr[] = $value->score;
        }
        $overArr = implode(',', $overArr);
        if (!empty($get_live_api_data)) {
          DB::table('live_score_summery')->where('matchkey', $matchkey)->delete();
          $bowlers_runsscore = $get_live_api_data->bowlers[0];
          $bowlers_runs = $bowlers_runsscore->wickets . '/' . $bowlers_runsscore->runs_conceded . ' (' . $bowlers_runsscore->overs . ')';
          $live_score_summery_array = array();
          $live_score_summery_array['matchkey'] = $matchkey;
          $live_score_summery_array['batsman1_name'] = $get_live_api_data->batsmen[0]->name;
          $live_score_summery_array['batsman1_run'] = $get_live_api_data->batsmen[0]->runs . ' (' . $get_live_api_data->batsmen[0]->balls_faced . ')';
          $live_score_summery_array['batsman2_name'] = $get_live_api_data->batsmen[1]->name;
          $live_score_summery_array['batsman2_run'] = $get_live_api_data->batsmen[1]->runs . ' (' . $get_live_api_data->batsmen[1]->balls_faced . ')';
          $live_score_summery_array['bowler_name'] = $get_live_api_data->bowlers[0]->name;
          $live_score_summery_array['bowler_detail'] = '';
          $live_score_summery_array['overs'] = $bowlers_runs;
          $live_score_summery_array['over_summery'] = $overArr;
          $save_data = 0;
          $save_data = DB::table('live_score_summery')->insertGetId($live_score_summery_array);
          $api_status = DB::Table('listmatches')->where('matchkey', $matchkey)->where('sport_type', 1)->select('commentary_api_status')->first();
          if (strtoupper($api_status->commentary_api_status) != 'TRUE' && $save_data > 0) {
            $update_api = array(
              "commentary_api_status" => "true"
            );
            DB::table('listmatches')->where('matchkey', $matchkey)->where('sport_type', 1)->update($update_api);
          }
        }
      }
    }
  }

  public function import_match_squad($match_id, $comp_id, $sport_type = CRICKET)
  {



    $sport_type = str_replace(' ', '', strtoupper($sport_type));

    $sportType =  DB::table('sport_types')->where('sport_key', $sport_type)->first();

    switch ($sport_type) {
      case BASKETBALL:
        /*$match = DB::table('listmatches')->where('matchkey', $match_id)->where('sport_type',3)->first();
                        $this->import_match_squad($match->matchkey, $match->competition_id,'BASKETBALL');
                        return Redirect::back();
                        exit;*/
        $squads = BasketBallController::get_match_squad($match_id, $comp_id);
        if ($match_id == 19016) {
        }
        if (!empty($squads)) {
          $squads = $squads->items;
          $matchInfo = $squads->match_info;
          $squads = $squads->fantasy_squad;
          foreach ($squads as $key2 => $value2) {
            $teamid = $matchInfo->teams->{$key2}->tid;
            $players = @$value2;
            if (!empty(@$players)) {
              $match_data['squadstatus'] = 'yes';
              DB::table('listmatches')->where('matchkey', $match_id)->where('sport_type', $sportType->id)->update($match_data);
            } else {
              $players = array();
            }

            foreach ($players as $key => $value) {
              if (isset($value->pid)) {
                $teamkey = $teamid;
                $players1 = $value->pid;
                $playerkey = $players1;
                $findmatchexist = DB::table('teams')->where('team_key', $teamkey)->where('sport_type', $sportType->id)->select('id')->first();
                if (!empty($findmatchexist)) {
                  $findp1 = DB::table('playerdetails')->where('player_key', $players1)->where('sport_type', $sportType->id)->first();
                  $findplayerexist = DB::table('players')->where('player_key', $players1)->where('team', $findmatchexist->id)->where('sport_type', $sportType->id)->first();

                  $data['player_name'] = $value->name;
                  $data['player_key'] = $playerkey;
                  $plaerdetailsdata['fullname'] = $value->name;
                  $plaerdetailsdata['player_key'] = $playerkey;
                  $plaerdetailsdata['sport_type'] = $sportType->id;
                  $data['sport_type'] = 3;

                  if (empty($findplayerexist)) {
                    $data['team'] = $findmatchexist->id;
                    $data['role'] = $value->rolename;
                    $playerid = DB::table('players')->insertGetId($data);
                    $credit = $value->rating;
                  } else {
                    $playerid = $findplayerexist->id;
                    $credit = $value->rating;
                    $data['role'] = $value->rolename;
                  }

                  /* insert in player details table*/

                  if (empty($findp1)) {
                    DB::table('playerdetails')->insert($plaerdetailsdata);
                  } else {
                    DB::table('playerdetails')->where('id', $findp1->id)->update($plaerdetailsdata);
                  }
                  // insert players for a match//
                  $findplayer1entry = DB::table('matchplayers')->where('matchkey', $match_id)->where('playerid', $playerid)->where('sport_type', $sportType->id)->first();
                  // print_r($findplayer1entry);
                  // $credit = 9;
                  if (empty($findplayer1entry)) {
                    $matchplayerdata['matchkey'] = $match_id;
                    $matchplayerdata['playerid'] = $playerid;
                    $matchplayerdata['player_key'] = $playerkey;
                    $matchplayerdata['role'] = $data['role'];
                    $matchplayerdata['name'] = $data['player_name'];
                    $matchplayerdata['credit'] = $credit;
                    $matchplayerdata['sport_type'] = $sportType->id;
                    DB::table('matchplayers')->insert($matchplayerdata);
                  } else {
                    // $matchplayerdata['matchkey'] = $match_id;
                    // $matchplayerdata['playerid'] = $playerid;
                    // $matchplayerdata['role'] = $data['role'];
                    // $matchplayerdata['name'] = $data['player_name'];
                    // $matchplayerdata['credit'] = $credit;
                    // DB::table('matchplayers')->where('id', $findplayer1entry->id)->update($matchplayerdata);
                  }
                }

                $findmatchexist = DB::table('teams')->where('team_key', $teamkey)->where('sport_type', $sportType->id)->select('id')->first();
                if (!empty($findmatchexist)) {
                  $findplayerexist = DB::table('players')->where('player_key', $players1)
                    ->where('team', $findmatchexist->id)
                    ->where('sport_type', $sportType->id)
                    ->first();

                  $findLastMatchTeam1 = DB::table('listmatches')
                    ->where(function ($query) use ($findmatchexist) {
                      $query->where('team1', $findmatchexist->id)
                        ->orWhere('team2', $findmatchexist->id);
                    })
                    ->select('matchkey')->orderBy('id', 'DESC')->limit(1)->first();
                  //  echo '<pre>'; print_r($findLastMatchTeam1);exit;
                  if (!empty($findLastMatchTeam1)) {
                    $findLastMatchPlayersTeam1 =  DB::table('matchplayers')
                      ->where('is_assumption', 1)
                      ->where('player_key', $players1)
                      ->where('sport_type', $sportType->id)
                      ->select('playerid')
                      ->orderby('id', 'desc')
                      ->first();
                    if (!empty($findLastMatchPlayersTeam1)) {
                      $lastMatchPlayedData['last_match_played'] = 'true';
                      // DB::table('matchplayers')->where('matchkey', $match_id)->where('playerid', $findLastMatchPlayersTeam1->playerid)->update($lastMatchPlayedData);
                    } else {
                      $lastMatchPlayedData['last_match_played'] = 'false';
                      // DB::table('matchplayers')->where('matchkey', $match_id)->where('playerid', @$findLastMatchPlayersTeam1->playerid)->update($lastMatchPlayedData);
                    }
                  }
                }
              }
            }
          }
        }
        break;

      case FOOTBALL:
        $squads = FootballController::get_match_squad($match_id, $comp_id);
        /* $match = DB::table('listmatches')->where('matchkey', $match_id)->where('sport_type',2)->first();
                    // print_r($match); exit;
                    $this->import_match_squad($match->matchkey, $match->competition_id,'FOOTBALL');
                    return Redirect::back();
                    exit;*/
        // echo"<pre>"; print_r($squads); exit;
        if ($match_id == 45643) {
        }
        DB::table('matchplayers')->where('matchkey', $match_id)->where('sport_type', 2)->delete();
        if (!empty($squads)) {
          $match_info = $squads->items->match_info;
          $squads = $squads->items->teams;
          // echo"<pre>"; print_r($squads); exit;
          foreach ($squads as $key2 => $value2) {
            $players = @$value2;

            if (!empty(@$players)) {
              $match_data['squadstatus'] = 'yes';
              DB::table('listmatches')->where('matchkey', $match_id)->where('sport_type', $sportType->id)->update($match_data);
            } else {
              $players = array();
            }
            $teamkey = $match_info->teams->{$key2}->tid;
            // print_r($players); exit;
            foreach ($players as $key => $value) {
              if (isset($value->pid)) {
                $data = array();
                $players1 = $value->pid;
                $playerkey = $players1;
                $findmatchexist = DB::table('teams')->where('team_key', $teamkey)->where('sport_type', $sportType->id)->select('id')->first();
                if (!empty($findmatchexist)) {
                  $findp1 = DB::table('playerdetails')->where('player_key', $players1)->where('sport_type', $sportType->id)->first();
                  $findplayerexist = DB::table('players')->where('player_key', $players1)->where('team', $findmatchexist->id)->where('sport_type', $sportType->id)->first();

                  $data['player_name'] = isset($value->name) ? $value->name : $value->pname;
                  $data['player_key'] = $playerkey;
                  $plaerdetailsdata['fullname'] = isset($value->name) ? $value->name : $value->pname;
                  $plaerdetailsdata['player_key'] = $playerkey;
                  $plaerdetailsdata['sport_type'] = $sportType->id;
                  $data['sport_type'] = 2;

                  if (empty($findplayerexist)) {
                    $data['team'] = $findmatchexist->id;
                    $data['role'] = $value->role;
                    $playerid = DB::table('players')->insertGetId($data);
                    $credit = $value->rating;
                  } else {
                    $playerid = $findplayerexist->id;
                    $credit = $value->rating;
                    $data['role'] = $value->role;
                    DB::table('players')->where('player_key', $players1)->where('sport_type', $sportType->id)->update($data);
                  }
                  /* insert in player details table*/

                  if (empty($findp1)) {
                    DB::table('playerdetails')->insert($plaerdetailsdata);
                  } else {
                    DB::table('playerdetails')->where('id', $findp1->id)->update($plaerdetailsdata);
                  }
                  // insert players for a match//
                  $findplayer1entry = DB::table('matchplayers')->where('matchkey', $match_id)->where('playerid', $playerid)->first();
                  if (empty($findplayer1entry)) {
                    $matchplayerdata['matchkey'] = $match_id;
                    $matchplayerdata['playerid'] = $playerid;
                    $matchplayerdata['player_key'] = $playerkey;
                    $matchplayerdata['role'] = $data['role'];
                    $matchplayerdata['name'] = $data['player_name'];
                    $matchplayerdata['sport_type'] = $sportType->id;
                    $matchplayerdata['credit'] = $credit;
                    try {
                      // var_dump($matchplayerdata);exit;

                      DB::table('matchplayers')->insert($matchplayerdata);
                    } catch (Exception $e) {
                    }
                    // DB::table('matchplayers')->insert($matchplayerdata);
                  } else {
                    // $matchplayerdata['matchkey'] = $match_id;
                    // $matchplayerdata['playerid'] = $playerid;
                    // $matchplayerdata['role'] = $data['role'];
                    // $matchplayerdata['name'] = $data['player_name'];
                    // $matchplayerdata['sport_type'] = $sportType->id;
                    // $matchplayerdata['credit'] = $credit;
                    // DB::table('matchplayers')->where('id', $findplayer1entry->id)->update($matchplayerdata);
                  }
                }
                $findmatchexist = DB::table('teams')->where('team_key', $teamkey)->where('sport_type', $sportType->id)->select('id')->first();
                if (!empty($findmatchexist)) {
                  $findplayerexist = DB::table('players')->where('player_key', $players1)
                    ->where('team', $findmatchexist->id)
                    ->where('sport_type', $sportType->id)
                    ->first();

                  $findLastMatchTeam1 = DB::table('listmatches')
                    ->where(function ($query) use ($findmatchexist) {
                      $query->where('team1', $findmatchexist->id)
                        ->orWhere('team2', $findmatchexist->id);
                    })
                    ->select('matchkey')->orderBy('id', 'DESC')->limit(1)->first();
                  //  echo '<pre>'; print_r($findLastMatchTeam1);exit;
                  if (!empty($findLastMatchTeam1)) {
                    $findLastMatchPlayersTeam1 =  DB::table('matchplayers')
                      ->where('is_assumption', 1)
                      ->where('player_key', $players1)
                      ->where('sport_type', $sportType->id)
                      ->select('playerid')
                      ->orderby('id', 'desc')
                      ->first();
                    if (!empty($findLastMatchPlayersTeam1)) {
                      $lastMatchPlayedData['last_match_played'] = 'true';
                      // DB::table('matchplayers')->where('matchkey', $match_id)->where('playerid', $findLastMatchPlayersTeam1->playerid)->update($lastMatchPlayedData);
                    } else {
                      $lastMatchPlayedData['last_match_played'] = 'false';
                      // DB::table('matchplayers')->where('matchkey', $match_id)->where('playerid', @$findLastMatchPlayersTeam1->playerid)->update($lastMatchPlayedData);
                    }
                  }
                }
              }
            }
          }
          if ($match_id == 34538) {
            // exit;
          }
        }
        break;

      //xxxxxxxxxxxxxxxxx KABADDI NEW ADDED xxxxxxxxxxxxxxx

      case 'KABADDI':
        $comp_id = DB::table('listmatches')->where('matchkey', $match_id)->first()->competition_id;
        $squads = KabaddiController::get_match_squad($match_id, $comp_id);

        if (!empty($squads)) {
          $match_info = $squads->items->match_info;
          $squads = $squads->items->squad;

          if (!empty($squads)) {
            foreach ($squads as $key2 => $value2) {
              $players = @$value2;
              if (!empty(@$players)) {
                $match_data['squadstatus'] = 'yes';
                DB::table('listmatches')->where('matchkey', $match_id)->where('sport_type', $sportType->id)->update($match_data);
              } else {
                $players = array();
              }
              $teamkey = $match_info->teams->{$key2}->tid;
              foreach ($players as $key => $value) {
                if (isset($value->pid)) {
                  $data = array();
                  $players1 = $value->pid;
                  $playerkey = $players1;
                  $findmatchexist = DB::table('teams')->where('team_key', $teamkey)->where('sport_type', $sportType->id)->select('id')->first();
                  if (!empty($findmatchexist)) {
                    $findp1 = DB::table('playerdetails')->where('player_key', $players1)->where('sport_type', $sportType->id)->first();
                    $findplayerexist = DB::table('players')->where('player_key', $players1)->where('team', $findmatchexist->id)->where('sport_type', 7)->first();

                    $data['player_name'] = isset($value->name) ? $value->name : $value->pname;
                    $data['player_key'] = $playerkey;
                    $plaerdetailsdata['fullname'] = isset($value->name) ? $value->name : $value->pname;
                    $plaerdetailsdata['player_key'] = $playerkey;
                    $plaerdetailsdata['sport_type'] = $sportType->id;


                    if (empty($findplayerexist)) {
                      $data['team'] = $findmatchexist->id;
                      $data['role'] = $value->role;
                      $data['sport_type'] = 7;
                      $playerid = DB::table('players')->insertGetId($data);
                      $credit = $value->fantasy_credit;
                    } else {
                      $playerid = $findplayerexist->id;
                      $credit = $value->fantasy_credit;
                      $data['role'] = $value->role;
                      DB::table('players')->where('player_key', $players1)->where('sport_type', 7)->update($data);
                    }


                    if (empty($findp1)) {
                      DB::table('playerdetails')->insert($plaerdetailsdata);
                    } else {
                      DB::table('playerdetails')->where('id', $findp1->id)->update($plaerdetailsdata);
                    }
                    // insert players for a match//
                    $findplayer1entry = DB::table('matchplayers')->where('matchkey', $match_id)->where('playerid', $playerid)->where('player_key', $playerkey)->where('sport_type', $sportType->id)->first();
                    if (empty($findplayer1entry) && !empty($playerkey)) {
                      $matchplayerdata['matchkey'] = $match_id;
                      $matchplayerdata['playerid'] = $playerid;
                      $matchplayerdata['player_key'] = $playerkey;
                      $matchplayerdata['role'] = $data['role'];
                      $matchplayerdata['name'] = $data['player_name'];
                      $matchplayerdata['sport_type'] = $sportType->id;
                      $matchplayerdata['credit'] = $credit;
                      try {
                        DB::table('matchplayers')->insert($matchplayerdata);
                      } catch (Exception $e) {
                      }
                    } else {
                      // $matchplayerdata['matchkey'] = $match_id;
                      // $matchplayerdata['playerid'] = $playerid;
                      // $matchplayerdata['role'] = $data['role'];
                      // $matchplayerdata['name'] = $data['player_name'];
                      // $matchplayerdata['sport_type'] = $sportType->id;
                      // $matchplayerdata['credit'] = $credit;
                      // DB::table('matchplayers')->where('id', $findplayer1entry->id)->update($matchplayerdata);
                    }
                  }

                  $findmatchexist = DB::table('teams')->where('team_key', $teamkey)->where('sport_type', $sportType->id)->select('id')->first();
                  if (!empty($findmatchexist)) {
                    $findplayerexist = DB::table('players')->where('player_key', $players1)
                      ->where('team', $findmatchexist->id)
                      ->where('sport_type', $sportType->id)
                      ->first();

                    $findLastMatchTeam1 = DB::table('listmatches')
                      ->where(function ($query) use ($findmatchexist) {
                        $query->where('team1', $findmatchexist->id)
                          ->orWhere('team2', $findmatchexist->id);
                      })
                      ->select('matchkey')->orderBy('id', 'DESC')->limit(1)->first();
                    //  echo '<pre>'; print_r($findLastMatchTeam1);exit;
                    if (!empty($findLastMatchTeam1)) {
                      $findLastMatchPlayersTeam1 =  DB::table('matchplayers')
                        ->where('is_assumption', 1)
                        ->where('player_key', $players1)
                        ->where('sport_type', $sportType->id)
                        ->select('playerid')
                        ->orderby('id', 'desc')
                        ->first();
                      if (!empty($findLastMatchPlayersTeam1)) {
                        $lastMatchPlayedData['last_match_played'] = 'true';
                        // DB::table('matchplayers')->where('matchkey', $match_id)->where('playerid', $findLastMatchPlayersTeam1->playerid)->update($lastMatchPlayedData);
                      } else {
                        $lastMatchPlayedData['last_match_played'] = 'false';
                        // DB::table('matchplayers')->where('matchkey', $match_id)->where('playerid', @$findLastMatchPlayersTeam1->playerid)->update($lastMatchPlayedData);
                      }
                    }
                  }
                }
              }
            }
          }
        }
        break;
      //xxxxxxxxxxxxxxxxx KABADDI NEW ADDED xxxxxxxxxxxxxxx


      default:

        $squads = Cricketapi2Controller::get_match_squad($match_id, $comp_id);
        // echo "<pre>"; print_r($squads); exit;

        if (!empty($squads)) {
          // DB::table('matchplayers')->where('matchkey', $match_id)->where('sport_type',1)->delete();


          $squads1 = $squads->squads;

          foreach ($squads1 as $key2 => $value2) {

            $players = @$value2->players;

            if (!empty(@$players)) {

              $match_data['squadstatus'] = 'yes';

              DB::table('listmatches')->where('matchkey', $match_id)->where('sport_type', $sportType->id)->update($match_data);
            } else {

              $players = array();
            }


            foreach ($players as $key => $value) {

              if (isset($value->pid) && !empty($value->pid)) {

                $teamkey = $value2->team_id;

                $players1 = $value->pid;

                $playerkey = $players1;
                // echo $teamkey;

                $findmatchexist = DB::table('teams')->where('team_key', $teamkey)->where('sport_type', $sportType->id)->select('id')->orderBy('id', 'DESC')->first();

                if (!empty($findmatchexist)) {

                  $findp1 = DB::table('playerdetails')->where('player_key', $players1)
                    ->where('sport_type', $sportType->id)->first();
                  // echo $findmatchexist->id;

                  $findplayerexist = DB::table('players')->where('player_key', $players1)->where('team', $findmatchexist->id)->where('sport_type', 1)->first();
                  //echo '<pre>';
                  //print_r($findplayerexist);


                  $data['player_name'] = $value->title;

                  $data['player_key'] = $playerkey;

                  $plaerdetailsdata['fullname'] = $value->title;

                  $plaerdetailsdata['bowling_style'] = @$value->bowling_style;
                  $plaerdetailsdata['batting_style'] = @$value->batting_style;

                  $plaerdetailsdata['country'] = @$value->nationality;
                  $plaerdetailsdata['dob'] = @$value->birthdate;

                  $plaerdetailsdata['player_key'] = $playerkey;
                  $plaerdetailsdata['sport_type'] = 1;

                  if (empty($findplayerexist)) {
                    //echo 'hi';

                    $data['team'] = $findmatchexist->id;

                    if ($value->playing_role == "bat") {

                      $data['role'] = 'batsman';
                    } elseif ($value->playing_role == "all") {

                      $data['role'] = 'allrounder';
                    } elseif ($value->playing_role == "bowl") {

                      $data['role'] = 'bowler';
                    } elseif ($value->playing_role == "wk") {

                      $data['role'] = 'keeper';
                    } elseif ($value->playing_role == "wkbat") {

                      $data['role'] = 'keeper';
                    } else {

                      $data['role'] =  'allrounder';
                    }

                    // $data['']

                    $playerid = DB::table('players')->insertGetId($data);

                    $credit = $value->fantasy_player_rating;
                  } else {

                    //echo 'bye';

                    $playerid = $findplayerexist->id;

                    $credit = $value->fantasy_player_rating;

                    if ($value->playing_role == "bat") {

                      $data['role'] = 'batsman';
                    } elseif ($value->playing_role == "all") {

                      $data['role'] = 'allrounder';
                    } elseif ($value->playing_role == "bowl") {

                      $data['role'] = 'bowler';
                    } elseif ($value->playing_role == "wk") {

                      $data['role'] = 'keeper';
                    } elseif ($value->playing_role == "wkbat") {

                      $data['role'] = 'keeper';
                    } else {

                      $data['role'] =  'allrounder';
                    }
                  }

                  //insert in player details table

                  if (empty($findp1)) {
                    //echo 1;

                    DB::table('playerdetails')->insert($plaerdetailsdata);
                  } else {
                    //echo 2;

                    DB::table('playerdetails')->where('id', $findp1->id)->update($plaerdetailsdata);
                  }

                  // insert players for a match//

                  $findplayer1entry = DB::table('matchplayers')->where('matchkey', $match_id)
                    ->where('playerid', $playerid)
                    //->where('player_key',$playerkey)
                    ->where('sport_type', 1)->first();

                  // print_r($playerkey);exit;

                  if (empty($findplayer1entry)) {
                    //echo 'arpit';

                    $matchplayerdata['matchkey'] = $match_id;

                    $matchplayerdata['playerid'] = $playerid;
                    $matchplayerdata['player_key'] = $playerkey;

                    $matchplayerdata['role'] = $data['role'];

                    $matchplayerdata['name'] = $data['player_name'];

                    $matchplayerdata['credit'] = $credit;
                    $matchplayerdata['fiveplus_credit'] = @$findplayerexist->fiveplus_credit;

                    $findplayer1entrycheck = DB::table('matchplayers')->where('matchkey', $match_id)
                      ->where('player_key', $playerkey)
                      //->where('playerid',$playerid)
                      ->where('sport_type', 1)->first();
                    if (!empty($findplayer1entrycheck)) {
                      DB::table('matchplayers')->where('id', $findplayer1entrycheck->id)->update($matchplayerdata);
                    } else {

                      DB::table('matchplayers')->insert($matchplayerdata);
                    }
                  } else {
                    //echo 'sri';
                    $matchplayerdata = array();
                    // $matchplayerdata['matchkey'] = $match_id;

                    // $matchplayerdata['playerid'] = $playerid;


                    // $matchplayerdata['role'] = $data['role'];

                    // $matchplayerdata['name'] = $data['player_name'];
                    //$matchplayerdata['player_key'] = $playerkey;
                    $matchplayerdata['credit'] = $credit;
                    $matchplayerdata['fiveplus_credit'] = @$findplayerexist->fiveplus_credit;

                    // DB::table('matchplayers')->where('id', $findplayer1entry->id)->where('sport_type',1)->update($matchplayerdata);

                  }

                  foreach ($squads->squads as $lastmatchp) {
                    $findmatchexist = DB::table('teams')->where('team_key', $lastmatchp->team_id)->select('id')->first();

                    foreach ($lastmatchp->last_match_played as $key => $value) {

                      if (!empty($findmatchexist)) {
                        $findplayerexist = DB::table('players')->where('player_key', $value->player_id)->where('sport_type', 1)->where('team', $findmatchexist->id)->first();

                        $findLastMatchTeam1 = DB::table('listmatches')
                          //  ->where('status','completed')
                          ->where(function ($query) use ($findmatchexist) {
                            $query->where('team1', $findmatchexist->id)
                              ->orWhere('team2', $findmatchexist->id);
                          })
                          ->select('matchkey')->orderBy('id', 'DESC')->limit(1)->first();
                        //  echo '<pre>'; print_r($findLastMatchTeam1);exit;
                        if (!empty($findLastMatchTeam1)) {
                          $findLastMatchPlayersTeam1 =  DB::table('result_matches')
                            ->where('match_key', $findLastMatchTeam1->matchkey)
                            ->where('player_key', $value->player_id)
                            ->select('player_key')->get();

                          if (!empty($findplayerexist)) {

                            $lastMatchPlayedData['last_match_played'] = 'true';
                            // DB::table('matchplayers')->where('matchkey', $match_id)->where('sport_type', 1)->where('playerid', $findplayerexist->id)->update($lastMatchPlayedData);
                          } else {
                            $lastMatchPlayedData['last_match_played'] = 'false';
                            // DB::table('matchplayers')->where('matchkey', $match_id)->where('sport_type', 1)->where('playerid', @$findplayerexist->id)->update($lastMatchPlayedData);
                          }
                          // if(!empty($findplayerexist)){
                          //     if(!$findLastMatchPlayersTeam1->isEmpty()){
                          //         $lastMatchPlayedData['last_match_played'] = 'true';
                          //         DB::table('matchplayers')->where('matchkey', $findLastMatchTeam1->matchkey)->where('playerid',$findplayerexist->id)->update($lastMatchPlayedData);
                          //     }else{
                          //       $lastMatchPlayedData['last_match_played'] = 'false';
                          //       DB::table('matchplayers')->where('matchkey', $findLastMatchTeam1->matchkey)->where('playerid',$findplayerexist->id)->update($lastMatchPlayedData);
                          //     }
                          //   }
                        }
                      }
                    }
                  }
                }
              }
            }
          } //die;

        }

        break;
    }
  }



  public function update_fantasy_credit($matchkey)
  {
    $credit_details = CricketapiController::getmatchcredit($matchkey);
    $data = @$credit_details['data'];
    if (!empty($data)) {
      $findmatchexist = DB::table('listmatches')->where('matchkey', $matchkey)->select('team1', 'team2')->first();
      $fantasy_points = @$data['fantasy_points']; //print_r($fantasy_points);
      if (!empty($fantasy_points)) {
        foreach ($fantasy_points as $key => $value) {
          $player = $value['player'];
          $credit = $value['credit_value'];

          $findp1 = DB::table('players')->where('player_key', $player)->where('team', $findmatchexist->team1)->first();
          if (empty($findp1)) {
            $findp1 = DB::table('players')->where('player_key', $player)->where('team', $findmatchexist->team2)->first();
          }

          if (!empty($findp1)) {
            $player_id = $findp1->id;

            DB::table('matchplayers')->where('matchkey', $matchkey)->where('playerid', $player_id)->update(array("credit" => $credit));
            $findIsSecondInning = DB::table('listmatches')->where('matchkey', $matchkey)->where('second_inning_allow', 1)->first();
            if (!empty($findIsSecondInning)) {
              DB::table('matchplayers')->where('matchkey', $matchkey . "_2")->where('playerid', $player_id)->update(array("credit" => $credit));
            }
          }
        }
      }
    }
    return true;
  }

  public function update_fantasy_credit_football($matchkey)
  {
    $credit_details = FootballController::getmatchcredit($matchkey);
    $data = @$credit_details['data'];
    if (!empty($data)) {
      $findmatchexist = DB::table('listmatches')->where('matchkey', $matchkey)->select('team1', 'team2')->first();
      $fantasy_points = @$data['fantasy']['credits']; //print_r($fantasy_points);
      if (!empty($fantasy_points)) {
        foreach ($fantasy_points as $key => $value) {
          $player = $value['player_key'];
          $credit = $value['credits'];

          $findp1 = DB::table('players')->where('player_key', $player)->where('team', $findmatchexist->team1)->first();
          if (empty($findp1)) {
            $findp1 = DB::table('players')->where('player_key', $player)->where('team', $findmatchexist->team2)->first();
          }

          if (!empty($findp1)) {
            $player_id = $findp1->id;

            DB::table('matchplayers')->where('matchkey', $matchkey)->where('playerid', $player_id)->update(array("credit" => $credit));
          }
        }
      }
    }
    return true;
  }

  public function importdatafromapi()
  {
    //$getdayslist = CricketapiController::getscedulematches();
    date_default_timezone_set('Asia/Kolkata');
    $getdayslist = CricketapiController::recentmatches();
    if (!empty($getdayslist)) {
      foreach ($getdayslist  as $daylist) {
        //$getlist = $daylist['matches'];
        $getli = $daylist;
        if (!empty($getli)) {
          // foreach($getlist as $getli){
          $matchdate = date('Y-m-d H:i:s', strtotime($getli['start_date']['iso']));
          $matchadata = array();
          $findmatchexist = DB::table('listmatches')->where('matchkey', $getli['key'])->first();
          if (empty($findmatchexist)) {
            //find squad details//
            $findsquaddetials = CricketapiController::getmatchdetails($getli['key']);
            if (!empty($findsquaddetials)) {
              $squadteam1players = array();
              $squadteam2players = array();
              if (isset($findsquaddetials['data']['card']['teams']['a']['match']['players'])) {
                $squadteam1players = $findsquaddetials['data']['card']['teams']['a']['match']['players'];
              }
              if (isset($findsquaddetials['data']['card']['teams']['b']['match']['players'])) {
                $squadteam2players = $findsquaddetials['data']['card']['teams']['b']['match']['players'];
              }
              if ((!empty($squadteam1players)) && (!empty($squadteam2players))) {
                $matchadata['squadstatus'] = 'yes';
              }
            }
            // team details update//
            $team1key = $getli['teams']['a']['key'];
            $team2key = $getli['teams']['b']['key'];
            // insert team 1//
            $findteam1 = DB::table('teams')->where('team_key', $team1key)->select('id')->first();
            if (empty($findteam1)) {
              $data['team_key'] = $team1key;
              $data['team'] = $getli['teams']['a']['name'];
              $data['short_name'] = $team1key;
              $team1id = DB::table('teams')->insertGetId($data);
            } else {
              $team1id = $findteam1->id;
            }
            // insert team 2//
            $findteam2 = DB::table('teams')->where('team_key', $team2key)->select('id')->first();
            if (empty($findteam2)) {
              $data1['team_key'] = $team2key;
              $data1['team'] = $getli['teams']['b']['name'];
              $data1['short_name'] = $team2key;
              $team2id = DB::table('teams')->insertGetId($data1);
            } else {
              $team2id = $findteam2->id;
            }
            // insert match data//
            $matchadata['status'] = $getli['status'];
            $matchadata['name'] = $getli['name'];
            $matchadata['short_name'] = $getli['short_name'];
            $matchadata['season'] = $getli['season']['name'];
            $matchadata['title'] = $getli['title'];
            $matchadata['format'] = $getli['format'];
            $matchadata['team1'] = $team1id;
            $matchadata['team2'] = $team2id;
            $matchadata['team1display'] = $getli['teams']['a']['key'];
            $matchadata['team2display'] = $getli['teams']['b']['key'];
            $matchadata['matchkey'] = $getli['key'];
            $matchdate = date('Y-m-d H:i:s', strtotime($getli['start_date']['iso']));
            $cuurectdate = Carbon::parse($matchdate)->addHours(5)->addMinutes(30);
            $matchadata['start_date'] = $matchdate;
            DB::table('listmatches')->insert($matchadata);
          }
          // }
        }
      }
    }
    return redirect()->action('App\Http\Controllers\Admin\MatchesController@matchmapping');
  }


  public function importFootballMatches()
  {
    $tournament = FootballController::get_tournament_matches();
    $tournament = $tournament['data']['tournaments'];
    foreach ($tournament as $key => $value) {
      $series_name = $value['name'];
      $tournament_key = $value['key'];
      $rounds = @$value['rounds'] ? $value['rounds'] : array();
      foreach ($rounds as $key2 => $value2) {
        $matches = $value2['matches'];
        if (!empty($matches)) {
          foreach ($matches as $key3 => $value3) { //print_r($value3); exit;
            if ($value3['match']['status'] != 'completed') {
              $match_key = $value3['match']['key'];

              $findmatchexist = DB::table('listmatches')->where('matchkey', $match_key)->first();
              if (empty($findmatchexist)) {
                $team1 = $value3['match']['home'];
                $team2 = $value3['match']['away'];
                $team1_details = DB::table('teams')->where('team_key', $team1)->first();

                // $match = FootballController::getmatchdetails($match_key);
                // print_r($team); exit;
                // $team = $match['data']['teams'][$team1];
                $team_name = '';
                $team1display = '';
                if (empty($team1_details)) {
                  $team_insert_data = array();
                  $team_insert_data['team'] = $team_name;
                  $team_insert_data['team_key'] = $team1;
                  $team_insert_data['short_name'] = $team1display;
                  $team_insert_data['sport_type'] = 2;
                  $team1id = DB::table('teams')->insertGetId($team_insert_data);
                } else {
                  DB::table('teams')->where('id', $team1_details->id)->update(array("short_name" => $team1display));
                  $team1id = $team1_details->id;
                  $team1display = $team1_details->short_name;
                }

                $team2_details = DB::table('teams')->where('team_key', $team2)->first();
                // $match = FootballController::getmatchdetails($match_key);
                // print_r($team); exit;
                // $team = $match['data']['teams'][$team2];
                $team_name = '';
                $team2display = '';
                if (empty($team2_details)) {
                  $team_insert_data = array();
                  $team_insert_data['team'] = $team_name;
                  $team_insert_data['team_key'] = $team2;
                  $team_insert_data['short_name'] = $team2display;
                  $team_insert_data['sport_type'] = 2;
                  $team2id = DB::table('teams')->insertGetId($team_insert_data);
                } else {
                  DB::table('teams')->where('id', $team2_details->id)->update(array("short_name" => $team2display));
                  $team2id = $team2_details->id;
                  $team2display = $team2_details->short_name;
                }

                //insert match data//
                $matchadata['status'] = 'notstarted';
                $matchadata['name'] = $value3['match']['name'];
                $matchadata['short_name'] = $value3['match']['short_name'];
                $matchadata['season'] = $value3['match']['tournament']['name'];
                $matchadata['title'] = $value3['match']['name'];
                $matchadata['format'] = 'other';
                $matchadata['team1'] = $team1id;
                $matchadata['team2'] = $team2id;
                $matchadata['sport_type'] = 2;
                // $matchadata['team1display'] = $team1display;
                // $matchadata['team2display'] = $team2display;
                $matchadata['matchkey'] = $value3['match']['key'];
                $cuurectdate = date('Y-m-d H:i:s', strtotime('+330 minutes', strtotime($value3['match']['start_date']['gmt'])));
                //$cuurectdate = Carbon::parse($matchdate )->addHours(5)->addMinutes(30);
                $matchadata['start_date'] = $cuurectdate;
                DB::table('listmatches')->insert($matchadata);
              } else if ($findmatchexist->team1display == "TBC A" || $findmatchexist->team2display == "TBC B" || $findmatchexist->status == "notstarted") {
                $team1 = $value3['match']['home'];
                $team2 = $value3['match']['away'];
                $team1_details = DB::table('teams')->where('team_key', $team1)->first();
                // $match = FootballController::getmatchdetails($match_key);
                if ($match_key == '1158671669221527660') {
                  // print_r($match); exit;
                }
                // print_r($match); exit;
                // if(empty($match['data'])) {
                //   continue;
                // }
                // print_r($match); exit;
                // $team = $match['data']['teams'][$team1];
                $team_name = '';
                $team1display = '';
                if (empty($team1_details)) {
                  $team_insert_data = array();
                  $team_insert_data['team'] = $team_name;
                  $team_insert_data['team_key'] = $team1;
                  $team_insert_data['short_name'] = $team1display;
                  $team_insert_data['sport_type'] = 2;
                  $team1id = DB::table('teams')->insertGetId($team_insert_data);
                } else {
                  DB::table('teams')->where('id', $team1_details->id)->update(array("short_name" => $team1display));
                  $team1id = $team1_details->id;
                  $team1display = $team1_details->short_name;
                }

                $team2_details = DB::table('teams')->where('team_key', $team2)->first();
                // $match = FootballController::getmatchdetails($tournament_key,$team1);
                // print_r($team); exit;
                // $team = $match['data']['teams'][$team2];
                $team_name = '';
                $team2display = '';
                if (empty($team2_details)) {
                  $team_insert_data = array();
                  $team_insert_data['team'] = $team_name;
                  $team_insert_data['team_key'] = $team2;
                  $team_insert_data['short_name'] = $team2display;
                  $team_insert_data['sport_type'] = 2;
                  $team2id = DB::table('teams')->insertGetId($team_insert_data);
                } else {
                  DB::table('teams')->where('id', $team2_details->id)->update(array("short_name" => $team1display));
                  $team2id = $team2_details->id;
                  $team2display = $team2_details->short_name;
                }

                //insert match data//
                $matchadata['status'] = 'notstarted';
                $matchadata['name'] = $value3['match']['name'];
                $matchadata['short_name'] = $value3['match']['short_name'];
                $matchadata['season'] = $value3['match']['tournament']['name'];
                $matchadata['title'] = $value3['match']['name'];
                $matchadata['format'] = 'other';
                $matchadata['team1'] = $team1id;
                $matchadata['team2'] = $team2id;
                $matchadata['sport_type'] = 2;
                // $matchadata['team1display'] = $team1display;
                // $matchadata['team2display'] = $team2display;
                $matchadata['matchkey'] = $value3['match']['key'];
                $cuurectdate = date('Y-m-d H:i:s', strtotime('+330 minutes', strtotime($value3['match']['start_date']['gmt'])));
                //$cuurectdate = Carbon::parse($matchdate )->addHours(5)->addMinutes(30);
                $matchadata['start_date'] = $cuurectdate;
                DB::table('listmatches')->where('id', $findmatchexist->id)->update($matchadata);
              }
            }
          }
        }
      }
    }
  }


  public function get_matches($sport_type = CRICKET)
  {
    date_default_timezone_set('Asia/Kolkata');
    $sportType =  DB::table('sport_types')->where('sport_key', $sport_type)->first();
    switch ($sport_type) {
      /* xxxxxxxxxxxxxxxx  KABADDI NEW SPORTS xxxxxxxxxxxxxxxxxxx  */
      case 'KABADDI': {
          $matchlist = KabaddiController::getMatches();
          //  echo "<pre>"; print_r($matchlist); exit;
          if (!empty($matchlist)) {
            foreach ($matchlist as $key => $value) {
              // echo "<pre>"; print_r($value); exit;
              $match_id = $matchkey = $value->mid;
              $name = $value->teams->home->tname . ' VS ' . $value->teams->away->tname;
              $short_name = $value->teams->home->shortname . ' VS ' . $value->teams->away->shortname;
              $season = @$value->competition->cname;

              $comp_id = $value->competition->cid;
              $title = $value->teams->home->tname . ' VS ' . $value->teams->away->tname;
              $format = $value->round;
              //Get Series
              $season = $value->competition->cname;
              $comp_id = $value->competition->cid;
              $cid = $comp_id;
              $created_at = date('Y-m-d H:i:s');
              $series_data = array();
              $series_data['cid'] = $value->competition->cid;
              // $series_data['name'] = $value->competition->cname;
              $series_data['start_date'] = $value->competition->startdate;
              $series_data['end_date'] = $value->competition->enddate;
              $series_data['sort'] = '0';
              $series_data['is_leaderboard'] = '0';
              $series_data['is_leaderboard_win_distribute'] = '0';
              $series_data['slug'] = '0';
              $series_data['series_status'] = (strtolower($value->competition->status) == 'live') ? 'opened' : 'opened';
              $series_data['sport_type'] = 7;
              $series_data['created_at'] = $created_at;
              $series_detail = DB::table('series')->where('cid', $cid)->first();

              if (empty($series_detail)) {
                $series_data['name'] = $value->competition->cname;
                $ser_id =   DB::table('series')->insertGetId($series_data);
              } else {
                $ser_id = $series_detail->id;
                DB::table('series')->where('cid', $cid)->update($series_data);
              }
              //End Series


              //Get Teams
              $team1key = $value->teams->home->tid;
              $team2key = $value->teams->away->tid;
              //Get Team1
              $team1_detail = DB::table('teams')->where('team_key', $team1key)->where('sport_type', $sportType->id)->first();
              if (empty($team1_detail)) {
                $team1 = array();
                $team1['team'] = $value->teams->home->tname;
                $team1['logo'] = $value->teams->home->logo;
                $team1['team_key'] = $team1key;
                $team1['short_name'] = $value->teams->home->shortname;

                $team1['sport_type'] = $sportType->id;
                $team1['color'] = '';
                $team1['created_at'] = date('Y-m-d H:i:s');
                $team1id = DB::table('teams')->insertGetId($team1);
                $team1display = $value->teams->home->shortname;
              } else {
                $team1 = array();
                $team1['short_name'] = $value->teams->home->shortname;
                $team1['logo'] = $value->teams->home->logo;
                DB::table('teams')->where('team_key', $team1key)->where('sport_type', 7)->update($team1);
                $team1id = $team1_detail->id;
                $team1display = $team1_detail->short_name;
              }

              //Get Team2
              $team2_detail = DB::table('teams')->where('team_key', $team2key)->where('sport_type', $sportType->id)->first();
              if (empty($team2_detail)) {
                $team2 = array();
                $team2['team'] = $value->teams->away->tname;
                $team2['logo'] = $value->teams->away->logo;
                $team2['team_key'] = $team2key;
                $team2['short_name'] = $value->teams->away->shortname;
                $team2['sport_type'] = $sportType->id;
                $team2['color'] = '';
                $team2['created_at'] = date('Y-m-d H:i:s');
                $team2id = DB::table('teams')->insertGetId($team2);
                $team2display = $value->teams->away->shortname;
              } else {
                $team2 = array();
                $team2['short_name'] = $value->teams->away->shortname;
                $team2['logo'] = $value->teams->away->logo;
                DB::table('teams')->where('team_key', $team2key)->where('sport_type', 7)->update($team2);
                $team2id = $team2_detail->id;
                $team2display = $team2_detail->short_name;
              }

              $series = 0;
              $start_date = date('Y-m-d H:i:s', strtotime('+330 minutes', strtotime($value->datestart)));
              $status = 'notstarted';
              $launch_status = 'pending';
              $final_status = 'pending';
              $created_at = date('Y-m-d H:i:s');
              $match_detail = DB::table('listmatches')->where('matchkey', $match_id)->where('sport_type', $sportType->id)->first();
              if (empty($match_detail)) {
                $match_data = array();
                $match_data['name'] = $name;
                $match_data['sport_type'] = (isset($sportType->id) ? $sportType->id : null);
                $match_data['short_name'] = $short_name;
                $match_data['season'] = $season;
                $match_data['title'] = $title;
                $match_data['format'] = $format;
                $match_data['team1'] = $team1id;
                $match_data['team2'] = $team2id;
                $match_data['team1display'] = $team1display;
                $match_data['team2display'] = $team2display;
                $match_data['matchkey'] = $matchkey;
                $match_data['series'] = $ser_id;
                $match_data['start_date'] = $start_date;
                $match_data['status'] = $status;
                $match_data['launch_status'] = $launch_status;
                $match_data['final_status'] = $final_status;
                $match_data['competition_id'] = $comp_id;
                $match_data['created_at'] = $created_at;
                //print_r($match_data); exit;
                DB::table('listmatches')->insert($match_data);
              } elseif ($match_detail->launch_status == 'pending' || ($match_detail->launch_status == 'launched' && $match_detail->status == 'notstarted')) {
                $match_data['name'] = $name;
                $match_data['short_name'] = $short_name;
                $match_data['sport_type'] = (isset($sportType->id) ? $sportType->id : null);
                $match_data['season'] = $season;
                $match_data['title'] = $title;
                $match_data['format'] = $format;
                $match_data['team1'] = $team1id;
                $match_data['team2'] = $team2id;
                $match_data['team1display'] = $team1display;
                $match_data['team2display'] = $team2display;
                $match_data['matchkey'] = $matchkey;
                $match_data['series'] = $match_detail->series;
                // $match_data['start_date'] = $start_date;
                $match_data['start_date'] = $match_detail->start_date;
                $match_data['status'] = $match_detail->status;
                $match_data['launch_status'] = $match_detail->launch_status;
                $match_data['final_status'] = $match_detail->final_status;
                $match_data['competition_id'] = $comp_id;
                $match_data['created_at'] = $created_at;
                DB::table('listmatches')->where('matchkey', $match_id)->where('sport_type', $sportType->id)->update($match_data);

                // if($value->pre_squad=='true') {
                // $this->import_match_squad($match_id, $comp_id,$sport_type);
                // }
              }
            }
          } else {
            Session::flash('alert-class', 'alert-danger');
            Session::flash('error', 'Api is not Provide data!');
            Helpers::logActivity('Api is not Provide data!', $sport_type);
            return Redirect::back();
          }
          break;
        }
        /*  xxxxxxxxxxxxxxxx  KABADDI NEW SPORTS xxxxxxxxxxxxxxxxxxx    */
      case FOOTBALL: {
          /*$this->importFootballMatches();
                    return Redirect::back();
                    die();*/
          $matchlist = FootballController::getMatches();
          if (!empty($matchlist)) {
            foreach ($matchlist as $key => $value) { //print_r($value); exit;
              $match_id = $matchkey = $value->mid;
              $name = $value->teams->home->tname . ' VS ' . $value->teams->away->tname;
              $short_name = $value->teams->home->abbr . ' VS ' . $value->teams->away->abbr;
              $season = $value->competition->cname;
              $comp_id = $value->competition->cid;
              $title = $value->teams->home->tname . ' VS ' . $value->teams->away->tname;
              $format = $value->round;
              /* If we need to manage round then we use this things.
                        if($format==1) {
                            $format = 'one-day';
                        } else if($format==3 || $format==6 || $format==8 || $format==10) {
                            $format = 't20';
                        } else if($format==2) {
                            $format = 'test';
                        } else {
                            $format = 'other';
                        }
                        */
              //Get Series

              $cid = $comp_id;
              $created_at = date('Y-m-d H:i:s');
              $series_data = array();

              $series_data['cid'] = $value->competition->cid;

              $series_data['start_date'] = $value->competition->startdate;

              $series_data['end_date'] = $value->competition->enddate;

              $series_data['sort'] = '0';

              $series_data['is_leaderboard'] = '0';

              $series_data['is_leaderboard_win_distribute'] = '0';

              $series_data['slug'] = '0';

              $series_data['series_status'] = (strtolower($value->competition->status_str) == 'live') ? 'opened' : '';

              $series_data['sport_type'] = (isset($sportType->id) ? $sportType->id : null);

              $series_data['created_at'] = $created_at;
              $series_detail = DB::table('series')->where('cid', $cid)->first();
              if (empty($series_detail)) {
                $series_data['name'] = $value->competition->cname;
                $s_id = DB::table('series')->insertGetId($series_data);
              } else {
                $s_id = $series_detail->id;
                DB::table('series')->where('cid', $cid)->update($series_data);
              }
              //End Series
              //Get Teams
              $team1key = $value->teams->home->tid;
              $team2key = $value->teams->away->tid;
              //Get Team1
              $team1_detail = DB::table('teams')->where('team_key', $team1key)->where('sport_type', $sportType->id)->first();
              if (empty($team1_detail)) {
                $team1 = array();
                $team1['team'] = $value->teams->home->tname;
                $team1['logo'] = $value->teams->home->logo;
                $team1['team_key'] = $team1key;
                $team1['short_name'] = $value->teams->home->abbr;

                $team1['sport_type'] = $sportType->id;
                $team1['color'] = '';
                $team1['created_at'] = date('Y-m-d H:i:s');
                $team1id = DB::table('teams')->insertGetId($team1);
                $team1display = $value->teams->home->abbr;
              } else {
                $team1id = $team1_detail->id;
                $team1display = $team1_detail->short_name;
              }

              //Get Team2
              $team2_detail = DB::table('teams')->where('team_key', $team2key)->where('sport_type', $sportType->id)->first();
              if (empty($team2_detail)) {
                $team2 = array();
                $team2['team'] = $value->teams->away->tname;
                $team2['logo'] = $value->teams->away->logo;
                $team2['team_key'] = $team2key;
                $team2['short_name'] = $value->teams->away->abbr;
                $team2['sport_type'] = $sportType->id;
                $team2['color'] = '';
                $team2['created_at'] = date('Y-m-d H:i:s');
                $team2id = DB::table('teams')->insertGetId($team2);
                $team2display = $value->teams->away->abbr;
              } else {
                $team2id = $team2_detail->id;
                $team2display = $team2_detail->short_name;
              }

              $series = 0;
              $start_date = date('Y-m-d H:i:s', strtotime('+330 minutes', strtotime($value->datestart)));
              $status = 'notstarted';
              $launch_status = 'pending';
              $final_status = 'pending';
              $created_at = date('Y-m-d H:i:s');
              $match_detail = DB::table('listmatches')->where('matchkey', $match_id)->where('sport_type', $sportType->id)->first();
              if (empty($match_detail)) {
                $match_data = array();
                $match_data['name'] = $name;
                $match_data['sport_type'] = (isset($sportType->id) ? $sportType->id : null);
                $match_data['short_name'] = $short_name;
                $match_data['season'] = $season;
                $match_data['title'] = $title;
                $match_data['format'] = $format;
                $match_data['team1'] = $team1id;
                $match_data['team2'] = $team2id;
                $match_data['team1display'] = $team1display;
                $match_data['team2display'] = $team2display;
                $match_data['matchkey'] = $matchkey;
                $match_data['series'] =  $s_id;
                $match_data['start_date'] = $start_date;
                $match_data['status'] = $status;
                $match_data['launch_status'] = $launch_status;
                $match_data['final_status'] = $final_status;
                $match_data['competition_id'] = $comp_id;
                $match_data['created_at'] = $created_at; //print_r($match_data); exit;
                DB::table('listmatches')->insert($match_data);
              } elseif ($match_detail->launch_status == 'pending' || ($match_detail->launch_status == 'launched' && $match_detail->status == 'notstarted')) {
                $match_data['name'] = $name;
                $match_data['short_name'] = $short_name;
                $match_data['sport_type'] = (isset($sportType->id) ? $sportType->id : null);
                $match_data['season'] = $season;
                $match_data['title'] = $title;
                $match_data['format'] = $format;
                $match_data['team1'] = $team1id;
                $match_data['team2'] = $team2id;
                $match_data['team1display'] = $team1display;
                $match_data['team2display'] = $team2display;
                $match_data['matchkey'] = $matchkey;
                $match_data['series'] = $match_detail->series;
                $match_data['start_date'] = $match_detail->start_date;
                $match_data['status'] = $match_detail->status;
                $match_data['launch_status'] = $match_detail->launch_status;
                $match_data['final_status'] = $match_detail->final_status;
                $match_data['competition_id'] = $comp_id;
                $match_data['created_at'] = $created_at;
                DB::table('listmatches')->where('matchkey', $match_id)->update($match_data);

                if ($value->pre_squad == 'true') {
                  // $this->import_match_squad($match_id, $comp_id,$sport_type);
                }
              }
            }
          } else {
            Session::flash('flash_notice', 'FOOTBALL data not import plz check api');
            return Redirect::back();
          }
          break;
        }
      case BASKETBALL: {
          $matchlist = BasketBallController::getMatches();

          if (!empty($matchlist)) {
            foreach ($matchlist as $key => $value) {
              $match_id = $matchkey = $value->mid;
              if ($match_id == 16830) {
              }
              $name = $value->teams->home->tname . ' VS ' . $value->teams->away->tname;
              $short_name = $value->teams->home->abbr . ' VS ' . $value->teams->away->abbr;
              $season = $value->competition->cname;
              $comp_id = $value->competition->cid;
              $title = $value->teams->home->tname . ' VS ' . $value->teams->away->tname;
              $format = $value->round->round;
              /* If we need to manage round then we use this things.
                        if($format==1) {
                            $format = 'one-day';
                        } else if($format==3 || $format==6 || $format==8 || $format==10) {
                            $format = 't20';
                        } else if($format==2) {
                            $format = 'test';
                        } else {
                            $format = 'other';
                        }
                        */
              //Get Series

              $cid = $comp_id;

              $created_at = date('Y-m-d H:i:s');
              $series_data = array();

              $series_data['cid'] = $value->competition->cid;

              $series_data['start_date'] = $value->competition->startdate;

              $series_data['end_date'] = $value->competition->enddate;

              $series_data['sort'] = '0';

              $series_data['is_leaderboard'] = '0';

              $series_data['is_leaderboard_win_distribute'] = '0';

              $series_data['slug'] = '0';

              $series_data['series_status'] = (strtolower($value->competition->status_str) == 'live') ? 'opened' : '';

              $series_data['sport_type'] = (isset($sportType->id) ? $sportType->id : null);

              $series_data['created_at'] = $created_at;
              $series_detail = DB::table('series')->where('cid', $cid)->first();
              if (empty($series_detail)) {
                $series_data['name'] = $value->competition->cname;
                DB::table('series')->insert($series_data);
              } else {
                DB::table('series')->where('cid', $cid)->update($series_data);
              }
              //End Series
              //Get Teams
              $team1key = $value->teams->home->tid;
              $team2key = $value->teams->away->tid;
              //Get Team1
              $team1_detail = DB::table('teams')->where('team_key', $team1key)->where('sport_type', $sportType->id)->first();
              if (empty($team1_detail)) {
                $team1 = array();
                $team1['team'] = $value->teams->home->tname;
                $team1['logo'] = '';
                $team1['team_key'] = $team1key;
                $team1['short_name'] = $value->teams->home->abbr;
                $team1['sport_type'] = $sportType->id;
                $team1['color'] = '';
                $team1['created_at'] = date('Y-m-d H:i:s');
                $team1id = DB::table('teams')->insertGetId($team1);
                $team1display = $value->teams->home->abbr;
              } else {
                $team1id = $team1_detail->id;
                $team1display = $team1_detail->short_name;
              }

              //Get Team2
              $team2_detail = DB::table('teams')->where('team_key', $team2key)->where('sport_type', $sportType->id)->first();
              if (empty($team2_detail)) {
                $team2 = array();
                $team2['team'] = $value->teams->away->tname;
                $team2['logo'] = '';
                $team2['team_key'] = $team2key;
                $team2['short_name'] = $value->teams->away->abbr;
                $team2['sport_type'] = $sportType->id;
                $team2['color'] = '';
                $team2['created_at'] = date('Y-m-d H:i:s');
                $team2id = DB::table('teams')->insertGetId($team2);
                $team2display = $value->teams->away->abbr;
              } else {
                $team2id = $team2_detail->id;
                $team2display = $team2_detail->short_name;
              }

              $series = 0;
              $start_date = date('Y-m-d H:i:s', strtotime('+330 minutes', strtotime($value->datestart)));
              $status = 'notstarted';
              $launch_status = 'pending';
              $final_status = 'pending';
              $created_at = date('Y-m-d H:i:s');
              $match_detail = DB::table('listmatches')->where('matchkey', $match_id)->where('sport_type', $sportType->id)->first();
              if (empty($match_detail)) {
                $match_data = array();
                $match_data['name'] = $name;
                $match_data['sport_type'] = (isset($sportType->id) ? $sportType->id : null);
                $match_data['short_name'] = $short_name;
                $match_data['season'] = $season;
                $match_data['title'] = $title;
                $match_data['format'] = $format;
                $match_data['team1'] = $team1id;
                $match_data['team2'] = $team2id;
                $match_data['team1display'] = $team1display;
                $match_data['team2display'] = $team2display;
                $match_data['matchkey'] = $matchkey;
                $match_data['series'] = 0;
                $match_data['start_date'] = $start_date;
                $match_data['status'] = $status;
                $match_data['launch_status'] = $launch_status;
                $match_data['final_status'] = $final_status;
                $match_data['competition_id'] = $comp_id;
                $match_data['created_at'] = $created_at;
                DB::table('listmatches')->insert($match_data);
              } elseif ($match_detail->launch_status == 'pending' || ($match_detail->launch_status == 'launched' && $match_detail->status == 'notstarted')) {
                $match_data['name'] = $name;
                $match_data['short_name'] = $short_name;
                $match_data['sport_type'] = (isset($sportType->id) ? $sportType->id : null);
                $match_data['season'] = $season;
                $match_data['title'] = $title;
                $match_data['format'] = $format;
                $match_data['team1'] = $team1id;
                $match_data['team2'] = $team2id;
                $match_data['team1display'] = $team1display;
                $match_data['team2display'] = $team2display;
                $match_data['matchkey'] = $matchkey;
                $match_data['series'] = $match_detail->series;
                // $match_data['start_date'] = $start_date;
                $match_data['start_date'] = $match_detail->start_date;
                $match_data['status'] = $match_detail->status;
                $match_data['launch_status'] = $match_detail->launch_status;
                $match_data['final_status'] = $match_detail->final_status;
                $match_data['competition_id'] = $comp_id;
                $match_data['created_at'] = $created_at;
                DB::table('listmatches')->where('matchkey', $match_id)->update($match_data);
              }
              if ($value->presquad == 'true') {
                // $this->import_match_squad($match_id, $comp_id,$sport_type);
              }
            }
          } else {
            Session::flash('flash_notice', 'BASKETBALL data not import plz check api');
            return Redirect::back();
          }
          break;
        }
      default: {
          $matchlist = Cricketapi2Controller::getMatches();
          // echo '<pre>';
          // print_r($matchlist);die;
          if (!empty($matchlist)) {
            foreach ($matchlist as $key => $value) {
              $match_id = $matchkey = $value->match_id;

              $name = $value->title;

              $short_name = $value->teama->short_name . ' VS ' . $value->teamb->short_name;

              $season = $value->competition->title;

              $comp_id = $value->competition->cid;

              $title = $value->title;

              $format = $value->format;
              if ($format == 1 || $format == 4 || $format == 5 || $format == 7 || $format == 9) {
                $format = 'one-day';
              } else if ($format == 3 || $format == 6 || $format == 8 || $format == 10) {
                $format = 't20';
              } else if ($format == 17) {
                $format = 't10';
              } else if ($format == 2) {
                $format = 'test';
              } else if ($format == '100-ball') {
                $format = 'hundred';
              } else {
                $format = 'other';
              }

              //Get series
              $cid = $comp_id;

              $created_at = date('Y-m-d H:i:s');
              // $launch_status = 'pending';


              $series_data = array();

              $series_data['cid'] = $value->competition->cid;

              $series_data['start_date'] = $value->competition->datestart;

              $series_data['end_date'] = $value->competition->dateend;

              $series_data['sort'] = '0';

              //$series_data['is_leaderboard'] = '0';//'1';

              $series_data['is_leaderboard_win_distribute'] = '0';

              $series_data['slug'] = '0';

              $series_data['series_status'] = (strtolower($value->competition->status) == 'live') ? 'opened' : 'opened';

              $series_data['sport_type'] = (isset($sportType->id) ? $sportType->id : null);

              $series_data['created_at'] = $created_at;
              $series_detail = DB::table('series')->where('cid', $cid)->first();
              if (empty($series_detail)) {
                $series_data['name'] = $value->competition->title;
                DB::table('series')->insert($series_data);
                $series_detail = DB::table('series')->where('name', $value->competition->title)->first();
              } else {
                DB::table('series')->where('cid', $cid)->update($series_data);
              }

              //End sseries
              //Get Teams
              $team1key = $value->teama->team_id;
              $team2key = $value->teamb->team_id;
              //Get Team1
              $team1_detail = DB::table('teams')->where('team_key', $team1key)->where('sport_type', "1")->first();
              if (empty($team1_detail)) {
                $team1 = array();
                $team1['team'] = $value->teama->name;
                $team1['logo'] = @$value->teama->logo_url;

                $team1['team_key'] = $team1key;
                $team1['sport_type'] = $sportType->id;
                $team1['short_name'] = $value->teama->short_name;
                $team1['color'] = '';
                $team1['created_at'] = date('Y-m-d H:i:s');
                $team1id = DB::table('teams')->insertGetId($team1);

                $team1display = $value->teama->short_name;
              } else {
                $team1id = $team1_detail->id;
                $team1display = $team1_detail->short_name;
                if (empty($team1_detail->logo)) {
                  $team1 = array();
                  $team1['logo'] = @$value->teama->logo_url;
                  DB::table('teams')->where('id', $team1id)->update($team1);
                }
              }
              //Get Team2
              $team2_detail = DB::table('teams')->where('team_key', $team2key)->where('sport_type', "1")->first();

              if (empty($team2_detail)) {

                $team2 = array();

                $team2['team'] = $value->teamb->name;

                $team2['logo'] = @$value->teamb->logo_url;

                $team2['team_key'] = $team2key;
                $team2['sport_type'] = $sportType->id;

                $team2['short_name'] = $value->teamb->short_name;

                $team2['color'] = '';

                $team2['created_at'] = date('Y-m-d H:i:s');

                $team2id = DB::table('teams')->insertGetId($team2);

                $team2display = $value->teamb->short_name;
              } else {
                $team2id = $team2_detail->id;
                $team2display = $team2_detail->short_name;
                if (empty($team2_detail->logo)) {
                  $team2 = array();
                  $team2['logo'] = @$value->teamb->logo_url;
                  DB::table('teams')->where('id', $team2id)->update($team2);
                }
              }



              $series = 0;

              $start_date = date('Y-m-d H:i:s', strtotime('+330 minutes', strtotime($value->date_start)));

              $status = 'notstarted';

              $launch_status = 'pending';

              $final_status = 'pending';

              $final_status = 'pending';

              $created_at = date('Y-m-d H:i:s');


              $sportType =  DB::table('sport_types')->where('sport_key', $sport_type)->first();
              $match_detail = DB::table('listmatches')->where('matchkey', $match_id)->where('sport_type', $sportType->id)->first();

              if (empty($match_detail)) {

                $match_data = array();

                $match_data['name'] = $name;
                $match_data['sport_type'] = (isset($sportType->id) ? $sportType->id : null);

                $match_data['short_name'] = $short_name;

                $match_data['season'] = $season;

                $match_data['title'] = $title;

                $match_data['format'] = $format;

                $match_data['team1'] = $team1id;

                $match_data['team2'] = $team2id;

                $match_data['team1display'] = $team1display;

                $match_data['team2display'] = $team2display;

                $match_data['matchkey'] = $matchkey;

                $match_data['series'] =  $series_detail->id;

                $match_data['start_date'] = $start_date;

                $match_data['status'] = $status;

                $match_data['launch_status'] = $launch_status;

                $match_data['final_status'] = $final_status;
                $match_data['competition_id'] = $comp_id;

                $match_data['created_at'] = $created_at;

                DB::table('listmatches')->insert($match_data);
              } elseif ($match_detail->launch_status == 'pending') {

                $match_data['name'] = $name;

                $match_data['short_name'] = $short_name;

                $match_data['sport_type'] = (isset($sportType->id) ? $sportType->id : null);
                $match_data['season'] = $season;

                $match_data['title'] = $title;

                $match_data['format'] = $format;

                $match_data['team1'] = $team1id;

                $match_data['team2'] = $team2id;

                $match_data['team1display'] = $team1display;

                $match_data['team2display'] = $team2display;

                $match_data['matchkey'] = $matchkey;

                $match_data['series'] = $match_detail->series;

                $match_data['start_date'] = $match_detail->start_date;
                $match_data['status'] = $match_detail->status;
                $match_data['launch_status'] = $match_detail->launch_status;
                $match_data['final_status'] = $match_detail->final_status;
                $match_data['competition_id'] = $comp_id;

                $match_data['created_at'] = $created_at;

                DB::table('listmatches')->where('matchkey', $match_id)->update($match_data);
              }

              if ($value->pre_squad == 'true') {
                // $this->import_match_squad($match_id, $comp_id);
              }
            }
          } else {
            Session::flash('error', 'Matches Data not Comming from Api....');

            return Redirect::back();
          }
          break;
        }
    }

    Session::flash('flash_notice', 'All Data Import Form Api Successfully!');

    Helpers::logActivity('All Data Import Form Api Successfully!', $sport_type);
    return Redirect::back();
  }

  public function importseasonfromapi()
  {
    $coverage = CricketapiController::get_coverage_v4();
    // print_r($coverage); exit;
    foreach ($coverage['data']['boards'] as $key => $value) {
      $board_key  = $value['key'];
      if ($board_key != 'c.board.ecc.2f218') {
        // continue;
      }
      $seasons = CricketapiController::get_seasons_v4($board_key);
      // print_r($seasons); exit;
      if (!empty(@$seasons['data']['seasons'])) {
        foreach ($seasons['data']['seasons'] as $key2 => $value2) {
          $season_key = $value2['key'];
          if ($season_key != 'c.season.ecsc.21b3b') {
            // continue;
          }
          //$getdayslist = CricketapiController::getscedulematches();
          date_default_timezone_set('Asia/Kolkata');
          $getdayslist = CricketapiController::seasonmatches_new($season_key);
          // print_r($getdayslist);  die;
          if (!empty($getdayslist)) {
            $mdata = $getdayslist['data']; //print_r($data); exit;
            foreach ($getdayslist  as $daylist) {
              $getroundlist = array_reverse($mdata['season']['rounds']);
              foreach ($getroundlist as $key => $value) {
                $getroundgroups = $value['groups'];
                foreach ($getroundgroups as $key2 => $value2) {
                  // print_r($value2); exit;
                  // $getlist = $mdata['intelligent_order']; //print_r($getlist); exit;
                  $getlist = $value2['matches']; //print_r($getlist); exit;
                  if (!empty($getlist)) {
                    foreach ($getlist as $getli) {
                      // $findsquaddetials = CricketapiController::getmatchdetails('c.match.final_match.2edfa');
                      // print_r($findsquaddetials); exit;
                      $matchadata = array();
                      $findmatchexist = DB::table('listmatches')->where('matchkey', $getli)->first();
                      if (empty($findmatchexist)) {
                        //find squad details//
                        $findsquaddetials = CricketapiController::getmatchdetails($getli);
                        // print_r($findsquaddetials); exit;
                        if (!empty($findsquaddetials)) {
                          $squadteam1players = array();
                          $squadteam2players = array();
                          if (isset($findsquaddetials['data']['card']['teams']['a']['match']['players'])) {
                            $squadteam1players = $findsquaddetials['data']['card']['teams']['a']['match']['players'];
                          }
                          if (isset($findsquaddetials['data']['card']['teams']['b']['match']['players'])) {
                            $squadteam2players = $findsquaddetials['data']['card']['teams']['b']['match']['players'];
                          }
                          if ((!empty($squadteam1players)) && (!empty($squadteam2players))) {
                            $matchadata['squadstatus'] = 'yes';
                          } else {
                            $matchadata['squadstatus'] = 'no';
                          }
                        }
                        //team details update//
                        $team1key = $findsquaddetials['data']['card']['teams']['a']['key'];
                        $team2key = $findsquaddetials['data']['card']['teams']['b']['key'];
                        //insert team 1//
                        $findteam1 = DB::table('teams')->where('team_key', $team1key)->select('id')->first();
                        if (empty($findteam1)) {
                          $data['team_key'] = $team1key;
                          $data['team'] = $findsquaddetials['data']['card']['teams']['a']['name']; //print_r($data); exit;
                          $data['short_name'] = $findsquaddetials['data']['card']['teams']['a']['short_name']; //print_r($data); exit;
                          $team1id = DB::table('teams')->insertGetId($data);
                        } else {
                          $team1id = $findteam1->id;
                        }
                        //insert team 2//
                        $findteam2 = DB::table('teams')->where('team_key', $team2key)->select('id')->first();
                        if (empty($findteam2)) {
                          $data1['team_key'] = $team2key;
                          $data1['team'] = $findsquaddetials['data']['card']['teams']['b']['name'];
                          $data1['short_name'] = $findsquaddetials['data']['card']['teams']['b']['short_name'];
                          $team2id = DB::table('teams')->insertGetId($data1);
                        } else {
                          $team2id = $findteam2->id;
                        }
                        //insert match data//
                        $matchadata['status'] = 'notstarted';
                        $matchadata['name'] = $findsquaddetials['data']['card']['name'];
                        $matchadata['short_name'] = $findsquaddetials['data']['card']['short_name'];
                        $matchadata['season'] = $findsquaddetials['data']['card']['season']['name'];
                        $matchadata['title'] = $findsquaddetials['data']['card']['title'];
                        $matchadata['format'] = $findsquaddetials['data']['card']['format'];
                        $matchadata['team1'] = $team1id;
                        $matchadata['team2'] = $team2id;
                        $matchadata['team1display'] = $findsquaddetials['data']['card']['teams']['a']['short_name'];
                        $matchadata['team2display'] = $findsquaddetials['data']['card']['teams']['b']['short_name'];
                        $matchadata['matchkey'] = $findsquaddetials['data']['card']['key'];
                        $cuurectdate = date('Y-m-d H:i:s', strtotime($findsquaddetials['data']['card']['start_date']['iso']));
                        //$cuurectdate = Carbon::parse($matchdate )->addHours(5)->addMinutes(30);
                        $matchadata['start_date'] = $cuurectdate;
                        DB::table('listmatches')->insert($matchadata);
                      } else if ($findmatchexist->team1display == "TBC A" || $findmatchexist->team2display == "TBC B" || $findmatchexist->launch_status == 'pending') {
                        $findsquaddetials = CricketapiController::getmatchdetails($getli);
                        if (!empty($findsquaddetials)) {
                          $squadteam1players = array();
                          $squadteam2players = array();
                          if (isset($findsquaddetials['data']['card']['teams']['a']['match']['players'])) {
                            $squadteam1players = $findsquaddetials['data']['card']['teams']['a']['match']['players'];
                          }
                          if (isset($findsquaddetials['data']['card']['teams']['b']['match']['players'])) {
                            $squadteam2players = $findsquaddetials['data']['card']['teams']['b']['match']['players'];
                          }
                          if ((!empty($squadteam1players)) && (!empty($squadteam2players))) {
                            $matchadata['squadstatus'] = 'yes';
                          } else {
                            $matchadata['squadstatus'] = 'no';
                          }
                        }
                        //team details update//
                        $team1key = $findsquaddetials['data']['card']['teams']['a']['key'];
                        $team2key = $findsquaddetials['data']['card']['teams']['b']['key'];
                        //insert team 1//
                        $findteam1 = DB::table('teams')->where('team_key', $team1key)->select('id')->first();
                        if (empty($findteam1)) {
                          $data['team_key'] = $team1key;
                          $data['team'] = $findsquaddetials['data']['card']['teams']['a']['name'];
                          $data['short_name'] = $findsquaddetials['data']['card']['teams']['a']['short_name'];
                          $team1id = DB::table('teams')->insertGetId($data);
                        } else {
                          DB::table('teams')->where('team_key', $team1key)->update(array("short_name" => $findsquaddetials['data']['card']['teams']['a']['short_name']));
                          $team1id = $findteam1->id;
                        }
                        //insert team 2//
                        $findteam2 = DB::table('teams')->where('team_key', $team2key)->select('id')->first();
                        if (empty($findteam2)) {
                          $data1['team_key'] = $team2key;
                          $data1['team'] = $findsquaddetials['data']['card']['teams']['b']['name'];
                          $data1['short_name'] = $findsquaddetials['data']['card']['teams']['b']['short_name'];
                          $team2id = DB::table('teams')->insertGetId($data1);
                        } else {
                          DB::table('teams')->where('team_key', $team2key)->update(array("short_name" => $findsquaddetials['data']['card']['teams']['b']['short_name']));
                          $team2id = $findteam2->id;
                        }
                        //update match data//
                        $matchadata['status'] = $findsquaddetials['data']['card']['status'];
                        $matchadata['name'] = $findsquaddetials['data']['card']['name'];
                        $matchadata['short_name'] = $findsquaddetials['data']['card']['short_name'];
                        $matchadata['season'] = $findsquaddetials['data']['card']['season']['name'];
                        $matchadata['title'] = $findsquaddetials['data']['card']['title'];
                        $matchadata['format'] = $findsquaddetials['data']['card']['format'];
                        $matchadata['team1'] = $team1id;
                        $matchadata['team2'] = $team2id;
                        $matchadata['team1display'] = $findsquaddetials['data']['card']['teams']['a']['short_name'];
                        $matchadata['team2display'] = $findsquaddetials['data']['card']['teams']['b']['short_name'];
                        $matchadata['matchkey'] = $findsquaddetials['data']['card']['key'];
                        $cuurectdate = date('Y-m-d H:i:s', strtotime($findsquaddetials['data']['card']['start_date']['iso']));
                        //$cuurectdate = Carbon::parse($matchdate )->addHours(5)->addMinutes(30);
                        $matchadata['start_date'] = $cuurectdate;
                        DB::table('listmatches')->where('matchkey', $findsquaddetials['data']['card']['key'])->update($matchadata);
                      }
                      // $this->importsquad($getli, 'CRICKET');
                    }
                  }
                }
              }
            }
          }
        }
      }
    }
    // return redirect::back();
  }


  public function importseasonfromapi_me()
  {
    $coverage = CricketapiController::get_coverage_v4();
    // print_r($coverage); exit;
    $coverage = array_reverse($coverage);
    foreach ($coverage['data']['boards'] as $key => $value) {
      $board_key  = $value['key'];
      if ($board_key != 'c.board.ecc.2f218') {
        // continue;
      }
      $seasons = CricketapiController::get_seasons_v4($board_key);
      // print_r($seasons); exit;
      if (!empty(@$seasons['data']['seasons'])) {
        foreach ($seasons['data']['seasons'] as $key2 => $value2) {
          $season_key = $value2['key'];
          // $season_key = 'c.season.hmc2021.19c81';
          // $season_key = 'c.season.hwc.56651';
          // $season_key = 'c.season.cntc.b2f8f';
          if ($season_key != 'c.season.hmc2021.19c81') {
            // continue;
          }
          //$getdayslist = CricketapiController::getscedulematches();
          date_default_timezone_set('Asia/Kolkata');
          $getdayslist = CricketapiController::seasonmatches($season_key);
          // print_r($getdayslist);  die;
          if (!empty($getdayslist)) {
            $mdata = $getdayslist['data']; //print_r($mdata); exit;
            // foreach($getdayslist  as $daylist){
            // $getroundlist = array_reverse($mdata['season']['rounds']);
            // foreach ($getroundlist as $key => $value) {
            // $getroundgroups = $value['groups'];
            // foreach ($getroundgroups as $key2 => $value2) {
            // print_r($value2); exit;
            $getlist = $mdata['cards']; //print_r($getlist); exit;
            // $getlist = $value2['matches']; //print_r($getlist); exit;
            if (!empty($getlist)) {
              foreach ($getlist as $getli) {
                // if($getli['format']=='100-ball') {
                // print_r($getli);
                // }
                $matchadata = array();
                $findmatchexist = DB::table('listmatches')->where('matchkey', $getli['key'])->first();
                if (empty($findmatchexist)) {
                  //find squad details//
                  // $findsquaddetials = CricketapiController::getmatchdetails($getli);
                  // print_r($findsquaddetials); exit;
                  /*if($getli=='c.match.zucc_vs_cocc.0bf96') {
                print_r($findsquaddetials); exit;
              }*/
                  $findsquaddetials = array();
                  if (!empty($findsquaddetials)) {
                    $squadteam1players = array();
                    $squadteam2players = array();
                    if (isset($findsquaddetials['data']['card']['teams']['a']['match']['players'])) {
                      $squadteam1players = $findsquaddetials['data']['card']['teams']['a']['match']['players'];
                    }
                    if (isset($findsquaddetials['data']['card']['teams']['b']['match']['players'])) {
                      $squadteam2players = $findsquaddetials['data']['card']['teams']['b']['match']['players'];
                    }
                    if ((!empty($squadteam1players)) && (!empty($squadteam2players))) {
                      $matchadata['squadstatus'] = 'yes';
                    } else {
                      $matchadata['squadstatus'] = 'no';
                    }
                  }
                  //team details update//
                  $team1key = $getli['teams']['a']['key'];
                  $team2key = $getli['teams']['b']['key'];
                  //insert team 1//
                  $findteam1 = DB::table('teams')->where('team_key', $team1key)->select('id')->first();
                  $short_name = explode('vs', $getli['short_name']);
                  if (empty($findteam1)) {
                    $data['team_key'] = $team1key;
                    $data['team'] = $getli['teams']['a']['name'];
                    $data['short_name'] = str_replace(' ', '', $short_name[0]);
                    $team1id = DB::table('teams')->insertGetId($data);
                  } else {
                    // DB::table('teams')->where('team_key',$team1key)->update(array("short_name" => $findsquaddetials['data']['card']['teams']['a']['short_name']));
                    $team1id = $findteam1->id;
                  }
                  //insert team 2//
                  $findteam2 = DB::table('teams')->where('team_key', $team2key)->select('id')->first();
                  if (empty($findteam2)) {
                    $data1['team_key'] = $team2key;
                    $data1['team'] = $getli['teams']['b']['name'];
                    $data1['short_name'] = str_replace(' ', '', $short_name[1]);
                    $team2id = DB::table('teams')->insertGetId($data1);
                  } else {
                    // DB::table('teams')->where('team_key',$team2key)->update(array("short_name" => $findsquaddetials['data']['card']['teams']['b']['short_name']));
                    $team2id = $findteam2->id;
                  }
                  //insert match data//
                  $matchadata['status'] = 'notstarted';
                  $matchadata['name'] = $getli['name'];
                  $matchadata['short_name'] = $getli['short_name'];
                  $matchadata['season'] = $getli['season']['name'];
                  $matchadata['title'] = $getli['title'];
                  $matchadata['format'] = $getli['format'];
                  $matchadata['team1'] = $team1id;
                  $matchadata['team2'] = $team2id;
                  $matchadata['team1display'] = str_replace(' ', '', $short_name[0]);
                  $matchadata['team2display'] = str_replace(' ', '', $short_name[1]);
                  $matchadata['matchkey'] = $getli['key'];
                  $cuurectdate = date('Y-m-d H:i:s', strtotime($getli['start_date']['iso']));
                  //$cuurectdate = Carbon::parse($matchdate )->addHours(5)->addMinutes(30);
                  $matchadata['start_date'] = $cuurectdate;
                  DB::table('listmatches')->insert($matchadata);
                } else if ($findmatchexist->team1display == "TBC A" || $findmatchexist->team2display == "TBC B" || $findmatchexist->final_status == 'pending') {
                  // $findsquaddetials = CricketapiController::getmatchdetails($getli);
                  $findsquaddetials = array();
                  if ($getli == 'c.match.alm_vs_ssd.abb60') {
                    // print_r($findsquaddetials); exit;
                  }
                  if (!empty($findsquaddetials)) {
                    $squadteam1players = array();
                    $squadteam2players = array();
                    if (isset($findsquaddetials['data']['card']['teams']['a']['match']['players'])) {
                      $squadteam1players = $findsquaddetials['data']['card']['teams']['a']['match']['players'];
                    }
                    if (isset($findsquaddetials['data']['card']['teams']['b']['match']['players'])) {
                      $squadteam2players = $findsquaddetials['data']['card']['teams']['b']['match']['players'];
                    }
                    if ((!empty($squadteam1players)) && (!empty($squadteam2players))) {
                      $matchadata['squadstatus'] = 'yes';
                    } else {
                      $matchadata['squadstatus'] = 'no';
                    }
                  }
                  //team details update//
                  $team1key = $getli['teams']['a']['key'];
                  $team2key = $getli['teams']['b']['key'];
                  //insert team 1//
                  $findteam1 = DB::table('teams')->where('team_key', $team1key)->select('id')->first();
                  $short_name = explode('vs', $getli['short_name']);
                  if (empty($findteam1)) {
                    $data['team_key'] = $team1key;
                    $data['team'] = $getli['teams']['a']['name'];
                    $team1id = DB::table('teams')->insertGetId($data);
                  } else {
                    $team1id = $findteam1->id;
                  }
                  //insert team 2//
                  $findteam2 = DB::table('teams')->where('team_key', $team2key)->select('id')->first();
                  if (empty($findteam2)) {
                    $data1['team_key'] = $team2key;
                    $data1['team'] = $getli['teams']['b']['name'];
                    $team2id = DB::table('teams')->insertGetId($data1);
                  } else {
                    $team2id = $findteam2->id;
                  }
                  //update match data//
                  // $matchadata['status'] = $getli['status'];
                  $matchadata['name'] = $getli['name'];
                  $matchadata['short_name'] = $getli['short_name'];
                  $matchadata['season'] = $getli['season']['name'];
                  $matchadata['title'] = $getli['title'];
                  $matchadata['format'] = $getli['format'] == '100-ball' ? 'hundred' : $getli['format'];
                  // $matchadata['format'] = $getli['format'];
                  $matchadata['team1'] = $team1id;
                  $matchadata['team2'] = $team2id;
                  $matchadata['team1display'] = str_replace(' ', '', $short_name[0]);
                  $matchadata['team2display'] = str_replace(' ', '', $short_name[1]);
                  $matchadata['matchkey'] = $getli['key'];
                  $cuurectdate = date('Y-m-d H:i:s', strtotime($getli['start_date']['iso']));
                  //$cuurectdate = Carbon::parse($matchdate )->addHours(5)->addMinutes(30);
                  $matchadata['start_date'] = $cuurectdate;
                  DB::table('listmatches')->where('matchkey', $getli['key'])->update($matchadata);
                }
                // $this->importsquad($getli, 'CRICKET');
              }
            }
            // }
            // }
            //   }
          }
        }
      }
    }
    // exit;
    // return redirect::back();
  }

  public function importMatchSquad($match_id, $sport_type = CRICKET, $comp_id = null)
  {
    $this->importsquad($match_id, $sport_type, $comp_id);


    return redirect()->action('App\Http\Controllers\Admin\MatchesController@matchmapping');
  }


  //

  public function fiveplusone($matchkey, $sport_type = CRICKET)
  {

    $matchadata['is_fiveplusone'] = 1;
    DB::table('listmatches')->where('matchkey', $matchkey)->update($matchadata);
    $findmatchdetails = DB::table('listmatches')
      ->join('teams as t1', 't1.id', '=', 'listmatches.team1')
      ->join('teams as t2', 't2.id', '=', 'listmatches.team2')
      ->where('listmatches.sport_type', $sport_type)
      ->where('matchkey', $matchkey)
      ->select(
        't1.id as team1id',
        't2.id as team2id',
        't1.team as team1name',
        't2.team as team2name',
        'listmatches.sport_type as sport_type',
        't1.team_key as team1key',
        't2.team_key as team2key',
        't2.team_key as team2key',
        't1.logo as team1logo',
        't2.logo as team2logo',
        'listmatches.id as listmatchid',
        'listmatches.*'
      )
      ->first();
    //echo "<pre>"; print_r($findmatchdetails); exit;
    $batsman1 = 0;
    $batsman2 = 0;
    $bowlers1 = 0;
    $bowlers2 = 0;
    $allrounder1 = 0;
    $allrounder2 = 0;
    $wk1 = 0;
    $wk2 = 0;
    $criteria = 1;
    if (!empty($findmatchdetails)) {
      $team1 = $findmatchdetails->team1;
      $team2 = $findmatchdetails->team2;
      $findallmatchplayers = DB::table('matchplayers')->where('matchkey', $matchkey)->join('players', 'matchplayers.playerid', '=', 'players.id')->select('players.team', 'matchplayers.*')->orderBy('batting_order', "ASC")->get();
      if (!empty($findallmatchplayers)) {
      }
    }
    //echo 4;exit;
    $showlineup = DB::table('match_playing11')->where('match_key', $matchkey)->first();
    return view("admin.$this->model.fiveplusoneplayer", compact('findmatchdetails', 'batsman1', 'batsman2', 'bowlers1', 'bowlers2', 'allrounder1', 'allrounder2', 'wk1', 'wk2', 'showlineup', 'team1', 'team2'));
  }

  public function tenplusone($matchkey, $sport_type = CRICKET)
  {

    $matchadata['is_tenplusone'] = 1;
    DB::table('listmatches')->where('matchkey', $matchkey)->update($matchadata);
    $findmatchdetails = DB::table('listmatches')
      ->join('teams as t1', 't1.id', '=', 'listmatches.team1')
      ->join('teams as t2', 't2.id', '=', 'listmatches.team2')
      ->where('listmatches.sport_type', $sport_type)
      ->where('matchkey', $matchkey)
      ->select(
        't1.id as team1id',
        't2.id as team2id',
        't1.team as team1name',
        't2.team as team2name',
        'listmatches.sport_type as sport_type',
        't1.team_key as team1key',
        't2.team_key as team2key',
        't2.team_key as team2key',
        't1.logo as team1logo',
        't2.logo as team2logo',
        'listmatches.id as listmatchid',
        'listmatches.*'
      )
      ->first();
    //echo "<pre>"; print_r($findmatchdetails); exit;
    $batsman1 = 0;
    $batsman2 = 0;
    $bowlers1 = 0;
    $bowlers2 = 0;
    $allrounder1 = 0;
    $allrounder2 = 0;
    $wk1 = 0;
    $wk2 = 0;
    $criteria = 1;
    if (!empty($findmatchdetails)) {
      $team1 = $findmatchdetails->team1;
      $team2 = $findmatchdetails->team2;
      $findallmatchplayers = DB::table('matchplayers')->where('matchkey', $matchkey)->join('players', 'matchplayers.playerid', '=', 'players.id')->select('players.team', 'matchplayers.*')->orderBy('batting_order', "ASC")->get();
      if (!empty($findallmatchplayers)) {
      }
    }
    return redirect()->back()->with('success', '10+1 functionality enabled successfully');
    //echo 4;exit;
    $showlineup = DB::table('match_playing11')->where('match_key', $matchkey)->first();
    return view("admin.$this->model.fiveplusoneplayer", compact('findmatchdetails', 'batsman1', 'batsman2', 'bowlers1', 'bowlers2', 'allrounder1', 'allrounder2', 'wk1', 'wk2', 'showlineup', 'team1', 'team2'));
  }

  public function importsquad($match_id, $sport_type = CRICKET, $comp_id = null)
  {

    $sport_type = str_replace(' ', '', strtoupper($sport_type));
    $sportType =  DB::table('sport_types')->where('sport_key', $sport_type)->first();
    switch ($sport_type) {
      case BASKETBALL:
        $match = DB::table('listmatches')->where('matchkey', $match_id)->where('sport_type', 3)->first();
        // print_r($match); exit;
        $this->import_match_squad($match->matchkey, $match->competition_id, 'BASKETBALL');
        return Redirect::back();
        exit;
        $squads = BasketBallController::get_match_squad($match_id, $comp_id);
        if (!empty($squads)) {
          $squads = $squads->items;
          $matchInfo = $squads->match_info;
          $squads = $squads->fantasy_squad;
          foreach ($squads as $key2 => $value2) {
            $teamid = $matchInfo->teams->{$key2}->tid;
            $players = @$value2;
            if (!empty(@$players)) {
              $match_data['squadstatus'] = 'yes';
              DB::table('listmatches')->where('matchkey', $match_id)->where('sport_type', $sportType->id)->update($match_data);
            } else {
              $players = array();
            }

            foreach ($players as $key => $value) {
              if (isset($value->pid)) {
                $teamkey = $teamid;
                $players1 = $value->pid;
                $playerkey = $players1;
                $findmatchexist = DB::table('teams')->where('team_key', $teamkey)->where('sport_type', $sportType->id)->select('id')->first();
                if (!empty($findmatchexist)) {
                  $findp1 = DB::table('playerdetails')->where('player_key', $players1)->where('sport_type', $sportType->id)->first();
                  $findplayerexist = DB::table('players')->where('player_key', $players1)->where('team', $findmatchexist->id)->where('sport_type', $sportType->id)->first();

                  $data['player_name'] = $value->name;
                  $data['player_key'] = $playerkey;
                  $plaerdetailsdata['fullname'] = $value->name;
                  $plaerdetailsdata['player_key'] = $playerkey;
                  $plaerdetailsdata['sport_type'] = $sportType->id;
                  $data['sport_type'] = $sportType->id;

                  if (empty($findplayerexist)) {
                    $data['team'] = $findmatchexist->id;
                    $data['role'] = $value->rolename;
                    $playerid = DB::table('players')->insertGetId($data);
                    $credit = $value->rating;
                  } else {
                    $playerid = $findplayerexist->id;
                    $credit = $value->rating;
                    $data['role'] = $value->rolename;
                  }

                  /* insert in player details table*/

                  if (empty($findp1)) {
                    DB::table('playerdetails')->insert($plaerdetailsdata);
                  } else {
                    DB::table('playerdetails')->where('id', $findp1->id)->update($plaerdetailsdata);
                  }
                  // insert players for a match//
                  $findplayer1entry = DB::table('matchplayers')->where('matchkey', $match_id)->where('playerid', $playerid)->where('sport_type', $sportType->id)->first();
                  // print_r($findplayer1entry);
                  if (empty($findplayer1entry)) {
                    $matchplayerdata['matchkey'] = $match_id;
                    $matchplayerdata['playerid'] = $playerid;
                    $matchplayerdata['role'] = $data['role'];
                    $matchplayerdata['name'] = $data['player_name'];
                    $matchplayerdata['credit'] = $credit;
                    $matchplayerdata['sport_type'] = $sportType->id;
                    DB::table('matchplayers')->insert($matchplayerdata);
                  } else {
                    $matchplayerdata['matchkey'] = $match_id;
                    $matchplayerdata['playerid'] = $playerid;
                    $matchplayerdata['role'] = $data['role'];
                    $matchplayerdata['name'] = $data['player_name'];
                    $matchplayerdata['credit'] = $credit;
                    // DB::table('matchplayers')->where('id', $findplayer1entry->id)->update($matchplayerdata);
                  }
                }
              }
            }
          }
        }
        break;

      case FOOTBALL:

        $match = DB::table('listmatches')->where('matchkey', $match_id)->where('sport_type', 2)->first();
        $this->import_match_squad($match->matchkey, $match->competition_id, 'FOOTBALL');
        return Redirect::back();
        exit;
        $squads = FootballController::getmatchdetails($match_id);
        // print_r($squads); exit;
        $squads = $squads['data'];
        $squadsTeams = @$squads['teams'] ? $squads['teams'] : array();
        foreach ($squadsTeams as $key => $value) {
          $team_key = $key;
          $findTeam = DB::table('teams')->where('team_key', $team_key)->first();


          if (!empty($findTeam)) {
            $teamUpdate['short_name'] = $value['code'];
            $teamUpdate['team'] = $value['name'];
            if ($value['position'] == 'home') {

              $matchUpdate['team1display'] = $value['code'];
            } else {

              $matchUpdate['team2display'] = $value['code'];
            }
            DB::table('teams')->where('id', $findTeam->id)->update($teamUpdate);
            DB::table('listmatches')->where('matchkey', $match_id)->update($matchUpdate);
            $players = $value['players'];
            if (!empty($players)) {
              foreach ($players as $key2 => $value2) {
                $player_key = $value2;
                $playerData = @$squads['players'][$player_key];
                if (!empty($playerData)) {
                  $find_player = DB::table('players')->where('player_key', $player_key)->where('team', $findTeam->id)->first();
                  if (empty($find_player)) {
                    $player_insert = array();
                    $player_insert['player_name'] = $playerData['name'];
                    $player_insert['player_key'] = $playerData['key'];
                    $player_insert['sport_type'] = 2;
                    $player_insert['team'] = $findTeam->id;
                    $player_insert['credit'] = 6;
                    $player_insert['role'] = $playerData['role'];
                    $name = $playerData['name'];
                    $role = $playerData['role'];
                    $player_id = DB::table('players')->insertGetId($player_insert);
                  } else {
                    $player_id = $find_player->id;
                    $role = $playerData['role'];
                    $name = $playerData['name'];
                  }
                  DB::table('playerdetails')->where('player_key', $player_key)->first();
                  if (empty($findp1)) {
                    $plaerdetailsdata['fullname'] = $name;
                    $plaerdetailsdata['player_key'] = $player_key;
                    $plaerdetailsdata['sport_type'] = 2;
                    DB::table('playerdetails')->insert($plaerdetailsdata);
                  }

                  $credit = 8;
                  $find_match_player = DB::table('matchplayers')->where('playerid', $player_id)->where('matchkey', $match_id)->first();
                  if ($role == 'striker') {
                    $role = 'Forward';
                  }
                  if (empty($find_match_player)) {
                    $matchplayerdata['matchkey'] = $match_id;
                    $matchplayerdata['playerid'] = $player_id;
                    $matchplayerdata['role'] = $role;
                    $matchplayerdata['name'] = $name;
                    $matchplayerdata['credit'] = $credit;
                    $matchplayerdata['sport_type'] = 2;
                    DB::table('matchplayers')->insert($matchplayerdata);
                  } else {
                    $matchplayerdata['role'] = $role;
                    $matchplayerdata['credit'] = $credit;
                    DB::table('matchplayers')->where('playerid', $player_id)->where('matchkey', $match_id)->update($matchplayerdata);
                  }
                }
              }
              DB::table('listmatches')->where('matchkey', $match_id)->update(array("squadstatus" => "yes"));
            }
          }
        }
        $this->update_fantasy_credit_football($match_id);
        return Redirect::back();
        break;
      // xxxxxxxxxxx  KABADDI NEW ADDED xxxxxxxxxxxxxxxx

      case 'KABADDI':
        $match = DB::table('listmatches')->where('matchkey', $match_id)->where('sport_type', 7)->first();
        $this->import_match_squad($match->matchkey, $match->competition_id, 'KABADDI');
        return Redirect::back();
        break;


      // xxxxxxxxxxx  KABADDI NEW ADDED xxxxxxxxxxxxxxxx


      default:

        $match = DB::table('listmatches')->where('matchkey', $match_id)->where('sport_type', 1)->first();
        $this->import_match_squad($match->matchkey, $match->competition_id, 'CRICKET');
        return Redirect::back();
        $getdetails = CricketapiController::getmatchdetails($match_id);

        // echo 1; exit;
        if (empty($getdetails['data'])) {
          // print_r($getdetails); exit;
          $getdetails = array();
          $getdetails = CricketapiController::getmatchdetails_old($match_id);
        }
        // echo '<pre>'; print_r($getdetails); die;
        if (!empty(@$getdetails['data'])) {
          $matchkikey = $getdetails['data']['card']['key'];
          $team1players = $getdetails['data']['card']['teams']['a']['match']['players'];
          $team2players = $getdetails['data']['card']['teams']['b']['match']['players'];

          if (!empty($team1players)) {
            foreach ($team1players as $players1) {
              $matchplayerdata = array();
              $playerkey = $players1;
              // insert players details which we get from api//
              $teamkey = $getdetails['data']['card']['teams']['a']['key'];
              $findmatchexist = DB::table('teams')->where('team_key', $teamkey)->select('id')->first();
              if (!empty($findmatchexist)) {
                $findp1 = DB::table('playerdetails')->where('player_key', $players1)->first();
                $findplayerexist = DB::table('players')->where('player_key', $players1)->where('team', $findmatchexist->id)->first();
                $data['player_name'] = $getdetails['data']['card']['players'][$players1]['fullname'];
                $data['player_key'] = $playerkey;
                $plaerdetailsdata['fullname'] = $getdetails['data']['card']['players'][$players1]['fullname'];
                $plaerdetailsdata['player_key'] = $playerkey;

                $findLastMatchTeam1 = DB::table('listmatches')
                  ->where('status', 'completed')
                  ->where(function ($query) use ($findmatchexist) {
                    $query->where('team1', $findmatchexist->id)
                      ->orWhere('team2', $findmatchexist->id);
                  })
                  ->select('matchkey')->orderBy('id', 'DESC')->limit(1)->first();

                if (!empty($findLastMatchTeam1)) {
                  $findLastMatchPlayersTeam1 =  DB::table('result_matches')
                    ->where('match_key', $findLastMatchTeam1->matchkey)
                    ->where('player_key', $playerkey)
                    ->select('player_key')->get();

                  if (!empty($findplayerexist)) {
                    if (!$findLastMatchPlayersTeam1->isEmpty()) {
                      $lastMatchPlayedData['last_match_played'] = 'true';
                      // DB::table('matchplayers')->where('matchkey', $matchkikey)->where('playerid', $findplayerexist->id)->update($lastMatchPlayedData);
                    } else {
                      $lastMatchPlayedData['last_match_played'] = 'false';
                      // DB::table('matchplayers')->where('matchkey', $matchkikey)->where('playerid', $findplayerexist->id)->update($lastMatchPlayedData);
                    }
                  }
                }

                if (empty($findplayerexist)) {
                  $data['team'] = $findmatchexist->id;
                  if ($getdetails['data']['card']['players'][$players1]['seasonal_role'] == "") {
                    $data['role'] = 'allrounder';
                  } else {
                    $data['role'] =  $getdetails['data']['card']['players'][$players1]['seasonal_role'];
                  }
                  $playerid = DB::table('players')->insertGetId($data);
                  $credit = 6;
                } else {
                  $playerid = $findplayerexist->id;
                  $credit = $findplayerexist->credit;
                  $data['role'] = $findplayerexist->role;
                  $getdetails['data']['card']['players'][$players1]['seasonal_role'] = $findplayerexist->role;
                }
                /* insert in player details table*/
                if (empty($findp1)) {
                  DB::table('playerdetails')->insert($plaerdetailsdata);
                }
                // insert players for a match//
                $findplayer1entry = DB::table('matchplayers')->where('matchkey', $matchkikey)->where('playerid', $playerid)->first();
                if (empty($findplayer1entry)) {
                  $matchplayerdata['matchkey'] = $matchkikey;
                  $matchplayerdata['playerid'] = $playerid;
                  $matchplayerdata['role'] = $data['role'];
                  $matchplayerdata['name'] = $data['player_name'];
                  $matchplayerdata['credit'] = $credit;
                  DB::table('matchplayers')->insert($matchplayerdata);
                } else {
                  // $matchplayerdata['matchkey'] = $matchkikey;
                  // $matchplayerdata['playerid'] = $playerid;
                  // $matchplayerdata['role'] = $getdetails['data']['card']['players'][$players1]['seasonal_role'];
                  // $matchplayerdata['name'] = $data['player_name'];
                  // $matchplayerdata['credit'] = $credit;
                  // print_r($matchplayerdata);
                  // DB::table('matchplayers')->where('matchkey', $matchkikey)->where('playerid',$playerid)->update($matchplayerdata);
                }


                $findIsSecondInning = DB::table('listmatches')->where('matchkey', $matchkikey)->where('second_inning_allow', 1)->first();
                if (!empty($findIsSecondInning)) {


                  // insert players for a match//
                  $findplayer1entry = DB::table('matchplayers')->where('matchkey', $matchkikey . "_2")->where('playerid', $playerid)->first();
                  if (empty($findplayer1entry)) {
                    $matchplayerdata['matchkey'] = $matchkikey . "_2";
                    $matchplayerdata['playerid'] = $playerid;
                    $matchplayerdata['role'] = $data['role'];
                    $matchplayerdata['name'] = $data['player_name'];
                    $matchplayerdata['credit'] = $credit;
                    DB::table('matchplayers')->insert($matchplayerdata);
                  } else {
                    // $matchplayerdata['matchkey'] = $matchkikey;
                    // $matchplayerdata['playerid'] = $playerid;
                    $matchplayerdata['role'] = $getdetails['data']['card']['players'][$players1]['seasonal_role'];
                    $matchplayerdata['matchkey'] = $matchkikey . "_2";
                    // $matchplayerdata['name'] = $data['player_name'];
                    // $matchplayerdata['credit'] = $credit;
                    // print_r($matchplayerdata);
                    DB::table('matchplayers')->where('matchkey', $matchkikey . "_2")->where('playerid', $playerid)->update($matchplayerdata);
                  }

                  // $matchplayerdata['matchkey'] = $matchkikey."_2";
                  // DB::table('matchplayers')->where('matchkey', $matchkikey."_2")->where('playerid',$playerid)->update($matchplayerdata);
                }
              }
            }
          }
          // print_r($getdetails['data']['card']['players']); exit;
          if (!empty($team2players)) {
            foreach ($team2players as $players2) {
              $matchplayerdata = array();
              $playerkey2 = $players2;
              $playerid = "";
              $findplayer2exist = array();
              $data = array();
              $team2key = $getdetails['data']['card']['teams']['b']['key'];
              $findmatchexist = DB::table('teams')->where('team_key', $team2key)->select('id')->first();
              if (!empty($findmatchexist)) {
                $findp2 = DB::table('playerdetails')->where('player_key', $players2)->first();
                $findplayer2exist = DB::table('players')->where('player_key', $players2)->where('team', $findmatchexist->id)->first();
                $data['player_name'] = $getdetails['data']['card']['players'][$players2]['fullname'];
                $data['player_key'] = $playerkey2;
                $plaerdetailsdata2['fullname'] = $getdetails['data']['card']['players'][$players2]['fullname'];
                $plaerdetailsdata2['player_key'] = $playerkey2;

                $findLastMatchTeam2 = DB::table('listmatches')
                  ->where('status', 'completed')
                  ->where(function ($query) use ($findmatchexist) {
                    $query->where('team1', $findmatchexist->id)
                      ->orWhere('team2', $findmatchexist->id);
                  })
                  ->select('matchkey')->orderBy('id', 'DESC')->limit(1)->first();

                if (!empty($findLastMatchTeam2)) {

                  $findLastMatchPlayersTeam2 =  DB::table('result_matches')
                    ->where('match_key', $findLastMatchTeam2->matchkey)
                    ->where('player_key', $playerkey2)
                    ->select('player_key')->get();
                  if ($playerkey2 == 'sd_lamichhane') {
                    // var_dump($findLastMatchPlayersTeam2);exit;
                  }
                  if (!empty($findplayer2exist)) {
                    if (!$findLastMatchPlayersTeam2->isEmpty()) {
                      $lastMatchPlayedData['last_match_played'] = 'true';
                      // DB::table('matchplayers')->where('matchkey', $matchkikey)->where('playerid', $findplayer2exist->id)->update($lastMatchPlayedData);
                    } else {
                      $lastMatchPlayedData['last_match_played'] = 'false';
                      // DB::table('matchplayers')->where('matchkey', $matchkikey)->where('playerid', $findplayer2exist->id)->update($lastMatchPlayedData);
                    }
                  }
                }

                if (empty($findplayer2exist)) {
                  $data['team'] = $findmatchexist->id;
                  if ($getdetails['data']['card']['players'][$players2]['seasonal_role'] == "") {
                    $data['role'] =  'allrounder';
                  } else {
                    $data['role'] = $getdetails['data']['card']['players'][$players2]['seasonal_role'];
                  }
                  $playerid =  DB::table('players')->insertGetId($data);
                  $credit = 6;
                } else {
                  $playerid = $findplayer2exist->id;
                  $credit = $findplayer2exist->credit;
                  $getdetails['data']['card']['players'][$players2]['seasonal_role'] = $findplayer2exist->role;
                  $data['role'] =  $findplayer2exist->role;
                }

                /* insert in player details table*/
                if (empty($findp2)) {
                  DB::table('playerdetails')->insert($plaerdetailsdata2);
                }
                $findplayer2entry = DB::table('matchplayers')->where('matchkey', $matchkikey)->where('playerid', $playerid)->first();
                if (empty($findplayer2entry)) {
                  $matchplayerdata['matchkey'] = $matchkikey;
                  $matchplayerdata['playerid'] = $playerid;
                  if ($data['role'] != "") {
                    $matchplayerdata['role'] = $data['role'];
                  }
                  $matchplayerdata['name'] = $data['player_name'];
                  $matchplayerdata['credit'] = $credit;
                  DB::table('matchplayers')->insert($matchplayerdata);
                } else {
                  // $matchplayerdata['matchkey'] = $matchkikey;
                  // $matchplayerdata['playerid'] = $playerid;
                  // $matchplayerdata['role'] = $getdetails['data']['card']['players'][$players2]['seasonal_role'];
                  // $matchplayerdata['name'] = $data['player_name'];
                  // $matchplayerdata['credit'] = $credit;
                  // print_r($matchplayerdata);
                  // DB::table('matchplayers')->where('matchkey', $matchkikey)->where('playerid',$playerid)->update($matchplayerdata);
                }

                $findIsSecondInning = DB::table('listmatches')->where('matchkey', $matchkikey)->where('second_inning_allow', 1)->first();
                if (!empty($findIsSecondInning)) {
                  // $matchplayerdata['matchkey'] = $matchkikey."_2";
                  $findplayer2entry = DB::table('matchplayers')->where('matchkey', $matchkikey . "_2")->where('playerid', $playerid)->first();
                  if (empty($findplayer2entry)) {
                    $matchplayerdata['matchkey'] = $matchkikey . "_2";
                    $matchplayerdata['playerid'] = $playerid;
                    if ($data['role'] != "") {
                      $matchplayerdata['role'] = $data['role'];
                    }
                    $matchplayerdata['name'] = $data['player_name'];
                    $matchplayerdata['credit'] = $credit;
                    DB::table('matchplayers')->insert($matchplayerdata);
                  } else {
                    // $matchplayerdata['matchkey'] = $matchkikey;
                    // $matchplayerdata['playerid'] = $playerid;
                    $matchplayerdata['role'] = $getdetails['data']['card']['players'][$players2]['seasonal_role'];
                    $matchplayerdata['matchkey'] = $matchkikey . "_2";
                    // $matchplayerdata['name'] = $data['player_name'];
                    // $matchplayerdata['credit'] = $credit;
                    // print_r($matchplayerdata);
                    DB::table('matchplayers')->where('matchkey', $matchkikey . "_2")->where('playerid', $playerid)->update($matchplayerdata);
                  }
                }
              }
            }
          }
          // echo 2; exit;
          // exit;
          // print_r($team2players); exit;
          if ((!empty($team1players)) && (!empty($team2players))) {
            $matchadata['squadstatus'] = 'yes';
            DB::table('listmatches')->where('matchkey', $match_id)->update($matchadata);
            $findthismatch = DB::table('listmatches')->where('matchkey', $match_id)->first();
            if ($findthismatch->launch_status != 'launched') {

              $this->update_fantasy_credit($match_id);
            }
            // $this->update_fantasy_credit($match_id);
            // Session::flash('message', 'Successfully updated!');
            // Session::flash('alert-class', 'alert-success');
            // return redirect()->action('MatchesController@matchmapping');
            return Redirect::back();
            // return true;
          } else {
            // return redirect()->action('MatchesController@matchmapping');
          }
        }

        break;
    }
  }

  public function viewmatchdetails($matchid, $sport_type = 1)
  {
    //  echo $sport_type;exit;
    $sportType = DB::table('sport_types')->where('id', $sport_type)->first();
    $findmatch = DB::table('listmatches')->where('matchkey', $matchid)->where('sport_type', $sportType->id)->first();
    if (!empty($findmatch)) {
      if ($findmatch->launch_status != 'launched') {
        switch ($sport_type) {
          case FOOTBALL: {
              $getdetails = FootballController::get_match_details($matchid);
              if (!empty($getdetails)) {
                $matchkikey = $getdetails->items->match_info[0]->mid;
                $team1players = array();
                $team2players = array();
                if (isset($getdetails->items->lineup->home->lineup->player)) {
                  $team1players = $getdetails->items->lineup->home->lineup->player;
                }
                if (isset($getdetails->items->lineup->away->lineup->player)) {
                  $team2players = $getdetails->items->lineup->away->lineup->player;
                }
                if (!empty($team1players)) {
                  foreach ($team1players as $players1) {
                    $playerkey = $players1->pid;
                    // insert players details which we get from api//
                    $teamkey = $getdetails->items->match_info[0]->teams->home->tid;
                    $findmatchexist = DB::table('teams')->where('team_key', $teamkey)->where('sport_type', $sportType->id)->select('id')->first();
                    if (!empty($findmatchexist)) {
                      $findp1 = DB::table('playerdetails')->where('player_key', $playerkey)->where('sport_type', $sportType->id)->first();
                      $findplayerexist = DB::table('players')->where('player_key', $playerkey)->where('team', $findmatchexist->id)->where('sport_type', $sportType->id)->first();
                      $data['player_name'] = $players1->pname;
                      $data['player_key'] = $playerkey;
                      //$data['player_key'] = $playerkey;
                      $plaerdetailsdata['fullname'] =  $players1->pname;
                      $plaerdetailsdata['player_key'] = $playerkey;
                      $plaerdetailsdata['sport_type'] = $sportType->id;
                      $credit = $players1->fantasy_player_rating;
                      if (empty($findplayerexist)) {
                        $data['team'] = $findmatchexist->id;
                        $data['role'] = $players1->name;
                        $playerid = DB::table('players')->insertGetId($data);
                      } else {
                        $playerid = $findplayerexist->id;
                        $data['role'] = $findplayerexist->role;
                      }
                      /* insert in player details table*/
                      if (empty($findp1)) {
                        DB::table('playerdetails')->insert($plaerdetailsdata);
                      }
                      // insert players for a match//
                      $findplayer1entry = DB::table('matchplayers')->where('matchkey', $matchkikey)->where('sport_type', $sportType->id)->where('playerid', $playerid)->first();
                      if (empty($findplayer1entry)) {
                        $matchplayerdata['matchkey'] = $matchkikey;
                        $matchplayerdata['playerid'] = $playerid;
                        $matchplayerdata['role'] = $data['role'];
                        $matchplayerdata['name'] = $data['player_name'];
                        $matchplayerdata['credit'] = $credit;
                        $matchplayerdata['sport_type'] = $sportType->id;
                        DB::table('matchplayers')->insert($matchplayerdata);
                      }
                    }
                  }
                }
                if (!empty($team2players)) {
                  foreach ($team2players as $players2) {
                    $playerkey = $players2->pid;
                    $playerid = "";
                    $findplayer2exist = array();
                    $data = array();
                    $team2key = $getdetails->items->match_info[0]->teams->away->tid;


                    $findmatchexist = DB::table('teams')->where('team_key', $team2key)->where('sport_type', $sportType->id)->select('id')->first();
                    if (!empty($findmatchexist)) {
                      $findp1 = DB::table('playerdetails')->where('player_key', $playerkey)->where('sport_type', $sportType->id)->first();
                      $findplayerexist = DB::table('players')->where('player_key', $playerkey)->where('team', $findmatchexist->id)->where('sport_type', $sportType->id)->first();
                      $data['player_name'] = $players2->pname;
                      $data['player_key'] = $playerkey;
                      $data['player_key'] = $playerkey;
                      $plaerdetailsdata['fullname'] =  $players2->pname;
                      $plaerdetailsdata['player_key'] = $playerkey;
                      $plaerdetailsdata['sport_type'] = $sportType->id;
                      $credit = $players2->fantasy_player_rating;
                      if (empty($findplayerexist)) {
                        $data['team'] = $findmatchexist->id;
                        $data['role'] = $players2->name;
                        $playerid = DB::table('players')->insertGetId($data);
                      } else {
                        $playerid = $findplayerexist->id;
                        $data['role'] = $findplayerexist->role;
                      }
                      /* insert in player details table*/
                      if (empty($findp1)) {
                        DB::table('playerdetails')->insert($plaerdetailsdata);
                      }
                      // insert players for a match//
                      $findplayer1entry = DB::table('matchplayers')->where('matchkey', $matchkikey)->where('sport_type', $sportType->id)->where('playerid', $playerid)->first();
                      if (empty($findplayer1entry)) {
                        $matchplayerdata['matchkey'] = $matchkikey;
                        $matchplayerdata['playerid'] = $playerid;
                        $matchplayerdata['role'] = $data['role'];
                        $matchplayerdata['name'] = $data['player_name'];
                        $matchplayerdata['credit'] = $credit;
                        $matchplayerdata['sport_type'] = $sportType->id;
                        DB::table('matchplayers')->insert($matchplayerdata);
                      }
                    }
                  }
                }
              }
            }
            break;
          case BASKETBALL: {
              $getdetails = BasketBallController::get_match_details($matchid);
              if (!empty($getdetails)) {
                $matchkikey = $getdetails->items->match_info->mid;
                $team1players = array();
                $team2players = array();
                if (isset($getdetails->items->lineup->home->lineup->player)) {
                  $team1players = $getdetails->items->lineup->home->lineup->player;
                }
                if (isset($getdetails->items->lineup->away->lineup->player)) {
                  $team2players = $getdetails->items->lineup->away->lineup->player;
                }
                if (!empty($team1players)) {
                  foreach ($team1players as $players1) {
                    $playerkey = $players1->pid;
                    // insert players details which we get from api//
                    $teamkey = $getdetails->items->match_info[0]->teams->home->tid;
                    $findmatchexist = DB::table('teams')->where('team_key', $teamkey)->where('sport_type', $sportType->id)->select('id')->first();
                    if (!empty($findmatchexist)) {
                      $findp1 = DB::table('playerdetails')->where('player_key', $playerkey)->where('sport_type', $sportType->id)->first();
                      $findplayerexist = DB::table('players')->where('player_key', $playerkey)->where('team', $findmatchexist->id)->where('sport_type', $sportType->id)->first();
                      $data['player_name'] = $players1->pname;
                      $data['player_key'] = $playerkey;
                      $data['player_key'] = $playerkey;
                      $plaerdetailsdata['fullname'] =  $players1->pname;
                      $plaerdetailsdata['player_key'] = $playerkey;
                      $plaerdetailsdata['sport_type'] = $sportType->id;
                      $credit = $players1->fantasy_player_rating;
                      if (empty($findplayerexist)) {
                        $data['team'] = $findmatchexist->id;
                        $data['role'] = $players1->name;
                        $playerid = DB::table('players')->insertGetId($data);
                      } else {
                        $playerid = $findplayerexist->id;
                        $data['role'] = $findplayerexist->role;
                      }
                      /* insert in player details table*/
                      if (empty($findp1)) {
                        DB::table('playerdetails')->insert($plaerdetailsdata);
                      }
                      // insert players for a match//
                      $findplayer1entry = DB::table('matchplayers')->where('matchkey', $matchkikey)->where('sport_type', $sportType->id)->where('playerid', $playerid)->first();
                      if (empty($findplayer1entry)) {
                        $matchplayerdata['matchkey'] = $matchkikey;
                        $matchplayerdata['playerid'] = $playerid;
                        $matchplayerdata['role'] = $data['role'];
                        $matchplayerdata['name'] = $data['player_name'];
                        $matchplayerdata['credit'] = $credit;
                        $matchplayerdata['sport_type'] = $sportType->id;
                        DB::table('matchplayers')->insert($matchplayerdata);
                      }
                    }
                  }
                }
                if (!empty($team2players)) {
                  foreach ($team2players as $players2) {
                    $playerkey = $players2;
                    $playerid = "";
                    $findplayer2exist = array();
                    $data = array();
                    $team2key = $getdetails->items->match_info[0]->teams->away->tid;


                    $findmatchexist = DB::table('teams')->where('team_key', $team2key)->where('sport_type', $sportType->id)->select('id')->first();
                    if (!empty($findmatchexist)) {
                      $findp1 = DB::table('playerdetails')->where('player_key', $playerkey)->where('sport_type', $sportType->id)->first();
                      $findplayerexist = DB::table('players')->where('player_key', $playerkey)->where('team', $findmatchexist->id)->where('sport_type', $sportType->id)->first();
                      $data['player_name'] = $players2->pname;
                      $data['player_key'] = $playerkey;
                      $data['player_key'] = $playerkey;
                      $plaerdetailsdata['fullname'] =  $players2->pname;
                      $plaerdetailsdata['player_key'] = $playerkey;
                      $plaerdetailsdata['sport_type'] = $sportType->id;
                      $credit = $players2->fantasy_player_rating;
                      if (empty($findplayerexist)) {
                        $data['team'] = $findmatchexist->id;
                        $data['role'] = $players2->name;
                        $playerid = DB::table('players')->insertGetId($data);
                      } else {
                        $playerid = $findplayerexist->id;
                        $data['role'] = $findplayerexist->role;
                      }
                      /* insert in player details table*/
                      if (empty($findp1)) {
                        DB::table('playerdetails')->insert($plaerdetailsdata);
                      }
                      // insert players for a match//
                      $findplayer1entry = DB::table('matchplayers')->where('matchkey', $matchkikey)->where('sport_type', $sportType->id)->where('playerid', $playerid)->first();
                      if (empty($findplayer1entry)) {
                        $matchplayerdata['matchkey'] = $matchkikey;
                        $matchplayerdata['playerid'] = $playerid;
                        $matchplayerdata['role'] = $data['role'];
                        $matchplayerdata['name'] = $data['player_name'];
                        $matchplayerdata['credit'] = $credit;
                        $matchplayerdata['sport_type'] = $sportType->id;
                        DB::table('matchplayers')->insert($matchplayerdata);
                      }
                    }
                  }
                }
              }
              break;
            }
          case CRICKET: {
              $getdetails = CricketapiController::getmatchdetails($matchid);
              if (!empty($getdetails)) {
                $matchkikey = $getdetails['data']['card']['key'];
                $team1players = array();
                $team2players = array();
                if (isset($getdetails['data']['card']['teams']['a']['match']['players'])) {
                  $team1players = $getdetails['data']['card']['teams']['a']['match']['players'];
                }
                if (isset($getdetails['data']['card']['teams']['b']['match']['players'])) {
                  $team2players = $getdetails['data']['card']['teams']['b']['match']['players'];
                }
                if (!empty($team1players)) {
                  foreach ($team1players as $players1) {
                    $playerkey = $players1;
                    // insert players details which we get from api//
                    $teamkey = $getdetails['data']['card']['teams']['a']['key'];
                    $findmatchexist = DB::table('teams')->where('team_key', $teamkey)->select('id')->first();
                    if (!empty($findmatchexist)) {
                      $findp1 = DB::table('playerdetails')->where('player_key', $players1)->first();
                      $findplayerexist = DB::table('players')->where('player_key', $players1)->where('team', $findmatchexist->id)->first();
                      $data['player_name'] = $getdetails['data']['card']['players'][$players1]['fullname'];
                      $data['player_key'] = $playerkey;
                      $plaerdetailsdata['fullname'] = $getdetails['data']['card']['players'][$players1]['fullname'];
                      $plaerdetailsdata['player_key'] = $playerkey;
                      if (empty($findplayerexist)) {
                        $data['team'] = $findmatchexist->id;
                        if ($getdetails['data']['card']['players'][$players1]['seasonal_role'] == "") {
                          $data['role'] = 'allrounder';
                        } else {
                          $data['role'] =  $getdetails['data']['card']['players'][$players1]['seasonal_role'];
                        }
                        $playerid = DB::table('players')->insertGetId($data);
                        $credit = 6;
                      } else {
                        $playerid = $findplayerexist->id;
                        $credit = $findplayerexist->credit;
                        $data['role'] = $findplayerexist->role;
                        $getdetails['data']['card']['players'][$players1]['seasonal_role'] = $findplayerexist->role;
                      }
                      /* insert in player details table*/
                      if (empty($findp1)) {
                        DB::table('playerdetails')->insert($plaerdetailsdata);
                      }
                      // insert players for a match//
                      $findplayer1entry = DB::table('matchplayers')->where('matchkey', $matchkikey)->where('playerid', $playerid)->first();
                      if (empty($findplayer1entry)) {
                        $matchplayerdata['matchkey'] = $matchkikey;
                        $matchplayerdata['playerid'] = $playerid;
                        $matchplayerdata['role'] = $data['role'];
                        $matchplayerdata['name'] = $data['player_name'];
                        $matchplayerdata['credit'] = $credit;
                        DB::table('matchplayers')->insert($matchplayerdata);
                      }
                    }
                  }
                }
                if (!empty($team2players)) {
                  foreach ($team2players as $players2) {
                    $playerkey2 = $players2;
                    $playerid = "";
                    $findplayer2exist = array();
                    $data = array();
                    $team2key = $getdetails['data']['card']['teams']['b']['key'];
                    $findmatchexist = DB::table('teams')->where('team_key', $team2key)->select('id')->first();
                    if (!empty($findmatchexist)) {
                      $findp2 = DB::table('playerdetails')->where('player_key', $players2)->first();
                      $findplayer2exist = DB::table('players')->where('player_key', $players2)->where('team', $findmatchexist->id)->first();
                      $data['player_name'] = $getdetails['data']['card']['players'][$players2]['fullname'];
                      $data['player_key'] = $playerkey2;
                      $plaerdetailsdata2['fullname'] = $getdetails['data']['card']['players'][$players2]['fullname'];
                      $plaerdetailsdata2['player_key'] = $playerkey2;
                      if (empty($findplayer2exist)) {
                        $data['team'] = $findmatchexist->id;
                        if ($getdetails['data']['card']['players'][$players2]['seasonal_role'] == "") {
                          $data['role'] =  'allrounder';
                        } else {
                          $data['role'] = $getdetails['data']['card']['players'][$players2]['seasonal_role'];
                        }
                        $playerid =  DB::table('players')->insertGetId($data);
                        $credit = 6;
                      } else {
                        $playerid = $findplayer2exist->id;
                        $credit = $findplayer2exist->credit;
                        $getdetails['data']['card']['players'][$players2]['seasonal_role'] = $findplayer2exist->role;
                        $data['role'] =  $findplayer2exist->role;
                      }
                      /* insert in player details table*/
                      if (empty($findp2)) {
                        DB::table('playerdetails')->insert($plaerdetailsdata2);
                      }
                      $findplayer2entry = DB::table('matchplayers')->where('matchkey', $matchkikey)->where('playerid', $playerid)->first();
                      if (empty($findplayer2entry)) {
                        $matchplayerdata['matchkey'] = $matchkikey;
                        $matchplayerdata['playerid'] = $playerid;
                        if ($data['role'] != "") {
                          $matchplayerdata['role'] = $data['role'];
                        }
                        $matchplayerdata['name'] = $data['player_name'];
                        $matchplayerdata['credit'] = $credit;
                        DB::table('matchplayers')->insert($matchplayerdata);
                      }
                    }
                  }
                }
              }
              break;
            }
        }
      } else {

        //   return redirect()->route('Matches.launchmatch')->with('matchid','sport_type')->withErrors('already imported');
        return redirect()->action('App\Http\Controllers\Admin\MatchesController@launchmatch', ['id' => $matchid, 'sport_type' => $sport_type]);
      }
    } else {
      return redirect()->action('App\Http\Controllers\Admin\MatchesController@launchmatch', ['id' => $matchid, 'sport_type' => $sport_type]);

      // return redirect()->route('Matches.launchmatch')->with('matchid','sport_type')->withErrors('Invalid match Provided');

    }

    //echo $sport_type;exit;


    return redirect()->action('App\Http\Controllers\Admin\MatchesController@launchmatch', ['id' => $matchid, 'sport_type' => $sport_type]);
  }

  public function editmatch($matchkey, $sports_key = '1', Request $request)
  {
    // dd($request->all());

    $currentdate = date('Y-m-d');
    if ($request->isMethod('post')) {
      $input = Input::all();
      // dd($input);
      unset($input['_token']);
      $input_second_inning_start_date = $input['second_inning_start_date'];
      unset($input['second_inning_start_date']);
      // if second_inning_allow == 1
      // find all  data of match id & insert new row in listmatches
      // second_inning_allow = 0 , second_inning = 1 , matchkey = {matchkey}_2 , start_date_iso = second_inning_start_date


      //image code for team1 n team2 player image

      if (empty($input['second_inning_allow'])) {
        $input['second_inning_allow'] = 0;
      }
      if (empty($input['is_bot_enable'])) {
        $input['is_bot_enable'] = 0;
      }
      if (empty($input['is_giveaway'])) {
        $input['is_giveaway'] = 0;
      }

      if (empty($input['is_allow_notification'])) {
        $input['is_allow_notification'] = 0;
      }
      // if(empty($input['is_unlimited_credits'])) {
      //   $input['is_unlimited_credits'] = 0;
      // }
      // if(isset($input['is_unlimited_credits'])){
      //   $input['is_unlimited_credits'] = 1;
      // }else{
      //   $input['is_unlimited_credits'] = 0;
      // }

      if (empty($input['status']) == 'started') {
        unset($input['status']);
      }
      if (empty($input['is_unlimited_credits'])) {
        $input['is_unlimited_credits'] = 0;
      }

      $matchDetail = DB::table('listmatches')
        ->select('listmatches.banner_image')
        ->where('matchkey', $matchkey)
        ->first();


    //   $file = isset($input['base64image']) ? $input['base64image'] : '';
    //   // dd($file);
    //   if (isset($input['base64image'])) {
    //
    //   if ($input['base64image'] || $input['base64image'] != '0') {
    //     $folderPath  = 'uploads/banners/';
    //     $image_parts = explode(";base64,", $input['base64image']);
    //     // dd($image_parts[0]);
    //     if ($image_parts[0] === "") {
    //       // dd($image_parts[0]);
    //       // echo "string"; die();
    //       if (Input::hasFile('banner_image')) {
    //         // echo "string"; die();
    //         $extension  =   Input::file('banner_image')->getClientOriginalExtension();
    //         // dd($extension);
    //         $img_ext    =   explode(",", IMAGE_EXTENSION);
    //         // dd($img_ext);
    //         if (in_array($extension, $img_ext)) {
    //
    //           $fileName = BRAND['name'] . '-banner-match-' . rand(1000, 9999) . $extension;
    //           // dd($fileName);
    //           if (Input::file('banner_image')->move('uploads/banners/', $fileName)) {
    //             $input['banner_image']     =   $fileName;
    //             // dd($input);
    //           }
    //           //File::delete($folderPath.'/'.$matchDetail->banner_image);
    //           // @unlink('uploads/matches/'.$oldimage);
    //           // Helpers::aws_upload_image(ADVERTISMENTS_PROFILE_IMAGE_ROOT_PATH.$fileName, "uploads/banners/",$fileName);
    //
    //         } else {
    //           Session::flash('error',  trans("$this->model.INVALID_IMAGE_EXTENSION"));
    //           return Redirect::back();
    //         }
    //       }
    //     } else {
    //       $image_type_aux = explode("image/", $image_parts[0]);
    //       // dd($image_type_aux);
    //       $image_type = $image_type_aux[1];
    //       // dd($image_type);
    //       $image_base64 = base64_decode($image_parts[1]);
    //       // $file = $folderPath . uniqid() . '.png';
    //       $filename           =   BRAND['name'] . '-banner-match-' . rand(1000, 9999) . "." . $image_type;
    //       // $filename = time() . '.'. $image_type;
    //       $file = $folderPath . $filename;
    //       $input['banner_image'] = $filename;
    //
    //       file_put_contents($file, $image_base64);
    //
    //       $input['banner_image'] = $filename;
    //     }
    //   }
    // }
      // echo"<pre>";print_r($input);exit;
      if (!empty($input['banner_image'])) {
        // dd($input['banner_image']);
        if (!empty($input)) {
          $input = [
            'banner_image' => $input['banner_image'],
            'name' => $input['name'],
            'format' => @$input['format'],
            'start_date' => $input['start_date'],
            'series' => $input['series'],
            'announcement' => $input['announcement'],
            'sort' => $input['sort'],
            'status' => isset($input['status']) ? $input['status'] : 'notstarted',
            'mega_contest_prize' => $input['mega_contest_prize'],
            'team1_color_code' => $input['team1_color_code'],
            'team2_color_code' => $input['team2_color_code'],
            'second_inning_allow' => $input['second_inning_allow'],
            'is_unlimited_credits' => $input['is_unlimited_credits'],
            'is_bot_enable' => $input['is_bot_enable'],
            'is_allow_notification' => $input['is_allow_notification'],
            'giveaway_subheading' => $input['giveaway_subheading'],
            'giveaway_heading' => $input['giveaway_heading'],
            'is_giveaway' => $input['is_giveaway']
          ];
        }
      } else {
        $input = [
          'name' => $input['name'],
          'format' => @$input['format'],
          'start_date' => $input['start_date'],
          'series' => $input['series'],
          'announcement' => $input['announcement'],
          'sort' => $input['sort'],
          'status' => isset($input['status']) ? $input['status'] : 'notstarted',
          'mega_contest_prize' => $input['mega_contest_prize'],
          'team1_color_code' => @$input['team1_color_code'],
          'team2_color_code' => @$input['team2_color_code'],
          'second_inning_allow' => $input['second_inning_allow'],
          'is_unlimited_credits' => $input['is_unlimited_credits'],
          'is_bot_enable' => $input['is_bot_enable'],
          'is_allow_notification' => $input['is_allow_notification'],
          'giveaway_subheading' => $input['giveaway_subheading'],
          'giveaway_heading' => $input['giveaway_heading'],
          'is_giveaway' => $input['is_giveaway']
        ];
      }
      // dd(request());
      if (request()->hasFile('team1_player_image')) {
        $folderPath  = 'uploads/player/';
        $image = request()->file('team1_player_image'); // Get the uploaded file
        $extension = $image->getClientOriginalExtension();

        $img_ext = explode(",", IMAGE_EXTENSION);
        if (in_array($extension, $img_ext)) {
          // Ensure the directory exists
          if (!file_exists(public_path($folderPath))) {
            mkdir(public_path($folderPath), 0777, true);
          }

          // Generate a unique file name
          $fileName = env("APP_NAME") . '-player-' . rand(100000, 999999) . "." . $extension;
          $filePath = $folderPath . $fileName;

          // Move the uploaded file to the directory
          $image->move(public_path($folderPath), $fileName);

          // Upload to AWS (if needed)
          $uploadedFileName = TeamsController::aws_upload_image($filePath, $folderPath, $fileName);
          $input['team1_player_image'] = env('CDN_URL') . 'uploads/player/' . $uploadedFileName;

          // Delete local file after uploading to AWS
          @unlink(public_path($filePath));
        } else {
          Session::flash('error', trans("messages.$this->model.INVALID_IMAGE_EXTENSION"));
          return Redirect::back()->withInput();
        }
      }

      if (request()->hasFile('team2_player_image')) {
        $folderPath  = 'uploads/player/';
        $image = request()->file('team2_player_image'); // Get the uploaded file
        $extension = $image->getClientOriginalExtension();

        $img_ext = explode(",", IMAGE_EXTENSION);
        if (in_array($extension, $img_ext)) {
          // Ensure the directory exists
          if (!file_exists(public_path($folderPath))) {
            mkdir(public_path($folderPath), 0777, true);
          }

          // Generate a unique file name
          $fileName = env("APP_NAME") . '-player-' . rand(100000, 999999) . "." . $extension;
          $filePath = $folderPath . $fileName;

          // Move the uploaded file to the directory
          $image->move(public_path($folderPath), $fileName);

          // Upload to AWS (if needed)
          $uploadedFileName = TeamsController::aws_upload_image($filePath, $folderPath, $fileName);
          $input['team2_player_image'] = env('CDN_URL') . 'uploads/player/' . $uploadedFileName;

          // Delete local file after uploading to AWS
          @unlink(public_path($filePath));
        } else {
          Session::flash('error', trans("messages.$this->model.INVALID_IMAGE_EXTENSION"));
          return Redirect::back()->withInput();
        }
      }



      // dd('s');

      // DB::table('listmatches')->where('matchkey',$matchkey)->update($input);
      DB::table('listmatches')->where('matchkey', $matchkey)->where('sport_type', $sports_key)->update($input);
      if ($input['second_inning_allow'] == 1) {
        $firstInningMatch = DB::table('listmatches')->where('matchkey', $matchkey)->where('second_inning_allow', 1)->first();
        if (!empty($firstInningMatch)) {
          $firstInningMatch->second_inning_allow = 0;
          $firstInningMatch->id = '';
          $firstInningMatch->second_inning = 1;
          $firstInningMatch->matchkey = $firstInningMatch->matchkey . "_2";
          $firstInningMatch->start_date = $input_second_inning_start_date;
          $firstInningMatch->name = $firstInningMatch->name . " Second Inning";
          $firstInningMatch->title = $firstInningMatch->title . " Second Inning";
          $firstInningMatch->announcement = "Second Inning";
          $firstInningMatch->launch_status = 'pending';
          $findSecondInning = DB::table('listmatches')->where('matchkey', 'LIKE', '%' . $matchkey . '%')->where('second_inning', 1)->first();
          if (empty($findSecondInning)) {
            DB::table('listmatches')->insert((array) $firstInningMatch);
          } else {
            $updateSecondInnData['start_date'] = $input_second_inning_start_date;
            DB::table('listmatches')->where('id', $findSecondInning->id)->update($updateSecondInnData);
          }


          $findMatchPlayers = DB::table('matchplayers')->where('matchkey', $matchkey)->get();
          if (!empty($findMatchPlayers)) {
            foreach ($findMatchPlayers as $record) {
              unset($record->id);
              $record->matchkey = $record->matchkey . "_2";
              $findplayer1entry = DB::table('matchplayers')->where('matchkey', $record->matchkey)->where('playerid', $record->playerid)->first();
              if (empty($findplayer1entry)) {

                DB::table('matchplayers')->insert(get_object_vars($record));
              } else {
                DB::table('matchplayers')->where('matchkey', $record->matchkey)->where('playerid', $record->playerid)->update(get_object_vars($record));
              }
            }
          }
        }
      }


      Session::flash('flash_notice', 'Successfully updated match details!');
      Helpers::logActivity('Successfully updated match details!', $matchkey);
      Session::flash('alert-class', 'alert-success');
      return Redirect::route("$this->model.matchmapping", [$sports_key]);
    }
    // echo $sports_key; exit;
    $findmatchdetails = DB::table('listmatches')
      ->join('teams as t1', 't1.id', '=', 'listmatches.team1')
      ->join('teams as t2', 't2.id', '=', 'listmatches.team2')
      ->where('matchkey', $matchkey)
      ->where('listmatches.sport_type', $sports_key)
      ->select(
        't1.id as team1id',
        't2.id as team2id',
        't1.team as team1name',
        't2.team as team2name',
        't1.team_key as team1key',
        't2.team_key as team2key',
        'listmatches.id as listmatchid',
        'listmatches.*'
      )
      ->first();
    //echo "<pre>"; print_r($findmatchdetails); exit;
    $findmatchseries = DB::table('series')->where('series_status', 'opened')->where('end_date', '>=', $currentdate)->where('sport_type', $findmatchdetails->sport_type)->get();

    //dd($findmatchseries);
    $matchformat = Helpers::allmatchformats();

    $match = !empty($findmatchdetails->status) ? $findmatchdetails->status : 'pending';
    //View Page
    return view("admin.$this->model.editmatch", compact('findmatchdetails', 'findmatchseries', 'matchformat', 'sports_key', 'match'));
  }

  public function teammapping($matchkey)
  {
    $findmatchdetails = DB::table('listmatches')->join('teams as t1', 't1.id', '=', 'listmatches.team1')->join('teams as t2', 't2.id', '=', 'listmatches.team2')->where('matchkey', $matchkey)->select('t1.id as team1id', 't2.id as team2id', 't1.team as team1name', 't2.team as team2name', 't1.team_key as team1key', 't2.team_key as team2key', 'listmatches.name', 'listmatches.id as listmatchid', 'listmatches.start_date', 'listmatches.matchkey')->first();
    return view('matches.teammapping', compact('findmatchdetails'));
  }

  public function launchmatch($matchkey, $sport_type = 1)
  {
    // echo $sport_type; exit;
    $findmatchdetails = DB::table('listmatches')
      ->join('teams as t1', 't1.id', '=', 'listmatches.team1')
      ->join('teams as t2', 't2.id', '=', 'listmatches.team2')
      ->where('listmatches.sport_type', $sport_type)
      ->where('matchkey', $matchkey)
      ->select(
        't1.id as team1id',
        't2.id as team2id',
        't1.team as team1name',
        't2.team as team2name',
        'listmatches.sport_type as sport_type',
        't1.team_key as team1key',
        't2.team_key as team2key',
        't2.team_key as team2key',
        't1.logo as team1logo',
        't2.logo as team2logo',
        'listmatches.id as listmatchid',
        'listmatches.*'
      )
      ->first();
    // echo "<pre>"; print_r($findmatchdetails); exit;
    $batsman1 = 0;
    $batsman2 = 0;
    $bowlers1 = 0;
    $bowlers2 = 0;
    $allrounder1 = 0;
    $allrounder2 = 0;
    $wk1 = 0;
    $wk2 = 0;
    $criteria = 1;
    if (!empty($findmatchdetails)) {
      $team1 = $findmatchdetails->team1;
      $team2 = $findmatchdetails->team2;
      $findallmatchplayers = DB::table('matchplayers')->where('matchkey', $matchkey)->join('players', 'matchplayers.playerid', '=', 'players.id')->select('players.team', 'matchplayers.*')->orderBy('batting_order', "ASC")->get();
      if (!empty($findallmatchplayers)) {
        foreach ($findallmatchplayers as $matchplay) {
          /*
                    if($matchplay->team==$team1){
                        if($matchplay->role=='bowler'){
                            $bowlers1++;
                        }
                        if($matchplay->role=='batsman'){
                            $batsman1++;
                        }
                        if($matchplay->role=='allrounder'){
                            $allrounder1++;
                        }
                        if($matchplay->role=='keeper'){
                            $wk1++;
                        }
                        if($matchplay->role==""){
                            $criteria=0;
                            Session::flash('message', 'You cannot launch this match because the role of '.ucwords($matchplay->name).' is not defined.');
                            Session::flash('alert-class', 'alert-danger'); echo 1; exit;
                            return Redirect()->action('MatchesController@launchmatch',$matchkey);
                        }
                    }
                    if($matchplay->team==$team2){
                        if($matchplay->role=='bowler'){
                            $bowlers2++;
                        }
                        if($matchplay->role=='batsman'){
                            $batsman2++;
                        }
                        if($matchplay->role=='allrounder'){
                            $allrounder2++;
                        }
                        if($matchplay->role=='keeper'){
                            $wk2++;
                        }
                        if($matchplay->role==""){
                            $criteria=0; echo 2; exit;
                            return Redirect()->action('App\Http\Controllers\Admin\MatchesController@launchmatch',$matchkey)->withErrors('You cannot launch this match because the role of '.ucwords($matchplay->name).' is not defined.');
                        }
                    }
                */
        }
      }
    }
    //echo 4;exit;
    $showlineup = DB::table('listmatches')->where('matchkey', $matchkey)->first();
    return view("admin.$this->model.launchmatch", compact('findmatchdetails', 'batsman1', 'batsman2', 'bowlers1', 'bowlers2', 'allrounder1', 'allrounder2', 'wk1', 'wk2', 'showlineup', 'team1', 'team2'));
  }

  public function launchmatchOrderClear($matchkey, $sport_type = 1, $team)
  {
    $order_exit = DB::table('matchplayers')
      ->join('players', 'players.id', '=', 'matchplayers.playerid')
      ->where('matchkey', $matchkey)
      ->where('players.team', $team)
      ->update(['batting_order' => 0]);

    // $findallmatchplayers = DB::table('matchplayers')->where('matchkey',$matchkey)->update(['batting_order'=>0]);
    return Redirect::route($this->model . '.launchmatch', $matchkey);
  }

  public function launchmatchshowlineup(Request $request)
  {
    $matchkey = $request->matchkey;
    $findallmatchplayers = DB::table('listmatches')->where('matchkey', $matchkey)->first();
    if (!empty($findallmatchplayers)) {
      if (empty($request->is_set_lineup)) {
        $linrupdate = 0;
      } else {
        $linrupdate = 1;
      }
      DB::table('listmatches')->where('matchkey', $matchkey)->update(['is_set_lineup' => $linrupdate]);
    }
    return Redirect::route($this->model . '.launchmatch', [$matchkey, $request->sport_type]);
  }




  public function launch($matchkey, $sport_type = 1)
  {
    // $matchkey = 'c.match.kista_cricket_club_vs_stockholm_mumbai_indians.0ce83';
    $sportType  = DB::table('sport_types')->where('id', $sport_type)->first();
    $datastatus['launch_status'] = 'launched';

    $findmatch = DB::table('listmatches')->where('matchkey', $matchkey)->where('sport_type', $sportType->id)->first();
    // print_r($findmatch); exit;
    if (!empty($findmatch)) {
      if ($findmatch->series == 0 || $findmatch->series == "") {
        Session::flash('message', 'You cannot launch this match. Series is required in this match.');

        Session::flash('alert-class', 'alert-danger');

        return Redirect::back();
      }

      switch ($sportType->sport_key) {
        case CRICKET: {
            $team1 = $findmatch->team1;
            $team2 = $findmatch->team2;
            $batsman1 = 0;
            $batsman2 = 0;
            $bowlers1 = 0;
            $bowlers2 = 0;
            $allrounder1 = 0;
            $allrounder2 = 0;
            $wk1 = 0;
            $wk2 = 0;
            $criteria = 1;
            $findallmatchplayers = DB::table('matchplayers')->where('matchkey', $matchkey)->join('players', 'matchplayers.playerid', '=', 'players.id')->select('players.team', 'matchplayers.*')->get();

            if (!empty($findallmatchplayers)) {

              foreach ($findallmatchplayers as $matchplay) {

                if ($matchplay->team == $team1) {

                  if ($matchplay->role == 'bowler') {

                    $bowlers1++;
                  }

                  if ($matchplay->role == 'batsman') {

                    $batsman1++;
                  }

                  if ($matchplay->role == 'allrounder') {

                    $allrounder1++;
                  }

                  if ($matchplay->role == 'keeper') {

                    $wk1++;
                  }

                  if ($matchplay->role == "") {
                    // echo 1; exit;
                    $criteria = 0;

                    Session::flash('message', 'You cannot launch this match because the role of ' . ucwords($matchplay->name) . ' is not defined.');

                    Session::flash('alert-class', 'alert-danger');

                    return Redirect::back();
                  }
                }

                if ($matchplay->team == $team2) {

                  if ($matchplay->role == 'bowler') {

                    $bowlers2++;
                  }

                  if ($matchplay->role == 'batsman') {

                    $batsman2++;
                  }

                  if ($matchplay->role == 'allrounder') {

                    $allrounder2++;
                  }

                  if ($matchplay->role == 'keeper') {

                    $wk2++;
                  }

                  if ($matchplay->role == "") {

                    $criteria = 0;

                    // return Redirect()->action('MatchesController@launchmatch',$matchkey)->withErrors('You cannot launch this match because the role of '.ucwords($matchplay->name).' is not defined.');
                    // return Redirect::back()->withErrors('You cannot launch this match because the role of '.ucwords($matchplay->name).' is not defined.');;

                  }
                }
              }
              if ($bowlers1 < 3) {

                // $criteria=0;

                // return Redirect::back()->withErrors('Minimum 3 bowlers are required in team1 to launch this match');
                echo 1;
              } else if ($bowlers2 < 3) {
                echo 2;
                // $criteria=0;

                // return Redirect::back()->withErrors('Minimum 3 bowlers are required in team2 to launch this match');

              } else if ($batsman1 < 3) {
                echo 3;
                // $criteria=0;

                // return Redirect::back()->withErrors('Minimum 3 batman are required in team1 to launch this match');

              } else if ($batsman2 < 3) {
                echo 5;
                // $criteria=0;

                // return Redirect::back()->withErrors('Minimum 3 batman are required in team2 to launch this match');

              } else if ($wk1 < 1) {
                echo 4;
                $criteria = 0;

                // return Redirect::back()->withErrors('Minimum 1 wicketkeeper is required in team1 to launch this match');

              } else if ($wk2 < 1) {
                echo 6;
                $criteria = 0;

                // return Redirect::back()->withErrors('Minimum 1 wicketkeeper is required in team2 to launch this match');

              } else if ($allrounder1 < 1) {
                echo 7;
                // $criteria=0;

                // return Redirect::back()->withErrors('Minimum 1 all rounder are required in team1 to launch this match');

              } else if ($allrounder2 < 1) {
                echo 8;
                // $criteria=0;

                // return Redirect::back()->withErrors('Minimum 1 all rounder are required in team2 to launch this match');

              }
            }
            // echo $criteria; exit;
            if ($criteria == 1) {

              return redirect()->action('App\Http\Controllers\Admin\MatchesController@selectleaguesforlaunch', [$matchkey, $sport_type]);
              //     DB::table('listmatches')->where('matchkey', $matchkey)->where('sport_type',$sportType->id)->update($datastatus);
              //
              //     // insert normal challnege//
              //     $challengesCategory = DB::table('challenges_category')->where('sport_type',1)->get();
              //     $categories = [];
              //     foreach($challengesCategory  as $category){
              //         $categories[] = $category->id;
              //     }
              //
              //
              //     $findleauges = DB::table('challenges')->where('global', 1)->whereIn('challenge_category_id',$categories)->get();
              //     $charray = array();
              //
              //
              //     if (!empty($findleauges)) {
              //
              //     // print_r("there");die;
              //         foreach ($findleauges as $ll) {
              //     $data['challenge_id'] = $ll->id;
              //     $data['entryfee'] = $ll->entryfee;
              //     $data['win_amount'] = $ll->win_amount;
              //     $data['challenge_type'] = $ll->challenge_type;
              //     $data['winning_percentage'] = $ll->winning_percentage;
              //     $data['minimum_user'] = $ll->minimum_user;
              //     $data['maximum_user'] = $ll->maximum_user;
              //     $data['multi_entry'] = $ll->multi_entry;
              //     $data['bonus'] = $ll->bonus;
              //     $data['bonus_precent'] = $ll->bonus_precent;
              //     // $data['max_team_limit'] = $ll->max_team_limit;
              //     $data['confirmed_challenge'] = $ll->confirmed_challenge;
              //     $data['is_running'] = $ll->is_running;
              //     $data['is_flexible'] = $ll->is_flexible;
              //     $data['loops'] = $ll->loops;
              //     $data['matchkey'] = $findmatch->matchkey;
              //     $data['challenge_category_id'] = $ll->challenge_category_id;
              //     $findchallenge = DB::table('matchchallenges')->where('challenge_id',$ll->id)->where('matchkey',$matchkey)->first();
              //     if(empty($findchallenge)){
              //         DB::table('matchchallenges');
              //         $getcid = DB::table('matchchallenges')->insertGetId($data);
              //         $findpricecrads = DB::table('pricecards')->where('challenge_id',$ll->id)->get();
              //         if(!empty($findpricecrads)){
              //             foreach($findpricecrads as $pricec){
              //                 $pdata['challenge_id'] = $getcid;
              //                 $pdata['matchkey'] = $findmatch->matchkey;
              //                 $pdata['winners'] = $pricec->winners;
              //                 $pdata['price'] = $pricec->price;
              //                 $pdata['min_position'] = $pricec->min_position;
              //                 $pdata['max_position'] = $pricec->max_position;
              //                 $pdata['description'] = $pricec->description;
              //                 $pdata['total'] = $pricec->total;
              //                 DB::table('matchpricecards');
              //                 DB::table('matchpricecards')->insert($pdata);
              //             }
              //         }
              //     }
              // }
              //
              //     }
            }
          }
          break;
        case FOOTBALL: {
            $team1 = $findmatch->team1;
            $team2 = $findmatch->team2;

            $batsman1 = 0;
            $batsman2 = 0;
            $bowlers1 = 0;
            $bowlers2 = 0;
            $allrounder1 = 0;
            $allrounder2 = 0;
            $wk1 = 0;
            $wk2 = 0;
            $criteria = 1;
            /* need to be decide how many playes role on football.
                        $findallmatchplayers = DB::table('matchplayers')->where('matchkey',$matchkey)->where('sport_type' ,$sportType->id)->join('players','matchplayers.playerid','=','players.id')->select('players.team','matchplayers.*')->get();
                        if(!empty($findallmatchplayers)){

                            foreach($findallmatchplayers as $matchplay){

                                if($matchplay->team==$team1){

                                    if($matchplay->role=='bowler'){

                                        $bowlers1++;

                                    }

                                    if($matchplay->role=='batsman'){

                                        $batsman1++;

                                    }

                                    if($matchplay->role=='allrounder'){

                                        $allrounder1++;

                                    }

                                    if($matchplay->role=='keeper'){

                                        $wk1++;

                                    }

                                    if($matchplay->role==""){

                                        $criteria=0;

                                        Session::flash('message', 'You cannot launch this match because the role of '.ucwords($matchplay->name).' is not defined.');

                                        Session::flash('alert-class', 'alert-danger');

                                        return Redirect()->action('MatchesController@launchmatch',$matchkey);

                                    }

                                }

                                if($matchplay->team==$team2){

                                    if($matchplay->role=='bowler'){

                                        $bowlers2++;

                                    }

                                    if($matchplay->role=='batsman'){

                                        $batsman2++;

                                    }

                                    if($matchplay->role=='allrounder'){

                                        $allrounder2++;

                                    }

                                    if($matchplay->role=='keeper'){

                                        $wk2++;

                                    }

                                    if($matchplay->role==""){

                                        $criteria=0;

                                        return Redirect()->action('MatchesController@launchmatch',$matchkey)->withErrors('You cannot launch this match because the role of '.ucwords($matchplay->name).' is not defined.');

                                    }

                                }

                            }

                            if($bowlers1<3){

                                $criteria=0;

                                return Redirect()->action('MatchesController@launchmatch',$matchkey)->withErrors('Minimum 3 bowlers are required in team1 to launch this match');

                            }

                            else if($bowlers2<3){

                                $criteria=0;

                                return Redirect()->action('MatchesController@launchmatch',$matchkey)->withErrors('Minimum 3 bowlers are required in team2 to launch this match');

                            }

                            else if($batsman1<3){

                                $criteria=0;

                                return Redirect()->action('MatchesController@launchmatch',$matchkey)->withErrors('Minimum 3 batman are required in team1 to launch this match');

                            }

                            else if($batsman2<3){

                                $criteria=0;

                                return Redirect()->action('MatchesController@launchmatch',$matchkey)->withErrors('Minimum 3 batman are required in team2 to launch this match');

                            }

                            else if($wk1<1){

                                $criteria=0;

                                return Redirect()->action('MatchesController@launchmatch',$matchkey)->withErrors('Minimum 1 wicketkeeper is required in team1 to launch this match');

                            }

                            else if($wk2<1){

                                $criteria=0;

                                return Redirect()->action('MatchesController@launchmatch',$matchkey)->withErrors('Minimum 1 wicketkeeper is required in team2 to launch this match');

                            }

                            else if($allrounder1<1){

                                $criteria=0;

                                return Redirect()->action('MatchesController@launchmatch',$matchkey)->withErrors('Minimum 1 all rounder are required in team1 to launch this match');

                            }

                            else if($allrounder2<1){

                                $criteria=0;

                                return Redirect()->action('MatchesController@launchmatch',$matchkey)->withErrors('Minimum 1 all rounder are required in team2 to launch this match');

                            }

                        }
*/
            if ($criteria == 1) {
              return redirect()->action('App\Http\Controllers\Admin\MatchesController@selectleaguesforlaunch', [$matchkey, $sport_type]);
              // DB::table('listmatches')->where('matchkey', $matchkey)->where('sport_type' ,$sportType->id)->update($datastatus);
              //
              // // insert normal challnege//
              // $challengesCategory = DB::table('challenges_category')->where('sport_type',1)->get();
              // $categories = [];
              // foreach($challengesCategory  as $category){
              //     $categories[] = $category->id;
              // }
              // // print_r($categories);die;
              // $findleauges = DB::table('challenges')->where('global', 1)->whereIn('challenge_category_id',$categories)->get();
              //
              // $charray = array();
              //
              // if (!empty($findleauges)) {
              //     foreach ($findleauges as $ll) {
              //         $data['challenge_id'] = $ll->id;
              //         $data['entryfee'] = $ll->entryfee;
              //         $data['win_amount'] = $ll->win_amount;
              //         $data['challenge_type'] = $ll->challenge_type;
              //         $data['winning_percentage'] = $ll->winning_percentage;
              //         $data['minimum_user'] = $ll->minimum_user;
              //         $data['maximum_user'] = $ll->maximum_user;
              //         // $data['max_team_limit'] = $ll->max_team_limit;
              //         $data['multi_entry'] = $ll->multi_entry;
              //         $data['bonus'] = $ll->bonus;
              //         $data['bonus_precent'] = $ll->bonus_precent;
              //         $data['confirmed_challenge'] = $ll->confirmed_challenge;
              //         $data['is_running'] = $ll->is_running;
              //         // $data['is_flexible'] = $ll->is_flexible;
              //         $data['loops'] = $ll->loops;
              //         $data['matchkey'] = $findmatch->matchkey;
              //         $data['challenge_category_id'] = $ll->challenge_category_id;
              //         $data['sport_type'] = $sportType->id;
              //         $findchallenge = DB::table('matchchallenges')->where('challenge_id', $ll->id)->where('matchkey', $matchkey)->first();
              //         if (empty($findchallenge)) {
              //             DB::table('matchchallenges');
              //             $getcid = DB::table('matchchallenges')->insertGetId($data);
              //             $findpricecrads = DB::table('pricecards')->where('challenge_id', $ll->id)->get();
              //             // print_r($findpricecrads); exit;
              //             if (!empty($findpricecrads)) {
              //                 foreach ($findpricecrads as $pricec) {
              //                     $pdata['challenge_id'] = $getcid;
              //                     $pdata['matchkey'] = $findmatch->matchkey;
              //                     $pdata['winners'] = $pricec->winners;
              //                     $pdata['price'] = $pricec->price;
              //                     $pdata['min_position'] = $pricec->min_position;
              //                     $pdata['max_position'] = $pricec->max_position;
              //                     $pdata['description'] = $pricec->description;
              //                     $pdata['total'] = $pricec->total;
              //                     DB::table('matchpricecards');
              //                     DB::table('matchpricecards')->insert($pdata);
              //                 }
              //             }
              //         }
              //     }
              // }
            }
          }
          break;
        // KABADDI START//
        case 'KABADDI': {
            $team1 = $findmatch->team1;
            $team2 = $findmatch->team2;

            $batsman1 = 0;
            $batsman2 = 0;
            $bowlers1 = 0;
            $bowlers2 = 0;
            $allrounder1 = 0;
            $allrounder2 = 0;
            $wk1 = 0;
            $wk2 = 0;
            $criteria = 1;
            /* need to be decide how many playes role on football.
                        $findallmatchplayers = DB::table('matchplayers')->where('matchkey',$matchkey)->where('sport_type' ,$sportType->id)->join('players','matchplayers.playerid','=','players.id')->select('players.team','matchplayers.*')->get();
                        if(!empty($findallmatchplayers)){

                            foreach($findallmatchplayers as $matchplay){

                                if($matchplay->team==$team1){

                                    if($matchplay->role=='bowler'){

                                        $bowlers1++;

                                    }

                                    if($matchplay->role=='batsman'){

                                        $batsman1++;

                                    }

                                    if($matchplay->role=='allrounder'){

                                        $allrounder1++;

                                    }

                                    if($matchplay->role=='keeper'){

                                        $wk1++;

                                    }

                                    if($matchplay->role==""){

                                        $criteria=0;

                                        Session::flash('message', 'You cannot launch this match because the role of '.ucwords($matchplay->name).' is not defined.');

                                        Session::flash('alert-class', 'alert-danger');

                                        return Redirect()->action('MatchesController@launchmatch',$matchkey);

                                    }

                                }

                                if($matchplay->team==$team2){

                                    if($matchplay->role=='bowler'){

                                        $bowlers2++;

                                    }

                                    if($matchplay->role=='batsman'){

                                        $batsman2++;

                                    }

                                    if($matchplay->role=='allrounder'){

                                        $allrounder2++;

                                    }

                                    if($matchplay->role=='keeper'){

                                        $wk2++;

                                    }

                                    if($matchplay->role==""){

                                        $criteria=0;

                                        return Redirect()->action('MatchesController@launchmatch',$matchkey)->withErrors('You cannot launch this match because the role of '.ucwords($matchplay->name).' is not defined.');

                                    }

                                }

                            }

                            if($bowlers1<3){

                                $criteria=0;

                                return Redirect()->action('MatchesController@launchmatch',$matchkey)->withErrors('Minimum 3 bowlers are required in team1 to launch this match');

                            }

                            else if($bowlers2<3){

                                $criteria=0;

                                return Redirect()->action('MatchesController@launchmatch',$matchkey)->withErrors('Minimum 3 bowlers are required in team2 to launch this match');

                            }

                            else if($batsman1<3){

                                $criteria=0;

                                return Redirect()->action('MatchesController@launchmatch',$matchkey)->withErrors('Minimum 3 batman are required in team1 to launch this match');

                            }

                            else if($batsman2<3){

                                $criteria=0;

                                return Redirect()->action('MatchesController@launchmatch',$matchkey)->withErrors('Minimum 3 batman are required in team2 to launch this match');

                            }

                            else if($wk1<1){

                                $criteria=0;

                                return Redirect()->action('MatchesController@launchmatch',$matchkey)->withErrors('Minimum 1 wicketkeeper is required in team1 to launch this match');

                            }

                            else if($wk2<1){

                                $criteria=0;

                                return Redirect()->action('MatchesController@launchmatch',$matchkey)->withErrors('Minimum 1 wicketkeeper is required in team2 to launch this match');

                            }

                            else if($allrounder1<1){

                                $criteria=0;

                                return Redirect()->action('MatchesController@launchmatch',$matchkey)->withErrors('Minimum 1 all rounder are required in team1 to launch this match');

                            }

                            else if($allrounder2<1){

                                $criteria=0;

                                return Redirect()->action('MatchesController@launchmatch',$matchkey)->withErrors('Minimum 1 all rounder are required in team2 to launch this match');

                            }

                        }
                      */
            if ($criteria == 1) {
              return redirect()->action('App\Http\Controllers\Admin\MatchesController@selectleaguesforlaunch', [$matchkey, $sport_type]);
              // DB::table('listmatches')->where('matchkey', $matchkey)->where('sport_type' ,$sportType->id)->update($datastatus);
              //
              // // insert normal challnege//
              // $challengesCategory = DB::table('challenges_category')->where('sport_type',1)->get();
              // $categories = [];
              // foreach($challengesCategory  as $category){
              //     $categories[] = $category->id;
              // }
              // // print_r($categories);die;
              // $findleauges = DB::table('challenges')->where('global', 1)->whereIn('challenge_category_id',$categories)->get();
              //
              // $charray = array();
              //
              // if (!empty($findleauges)) {
              //     foreach ($findleauges as $ll) {
              //         $data['challenge_id'] = $ll->id;
              //         $data['entryfee'] = $ll->entryfee;
              //         $data['win_amount'] = $ll->win_amount;
              //         $data['challenge_type'] = $ll->challenge_type;
              //         $data['winning_percentage'] = $ll->winning_percentage;
              //         $data['minimum_user'] = $ll->minimum_user;
              //         $data['maximum_user'] = $ll->maximum_user;
              //         // $data['max_team_limit'] = $ll->max_team_limit;
              //         $data['multi_entry'] = $ll->multi_entry;
              //         $data['bonus'] = $ll->bonus;
              //         $data['bonus_precent'] = $ll->bonus_precent;
              //         $data['confirmed_challenge'] = $ll->confirmed_challenge;
              //         $data['is_running'] = $ll->is_running;
              //         // $data['is_flexible'] = $ll->is_flexible;
              //         $data['loops'] = $ll->loops;
              //         $data['matchkey'] = $findmatch->matchkey;
              //         $data['challenge_category_id'] = $ll->challenge_category_id;
              //         $data['sport_type'] = $sportType->id;
              //         $findchallenge = DB::table('matchchallenges')->where('challenge_id', $ll->id)->where('matchkey', $matchkey)->first();
              //         if (empty($findchallenge)) {
              //             DB::table('matchchallenges');
              //             $getcid = DB::table('matchchallenges')->insertGetId($data);
              //             $findpricecrads = DB::table('pricecards')->where('challenge_id', $ll->id)->get();
              //             // print_r($findpricecrads); exit;
              //             if (!empty($findpricecrads)) {
              //                 foreach ($findpricecrads as $pricec) {
              //                     $pdata['challenge_id'] = $getcid;
              //                     $pdata['matchkey'] = $findmatch->matchkey;
              //                     $pdata['winners'] = $pricec->winners;
              //                     $pdata['price'] = $pricec->price;
              //                     $pdata['min_position'] = $pricec->min_position;
              //                     $pdata['max_position'] = $pricec->max_position;
              //                     $pdata['description'] = $pricec->description;
              //                     $pdata['total'] = $pricec->total;
              //                     DB::table('matchpricecards');
              //                     DB::table('matchpricecards')->insert($pdata);
              //                 }
              //             }
              //         }
              //     }
              // }
            }
          }
          break;
        //KABADDI END//
        case BASKETBALL: {
            $team1 = $findmatch->team1;
            $team2 = $findmatch->team2;

            $batsman1 = 0;
            $batsman2 = 0;
            $bowlers1 = 0;
            $bowlers2 = 0;
            $allrounder1 = 0;
            $allrounder2 = 0;
            $wk1 = 0;
            $wk2 = 0;
            $criteria = 1;
            /* need to be decide how many playes role on football.
                                                    $findallmatchplayers = DB::table('matchplayers')->where('matchkey',$matchkey)->where('sport_type' ,$sportType->id)->join('players','matchplayers.playerid','=','players.id')->select('players.team','matchplayers.*')->get();
                                                    if(!empty($findallmatchplayers)){

                                                        foreach($findallmatchplayers as $matchplay){

                                                            if($matchplay->team==$team1){

                                                                if($matchplay->role=='bowler'){

                                                                    $bowlers1++;

                                                                }

                                                                if($matchplay->role=='batsman'){

                                                                    $batsman1++;

                                                                }

                                                                if($matchplay->role=='allrounder'){

                                                                    $allrounder1++;

                                                                }

                                                                if($matchplay->role=='keeper'){

                                                                    $wk1++;

                                                                }

                                                                if($matchplay->role==""){

                                                                    $criteria=0;

                                                                    Session::flash('message', 'You cannot launch this match because the role of '.ucwords($matchplay->name).' is not defined.');

                                                                    Session::flash('alert-class', 'alert-danger');

                                                                    return Redirect()->action('MatchesController@launchmatch',$matchkey);

                                                                }

                                                            }

                                                            if($matchplay->team==$team2){

                                                                if($matchplay->role=='bowler'){

                                                                    $bowlers2++;

                                                                }

                                                                if($matchplay->role=='batsman'){

                                                                    $batsman2++;

                                                                }

                                                                if($matchplay->role=='allrounder'){

                                                                    $allrounder2++;

                                                                }

                                                                if($matchplay->role=='keeper'){

                                                                    $wk2++;

                                                                }

                                                                if($matchplay->role==""){

                                                                    $criteria=0;

                                                                    return Redirect()->action('MatchesController@launchmatch',$matchkey)->withErrors('You cannot launch this match because the role of '.ucwords($matchplay->name).' is not defined.');

                                                                }

                                                            }

                                                        }

                                                        if($bowlers1<3){

                                                            $criteria=0;

                                                            return Redirect()->action('MatchesController@launchmatch',$matchkey)->withErrors('Minimum 3 bowlers are required in team1 to launch this match');

                                                        }

                                                        else if($bowlers2<3){

                                                            $criteria=0;

                                                            return Redirect()->action('MatchesController@launchmatch',$matchkey)->withErrors('Minimum 3 bowlers are required in team2 to launch this match');

                                                        }

                                                        else if($batsman1<3){

                                                            $criteria=0;

                                                            return Redirect()->action('MatchesController@launchmatch',$matchkey)->withErrors('Minimum 3 batman are required in team1 to launch this match');

                                                        }

                                                        else if($batsman2<3){

                                                            $criteria=0;

                                                            return Redirect()->action('MatchesController@launchmatch',$matchkey)->withErrors('Minimum 3 batman are required in team2 to launch this match');

                                                        }

                                                        else if($wk1<1){

                                                            $criteria=0;

                                                            return Redirect()->action('MatchesController@launchmatch',$matchkey)->withErrors('Minimum 1 wicketkeeper is required in team1 to launch this match');

                                                        }

                                                        else if($wk2<1){

                                                            $criteria=0;

                                                            return Redirect()->action('MatchesController@launchmatch',$matchkey)->withErrors('Minimum 1 wicketkeeper is required in team2 to launch this match');

                                                        }

                                                        else if($allrounder1<1){

                                                            $criteria=0;

                                                            return Redirect()->action('MatchesController@launchmatch',$matchkey)->withErrors('Minimum 1 all rounder are required in team1 to launch this match');

                                                        }

                                                        else if($allrounder2<1){

                                                            $criteria=0;

                                                            return Redirect()->action('MatchesController@launchmatch',$matchkey)->withErrors('Minimum 1 all rounder are required in team2 to launch this match');

                                                        }

                                                    }
                            */
            if ($criteria == 1) {
              return redirect()->action('App\Http\Controllers\Admin\MatchesController@selectleaguesforlaunch', [$matchkey, $sport_type]);
              // DB::table('listmatches')->where('matchkey', $matchkey)->where('sport_type' ,$sportType->id)->update($datastatus);
              //
              // // insert normal challnege//
              // $challengesCategory = DB::table('challenges_category')->where('sport_type',1)->get();
              // // print_r($challengesCategory); exit;
              // $categories = [];
              // foreach($challengesCategory  as $category){
              //     $categories[] = $category->id;
              // }
              //
              //
              // $findleauges = DB::table('challenges')->where('global', 1)->whereIn('challenge_category_id',$categories)->get();
              //
              // $charray = array();
              //
              // if (!empty($findleauges)) {
              //     foreach ($findleauges as $ll) {
              //         $data['challenge_id'] = $ll->id;
              //         $data['entryfee'] = $ll->entryfee;
              //         $data['win_amount'] = $ll->win_amount;
              //         $data['challenge_type'] = $ll->challenge_type;
              //         $data['winning_percentage'] = $ll->winning_percentage;
              //         $data['minimum_user'] = $ll->minimum_user;
              //         $data['maximum_user'] = $ll->maximum_user;
              //         $data['multi_entry'] = $ll->multi_entry;
              //         // $data['max_team_limit'] = $ll->max_team_limit;
              //         $data['bonus'] = $ll->bonus;
              //         $data['bonus_precent'] = $ll->bonus_precent;
              //         $data['confirmed_challenge'] = $ll->confirmed_challenge;
              //         $data['is_running'] = $ll->is_running;
              //         // $data['is_flexible'] = $ll->is_flexible;
              //         $data['loops'] = $ll->loops;
              //         $data['matchkey'] = $findmatch->matchkey;
              //         $data['challenge_category_id'] = $ll->challenge_category_id;
              //         $data['sport_type'] = $sportType->id;
              //         $findchallenge = DB::table('matchchallenges')->where('challenge_id', $ll->id)->where('matchkey', $matchkey)->first();
              //         if (empty($findchallenge)) {
              //             DB::table('matchchallenges');
              //             $getcid = DB::table('matchchallenges')->insertGetId($data);
              //             $findpricecrads = DB::table('pricecards')->where('challenge_id', $ll->id)->get();
              //             if (!empty($findpricecrads)) {
              //                 foreach ($findpricecrads as $pricec) {
              //                     $pdata['challenge_id'] = $getcid;
              //                     $pdata['matchkey'] = $findmatch->matchkey;
              //                     $pdata['winners'] = $pricec->winners;
              //                     $pdata['price'] = $pricec->price;
              //                     $pdata['min_position'] = $pricec->min_position;
              //                     $pdata['max_position'] = $pricec->max_position;
              //                     $pdata['description'] = $pricec->description;
              //                     $pdata['total'] = $pricec->total;
              //                     DB::table('matchpricecards');
              //                     DB::table('matchpricecards')->insert($pdata);
              //                 }
              //             }
              //         }
              //     }
              // }
            }
          }
          break;
      }
      //
      // Session::flash('message', 'Successfully launched this match!');
      //
      // Session::flash('alert-class', 'alert-success');

      return Redirect::back();
    } else {

      return redirect()->action('MatchesController@matchmapping')->withErrors('Invalid match Provided');
    }
  }
  public function viewchallenges()
  {
    $formData = Input::all();
    $is_editable = 0;
    if (isset($formData['is_update'])) {
      $is_editable = 1;
    }

    if (isset($formData) && !empty($formData)) {

      $query = DB::table('challenges')
        ->leftJoin('challenges_category', 'challenges_category.id', '=', 'challenges.challenge_category_id')
        ->select('challenges.*', 'challenges_category.name', 'challenges_category.sport_type')
        ->where(function ($query) use ($formData) {
          if (isset($formData['categoryId'])) {
            $query->where('challenges_category.id', '=', unserialize(base64_decode($formData['categoryId'])));
          }
          if (isset($formData['is_update']) && !empty($formData['is_update'])) {
            $data1 = DB::table('matchchallenges')->where('matchkey', $formData['matchkey'])
              ->where('challenge_category_id', unserialize(base64_decode($formData['categoryId'])))
              ->where('sport_type', $formData['sport_type'])
              ->pluck('real_challenge_id')->toArray();
            if (!empty($data1)) {
              $query->whereNotIn('challenges.id', $data1);
            }
          }
        })
        ->get();

      return Datatables::of($query)
        ->addColumn('#', function ($result) use ($formData) {


          $query = DB::table('matchchallenges')->where('matchkey', $formData['matchkey'])->where('challenge_id', $result->id);
          if ($formData['sport_type'] == 1) {
            $query->where('fantasy_type_id', 0);
          } else {
            $query->where('fantasy_type_id', 0);
          }

          $data1 = $query->where('challenge_category_id', unserialize(base64_decode($formData['categoryId'])))
            ->where('sport_type', $formData['sport_type'])
            ->first();

          if (empty($data1)) {

            return "<input type='checkbox' name='challenge_id' value='$result->id' onchange='addOrRemoveChallenge(event)'>";
          } else {
            return "<input type='checkbox' name='' value='' checked disabled>";
          }


          // if($is_editable == 0){
          //    return "<input type='checkbox' name='challenge_id' value='$result->id' onchange='addOrRemoveChallenge(event)'checked='checked'>";
          //  }else{
          //      return "<input type='checkbox' name='challenge_id' value='$result->id' onchange='addOrRemoveChallenge(event)'>";
          //  }
        })
        ->addIndexColumn()
        ->addIndexColumn()
        ->addColumn('live_fantasy', function ($result) use ($is_editable) {
          if (@$result->is_challenges_selected == 1  && $is_editable == 0) {
            return "<input type='checkbox' name='live_fantasy_challenge_id' id='live_fantasy_challenge_id' value='$result->id' onchange='addOrRemoveliveFanasyChallenge(event)' checked='checked'>";
          } else {
            return "<input type='checkbox' name='live_fantasy_challenge_id' id='live_fantasy_challenge_id' value='$result->id' onchange='addOrRemoveliveFanasyChallenge(event)'>";
          }
        })
        ->addColumn('batting_fantasy', function ($result) use ($is_editable) {
          if (@$result->is_challenges_selected == 1  && $is_editable == 0) {
            return "<input type='checkbox' name='batting_fantasy_challenge_id' id='batting_fantasy_challenge_id' value='$result->id' onchange='addOrRemovebattingFantasyChallenge(event)' checked='checked'>";
          } else {
            return "<input type='checkbox' name='batting_fantasy_challenge_id' id='batting_fantasy_challenge_id' value='$result->id' onchange='addOrRemovebattingFantasyChallenge(event)'>";
          }
        })
        ->addColumn('bowling_fantasy', function ($result) use ($is_editable) {
          if (@$is_editable == 0) {
            return "<input type='checkbox' name='bowling_fantasy_challenge_id' id='bowling_fantasy_challenge_id' value='$result->id' onchange='addOrRemovebowlingFantasyChallenge(event)' checked='checked'>";
          } else {
            return "<input type='checkbox' name='bowling_fantasy_challenge_id' id='bowling_fantasy_challenge_id' value='$result->id' onchange='addOrRemovebowlingFantasyChallenge(event)'>";
          }
        })
        ->addColumn('reverse_fantasy', function ($result) use ($is_editable) {
          if (@$is_editable == 0) {
            return "<input type='checkbox' name='reverse_fantasy_challenge_id' id='reverse_fantasy_challenge_id' value='$result->id' onchange='addOrRemovereverseFantasyChallenge(event)' checked='checked'>";
          } else {
            return "<input type='checkbox' name='reverse_fantasy_challenge_id' id='reverse_fantasy_challenge_id' value='$result->id' onchange='addOrRemovereverseFantasyChallenge(event)'>";
          }
        })
        ->addColumn('tenone_fantasy', function ($result) use ($formData) {
          $data1 = DB::table('matchchallenges')->where('matchkey', $formData['matchkey'])->where('challenge_id', $result->id)->where('fantasy_type_id', 0)
            ->where('challenge_category_id', unserialize(base64_decode($formData['categoryId'])))
            ->where('sport_type', $formData['sport_type'])
            ->first();

          if (empty($data1)) {

            return "<input type='checkbox' name='ten_one_fantasy_challenge_id' value='$result->id' onchange='addOrRemoveTenOneFantasyChallenge(event)'>";
          } else {
            return "<input type='checkbox' name='' value='' checked disabled>";
          }
          //  if(@$is_editable == 0){
          //  return "<input type='checkbox' name='ten_one_fantasy_challenge_id' id='ten_one_fantasy_challenge_id' value='$result->id' onchange='addOrRemoveTenOneFantasyChallenge(event)' checked='checked'>";
          // }else{
          //     return "<input type='checkbox' name='ten_one_fantasy_challenge_id' id='ten_one_fantasy_challenge_id' value='$result->id' onchange='addOrRemoveTenOneFantasyChallenge(event)'>";
          // }
        })
        ->addColumn('fiveone_fantasy', function ($result) use ($formData) {
          $data1 = DB::table('matchchallenges')->where('matchkey', $formData['matchkey'])->where('challenge_id', $result->id)
            ->where('fantasy_type_id', 6)
            ->where('challenge_category_id', unserialize(base64_decode($formData['categoryId'])))
            ->where('sport_type', $formData['sport_type'])
            ->first();

          if (empty($data1)) {

            return "<input type='checkbox' name='five_one_fantasy_challenge_id' value='$result->id' onchange='addOrRemoveFiveOneFantasyChallenge(event)'>";
          } else {
            return "<input type='checkbox' name='' value='' checked disabled>";
          }
          //  if(@$is_editable == 0){
          //  return "<input type='checkbox' name='five_one_fantasy_challenge_id' id='five_one_fantasy_challenge_id' value='$result->id' onchange='addOrRemoveFiveOneFantasyChallenge(event)' checked='checked'>";
          // }else{
          //     return "<input type='checkbox' name='five_one_fantasy_challenge_id' id='five_one_fantasy_challenge_id' value='$result->id' onchange='addOrRemoveFiveOneFantasyChallenge(event)'>";
          // }
        })
        ->addColumn('sort_order', function ($result) {
          return "<input type='number'  class='form-control' name='sort_order_" . $result->id . "' onchange='editSortingOrderInArray(" . $result->id . " , event)' value='0' >";
        })
        ->addColumn('sport_type', function ($result) {
          $db_sport_name = '';
          if (!empty($result->sport_type)) {
            $db_result = DB::table('sport_types')->where('id', $result->sport_type)->first();
            if (!empty($db_result)) {
              $db_sport_name = $db_result->sport_name;
            }
          }
          return $db_sport_name;
        })
        ->addColumn('challenge_type', function ($result) {
          $challenge_type = '';
          if ($result->challenge_type == 'money') {
            $challenge_type = ucwords('Fixed Challenge');
          } else {
            $challenge_type = ucwords('Percentage based');
          }
          return $challenge_type;
        })
        ->addColumn('maximum_user', function ($result) {
          $maximum_user = '';
          if ($result->challenge_type == 'money') {
            $maximum_user = $result->maximum_user;
          } else {
            $maximum_user = '-';
          }
          return $maximum_user;
        })
        ->addColumn('winning_percentage', function ($result) {
          $winning_percentage = '';
          if ($result->challenge_type != 'money') {
            $winning_percentage = $result->winning_percentage . ' %';
          } else {
            $winning_percentage = '-';
          }
          return $winning_percentage;
        })
        ->addColumn('multi_entry', function ($result) {
          $multi_entry = '';
          if ($result->multi_entry == 1) {
            $multi_entry = '<i class="fa fa-check" style="color:green">';
          } else {
            $multi_entry = '<i class="fa fa-times" style="color:red">';
          }
          return $multi_entry;
        })
        ->addColumn('bonus', function ($result) {
          $bonus = '';
          if ($result->bonus == 1) {
            $bonus = '<i class="fa fa-check" style="color:green">';
          } else {
            $bonus = '<i class="fa fa-times" style="color:red">';
          }
          return $bonus;
        })
        ->addColumn('is_running', function ($result) {
          $is_running = '';
          if ($result->is_running == 1) {
            $is_running = '<i class="fa fa-check" style="color:green">';
          } else {
            $is_running = '<i class="fa fa-times" style="color:red">';
          }
          return $is_running;
        })
        ->addColumn('confirmed_challenge', function ($result) {
          $confirmed_challenge = '';
          if ($result->confirmed_challenge == 1) {
            $confirmed_challenge = '<i class="fa fa-check" style="color:green">';
          } else {
            $confirmed_challenge = '<i class="fa fa-times" style="color:red">';
          }
          return $confirmed_challenge;
        })
        ->escapeColumns([])
        ->make(true);
    } //end

    return view("admin.$this->model.viewchallenges");
  }

  public function viewchallenges_old_23_11()
  {
    $formData = Input::all();
    if (isset($formData) && !empty($formData)) {
      return Datatables::of($query = DB::table('challenges')
        ->leftJoin('challenges_category', 'challenges_category.id', '=', 'challenges.challenge_category_id')
        ->select('challenges.*', 'challenges_category.name', 'challenges_category.sport_type')
        ->where(function ($query) use ($formData) {
          if (isset($formData['categoryId'])) {
            $query->where('challenges_category.id', '=', unserialize(base64_decode($formData['categoryId'])));
          }
        })
        ->get())
        ->addColumn('#', function ($result) {
          return "<input type='checkbox' name='challenge_id' value='$result->id' onchange='addOrRemoveChallenge(event)'>";
        })
        ->addIndexColumn()
        ->addColumn('sort_order', function ($result) {
          return "<input type='number'  class='form-control' name='sort_order_" . $result->id . "' onchange='editSortingOrderInArray(" . $result->id . " , event)' value='0' >";
        })
        ->addColumn('sport_type', function ($result) {
          $db_sport_name = '';
          if (!empty($result->sport_type)) {
            $db_result = DB::table('sport_types')->where('id', $result->sport_type)->first();
            if (!empty($db_result)) {
              $db_sport_name = $db_result->sport_name;
            }
          }
          return $db_sport_name;
        })
        ->addColumn('challenge_type', function ($result) {
          $challenge_type = '';
          if ($result->challenge_type == 'money') {
            $challenge_type = ucwords('Fixed Challenge');
          } else {
            $challenge_type = ucwords('Percentage based');
          }
          return $challenge_type;
        })
        ->addColumn('maximum_user', function ($result) {
          $maximum_user = '';
          if ($result->challenge_type == 'money') {
            $maximum_user = $result->maximum_user;
          } else {
            $maximum_user = '-';
          }
          return $maximum_user;
        })
        ->addColumn('winning_percentage', function ($result) {
          $winning_percentage = '';
          if ($result->challenge_type != 'money') {
            $winning_percentage = $result->winning_percentage . ' %';
          } else {
            $winning_percentage = '-';
          }
          return $winning_percentage;
        })
        ->addColumn('multi_entry', function ($result) {
          $multi_entry = '';
          if ($result->multi_entry == 1) {
            $multi_entry = '<i class="fa fa-check" style="color:green">';
          } else {
            $multi_entry = '<i class="fa fa-times" style="color:red">';
          }
          return $multi_entry;
        })
        ->addColumn('bonus', function ($result) {
          $bonus = '';
          if ($result->bonus == 1) {
            $bonus = '<i class="fa fa-check" style="color:green">';
          } else {
            $bonus = '<i class="fa fa-times" style="color:red">';
          }
          return $bonus;
        })
        ->addColumn('is_running', function ($result) {
          $is_running = '';
          if ($result->is_running == 1) {
            $is_running = '<i class="fa fa-check" style="color:green">';
          } else {
            $is_running = '<i class="fa fa-times" style="color:red">';
          }
          return $is_running;
        })
        ->addColumn('confirmed_challenge', function ($result) {
          $confirmed_challenge = '';
          if ($result->confirmed_challenge == 1) {
            $confirmed_challenge = '<i class="fa fa-check" style="color:green">';
          } else {
            $confirmed_challenge = '<i class="fa fa-times" style="color:red">';
          }
          return $confirmed_challenge;
        })
        ->escapeColumns([])
        ->make(true);
    } //end

    return view("admin.$this->model.viewchallenges");
  }

  public function submitleaguesforlaunch()
  {
    $formData = Input::all();

    // echo '<pre>'; print_r($formData);exit;
    if (isset($formData)) {

      $matchkey = $formData['matchId'];
      $sportType = $formData['sport_type'];
      $check_status = DB::table('listmatches')->where('matchkey', $matchkey)->where('sport_type', $sportType)->first();

      if (isset($formData['action_type']) == false && !empty($check_status) && $check_status->launch_status == "launched") {
        Session::flash('flash_notice', 'Match is already launched.');
        Session::flash('alert-class', 'alert-danger');
        return Redirect()->action('App\Http\Controllers\Admin\MatchesController@launchmatch', [$matchkey, $sportType]);
      }

      if ($sportType == 1) {
        // if(!empty($formData['ten_one_fantasy_challenge_id']) ||!empty($formData['five_one_fantasy_challenge_id'])){
        $this->submitleaguesforlaunch_new($formData);
        Session::flash('message', 'Successfully launched this match!');
        Session::flash('alert-class', 'alert-success');
        Helpers::logActivity('Successfully launched this match!', $matchkey);

        return Redirect()->action('App\Http\Controllers\Admin\MatchesController@launchmatch', [$matchkey, $sportType]);
        exit;
      } else {
        //$this->submitleaguesforlaunch_old($formData);
      }
      $challenge_ids = @$formData['challenge_ids'] ? $formData['challenge_ids'] : array();

      // var_dump($sportType);exit;
      $datastatus['launch_status'] = 'launched';
      DB::table('listmatches')->where('matchkey', $matchkey)->where('sport_type', $sportType)->update($datastatus);

      // insert normal challnege//
      // $challengesCategory = DB::table('challenges_category')->where('sport_type',$sportType->id)->get();
      $input_challengeId = [];
      $array_challenges = [];
      foreach ($challenge_ids  as $ch_id) {
        $array_challenges[] = json_decode($ch_id, true);
        $ch_id = json_decode($ch_id, true);
        $input_challengeId[] = $ch_id['challenge_id'];
      }

      $findleauges = DB::table('challenges')->where('global', 1)->whereIn('id', $input_challengeId)->get();
      $charray = array();

      // var_dump($findleauges);exit;
      if (!empty($findleauges)) {

        // print_r("there");die;

        foreach ($findleauges as $ll) {
          $data['challenge_id'] = $ll->id;
          $data['real_challenge_id'] = $ll->id;

          foreach ($array_challenges as $arr_val) {
            if ($arr_val['challenge_id'] == $ll->id) {
              $data['sort_order'] = (int)$arr_val['sort_order'];
              break;
            }
          }
          $data['entryfee'] = $ll->entryfee;
          $data['win_amount'] = $ll->win_amount;
          $data['challenge_type'] = $ll->challenge_type;
          $data['winning_percentage'] = $ll->winning_percentage;
          $data['minimum_user'] = $ll->minimum_user;
          $data['maximum_user'] = $ll->maximum_user;
          $data['multi_entry'] = $ll->multi_entry;
          $data['sport_type'] = $sportType;
          //$data['max_team_limit'] = $ll->max_team_limit;
          $data['max_team_limit'] = (!empty($ll->max_team_limit) && !empty($ll->max_team_limit) > 0) ? $ll->max_team_limit : 1;
          $data['is_flexible'] = $ll->is_flexible;
          if ($sportType == 1) {
            $data['is_flexible'] = $ll->is_flexible;
          }
          if ($sportType == 7) {
            $data['is_flexible'] = $ll->is_flexible;
          }
          if ($sportType == 2) {
            $data['is_flexible'] = $ll->is_flexible;
          }
          if ($sportType == 3) {
            $data['is_flexible'] = $ll->is_flexible;
          }


          $data['bonus'] = $ll->bonus;
          $data['gst_bonus'] = !empty($ll->gst_bonus) ? $ll->gst_bonus : 0;
          $data['bonus_precent'] = $ll->bonus_precent;
          $data['confirmed_challenge'] = $ll->confirmed_challenge;
          $data['is_running'] = $ll->is_running;
          $data['loops'] = isset($ll->loops) ? $ll->loops : 0;
          $data['is_free_for_referrer'] = $ll->is_free_for_referrer;
          $data['is_gadget'] = $ll->is_gadgets;
          $data['gadget_image'] = $ll->gadgets_image;
          $data['matchkey'] = $matchkey;
          $data['challenge_category_id'] = $ll->challenge_category_id;
          $data['is_manual_bot'] = $ll->is_manual_bot;
          $data['real_entry_fees'] = @$ll->real_entry_fees;
          $data['discount_price'] = @$ll->discount_price;
          $data['is_discount'] = @$ll->is_discount;
          $data['is_promotor'] = @$ll->is_promotor;
          $data['promotor_id'] = @$ll->promotor_id;
          $data['is_join_similar_contest'] = $ll->is_join_similar_contest;
          $findchallenge = DB::table('matchchallenges')->where('challenge_id', $ll->id)->where('sport_type', $sportType)->where('matchkey', $matchkey)->first();
          // var_dump($findchallenge);exit;
          if (empty($findchallenge)) {
            DB::table('matchchallenges');
            $getcid = DB::table('matchchallenges')->insertGetId($data);

            $findpricecrads = DB::table('pricecards')->where('challenge_id', $ll->id)->get();
            if (!empty($findpricecrads)) {
              foreach ($findpricecrads as $pricec) {
                $pdata['challenge_id'] = $getcid;
                $pdata['matchkey'] = $matchkey;
                $pdata['winners'] = $pricec->winners;
                $pdata['price'] = $pricec->price;
                $pdata['min_position'] = $pricec->min_position;
                $pdata['max_position'] = $pricec->max_position;
                $pdata['description'] = $pricec->description;
                $pdata['total'] = $pricec->total;
                $pdata['is_gadget'] = $pricec->is_gadget;
                $pdata['gadget_image'] = $pricec->gadget_image;
                DB::table('matchpricecards');
                DB::table('matchpricecards')->insert($pdata);
              }
            }
            // var_dump($getcid);exit;
          }
        }
      }

      Session::flash('message', 'Successfully launched this match!');
      Session::flash('alert-class', 'alert-success');
      Helpers::logActivity('Successfully launched this match!', $matchkey);
      return Redirect()->action('App\Http\Controllers\Admin\MatchesController@launchmatch', [$matchkey, $sportType]);
    }
  }

  public function submitleaguesforlaunch_new($formData)
  {
    // $formData = Input::all();

    if (isset($formData)) {
      $matchkey = $formData['matchId'];
      $sportType = $formData['sport_type'];

      $challenge_ids = @$formData['challenge_ids'] ? $formData['challenge_ids'] : array();

      /*xxxx Live Fantasy Array xxxxx */
      $live_fantasy_challenge_id = @$formData['live_fantasy_challenge_id'] ? $formData['live_fantasy_challenge_id'] : array();

      /*xxxx Live Fantasy Array xxxxx */
      /*xxxx Batting Fantasy Array xxxxx */
      $batting_fantasy_challenge_id = @$formData['batting_fantasy_challenge_id'] ? $formData['batting_fantasy_challenge_id'] : array();
      /*xxxx Batting Fantasy Array xxxxx */
      /*xxxx Bowling Fantasy Array xxxxx */
      $bowling_fantasy_challenge_id = @$formData['bowling_fantasy_challenge_id'] ? $formData['bowling_fantasy_challenge_id'] : array();
      /*xxxx Bowling Fantasy Array xxxxx */
      /*xxxx Reverse Fantasy Array xxxxx */

      $reverse_fantasy_challenge_id = @$formData['reverse_fantasy_challenge_id'] ? $formData['reverse_fantasy_challenge_id'] : array();
      // var_dump($reverse_fantasy_challenge_id);exit;
      /*xxxx Reverse Fantasy Array xxxxx */

      $ten_one_fantasy_challenge_id = @$formData['ten_one_fantasy_challenge_id'] ? $formData['ten_one_fantasy_challenge_id'] : array();
      // var_dump($ten_one_fantasy_challenge_id);exit;
      /*xxxx Tenone Fantasy Array xxxxx */

      $five_one_fantasy_challenge_id = @$formData['five_one_fantasy_challenge_id'] ? $formData['five_one_fantasy_challenge_id'] : array();
      // var_dump($five_one_fantasy_challenge_id);exit;
      /*xxxx Fiveone Fantasy Array xxxxx */

      if (empty($challenge_ids)) {
        Session::flash('error', 'Please select contest after  launched this match!');
        Session::flash('alert-class', 'alert-success');

        return Redirect()->action('App\Http\Controllers\Admin\MatchesController@selectleaguesforlaunch', [$matchkey, $sportType]);
      }
      $datastatus['launch_status'] = 'launched';
      DB::table('listmatches')->where('matchkey', $matchkey)->where('sport_type', $sportType)->update($datastatus);
      $input_challengeId = [];


      $array_challenges = [];
      foreach ($challenge_ids  as $ch_id) {

        $array_challenges[] = json_decode($ch_id, true);
        $ch_id = json_decode($ch_id, true);
        $input_challengeId[] = $ch_id['challenge_id'];
      }
      /*xxxx Live Fantasy Array xxxxx */
      $input_LiveFantasychallengeId = [];
      $array_livefantasy_challenges = [];

      foreach ($live_fantasy_challenge_id  as $lfch_id) {

        $array_livefantasy_challenges[] = json_decode($lfch_id, true);
        $lfch_id = json_decode($lfch_id, true);
        $input_LiveFantasychallengeId[] = $lfch_id['live_fantasy_challenge_id'];
      }
      /*xxxx Live Fantasy Array xxxxx */
      /*xxxx Batting Fantasy Array xxxxx */
      $input_BattingFantasychallengeId = [];
      $array_battingfantasy_challenges = [];

      foreach ($batting_fantasy_challenge_id  as $lfch_id) {
        $array_battingfantasy_challenges[] = json_decode($lfch_id, true);
        $lfch_id = json_decode($lfch_id, true);
        $input_BattingFantasychallengeId[] = $lfch_id['batting_fantasy_challenge_id'];
      }
      /*xxxx Batting Fantasy Array xxxxx */


      /**xxxx Bowling Fantasy Input Array xxxxx*/
      $input_BowlingFantasychallengeId = [];
      $array_bowlingfantasy_challenges = [];

      foreach ($bowling_fantasy_challenge_id  as $lfch_id) {
        $array_bowlingfantasy_challenges[] = json_decode($lfch_id, true);
        $lfch_id = json_decode($lfch_id, true);
        $input_BowlingFantasychallengeId[] = $lfch_id['bowling_fantasy_challenge_id'];
      }
      /**xxxx Bowling Fantasy Input Array xxxxx*/

      /**xxxx Reverse Fantasy Input Array xxxxx*/
      $input_ReverseFantasychallengeId = [];
      $array_reversefantasy_challenges = [];

      foreach ($reverse_fantasy_challenge_id  as $lfch_id) {
        $array_reversefantasy_challenges[] = json_decode($lfch_id, true);
        $lfch_id = json_decode($lfch_id, true);
        $input_ReverseFantasychallengeId[] = $lfch_id['reverse_fantasy_challenge_id'];
      }
      /**xxxx Reverse Fantasy Input Array xxxxx*/

      /**xxxxTenone Fantasy Input Array xxxxx*/
      $input_TenoneFantasychallengeId = [];
      $array_tenonefantasy_challenges = [];

      foreach ($ten_one_fantasy_challenge_id  as $lfch_id) {
        $array_tenonefantasy_challenges[] = json_decode($lfch_id, true);
        $lfch_id = json_decode($lfch_id, true);
        $input_TenoneFantasychallengeId[] = $lfch_id['ten_one_fantasy_challenge_id'];
      }
      /**xxxx TenOne Fantasy Input Array xxxxx*/

      /**xxxxFiveone Fantasy Input Array xxxxx*/
      $input_FiveoneFantasychallengeId = [];
      $array_fiveonefantasy_challenges = [];

      foreach ($five_one_fantasy_challenge_id  as $lfch_id) {
        $array_fiveonefantasy_challenges[] = json_decode($lfch_id, true);
        $lfch_id = json_decode($lfch_id, true);
        $input_FiveoneFantasychallengeId[] = $lfch_id['five_one_fantasy_challenge_id'];
      }
      /**xxxx TenOne Fantasy Input Array xxxxx*/
      // echo "<pre>"; print_r($findleauges); exit;


      $charray = array();
      $findleauges = array();
      if (!empty($challenge_ids)) {
        $findleauges = DB::table('challenges')->where('global', 1)->whereIn('id', $input_challengeId)
          ->get();

        if (!empty($findleauges)) {
          foreach ($findleauges as $ll) {
            $data['challenge_id'] = $ll->id;

            foreach ($array_challenges as $arr_val) {
              // var_dump($arr_val);exit;
              if ($arr_val['challenge_id'] == $ll->id) {
                $data['sort_order'] = (int)$arr_val['sort_order'];
                break;
              }
            }
            $data['real_challenge_id'] = $ll->id;
            $data['entryfee'] = $ll->entryfee;
            $data['win_amount'] = $ll->win_amount;
            $data['challenge_type'] = $ll->challenge_type;
            $data['winning_percentage'] = $ll->winning_percentage;
            $data['minimum_user'] = $ll->minimum_user;
            $data['maximum_user'] = $ll->maximum_user;
            $data['multi_entry'] = $ll->multi_entry;
            $data['max_team_limit'] = $ll->max_team_limit;
            //$data['champion_image'] = $ll->champion_image;
            $data['is_flexible'] = $ll->is_flexible;
            $data['bonus'] = $ll->bonus;
            $data['gst_bonus'] = !empty($ll->gst_bonus) ? $ll->gst_bonus : 0;
            $data['bonus_precent'] = $ll->bonus_precent;
            $data['confirmed_challenge'] = $ll->confirmed_challenge;
            $data['is_running'] = $ll->is_running;
            $data['loops'] = isset($ll->loops) ? $ll->loops : 0;
            $data['is_free_for_referrer'] = $ll->is_free_for_referrer;
            $data['is_gadget'] = $ll->is_gadgets;
            $data['gadget_image'] = $ll->gadgets_image;
            $data['is_join_similar_contest'] = $ll->is_join_similar_contest;
            //$data['is_champion'] = $ll->is_champion;
            // $data['champion_team_id'] = $ll->champion_team_id;
            // $data['champion_team_userid'] = $ll->champion_team_userid;
            // $data['champion_image'] = $ll->champion_image;
            $data['is_offer_team'] = $ll->is_offer_team;
            $data['contest_free_team'] = $ll->contest_free_team;
            $data['contest_bonus_team'] = $ll->contest_bonus_team;
            $data['offer_bonus_percent'] = $ll->offer_bonus_percent;



            $data['matchkey'] = $matchkey;
            $data['challenge_category_id'] = $ll->challenge_category_id;
            //$data['is_first_time_free'] = $ll->is_first_time_free;
            $data['fantasy_type_id'] = 0;
            $data['real_entry_fees'] = @$ll->real_entry_fees;
            $data['discount_price'] = @$ll->discount_price;
            $data['is_discount'] = @$ll->is_discount;
            $data['is_promotor'] = @$ll->is_promotor;
            $data['promotor_id'] = @$ll->promotor_id;
            // $data['fantasy_type'] = 'Normal fantasy';
            // $findchallenge = DB::table('matchchallenges')->where('challenge_id',$ll->id)->where('matchkey',$matchkey)->first();
            // if(empty($findchallenge)){
            DB::table('matchchallenges');
            $getcid = DB::table('matchchallenges')->insertGetId($data);
            $findpricecrads = DB::table('pricecards')->where('challenge_id', $ll->id)->get();
            if (!empty($findpricecrads)) {
              foreach ($findpricecrads as $pricec) {
                $pdata['challenge_id'] = $getcid;
                $pdata['matchkey'] = $matchkey;
                $pdata['winners'] = $pricec->winners;
                $pdata['price'] = $pricec->price;
                $pdata['min_position'] = $pricec->min_position;
                $pdata['max_position'] = $pricec->max_position;
                $pdata['description'] = $pricec->description;
                $pdata['total'] = $pricec->total;
                $pdata['is_gadget'] = $pricec->is_gadget;
                $pdata['gadget_image'] = $pricec->gadget_image;
                DB::table('matchpricecards');
                DB::table('matchpricecards')->insert($pdata);
              }
            }
            // }
          }
        }
      }
      if (!empty($input_TenoneFantasychallengeId)) {
        $findleauges = DB::table('challenges')->where('global', 1)->whereIn('id', $input_TenoneFantasychallengeId)
          ->get();
        if (!empty($findleauges)) {
          foreach ($findleauges as $ll) {
            $data['challenge_id'] = $ll->id;

            foreach ($array_challenges as $arr_val) {
              // var_dump($arr_val);exit;
              if ($arr_val['challenge_id'] == $ll->id) {
                $data['sort_order'] = (int)$arr_val['sort_order'];
                break;
              }
            }
            $data['real_challenge_id'] = $ll->id;
            $data['entryfee'] = $ll->entryfee;
            $data['win_amount'] = $ll->win_amount;
            $data['challenge_type'] = $ll->challenge_type;
            $data['winning_percentage'] = $ll->winning_percentage;
            $data['minimum_user'] = $ll->minimum_user;
            $data['maximum_user'] = $ll->maximum_user;
            $data['multi_entry'] = $ll->multi_entry;
            $data['max_team_limit'] = $ll->max_team_limit;
            $data['is_flexible'] = $ll->is_flexible;
            $data['bonus'] = $ll->bonus;
            $data['gst_bonus'] = !empty($ll->gst_bonus) ? $ll->gst_bonus : 0;
            $data['bonus_precent'] = $ll->bonus_precent;
            $data['confirmed_challenge'] = $ll->confirmed_challenge;
            $data['is_running'] = $ll->is_running;
            $data['loops'] = isset($ll->loops) ? $ll->loops : 0;
            $data['is_free_for_referrer'] = $ll->is_free_for_referrer;
            $data['is_gadget'] = $ll->is_gadgets;
            $data['gadget_image'] = $ll->gadgets_image;
            // $data['is_champion'] = $ll->is_champion;
            // $data['champion_team_id'] = $ll->champion_team_id;
            // $data['champion_team_userid'] = $ll->champion_team_userid;
            //$data['champion_image'] = $ll->champion_image;
            $data['is_offer_team'] = $ll->is_offer_team;
            $data['contest_free_team'] = $ll->contest_free_team;
            $data['contest_bonus_team'] = $ll->contest_bonus_team;
            $data['offer_bonus_percent'] = $ll->offer_bonus_percent;
            $data['matchkey'] = $matchkey;
            $data['challenge_category_id'] = $ll->challenge_category_id;
            //$data['is_first_time_free'] = $ll->is_first_time_free;
            $data['fantasy_type_id'] = 0;
            $data['real_entry_fees'] = @$ll->real_entry_fees;
            $data['discount_price'] = @$ll->discount_price;
            $data['is_discount'] = @$ll->is_discount;
            $data['is_promotor'] = @$ll->is_promotor;
            $data['promotor_id'] = @$ll->promotor_id;
            // $data['fantasy_type'] = 'Normal fantasy';
            // $findchallenge = DB::table('matchchallenges')->where('challenge_id',$ll->id)->where('matchkey',$matchkey)->first();
            // if(empty($findchallenge)){
            DB::table('matchchallenges');
            $getcid = DB::table('matchchallenges')->insertGetId($data);
            $findpricecrads = DB::table('pricecards')->where('challenge_id', $ll->id)->get();
            if (!empty($findpricecrads)) {
              foreach ($findpricecrads as $pricec) {
                $pdata['challenge_id'] = $getcid;
                $pdata['matchkey'] = $matchkey;
                $pdata['winners'] = $pricec->winners;
                $pdata['price'] = $pricec->price;
                $pdata['min_position'] = $pricec->min_position;
                $pdata['max_position'] = $pricec->max_position;
                $pdata['description'] = $pricec->description;
                $pdata['total'] = $pricec->total;
                $pdata['is_gadget'] = $pricec->is_gadget;
                $pdata['gadget_image'] = $pricec->gadget_image;
                DB::table('matchpricecards');
                DB::table('matchpricecards')->insert($pdata);
              }
            }
            // }
          }
        }
      }

      if (!empty($input_FiveoneFantasychallengeId)) {
        $findleauges = DB::table('challenges')->where('global', 1)->whereIn('id', $input_FiveoneFantasychallengeId)
          ->get();
        if (!empty($findleauges)) {
          foreach ($findleauges as $ll) {
            $data['challenge_id'] = $ll->id;

            foreach ($array_challenges as $arr_val) {
              // var_dump($arr_val);exit;
              if ($arr_val['challenge_id'] == $ll->id) {
                $data['sort_order'] = (int)$arr_val['sort_order'];
                break;
              }
            }
            $data['real_challenge_id'] = $ll->id;
            $data['entryfee'] = $ll->entryfee;
            $data['win_amount'] = $ll->win_amount;
            $data['challenge_type'] = $ll->challenge_type;
            $data['winning_percentage'] = $ll->winning_percentage;
            $data['minimum_user'] = $ll->minimum_user;
            $data['maximum_user'] = $ll->maximum_user;
            $data['multi_entry'] = $ll->multi_entry;
            $data['max_team_limit'] = $ll->max_team_limit;
            //$data['champion_image'] = $ll->champion_image;
            $data['is_flexible'] = $ll->is_flexible;
            $data['bonus'] = $ll->bonus;
            $data['gst_bonus'] = !empty($ll->gst_bonus) ? $ll->gst_bonus : 0;
            $data['bonus_precent'] = $ll->bonus_precent;
            $data['confirmed_challenge'] = $ll->confirmed_challenge;
            $data['is_running'] = $ll->is_running;
            $data['loops'] = isset($ll->loops) ? $ll->loops : 0;
            $data['is_free_for_referrer'] = $ll->is_free_for_referrer;
            $data['is_gadget'] = $ll->is_gadgets;
            $data['gadget_image'] = $ll->gadgets_image;
            // $data['is_champion'] = $ll->is_champion;
            //$data['champion_team_id'] = $ll->champion_team_id;
            //$data['champion_team_userid'] = $ll->champion_team_userid;
            // $data['champion_image'] = $ll->champion_image;
            $data['is_offer_team'] = $ll->is_offer_team;
            $data['contest_free_team'] = $ll->contest_free_team;
            $data['contest_bonus_team'] = $ll->contest_bonus_team;
            $data['offer_bonus_percent'] = $ll->offer_bonus_percent;
            $data['matchkey'] = $matchkey;
            $data['challenge_category_id'] = $ll->challenge_category_id;
            // $data['is_first_time_free'] = $ll->is_first_time_free;
            $data['fantasy_type_id'] = 0;
            $data['real_entry_fees'] = @$ll->real_entry_fees;
            $data['discount_price'] = @$ll->discount_price;
            $data['is_discount'] = @$ll->is_discount;
            $data['is_promotor'] = @$ll->is_promotor;
            $data['promotor_id'] = @$ll->promotor_id;
            // $data['fantasy_type'] = 'Normal fantasy';
            // $findchallenge = DB::table('matchchallenges')->where('challenge_id',$ll->id)->where('matchkey',$matchkey)->first();
            // if(empty($findchallenge)){
            DB::table('matchchallenges');
            $getcid = DB::table('matchchallenges')->insertGetId($data);
            $findpricecrads = DB::table('pricecards')->where('challenge_id', $ll->id)->get();
            if (!empty($findpricecrads)) {
              foreach ($findpricecrads as $pricec) {
                $pdata['challenge_id'] = $getcid;
                $pdata['matchkey'] = $matchkey;
                $pdata['winners'] = $pricec->winners;
                $pdata['price'] = $pricec->price;
                $pdata['min_position'] = $pricec->min_position;
                $pdata['max_position'] = $pricec->max_position;
                $pdata['description'] = $pricec->description;
                $pdata['total'] = $pricec->total;
                $pdata['is_gadget'] = $pricec->is_gadget;
                $pdata['gadget_image'] = $pricec->gadget_image;
                DB::table('matchpricecards');
                DB::table('matchpricecards')->insert($pdata);
              }
            }
            // }
          }
        }
      }
      return true;
      Session::flash('message', 'Successfully launched this match!');
      Session::flash('alert-class', 'alert-success');
      Helpers::logActivity('Successfully launched this match!', $matchkey);

      return Redirect()->action('App\Http\Controllers\Admin\MatchesController@launchmatch', [$matchkey, $sportType]);
    }
  }

  public function editleaguesformatch($matchkey, $sport_type = 1)
  {
    $allchallengecategory = DB::table('challenges_category')->where('status', '1')->where('sport_type', $sport_type)->get();
    $livefantasy = '';
    $battingfantasy = '';
    $bowlingfantasy = '';
    $reversefantasy = '';
    $tenOneFantasy = '';
    $fiveOneFantasy = '';
    if (!empty($matchkey)) {
      $fantasy_challange = DB::table('listmatches')->where('matchkey', $matchkey)->first();
      if (!empty($fantasy_challange->is_fiveplusone)) {
        $fiveOneFantasy = $fantasy_challange->is_fiveplusone;
      }
      if (!empty($fantasy_challange->is_tenplusone)) {
        $tenOneFantasy = $fantasy_challange->is_tenplusone;
      }
      if (!empty($fantasy_challange->is_live_fantasy_enable)) {
        $livefantasy = $fantasy_challange->is_live_fantasy_enable;
      }
      if (!empty($fantasy_challange->is_batting_fantasy_enable)) {
        $battingfantasy = $fantasy_challange->is_batting_fantasy_enable;
      }
      if (!empty($fantasy_challange->is_bowling_fantasy_enable)) {
        $bowlingfantasy = $fantasy_challange->is_bowling_fantasy_enable;
      }
      if (!empty($fantasy_challange->is_reverse_fantasy_enable)) {
        $reversefantasy = $fantasy_challange->is_reverse_fantasy_enable;
      }
    }
    $is_editable_input = true;
    return view("admin.$this->model.editleaguesformatch", compact('allchallengecategory', 'matchkey', 'sport_type', 'livefantasy', 'battingfantasy', 'bowlingfantasy', 'reversefantasy', 'is_editable_input', 'tenOneFantasy', 'fiveOneFantasy'));
  }

  public function editleaguesformatch_old23_11($matchkey, $sport_type = 1)
  {
    $allchallengecategory = DB::table('challenges_category')->where('status', '1')->where('sport_type', $sport_type)->get();

    return view("admin.$this->model.editleaguesformatch", compact('allchallengecategory', 'matchkey', 'sport_type'));
  }

  //code for custom league selection number 2
  public function view_edit_challenges()
  {
    $formData = Input::all();

    if (isset($formData) && !empty($formData)) {
      return Datatables::of($query = DB::table('challenges')
        ->leftJoin('challenges_category', 'challenges_category.id', '=', 'challenges.challenge_category_id')
        ->select('challenges.*', 'challenges_category.name', 'challenges_category.sport_type')
        ->where(function ($query) use ($formData) {
          if (isset($formData['categoryId'])) {
            $query->where('challenges_category.id', '=', unserialize(base64_decode($formData['categoryId'])));
          }
        })
        ->get())
        ->addColumn('#', function ($result) use ($formData) {

          $data1 = DB::table('matchchallenges')->where('matchkey', $formData['matchkey'])->where('challenge_id', $result->id)
            ->where('challenge_category_id', unserialize(base64_decode($formData['categoryId'])))
            ->where('sport_type', $formData['sport_type'])
            ->first();

          if (empty($data1)) {

            return "<input type='checkbox' name='challenge_id' value='$result->id' onchange='addOrRemoveChallenge(event)'>";
          } else {
            return "<input type='checkbox' name='' value='' checked disabled>";
          }
        })
        ->addIndexColumn()
        ->addColumn('sort_order', function ($result) use ($formData) {

          $data2 = DB::table('matchchallenges')->where('matchkey', $formData['matchkey'])->where('challenge_id', $result->id)
            ->where('challenge_category_id', unserialize(base64_decode($formData['categoryId'])))
            ->where('sport_type', $formData['sport_type'])
            ->first();

          if (empty($data2)) {
            return "<input type='number'  class='form-control' name='sort_order_" . $result->id . "' onchange='editSortingOrderInArray(" . $result->id . " , event)' value='0' >";
          } else {

            // var_dump($data2);exit;
            return "<input type='number'  class='form-control' name=''  value='" . $data2->sort_order . "' disabled >";
          }
        })
        ->addColumn('sport_type', function ($result) use ($formData) {

          $db_sport_name = '';
          if (!empty($result->sport_type)) {
            $db_result = DB::table('sport_types')->where('id', $result->sport_type)->first();
            if (!empty($db_result)) {
              $db_sport_name = $db_result->sport_name;
            }
          }
          return $db_sport_name;
        })
        ->addColumn('challenge_type', function ($result) {
          $challenge_type = '';
          if ($result->challenge_type == 'money') {
            $challenge_type = ucwords('Fixed Challenge');
          } else {
            $challenge_type = ucwords('Percentage based');
          }
          return $challenge_type;
        })
        ->addColumn('maximum_user', function ($result) {
          $maximum_user = '';
          if ($result->challenge_type == 'money') {
            $maximum_user = $result->maximum_user;
          } else {
            $maximum_user = '-';
          }
          return $maximum_user;
        })
        ->addColumn('winning_percentage', function ($result) {
          $winning_percentage = '';
          if ($result->challenge_type != 'money') {
            $winning_percentage = $result->winning_percentage . ' %';
          } else {
            $winning_percentage = '-';
          }
          return $winning_percentage;
        })
        ->addColumn('multi_entry', function ($result) {
          $multi_entry = '';
          if ($result->multi_entry == 1) {
            $multi_entry = '<i class="fa fa-check" style="color:green">';
          } else {
            $multi_entry = '<i class="fa fa-times" style="color:red">';
          }
          return $multi_entry;
        })
        ->addColumn('bonus', function ($result) {
          $bonus = '';
          if ($result->bonus == 1) {
            $bonus = '<i class="fa fa-check" style="color:green">';
          } else {
            $bonus = '<i class="fa fa-times" style="color:red">';
          }
          return $bonus;
        })
        ->addColumn('is_running', function ($result) {
          $is_running = '';
          if ($result->is_running == 1) {
            $is_running = '<i class="fa fa-check" style="color:green">';
          } else {
            $is_running = '<i class="fa fa-times" style="color:red">';
          }
          return $is_running;
        })
        ->addColumn('confirmed_challenge', function ($result) {
          $confirmed_challenge = '';
          if ($result->confirmed_challenge == 1) {
            $confirmed_challenge = '<i class="fa fa-check" style="color:green">';
          } else {
            $confirmed_challenge = '<i class="fa fa-times" style="color:red">';
          }
          return $confirmed_challenge;
        })
        ->escapeColumns([])
        ->make(true);
    } //end

    return view("admin.$this->model.viewchallenges");
  }

  public function selectleaguesforlaunch($matchkey, $sport_type = 1)
  {
    $allchallengecategory = DB::table('challenges_category')->where('status', '1')
      ->where('sport_type', $sport_type)->get();
    $livefantasy = '';
    $battingfantasy = '';
    $bowlingfantasy = '';
    $reversefantasy = '';
    $tenOneFantasy = '';
    $fiveOneFantasy = '';
    if (!empty($matchkey)) {
      $fantasy_challange = DB::table('listmatches')->where('matchkey', $matchkey)->first();

      if (!empty($fantasy_challange->is_live_fantasy_enable)) {
        $livefantasy = $fantasy_challange->is_live_fantasy_enable;
      }
      if (!empty($fantasy_challange->is_fiveplusone)) {
        $fiveOneFantasy = $fantasy_challange->is_fiveplusone;
      }
      if (!empty($fantasy_challange->is_tenplusone)) {
        $tenOneFantasy = $fantasy_challange->is_tenplusone;
      }
      if (!empty($fantasy_challange->is_bowling_fantasy_enable)) {
        $bowlingfantasy = $fantasy_challange->is_bowling_fantasy_enable;
      }
      if (!empty($fantasy_challange->is_reverse_fantasy_enable)) {
        $reversefantasy = $fantasy_challange->is_reverse_fantasy_enable;
      }
    }
    $is_editable_input = false;
    return view("admin.$this->model.selectleaguesforlaunch", compact('allchallengecategory', 'matchkey', 'sport_type', 'livefantasy', 'battingfantasy', 'bowlingfantasy', 'reversefantasy', 'is_editable_input', 'tenOneFantasy', 'fiveOneFantasy'));
    // return view("admin.$this->model.selectleaguesforlaunch",compact('allchallengecategory' , 'matchkey' , 'sport_type'));
  }


  public function activatematch($matchkey)
  {
    $datastatus['launch_status'] = 'activated';
    $findmatch = DB::table('listmatches')->where('matchkey', $matchkey)->first();
    if (!empty($findmatch)) {
      DB::table('listmatches')->where('matchkey', $matchkey)->update($datastatus);
      Session::flash('flash_notice', 'Successfully activated this match!');
      Session::flash('alert-class', 'alert-success');
      return redirect()->action('App\Http\Controllers\Admin\MatchesController@matchmapping');
    } else {
      return redirect()->action('App\Http\Controllers\Admin\MatchesController@matchmapping')->withErrors('Invalid match Provided');
    }
  }

  public function playerroles($playerid, $sportType, Request $request)
  {

    // echo "break";die;
    //echo '<pre>'; print_r($sportType);exit;
    //$findplayerdetails = DB::table('matchplayers')->where('id',$playerid)->first();
    $findplayerdetails = DB::table('matchplayers')
      ->join('players', 'players.id', '=', 'matchplayers.playerid')
      ->where('matchplayers.id', $playerid)
      ->where('matchplayers.sport_type', $sportType)
      ->where('players.sport_type', $sportType)
      ->select('matchplayers.*', 'players.team')
      ->first();
    //echo '<pre>'; print_r($findplayerdetails);exit;
    if ($request->isMethod('post')) {
      $input = Input::all();
      $order_exit = DB::table('matchplayers')
        ->join('players', 'players.id', '=', 'matchplayers.playerid')
        ->where('batting_order', $input['batting_order'])->where('matchkey', $findplayerdetails->matchkey)
        ->where('players.team', $findplayerdetails->team)
        ->where('players.sport_type', $sportType)
        ->count();
      if ($order_exit > 0) {
        Session::flash('flash_notice', 'Batting Order already asign to another player !');
        Session::flash('alert-class', 'alert-danger');
        return Redirect::back();
      } else {

        $data['batting_order'] = $input['batting_order'];
      }
      if (empty($input['batting_order'])) {
        $data['batting_order'] = 0;
      } else {
        $data['batting_order'] = $input['batting_order'];
      }
      if (empty($input['fiveplus_credit'])) {
        $data['fiveplus_credit'] = 0;
      } else {
        $data['fiveplus_credit'] = $input['fiveplus_credit'];
      }
      $data['role'] = $input['role'];
      $data['credit'] = $input['credit'];
      DB::table('matchplayers')->where('id', $playerid)->where('sport_type', $sportType)->update($data);
      if (isset($input['global'])) {
        unset($data['batting_order']);
        DB::table('players')->where('id', $findplayerdetails->playerid)->where('sport_type', $sportType)->update($data);
      }
    }
    Session::flash('flash_notice', 'Successfully updated the player roles and credit!');
    Session::flash('alert-class', 'alert-success');
    return Redirect::back();
  }
  public function playercredit($playerid, Request $request)
  {

    // echo "break";die;

    //$findplayerdetails = DB::table('matchplayers')->where('id',$playerid)->first();
    $findplayerdetails = DB::table('matchplayers')
      ->join('players', 'players.id', '=', 'matchplayers.playerid')
      ->where('matchplayers.id', $playerid)
      ->where('matchplayers.sport_type', 1)
      ->where('players.sport_type', 1)
      ->select('matchplayers.*', 'players.team')
      ->first();
    //  echo '<pre>'; print_r($findplayerdetails);exit;
    if ($request->isMethod('post')) {
      $input = Input::all();
      $order_exit = DB::table('matchplayers')
        ->join('players', 'players.id', '=', 'matchplayers.playerid')
        ->where('batting_order', $input['batting_order'])->where('matchkey', $findplayerdetails->matchkey)
        ->where('players.team', $findplayerdetails->team)
        ->where('players.sport_type', 1)
        ->count();
      if ($order_exit > 0) {
        Session::flash('flash_notice', 'Batting Order already asign to another player !');
        Session::flash('alert-class', 'alert-danger');
        return Redirect::back();
      } else {

        // $data['batting_order'] = $input['batting_order'];
      }
      if (empty($input['batting_order'])) {
        // $data['batting_order']=0;
      } else {
        // $data['batting_order']=$input['batting_order'];
      }
      // $data['role'] = $input['role'];
      $data['fiveplus_credit'] = $input['fiveplus_credit'];
      DB::table('matchplayers')->where('id', $playerid)->where('sport_type', 1)->update($data);
      if (isset($input['global'])) {
        unset($data['batting_order']);
        DB::table('players')->where('id', $findplayerdetails->playerid)->where('sport_type', 1)->update($data);
      }
    }
    Session::flash('flash_notice', 'Successfully updated the player roles and credit!');
    Session::flash('alert-class', 'alert-success');
    return Redirect::back();
  }

  public function updatelogo($teamid, Request $request)
  {
    if ($request->isMethod('post')) {

      $findteam = DB::table('teams')->where('id', $teamid)->select('team', 'logo')->first();
      $inputt = Input::all();
      $input = $request->input();
      unset($input['_token']);
      $file = $inputt['image'];
      if (request()->hasFile('image')) {
        $folderPath  = 'uploads/teams/';
        $image = request()->file('image'); // Get the uploaded file
        $extension = $image->getClientOriginalExtension();

        $img_ext = explode(",", IMAGE_EXTENSION);
        if (in_array($extension, $img_ext)) {
          // Ensure the directory exists
          if (!file_exists(public_path($folderPath))) {
            mkdir(public_path($folderPath), 0777, true);
          }

          // Generate a unique file name
          $fileName = env("APP_NAME") . '-teams-' . rand(100000, 999999) . "." . $extension;
          $filePath = $folderPath . $fileName;

          // Move the uploaded file to the directory
          $image->move(public_path($folderPath), $fileName);

          // Upload to AWS (if needed)
          $uploadedFileName = TeamsController::aws_upload_image($filePath, $folderPath, $fileName);
          $datateam['logo'] = env('CDN_URL') . 'uploads/teams/' . $uploadedFileName;
          DB::table('teams')->where('id', $teamid)->update($datateam);
          // Delete local file after uploading to AWS
          @unlink(public_path($filePath));
        } else {
          Session::flash('error', trans("messages.$this->model.INVALID_IMAGE_EXTENSION"));
          return Redirect::back()->withInput();
        }
      }
      Session::flash('flash_notice', 'Successfully updated the team logo!');
      Session::flash('alert-class', 'alert-success');
      return Redirect::back();
    }
  }

  public function updatescores($matchkey, $sport_type)
  {
    $getdata = $this->getscoresupdates($matchkey, $sport_type);

    if ($getdata == 1) {
      Session::flash('flash_notice', 'Scores has been refreshed.!');
      Session::flash('alert-class', 'alert-success');
      return redirect()->action('App\Http\Controllers\Admin\MatchesController@match_points', [$matchkey, $sport_type]);
    } else {
      Session::flash('flash_notice', 'Scores has been refreshed.!');
      Session::flash('alert-class', 'alert-success');
      return redirect()->action('App\Http\Controllers\Admin\MatchesController@match_points', [$matchkey, $sport_type]);
    }
  }

  public function update_lineup_of_matches()
  {

    // Helpers::sendnotificationAll('test',"TEsign Notification",'');
    date_default_timezone_set('Asia/Kolkata');
    $findmatchexist = DB::table('listmatches')
      ->where('start_date', '<=', date('Y-m-d H:i s', strtotime('+100 minutes')))
      ->where('launch_status', 'launched')
      //->where('matchkey','78578')
      ->where('final_status', '!=', 'winnerdeclared')
      ->where('final_status', '!=', 'IsAbandoned')
      ->where('final_status', '!=', 'IsCanceled')
      // ->where('final_status','!=','IsReviewed')
      ->whereNotIn('status', ['completed', 'started'])
      ->orderBy('start_date', 'ASC')
      ->get();
    //echo date('Y-m-d H:i',strtotime('+60 minutes'));exit;
    //echo "<pre>"; print_r($findmatchexist); exit;
    if (!empty($findmatchexist)) {
      foreach ($findmatchexist as $val) {
        $match_key = $val->matchkey;
        $match_type = $val->format;
        $getcurrentdate = date('Y-m-d H:i');
        $matchtimings = $val->start_date;
        // if($getcurrentdate>$matchtimings){
        //   $match_key=$val->matchkey;
        // }

        if (empty($val->toss)) {
          $giveresresult = Cricketapi2Controller::get_match_details($val->matchkey);
          if (!empty($giveresresult)) {
            $toss = @$giveresresult->toss->text;
            DB::table('listmatches')->where('matchkey', $val->matchkey)->update(['toss' => $toss]);
          }
        }

        if ($val->is_allow_notification == 2) {
          if (date('Y-m-d H:i', strtotime('-15 minutes', strtotime($matchtimings))) == date('Y-m-d H:i')) {
            $title = '15 Minutes left ' . $val->short_name;
            $message = 'Create your team now and more Fantasy World 11 more winning';
            Helpers::sendnotificationAll($title, $message);
            $image = "";
            $titleget = $title;
            $msg = $message;
            $userdata = array(1, 3);
            foreach ($userdata as $userid) {
              Helpers::sendnotification($titleget, $msg, $image, $userid);
            }
          }

          if (date('Y-m-d H:i', strtotime('-5 minutes', strtotime($matchtimings))) == date('Y-m-d H:i')) {
            $title = '5 Minutes left ' . $val->short_name;
            $message = 'Hurry up! Join the game right away';
            Helpers::sendnotificationAll($title, $message);
            $image = "";
            $titleget = $title;
            $msg = $message;
            $userdata = array(1, 3);
            foreach ($userdata as $userid) {
              Helpers::sendnotification($titleget, $msg, $image, $userid);
            }
          }
        }
        // if(date('Y-m-d H:i:s', strtotime('+60 minutes', strtotime($getcurrentdate))) > $matchtimings ){
        if (1) {
          $match_key = $val->matchkey;
          if ($val->sport_type == 1) {

            $this->get_playing_11_new($match_key, 'CRICKET');
          } else if ($val->sport_type == 2) {
            $this->get_playing_11_new($match_key, 'FOOTBALL');
          }
          //xxxxxxxxxxxxxx KABADDI NEW ADED xxxxxxxxxxxx
          else if ($val->sport_type == 7) {
            //$match_key=2066;
            $this->get_playing_11_new($match_key, 'KABADDI');
            // Session::flash('flash_notice', 'Lineup Update Successfully.!');
            // Session::flash('alert-class', 'alert-success');
            //  return redirect()->to('admin/matches/match-mapping/7');
          } else {
            $this->get_playing_11_new($match_key, 'BASKETBALL');
          }
        }
      }
    }
    //exit;
    return redirect()->back()->with('success', 'Lineup Update Successfully.!');
  }

  public function livescoreapi_commentry($matchkey, $inning)
  {
    $curl = curl_init();
    // if($matchkey=='65430'){
    //
    //   echo 'http://score.PlaynWin11.net:2701/commentary-store?matchkey='.$matchkey.'&inning='.$inning ; exit;
    // }
    curl_setopt_array($curl, array(
      CURLOPT_URL => 'http://score.PlaynWin11.in/:2701/commentary-store?matchkey=' . $matchkey . '&inning=' . $inning,
      CURLOPT_RETURNTRANSFER => true,
      CURLOPT_ENCODING => '',
      CURLOPT_MAXREDIRS => 10,
      CURLOPT_TIMEOUT => 0,
      CURLOPT_FOLLOWLOCATION => true,
      CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
      CURLOPT_CUSTOMREQUEST => 'GET',
    ));

    $response = curl_exec($curl);

    curl_close($curl);
  }

  public function livematchscoreapi($matchkey)
  {
    $curl = curl_init();
    curl_setopt_array($curl, array(
      CURLOPT_URL => 'http://score.focus11.net:2701/add-match?matchkey=' . $matchkey,
      CURLOPT_RETURNTRANSFER => true,
      CURLOPT_ENCODING => '',
      CURLOPT_MAXREDIRS => 10,
      CURLOPT_TIMEOUT => 0,
      CURLOPT_FOLLOWLOCATION => true,
      CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
      CURLOPT_CUSTOMREQUEST => 'GET',
    ));
    $response = curl_exec($curl);
    curl_close($curl);
    // echo $response;
  }
  public function livescoreapi($matchkey)
  {
    $curl = curl_init();
    curl_setopt_array($curl, array(
      CURLOPT_URL => 'http://score.PlaynWin11.in/:2701/score-store?matchkey=' . $matchkey,
      CURLOPT_RETURNTRANSFER => true,
      CURLOPT_ENCODING => '',
      CURLOPT_MAXREDIRS => 10,
      CURLOPT_TIMEOUT => 0,
      CURLOPT_FOLLOWLOCATION => true,
      CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
      CURLOPT_CUSTOMREQUEST => 'GET',
    ));
    $response = curl_exec($curl);
    curl_close($curl);
    // echo $response;
  }


  public function update_winnerdeclear_of_matches()
  {
    die;
    date_default_timezone_set('Asia/Kolkata');
    $findmatchexist = DB::table('listmatches')
      ->whereDate('start_date', '<=', date('Y-m-d'))
      ->where('launch_status', 'launched')
      ->where('final_status', '!=', 'winnerdeclared')
      ->where('final_status', '!=', 'IsCanceled')
      ->where('final_status', '!=', 'IsAbandoned')
      ->where('status', '=', 'completed')
      //->where('sport_type',1)
      ->orderBy('id', 'DESC')
      //->limit(1)
      //->where('listmatches.matchkey','65738')
      ->get();
    //  echo '<pre>'; print_r( $findmatchexist);exit;

    foreach ($findmatchexist as $val) {
      if ($val->sport_type == 1) {
        $matchkey = $val->matchkey;
        $sport_type = $val->sport_type;
        $res = MatchesController::distribute_winning_amount($matchkey, $val->format, $sport_type);
        $input['final_status'] = 'winnerdeclared';
        DB::table('listmatches')->where('matchkey', $matchkey)->where('sport_type', $sport_type)->update($input);
        $lead = MatchesController::update_match_leaderboard($matchkey);
        Helpers::logActivity('Winner declared successfully!', $matchkey);

        MatchesController::update_match_investment_leaderboard($matchkey, $sport_type);
      }
    }
    echo "Winner declear done";
  }


  public function update_results_of_matches()
  {
    date_default_timezone_set('Asia/Kolkata');
    $findmatchexist = DB::table('listmatches')
      ->whereDate('start_date', '<=', date('Y-m-d'))
      ->where('launch_status', 'launched')
      ->where('final_status', '!=', 'winnerdeclared')
      ->where('final_status', '!=', 'IsCanceled')
      ->where('final_status', '!=', 'IsAbandoned')
      ->where('status', '!=', 'completed')
      //->where('sport_type',1)
      ->orderBy('id', 'DESC')
      //->where('listmatches.matchkey','65738')
      ->get();


    if (!empty($findmatchexist)) {
      foreach ($findmatchexist as $val) {
        if ($val->sport_type == 1) {
          // $inningdata = DB :: table('result_matches')->where('match_key',$val->matchkey)
          //   ->where('sport_type',1)->orderby('innings','DESC')->select('innings')->first();

          $inningdata = DB::table('matchruns')->where('matchkey', $val->matchkey)
            ->where('sport_type', $val->sport_type)->orderby('inning', 'DESC')->select('inning')->first();
          //            if($val->matchkey=='65430'){
          //
          //               dd($inningdata);
          // }
          $this->livematchscoreapi($val->matchkey);
          if (!empty($inningdata)) {
            // $this->livescoreapi($val->matchkey);
            $this->livescoreapi_commentry($val->matchkey, $inningdata->inning);
          }


          if ($val->is_verified == 1) {
            continue;
          }
          $match_type = $val->format;
          $getcurrentdate = date('Y-m-d H:i:s');
          $matchtimings = $val->start_date;
          if ($getcurrentdate > $matchtimings) {
            $match_key = $val->matchkey;
            $this->getscoresupdates($match_key, $val->sport_type);
            //  $this->getscoresupdates($match_key,'1');
            // $this->getscoresupdates('bblt20_2020_g23','1');

          }
          if (date('Y-m-d H:i:s', strtotime('+40 minutes', strtotime($getcurrentdate))) > $matchtimings) { //echo 11; exit;
            $match_key = $val->matchkey;
            // $this->get_playing_11($match_key);
            // $this->get_playing_11_new($match_key,'CRICKET');
          }
          DB::table('listmatches')->where('matchkey', $val->matchkey)->update(['score_card' => 1]);
        }
      }
    }

    $this->update_result_football();
    // $this->update_result_basketball();
    $this->update_result_kabaddi();
    return 1;
  }

  public function update_result_kabaddi()
  {
    ini_set('max_execution_time', 30000);
    date_default_timezone_set('Asia/Kolkata');
    $sport_type = DB::table('sport_types')->where('sport_key', 'KABADDI')->first();
    $findmatchexist = DB::table('listmatches')
      ->whereDate('start_date', '<=', date('Y-m-d'))
      ->where('sport_type', $sport_type->id)
      ->whereDate('start_date', '>=', date('Y-m-d', strtotime('-14 days')))
      ->where('launch_status', 'launched')
      ->where('final_status', '!=', 'winnerdeclared')
      ->where('status', '!=', 'completed')
      ->get();
    foreach ($findmatchexist as $match) {
      $getcurrentdate = date('Y-m-d H:i:s');
      $matchtimings = $match->start_date;
      if ($getcurrentdate > $matchtimings) {
        $this->getscoresupdates($match->matchkey, $sport_type->id);
      }
      $matchtimings = date('Y-m-d H:i:s', strtotime('-70 minutes', strtotime($matchtimings)));
    }
  }
  public static function get_playing_11($match_key)
  {
    $findmatchtype = DB::table('listmatches')->where('matchkey', $match_key)->select('format', 'series')->first();

    $giveresresult = CricketapiController::getmatchdetails($match_key);
    // echo 1; exit;
    if (empty($giveresresult['data'])) {
      // print_r($giveresresult); exit;
      $giveresresult = array();
      $giveresresult = CricketapiController::getmatchdetails_old($match_key);
    }
    // $giveresresult = CricketapiController::getmatchdetails($match_key); //print_r($giveresresult); exit;
    // if($match_key=='c.match.cec_vs_nct.e7e6c') {
    //  // echo '<pre>'; print_r($giveresresult); exit;
    //   }
    // var_dump($giveresresult);exit;
    if (!empty($giveresresult)) {
      $mainarrayget = $giveresresult['data']['card'];

      $data_team1_shortName = '';
      $data_team2_shortName = '';

      if (!empty($mainarrayget['teams'])) {
        foreach ($mainarrayget['teams'] as $tp_val => $tp_key) {
          if ($tp_val === 'a') {
            $data_team1_shortName = $tp_key['short_name'];
          } else if ($tp_val === 'b') {
            $data_team2_shortName = $tp_key['short_name'];
          }
        }
      }


      if (!empty($mainarrayget['toss'])) {
        $toss_won = $mainarrayget['toss']['won'];
        $toss_decision = $mainarrayget['toss']['decision'];
        $toss_won_short_name = '';

        if ($toss_won == 'a') {
          $toss_won_short_name = $data_team1_shortName;
        } else {
          $toss_won_short_name = $data_team2_shortName;
        }
        $final_toss_str = $toss_won_short_name . ' won the toss and choose to ' . $toss_decision . ' first';
        $getmtdatastatus['toss'] = $final_toss_str;
      }
      $getmtdatastatus['status'] = $mainarrayget['status'];
      if ($getmtdatastatus['status'] == 'completed') {
        $getmtdatastatus['final_status'] = 'IsReviewed';
      }

      $findIsSecondInning = DB::table('listmatches')->where('matchkey', $match_key)->where('second_inning_allow', 1)->first();
      if (!empty($findIsSecondInning)) {
        DB::table('listmatches')->where('matchkey', $match_key . "_2")->update($getmtdatastatus);
      }

      DB::table('listmatches')->where('matchkey', $match_key)->update($getmtdatastatus);
      $findteams = $mainarrayget['teams'];
      $finalplayingteams = array();
      if (!empty($findteams)) {
        foreach ($findteams as $tp) {
          $findpl = $tp['match']['playing_xi'];
          if (!empty($findpl)) {
            foreach ($findpl as $fl) {
              $finalplayingteams[] = $fl;
            }
          }
        }

        foreach ($finalplayingteams as $fl) {
          $player_details = DB::table('players')->join('matchplayers', 'players.id', '=', 'matchplayers.playerid')->where('players.player_key', $fl)->where('players.sport_type', 1)->where('matchplayers.sport_type', 1)->where('matchplayers.matchkey', $match_key)->select('players.id')->first();
          if (!empty($player_details)) {
            $players[] = $player_details->id;
          }
        }

        // DB::table('matchplayers')->where('matchkey',   )
        if (!empty($finalplayingteams)) {
          $insert_data = array(

            "match_key" => $match_key,

            "player_ids" => serialize($players),

          );


          $findExist = DB::table('match_playing11')->where('match_key', $match_key)->first();
          if (!empty($findExist)) {

            DB::table('match_playing11')->where('match_key', $match_key)->update($insert_data);
          } else {
            DB::table('match_playing11')->insert($insert_data);
          }

          $findIsSecondInning = DB::table('listmatches')->where('matchkey', $match_key)->where('second_inning_allow', 1)->first();
          if (!empty($findIsSecondInning)) {

            $insert_data = array(
              "match_key" => $match_key . "_2",
              "player_ids" => serialize($players),
            );

            $findExist = DB::table('match_playing11')->where('match_key', $match_key . "_2")->first();
            if (!empty($findExist)) {
              DB::table('match_playing11')->where('match_key', $match_key . "_2")->update($insert_data);
            } else {
              DB::table('match_playing11')->insert($insert_data);
            }
          }
        }
      }
    }
  }

  public static function get_playing_11_football($match_key, $sport)
  {

    $findmatchtype = DB::table('listmatches')->where('matchkey', $match_key)->select('format', 'series')->first();
    $giveresresult = FootballController::getmatchdetails($match_key);
    //  print_r($giveresresult); exit;
    $giveresresult = @$giveresresult['data'];
    // print_r($giveresresult); exit;
    if ($match_key == 1241284158949560332) {
      // print_r($giveresresult); exit;
    }

    $finalplayingteams = array();
    if (!empty($giveresresult)) {
      $players = @$giveresresult['players'];
      if (!empty($players)) {
        foreach ($players as $fl) {
          if (@$fl['in_playing_squad']) {
            $finalplayingteams[] = $fl;
          }
        }
      }
      $playerss = array();
      if (!empty($finalplayingteams)) {
        foreach ($finalplayingteams as $fl) {
          $player_details = DB::table('players')->join('matchplayers', 'players.id', '=', 'matchplayers.playerid')->where('players.player_key', $fl['key'])->where('players.sport_type', 2)->where('matchplayers.sport_type', 2)->where('matchplayers.matchkey', $match_key)->select('players.id')->first();
          if (!empty($player_details)) {
            $playerss[] = $player_details->id;
          }
        }

        // DB::table('matchplayers')->where('matchkey',   )
        // print_r($playerss); exit;
        if (!empty($finalplayingteams)) {
          $insert_data = array(

            "match_key" => $match_key,

            "player_ids" => serialize($playerss),

          );
          $findExist = DB::table('match_playing11')->where('match_key', $match_key)->first();
          if (!empty($findExist)) {

            DB::table('match_playing11')->where('match_key', $match_key)->update($insert_data);
          } else {
            DB::table('match_playing11')->insert($insert_data);
          }
        }
      }
    }
  }

  public function oversDataUpdate($matchkey)
  {
    // $oversData = CricketapiController::overByOver($matchkey);
    // $oversData = $oversData['data'];
    // $innings = $oversData['innings'];
    // // print_r($innings); exit;
    // $i = 1;
    // foreach ($innings as $key => $value) {
    //  $overs_summary = $value['overs_summary'];
    //  foreach ($overs_summary as $key2 => $value2) {
    //      $innings = $value2['innings'];
    //      $over = $value2['over']; print_r($value2);
    //      $already_over_counted = DB::table('players_overs_points')->where('inning', $i)->where('over', $over)->where('matchkey', $matchkey)->get();
    //      if(empty($already_over_counted)) {
    //      /*Batting insert data*/
    //      $batsman = $value2['batsman'];
    //      $batting_insert_data = array();
    //      $b1 = 0;
    //      foreach ($batsman as $key3 => $value3) {
    //          $batting = $value3['batting'];
    //          $runs = $batting['runs'];
    //          $fours = $batting['fours'];
    //          $sixes = $batting['sixes'];
    //          $runs_point = ($runs * 0.5) + ($fours * 0.5) + ($sixes * 1);
    //          // print_r($runs_point);
    //          $player_key = $value3['key'];
    //          $player_info = DB::table('matchplayers')->join('players','matchplayers.playerid','=','players.id')->where('matchplayers.matchkey', $matchkey)->where('players.player_key', $player_key)->select('players.id')->first();
    //          if(!empty($player_info)) {
    //              $already_points = DB::table('players_overs_points')->where('player_id', $player_info->id)->where('inning', $i)->where('matchkey', $matchkey)->sum('point');
    //              if($already_points) {
    //                  $runs_point = $runs_point - $already_points;
    //              }
    //              $batting_insert_data[$b1]['matchkey'] = $matchkey;
    //              $batting_insert_data[$b1]['inning'] = $i;
    //              $batting_insert_data[$b1]['over'] = $over;
    //              $batting_insert_data[$b1]['player_id'] = $player_info->id;
    //              $batting_insert_data[$b1]['point'] = $runs_point;
    //              $batting_insert_data[$b1]['created_at'] = date('Y-m-d H:i:s');
    //              $b1++;
    //          }
    //      }
    //      //print_r($batting_insert_data);
    //      DB::table('players_overs_points')->insert($batting_insert_data);
    //      /*Bowling insert data*/
    //      $bowler = $value2['bowler'];
    //      $bowler_insert_data = array();
    //      $b2 = 0;
    //      foreach ($bowler as $key3 => $value3) {
    //          $bowling = $value3['bowling'];
    //          $maiden = $bowling['maiden_overs'];
    //          $wickets = $bowling['wickets'];
    //          $runs_point = ($maiden * 4) + ($wickets * 10);
    //          $player_key = $value3['key'];
    //          $player_info = DB::table('matchplayers')->join('players','matchplayers.playerid','=','players.id')->where('matchplayers.matchkey', $matchkey)->where('players.player_key', $player_key)->select('players.id')->first();
    //          if(!empty($player_info)) {
    //              $already_points = DB::table('players_overs_points')->where('player_id', $player_info->id)->where('inning', $i)->where('matchkey', $matchkey)->sum('point');
    //              if($already_points) {
    //                  $runs_point = $runs_point - $already_points;
    //              }
    //              $bowler_insert_data[$b2]['matchkey'] = $matchkey;
    //              $bowler_insert_data[$b2]['inning'] = $i;
    //              $bowler_insert_data[$b2]['over'] = $over;
    //              $bowler_insert_data[$b2]['player_id'] = $player_info->id;
    //              $bowler_insert_data[$b2]['point'] = $runs_point;
    //              $bowler_insert_data[$b2]['created_at'] = date('Y-m-d H:i:s');
    //              $b2++;
    //          }
    //      }
    //      //print_r($bowler_insert_data);
    //      try {
    //           DB::table('players_overs_points')->insert($bowler_insert_data);
    //      }
    //      catch(\Illuminate\Database\QueryException $ex) {}
    //      /*Bowling insert data*/
    //  }
    //  } //exit;
    //  $i++;
    // } //exit;
  }

  public function updateFootballScore($match_key)
  {
    $sportType = DB::table('sport_types')->where('id', 2)->first();
    $match_detail = FootballController::getmatchdetails($match_key);
    if (!empty($match_detail)) {
      $match_detail = $match_detail['data'];
      $players = @$match_detail['players'];
      if ($match_key == 1158671669200556138) {
      }
      // print_r($match_detail); exit;
      $getmtdatastatus['status'] = @$match_detail['match']['status'];
      if ($getmtdatastatus['status'] == 'completed') {
        $getmtdatastatus['final_status'] = 'IsReviewed';
      }
      if (@$match_detail['match']['data_review_checkpoint'] == 'post_match_validated') {
        $getmtdatastatus['is_verified'] = 1;
      }
      if (!empty($players)) {
        DB::table('result_matches')->where('match_key', $match_key)->where('sport_type', $sportType->id)->delete();
        DB::table('listmatches')->where('matchkey', $match_key)->update($getmtdatastatus);
        $i = 0;
        foreach ($players as $player_key => $playing_player) {
          $stats = @$playing_player['stats'];
          if (!empty($stats)) { //print_r($playing_player);
            // $datasv = array();
            $player_id = $playing_player['key'];
            $datasvv['player_key'] = $player_id;
            $datasvv['starting11'] = 1;
            $datasvv['match_key'] = $match_key;
            $datasvv['sport_type'] = $sportType->id;
            $datasvv['innings'] = 1;
            $player = DB::table('matchplayers')->join('players', 'players.id', '=', 'matchplayers.playerid')->where('matchkey', $match_key)->where('matchplayers.sport_type', $sportType->id)->where('players.sport_type', $sportType->id)->select('matchplayers.*', 'players.player_key', 'players.role as playerrole')->where('players.player_key', $player_id)->first();
            if (!empty($player)) {
              $datasvv['player_id'] = $player->playerid;
              // $findplayerex = DB::table('result_matches')->where('player_key', $player_id)->where('match_key', $match_key)->where('innings', 1)->select('id')->first();

              if (!empty($player)) {
                $playingTime = $stats['minutes_played'];
                $goals = $stats['goal']['scored'];
                $assist = $stats['goal']['assist'] + $stats['goal']['own_goal_assist'];
                $passes = @$stats['passes'] ? $stats['passes'] : 0;
                $shots = @$stats['shot_on_target'] ? $stats['shot_on_target'] : 0;
                $cleansheet = @$stats['clean_sheet'] ? 1 : 0;
                $saveShots = @$stats['goal']['saved'] ? $stats['goal']['saved'] : 0;
                $penaltySave = $stats['penalty']['saved'];
                $tackles = @$stats['tackles'] ? $stats['tackles'] : 0;
                $yellowCard = $stats['card']['YC'];
                $redCard = $stats['card']['RC'];
                $goalconceded = @$stats['goal']['conceded'] ? $stats['goal']['conceded'] : 0;
                $ownGoal = @$stats['goal']['own_goal_conceded'] ? $stats['goal']['own_goal_conceded'] : 0;
                $penaltyMiss = $stats['penalty']['missed'];
                if ($playingTime > 0) {
                  $datasv[$i]['minutesplayed'] = $playingTime;
                  $datasv[$i]['goals'] = $goals;
                  $datasv[$i]['assist'] = $assist;
                  $datasv[$i]['totalpass'] = $passes;
                  $datasv[$i]['shotsontarget'] = $shots;
                  $datasv[$i]['cleansheet'] = $cleansheet;
                  $datasv[$i]['shotsblocked'] = $saveShots;
                  $datasv[$i]['penaltysave'] = $penaltySave;
                  $datasv[$i]['tacklesuccess'] = $tackles;
                  $datasv[$i]['yellowcard'] = $yellowCard;
                  $datasv[$i]['redcard'] = $redCard;
                  $datasv[$i]['owngoals'] = $ownGoal;
                  $datasv[$i]['penaltymiss'] = $penaltyMiss;
                  $datasv[$i]['goalconceded'] = $goalconceded;
                  $datasv[$i]['sport_type'] = $sportType->id;
                  $datasv[$i]['match_key'] = $match_key;
                  $datasv[$i]['sport_type'] = $sportType->id;
                  $datasv[$i]['player_key'] = $player_id;
                  $datasv[$i]['player_id'] = $player->playerid;
                  $datasv[$i]['total_points'] = 0; //($playingTime + $goals + $assist + $passes + $shots + $cleansheet + $saveShots + $penaltySave + $tackles + $yellowCard + $redCard + $ownGoal + $penaltyMiss + $goalconceded);
                  $datasv[$i]['starting11'] = 1;
                  // $findplayerex = DB::table('result_matches')->where('player_key', $player_id)->where('match_key', $match_key)->where('sport_type', $sportType->id)->select('id')->first();
                  // if (!empty($findplayerex)) {
                  //     DB::table('result_matches')->where('id', $findplayerex->id)->update($datasv);
                  // } else {
                  // DB::table('result_matches')->insert($datasv);
                  // }
                  // echo $i; //exit;
                }
                $i++;
              }
            }
          }
        }

        try {
          DB::table('result_matches')->insert($datasv);
          // }
        } catch (Exception $e) {
        }

        $showpoints = MatchesController::player_point($match_key, 'other', $sportType->sport_key);

        $refunded = MatchesController::refund_amount($match_key, $sportType->id);
      }
    }
  }

  public function getscoresupdates($match_key, $sport_type = '1')
  {
    date_default_timezone_set('Asia/Kolkata');
    //  echo $sport_type; exit;
    $sportType = DB::table('sport_types')->where('id', $sport_type)->first();
    $sport_type = $sportType->sport_key;

    // echo $sport_type; exit;
    switch ($sport_type) {
      case FOOTBALL: {
          /// xxxxxxxxxxxx Flexible xxxxxxxxxxxxxxxxxxx
          $listmatches = DB::table('listmatches')
            ->where('matchkey', $match_key)
            ->where('sport_type', $sportType->id)
            ->where('final_status', '!=', 'winnerdeclared')
            ->where('final_status', '!=', 'IsCanceled')
            // ->where('status','=','started')
            ->where('flexible_breakup_set', 0)
            ->first();

          $getcurrentdate = date('Y-m-d H:i:s');
          if (!empty($listmatches)) {
            $matchtimings = @$listmatches->start_date;
            // echo $getcurrentdate .'<'. $matchtimings; exit;
            if (!$getcurrentdate > $matchtimings) {
              // echo "not live"; exit;
              // return true;
            } else {
              $flaxuble = MatchesController::set_flexy_league_automatic($match_key, $sportType->id);
            }
          }
          /// xxxxxxxxxxxx Flexible xxxxxxxxxxxxxxxxxxx
          $findmatchtype = DB::table('listmatches')->where('matchkey', $match_key)->where('sport_type', $sportType->id)->select('format', 'short_name', 'team1display', 'team2display')->first();
          $match_detail = FootballController::get_match_score($match_key);
          $team_statistics = @$match_detail->items->playerstats;

          if (!empty($match_detail)) {
            DB::table('result_matches')->where('match_key', $match_key)->where('sport_type', $sportType->id)->delete();

            $matchInfo = $match_detail->items->match_info;
            $match_status = $matchInfo->status; // 1 = scheduled , 2 = completed, 3 = Live , 4 = canceled
            if ($match_status == 2 && $matchInfo->verified == 'true') {

              $winnerteam =  $match_detail->items->match_info->result;

              $winteamname = $winnerteam->winner;
              $matchdata['winning_status'] = '';
              if ($winteamname == 'away') {
                $team2 = $findmatchtype->team2display;

                $matchdata['winning_status'] = $team2 . ' Win ' . $winnerteam->away . '-' . $winnerteam->home;
              }
              if ($winteamname == 'home') {
                $team1 = $findmatchtype->team1display;
                $matchdata['winning_status'] = $team1 . ' Win ' . $winnerteam->home . '-' . $winnerteam->away;
              }
              if ($winteamname == 'draw') {
                $matchdata['winning_status'] = $winteamname;
              }

              $getmtdatastatus['status'] = 'completed';
              $getmtdatastatus['is_verified'] = 1;
            }
            if ($match_status == 3) {
              $getmtdatastatus['status'] = 'started';
            }

            if (@$getmtdatastatus['status'] == 'completed') {
              $getmtdatastatus['final_status'] = 'IsReviewed';
              $image = "";
              $titleget = @$findmatchtype->short_name;
              $msg = 'This match IsReviewed please winner declared';
              $userdata = array(1, 3);
              foreach ($userdata as $userid) {
                //	Helpers::sendnotification($titleget,$msg,$image,$userid);
              }
            }
            if (!empty(@$getmtdatastatus['status']) || !is_null(@$getmtdatastatus['status'])) {
              DB::table('listmatches')->where('matchkey', $match_key)->where('sport_type', $sportType->id)->update($getmtdatastatus);
            }


            $checkpre = DB::table('matchruns')->where('matchkey', $match_key)->where('sport_type', $sportType->id)->first();
            if (empty($checkpre)) {
              $matchdata['matchkey'] = $match_key;
              $matchdata['teams1'] = $matchInfo->teams->home->abbr;
              $matchdata['teams2'] = $matchInfo->teams->away->abbr;
              $matchdata['runs1'] = $matchInfo->result->home;
              $matchdata['runs2'] = $matchInfo->result->away;
              $matchdata['sport_type'] = $sportType->id;
              $matchdata['match_time'] = $matchInfo->time;
              DB::table('matchruns')->insert($matchdata);
            } else {
              $matchdata['matchkey'] = $match_key;
              $matchdata['teams1'] = $matchInfo->teams->home->abbr;
              $matchdata['teams2'] = $matchInfo->teams->away->abbr;
              $matchdata['runs1'] = $matchInfo->result->home;
              $matchdata['runs2'] = $matchInfo->result->away;

              $matchdata['match_time'] = $matchInfo->time;
              DB::table('matchruns')->where('matchkey', $match_key)->where('sport_type', $sportType->id)->update($matchdata);
            }


            $team_statistics = (empty($team_statistics) ? array() : $team_statistics);
            //echo"<pre>";  print_r($team_statistics); exit;
            foreach ($team_statistics as $teamkey => $team_player) {
              $teamid = $matchInfo->teams->{$teamkey}->tid;
              $i = 0;
              $datasv = array();
              foreach ($team_player as $playing_player) {
                if (isset($playing_player->pid)) {
                  // $datasv = array();
                  $player_id = $playing_player->pid;

                  $datasvv['player_key'] = $player_id;
                  $datasvv['starting11'] = $playing_player->starting11;
                  $datasvv['substitute'] = $playing_player->substitute;
                  $datasvv['match_key'] = $match_key;
                  $datasvv['sport_type'] = $sportType->id;
                  $datasvv['innings'] = 1;
                  $player = DB::table('matchplayers')->join('players', 'players.id', '=', 'matchplayers.playerid')->where('matchkey', $match_key)->where('matchplayers.sport_type', $sportType->id)->where('players.sport_type', $sportType->id)->select('matchplayers.*', 'players.player_key', 'players.role as playerrole')->where('players.player_key', $player_id)->first();
                  if (!empty($player)) {
                    $datasvv['player_id'] = $player->playerid;
                    // $findplayerex = DB::table('result_matches')->where('player_key', $player_id)->where('match_key', $match_key)->where('innings', 1)->select('id')->first();

                    if (!empty($player)) {
                      $playingTime = $playing_player->minutesplayed;
                      $goals = $playing_player->goalscored;
                      $assist = $playing_player->assist;
                      $passes = $playing_player->passes;
                      $shots = $playing_player->shotsontarget;
                      $cleansheet = $playing_player->cleansheet;
                      $saveShots = $playing_player->shotssaved;
                      $penaltySave = $playing_player->penaltysaved;
                      $tackles = $playing_player->tacklesuccessful;
                      $yellowCard = $playing_player->yellowcard;
                      $redCard = $playing_player->redcard;
                      $goalconceded = $playing_player->goalsconceded;
                      $ownGoal = $playing_player->owngoal;
                      $penaltyMiss = $playing_player->penaltymissed;

                      $chancecreated = @$playing_player->chancecreated ? $playing_player->chancecreated : 0;
                      $starting11 = $playing_player->starting11;
                      $substitute = $playing_player->substitute;
                      $blockedshot = @$playing_player->blockedshot ? $playing_player->blockedshot : 0;
                      $interceptionwon = @$playing_player->interceptionwon ? $playing_player->interceptionwon : 0;
                      $clearance = @$playing_player->clearance ? $playing_player->clearance : 0;
                      //New Params
                      if ($player->playerid == 21584 && $playingTime == 0) {
                      } else {
                        $datasv[$i]['minutesplayed'] = $playingTime;
                        $datasv[$i]['goals'] = $goals;
                        $datasv[$i]['assist'] = $assist;
                        $datasv[$i]['totalpass'] = $passes;
                        $datasv[$i]['shotsontarget'] = $shots;
                        $datasv[$i]['cleansheet'] = $cleansheet;
                        $datasv[$i]['shotsblocked'] = $saveShots;
                        $datasv[$i]['penaltysave'] = $penaltySave;
                        $datasv[$i]['tacklesuccess'] = $tackles;
                        $datasv[$i]['yellowcard'] = $yellowCard;
                        $datasv[$i]['redcard'] = $redCard;
                        $datasv[$i]['owngoals'] = $ownGoal;
                        $datasv[$i]['penaltymiss'] = $penaltyMiss;
                        $datasv[$i]['goalconceded'] = $goalconceded;
                        $datasv[$i]['sport_type'] = $sportType->id;
                        $datasv[$i]['match_key'] = $match_key;
                        $datasv[$i]['sport_type'] = $sportType->id;
                        $datasv[$i]['player_key'] = $player_id;
                        $datasv[$i]['player_id'] = $player->playerid;
                        $datasv[$i]['total_points'] = 0; //($playingTime + $goals + $assist + $passes + $shots + $cleansheet + $saveShots + $penaltySave + $tackles + $yellowCard + $redCard + $ownGoal + $penaltyMiss + $goalconceded);
                        $datasv[$i]['starting11'] = $starting11;
                        $datasv[$i]['substitute'] = $substitute;
                        //New Param
                        $datasv[$i]['chancecreated'] = $chancecreated;
                        $datasv[$i]['interceptionwon'] = $interceptionwon;
                        $datasv[$i]['blockedshot'] = $blockedshot;
                        $datasv[$i]['clearance'] = $clearance;
                      }
                      $i++;
                    }
                  }
                }
              }


              try {


                // } else {


                DB::table('result_matches')->insert($datasv);
                // }
              } catch (Exception $e) {
              }
            }
            $showpoints = MatchesController::player_point($match_key, $findmatchtype->format, $sportType->sport_key);
            // exit;
            //MatchesController::update_leaderboard_points($match_key ,$sportType->id);
            // MatchesController::update_leaderboard_rank($match_key ,$sportType->id);

          }
          $refunded = MatchesController::refund_amount($match_key, $sportType->id);
          $refunded_clash = MatchesController::clash_refund($match_key, $sportType->id);
          // exit;
        }
        break;
      case BASKETBALL: {
          /// xxxxxxxxxxxx Flexible xxxxxxxxxxxxxxxxxxx
          $listmatches = DB::table('listmatches')
            ->where('matchkey', $match_key)
            ->where('sport_type', $sportType->id)
            ->where('final_status', '!=', 'winnerdeclared')
            ->where('final_status', '!=', 'IsCanceled')
            // ->where('status','=','started')
            ->where('flexible_breakup_set', 0)
            ->first();

          $getcurrentdate = date('Y-m-d H:i:s');
          if (!empty($listmatches)) {
            $matchtimings = @$listmatches->start_date;
            // echo $getcurrentdate .'<'. $matchtimings; exit;
            if (!$getcurrentdate > $matchtimings) {
              // echo "not live"; exit;
              // return true;
            } else {
              $flaxuble = MatchesController::set_flexy_league_automatic($match_key, $sportType->id);
            }
          }
          /// xxxxxxxxxxxx Flexible xxxxxxxxxxxxxxxxxxx
          // $match_key = 15701
          $findmatchtype = DB::table('listmatches')->where('matchkey', $match_key)->where('sport_type', $sportType->id)->select('format', 'short_name')->first();
          $match_detail = BasketBallController::get_match_score($match_key);
          $team_statistics = @$match_detail->items->fantasy_points;
          // echo '<pre>'; print_r($match_detail); exit;
          DB::table('result_matches')->where('match_key', $match_key)->where('sport_type', $sportType->id)->delete();

          if (!empty($match_detail)) {
            $matchInfo = $match_detail->items->match_info;

            $match_status = $matchInfo->status; // 1 = scheduled , 2 = completed, 3 = Live , 4 = canceled
            if ($match_status == 2 && $matchInfo->verified == 'true') {
              $getmtdatastatus['status'] = 'completed';
              $getmtdatastatus['is_verified'] = 1;
            }
            if ($match_status == 3) {
              $getmtdatastatus['status'] = 'started';
            }
            // $getmtdatastatus['status'] = $mainarrayget['status'];
            if (@$getmtdatastatus['status'] == 'completed') {
              $getmtdatastatus['final_status'] = 'IsReviewed';
              $image = "";
              $titleget = @$findmatchtype->short_name;
              $msg = 'This match IsReviewed please winner declared';
              $userdata = array(1, 3);
              foreach ($userdata as $userid) {
                //	Helpers::sendnotification($titleget,$msg,$image,$userid);
              }
            }
            if (!empty(@$getmtdatastatus['status']) || !is_null(@$getmtdatastatus['status'])) {
              // print_r($getmtdatastatus); exit;
              DB::table('listmatches')->where('matchkey', $match_key)->where('sport_type', $sportType->id)->update($getmtdatastatus);
            }

            $checkpre = DB::table('matchruns')->where('matchkey', $match_key)->where('sport_type', $sportType->id)->first();
            if (empty($checkpre)) {
              $matchdata['matchkey'] = $match_key;
              $matchdata['teams1'] = $matchInfo->teams->home->abbr;
              $matchdata['teams2'] = $matchInfo->teams->away->abbr;
              $matchdata['runs1'] = $matchInfo->result->home;
              $matchdata['runs2'] = $matchInfo->result->away;
              $matchdata['sport_type'] = $sportType->id;
              $matchdata['match_time'] = $matchInfo->time;
              DB::table('matchruns')->insert($matchdata);
            } else {
              $matchdata['matchkey'] = $match_key;
              $matchdata['teams1'] = $matchInfo->teams->home->abbr;
              $matchdata['teams2'] = $matchInfo->teams->away->abbr;
              $matchdata['runs1'] = $matchInfo->result->home;
              $matchdata['runs2'] = $matchInfo->result->away;

              $matchdata['match_time'] = $matchInfo->time;
              DB::table('matchruns')->where('matchkey', $match_key)->where('sport_type', $sportType->id)->update($matchdata);
            }

            $team_statistics = (empty($team_statistics) ? array() : $team_statistics);
            foreach ($team_statistics as $teamkey => $team_player) {
              $teamid = $matchInfo->teams->{$teamkey}->tid;
              $team_player = (empty($team_player) ? array() : $team_player);
              foreach ($team_player as $playing_player) {
                $datasv = array();
                $player_id = $playing_player->pid;
                $datasv['player_key'] = $player_id;
                $datasv['starting11'] = 1;
                $datasv['sport_type'] = $sportType->id;
                $datasv['match_key'] = $match_key;
                $datasv['innings'] = 1;
                $player = DB::table('matchplayers')->join('players', 'players.id', '=', 'matchplayers.playerid')->where('matchkey', $match_key)->where('matchplayers.sport_type', $sportType->id)->where('players.sport_type', $sportType->id)->select('matchplayers.*', 'players.player_key', 'players.role as playerrole')->where('players.player_key', $player_id)->first();
                if (!empty($player)) {
                  if (!empty($player)) {
                    $role = $playing_player->role;
                    $pointscored = $playing_player->pointscored;
                    $rebound = $playing_player->rebound;
                    $assists = $playing_player->assist;
                    $steals = $playing_player->steal;
                    $blocks = $playing_player->block;
                    $turnovers = $playing_player->turnover;
                    $datasv['apiresult'] = json_encode($playing_player);
                    $datasv['pointscored'] = $pointscored;
                    $datasv['rebound'] = $rebound;
                    $datasv['assist'] = $assists;
                    $datasv['steal'] = $steals;
                    $datasv['block'] = $blocks;
                    $datasv['turnover'] = $turnovers;
                    $datasv['sport_type'] = $sportType->id;
                    $datasv['match_key'] = $match_key;
                    $datasv['player_key'] = $player_id;
                    $datasv['player_id'] = $player->playerid;
                    $datasv['total_points'] = number_format($playing_player->point, 2);
                    $datasv['starting11'] = 1;
                    $findplayerex = DB::table('result_matches')->where('player_key', $player_id)->where('match_key', $match_key)->where('sport_type', $sportType->id)->select('id')->first();
                    if (!empty($findplayerex)) {
                      DB::table('result_matches')->where('id', $findplayerex->id)->update($datasv);
                    } else {
                      DB::table('result_matches')->insert($datasv);
                    }
                  }
                }
              }
            }

            //  MatchesController::update_leaderboard($match_key ,$sportType->id);

            // $showpoints = MatchesController::player_point($match_key, $findmatchtype->format ,$sportType->sport_key);
            $showpoints = MatchesController::player_point($match_key, 'other', $sportType->sport_key);

            $refunded = MatchesController::refund_amount($match_key, $sportType->id);
            $refunded_clash = MatchesController::clash_refund($match_key, $sportType->id);
          }
          // exit;
        }
        break;
      // xxxxxxxxxxxxxxxxxxx KABADDI ADDED NEW xxxxxxxxxxxxxxxxxxx

      case 'KABADDI': {
          $listmatches = DB::table('listmatches')
            ->where('matchkey', $match_key)
            ->where('sport_type', 7)
            ->where('final_status', '!=', 'winnerdeclared')
            ->where('final_status', '!=', 'IsCanceled')
            ->where('status', '=', 'started')
            ->where('flexible_breakup_set', 0)
            ->first();

          $getcurrentdate = date('Y-m-d H:i:s');
          if (!empty($listmatches)) {
            $matchtimings = @$listmatches->start_date;
            if ($getcurrentdate < $matchtimings) {
              // dd($listmatches);
              return true;
            } else {
              $flaxuble = MatchesController::set_flexy_league_automatic($match_key, '7');
            }
          }

          $matchInfo = array();
          $findmatchtype = DB::table('listmatches')->where('matchkey', $match_key)->where('sport_type', $sportType->id)->select('format', 'short_name')->first();
          $match_detail = KabaddiController::get_match_score($match_key);

          if ($match_detail == 'forbidden') {
            Session::flash('flash_notice', 'Match score data not found');
            Session::flash('alert-class', 'alert-danger');
            // Helpers::logActivity('AMatch score data not found!',$sport_type);
            return redirect()->to('admin/matches/match-mapping/7');

            //return redirect()->action('App\Http\Controllers\Admin\MatchesController@marathon_result');
          }

          if (!empty($match_detail)) {
            $matchInfo = $match_detail->items->match_info;
            $matchScore = $match_detail->items->match_player_stats;
            $matchPoint = $match_detail->items->new_points;
          }
          $matchInfo = $match_detail->items->match_info;
          $match_status = $matchInfo->status;

          if ($match_status == 2 && $matchInfo->verified == 'true') {
            $getmtdatastatus['status'] = 'completed';
            $getmtdatastatus['is_verified'] = 1;
          }
          if ($match_status == 3) {
            $getmtdatastatus['status'] = 'started';
          }
          if (@$getmtdatastatus['status'] == 'completed') {
            $getmtdatastatus['final_status'] = 'IsReviewed';
            $image = "";
            $titleget = @$findmatchtype->short_name;
            $msg = 'This match IsReviewed please winner declared';
            $userdata = array(1, 3);
            foreach ($userdata as $userid) {
              //	Helpers::sendnotification($titleget,$msg,$image,$userid);
            }
          }
          if (!empty(@$getmtdatastatus['status']) || !is_null(@$getmtdatastatus['status'])) {
            DB::table('listmatches')->where('matchkey', $match_key)->where('sport_type', $sportType->id)->update($getmtdatastatus);
          }
          $checkpre = DB::table('matchruns')->where('matchkey', $match_key)->where('sport_type', $sportType->id)->first();
          if (empty($checkpre)) {
            $matchdata['matchkey'] = $match_key;
            $matchdata['teams1'] = $matchInfo->teams->home->shortname;
            $matchdata['teams2'] = $matchInfo->teams->away->shortname;
            $matchdata['runs1'] = $matchInfo->result->home;
            $matchdata['runs2'] = $matchInfo->result->away;
            $matchdata['sport_type'] = $sportType->id;
            $matchdata['match_time'] = $matchInfo->time;
            DB::table('matchruns')->insert($matchdata);
          } else {
            $matchdata['matchkey'] = $match_key;
            $matchdata['teams1'] = $matchInfo->teams->home->shortname;
            $matchdata['teams2'] = $matchInfo->teams->away->shortname;
            $matchdata['runs1'] = $matchInfo->result->home;
            $matchdata['runs2'] = $matchInfo->result->away;
            $matchdata['match_time'] = $matchInfo->time;
            DB::table('matchruns')->where('matchkey', $match_key)->where('sport_type', $sportType->id)->update($matchdata);
          }
          $team_statistics = @$match_detail->items->match_player_stats;
          if (!empty($match_detail)) {
            $db_sport_Type = DB::table('sport_types')->where('sport_key', 'KABADDI')->first();
            if (empty($matchScore)) {
              $matchScore = array();
            }
            //########## Match Point Update  ############
            foreach ($matchScore as $key => $match_Score) {
              foreach ($match_Score as $key => $value) {
                //echo '<pre>'; print_r($match_Score);exit;
                $matchResultArr = array();
                $matchResultArr['match_key'] = $match_key;
                $matchResultArr['sport_type'] = $sportType->id;
                if (!empty($value->pid)) {
                  $player_keys = DB::table('matchplayers')->where('matchkey', $match_key)->where('player_key', $value->pid)->select('playerid as id')->first();
                  if (!isset($player_keys)) {
                    continue;
                  }
                  $matchResultArr['player_key'] = $value->pid;
                  $matchResultArr['player_id'] = $player_keys->id;
                }

                $matchResultArr['role'] = @$player_keys->role;
                $matchResultArr['greencard'] = $value->greencardcount;
                $matchResultArr['yellowcard'] = $value->yellowcardcount;
                $matchResultArr['redcard'] = $value->redcardcount;
                //$matchResultArr['pointscored'] = $value->totalpoint;
                $matchResultArr['pointscored'] = 0;
                $matchResultArr['starting7'] = !empty($value->starting7) ? $value->starting7 : 0;
                $matchResultArr['substitute'] = !empty($value->substitute) ? $value->substitute : 0;
                $matchResultArr['raidtotalpoint'] = $value->raidtotalpoint;
                $matchResultArr['raidtouch']  = $value->raidtouchpoint;
                $matchResultArr['raidbonus'] = $value->raidbonuspoint;
                $matchResultArr['tackletotalpoint'] = $value->tackletotalpoint;
                $matchResultArr['tacklecapturepoint'] = $value->tacklecapturepoint;
                $matchResultArr['tacklecapturebonuspoint'] = $value->tacklecapturebonuspoint;
                $matchResultArr['tackletotal'] = $value->tackletotal;
                $matchResultArr['tacklesucceessful'] = $value->tacklesuccessful;
                $matchResultArr['tackleunsuccessful'] = $value->tackleunsuccessful;
                $matchResultArr['supertackle'] = $value->supertackles;
                $matchResultArr['raidtotal'] = $value->raidtotal;
                $matchResultArr['raidsuccessful'] = $value->raidsuccessful;
                $matchResultArr['raidunsuccessful'] = $value->raidunsuccessful;
                $matchResultArr['raidempty'] = $value->raidempty;
                $matchResultArr['superraid'] = $value->superraid;
                $matchResultArr['super10']  = $value->superten;
                $matchResultArr['highfive'] = $value->highfive;
                $matchResultArr['starting11'] = 1;
                $matchResultArr['pushingallout'] = !empty($value->pushingallout) ? $value->pushingallout : 0;
                $matchResultArr['gettingallout'] = !empty($value->gettingallout) ? $value->gettingallout : 0;
                $db_match_check = DB::table('result_matches')->where('player_id', $player_keys->id)->where('match_key', $match_key)->first();
                if (!empty($db_match_check)) {
                  // DB::table('result_matches')->where('match_key', $match_key)->where('sport_type', $sportType->id)->delete();
                  $findmatchtype = DB::table('listmatches')->where('matchkey', $match_key)->where('sport_type', $sportType->id)->first();
                  // if (@$findmatchtype->status!= 'completed') {
                  //    DB::table('result_matches')->where('id', $db_match_check->id)->update($matchResultArr);
                  // }
                  DB::table('result_matches')->where('id', $db_match_check->id)->update($matchResultArr);
                } else {
                  DB::table('result_matches')->insert($matchResultArr);
                }
              }
            }

            if (empty($matchScore)) {
              $matchPoint = array();
            }
            //########## Match Point Update  ############
            if (!empty($matchPoint)) {
              foreach ($matchPoint as $key => $match_Point) {
                foreach ($match_Point as $key => $value) {
                  $matchPointArr = array();
                  $match_id_arr = DB::table('result_matches')->where('player_key', $value->pid)->where('match_key', $match_key)->first();
                  if (!empty($match_id_arr->id)) {
                    $matchPointArr['resultmatch_id']    = $match_id_arr->id;
                  }
                  $matchPointArr['matchkey']          = $match_key;
                  if (!empty($value->pid)) {
                    $player_keys = DB::table('matchplayers')->join('players', 'players.id', '=', 'matchplayers.playerid')->where('matchkey', $match_key)->where('matchplayers.sport_type', $sportType->id)->where('players.sport_type', $sportType->id)->select('players.*')->where('players.player_key', $value->pid)->first();
                  }
                  if (!isset($player_keys->id)) {
                    continue;
                  }
                  $matchPointArr['playerid'] = $player_keys->id;
                  $matchPointArr['role']  = $value->role;
                  //$matchPointArr['pointscored']= $value->point;
                  $matchPointArr['pointscored'] = 0;
                  $matchPointArr['starting7'] = $value->starting7;
                  $matchPointArr['substitute'] = $value->substitute;
                  $matchPointArr['raidtouch'] = $value->raidtouch;
                  $matchPointArr['raidbonus']  = $value->raidbonus;
                  $matchPointArr['raidunsucceessful'] = $value->raidunsucceessful;
                  $matchPointArr['tacklesucceessful'] = $value->tacklesucceessful;
                  $matchPointArr['supertackle']  = $value->supertackle;
                  $matchPointArr['greencard'] = $value->greencard;
                  $matchPointArr['yellowcard'] = $value->yellowcard;
                  $matchPointArr['redcard'] = $value->redcard;
                  $matchPointArr['pushingallout'] = $value->pushingallout;
                  $matchPointArr['gettingallout'] = $value->gettingallout;
                  if (0) {
                    $matchPointArr['total'] = $value->point;
                  } else {

                    $matchPointArr['total'] = $value->point - $value->superten;
                  }
                  // $matchPointArr['sport_types']=7;
                  DB::table('result_points')->where('matchkey', $match_key)->where('playerid', @$player_keys->id)->delete();
                  DB::table('result_points')->insert($matchPointArr);

                  if ($value->substitute != 0) {
                    $matchDiffResult['substitute'] = $value->substitute / 2;
                  } else {
                    $matchDiffResult['substitute'] = 0;
                  }
                  if ($value->pushingallout != 0) {

                    $matchDiffResult['pushingallout'] = $value->pushingallout / 8;
                  } else {
                    $matchDiffResult['pushingallout'] = 0;
                  }
                  if ($value->gettingallout != 0) {

                    $matchDiffResult['gettingallout']     = $value->gettingallout / -4;
                  } else {
                    $matchDiffResult['gettingallout'] = 0;
                  }

                  $db_match_check = DB::table('result_matches')->where('player_id', @$player_keys->id)->where('match_key', $match_key)->first();
                  if (!empty($db_match_check)) {
                    //DB::table('result_matches')->where('player_id', $player_keys->id)->where('match_key', $match_key)->update($matchResultArr);
                    // DB::table('result_matches')->where('match_key', $match_key)->where('sport_type', $sportType->id)->delete();
                    // var_dump($player_keys->id);
                    //   var_dump($matchResultArr);exit;

                    $findmatchtype = DB::table('listmatches')->where('matchkey', $match_key)->where('sport_type', $sportType->id)->first();
                    // if (@$findmatchtype->status!= 'completed') {
                    //       DB::table('result_matches')->where('id', $db_match_check->id)->update($matchDiffResult);
                    // }
                    DB::table('result_matches')->where('id', $db_match_check->id)->update($matchDiffResult);
                  } else {
                    // DB::table('result_matches')->insert($matchResultArr);
                  }
                }
              }
            }

            $showpoints = MatchesController::player_point($match_key, 'other', 'KABADDI');
            // $this->updateplayerpoints($match_key,7);
            // MatchesController::update_leaderboard_points($match_key ,7);
            // MatchesController::update_leaderboard_rank($match_key ,7);
          }
          $refunded = MatchesController::refund_amount($match_key, 7);
          $refunded_clash = MatchesController::clash_refund($match_key, 7);
        }
        break;

      // xxxxxxxxxxxxxxxxxxx KABADDI ADDED NEW xxxxxxxxxxxxxxxxxxx

      case CRICKET: {
          $match_key = str_replace('_2', '', $match_key);
          $this->entityScoreUpdate($match_key, $sportType->id);
          return true;
          $findmatchtype = DB::table('listmatches')->where('matchkey', $match_key)->select('format', 'series', 'second_inning')->first();

          if ($findmatchtype->second_inning == 1) {
            $refunded = MatchesController::refund_amount($match_key);
          }

          $giveresresult = CricketapiController::getmatchdetails($match_key);

          // echo 1; exit;
          if (empty($giveresresult['data'])) {
            // print_r($giveresresult); exit;
            $giveresresult = array();
            $giveresresult = CricketapiController::getmatchdetails_old($match_key);
            // if($match_key=='engire_2020_one-day_01') { echo '<pre>'; print_r($giveresresult); exit; }

          }

          if ($match_key == 'c.match.spc_vs_vvv.837bb') {
            // print_r($giveresresult); exit;
          }

          if (!empty($giveresresult)) {

            $mainarrayget = $giveresresult['data']['card'];
            // var_dump($mainarrayget['innings']);exit;

            $db_sport_Type = DB::table('sport_types')->where('sport_key', 'CRICKET')->first();

            $data_matchruns['matchkey'] = $match_key;
            $data_matchruns['sport_type'] = $db_sport_Type->id;


            $secondInningBattingTeam = '';
            $secondInningBattingTeam_key = '';
            $secondInningBowlingTeam = '';
            $secondInningBowlingTeam_key = '';
            if (!empty($mainarrayget['toss'])) {
              $toss_won = $mainarrayget['toss']['won'];
              $toss_decision = $mainarrayget['toss']['decision'];


              if ($toss_won == 'a') {
                if ($toss_decision == 'bat') {
                  $secondInningBattingTeam = 'b';
                  $secondInningBowlingTeam = 'a';
                }
                if ($toss_decision == 'bowl') {
                  $secondInningBattingTeam = 'a';
                  $secondInningBowlingTeam = 'b';
                }
              } else {
                if ($toss_decision == 'bat') {
                  $secondInningBattingTeam = 'a';
                  $secondInningBowlingTeam = 'b';
                }
                if ($toss_decision == 'bowl') {
                  $secondInningBattingTeam = 'b';
                  $secondInningBowlingTeam = 'a';
                }
              }
            }

            if (!empty($mainarrayget['teams'])) {
              foreach ($mainarrayget['teams'] as $tp_val => $tp_key) {
                if ($tp_val === 'a') {
                  $data_matchruns['teams1'] = $tp_key['name'];
                  if ($secondInningBattingTeam == 'a') {
                    $secondInningBattingTeam_key = $tp_key['key'];
                  }
                  if ($secondInningBowlingTeam == 'a') {
                    $secondInningBowlingTeam_key = $tp_key['key'];
                  }
                } else if ($tp_val === 'b') {
                  $data_matchruns['teams2'] = $tp_key['name'];
                  if ($secondInningBattingTeam == 'b') {
                    $secondInningBattingTeam_key = $tp_key['key'];
                  }
                  if ($secondInningBowlingTeam == 'b') {
                    $secondInningBowlingTeam_key = $tp_key['key'];
                  }
                }
              }
            }

            if ($match_key == 'c.match.srj_vs_ecb.ab34b') {
              // var_dump('$secondInningBattingTeam_key');
              // var_dump($secondInningBattingTeam_key);
              $secondInningBattingTeam_key = 'c.team.srj.4f384';
              // var_dump('$secondInningBowlingTeam_key');
              // var_dump($secondInningBowlingTeam_key);
              $secondInningBowlingTeam_key = 'c.team.ecb.8de54';
            }

            if (!empty($mainarrayget['innings'])) {
              foreach ($mainarrayget['innings'] as $in_val => $in_key) {
                if (strpos($in_val, "a") !== false) {
                  $data_matchruns['runs1'] = $in_key["runs"];
                  $data_matchruns['overs1'] = $in_key["overs"];
                  $data_matchruns['wickets1'] =  $in_key["wickets"];
                } else if (strpos($in_val, "b") !== false) {
                  $data_matchruns['runs2'] = $in_key["runs"];
                  $data_matchruns['overs2'] = $in_key["overs"];
                  $data_matchruns['wickets2'] =  $in_key["wickets"];
                }
              }
            }

            if (!empty($mainarrayget['msgs'])) {
              $data_matchruns['winning_status'] = $mainarrayget['msgs']['result'];
            }

            if (!empty($mainarrayget['start_date'])) {
              $data_matchruns['match_time'] = $mainarrayget['start_date']['iso'];
            }

            $db_match_runs = DB::table('matchruns')->where('matchkey', $match_key)->first();

            if (!empty($db_match_runs)) {
              // $data_matchruns['sport_type']
              DB::table('matchruns')->where('matchkey', $match_key)->update($data_matchruns);
            } else {
              DB::table('matchruns')->insert($data_matchruns);
            }

            $findIsSecondInning = DB::table('listmatches')->where('matchkey', $match_key)->where('second_inning_allow', 1)->first();
            if (!empty($findIsSecondInning)) {
              $data_matchruns['matchkey'] = $match_key . "_2";
              $db_match_runs = DB::table('matchruns')->where('matchkey', $match_key . "_2")->first();

              if (!empty($db_match_runs)) {
                DB::table('matchruns')->where('matchkey', $match_key . "_2")->update($data_matchruns);
              } else {
                DB::table('matchruns')->insert($data_matchruns);
              }
            }


            //  print_r($mainarrayget['status']);
            if ($mainarrayget['status'] == 0) {
              $statuscomplete = "completed";
            } else {
              $statuscomplete = $mainarrayget['status'];
            }

            $getmtdatastatus['status'] = $statuscomplete;
            //  $getmtdatastatus['status'] = $mainarrayget['status'];
            if ($getmtdatastatus['status'] == 'completed') {
              $getmtdatastatus['final_status'] = 'IsReviewed';
            }
            if ($mainarrayget['data_review_checkpoint'] == 'post-match-validated') {
              $getmtdatastatus['is_verified'] = 1;
            }
            // print_r($getmtdatastatus); exit;
            DB::table('listmatches')->where('matchkey', $match_key)->update($getmtdatastatus);

            $findIsSecondInning = DB::table('listmatches')->where('matchkey', $match_key)->where('second_inning_allow', 1)->first();
            if (!empty($findIsSecondInning)) {

              DB::table('listmatches')->where('matchkey', $match_key . "_2")->update($getmtdatastatus);
            }
            $findteams = $mainarrayget['teams'];
            $finalplayingteams = array();
            if (!empty($findteams)) {
              foreach ($findteams as $tp) {
                $findpl = $tp['match']['playing_xi'];
                if (!empty($findpl)) {
                  foreach ($findpl as $fl) {
                    if (($match_key == 'bblt20_2020_e' || $match_key == 'bblt20_2020_k' || $match_key == 'bblt20_2020_c') && ($fl == 'm_steketee')) {
                      // $finalplayingteams[] = 'a_ross';
                    } else {

                      $finalplayingteams[] = $fl;
                    }
                  }
                }
              }
            }

            if ($match_key == 'c.match.hkgw_vs_malw.6be23') {
              $finalplayingteams[] = 'c.player.alison_siu.123af';
            }
            if ($match_key == 'c.match.prsxi_vs_botr.2a2e6') {
              $finalplayingteams[] = 'c.player.joe_solyn.33d78';
            }


            if ($match_key == 'icc_wc_warmupt20_2021_g1') {
              $key1 = array_search('p_stirling', $finalplayingteams); // $key = 2;
              unset($finalplayingteams[$key1]);
              $key2 = array_search('c.player.kabua_morea.e01b0', $finalplayingteams); // $key = 2;
              unset($finalplayingteams[$key2]);
              // var_dump($finalplayingteams);exit;
            }
            if (count($finalplayingteams) >= 15) {
              $giveres = $mainarrayget['players'];
              $matchplayers = DB::table('matchplayers')->join('players', 'players.id', '=', 'matchplayers.playerid')->where('matchkey', $match_key)->whereIn('players.player_key', $finalplayingteams)->select('matchplayers.*', 'players.player_key', 'players.role as playerrole')->get();
              // print_r($matchplayers); exit;
              if (!empty($matchplayers)) {
                DB::table('result_matches')->where('match_key', $match_key)->delete();

                $findIsSecondInning = DB::table('listmatches')->where('matchkey', $match_key)->where('second_inning_allow', 1)->first();
                if (!empty($findIsSecondInning)) {

                  DB::table('result_matches')->where('match_key', $match_key . "_2")->delete();
                }

                foreach ($matchplayers as $player2) {
                  $pid = $player2->playerid;

                  $datasv = array();

                  $playr = DB::table('players')->where('id', $pid)->select('player_key')->first();
                  $pact_name = $player2->player_key;


                  $datasv['match_key'] = $match_key;
                  $datasv['player_key'] = $pact_name;
                  $datasv['player_id'] = $pid;
                  $datasv['innings'] = 1;
                  $datasv['starting11'] = 1;


                  $find_starting11 = DB::table('result_matches')->where('match_key', $match_key)->where('player_key', $pact_name)->first();
                  if (empty($find_starting11)) {
                    DB::table('result_matches')->insert($datasv);
                  } else {
                    // $datasv['runouts'] = 0;
                    // $datasv['runout_thrower'] = 0;
                    // $datasv['runout_catcher'] = 0;
                    DB::table('result_matches')->where('match_key', $match_key)->where('player_key', $pact_name)->update($datasv);
                  }


                  $findIsSecondInning = DB::table('listmatches')->where('matchkey', $match_key)->where('second_inning_allow', 1)->first();
                  if (!empty($findIsSecondInning)) {

                    $find_starting11 = DB::table('result_matches')->where('match_key', $match_key . "_2")->where('player_key', $pact_name)->first();
                    $datasv['match_key'] = $match_key . "_2";
                    if (empty($find_starting11)) {
                      DB::table('result_matches')->insert($datasv);
                    } else {
                      // $datasv['runouts'] = 0;
                      // $datasv['runout_thrower'] = 0;
                      // $datasv['runout_catcher'] = 0;
                      DB::table('result_matches')->where('match_key', $match_key . "_2")->where('player_key', $pact_name)->update($datasv);
                    }
                  }
                }

                $lbwarray = array(); // new points system
                foreach ($matchplayers as $player) {
                  $pid = $player->playerid;

                  $datasv = array();

                  $playr = DB::table('players')->where('id', $pid)->select('player_key')->first();
                  $pact_name = $player->player_key;

                  $datasv['match_key'] = $match_key;
                  $datasv['player_key'] = $pact_name;
                  $datasv['player_id'] = $pid;
                  $datasv['innings'] = 1;
                  $datasv['starting11'] = 1;


                  $find_starting11 = DB::table('result_matches')->where('match_key', $match_key)->where('player_key', $pact_name)->first();
                  if (empty($find_starting11)) {
                    DB::table('result_matches')->insert($datasv);
                  } else {
                    // $datasv['runouts'] = 0;
                    // $datasv['runout_thrower'] = 0;
                    // $datasv['runout_catcher'] = 0;
                    DB::table('result_matches')->where('match_key', $match_key)->where('player_key', $pact_name)->update($datasv);
                  }

                  $findIsSecondInning = DB::table('listmatches')->where('matchkey', $match_key)->where('second_inning_allow', 1)->first();
                  if (!empty($findIsSecondInning)) {

                    $find_starting11 = DB::table('result_matches')->where('match_key', $match_key . "_2")->where('player_key', $pact_name)->first();
                    $datasv['match_key'] = $match_key . "_2";
                    if (empty($find_starting11)) {
                      DB::table('result_matches')->insert($datasv);
                    } else {
                      // $datasv['runouts'] = 0;
                      // $datasv['runout_thrower'] = 0;
                      // $datasv['runout_catcher'] = 0;
                      DB::table('result_matches')->where('match_key', $match_key . "_2")->where('player_key', $pact_name)->update($datasv);
                    }
                  }

                  if (isset($giveres[$pact_name]['match']['innings'])) {
                    $inning = $giveres[$pact_name]['match']['innings'];

                    if (!empty($inning)) {
                      $k = 1;
                      foreach ($inning as $keyin => $innings) {
                        if ($keyin == 'superover') {
                          continue;
                        }
                        if (isset($inning[$keyin])) {
                          $datasv = array();
                          $hitterarray = array();
                          $throwerarray = array();
                          $runout_direct_hit = array();
                          //starting player points//
                          $catch = 0;
                          $runouts = 0;
                          $stumbed = 0;
                          $batdots = 0;
                          $balldots = 0;
                          $six = 0;
                          $runs = 0;
                          $fours = 0;
                          $miletone_run = 0;
                          $bball = 0;
                          $strike = 0;
                          $acstrike = 0;
                          $grun = 0;
                          $balls = 0;
                          $bballs = 0;
                          $maiden_over = 0;
                          $wicket = 0;
                          $extra = 0;
                          $overs = 0;
                          $economy = 0;
                          $duck = 0;
                          $mile_wicket = 0;
                          $datasv = array();
                          // if($k==1){
                          if (in_array($pact_name, $finalplayingteams)) {
                            $datasv['starting11'] = 1;
                          } else {
                            $datasv['starting11'] = 0;
                            $starting11 = 0;
                          }
                          // }
                          //fielding points//
                          $fielding = $inning[$keyin]['fielding'];
                          if (isset($fielding['catches'])) {
                            $datasv['catch'] = $catch = $catch + $fielding['catches'];
                          }

                          if (isset($fielding['runouts'])) {
                            // $datasv['runouts'] = 0;
                            // $datasv['runout_thrower'] = 0;
                            // $datasv['runout_catcher'] = 0;
                          }
                          if (isset($fielding['stumbeds'])) {
                            $datasv['stumbed'] = $stumbed = $stumbed + $fielding['stumbeds'];
                          }
                          //batting fields//
                          $batting = $inning[$keyin]['batting'];
                          if ((!empty($batting))) {
                            if (isset($batting['strike_rate'])) {
                              $datasv['batting'] = 1;
                              $datasv['strike_rate'] = $batting['strike_rate'];
                            } else {
                              $datasv['batting'] = 0;
                            }
                          }

                          if (isset($batting['dots'])) {
                            $datasv['battingdots'] = $batdots = $batdots + $batting['dots'];
                          }
                          if (isset($batting['sixes'])) {
                            $datasv['six'] = $six = $six + $batting['sixes'];
                          }
                          if (isset($batting['runs'])) {
                            $datasv['runs'] = $runs = $runs +  $batting['runs'];
                          }
                          if (isset($batting['fours'])) {
                            $datasv['fours'] = $fours = $fours + $batting['fours'];
                          }
                          if (isset($batting['balls'])) {
                            $datasv['bball'] = $bball = $bball + $batting['balls'];
                          }
                          //duck out//
                          $datasv['duck'] = 0;

                          if (isset($batting['dismissed'])) {
                            if ($player->playerrole != 'bowler') {
                              if (($runs == 0) && ($batting['dismissed'] == 1)) {
                                $datasv['duck'] = $duck = 1;
                              }
                            } else {
                              $datasv['duck'] = $duck = 0;
                            }
                            if ($batting['dismissed'] == 1) {
                              $datasv['out_str'] = $batting['out_str'];
                            } else {
                              $datasv['out_str'] = 'not out';
                            }
                          }


                          /*if($batting['ball_of_dismissed']['wicket_type']=='runout') {
                         if(!empty($batting['ball_of_dismissed']['other_fielder'])) {
                           $run_thrower = $batting['ball_of_dismissed']['other_fielder'];
                           $find_thrower_player = DB::table('result_matches')->where('player_key',$run_thrower)->where('match_key',$match_key)->where('innings',$k)->select('id')->first();
                           if(!empty($find_thrower_player)){
                             //$data_runout_thrower['runouts'] = $1;
                             //DB::table('result_matches')->where('id',$findplayerex->id)->update($datasv);
                           }
                         } else {

                         }
                        }*/

                          if (isset($batting['ball_of_dismissed'])) {
                            $d_smm = $batting['ball_of_dismissed'];
                            if ($batting['ball_of_dismissed']['wicket_type'] == 'runout') {
                              if (!empty($d_smm['other_fielder'])) {
                                if (isset($d_smm['other_fielder'])) {
                                  if ($d_smm['other_fielder'] != "") {
                                    $throwerarray[] = $d_smm['other_fielder'] . '$$$$' . $keyin;
                                  }
                                }
                                if (isset($d_smm['fielder'])) {
                                  if (isset($d_smm['fielder']['key'])) {
                                    $hitterarray[] = $d_smm['fielder']['key'] . '$$$$' . $keyin;
                                  }
                                }
                              } else {
                                $runout_direct_hit[] = $d_smm['fielder']['key'] . '$$$$' . $keyin;
                              }
                            } else if ($batting['ball_of_dismissed']['wicket_type'] == 'lbw' || $batting['ball_of_dismissed']['wicket_type'] == 'bowled') { // new point system

                              if (isset($d_smm['bowler'])) {
                                if (isset($d_smm['bowler']['key'])) {
                                  $lbwarray[] = $d_smm['bowler']['key'] . '$$$$' . $keyin;
                                }
                              }
                            }
                          }


                          //bowling fields//
                          $bowling = $inning[$keyin]['bowling'];
                          if (!empty($bowling)) {
                            $datasv['bowling'] = 1;
                            $datasv['economy_rate'] = $bowling['economy'];
                          }
                          if (isset($bowling['runs'])) {
                            $datasv['grun'] = $grun = $grun + $bowling['runs'];
                          }
                          if (isset($bowling['dots'])) {
                            $datasv['balldots'] = $balldots = $balldots + $bowling['dots'];
                          }

                          if (isset($bowling['balls'])) {
                            $datasv['balls'] = $balls = $balls + $bowling['balls'];
                          }
                          if (isset($bowling['maiden_overs'])) {
                            $datasv['maiden_over'] = $maiden_over = $maiden_over + $bowling['maiden_overs'];
                          }
                          if (isset($bowling['wickets'])) {
                            $datasv['wicket'] = $wicket = $wicket + $bowling['wickets'];
                          }
                          if (isset($bowling['extras'])) {
                            $datasv['extra'] = $extra = $extra + $bowling['extras'];
                          }
                          if (isset($bowling['overs'])) {
                            $datasv['overs'] = $overs = $overs + $bowling['overs'];
                          }
                          $datasv['match_key'] = $match_key;
                          $datasv['player_key'] = $pact_name;
                          $datasv['player_id'] = $pid;
                          $datasv['innings'] = $keyin;

                          $findplayerex = DB::table('result_matches')->where('player_key', $pact_name)->where('match_key', $match_key)->where('innings', $keyin)->select('*')->first();

                          if (!empty($findplayerex)) {
                            DB::table('result_matches')->where('id', $findplayerex->id)->update($datasv);
                          } else {
                            DB::table('result_matches')->insert($datasv);
                          }
                          //update points//

                          $findIsSecondInning = DB::table('listmatches')->where('matchkey', $match_key)->where('second_inning_allow', 1)->first();

                          if (!empty($findIsSecondInning)) {

                            $findTeamId_batting = DB::table('teams')->where('team_key', $secondInningBattingTeam_key)->first();

                            $findPlayerExist_db_batting = DB::table('players')->where('player_key', $pact_name)->where('team', $findTeamId_batting->id)->first();

                            if (!empty($findPlayerExist_db_batting)) {
                              $findplayerex = DB::table('result_matches')->where('player_key', $pact_name)->where('match_key', $match_key . "_2")->where('innings', $keyin)->select('*')->first();
                              $datasv['match_key'] = $match_key . "_2";
                              if (!empty($findplayerex)) {
                                DB::table('result_matches')->where('id', $findplayerex->id)->update([
                                  'match_key' => $match_key . "_2",
                                  'player_key' => $pact_name,
                                  'player_id' => $pid,
                                  'innings' => $keyin,
                                  'starting11' => $datasv['starting11'],
                                  'batting' => $datasv['batting'],
                                  'strike_rate' => isset($datasv['strike_rate']) ? $datasv['strike_rate'] : '',
                                  'battingdots' => isset($datasv['battingdots']) ? $datasv['battingdots'] : '',
                                  'six' => isset($datasv['six']) ? $datasv['six'] : '',
                                  'runs' => isset($datasv['runs']) ? $datasv['runs'] : '',
                                  'fours' => isset($datasv['fours']) ? $datasv['fours'] : '',
                                  'bball' => isset($datasv['bball']) ? $datasv['bball'] : '',
                                  'duck' => isset($datasv['duck']) ? $datasv['duck'] : '',
                                  'out_str' => isset($datasv['out_str']) ? $datasv['out_str'] : ''
                                ]);
                              } else {
                                DB::table('result_matches')->insert([
                                  'match_key' => $match_key . "_2",
                                  'player_key' => $pact_name,
                                  'player_id' => $pid,
                                  'innings' => $keyin,
                                  'starting11' => $datasv['starting11'],
                                  'batting' => $datasv['batting'],
                                  'strike_rate' => isset($datasv['strike_rate']) ? $datasv['strike_rate'] : '',
                                  'battingdots' => isset($datasv['battingdots']) ? $datasv['battingdots'] : '',
                                  'six' => isset($datasv['six']) ? $datasv['six'] : '',
                                  'runs' => isset($datasv['runs']) ? $datasv['runs'] : '',
                                  'fours' => isset($datasv['fours']) ? $datasv['fours'] : '',
                                  'bball' => isset($datasv['bball']) ? $datasv['bball'] : '',
                                  'duck' => isset($datasv['duck']) ? $datasv['duck'] : '',
                                  'out_str' => isset($datasv['out_str']) ? $datasv['out_str'] : ''
                                ]);
                              }
                            }

                            $findTeamId_bowling = DB::table('teams')->where('team_key', $secondInningBowlingTeam_key)->first();

                            $findPlayerExist_db_bowling = DB::table('players')->where('player_key', $pact_name)->where('team', $findTeamId_bowling->id)->first();

                            if (!empty($findPlayerExist_db_bowling)) {

                              $findplayerex = DB::table('result_matches')->where('player_key', $pact_name)->where('match_key', $match_key . "_2")->where('innings', $keyin)->select('*')->first();
                              $datasv['match_key'] = $match_key . "_2";
                              if (!empty($findplayerex)) {
                                DB::table('result_matches')->where('id', $findplayerex->id)->update([
                                  'match_key' => $match_key . "_2",
                                  'player_key' => $pact_name,
                                  'player_id' => $pid,
                                  'innings' => $keyin,
                                  'starting11' => $datasv['starting11'],
                                  'catch' => isset($datasv['catch']) ? $datasv['catch'] : '',
                                  'stumbed' => isset($datasv['stumbed']) ? $datasv['stumbed'] : '',
                                  'bowling' => isset($datasv['bowling']) ? $datasv['bowling'] : '',
                                  'economy_rate' => isset($datasv['economy_rate']) ? $datasv['economy_rate'] : '',
                                  'grun' => isset($datasv['grun']) ? $datasv['grun'] : '',
                                  'balldots' => isset($datasv['balldots']) ? $datasv['balldots'] : '',
                                  'balls' => isset($datasv['balls']) ? $datasv['balls'] : '',
                                  'maiden_over' => isset($datasv['maiden_over']) ? $datasv['maiden_over'] : '',
                                  'wicket' => isset($datasv['wicket']) ? $datasv['wicket'] : '',
                                  'extra' => isset($datasv['extra']) ? $datasv['extra'] : '',
                                  'overs' => isset($datasv['overs']) ? $datasv['overs'] : '',
                                ]);
                              } else {
                                DB::table('result_matches')->insert([
                                  'match_key' => $match_key . "_2",
                                  'player_key' => $pact_name,
                                  'player_id' => $pid,
                                  'innings' => $keyin,
                                  'starting11' => $datasv['starting11'],
                                  'catch' => isset($datasv['catch']) ? $datasv['catch'] : '',
                                  'stumbed' => isset($datasv['stumbed']) ? $datasv['stumbed'] : '',
                                  'bowling' => isset($datasv['bowling']) ? $datasv['bowling'] : '',
                                  'economy_rate' => isset($datasv['economy_rate']) ? $datasv['economy_rate'] : '',
                                  'grun' => isset($datasv['grun']) ? $datasv['grun'] : '',
                                  'balldots' => isset($datasv['balldots']) ? $datasv['balldots'] : '',
                                  'balls' => isset($datasv['balls']) ? $datasv['balls'] : '',
                                  'maiden_over' => isset($datasv['maiden_over']) ? $datasv['maiden_over'] : '',
                                  'wicket' => isset($datasv['wicket']) ? $datasv['wicket'] : '',
                                  'extra' => isset($datasv['extra']) ? $datasv['extra'] : '',
                                  'overs' => isset($datasv['overs']) ? $datasv['overs'] : '',
                                ]);
                              }
                            }
                          }



                          if (!empty($hitterarray)) { //print_r($hitterarray);
                            foreach ($hitterarray as $hr) {
                              $dplay = array();
                              $dplay['match_key'] = $match_key;
                              $explodarr = explode('$$$$', $hr);
                              $dplay['player_key'] = $explodarr[0];
                              $dplay['innings'] = $explodarr[1];

                              $findplayenewentry = DB::table('result_matches')->where('player_key', $dplay['player_key'])->where('match_key', $match_key)->where('innings', $dplay['innings'])->select('id', 'runout_catcher')->first();
                              if (!empty($findplayenewentry)) {
                                $dplay['runout_catcher'] = $findplayenewentry->runout_catcher + 1;
                                DB::table('result_matches')->where('id', $findplayenewentry->id)->update($dplay);
                              }

                              $findIsSecondInning = DB::table('listmatches')->where('matchkey', $match_key)->where('second_inning_allow', 1)->first();
                              if (!empty($findIsSecondInning)) {
                                $findTeamId_bowling = DB::table('teams')->where('team_key', $secondInningBowlingTeam_key)->first();
                                $findPlayerExist_db_bowling = DB::table('players')->where('player_key', $dplay['player_key'])->where('team', $findTeamId_bowling->id)->first();
                                if (!empty($findPlayerExist_db_bowling)) {
                                  $dplay['match_key'] = $match_key . "_2";
                                  $findplayenewentry = DB::table('result_matches')->where('player_key', $dplay['player_key'])->where('match_key', $match_key . "_2")->where('innings', $dplay['innings'])->select('id', 'runout_catcher')->first();
                                  if (!empty($findplayenewentry)) {
                                    $dplay['runout_catcher'] = $findplayenewentry->runout_catcher + 1;
                                    DB::table('result_matches')->where('id', $findplayenewentry->id)->update($dplay);
                                  }
                                }
                              }
                            }
                          }

                          if (!empty($throwerarray)) { //print_r($throwerarray);
                            foreach ($throwerarray as $hr) {
                              $dplay = array();
                              $dplay['match_key'] = $match_key;
                              $explodarr = explode('$$$$', $hr);
                              $dplay['player_key'] = $explodarr[0];
                              $dplay['innings'] = $explodarr[1];
                              // print_r($dplay); exit;
                              $findplayenewentry = DB::table('result_matches')->where('player_key', $dplay['player_key'])->where('match_key', $match_key)->where('innings', $dplay['innings'])->select('id', 'runout_thrower')->first();
                              // print_r($findplayenewentry); exit;
                              if (!empty($findplayenewentry)) {
                                $dplay['runout_thrower'] = $findplayenewentry->runout_thrower + 1;
                                DB::table('result_matches')->where('id', $findplayenewentry->id)->update($dplay);
                              }

                              $findIsSecondInning = DB::table('listmatches')->where('matchkey', $match_key)->where('second_inning_allow', 1)->first();
                              if (!empty($findIsSecondInning)) {
                                $findTeamId_bowling = DB::table('teams')->where('team_key', $secondInningBowlingTeam_key)->first();
                                $findPlayerExist_db_bowling = DB::table('players')->where('player_key', $dplay['player_key'])->where('team', $findTeamId_bowling->id)->first();
                                if (!empty($findPlayerExist_db_bowling)) {
                                  $dplay['match_key'] = $match_key . "_2";
                                  $findplayenewentry = DB::table('result_matches')->where('player_key', $dplay['player_key'])->where('match_key', $match_key . "_2")->where('innings', $dplay['innings'])->select('id', 'runout_thrower')->first();
                                  if (!empty($findplayenewentry)) {
                                    $dplay['runout_thrower'] = $findplayenewentry->runout_thrower + 1;
                                    DB::table('result_matches')->where('id', $findplayenewentry->id)->update($dplay);
                                  }
                                }
                              }
                            }
                          }

                          if (!empty($runout_direct_hit)) {
                            foreach ($runout_direct_hit as $hr) {
                              $dplay = array();
                              $dplay['match_key'] = $match_key;
                              $explodarr = explode('$$$$', $hr);
                              $dplay['player_key'] = $explodarr[0];
                              $dplay['innings'] = $explodarr[1];
                              $findplayenewentry = DB::table('result_matches')->where('player_key', $dplay['player_key'])->where('match_key', $match_key)->where('innings', $dplay['innings'])->select('id', 'runouts')->first();
                              if (!empty($findplayenewentry)) {
                                $dplay['runouts'] = $findplayenewentry->runouts + 1;
                                DB::table('result_matches')->where('id', $findplayenewentry->id)->update($dplay);
                              }


                              $findIsSecondInning = DB::table('listmatches')->where('matchkey', $match_key)->where('second_inning_allow', 1)->first();
                              if (!empty($findIsSecondInning)) {
                                $findTeamId_bowling = DB::table('teams')->where('team_key', $secondInningBowlingTeam_key)->first();
                                $findPlayerExist_db_bowling = DB::table('players')->where('player_key', $dplay['player_key'])->where('team', $findTeamId_bowling->id)->first();
                                if (!empty($findPlayerExist_db_bowling)) {
                                  $dplay['match_key'] = $match_key . "_2";
                                  $findplayenewentry = DB::table('result_matches')->where('player_key', $dplay['player_key'])->where('match_key', $match_key . "_2")->where('innings', $dplay['innings'])->select('id', 'runouts')->first();
                                  if (!empty($findplayenewentry)) {
                                    $dplay['runouts'] = $findplayenewentry->runouts + 1;
                                    DB::table('result_matches')->where('id', $findplayenewentry->id)->update($dplay);
                                  }
                                }
                              }
                            }
                          }

                          $k++;
                        }
                      }
                    }
                  }
                } //exit;

                if (!empty($lbwarray)) {
                  // print_r($lbwarray);exit;
                  foreach ($lbwarray as $lbwr) {
                    $dplay = array();
                    $dplay['match_key'] = $match_key;
                    $explodarr = explode('$$$$', $lbwr);
                    $dplay['player_key'] = $explodarr[0];
                    $dplay['innings'] = $explodarr[1];

                    $findplayenewentry = DB::table('result_matches')->where('player_key', $dplay['player_key'])->where('match_key', $match_key)->where('innings', $dplay['innings'])->select('id', 'lbw_bowled')->first();
                    if (!empty($findplayenewentry)) {
                      $dplay['lbw_bowled'] = $findplayenewentry->lbw_bowled + 1;
                      DB::table('result_matches')->where('id', $findplayenewentry->id)->update($dplay);
                    }

                    $findIsSecondInning = DB::table('listmatches')->where('matchkey', $match_key)->where('second_inning_allow', 1)->first();
                    if (!empty($findIsSecondInning)) {
                      $findTeamId_bowling = DB::table('teams')->where('team_key', $secondInningBowlingTeam_key)->first();
                      $findPlayerExist_db_bowling = DB::table('players')->where('player_key', $dplay['player_key'])->where('team', $findTeamId_bowling->id)->first();
                      if (!empty($findPlayerExist_db_bowling)) {
                        $dplay['match_key'] = $match_key . "_2";
                        $findplayenewentry = DB::table('result_matches')->where('player_key', $dplay['player_key'])->where('match_key', $match_key . "_2")->where('innings', $dplay['innings'])->select('id', 'lbw_bowled')->first();
                        if (!empty($findplayenewentry)) {
                          $dplay['lbw_bowled'] = $findplayenewentry->lbw_bowled + 1;
                          DB::table('result_matches')->where('id', $findplayenewentry->id)->update($dplay);
                        }
                      }
                    }
                  }
                }

                $refunded = MatchesController::refund_amount($match_key);
                $showpoints = MatchesController::player_point($match_key, $findmatchtype->format);
                //MatchesController::clash_refund($match_key , 1);


                $findIsSecondInning = DB::table('listmatches')->where('matchkey', $match_key)->where('second_inning_allow', 1)->first();
                if (!empty($findIsSecondInning)) {
                  $showpoints = MatchesController::player_point($match_key . "_2", $findmatchtype->format);
                  // $refunded = MatchesController::refund_amount($match_key."_2");
                }
              }
            }
          }
          return 1;
        }
        break;
    }

    return 1;
  }


  public function entityScoreUpdate($match_key, $sport_type = 1)
  {
    date_default_timezone_set('Asia/Kolkata');
    // echo $match_key; exit;
    $sport_type = 1;
    $listmatches = DB::table('listmatches')
      ->where('matchkey', $match_key)
      ->where('sport_type', $sport_type)
      ->where('final_status', '!=', 'winnerdeclared')
      ->where('final_status', '!=', 'IsCanceled')
      ->where('status', '=', 'started')
      ->where('flexible_breakup_set', 0)
      ->first();
    // dd($listmatches);
    $getcurrentdate = date('Y-m-d H:i:s');
    if (!empty($listmatches)) {
      $matchtimings = @$listmatches->start_date;
      // echo $getcurrentdate .'<'. $matchtimings; exit;
      if ($getcurrentdate < $matchtimings) {
        echo "not live";
        exit;
        return true;
      } else {
        $flaxuble = MatchesController::set_flexy_league_automatic($match_key, '1');
      }
    }
    // else{
    //   echo "not live"; exit;
    // }

    $findmatchtype = DB::table('listmatches')->where('matchkey', $match_key)->where('sport_type', 1)->select('format', 'second_inning', 'short_name')->first();


    if ($findmatchtype->second_inning == 1) {
      return;
    }
    $findmatchtype = DB::table('listmatches')->where('matchkey', $match_key)
      ->where('sport_type', $sport_type)
      ->where('final_status', '!=', 'winnerdeclared')
      ->select('format', 'sport_type', 'short_name')->first();
    if (empty($findmatchtype)) {
      return Redirect::back();
    }
    $match_detail = $giveresresult = Cricketapi2Controller::get_match_details($match_key);
    // echo "<pre>"; print_r($match_detail); exit;
    if (empty($match_detail) || !isset($giveresresult->teama)) {
      return true;
    }


    $inningNumber = 0;
    if (!empty($giveresresult->innings)) {
      $inningNumber = count($giveresresult->innings);
    }


    $checkpre = DB::table('matchruns')
      ->where('matchkey', $match_key)
      ->where('sport_type', $sport_type)
      ->where('inning', $inningNumber)
      ->first();

    if (empty($checkpre)) {

      $matchdata['matchkey'] = $match_key;
      $matchdata['sport_type'] = $sport_type;
      $matchdata['teams1'] = $giveresresult->teama->short_name;
      $matchdata['teams2'] = $giveresresult->teamb->short_name;
      if (!empty($giveresresult->status == 2)) {
        $matchdata['winning_status'] = $giveresresult->status_note;
      } else {
        $matchdata['winning_status'] = 0;
      }
      if (!empty($giveresresult->innings)) {
        $gettestscore1 = 0;
        $gettestscore2 = 0;
        $gettestwicket1 = 0;
        $gettestwicket2 = 0;
        $gettestover1 = 0;
        $gettestover2 = 0;
        if (!empty($giveresresult->innings)) {
          $runs_wick_0 = explode('/', @$giveresresult->innings['0']->scores);
          $runs_wick_1 = explode('/', @$giveresresult->innings['1']->scores);

          $gettestscore2 = @$runs_wick_1[0];
          $gettestscore1 = @$runs_wick_0[0];
          $gettestwicket1 = @$runs_wick_0[1];
          $gettestwicket2 = @$runs_wick_1[1];
          $gettestover1 = 0;
          $gettestover2 = 0;

          $matchdata['wickets1'] = $gettestwicket1;
          $matchdata['wickets2'] = $gettestwicket2 ? $gettestwicket2 : 0;
          $matchdata['overs1'] = $gettestover1;
          $matchdata['overs1'] = '';
          $matchdata['overs2'] = $gettestover2 ? $gettestover2 : 0;
          $matchdata['overs2'] = '';
          $matchdata['runs1'] = $gettestscore1;
          $matchdata['runs2'] = $gettestscore2 ? $gettestscore2 : 0;
          $matchdata['inning'] = $inningNumber;
          // print_r($matchdata); exit;
        }
      } else {
        $matchdata['winning_status'] = 0;
        $matchdata['wickets1'] = 0;
        $matchdata['wickets2'] = 0;
        $matchdata['overs1'] = 0;
        $matchdata['overs2'] = 0;
        $matchdata['runs1'] = 0;
        $matchdata['runs2'] = 0;
        $matchdata['inning'] = 0;
      }

      //  DB::table('matchruns')->insert($matchdata);

      $matchruns_exists = DB::table("matchruns")->where("matchkey", $match_key)
        ->where("sport_type", $sport_type)->where('inning', $inningNumber)->exists();
      if ($matchruns_exists) {
        DB::table('matchruns')->where("matchkey", $match_key)->where("sport_type", $sport_type)->update($matchdata);
      } else {
        DB::table('matchruns')->insert($matchdata);
      }
    } else {
      $matchdata1['matchkey'] = $match_key;
      $matchdata1['sport_type'] = $sport_type;
      $matchdata1['teams1'] = $giveresresult->teama->short_name;
      $matchdata1['teams2'] = $giveresresult->teamb->short_name;
      if (!empty($giveresresult->status == 2)) {
        $matchdata1['winning_status'] = $giveresresult->status_note;
      } else {
        $matchdata1['winning_status'] = 0;
      }
      if (!empty($giveresresult->innings)) {
        $gettestscore1 = 0;
        $gettestscore2 = 0;
        $gettestwicket1 = 0;
        $gettestwicket2 = 0;
        $gettestover1 = 0;
        $gettestover2 = 0;
        if (!empty($giveresresult->innings['0'])) {
          if ($match_key == 45149) {

            // print_r($giveresresult->innings['0']); die;
          }
          $runs_wick_0 = explode('/', @$giveresresult->teama->scores);
          $runs_wick_1 = explode('/', @$giveresresult->teamb->scores);

          $overs1 = explode('(', $giveresresult->teama->scores_full);
          $overs1 = explode(')', @$overs1[1]);
          $overs1 = @$overs1[0];

          $overs2 = explode('(', @$giveresresult->teamb->scores_full);
          $overs2 = explode(')', @$overs2[1]);
          $overs2 = @$overs2[0];

          $gettestscore2 = $runs_wick_1[0] ? $runs_wick_1[0] : 0;
          $gettestscore1 = $runs_wick_0[0] ?? 0;
          $gettestwicket1 = $runs_wick_0[1] ?? 0;
          $gettestwicket2 = $runs_wick_1[1] ?? 0;
          $gettestover1 = (float)$overs1 ?? 0;
          $gettestover2 = (float)$overs2 ?? 0;

          $matchdata1['wickets1'] = $gettestwicket1;
          $matchdata1['wickets2'] = $gettestwicket2;
          $matchdata1['overs1'] = $gettestover1;
          $matchdata1['overs2'] = $gettestover2;
          $matchdata1['runs1'] = $gettestscore1;
          $matchdata1['runs2'] = $gettestscore2;
          $matchdata1['inning'] = $inningNumber;
        }
      } else {
        $matchdata1['wickets1'] = 0;
        $matchdata1['wickets2'] = 0;
        $matchdata1['overs1'] = 0;
        $matchdata1['overs2'] = 0;
        $matchdata1['runs1'] = 0;
        $matchdata1['runs2'] = 0;
        $matchdata1['inning'] = 0;
      }

      $matchruns_exists = DB::table("matchruns")->where("matchkey", $match_key)
        ->where("sport_type", $sport_type)->where('inning', $inningNumber)->exists();
      if ($matchruns_exists) {
        DB::table('matchruns')->where("matchkey", $match_key)->where("sport_type", $sport_type)->update($matchdata1);
      } else {
        DB::table('matchruns')->insert($matchdata1);
      }
    }

    if (!empty($match_detail)) {
      $getmtdatastatus = array();
      $match_status = $match_detail->status;
      //  dd($match_status);
      // 1 = scheduled , 2 = completed, 3 = Live , 4 = canceled
      if ($match_status == 2 && $match_detail->verified == 'true') {
        $getmtdatastatus['status'] = 'completed';
        $getmtdatastatus['is_verified'] = 1;
      }
      if ($match_status == 3) {
        $getmtdatastatus['status'] = 'started';
      }
      if ($match_status == 4) {
        $getmtdatastatus['status'] = 'canceled';
        // $getmtdatastatus['final_status'] = 'IsCanceled';
        // $image = "";
        // $titleget = @$findmatchtype->short_name;
        // $msg ='This match is IsAbandoned';
        // $userdata=array(1,3,4873,10,4,17925);
        // foreach($userdata as $userid){
        // 	Helpers::sendnotification($titleget,$msg,$image,$userid);
        // }
      }
      if (@$getmtdatastatus['status'] == 'completed') {
        $getmtdatastatus['final_status'] = 'IsReviewed';
        //   $image = "";
        //  $titleget = @$findmatchtype->short_name;
        // $msg ='This match IsReviewed please winner declared';
        // $userdata=array(1,3,4873,10,4,17925);
        //  foreach($userdata as $userid){
        //  	Helpers::sendnotification($titleget,$msg,$image,$userid);
        //  }

        //echo $titleget.' === '.$msg.' ==== '.$image.' === '.$user->id.' <br>';

      }
      if (!empty(@$getmtdatastatus['status']) || !is_null(@$getmtdatastatus['status'])) {
        DB::table('listmatches')->where('matchkey', $match_key)->where('sport_type', $sport_type)->update($getmtdatastatus);
        $findIsSecondInning = DB::table('listmatches')->where('matchkey', $match_key)->where('second_inning_allow', 1)->first();

        if (!empty($findIsSecondInning)) {
          //  DB::table('listmatches')->where('matchkey', $match_key.'_2')->where('sport_type',1)->update($getmtdatastatus);

          $currentTime = date('Y-m-d H:i:s');
          $findIsSecondInning = DB::table('listmatches')
            ->where('matchkey', "=", $match_key . '_2')
            ->where('start_date', '<=', $currentTime)
            ->first();
          if (!empty($findIsSecondInning)) {
            DB::table('listmatches')->where('matchkey', $match_key . '_2')->where('sport_type', 1)->update($getmtdatastatus);
          }
        }
      }

      $finalplayingteams = 0;
      $matchplayer = DB::table('match_playing11')->where('match_key', $match_key)->first();
      if (empty($matchplayer)) {
        $finalresultplayer = Cricketapi2Controller::get_match_playing_players($match_key);
        $finalplayingteams  = @$finalresultplayer['lineup_player'];
      } else {
        $playerarrdata = unserialize(@DB::table('match_playing11')->where('match_key', $match_key)->first()->player_ids);

        if (!empty($playerarrdata)) {
          $playerarr = $playerarrdata;
          $finalplayingteams =  DB::table('matchplayers')
            ->where('matchkey', $match_key)
            ->whereIn('matchplayers.playerid', $playerarr)
            ->select('matchplayers.player_key')
            ->groupBy('matchplayers.playerid')->pluck('player_key');
          // print_r($finalplayingteams);exit;
        }
      }

      // $finalplayingteams=0;
      //    $finalresultplayer = Cricketapi2Controller::get_match_playing_players($match_key);
      //    $finalplayingteams  = @$finalresultplayer['lineup_player'];



      // if (count($finalplayingteams) >= 15) {
      if (!empty($finalplayingteams) && count($finalplayingteams) >= 15) {
        DB::table('result_matches')->where('match_key', $match_key)->where('sport_type', $sport_type)->delete();
        $findIsSecondInning = DB::table('listmatches')->where('matchkey', $match_key)->where('second_inning_allow', 1)->first();

        if (!empty($findIsSecondInning)) {
          DB::table('result_matches')->where('match_key', $match_key . '_2')->where('sport_type', 1)->delete();
        }

        foreach ($finalplayingteams as $playing_player) {

          $datasv = array();

          $player_id = $playing_player;

          $datasv['player_key'] = $player_id;

          $datasv['starting11'] = 1;

          $datasv['match_key'] = $match_key;
          $inningNumber = 0;
          if (!empty($giveresresult->innings)) {
            $inningNumber = count($giveresresult->innings);
          }

          // $datasv['innings'] = !empty($inningNumber)? $inningNumber: 1;
          $datasv['innings'] = 1;
          $player = DB::table('matchplayers')->join('players', 'players.id', '=', 'matchplayers.playerid')->where('matchkey', $match_key)->select('matchplayers.*', 'players.player_key', 'players.role as playerrole')->where('players.player_key', $player_id)->first();
          if (!empty($player)) {
            $datasv['player_id'] = $player->playerid;
            $findplayerex = DB::table('result_matches')->where('player_key', $player_id)->where('match_key', $match_key)->where('innings', 1)->select('id')->first();
            if (empty($findplayerex)) {
              try {
                DB::table('result_matches')->insert($datasv);
              } catch (\Illuminate\Database\QueryException $ex) {
                dd($ex->getMessage());
              }
            }

            $findIsSecondInning = DB::table('listmatches')->where('matchkey', $match_key)->where('second_inning_allow', 1)->first();

            if (!empty($findIsSecondInning)) {

              $findplayerex = DB::table('result_matches')->where('player_key', $player_id)
                ->where('match_key', $match_key . '_2')
                ->where('innings', 1)->select('id')->first();

              // print_r($datasv);
              if (empty($findplayerex)) {

                $datasv['match_key'] = $match_key . '_2';
                try {

                  DB::table('result_matches')->insert($datasv);
                } catch (\Illuminate\Database\QueryException $ex) {

                  dd($ex->getMessage());

                  // Note any method of class PDOException can be called on $ex.

                }
              }
            }
          }
        }

        //exit;


        $innings = @$match_detail->innings;
        if (!empty($innings)) {
          foreach ($innings as $key => $value) {
            if ($value->issuperover == "true") {
              // echo ":hi";exit;
              continue;
            }
            $inning_number = $value->number;
            $inning_number_new = $value->number;

            if ($inning_number == 1 || $inning_number == 2) {

              $inning_number = 1;
            } else if ($inning_number == 3 || $inning_number == 4) {

              $inning_number = 2;
            }

            $batsmen = $value->batsmen;

            foreach ($batsmen as $key2 => $value2) {

              $datasv = array();

              $player_id = $value2->batsman_id;

              $player = DB::table('matchplayers')->join('players', 'players.id', '=', 'matchplayers.playerid')->where('matchkey', $match_key)->select('matchplayers.*', 'players.player_key', 'matchplayers.role as playerrole')->where('players.player_key', $player_id)->first();

              if (!empty($player)) {
                $catch = 0;
                $runouts = 0;
                $stumbed = 0;
                $batdots = 0;
                $balldots = 0;
                $six = 0;
                $runs = 0;
                $fours = 0;
                $miletone_run = 0;
                $bball = 0;

                $strike = 0;
                $acstrike = 0;
                $grun = 0;
                $balls = 0;
                $bballs = 0;
                $maiden_over = 0;
                $wicket = 0;
                $extra = 0;
                $overs = 0;

                $economy = 0;
                $duck = 0;
                $mile_wicket = 0;


                $datasv['runs'] = $runs = (int)$runs + (int)$value2->runs;

                $datasv['bball'] = $bball = (int)$bball + (int)$value2->balls_faced;

                $datasv['fours'] = $fours = (int)$fours + (int)$value2->fours;

                $datasv['six'] = $six = (int)$six + (int)$value2->sixes;

                $datasv['batting'] = 1;

                $datasv['strike_rate'] = $value2->strike_rate;

                if ($value2->how_out != 'Not out') {

                  if ($runs == 0 && $player->playerrole != 'bowler' && !empty($value2->dismissal)) {

                    $datasv['duck'] = $duck = 1;
                    if ($player->playerid == 2334 && $match_key == "63104") {
                      $datasv['duck'] = $duck = 0;
                    }
                  } else {

                    $datasv['duck'] = $duck = 0;
                  }

                  $datasv['out_str'] = $value2->how_out;
                }

                $datasv['match_key'] = $match_key;

                $datasv['player_key'] = $player_id;

                $datasv['player_id'] = $player->playerid;

                $datasv['innings'] = $inning_number;

                $datasv['starting11'] = 1;


                /*if($player_id==46824) {

              print_r($datasv); exit;
            }*/
                // echo "<pre>";
                //  print_r($datasv);
                $findplayerex = DB::table('result_matches')->where('player_key', $player_id)->where('match_key', $match_key)->where('innings', $inning_number)->select('id')->first();

                if (!empty($findplayerex)) {
                  DB::table('result_matches')->where('id', $findplayerex->id)->update($datasv);
                } else {
                  DB::table('result_matches')->insert($datasv);
                }

                if ($inning_number_new == 2) {
                  $findIsSecondInning = DB::table('listmatches')->where('matchkey', $match_key)->where('second_inning_allow', 1)->first();

                  if (!empty($findIsSecondInning)) {

                    $findplayerex = DB::table('result_matches')->where('player_key', $player_id)
                      ->where('match_key', $match_key . '_2')
                      ->where('innings', $inning_number)->select('id')->first();

                    if (!empty($findplayerex)) {
                      $datasv['match_key'] = $match_key . '_2';
                      DB::table('result_matches')->where('id', $findplayerex->id)->update($datasv);
                    } else {
                      $datasv['match_key'] = $match_key . '_2';
                      DB::table('result_matches')->insert($datasv);
                    }
                  }
                }
              }
            }

            $bowlers = $value->bowlers;
            foreach ($bowlers as $key2 => $value2) {
              // if(!$value2->is_substitute) {
              $datasv = array();

              $catch = 0;
              $runouts = 0;
              $stumbed = 0;
              $batdots = 0;
              $balldots = 0;
              $six = 0;
              $runs = 0;
              $fours = 0;
              $miletone_run = 0;
              $bball = 0;

              $strike = 0;
              $acstrike = 0;
              $grun = 0;
              $balls = 0;
              $bballs = 0;
              $maiden_over = 0;
              $wicket = 0;
              $extra = 0;
              $overs = 0;

              $economy = 0;
              $duck = 0;
              $mile_wicket = 0;
              $lbwBowled = 0;
              $player_id = $value2->bowler_id;

              $player = DB::table('matchplayers')->join('players', 'players.id', '=', 'matchplayers.playerid')->where('matchkey', $match_key)->select('matchplayers.*', 'players.player_key', 'players.role as playerrole')->where('players.player_key', $player_id)->first();


              if (!empty($player)) {


                $datasv['balls'] = $balls = $balls + (round((int)$value2->overs) * 6);

                $datasv['maiden_over'] = $maiden_over = (int)$maiden_over + (int)$value2->maidens;

                $datasv['wicket'] = $wicket = (int)$wicket + (int)$value2->wickets;

                $datasv['extra'] = $extra = $extra + (int)$value2->noballs + (int)$value2->wides;

                $datasv['overs'] = $overs = $overs + $value2->overs;

                $datasv['grun'] = $grun = (int)$grun + (int)$value2->runs_conceded;
                $datasv['lbw_bowled'] = $lbwBowled = (int)$lbwBowled + ((int)$value2->lbwcount + $value2->bowledcount);
                $datasv['balldots'] = $balldots = (int)$balldots + (int)$value2->run0;

                $datasv['bowling'] = 1;

                $datasv['economy_rate'] = $value2->econ;


                $datasv['match_key'] = $match_key;

                $datasv['player_key'] = $player_id;

                $datasv['player_id'] = $player->playerid;

                $datasv['innings'] = $inning_number;

                $datasv['starting11'] = 1;


                $findplayerex = DB::table('result_matches')->where('player_key', $player_id)->where('match_key', $match_key)->where('innings', $inning_number)->select('id')->first();


                if (!empty($findplayerex)) {

                  DB::table('result_matches')->where('id', $findplayerex->id)->update($datasv);
                } else {

                  DB::table('result_matches')->insert($datasv);
                }

                if ($inning_number_new == 2) {
                  $findIsSecondInning = DB::table('listmatches')->where('matchkey', $match_key)->where('second_inning_allow', 1)->first();

                  if (!empty($findIsSecondInning)) {
                    $findplayerex = DB::table('result_matches')->where('player_key', $player_id)
                      ->where('match_key', $match_key . '_2')
                      ->where('innings', $inning_number)->select('id')->first();

                    if (!empty($findplayerex)) {
                      $datasv['match_key'] = $match_key . '_2';
                      DB::table('result_matches')->where('id', $findplayerex->id)->update($datasv);
                    } else {
                      $datasv['match_key'] = $match_key . '_2';
                      DB::table('result_matches')->insert($datasv);
                    }
                  }
                }
              }
              // }
            }

            $fielders = $value->fielder;
            // print_r($fielders); exit;
            foreach ($fielders as $key2 => $value2) {
              /*if($value2->fielder_id==43619) {
          print_r($value2); exit;
        }*/
              if ($value2->is_substitute == 'false') {
                // print_r($value2); exit;
                $datasv = array();

                $catch = 0;
                $runouts = 0;
                $stumbed = 0;
                $batdots = 0;
                $balldots = 0;
                $six = 0;
                $runs = 0;
                $fours = 0;
                $miletone_run = 0;
                $bball = 0;

                $strike = 0;
                $acstrike = 0;
                $grun = 0;
                $balls = 0;
                $bballs = 0;
                $maiden_over = 0;
                $wicket = 0;
                $extra = 0;
                $overs = 0;

                $economy = 0;
                $duck = 0;
                $mile_wicket = 0;

                $player_id = $value2->fielder_id;

                $player = DB::table('matchplayers')->join('players', 'players.id', '=', 'matchplayers.playerid')->where('matchkey', $match_key)->select('matchplayers.*', 'players.player_key', 'players.role as playerrole')->where('players.player_key', $player_id)->first();
                /*if($value2->fielder_id==43619) {
          print_r($player); exit;
        }*/
                if (!empty($player)) {

                  $datasv['catch'] = $catch = $catch + $value2->catches;

                  $datasv['stumbed'] = $stumbed = $stumbed + $value2->stumping;

                  $datasv['runouts'] = $runouts = $runouts + $value2->runout_direct_hit;

                  $thrower = $value2->runout_thrower;
                  $hitter = $value2->runout_catcher;

                  $datasv['runout_catcher'] = $hitter;
                  $datasv['runout_thrower'] = $thrower;

                  $datasv['match_key'] = $match_key;

                  $datasv['player_key'] = $player_id;

                  $datasv['player_id'] = $player->playerid;

                  $datasv['innings'] = $inning_number;

                  $datasv['starting11'] = 1;

                  $findplayerex = DB::table('result_matches')->where('player_key', $player_id)->where('match_key', $match_key)->where('innings', $inning_number)->select('id')->first();

                  if (!empty($findplayerex)) {

                    DB::table('result_matches')->where('id', $findplayerex->id)->update($datasv);
                  } else {

                    DB::table('result_matches')->insert($datasv);
                  }

                  if ($inning_number_new == 2) {
                    $findIsSecondInning = DB::table('listmatches')->where('matchkey', $match_key)->where('second_inning_allow', 1)->first();

                    if (!empty($findIsSecondInning)) {

                      $findplayerex = DB::table('result_matches')->where('player_key', $player_id)
                        ->where('match_key', $match_key . '_2')
                        ->where('innings', $inning_number)->select('id')->first();

                      if (!empty($findplayerex)) {
                        $datasv['match_key'] = $match_key . '_2';
                        DB::table('result_matches')->where('id', $findplayerex->id)->update($datasv);
                      } else {
                        $datasv['match_key'] = $match_key . '_2';
                        DB::table('result_matches')->insert($datasv);
                      }
                    }
                  }
                }
              }
            }
          }
        }
        // die;


        $currentTime = date('Y-m-d H:i:s');
        $showpoints = MatchesController::player_point($match_key, $findmatchtype->format, "CRICKET");

        // $findIsSecondInning = DB::table('listmatches')->where('matchkey',$match_key)->where('second_inning_allow',1)->first();
        $findIsSecondInning = DB::table('listmatches')
          ->where('matchkey', "=", $match_key . '_2')
          ->where('start_date', '<=', $currentTime)
          ->first();


        //$refunded = MatchesController::refund_amount($match_key,1);
        // $refunded_new = MatchesController::clash_refund($match_key,1);
        if (!empty($findIsSecondInning)) {
          $flaxuble = MatchesController::set_flexy_league_automatic($match_key . '_2', '1');
          MatchesController::player_point($match_key . '_2', $findmatchtype->format, "CRICKET");

          $refunded = MatchesController::refund_amount($match_key . '_2', 1);
          $refunded_new = MatchesController::clash_refund($match_key . '_2', 1);
        }
      }
    }
    // echo 1; exit;
    //MatchesController::update_leaderboard($match_key,$sport_type);
    $refunded = MatchesController::refund_amount($match_key, '1');
    $refunded_clash = MatchesController::clash_refund($match_key, '1');
    //echo 'hello';exit;
  }

  //Update Leaderboard new function

  public function update_results_of_leaderboard()
  {
    date_default_timezone_set('Asia/Kolkata');  //echo date('Y-m-d H:i:s'); exit;
    // $findmatchexist = DB::table('listmatches')->where('matchkey','irepak_2018_test_01')->get();
    $findmatchexist = DB::table('listmatches')->whereDate('start_date', '<=', date('Y-m-d'))->where('launch_status', 'launched')
      ->where('final_status', '!=', 'winnerdeclared')->where('final_status', '!=', 'IsCanceled')->where('final_status', '!=', 'IsAbandoned')->where('status', '!=', 'completed')->where('sport_type', 1)->orderBy('id', 'DESC')
      //->where('listmatches.matchkey','65738')
      ->get();

    //dd($findmatchexist);
    if (!empty($findmatchexist)) {
      foreach ($findmatchexist as $val) {

        // $inningdata = DB :: table('result_matches')->where('match_key',$val->matchkey)
        //   ->where('sport_type',1)->orderby('innings','DESC')->select('innings')->first();
        $inningdata = DB::table('matchruns')->where('matchkey', $val->matchkey)
          ->where('sport_type', 1)->orderby('inning', 'DESC')->select('inning')->first();

        // if(!empty($inningdata)){
        //  $this->livescoreapi($val->matchkey);
        //  $this->livescoreapi_commentry($val->matchkey,$inningdata->inning);
        //  }


        if ($val->is_verified == 1) {
          continue;
        }
        $match_type = $val->format;
        $getcurrentdate = date('Y-m-d H:i:s');
        $matchtimings = $val->start_date;
        if ($getcurrentdate > $matchtimings) {
          $match_key = $val->matchkey;
          $this->getscoresupdatesleaderboard($match_key, '1');
        }
        if (date('Y-m-d H:i:s', strtotime('+40 minutes', strtotime($getcurrentdate))) > $matchtimings) { //echo 11; exit;
          $match_key = $val->matchkey;;
        }
      }
    }
    return 1;
  }

  public function getscoresupdatesleaderboard($match_key, $sport_type = 1)
  {
    date_default_timezone_set('Asia/Kolkata');
    // echo $match_key; exit;
    $sport_type = 1;
    $listmatches = DB::table('listmatches')
      ->where('matchkey', $match_key)
      ->where('sport_type', $sport_type)
      ->where('final_status', '!=', 'winnerdeclared')
      ->where('final_status', '!=', 'IsCanceled')
      ->where('status', '=', 'started')
      ->where('flexible_breakup_set', 0)
      ->first();
    // dd($listmatches);
    $getcurrentdate = date('Y-m-d H:i:s');
    if (!empty($listmatches)) {
      $matchtimings = @$listmatches->start_date;
      // echo $getcurrentdate .'<'. $matchtimings; exit;
      if ($getcurrentdate < $matchtimings) {
        echo "not live";
        exit;
        return true;
      } else {
        $flaxuble = MatchesController::set_flexy_league_automatic($match_key, '1');
      }
    }

    $findmatchtype = DB::table('listmatches')->where('matchkey', $match_key)->where('sport_type', 1)->select('format', 'second_inning')->first();


    if ($findmatchtype->second_inning == 1) {
      return;
    }
    $findmatchtype = DB::table('listmatches')->where('matchkey', $match_key)
      ->where('sport_type', $sport_type)
      ->where('final_status', '!=', 'winnerdeclared')
      ->select('format', 'sport_type')->first();
    if (empty($findmatchtype)) {
      return Redirect::back();
    }

    MatchesController::update_leaderboard($match_key, $sport_type);
  }


  public function entityScoreUpdate_old_f11($match_key, $sporttype = 1)
  {
    // dd('sdfas');
    $findmatchtype = DB::table('listmatches')->where('matchkey', $match_key)->where('sport_type', $sporttype)->select('format')->first();
    $match_detail = $giveresresult = Cricketapi2Controller::get_match_details($match_key);

    // print_r($match_detail);die;
    if (empty($match_detail) || !isset($giveresresult->teama)) {
      return true;
    }

    $checkpre = DB::table('matchruns')->where('matchkey', $match_key)->where('sport_type', 1)->first();
    // dd($checkpre);
    if (empty($checkpre)) {
      // var_dump($giveresresult);exit;
      $matchdata['matchkey'] = $match_key;
      $matchdata['teams1'] = $giveresresult->teama->short_name;
      $matchdata['teams2'] = $giveresresult->teamb->short_name;
      if (!empty($giveresresult->status == 2)) {
        $matchdata['winning_status'] = $giveresresult->status_note;
      } else {
        $matchdata['winning_status'] = 0;
      }
      if (!empty($giveresresult->innings)) {
        $gettestscore1 = 0;
        $gettestscore2 = 0;
        $gettestwicket1 = 0;
        $gettestwicket2 = 0;
        $gettestover1 = 0;
        $gettestover2 = 0;
        if (!empty($giveresresult->innings)) {
          $runs_wick_0 = explode('/', @$giveresresult->innings['0']->scores);
          $runs_wick_1 = explode('/', @$giveresresult->innings['1']->scores);

          $gettestscore2 = @$runs_wick_1[0];
          $gettestscore1 = @$runs_wick_0[0];
          $gettestwicket1 = @$runs_wick_0[1];
          $gettestwicket2 = @$runs_wick_1[1];
          $gettestover1 = $overs2 = @$giveresresult->teama->overs;
          $gettestover2 = $overs2 = @$giveresresult->teamb->overs;

          $matchdata['wickets1'] = $gettestwicket1;
          $matchdata['wickets2'] = $gettestwicket2 ? $gettestwicket2 : 0;
          $matchdata['overs1'] = $gettestover1;
          $matchdata['overs1'] = '';
          $matchdata['overs2'] = $gettestover2 ? $gettestover2 : 0;
          $matchdata['overs2'] = '';
          $matchdata['runs1'] = !empty($gettestscore1) ? $gettestscore1 : 0;
          $matchdata['runs2'] = $gettestscore2 ? $gettestscore2 : 0;
          // print_r($matchdata); exit;
        }
        /*if(empty($gettestwicket1)){
                                  $matchdata['wickets1'] = $giveresresult['data']['card']['innings']['a_1']['wickets'];
                             }else{
                                 $matchdata['wickets1'] = $giveresresult['data']['card']['innings']['a_1']['wickets'].','.$gettestwicket1;
                             }
                             if(empty($gettestwicket2)){
                                  $matchdata['wickets2'] = $giveresresult['data']['card']['innings']['b_1']['wickets'];
                             }else{
                                 $matchdata['wickets2'] = $giveresresult['data']['card']['innings']['b_1']['wickets'].','.$gettestwicket2;
                             }
                             if(empty($gettestover1)){
                                  $matchdata['overs1'] = $giveresresult['data']['card']['innings']['a_1']['overs'];
                             }else{
                                 $matchdata['overs1'] = $giveresresult['data']['card']['innings']['a_1']['overs'].','.$gettestover1;
                             }
                             if(empty($gettestover2)){
                                  $matchdata['overs2'] = $giveresresult['data']['card']['innings']['b_1']['overs'];
                             }else{
                                 $matchdata['overs2'] = $giveresresult['data']['card']['innings']['b_1']['overs'].','.$gettestover2;
                             }
                             if(empty($gettestscore1)){
                                  $matchdata['runs1'] = $giveresresult['data']['card']['innings']['a_1']['runs'];
                             }else{
                                 $matchdata['runs1'] = $giveresresult['data']['card']['innings']['a_1']['runs'].','.$gettestscore1;
                             }
                             if(empty($gettestscore2)){
                                  $matchdata['runs2'] = $giveresresult['data']['card']['innings']['b_1']['runs'];
                             }else{
                                 $matchdata['runs2'] = $giveresresult['data']['card']['innings']['b_1']['runs'].','.$gettestscore2;
                             }*/
      } else {
        $matchdata['winning_status'] = 0;
        $matchdata['wickets1'] = 0;
        $matchdata['wickets2'] = 0;
        $matchdata['overs1'] = 0;
        $matchdata['overs2'] = 0;
        $matchdata['runs1'] = 0;
        $matchdata['runs2'] = 0;
      }
      DB::table('matchruns')->insert($matchdata);
    } else {
      $matchdata1['matchkey'] = $match_key;
      $matchdata1['teams1'] = $giveresresult->teama->short_name;
      $matchdata1['teams2'] = $giveresresult->teamb->short_name;
      if (!empty($giveresresult->status == 2)) {
        $matchdata1['winning_status'] = $giveresresult->status_note;
      } else {
        $matchdata1['winning_status'] = 0;
      }
      if (!empty($giveresresult->innings)) {
        $gettestscore1 = 0;
        $gettestscore2 = 0;
        $gettestwicket1 = 0;
        $gettestwicket2 = 0;
        $gettestover1 = 0;
        $gettestover2 = 0;
        if (!empty($giveresresult->innings['0'])) {
          if ($match_key == 45149) {

            // print_r($giveresresult->innings['0']); die;
          }
          $runs_wick_0 = explode('/', @$giveresresult->teama->scores);
          $runs_wick_1 = explode('/', @$giveresresult->teamb->scores);

          $overs1 = explode('(', $giveresresult->teama->scores_full);
          $overs1 = explode(')', @$overs1[1]);
          //$overs1 = @$overs1[0];
          $overs1 = @$giveresresult->teama->overs;

          $overs2 = explode('(', @$giveresresult->teamb->scores_full);
          $overs2 = explode(')', @$overs2[1]);
          $overs2 = @$overs2[0];
          $overs2 = @$giveresresult->teamb->overs;

          $gettestscore2 = $runs_wick_1[0] ? $runs_wick_1[0] : 0;
          $gettestscore1 = $runs_wick_0[0] ?? 0;
          $gettestwicket1 = $runs_wick_0[1] ?? 0;
          $gettestwicket2 = $runs_wick_1[1] ?? 0;
          $gettestover1 = (float)$overs1 ?? 0;
          $gettestover2 = (float)$overs2 ?? 0;

          $matchdata1['wickets1'] = $gettestwicket1;
          $matchdata1['wickets2'] = $gettestwicket2;
          $matchdata1['overs1'] = $gettestover1;
          $matchdata1['overs2'] = $gettestover2;
          $matchdata1['runs1'] = !empty($gettestscore1) ? $gettestscore1 : 0;
          $matchdata1['runs2'] = $gettestscore2;

          if ($match_key == 44626) {

            // print_r($matchdata1); die;
          }
        }
      } else {
        $matchdata1['wickets1'] = 0;
        $matchdata1['wickets2'] = 0;
        $matchdata1['overs1'] = 0;
        $matchdata1['overs2'] = 0;
        $matchdata1['runs1'] = 0;
        $matchdata1['runs2'] = 0;
      }
      DB::table('matchruns')->where('matchkey', $match_key)->where('sport_type', 1)->update($matchdata1);
    }

    if (!empty($match_detail)) {
      $match_status = $match_detail->status; // 1 = scheduled , 2 = completed, 3 = Live , 4 = canceled
      if ($match_status == 2 && $match_detail->verified == 'true') {
        // $getmtdatastatus['status'] = 'completed';
        $getmtdatastatus['is_verified'] = 1;
      }
      if ($match_status == 3) {

        $getmtdatastatus['status'] = 'started';
      }

      // $getmtdatastatus['status'] = $mainarrayget['status'];

      if (@$getmtdatastatus['status'] == 'completed') {

        $getmtdatastatus['final_status'] = 'IsReviewed';
      }

      // print_r($getmtdatastatus); exit;
      if (!empty(@$getmtdatastatus['status']) || !is_null(@$getmtdatastatus['status'])) {


        DB::table('listmatches')->where('matchkey', $match_key)->where('sport_type', $sporttype)->update($getmtdatastatus);
      }

      $finalplayingteams = Cricketapi2Controller::get_match_playing_players($match_key);

      // print_r($finalplayingteams); exit;

      // if($match_key==42308) {

      //        print_r($finalplayingteams); exit;

      //      }


      if (count($finalplayingteams) >= 15) {
        DB::table('result_matches')->where('match_key', $match_key)->delete();


        foreach ($finalplayingteams as $playing_player) {

          $datasv = array();

          $player_id = $playing_player;

          $datasv['player_key'] = $player_id;

          $datasv['starting11'] = 1;

          $datasv['match_key'] = $match_key;

          $datasv['innings'] = 1;


          $player = DB::table('matchplayers')->join('players', 'players.id', '=', 'matchplayers.playerid')->where('matchkey', $match_key)->select('matchplayers.*', 'players.player_key', 'players.role as playerrole')->where('players.player_key', $player_id)->first();

          if (!empty($player)) {

            $datasv['player_id'] = $player->playerid;


            $findplayerex = DB::table('result_matches')->where('player_key', $player_id)->where('match_key', $match_key)->where('innings', 1)->select('id')->first();


            if (empty($findplayerex)) {


              try {

                DB::table('result_matches')->insert($datasv);
              } catch (\Illuminate\Database\QueryException $ex) {

                dd($ex->getMessage());

                // Note any method of class PDOException can be called on $ex.

              }
            }
          }
        }

        //exit;


        $innings = $match_detail->innings;

        foreach ($innings as $key => $value) {

          $inning_number = $value->number;

          if ($inning_number == 1 || $inning_number == 2) {

            $inning_number = 1;
          } else if ($inning_number == 3 || $inning_number == 4) {

            $inning_number = 2;
          }

          $batsmen = $value->batsmen;

          foreach ($batsmen as $key2 => $value2) {

            $datasv = array();

            $player_id = $value2->batsman_id;

            $player = DB::table('matchplayers')->join('players', 'players.id', '=', 'matchplayers.playerid')->where('matchkey', $match_key)->select('matchplayers.*', 'players.player_key', 'matchplayers.role as playerrole')->where('players.player_key', $player_id)->first();

            if (!empty($player)) {

              $catch = 0;
              $runouts = 0;
              $stumbed = 0;
              $batdots = 0;
              $balldots = 0;
              $six = 0;
              $runs = 0;
              $fours = 0;
              $miletone_run = 0;
              $bball = 0;

              $strike = 0;
              $acstrike = 0;
              $grun = 0;
              $balls = 0;
              $bballs = 0;
              $maiden_over = 0;
              $wicket = 0;
              $extra = 0;
              $overs = 0;

              $economy = 0;
              $duck = 0;
              $mile_wicket = 0;


              $datasv['runs'] = $runs = (int)$runs + (int)$value2->runs;

              $datasv['bball'] = $bball = (int)$bball + (int)$value2->balls_faced;

              $datasv['fours'] = $fours = (int)$fours + (int)$value2->fours;

              $datasv['six'] = $six = (int)$six + (int)$value2->sixes;

              $datasv['batting'] = 1;

              $datasv['strike_rate'] = $value2->strike_rate;

              if ($value2->how_out != 'Not out') {

                if ($runs == 0 && $player->playerrole != 'bowler' && !empty($value2->dismissal)) {

                  $datasv['duck'] = $duck = 1;
                } else {

                  $datasv['duck'] = $duck = 0;
                }

                $datasv['out_str'] = $value2->how_out;
              }

              $datasv['match_key'] = $match_key;

              $datasv['player_key'] = $player_id;

              $datasv['player_id'] = $player->playerid;

              $datasv['innings'] = $inning_number;

              $datasv['starting11'] = 1;


              /*if($player_id==46824) {

                  print_r($datasv); exit;
                }*/

              $findplayerex = DB::table('result_matches')->where('player_key', $player_id)->where('match_key', $match_key)->where('innings', $inning_number)->select('id')->first();

              if (!empty($findplayerex)) {

                DB::table('result_matches')->where('id', $findplayerex->id)->update($datasv);
              } else {

                DB::table('result_matches')->insert($datasv);
              }
            }
          }

          $bowlers = $value->bowlers;

          foreach ($bowlers as $key2 => $value2) {
            // if(!$value2->is_substitute) {


            $datasv = array();

            $catch = 0;
            $runouts = 0;
            $stumbed = 0;
            $batdots = 0;
            $balldots = 0;
            $six = 0;
            $runs = 0;
            $fours = 0;
            $miletone_run = 0;
            $bball = 0;

            $strike = 0;
            $acstrike = 0;
            $grun = 0;
            $balls = 0;
            $bballs = 0;
            $maiden_over = 0;
            $wicket = 0;
            $extra = 0;
            $overs = 0;

            $economy = 0;
            $duck = 0;
            $mile_wicket = 0;
            $lbwBowled = 0;
            $player_id = $value2->bowler_id;

            $player = DB::table('matchplayers')->join('players', 'players.id', '=', 'matchplayers.playerid')->where('matchkey', $match_key)->select('matchplayers.*', 'players.player_key', 'players.role as playerrole')->where('players.player_key', $player_id)->first();


            if (!empty($player)) {


              $datasv['balls'] = $balls = $balls + (round((int)$value2->overs) * 6);

              $datasv['maiden_over'] = $maiden_over = (int)$maiden_over + (int)$value2->maidens;

              $datasv['wicket'] = $wicket = (int)$wicket + (int)$value2->wickets;

              $datasv['extra'] = $extra = $extra + (int)$value2->noballs + (int)$value2->wides;

              $datasv['overs'] = $overs = $overs + $value2->overs;

              $datasv['grun'] = $grun = (int)$grun + (int)$value2->runs_conceded;
              $datasv['lbw_bowled'] = $lbwBowled = (int)$lbwBowled + ((int)$value2->lbwcount + $value2->bowledcount);
              $datasv['balldots'] = $balldots = (int)$balldots + (int)$value2->run0;

              $datasv['bowling'] = 1;

              $datasv['economy_rate'] = $value2->econ;


              $datasv['match_key'] = $match_key;

              $datasv['player_key'] = $player_id;

              $datasv['player_id'] = $player->playerid;

              $datasv['innings'] = $inning_number;

              $datasv['starting11'] = 1;


              $findplayerex = DB::table('result_matches')->where('player_key', $player_id)->where('match_key', $match_key)->where('innings', $inning_number)->select('id')->first();


              if (!empty($findplayerex)) {

                DB::table('result_matches')->where('id', $findplayerex->id)->update($datasv);
              } else {

                DB::table('result_matches')->insert($datasv);
              }
            }
            // }

          }

          $fielders = $value->fielder;
          // print_r($fielders); exit;
          foreach ($fielders as $key2 => $value2) {
            /*if($value2->fielder_id==43619) {
              print_r($value2); exit;
            }*/
            if ($value2->is_substitute == 'false') {
              // print_r($value2); exit;
              $datasv = array();

              $catch = 0;
              $runouts = 0;
              $stumbed = 0;
              $batdots = 0;
              $balldots = 0;
              $six = 0;
              $runs = 0;
              $fours = 0;
              $miletone_run = 0;
              $bball = 0;

              $strike = 0;
              $acstrike = 0;
              $grun = 0;
              $balls = 0;
              $bballs = 0;
              $maiden_over = 0;
              $wicket = 0;
              $extra = 0;
              $overs = 0;

              $economy = 0;
              $duck = 0;
              $mile_wicket = 0;

              $player_id = $value2->fielder_id;

              $player = DB::table('matchplayers')->join('players', 'players.id', '=', 'matchplayers.playerid')->where('matchkey', $match_key)->select('matchplayers.*', 'players.player_key', 'players.role as playerrole')->where('players.player_key', $player_id)->first();
              /*if($value2->fielder_id==43619) {
              print_r($player); exit;
            }*/
              if (!empty($player)) {

                $datasv['catch'] = $catch = $catch + $value2->catches;

                $datasv['stumbed'] = $stumbed = $stumbed + $value2->stumping;

                $datasv['runouts'] = $runouts = $runouts + $value2->runout_direct_hit;

                $thrower = $value2->runout_thrower;
                $hitter = $value2->runout_catcher;

                $datasv['runout_catcher'] = $hitter;
                $datasv['runout_thrower'] = $thrower;

                $datasv['match_key'] = $match_key;

                $datasv['player_key'] = $player_id;

                $datasv['player_id'] = $player->playerid;

                $datasv['innings'] = $inning_number;

                $datasv['starting11'] = 1;

                $findplayerex = DB::table('result_matches')->where('player_key', $player_id)->where('match_key', $match_key)->where('innings', $inning_number)->select('id')->first();

                if (!empty($findplayerex)) {

                  DB::table('result_matches')->where('id', $findplayerex->id)->update($datasv);
                } else {

                  DB::table('result_matches')->insert($datasv);
                }
              }
            }
          }
        }

        MatchesController::update_leaderboard($match_key);

        $showpoints = MatchesController::player_point($match_key, $findmatchtype->format);

        $refunded = MatchesController::refund_amount($match_key);
      }
    }
    // exit;

  }

  public function player_point($match_key, $match, $sport_type = 'CRICKET', $updatetype = 1)
  {

    // echo $sport_type; exit;
    $sportType = DB::table('sport_types')->where('sport_key', $sport_type)->first();
    // echo"<pre>";print_r($sportType);exit;
    $matchplayers = DB::table('result_matches')->where('match_key', $match_key)->get();
    // echo "<pre>";print_r($matchplayers);echo $match;die;


    switch ($sport_type) {
      case FOOTBALL:
        DB::table('result_points')->where('matchkey', $match_key)->delete();
        // print_r($matchplayers); exit;
        $i = 0;
        foreach ($matchplayers as $row) {
          // DB::table('result_points')->where('resultmatch_id', $row->id)->delete();
          $findplayerid = DB::table('players')->where('id', $row->player_id)->where('sport_type', $sportType->id)->first();
          //print_r($findplayerid);
          $findplayerids = DB::table('matchplayers')->where('playerid', $row->player_id)->where('matchkey', $match_key)->where('sport_type', $sportType->id)->first();
          $role = $findplayerids->role;
          $datasv[$i] = ['matchkey' => $match_key, 'playerid' => $findplayerid->id, 'resultmatch_id' => $row->id, 'total' => $row->total_points];


          $playingTime = (((int)$row->minutesplayed >= 55)  ? 0 : 0);
          $assist = (int)$row->assist * 20;
          $passes = (int)($row->totalpass / 5) * 1;
          $shots = ((int)($row->shotsontarget) * 6);
          $cleansheet = 0;
          $saveShots = 0;
          $penaltySave = 0;
          $tackles = ((int)($row->tacklesuccess)) * 4;
          $yellowCard = ((int)$row->yellowcard * (-4));
          $redCard = ((int)$row->redcard * (-10));
          $goalconceded = 0;
          $ownGoal = ((int)$row->owngoals * (-8));
          $penaltyMiss = ((int)$row->penaltymiss * (-20));

          //New Field
          $chancecreated = $row->chancecreated * 3;
          $interceptionwon = $row->interceptionwon * 4;
          //$blockedshot = $row->blockedshot * 4;
          $blockedshot = 0;
          //$clearance = $row->clearance * 2;
          $clearance = 0;
          $starting11 = $row->starting11 * 4;
          $substitute = $row->substitute * 2;


          if ($role == 'Forward' || $role == 'forward') {
            $goals = (int)$row->goals * 40;
          } else if ($role == 'Midfielder' || $role == 'midfielder') {
            $goals = (int)$row->goals * 50;
            if ($row->minutesplayed >= 55) {
              // $cleansheet = (int)$row->cleansheet*1;
            }
            // $goalconceded = ((int)$row->goalconceded *  (-2));
          } elseif ($role == 'Defender' || $role == 'defender') {
            $goalconceded = ((int)($row->goalconceded) *  (-2));
            if ($row->minutesplayed >= 55) {

              $cleansheet = (int)$row->cleansheet * 20;
            }
            $goals = (int)$row->goals * 60;
          } else {
            $goals = (int)$row->goals * 60;
            if ($row->minutesplayed >= 55) {
              $cleansheet = (int)$row->cleansheet * 20;
            }
          }

          if ($role == 'Goalkeeper' || $role == 'goalkeeper' || $role == 'Defender' || $role == 'defender') {
            $saveShots = (int)($row->shotsblocked) * 6;
            $penaltySave = (int)$row->penaltysave * 50;
            $goalconceded = ((int)($row->goalconceded) *  (-2));
          }
          $datasv[$i]['minutesplayed'] = $playingTime;
          $datasv[$i]['goals'] = $goals;
          $datasv[$i]['assist'] = $assist;
          $datasv[$i]['totalpass'] = $passes;
          $datasv[$i]['shotsontarget'] = $shots;
          $datasv[$i]['cleansheet'] = $cleansheet;
          $datasv[$i]['shotsblocked'] = $saveShots;
          $datasv[$i]['penaltysave'] = $penaltySave;
          $datasv[$i]['tacklesuccess'] = $tackles;
          $datasv[$i]['yellowcard'] = $yellowCard;
          $datasv[$i]['redcard'] = $redCard;
          $datasv[$i]['owngoals'] = $ownGoal;
          $datasv[$i]['penaltymiss'] = $penaltyMiss;
          $datasv[$i]['goalconceded'] = $goalconceded;

          $datasv[$i]['chancecreated'] = $chancecreated;
          $datasv[$i]['interceptionwon'] = $interceptionwon;
          $datasv[$i]['blockedshot'] = $blockedshot;
          $datasv[$i]['clearance'] = $clearance;

          $datasv[$i]['total'] = ($playingTime + $goals + $assist + $passes + $shots + $cleansheet + $saveShots + $penaltySave + $tackles + $yellowCard + $redCard + $ownGoal + $penaltyMiss + $goalconceded + $chancecreated + $interceptionwon + $blockedshot + $clearance + $starting11 + $substitute);
          //   if($findplayerid->id == 12314){
          //     var_dump("total");
          //   var_dump($datasv[$i]['total']);
          //
          //  var_dump('$goals');
          //  var_dump($goals);
          //
          //  var_dump('$passes');
          //  var_dump($passes);
          //
          //  var_dump('$shots');
          //  var_dump($shots);
          //
          //  var_dump('$chancecreated');
          //  var_dump($chancecreated);
          //
          //  var_dump('$interceptionwon');
          //  var_dump($interceptionwon);
          //
          //
          //  var_dump('$starting11');
          //  var_dump($starting11);
          //
          //
          //   exit;
          // }
          $i++;
        }
        // print_r($datasv); exit;
        if (!empty($datasv)) {
          $result = DB::table('result_points')->insert($datasv);
        }
        $this->updateplayerpoints($match_key, $sportType->id);
        break;
      case BASKETBALL:
        DB::table('result_points')->where('matchkey', $match_key)->delete();
        foreach ($matchplayers as $row) { //echo $row->id;
          $findplayerid = DB::table('players')->select('id')->where('id', $row->player_id)->where('sport_type', $sportType->id)->first();
          $pointscored = $row->pointscored * 1;
          //$rebound = $row->rebound * 1.2;
          $rebound = $row->rebound * 1;
          //$assists = $row->assist * 1.5;
          $assists = $row->assist * 1;
          //$steals = $row->steal * 3;
          $steals = $row->steal * 1;
          //$blocks = $row->block * 3;
          $blocks = $row->block * 1;
          $turnovers = $row->turnover * (1);
          //$turnovers = $row->turnover * (-1);
          // $missed_fg = $row->missed_fg * (-3.5);
          // $missed_ft = $row->missed_ft * (-1.5);
          $data = ['matchkey' => $match_key, 'playerid' => $findplayerid->id, 'resultmatch_id' => $row->id, 'total' => $row->total_points];
          $data['pointscored'] = $pointscored;
          $data['rebound'] = $rebound;
          $data['assist'] = $assists;
          $data['steal'] = $steals;
          $data['block'] = $blocks;
          $data['turnover'] = $turnovers;
          // $data['missed_fg'] = $missed_fg;
          // $data['missed_ft'] = $missed_ft;
          $data['total'] = ($pointscored + $rebound + $assists + $steals + $blocks + $turnovers);
          DB::table('result_points')->insert($data);
        }
        $this->updateplayerpoints($match_key, $sportType->id);
        break;
      // xxxxxxxxxxxx KABADDI NEW ADDED xxxxxxxxxxxxxxxxx
      case 'KABADDI':

        if ($updatetype != 7) {
          $this->updateplayerpoints($match_key, $sportType->id);
          return true;
        }
        DB::table('result_points')->where('matchkey', $match_key)->delete();
        foreach ($matchplayers as $row) {
          $findplayerid = DB::table('players')->select('id')->where('id', $row->player_id)->where('sport_type', $sportType->id)->first();
          //	$pointscored = (int)($row->pointscored) * 1;
          $pointscored = 0;
          $SuccessfulRaid = (int)($row->raidtouch) * 8;
          $RaidBonus = (int)($row->raidbonus) * 2;
          $SuperRaid = (int)($row->superraid) * 4;
          $Super10 = (int)($row->super10) * 4;
          //	$Super10 =0;
          $UnsuccessfulRaid = (int)($row->raidunsuccessful) * -2;
          $SuccessfulTackle = (int)($row->tacklesucceessful) * 20;
          $SuperTackle = (int)($row->supertackle) * 8;
          $High5 = (int)($row->highfive) * 10;
          $UnsuccessfulTackle = (int)($row->tackleunsuccessful) * -1;
          if ($row->substitute == 0) {
            $Starting7 = (int)1 * 8;
          } else {
            $Starting7 = (int)0;
          }
          $SubstituteAppearance = (int)($row->substitute) * 2;
          $AllOut = (int)($row->gettingallout) * -4;
          $TeamAllOut = (int)($row->pushingallout) * 8;
          $GreenCard = (int)($row->greencard) * -2;
          //	$GreenCard = 0;
          $YellowCard = (int)($row->yellowcard) * -4;
          $RedCard = (int)($row->redcard) * -6;
          $total_points = ($Starting7 + $SuccessfulRaid + $RaidBonus + $SuperRaid + $UnsuccessfulRaid + $SuccessfulTackle + $UnsuccessfulTackle + $SubstituteAppearance + $AllOut + $TeamAllOut + $High5 + $Super10 + $GreenCard + $YellowCard + $RedCard + $SuperTackle);

          // $total_points= ($SuccessfulRaid+$RaidBonus+$SuperRaid+$UnsuccessfulRaid+$SuccessfulTackle
          // 	+$SuperTackle+$UnsuccessfulTackle+$Starting7+$SubstituteAppearance+$AllOut+$TeamAllOut+$GreenCard+$YellowCard+$RedCard+$High5+$Super10);

          // $total_points= ($SuccessfulRaid+$RaidBonus+$SuperRaid+$UnsuccessfulRaid+$SuccessfulTackle
          // +$SuperTackle+$UnsuccessfulTackle+$Starting7+$SubstituteAppearance+$AllOut+$TeamAllOut+$GreenCard+$YellowCard+$RedCard+$High5+$Super10);

          $data = [
            'matchkey' => $match_key,
            'playerid' => @$findplayerid->id,
            'sport_type' => 7,
            'resultmatch_id' => $row->id,
            'total' => $total_points
          ];

          $data['pointscored'] = $pointscored;
          $data['raidtouch'] = $SuccessfulRaid;
          $data['raidbonus'] = $RaidBonus;
          $data['superraid'] = $SuperRaid;
          $data['raidunsucceessful'] = $UnsuccessfulRaid;
          $data['tacklesucceessful'] = $SuccessfulTackle;
          $data['tackleunsuccessful'] = $UnsuccessfulTackle;
          $data['supertackle'] = $SuperTackle;
          $data['starting7'] = $Starting7;
          $data['substitute'] = $SubstituteAppearance;
          $data['gettingallout'] = $AllOut;
          $data['pushingallout'] = $TeamAllOut;
          $data['highfive'] = $High5;
          $data['super10'] = $Super10;
          $data['greencard'] = $GreenCard;
          $data['yellowcard'] = $YellowCard;
          $data['redcard'] = $RedCard;

          $data['total'] = (int)($total_points);

          // if($findplayerid->id==19752){
          // 	$data['total'] = (int)($total_points-4);
          // }
          // if($findplayerid->id==19708){
          // 	$data['total'] = (int)($total_points-6);
          // }
          // if($findplayerid->id==19688){
          //   $data['total'] = (int)($total_points+2);
          // }


          DB::table('result_points')->insert($data);
        }
        $this->updateplayerpoints($match_key, $sportType->id);

        // xxxxxxxxxxxx KABADDI NEW ADDED xxxxxxxxxxxxxxxxx
        break;
      case CRICKET:
        if (!empty($matchplayers)) {
          DB::table('result_points')->where('matchkey', $match_key)->delete();
          foreach ($matchplayers as $row) {

            $resultmatchupdate = array();

            $result = array();

            $duck = $row->duck;

            $player_key = $row->player_key;

            $findplayerid = DB::table('players')->select('id')->where('id', $row->player_id)->first();

            $findplayerrole = DB::table('matchplayers')->where('playerid', $findplayerid->id)->where('matchkey', $match_key)->select('role')->first();

            $findplayerrole = @$findplayerrole->role;
            $runs = $row->runs;

            $wicket = $row->wicket;

            $catch = $row->catch;

            $stumbed = $row->stumbed;

            $boundary = $row->boundary;

            $six = $row->six;

            $fours = $row->fours;

            $maiden_over = $row->maiden_over;

            $overs = $row->overs;

            $balls = $row->balls;

            $bballs = $row->bball;

            $grun = $row->grun;
            $runout_catcher = $row->runout_catcher;
            $runout_thrower = $row->runout_thrower;
            $runouts = $row->runouts;
            //new point system
            $lbw_bowled = $row->lbw_bowled;
            // if($row->player_id==2227){
            //   echo $lbw_bowled; exit;
            // }
            $economyrate = 0;

            $strikerate = 0;

            $extrapoints = 0;

            $total_points = 0;

            $batting_points = 0;

            $bowling_points = 0;

            $fielding_points = 0;

            $extra_points = 0;

            $negative_points = 0;

            $duck = 0;
            $Wicket_bonus = 0;
            $catch_bonus = 0;
            $crpoints = 0;
            // new point system
            $thirtyPoints = 0;
            $bonuspoints = 0;

            if ($match == 't20') {

              if ($row->starting11 == 1 && $row->innings == 1) {

                $startingpoint = 4;
              } else {

                $startingpoint = 0;
              }

              $runs = $runs * 1;

              if ($findplayerrole != 'bowler') {

                if ($row->duck != 0 || $row->duck != "") {

                  $duck = -2;
                }
              }
              if ($wicket == 3) {

                $extrapoints = $extrapoints + 4;

                $bonuspoints = $bonuspoints + 4;
                $Wicket_bonus = $Wicket_bonus + 4;
              }

              if ($wicket == 4) {

                $extrapoints = $extrapoints + 8;

                $bonuspoints = $bonuspoints + 8;
                $Wicket_bonus = $Wicket_bonus + 8;
              }

              if ($wicket >= 5) {

                $extrapoints = $extrapoints + 16;

                $bonuspoints = $bonuspoints + 16;
                $Wicket_bonus = $Wicket_bonus + 16;
              }

              $wicket = $wicket * 25;
              if ($catch >= 3) {
                $extrapoints = $extrapoints + 4;
                $bonuspoints = $bonuspoints + 4;
                $catch_bonus = $catch_bonus + 4;
              }
              $catch = $catch * 8;




              $stumbed = $stumbed * 12;


              $runouts = $runouts * 12;
              $runout_catcher = $runout_catcher * 6;
              $runout_thrower = $runout_thrower * 6;
              $lbw_bowled = $lbw_bowled * 8;
              $boundary = $fours * 1;

              $six = $six * 2;

              if (($runs >= 50) && ($runs < 100)) {

                $extrapoints = $extrapoints + 8;

                $crpoints = $crpoints + 8;
              }

              if ($runs >= 100) {

                $extrapoints = $extrapoints + 16;

                $crpoints = $crpoints + 16;
              }


              if (($runs >= 30) && ($runs < 50)) {

                $extrapoints = $extrapoints + 4;

                $thirtyPoints = $thirtyPoints + 4;
              }


              $maiden_over = $maiden_over * 12;



              if ($balls >= 12) {

                //$economyrate = 2*(1.5*$balls - $grun);



                //$economyrate = 2*(1.5*$balls - $grun);

                //$total_over=($balls/6);

                $get_economyrate = $row->economy_rate;



                if ($get_economyrate > 12) {

                  $economyrate = '-6';
                } else if ($get_economyrate >= 11.1 && $get_economyrate <= 12) { //            }else if($get_economyrate >=11.01 && $get_economyrate <=12){

                  $economyrate = '-4';
                } else if ($get_economyrate >= 10 && $get_economyrate <= 11) {

                  $economyrate = '-2';
                } else if ($get_economyrate >= 6 && $get_economyrate <= 7) {

                  $economyrate = '2';
                } else if ($get_economyrate >= 5 && $get_economyrate <= 5.99) {

                  $economyrate = '4';
                } else if ($get_economyrate < 5) {

                  $economyrate = '6';
                } else {

                  $economyrate = '0';
                }

                //End

              }

              if ($bballs >= 10 && $findplayerrole != 'bowler') {

                $battingdots = $row->battingdots;

                $totalballs = $row->bball;

                $facedballls = $totalballs - $battingdots;

                //$strikerate = 2*($runs - $totalballs);

                $get_strikerate = ($runs / $totalballs) * 100;

                //Get Strike Rate

                if ($get_strikerate >= 60 && $get_strikerate <= 70) {

                  $strikerate = '-2';
                } else if ($get_strikerate >= 50 && $get_strikerate <= 59.99) {

                  $strikerate = '-4';
                } else if ($get_strikerate < 50) {

                  $strikerate = '-6';

                  //End

                } else if ($get_strikerate > 170) {
                  $strikerate = '6';
                } else if ($get_strikerate >= 150.01 && $get_strikerate <= 170) {
                  $strikerate = '4';
                } else if ($get_strikerate >= 130 && $get_strikerate <= 150) {
                  $strikerate = '2';
                }
              }
            } else if ($match == 't10') {

              if ($row->starting11 == 1 && $row->innings == 1) {

                $startingpoint = 4;
              } else {

                $startingpoint = 0;
              }

              $runs = $runs * 1;

              if ($findplayerrole != 'bowler') {

                if ($row->duck != 0 || $row->duck != "") {

                  $duck = -2;
                }
              }

              if ($wicket == 2) {

                $extrapoints = $extrapoints + 8;

                $bonuspoints = $bonuspoints + 8;
                $Wicket_bonus = $Wicket_bonus + 8;
              }

              if ($wicket >= 3) {

                $extrapoints = $extrapoints + 16;

                $bonuspoints = $bonuspoints + 16;
                $Wicket_bonus = $Wicket_bonus + 16;
              }

              $wicket = $wicket * 25;

              if ($catch >= 3) {
                $extrapoints = $extrapoints + 4;

                $bonuspoints = $bonuspoints + 4;
                $catch_bonus = $catch_bonus + 4;
              }
              $catch = $catch * 8;


              $stumbed = $stumbed * 12;

              $runouts = $runouts * 12;
              $runout_catcher = $runout_catcher * 6;
              $runout_thrower = $runout_thrower * 6;
              $lbw_bowled = $row->lbw_bowled * 8;
              $boundary = $fours * 1;

              $six = $six * 2;

              if (($runs >= 30) && ($runs < 50)) {

                $extrapoints = $extrapoints + 8;

                $crpoints = $crpoints + 8;
              }

              if ($runs >= 50) {

                $extrapoints = $extrapoints + 16;

                $crpoints = $crpoints + 16;
              }

              $maiden_over = $maiden_over * 16;



              if ($overs >= 1) {

                //$economyrate = 2*(1.5*$balls - $grun);



                //$economyrate = 2*(1.5*$balls - $grun);

                //$total_over=($balls/6);

                $get_economyrate = $row->economy_rate;



                if ($get_economyrate > 16) {

                  $economyrate = '-6';
                } else if ($get_economyrate >= 15.01 && $get_economyrate <= 16) {

                  $economyrate = '-4';
                } else if ($get_economyrate >= 14 && $get_economyrate <= 15) {

                  $economyrate = '-2';
                } else if ($get_economyrate >= 8 && $get_economyrate <= 9) {

                  $economyrate = '2';
                } else if ($get_economyrate >= 7 && $get_economyrate <= 7.99) {

                  $economyrate = '4';
                } else if ($get_economyrate < 7) {

                  $economyrate = '6';
                } else {

                  $economyrate = '0';
                }

                //End

              }



              if ($bballs >= 5 && $findplayerrole != 'bowler') {

                $battingdots = $row->battingdots;

                $totalballs = $row->bball;

                $facedballls = $totalballs - $battingdots;

                //$strikerate = 2*($runs - $totalballs);

                $get_strikerate = ($runs / $totalballs) * 100;

                //Get Strike Rate

                if ($get_strikerate >= 70 && $get_strikerate <= 80) {

                  $strikerate = '-2';
                } else if ($get_strikerate >= 60 && $get_strikerate <= 69.99) {

                  $strikerate = '-4';
                } else if ($get_strikerate < 60) {

                  $strikerate = '-6';

                  //End

                } else if ($get_strikerate > 190) {
                  $strikerate = '6';
                } else if ($get_strikerate >= 170.01 && $get_strikerate <= 190) {
                  $strikerate = '4';
                } else if ($get_strikerate >= 150 && $get_strikerate <= 170) {
                  $strikerate = '2';
                }
              }
            } else if ($match == 'one-day') {

              // print_r($row); exit;

              if ($row->starting11 == 1 && $row->innings == 1) {

                $startingpoint = 4;
              } else {

                $startingpoint = 0;
              }

              $runs = $runs * 1;

              if ($findplayerrole != 'bowler') {

                if ($row->duck != 0 || $row->duck != "") {

                  $duck = -3;
                }
              }


              if ($wicket == 4) {

                $extrapoints = $extrapoints + 4;

                $bonuspoints = $bonuspoints + 4;
                $Wicket_bonus = $Wicket_bonus + 4;
              }

              if ($wicket >= 5) {

                $extrapoints = $extrapoints + 8;

                $bonuspoints = $bonuspoints + 8;
                $Wicket_bonus = $Wicket_bonus + 8;
              }

              $wicket = $wicket * 25;
              if ($catch >= 3) {
                $extrapoints = $extrapoints + 4;

                $bonuspoints = $bonuspoints + 4;
                $catch_bonus = $catch_bonus + 4;
              }
              $catch = $catch * 8;

              $stumbed = $stumbed * 12;

              $runouts = $runouts * 12;
              $runout_catcher = $runout_catcher * 6;
              $runout_thrower = $runout_thrower * 6;
              $lbw_bowled = $row->lbw_bowled * 8;
              $boundary = $fours * 1;

              $six = $six * 2;

              if (($runs >= 50) && ($runs < 100)) {

                $extrapoints = $extrapoints + 4;

                $crpoints = $crpoints + 4;
              }

              if ($runs >= 100) {

                $extrapoints = $extrapoints + 4;

                $crpoints = $crpoints + 8;
              }

              $maiden_over = $maiden_over * 4;

              if ($overs >= 5) {

                //$economyrate =($balls - $grun);

                $get_economyrate = $row->economy_rate;



                if ($get_economyrate > 9) {

                  $economyrate = '-6';
                } else if ($get_economyrate >= 8.01 && $get_economyrate <= 9) {

                  $economyrate = '-4';
                } else if ($get_economyrate >= 7 && $get_economyrate <= 8) {

                  $economyrate = '-2';
                } else if ($get_economyrate >= 3.5 && $get_economyrate <= 4.5) {

                  $economyrate = '2';
                } else if ($get_economyrate >= 2.5 && $get_economyrate <= 3.49) {

                  $economyrate = '4';
                } else if ($get_economyrate < 2.5) {

                  $economyrate = '6';
                }

                //End

              }

              if ($bballs >= 20 && $findplayerrole != 'bowler') {

                $battingdots = $row->battingdots;

                $totalballs = $row->bball;

                $facedballls = $totalballs - $battingdots;

                //$strikerate = ($runs - $totalballs);

                $get_strikerate =  ($runs / $totalballs) * 100;

                //Get Strike Rate

                if ($get_strikerate >= 40 && $get_strikerate <= 50) {

                  $strikerate = '-2';
                } else if ($get_strikerate >= 30 && $get_strikerate <= 39.99) {

                  $strikerate = '-4';
                } else if ($get_strikerate < 30) {

                  $strikerate = '-6';

                  //End

                } else if ($get_strikerate > 140) {
                  $strikerate = '6';
                } else if ($get_strikerate >= 120.01 && $get_strikerate <= 140) {
                  $strikerate = '4';
                } else if ($get_strikerate >= 100 && $get_strikerate <= 120) {
                  $strikerate = '2';
                }
              }
            } else if ($match == 'hundred') {

              if ($row->starting11 == 1 && $row->innings == 1) {

                $startingpoint = 4;
              } else {

                $startingpoint = 0;
              }

              $runs = $runs * 1;

              if ($findplayerrole != 'bowler') {

                if ($row->duck != 0 || $row->duck != "") {

                  $duck = -2;
                }
              }

              if ($wicket == 2) {

                $extrapoints = $extrapoints + 3;

                $bonuspoints = $bonuspoints + 3;
              }
              if ($wicket == 3) {

                $extrapoints = $extrapoints + 5;

                $bonuspoints = $bonuspoints + 5;
              }
              if ($wicket == 4) {

                $extrapoints = $extrapoints + 10;

                $bonuspoints = $bonuspoints + 10;
              }

              if ($wicket >= 5) {

                $extrapoints = $extrapoints + 20;

                $bonuspoints = $bonuspoints + 20;
              }

              $wicket = $wicket * 25;
              if ($catch >= 3) {
                $extrapoints = $extrapoints + 4;
                $bonuspoints = $bonuspoints + 4;
              }
              $catch = $catch * 8;




              $stumbed = $stumbed * 12;


              $runouts = $runouts * 12;
              $runout_catcher = $runout_catcher * 6;
              $runout_thrower = $runout_thrower * 6;
              $lbw_bowled = $lbw_bowled * 8;
              $boundary = $fours * 1;

              $six = $six * 2;

              if (($runs >= 50) && ($runs < 100)) {

                $extrapoints = $extrapoints + 10;

                $crpoints = $crpoints + 10;
              }

              if ($runs >= 100) {

                $extrapoints = $extrapoints + 20;

                $crpoints = $crpoints + 20;
              }


              if (($runs >= 30) && ($runs < 50)) {

                $extrapoints = $extrapoints + 5;

                $thirtyPoints = $thirtyPoints + 5;
              }


              // $maiden_over = $maiden_over*12;



              if ($balls >= 12) {

                //$economyrate = 2*(1.5*$balls - $grun);



                //$economyrate = 2*(1.5*$balls - $grun);

                //$total_over=($balls/6);

                $get_economyrate = $row->economy_rate;



                if ($get_economyrate > 12) {

                  // $economyrate='-6';

                } else if ($get_economyrate >= 11.1 && $get_economyrate <= 12) {

                  // $economyrate='-4';

                } else if ($get_economyrate >= 10 && $get_economyrate <= 11) {

                  // $economyrate='-2';

                } else if ($get_economyrate >= 6 && $get_economyrate <= 7) {

                  // $economyrate='2';

                } else if ($get_economyrate >= 5 && $get_economyrate <= 5.99) {

                  // $economyrate='4';

                } else if ($get_economyrate < 5) {

                  // $economyrate='6';

                } else {

                  // $economyrate='0';

                }

                //End

              }

              if ($bballs >= 10 && $findplayerrole != 'bowler') {

                $battingdots = $row->battingdots;

                $totalballs = $row->bball;

                $facedballls = $totalballs - $battingdots;

                //$strikerate = 2*($runs - $totalballs);

                $get_strikerate = ($runs / $totalballs) * 100;

                //Get Strike Rate

                if ($get_strikerate >= 60 && $get_strikerate <= 70) {

                  // $strikerate='-2';

                } else if ($get_strikerate >= 50 && $get_strikerate <= 59.99) {

                  // $strikerate='-4';

                } else if ($get_strikerate < 50) {

                  // $strikerate='-6';

                  //End

                } else if ($get_strikerate > 170) {
                  // $strikerate = '6';
                } else if ($get_strikerate >= 150.01 && $get_strikerate <= 170) {
                  // $strikerate = '4';
                } else if ($get_strikerate >= 130 && $get_strikerate <= 150) {
                  // $strikerate = '2';
                }
              }
              $maiden_over = 0;
            }
            //
            // else if($match == 't10'){
            //
            //   if($row->starting11==1 && $row->innings==1){
            //
            //     $startingpoint = 4;
            //
            //   }
            //
            //   else{
            //
            //     $startingpoint = 0;
            //
            //   }
            //
            //   $runs = $runs*1;
            //
            //   if($findplayerrole!='bowler'){
            //
            //     if($row->duck!=0 || $row->duck!=""){
            //
            //       $duck = -2;
            //
            //     }
            //
            //   }
            //
            //   if($wicket==2){
            //
            //     $extrapoints = $extrapoints+8;
            //
            //     $bonuspoints=$bonuspoints+8;
            //
            //   }
            //
            //   if($wicket>=3){
            //
            //     $extrapoints = $extrapoints+16;
            //
            //     $bonuspoints=$bonuspoints+16;
            //
            //   }
            //
            //   $wicket = $wicket*25;
            //
            //   $catch = $catch*8;
            //
            //   $stumbed = $stumbed*12;
            //
            //   $runouts = $runouts*12;
            //   $runout_catcher = $runout_catcher*6;
            //   $runout_thrower = $runout_thrower*6;
            //
            //   $boundary = $fours*1;
            //
            //   $six = $six*2;
            //
            //   if(($runs>=30) && ($runs<=50)){
            //
            //     $extrapoints = $extrapoints+ 8;
            //
            //     $crpoints = $crpoints+8;
            //
            //   }
            //
            //   if($runs>=50){
            //
            //     $extrapoints =$extrapoints + 16;
            //
            //     $crpoints = $crpoints+16;
            //
            //   }
            //
            //   $maiden_over = $maiden_over*16;
            //
            //
            //
            //   if($overs>=1){
            //
            //     //$economyrate = 2*(1.5*$balls - $grun);
            //
            //
            //
            //     //$economyrate = 2*(1.5*$balls - $grun);
            //
            //     //$total_over=($balls/6);
            //
            //     $get_economyrate=$row->economy_rate;
            //
            //
            //
            //     if($get_economyrate >13){
            //
            //       $economyrate='-6';
            //
            //     }else if($get_economyrate >=12.01 && $get_economyrate <=13){
            //
            //                       $economyrate='-4';
            //
            //     }else if($get_economyrate >=11 && $get_economyrate <=12){
            //
            //                       $economyrate='-2';
            //
            //     }else if($get_economyrate >=7 && $get_economyrate <=8){
            //
            //                       $economyrate='2';
            //
            //     }else if($get_economyrate >=6.00 && $get_economyrate <=6.99){
            //
            //         $economyrate='4';
            //
            //     }else if($get_economyrate < 6){
            //
            //                       $economyrate='6';
            //
            //     } else {
            //
            //       $economyrate='0';
            //
            //     }
            //
            //     //End
            //
            //   }
            //
            //   if($bballs>=5 && $findplayerrole!='bowler'){
            //
            //     $battingdots = $row->battingdots;
            //
            //     $totalballs = $row->bball;
            //
            //     $facedballls = $totalballs - $battingdots;
            //
            //     //$strikerate = 2*($runs - $totalballs);
            //
            //     $get_strikerate = ($runs/$totalballs)*100;
            //
            //                  //Get Strike Rate
            //
            //                  if($get_strikerate >=90 && $get_strikerate <=99.99){
            //
            //                   $strikerate='-2';
            //
            //                  }else if($get_strikerate >=80 && $get_strikerate <=89.9){
            //
            //                    $strikerate='-4';
            //
            //                  }else if($get_strikerate < 80){
            //
            //                    $strikerate='-6';
            //
            //                  //End
            //
            //                  }
            //
            //   }
            //
            // }

            else {

              if ($row->starting11 == 1 && $row->innings == 1) {

                $startingpoint = 4;
              } else {

                $startingpoint = 0;
              }

              $runs = $runs * 1;

              if ($findplayerrole != 'bowler') {

                if ($row->duck != 0 || $row->duck != "") {

                  $duck = -4;
                }
              }

              if ($wicket == 4) {

                $extrapoints = $extrapoints + 4;

                $bonuspoints = $bonuspoints + 4;
              }

              if ($wicket >= 5) {

                $extrapoints = $extrapoints + 8;

                $bonuspoints = $bonuspoints + 8;
              }

              $wicket = $wicket * 16;

              $catch = $catch * 8;

              $stumbed = $stumbed * 12;

              $runouts = $runouts * 12;
              $runout_catcher = $runout_catcher * 6;
              $runout_thrower = $runout_thrower * 6;
              $lbw_bowled = $row->lbw_bowled * 8;
              $boundary = $fours * 1;

              $six = $six * 2;

              if (($runs >= 50) && ($runs <= 100)) {

                $extrapoints = $extrapoints + 4;

                $crpoints = $crpoints + 4;
              }

              if ($runs >= 100) {

                $extrapoints = $extrapoints + 8;

                $crpoints = $crpoints + 8;
              }

              $maiden_over = 0;
            }

            if ($row->starting11 == 1) {

              // if($match_key=='74441' && $player_key=='46821')
              // {
              //   echo "$runs+$six+$fours+$strikerate+$crpoints+$thirtyPoints";die;
              // }

              $result['batting_points'] = $runs + $six + $fours + $strikerate + $crpoints + $thirtyPoints;

              $result['fielding_points'] = $catch + $stumbed;

              $result['bowling_points'] = $wicket + $maiden_over + $economyrate + $lbw_bowled;

              $result['negative_points'] = $duck;

              $result['extra_points'] = $bonuspoints;

              $result['total_points'] = $total_points = $startingpoint + $runs + $wicket + $catch + $stumbed + $boundary + $six + $bonuspoints + $economyrate + $strikerate + $maiden_over + $duck + $crpoints + $runouts + $runout_catcher + $runout_thrower + $lbw_bowled + $thirtyPoints;
            } else {

              $result['batting_points'] = 0;

              $result['fielding_points'] = 0;

              $result['bowling_points'] = 0;

              $result['negative_points'] = 0;

              $result['extra_points'] = 0;

              $result['total_points'] = 0;
            }



            DB::table('result_matches')->where('player_key', $player_key)->where('match_key', $match_key)->where('innings', $row->innings)->update($result);

            //insert in result points//

            $resultpoints['matchkey'] = $match_key;

            $resultpoints['playerid'] = $findplayerid->id;

            if ($row->starting11 == 1) {

              $resultpoints['startingpoints'] = $startingpoint;

              $resultpoints['runs'] = $runs;

              $resultpoints['fours'] = $boundary;

              $resultpoints['sixs'] = $six;

              $resultpoints['strike_rate'] = $strikerate;

              $resultpoints['century'] = $crpoints;

              $resultpoints['wickets'] = $wicket;

              $resultpoints['maidens'] = $maiden_over;

              $resultpoints['economy_rate'] = $economyrate;

              $resultpoints['catch'] = $catch;

              $resultpoints['stumping'] = $stumbed;
              $resultpoints['runouts'] = $runouts;
              $resultpoints['runout_catcher'] = $runout_catcher;
              $resultpoints['runout_thrower'] = $runout_thrower;
              $resultpoints['lbw_bowled'] = $lbw_bowled;
              $resultpoints['catch_bonus'] = $catch_bonus;
              $resultpoints['wicket_bonus'] = $Wicket_bonus;

              $resultpoints['thirty_runs'] = $thirtyPoints;

              $resultpoints['bonus'] = $bonuspoints;

              $resultpoints['negative'] = $duck;
              $resultpoints['duck'] = $duck;

              $resultpoints['total'] = $total_points;
            } else {

              $resultpoints['startingpoints'] = 0;

              $resultpoints['runs'] = 0;

              $resultpoints['fours'] = 0;

              $resultpoints['sixs'] = 0;

              $resultpoints['strike_rate'] = 0;

              $resultpoints['century'] = 0;

              $resultpoints['wickets'] = 0;

              $resultpoints['maidens'] = 0;

              $resultpoints['economy_rate'] = 0;

              $resultpoints['catch'] = 0;

              $resultpoints['stumping'] = 0;

              $resultpoints['bonus'] = 0;
              $resultpoints['catch_bonus'] = 0;
              $resultpoints['wicket_bonus'] = 0;
              $resultpoints['negative'] = 0;

              $resultpoints['total'] = 0;
            }
            // if($findplayerid->id==2227){
            //     echo "<pre>";  print_r($resultpoints); exit;
            // }

            // $finde = DB::table('result_points')
            //   ->where('matchkey',$match_key)
            //   ->where('playerid',$findplayerid->id)
            //   ->where('resultmatch_id',$row->id)
            //   ->select('id')->first();
            // if(!empty($finde)) {
            //
            //   // DB::table('result_points')->where('id',$finde->id)->delete();
            // }

            // if(empty($finde)){

            $resultpoints['resultmatch_id'] = $row->id;

            DB::table('result_points')->insert($resultpoints);

            // }
            //
            // else{
            //
            //   DB::table('result_points')->where('id',$finde->id)->update($resultpoints);
            //
            // }

            // echo 'yes'; exit;

            // print_r($match_key);exit;

          }

          //       if($match=='test'){
          //            $finde3 = DB::table('result_points')->where('matchkey',$match_key)->get();
          //           foreach ($finde3 as $key => $value) {
          //              $finde = DB::table('result_points')->where('matchkey',$match_key)->where('playerid',$value->playerid)->sum('total');
          //            DB::table('result_points')->where('id',$value->id)->update(['total'=>$finde]);
          //           }
          // }

          $this->updateplayerpoints($match_key);
        }
    }
  }

  public function player_point_old_06_09_23($match_key, $match, $sport_type = 'CRICKET')
  {
    //echo $match; exit;
    $sportType = DB::table('sport_types')->where('sport_key', $sport_type)->first();
    $matchplayers = DB::table('result_matches')->where('match_key', $match_key)->get();
    // dd($matchplayers);
    // echo "<pre>";print_r($matchplayers);echo $match;die;


    switch ($sport_type) {
      case FOOTBALL:
        DB::table('result_points')->where('matchkey', $match_key)->delete();
        // print_r($matchplayers); exit;
        $i = 0;
        foreach ($matchplayers as $row) {
          // DB::table('result_points')->where('resultmatch_id', $row->id)->delete();
          $findplayerid = DB::table('players')->where('id', $row->player_id)->where('sport_type', $sportType->id)->first();
          //print_r($findplayerid);
          $findplayerids = DB::table('matchplayers')->where('playerid', $row->player_id)->where('matchkey', $match_key)->where('sport_type', $sportType->id)->first();
          $role = $findplayerids->role;
          $datasv[$i] = ['matchkey' => $match_key, 'playerid' => $findplayerid->id, 'resultmatch_id' => $row->id, 'total' => $row->total_points];


          $playingTime = (((int)$row->minutesplayed >= 55)  ? 0 : 0);
          $assist = (int)$row->assist * 20;
          $passes = (int)($row->totalpass / 5) * 1;
          $shots = ((int)($row->shotsontarget) * 6);
          $cleansheet = 0;
          $saveShots = 0;
          $penaltySave = 0;
          $tackles = ((int)($row->tacklesuccess)) * 4;
          $yellowCard = ((int)$row->yellowcard * (-4));
          $redCard = ((int)$row->redcard * (-10));
          $goalconceded = 0;
          $ownGoal = ((int)$row->owngoals * (-8));
          $penaltyMiss = ((int)$row->penaltymiss * (-20));

          //New Field
          $chancecreated = $row->chancecreated * 3;
          $interceptionwon = $row->interceptionwon * 4;
          //$blockedshot = $row->blockedshot * 4;
          $blockedshot = 0;
          //$clearance = $row->clearance * 2;
          $clearance = 0;
          $starting11 = $row->starting11 * 4;
          $substitute = $row->substitute * 2;


          if ($role == 'Forward' || $role == 'forward') {
            $goals = (int)$row->goals * 40;
          } else if ($role == 'Midfielder' || $role == 'midfielder') {
            $goals = (int)$row->goals * 50;
            if ($row->minutesplayed >= 55) {
              // $cleansheet = (int)$row->cleansheet*1;
            }
            // $goalconceded = ((int)$row->goalconceded *  (-2));
          } elseif ($role == 'Defender' || $role == 'defender') {
            $goalconceded = ((int)($row->goalconceded) *  (-2));
            if ($row->minutesplayed >= 55) {

              $cleansheet = (int)$row->cleansheet * 20;
            }
            $goals = (int)$row->goals * 60;
          } else {
            $goals = (int)$row->goals * 60;
            if ($row->minutesplayed >= 55) {
              $cleansheet = (int)$row->cleansheet * 20;
            }
          }

          if ($role == 'Goalkeeper' || $role == 'goalkeeper' || $role == 'Defender' || $role == 'defender') {
            $saveShots = (int)($row->shotsblocked) * 6;
            $penaltySave = (int)$row->penaltysave * 50;
            $goalconceded = ((int)($row->goalconceded) *  (-2));
          }
          $datasv[$i]['minutesplayed'] = $playingTime;
          $datasv[$i]['goals'] = $goals;
          $datasv[$i]['assist'] = $assist;
          $datasv[$i]['totalpass'] = $passes;
          $datasv[$i]['shotsontarget'] = $shots;
          $datasv[$i]['cleansheet'] = $cleansheet;
          $datasv[$i]['shotsblocked'] = $saveShots;
          $datasv[$i]['penaltysave'] = $penaltySave;
          $datasv[$i]['tacklesuccess'] = $tackles;
          $datasv[$i]['yellowcard'] = $yellowCard;
          $datasv[$i]['redcard'] = $redCard;
          $datasv[$i]['owngoals'] = $ownGoal;
          $datasv[$i]['penaltymiss'] = $penaltyMiss;
          $datasv[$i]['goalconceded'] = $goalconceded;

          $datasv[$i]['chancecreated'] = $chancecreated;
          $datasv[$i]['interceptionwon'] = $interceptionwon;
          $datasv[$i]['blockedshot'] = $blockedshot;
          $datasv[$i]['clearance'] = $clearance;

          $datasv[$i]['total'] = ($playingTime + $goals + $assist + $passes + $shots + $cleansheet + $saveShots + $penaltySave + $tackles + $yellowCard + $redCard + $ownGoal + $penaltyMiss + $goalconceded + $chancecreated + $interceptionwon + $blockedshot + $clearance + $starting11 + $substitute);
          //   if($findplayerid->id == 12314){
          //     var_dump("total");
          //   var_dump($datasv[$i]['total']);
          //
          //  var_dump('$goals');
          //  var_dump($goals);
          //
          //  var_dump('$passes');
          //  var_dump($passes);
          //
          //  var_dump('$shots');
          //  var_dump($shots);
          //
          //  var_dump('$chancecreated');
          //  var_dump($chancecreated);
          //
          //  var_dump('$interceptionwon');
          //  var_dump($interceptionwon);
          //
          //
          //  var_dump('$starting11');
          //  var_dump($starting11);
          //
          //
          //   exit;
          // }
          $i++;
        }
        // print_r($datasv); exit;
        if (!empty($datasv)) {
          $result = DB::table('result_points')->insert($datasv);
        }
        $this->updateplayerpoints($match_key, $sportType->id);
        break;
      case BASKETBALL:
        DB::table('result_points')->where('matchkey', $match_key)->delete();
        foreach ($matchplayers as $row) {
          echo $row->id;
          $findplayerid = DB::table('players')->select('id')->where('id', $row->player_id)->where('sport_type', $sportType->id)->first();
          $pointscored = $row->pointscored * 1;
          //$rebound = $row->rebound * 1.2;
          $rebound = $row->rebound * 1;
          //$assists = $row->assist * 1.5;
          $assists = $row->assist * 1;
          //$steals = $row->steal * 3;
          $steals = $row->steal * 1;
          //$blocks = $row->block * 3;
          $blocks = $row->block * 1;
          $turnovers = $row->turnover * (1);
          //$turnovers = $row->turnover * (-1);
          // $missed_fg = $row->missed_fg * (-3.5);
          // $missed_ft = $row->missed_ft * (-1.5);
          $data = ['matchkey' => $match_key, 'playerid' => $findplayerid->id, 'resultmatch_id' => $row->id, 'total' => $row->total_points];
          $data['pointscored'] = $pointscored;
          $data['rebound'] = $rebound;
          $data['assist'] = $assists;
          $data['steal'] = $steals;
          $data['block'] = $blocks;
          $data['turnover'] = $turnovers;
          // $data['missed_fg'] = $missed_fg;
          // $data['missed_ft'] = $missed_ft;
          $data['total'] = ($pointscored + $rebound + $assists + $steals + $blocks + $turnovers);
          DB::table('result_points')->insert($data);
        }
        $this->updateplayerpoints($match_key, $sportType->id);
        break;
      case CRICKET:
        if (!empty($matchplayers)) {
          DB::table('result_points')->where('matchkey', $match_key)->delete();
          foreach ($matchplayers as $row) {

            $resultmatchupdate = array();

            $result = array();

            $duck = $row->duck;

            $player_key = $row->player_key;

            $findplayerid = DB::table('players')->select('id')->where('id', $row->player_id)->first();
            $findplayerrole = DB::table('matchplayers')->where('playerid', $findplayerid->id)->where('matchkey', $match_key)->select('role')->first();
            // dd($findplayerrole);

            $findplayerrole = $findplayerrole->role;
            $runs = $row->runs;

            $wicket = $row->wicket;

            $catch = $row->catch;

            $stumbed = $row->stumbed;

            $boundary = $row->boundary;

            $six = $row->six;

            $fours = $row->fours;

            $maiden_over = $row->maiden_over;

            $overs = $row->overs;

            $balls = $row->balls;

            $bballs = $row->bball;

            $grun = $row->grun;
            $runout_catcher = $row->runout_catcher;
            $runout_thrower = $row->runout_thrower;
            $runouts = $row->runouts;
            //new point system
            $lbw_bowled = $row->lbw_bowled;
            // if($row->player_id==2227){
            //   echo $lbw_bowled; exit;
            // }
            $economyrate = 0;

            $strikerate = 0;

            $extrapoints = 0;

            $total_points = 0;

            $batting_points = 0;

            $bowling_points = 0;

            $fielding_points = 0;

            $extra_points = 0;

            $negative_points = 0;

            $duck = 0;
            $Wicket_bonus = 0;
            $catch_bonus = 0;
            $crpoints = 0;
            // new point system
            $thirtyPoints = 0;
            $bonuspoints = 0;

            if ($match == 't20') {

              if ($row->starting11 == 1 && $row->innings == 1) {

                $startingpoint = 4;
              } else {

                $startingpoint = 0;
              }

              $runs = $runs * 1;

              if ($findplayerrole != 'bowler') {

                if ($row->duck != 0 || $row->duck != "") {

                  $duck = -2;
                }
              }
              if ($wicket == 3) {

                $extrapoints = $extrapoints + 4;

                $bonuspoints = $bonuspoints + 4;
                $Wicket_bonus = $Wicket_bonus + 4;
              }

              if ($wicket == 4) {

                $extrapoints = $extrapoints + 8;

                $bonuspoints = $bonuspoints + 8;
                $Wicket_bonus = $Wicket_bonus + 8;
              }

              if ($wicket >= 5) {

                $extrapoints = $extrapoints + 16;

                $bonuspoints = $bonuspoints + 16;
                $Wicket_bonus = $Wicket_bonus + 16;
              }

              $wicket = $wicket * 25;
              if ($catch >= 3) {
                $extrapoints = $extrapoints + 4;
                $bonuspoints = $bonuspoints + 4;
                $catch_bonus = $catch_bonus + 4;
              }
              $catch = $catch * 8;




              $stumbed = $stumbed * 12;


              $runouts = $runouts * 12;
              $runout_catcher = $runout_catcher * 6;
              $runout_thrower = $runout_thrower * 6;
              $lbw_bowled = $lbw_bowled * 8;
              $boundary = $fours * 1;

              $six = $six * 2;

              if (($runs >= 50) && ($runs < 100)) {

                $extrapoints = $extrapoints + 8;

                $crpoints = $crpoints + 8;
              }

              if ($runs >= 100) {

                $extrapoints = $extrapoints + 16;

                $crpoints = $crpoints + 16;
              }


              if (($runs >= 30) && ($runs < 50)) {

                $extrapoints = $extrapoints + 4;

                $thirtyPoints = $thirtyPoints + 4;
              }


              $maiden_over = $maiden_over * 12;



              if ($balls >= 12) {

                //$economyrate = 2*(1.5*$balls - $grun);



                //$economyrate = 2*(1.5*$balls - $grun);

                //$total_over=($balls/6);

                $get_economyrate = $row->economy_rate;



                if ($get_economyrate > 12) {

                  $economyrate = '-6';
                } else if ($get_economyrate >= 11.1 && $get_economyrate <= 12) {

                  $economyrate = '-4';
                } else if ($get_economyrate >= 10 && $get_economyrate <= 11) {

                  $economyrate = '-2';
                } else if ($get_economyrate >= 6 && $get_economyrate <= 7) {

                  $economyrate = '2';
                } else if ($get_economyrate >= 5 && $get_economyrate <= 5.99) {

                  $economyrate = '4';
                } else if ($get_economyrate < 5) {

                  $economyrate = '6';
                } else {

                  $economyrate = '0';
                }

                //End

              }

              if ($bballs >= 10 && $findplayerrole != 'bowler') {

                $battingdots = $row->battingdots;

                $totalballs = $row->bball;

                $facedballls = $totalballs - $battingdots;

                //$strikerate = 2*($runs - $totalballs);

                $get_strikerate = ($runs / $totalballs) * 100;

                //Get Strike Rate

                if ($get_strikerate >= 60 && $get_strikerate <= 70) {

                  $strikerate = '-2';
                } else if ($get_strikerate >= 50 && $get_strikerate <= 59.99) {

                  $strikerate = '-4';
                } else if ($get_strikerate < 50) {

                  $strikerate = '-6';

                  //End

                } else if ($get_strikerate > 170) {
                  $strikerate = '6';
                } else if ($get_strikerate >= 150.01 && $get_strikerate <= 170) {
                  $strikerate = '4';
                } else if ($get_strikerate >= 130 && $get_strikerate <= 150) {
                  $strikerate = '2';
                }
              }
            } else if ($match == 't10') {

              if ($row->starting11 == 1 && $row->innings == 1) {

                $startingpoint = 4;
              } else {

                $startingpoint = 0;
              }

              $runs = $runs * 1;

              if ($findplayerrole != 'bowler') {

                if ($row->duck != 0 || $row->duck != "") {

                  $duck = -2;
                }
              }

              if ($wicket == 2) {

                $extrapoints = $extrapoints + 8;

                $bonuspoints = $bonuspoints + 8;
                $Wicket_bonus = $Wicket_bonus + 8;
              }

              if ($wicket >= 3) {

                $extrapoints = $extrapoints + 16;

                $bonuspoints = $bonuspoints + 16;
                $Wicket_bonus = $Wicket_bonus + 16;
              }

              $wicket = $wicket * 25;

              if ($catch >= 3) {
                $extrapoints = $extrapoints + 4;

                $bonuspoints = $bonuspoints + 4;
                $catch_bonus = $catch_bonus + 4;
              }
              $catch = $catch * 8;


              $stumbed = $stumbed * 12;

              $runouts = $runouts * 12;
              $runout_catcher = $runout_catcher * 6;
              $runout_thrower = $runout_thrower * 6;
              $lbw_bowled = $row->lbw_bowled * 8;
              $boundary = $fours * 1;

              $six = $six * 2;

              if (($runs >= 30) && ($runs < 50)) {

                $extrapoints = $extrapoints + 8;

                $crpoints = $crpoints + 8;
              }

              if ($runs >= 50) {

                $extrapoints = $extrapoints + 16;

                $crpoints = $crpoints + 16;
              }

              $maiden_over = $maiden_over * 16;



              if ($overs >= 1) {

                //$economyrate = 2*(1.5*$balls - $grun);



                //$economyrate = 2*(1.5*$balls - $grun);

                //$total_over=($balls/6);

                $get_economyrate = $row->economy_rate;



                if ($get_economyrate > 16) {

                  $economyrate = '-6';
                } else if ($get_economyrate >= 15.01 && $get_economyrate <= 16) {

                  $economyrate = '-4';
                } else if ($get_economyrate >= 14 && $get_economyrate <= 15) {

                  $economyrate = '-2';
                } else if ($get_economyrate >= 8 && $get_economyrate <= 9) {

                  $economyrate = '2';
                } else if ($get_economyrate >= 7 && $get_economyrate <= 7.99) {

                  $economyrate = '4';
                } else if ($get_economyrate < 7) {

                  $economyrate = '6';
                } else {

                  $economyrate = '0';
                }

                //End

              }



              if ($bballs >= 5 && $findplayerrole != 'bowler') {

                $battingdots = $row->battingdots;

                $totalballs = $row->bball;

                $facedballls = $totalballs - $battingdots;

                //$strikerate = 2*($runs - $totalballs);

                $get_strikerate = ($runs / $totalballs) * 100;

                //Get Strike Rate

                if ($get_strikerate >= 70 && $get_strikerate <= 80) {

                  $strikerate = '-2';
                } else if ($get_strikerate >= 60 && $get_strikerate <= 69.99) {

                  $strikerate = '-4';
                } else if ($get_strikerate < 60) {

                  $strikerate = '-6';

                  //End

                } else if ($get_strikerate > 190) {
                  $strikerate = '6';
                } else if ($get_strikerate >= 170.01 && $get_strikerate <= 190) {
                  $strikerate = '4';
                } else if ($get_strikerate >= 150 && $get_strikerate <= 170) {
                  $strikerate = '2';
                }
              }
            } else if ($match == 'one-day') {

              // print_r($row); exit;

              if ($row->starting11 == 1 && $row->innings == 1) {

                $startingpoint = 4;
              } else {

                $startingpoint = 0;
              }

              $runs = $runs * 1;

              if ($findplayerrole != 'bowler') {

                if ($row->duck != 0 || $row->duck != "") {

                  $duck = -3;
                }
              }

              if ($wicket == 4) {

                $extrapoints = $extrapoints + 4;

                $bonuspoints = $bonuspoints + 4;
                $Wicket_bonus = $Wicket_bonus + 4;
              }

              if ($wicket >= 5) {

                $extrapoints = $extrapoints + 8;

                $bonuspoints = $bonuspoints + 8;
                $Wicket_bonus = $Wicket_bonus + 8;
              }

              $wicket = $wicket * 25;
              if ($catch >= 3) {
                $extrapoints = $extrapoints + 4;

                $bonuspoints = $bonuspoints + 4;
                $catch_bonus = $catch_bonus + 4;
              }
              $catch = $catch * 8;

              $stumbed = $stumbed * 12;

              $runouts = $runouts * 12;
              $runout_catcher = $runout_catcher * 6;
              $runout_thrower = $runout_thrower * 6;
              $lbw_bowled = $row->lbw_bowled * 8;
              $boundary = $fours * 1;

              $six = $six * 2;

              if (($runs >= 50) && ($runs < 100)) {

                $extrapoints = $extrapoints + 4;

                $crpoints = $crpoints + 4;
              }

              if ($runs >= 100) {

                $extrapoints = $extrapoints + 4;

                $crpoints = $crpoints + 8;
              }

              $maiden_over = $maiden_over * 4;

              if ($overs >= 5) {

                //$economyrate =($balls - $grun);

                $get_economyrate = $row->economy_rate;



                if ($get_economyrate > 9) {

                  $economyrate = '-6';
                } else if ($get_economyrate >= 8.01 && $get_economyrate <= 9) {

                  $economyrate = '-4';
                } else if ($get_economyrate >= 7 && $get_economyrate <= 8) {

                  $economyrate = '-2';
                } else if ($get_economyrate >= 3.5 && $get_economyrate <= 4.5) {

                  $economyrate = '2';
                } else if ($get_economyrate >= 2.5 && $get_economyrate <= 3.49) {

                  $economyrate = '4';
                } else if ($get_economyrate < 2.5) {

                  $economyrate = '6';
                }

                //End

              }

              if ($bballs >= 20 && $findplayerrole != 'bowler') {

                $battingdots = $row->battingdots;

                $totalballs = $row->bball;

                $facedballls = $totalballs - $battingdots;

                //$strikerate = ($runs - $totalballs);

                $get_strikerate =  ($runs / $totalballs) * 100;

                //Get Strike Rate

                if ($get_strikerate >= 40 && $get_strikerate <= 50) {

                  $strikerate = '-2';
                } else if ($get_strikerate >= 30 && $get_strikerate <= 39.99) {

                  $strikerate = '-4';
                } else if ($get_strikerate < 30) {

                  $strikerate = '-6';

                  //End

                } else if ($get_strikerate > 140) {
                  $strikerate = '6';
                } else if ($get_strikerate >= 120.01 && $get_strikerate <= 140) {
                  $strikerate = '4';
                } else if ($get_strikerate >= 100 && $get_strikerate <= 120) {
                  $strikerate = '2';
                }
              }
            } else if ($match == 'hundred') {

              if ($row->starting11 == 1 && $row->innings == 1) {

                $startingpoint = 4;
              } else {

                $startingpoint = 0;
              }

              $runs = $runs * 1;

              if ($findplayerrole != 'bowler') {

                if ($row->duck != 0 || $row->duck != "") {

                  $duck = -2;
                }
              }

              if ($wicket == 2) {

                $extrapoints = $extrapoints + 3;

                $bonuspoints = $bonuspoints + 3;
              }
              if ($wicket == 3) {

                $extrapoints = $extrapoints + 5;

                $bonuspoints = $bonuspoints + 5;
              }
              if ($wicket == 4) {

                $extrapoints = $extrapoints + 10;

                $bonuspoints = $bonuspoints + 10;
              }

              if ($wicket >= 5) {

                $extrapoints = $extrapoints + 20;

                $bonuspoints = $bonuspoints + 20;
              }

              $wicket = $wicket * 25;
              if ($catch >= 3) {
                $extrapoints = $extrapoints + 4;
                $bonuspoints = $bonuspoints + 4;
              }
              $catch = $catch * 8;




              $stumbed = $stumbed * 12;


              $runouts = $runouts * 12;
              $runout_catcher = $runout_catcher * 6;
              $runout_thrower = $runout_thrower * 6;
              $lbw_bowled = $lbw_bowled * 8;
              $boundary = $fours * 1;

              $six = $six * 2;

              if (($runs >= 50) && ($runs < 100)) {

                $extrapoints = $extrapoints + 10;

                $crpoints = $crpoints + 10;
              }

              if ($runs >= 100) {

                $extrapoints = $extrapoints + 20;

                $crpoints = $crpoints + 20;
              }


              if (($runs >= 30) && ($runs < 50)) {

                $extrapoints = $extrapoints + 5;

                $thirtyPoints = $thirtyPoints + 5;
              }


              // $maiden_over = $maiden_over*12;



              if ($balls >= 12) {

                //$economyrate = 2*(1.5*$balls - $grun);



                //$economyrate = 2*(1.5*$balls - $grun);

                //$total_over=($balls/6);

                $get_economyrate = $row->economy_rate;



                if ($get_economyrate > 12) {

                  // $economyrate='-6';

                } else if ($get_economyrate >= 11.1 && $get_economyrate <= 12) {

                  // $economyrate='-4';

                } else if ($get_economyrate >= 10 && $get_economyrate <= 11) {

                  // $economyrate='-2';

                } else if ($get_economyrate >= 6 && $get_economyrate <= 7) {

                  // $economyrate='2';

                } else if ($get_economyrate >= 5 && $get_economyrate <= 5.99) {

                  // $economyrate='4';

                } else if ($get_economyrate < 5) {

                  // $economyrate='6';

                } else {

                  // $economyrate='0';

                }

                //End

              }

              if ($bballs >= 10 && $findplayerrole != 'bowler') {

                $battingdots = $row->battingdots;

                $totalballs = $row->bball;

                $facedballls = $totalballs - $battingdots;

                //$strikerate = 2*($runs - $totalballs);

                $get_strikerate = ($runs / $totalballs) * 100;

                //Get Strike Rate

                if ($get_strikerate >= 60 && $get_strikerate <= 70) {

                  // $strikerate='-2';

                } else if ($get_strikerate >= 50 && $get_strikerate <= 59.99) {

                  // $strikerate='-4';

                } else if ($get_strikerate < 50) {

                  // $strikerate='-6';

                  //End

                } else if ($get_strikerate > 170) {
                  // $strikerate = '6';
                } else if ($get_strikerate >= 150.01 && $get_strikerate <= 170) {
                  // $strikerate = '4';
                } else if ($get_strikerate >= 130 && $get_strikerate <= 150) {
                  // $strikerate = '2';
                }
              }
              $maiden_over = 0;
            }
            //
            // else if($match == 't10'){
            //
            //   if($row->starting11==1 && $row->innings==1){
            //
            //     $startingpoint = 4;
            //
            //   }
            //
            //   else{
            //
            //     $startingpoint = 0;
            //
            //   }
            //
            //   $runs = $runs*1;
            //
            //   if($findplayerrole!='bowler'){
            //
            //     if($row->duck!=0 || $row->duck!=""){
            //
            //       $duck = -2;
            //
            //     }
            //
            //   }
            //
            //   if($wicket==2){
            //
            //     $extrapoints = $extrapoints+8;
            //
            //     $bonuspoints=$bonuspoints+8;
            //
            //   }
            //
            //   if($wicket>=3){
            //
            //     $extrapoints = $extrapoints+16;
            //
            //     $bonuspoints=$bonuspoints+16;
            //
            //   }
            //
            //   $wicket = $wicket*25;
            //
            //   $catch = $catch*8;
            //
            //   $stumbed = $stumbed*12;
            //
            //   $runouts = $runouts*12;
            //   $runout_catcher = $runout_catcher*6;
            //   $runout_thrower = $runout_thrower*6;
            //
            //   $boundary = $fours*1;
            //
            //   $six = $six*2;
            //
            //   if(($runs>=30) && ($runs<=50)){
            //
            //     $extrapoints = $extrapoints+ 8;
            //
            //     $crpoints = $crpoints+8;
            //
            //   }
            //
            //   if($runs>=50){
            //
            //     $extrapoints =$extrapoints + 16;
            //
            //     $crpoints = $crpoints+16;
            //
            //   }
            //
            //   $maiden_over = $maiden_over*16;
            //
            //
            //
            //   if($overs>=1){
            //
            //     //$economyrate = 2*(1.5*$balls - $grun);
            //
            //
            //
            //     //$economyrate = 2*(1.5*$balls - $grun);
            //
            //     //$total_over=($balls/6);
            //
            //     $get_economyrate=$row->economy_rate;
            //
            //
            //
            //     if($get_economyrate >13){
            //
            //       $economyrate='-6';
            //
            //     }else if($get_economyrate >=12.01 && $get_economyrate <=13){
            //
            //                       $economyrate='-4';
            //
            //     }else if($get_economyrate >=11 && $get_economyrate <=12){
            //
            //                       $economyrate='-2';
            //
            //     }else if($get_economyrate >=7 && $get_economyrate <=8){
            //
            //                       $economyrate='2';
            //
            //     }else if($get_economyrate >=6.00 && $get_economyrate <=6.99){
            //
            //         $economyrate='4';
            //
            //     }else if($get_economyrate < 6){
            //
            //                       $economyrate='6';
            //
            //     } else {
            //
            //       $economyrate='0';
            //
            //     }
            //
            //     //End
            //
            //   }
            //
            //   if($bballs>=5 && $findplayerrole!='bowler'){
            //
            //     $battingdots = $row->battingdots;
            //
            //     $totalballs = $row->bball;
            //
            //     $facedballls = $totalballs - $battingdots;
            //
            //     //$strikerate = 2*($runs - $totalballs);
            //
            //     $get_strikerate = ($runs/$totalballs)*100;
            //
            //                  //Get Strike Rate
            //
            //                  if($get_strikerate >=90 && $get_strikerate <=99.99){
            //
            //                   $strikerate='-2';
            //
            //                  }else if($get_strikerate >=80 && $get_strikerate <=89.9){
            //
            //                    $strikerate='-4';
            //
            //                  }else if($get_strikerate < 80){
            //
            //                    $strikerate='-6';
            //
            //                  //End
            //
            //                  }
            //
            //   }
            //
            // }

            else {

              if ($row->starting11 == 1 && $row->innings == 1) {

                $startingpoint = 4;
              } else {

                $startingpoint = 0;
              }

              $runs = $runs * 1;

              if ($findplayerrole != 'bowler') {

                if ($row->duck != 0 || $row->duck != "") {

                  $duck = -4;
                }
              }

              if ($wicket == 4) {

                $extrapoints = $extrapoints + 4;

                $bonuspoints = $bonuspoints + 4;
              }

              if ($wicket >= 5) {

                $extrapoints = $extrapoints + 8;

                $bonuspoints = $bonuspoints + 8;
              }

              $wicket = $wicket * 16;

              $catch = $catch * 8;

              $stumbed = $stumbed * 12;

              $runouts = $runouts * 12;
              $runout_catcher = $runout_catcher * 6;
              $runout_thrower = $runout_thrower * 6;
              $lbw_bowled = $row->lbw_bowled * 8;
              $boundary = $fours * 1;

              $six = $six * 2;

              if (($runs >= 50) && ($runs <= 100)) {

                $extrapoints = $extrapoints + 4;

                $crpoints = $crpoints + 4;
              }

              if ($runs >= 100) {

                $extrapoints = $extrapoints + 8;

                $crpoints = $crpoints + 8;
              }

              $maiden_over = 0;
            }

            if ($row->starting11 == 1) {

              $result['batting_points'] = $runs + $six + $fours + $strikerate + $crpoints + $thirtyPoints;

              $result['fielding_points'] = $catch + $stumbed;

              $result['bowling_points'] = $wicket + $maiden_over + $economyrate + $lbw_bowled;

              $result['negative_points'] = $duck;

              $result['extra_points'] = $bonuspoints;
              $startingpoint = !empty($startingpoint) ? $startingpoint : 4;
              $result['total_points'] = $total_points = $startingpoint + $runs + $wicket + $catch + $stumbed + $boundary + $six + $bonuspoints + $economyrate + $strikerate + $maiden_over + $duck + $crpoints + $runouts + $runout_catcher + $runout_thrower + $lbw_bowled + $thirtyPoints;
            } else {

              $result['batting_points'] = 0;

              $result['fielding_points'] = 0;

              $result['bowling_points'] = 0;

              $result['negative_points'] = 0;

              $result['extra_points'] = 0;

              $result['total_points'] = 0;
            }



            DB::table('result_matches')->where('player_key', $player_key)->where('match_key', $match_key)->where('innings', $row->innings)->update($result);

            //insert in result points//

            $resultpoints['matchkey'] = $match_key;

            $resultpoints['playerid'] = $findplayerid->id;

            if ($row->starting11 == 1) {

              $resultpoints['startingpoints'] = 4;

              $resultpoints['runs'] = $runs;

              $resultpoints['fours'] = $boundary;

              $resultpoints['sixs'] = $six;

              $resultpoints['strike_rate'] = $strikerate;

              $resultpoints['century'] = $crpoints;

              $resultpoints['wickets'] = $wicket;

              $resultpoints['maidens'] = $maiden_over;

              $resultpoints['economy_rate'] = $economyrate;

              $resultpoints['catch'] = $catch;

              $resultpoints['stumping'] = $stumbed;
              $resultpoints['runouts'] = $runouts;
              $resultpoints['runout_catcher'] = $runout_catcher;
              $resultpoints['runout_thrower'] = $runout_thrower;
              $resultpoints['lbw_bowled'] = $lbw_bowled;
              $resultpoints['catch_bonus'] = $catch_bonus;
              $resultpoints['wicket_bonus'] = $Wicket_bonus;

              $resultpoints['thirty_runs'] = $thirtyPoints;

              $resultpoints['bonus'] = $bonuspoints;

              $resultpoints['negative'] = $duck;
              $resultpoints['duck'] = $duck;

              $resultpoints['total'] = $total_points;
            } else {

              $resultpoints['startingpoints'] = 0;

              $resultpoints['runs'] = 0;

              $resultpoints['fours'] = 0;

              $resultpoints['sixs'] = 0;

              $resultpoints['strike_rate'] = 0;

              $resultpoints['century'] = 0;

              $resultpoints['wickets'] = 0;

              $resultpoints['maidens'] = 0;

              $resultpoints['economy_rate'] = 0;

              $resultpoints['catch'] = 0;

              $resultpoints['stumping'] = 0;

              $resultpoints['bonus'] = 0;
              $resultpoints['catch_bonus'] = 0;
              $resultpoints['wicket_bonus'] = 0;
              $resultpoints['negative'] = 0;

              $resultpoints['total'] = 0;
            }
            // if($findplayerid->id==2227){
            //     echo "<pre>";  print_r($resultpoints); exit;
            // }


            $finde = DB::table('result_points')->where('matchkey', $match_key)->where('playerid', $findplayerid->id)->where('resultmatch_id', $row->id)->select('id')->first();
            if (!empty($finde)) {

              // DB::table('result_points')->where('id',$finde->id)->delete();
            }

            if (empty($finde)) {

              $resultpoints['resultmatch_id'] = $row->id;

              DB::table('result_points')->insert($resultpoints);
            } else {

              DB::table('result_points')->where('id', $finde->id)->update($resultpoints);
            }

            // echo 'yes'; exit;

            // print_r(expression)

          }
          $this->updateplayerpoints($match_key);
        }
    }
  }


  public function updateplayerpoints($match_key)
  {
    $findallplayers = DB::table('matchplayers')->join('players', 'players.id', '=', 'matchplayers.playerid')->where('matchkey', $match_key)->select('matchplayers.*', 'players.player_key')->get();
    $player_id = 0;
    if (!empty($findallplayers)) {
      foreach ($findallplayers as $player) {
        $findtotalpoints = DB::table('result_points')->join('result_matches', 'result_matches.id', '=', 'result_points.resultmatch_id')->where('result_points.matchkey', $match_key)->where('result_matches.player_key', $player->player_key)->sum('result_points.total');
        //   if($player->id=='28822'){
        //    $player_id = $player->id;
        // }
        $data['points'] = $findtotalpoints;

        DB::table('matchplayers')->where('id', $player->id)->update($data);
      }
      //   if($player_id=='28822'){
      //     $findallp = DB::table('matchplayers')->join('players','players.id','=','matchplayers.playerid')->where('matchkey',$match_key)
      //     ->where('matchplayers.id','28822')
      //     ->select('matchplayers.*','players.player_key')
      //     ->first();
      //       echo "adasd<pre>"; print_r($findallp); exit;
      //
      // }
      MatchesController::userpoints($match_key);
    }
  }

  public function userpoints($match_key)
  {
    $joinlist = DB::table('jointeam')->where('matchkey', $match_key)->get();

    if (!empty($joinlist)) {

      $i = 0;

      $matchplayers = DB::table('matchplayers')->where('matchkey', $match_key)->get();
      $result = array();
      foreach ($joinlist as $row2) {

        $user_points = 0;

        $players = explode(',', $row2->players);



        if (!empty($matchplayers)) {

          foreach ($matchplayers as $row) {

            $pid = $row->playerid;

            if (in_array($pid, $players)) {

              if ($row2->captain == $pid) {

                $user_points = $user_points + ($row->points * 2);
              } else if ($row2->vicecaptain == $pid) {

                $user_points = $user_points + ($row->points * 1.5);
              } else {

                $user_points = $user_points + $row->points;
              }
            } else {

              $user_points = $user_points;
            }
          }
        }

        if ($row2->points != $user_points) {

          $result[$i]['lastpoints'] = $row2->points;
        }

        $result[$i]['points'] = $user_points;

        $result[$i]['id'] = $row2->id;

        // DB::table('jointeam')->where('id',$row2->id)->update($result);

        $i++;
      }

      if (!empty($result)) {
        $new_result = array_chunk($result, 2000);

        foreach ($new_result as $rkey => $rvalue) {
          // MatchesController::updateDisplayIndex($result);
          MatchesController::updateDisplayIndex($rvalue);
        }
      }

      // print_r($result); exit;



    }

    MatchesController::update_leaderboard($match_key);
  }

  public function updateDisplayIndex(array $values)

  {

    $caseString = 'case id';

    $ids = '';

    foreach ($values as $value) {

      $id = $value['id'];

      $displayIndex = $value['points'];

      $caseString .= " when $id then $displayIndex";

      $ids .= " $id,";
    }

    $ids = trim($ids, ',');

    // print_r($caseString); exit;

    DB::update("update jointeam set points = $caseString end where id in ($ids)");

    return;
  }

  public function powerplay_points($matchkey, $team_id, $players)
  {
    /*$powerplay_overs = DB::table('powerplay')->where('team_id')->get();
        if(!empty($powerplay_overs)) {
            $overs = array();
            foreach ($powerplay_overs as $key => $value) {
              $overs[$value->inning][] = $value;
            }
            // Calculate Powerplay Points
            $points = 0;
            foreach ($overs as $key => $value) {
              foreach ($value as $key2 => $value2) {
                $start = $value2->start;
                $end = $value2->end;
                $overss = range($start, $end);
                $points += DB::table('players_overs_points')->whereIn('over', $overss)->where('inning', $key)->where('matchkey', $matchkey)->whereIn('player_id', $players)->sum('point');
              }
            }
            if($points) {
              return $points;
            }
          }
          return 0;*/
  }

  public function update_leaderboard($matchkey)
  {
    // return 'here';
    date_default_timezone_set('Asia/Kolkata');
    sleep(1);
    $listmatchdetail = DB::table('listmatches')
      ->where('matchkey', $matchkey)
      // ->where('sport_type', $sport_type)
      ->select('final_status', 'status', 'start_date', 'sport_type')
      ->first();

    $log = DB::statement('INSERT INTO leaderboard (challenge_id, user_id, team_id, team_number, team_name, points, `rank`, join_id, sport_type, arrowname) SELECT challengeid, jl.userid, jl.teamid, jt.teamnumber, r.team, jt.points, "0" as userrank, jl.id, jl.sport_type,"up-arrow" as arrowname FROM joinedleauges as jl JOIN jointeam as jt ON jt.id = jl.teamid JOIN registerusers as r ON r.id = jl.userid WHERE jl.matchkey = "' . $matchkey . '" AND jl.sport_type = ' . $listmatchdetail->sport_type . ' ON DUPLICATE KEY UPDATE leaderboard.points = jt.points');
    sleep(2);
    $this->update_leaderboard_rank($matchkey, $listmatchdetail->sport_type);

    return;
  }

  public function update_leaderboard_old_keshav_12_dec($matchkey)
  {
    ini_set('max_execution_time', -1);
    //$matchkey = $data['matchkey'] =  $_GET['matchkey'];
    $listmatchdetail = DB::table('listmatches')->where('matchkey', $matchkey)->select('final_status', 'status')->first();
    // echo "<pre>";print_r($listmatchdetail);die;
    if ($listmatchdetail->final_status == 'winnerdeclared') {
    } else {
      $matchchallenges = DB::table('matchchallenges')
        ->where('matchchallenges.status', '!=', 'canceled')
        ->where('matchchallenges.matchkey', $matchkey)
        ->select('id')
        ->get();
      // print_r($matchchallenges);die;
      $challarr = array();
      foreach ($matchchallenges as $key => $value) {
        $challarr[] = $value->id;
      }
      $resjoinedteams =  DB::table('joinedleauges')
        ->whereIn('joinedleauges.challengeid', $challarr)
        ->join('registerusers', 'registerusers.id', '=', 'joinedleauges.userid')
        ->join('jointeam', 'jointeam.id', '=', 'joinedleauges.teamid')
        ->orderBy('jointeam.points', 'DESC')
        ->select('joinedleauges.challengeid', 'registerusers.team', 'registerusers.email', 'jointeam.teamnumber', 'jointeam.points', 'jointeam.lastpoints', 'joinedleauges.id as jid', 'joinedleauges.userid', 'joinedleauges.teamid')
        ->get();
      // print_r($resjoinedteams);die;
      foreach ($resjoinedteams as $row) {
        $joinedteamsarr[$row->challengeid][] = $row;
      }
      $i = 0;
      $Json = array();
      foreach ($matchchallenges as $key2 => $joined) {
        $i = $joined->id;
        $findjoinedteams = (isset($joinedteamsarr[$joined->id])) ? $joinedteamsarr[$joined->id] : [];

        $gtlastranks = array();
        $getcurrentrankarray = array();
        $ss = 0;
        if (!empty($findjoinedteams)) {
          foreach ($findjoinedteams as $pleauges) {
            $gtlastranks[$ss]['lastpoints'] = $pleauges->lastpoints;
            $gtlastranks[$ss]['userid'] = $pleauges->userid;
            $gtlastranks[$ss]['userjoinid'] = $pleauges->jid;
            $getcurrentrankarray[$ss]['points'] = $pleauges->points;
            $getcurrentrankarray[$ss]['userid'] = $pleauges->userid;
            $getcurrentrankarray[$ss]['userjoinid'] = $pleauges->jid;
            $ss++;
          }
        }
        $gtlastranks = $this->multid_sort($gtlastranks, 'lastpoints');
        if (!empty($gtlastranks)) {
          $getuserlastrank = array();
          $lr = 0;
          $lrsno = 0;
          $uplus = 0;
          foreach ($gtlastranks as $lrnk) {
            if (in_array($lrnk['lastpoints'], array_column($getuserlastrank, 'points'))) { // search value in the array
              $lrsno++;
              $lrsno = $lrsno + $uplus;
              $uplus = 0;
            } else {
              $lrsno++;
            }
            $getuserlastrank[$lr]['rank'] = $lrsno;
            $getuserlastrank[$lr]['points'] = $lrnk['lastpoints'];
            $getuserlastrank[$lr]['userid'] = $lrnk['userid'];
            $getuserlastrank[$lr]['userjoinid'] = $lrnk['userjoinid'];
            $lr++;
          }
        }
        //get current ranks//
        $gtcurranks = $this->multid_sort($getcurrentrankarray, 'points');
        if (!empty($gtcurranks)) {
          $getusercurrank = array();
          $cur = 0;
          $currsno = 0;
          $plus = 0;
          foreach ($gtcurranks as $curnk) {
            if (!in_array($curnk['points'], array_column($getusercurrank, 'points'))) { // search value in the array
              $currsno++;
              $currsno = $currsno + $plus;
              $plus = 0;
            } else {
              $plus++;
            }
            $getusercurrank[$cur]['rank'] = $currsno;
            $getusercurrank[$cur]['points'] = $curnk['points'];
            $getusercurrank[$cur]['userid'] = $curnk['userid'];
            $getusercurrank[$cur]['userjoinid'] = $curnk['userjoinid'];
            $cur++;
          }
        } //End Function

        /* Genrate Lederboard */
        if (!empty($findjoinedteams)) {
          $k = 0;
          $userrank = 1;
          $userslistsno = -1;
          $userrankarray = array();
          $pdfname = "";
          foreach ($findjoinedteams as $jointeam) {
            if ($jointeam->team != "") {
              $Json[$i]['jointeams'][$k]['team_name'] = ucwords($jointeam->team);
            } else {
              $Json[$i]['jointeams'][$k]['team_name'] = $jointeam->email;
            }
            $Json[$i]['jointeams'][$k]['team_id'] = $jointeam->teamid;
            $Json[$i]['jointeams'][$k]['team_number'] = $jointeam->teamnumber;

            $Json[$i]['jointeams'][$k]['points'] = $jointeam->points;
            $getuserindexinglast = $this->searchByValue($getuserlastrank, 'userjoinid', $jointeam->jid);
            $getlastrank = $getuserlastrank[$getuserindexinglast]['rank'];
            $getuserindexingcurent = $this->searchByValue($getusercurrank, 'userjoinid', $jointeam->jid);
            $getcurrentrank = $getusercurrank[$getuserindexingcurent]['rank'];
            $Json[$i]['jointeams'][$k]['rank'] = $getcurrentrank;
            if ($getlastrank < $getcurrentrank) {
              $Json[$i]['jointeams'][$k]['arrowname'] = 'down-arrow';
            } else if ($getlastrank == $getcurrentrank) {
              $Json[$i]['jointeams'][$k]['arrowname'] = 'equal-arrow';
            } else if ($getlastrank > $getcurrentrank) {
              $Json[$i]['jointeams'][$k]['arrowname'] = 'up-arrow';
            }
            $Json[$i]['jointeams'][$k]['join_id'] = $jointeam->jid;
            $Json[$i]['jointeams'][$k]['user_id'] = $jointeam->userid;
            $Json[$i]['jointeams'][$k]['challenge_id'] = $i;


            $k++;
          }
          //array_multisort(array_column($Json[$i]['jointeams'],'userno'),SORT_ASC,array_column($Json[$i]['jointeams'],'points'),SORT_DESC,$Json[$i]['jointeams']);
        } //print_r($Json); exit;
        /* Genrate Lederboard */
        if (!empty($Json[$i]['jointeams'])) {
          //$leaderboard_exist = DB::table('leaderboard')->where('challenge_id',$i)->get();
          //if(empty($leaderboard_exist)) {
          // if($joined->id =='456960')
          // {


          $this->insertOrUpdate($Json[$i]['jointeams'], 'leaderboard');
          //}

          // DB::table('leaderboard')->insert($Json[$i]['jointeams']);
          //} else {
          // foreach ($Json[$i]['jointeams'] as $teams) { //print_r($teams);
          //  DB::table('leaderboard')->where('join_id', $teams['join_id'])->update($teams);
          // }
          //}
        }
      }
      //print_r($Json); exit;
      return;
    }
  }


  public function update_leaderboard_rank($matchkey, $sport_type = 1)
  {
    // return;
    // echo 'yes'; exit;
    //$matchkey = $data['matchkey'] =  $_GET['matchkey'];
    $listmatchdetail = DB::table('listmatches')->where('matchkey', $matchkey)->where('sport_type', $sport_type)->select('final_status', 'status')->first();
    DB::statement('CALL update_rank("' . $matchkey . '", ' . $sport_type . ')');
    return true;
  }


  public function multid_sort($arr, $index)
  {
    $b = array();
    $c = array();
    foreach ($arr as $key => $value) {
      $b[$key] = $value[$index];
    }
    arsort($b);
    foreach ($b as $key => $value) {
      $c[] = $arr[$key];
    }
    return $c;
  }

  public function searchByValue($products, $field, $value)
  {
    foreach ($products as $key => $product) {
      if ($product[$field] === $value)
        return $key;
    }
    return false;
  }


  public function refund_amount($match_key = '60919_2', $sport_type = '1')
  {

    date_default_timezone_set('Asia/Kolkata');
    $listmatches = DB::table('listmatches')
      ->where('matchkey', $match_key)
      ->where('sport_type', $sport_type)
      ->first();
    $getcurrentdate = date('Y-m-d H:i:s');
    if (!empty($listmatches)) {
      $matchtimings = @$listmatches->start_date;
    }

    // echo $getcurrentdate ."<".$matchtimings; exit;
    if ($getcurrentdate < $matchtimings) {
      // echo 1; exit;
      return true;
    }
    // exit;
    // echo $listmatches->refund; exit;
    if ($listmatches->refund == 1) {
      return true;
    }
    // echo 1; exit;

    $joinedleauges = DB::table('joinedleauges')
      ->where('matchkey', $match_key)
      ->where('sport_type', $sport_type)
      ->select('challengeid', 'userid', 'id')
      ->groupBy('challengeid')->get();
    foreach ($joinedleauges as $val1) {
      $matchchallenges = DB::table('matchchallenges')
        ->where('id', $val1->challengeid)
        ->where('status', '!=', 'canceled')->get();
      // echo "<pre>"; print_r($matchchallenges); exit;
      foreach ($matchchallenges as $val2) {
        if (($val2->maximum_user > $val2->joinedusers && $val2->challenge_type == 'money') || ($val2->challenge_type == 'percentage' &&  $val2->joinedusers < $val2->minimum_user)) {
          if ($val2->entryfee > 0 &&  $val2->win_amount > 0) {
            if ($val2->joinedusers > 1 && $val2->is_flexible == 1) {
              //$this->set_flexy_league_auto($match_key,$val1->challengeid,'auto');
              continue;
            }
          }

          if ($val2->entryfee == 0 && $val2->win_amount == 0 && $val2->is_private == 1) {
            continue;
          }
          //if($val2->confirmed_challenge==0 || ($val2->confirmed_challenge==1 && $val2->joinedusers == 1) ){
          if ($val2->confirmed_challenge == 0 &&  $val2->joinedusers < $val2->minimum_user) {
            if ($match_key == 'c.match.kista_cricket_club_vs_stockholm_mumbai_indians.0ce83') {
              $league_match_key = 'c.match.kista_cricket_club_vs_stockholm_mumbai_ind';
            } else {
              $league_match_key = $match_key;
            }
            // echo($league_match_key);DIE;
            $leaugestransactions = DB::table('leaugestransactions')
              ->where('matchkey', $league_match_key)
              ->where('challengeid', $val1->challengeid)->get();
            // dd($leaugestransactions);
            foreach ($leaugestransactions as $val3) {
              $entryfee = $val2->entryfee;
              $findlastow = DB::table('userbalances')->where('user_id', $val3->user_id)->first();
              if (!empty($findlastow)) {
                $dasts['status'] = 'canceled';
                DB::table('matchchallenges')->where('id', $val2->id)->update($dasts);
                // entry in refund //
                $refunddata['userid'] = $val3->user_id;
                $refunddata['amount'] = $entryfee;
                $refunddata['joinid'] = $val3->joinid;
                $refunddata['challengeid'] = $val3->challengeid;
                $refunddata['reason'] = 'Challenge cancel';
                $refunddata['matchkey'] = $match_key;
                //$findifalreadyrefund = DB::table('refunds')->where('joinid',$val3->joinid)->first();
                try {
                  DB::table('refunds')->insert($refunddata); // end entry in refund data//

                  //Update User Balance

                  $balanceDeductUpdate = array(
                    "winning" => DB::raw("winning + " . $val3->winning),
                    "balance" => DB::raw("balance + " . $val3->balance),
                    "bonus" => DB::raw("bonus + " . $val3->bonus),
                    "gst_bonus" => DB::raw("gst_bonus + " . $val3->gst_bonus),
                    "affiliation_commission" => DB::raw("affiliation_commission + " . $val3->affiliation_commission),
                  );
                  DB::table('userbalances')->where('user_id', $val3->user_id)->update($balanceDeductUpdate);
                  $findlastow = DB::table('userbalances')->where('user_id', $val3->user_id)->first();


                  //transactions//
                  $registeruserdetails = DB::table('registerusers')->where('id', $val3->user_id)->first();
                  $datatr['transaction_id'] = 'PlaynWin11-REFUND-' . rand(100, 999) . $val3->user_id;
                  $datatr['type'] = 'Refund amount';
                  $datatr['transaction_by'] = 'PlaynWin11';
                  $datatr['amount'] = $entryfee;
                  $datatr['paymentstatus'] = 'confirmed';
                  $datatr['challengeid'] = $val3->challengeid;
                  $datatr['bonus_amt'] = $val3->bonus;
                  $datatr['gst_bonus_amt'] = $val3->gst_bonus;
                  $datatr['win_amt'] = $val3->winning;
                  $datatr['affiliation_amount'] = $val3->affiliation_commission;
                  $datatr['addfund_amt'] = $val3->balance;
                  $datatr['bal_bonus_amt'] = $findlastow->bonus;
                  $datatr['bal_win_amt'] = $findlastow->winning;
                  $datatr['bal_gst_bonus_amt'] = $findlastow->gst_bonus;
                  $datatr['bal_fund_amt'] = $findlastow->balance;
                  $datatr['bal_affi_amt'] = @$findlastow->affiliation_commission;
                  $datatr['userid'] = $val3->user_id;
                  // $datatr['total_available_amt'] = $dataq['balance']+$dataq['winning']+$dataq['bonus'];
                  $datatr['total_available_amt'] = $findlastow->balance + $findlastow->winning + $findlastow->bonus + $findlastow->gst_bonus + @$findlastow->affiliation_commission;
                  DB::table('transactions')->insert($datatr);
                  //mail//
                  $challengename = "";
                  if ($val2->name != "") {
                    $challengename = $val2->name;
                  } else {
                    $challengename = 'Win-' . $val2->win_amount;
                  }
                  // $email = $registeruserdetails->email;
                  // $emailsubject = 'Challenge Cancelled-Refund initiated!';
                  // $content='<p><strong>Dear Challenger </strong></p>';
                  // $content.='<p>Unfortunately the challenge '.$challengename.' of match '.date('M d Y h:i:a',strtotime($listmatches->start_date)).' '.$listmatches->title.' has cancelled due to lack of users and your entry fee for the match is getting refunded back to your CLUB11 wallet.</p>';
                  // $msg = Helpers::mailheader();
                  // $msg.= Helpers::mailbody($content);
                  // $msg.= Helpers::mailfooter();
                  // Helpers::mailsentFormat($email,$emailsubject,$msg);
                  //notifications//
                  $datan['title'] = 'Refund Amount of ₹' . $val2->entryfee . ' for challenge cancellation';
                  $datan['userid'] = $val3->user_id;
                  DB::table('notifications')->insert($datan);
                } catch (\Illuminate\Database\QueryException $ex) {
                  // echo $ex->getMessage();
                  // echo 'yes'; exit;
                  continue;
                }
              }
            }
          } else if ($val2->confirmed_challenge == 0  && $val2->joinedusers == 1) {
            if ($match_key == 'c.match.kista_cricket_club_vs_stockholm_mumbai_indians.0ce83') {
              $league_match_key = 'c.match.kista_cricket_club_vs_stockholm_mumbai_ind';
            } else {
              $league_match_key = $match_key;
            }
            $leaugestransactions = DB::table('leaugestransactions')
              ->where('matchkey', $league_match_key)
              ->where('challengeid', $val1->challengeid)->get();

            foreach ($leaugestransactions as $val3) {
              $entryfee = $val2->entryfee;
              $findlastow = DB::table('userbalances')->where('user_id', $val3->user_id)->first();
              if (!empty($findlastow)) {
                $dasts['status'] = 'canceled';
                DB::table('matchchallenges')->where('id', $val2->id)->update($dasts);
                // entry in refund //
                $refunddata['userid'] = $val3->user_id;
                $refunddata['amount'] = $entryfee;
                $refunddata['joinid'] = $val3->joinid;
                $refunddata['challengeid'] = $val3->challengeid;
                $refunddata['reason'] = 'Challenge cancel';
                $refunddata['matchkey'] = $match_key;

                try {
                  DB::table('refunds')->insert($refunddata);

                  $balanceDeductUpdate = array(
                    "winning" => DB::raw("winning + " . $val3->winning),
                    "balance" => DB::raw("balance + " . $val3->balance),
                    "bonus" => DB::raw("bonus + " . $val3->bonus),
                    "gst_bonus" => DB::raw("gst_bonus + " . $val3->gst_bonus),
                    "affiliation_commission" => DB::raw("affiliation_commission + " . $val3->affiliation_commission),
                  );
                  DB::table('userbalances')->where('user_id', $val3->user_id)->update($balanceDeductUpdate);
                  $findlastow = DB::table('userbalances')->where('user_id', $val3->user_id)->first();

                  //transactions//
                  $registeruserdetails = DB::table('registerusers')->where('id', $val3->user_id)->first();
                  $datatr['transaction_id'] = 'PlaynWin11-REFUND-' . rand(100, 999) . $val3->user_id;
                  $datatr['type'] = 'Refund amount';
                  $datatr['transaction_by'] = 'PlaynWin11';
                  $datatr['amount'] = $entryfee;
                  $datatr['paymentstatus'] = 'confirmed';
                  $datatr['challengeid'] = $val3->challengeid;
                  $datatr['bonus_amt'] = $val3->bonus;
                  $datatr['gst_bonus_amt'] = $val3->gst_bonus;
                  $datatr['win_amt'] = $val3->winning;
                  $datatr['affiliation_amount'] = $val3->affiliation_commission;
                  $datatr['addfund_amt'] = $val3->balance;
                  $datatr['bal_bonus_amt'] = $findlastow->bonus;
                  $datatr['bal_win_amt'] = $findlastow->winning;
                  $datatr['bal_gst_bonus_amt'] = $findlastow->gst_bonus;
                  $datatr['bal_fund_amt'] = $findlastow->balance;
                  $datatr['bal_affi_amt'] = @$findlastow->affiliation_commission;
                  $datatr['userid'] = $val3->user_id;

                  $datatr['total_available_amt'] = $findlastow->balance + $findlastow->winning + $findlastow->bonus + $findlastow->gst_bonus + @$findlastow->affiliation_commission;
                  DB::table('transactions')->insert($datatr);

                  $challengename = "";
                  if ($val2->name != "") {
                    $challengename = $val2->name;
                  } else {
                    $challengename = 'Win-' . $val2->win_amount;
                  }

                  $datan['title'] = 'Refund Amount of ₹' . $val2->entryfee . ' for challenge cancellation';
                  $datan['userid'] = $val3->user_id;
                  DB::table('notifications')->insert($datan);
                } catch (\Illuminate\Database\QueryException $ex) {
                  // echo $ex->getMessage();
                  // echo 'yes'; exit;
                  continue;
                }
              }
            }
          }
        }
      }
    }

    if ($getcurrentdate > date('Y-m-d H:i:s', strtotime('+15 minutes', strtotime($matchtimings)))) {
      DB::table('listmatches')->where('id', $listmatches->id)->update(array("refund" => 1));
    }
    // echo 1; exit;
    //return 1;
  }


  public function refund_amount_old($match_key)
  {

    date_default_timezone_set('Asia/Kolkata');

    $joinedleauges = DB::table('joinedleauges')->where('matchkey', $match_key)->select('challengeid', 'userid', 'id')->groupBy('challengeid')->get();
    $listmatches = DB::table('listmatches')->where('matchkey', $match_key)->first(); //

    // print_r($listmatches);

    $getcurrentdate = date('Y-m-d H:i:s');
    // echo $getcurrentdate;
    $matchtimings = $listmatches->start_date;

    if ($getcurrentdate < $matchtimings) {
      return true;
    }

    foreach ($joinedleauges as $val1) {
      $matchchallenges = DB::table('matchchallenges')->where('id', $val1->challengeid)->where('status', '!=', 'canceled')->get();
      foreach ($matchchallenges as $val2) {
        if (($val2->maximum_user > $val2->joinedusers && $val2->challenge_type == 'money') || ($val2->challenge_type == 'percentage' &&  $val2->joinedusers < $val2->minimum_user)) {
          if ($val2->confirmed_challenge == 0 || ($val2->challenge_type == 'percentage' &&  $val2->joinedusers < $val2->minimum_user)) {

            if ($match_key == 'c.match.kista_cricket_club_vs_stockholm_mumbai_indians.0ce83') {
              $league_match_key = 'c.match.kista_cricket_club_vs_stockholm_mumbai_ind';
            } else {
              $league_match_key = $match_key;
            }
            // echo($league_match_key);DIE;
            $leaugestransactions = DB::table('leaugestransactions')->where('matchkey', $league_match_key)->where('challengeid', $val1->challengeid)->get();
            foreach ($leaugestransactions as $val3) {
              $entryfee = $val2->entryfee;
              $findlastow = DB::table('userbalances')->where('user_id', $val3->user_id)->first();
              if (!empty($findlastow)) {


                $dasts['status'] = 'canceled';
                DB::table('matchchallenges')->where('id', $val2->id)->update($dasts);
                // entry in refund //
                $refunddata['userid'] = $val3->user_id;
                $refunddata['amount'] = $entryfee;
                $refunddata['joinid'] = $val3->joinid;
                $refunddata['challengeid'] = $val3->challengeid;
                $refunddata['reason'] = 'Contest cancel';
                $refunddata['matchkey'] = $match_key;
                //$findifalreadyrefund = DB::table('refunds')->where('joinid',$val3->joinid)->first();

                try {

                  DB::table('refunds')->insert($refunddata); // end entry in refund data//

                  //Update User Balance
                  $dataq['balance'] =  $findlastow->balance + $val3->balance;
                  $dataq['winning'] =  $findlastow->winning + $val3->winning;
                  $dataq['bonus'] =  $findlastow->bonus + $val3->bonus;
                  // $dataq['perks'] =  $findlastow->perks-($val3->winning + $val3->balance);
                  DB::table('userbalances')->where('id', $findlastow->id)->update($dataq);



                  //transactions//
                  $registeruserdetails = DB::table('registerusers')->where('id', $val3->user_id)->first();
                  $datatr['transaction_id'] = BRAND['name'] . '-REFUND-' . rand(100, 999) . $val3->user_id;
                  $datatr['type'] = 'Refund amount';
                  $datatr['transaction_by'] = BRAND['name'];
                  $datatr['amount'] = $entryfee;
                  $datatr['paymentstatus'] = 'confirmed';
                  $datatr['challengeid'] = $val3->challengeid;
                  $datatr['bonus_amt'] = $val3->bonus;
                  $datatr['win_amt'] = $val3->winning;
                  $datatr['addfund_amt'] = $val3->balance;
                  $datatr['bal_bonus_amt'] = $dataq['bonus'];
                  $datatr['bal_win_amt'] = $dataq['winning'];
                  $datatr['bal_fund_amt'] = $dataq['balance'];
                  $datatr['userid'] = $val3->user_id;
                  $datatr['total_available_amt'] = $dataq['balance'] + $dataq['winning'] + $dataq['bonus'];
                  DB::table('transactions')->insert($datatr);
                  //mail//
                  $challengename = "";
                  if ($val2->name != "") {
                    $challengename = $val2->name;
                  } else {
                    $challengename = 'Win-' . $val2->win_amount;
                  }
                  // $email = $registeruserdetails->email;
                  // $emailsubject = 'Contest Cancelled-Refund initiated!';
                  // $content='<p><strong>Dear Challenger </strong></p>';
                  // $content.='<p>Unfortunately the contest '.$challengename.' of match '.date('M d Y h:i:a',strtotime($listmatches->start_date)).' '.$listmatches->title.' has cancelled due to lack of users and your entry fee for the match is getting refunded back to your CLUB11 wallet.</p>';
                  // $msg = Helpers::mailheader();
                  // $msg.= Helpers::mailbody($content);
                  // $msg.= Helpers::mailfooter();
                  // // Helpers::mailsentFormat($email,$emailsubject,$msg);
                  // //notifications//
                  // $datan['title'] = 'Refund Amount of ₹'.$val2->entryfee.' for contest cancellation';
                  // $datan['userid'] = $val3->user_id;
                  // DB::table('notifications')->insert($datan);

                } catch (\Illuminate\Database\QueryException $ex) {
                  echo $ex->getMessage();
                  echo 'yes';
                  exit;
                }
              }
            }
          }
        }
      }
    }
    return 1;
  }

  public function clash_refund($matchkey, $sport_type)
  {
    date_default_timezone_set('Asia/Kolkata');
    $check_match = DB::table('listmatches')->where('matchkey', $matchkey)->where('sport_type', $sport_type)->first();
    if (!empty($check_match) && $check_match->start_date < date('Y-m-d H:i:s')) {
      if ($check_match->clash_refund == 0) {
        $find_challenges = DB::table('matchchallenges')
          ->where('matchkey', $matchkey)
          // ->where('id', 1151830)
          ->where('sport_type', $sport_type)->where('maximum_user', '<', 5)->where('status', '!=', 'canceled')->get();

        foreach ($find_challenges as $key => $value) {
          $find_teams = DB::table('joinedleauges')->join('jointeam', 'jointeam.id', '=', 'joinedleauges.teamid')->where('challengeid', $value->id)->select('jointeam.players', 'jointeam.captain', 'jointeam.vicecaptain')->get();
          $same_c_vc = 0;
          $players = array();
          foreach ($find_teams as $key => $value_team) {
            $players[] = explode(',', $value_team->players);
            if ($key == 1 && $find_teams[$key - 1]->captain == $value_team->captain && $find_teams[$key - 1]->vicecaptain == $value_team->vicecaptain) {
              $same_c_vc  = 1;
            } else if ($key > 1 && $find_teams[$key - 1]->captain == $value_team->captain && $find_teams[$key - 1]->vicecaptain == $value_team->vicecaptain && $same_c_vc  == 1) {
              $same_c_vc  = 1;
            } else {
              $same_c_vc  = 0;
              continue;
            }
          }
          $new_players = array();
          foreach ($players as $key => $value_ply) {
            $new_players = array_merge($new_players, $value_ply);
          }
          // print_r($new_players); exit;
          //dd($same_c_vc);
          if ($same_c_vc == 1) {
            $array_count = count(array_unique(array_filter($new_players)));
            if ($array_count == count(array_filter(explode(',', $find_teams[0]->players)))) {
              //print_r('Cancel This Contest'); exit;
              $this->refund_allamount_of_contest($matchkey, $value->id, $sport_type);
              //Cancel that contest
            }
          }
        }

        DB::table('listmatches')->where('matchkey', $matchkey)->update(array("clash_refund" => 1));
      }
    }
  }


  public function sortBySubArrayValue(&$array, $key, $dir = 'asc')
  {

    $sorter = array();
    $rebuilt = array();

    //make sure we start at the beginning of $array
    reset($array);

    //loop through the $array and store the $key's value
    foreach ($array as $ii => $value) {
      $sorter[$ii] = $value[$key];
    }

    //sort the built array of key values
    if ($dir == 'asc') asort($sorter);
    if ($dir == 'desc') arsort($sorter);

    //build the returning array and add the other values associated with the key
    foreach ($sorter as $ii => $value) {
      $rebuilt[$ii] = $array[$ii];
    }

    //assign the rebuilt array to $array
    $array = $rebuilt;
  }

  public  function marathon_winner_declared($series)
  {

    $findmarathon = DB::table('marathon')->where('series', $series)->first();
    $findseriesdeatils = DB::table('series')->where('id', $series)->first();
    if (!empty($findmarathon)) {
      if ($findmarathon->status == 'pending') {
        $findbestmatches = $findmarathon->bestmatches;
        $findallchallenges = DB::table('matchchallenges')->where('challenge_id', $findmarathon->id)->where('series_id', $series)->get();
        $challengarary = array();
        if (!empty($findallchallenges)) {
          foreach ($findallchallenges as $ch) {
            $challengarary[] = $ch->id;
          }
        }
        $usersarray = array();
        $findjoinedleauges = DB::table('joinedleauges')->whereIn('challengeid', $challengarary)->groupBy('joinedleauges.userid')->get();
        if (!empty($findjoinedleauges)) {
          foreach ($findjoinedleauges as $jleaug) {
            $usersarray[] = $jleaug->userid;
          }
        }
        $ulastrank = 0;
        $i = 0;
        $user_points = array();
        if (!empty($usersarray)) {
          foreach ($usersarray as $uaray) {
            $bestscores = 0;
            $finduserpoints = DB::table('joinedleauges')->whereIn('joinedleauges.challengeid', $challengarary)->where('joinedleauges.userid', $uaray)->join('jointeam', 'jointeam.id', '=', 'joinedleauges.teamid')->orderBy('jointeam.points', 'DESC')->select('jointeam.points')->limit($findbestmatches)->get();
            if (!empty($finduserpoints)) {
              foreach ($finduserpoints as $point) {
                $bestscores += $point->points;
              }
            }
            $user_points[$i]['points'] = $bestscores;
            $user_points[$i]['id'] = $uaray;
            $i++;
          }
          $this->sortBySubArrayValue($user_points, 'points', 'desc');
          if (!empty($user_points)) {
            $matchpricecards = DB::table('marathonpricecards')->where('challenge_id', $findmarathon->id)->get();
            $prc_arr = array();
            if (!empty($matchpricecards)) {
              foreach ($matchpricecards as $prccrd) {
                $min_position = $prccrd->min_position;
                $max_position = $prccrd->max_position;
                for ($i = $min_position; $i < $max_position; $i++) {
                  $prc_arr[$i + 1] = $prccrd->price;
                }
              }
            } else {
              $prc_arr[1] = $findmarathon->win_amount;
            }
            $count = count($prc_arr);
            $poin_user = array();
            foreach ($user_points as $usr) {
              $ids_str = "";
              $ids_arr = array();
              if (array_key_exists("'" . $usr['points'] . "'", $poin_user)) {
                if (isset($poin_user["'" . $usr['points'] . "'"]['id'])) {
                  $ids_str = implode(',', $poin_user["'" . $usr['points'] . "'"]['id']);
                }
                $ids_str = $ids_str . ',' . $usr['id'];
                $ids_arr = explode(',', $ids_str);
                $poin_user["'" . $usr['points'] . "'"]['id'] = $ids_arr;
                $poin_user["'" . $usr['points'] . "'"]['points'] = $usr['points'];
              } else {
                $poin_user["'" . $usr['points'] . "'"]['id'][0] = $usr['id'];
                $poin_user["'" . $usr['points'] . "'"]['points'] = $usr['points'];
              }
            }
            $this->sortBySubArrayValue($poin_user, 'points', 'desc');
            $win_usr = array();
            $win_cnt = 0;
            foreach ($poin_user as $kk => $pu) {
              if ($win_cnt < $count) {
                $win_usr[$kk]['min'] = $win_cnt + 1;
                $win_cnt = $win_cnt + count($pu['id']);
                $win_usr[$kk]['max'] = $win_cnt;
                $win_usr[$kk]['count'] = count($pu['id']);
                $win_usr[$kk]['id'] = $pu['id'];
              } else {
                break;
              }
            }
            $final_poin_user = array();
            foreach ($win_usr as $ks => $ps) {
              if ($ps['count'] == 1) {
                $final_poin_user[$ps['id'][0]]['points'] = $ks;
                $final_poin_user[$ps['id'][0]]['amount'] = $prc_arr[$ps['min']];
                $final_poin_user[$ps['id'][0]]['rank'] = $ps['min'];
              } else {
                $ttl = 0;
                $avg_ttl = 0;
                for ($jj = $ps['min']; $jj <= $ps['max']; $jj++) {
                  $sm = 0;
                  if (isset($prc_arr[$jj])) {
                    $sm = $prc_arr[$jj];
                  }
                  $ttl = $ttl + $sm;
                }
                $avg_ttl = $ttl / $ps['count'];
                foreach ($ps['id'] as $fnl) {
                  $final_poin_user[$fnl]['points'] = $ks;
                  $final_poin_user[$fnl]['amount'] = $avg_ttl;
                  $final_poin_user[$fnl]['rank'] = $ps['min'];
                }
              }
            }

            foreach ($final_poin_user as $fpusk => $fpusv) {
              $transactionidsave = BRAND['name'] . '-MARATHON-' . rand(1000, 99999);
              $fres['userid'] = $fpusk;
              $fres['points'] = str_replace("'", "", $fpusv['points']);
              $fres['amount'] = round($fpusv['amount'], 2);
              $fres['rank'] = $fpusv['rank'];
              $fres['seriesid'] = $series;
              $fres['challengeid'] = $findmarathon->id;
              $fres['transaction_id'] = $transactionidsave;
              DB::table('finalresults')->insert($fres);
              $fpusv['amount'] = round($fpusv['amount'], 2);
              if ($fpusv['amount'] >= 10000) {
                $tdsdata['tds_amount'] = (30 / 100) * $fpusv['amount'];
                $tdsdata['amount'] = $fpusv['amount'];
                $remainingamount = $fpusv['amount'] - $tdsdata['tds_amount'];
                $tdsdata['userid'] = $fpusk;
                $tdsdata['seriesid'] = $series;
                $tdsdata['challengeid'] = $findmarathon->id;
                DB::table('tdsdetails')->insert($tdsdata);
                $fpusv['amount'] = $remainingamount;
                //user balance//
                $registeruserdetails = DB::table('registerusers')->where('id', $fpusk)->first();
                $findlastow = DB::table('userbalances')->where('user_id', $fpusk)->first();
                $dataqs['winning'] =  $findlastow->winning + $fpusv['amount'];
                DB::table('userbalances')->where('id', $findlastow->id)->update($dataqs);
                //transactions entry//
                $datatr['transaction_id'] = $transactionidsave;
                $datatr['type'] = 'Win amount';
                $datatr['transaction_by'] = BRAND['name'];
                $datatr['amount'] = $fpusv['amount'];
                $datatr['paymentstatus'] = 'confirmed';
                $datatr['challengeid'] = $findmarathon->id;
                $datatr['seriesid'] = $series;
                $datatr['win_amt'] = $fpusv['amount'];
                $datatr['bal_bonus_amt'] = $findlastow->bonus;
                $datatr['bal_win_amt'] = $dataqs['winning'];
                $datatr['bal_fund_amt'] = $findlastow->balance;
                $datatr['userid'] = $fpusk;
                $datatr['total_available_amt'] = $findlastow->balance + $dataqs['winning'] + $findlastow->bonus;
                DB::table('transactions')->insert($datatr);
                //notifications entry//
                $datanot['title'] = 'You won amount ₹' . $fpusv['amount'] . ' and 30% amount of ' . $tdsdata['amount'] . ' deducted due to TDS.';
                $datanot['userid'] = $fpusk;
                DB::table('notifications')->insert($datanot);
                //mail//
                $challengename = "";
                if ($findmarathon->name == "") {
                  if ($findmarathon->win_amount == 0) {
                    $challengename = 'Net Practice';
                  } else {
                    $challengename = 'Win-' . $findmarathon->win_amount;
                  }
                } else {
                  $challengename = $findmarathon->name;
                }
                $email = $registeruserdetails->email;
                $emailsubject = 'Congrats you won a marathon challenge!';
                $content = '<p><strong>Dear Challenger </strong></p>';
                $content .= '<p>Congratulations. You have won a marathon contest of ' . $challengename . ' for series ' . $findseriesdeatils->name . '  with points ' . $fres['points'] . '. An amount of ₹ ' . $fpusv['amount'] . ' is transfered to your ' . BRAND['name'] . ' wallet and 30% amount is deducted due to Tax deduction as per government regulations. Enjoy!</p>';
                $msg = Helpers::mailheader();
                $msg .= Helpers::mailbody($content);
                $msg .= Helpers::mailfooter();
                // Helpers::mailsentFormat($email,$emailsubject,$msg);
              } else {
                //user balance//
                $registeruserdetails = DB::table('registerusers')->where('id', $fpusk)->first();
                $findlastow = DB::table('userbalances')->where('user_id', $fpusk)->first();
                $dataqs['winning'] =  $findlastow->winning + $fpusv['amount'];
                DB::table('userbalances')->where('id', $findlastow->id)->update($dataqs);
                if ($fpusv['amount'] > 0) {
                  //transactions entry//
                  $datatr['transaction_id'] = $transactionidsave;
                  $datatr['type'] = 'Win amount';
                  $datatr['transaction_by'] = BRAND['name'];
                  $datatr['amount'] = $fpusv['amount'];
                  $datatr['paymentstatus'] = 'confirmed';
                  $datatr['challengeid'] = $findmarathon->id;
                  $datatr['seriesid'] = $series;
                  $datatr['win_amt'] = $fpusv['amount'];
                  $datatr['bal_bonus_amt'] = $findlastow->bonus;
                  $datatr['bal_win_amt'] = $dataqs['winning'];
                  $datatr['bal_fund_amt'] = $findlastow->balance;
                  $datatr['userid'] = $fpusk;
                  $datatr['total_available_amt'] = $findlastow->balance + $dataqs['winning'] + $findlastow->bonus;
                  DB::table('transactions')->insert($datatr);
                  //notifications entry//
                  $datanot['title'] = 'You won amount ₹' . $fpusv['amount'];
                  $datanot['userid'] = $fpusk;
                  DB::table('notifications')->insert($datanot);
                  //mail//
                  $challengename = "";
                  if ($findmarathon->name == "") {
                    if ($findmarathon->win_amount == 0) {
                      $challengename = 'Net Practice';
                    } else {
                      $challengename = 'Win-' . $findmarathon->win_amount;
                    }
                  } else {
                    $challengename = $findmarathon->name;
                  }
                  $email = $registeruserdetails->email;
                  $emailsubject = 'Congrats you won a marathon challenge!';
                  $content = '<p><strong>Dear Challenger </strong></p>';
                  $content .= '<p>Congratulations. You have won a contest of ' . $challengename . ' for series ' . $findseriesdeatils->name . '  with points ' . $fres['points'] . '. An amount of ₹ ' . $fpusv['amount'] . ' is transfered to your ' . BRAND['name'] . ' wallet. Enjoy!</p>';
                  $content .= '<p> <strong> Note:- </strong> Winning amount will be credited in your ' . BRAND['name'] . ' wallet after tax deductions as per government regulations.</p>';
                  $content .= '<p> For details , please check account balance.</p>';
                  $msg = Helpers::mailheader();
                  $msg .= Helpers::mailbody($content);
                  $msg .= Helpers::mailfooter();
                  // Helpers::mailsentFormat($email,$emailsubject,$msg);
                }
              }
            }
          }
        }
        $marathn['status'] = 'winnerdeclared';
        DB::table('marathon')->where('id', $findmarathon->id)->update($marathn);
        Session::flash('flash_notice', 'winner declared successfully!');
        Session::flash('alert-class', 'alert-success');
        return redirect()->action('App\Http\Controllers\Admin\MatchesController@marathon_result');
      } else {
        Session::flash('flash_notice', 'Already winner declared. You cannot redeclare the winner again!');
        Session::flash('alert-class', 'alert-danger');
        return redirect()->action('App\Http\Controllers\Admin\MatchesController@marathon_result');
      }
    }
  } //End Function

  //Distribute Winning Amount
  public function distribute_winning_amount2($matchkey = null, $match_type = null)
  {
    $listmatches = DB::table('listmatches')->where('matchkey', $matchkey)->where('final_status', 'IsClosed')->orWhere('status', 'completed')->first();
    if (!empty($listmatches)) {

      $matchchallenges = DB::table('matchchallenges')->where('matchkey', $matchkey)->where('marathon', '!=', 1)->where('status', '!=', 'canceled')->get();
      if (!empty($matchchallenges)) {
        /* New Update */
        $challarr = array();
        foreach ($matchchallenges as $key => $value) {
          $challarr[] = $value->id;
        }
        $joinedleauges = DB::table('joinedleauges')->where('joinedleauges.matchkey', $matchkey)->whereIn('joinedleauges.challengeid', $challarr)->select('joinedleauges.userid', 'joinedleauges.teamid', 'points', 'joinedleauges.id as jid', 'joinedleauges.challengeid')->join('jointeam', 'jointeam.id', '=', 'joinedleauges.teamid')->orderBy('jointeam.points', 'DESC')->get();
        foreach ($joinedleauges as $row) {
          $joinedteamsarr[$row->challengeid][] = $row;
        }
        /* New Update */                //print_r($joinedteamsarr); exit;
        foreach ($matchchallenges as $val2) {
          $ratio = 1;
          $flag = 0;
          if ($val2->confirmed_challenge == 1) {
            $flag = 1;
            if ($val2->minimum_user > $val2->joinedusers && $val2->challenge_type == "percentage") {
              $flag = 0;
            }
          } else {
            if ($val2->maximum_user == $val2->joinedusers) {
              $flag = 1;
            }
            if ($val2->minimum_user > $val2->joinedusers && $val2->challenge_type == "percentage") {
              $flag = 0;
            }
          }

          $challengeid = $val2->id;
          $user_points = array();
          if ($flag == 1) {

            if (isset($joinedteamsarr[$challengeid]) && !empty($joinedteamsarr[$challengeid])) {
              $joinedleauges = $joinedteamsarr[$challengeid];
              $total_joined_league = count($joinedleauges);
              if ($val2->maximum_user > $total_joined_league) {
                $ratio =  $total_joined_league / $val2->maximum_user;
              } else {
                $ratio = 1;
              }
              $lp = 0;
              // foreach($joinedleauges as $jntm){
              //  $user_points[$lp]['id']=$jntm->userid;
              //  $user_points[$lp]['points']=$jntm->points;
              //  $user_points[$lp]['joinedid']=$jntm->jid;
              //  $lp++;
              // }
              //print_r($joinedleauges); exit;
              foreach ($joinedleauges as $usr) {
                $ids_str = "";
                $ids_arr = array();
                if (array_key_exists("'" . $usr->points . "'", $user_points)) {
                  if (isset($user_points["'" . $usr->points . "'"]['joinedid'])) {
                    $ids_str = implode(',', $user_points["'" . $usr->points . "'"]['joinedid']);
                  }
                  $ids_str = $ids_str . ',' . $usr->jid;
                  $ids_arr = explode(',', $ids_str);
                  $user_points["'" . $usr->points . "'"]['joinedid'] = $ids_arr;
                  $user_points["'" . $usr->points . "'"]['points'] = $usr->points;
                  $user_points["'" . $usr->points . "'"]['id'] = $usr->userid;
                } else {
                  $user_points["'" . $usr->points . "'"]['id'] = $usr->userid;
                  $user_points["'" . $usr->points . "'"]['points'] = $usr->points;
                  $user_points["'" . $usr->points . "'"]['joinedid'][0] = $usr->jid;
                }
              }
            } //print_r($user_points); exit;
            if (!empty($user_points)) {
              $prc_arr = array();
              if ($val2->challenge_type == 'percentage') {
                $gtjnusers = $val2->joinedusers;
                $userstowin = $val2->winning_percentage;
                $toWin = floor($gtjnusers * $userstowin / 100);
                for ($i = 0; $i < $toWin; $i++) {
                  $prc_arr[$i + 1] = $val2->win_amount;
                }
                $ratio = 1;
              } else {
                $matchpricecards = DB::table('matchpricecards')->where('matchkey', $matchkey)->where('challenge_id', $val2->id)->get();

                if (!empty($matchpricecards)) {
                  foreach ($matchpricecards as $prccrd) {
                    $min_position = $prccrd->min_position;
                    $max_position = $prccrd->max_position;
                    for ($i = $min_position; $i < $max_position; $i++) {
                      $prc_arr[$i + 1] = $prccrd->price;
                    }
                  }
                } else {
                  $prc_arr[1] = $val2->win_amount;
                }
              }
              $count = count($prc_arr);
              $poin_user = $user_points;


              // $this->sortBySubArrayValue($poin_user, 'points', 'desc');
              //print_r($poin_user); exit;
              $win_usr = array();
              $win_cnt = 0;
              foreach ($poin_user as $kk => $pu) {
                if ($win_cnt < $count) {
                  $win_usr[$kk]['min'] = $win_cnt + 1;
                  $win_cnt = $win_cnt + count($pu['joinedid']);
                  $win_usr[$kk]['max'] = $win_cnt;
                  $win_usr[$kk]['count'] = count($pu['joinedid']);
                  $win_usr[$kk]['joinedid'] = $pu['joinedid'];
                  $win_usr[$kk]['userid'] = $pu['id'];
                } else {
                  break;
                }
              }
              // print_r($win_usr); exit;
              $final_poin_user = array();
              foreach ($win_usr as $ks => $ps) {
                if ($ps['count'] == 1) {
                  $final_poin_user[$ps['joinedid'][0]]['points'] = $ks;
                  $final_poin_user[$ps['joinedid'][0]]['amount'] = $prc_arr[$ps['min']]; //multiply ratio here
                  $final_poin_user[$ps['joinedid'][0]]['rank'] = $ps['min'];
                  $final_poin_user[$ps['joinedid'][0]]['userid'] = $ps['userid'];
                } else {
                  $ttl = 0;
                  $avg_ttl = 0;
                  for ($jj = $ps['min']; $jj <= $ps['max']; $jj++) {
                    $sm = 0;
                    if (isset($prc_arr[$jj])) {
                      $sm = $prc_arr[$jj];
                    }
                    $ttl = $ttl + $sm;
                  }
                  $avg_ttl = $ttl / $ps['count'];
                  foreach ($ps['joinedid'] as $fnl) {
                    $final_poin_user[$fnl]['points'] = $ks;
                    $final_poin_user[$fnl]['amount'] = $avg_ttl; //multiply ratio here
                    $final_poin_user[$fnl]['rank'] = $ps['min'];
                    $final_poin_user[$fnl]['userid'] = $ps['userid'];
                  }
                }
              }
              // print_r($final_poin_user); exit;
              foreach ($final_poin_user as $fpuskjoinid => $fpusv) {
                // $finduserid = DB::table('joinedleauges')->where('id',$fpuskjoinid)->select('userid')->first();
                $fpusk = $fpusv['userid'];
                //$transactionidsave = 'WIN-'.rand(1000,99999).$challengeid;
                $fres['userid'] = $fpusk;
                $fres['points'] = str_replace("'", "", $fpusv['points']);
                $fres['amount'] = round($fpusv['amount'], 2);
                $fres['rank'] = $fpusv['rank'];
                $fres['matchkey'] = $matchkey;
                $fres['challengeid'] = $challengeid;
                $fres['transaction_id'] = '0';
                $fres['joinedid'] = $fpuskjoinid;
                $finalresults[] = $fres;
                //$findalreexist = DB::table('finalresults')->where('matchkey',$matchkey)->where('joinedid',$fpuskjoinid)->first();
                try {
                } catch (\Illuminate\Database\QueryException $ex) {
                }
              }
            }
          }
        }
        if (!empty($finalresults)) {
          // $table = \DB::getTablePrefix().with(new self)->getTable(); print_r($table); exit;
          //DB::table('finalresults')->insertOrUpdate($finalresults);
          $this->insertOrUpdate($finalresults, 'finalresults');
        }
        // print_r($finalresults);
      }
      MatchesController::refer_bonus($matchkey);
    }
  } //End Function




  public function update_result_points()
  {
    $matchplayers = DB::table('result_matches')->get();
    if (!empty($matchplayers)) {
      foreach ($matchplayers as $row) {
        $data['startingpoints'] = $row->starting11;
        $data['runs'] = $row->runs;
        $data['fours'] = $row->fours;
        $data['sixs'] = $row->six;
        $data['strike_rate'] = $row->strike_rate;
        $data['wickets'] = $row->wicket;
        $data['maidens'] = $row->maiden_over;
        $data['economy_rate'] = $row->economy_rate;
        $data['catch'] = $row->catch;
        $data['stumping'] = $row->stumbed;
        $data['negative'] = $row->negative_points;
        $data['total'] = $row->total_points;
        DB::table('result_points')->where('matchkey', $row->match_key)->where('playerid', $row->player_id)->update($data);
      }
    }
  }



  public function match_reviewed(Request $request)
  {
    if ($request->isMethod('post')) {
      $input = Input::all();
      $matchkey = $input['matchkey'];
      $data['final_status'] = $input['final_status'];
      $data['review'] = $input['review'];
      DB::table('listmatches')->where('matchkey', $matchkey)->update($data);
      Session::flash('flash_notice', 'Match Reviewed successfully!');
      Session::flash('alert-class', 'alert-success');
      return Redirect::back();
    }
  }
  public function marathon_result()
  {
    $finduserpoints = array();
    $findmarathon = array();
    $findallseries = DB::table('series')->where('series_status', 'opened')->get();
    if (isset($_GET['series'])) {
      $findmarathon = DB::table('marathon')->where('series', $_GET['series'])->first();
      if (!empty($findmarathon)) {
        $findbestmatches = $findmarathon->bestmatches;
      }
    }
    return view('matches.marathon_result', compact('findallseries', 'findmarathon', 'findbestmatches'));
  }



  //
  public function deductmoney()
  {
    $matchkey = 'paknz_2018_one-day_03';
    $findallfinalresults = DB::table('finalresults')->where('matchkey', $matchkey)->get();
    if (!empty($findallfinalresults)) {
      foreach ($findallfinalresults as $duplicate) {
        $userid = $duplicate->userid;
        $this->finaldeduction($duplicate->transaction_id, $duplicate->amount, $duplicate->userid, $duplicate->id);
      }
    }
    // $matchkey = 'aplt20_2018_g20';
    // $findallfinalresults = DB::table('finalresults')->where('matchkey',$matchkey)->groupBy('joinedid')->get();
    // $content="";
    // if(!empty($findallfinalresults)){
    // foreach($findallfinalresults as $fresults){
    // $findifduplicate = DB::table('finalresults')->where('matchkey',$matchkey)->where('joinedid',$fresults->joinedid)->where('id','<>',$fresults->id)->get();
    // if(!empty($findifduplicate)){
    // foreach($findifduplicate as $duplicate){
    // $userid = $duplicate->userid;
    // $findregisteruserdetails = DB::table('registerusers')->where('id',$userid)->first();
    // if(!empty($findregisteruserdetails)){
    // $finduseramount = DB::table('userbalances')->where('user_id',$duplicate->userid)->first();
    // $content.='<p> Name:- '.$findregisteruserdetails->team.' &nbsp; &nbsp; Won Amount:- '.$duplicate->amount.' &nbsp; &nbsp;  Total winning amount in bucket :- '.$finduseramount->winning.' &nbsp; &nbsp;';
    // if($finduseramount->winning>$duplicate->amount){
    // $this->finaldeduction($duplicate->transaction_id,$duplicate->amount,$duplicate->userid,$duplicate->id);
    // $content.='<a href="'.action('App\Http\Controllers\Admin\MatchesController@finaldeduction',[$duplicate->transaction_id,$duplicate->amount,$duplicate->userid,$duplicate->id]).'">Deduct Amount</a>';
    // }
    // $content.='&nbsp; &nbsp; joinedid :- '.$fresults->joinedid.' &nbsp; &nbsp; email address:- '.$findregisteruserdetails->email.' &nbsp; &nbsp; userid:- '.$duplicate->userid.'</p><br>';
    // }

    // $gettransactionid = $duplicate->transaction_id;
    // $findtransaction = DB::table('transactions')->where('transaction_id',$duplicate->transaction_id)->first();
    // if(!empty($findtransaction)){
    // DB::table('transactions')->where('id',$findtransaction->id)->delete();
    // }
    // $finduseramount = DB::table('userbalances')->where('user_id',$duplicate->userid)->first();
    // $findwinning['winning'] = $finduseramount->winning-$duplicate->amount;

    // if($findwinning['winning']<0){
    // $findwinning['winning'] = 0;
    // }
    // DB::table('userbalances')->where('user_id',$duplicate->userid)->update($findwinning);
    // DB::table('finalresults')->where('id',$duplicate->id)->delete();

    // }
    // }

    // }
    // }
    // echo $content;
    // die;
  }
  public function finaldeduction($tranid, $amount, $userid, $id)
  {
    $gettransactionid = $tranid;
    $findtransaction = DB::table('transactions')->where('transaction_id', $gettransactionid)->select('id')->first();
    if (!empty($findtransaction)) {
      DB::table('transactions')->where('id', $findtransaction->id)->delete();
    }
    $finduseramount = DB::table('userbalances')->where('user_id', $userid)->first();
    $findwinning['winning'] = $finduseramount->winning - $amount;
    if ($findwinning['winning'] < 0) {
      $findwinning['winning'] = 0;
    }
    DB::table('userbalances')->where('user_id', $userid)->update($findwinning);
    DB::table('finalresults')->where('id', $id)->delete();
    // return Redirect::back();
  }

  public function deductUserAmount($userid, $amount)
  {
    // exit;
    // $needToDeductUsers = DB::table('deduct_user_balances')->where('is_deducted' , 0)->get();

    if (1) {
      $totalDeduction = 0;
      $userBalance = DB::table('userbalances')->where('user_id', $userid)->first();
      if (!empty($userBalance)) {
        $total_available_balance = $userBalance->balance;
        $total_available_winning = $userBalance->winning;
        $total_available_amounts = $total_available_balance + $total_available_winning;

        $totalAmountDeducted = 0;
        $deductionBalance = 0;
        $deductionWinning = 0;

        if ($total_available_amounts >= $amount) {

          if ($total_available_winning >= $amount) {
            $totalAmountDeducted = $amount;
            $updatedAmount['winning'] = $total_available_winning - $amount;
          } else {
            if ($total_available_winning != 0) {
              $deductionWinning = $total_available_winning;
              $updatedAmount['winning'] = 0;
            }

            if ($deductionWinning < $amount) {

              $moreNeedToDeduct = $amount - $deductionWinning;
              if ($total_available_balance >= $moreNeedToDeduct) {
                $deductionBalance = $moreNeedToDeduct;
                $updatedAmount['balance'] = $total_available_balance - $moreNeedToDeduct;
              } else {
                if ($total_available_balance != 0) {
                  $deductionBalance = $total_available_balance;
                  $updatedAmount['balance'] = 0;
                }
              }
            }

            $totalAmountDeducted = $deductionWinning + $deductionBalance;
          }

          $updatedDeductedEntry['total_deducted_amount']  = $totalAmountDeducted;
          if ($totalAmountDeducted  < $amount) {
            $updatedDeductedEntry['is_deducted'] = 0;
            $updatedDeductedEntry['amount']  = $amount - $totalAmountDeducted;
          } else {
            $updatedDeductedEntry['is_deducted'] = 1;
          }

          DB::table('userbalances')->where('user_id', $userid)->update($updatedAmount);
          // DB::table('deduct_user_balances')->where('id', $deductUser->id)->update($updatedDeductedEntry);

          $userBalances = DB::table('userbalances')->where('user_id', $userid)->first();

          $trans_id = "foucs11-AABA" . time() . $userid;
          $transaction['userid'] = $userid;
          $transaction['type'] = "Extra Amount Deduct By Admin";
          $transaction['transaction_id'] = $trans_id;
          $transaction['transaction_by'] = "Foucs11";
          $transaction['amount'] = $totalAmountDeducted;
          $transaction['paymentstatus'] = "confirmed";
          $transaction['bal_bonus_amt'] = $userBalances->bonus;
          $transaction['bal_win_amt'] = $userBalances->winning;
          $transaction['bal_fund_amt'] = $userBalances->balance;
          $transaction['total_available_amt'] = $userBalances->balance + $userBalances->winning + $userBalances->bonus;
          if ($totalDeduction > 0) {

            DB::table('transactions')->insert($transaction);
          }
        } else {
          if ($total_available_amounts != 0) {

            if ($total_available_winning >= $amount) {
              $totalAmountDeducted = $amount;
              $updatedAmount['winning'] = $total_available_winning - $amount;
            } else {

              if ($total_available_winning != 0) {
                $deductionWinning = $total_available_winning;
                $updatedAmount['winning'] = 0;
              }

              if ($deductionWinning < $amount) {

                $moreNeedToDeduct = $amount - $deductionWinning;
                if ($total_available_balance >= $moreNeedToDeduct) {
                  $deductionBalance = $moreNeedToDeduct;
                  $updatedAmount['balance'] = $total_available_balance - $moreNeedToDeduct;
                } else {
                  if ($total_available_balance != 0) {
                    $deductionBalance = $total_available_balance;
                    $updatedAmount['balance'] = 0;
                  }
                }
              }
            }

            $totalDeduction = $deductionBalance + $deductionWinning;

            DB::table('userbalances')->where('user_id', $userid)->update($updatedAmount);
            $updatedDeductedEntry['is_deducted'] = 0;
            // $updatedDeductedEntry['total_deducted_amount'] = $deductUser->total_deducted_amount + $totalDeduction;
            $updatedDeductedEntry['amount'] = $amount - $totalDeduction;
            // DB::table('deduct_user_balances')->where('id', $deductUser->id)->update($updatedDeductedEntry);

          }

          $userBalances = DB::table('userbalances')->where('user_id', $userid)->first();

          $trans_id = "PlaynWin11-AABA" . time() . $userid;
          $transaction['userid'] = $userid;
          $transaction['type'] = "Extra Amount Deduct By Admin";
          $transaction['transaction_id'] = $trans_id;
          $transaction['transaction_by'] = "PlaynWin11";
          $transaction['amount'] = @$totalDeduction ? $totalDeduction : 0;
          $transaction['paymentstatus'] = "confirmed";
          $transaction['bal_bonus_amt'] = $userBalances->bonus;
          $transaction['bal_win_amt'] = $userBalances->winning;
          $transaction['bal_fund_amt'] = $userBalances->balance;
          $transaction['total_available_amt'] = $userBalances->balance + $userBalances->winning + $userBalances->bonus;
          if ($totalDeduction > 0) {
            DB::table('transactions')->insert($transaction);
          }
        }
      }
    }
    return true;
  }

  public function reverse()
  {
    /*$sql = "SELECT *  FROM `leaugestransactions`  WHERE leaugestransactions.`matchkey` IN ('c.match.sha_vs_tig.5c46e') AND leaugestransactions.challengeid NOT IN (SELECT id FROM matchchallenges WHERE matchchallenges.matchkey IN('c.match.sha_vs_tig.5c46e'))";
        $records = DB::select( $sql );
        print_r($records); exit;
        foreach ($records as $key => $value) {
            $joinid = $value->joinid;
            $findRefundExist = DB::table('refunds')->where('joinid', $joinid)->first();
            if(empty($findRefundExist)) {
                $updateData = array();
                $updateData['userid'] = $value->user_id;
                $updateData['amount'] = $value->bonus + $value->winning + $value->balance;
                $updateData['joinid'] = $value->joinid;
                $updateData['challengeid'] = $value->challengeid;
                $updateData['matchkey'] = $value->matchkey;
                // print_r($updateData);
                DB::table('refunds')->insert($updateData);

                $bal_update =array();
                $bal = DB::table('userbalances')->where('userbalances.user_id', $value->user_id)->first();
                $bal_update['balance'] = $bal->balance + $value->balance;
                $bal_update['bonus'] = $bal->bonus + $value->bonus;
                $bal_update['winning'] = $bal->winning + $value->winning;
                DB::table('userbalances')->where('user_id', $value->user_id)->update($bal_update);
            }
        }
        // print_r($records); exit;
        echo 'yes'; exit;
        // DB::enableQueryLog();
        exit;*/


    $sql = "SELECT user_promo.user_id, transactions.amount FROM `user_promo` JOIN transactions ON user_promo.user_id = transactions.userid WHERE `promo_code` LIKE 'WELCOME' AND `status` = 1 AND transactions.type = 'Bonus add during add fund (Valid for 30 days)' AND DATE_FORMAT(transactions.created_at, '%Y-%m-%d') = DATE_FORMAT(user_promo.created,'%Y-%m-%d')";
    $records = DB::select($sql);
    $amount_deduct = 0;
    foreach ($records as $key => $value) {
      $bal = DB::table('userbalances')->where('userbalances.user_id', $value->user_id)->first();
      if (1) {
        // echo $value->amount; echo '<br>';
        // $amount_deduct += $value->amount;
        $this->deductUserAmount($value->user_id, $value->amount);
      }
    }
    exit;
    // print_r($amount_deduct); exit;


    $trans = DB::table('finalresults')->where('matchkey', 'c.match.rom_vs_net_xi.d477c')->get();
    // print_r($trans); exit;
    foreach ($trans as $key => $value) {
      // $rem_amount =
      $finduseramount = DB::table('userbalances')->where('user_id', $value->userid)->first();

      $findwinning['winning'] = $finduseramount->winning - $value->amount;
      if ($findwinning['winning'] < 0) {
        $findwinning['winning'] = 0;
      }
      DB::table('userbalances')->where('user_id', $value->userid)->update($findwinning);
      DB::table('finalresults')->where('id', $value->id)->delete();
    }
    echo 1;
    exit;

    $refund = DB::table('refunds')->where('matchkey', 'iplt20_2021_g9')->get();
    print_r($refund);
    exit;
    foreach ($refund as $key => $value) {
      // $count = $value->cnt;
      if (1) {

        // $finduseramount = DB::table('userbalances')->where('user_id',$value->userid)->first();
        // $findwinning['winning'] = $finduseramount->winning-$value->amount;
        // if($findwinning['winning']<0){
        //  $findwinning['winning'] = 0;
        // }
        //DB::table('userbalances')->where('user_id',$value->userid)->update($findwinning);
        // DB::table('refunds')->where('id',$value->id)->delete();

        $joinid = $value->joinid;
        $trans = DB::table('leaugestransactions')->where('joinid', $joinid)->first();

        $finduseramount = DB::table('userbalances')->where('user_id', $trans->user_id)->first();
        $findwinning['winning'] = $finduseramount->winning - $trans->winning;
        $findwinning['balance'] = $finduseramount->balance - $trans->balance;
        $findwinning['bonus'] = $finduseramount->bonus - $trans->bonus;
        if ($findwinning['winning'] < 0) {
          $findwinning['winning'] = 0;
        }
        if ($findwinning['balance'] < 0) {
          $findwinning['balance'] = 0;
        }
        if ($findwinning['bonus'] < 0) {
          $findwinning['bonus'] = 0;
        }
        DB::table('userbalances')->where('user_id', $trans->user_id)->update($findwinning);
        DB::table('refunds')->where('id', $value->id)->delete();
      }

      //DB::table('transactions')->where('id',$value->id)->delete();
    }
  }

  public function fantasy_point_system()
  {
    return view('point_system.fantasy_cricket_points');
  }



  public function update_user_commission()
  {
    $users = DB::table('league_refer_bonus')->select(DB::raw("SUM(amount) as amount, COUNT(id) as count, refer_id, user_id"))->groupBy('user_id')->get();
    // print_r($users); exit;
    foreach ($users as $key => $value) {
      if ($value->count > 9) {
        $amount = $value->amount;
        $refer_id = $value->refer_id;
        $user_id = $value->user_id;
        $bal = DB::table('userbalances')->where('user_id', $refer_id)->first();
        $royalty_balance = $bal->royalty_bonus;
        $update_data['royalty_bonus'] =  $royalty_balance + $amount;
        DB::table('userbalances')->where('user_id', $refer_id)->update($update_data);
        DB::table('registerusers')->where('id', $user_id)->update(array("refer_commission" => 1));
        DB::table('league_refer_bonus')->where('user_id', $user_id)->update(array("is_paid" => 1));
      }
    }
  }


  public function refer_bonus2($challengeid, $entryfee)
  {
    $joinedleauges = DB::table('joinedleauges')->where('joinedleauges.challengeid', $challengeid)->get();
    if (!empty($joinedleauges)) {
      foreach ($joinedleauges as $key => $value) {
        $get_refer = DB::table('registerusers')->where('id', $value->userid)->select('refer_id')->first();
        if (!empty($get_refer) && $get_refer->refer_id != 0) {
          $join_id = $value->id;
          $refer_id = $get_refer->refer_id;
          $refer_balance = DB::table('registerusers')->join('userbalances', 'userbalances.user_id', '=', 'registerusers.id')->where('registerusers.id', $refer_id)->where('refer_to_join', 1)->select('userbalances.bonus', 'userbalances.winning', 'registerusers.player_percentage')->first();
          if (!empty($refer_balance)) {
            if ($entryfee) {
              $league_trans = DB::table('leaugestransactions')->where('joinid', $join_id)->first();
              $entryfee2 = $league_trans->winning + $league_trans->balance;
              if ($entryfee2) {
                $referamount = ($entryfee2 * $refer_balance->player_percentage) / 100;
                $insert_data['affiliation_commission'] = $refer_balance->affiliation_commission + $referamount;

                $already_bonus = DB::table('league_refer_bonus')->where('user_id', $value->userid)->where('refer_id', $refer_id)->where('challenge_id', $challengeid)->where('join_id', $value->id)->get();
                if (empty($already_bonus)) {

                  $insert_bonus_data = array(
                    "user_id" => $value->userid,
                    "refer_id" => $refer_id,
                    "amount" => $referamount,
                    "challenge_id" => $challengeid,
                    "join_id" => $value->id
                  );

                  DB::table('league_refer_bonus')->insert($insert_bonus_data);
                  DB::table('userbalances')->where('user_id', $refer_id)->update($insert_data);

                  $type = 'Join league';
                  $notificationdata['userid'] = $refer_id;
                  $notificationdata['title'] = $type . '  Referral Bonus Of  ₹' . $referamount;
                  DB::table('notifications')->insert($notificationdata);
                  //push notifications//
                  $titleget = 'Join league Referral Bonus!';
                  // Helpers::sendnotification($titleget,$notificationdata['title'],'',$refer_id);
                  //end push notifications//

                  $findlastow = DB::table('userbalances')->where('user_id', $refer_id)->first();
                  if (!empty($findlastow)) {
                    $total_available_amt = $findlastow->balance + $findlastow->winning + $findlastow->bonus + $findlastow->gst_bonus + $findlastow->affiliation_commission;
                    $bal_fund_amt = $findlastow->balance;
                    $bal_win_amt = $findlastow->winning;
                    $bal_bonus_amt = $findlastow->bonus;
                  }

                  $transactionsdata['userid'] = $refer_id;
                  $transactionsdata['refer_id'] = $value->userid;
                  $transactionsdata['type'] = $type . ' Referral Bonus';
                  $transactionsdata['transaction_id'] = 'BBF-VBONUS-' . rand(1000, 9999);
                  $transactionsdata['transaction_by'] = BRAND['name'];
                  $transactionsdata['amount'] = $referamount;
                  $transactionsdata['bonus_amt'] = $referamount;
                  $transactionsdata['paymentstatus'] = 'confirmed';
                  $transactionsdata['challengeid'] = $challengeid;
                  $transactionsdata['bal_fund_amt'] = $bal_fund_amt;
                  $transactionsdata['bal_win_amt'] = $bal_win_amt;
                  $transactionsdata['bal_bonus_amt'] = $bal_bonus_amt;
                  $transactionsdata['bal_gst_bonus_amt'] = @$findlastow->gst_bonus;
                  $transactionsdata['bal_affi_amt'] = @$findlastow->affiliation_commission;
                  // $transactionsdata['cons_amount'] = $referamount;
                  $transactionsdata['total_available_amt'] = $total_available_amt;
                  DB::table('transactions')->insert($transactionsdata);
                  //return true;
                }
              }
            }
          }
        }
      }
    }
  }



  public function send_notification_cron()
  {
    $data = DB::table('notifications')->where('is_sent', 0)->get();
    foreach ($data as $key => $value) {
      //  Helpers::sendnotification($value->title,$value->message,'',$value->userid);
    }
    DB::table('notifications')->where('is_sent', 0)->update(array("is_sent" => 1));
  }

  public function bank_withdraw_cron()
  {
    date_default_timezone_set('Asia/Kolkata');
    $date = date('Y-m-d H:i:s');
    $withdraw_time = date('Y-m-d H:i:s', strtotime('-5 minutes', strtotime($date)));
    // echo $withdraw_time; exit;
    $withdraw = DB::table('withdraw')->where('created', '>=', $withdraw_time)->where('status', 0)->where('type', 'bank')->get(); //print_r($withdraw); exit;
    foreach ($withdraw as $pay) {
      $return = $this->approve_bank($pay);
      if ($return) {
      } else {
      }
    }
    // print_r($withdraw); exit;
  }

  public static function approve_bank($pay_data)
  {

    $uid = $pay_data->user_id;
    $amount = $pay_data->amount;

    $settings = DB::table('registerusers')->where('id', $uid)->first();
    if (Helpers::cf_request_transfer($uid, $amount)) {
      $data['status'] = 1;
    } else {
      return false;
    }

    $finduserdetails = DB::table('withdraw')->where('withdraw.id', $pay_data->id)->join('registerusers', 'registerusers.id', '=', 'withdraw.user_id')->select('user_id', 'registerusers.email', 'registerusers.team', 'withdraw_request_id')->first();
    $rowCOllection = DB::table('withdraw')->where('id', $pay_data->id)->update($data);
    $findtransactiondate = DB::table('transactions')->where('transaction_id', $finduserdetails->withdraw_request_id)->first();
    $tdata['paymentstatus'] = 'Confirmed';
    $tdata['created'] = $findtransactiondate->created;
    $findtransactiondetails  = DB::table('transactions')->where('transaction_id', $finduserdetails->withdraw_request_id)->update($tdata);
    //mail//
    $email = $finduserdetails->email;
    $emailsubject = 'Withdraw Request approved';
    $content = '<p><strong>Hello ' . ucwords($finduserdetails->team) . ' </strong></p>';
    $content .= '<p>Your withdrawl request of ₹' . $pay_data->amount . ' has been approved successfully.</p>';
    //$content.='<p><strong>'.$input['comment'].'</strong></p>';
    $content .= '<p></p>';
    $msg = Helpers::mailheader();
    $msg .= Helpers::mailbody($content);
    $msg .= Helpers::mailfooter();
    Helpers::mailsentFormat($email, $emailsubject, $msg);
    //notifications//
    $notificationdata['userid'] = $finduserdetails->user_id;
    $notificationdata['title'] = 'Withdraw Request Approved successfully of amount ₹' . $pay_data->amount;
    DB::table('notifications')->insert($notificationdata);
    //push notifications//
    $titleget = 'Withdrawl Request Approved!';
    // Helpers::sendnotification($titleget,$notificationdata['title'],'',$finduserdetails->user_id);
    //end push notifications//
    //message show//
    return true;
  }

  public function update_transaction()
  {

    $path = base_path() . '/Book2.xlsx'; //echo $path; exit;
    $data = Excel::load($path, function ($reader) {})->get();
    if (!empty($data) && $data->count()) { //echo 1; exit;
      // print_r($data); exit;
      foreach ($data->toArray() as $row) {
        $update_data = array();
        $order_id = str_replace("'", '', $row['orderid']);
        echo $order_id;
        echo '</br>';
        $transactions = DB::table('transactions')->where('paytid', 'Like', trim($order_id))->where('paymentstatus', 'pending')->first();
        if (!empty($transactions)) {
          print_r($transactions); //exit;
          $user_id = $transactions->userid;
          $update_data['transaction_id'] = $row['txn_id'];
          $update_data['paymentstatus'] = "confirmed";
          // DB::table('transactions')->where('id', $transactions->id)->update($update_data);
          $user_balance = DB::table('userbalances')->where('user_id', $user_id)->first();
          $update_balance['balance'] = $user_balance->balance + $row['txn_amount'];
          $update_balance['winning'] = $user_balance->winning;
          $update_balance['bonus'] = $user_balance->bonus;
          // DB::table('userbalances')->where('user_id', $user_id)->update($update_balance);
          exit;
        }
      }
      //print_r($update_data); exit;
      if (!empty($dataArray)) {
        //pr($dataArray);die;
        User::insert($dataArray);
        return back();
      } else {
        Session::flash('flash_notice', trans("User Data Already Exist!"));
        return back();
      }
    }
  }

  public function player_list_cron()
  {
    try {
      $locktime = date('Y-m-d H:i:s');
      $query = DB::table('listmatches');
      $findmatches = $query->leftjoin('series', 'listmatches.series', '=', 'series.id')
        // ->leftJoin('match_playing11','match_playing11.match_key','=','listmatches.matchkey')
        //->where('matchkey','64692')
        ->Where('listmatches.series', '!=', '0')->where('listmatches.start_date', '>', $locktime)->Where('listmatches.launch_status', 'launched')
        //->orderBY('listmatches.sort','DESC')
        ->orderBY('listmatches.start_date', 'ASC')
        ->where('series.series_status', 'opened')
        ->take(50)
        ->get();
      // echo "<pre>";  print_r($findmatches); exit;
      foreach ($findmatches as $key => $value) {
        $this->update_selected_percent($value->matchkey);
      }
      echo "Completed successfully.";
    } catch (\Exception $e) {
      echo $e->getMessage();
    }
  }

  public static function update_selected_percent($matchkey)
  {
    $total_teams = DB::table('jointeam')->where('matchkey', $matchkey)->count();
    $players = DB::table('matchplayers')->where('matchkey', $matchkey)->get();
    // print_r($players); exit;
    foreach ($players as $key => $value) {
      //echo $value->name;
      $playerid = $value->playerid;
      $total_choose = DB::table('jointeam')->whereRaw('FIND_IN_SET(' . $playerid . ',players)')->where('matchkey', $matchkey)->count();
      $selected_by = $total_choose ? round((($total_choose * 100) / $total_teams), 2) : 0;
      $total_captain_choose = DB::table('jointeam')->where('captain', $playerid)->where('matchkey', $matchkey)->count();
      $selected_captain_percent = $total_captain_choose ? round((($total_captain_choose * 100) / $total_teams), 2) : 0;

      $total_vcaptain_choose = DB::table('jointeam')->where('vicecaptain', $playerid)->where('matchkey', $matchkey)->count();
      $selected_vcaptain_percent = $total_vcaptain_choose ? round((($total_vcaptain_choose * 100) / $total_teams), 2) : 0;

      $updateData['selected_percent'] = $selected_by;
      $updateData['selected_captain_percent'] = $selected_captain_percent;
      $updateData['selected_vicecaptain_percent'] = $selected_vcaptain_percent;
      // print_r($value->id); exit;
      DB::table('matchplayers')->where('id', $value->id)->update($updateData);
      //echo "<pre>"; print_r($updateData); exit;
    }
    return true;
  }

  //Add Match//
  public function add_match(Request $request)
  {
    date_default_timezone_set('Asia/Kolkata');
    if ($request->isMethod('post')) {
      $input = Input::all();

      $validate   =   array(
        'series'        =>  'required',
        //  'format'        =>  'required',
        'team1'         =>  'required',
        'team2'         =>  'required',
        'start_date'    =>  'required|date_format:Y-m-d H:i:s|after:yesterday',
        'sport_type'    =>  'required',
      );
      $validator = Validator::make($input, $validate);
      if ($validator->fails()) {
        return Redirect::back()->withErrors($validator)->withInput();
      } else {
        //echo "hi"; exit;

        $team1_details = DB::table('teams')->where('id', $input['team1'])->where('sport_type', $input['sport_type'])->first();
        $team2_details = DB::table('teams')->where('id', $input['team2'])->where('sport_type', $input['sport_type'])->first();

        unset($input['_token']);
        $matchkey = substr($team1_details->team, 0, 3) . '_' . substr($team2_details->team, 0, 3) . '_' . $input['team1'] . $input['team2'] . time();

        $matchData['name'] = $team1_details->team . ' vs ' . $team2_details->team;
        $matchData['short_name'] = $team1_details->short_name . ' vs ' . $team2_details->short_name;
        $matchData['season'] = @$input['season'] ? $input['season'] : '';
        $matchData['title'] = $team1_details->short_name . ' vs ' . $team2_details->short_name;
        $matchData['team1'] = $input['team1'];
        $matchData['team2'] = $input['team2'];
        $matchData['team1display'] = $team1_details->short_name;
        $matchData['team2display'] = $team2_details->short_name;
        $matchData['series'] = $input['series'];
        $matchData['status'] = 'pending';
        $matchData['squadstatus'] = 'yes';
        $matchData['final_status'] = 'pending';
        $matchData['launch_status'] = 'pending';
        $matchData['start_date'] = date('Y-m-d H:i:s', strtotime($input['start_date']));
        $matchData['format'] = $input['format'];
        $matchData['matchkey'] = $matchkey;
        $matchData['sport_type'] = $input['sport_type'];

        $insertId = DB::table('listmatches')->insertGetId($matchData);

        if ($insertId > 0) {
          if (isset($input['team2_player'])) {
            foreach ($input['team2_player'] as $value) {
              $playerid = $value;
              $playerkey = DB::table('players')->where('id', $playerid)->select('player_key', 'credit', 'fiveplus_credit', 'role')->first();
              $query = "INSERT INTO matchplayers (matchkey,player_key,playerid,points,role,credit,fiveplus_credit,name) SELECT '" . $matchkey . "' as matchkey,'" . $playerkey->player_key . "' as player_key, '" . $playerid . "' as playerid, '0' as points, role, credit, fiveplus_credit,player_name FROM players WHERE id='" . $playerid . "'";
              DB::statement($query);
            }
          }

          if (isset($input['team1_player'])) {
            foreach ($input['team1_player'] as $value) {
              $playerid = $value;
              $playerkey = DB::table('players')->where('id', $playerid)->select('player_key', 'credit', 'fiveplus_credit', 'role')->first();
              $query = "INSERT INTO matchplayers (matchkey,player_key,playerid,points,role,credit,fiveplus_credit,name) SELECT '" . $matchkey . "' as matchkey,'" . $playerkey->player_key . "' as player_key, '" . $playerid . "' as playerid, '0' as points, role, credit, fiveplus_credit,player_name FROM players WHERE id='" . $playerid . "'";
              DB::statement($query);
            }
          }
        }
        //		Session::flash('success',  trans("Match Saved Successfully!"));
        Session::flash('flash_notice', 'Match Saved Successfully!');
        return Redirect::back();
        //Session::flash('message', 'Match Saved Successfully!');
        // Session::flash('alert-class', 'alert-success');
      }
    }
    $currentdate = date('Y-m-d');
    $teams = DB::table('teams')->select('id', 'team')->get();
    $sport_types = DB::table('sport_types')->select('id', 'sport_name')->where('status', 1)->get();
    $findallseries = DB::table('series')->where('series_status', '!=', 'completed')->where('end_date', '>=', $currentdate)->orderBY('start_date', 'ASC')->get();

    return view("admin.$this->model.add_match", compact('teams', 'findallseries', 'sport_types'));
  }

  public function getTeamPlayers(Request $request)
  {
    $formData = $request->all();
    $players = DB::table('players')->where("team", $formData['team_id'])->select("id", "player_name")->get();
    return response()->json(["players" => $players]);
  }

  //Edit Match//
  public function edit_match($matchkey, Request $request)
  {

    date_default_timezone_set('Asia/Kolkata');
    if ($request->isMethod('post')) {
      $input = Input::all();
      unset($input['_token']);

      $team1_details = DB::table('teams')->where('id', $input['team1'])->first();
      $team2_details = DB::table('teams')->where('id', $input['team2'])->first();

      $matchData['name'] = $team1_details->team . ' vs ' . $team2_details->team;
      $matchData['short_name'] = $team1_details->short_name . ' vs ' . $team2_details->short_name;
      // $matchData['season'] = $input['season'];
      $matchData['title'] = $team1_details->short_name . ' vs ' . $team2_details->short_name;
      $matchData['team1'] = $input['team1'];
      $matchData['team2'] = $input['team2'];
      $matchData['team1display'] = $team1_details->short_name;
      $matchData['team2display'] = $team2_details->short_name;
      $matchData['series'] = $input['series'];
      $matchData['start_date'] = date('Y-m-d H:i:s', strtotime($input['start_date']));
      $matchData['format'] = $input['format'];
      //echo "<pre>";print_r($matchData);die();

      DB::table('listmatches')->where('matchkey', $matchkey)->update($matchData);
      DB::table('matchplayers')->where('matchkey', $matchkey)->delete();

      if (isset($input['team2_player'])) {
        foreach ($input['team2_player'] as $value) {
          $playerid = $value;
          $query = "INSERT INTO matchplayers (matchkey,playerid,points,role,credit,name, sport_type) SELECT '" . $matchkey . "' as matchkey, '" . $playerid . "' as playerid, '0' as points, role, credit, player_name, sport_type FROM players WHERE id='" . $playerid . "'";
          DB::statement($query);
        }
      }
      if (isset($input['team2_player'])) {
        foreach ($input['team1_player'] as $value) {
          $playerid = $value;
          $query = "INSERT INTO matchplayers (matchkey,playerid,points,role,credit,name, sport_type) SELECT '" . $matchkey . "' as matchkey, '" . $playerid . "' as playerid, '0' as points, role, credit, player_name,sport_type FROM players  WHERE id='" . $playerid . "'";
          DB::statement($query);
        }
      }
      Session::flash('message', 'Match Update Successfully!');
      Session::flash('alert-class', 'alert-success');
    }
    // echo 1; exit;
    $currentdate = date('Y-m-d');
    $teams = DB::table('teams')->select('id', 'team')->get();
    $findallseries = DB::table('series')->where('series_status', '!=', 'completed')->where('end_date', '>=', $currentdate)->orderBY('start_date', 'ASC')->get();
    $match_detail = DB::table('listmatches')->where('matchkey', $matchkey)->first();
    $team1players = DB::table('players')->where('team', $match_detail->team1)->select('id', 'player_name')->get();
    $team2players = DB::table('players')->where('team', $match_detail->team2)->select('id', 'player_name')->get();
    $matchplayers = DB::table('matchplayers')->where('matchkey', $matchkey)->select('playerid')->get();
    return view("admin.$this->model.edit_match", compact('teams', 'findallseries', 'match_detail', 'matchplayers', 'team1players', 'team2players', 'matchkey'));
  }

  //viewedit points
  public function viewEditPoints(Request $request, $id, $sport_type = 1)
  {
    $mkey = $id;
    if ($request->isMethod('post')) {
      $post = $request->all();

      $insert_data = array();
      /*$insert_data['player_id'] = $post['player_id'];
            $insert_data['runs'] = $post['runs'];
            $insert_data['bball'] = $post['bball'];
            $insert_data['fours'] = $post['fours'];
            $insert_data['six'] = $post['six'];
            $insert_data['strike_rate'] = $post['strike_rate'];
            $insert_data['duck'] = $post['duck'];
            $insert_data['out_str'] = $post['out_str'];
            $insert_data['balls'] = $post['balls'];
            $insert_data['maiden_over'] = $post['maiden_over'];
            $insert_data['wicket'] = $post['wicket'];
            $insert_data['extra'] = $post['extra'];
            $insert_data['overs'] = $post['overs'];
            $insert_data['grun'] = $post['grun'];
            $insert_data['balldots'] = $post['balldots'];
            $insert_data['economy_rate'] = $post['economy_rate'];
            $insert_data['catch'] = $post['catch'];
            $insert_data['stumbed'] = $post['stumbed'];
            $insert_data['runouts'] = $post['runouts'];
            $insert_data['runout_thrower'] = $post['runout_thrower'];
            $insert_data['runout_catcher'] = $post['runout_catcher'];*/
      //  print_r($post); exit;
      if (isset($post['startingpoints'])) {
        DB::table('result_points')->where('matchkey', $post['matchkey'])->where('playerid', $post['player_id'])->where('resultmatch_id', $post['resultmatch_id'])
          ->update(['startingpoints' => $post['startingpoints']]);
      }

      unset($post['matchkey']);
      unset($post['submit']);
      unset($post['startingpoints']);
      unset($post['resultmatch_id']);
      DB::table('result_matches')->where('id', $post['id'])->update($post);


      Session::flash('message', 'Score updated successfully.');
      Session::flash('alert-class', 'alert-success');
      return redirect()->back();
      // print_r($post); exit;
    }
    $playerarr = array();
    $playerarrdata = unserialize(@DB::table('match_playing11')->where('match_key', $id)->first()->player_ids);
    if (!empty($playerarrdata)) {
      $playerarr = $playerarrdata;
    }
    // dd($playerarr);
    $records = DB::table('matchplayers')->Join('result_matches', function ($join) {
      $join->on('matchplayers.playerid', '=', 'result_matches.player_id');
      $join->on('matchplayers.matchkey', '=', 'result_matches.match_key');
    })->join('players', 'players.id', '=', 'matchplayers.playerid')
      ->where('matchkey', $id)
      // ->where('innings',1)
      ->whereIn('matchplayers.playerid', $playerarr)
      ->select('result_matches.*', 'players.player_name', 'matchplayers.role', 'matchplayers.matchkey')->groupBy('matchplayers.playerid')->get();
    // dd($records);
    if (!empty($records)) {
      foreach ($records as $key => $value) {
        $start_data = DB::table('result_points')
          ->where('matchkey', $value->matchkey)->where('resultmatch_id', $value->id)->first();
        $value->startingpoint = !empty($start_data->startingpoints) ? $start_data->startingpoints : 0;
        $value->resultmatch_id = !empty($start_data->resultmatch_id) ? $start_data->resultmatch_id : 0;
      }
    }
    $match_detail = DB::table('listmatches')->where('matchkey', $id)
      ->join('teams as t1', 't1.id', '=', 'listmatches.team1')
      ->join('teams as t2', 't2.id', '=', 'listmatches.team2')
      ->select('t1.team_key as team1_key', 't2.team_key as team2_key', 'team1', 'team2')
      ->get();
    //echo "<pre>";print_r($records);die();

    $teamscore1 = array();
    $teamscore2 = array();
    foreach ($match_detail as $key => $value) {
      $team1 = DB::table('teams')
        ->where('id', $value->team1)
        ->select('short_name')->first();
      $team2 = DB::table('teams')->where('id', $value->team2)
        ->select('short_name')->first();
    }

    $teamsScore = DB::table('matchruns')->where('matchkey', $id)
      ->where('sport_type', $sport_type)->first();
    if (!empty($teamsScore)) {
      $teamscore1['teamname'] = $team1->short_name;
      $teamscore1['score'] = $teamsScore->runs1;
      $teamscore1['wickets'] = $teamsScore->wickets1;
      $teamscore1['overs'] = $teamsScore->overs1;
      $teamscore2['teamname'] = $team2->short_name;
      $teamscore2['score'] = $teamsScore->runs2;
      $teamscore2['wickets'] = $teamsScore->wickets2;
      $teamscore2['overs'] = $teamsScore->overs2;
    } else {
      $teamscore1['score'] = 0;
      $teamscore1['teamname'] = $team1->short_name;
      $teamscore2['score'] = 0;
      $teamscore2['teamname'] = $team2->short_name;
      $teamscore1['wickets'] = 0;
      $teamscore1['overs'] = 0;
      $teamscore2['wickets'] = 0;
      $teamscore2['overs'] = 0;
    }

    return view("admin.$this->model.view_points", compact('records', 'match_detail', 'sport_type', 'mkey', 'teamscore1', 'teamscore2'));
  }

  //update all points
  public function updateAllPoints($matchkey)
  {
    $findmatchtype = DB::table('listmatches')->where('matchkey', $matchkey)->first();
    $sport_type = DB::table('sport_types')->where('id', $findmatchtype->sport_type)->first();
    $updatatype = 1;
    if ($sport_type->id == 7) {
      $updatatype = 7;
    }
    $this->player_point($matchkey, $findmatchtype->format, $sport_type->sport_key, $updatatype);
    $refunded = MatchesController::refund_amount($matchkey, $sport_type->id);
    Session::flash('message', 'Score updated successfully.');
    Session::flash('alert-class', 'alert-success');
    return redirect()->back();
  }

  //addlineup
  public function addlinup(Request $request, $id)
  {
    if ($request->isMethod('post')) {
      $post = $request->all();
      // print_r($post); exit;
      $matchkey = $post['matchid'];
      // $checkForLineup = DB::table('listmatches')->where('matchkey', $matchkey)->where('playing11_status',-1)->first();
      /*$checkForLineup = DB::table('listmatches')->where('matchkey', $matchkey)->first();
            if(!empty($checkForLineup)) {
                $this->showplaying($post['matchid'], $post['playing_11_team']);
            } else {
                // $this->updateLineup($post['matchid'], $post['playing_11_team']);
            }*/

      $players = $post['playing_11_team'];
      $insert_data = array(

        "match_key" => $matchkey,

        "player_ids" => serialize($players),

      );
      DB::table('match_playing11')->where('match_key', $matchkey)->delete();
      DB::table('match_playing11')->insert($insert_data);
      /*$scorecard_name = $post['scorecard_name'];
            $update_data['scorecard_name'] = $scorecard_name;
            DB::table('listmatches')->where('matchkey', $matchkey)->update($update_data);*/
      $finalplayingteams = $post['playing_11_team'];
      //print_r($finalplayingteams); //exit;
      foreach ($finalplayingteams as $playing_player) {
        $datasv = array();
        $player_id = $playing_player;
        $datasv['player_id'] = $player_id;
        $datasv['starting11'] = 1;
        $datasv['match_key'] = $matchkey;
        $datasv['innings'] = 1;
        // print_r($datasv); exit;
        //Match Player Insert Data
        $player = DB::table('matchplayers')->join('players', 'players.id', '=', 'matchplayers.playerid')->where('matchkey', $matchkey)->select('matchplayers.*', 'players.player_key', 'players.role as playerrole')->where('players.id', $player_id)->first();
        // print_r(expression)
        if (!empty($player)) {
          $datasv['player_key'] = $player->player_key;
          $findplayerex = DB::table('result_matches')->where('player_id', $player_id)->where('match_key', $matchkey)->where('innings', 1)->select('id')->first();

          // print_r($datasv); exit;

          if (empty($findplayerex)) {


            try {

              DB::table('result_matches')->insert($datasv);
            } catch (\Illuminate\Database\QueryException $ex) {

              dd($ex->getMessage());

              // Note any method of class PDOException can be called on $ex.

            }
          }
        } else {
          /*$matchplayers_data['playerid'] = $player_id;
                        $matchplayers_data['matchkey'] = $matchkey;
                        DB::table('matchplayers')->insert($matchplayers_data);

                        $datasv['player_id'] =$player_id;

                        $datasv['starting11'] =1;

                        $datasv['match_key'] =$matchkey;

                        $datasv['innings'] =1;
                        DB::table('result_matches')->insert($datasv);*/
        }
      } //exit;

      Helpers::logActivity('Lineup added successfully processed!', $matchkey);

      return redirect()->back()->with('success', 'Lineup added successfully processed');
    }
    $match_detail = DB::table('listmatches')->join('teams as team1', 'team1.id', '=', 'listmatches.team1')->join('teams as team2', 'team2.id', '=', 'listmatches.team2')->where('matchkey', $id)->select('listmatches.*', 'team1.team as team1_name', 'team1.logo as team1_logo', 'team1.short_name as team1_short_name', 'team2.team as team2_name', 'team2.logo as team2_logo', 'team2.short_name as team2_short_name')->first();

    $players = DB::table('players')->join('matchplayers', function ($join) use ($match_detail) {
      $join->on('players.id', '=', 'matchplayers.playerid');
      $join->on('matchplayers.matchkey', '=', DB::raw("'" . $match_detail->matchkey . "'"));
    })
      //->where('matchkey', $id)
      ->whereIn('team', array($match_detail->team1, $match_detail->team2))->select('players.*')->groupBy('players.id')->get();
    $team1_players = array();
    $team2_players = array();
    foreach ($players as $key => $value) {
      if ($value->team == $match_detail->team1) {
        $team1_players[] = $value;
      } else {
        $team2_players[] = $value;
      }
    }
    $playing = DB::table('match_playing11')->where('match_key', $match_detail->matchkey)->first();
    $playing = @$playing->player_ids;
    $selectedPlaying = unserialize($playing);
    if (!$selectedPlaying) {
      $selectedPlaying = array();
    }

    $ids = $id;

    // var_dump($selectedPlaying);exit;
    // return view("admin.$this->model.lineup",compact('match_detail','team1_players','team2_players','playing' , 'selectedPlaying'));
    // print_r($team2_players); exit;
    // print_r($playing); exit;
    return view("admin.$this->model.lineup", compact('match_detail', 'team1_players', 'team2_players', 'playing', 'selectedPlaying', 'ids'));
  }

  public function showplaying($match_key, $match_playing_array = array())
  {
    $checkmath = DB::table('listmatches')->where('matchkey', $match_key)->where('playing11_status', '-1')->select('playing11_status')->first();
    if (!empty($checkmath)) {
      // $giveresresult = Cricketapi2Controller::getmatchdetails($match_key);
      $finalplayingteams = $match_playing_array;
      // print_r($giveresresult); exit;
      if (!empty($finalplayingteams)) {
        foreach ($finalplayingteams as $vall1) {
          $getid = array();
          $getid = DB::table('players')->join('matchplayers', 'matchplayers.playerid', '=', 'players.id')->where('matchplayers.matchkey', $match_key)->where('matchplayers.playerid', $vall1)->select('matchplayers.id')->first();
          if (!empty($getid)) {
            $dddjdh['playingstatus'] = 1;
            $dddjdh1ss['status'] = 1;
            // if($getid->id==13590 || $getid->id==13582) {

            //     $dddjdh['playingstatus'] = 0;
            //     $dddjdh1ss['status'] = 0;
            //    }
            DB::table('matchplayers')->where('id', $getid->id)->update($dddjdh);

            DB::table('vote_players_list')->where('playerid', $getid->id)->update($dddjdh1ss);
          }
        }
      }
      if (!empty($finalplayingteams)) {
        $i = 0;
        $dddjdh2['playingstatus'] = 0;
        DB::table('matchplayers')->where('matchplayers.matchkey', $match_key)->where('playingstatus', '!=', '1')->update($dddjdh2);
        $nonpalying = DB::table('matchplayers')->where('playingstatus', '0')->get();

        foreach ($nonpalying as $value) {
          $playeridd = $value->id;
          $playdatas = DB::table('joinedleauges')->where('matchkey', $match_key)->where('playerid', $playeridd)->where('status', '!=', '2')->get();
          // echo "<pre>"; print_r($playdatas);
          if (!empty($playdatas)) {
            foreach ($playdatas as $joinplay) {
              $entryfee = 0;

              if ($joinplay->type == 'sell') {
                $playerdata = DB::table('matchplayers')->where('id', $joinplay->playerid)->select('sell_rate', 'new_sell_rate')->first();
                if ($joinplay->sell_rate == '0') {
                  if ($playerdata->new_sell_rate != '0') {
                    $entryfee = $playerdata->new_sell_rate * $joinplay->shares;
                  } else {
                    $entryfee = $playerdata->sell_rate * $joinplay->shares;
                  }
                } else {
                  $entryfee = $joinplay->sell_rate * $joinplay->shares;
                }
              } else if ($joinplay->type == 'buy') {
                $playerdata = DB::table('matchplayers')->where('id', $joinplay->playerid)->select('buy_rate', 'new_buy_rate')->first();
                if ($joinplay->buy_rate == '0') {
                  if ($playerdata->new_buy_rate != '0') {
                    $entryfee = $playerdata->new_buy_rate * $joinplay->shares;
                  } else {
                    $entryfee = $playerdata->buy_rate * $joinplay->shares;
                  }
                } else {
                  $entryfee = $joinplay->buy_rate * $joinplay->shares;
                }
              }
              $getresponse = $this->refundprocess($joinplay->id, $entryfee, $match_key, 'Request Canceled');
              if ($getresponse == true) {
                $data['status'] = '2';
                DB::table('joinedleauges')->where('id', $joinplay->id)->update($data);
              }
            }
          }
        }

        $playingstat['playing11_status'] = '1';
        DB::table('listmatches')->where('matchkey', $match_key)->update($playingstat);
      }
    }
  }

  public function updateMatchStatus(Request $request, $matchkey, $isReviewed, $completed)
  {
    if ($isReviewed == 'IsReviewed' && $completed == 'completed') {
      $updateData['final_status'] = $isReviewed;
      $updateData['status'] = $completed;
      $match_detail = DB::table('listmatches')->where('matchkey', $matchkey)->get();
      if (!empty($match_detail)) {
        DB::table('listmatches')->where('matchkey', $matchkey)->update($updateData);
        return Redirect::back()->with('success', 'Successfully updated status.');
      } else {
        return Redirect::back()->with('danger', 'Match not found.');
      }
    } else {
      return Redirect::back()->with('danger', 'Status wrong!');
    }
  }

  public function liveScoresCron($matchkey = '', $sport_type = 1)
  {
    die;
    if (empty($matchkey)) {
      date_default_timezone_set('Asia/Kolkata');
      $findmatchexist = DB::table('listmatches')
        ->whereDate('start_date', '<=', date('Y-m-d'))
        ->where('launch_status', 'launched')->where('final_status', '!=', 'winnerdeclared')
        ->where('final_status', '!=', 'IsCanceled')->where('final_status', '!=', 'IsAbandoned')
        ->where('status', '!=', 'completed')->where('sport_type', 1)->orderBy('id', 'DESC')
        ->get();
      // print_r($findmatchexist);die;
      foreach ($findmatchexist as $key => $value) {
        $matchkey = $value->matchkey;
        if (!empty($matchkey)) {
          $comp_id = DB::table('listmatches')->where('matchkey', $matchkey)
            ->where('sport_type', 1)
            ->select('competition_id')
            ->first();
          $update_return =  $this->update_live_score_cards($matchkey, $sport_type, $comp_id->competition_id);
        }
      }
    } else {
      // echo "ds";die;
      if (!empty($matchkey)) {
        $comp_id = DB::table('listmatches')->where('matchkey', $matchkey)
          ->where('sport_type', 1)
          ->select('competition_id')
          ->first();
        $update_return =  $this->update_live_score_cards($matchkey, $sport_type, $comp_id->competition_id);
      }
    }
  }


  public function livematch()
  {
    $live_data = DB::table('listmatches')->where('status', 'started')->where('launch_status', 'launched')->get();

    return view('admin.Matches.live_match_detail', compact('live_data'));
  }
  public function live_details($matchkey)
  {
    $live_match_data = DB::table('live_teams_score')->where('matchkey', $matchkey)
      ->get();

    $team1 = $live_match_data[0]->team_id;
    $team2 = $live_match_data[1]->team_id;

    $live_data_details =  DB::table('teams')->where('team_key', $team1)->get();
    $team3 = $live_data_details[0]->team;
    $team1_data = array($team3);
    $live_data_details =  DB::table('teams')->where('team_key', $team2)->get();
    $team4 = $live_data_details[0]->team;
    $team2_data = array($team4);
    ///Bowlers Score For Innings 1 and 2 for team 1////
    $live_bowlers_score1 =  DB::table('live_bowlers_score')->where('team_id', $team1)
      ->where('inning', '=', 1)->get();
    $live_bowlers_score2 =  DB::table('live_bowlers_score')->where('team_id', $team1)
      ->where('inning', '=', 2)->get();
    $live_bowlers_score3 =  DB::table('live_bowlers_score')->where('team_id', $team2)
      ->where('inning', '=', 1)->get();
    $live_bowlers_score4 =  DB::table('live_bowlers_score')->where('team_id', $team2)
      ->where('inning', '=', 2)->get();

    $live_players_score1 =  DB::table('live_players_score')->where('team_id', $team1)
      ->where('inning', '=', 1)->get();
    $live_players_score2 =  DB::table('live_players_score')->where('team_id', $team1)
      ->where('inning', '=', 2)->get();
    $live_players_score3 =  DB::table('live_players_score')->where('team_id', $team2)
      ->where('inning', '=', 1)->get();
    $live_players_score4 =  DB::table('live_players_score')->where('team_id', $team2)
      ->where('inning', '=', 2)->get();

    return view('admin.Matches.view_live_match', compact('live_match_data', 'team2_data', 'team1_data', 'live_bowlers_score1', 'live_bowlers_score2', 'live_bowlers_score3', 'live_bowlers_score4', 'live_players_score1', 'live_players_score2', 'live_players_score3', 'live_players_score4'));
  }

  public function liveMatches($sport_type = 1)
  {
    $sportTypes = DB::table('sport_types')->where('admin_status', 1)->get();
    $formData = Input::all();
    // echo "dsds"; die($sport_type);
    if (!empty($formData)) {

      return Datatables::of(DB::table('series as s')
        ->join('listmatches as lm', 'lm.series', '=', 's.id')
        ->join('matchchallenges as mc', 'mc.matchkey', '=', 'lm.matchkey')
        // ->where('lm.status','started')->where('lm.launch_status','launched')
        ->whereIn('lm.final_status', ['pending', 'isReviewed'])
        ->where('lm.sport_type', $sport_type)
        ->select('mc.id as matchchallenges_id', 'lm.title as listmatches_title', 'lm.start_date as listmatches_start_date', 'lm.matchkey as listmatches_matchkey', 's.id as series_id', 'lm.status as listmatches_status', 'lm.launch_status as listmatches_launch_status', 'lm.final_status as listmatches_final_status', 'lm.sport_type as listmatches_sport_key',   DB::raw('count(mc.matchkey) as total_challenge'), DB::raw('sum(mc.joinedusers) as total_joinedusers'))
        ->groupBY('lm.matchkey')
        ->orderBy('lm.start_date', 'ASC')
        ->get())
        ->addIndexColumn()
        ->addColumn('id', function ($result) {
          return $result->series_id;
        })
        ->addColumn('match_name', function ($result) {
          $cancelconcount = DB::table('matchchallenges')
            //  ->join('joinedleauges','matchchallenges.id','=','joinedleauges.challengeid')
            ->where('matchchallenges.matchkey', $result->listmatches_matchkey)
            ->where('matchchallenges.status', 'canceled')
            ->count();
          $cancelconcount = !empty($cancelconcount) ? $cancelconcount : 0;


          $joinuserunique = DB::table('joinedleauges')->where('joinedleauges.matchkey', $result->listmatches_matchkey)->groupBy('joinedleauges.userid')->get();

          if ($result->listmatches_status == 'started') {
            $matchstatus = "Live";
          } else if ($result->listmatches_status == 'canceled') {
            $matchstatus = "Canceled";
          } else {
            $matchstatus = $result->listmatches_final_status;
          }
          // <p>
          // <a href="'.route($this->model.'.join_users',[$result->listmatches_matchkey,$result->listmatches_sport_key]).'">Join Persons : '.$result->total_joinedusers.'</a>
          // </p>
          return '<p><u><a href="' . route($this->model . '.match_points', [$result->listmatches_matchkey, $result->listmatches_sport_key]) . '">' . $result->listmatches_title . '</a></u></p>
          <p>' . date('l, d-M-y h:i:s a', strtotime($result->listmatches_start_date)) . '</p>
          <p><u><a href="' . route('Challenges.create_challenges', ['matchid' => $result->listmatches_matchkey]) . '">Total Challenges2 : ' . $result->total_challenge . '</a></p>
          <p><a href="' . route($this->model . '.join_users', [$result->listmatches_matchkey, $result->listmatches_sport_key]) . '">Join Persons : ' . count($joinuserunique) . '</a></p>
         <p><a >Match status :' . $matchstatus . '</a></p>
          <p><a href="' . route($this->model . '.contest_cancel', [$result->listmatches_matchkey, $result->listmatches_sport_key]) . '">Canceled Contest : ' . $cancelconcount . '</a></p>';
        })
        ->addColumn('action', function ($result) {
          $action = '';
          $edit_match = '';

          $action = '<a class="btn btn-danger action-btn" href="' . route($this->model . '.contest_refund_amount', [$result->listmatches_matchkey, $result->listmatches_sport_key]) . '">Not filled Contest Refund</a>
        <a class="btn btn-success action-btn" href="' . route($this->model . '.addlinup', $result->listmatches_matchkey) . '">Add/Edit Lineup</a>
            <a class="btn btn-success action-btn" href="' . route($this->model . '.viewEditPoints', [$result->listmatches_matchkey, $result->listmatches_sport_key]) . '">View/Edit points</a>';
          if ($result->listmatches_final_status != 'winnerdeclared') {
            $edit_match = ' <a class="btn btn-info action-btn" href="' . route($this->model . '.editmatch', [$result->listmatches_matchkey, $result->listmatches_sport_key]) . '">Edit Match</a>';
          }
          return  $action
            . $edit_match;
        })
        ->addColumn('match_status', function ($result) {
          $final_status_not_winnerdeclared = '';
          $final_status = '';

          if ($result->listmatches_final_status != 'winnerdeclared') {
            $final_status_not_winnerdeclared = '<div class="col-md-12 col-sm-12 mb-2" style="padding:0px;">
            <form action="' . route($this->model . '.update_manually') . '" method="post" class="pt-2">
              ' . csrf_field() . '
              <input type="hidden" value="' . $result->listmatches_matchkey . '" name="matchkey">
              <select class="form-control in_text w-65" name="final_status">
                <option value=""> Select status </option>
                <option value="pending"> Pending </option>
                <option value="IsReviewed"> IsReviewed </option>
              </select>
              <button class="btn btn-info ml-2 cust-padd"><i class="fa fa-refresh mr-2"></i>Update Status</button>
              <div class="col-md-12 col-sm-12"  style="margin-top:10px;">

              </div>
              </form>
            </div>';
          }

          if ($result->listmatches_final_status == 'pending') {

            $final_status = '<p class="mb-0 "><u><a class="btn btn-danger action-btn action-status"  onclick="confirm("Are you sure?")" href="' . route($this->model . '.update_match_final_status', [$result->listmatches_matchkey, $result->listmatches_sport_key, 'IsAbandoned']) . '">Match Abandoned </a></u></p>
            <p class="mb-0"><u><a class="btn btn-danger action-btn action-status" onclick="confirm("Are you sure?")" href="' . route($this->model . '.update_match_final_status', [$result->listmatches_matchkey, $result->listmatches_sport_key, 'IsCanceled']) . '">Match Canceled</a></u></p>';
            if ($result->listmatches_status == 'started') {
              $final_status .= '<p class="mb-0"><u><a style="color:red;" onclick="confirm("Are you sure?")" href="' . route($this->model . '.update_match_final_status', [$result->listmatches_matchkey, $result->listmatches_sport_key, 'IsClosed']) . '">IsClosed</a></u></p>';
            }
          } else if ($result->listmatches_final_status == 'IsReviewed') {
            $final_status = '<p class="mb-0"><u><a style="color:red;" onclick="confirm("Are you sure?")" href="' . route($this->model . '.match_points', [$result->listmatches_matchkey, $result->listmatches_sport_key]) . '">IsReviwed</a></u></p>
            <p class="mb-0"><u><a style="color:red;" onclick="confirm("Are you sure?")" href="' . route($this->model . '.update_match_final_status', [$result->listmatches_matchkey, $result->listmatches_sport_key, 'winnerdeclared']) . '">IsWinnerDeclared</a></u></p>';
          }
          return  $final_status_not_winnerdeclared
            . $final_status;
        })
        ->escapeColumns([])
        ->make(true);
    }

    return view('admin.Matches.live-matches', compact('sportTypes', 'sport_type'));
  }

  public function contest_refund_amount($match_key = '60919_2', $sport_type = '1')
  {
    // echo 1; exit;
    date_default_timezone_set('Asia/Kolkata');
    $listmatches = DB::table('listmatches')
      ->where('matchkey', $match_key)
      ->where('sport_type', $sport_type)
      ->first();

    // dd($listmatches);
    $getcurrentdate = date('Y-m-d H:i:s');
    if (!empty($listmatches)) {
      $matchtimings = @$listmatches->start_date;
    }

    // echo $getcurrentdate ."<".$matchtimings; exit;
    if ($getcurrentdate < $matchtimings) {
      return redirect()->back();
    }

    if ($listmatches->refund == 1) {
      return redirect()->back();
    }

    $joinedleauges = DB::table('joinedleauges')
      ->where('matchkey', $match_key)
      ->where('sport_type', $sport_type)
      ->select('challengeid', 'userid', 'id')
      ->groupBy('challengeid')->get();
    //echo "<pre>"; print_r($joinedleauges); exit;

    foreach ($joinedleauges as $val1) {
      $matchchallenges = DB::table('matchchallenges')
        ->where('id', $val1->challengeid)
        ->where('status', '!=', 'canceled')->get();
      foreach ($matchchallenges as $val2) {
        if (($val2->maximum_user > $val2->joinedusers && $val2->challenge_type == 'money') || ($val2->challenge_type == 'percentage' &&  $val2->joinedusers < $val2->minimum_user)) {

          if ($val2->joinedusers > 1 && $val2->is_flexible == 1) {
            continue;
          }

          //if($val2->confirmed_challenge==0 || ($val2->confirmed_challenge==1 && $val2->joinedusers == 1) ){
          if ($val2->confirmed_challenge == 0 &&  $val2->joinedusers < $val2->minimum_user) {


            if ($match_key == 'c.match.kista_cricket_club_vs_stockholm_mumbai_indians.0ce83') {
              $league_match_key = 'c.match.kista_cricket_club_vs_stockholm_mumbai_ind';
            } else {
              $league_match_key = $match_key;
            }
            // echo($league_match_key);DIE;
            $leaugestransactions = DB::table('leaugestransactions')
              ->where('matchkey', $league_match_key)
              ->where('challengeid', $val1->challengeid)->get();
            // dd($leaugestransactions);
            foreach ($leaugestransactions as $val3) {
              $entryfee = $val2->entryfee;
              $findlastow = DB::table('userbalances')->where('user_id', $val3->user_id)->first();
              if (!empty($findlastow)) {


                $dasts['status'] = 'canceled';
                DB::table('matchchallenges')->where('id', $val2->id)->update($dasts);
                // entry in refund //
                $refunddata['userid'] = $val3->user_id;
                $refunddata['amount'] = $entryfee;
                $refunddata['joinid'] = $val3->joinid;
                $refunddata['challengeid'] = $val3->challengeid;
                $refunddata['reason'] = 'Challenge cancel';
                $refunddata['matchkey'] = $match_key;
                //$findifalreadyrefund = DB::table('refunds')->where('joinid',$val3->joinid)->first();
                try {
                  DB::table('refunds')->insert($refunddata); // end entry in refund data//

                  //Update User Balance
                  $dataq['balance'] =  $findlastow->balance + $val3->balance;
                  $dataq['winning'] =  $findlastow->winning + $val3->winning;
                  $dataq['bonus'] =  $findlastow->bonus + $val3->bonus;
                  $dataq['gst_bonus'] =  $findlastow->gst_bonus + $val3->gst_bonus;
                  $dataq['affiliation_commission'] =  $findlastow->affiliation_commission + $val3->affiliation_commission;
                  // $dataq['perks'] =  $findlastow->perks-($val3->winning + $val3->balance);
                  DB::table('userbalances')->where('id', $findlastow->id)->update($dataq);



                  //transactions//
                  $registeruserdetails = DB::table('registerusers')->where('id', $val3->user_id)->first();
                  $datatr['transaction_id'] = 'PlaynWin11-REFUND-' . rand(100, 999) . $val3->user_id;
                  $datatr['type'] = 'Refund amount';
                  $datatr['transaction_by'] = 'PlaynWin11';
                  $datatr['amount'] = $entryfee;
                  $datatr['paymentstatus'] = 'confirmed';
                  $datatr['challengeid'] = $val3->challengeid;
                  $datatr['bonus_amt'] = $val3->bonus;
                  $datatr['win_amt'] = $val3->winning;
                  $datatr['gst_bonus_amt'] = $val3->gst_bonus;
                  $datatr['addfund_amt'] = $val3->balance;
                  $datatr['bal_bonus_amt'] = $dataq['bonus'];
                  $datatr['bal_win_amt'] = $dataq['winning'];
                  $datatr['bal_fund_amt'] = $dataq['balance'];
                  $datatr['bal_gst_bonus_amt'] = $dataq['gst_bonus'];
                  $datatr['bal_affi_amt'] = $dataq['affiliation_commission'];
                  $datatr['userid'] = $val3->user_id;
                  $datatr['total_available_amt'] = $dataq['balance'] + $dataq['winning'] + $dataq['bonus'] + $dataq['gst_bonus'] + $dataq['affiliation_commission'];
                  DB::table('transactions')->insert($datatr);
                  //mail//
                  $challengename = "";
                  if ($val2->name != "") {
                    $challengename = $val2->name;
                  } else {
                    $challengename = 'Win-' . $val2->win_amount;
                  }
                  $email = $registeruserdetails->email;
                  $emailsubject = 'Challenge Cancelled-Refund initiated!';
                  $content = '<p><strong>Dear Challenger </strong></p>';
                  $content .= '<p>Unfortunately the challenge ' . $challengename . ' of match ' . date('M d Y h:i:a', strtotime($listmatches->start_date)) . ' ' . $listmatches->title . ' has cancelled due to lack of users and your entry fee for the match is getting refunded back to your CLUB11 wallet.</p>';
                  $msg = Helpers::mailheader();
                  $msg .= Helpers::mailbody($content);
                  $msg .= Helpers::mailfooter();
                  // Helpers::mailsentFormat($email,$emailsubject,$msg);
                  //notifications//
                  $datan['title'] = 'Refund Amount of ₹' . $val2->entryfee . ' for challenge cancellation';
                  $datan['userid'] = $val3->user_id;
                  DB::table('notifications')->insert($datan);
                  // DB::table('listmatches')
                  // ->where('matchkey',$match_key)
                  // ->where('sport_type',$sport_type)
                  // ->update(['final_status'=>'IsCanceled']);

                } catch (\Illuminate\Database\QueryException $ex) {
                  // echo $ex->getMessage();
                  // echo 'yes'; exit;
                  continue;
                }
              }
            }
          }
        }
      }
    }

    if ($getcurrentdate > date('Y-m-d H:i:s', strtotime('+15 minutes', strtotime($matchtimings)))) {
      DB::table('listmatches')->where('id', $listmatches->id)->update(array("refund" => 1));
    }
    Session::flash('message', 'Refund successfully....');
    Session::flash('alert-class', 'alert-success');
    return redirect()->back();
    // print_r($post); exit;
  }

  public function contest_refund_amount_old($match_key = '60984', $sport_type = '1')
  {

    date_default_timezone_set('Asia/Kolkata');

    $joinedleauges = DB::table('joinedleauges')->where('matchkey', $match_key)->select('challengeid', 'userid', 'id')->groupBy('challengeid')->get();
    $listmatches = DB::table('listmatches')->where('matchkey', $match_key)->first(); //

    print_r($listmatches);

    $getcurrentdate = date('Y-m-d H:i:s');
    // echo $getcurrentdate;
    $matchtimings = $listmatches->start_date;

    if ($getcurrentdate < $matchtimings) {
      return true;
    }

    foreach ($joinedleauges as $val1) {
      $matchchallenges = DB::table('matchchallenges')->where('id', $val1->challengeid)->where('status', '!=', 'canceled')->get();
      foreach ($matchchallenges as $val2) {
        if (($val2->maximum_user > $val2->joinedusers && $val2->challenge_type == 'money') || ($val2->challenge_type == 'percentage' &&  $val2->joinedusers < $val2->minimum_user)) {

          if ($val2->joinedusers > 1 && $val2->is_flexible == 1) {
            continue;
          }

          if ($val2->confirmed_challenge == 0 || ($val2->confirmed_challenge == 1 && $val2->joinedusers == 1)) {

            if (0) {
              $league_match_key = 'c.match.kista_cricket_club_vs_stockholm_mumbai_ind';
            } else {
              $league_match_key = $match_key;
            }
            // echo($league_match_key);DIE;
            $leaugestransactions = DB::table('leaugestransactions')->where('matchkey', $league_match_key)->where('challengeid', $val1->challengeid)->get();
            foreach ($leaugestransactions as $val3) {
              $entryfee = $val2->entryfee;
              $findlastow = DB::table('userbalances')->where('user_id', $val3->user_id)->first();
              if (!empty($findlastow)) {


                $dasts['status'] = 'canceled';
                DB::table('matchchallenges')->where('id', $val2->id)->update($dasts);
                // entry in refund //
                $refunddata['userid'] = $val3->user_id;
                $refunddata['amount'] = $entryfee;
                $refunddata['joinid'] = $val3->joinid;
                $refunddata['challengeid'] = $val3->challengeid;
                $refunddata['reason'] = 'Contest cancel';
                $refunddata['matchkey'] = $match_key;
                //$findifalreadyrefund = DB::table('refunds')->where('joinid',$val3->joinid)->first();
                try {
                  DB::table('refunds')->insert($refunddata); // end entry in refund data//

                  //Update User Balance
                  $dataq['balance'] =  $findlastow->balance + $val3->balance;
                  $dataq['winning'] =  $findlastow->winning + $val3->winning;
                  $dataq['bonus'] =  $findlastow->bonus + $val3->bonus;
                  // $dataq['perks'] =  $findlastow->perks-($val3->winning + $val3->balance);
                  DB::table('userbalances')->where('id', $findlastow->id)->update($dataq);



                  //transactions//
                  $registeruserdetails = DB::table('registerusers')->where('id', $val3->user_id)->first();
                  $datatr['transaction_id'] = BRAND['name'] . '-REFUND-' . rand(100, 999) . $val3->user_id;
                  $datatr['type'] = 'Refund amount';
                  $datatr['transaction_by'] = BRAND['name'];
                  $datatr['amount'] = $entryfee;
                  $datatr['paymentstatus'] = 'confirmed';
                  $datatr['challengeid'] = $val3->challengeid;
                  $datatr['bonus_amt'] = $val3->bonus;
                  $datatr['win_amt'] = $val3->winning;
                  $datatr['addfund_amt'] = $val3->balance;
                  $datatr['bal_bonus_amt'] = $dataq['bonus'];
                  $datatr['bal_win_amt'] = $dataq['winning'];
                  $datatr['bal_fund_amt'] = $dataq['balance'];
                  $datatr['userid'] = $val3->user_id;
                  $datatr['total_available_amt'] = $dataq['balance'] + $dataq['winning'] + $dataq['bonus'];
                  DB::table('transactions')->insert($datatr);
                  //mail//
                  $challengename = "";
                  if ($val2->name != "") {
                    $challengename = $val2->name;
                  } else {
                    $challengename = 'Win-' . $val2->win_amount;
                  }
                  // $email = $registeruserdetails->email;
                  // $emailsubject = 'Contest Cancelled-Refund initiated!';
                  // $content='<p><strong>Dear Challenger </strong></p>';
                  // $content.='<p>Unfortunately the contest '.$challengename.' of match '.date('M d Y h:i:a',strtotime($listmatches->start_date)).' '.$listmatches->title.' has cancelled due to lack of users and your entry fee for the match is getting refunded back to your CLUB11 wallet.</p>';
                  // $msg = Helpers::mailheader();
                  // $msg.= Helpers::mailbody($content);
                  // $msg.= Helpers::mailfooter();
                  // // Helpers::mailsentFormat($email,$emailsubject,$msg);
                  // //notifications//
                  // $datan['title'] = 'Refund Amount of ₹'.$val2->entryfee.' for contest cancellation';
                  // $datan['userid'] = $val3->user_id;
                  // DB::table('notifications')->insert($datan);

                } catch (\Illuminate\Database\QueryException $ex) {
                  echo $ex->getMessage();
                  echo 'yes';
                  exit;
                }
              }
            }
          }
        }
      }
    }
    return 1;
  }

  public function custom_update_leaderboard($matchkey)
  {
    //die('died');

    $listmatchdetail = DB::table('listmatches')->where('matchkey', $matchkey)->select('final_status', 'status')->first();

    $matchchallenges = DB::table('matchchallenges')
      ->where('matchchallenges.status', '!=', 'canceled')
      ->where('matchchallenges.joinedusers', '>', 0)
      ->where('matchchallenges.matchkey', $matchkey)
      ->orderBy('matchchallenges.joinedusers', 'DESC')
      ->get();
    // echo '<pre>';
    // print_r($matchchallenges);die;

    $challarr = array();
    foreach ($matchchallenges as $key => $value) {
      $challarr[] = $value->id;
    }


    $resjoinedteams =  DB::table('joinedleauges')
      ->whereIn('joinedleauges.challengeid', $challarr)
      ->join('registerusers', 'registerusers.id', '=', 'joinedleauges.userid')
      ->join('jointeam', 'jointeam.id', '=', 'joinedleauges.teamid')
      ->orderBy('jointeam.points', 'DESC')
      ->select('joinedleauges.challengeid', 'registerusers.team', 'registerusers.email', 'jointeam.teamnumber', 'jointeam.points', 'jointeam.lastpoints', 'joinedleauges.id as jid', 'joinedleauges.userid', 'joinedleauges.teamid')
      ->get();
    //echo count($resjoinedteams);die;

    // echo '<pre>';
    // print_r($resjoinedteams);die;

    foreach ($resjoinedteams as $row) {
      $joinedteamsarr[$row->challengeid][] = $row;
    }
    $i = 0;
    $Json = array();
    foreach ($matchchallenges as $key2 => $joined) {
      $i = $joined->id;
      $findjoinedteams = (isset($joinedteamsarr[$joined->id])) ? $joinedteamsarr[$joined->id] : [];
      $gtlastranks = array();
      $getcurrentrankarray = array();
      $ss = 0;
      if (!empty($findjoinedteams)) {

        foreach ($findjoinedteams as $pleauges) {
          $gtlastranks[$ss]['lastpoints'] = $pleauges->lastpoints;
          $gtlastranks[$ss]['userid'] = $pleauges->userid;
          $gtlastranks[$ss]['userjoinid'] = $pleauges->jid;
          $getcurrentrankarray[$ss]['points'] = $pleauges->points;
          $getcurrentrankarray[$ss]['userid'] = $pleauges->userid;
          $getcurrentrankarray[$ss]['userjoinid'] = $pleauges->jid;
          $ss++;
        }
      }
      $gtlastranks = $this->multid_sort($gtlastranks, 'lastpoints');

      if (!empty($gtlastranks)) {
        $getuserlastrank = array();
        $lr = 0;
        $lrsno = 0;
        $uplus = 0;
        foreach ($gtlastranks as $lrnk) {
          if (in_array($lrnk['lastpoints'], array_column($getuserlastrank, 'points'))) { // search value in the array
            $lrsno++;
            $lrsno = $lrsno + $uplus;
            $uplus = 0;
          } else {
            $lrsno++;
          }
          $getuserlastrank[$lr]['rank'] = $lrsno;
          $getuserlastrank[$lr]['points'] = $lrnk['lastpoints'];
          $getuserlastrank[$lr]['userid'] = $lrnk['userid'];
          $getuserlastrank[$lr]['userjoinid'] = $lrnk['userjoinid'];
          $lr++;
        }
      }

      //get current ranks//
      $gtcurranks = $this->multid_sort($getcurrentrankarray, 'points');
      if (!empty($gtcurranks)) {
        $getusercurrank = array();
        $cur = 0;
        $currsno = 0;
        $plus = 0;
        foreach ($gtcurranks as $curnk) {
          if (!in_array($curnk['points'], array_column($getusercurrank, 'points'))) { // search value in the array
            $currsno++;
            $currsno = $currsno + $plus;
            $plus = 0;
          } else {
            $plus++;
          }
          $getusercurrank[$cur]['rank'] = $currsno;
          $getusercurrank[$cur]['points'] = $curnk['points'];
          $getusercurrank[$cur]['userid'] = $curnk['userid'];
          $getusercurrank[$cur]['userjoinid'] = $curnk['userjoinid'];
          $cur++;
        }
      } //End Function


      /* Genrate Lederboard */
      if (!empty($findjoinedteams)) {
        $k = 0;
        $userrank = 1;
        $userslistsno = -1;
        $userrankarray = array();
        $pdfname = "";
        foreach ($findjoinedteams as $jointeam) {
          if ($jointeam->team != "") {
            $Json[$i]['jointeams'][$k]['team_name'] = ucwords($jointeam->team);
          } else {
            $Json[$i]['jointeams'][$k]['team_name'] = $jointeam->email;
          }
          $Json[$i]['jointeams'][$k]['team_id'] = $jointeam->teamid;
          $Json[$i]['jointeams'][$k]['team_number'] = $jointeam->teamnumber;

          $Json[$i]['jointeams'][$k]['points'] = $jointeam->points;
          $getuserindexinglast = $this->searchByValue($getuserlastrank, 'userjoinid', $jointeam->jid);
          $getlastrank = $getuserlastrank[$getuserindexinglast]['rank'];
          $getuserindexingcurent = $this->searchByValue($getusercurrank, 'userjoinid', $jointeam->jid);
          $getcurrentrank = $getusercurrank[$getuserindexingcurent]['rank'];
          $Json[$i]['jointeams'][$k]['rank'] = $getcurrentrank;
          if ($getlastrank < $getcurrentrank) {
            $Json[$i]['jointeams'][$k]['arrowname'] = 'down-arrow';
          } else if ($getlastrank == $getcurrentrank) {
            $Json[$i]['jointeams'][$k]['arrowname'] = 'equal-arrow';
          } else if ($getlastrank > $getcurrentrank) {
            $Json[$i]['jointeams'][$k]['arrowname'] = 'up-arrow';
          }
          $Json[$i]['jointeams'][$k]['join_id'] = $jointeam->jid;
          $Json[$i]['jointeams'][$k]['user_id'] = $jointeam->userid;
          $Json[$i]['jointeams'][$k]['challenge_id'] = $i;


          $k++;
        }
      }
      /* Genrate Lederboard */
      // if(isset($_GET['test']) && $_GET['test']==1)
      // {
      //   if(count($Json[$i]['jointeams'])>15000){
      //     echo '<pre>';
      //     print_r($Json[$i]['jointeams']);
      //     //die;
      //   }
      //
      // }
      if (!empty($Json[$i]['jointeams'])) {

        $chunk_size = 1000;
        if (count($Json[$i]['jointeams']) > 1000) {
          $chunk_size = 10000;
        }

        $new_result = array_chunk($Json[$i]['jointeams'], $chunk_size);
        foreach ($new_result as $rkey => $rvalue) {
          $this->insertOrUpdate($rvalue, 'leaderboard');
        }
      }
    }
    if (isset($_GET['test']) && $_GET['test'] == 1) {
      echo 'success';
      die;
    }
    return;
  }
  public function update_match_leaderboard($matchkey)
  {
    $listmatches = DB::table('listmatches as l')->where('matchkey', $matchkey)
      ->where('s.is_leaderboard', 1)
      ->join('series as s', 's.id', '=', 'l.series')
      ->where('final_status', 'winnerdeclared')->select('series', 'matchkey')->first();


    if (!empty($listmatches)) {

      $leaderboard = DB::table('leaderboard as l')
        // ->join('matchchallenges as mc', 'mc.id', '=', 'l.challenge_id')
        ->join('matchchallenges as mc', function ($join) {
          $join->on('mc.id', '=', 'l.challenge_id')
            ->where('mc.entryfee', '>', '0')
            ->where(function ($query) {
              $query->where('mc.bonus_precent', '!=', '100')
                ->orWhere('mc.bonus_precent', '');
            })
            ->where('mc.status', '!=', 'canceled');
        })
        ->where('mc.matchkey', $listmatches->matchkey)
        ->where('mc.is_private', 0)
        ->where('mc.win_amount', ">", 0)
        ->groupBy('l.user_id')
        ->havingRaw('team_count > 0')
        ->select(
          'l.user_id',
          DB::raw("MAX(l.points) as points, COUNT(l.team_id) as team_count,
                          " . $listmatches->series . " AS series_id,
                          '" . $listmatches->matchkey . "' AS match_id")
        )
        ->orderBy('points', 'DESC')
        ->get();
      // echo "<pre>"; print_r($leaderboard);  exit;

      foreach ($leaderboard as $key => $value_l) {
        $leade_team_id = DB::table('leaderboard')->join('matchchallenges', 'matchchallenges.id', '=', 'leaderboard.challenge_id')
          ->where('user_id', $value_l->user_id)
          ->where('matchchallenges.matchkey', $listmatches->matchkey)
          ->where('points', $value_l->points)->first();
        // var_dump($leade_team_id);exit;
        $leaderboard[$key]->player_team_id = $leade_team_id->team_id;
      }

      $data = collect($leaderboard)->map(function ($x) {
        return (array) $x;
      })->toArray();
      $check = DB::table('match_leaderboard')->where('match_id', $matchkey)->exists();
      if ($check) {
        DB::table('match_leaderboard')->where('match_id', $matchkey)->delete();
      }
      DB::table('match_leaderboard')->insert($data);

      DB::table('listmatches')->where('matchkey', $listmatches->matchkey)->update(array("is_leaderboard" => 1));
      $this->update_series_leaderboard($listmatches->series);
      return 1;
    }
    return 1;
  }

  public function update_series_leaderboard($series_id)
  {
    // echo "string";die;
    $match_leaderboard = DB::table('match_leaderboard')->select(DB::raw('SUM(points) as points, user_id, series_id'))->where('series_id', $series_id)->orderByRaw('SUM(points) DESC')->groupBy('user_id')->get();

    $lastpoints = 0;
    $skip_count = 0;
    $rank = 1;
    $i = 0;

    if (!$match_leaderboard->isEmpty()) {
      foreach ($match_leaderboard as $key => $value) {
        if ($value->points == $lastpoints) {
          $skip_count++;
          $data[$i]['rank'] = $rank - $skip_count;
        } else {
          $data[$i]['rank'] = $rank;
          $skip_count = 0;
        }
        $data[$i]['points'] = $value->points;
        $data[$i]['user_id'] = $value->user_id;
        $data[$i]['series_id'] = $value->series_id;
        $data[$i]['status'] = 1;
        $rank++;
        $i++;
        $lastpoints = $value->points;
      }

      $check = DB::table('series_leaderboard')->where('series_id', $series_id)->exists();
      if ($check) {
        DB::table('series_leaderboard')->where('series_id', $series_id)->delete();
      }
      DB::table('series_leaderboard')->insert($data);
    }
    return 1;
  }


  public function matchChallengePdfGenerate_old07_11_23()
  {

    date_default_timezone_set('Asia/Kolkata');
    $matchList = DB::table('listmatches')
      ->whereIn('status', ['started', 'completed'])
      ->where('launch_status', '=', 'launched')
      ->whereNull('pdfstatus')
      // ->where('matchkey','63516')
      ->whereNotIn('final_status', ['IsAbandoned', 'IsCanceled'])
      ->where('start_date', '<=', date('Y-m-d H:i:s'))
      ->select('matchkey')->limit(1)->orderBY('id', 'DESC')->get();

    // echo "<pre>"; print_r($matchList); exit;
    if (!$matchList->isEmpty()) {
      foreach ($matchList as $key => $value) {
        // echo $value->matchkey; exit;
        $this->createpdfnew($value->matchkey);
      }
    }
  }
  public function matchChallengePdfGenerate($number = 1)
  {

    date_default_timezone_set('Asia/Kolkata');
    $matchList = DB::table('listmatches')
      ->where('status', 'started')
      // ->whereIn('status',['started','pending','completed'])
      ->where('launch_status', '=', 'launched')
      ->whereNull('pdfstatus')
      // ->where('matchkey','61971')
      ->whereNotIn('final_status', ['IsAbandoned', 'IsCanceled'])
      ->where('start_date', '<=', date('Y-m-d H:i'))
      //->where('start_date','<=','2024-06-05 20:50')
      ->select('matchkey', 'sport_type')->limit(2)->orderBY('id', 'DESC')->get();
    //echo "nn<pre>";print_r($matchList);die();

    // if(!empty($matchList) && isset($matchList[0]->matchkey)) {
    if (!$matchList->isEmpty()) {
      foreach ($matchList as $key => $value) {
        // echo $value->matchkey."<br>";
        $this->createpdfnew($value->matchkey, $value->sport_type, $number);
      }
    }
  }
  public  function createpdfnew_old($matchkey)
  {

    date_default_timezone_set("Asia/Kolkata");
    $decodematchdetails = DB::table('listmatches')->where('matchkey', $matchkey)->select('matchkey', 'title', 'short_name', 'start_date', 'format', 'name')->first();

    $findallchallenges = DB::table('matchchallenges')->where('matchkey', $matchkey)->where('pdf_created', 0)->where('status', '!=', 'canceled')->select('*')->get();

    // dd($findallchallenges);

    $findmatchplayers = DB::table('matchplayers')->where('matchkey', $matchkey)->select('name', 'playerid')->get();

    // dd($findmatchplayers);

    $chid = array();
    if (!empty($findallchallenges)) {
      foreach ($findallchallenges as $chllenge) {
        $chid[] = $chllenge->id;
      }
    }
    // dd($chid);
    if (!empty($chid)) {

      $findallusers = DB::table('joinedleauges')->whereIn('challengeid', $chid)->join('registerusers', 'registerusers.id', '=', 'joinedleauges.userid')->join('jointeam', 'jointeam.id', '=', 'joinedleauges.teamid')->select('registerusers.team', 'registerusers.email', 'jointeam.players', 'jointeam.captain', 'jointeam.vicecaptain', 'jointeam.teamnumber', 'joinedleauges.id as joinedid', 'pdfcreate', 'joinedleauges.challengeid')->get();

      $findallusers = json_decode(json_encode((array) $findallusers), true);

      foreach ($findallusers as $val) {
        $all_users_data[] = $val;
      }

      if (!empty($all_users_data)) {
        foreach ($findallchallenges as $chllenge) {
          $filterusers = array();
          foreach ($all_users_data[0] as $key => $value) {
            if ($value['challengeid'] == $chllenge->id) {
              array_push($filterusers, $value);
            }
          }

          if (!empty($filterusers)) {

            $this->getPdfDownload($filterusers, $chllenge, $findmatchplayers, $decodematchdetails);

            //print status log
            // $myfile = fopen(ROOT.DS."pdffiles-status.txt", "a");
            // $txt = "matchkey = ".$matchkey." challengeid = ".$chllenge->id." pdf generate\n";
            // fwrite($myfile, $txt);
            // fclose($myfile);
            //end print log
            $pdfcreatedata['pdfstatus'] = 1;
            DB::table('listmatches')->where('matchkey', $matchkey)->update($pdfcreatedata);
          }
          $challengepdf['pdf_created'] = 1;
          DB::table('matchchallenges')->where('id', $chllenge->id)->update($challengepdf);
        }
      }
    }
    // $pdfcreatedata['pdfstatus'] = 1;
    // DB::table('listmatches')->where('matchkey',$matchkey)->update($pdfcreatedata);
    return true;
  }
  public  function createpdfnew($matchkey, $sport_type, $number)
  {
    date_default_timezone_set("Asia/Kolkata");

    $decodematchdetails = DB::table('listmatches')->where('matchkey', $matchkey)->where('sport_type', $sport_type)->select('matchkey', 'title', 'short_name', 'start_date', 'format', 'name')->first();

    $findallchallenges = DB::table('matchchallenges')
      ->where('matchkey', $matchkey)
      ->where('sport_type', $sport_type)
      // ->skip(1000 * $number)
      ->take(1000)
      ->where('pdf_created', 0)
      ->where('joinedusers', '>', 1)
      ->where('status', '!=', 'canceled')->select('*')->get();
    $findmatchplayers = DB::table('matchplayers')->where('matchkey', $matchkey)->select('name', 'playerid')->get();

    $chid = array();
    if (!empty($findallchallenges)) {
      foreach ($findallchallenges as $chllenge) {
        $chid[] = $chllenge->id;
      }
    }

    // echo $matchkey; exit;
    if (!empty($chid)) {
      $findallusers = DB::table('joinedleauges')->whereIn('challengeid', $chid)->join('registerusers', 'registerusers.id', '=', 'joinedleauges.userid')->join('jointeam', 'jointeam.id', '=', 'joinedleauges.teamid')->select('registerusers.team', 'registerusers.email', 'jointeam.players', 'jointeam.captain', 'jointeam.vicecaptain', 'jointeam.teamnumber', 'joinedleauges.id as joinedid', 'pdfcreate', 'joinedleauges.challengeid')->get();

      $findallusers = json_decode(json_encode((array) $findallusers), true);

      foreach ($findallusers as $val) {
        $all_users_data[] = $val;
      }

      if (!empty($all_users_data)) {
        foreach ($findallchallenges as $chllenge) {
          $filterusers = array();
          foreach ($all_users_data[0] as $key => $value) {
            if ($value['challengeid'] == $chllenge->id) {
              array_push($filterusers, $value);
            }
          }
          if (!empty($filterusers)) {

            $this->getPdfDownload($filterusers, $chllenge, $findmatchplayers, $decodematchdetails);

            //print status log
            // $myfile = fopen(ROOT.DS."pdffiles-status.txt", "a");
            // $txt = "matchkey = ".$matchkey." challengeid = ".$chllenge->id." pdf generate\n";
            // // print_r($txt); exit;
            // fwrite($myfile, $txt);
            // fclose($myfile);
            //end print log
            $pdfcreatedata['pdfstatus'] = 1;
            DB::table('listmatches')->where('matchkey', $matchkey)->where('sport_type', $sport_type)->update($pdfcreatedata);
          }
          $challengepdf['pdf_created'] = 1;
          DB::table('matchchallenges')->where('id', $chllenge->id)->update($challengepdf);
        }
      }
    }
    if (empty($findallusers)) {
      //   $pdfcreatedata['pdfstatus'] = 1;
      // DB::table('listmatches')->where('matchkey',$matchkey)->where('sport_type', $sport_type)->update($pdfcreatedata);
    }

    return true;
  }
  public function getPdfDownload($findjoinedleauges, $findchallenge, $findmatchplayers, $findmatchdetails)
  {

    ini_set('memory_limit', '-1');
    require_once(base_path() . "/mpdf/mpdf.php");

    $mpdf = new mPDF();
    $mpdf->useSubstitutions = false;
    $mpdf->simpleTables = true;
    $mpdf->SetCompression(true);
    $content = "";

    $content = '<div class="col-md-12 col-sm-12" style="margin-top:20px;">

          <div class="col-md-12 col-sm-12 text-center" style="margin-top:20px;text-align:center">
            <div class="col-md-12 col-sm-12">
              <p> ' . BRAND['name'] . ' Fantasy Cricket </p>
            </div>';
    $content .= '<div class="col-md-12 col-sm-12">
              <p> <strong>Pdf Generated On: </strong>' . date('Y-m-d H:i:s a') . '</p>
            </div>
          </div>
        </div>';
    $content .= '<div class="col-md-12 col-sm-12" style="margin-top:20px;">
              <table style="width:100%" border="1">
               <tr style="background:#3C7CC4;color:#fff;text-align:center">';
    $challengename = "";
    if ($findchallenge->name == "") {
      if ($findchallenge->win_amount == 0) {
        $challengename = 'Net Practice';
      } else {
        $challengename = 'Win-' . $findchallenge->win_amount;
      }
    } else {
      $challengename = $findchallenge->name;
    }
    $content .= '<th style="color:#fff !important;" colspan="' . (count($findmatchplayers) + 1) . '">' . $challengename . '( ' . $findmatchdetails->short_name . ' ' . $findmatchdetails->format . ' ' . $findmatchdetails->start_date . ')</th>

                </tr>
                <tr style="background:#ccc;color:#333;text-align:center">
                <th>Display User Name</th>';
    if (!empty($findmatchplayers)) {
      $pn = 1;
      foreach ($findmatchplayers as $player1) {
        if ($pn < 12) {
          //$content.='<th>'.ucwords($player1->name).'</th>';
          $content .= '<th>Player ' . $pn . '</th>';
        }
        $pn++;
      }
    }
    $content .= '</tr>';

    if (!empty($findjoinedleauges)) {
      foreach ($findjoinedleauges as $joinleauge) {
        $content .= '<tr>
              <td style="text-align:center">';
        if ($joinleauge['team'] != "") {
          $content .= ucwords($joinleauge['team']) . '<br> ( ' . $joinleauge['teamnumber'] . ' )';
        } else {
          $content .= ucwords($joinleauge['email']) . '<br> ( ' . $joinleauge['teamnumber'] . ' )';
        }
        $content .= '</td>';
        $jointeam = $joinleauge['players'];
        $explodeplayers = explode(',', $jointeam);
        foreach ($findmatchplayers as $player2) {
          if (in_array($player2->playerid, $explodeplayers)) {
            $content .= '<td class="text-center" style="text-align:center;">';
            $content .= $player2->name;

            if ($player2->playerid == $joinleauge['vicecaptain']) {
              $content .= '(VC)';
            }
            if ($player2->playerid == $joinleauge['captain']) {
              $content .= '(C)';
            }
            $content .= '</td>';
          }
        }
        $content .= '</tr>';
      }
    }
    $content .= '</table>
        </div>';
    // echo $content; exit;
    $mpdf->WriteHTML($content);
    $filename = $findchallenge->id;
    // echo base_path().'/pdffolders/join-leauges-'.$filename.'.pdf'; exit;
    if (file_exists(base_path() . '/pdffolders/join-leauges-' . $filename . '.pdf')) {

      unlink(base_path() . '/pdffolders/join-leauges-' . $filename . '.pdf');
    }

    $mpdf->Output(PDF_DIRECTORY . 'join-leauges-' . $filename . '.pdf');
    move_uploaded_file(base_path() . '/pdffolders/join-leauges-' . $filename . '.pdf', "uploads/pdffolders/join-leauges-", $filename . '.pdf');
    Helpers::aws_upload_image(base_path() . '/pdffolders/join-leauges-' . $filename . '.pdf', "uploads/pdffolders/join-leauges-", $filename . '.pdf');

    // Helpers::aws_upload_image(base_path().'/pdffolders/join-leauges-'.$filename.'.pdf', "uploads/pdffolders/join-leauges-",$filename.'.pdf');
    unlink(base_path() . '/pdffolders/join-leauges-' . $filename . '.pdf');

    return true;
  }

  public function contestPdfGenerateCustom($challenge_id)
  {
    $findallchallenges = DB::table('matchchallenges')->where('id', $challenge_id)->where('status', '!=', 'canceled')->select('*')->get();
    $matchkey = $findallchallenges[0]->matchkey;
    $decodematchdetails = DB::table('listmatches')->where('matchkey', $matchkey)->select('matchkey', 'title', 'short_name', 'start_date', 'format', 'name')->first();
    $findmatchplayers = DB::table('matchplayers')->where('matchkey', $matchkey)->select('name', 'playerid')->get();
    $chid = array();
    if (!empty($findallchallenges)) {
      foreach ($findallchallenges as $chllenge) {
        $chid[] = $chllenge->id;
      }
    }
    // dd($chid);
    if (!empty($chid)) {
      $findallusers = DB::table('joinedleauges')->whereIn('challengeid', $chid)->join('registerusers', 'registerusers.id', '=', 'joinedleauges.userid')->join('jointeam', 'jointeam.id', '=', 'joinedleauges.teamid')->select('registerusers.team', 'registerusers.email', 'jointeam.players', 'jointeam.captain', 'jointeam.vicecaptain', 'jointeam.teamnumber', 'joinedleauges.id as joinedid', 'pdfcreate', 'joinedleauges.challengeid')->get();

      $findallusers = json_decode(json_encode((array) $findallusers), true);

      foreach ($findallusers as $val) {
        $all_users_data[] = $val;
      }
      // dd($all_users_data);

      if (!empty($all_users_data)) {
        foreach ($findallchallenges as $chllenge) {
          $filterusers = array();
          foreach ($all_users_data[0] as $key => $value) {
            if ($value['challengeid'] == $chllenge->id) {
              array_push($filterusers, $value);
            }
          }
          // dd($filterusers);
          if (!empty($filterusers)) {
            // dd('dsfasdf');
            $this->getPdfDownload($filterusers, $chllenge, $findmatchplayers, $decodematchdetails);

            //print status log
            // $myfile = fopen(ROOT.DS."pdffiles-status.txt", "a");
            // $txt = "matchkey = ".$matchkey." challengeid = ".$chllenge->id." pdf generate\n";
            // fwrite($myfile, $txt);
            // fclose($myfile);
            //end print log

          }
          $challengepdf['pdf_created'] = 1;
          DB::table('matchchallenges')->where('id', $chllenge->id)->update($challengepdf);
        }
      }
    }
    echo "generated";
  }

  public function set_flexy_league()
  {
    // Storage::append('croncheck.txt', 'SET_FLEX_LEAGUE-'.Carbon::now());
    date_default_timezone_set('Asia/Kolkata');
    $findmatchexist = DB::table('listmatches')->where('start_date', '<=', date('Y-m-d H:i:s'))->where('launch_status', 'launched')->where('final_status', '!=', 'winnerdeclared')->where('final_status', '!=', 'IsCanceled')->where('status', '!=', 'completed')->where('sport_type', 1)->where('flexible_breakup_set', 0)->orderBy('id', 'DESC')->get();
    // print_r($findmatchexist); exit;
    foreach ($findmatchexist as $key => $value) {
      $matchchallenges = DB::table('matchchallenges')->where('matchkey', $value->matchkey)->where('is_flexible', 1)->get();
      foreach ($matchchallenges as $key2 => $value2) {
        if ($value2->joinedusers < $value2->maximum_user) {
          $matchpricecards = DB::table('matchpricecards')->where('matchkey', $value->matchkey)->where('challenge_id', $value2->id)->get();
          $winning_amount = 0;
          foreach ($matchpricecards as $key => $value) {
            $winning_amount += $value->total;
          }
          if ($winning_amount > 0) {
            $comm = $winning_amount / ($value2->entryfee * $value2->maximum_user);
            $ratio =  (($value2->joinedusers * $value2->entryfee) * $comm) / $winning_amount;
            $new_win_amount = $winning_amount * $ratio;
            foreach ($matchpricecards as $key3 => $value3) {
              $update = array();
              $update['price'] = (int)($value3->price * $ratio);
              DB::table('matchpricecards')->where('id', $value3->id)->update($update);
            }
            DB::table('matchchallenges')->where('id', $value2->id)->update(["win_amount" => $new_win_amount]);
          }
        }
      }
      DB::table('listmatches')->where('matchkey', $value->matchkey)->update(array("flexible_breakup_set" => 1));
    }
  }
  public function bot_join_users($matchkey = null)
  {
    //Get Ajax Data
    $formData = Input::all();
    if (isset($formData) && !empty($formData)) {

      $regDB = DB::table('registerusers')->where('is_bot', 1)->pluck('id');


      return Datatables::of(DB::table('matchchallenges as mc')
        ->leftjoin('joinedleauges as jl', 'jl.challengeid', '=', 'mc.id')
        ->whereIn('jl.userid', $regDB)
        ->where('mc.matchkey', $matchkey)
        ->where('mc.status', '!=', 'canceled')
        ->select('mc.id as matchchallenges_id', 'mc.challenge_type as challenge_type', 'mc.entryfee as matchchallenges_entryfee', 'mc.win_amount as matchchallenges_win_amount', 'is_manual_bot', 'mc.maximum_user as matchchallenges_maximum_user', 'mc.grand as matchchallenges_grand', DB::raw('count(jl.userid) as total'))
        ->groupBY('mc.id')
        ->get())
        ->addIndexColumn()
        ->addColumn('action', function ($result) {
          // return '<a href="'.route($this->model.'.cancel_contest',base64_encode(serialize($result->matchchallenges_id))).'" class="btn btn-danger">Cancel</a>';
          return '<a href="' . route($this->model . '.join_bot_details', base64_encode(serialize($result->matchchallenges_id))) . '" class="btn btn-success" > Bot Details</a>';
          if ($result->is_manual_bot == 1) {
            // return '<a href="'.route($this->model.'.cancel_contest',base64_encode(serialize($result->matchchallenges_id))).'" class="btn btn-danger">Cancel</a>
            // ';
          } else {
            // return '<a href="'.route($this->model.'.cancel_contest',base64_encode(serialize($result->matchchallenges_id))).'" class="btn btn-danger">Cancel</a>
            // ';
          }
        })
        ->addColumn('total_bot_winning', function ($result) use ($regDB) {
          return DB::table('finalresults')->where('challengeid', $result->matchchallenges_id)->whereIn('userid', $regDB)->sum('amount');
        })
        ->escapeColumns([])
        ->make(true);
    } //end

    //End
    return view("admin.$this->model.bot_join_users", compact('matchkey'));
  } //End Function




  /// XXXXXXXXXXXXXX SET FLAXIBLE XXXXXXXXXXXXXXXXXX

  public function setflaxibleleague($matchkey)
  {
    date_default_timezone_set('Asia/Kolkata');
    $findmatchexist = DB::table('listmatches')
      ->where('matchkey', $matchkey)
      ->where('start_date', '<=', date('Y-m-d H:i:s'))
      ->where('launch_status', 'launched')
      ->where('final_status', '!=', 'winnerdeclared')
      ->where('final_status', '!=', 'IsCanceled')
      ->where('status', '!=', 'completed')
      ->where('sport_type', 1)
      ->where('flexible_breakup_set', 0)
      ->orderBy('id', 'DESC')->get();

    foreach ($findmatchexist as $key => $value) {
      $matchchallenges = DB::table('matchchallenges')
        ->where('matchkey', $value->matchkey)
        ->where('is_flexible', 1)
        ->get();

      foreach ($matchchallenges as $key2 => $value2) {
        if ($value2->joinedusers < $value2->maximum_user) {
          $matchpricecards = DB::table('matchpricecards')
            ->where('matchkey', $value2->matchkey)
            ->where('challenge_id', $value2->id)
            ->get();

          $winning_amount = 0;
          foreach ($matchpricecards as $key => $value) {
            $winning_amount += $value->total;
          }
          if ($winning_amount > 0) {
            $comm = $winning_amount / ($value2->entryfee * $value2->maximum_user);
            $ratio =  (($value2->joinedusers * $value2->entryfee) * $comm) / $winning_amount;
            $new_win_amount = $winning_amount * $ratio;
            foreach ($matchpricecards as $key3 => $value3) {
              $update = array();
              $update['price'] = (int)($value3->price * $ratio);
              DB::table('matchpricecards')->where('id', $value3->id)->update($update);
            }
            DB::table('matchchallenges')->where('id', $value2->id)->update(["win_amount" => $new_win_amount]);
          }
        }
      }
      DB::table('listmatches')->where('matchkey', $value->matchkey)->update(array("flexible_breakup_set" => 1));
    }
    return redirect()->back();
  }

  /// XXXXXXXXXXXXXX SET FLAXIBLE XXXXXXXXXXXXXXXXXX
  public function set_flexy_league_auto($matchkey = '63570', $challengesid = '227343', $type_flexi = 'auto')
  {
    date_default_timezone_set('Asia/Kolkata');
    if ($type_flexi == 'manual') {
      $findmatchexist = DB::table('listmatches')
        ->where('matchkey', $matchkey)
        ->orderBy('id', 'DESC')->get();
      // dd($findmatchexist);
    } else {

      $findmatchexist = DB::table('listmatches')
        ->where('matchkey', $matchkey)
        ->where('start_date', '<=', date('Y-m-d H:i:s'))
        ->where('launch_status', 'launched')
        ->where('final_status', '!=', 'winnerdeclared')
        ->where('final_status', '!=', 'IsCanceled')
        // ->where('status','!=','completed')
        ->where('sport_type', 1)
        ->where('flexible_breakup_set', 0)
        ->orderBy('id', 'DESC')->get();
    }
    foreach ($findmatchexist as $key => $value) {
      $matchchallenges = DB::table('matchchallenges')
        ->where('matchkey', $value->matchkey)
        ->where('id', $challengesid)
        ->where('is_flexible', 1)
        ->where('is_flexible_updated', 0)
        ->first();

      $flaxible_matchpericecard = array();
      if (!empty($matchchallenges)) {
        if ($matchchallenges->win_amount > 0 && $matchchallenges->maximum_user > 0) {
          $totalwinning = $matchchallenges->win_amount;
          $totalEarning = ($matchchallenges->entryfee * $matchchallenges->maximum_user);
          $rate_of_winning_distribute = (($totalwinning / $totalEarning) * 100);
          $total_joinuser_earning = $matchchallenges->entryfee * $matchchallenges->joinedusers;
          $total_joinuser_winning = round(($total_joinuser_earning * $rate_of_winning_distribute) / 100);
          $flaxible_matchpericecard = Helpers::auto_update_current_price_pool($value->matchkey, $challengesid, $rate_of_winning_distribute);
        }
        // echo "<pre>"; print_r($flaxible_matchpericecard); exit;

        if (!empty($flaxible_matchpericecard)) {

          DB::table('matchpricecards')->where('matchkey', $value->matchkey)->where('challenge_id', $challengesid)->delete();
          foreach ($flaxible_matchpericecard as $key => $flax_pricecard) {
            DB::table('matchpricecards')->insert($flax_pricecard);
          }

          DB::table('matchchallenges')->where('id', $matchchallenges->id)->update(["win_amount" => $total_joinuser_winning, "is_flexible_updated" => 1]);
        }
      }
      // dd($flaxible_matchpericecard);

    }
    if ($type_flexi == 'manual') {
      return redirect()->back();
    } else {
      DB::table('listmatches')->where('matchkey', $matchkey)->update(array("flexible_breakup_set" => 1));
    }
  }


  public function set_flexy_league_automatic($matchkey = '63570', $sports_type = '1')
  {
    date_default_timezone_set('Asia/Kolkata');
    $matchchallenges_flaxible = DB::table('matchchallenges')
      ->where('matchkey', $matchkey)
      ->where('sport_type', $sports_type)
      ->where('status', '!=', 'canceled')
      ->where('status', '!=', 'closed')
      ->where('entryfee', '>', 0)
      ->where('joinedusers', '>', 0)
      ->where('is_flexible', 1)
      ->where('is_flexible_updated', 0)
      ->get();
    // dd($matchchallenges_flaxible);
    if (!empty($matchchallenges_flaxible)) {

      foreach ($matchchallenges_flaxible as $key => $matchchallenges) {
        $challengesid = $matchchallenges->id;
        $flaxible_matchpericecard = array();
        if ($matchchallenges->win_amount > 0 && $matchchallenges->maximum_user > 0) {

          $totalwinning = $matchchallenges->win_amount;
          $totalEarning = ($matchchallenges->entryfee * $matchchallenges->maximum_user);
          $rate_of_winning_distribute = (($totalwinning / $totalEarning) * 100);
          $total_joinuser_earning = $matchchallenges->entryfee * $matchchallenges->joinedusers;
          $total_joinuser_winning = round(($total_joinuser_earning * $rate_of_winning_distribute) / 100);
          $flaxible_matchpericecard = Helpers::auto_update_current_price_pool($matchkey, $challengesid, $rate_of_winning_distribute);
        }
        //echo "<pre>"; print_r($flaxible_matchpericecard); exit;
        if (!empty($flaxible_matchpericecard)) {
          DB::table('matchpricecards')->where('matchkey', $matchkey)->where('challenge_id', $challengesid)->delete();
          foreach ($flaxible_matchpericecard as $key => $flax_pricecard) {
            DB::table('matchpricecards')->insert($flax_pricecard);
          }

          DB::table('matchchallenges')->where('id', $matchchallenges->id)->update(["win_amount" => $total_joinuser_winning, "is_flexible_updated" => 1]);
        }
        // dd($flaxible_matchpericecard);

        $setflaxiblecheck = DB::table('matchchallenges')
          ->where('matchkey', $matchkey)
          ->where('sport_type', $sports_type)
          ->where('status', '!=', 'canceled')
          ->where('status', '!=', 'closed')
          ->where('entryfee', '>', 0)
          ->where('joinedusers', '>', 0)
          ->where('is_flexible', 1)
          ->where('is_flexible_updated', 0)
          ->get();
        if (count($setflaxiblecheck) > 0) {
        } else {
          DB::table('listmatches')->where('matchkey', $matchkey)->update(array("flexible_breakup_set" => 1));
        }
      }
    }
  }

  public function testsendnotification()
  {
    $title = 'Test';
    $message = 'Test Test';
    $regId = 16;
    Helpers::sendnotificationdeveleopertest($title, $message, '', $regId);
    exit;
  }
  public function reverse_life11()
  {
    exit;
    $trans = DB::table('finalresults')
      ->join('matchchallenges', 'matchchallenges.id', '=', 'finalresults.challengeid')
      ->where('finalresults.matchkey', '61090')
      ->where('matchchallenges.sport_type', 1)
      // ->whereIn('challengeid',$challengeIdss)
      ->select('finalresults.*')->get();

    // var_dump($trans);exit;
    $amount_to_deduct = 0;
    $loss_amount = 0;
    foreach ($trans as $key => $value) {
      $amount_to_deduct += $value->amount;
      $finduseramount = DB::table('userbalances')->where('user_id', $value->userid)->first();

      $findwinning['winning'] = $finduseramount->winning - $value->amount;
      if ($findwinning['winning'] < 0) {
        $loss_amount += $value->amount - $finduseramount->winning;
        $findwinning['winning'] = 0;
      }
      DB::table('userbalances')->where('user_id', $value->userid)->update($findwinning);
      $datatr['transaction_id'] = 'PlaynWin11-REVERT-' . rand(100, 999) . $value->userid;
      $datatr['type'] = 'Revert amount';
      $datatr['transaction_by'] = 'PlaynWin11';
      $datatr['amount'] = $value->amount;
      $datatr['paymentstatus'] = 'confirmed';
      $datatr['challengeid'] = $value->challengeid;
      // $datatr['bonus_amt'] = $val3->bonus;
      // $datatr['win_amt'] = $val3->winning;
      // $datatr['addfund_amt'] = $val3->balance;
      $datatr['bal_bonus_amt'] = $finduseramount->bonus;
      $datatr['bal_win_amt'] = $findwinning['winning'];
      $datatr['bal_fund_amt'] = $finduseramount->balance;
      $datatr['userid'] = $value->userid;
      $datatr['total_available_amt'] = $finduseramount->bonus + $findwinning['winning'] + $finduseramount->balance;
      DB::table('transactions')->insert($datatr);
      DB::table('finalresults')->where('id', $value->id)->delete();
    }
    echo "LOSS AMT " . $loss_amount;
    echo "-----";
    print_r($amount_to_deduct);
    // exit;
    echo 1;
    exit;
  }

  public function winningRevert($matchkey = '')
  {
    $chalangeid = DB::table('matchchallenges')->where('matchkey', $matchkey)->where('joinedusers', '>', 0)->where('confirmed_challenge', '=', 0)->where('status', '!=', 'canceled')
      ->whereColumn('joinedusers', '<=', 'minimum_user')
      ->pluck('id');
    dd($chalangeid);
    if (!empty($chalangeid)) {
      $finalresult = DB::table('finalresults')

        ->where('matchkey', $matchkey)
        // ->where('userid', '4808')
        // ->whereIn('challengeid', $chalangeid)
        ->orderBY('amount', 'asc')
        //->limit(1)
        ->get();
    }

    //echo '<pre>'; print_r($finalresult);exit;

    if (count($finalresult) > 0) {
      foreach ($finalresult as $key => $result) {
        // echo "<pre>"; print_r($result); exit;
        $userbalance = array();
        if ($result->userid > 0) {

          $userbalance = DB::table('userbalances')->where('user_id', $result->userid)->first();
        }
        if (!empty($userbalance) && $result->amount > 0 && $userbalance->winning >= $result->amount) {
          // xxxxxxxxxxx Winning Revert xxxxxxxxxxxxxxxx
          $tds_transaction_id = 'PlaynWin11-REVERT' . time() . '' . $result->userid;
          $commission_transaction = array(
            "userid" => $result->userid,
            "type" => 'Reversed Winning Amount',
            "transaction_id" => $tds_transaction_id,
            "transaction_by" => 'wallet',
            "amount" => $result->amount,
            "win_amt" => $result->amount,
            "paymentstatus" => 'confirmed',
            "bal_win_amt" => round(($userbalance->winning - $result->amount), 2),
            "bal_fund_amt" => $userbalance->balance,
            "bal_bonus_amt" => $userbalance->bonus,
            "bal_gst_bonus_amt" => $userbalance->gst_bonus,
            "bal_affi_amt" => $userbalance->affiliation_commission,
            "total_available_amt" => round(($userbalance->winning + $userbalance->balance + $userbalance->bonus + $userbalance->gst_bonus + $userbalance->affiliation_commission - $result->amount), 2),
          );
          DB::table("transactions")->insert($commission_transaction);
          if ($userbalance->winning >= $result->amount) {
            $remaingwinning = $userbalance->winning - $result->amount;
          } else {
            // if($userbalance->winning+$userbalance->balance>=$result->amount)
            // {
            //     $remaingwinning= $userbalance->winning-$result->amount;
            // }
            $remaingwinning = 0;
          }

          DB::table('userbalances')->where('user_id', $result->userid)->update(['winning' => $remaingwinning]);
          if (!empty($result) && $result->amount > 0) {

            $refund = array(
              'userid' => $result->userid,
              'amount' => $result->amount,
              'joinid' => $result->joinedid,
              'challengeid' => $result->challengeid,
              'matchkey' => $result->matchkey,
              'reason' => 'Winning reversed'
            );
            DB::table('refunds')->insert($refund);
          }


          DB::table('finalresults')->where('id', $result->id)->delete();
        } else {
          if ($result->amount > 0) {
            /*
                 $winning = 0;
                  $cons_winning=0;
                 $cons_balance=0;
                 $remaningAmount = $result->amount - $userbalance->winning;
                 $cons_winning =  $userbalance->winning;
             if ($remaningAmount > 0) {
                 if ($userbalance->balance >= $remaningAmount) {
                     $balance = $userbalance->balance - $remaningAmount;
                     $cons_balance = $remaningAmount;
                     $remaningAmount = 0;
                 } else {
                     $balance = 0;
                     $remaningAmount = $remaningAmount - $userbalance->balance;
                     $cons_balance = $userbalance->balance;
                 }
             }
                $total_deducted_amount = ($cons_winning + $cons_balance);

                if ($total_deducted_amount > 0) {

                    $data = array(
                        "winning"    => DB::raw("winning - " . $cons_winning),
                        "balance"    => DB::raw("balance - " . $cons_balance)
                    );
                    // update user balance
                    $userbalance = DB::table('userbalances')->where('user_id', $userbalance->user_id)->update($data);
                  }


                    // xxxxxxxxxxx Balance Revert xxxxxxxxxxxxxxxx
                 if($total_deducted_amount>0){
                    $tds_transaction_id = 'PlaynWin11-REVERT'.time().''.$result->userid;
                    $commission_transaction = array(
                      "userid"=> $result->userid,
                      "type"=>'Reversed Winning Amount',
                      "transaction_id" => $tds_transaction_id,
                      "transaction_by" => 'wallet',
                      "amount" => $total_deducted_amount,
                      "cons_win" =>$cons_winning,
                      "cons_amount" =>$cons_balance,
                      "paymentstatus" =>'confirmed',
                      "bal_win_amt" => round(($userbalance->winning-$cons_winning),2),
                      "bal_fund_amt" => $userbalance->balance-$cons_balance,
                      "bal_bonus_amt" => $userbalance->bonus,
                      "bal_gst_bonus_amt" => $userbalance->gst_bonus,
                      "bal_affi_amt" => $userbalance->affiliation_commission,
                      "total_available_amt" => round(($userbalance->winning + $userbalance->balance+$userbalance->bonus+$userbalance->gst_bonus+$userbalance->affiliation_commission-$total_deducted_amount),2),
                    );
                    DB::table("transactions")->insert($commission_transaction);
                }


                if($result->amount > $total_deducted_amount)
                {
                    $reverdata=array('user_id'=>$result->userid,
                    'matchkey'=>$result->matchkey,
                    'challengeid'=>$result->challengeid,
                    'joinid'=>$result->joinedid,
                    'total_deduct_amount'=>$result->amount,
                    'deduct_amount'=>$total_deducted_amount,
                    'deduct_amount'=>0,
                    'status'=>0
                  );
                    DB::table('revert_repeated_refund_amount')->insert($reverdata);
                }
              */


            $reverdata = array(
              'user_id' => $result->userid,
              'matchkey' => $result->matchkey,
              'challengeid' => $result->challengeid,
              'joinid' => $result->joinedid,
              'total_deduct_amount' => $result->amount,
              'deduct_amount' => 0,
              'status' => 0
            );
            DB::table('revert_repeated_refund_amount')->insert($reverdata);
          }
          DB::table('finalresults')->where('id', $result->id)->delete();
        }
        // xxxxxxxxxxx Winning Revert xxxxxxxxxxxxxxxx
      }
    }
    echo 'done';
    exit;

    $revert_total_amount = $result->amount;
    $be_revert_amount = 0;
    $revert_bal_amount = 0;
    $revert_win_amount = 0;
    $getwalletData = DB::table('userbalances')
      ->where('user_id', $result->userid)->select('user_id', 'balance', 'winning')->first();
    if ($userbalance->winning >= $revert_total_amount) {

      $userBalance['winning'] = $userbalance->winning - $revert_total_amount;
      $be_revert_amount = $revert_total_amount;
      $revert_win_amount = $revert_total_amount;
      $revert_total_amount = 0;
    } else if ($userbalance->winning < $revert_total_amount) {
      $userBalance['winning'] = 0;
      $be_revert_amount = $userbalance->winning;
      $revert_total_amount = $revert_total_amount - $userbalance->winning;
      $revert_win_amount = $userbalance->winning;
    }

    if ($userbalance->balance >= $revert_total_amount) {
      $userBalance['balance'] = $userbalance->balance - $revert_total_amount;
      $be_revert_amount = $be_revert_amount +  $revert_total_amount;
      $revert_bal_amount = $userbalance->balance - $revert_total_amount;
      $revert_total_amount = 0;
    } else if ($userbalance->balance < $revert_total_amount) {
      $userBalance['balance'] = 0;
      $be_revert_amount = $be_revert_amount + $userbalance->balance;
      $revert_total_amount = $revert_total_amount - $getwalletData->balance;
      $revert_bal_amount = $userbalance->balance;
    }

    DB::table('userbalances')->where('user_id', $userbalance->user_id)->update($userBalance);

    $AfterDeduct_walletData = DB::table('userbalances')
      ->where('user_id', $users->user_id)->first();

    if ($be_revert_amount > 0) {
      $tds_transaction_id = 'PlaynWin11-REVERT' . time() . '' . $result->userid;
      $transaction = array(
        "userid" => $getwalletData->user_id,
        "type" => 'Reversed Winning Amount',
        "transaction_id" => $tds_transaction_id,
        "transaction_by" => 'wallet',
        "amount" => $be_revert_amount,
        "paymentstatus" => 'confirmed',
        "cons_amount" => $revert_bal_amount,
        "cons_win" => $revert_win_amount,
        //  "bonus_amt" =>$AfterDeduct_walletData->bonus,
        // "gst_bonus_amt" =>$AfterDeduct_walletData->gst_bonus,
        "bal_win_amt" => round($AfterDeduct_walletData->winning, 2),
        "bal_fund_amt" => round($AfterDeduct_walletData->balance, 2),
        "bal_bonus_amt" => $AfterDeduct_walletData->bonus,
        "bal_gst_bonus_amt" => $AfterDeduct_walletData->gst_bonus,
        "bal_affi_amt" => $AfterDeduct_walletData->affiliation_commission,
        "total_available_amt" => round(($AfterDeduct_walletData->winning + $AfterDeduct_walletData->balance + $AfterDeduct_walletData->bonus + $AfterDeduct_walletData->gst_bonus + $AfterDeduct_walletData->affiliation_commission), 2),
      );
      DB::table('transactions')->insert($transaction);
    }

    $remingAmount = $revert_total_amount - $be_revert_amount;

    if ($remingAmount > 0) {
      $reverreming = array(
        "user_id" => $getwalletData->user_id,
        // "matchkey"=>$match_key,
        "total_deduct_amount" => $revert_total_amount,
        "deduct_amount" => $be_revert_amount,
        "remain_deduct_amount" => 0,
        "status" => 0
      );

      DB::table('revert_repeated_refund_amount')->insert($reverreming);
      // echo "</br>"; print_r($reverreming);
    }
  }

  public function ContestRefundList($challangesid = '', $matchkey)
  {

    //Get Ajax Data
    $formData = Input::all();
    if (isset($formData) && !empty($formData)) {
      return Datatables::of(DB::table('registerusers')
        ->join('refunds as rf', 'rf.userid', '=', 'registerusers.id')
        ->where('rf.matchkey', $matchkey)
        ->where('rf.challengeid', $challangesid)
        ->select('rf.challengeid', 'registerusers.mobile', 'registerusers.email', 'registerusers.username', 'rf.amount', 'rf.reason')
        ->get())
        ->addIndexColumn()
        ->escapeColumns([])
        ->make(true);
    } //end
    return view("admin.$this->model.contest_refund_list", compact('matchkey', 'challangesid'));
  }

  public function winner_list($matchkey = '', $sport_key = 1)
  {
    //Get Ajax Data
    $data = DB::table('registerusers')
      ->join('finalresults as rf', 'rf.userid', '=', 'registerusers.id')
      ->where('rf.matchkey', $matchkey)
      ->where('rf.sport_type', $sport_key)
      // ->where('rf.challengeid',$challangesid)
      ->select('rf.challengeid', 'registerusers.mobile', 'registerusers.email', 'registerusers.username', 'rf.amount', 'rf.rank')
      ->get();

    $formData = Input::all();
    if (isset($formData) && !empty($formData)) {
      return Datatables::of(DB::table('registerusers')
        ->join('finalresults as rf', 'rf.userid', '=', 'registerusers.id')
        ->where('rf.matchkey', $matchkey)
        ->where('rf.sport_type', $sport_key)
        // ->where('rf.challengeid',$challangesid)
        ->select('rf.challengeid', 'registerusers.mobile', 'registerusers.email', 'registerusers.username', 'rf.amount', 'rf.rank')
        ->get())
        ->addIndexColumn()
        ->escapeColumns([])
        ->make(true);
    } //end

    return view("admin.$this->model.winner_user_list", compact('matchkey', 'sport_key'));
  }


  public function revert_amount_wrong_amount($match_key = '60919_2', $sport_type = '1')
  {

    echo " Chal Nahi Raha";
    exit;

    date_default_timezone_set('Asia/Kolkata');

    $listmatches = DB::table('listmatches')
      ->where('matchkey', $match_key)
      ->where('sport_type', $sport_type)
      ->first();
    $getcurrentdate = date('Y-m-d H:i:s');
    if (!empty($listmatches)) {
      $matchtimings = @$listmatches->start_date;
    }
    $challanges_league = DB::table('leaugestransactions')->where('matchkey', $match_key)->pluck('challengeid')->toArray();
    //   echo "<pre>"; print_r($challanges_league); exit;
    $leaugestransactions = DB::table('joinedleauges')
      ->join('matchchallenges', 'matchchallenges.id', '=', 'joinedleauges.challengeid')
      ->whereNotIn('challengeid', $challanges_league)
      ->where('joinedleauges.matchkey', $match_key)
      // ->where('matchchallenges.status','!=','canceled')
      // ->select('matchchallenges.*')
      ->select('joinedleauges.userid')
      //->sum('matchchallenges.')
      // ->limit(1)
      //  ->sum('matchchallenges.win_amount');
      ->pluck('joinedleauges.userid')->toArray();
    //->get();
    dd($leaugestransactions);
    foreach ($leaugestransactions as $val3) {

      $entryfee = !empty($val3->entryfee) ? $val3->entryfee : 0;
      $gstbonus = 0;
      $Nomralbonus = 0;
      if ($val3->bonus == 1) {
        $Nomralbonus = ($entryfee > 0) ? round(($val3->entryfee * $val3->bonus_precent) / 100, 2) : 0;
        $entryfee = $entryfee - $Nomralbonus;
      }
      if ($val3->gst_bonus == 1) {
        $gstbonus = ($entryfee > 0) ? round(($val3->entryfee * $val3->bonus_precent) / 100, 2) : 0;
        $entryfee = $entryfee - $gstbonus;
      }

      $joinedleauges = DB::table('joinedleauges')
        ->where('matchkey', $match_key)
        ->where('sport_type', $sport_type)
        ->where('challengeid', $val3->id)
        ->select('challengeid', 'userid', 'id as joinid')
        ->get();
      // dd($joinedleauges);
      if (!empty($joinedleauges)) {
        foreach ($joinedleauges as $val1) {
          $findlastow = DB::table('userbalances')->where('user_id', $val1->userid)->first();
          if (!empty($findlastow)) {
            $dasts['status'] = 'canceled';
            DB::table('matchchallenges')->where('id', $val1->challengeid)->update($dasts);
            // entry in refund //
            $refunddata['userid'] = $val1->userid;
            $refunddata['entryfees'] = $entryfee;
            $refunddata['bonus'] = $gstbonus + $Nomralbonus;
            $refunddata['joinid'] = $val1->joinid;
            $refunddata['challengeid'] = $val1->challengeid;
            $refunddata['matchkey'] = $match_key;
            //echo '<pre>';print_r($refunddata);exit;
            DB::table('wrongcontest')->insert($refunddata);
            //   exit;
            //
            // $refunddata['userid']=$val1->userid;
            // $refunddata['amount']=$val3->entryfee;
            // $refunddata['joinid']=$val1->joinid;
            // $refunddata['challengeid']=$val1->challengeid;
            //  $refunddata['matchkey']=$match_key;
            //  $refunddata['reason']='Challenge cancel due to technical fault';
            // echo "<pre>"; print_r($refunddata);
            try {
              // DB::table('refunds')->insert($refunddata);
              // $balanceDeductUpdate = array(
              //   "balance" => DB::raw("balance + ". $entryfee),
              //   "bonus" => DB::raw("bonus + ". $Nomralbonus ),
              //   "gst_bonus" => DB::raw("gst_bonus + ". $gstbonus )
              // );

              // echo "<br/>USERBAL:<pre>"; print_r($balanceDeductUpdate);

              //  DB::table('userbalances')->where('user_id',$val1->userid)->update($balanceDeductUpdate);


              $findlastow = DB::table('userbalances')->where('user_id', $val1->userid)->first();


              //transactions//
              // $registeruserdetails = DB::table('registerusers')->where('id',$val1->userid)->first();
              // $datatr['transaction_id'] = 'PlaynWin11-REFUND-'.rand(100,999).$val1->userid;
              // $datatr['type'] = 'Refund amount';
              // $datatr['transaction_by'] = 'PlaynWin11';
              // $datatr['amount'] = ($entryfee+$Nomralbonus+$gstbonus);
              // $datatr['paymentstatus'] = 'confirmed';
              // $datatr['challengeid'] = $val1->challengeid;
              // $datatr['bonus_amt'] = $Nomralbonus;
              // $datatr['gst_bonus_amt'] = $gstbonus;
              // $datatr['win_amt'] = $findlastow->winning;
              // $datatr['addfund_amt'] = $entryfee;
              // $datatr['bal_bonus_amt'] = $findlastow->bonus;
              // $datatr['bal_win_amt'] = $findlastow->winning;
              // $datatr['bal_gst_bonus_amt'] = $findlastow->gst_bonus;
              // $datatr['bal_fund_amt'] = $findlastow->balance;
              // $datatr['userid'] = $val1->userid;
              // $datatr['total_available_amt'] = $dataq['balance']+$dataq['winning']+$dataq['bonus'];
              // $datatr['total_available_amt'] = $findlastow->balance+$findlastow->winning+$findlastow->bonus+$findlastow->gst_bonus;

              // echo "<br/><pre>TRans:";
              //     print_r($datatr);
              //     exit;

              // DB::table('transactions')->insert($datatr);
            } catch (\Illuminate\Database\QueryException $ex) {

              continue;
            }
          }
        }
      }
    }

    // if($getcurrentdate > date('Y-m-d H:i:s', strtotime('+15 minutes', strtotime($matchtimings)))){
    // DB::table('listmatches')->where('id' , $listmatches->id)->update(array("refund" => 1));

    // echo "Done Maje Karo "; exit;
    // }
    // echo 1; exit;
    //return 1;
  }



  public function refund_amount_manul($match_key = '60919_2', $sport_type = '1')
  {

    echo $match_key;
    // xxxxxxxxxxxxxx Winning Revert xxxxxxxxxxxxxxxxxxxxx

    echo '</br/>Total Contest Join Leagues Record = ' . count(DB::table('joinedleauges')
      ->join('matchchallenges', 'matchchallenges.id', '=', 'joinedleauges.challengeid')
      ->where('joinedleauges.matchkey', $match_key)
      ->selectRaw('DISTINCT(joinedleauges.challengeid)')
      ->where('matchchallenges.status', '!=', 'canceled')
      ->get());


    echo '</br/>Total Contest Leauguetransaction Record = ' . count(@DB::table('leaugestransactions')
      ->join('matchchallenges', 'matchchallenges.id', '=', 'leaugestransactions.challengeid')
      ->where('leaugestransactions.matchkey', $match_key)
      ->selectRaw('DISTINCT(leaugestransactions.challengeid)')
      ->where('matchchallenges.status', '!=', 'canceled')->get());

    $challanges_league = DB::table('leaugestransactions')
      ->join('matchchallenges', 'matchchallenges.id', '=', 'leaugestransactions.challengeid')
      ->where('leaugestransactions.matchkey', $match_key)
      ->where('matchchallenges.status', '!=', 'canceled')
      ->pluck('challengeid')->toArray();

    //echo '</br/></br/>XXXXXXXXXXXXXXXXXXXXXXXXXX</br>';

    echo '</br/>Total Wrong Winning Contest Record = ' . count(DB::table('joinedleauges')
      ->join('matchchallenges', 'matchchallenges.id', '=', 'joinedleauges.challengeid')
      ->whereNotIn('joinedleauges.challengeid', $challanges_league)
      ->selectRaw('DISTINCT(joinedleauges.challengeid)')
      ->where('matchchallenges.status', '!=', 'canceled')
      ->where('joinedleauges.matchkey', $match_key)
      ->get());

    // echo '</br/>XXXXXXXXXXXXXXXXXXXXXXXXXX</br>';


    $leaugestransactions = DB::table('joinedleauges')
      ->join('matchchallenges', 'matchchallenges.id', '=', 'joinedleauges.challengeid')
      ->whereNotIn('joinedleauges.challengeid', $challanges_league)
      // ->where('matchchallenges.status','!=','canceled')
      ->where('joinedleauges.matchkey', $match_key)
      ->pluck('joinedleauges.challengeid')->toArray();

    // join_leauges table entry but leagetransaction not entryfee

    // $joincontestleage=  DB::table('leaugestransactions')->where('matchkey',$match_key)->pluck('challengeid')->toArray();
    //   $leaugestransactions = DB::table('joinedleauges')
    //   ->join('matchchallenges','matchchallenges.id','=','joinedleauges.challengeid')
    //     ->whereNotIn('joinedleauges.challengeid',$joincontestleage)
    //     ->where('matchchallenges.status','!=','closed')
    //     ->where('joinedleauges.matchkey',$match_key)
    //     ->pluck('joinedleauges.challengeid')->toArray();

    //

    //echo '</br/>Revert Total Joined Users   = '.count($leaugestransactions).' Contest';

    $finalResult = array();
    $finalResult = DB::table('finalresults')
      ->whereIN('challengeid', $leaugestransactions)
      ->where('matchkey', $match_key)
      // ->where('userid','46507')
      // ->select('userid','challengeid',DB::raw('sum(finalresults.amount) as TotalWining'))
      ->select('userid', 'challengeid', 'amount as TotalWining')
      // ->groupBy('userid')
      // ->limit(1)
      ->get();

    // echo "<pre>"; print_r($leaugestransactions); exit;
    //   $finalResult = array();
    //   $finalResult = DB :: table('refunds')
    //    ->whereIN('challengeid',$leaugestransactions)
    //   ->where('matchkey',$match_key)
    // //  ->where('reason','Challenge cancel due to technical fault')
    //  // ->select('userid','challengeid',DB::raw('sum(finalresults.amount) as TotalWining'))
    //     ->select('id','userid','challengeid','amount as TotalWining')
    //  // ->groupBy('userid')
    // //->limit(1)
    //   ->get();
    // echo "<pre>"; print_r($finalResult); exit;
    //   echo "</br/></br/></br/>";
    if (!empty($finalResult)) {
      foreach ($finalResult as $key => $winningData) {
        // echo "<pre>"; print_r($winningData); exit;
        echo '</br>xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx</br> ';
        // echo "</br/>Record No.".$key." </br/>";
        $getwalletData = array();
        $revert_total_amount = $winningData->TotalWining;
        $getwalletData = DB::table('userbalances')
          ->where('user_id', $winningData->userid)->Select('user_id', 'balance', 'winning')->first();
        echo '</br/>Before<pre>';
        print_r($getwalletData);
        $be_revert_amount = 0;
        $revert_bal_amount = 0;
        $revert_bonus_amount = 0;
        $revert_win_amount = 0;
        $revert_gst_bonus_amount = 0;
        if (!empty($getwalletData)) {
          echo "<br/>Total Revert Amount= " . $revert_total_amount;
          $userBalance = array();
          /// DEDUCT FROM BALANCE
          if ($getwalletData->balance >= $revert_total_amount) {
            $userBalance['balance'] = $getwalletData->balance - $revert_total_amount;
            $be_revert_amount = $revert_total_amount;
            $revert_bal_amount = $revert_total_amount;
            $revert_total_amount = 0;
          } else if ($getwalletData->balance < $revert_total_amount) {
            $userBalance['balance'] = 0;
            $be_revert_amount = $getwalletData->balance;
            $revert_total_amount = $revert_total_amount - $getwalletData->balance;
            $revert_bal_amount = $getwalletData->balance;
          }
          /// DEDUCT FROM WINNING
          if ($getwalletData->winning >= $revert_total_amount) {

            $userBalance['winning'] = $getwalletData->winning - $revert_total_amount;
            $be_revert_amount = $be_revert_amount +  $revert_total_amount;
            $revert_win_amount = $getwalletData->winning - $revert_total_amount;
            $revert_total_amount = 0;
          } else if ($getwalletData->winning < $revert_total_amount) {
            $userBalance['winning'] = 0;
            $be_revert_amount = $getwalletData->winning;
            $revert_total_amount = $revert_total_amount - $getwalletData->winning;
            $revert_win_amount = $getwalletData->winning;
          }
          echo "</br>***AFTER DEDUCT**<pre>";
          print_r($userBalance);
          // Comment Karna He
          DB::table('userbalances')->where('user_id', $getwalletData->user_id)->update($userBalance);
          // Comment Karna He
          $AfterDeduct_walletData = DB::table('userbalances')
            ->where('user_id', $getwalletData->user_id)->first();

          $revert_transaction_id = 'PlaynWin11-REVERT' . time() . rand(11, 99) . '' . $getwalletData->user_id;
          $transaction = array(
            "userid" => $getwalletData->user_id,
            "type" => 'Revert Wrong refund',
            "transaction_id" => $revert_transaction_id,
            "transaction_by" => 'wallet',
            "amount" => $be_revert_amount,
            "paymentstatus" => 'confirmed',
            "challengeid" => $winningData->challengeid,
            //  "addfund_amt" =>$revert_bal_amount,
            //   "win_amt" =>$revert_win_amount,
            //  "bonus_amt" =>$AfterDeduct_walletData->bonus,
            //  "gst_bonus_amt" =>$AfterDeduct_walletData->gst_bonus,
            "bal_win_amt" => round(($AfterDeduct_walletData->winning), 2),
            "bal_fund_amt" => round(($AfterDeduct_walletData->balance), 2),
            "bal_bonus_amt" => $AfterDeduct_walletData->bonus,
            "bal_gst_bonus_amt" => $AfterDeduct_walletData->gst_bonus,
            "bal_affi_amt" => $AfterDeduct_walletData->affiliation_commission,
            "total_available_amt" => round(($AfterDeduct_walletData->winning + $AfterDeduct_walletData->balance + $AfterDeduct_walletData->bonus + $AfterDeduct_walletData->gst_bonus + $AfterDeduct_walletData->affiliation_commission), 2),
          );
          $remingAmount = $winningData->TotalWining - $be_revert_amount;
          echo "</br><Transaction = <pre>";
          print_r($transaction);
          echo "</br>Reming Revert amount =" . ($winningData->TotalWining - $be_revert_amount);
          // Comment Karna He
          if ($be_revert_amount != 0) {

            DB::table('transactions')->insert($transaction);
          }
          // Comment Karna He
          if ($remingAmount > 0) {
            $reverreming = array(
              "user_id" => $getwalletData->user_id,
              "matchkey" => $match_key,
              "challengeid" =>  $winningData->challengeid,
              "total_deduct_amount" => $winningData->TotalWining,
              "deduct_amount" => $be_revert_amount,
              "remain_deduct_amount" => $remingAmount,
              "status" => ($remingAmount <= 0) ? 1 : 0
            );
            // Comment Karna He
            DB::table('revert_repeated_refund_amount')->insert($reverreming);
            // Comment Karna He

            echo "</br>";
            print_r($reverreming);
          }
          // Comment Karna He
          DB::table('finalresults')
            ->where('matchkey', $match_key)->where('userid', $getwalletData->user_id)->where('challengeid', $winningData->challengeid)->delete();
          //  DB:: table('refunds')->where('id',$winningData->id)->delete();
          // Comment Karna He
          echo "</br>Challenges" . $winningData->challengeid;
          //  DB :: table('matchchallenges')->where('id',$winningData->challengeid)->update(array("status"=>'canceled'));
        }
      }
    }

    exit;
    // xxxxxxxxxxxxxx Winning Revert xxxxxxxxxxxxxxxxxxxxx


    // xxxxxxxxxxxxxx REFUND Revert xxxxxxxxxxxxxxxxxxxxx
    /*
    echo "</br/>XXXXXXXXXXXXXXXXXXXXXXX REFUND XXXXXXXXXXXXXXXXXXXXXXXXXXX </br>";

    echo '</br/>Total Contest Join Leagues Record = '.count(DB::table('joinedleauges')
       ->join('matchchallenges','matchchallenges.id','=','joinedleauges.challengeid')
       ->where('joinedleauges.matchkey',$match_key)
       // ->selectRaw('DISTINCT(joinedleauges.challengeid)')
        ->where('matchchallenges.status','=','canceled')
       ->get());

    echo '</br/>Total Contest Leauguetransaction Record = '.count(@DB::table('leaugestransactions')
        ->join('matchchallenges','matchchallenges.id','=','leaugestransactions.challengeid')
        ->where('leaugestransactions.matchkey',$match_key)
        // ->selectRaw('DISTINCT(leaugestransactions.challengeid)')
        ->where('matchchallenges.status','=','canceled')
      ->get());

       $challanges_league = DB :: table('leaugestransactions')
       ->join('matchchallenges','matchchallenges.id','=','leaugestransactions.challengeid')
       ->where('leaugestransactions.matchkey',$match_key)
       ->where('matchchallenges.status','=','canceled')
       ->pluck('challengeid')->toArray();

         $leaugestransactions = DB::table('joinedleauges')
         ->join('matchchallenges','matchchallenges.id','=','joinedleauges.challengeid')
          ->whereNotIn('joinedleauges.challengeid',$challanges_league)
          ->where('matchchallenges.status','=','canceled')
          ->where('joinedleauges.matchkey',$match_key)
          ->pluck('joinedleauges.challengeid')->toArray();


        // echo "<pre>"; print_r($leaugestransactions);
        echo '</br/>Revert Total Refund Users   = '.count($leaugestransactions).'Contest';

           $Refunds = array();
           $Refunds = DB :: table('refunds')
           ->whereIN('challengeid',$leaugestransactions)
           ->where('matchkey',$match_key)
           // ->where('reason','Contest canceled due to all users have points same')
           ->select('userid',DB::raw('sum(refunds.amount) as TotalWining'),'reason')
           ->groupBy('userid')
           ->get();
             if(!empty($Refunds)){
               foreach($Refunds as $key => $winningData) {
               echo '</br>xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx</br> ';
               echo "</br/>Record No.".$key." </br/>";
                    $getwalletData = array();
                     $revert_total_amount =$winningData->TotalWining;
                     $getwalletData = DB :: table('userbalances')
                        ->where('user_id',$winningData->userid)->Select('user_id','balance','winning')->first();
                     echo '</br/>Before<pre>'; print_r($getwalletData);
                     $be_revert_amount=0;
                     $revert_bal_amount = 0;
                     $revert_bonus_amount = 0;
                     $revert_winning_amount = 0;
                     $revert_gst_bonus_amount = 0;
                     if(!empty($getwalletData)){
                         echo "<br/>Total Revert Amount= ".$revert_total_amount;
                         $userBalance=array();
                   /// DEDUCT FROM BALANCE
                         if($getwalletData->balance >=$revert_total_amount){
                             $userBalance['balance'] = $getwalletData->balance -$revert_total_amount;
                             $be_revert_amount = $revert_total_amount;
                             $revert_bal_amount = $revert_total_amount;
                             $revert_total_amount =0;
                         }else if($getwalletData->balance < $revert_total_amount){
                             $userBalance['balance'] = 0;
                             $be_revert_amount = $getwalletData->balance;
                             $revert_total_amount = $revert_total_amount - $getwalletData->balance;
                             $revert_bal_amount = $getwalletData->balance;
                         }
                   /// DEDUCT FROM WINNING
                           if($getwalletData->winning >= $revert_total_amount){

                             $userBalance['winning'] = $getwalletData->winning -$revert_total_amount;
                             $be_revert_amount = $be_revert_amount+  $revert_total_amount;
                             $revert_win_amount = $getwalletData->winning - $revert_total_amount;
                               $revert_total_amount =0;


                         }else if($getwalletData->winning < $revert_total_amount){
                             $userBalance['winning'] = 0;
                             $be_revert_amount = $getwalletData->winning;
                             $revert_total_amount = $revert_total_amount - $getwalletData->winning;
                             $revert_win_amount = $getwalletData->winning;
                         }
                         echo "</br>***AFTER DEDUCT**<pre>"; print_r($userBalance);

                           // DB :: table('userbalances')->where('user_id',$getwalletData->user_id)->update($userBalance);

                       $AfterDeduct_walletData = DB :: table('userbalances')
                          ->where('user_id',$getwalletData->user_id)->first();

                            $revert_transaction_id = 'PlaynWin11-REVERT'.time().''.$getwalletData->user_id;
                          $transaction = array(
                            "userid"=> $getwalletData->user_id,
                            "type"=>'Revert Amount Due To  Wrong Winning Distribute',
                            "transaction_id" => $revert_transaction_id,
                            "transaction_by" => 'wallet',
                            "amount" => $be_revert_amount,
                            "paymentstatus" =>'confirmed',
                            "addfund_amt" =>$revert_bal_amount,
                            "win_amt" =>$revert_win_amount,
                            "bonus_amt" =>$AfterDeduct_walletData->bonus,
                            "gst_bonus_amt" =>$AfterDeduct_walletData->gst_bonus,
                            "bal_win_amt" => round(($AfterDeduct_walletData->winning+$revert_win_amount),2),
                            "bal_fund_amt" => round(($AfterDeduct_walletData->balance+$revert_bal_amount),2),
                            "bal_bonus_amt" => $AfterDeduct_walletData->bonus,
                            "bal_gst_bonus_amt" => $AfterDeduct_walletData->gst_bonus,
                            "total_available_amt" => round(($AfterDeduct_walletData->winning + $AfterDeduct_walletData->balance+$AfterDeduct_walletData->bonus+$AfterDeduct_walletData->gst_bonus),2),
                          );
                           $remingAmount = $winningData->TotalWining-$be_revert_amount;
                          echo "</br><Transaction = <pre>"; print_r($transaction);
                           echo "</br>Reming Revert amount =".($winningData->TotalWining-$be_revert_amount);

                           // DB :: table('transactions')->insert($transaction);
                           if($remingAmount>0){
                                $reverreming=array(
                                     "user_id"=>$getwalletData->user_id,
                                     "matchkey"=>$match_key,
                                     "total_deduct_amount"=>$winningData->TotalWining,
                                     "deduct_amount"=>$be_revert_amount,
                                     "remain_deduct_amount"=>$remingAmount,
                                     "status"=>($remingAmount<=0) ? 1:0
                                 );

                                 // DB :: table('revert_repeated_refund_amount')->insert($reverreming);
                                 $
                                 echo "</br>"; print_r($reverreming);
                           }

                           // DB:: table('finalresults')
                           // ->where('matchkey',$match_key)->where('userid',$getwalletData->user_id)->delete();

                     }
               }
               exit;
             }
           echo "<pre>"; print_r($finalResult); exit;

   // xxxxxxxxxxxxxx REFUND Revert xxxxxxxxxxxxxxxxxxxxx
  */
    echo "<br/>Mongembo Khush Hua.....!";
    exit;
  }


  public function updatenonplayingbots(Request $request, $id)
  {
    //echo $id;
    // print_r("echo"); exit;
    // $matchkey = $post['matchid'];

    $mysql1 = "SET @row_number = 0";
    $mysql2 = "SET @row_number1 = 0;";

    $userids = DB::table('registerusers')->where('is_bot', 1)->pluck('id');
    $nonPlayingBots = DB::table('jointeam')->where('matchkey', $id)->whereIn('userid', $userids)->where('is_bot_lineup', 0)->count();
    $limits = $nonPlayingBots;

    $botsLineup = DB::table("bots_teams")->where('matchkey', $id)->where('is_used', 0)->where('is_lineup', 1)->count();

    // echo $nonPlayingBots.'___'.$botsLineup; exit;
    if ($nonPlayingBots > $botsLineup) {
      return redirect()->back()->with('success', 'Bots is less than lineup player , please generate bots');
    }

    // $limits_new = ceil($limits/100);

    // for ($i=0; $i < 100; $i++) {
    //    $mysql = "UPDATE jointeam JOIN (SELECT id , (@row_number:=@row_number + 1) as jtRow FROM jointeam where matchkey = '".$id."'  and userid IN (SELECT id from registerusers where is_bot = 1) and is_bot_lineup = 0   LIMIT ".$limits_new.") as t1 ON  t1.id = jointeam.id JOIN (SELECT id , (@row_number1:=@row_number1 + 1) as btRow  , players , vicecaptain  , captain FROM bots_teams where matchkey = '".$id."' and is_lineup = 1 and is_used = 0  LIMIT ".$limits_new.")  as t2
    //             ON t1.jtRow =  t2.btRow
    //             SET jointeam.`players` = t2.players,
    //             jointeam.is_bot_lineup = 1,
    //             jointeam.`vicecaptain` = t2.vicecaptain,
    //             jointeam.captain = t2.captain";

    //     DB::statement(DB::raw( 'SET @row_number = 0'));
    //     DB::statement(DB::raw( 'SET @row_number1 = 0'));
    //     DB::statement($mysql);

    //     sleep(2);
    //               // var_dump($mysql);
    //               // exit;
    //  }

    $mysql = "UPDATE jointeam JOIN (SELECT id , (@row_number:=@row_number + 1) as jtRow FROM jointeam where matchkey = '" . $id . "'  and userid IN (SELECT id from registerusers where is_bot = 1) and is_bot_lineup = 0   LIMIT " . $limits . ") as t1 ON  t1.id = jointeam.id
              JOIN (SELECT id , (@row_number1:=@row_number1 + 1) as btRow  , players , vicecaptain  , captain FROM bots_teams where matchkey = '" . $id . "' and is_lineup = 1 and is_used = 0  LIMIT " . $limits . ")  as t2
              ON t1.jtRow =  t2.btRow
              SET jointeam.`players` = t2.players,
              jointeam.is_bot_lineup = 1,
              jointeam.`vicecaptain` = t2.vicecaptain,
              jointeam.captain = t2.captain";
    var_dump($mysql);
    // exit;

    DB::statement('SET @row_number = 0');
    DB::statement('SET @row_number1 = 0');
    DB::statement($mysql);


    return redirect()->back()->with('success', 'Playings Bots updates successfully');
  }

  public function update_promoter_match_leaderboard($matchkey)
  {

    $listmatches = DB::table('listmatches as l')->where('matchkey', $matchkey)
      ->where('s.is_promoter_series_leaderboard', 1)
      ->join('series as s', 's.id', '=', 'l.series')
      ->where('final_status', 'winnerdeclared')->select('series', 'matchkey')->first();
    // echo "<pre>"; print_r($listmatches); exit;


    if (!empty($listmatches)) {

      $pl_users = DB::table('promoter_leaderboard_users')
        ->where('series_id', $listmatches->series)
        ->get();
      //  echo "<pre>"; print_r($pl_users); exit;
      if (!empty($pl_users)) {
        foreach ($pl_users as $key => $plu) {
          $leaderboard = DB::table('leaderboard as l')
            ->join('registerusers as r', 'r.id', '=', 'l.user_id') // Fixing alias syntax
            ->join('matchchallenges as mc', function ($join) {
              $join->on('mc.id', '=', 'l.challenge_id')
                ->where('mc.entryfee', '>', 0)  // Removed quotes around numbers
                ->where(function ($query) {
                  $query->where('mc.bonus_precent', '!=', 100)  // Numeric comparison for bonus_precent
                    ->orWhereNull('mc.bonus_precent');     // Check for NULL or empty values
                })
                ->where('mc.status', '!=', 'canceled');
            })
            ->where('mc.matchkey', $listmatches->matchkey)
            ->where('r.refer_id', $plu->user_id)
            ->where('mc.is_private', 0)
            ->where('mc.win_amount', '>', 0)
            ->groupBy('l.user_id')
            ->havingRaw('team_count > 0')
            ->select(
              'l.user_id',
              DB::raw("MAX(l.points) as points, COUNT(l.team_id) as team_count,
                        " . $listmatches->series . " AS series_id,
                        '" . $listmatches->matchkey . "' AS match_id")
            )
            ->orderBy('points', 'DESC')
            ->get();

          if (!empty($leaderboard)) {
            foreach ($leaderboard as $key => $value_l) {
              $leade_team_id = DB::table('leaderboard')->join('matchchallenges', 'matchchallenges.id', '=', 'leaderboard.challenge_id')
                ->where('user_id', $value_l->user_id)
                ->where('matchchallenges.matchkey', $listmatches->matchkey)
                ->where('points', $value_l->points)->first();
              // var_dump($leade_team_id);exit;
              $leaderboard[$key]->player_team_id = $leade_team_id->team_id;
              $leaderboard[$key]->promoter_leaderboard_id = $plu->id;
            }

            $data = collect($leaderboard)->map(function ($x) {
              return (array) $x;
            })->toArray();
            //echo "<pre>"; print_r($data);
            $check = DB::table('promoter_match_leaderboard')->where('match_id', $matchkey)->where('promoter_leaderboard_id', $plu->id)->exists();
            if ($check) {
              DB::table('promoter_match_leaderboard')->where('match_id', $matchkey)->where('promoter_leaderboard_id', $plu->id)->delete();
            }
            DB::table('promoter_match_leaderboard')->insert($data);
            $this->update_promoter_series_leaderboard($plu->id);
          }
        }
        //DB::table('listmatches')->where('matchkey', $listmatches->matchkey)->update(array("is_leaderboard" => 1));
      }
      //return 1;
    }
    //return 1;
  }

  public function update_promoter_series_leaderboard($promoter_leaderboard_id)
  {

    $match_leaderboard = DB::table('promoter_match_leaderboard')
      ->select(DB::raw('SUM(points) as points, user_id, series_id'))
      ->orderByRaw('SUM(points) DESC')
      ->where('promoter_leaderboard_id', $promoter_leaderboard_id)
      ->groupBy('user_id')->get();

    $lastpoints = 0;
    $skip_count = 0;
    $rank = 1;
    $i = 0;

    if (!$match_leaderboard->isEmpty()) {

      foreach ($match_leaderboard as $key => $value) {

        if ($value->points == $lastpoints) {
          $skip_count++;
          $data[$i]['rank'] = $rank - $skip_count;
        } else {
          $data[$i]['rank'] = $rank;
          $skip_count = 0;
        }
        $data[$i]['points'] = $value->points;
        $data[$i]['user_id'] = $value->user_id;
        $data[$i]['series_id'] = $value->series_id;;
        $data[$i]['promoter_leaderboard_id'] = $promoter_leaderboard_id;
        $data[$i]['status'] = 1;

        $rank++;
        $i++;
        $lastpoints = $value->points;
      }

      $check = DB::table('promoter_series_leaderboard')->where('promoter_leaderboard_id', $promoter_leaderboard_id)->exists();
      if ($check) {
        DB::table('promoter_series_leaderboard')->where('promoter_leaderboard_id', $promoter_leaderboard_id)->delete();
      }
      DB::table('promoter_series_leaderboard')->insert($data);
    }

    //return 1;
  }
  public function update_promoter_match_leaderboard_old($matchkey, $sport_type = 1, $Promoter_series_id = 20)
  {
    //dd($Promoter_series_id);
    $listmatches = DB::table('listmatches as l')
      ->where('matchkey', $matchkey)
      ->where('final_status', 'winnerdeclared')
      ->where('l.sport_type', $sport_type)
      ->select('series', 'matchkey')->first();

    // echo "<pre>"; print_r($listmatches); exit;
    if (!empty($listmatches)) {
      $check = DB::table('promoter_match_leaderboard')
        ->where('match_id', $matchkey)
        ->exists();
      if ($check) {
        //   dd('dfasf');
        DB::table('promoter_match_leaderboard')
          ->where('match_id', $matchkey)
          ->delete();
      }
      // dd('dfasf111');
      $leaguestransadb = DB::table("leaugestransactions")
        ->join('matchchallenges', 'matchchallenges.id', '=', 'leaugestransactions.challengeid')
        ->join('registerusers', 'registerusers.id', '=', 'leaugestransactions.user_id')
        ->where('leaugestransactions.matchkey', $matchkey)
        ->where('matchchallenges.sport_type', $sport_type)
        ->where('matchchallenges.status', '!=', 'canceled')
        // ->where('registerusers.refer_id' ,'!=',0)   // Uncomment After check issue
        // ->where('registerusers.id' ,'>',1835940)
        ->select(DB::raw('SUM(leaugestransactions.winning + leaugestransactions.balance) as points, registerusers.refer_id as user_id'))
        ->groupBy('registerusers.refer_id')
        ->get();
      // echo"<pre>";print_r($leaguestransadb);die;
      foreach ($leaguestransadb as $key => $value_data) {

        $promoter_check = DB::table("registerusers")->where("id", $value_data->user_id)->first();
        if (!empty($promoter_check)) {
          if (!empty($promoter_check->is_yoububer == 1)) {
            // dd($promoter_check);
            // dd($value_data->user_id);
            // promoter  leaderboard id check
            $is_selected_promoter = DB::table('promoter_leaderboard_users')
              ->where('user_id', $value_data->user_id)
              ->first();
            // echo "<pre>"; print_r($is_selected_promoter); exit;
            if (!empty($is_selected_promoter)) {

              $data['match_id'] = $listmatches->matchkey;
              $data['series_id'] = $listmatches->series;
              $data['user_id'] = $value_data->user_id;
              $data['points'] = $value_data->points;
              $data['promoter_leaderboard_id'] = $Promoter_series_id;
              // $data['sport_type'] = $sport_type;
              // dd($data);
              DB::table('promoter_match_leaderboard')->insert($data);
            }
          }
        }
      }

      $this->update_promoter_series_leaderboard_old($Promoter_series_id);

      //return 1;
    }
    //return 1;
  }
  public function update_promoter_series_leaderboard_old($promoter_leaderboard_id)
  {

    $match_leaderboard = DB::table('promoter_match_leaderboard')
      ->select(DB::raw('SUM(points) as points, user_id, series_id'))
      ->orderByRaw('SUM(points) DESC')
      ->where('promoter_leaderboard_id', $promoter_leaderboard_id)
      ->groupBy('user_id')->get();

    $lastpoints = 0;
    $skip_count = 0;
    $rank = 1;
    $i = 0;

    if (!$match_leaderboard->isEmpty()) {

      foreach ($match_leaderboard as $key => $value) {

        if ($value->points == $lastpoints) {
          $skip_count++;
          $data[$i]['rank'] = $rank - $skip_count;
        } else {
          $data[$i]['rank'] = $rank;
          $skip_count = 0;
        }
        $data[$i]['points'] = $value->points;
        $data[$i]['user_id'] = $value->user_id;
        $data[$i]['series_id'] = $promoter_leaderboard_id;
        $data[$i]['promoter_leaderboard_id'] = $promoter_leaderboard_id;
        $data[$i]['status'] = 1;

        $rank++;
        $i++;
        $lastpoints = $value->points;
      }

      $check = DB::table('promoter_series_leaderboard')->where('promoter_leaderboard_id', $promoter_leaderboard_id)->exists();
      if ($check) {
        DB::table('promoter_series_leaderboard')->where('promoter_leaderboard_id', $promoter_leaderboard_id)->delete();
      }
      DB::table('promoter_series_leaderboard')->insert($data);
    }

    //return 1;
  }

  public function update_ScoreCard_of_matches()
  {
    //echo 'hi';die;
    date_default_timezone_set('Asia/Kolkata');
    $findmatchexist = DB::table('listmatches')
      ->whereDate('start_date', '<=', date('Y-m-d hh:mm:ss'))
      ->whereDate('start_date', '>=', date('Y-m-d', strtotime('-5 days')))
      ->where('launch_status', 'launched')
      ->whereNotIn('final_status', ['winnerdeclared', 'IsCanceled', 'IsAbandoned'])
      ->where('status', '!=', 'completed')
      ->where('status', '=', 'started')
      ->where('sport_type', 1)
      //  ->where('matchkey',"77562")
      ->orderBy('id', 'DESC')
      ->pluck('matchkey');

    if (!empty($findmatchexist) && count($findmatchexist) > 0) {
      foreach ($findmatchexist as $key => $match_key) {
        $match_detail = $giveresresult = Cricketapi2Controller::get_match_details($match_key);
        if (empty($match_detail) || !isset($giveresresult->teama)) {
          return Redirect::back();
        }
        $updateMatchScored  =  Helpers::UpdateMatchScored($match_key, 1, $giveresresult, $match_detail = "");
        $inningdata = DB::table('matchruns')->where('matchkey', $match_key)
          ->where('sport_type', 1)->orderby('inning', 'DESC')->select('inning')->first();
        if (!empty($inningdata)) {

          $this->livescoreapi($match_key);
          $this->livescoreapi_commentry($match_key, $inningdata->inning);
        }
      }
      echo  "Done";
    } else {
      echo  "No data found";
    }
  }

  public function update_match_investment_leaderboard($matchkey = '', $sport_type = 1)
  {
    // echo "fghjkl"; exit;
    $listmatches = DB::table('listmatches as l')
      ->join('investment_leaderboard_name as iln', 'iln.series_id', '=', 'l.series')
      ->where('l.matchkey', $matchkey)
      ->where('l.sport_type', $sport_type)
      ->where('final_status', 'winnerdeclared')
      ->select('iln.series_id', 'l.matchkey', 'l.sport_type')->exists();

    $listmatche = DB::table('listmatches as l')
      ->join('investment_leaderboard_name as iln', 'iln.series_id', '=', 'l.series')
      ->where('l.matchkey', $matchkey)
      ->where('l.sport_type', $sport_type)
      ->where('final_status', 'winnerdeclared')
      ->select('iln.series_id', 'l.matchkey', 'l.sport_type')->first();

    if (empty($listmatches)) {
      // Session::flash('error',  trans("Please investment series add after update match investment leaderboard"));
      //return Redirect::back();
      return 1;
    }

    // if(!empty($listmatches)) {
    if ($listmatches) {

      $leaderboard = DB::table("leaugestransactions as l")
        ->join("matchchallenges as m", "m.id", "=", "l.challengeid")
        ->selectRaw("SUM(l.winning+l.balance+l.bonus+l.gst_bonus+l.affiliation_commission) as points, l.user_id,
          '" . $listmatche->series_id . "' as series_id,
          '" . $listmatche->matchkey . "' as match_id
        ")
        ->where('m.matchkey', $listmatche->matchkey)
        ->where('m.sport_type', $listmatche->sport_type)
        ->where('m.is_private', 0)
        ->where('m.status', '<>', 'canceled')
        ->groupBy('l.user_id')
        ->orderBy('points', 'DESC')
        ->get();
      $data = collect($leaderboard)->map(function ($x) {
        return (array) $x;
      })->toArray();

      $joinuser = DB::table('investment_match_leaderboard')
        ->where('match_id', $matchkey)
        ->select('user_id', DB::raw('sum(points) as points'))
        ->groupby('user_id')->having(DB::raw('count(user_id)'), '>', 1)->get();

      $check = DB::table('investment_match_leaderboard')->where('match_id', $matchkey)->exists();

      if ($check) {
        DB::table('investment_match_leaderboard')->where('match_id', $matchkey)->where('manul_update', 0)->delete();
      }

      $data = array_chunk($data, 5000);
      foreach ($data as $key => $value) {
        DB::table('investment_match_leaderboard')->insert($value);
      }

      $joinuser = DB::table('investment_match_leaderboard')
        ->where('match_id', $matchkey)
        ->select('user_id', DB::raw('sum(points) as points'))
        ->groupby('user_id')->having(DB::raw('count(user_id)'), '>', 1)->get();


      if (!empty($joinuser)) {
        foreach ($joinuser as $k => $v) {
          DB::table('investment_match_leaderboard')
            ->where('match_id', $matchkey)->where('user_id', $v->user_id)
            // ->where('manul_update',0)
            ->delete();
          DB::table('investment_match_leaderboard')->insert(['series_id' => $listmatche->series_id, 'match_id' => $matchkey, 'user_id' => $v->user_id, 'points' => $v->points, 'manul_update' => 1]);
        }
      }

      $joinusercheck = DB::table('investment_match_leaderboard')
        ->where('match_id', $matchkey)
        ->select('user_id', DB::raw('sum(points) as points'))
        ->groupby('user_id')->having(DB::raw('count(user_id)'), '>', 1)->get();

      $this->update_investments_leaderboard($listmatche->series_id);
      DB::table('listmatches')
        ->where('matchkey', $listmatche->matchkey)
        ->where('sport_type', $listmatche->sport_type)
        ->update(array("is_update_investment_leaderboard" => 1));

      Session::flash('success', 'Update Investments Leaderboard. Successfully');
      return 1;
      // return Redirect::back();
    }
    // return Redirect::back();
    return 1;
  }

  //Investments Leaderboard Update
  public function update_investments_leaderboard($series_id)
  {
    $match_leaderboard = DB::table('investment_match_leaderboard')->select(DB::raw('SUM(points) as points, user_id, series_id'))->where('series_id', $series_id)->orderByRaw('SUM(points) DESC')->groupBy('user_id')->get();

    $lastpoints = 0;
    $skip_count = 0;
    $rank = 1;
    $i = 0;

    if (!$match_leaderboard->isEmpty()) {
      foreach ($match_leaderboard as $key => $value) {
        if ($value->points == $lastpoints) {
          $skip_count++;
          $data[$i]['rank'] = $rank - $skip_count;
        } else {
          $data[$i]['rank'] = $rank;
          $skip_count = 0;
        }
        $data[$i]['points'] = $value->points;
        $data[$i]['user_id'] = $value->user_id;
        $data[$i]['series_id'] = $value->series_id;
        $data[$i]['status'] = 1;
        $rank++;
        $i++;
        $lastpoints = $value->points;
      }

      $check = DB::table('investment_leaderboard')->where('series_id', $series_id)->exists();

      if ($check) {
        DB::table('investment_leaderboard')->where('series_id', $series_id)->delete();
      }
      $data = array_chunk($data, 5000);
      foreach ($data as $key => $value) {
        DB::table('investment_leaderboard')->insert($value);
      }
    }
    return 1;
  }


  public function get_wrong_winners_list()
  {
    $results = DB::table('finalresults')
      ->select('challengeid', DB::raw('count(userid) as total_users'), DB::raw('sum(amount) as total_amount'))
      ->where('matchkey', '75657')
      ->groupBy('challengeid')
      ->having('total_users', '<', 2)
      ->orderBy('total_amount', 'asc')
      ->get();
    $i = 1;

    $fileName = 'Wrong-winners-report-' . date("YmdHis", time());
    header('Content-Encoding: UTF-8');
    header("Content-type:application/vnd.ms-excel;charset=UTF-8");
    header('Content-Disposition: attachment;filename="' . $fileName . '.csv"');

    $tableheader = array(
      '#',
      'Current Winner',
      'Points when winner declared',
      'Balance',
      'Actual Points',
      'Amount',
      'Actual Winner',
      'Points',
      'Balance'
    );


    $fp = fopen('php://output', 'a');
    fputcsv($fp, $tableheader);

    foreach ($results as $key => $res1) {
      $CW = DB::table('finalresults')
        ->where('matchkey', '75657')
        ->where('challengeid', $res1->challengeid)
        ->first();
      $cw_name = DB::table('registerusers')
        ->join("userbalances", "userbalances.user_id", "=", "registerusers.id")
        ->where('registerusers.id', $CW->userid)
        ->first();
      $leaderboard0 = DB::table('leaderboard')
        ->where('challenge_id', $res1->challengeid)
        ->where('user_id', $CW->userid)
        ->orderBy('points', 'desc')
        ->first();
      $leaderboard = DB::table('leaderboard')
        ->where('challenge_id', $res1->challengeid)
        ->orderBy('points', 'desc')
        ->first();
      $cw_name1 = DB::table('registerusers')
        ->join("userbalances", "userbalances.user_id", "=", "registerusers.id")
        ->where('registerusers.id', $leaderboard->user_id)
        ->first();


      if ($cw_name->team != $cw_name1->team) {
        $row = array(
          $i++,
          $cw_name->team,
          $CW->points,
          $cw_name->winning,
          $leaderboard0->points,
          $CW->amount,
          $cw_name1->team,
          $leaderboard->points,
          $cw_name1->winning
        );

        fputcsv($fp, $row);

        $i++;
      }
    }
    ob_flush();
    flush();
    ob_end_clean();
    exit();
  }
  function fetchSeries(Request $request){
    if($request->get('query'))
    {
     $query = $request->get('query');
     $data = DB::table('series as s')
     ->where('series_status','opened')
     ->select('s.name as series_name','s.id as series_id')
     ->orderBY('s.id','DESC')
     ->where('name', 'LIKE', "%{$query}%")
     ->groupBY('s.id')
     ->limit(30)
     ->get();
     $output = '<ul class="dropdown-menu" style="display:block; position:relative" width:300px;>';
     foreach($data as $row)
     {
      $output .= '
      <li style="padding:5px;"><input type="hidden" id="Seriesid" name="Seriesid" value="'.$row->series_id.'"><a href="#" data-attr-id="'.$row->series_id.'"> '.ucwords($row->series_name).'</a></li>
      ';
     }
     $output .= '</ul>';
     echo $output;
    }
   }
}
