<?php

namespace App\Http\Controllers\Admin;

use App\Model\AdminUser;
use App\Http\Controllers\BaseController;
use App\Model\Players;
use App\Helpers\Helpers;
use Illuminate\Http\Request;
use App\Services\Input;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\File;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\View;
use Yajra\DataTables\Facades\DataTables;

class PlayersController extends BaseController
{
	/*
	 * Function for display email detail from database
	 *
	 * @param null
	 *
	 * @return view page.
	 */
	public $model	=	'Players';

	//First time Lode Function
	public function __construct()
	{
		View::share('modelName', $this->model);
	} //End Function

	//View Players

	//View Players
	public function viewplayers()
	{

		// $findallteams= Db::table('teams')->select('id','team')->get();
		$formData = Input::all();
		if (isset($formData) && !empty($formData)) {
			return Datatables::of(
				DB::table('playerdetails')
					->join('players', function ($join) {
						$join->on('players.player_key', '=', 'playerdetails.player_key')
							->on('players.sport_type', '=', 'playerdetails.sport_type');
					})
					->join('teams', 'teams.id', '=', 'players.team')
					->select('teams.team as teamname', 'playerdetails.*', 'playerdetails.player_key as player_key', 'players.id as id', 'players.role', 'players.credit')
					->orderBy('fullname', 'ASC')
					->groupBy('playerdetails.player_key')
					->groupBy('playerdetails.sport_type')
					->get()
			)
				->addIndexColumn()
				->addColumn('id', function ($result) {
					return $result->id;
				})
				->editColumn('credit', function ($result) {
					return '<td id="credittd' . $result->id . '">
							' . $result->credit . '
							</td>';
				})
				->addColumn('fullname', function ($result) {
					return ucwords($result->fullname);
				})
				->addColumn('image', function ($result) {
					if ($result->image != "") {
						$image = '<img src="' . $result->image . '" style="width:50px; height:50px; border-radius:2px;">';
					} else {
						$image = '<img src="' . DEFAULT_PLAYER_IMAGE_URL . '" style="width:50%; height:50%; border-radius:2px;background-color:red;">';
					}
					return $image;
				})
				->addColumn('role', function ($result) {
					return '<td id="roletd<?php echo $player->id;?>">' . $result->role . '</td>';
				})
				->addColumn('player_key', function ($result) {
					return $result->player_key;
				})
				->addColumn('credit', function ($result) {
					return $result->credit;
				})
				->addColumn('teamname', function ($result) {
					return $result->teamname;
				})
				->addColumn('sport_type', function ($result) {
					if ($result->sport_type == 1) {
						return 'Cricket';
					} else if ($result->sport_type == 2) {
						return 'Football';
					} else if ($result->sport_type == 3) {
						return 'Basketball';
					}
					return $result->sport_type;
				})
				->addColumn('action', function ($result) {
					$bowler = $result->role;
					return '<a href="' . route($this->model . '.edit', [base64_encode(serialize($result->id)), $result->sport_type]) . '" data-toggle="tooltip" title="Edit" class="btn btn-rg mr-1 mt-1" data-original-title="Edit"><i class="fa fa-pencil" aria-hidden="true"></i></a>'
						. '<a onclick="updateplayer(' . $result->id . ',' . $result->credit . ')" id="updateplayer' . $result->id . '" class="btn btn-rg mr-1 mt-1" aria-hidden="true" data-toggle="tooltip" title="Change Credits" data-original-title="Refresh"><i class="fa fa-refresh"></i></a>'
						. '<a id="saveplayer' . $result->id . '" class="btn btn-rg mr-1 mt-1" style="display:none;cursor:pointer" data-toggle="tooltip" title="" data-original-title="Save" ><i class="fa fa-floppy-o" aria-hidden="true"></i></a>'
						. '<a href="' . route($this->model . '.delete', base64_encode(serialize($result->id))) . '" data-toggle="tooltip" title="delete" class="btn btn-danger action-players"><i class="fa fa-times mr-2" aria-hidden="true" data-original-title="Delete"></i>Delete</a>';
					// onclick="saveplayer('.$result->id.')"
				})
				->escapeColumns([])
				->make(true);
		} //end
		return view("admin.$this->model.viewplayers");
	} //End Function


	public function deleteplayer($id)
	{
		$id = unserialize(base64_decode($id));
		$findPlayer = DB::table('players')->where('id', $id)->first();
		if (!empty($findPlayer)) {
			// dd($findPlayer);
			DB::table('players')->where('id', $id)->delete();
			Session::flash('flash_notice', 'Successfully Deleted Player!');
			Helpers::logActivity('Successfully Deleted Player!', $findPlayer->id);
			Session::flash('alert-class', 'alert-success');
		} else {
			Session::flash('flash_notice', 'Invalid Player id');
			Session::flash('alert-class', 'alert-error');
		}
		return Redirect::back();
	}
	public function editplayer(Request $request, $id, $sport_type = 1)
	{
		$id = unserialize(base64_decode($id));

		//Get Player Data


		$playerskeyget = DB::table('players')->where('id', $id)
			->where('sport_type', $sport_type)
			->select('id', 'player_key', 'sport_type')->first();
		//dd($playerskeyget);
		$player = DB::table('playerdetails as pld')
			->join('players as pl', 'pl.player_key', '=', 'pld.player_key')
			->join('teams as tm', 'tm.id', '=', 'pl.team')
			->select('tm.team as teamname', 'pl.player_key as player_key', 'pld.*', 'pl.credit', 'pl.role', 'pl.id as pid')
			->where('pld.player_key', @$playerskeyget->player_key)
			->where('pld.sport_type', @$playerskeyget->sport_type)
			->first();
		$formData	=	Input::all();
		if (!empty($formData)) {
			// dd($formData);
			unset($formData['_token']);
			$playerdetail['fullname'] = $formData['player_name'];
			$playerdetail['country'] = $formData['country'];
			$playerdetail['bowling_style'] = $formData['bowling_style'];
			$playerdetail['batting_style'] = $formData['batting_style'];
			if ($formData['dob'] != '') {
				$playerdetail['dob'] = date('Y-m-d', strtotime($formData['dob']));
			} else {
				$playerdetail['dob'] = null;
			}
			$playerdetail['sport_type'] = $formData['sport_type'];
			$input = $request->all();
			if (Input::hasFile('image')) {
				// dd('as');
				$extension =	Input::file('image')->getClientOriginalExtension();
				$img_ext = explode(",", IMAGE_EXTENSION);
				if (in_array($extension, $img_ext)) {
					$destinationPath = 'uploads/players';
					$fileName = BRAND['name'] . '-player-' . rand(10000, 99999) . '.' . $extension;
					//print_r(PLAYER_IMAGE_ROOT_PATH);die;
					if (Input::file('image')->move(PLAYER_IMAGE_ROOT_PATH, $fileName)) {
						if ($player->image != "") {
							File::delete($destinationPath . '/' . $player->image);
						}
						//$playerd['image'] = $fileName;
					}
					$name =  TeamsController::aws_upload_image('uploads/players/' . $fileName, "uploads/players/", $fileName);
					
					$playerdetail['image'] = env('CDN_URL').'uploads/players/'.$name;
					// dd($playerdetail['image']);
				} else {
					Session::flash('error',  trans("messages.$this->model.INVALID_IMAGE_EXTENSION"));
					return Redirect::back()->withInput();
				}
			}
			// print_r($playerskeyget->player_key);die;
			DB::table('playerdetails')->where('player_key', $playerskeyget->player_key)->where('sport_type', $playerskeyget->sport_type)->update($playerdetail);
			/* to update credits and roles */
			$playerd['credit'] = $formData['credit'];
			$playerd['role'] = @$formData['role'];
			$playerd['player_name'] = $formData['player_name'];
			$playerd['sport_type'] = $formData['sport_type'];
			$findallplay = DB::table('players')->where('player_key', $playerskeyget->player_key)->get();

			if (!empty($findallplay)) {
				foreach ($findallplay as $fplay) {
					DB::table('players');
					DB::table('players')->where('id', $fplay->id)->where('sport_type', 1)->update($playerd);
				}
			}
			//die;
			// Session::flash('message', 'Successfully updated series!');
			// Session::flash('alert-class', 'alert-success');
			Session::flash('flash_notice',  trans("Player Successfully updated!"));
			Helpers::logActivity('Player successfully updated!', $fplay->player_name);
			return Redirect::route("$this->model.view");
		}
		$sport_types = DB::table('sport_types')->select('id', 'sport_name')->where('status', 1)->get();

		//Session::flash('flash_notice',  trans("Invalid Id Provided!"));
		return view("admin.$this->model.editplayer", compact('player', 'playerskeyget', 'sport_types', 'sport_type'));
	} //End Function

	//Save  Player Roles
	// public function saveplayerroles(Request $request){
	// 	if ($request->isMethod('post')){
	// 		$input = Input::all();
	// 		$data['credit'] = $input['credit'];
	// 		$findplayerkey = DB::table('players')->where('id',$input['id'])->select('player_key')->first();
	// 		$playerkey= $findplayerkey->player_key;
	// 		$findplayers = DB::table('players')->where('player_key',$playerkey)->get();
	// 		if(!empty($findplayers)){
	// 			foreach($findplayers as $pl){
	// 				DB::table('players');
	// 				DB::table('players')->where('id',$pl->id)->update($data);
	// 			}
	// 		}
	// 		echo 1;die;
	// 	}
	// }//End Function

	//Save  Player Roles
	public function saveplayerroles(Request $request)
	{
		if ($request->isMethod('post')) {
			$input = Input::all();
			if ($input['credit'] > 0) {
				$data['credit'] = $input['credit'];
				$findplayerkey = DB::table('players')->where('id', $input['id'])->select('player_key')->first();
				$playerkey = $findplayerkey->player_key;
				$findplayers = DB::table('players')->where('player_key', $playerkey)->get();
				if (!empty($findplayers)) {
					foreach ($findplayers as $pl) {
						DB::table('players');
						DB::table('players')->where('id', $pl->id)->update($data);
					}
				}
			} else {
				Session::flash('flash_notice',  trans("You cannot enter credit of a player more than 0."));
			}
			return Redirect::back();
		}
	} //End Function

	public function addplayermanually(Request $request)
	{
		if ($request->isMethod('post')) {
			$input = Input::all();
			$matchkikey = $input['matchkey'];
			$findplayerexist = DB::table('players')->where('player_key', $input['player_key'])->where('team', $input['team'])->where('sport_type', 1)->first();
			$data['player_name'] = $input['player_name'];
			$data['player_key'] = $input['player_key'];
			$data['role'] =  $input['role'];
			if (empty($findplayerexist)) {
				$data['team'] = $input['team'];
				$playerid = DB::table('players')->insertGetId($data);
				$credit = $input['credit'];
			} else {
				$playerid = $findplayerexist->id;
				$credit = $input['credit'];
			}
			/* insert in player details */
			$findplayerdetails = DB::table('playerdetails')->where('player_key', $input['player_key'])->first();
			if (empty($findplayerdetails)) {
				$fdata['fullname'] = $input['player_name'];
				$fdata['player_key'] = $input['player_key'];
				DB::table('playerdetails')->insert($fdata);
			}
			// insert players for a match//
			$findplayer1entry = DB::table('matchplayers')->where('matchkey', $matchkikey)->where('playerid', $playerid)->first();
			if (empty($findplayer1entry)) {
				$matchplayerdata['matchkey'] = $matchkikey;
				$matchplayerdata['playerid'] = $playerid;
				$matchplayerdata['role'] = $data['role'];
				$matchplayerdata['name'] = $data['player_name'];
				$matchplayerdata['credit'] = $credit;
				DB::table('matchplayers')->insert($matchplayerdata);
			}
			Session::flash('flash_notice', 'Successfully added the player!');
			//Session::flash('alert-class', 'alert-success');
			return Redirect::back();
		}
	}

	//add player
	public function add_player(Request $request)
	{
		// dd($request);
		$teams = DB::table('teams')->select('id', 'team')->orderBy('team', 'ASC')->get();
		$formData	=	Input::all();
		if (!empty($formData)) {

			$validate	=	array(
				'team'	 =>	'required',
				'role'	=>	'required',
				'player_name' => 'required',
				'sport_type' => 'required',
			);
			$validator = Validator::make(Input::all(), $validate);
			if ($validator->fails()) {
				return Redirect::back()->withErrors($validator)->withInput();
			} else {
				unset($formData['_token']);

				$playerData['team'] = $formData['team'];
				$playerData['role'] = $formData['role'];
				$playerData['credit'] = $formData['credit'];
				$playerData['player_name'] = $formData['player_name'];
				$playerData['sport_type'] = $formData['sport_type'];
				$playerData['player_key'] =  substr(str_replace(' ', '', $formData['player_name']), 0, 5) . '_' . $formData['team'] . substr(time(), -4);

				DB::table('players')->insert($playerData);

				$country_detail = DB::table('teams')->where('id', $formData['team'])->select('team')->first();

				$playerdetail['player_key'] = $playerData['player_key'];
				$playerdetail['fullname'] = $formData['player_name'];
				$playerdetail['country'] = $country_detail->team;
				$playerdetail['bowling_style'] = $formData['bowling_style'];
				$playerdetail['batting_style'] = $formData['batting_style'];
				$playerdetail['sport_type'] = $formData['sport_type'];

				$input = $request->all();
				$file = isset($formData['base64image']) ? $formData['base64image'] : '';
				// $input = $request->all();
				if ($formData['base64image'] || $formData['base64image'] != '0') {
					// echo "string"; die();
					$folderPath  = 'uploads/players/';
					// dd($folderPath);
					// $folderPath = public_path('images/');
					$image_parts = explode(";base64,", $formData['base64image']);
					if ($image_parts[0] === "") {
						// echo "string"; die();
						if (input::hasFile('logo')) {
							// echo "string"; die();
							$extension  =   Input::file('logo')->getClientOriginalExtension();
							$img_ext    =   explode(",", IMAGE_EXTENSION);
							if (in_array($extension, $img_ext)) {
								$fileName           =   time() . '-user-image.' . $extension;
								
							} else {
								Session::flash('error',  trans("$this->model.INVALID_IMAGE_EXTENSION"));
								return Redirect::back();
							}
						}
					} else {
						$image_type_aux = explode("image/", $image_parts[0]);
						// dd($image_parts);
						$image_type = $image_type_aux[1];
						// dd($image_type);
						$image_base64 = base64_decode($image_parts[1]);
						// $file = $folderPath . uniqid() . '.png';
						$filename           =   time() . '-user-image.' . $image_type;
						// $filename = time() . '.'. $image_type;
						$file = $folderPath . $filename;
						$formData['logo'] = $filename;
						// dd($file);
						file_put_contents($file, $image_base64);

						//	echo 	$fileName;exit;
						// dd($file);

						// $playerdetail = new Players;
						$fileName =	TeamsController::aws_upload_image('uploads/players/' . $filename, $folderPath, $filename);
						$playerdetail['image'] = env('CDN_URL') . 'uploads/players/' . $fileName;
						// dd($formData);
						@unlink('uploads/players/' . $filename);
						// dd($playerdetail);
						// $playerdetail->save();
					}
				}

				DB::table('playerdetails')->insert($playerdetail);

				Session::flash('flash_notice',  trans("Player Successfully added!"));
				Helpers::logActivity('Player Successfully added!', $formData['player_name']);
				return Redirect::route("$this->model.view");
			}
		}
		$sport_types = DB::table('sport_types')->select('id', 'sport_name')->where('status', 1)->get();

		return view("admin.$this->model.add_player", compact('teams', 'sport_types'));
	} //End Function
}
