<?php

namespace App\Http\Controllers\Admin;

use App\Model\AdminUser;
use App\Http\Controllers\BaseController;
use App\Model\Promotors;
use App\Helpers\Helpers;
use App\libraries\CustomHelper;
use Illuminate\Http\Request;
use App\Services\Input;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\File;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\View;
use Yajra\DataTables\Facades\DataTables;

class PromotorsController extends BaseController
{
    /*
	 * Function for display email detail from database
	 *
	 * @param null
	 *
	 * @return view page.
	 */
    public $model    =    'Promotors';

    //First time Lode Function
    public function __construct()
    {
        View::share('modelName', $this->model);
    } //End Function

    //View Players
    public function viewpromotors($offset_value = 0)
    {

        if (!empty($offset_value) && $offset_value > 0) {
            $offset_value = ($offset_value - 1);
        } else if ($offset_value == 1) {
            $offset_value = 0;
        } else {
            $offset_value = 0;
        }

        $formData = Input::all();
        if (isset($formData) && !empty($formData)) {
            if (isset($formData['custom_page'])) {
                $offset_value = $formData['custom_page'] + 2;
            }
            return Datatables::of(DB::table('promoter_details')
                ->where(function ($query) use ($formData) {

                    if (isset($formData['filter_columns'])) {
                        if (isset($formData['filter_columns']['filter_email'])) {
                            $query->where('email', 'like', '%' . $formData['filter_columns']['filter_email'] . '%');
                        }
                        if (isset($formData['filter_columns']['filter_mobile'])) {
                            $query->where('mobile', 'like', '%' . $formData['filter_columns']['filter_mobile'] . '%');
                        }
                    }
                })
                ->groupBy('user_id')->offset($offset_value)
                ->limit(10000)->get())
                ->addIndexColumn()
                ->addColumn('id', function ($result) {
                    return $result->id;
                })
                /*->editColumn('credit',function ($result){
	           		return '<td id="credittd'.$result->id.'">
							'.$result->credit.'
							</td>';
						})*/
                ->addColumn('name', function ($result) {
                    return ucwords($result->name);
                })
                ->addColumn('email', function ($result) {
                    return $result->email;
                })

                ->addColumn('mobile', function ($result) {
                    return $result->mobile;
                })

                ->addColumn('state', function ($result) {
                    return $result->state;
                })
                ->addColumn('city', function ($result) {
                    return $result->city;
                })
                ->addColumn('user_id', function ($result) {

                    return $result->user_id;
                })
                ->addColumn('date', function ($result) {
                    return $result->created_at;
                })
                ->addColumn('action', function ($result) {

                    return '<a href="' . route($this->model . '.channeldetail', [base64_encode(serialize($result->user_id))]) . '" data-toggle="tooltip" title="view" class="btn btn-success mt-1" data-original-title="Edit">View channel detail</a>';
                })



                //       ->addColumn('action', function ($result) {
                //       	$bowler=$result->role;
                //            return '<a href="'.route($this->model.'.edit',[base64_encode(serialize($result->id)), $result->sport_type]).'" data-toggle="tooltip" title="Edit" class="btn btn-rg mr-1 mt-1" data-original-title="Edit"><i class="fa fa-pencil" aria-hidden="true"></i></a>'
                //            	.'<a onclick="updateplayer('.$result->id.','.$result->credit.')" id="updateplayer'. $result->id.'" class="btn btn-rg mr-1 mt-1" aria-hidden="true" data-toggle="tooltip" title="Change Credits" data-original-title="Refresh"><i class="fa fa-refresh"></i></a>'
                // .'<a id="saveplayer'.$result->id.'" class="btn btn-rg mr-1 mt-1" style="display:none;cursor:pointer" data-toggle="tooltip" title="" data-original-title="Save" ><i class="fa fa-floppy-o" aria-hidden="true"></i></a>'
                // .'<a href="'.route($this->model.'.delete',base64_encode(serialize($result->id))).'" data-toggle="tooltip" title="delete" class="btn btn-danger action-players"><i class="fa fa-times mr-2" aria-hidden="true" data-original-title="Delete"></i>Delete</a>'
                // ;
                // // onclick="saveplayer('.$result->id.')"
                //        })
                ->escapeColumns([])
                ->make(true);
        } //end

        $total_records = count(DB::table('promoter_details')->groupBy('user_id')->get());
        $pages = ceil($total_records / 10);
        if (empty($offset_value)) {

            $offset_value = $offset_value + 1;
        }
        return view("admin.$this->model.view_promotors", compact('pages', 'offset_value'));
    }
    //End Function
    public function promotorschanneldetail($user_id)
    {
        // print_r($userid);exit;
        $userid = unserialize(base64_decode($user_id));
        $data = DB::table('promoter_channel_details')->where(
            'user_id',
            $userid
        )->first();
        $formData = Input::all();
        if (isset($formData) && !empty($formData)) {
            // Helpers::logActivity('Promoter Channels Details !',$data->channel_name);
            return Datatables::of(DB::table('promoter_channel_details')->where('user_id', $userid)->get())
                ->addIndexColumn()


                ->addColumn('id', function ($result) {
                    return $result->id;
                })
                ->addColumn('channel_name', function ($result) {
                    return $result->channel_name;
                })
                ->addColumn('channel_url', function ($result) {
                    return $result->channel_url;
                })
                ->addColumn('channel_type', function ($result) {
                    return $result->channel_type;
                })
                ->addColumn('user_id', function ($result) {
                    return $result->user_id;
                })

                ->escapeColumns([])
                ->make(true);
        }


        return view("admin.$this->model.view_promotorschannel_detail", compact('user_id'));
    }

    public function viewleaderboards(Request $req)
    {
        // echo "on working, manisha ma'am work kr rhi hai";die;
        if ($req->isMethod('post')) {
            $formData = Input::all();

            if (isset($formData) && !empty($formData)) {

                $query = DB::table('promoter_leaderboard_series')->where('sports_type', 1)
                    ->select('*')
                    ->get();
                // dd($query);

                return Datatables::of($query)
                    ->addIndexColumn()
                    ->addColumn('name', function ($result) {
                        return $result->name;
                    })

                    ->addColumn('action', function ($result) {

                        return '<a href="' . route($this->model . '.edit', [base64_encode(serialize($result->id))]) . '" data-toggle="tooltip" title="edit" class="btn btn-success mt-1" data-original-title="Edit" disabled>Edit</a>' .
                            '<a href="' . route($this->model . '.delete', base64_encode(serialize($result->id))) . '" data-toggle="tooltip" title="delete" class="btn btn-danger mt-1" data-original-title="Delete"  disabled >Delete</a>';
                    })

                    ->escapeColumns([])
                    ->make(true);
            } //end
        }

        return  View::make("admin.$this->model.viewleaderboard");
    }
    public function getleaderboard_users(Request $request)
    {
        $leader_user_id = $request->leaderboard_id;
        $getData = DB::table('promoter_leaderboard_users as plusers')
            ->join('registerusers as r', 'r.id', 'plusers.user_id')
            ->where('plusers.promoter_leaderboard_id', $leader_user_id)
            ->select('r.username', 'r.id')
            ->get();
        return response()->json(['data' => $getData]);
    }

    public function editleaderboards($id, Request $request)
    {

        $id = unserialize(base64_decode($id));
        $series = DB::table('promoter_leaderboard_series')->where('id', $id)->first();

        $formData    =    Input::all();
        if (!empty($formData)) {
            $validate    =    array(
                'name'                =>    "required",
            );
            // echo "<pre>"; print_r($formData); exit;
            $validator = Validator::make(Input::all(), $validate);
            if ($validator->fails()) {
                return Redirect::back()->withErrors($validator)->withInput();
            } else {
                $catname = $formData['name'];
                $findseries = DB::table('promoter_leaderboard_series')->where('name', $catname)->where('id', '!=', $id)->first();
                if (!empty($findseries)) {
                    return Redirect::back()
                        ->withErrors('This leaderboard is already exist.')
                        ->withInput(Input::except('password'));
                }

                unset($formData['_token']);
                $formData['start_date'] = date('Y-m-d h:i:s', strtotime($formData['start_date']));
                $formData['end_date'] = date('Y-m-d h:i:s', strtotime($formData['end_date']));
                $formData['status'] = !empty($formData['status']) ? $formData['status'] : 0;


                $rowCOllection = DB::table('promoter_leaderboard_series')->where('id', $id)->update($formData);

                Session::flash('flash_notice',  trans("Successfully updated leaderboard!"));
                Helpers::logActivity('Successfully updated leaderboard!', $formData['name']);
                return Redirect::route($this->model . '.viewleader');
            }
        }
        $sport_types = DB::table('sport_types')->select('id', 'sport_name')->where('status', 1)->get();

        return view("admin.$this->model.editleaderboard", compact('series', 'sport_types'));
    }

    public function deleteleaderboards($id)
    {

        $id = unserialize(base64_decode($id));

        $rowCOllection = DB::table('promoter_leaderboard_series')->where('id', $id)->first();
        if (!empty($rowCOllection)) {
            DB::table('promoter_leaderboard_series')->where('id', $id)->delete();
            Session::flash('flash_notice', 'Successfully Deleted Promoter Leaderboard!');
            Helpers::logActivity('Successfully Deleted Promoter Leaderboard!', $rowCOllection->id);
            Session::flash('alert-class', 'alert-success');
        } else {
            Session::flash('flash_notice', 'Invalid Promoter Leaderboard id');
            Session::flash('alert-class', 'alert-error');
        }
        return Redirect::back();
    }

    public function addleaderboards(Request $request)
    {

        $formData    =    Input::all();
        if (!empty($formData)) {
            $validate    =    array(
                'name'                =>    'required|unique:promoter_leaderboard_series',
            );
            $validator = Validator::make(Input::all(), $validate);
            if ($validator->fails()) {
                return Redirect::back()->withErrors($validator)->withInput();
            } else {
                $input = Input::all();
                // $input = $request->input();
                // print_r($input);die;
                unset($input['_token']);
                $input['start_date'] = date('Y-m-d h:i:s', strtotime($input['start_date']));
                $input['end_date'] = date('Y-m-d h:i:s', strtotime($input['end_date']));
                $input['status'] = !empty($input['status']) ? $input['status'] : 0;
                $input['sports_type'] = 1;
                // var_dump($input);exit;
                DB::table('promoter_leaderboard_series')->insert($input);
                Session::flash('flash_notice',  trans("Successfully added leaderboard!"));
                Helpers::logActivity('Successfully added leaderboard!', $input['name']);
                return Redirect::route($this->model . '.viewleader');
            }
        }
        $sport_types = DB::table('sport_types')->select('id', 'sport_name')->where('status', 1)->get();

        return view('admin.Promotors.addleaderboard', compact( 'sport_types'));
    }
}
