<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Http\Requests;
use Illuminate\Http\Request;
use App\Model\AdminActivityLog;
use App\Helpers\Helpers;
use Carbon\Carbon;
use App\Services\Input;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\View;
use Yajra\DataTables\Facades\DataTables;

date_default_timezone_set("Asia/Kolkata");
class Sub_admin_activityController extends Controller
{
    /*
* Function for display email detail from database
*
* @param null
*
* @return view page.
*/
    public $model = 'AdminActivityLog';

    public function __construct()
    {
        View::share('modelName', $this->model);
        $newDateTime = Carbon::now()->addMinutes(330);
    }


    public function sub_adminAction()
    {
        // echo "string";die();
        $model = new AdminActivityLog;
        $resData = Helpers::logActivity('');
    }
    public function viewtransactionmodel()
    {

        $formdata = Input::all();
        if (isset($formdata) && !empty($formdata)) {
            return Datatables::of(DB::table('withdraw as tr')
                ->join('registerusers as urs', 'urs.id', '=', 'tr.user_id')
                ->where('withdraw_request_id', $formdata['transId'])
                ->select('username', 'withdraw_request_id as transaction_id', 'tr.type as transaction_by', 'amount', 'status', 'tr.approved_date as created')
                ->orderBy('tr.approved_date', 'desc')
                ->get())
                ->addIndexColumn()
                ->addcolumn('username', function ($result) {
                    return ucwords($result->username);
                })
                ->addcolumn('transaction_id', function ($result) {
                    return $result->transaction_id;
                })
                ->addcolumn('transaction_by', function ($result) {
                    return ucwords($result->transaction_by);
                })
                ->addcolumn('amount', function ($result) {
                    return $result->amount;
                })
                ->addcolumn('status', function ($result) {
                    if (!empty($result->status)) {
                        return '<span class="text-success">Confirmed</span>';
                    } else {
                        return '<span class="text-danger">Pending</span>';;
                    }
                })
                ->addcolumn('created', function ($result) {
                    return $result->created;
                })
                ->escapeColumns([])
                ->make(true);
        }
        return view("admin.$this->model.viewActivity");
    }
    public function viewAdminActivity(Request $req)
    {
        if ($req->isMethod('post')) {
            $formdata = Input::all();
            if (isset($formdata) && !empty($formdata)) {
                return Datatables::of(DB::table('sub_admin_activity as sac')
                    ->join('users as urs', 'urs.id', '=', 'sac.user_id')
                    ->where(function ($query) use ($formdata) {
                        if (isset($formdata['filter_columns'])) {

                            if (isset($formdata['filter_columns']['filter_activity_subject'])) {
                                $query->where('activity', 'like', '%' . $formdata['filter_columns']['filter_activity_subject'] . '%');
                            }

                            if (isset($formdata['filter_columns']['filter_activity_name'])) {
                                $query->where('activity_element', 'like', '%' . $formdata['filter_columns']['filter_activity_name'] . '%');
                            }
                        }
                    })
                    ->select('urs.name', 'activity', 'activity_element', 'sac.created_at as create', 'sac.transaction_id as transaction_id', 'sac.updated_at as update')
                    ->orderBy('sac.created_at', 'desc')->orderBy('sac.updated_at', 'desc')

                    ->limit(1000)
                    ->get())
                    ->addIndexColumn()
                    ->addcolumn('name', function ($result) {
                        return ucwords($result->name);
                    })
                    ->addcolumn('activity', function ($result) {
                        return $result->activity;
                    })
                    ->addcolumn('activity_element', function ($result) {
                        if (!empty($result->transaction_id)) {
                            return '<a href="" id="transaction_details" data-toggle="modal" data-target="#transaction_modal" data-id="' . $result->transaction_id . '">' . $result->activity_element . '</a>';
                        } else {
                            return $result->activity_element;
                        }
                    })
                    ->addcolumn('created_at', function ($result) {
                        return $result->create;
                    })
                    // ->addcolumn('updated_at',function($result){
                    //   return $result->update;
                    // })
                    ->escapeColumns([])
                    ->make(true);
            }
        }

        return view("admin.$this->model.viewActivity");
    } //endclass


} //End Class
