<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Services\Input;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Validator;

class SubadminController extends Controller
{

    public function login()
    {
        $formData       = Input::all();
        if (!empty($formData)) {
            $message  = array(
                'name.required'         => 'Please enter name.',
                'email_id.required'     => 'Please enter email id.',
                'phone_no.required'     => 'Please enter phone no.',
                'password.required'     => 'Please enter password.',
            );
            $validate = array(
                'name'                      => 'required',
                'email_id'                => 'required|email|unique:sub_admin,email_id,NULL,id',
                'phone_no'                => 'required|numeric|min:10',
                'password'                => 'required',
            );
            $validator = Validator::make(Input::all(), $validate, $message);
            if ($validator->fails()) {
                return Redirect::back()->withErrors($validator)->withInput();
                //Validation Comp.
            } else {
                //Insert Data
                $data['name'] = $formData['name'];
                $data['email_id'] = $formData['email_id'];
                $data['phone_no'] = $formData['phone_no'];
                $data['password'] = bcrypt($formData['password']);
                DB::table('sub_admin')->insert($data);
                Session::flash('message', 'Add Sub Admin Successfully!');
                Session::flash('alert-class', 'alert-success');
                return Redirect::to(action('Sub_adminController@index'));
            }
        } else {
            return view('auth.login');
        }
    }
}//End Class
