<?php
namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Services\Input;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\File;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\View;
use Yajra\DataTables\Facades\DataTables;

class TDSController extends Controller {

	/*
	 * Function for display email detail from database
	 *
	 * @param null
	 *
	 * @return view page.
	 */
	public $model	=	'TDSDetails';

	public function __construct() {
		View::share('modelName',$this->model);
	}//End Function


  public function viewDetails(Request $request)
  {
      if ($request->isMethod('post')) {

        $formData = Input::all();
				// echo "<pre>"; print_r(); die;
        if (isset($formData) && !empty($formData)) {

          return Datatables::of($query=DB::table('registerusers as r')
          ->join('tdsdetails as tds', 'tds.userid' ,'=','r.id')
          ->leftJoin('pancard as p', 'p.userid' ,'=','r.id')
          ->leftJoin('series as s', 's.id' ,'=','tds.seriesid')
          ->leftJoin('matchchallenges as mc', 'mc.challenge_id' ,'=','tds.challengeid')
          ->leftJoin('listmatches as lm', 'lm.matchkey' ,'=','mc.matchkey')
          ->select('r.username', 'r.email','r.mobile','r.id','p.pan_number','tds.tds_amount','tds.amount','s.name','lm.name as matchname')
          ->where(function ($query) use ($formData) {
            if (isset($formData['filter_columns']['filter_email'])) {
                $query->where('r.email','LIKE','%'.$formData['filter_columns']['filter_email'].'%');
              }
						if (isset($formData['filter_columns']['filter_start'])) {
							  $query->whereBetween('tds.created_at', [$formData['filter_columns']['filter_start'], $formData['filter_columns']['filter_end']]);

              }

          })
          ->get())
          ->addIndexColumn()
					->addColumn('net_amount',function ($result){
							 return $result->amount - $result->tds_amount;
					})
          ->escapeColumns([])
          ->make(true);
        }//end
      }

    return view("admin.$this->model.tdsView");
  }

	public function TDSDetailsDowmload(Request $request){

		//echo "<pre>"; print_r($request['start_date']); die;

		$output1 = "";
		$output1 .='"USERNAME",';
		$output1 .='"EMAIL",';
		$output1 .='"MOBILE",';
		$output1 .='"USER PAN NUMBER",';
		$output1 .='"SERIES NAME",';
		$output1 .='"MATCH NAME",';
		$output1 .='"WINING AMOUNT",';
		$output1 .='"TDS AMOUNT",';
		$output1 .='"NET WINING AMOUNT",';
		$output1 .="\n";

		$query= DB::table('registerusers as r')
		->join('tdsdetails as tds', 'tds.userid' ,'=','r.id')
		->leftJoin('pancard as p', 'p.userid' ,'=','r.id')
		->leftJoin('series as s', 's.id' ,'=','tds.seriesid')
		->leftJoin('matchchallenges as mc', 'mc.challenge_id' ,'=','tds.challengeid')
		->leftJoin('listmatches as lm', 'lm.matchkey' ,'=','mc.matchkey')
		->select('r.username', 'r.email','r.mobile','r.id','p.pan_number','tds.tds_amount','tds.amount','s.name','lm.name as matchname')
		->whereBetween('tds.created_at', [$request['start_date'], $request['end_date']])
		->get();
	 // echo "<pre>";print_r($query); die;
		if(!empty($query)){
		foreach($query as $get){
		$output1 .='"'.$get->username.'",';
		$output1 .='"'.$get->email.'",';
		$output1 .='"'.$get->mobile.'",';
		$output1 .='"'.$get->pan_number.'",';
		$output1 .='"'.$get->name.'",';
		$output1 .='"'.$get->matchname.'",';
		$output1 .='"'.$get->amount.'",';
		$output1 .='"'.$get->tds_amount.'",';
		$output1 .= $get->amount - $get->tds_amount;
		$output1 .="\n";
		}
		}
		// echo "<pre>";print_r($output1); die;
	 //  print_r($output1); die();

		$filename =  "TDS-Details.csv";
		header('Content-type: application/csv');
		header('Content-Disposition: attachment; filename='.$filename);
		echo $output1;
		exit;
	}

}//End Class
