<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Http\Requests;
use App\Helpers\Helpers;
use App\Model\Team;
use mjanssen\BreadcrumbsBundle\Breadcrumbs as Breadcrumb;
use Aws\S3\S3Client;
use App\Services\Input;
use Aws\S3\Exception\S3Exception;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\File;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\View;
use Yajra\DataTables\Facades\DataTables;

class TeamsController extends Controller
{
	/*
	 * Function for display email detail from database
	 *
	 * @param null
	 *
	 * @return view page.
	 */
	public $model	=	'Team';

	public function __construct()
	{
		View::share('modelName', $this->model);
	}

	//View Team
	public function viewteams()
	{
		$formData = Input::all();
		if (isset($formData) && !empty($formData)) {
			return Datatables::of(DB::table('teams')->get())
				->addIndexColumn()
				->addColumn('logo', function ($result) {
					if ($result->logo != "") {
						$logo = '<img src="' . $result->logo . '" style="width:70px; height:35px; border-radius:2px;"/>';
					} else {
						$logo = '<img src="' . DEFAULT_TEAM_IMAGE_URL . '" class="py-2" style="width:100px;height:100px;background-color:red;">';
					}
					return $logo;
				})
				->addColumn('action', function ($result) {
					return '<a href="' . route($this->model . '.edit', base64_encode(serialize($result->id))) . '" data-toggle="tooltip" title="" class="btn btn-rg mr-1 mt-1" data-original-title="Edit"><i class="fa fa-pencil mr-2" aria-hidden="true"></i>Edit</a>';
				})
				->escapeColumns([])
				->make(true);
		} //end

		//print_r($this->model);die;
		return view("admin.$this->model.viewteams");
	}

	//Edit Team
	public function editteams_old($id = null)
	{
		//Decode Id
		$id = unserialize(base64_decode($id));
		//Get Data
		$series = DB::table('teams')->where('id', $id)->first();

		$formData	=	Input::all();
		if (!empty($formData)) {
			$validate	=	array(
				'team'			    =>	'required',
				'short_name'		=>	'required',
			);
			$validator = Validator::make(Input::all(), $validate);
			if ($validator->fails()) {
				return Redirect::back()->withErrors($validator)->withInput();
			} else {

				$catname = $formData['team'];
				$findteams = DB::table('teams')->where('team', $catname)->where('id', '!=', $id)->first();
				if (!empty($findseries)) {
					return Redirect::back()
						->withErrors('This teams is already exist.')
						->withInput(Input::except('password'));
				}
				unset($formData['_token']);

				//$formData['team_key'] = $formData['team_key'];

				$file = isset($formData['logo']) ? $formData['logo'] : '';
				if (!empty($formData['logo'])) {
					if (!empty($file)) {
						$destinationPath = 'uploads/teams';
						$fileName = '11CAPS-team-' . str_replace(' ', '-', $series->team);
						if ($series->logo != "") {
							File::delete($destinationPath . '/' . $series->logo);
						}
						$imageName = CustomHelper::imageUpload($file, $destinationPath, $fileName);

						$formData['logo'] = $imageName;
					}
				}
				// print_r($formData);die;//KTS
				DB::table('teams')->where('id', $id)->update($formData);
				//Update
				Session::flash('flash_notice',  trans("Team updated successfully."));
				Helpers::logActivity('Team updated!', $formData['team']);
				return Redirect::route("$this->model.view");
			}
		}
		### Breadcrumb End ###
		return view("admin.$this->model.editteams", compact('series'));
	}

	public function editteams($id = null)
	{
		//Decode Id
		$id = unserialize(base64_decode($id));
		//Get Data
		$series = DB::table('teams')->where('id', $id)->first();
		### Breadcrumb End ###
		$formData	=	Input::all();
		if (!empty($formData)) {
			$validate	=	array(
				'team'			    =>	'required',
				'short_name'		=>	'required',
			);
			$validator = Validator::make(Input::all(), $validate);
			if ($validator->fails()) {
				return Redirect::back()->withErrors($validator)->withInput();
			} else {

				$catname = $formData['team'];
				$findteams = DB::table('teams')->where('team', $catname)->where('id', '!=', $id)->first();
				if (!empty($findseries)) {
					return Redirect::back()
						->withErrors('This teams is already exist.')
						->withInput(Input::except('password'));
				}
				unset($formData['_token']);

				$formData['color'] = @$formData['color'];


				$file = isset($formData['base64image']) ? $formData['base64image'] : '';
				// $input = $request->all();
				if ($formData['base64image'] || $formData['base64image'] != '0') {
					// echo "string"; die();
					$folderPath  = 'uploads/teams/';
					// dd($folderPath);
					// $folderPath = public_path('images/');
					$image_parts = explode(";base64,", $formData['base64image']);
					if ($image_parts[0] === "") {
						// echo "string"; die();
						if (input::hasFile('logo')) {
							// echo "string"; die();
							$extension  =   Input::file('logo')->getClientOriginalExtension();
							$img_ext    =   explode(",", IMAGE_EXTENSION);
							if (in_array($extension, $img_ext)) {
								$fileName           =   time() . '-user-image.' . $extension;
								if (Input::file('logo')->move('uploads/teams/', $fileName)) {
									$formData['logo']     =   $fileName;
									// dd($obj['image']);
								}
								@unlink('uploads/teams/' . $oldimage);
							} else {
								Session::flash('error',  trans("$this->model.INVALID_IMAGE_EXTENSION"));
								return Redirect::back();
							}
						}
					} else {
						$image_type_aux = explode("image/", $image_parts[0]);
						// dd($image_parts);
						$image_type = $image_type_aux[1];
						// dd($image_type);
						$image_base64 = base64_decode($image_parts[1]);
						// $file = $folderPath . uniqid() . '.png';
						$filename           =   time() . '-user-image.' . $image_type;
						// $filename = time() . '.'. $image_type;
						$file = $folderPath . $filename;
						$formData['logo'] = $filename;
						// dd($file);
						file_put_contents($file, $image_base64);

						//	echo 	$fileName;exit;
						// dd($file);

						// $playerdetail = new Players;
						$fileName =	$this->aws_upload_image(TEAM_IMAGE_URL_ROOT_PATH . $filename, $folderPath, $filename);
						$datateam['logo'] = env('CDN_URL') . 'uploads/teams/' . $fileName;
						$formData['logo'] = env('CDN_URL') . 'uploads/teams/' . $fileName;
						
						@unlink('uploads/teams/' . $filename);
						// dd($playerdetail);
						// $playerdetail->save();
					}
				}

				if (!empty($formData['logo'])) {
					if (!empty($formData)) {


						$formData = [
							'team' => $formData['team'],
							'logo' => $formData['logo'],
							'short_name' => $formData['short_name'],
							'color' => @$formData['color'],
						];
					}
				} else {
					$formData = [
						'team' => $formData['team'],
						'short_name' => $formData['short_name'],
						'color' => @$formData['color'],
					];
				}
				// echo"<pre>";print_r($formData['logo']);exit;
				DB::table('teams')->where('id', $id)->update($formData);
				//Update
				Session::flash('flash_notice',  trans("Team updated successfully"));
				Helpers::logActivity('Team updated!', $formData['team']);
				return Redirect::route("$this->model.view");
			}
		}
		return view("admin.$this->model.editteams", compact('series'));
	}


	public static function aws_upload_image($path_to_file, $upload_path, $file_name)
	{

		// require_once(APP . 'Vendor' . DS . 'autoload.php');

		try {

			//Create a S3Client

			//  print_r($path_to_file);die;

			$s3 = new S3Client([

				'version' => 'latest',

				'region'  => env('REGION'),

				'endpoint' => env('ENDPOINT'),

				'credentials' => [

					'key'    => env('S3_KEY'),

					'secret' => env('S3_SECRET'),

				],

			]);

			$result = $s3->putObject([

				'Bucket' => env('S3_NAME'),

				'Key' => $upload_path . $file_name,

				'SourceFile' => $path_to_file,

				'Body' => $path_to_file,

				'ACL'          => 'public-read'

			]);

			// print_r($result); exit;

			return $file_name;
		} catch (S3Exception $e) {
			return false;
		}
	}

	public function add_team()
	{
		$formData	=	Input::all();
		// echo"<pre>";print_r($formData);exit;
		if (!empty($formData)) {
			$validate	=	array(
				'team'			    =>	'required',
				'short_name'		=>	'required',
			);
			$validator = Validator::make(Input::all(), $validate);
			if ($validator->fails()) {
				return Redirect::back()->withErrors($validator)->withInput();
			} else {

				unset($formData['_token']);
				$formData['team_key'] = substr(str_replace(' ', '', $formData['team']), 0, 5) . '_' . substr(time(), -4);

				$file = isset($formData['base64image']) ? $formData['base64image'] : '';


				$file = isset($formData['base64image']) ? $formData['base64image'] : '';
				// $input = $request->all();
				if ($formData['base64image'] || $formData['base64image'] != '0') {
					// echo "string"; die();
					$folderPath  = 'uploads/teams/';
					// dd($folderPath);
					// $folderPath = public_path('images/');
					$image_parts = explode(";base64,", $formData['base64image']);
					if ($image_parts[0] === "") {
						// echo "string"; die();
						if (input::hasFile('logo')) {
							// echo "string"; die();
							$extension  =   Input::file('logo')->getClientOriginalExtension();
							$img_ext    =   explode(",", IMAGE_EXTENSION);
							if (in_array($extension, $img_ext)) {
								$fileName           =   time() . '-user-image.' . $extension;
								if (Input::file('logo')->move('uploads/teams/', $fileName)) {
									$formData['logo']     =   $fileName;
									// dd($obj['image']);
								}
								@unlink('uploads/teams/' . $oldimage);
							} else {
								Session::flash('error',  trans("$this->model.INVALID_IMAGE_EXTENSION"));
								return Redirect::back();
							}
						}
					} else {
						$image_type_aux = explode("image/", $image_parts[0]);
						// dd($image_parts);
						$image_type = $image_type_aux[1];
						// dd($image_type);
						$image_base64 = base64_decode($image_parts[1]);
						// $file = $folderPath . uniqid() . '.png';
						$filename           =   time() . '-user-image.' . $image_type;
						// $filename = time() . '.'. $image_type;
						$file = $folderPath . $filename;
						$formData['logo'] = $filename;
						// dd($file);
						file_put_contents($file, $image_base64);

						//	echo 	$fileName;exit;
						// dd($file);

						// $playerdetail = new Players;
						$fileName =	$this->aws_upload_image(TEAM_IMAGE_URL_ROOT_PATH . $filename, $folderPath, $filename);
						$formData['logo'] = env('CDN_URL') . 'uploads/teams/' . $fileName;
						// dd($formData);
						@unlink('uploads/teams/' . $filename);
						// dd($playerdetail);
						// $playerdetail->save();
					}
				}


				$imageCheck = !empty($formData['logo']) ? $formData['logo'] : null;
				if (!empty($formData)) {
					// dd($formData);
					$formData = [
						'team' => $formData['team'],
						'team_key' => $formData['team_key'],
						'logo' => $imageCheck,
						// unset($formData['logo']);
						'short_name' => $formData['short_name'],
					];
				}

				// dd($formData);
				DB::table('teams')->insert($formData);
				Session::flash('flash_notice',  trans("Successfully team added!"));
				Helpers::logActivity('Team added!', $formData['team_key']);
				return Redirect::route("$this->model.view");
			}
		}
		return view("admin.$this->model.add_team");
	}
}
