<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Services\Input;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Support\Facades\View;
use Yajra\DataTables\Facades\DataTables;

class TransactionManagerController extends Controller
{

    /*
	 * Function for display email detail from database
	 *
	 * @param null
	 *
	 * @return view page.
	 */
    public $model    =    'TransactionManager';

    public function __construct()
    {
        View::share('modelName', $this->model);
    } //End Function

    //User Balance DETAIL
    public function investedamount(Request $req)
    {
        //Get Post Data
        $formData = Input::all();
        if ($req->ismethod('post')) {
            if (isset($formData) && !empty($formData)) {
                return Datatables::of(DB::table('listmatches')
                    ->join('series as s', 's.id', '=', 'listmatches.series')
                    ->where('launch_status', 'launched')
                    ->whereNotIn('final_status', ['winnerdeclared', 'IsCanceled', 'IsAbandoned'])
                    ->select('listmatches.*', 's.name as series_name')
                    ->orderBy('listmatches.start_date', 'ASC')
                    ->orderBy('id', 'DESC')
                    ->get())
                    ->addIndexColumn()
                    ->addColumn('sports', function ($result) {
                        $sportType = '';
                        if ($result->sport_type == '1') {
                            $sportType = 'CRICKET';
                        }
                        if ($result->sport_type == '2') {
                            $sportType = 'FOOTBALL';
                        }
                        if ($result->sport_type == '3') {
                            $sportType = 'BASKETBALL';
                        }
                        return $result->matchkey;
                    })
                    ->addColumn('final_status', function ($result) {
                        $final_status = '';
                        if ($result->status == 'started' && $result->final_status == 'pending') {
                            $final_status = 'Live';
                        } else if ($result->final_status == 'pending' && $result->status == 'notstarted') {
                            $final_status = 'Upcoming';
                        } else if ($result->final_status == 'IsReviewed') {
                            $final_status = 'Under Review';
                        }

                        return $final_status;
                    })
                    ->addColumn('investedamount', function ($result) {
                        $leaugestransactions =  DB::table('leaugestransactions as lt')
                            ->join('matchchallenges as mc', function ($join) {
                                $join->on('mc.id', '=', 'lt.challengeid')
                                    ->where('mc.status', '!=', 'canceled');
                            })
                            ->selectRaw('sum(lt.balance) as balance')
                            ->selectRaw('sum(lt.winning) as winning')
                            ->selectRaw('sum(lt.bonus) as bonus')
                            ->where('mc.matchkey', $result->matchkey)
                            ->where('mc.sport_type', $result->sport_type)
                            ->first();

                        if (!empty($leaugestransactions)) {
                            return $leaugestransactions->balance + $leaugestransactions->winning + $leaugestransactions->bonus;
                        } else {
                            return 0;
                        }
                    })

                    ->escapeColumns([])
                    ->make(true);
            } //end
        }

        return view("admin.$this->model.investedamount");
    } //End Function

    public function tds_report_new(Request $req)
    {
        $formData = Input::all();
        // $start_date = $req->start_date != "" ? $req->start_date : date("Y-m-01 00:00:00");
        // 	$end_date = $req->end_date != "" ? $req->end_date : date("Y-m-t 23:59:59");
        $start_date = $req->start_date != "" ? $req->start_date : "";
        $end_date = $req->end_date != "" ? $req->end_date : "";
        if (isset($formData) && !empty($formData)) {

            if (!empty($req->download_all_users_tds)) {
                $tdsData = DB::table('tds_new as tn')
                    ->join('registerusers as r_user', 'r_user.id', 'tn.user_id')
                    ->where('tn.status', 1)
                    ->orderBy('tn.id', 'DESC')
                    ->select('tn.*', 'r_user.username', 'r_user.email', 'r_user.mobile', 'r_user.state');
                if (!empty($start_date) && !empty($end_date) && !empty($request->download_all_users_tds)) {
                    $tdsData->where('tn.created_at', '>=', $start_date)
                        ->where('tn.created_at', '<=', $end_date);
                }
                if (!empty($start_date) && !empty($end_date) && empty($request->download_all_users_tds)) {
                    $tdsData->where('tn.created_at', '>=', $start_date)
                        ->where('tn.created_at', '<=', $end_date);
                }

                $tdsDetails = $tdsData->groupBY('tn.user_id')->get();

                if (count($tdsDetails) == 0) {
                    return Redirect::back()->withError("No data found");
                }
                ini_set('memory_limit', '-1');
                $fileName = 'TDS-all-Users-report-' . date("YmdHis", time());
                header('Content-Encoding: UTF-8');
                header("Content-type:application/vnd.ms-excel;charset=UTF-8");
                header('Content-Disposition: attachment;filename="' . $fileName . '.csv"');

                $tableheader = array(
                    'A' => 'Name',
                    'B' => 'Email',
                    'C' => 'Mobile',
                    'D' => 'Pan Number',
                    'E' => 'State',
                    'F' => 'Investment Amount',
                    //'F' => 'Withdrawal Amount',
                    'G' => 'Withdraw Amount',
                    'H' => 'TDS Amount',
                    //	'I' => 'TDS Deducted Amount',
                    'J' => 'Refund Amount',
                    'K' => 'TDS Deduction Date',
                );

                $fp = fopen('php://output', 'a');
                fputcsv($fp, $tableheader);
                $loopcount = ceil(count($tdsDetails) / 10000);

                for ($i = 0; $i < $loopcount; $i++) {
                    $query = $tdsDetails;
                    if (!$query->isEmpty()) {
                        foreach ($query as $key => $value) {
                            //	$tdsValu = ((($value->total_withdrawal)-($value->total_invested))*0.3);
                            $tdstotal = DB::table('tds_new')->where('user_id', $value->user_id)->where('status', 1)->sum('withdraw_amount');
                            $tdsAmount = DB::table('tds_new')->where('user_id', $value->user_id)->where('status', 1)->sum('tds_amount');
                            //	$tdsValu = ((($value->withdraw_amount)-($value->total_invested))*0.3);
                            //	$tdsAmount = number_format($tdstotal, 2, '.', '');
                            $panCard = DB::table('pancard')
                                ->where('pancard.userid', $value->user_id)
                                ->first();

                            $csv = [];
                            $csv['NAME'] = $value->username;
                            $csv['EMAIL'] = $value->email;
                            $csv['MOBILE'] = $value->mobile;
                            $csv['PAN NUMBER'] = @$panCard->pan_number;
                            $csv['STATE'] = @$value->state;
                            $csv['INVESTMENT AMOUNT'] = $value->total_invested;
                            //	$csv['WITHDRAWAL AMOUNT'] = $value->total_withdrawal;
                            $csv['WITHDRAWAL AMOUNT'] = @$tdstotal;
                            //	$csv['WITHDRAW AMOUNT'] = $value->withdraw_amount;
                            $csv['TDS AMOUNT'] = $tdsAmount;
                            //	$csv['TDS DEDUCTED AMOUNT'] = $value->tds_amount;
                            $csv['REFUND AMOUNT'] = (string)$value->tds_refund_amount;
                            $csv['TDS DEDUCTION DATE'] = date('Y-m-d h:i a', strtotime($value->created_at));

                            fputcsv($fp, $csv);
                        }
                    }
                    ob_flush();
                    flush();
                }
                ob_end_clean();
                exit();
            }
            $limit = 500;
            //echo '<pre>'; print_r($formData);exit;
            $usersList = DB::table('registerusers as ru')
                ->join('registerusers_session as rs', 'rs.user_id', '=', 'ru.id')
                ->join('tds_new', 'tds_new.user_id', '=', 'ru.id')
                ->select('rs.*', 'ru.username', 'ru.id as u_id', 'ru.email', 'ru.mobile', 'tds_new.user_id as tds_user_id', 'tds_new.created_at', 'ru.state')
                ->where('rs.session_year', '2023')
                ->groupBy('ru.id');
            if (!empty($req->user_id)) {
                $usersList->where('ru.id', $req->user_id);
            } else {
                $usersList->orderBy('tds_new.id', 'DESC');
            }
            if (isset($formData['filter_columns'])) {
                if (isset($formData['filter_columns']['filter_name'])) {
                    $usersList->where('ru.username', 'like', '%' . $formData['filter_columns']['filter_name'] . '%');
                }
                if (isset($formData['filter_columns']['filter_email'])) {
                    $usersList->where('ru.email', 'like', '%' . $formData['filter_columns']['filter_email'] . '%');
                }
                if (isset($formData['filter_columns']['filter_mobile'])) {
                    $usersList->where('ru.mobile', 'like', '%' . $formData['filter_columns']['filter_mobile'] . '%');
                }
            }
            if (!empty($start_date) && !empty($end_date)) {
                $limit = 50000;
                $usersList->where('tds_new.created_at', '>=', $start_date)
                    ->where('tds_new.created_at', '<=', $end_date);
            }
            $usersData = $usersList->limit($limit)->get();
            //	echo '<pre>'; print_r($usersData);exit;
            if (!empty($req->download)) {

                if (count($usersData) == 0) {
                    return Redirect::back()->withError("No data found");
                }
                ini_set('memory_limit', '-1');

                $fileName = 'TDS-report-' . date("YmdHis", time());
                header('Content-Encoding: UTF-8');
                header("Content-type:application/vnd.ms-excel;charset=UTF-8");
                header('Content-Disposition: attachment;filename="' . $fileName . '.csv"');


                $tableheader = array(
                    'A' => 'NAME',
                    'B' => 'EMAIL',
                    'C' => 'MOBILE',
                    'D' => 'PAN NUMBER',
                    'E' => 'STATE',
                    'F' => 'OPENING BALANCE',
                    'G' => 'DEPOSIT',
                    // 'H' => 'INVESTMENT',
                    'I' => 'WITHDRAW',
                    'J' => 'TDS',
                    'K' => 'REFUND TDS AMOUNT',
                );

                $fp = fopen('php://output', 'a');
                fputcsv($fp, $tableheader);
                $loopcount = ceil(count($usersData) / 10000);

                for ($i = 0; $i < $loopcount; $i++) {
                    $query = $usersData;
                    if (!$query->isEmpty()) {
                        foreach ($query as $key => $value) {
                            $panCard = DB::table('pancard')
                                ->where('pancard.userid', $value->u_id)
                                ->select('pan_number')->first();
                            $total_refund = DB::table('tds_new')->where('user_id', $value->tds_user_id)
                                ->where('created_at', '<=', date('Y-m-d H:i:s'))->sum('tds_refund_amount');

                            $tdstotal = DB::table('tds_new')->where('user_id', $value->user_id)->where('status', 1)->sum('withdraw_amount');
                            //	$tdsValu = ((($value->withdraw_amount)-($value->total_invested))*0.3);
                            $csv = [];
                            $csv['NAME'] = $value->username;
                            $csv['EMAIL'] = $value->email;
                            $csv['MOBILE'] = $value->mobile;
                            $csv['PAN NUMBER'] = @$panCard->pan_number;
                            $csv['STATE'] = @$value->state;
                            $csv['OPENING BALANCE'] = $value->opening_balance;
                            $csv['DEPOSIT'] = $value->total_deposit;
                            // $csv['INVESTMENT'] = $value->total_commission;
                            //	$csv['WITHDRAW'] = $value->total_withdraw;
                            $csv['WITHDRAW'] = $tdstotal;
                            $csv['TDS'] = $value->total_tds_dedcuted;
                            $csv['REFUND TDS AMOUNT'] = !empty($total_refund) ? $total_refund : 0;

                            fputcsv($fp, $csv);
                        }
                    }
                    ob_flush();
                    flush();
                }
                ob_end_clean();
                exit();
            }
            if ($req->ismethod('post')) {
                return Datatables::of($usersData)
                    ->addIndexColumn()
                    ->addColumn('name', function ($result) {
                        return $result->username;
                    })
                    ->addColumn('email', function ($result) {
                        return $result->email;
                    })
                    ->addColumn('mobile', function ($result) {
                        return $result->mobile;
                    })
                    ->addColumn('pan_number', function ($result) {
                        $panCard = DB::table('pancard')
                            ->where('pancard.userid', $result->u_id)
                            ->select('pan_number')->first();
                        return @$panCard->pan_number;
                    })
                    ->addColumn('state', function ($result) {
                        return @$result->state;
                    })
                    // ->addColumn('open_blnc',function ($result){
                    // 	return $result->opening_balance;
                    // })
                    ->addColumn('deposit', function ($result) {
                        return $result->total_deposit;
                    })
                    // ->addColumn('investment',function ($result){
                    // 	return $result->total_commission;
                    // })
                    ->addColumn('withdraw', function ($result) {
                        return $result->total_withdraw;
                    })
                    ->addColumn('tds', function ($result) {
                        return $result->total_tds_dedcuted;
                    })
                    ->addColumn('refund_tds', function ($result) {
                        $total_refund_tds = DB::table('tds_new')->where('user_id', $result->tds_user_id)
                            ->where('created_at', '<=', date('Y-m-d H:i:s'))->sum('tds_refund_amount');
                        return !empty($total_refund_tds) ? $total_refund_tds : 0;
                    })
                    ->addColumn('action', function ($result) {
                        return '<a href="' . url('admin/transaction-manager/user_tds_details', $result->u_id) . '" data-toggle="tooltip" title="Edit" class="btn btn-primary mr-1 mt-1">TDS Details</a>';
                    })
                    ->escapeColumns([])
                    ->make(true);
            } //end
        }

        $userslist = DB::table('registerusers as ru')
            ->join('registerusers_session as rs', 'rs.user_id', '=', 'ru.id')
            ->join('tds_new', 'tds_new.user_id', '=', 'ru.id')
            ->select('tds_new.*', 'rs.*', 'ru.username', 'ru.id as u_id')
            ->orderBy('ru.id', 'DESC')
            ->groupBy('ru.id')
            ->get();
        return view("admin.$this->model.tds_report_new", compact( 'userslist'));
    }

    public function userTdsDetail(Request $request, $userId = null)
    {
        $formData = Input::all();
        $start_date = $request->start_date != "" ? $request->start_date : date("Y-m-01 00:00:00");
        $end_date = $request->end_date != "" ? $request->end_date : date("Y-m-t 23:59:59");

        if (isset($formData) && !empty($formData)) {
            $tdsData = DB::table('tds_new as tn')
                ->join('registerusers as r_user', 'r_user.id', 'tn.user_id')
                ->orderBy('tn.id', 'DESC')
                ->select('tn.*', 'r_user.username', 'r_user.email', 'r_user.mobile');

            if (!empty($start_date) && !empty($end_date) && !empty($request->download)) {
                $tdsData->where('tn.created_at', '>=', $start_date)
                    ->where('tn.created_at', '<=', $end_date);
            }
            if (!empty($start_date) && !empty($end_date) && empty($request->download)) {
                $tdsData->where('tn.created_at', '>=', $start_date)
                    ->where('tn.created_at', '<=', $end_date)->where('tn.user_id', $userId);
            }

            $tdsDetails = $tdsData->get();

            if (!empty($request->download)) {

                if (count($tdsDetails) == 0) {
                    return Redirect::back()->withError("No data found");
                }
                ini_set('memory_limit', '-1');

                $fileName = 'TDS-report-' . date("YmdHis", time());
                header('Content-Encoding: UTF-8');
                header("Content-type:application/vnd.ms-excel;charset=UTF-8");
                header('Content-Disposition: attachment;filename="' . $fileName . '.csv"');


                $tableheader = array(
                    'A' => 'Name',
                    'B' => 'Email',
                    'C' => 'Mobile',
                    'D' => 'Pan Number',
                    'E' => 'Investment Amount',
                    'F' => 'Withdrawal Amount',
                    'G' => 'Withdraw Amount',
                    'H' => 'TDS Amount',
                    'I' => 'TDS Deducted Amount',
                    'J' => 'Refund Amount',
                    'K' => 'TDS Deduction Date',
                );

                $fp = fopen('php://output', 'a');
                fputcsv($fp, $tableheader);
                $loopcount = ceil(count($tdsDetails) / 10000);

                for ($i = 0; $i < $loopcount; $i++) {
                    $query = $tdsDetails;
                    if (!$query->isEmpty()) {
                        foreach ($query as $key => $value) {
                            $tdsValu = ((($value->total_withdrawal) - ($value->total_invested)) * 0.3);
                            $tdsAmount = number_format($tdsValu, 2, '.', '');
                            $panCard = DB::table('pancard')
                                ->where('pancard.userid', $value->user_id)
                                ->first()->pan_number;

                            $csv = [];
                            $csv['NAME'] = $value->username;
                            $csv['EMAIL'] = $value->email;
                            $csv['MOBILE'] = $value->mobile;
                            $csv['PAN NUMBER'] = $panCard;
                            $csv['INVESTMENT AMOUNT'] = $value->total_invested;
                            $csv['WITHDRAWAL AMOUNT'] = $value->total_withdrawal;
                            $csv['WITHDRAW AMOUNT'] = $value->withdraw_amount;
                            $csv['TDS AMOUNT'] = $tdsAmount;
                            $csv['TDS DEDUCTED AMOUNT'] = $value->tds_amount;
                            $csv['REFUND AMOUNT'] = $value->is_refunded;
                            $csv['TDS DEDUCTION DATE'] = date('Y-m-d h:i a', strtotime($value->created_at));

                            fputcsv($fp, $csv);
                        }
                    }
                    ob_flush();
                    flush();
                }
                ob_end_clean();
                exit();
            }
            if ($request->ismethod('post')) {

                return Datatables::of($tdsDetails)
                    ->addIndexColumn()
                    ->addColumn('invested_amt', function ($result) {
                        return $result->total_invested;
                    })
                    ->addColumn('withdrawal_amt', function ($result) {
                        return $result->total_withdrawal;
                    })
                    ->addColumn('withdraw_amt', function ($result) {
                        return $result->withdraw_amount;
                    })
                    ->addColumn('tds_amt', function ($result) {
                        $tdsValu = ((($result->total_withdrawal) - ($result->total_invested)) * 0.3);
                        $tdsAmount = number_format($tdsValu, 2, '.', '');
                        return $tdsAmount;
                    })
                    ->addColumn('tds_deduct_amt', function ($result) {
                        return $result->tds_amount;
                    })
                    ->addColumn('refund_amt', function ($result) {
                        return boolval($result->is_refunded);
                    })
                    ->addColumn('tds_deduct_date', function ($result) {
                        return date('Y-M-d', strtotime($result->created_at));
                    })
                    ->escapeColumns([])
                    ->make(true);
            }
        } //end
        return view("admin.$this->model.user_tds_details", compact('userId'));
    }
    //End Function

    /// xxxxxxxxxxxxxx PROMOTOR TDS Reports xxxxxxxxxxxxxxxxxx

    public function promotor_tds_report_new(Request $req)
    {
        $formData = Input::all();
        if (isset($formData) && !empty($formData)) {
            $usersList = DB::table('registerusers as ru')
                ->join('tds_refer_commission', 'tds_refer_commission.userid', '=', 'ru.id')
                ->where('tds_refer_commission.status', 1)
                ->select('ru.username', 'ru.id as u_id', 'ru.email', 'ru.mobile')
                ->groupBy('ru.id');
            if (!empty($req->user_id)) {
                $usersList->where('ru.id', $req->user_id);
            } else {
                $usersList->orderBy('ru.id', 'DESC');
            }
            if (isset($formData['filter_columns'])) {
                if (isset($formData['filter_columns']['filter_name'])) {
                    $usersList->where('ru.username', 'like', '%' . $formData['filter_columns']['filter_name'] . '%');
                }
                if (isset($formData['filter_columns']['filter_email'])) {
                    $usersList->where('ru.email', 'like', '%' . $formData['filter_columns']['filter_email'] . '%');
                }
                if (isset($formData['filter_columns']['filter_mobile'])) {
                    $usersList->where('ru.mobile', 'like', '%' . $formData['filter_columns']['filter_mobile'] . '%');
                }
            }
            $usersData = $usersList->get();
            // dd($usersData);
            if (!empty($req->download)) {

                if (count($usersData) == 0) {
                    return Redirect::back()->withError("No data found");
                }
                ini_set('memory_limit', '-1');

                $fileName = 'Promotor-TDS-report-' . date("YmdHis", time());
                header('Content-Encoding: UTF-8');
                header("Content-type:application/vnd.ms-excel;charset=UTF-8");
                header('Content-Disposition: attachment;filename="' . $fileName . '.csv"');


                $tableheader = array(
                    'A' => 'Name',
                    'B' => 'Email',
                    'C' => 'Mobile',
                    //	'D' => 'PAN',
                    'E' => 'TOTAL EARN COMMISSION',
                    'F' => 'DEDUCTED TDS AMOUNT',
                    'G' => 'NET COMMISSION',
                );

                $fp = fopen('php://output', 'a');
                fputcsv($fp, $tableheader);
                $loopcount = ceil(count($usersData) / 10000);

                for ($i = 0; $i < $loopcount; $i++) {
                    $query = $usersData;
                    if (!$query->isEmpty()) {
                        foreach ($query as $key => $value) {
                            // $panCard = DB::table('pancard')
                            // 		->where('pancard.userid',$value->u_id)
                            // 		->select('pan_number')->first();
                            $tdsRefer =    DB::table('tds_refer_commission')->where('userid', $value->u_id)
                                ->where('tds_refer_commission.status', 1)
                                ->sum('amount');
                            $tdsAmount =    DB::table('tds_refer_commission')->where('userid', $value->u_id)
                                ->where('tds_refer_commission.status', 1)->sum('tds_amount');
                            $tdsnet =    DB::table('tds_refer_commission')->where('userid', $value->u_id)->sum('net_commission_amount');
                            $csv = [];
                            $csv['NAME'] = $value->username;
                            $csv['EMAIL'] = $value->email;
                            $csv['MOBILE'] = $value->mobile;
                            //	$csv['PAN'] = $panCard->pan_number;
                            $csv['TOTAL EARN COMMISSION'] = $tdsRefer;
                            $csv['DEDUCTED TDS AMOUNT'] = $tdsAmount;
                            $csv['NET COMMISSION'] = $tdsnet;

                            fputcsv($fp, $csv);
                        }
                    }
                    ob_flush();
                    flush();
                }
                ob_end_clean();
                exit();
            }
            if ($req->ismethod('post')) {
                return Datatables::of($usersData)
                    ->addIndexColumn()
                    ->addColumn('name', function ($result) {
                        return $result->username;
                    })
                    ->addColumn('email', function ($result) {
                        return $result->email;
                    })
                    ->addColumn('mobile', function ($result) {
                        return $result->mobile;
                    })
                    // ->addColumn('pan_number',function ($result){
                    // 	$panCard = DB::table('pancard')
                    // 			->where('pancard.userid',$result->u_id)
                    // 			->select('pan_number')->first();
                    // 	return $panCard->pan_number;
                    // })
                    ->addColumn('total_earn_comsn', function ($result) {
                        $tdsRefer =    DB::table('tds_refer_commission')->where('userid', $result->u_id)
                            ->where('tds_refer_commission.status', 1)->sum('amount');
                        return $tdsRefer;
                    })
                    ->addColumn('deduct_tds_amount', function ($result) {
                        $tdsAmount =    DB::table('tds_refer_commission')->where('userid', $result->u_id)
                            ->where('tds_refer_commission.status', 1)->sum('tds_amount');
                        return $tdsAmount;
                    })
                    // ->addColumn('net_comsn',function ($result){
                    // 	$tdsnet =	DB :: table('tds_refer_commission')->where('userid',$result->u_id)->sum('net_commission_amount');
                    // 	return $tdsnet;
                    // })
                    ->addColumn('action', function ($result) {
                        return '<a href="' . url('admin/transaction-manager/promotor_tds_details', $result->u_id) . '" data-toggle="tooltip" title="Edit" class="btn btn-primary mr-1 mt-1">TDS Details</a>';
                    })
                    ->escapeColumns([])
                    ->make(true);
            } //end
        }

        // $userslist = DB::table('registerusers as ru')
        // ->join('tds_refer_commission','tds_refer_commission.userid','=','ru.id')
        // ->select('tds_refer_commission.*','ru.username','ru.id as u_id')
        // ->orderBy('ru.id', 'DESC')
        // ->groupBy('ru.id')
        // ->get();
        return view("admin.$this->model.promotor_tds_report_new");
    }

    public function promotorTdsDetail(Request $request, $userId = null)
    {
        $formData = Input::all();
        $start_date = $request->start_date != "" ? $request->start_date : date("Y-m-01 00:00:00");
        $end_date = $request->end_date != "" ? $request->end_date : date("Y-m-t 23:59:59");

        if (isset($formData) && !empty($formData)) {
            // dd($formData);
            $tdsData = DB::table('tds_refer_commission as tn')
                ->join('registerusers as r_user', 'r_user.id', 'tn.userid')
                //	->join('listmatches as lm','lm.matchkey', 'tn.matchkey')
                //		->join('sport_types as st','st.id','tn.sport_type')
                ->where('tn.userid', $userId)
                ->where('tn.status', 1)
                ->orderBy('tn.id', 'DESC')
                // ->select('tn.*','r_user.username', 'r_user.email', 'r_user.mobile','st.sport_name','lm.name as matchName','lm.start_date as match_start_date');
                ->select('tn.*', 'r_user.username', 'r_user.email', 'r_user.mobile');


            if (!empty($start_date) && !empty($end_date) && !empty($request->download)) {
                $tdsData->whereDate('tn.tds_date', '>=', $start_date)
                    ->whereDate('tn.tds_date', '<=', $end_date);
            }
            if (!empty($start_date) && !empty($end_date) && empty($request->download)) {

                $tdsData->whereDate('tn.tds_date', '>=', $start_date)
                    ->whereDate('tn.tds_date', '<=', $end_date)->where('tn.userid', $userId);
            }

            $tdsDetails = $tdsData->get();
            if (!empty($request->download)) {
                if (count($tdsDetails) == 0) {
                    return Redirect::back()->withError("No data found");
                }
                ini_set('memory_limit', '-1');
                $fileName = 'Promotor-TDS-details-' . date("YmdHis", time());
                header('Content-Encoding: UTF-8');
                header("Content-type:application/vnd.ms-excel;charset=UTF-8");
                header('Content-Disposition: attachment;filename="' . $fileName . '.csv"');

                $tableheader = array(
                    'A' => 'NAME',
                    'B' => 'EMAIL',
                    'C' => 'MOBILE',
                    'D' => 'PAN NUMBER',
                    //	'E' => 'SPORT TYPE',
                    //	'F' => 'MATCH NAME',
                    //	'G' => 'MATCH START DATE',
                    'H' => 'TOTAL EARN COMMISSION',
                    'I' => 'DEDUCTED TDS AMOUNT',
                    'J' => 'WITHDRAW AMOUNT',
                    'K' => 'TDS DATE',
                );

                $fp = fopen('php://output', 'a');
                fputcsv($fp, $tableheader);
                $loopcount = ceil(count($tdsDetails) / 10000);

                for ($i = 0; $i < $loopcount; $i++) {
                    $query = $tdsDetails;
                    if (!$query->isEmpty()) {
                        foreach ($query as $key => $value) {
                            $panCard = DB::table('pancard')
                                ->where('pancard.userid', $value->userid)
                                ->first()->pan_number;

                            $csv = [];
                            $csv['NAME'] = $value->username;
                            $csv['EMAIL'] = $value->email;
                            $csv['MOBILE'] = $value->mobile;
                            $csv['PAN NUMBER'] = $panCard;
                            //$csv['SPORT TYPE'] = $value->sport_name;
                            //	$csv['MATCH NAME'] = $value->matchName;
                            //	$csv['MATCH START DATE'] = $value->match_start_date;
                            $csv['TOTAL EARN COMMISSION'] = $value->amount;
                            $csv['DEDUCTED TDS AMOUNT'] = $value->tds_amount;
                            $csv['WITHDRAW AMOUNT'] = $value->amount - $value->tds_amount;
                            //	$csv['NET COMMISSION'] = $value->net_commission_amount;
                            $csv['TDS DATE'] = $value->tds_date;

                            fputcsv($fp, $csv);
                        }
                    }
                    ob_flush();
                    flush();
                }
                ob_end_clean();
                exit();
            }
            if ($request->ismethod('post')) {

                return Datatables::of($tdsDetails)
                    ->addIndexColumn()
                    // ->addColumn('sport_type',function ($result){
                    //  return $result->sport_name;
                    // })
                    // ->addColumn('match_name',function ($result){
                    //  return $result->matchName;
                    // })
                    // ->addColumn('match_date',function ($result){
                    //  return $result->match_start_date;
                    // })
                    ->addColumn('earn_comsn', function ($result) {
                        return $result->amount;
                    })
                    ->addColumn('deducted_tds_amount', function ($result) {
                        return $result->tds_amount;
                    })
                    ->addColumn('withdraw_amount', function ($result) {
                        return $result->amount - $result->tds_amount;
                    })
                    // ->addColumn('net_comsn',function ($result){
                    //  return $result->net_commission_amount;
                    // })
                    ->addColumn('tds_date', function ($result) {
                        return $result->tds_date;
                    })
                    ->escapeColumns([])
                    ->make(true);
            }
        } //end
        return view("admin.$this->model.promotor_tds_details", compact('userId'));
    }

    /// xxxxxxxxxxxxxx Winning TO Deposit xxxxxxxxxxxxxxxxxx

    public function winning_to_cash(Request $req)
    {

        $formData = Input::all();
        if (isset($formData) && !empty($formData)) {
            $usersList = DB::table('registerusers as ru')
                ->join('winning_commission', 'winning_commission.userid', '=', 'ru.id')
                ->where('winning_commission.status', 1)
                ->select('ru.username', 'ru.id as u_id', 'ru.email', 'ru.mobile')
                ->groupBy('ru.id');
            if (!empty($req->user_id)) {
                $usersList->where('ru.id', $req->user_id);
            } else {
                $usersList->orderBy('ru.id', 'DESC');
            }
            if (isset($formData['filter_columns'])) {
                if (isset($formData['filter_columns']['filter_name'])) {
                    $usersList->where('ru.username', 'like', '%' . $formData['filter_columns']['filter_name'] . '%');
                }
                if (isset($formData['filter_columns']['filter_email'])) {
                    $usersList->where('ru.email', 'like', '%' . $formData['filter_columns']['filter_email'] . '%');
                }
                if (isset($formData['filter_columns']['filter_mobile'])) {
                    $usersList->where('ru.mobile', 'like', '%' . $formData['filter_columns']['filter_mobile'] . '%');
                }
            }
            $usersData = $usersList->get();
            // dd($usersData);
            if (!empty($req->download)) {

                if (count($usersData) == 0) {
                    return Redirect::back()->withError("No data found");
                }
                ini_set('memory_limit', '-1');

                $fileName = 'WINNING_TO-CASH-report-' . date("YmdHis", time());
                header('Content-Encoding: UTF-8');
                header("Content-type:application/vnd.ms-excel;charset=UTF-8");
                header('Content-Disposition: attachment;filename="' . $fileName . '.csv"');


                $tableheader = array(
                    'A' => 'Name',
                    'B' => 'Email',
                    'C' => 'Mobile',
                    //	'D' => 'PAN',
                    'E' => 'TOTAL AMOUNT',
                    'F' => 'COMMISSION',
                    //	'G' => 'DATE',
                );

                $fp = fopen('php://output', 'a');
                fputcsv($fp, $tableheader);
                $loopcount = ceil(count($usersData) / 10000);

                for ($i = 0; $i < $loopcount; $i++) {
                    $query = $usersData;
                    if (!$query->isEmpty()) {
                        foreach ($query as $key => $value) {
                            // $panCard = DB::table('pancard')
                            // 		->where('pancard.userid',$value->u_id)
                            // 		->select('pan_number')->first();
                            $tdsRefer =    DB::table('winning_commission')->where('userid', $value->u_id)
                                ->where('winning_commission.status', 1)
                                ->sum('amount');
                            $tdsAmount =    DB::table('winning_commission')->where('userid', $value->u_id)
                                ->where('winning_commission.status', 1)->sum('commission');
                            $tdsnet =    DB::table('winning_commission')->where('userid', $value->u_id)->sum('commission');
                            $csv = [];
                            $csv['NAME'] = $value->username;
                            $csv['EMAIL'] = $value->email;
                            $csv['MOBILE'] = $value->mobile;
                            //	$csv['PAN'] = $panCard->pan_number;
                            $csv['TOTAL AMOUNT'] = $tdsRefer;
                            $csv['COMMISSION'] = $tdsAmount;
                            //	$csv['DATE'] = $tdsnet;

                            fputcsv($fp, $csv);
                        }
                    }
                    ob_flush();
                    flush();
                }
                ob_end_clean();
                exit();
            }

            if ($req->ismethod('post')) {
                return Datatables::of($usersData)
                    ->addIndexColumn()
                    ->addColumn('name', function ($result) {
                        return $result->username;
                    })
                    ->addColumn('email', function ($result) {
                        return $result->email;
                    })
                    ->addColumn('mobile', function ($result) {
                        return $result->mobile;
                    })
                    ->addColumn('total_earn_comsn', function ($result) {
                        $tdsRefer =    DB::table('winning_commission')->where('userid', $result->u_id)
                            ->where('winning_commission.status', 1)->sum('amount');
                        return $tdsRefer;
                    })
                    ->addColumn('deduct_tds_amount', function ($result) {
                        $tdsAmount =    DB::table('winning_commission')->where('userid', $result->u_id)
                            ->where('winning_commission.status', 1)->sum('commission');
                        return $tdsAmount;
                    })
                    ->addColumn('action', function ($result) {
                        return '<a href="' . url('admin/transaction-manager/winning_to_cash_details', $result->u_id) . '" data-toggle="tooltip" title="Edit" class="btn btn-primary mr-1 mt-1">Commossion Details</a>';
                    })
                    ->escapeColumns([])
                    ->make(true);
            } //end
        }

        return view("admin.$this->model.winning_to_cash_report_new", compact( 'totalrrealcash'));
    }
    public function winning_to_cash_details(Request $request, $userId = null)
    {
        date_default_timezone_set("Asia/Kolkata");
        $formData = Input::all();
        $start_date = $request->start_date != "" ? $request->start_date : date("Y-m-01 00:00:00");
        $end_date = $request->end_date != "" ? $request->end_date : date("Y-m-t 23:59:59");

        if (isset($formData) && !empty($formData)) {
            // dd($formData);
            $tdsData = DB::table('winning_commission as tn')
                ->join('registerusers as r_user', 'r_user.id', 'tn.userid')
                ->where('tn.userid', $userId)
                ->where('tn.status', 1)
                ->orderBy('tn.id', 'DESC')
                ->select('tn.*', 'r_user.username', 'r_user.email', 'r_user.mobile');
            if (!empty($start_date) && !empty($end_date) && !empty($request->download)) {
                $tdsData->whereDate('tn.date', '>=', $start_date)
                    ->whereDate('tn.date', '<=', $end_date);
            }
            if (!empty($start_date) && !empty($end_date) && empty($request->download)) {

                $tdsData->where('tn.date', '>=', $start_date)
                    ->where('tn.date', '<=', $end_date)->where('tn.userid', $userId);
            }

            $tdsDetails = $tdsData->get();
            if (!empty($request->download)) {
                if (count($tdsDetails) == 0) {
                    return Redirect::back()->withError("No data found");
                }
                ini_set('memory_limit', '-1');
                $fileName = 'Winning-to-cash-details-' . date("YmdHis", time());
                header('Content-Encoding: UTF-8');
                header("Content-type:application/vnd.ms-excel;charset=UTF-8");
                header('Content-Disposition: attachment;filename="' . $fileName . '.csv"');

                $tableheader = array(
                    'A' => 'NAME',
                    'B' => 'EMAIL',
                    'C' => 'MOBILE',
                    'D' => 'PAN NUMBER',
                    'H' => 'TOTAL AMOUNT',
                    'I' => 'COMMISSION',
                    'K' => 'COMMISSION DATE',
                );

                $fp = fopen('php://output', 'a');
                fputcsv($fp, $tableheader);
                $loopcount = ceil(count($tdsDetails) / 10000);

                for ($i = 0; $i < $loopcount; $i++) {
                    $query = $tdsDetails;
                    if (!$query->isEmpty()) {
                        foreach ($query as $key => $value) {
                            $panCard = DB::table('pancard')
                                ->where('pancard.userid', $value->userid)
                                ->first()->pan_number;

                            $csv = [];
                            $csv['NAME'] = $value->username;
                            $csv['EMAIL'] = $value->email;
                            $csv['MOBILE'] = $value->mobile;
                            $csv['PAN NUMBER'] = $panCard;
                            $csv['TOTAL AMOUNT'] = $value->amount;
                            $csv['COMMISSION'] = $value->commission;
                            $csv['COMMISSION DATE'] = $value->date;

                            fputcsv($fp, $csv);
                        }
                    }
                    ob_flush();
                    flush();
                }
                ob_end_clean();
                exit();
            }
            if ($request->ismethod('post')) {

                return Datatables::of($tdsDetails)
                    ->addIndexColumn()
                    ->addColumn('earn_comsn', function ($result) {
                        return $result->amount;
                    })
                    ->addColumn('deducted_tds_amount', function ($result) {
                        return $result->commission;
                    })
                    ->addColumn('tds_date', function ($result) {
                        return $result->date;
                    })
                    ->escapeColumns([])
                    ->make(true);
            }
        } //end
        return view("admin.$this->model.winning_to_cash_details", compact('userId'));
    }

    public function tds_report_promoter(Request $req)
    {
        $formData = Input::all();
        // $start_date = $req->start_date != "" ? $req->start_date : date("Y-m-01 00:00:00");
        // 	$end_date = $req->end_date != "" ? $req->end_date : date("Y-m-t 23:59:59");
        $start_date = $req->start_date != "" ? $req->start_date : "";
        $end_date = $req->end_date != "" ? $req->end_date : "";
        if (isset($formData) && !empty($formData)) {

            if (!empty($req->download_all_users_tds)) {
                $tdsData = DB::table('tds_refer_commission as tn')
                    ->join('registerusers as r_user', 'r_user.id', 'tn.userid')
                    ->where('tn.status', 1)
                    ->orderBy('tn.id', 'DESC')
                    ->select('tn.*', 'r_user.username', 'r_user.team', 'r_user.mobile', 'r_user.state');
                if (!empty($start_date) && !empty($end_date) && !empty($request->download_all_users_tds)) {
                    $tdsData->where('tn.created_at', '>=', $start_date)
                        ->where('tn.created_at', '<=', $end_date);
                }
                if (!empty($start_date) && !empty($end_date) && empty($request->download_all_users_tds)) {
                    $tdsData->where('tn.created_at', '>=', $start_date)
                        ->where('tn.created_at', '<=', $end_date);
                }

                $tdsDetails = $tdsData->groupBY('tn.userid')->get();


                if (count($tdsDetails) == 0) {
                    return Redirect::back()->withError("No data found");
                }
                ini_set('memory_limit', '-1');
                $fileName = 'TDS-all-Users-reportpromoter-' . date("YmdHis", time());
                header('Content-Encoding: UTF-8');
                header("Content-type:application/vnd.ms-excel;charset=UTF-8");
                header('Content-Disposition: attachment;filename="' . $fileName . '.csv"');

                $tableheader = array(
                    'A' => 'Name',
                    'B' => 'Team Name',
                    'C' => 'Mobile',
                    'D' => 'Pan',
                    'E' => 'State',
                    'F' => 'Affliate Commission',
                    'G' => ' Withdraw',
                    'H' => 'TDS',
                    'I' => 'Refunded TDS Amount',
                );

                $fp = fopen('php://output', 'a');
                fputcsv($fp, $tableheader);
                $loopcount = ceil(count($tdsDetails) / 10000);

                for ($i = 0; $i < $loopcount; $i++) {
                    $query = $tdsDetails;
                    if (!$query->isEmpty()) {
                        foreach ($query as $key => $value) {
                            $query = DB::table('tds_refer_commission')->where('userid', $value->userid)->where('status', 1);
                            if (!empty($start_date) && !empty($end_date)) {
                                $query->where('created_at', '>=', $start_date)
                                    ->where('created_at', '<=', $end_date);
                            }
                            $tdstotal = $query->sum('tds_amount');

                            $query = DB::table('tds_refer_commission')->where('userid', $value->userid)->where('status', 1);
                            if (!empty($start_date) && !empty($end_date)) {
                                $query->where('created_at', '>=', $start_date)
                                    ->where('created_at', '<=', $end_date);
                            }
                            $totalwithdraw = $query->sum('amount');

                            $panCard = DB::table('pancard')
                                ->where('pancard.userid', $value->userid)
                                ->first();

                            $query    = DB::table('tds_refer_commission')->where('userid', $value->userid);
                            if (!empty($start_date) && !empty($end_date)) {
                                $query->where('tds_refer_commission.created_at', '>=', $start_date)
                                    ->where('tds_refer_commission.created_at', '<=', $end_date);
                            }
                            $affiliatetotal =    $query->sum('net_commission_amount');

                            $csv = [];
                            $csv['NAME'] = $value->username;
                            $csv['TEAM NAME'] = $value->team;
                            $csv['MOBILE'] = $value->mobile;
                            $csv['PAN'] = @$panCard->pan_number;
                            $csv['STATE'] = @$value->state;
                            $csv['Affliate Commission'] = $affiliatetotal;
                            $csv['Withdraw'] = $totalwithdraw;
                            $csv['TDS'] = $tdstotal;
                            $csv['Refunded TDS Amount'] = '0';
                            fputcsv($fp, $csv);
                        }
                    }
                    ob_flush();
                    flush();
                }
                ob_end_clean();
                exit();
            }
            $limit = 1000;
            //echo '<pre>'; print_r($formData);exit;
            $usersList = DB::table('registerusers as ru')
                //->join('registerusers_session as rs','rs.user_id','=','ru.id')
                ->join('tds_refer_commission', 'tds_refer_commission.userid', '=', 'ru.id')
                ->select('ru.username', 'ru.id as u_id', 'ru.team', 'ru.mobile', 'tds_refer_commission.userid as tds_user_id', 'ru.state')
                ->groupBy('tds_refer_commission.userid');
            if (!empty($req->user_id)) {
                $usersList->where('ru.id', $req->user_id);
            } else {
                $usersList->orderBy('tds_refer_commission.id', 'DESC');
            }
            if (isset($formData['filter_columns'])) {
                if (isset($formData['filter_columns']['filter_name'])) {
                    $usersList->where('ru.username', 'like', '%' . $formData['filter_columns']['filter_name'] . '%');
                }
                if (isset($formData['filter_columns']['filter_email'])) {
                    $usersList->where('ru.team', 'like', '%' . $formData['filter_columns']['filter_email'] . '%');
                }
                if (isset($formData['filter_columns']['filter_mobile'])) {
                    $usersList->where('ru.mobile', 'like', '%' . $formData['filter_columns']['filter_mobile'] . '%');
                }
            }
            if (!empty($start_date) && !empty($end_date)) {
                $limit = 50000;
                $usersList->where('tds_refer_commission.created_at', '>=', $start_date)
                    ->where('tds_refer_commission.created_at', '<=', $end_date);
            }
            $usersData = $usersList->limit($limit)->get();
            //echo '<pre>'; print_r($req->all());exit;
            if (!empty($req->download)) {

                if (count($usersData) == 0) {
                    return Redirect::back()->withError("No data found");
                }
                ini_set('memory_limit', '-1');


                $fileName = 'TDS-report-promoter-' . date("YmdHis", time());
                header('Content-Encoding: UTF-8');
                header("Content-type:application/vnd.ms-excel;charset=UTF-8");
                header('Content-Disposition: attachment;filename="' . $fileName . '.csv"');

                $tableheader = array(
                    'A' => 'NAME',
                    'B' => 'TEAM NAME',
                    'C' => 'MOBILE',
                    'D' => 'PAN',
                    'E' => 'STATE',
                    'F' => 'AFFILIATE COMMISSION',
                    'G' => 'WITHDRAW',
                    'H' => 'TDS',
                    'I' => 'Refunded TDS AMOUNT',
                );

                $fp = fopen('php://output', 'a');
                fputcsv($fp, $tableheader);
                $loopcount = ceil(count($usersData) / 10000);

                for ($i = 0; $i < $loopcount; $i++) {
                    $query = $usersData;
                    if (!$query->isEmpty()) {
                        foreach ($query as $key => $value) {
                            $panCard = DB::table('pancard')
                                ->where('pancard.userid', $value->tds_user_id)
                                ->select('pan_number')->first();
                            $query = DB::table('tds_refer_commission')->where('userid', $value->tds_user_id)->where('status', 1);
                            if (!empty($start_date) && !empty($end_date)) {
                                $query->where('tds_refer_commission.created_at', '>=', $start_date)
                                    ->where('tds_refer_commission.created_at', '<=', $end_date);
                            }
                            $totalwithdraw =    $query->sum('amount');

                            $query = DB::table('tds_refer_commission')->where('userid', $value->tds_user_id)->where('status', 1);
                            if (!empty($start_date) && !empty($end_date)) {
                                $query->where('tds_refer_commission.created_at', '>=', $start_date)
                                    ->where('tds_refer_commission.created_at', '<=', $end_date);
                            }
                            $total_tds = $query->sum('tds_amount');

                            $query    = DB::table('tds_refer_commission')->where('userid', $value->tds_user_id);
                            if (!empty($start_date) && !empty($end_date)) {
                                $query->where('tds_refer_commission.created_at', '>=', $start_date)
                                    ->where('tds_refer_commission.created_at', '<=', $end_date);
                            }
                            $affiliatetotal =    $query->sum('net_commission_amount');

                            $csv = [];
                            $csv['Name'] = $value->username;
                            $csv['Team Name'] = $value->team;
                            $csv['Mobile'] = $value->mobile;
                            $csv['PAN'] = @$panCard->pan_number;
                            $csv['STATE'] = @$value->state;
                            $csv['AFFILIATE COMMISSION'] = $affiliatetotal;
                            $csv['WITHDRAW'] = $totalwithdraw;
                            $csv['TDS'] = $total_tds;
                            $csv['Refunded TDS Amount'] = '0';
                            fputcsv($fp, $csv);
                        }
                    }
                    ob_flush();
                    flush();
                }
                ob_end_clean();
                exit();
            }

            if ($req->ismethod('post')) {

                return Datatables::of($usersData)
                    ->addIndexColumn()
                    ->addColumn('name', function ($result) {
                        return $result->username;
                    })
                    // ->addColumn('email',function ($result){
                    // 	return $result->email;
                    // })
                    ->addColumn('team', function ($result) {
                        return $result->team;
                    })
                    ->addColumn('mobile', function ($result) {
                        return $result->mobile;
                    })
                    ->addColumn('pan_number', function ($result) {
                        $panCard = DB::table('pancard')
                            ->where('pancard.userid', $result->u_id)
                            ->select('pan_number')->first();
                        return @$panCard->pan_number;
                    })
                    ->addColumn('state', function ($result) {
                        return @$result->state;
                    })
                    ->addColumn('affiliate', function ($result) use ($start_date, $end_date) {
                        $query    = DB::table('tds_refer_commission')->where('userid', $result->tds_user_id);
                        if (!empty($start_date) && !empty($end_date)) {
                            $query->where('tds_refer_commission.created_at', '>=', $start_date)
                                ->where('tds_refer_commission.created_at', '<=', $end_date);
                        }
                        $affiliatetotal =    $query->sum('net_commission_amount');

                        return $affiliatetotal;
                    })
                    ->addColumn('withdraw', function ($result) use ($start_date, $end_date) {
                        $query    = DB::table('tds_refer_commission')->where('userid', $result->tds_user_id);
                        if (!empty($start_date) && !empty($end_date)) {
                            $query->where('tds_refer_commission.created_at', '>=', $start_date)
                                ->where('tds_refer_commission.created_at', '<=', $end_date);
                        }
                        $tdstotalwithdraw =    $query->sum('amount');
                        return $tdstotalwithdraw;
                    })
                    ->addColumn('tds', function ($result) use ($start_date, $end_date) {
                        $query = DB::table('tds_refer_commission')->where('userid', $result->tds_user_id);
                        if (!empty($start_date) && !empty($end_date)) {
                            $query->where('tds_refer_commission.created_at', '>=', $start_date)
                                ->where('tds_refer_commission.created_at', '<=', $end_date);
                        }

                        $tdstotal = $query->sum('tds_amount');
                        return $tdstotal;
                    })
                    ->addColumn('tdsrefund', function ($result) use ($start_date, $end_date) {
                        return '0';
                    })

                    ->escapeColumns([])
                    ->make(true);
            } //end
        }
        $userslist = DB::table('registerusers as ru')
            ->join('pancard', 'pancard.userid', '=', 'ru.id')
            ->join('tds_refer_commission', 'tds_refer_commission.userid', '=', 'ru.id')
            ->select(DB::raw("SUM(amount) as  withdraw"), DB::raw("SUM(tds_amount) as tds"), 'ru.username', 'ru.id as u_id')->where('tds_refer_commission.status', 1)
            //	->orderBy('ru.id', 'DESC')
            ->groupBy('tds_refer_commission.userid')
            ->get();
        return view("admin.$this->model.tds_report_promoter", compact('userslist'));
    }
} //End Class
