<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Http\Requests;
use Illuminate\Http\Request;
use App\Model\Yoububer;
use App\libraries\CustomHelper;
use App\Helpers\Helpers;
use App\Services\Input;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\View;
use Yajra\DataTables\Facades\DataTables;

date_default_timezone_set('Asia/Kolkata');
class YoububerController extends Controller
{

    /*
	 * Function for display email detail from database
	 *
	 * @param null
	 *
	 * @return view page.
	 */
    public $model = 'Yoububer';

    public function __construct()
    {
        View::share('modelName', $this->model);
    } //End Function

    //View Register users
    public function view()
    {
        //Get Ajax Data
        $formData = Input::all();
        if (isset($formData) && !empty($formData)) {
            $where_condition = '';
            $where_operation = '';
            $where_value = '';
            if ($formData['users_type'] == 'active') {
                $where_condition = "r.activation_status";
                $where_operation = "=";
                $where_value = "activated";
            } elseif ($formData['users_type'] == 'deactive') {
                $where_condition = "r.activation_status";
                $where_operation = "=";
                $where_value = "deactivated";
            } else {
                $where_condition = "r.email";
                $where_operation = "!=";
                $where_value = "";
            }

            return Datatables::of(DB::table('registerusers as r')
                ->leftJoin('userbalances as ub', 'ub.user_id', '=', 'r.id')
                // ->leftJoin('withdraw as w','w.user_id','=','r.id')
                // ->leftJoin('transactions as t','t.userid','=','r.id')
                // ->leftJoin('joinedleauges as jl','jl.userid','=','r.id')
                // ->leftJoin('jointeam as jt','jt.userid','=','r.id')
                ->limit(1000)
                ->groupBy('r.id')

                // ->select('r.*','ub.id as userbalances_id','ub.balance','ub.winning','ub.bonus','w.id  as withdraw_id','jl.id as joinedleauges_id','jt.id as jointeam_id')
                ->select('r.*', 'ub.id as userbalances_id', 'ub.balance', 'ub.winning', 'ub.bonus')
                ->where([['r.is_yoububer', '=', '1'], [$where_condition, $where_operation, $where_value]])
                ->orderBy('id', 'DESC')
                ->get())
                ->addIndexColumn()
                /*->addColumn('mobile_verify',function ($result){
	           	 	$mobileverify='';
	              	if($result->mobile_verify == 0){
						$mobileverify= '<td><span class="badge badge-danger"><i class="fa fa-times-circle-o"></i></span></td>';
					}elseif($result->mobile_verify==1){
						$mobileverify= '<td><span class="badge badge-success"><i class="fa fa-check-circle-o"></i></span></td>';
					}
              		return $mobileverify;
	           })
	           ->addColumn('email_verify',function ($result){
	           	 	$emailverify='';
	              	if($result->email_verify ==0){
						$emailverify= '<td><span class="badge badge-danger"><i class="fa fa-times-circle-o"></i></span></td>';
					}elseif($result->email_verify ==1){
						$emailverify= '<td><span class="badge badge-success"><i class="fa fa-check-circle-o"></i></span></td>';
					}
              		return $emailverify;
	           })
	           ->addColumn('pan_verify',function ($result){
	           	 	$panverify='';
	              	if($result->pan_verify==0){
						$panverify= '<td><span class="badge badge-danger"><i class="fa fa-times-circle-o"></i>Under Review</span></td>';
					}elseif($result->pan_verify == 1 ){
						$panverify= '<td><span class="badge badge-success"><i class="fa fa-check-circle-o"></i></span></td>';
					}elseif($result->pan_verify == -1 ){
						$panverify= '<td><span class="badge badge-primary"><i class="fa fa-times-circle-o"></i> Not Requested</span></td>';
					}
              		return $panverify;
	           })
	           ->addColumn('bank_verify',function ( $result){
	           	 	$bankverify='';
	              	if($result->bank_verify==0){
						$bankverify= '<td><span class="badge badge-danger"><i class="fa fa-times-circle-o"></i>Under Review</span></td>';
					}elseif($result->bank_verify == 1 ){
						$bankverify= '<td><span class="badge badge-success"><i class="fa fa-check-circle-o"></i>Verified</span></td>';
					}elseif($result->bank_verify == -1 ){
						$bankverify= '<td><span class="badge badge-primary"><i class="fa fa-times-circle-o"></i>Not Requested</span></td>';
					}
              		return $bankverify;
	           })*/
                ->addColumn('balance', function ($result) {
                    if (isset($result->userbalances_id) && !empty($result->userbalances_id)) {
                        return '₹ ' . $result->balance;
                    } else {
                        return '₹ 0';
                    }
                })
                ->addColumn('refercode', function ($result) {
                    if (isset($result->refercode) && !empty($result->refercode)) {
                        return $result->refercode;
                    } else {
                        return '';
                    }
                })
                ->addColumn('winning', function ($result) {
                    if (isset($result->userbalances_id) && !empty($result->userbalances_id)) {
                        return '₹ ' . $result->winning;
                    } else {
                        return '₹ 0';
                    }
                })
                ->addColumn('bonus', function ($result) {
                    if (isset($result->userbalances_id) && !empty($result->userbalances_id)) {
                        return '₹ ' . $result->bonus;
                    } else {
                        return '₹ 0';
                    }
                })
                ->addColumn('refer_id', function ($result) {
                    $total_refered_users = DB::table('registerusers')->where('refer_id', $result->id)->count();
                    return !empty($total_refered_users) ? $total_refered_users : 0;
                })
                ->addColumn('youtuber_commission_type', function ($result) {
                    $youtuber_commission_type = '';
                    if ($result->youtuber_commission_type == 0) {
                        $youtuber_commission_type = '<td><span class="badge badge-danger">Revenue Amount</span></td>';
                    } elseif ($result->youtuber_commission_type == 1) {
                        $youtuber_commission_type = '<td><span class="badge badge-success">Flat Amount</span></td>';
                    }
                    return $youtuber_commission_type;
                })
                ->addColumn('action', function ($result) {
                    //Change Status
                    $activation_status = '';
                    if (strtolower($result->activation_status) != 'activated') {
                        $activation_status = '<a href="' . route('Registerusers.update_user_status', [base64_encode(serialize($result->id)), 'activated']) . '" data-toggle="tooltip" title="Activate" class="btn btn-success mr-1 mt-1 action-users"><i class="fa fa-check-square-o" aria-hidden="true"></i></a>';
                    } else {
                        $activation_status = '<a href="' . route('Registerusers.update_user_status', [base64_encode(serialize($result->id)), 'deactivated']) . '" data-toggle="tooltip" title="Deactivate" class="btn btn-danger mr-1 mt-1 action-users"><i class="fa fa-ban"></i></a>';
                    }

                    //youtuber users not show in all registerusrs
                    $is_youtuber = '<a href="' . route('Registerusers.update_refer_join', [base64_encode(serialize($result->id)), '0']) . '" data-toggle="tooltip" title="Convert to User" class="btn btn-info mr-1 mt-1"><i class="fa fa-retweet"></i></a>';

                    //Withdraw
                    // if(isset($result->withdraw_id) && !empty($result->withdraw_id)){
                        $withdraw_link = '<a href="' . route('Registerusers.withdraw_detail', base64_encode(serialize($result->id))) . '" data-toggle="tooltip" title="Withdraw Amount" class="btn btn-warning mr-1 mt-1" data-original-title="withdraw Amount"><i class="fa fa-inr p-1" aria-hidden="true"></i></a>';


                    // if(isset($result->transactions_id) && !empty($result->transactions_id)){
                        $transactions_link = '<a href="' . route('Registerusers.add_cash_list', base64_encode(serialize($result->id))) . '" class="btn btn-dark mr-1 mt-1" data-toggle="tooltip" title="Add Cash Summary" ><i class="fa fa-plus" aria-hidden="true"></i></a>';


                    //Show Joined Leauges
                    // if(isset($result->joinedleauges_id) && !empty($result->joinedleauges_id)){
                        $joinedleauges_link = '<a href="' . route('Registerusers.join_leauges', base64_encode(serialize($result->id))) . '" data-toggle="tooltip" title="Joined Leauges" class="btn btn-dark mr-1 mt-1"><i class="fa fa-trophy"></i></a>';

                    //Join team Link jointeam_id
                    // if(isset($result->jointeam_id) && !empty($result->jointeam_id)){
                        $jointeam_link = '<a href="' . route('Registerusers.user_team', base64_encode(serialize($result->id))) . '" data-toggle="tooltip" title="User Team" class="btn btn-dark mr-1 mt-1"><i class="fa fa-user-plus" aria-hidden="true"></i></a>';

                    return '<a href="' . route('Registerusers.transactions', base64_encode(serialize($result->id))) . '" data-toggle="tooltip" title="Transactions" class="btn btn-primary mr-1 mt-1" data-original-title="User Transactions"><i class="fa fa-exchange" aria-hidden="true"></i></a>'
                        . '<a href="' . route($this->model . '.edit', base64_encode(serialize($result->id))) . '" data-toggle="tooltip" title="Edit" class="btn btn-dark mr-1 mt-1"><i class="fa fa-pencil" aria-hidden="true" data-toggle="tooltip" title="" data-original-title="Edit" ></i></a>'
                        . $withdraw_link
                        . $transactions_link
                        . $activation_status
                        . $is_youtuber
                        . $joinedleauges_link
                        . $jointeam_link
                        //.'<a href="javascript:void(0);" class="btn btn-primary submitper mr-1 mt-1"  data-toggle="modal" data-id="'.$result->id.'" data-status="0">Set %</a></br>'
                    ;
                })
                ->escapeColumns([])
                ->make(true);
        } //end

        return view("admin.$this->model.view");
    } //End if


    public function promoter_reporting_dd(Request $request)
    {
        if ($request->isMethod('post')) {
            $formData = Input::all();
            $columns = array(
                0 => 'id',
                1 => 'username',
                2 => 'email',
                3 => 'mobile',
                4 => 'refercode',
                5 => 'refercount',
                6 => 'earn',
                7 => 'deposit',
                8 => 'invest',
            );
            $limit  = $request->input('length');
            $start  = $request->input('start');
            $order  = $columns[$request->input('order.0.column')];
            $dir    = $request->input('order.0.dir');

            $formData = Input::all();
            $query = DB::table('registerusers as r')
                ->where('r.is_yoububer', '=', '1')
                ->where(function ($query) use ($formData) {
                    if (isset($formData['email']))
                        $query->where('r.email', $formData['email']);
                    if (isset($formData['mobile']))
                        $query->where('r.mobile', $formData['mobile']);
                    if (isset($formData['team']))
                        $query->where('r.team', $formData['team']);
                });
            $query->orderBy('id', 'DESC');
            $totalTitles = $query->count();
            $totalFiltered = $totalTitles;


            $titles = $query->select('r.username', 'r.email', 'r.mobile', 'r.id', 'r.refercode')
                ->offset($start)->limit($limit)->get();

            if (!empty($titles)) {
                $data = array();
                $count = 1;
                foreach ($titles as $title) {
                    $query1 = DB::table('registerusers')->where('refer_id', $title->id);
                    if (!empty(@$formData['start_date']) && !empty($formData['end_date'])) {
                        $query1->whereBetween('registerusers.created_at', [$formData['start_date'], $formData['end_date']]);
                    }
                    $refercount = $query1->count('id');

                    $queryleageu = DB::table('league_refer_bonus')->where('refer_id', $title->id);
                    if (!empty(@$formData['start_date']) && !empty($formData['end_date'])) {
                        $queryleageu->whereBetween('league_refer_bonus.created', [$formData['start_date'], $formData['end_date']]);
                    }
                    $queryleageucount =    $queryleageu->sum('amount');


                    $queryt = DB::table('transactions')->join('registerusers', 'registerusers.id', '=', 'transactions.userid')->where('registerusers.refer_id', $title->id)->where('type', '=', 'add fund')->where('paymentstatus', '=', 'confirmed');
                    if (!empty(@$formData['start_date']) && !empty($formData['end_date'])) {
                        $queryt->whereBetween('transactions.created', [$formData['start_date'], $formData['end_date']]);
                    }
                    $totaldeposit = $queryt->sum('amount');


                    $queryinvit =    DB::table('registerusers')
                        ->join('leaugestransactions', 'registerusers.id', '=', 'leaugestransactions.user_id')
                        ->join('matchchallenges', 'leaugestransactions.challengeid', '=', 'matchchallenges.id')
                        ->where('matchchallenges.status', '!=', 'canceled')
                        ->where('registerusers.refer_id', $title->id);
                    if (!empty(@$formData['start_date']) && !empty($formData['end_date'])) {
                        $query->whereBetween('leaugestransactions.created_at', [$formData['start_date'], $formData['end_date']]);
                    }
                    $total_joinlegue = $queryinvit->select(DB::raw("SUM(leaugestransactions.winning+leaugestransactions.balance) as total_amount"))
                        ->first();

                    $nestedData['s_no'] = $count;
                    $nestedData['username'] = $title->username;
                    $nestedData['email'] = $title->email;
                    $nestedData['mobile'] = $title->mobile;
                    $nestedData['refercode'] = $title->refercode;
                    $nestedData['refercount'] = @$refercount;
                    $nestedData['earn'] = @$queryleageucount;
                    $nestedData['deposit'] = @$totaldeposit;
                    $nestedData['invest'] = @$total_joinlegue->total_amount;
                    $nestedData['action'] = '';
                    $data[] = $nestedData;
                    $count++;
                }
            }
            $json_data = array(
                "draw" => intval($request->input('draw')),
                "recordsTotal" => intval($totalTitles),
                "recordsFiltered" => intval($totalFiltered),
                "data" => $data,
            );

            echo json_encode($json_data);
            exit;
        }


        return view("admin.$this->model.report");
    }
    public function promoter_reporting(Request $request)
    {
        //Get Ajax Data
        if ($request->isMethod('post')) {
            $formData = Input::all();
            $limit  = $request->input('length');
            $start  = $request->input('start');

            if (isset($formData) && !empty($formData)) {
                $where_condition = '';
                $where_operation = '';
                $where_value = '';
                if ($formData['users_type'] == 'active') {
                    $where_condition = "r.activation_status";
                    $where_operation = "=";
                    $where_value = "activated";
                } elseif ($formData['users_type'] == 'deactive') {
                    $where_condition = "r.activation_status";
                    $where_operation = "=";
                    $where_value = "deactivated";
                } else {
                    $where_condition = "r.email";
                    $where_operation = "!=";
                    $where_value = "";
                }
                // $query= DB::table('registerusers as r')
                //     ->where('r.is_yoububer','=','1');
                //
                // $totalTitles = $query->count();
                // $totalFiltered = $totalTitles;
                //         $json_data=  array(
                //             "recordsTotal" => intval($totalTitles),
                //             "recordsFiltered" => intval($totalFiltered)
                //           );
                //   json_encode($json_data);
                return Datatables::of(DB::table('registerusers as r')
                    ->where('r.is_yoububer', '=', '1')
                    ->where(function ($query) use ($formData) {
                        if (isset($formData['email']))
                            $query->where('r.email', $formData['email']);
                        if (isset($formData['mobile']))
                            $query->where('r.mobile', $formData['mobile']);
                    })

                    // ->where( [$where_condition,$where_operation,$where_value] )
                    ->orderBy('id', 'DESC')
                    // ->offset($start)->limit($limit)
                    ->select('r.username', 'r.email', 'r.mobile', 'r.id', 'r.refercode')
                    //->limit(100)
                    ->get())
                    ->addIndexColumn()
                    ->addColumn('username', function ($result) {
                        return $result->username;
                    })
                    ->addColumn('email', function ($result) {
                        return $result->email;
                    })
                    ->addColumn('mobile', function ($result) {
                        return $result->mobile;
                    })
                    ->addColumn('refercode', function ($result) {
                        return $result->refercode;
                    })
                    ->addColumn('refercount', function ($result) use ($formData) {
                        $query = DB::table('registerusers')->where('refer_id', $result->id);
                        if (!empty(@$formData['start_date']) && !empty($formData['end_date'])) {
                            $query->whereBetween('registerusers.created_at', [$formData['start_date'], $formData['end_date']]);
                        }
                        return $query->count('id');
                    })
                    ->addColumn('earn', function ($result) use ($formData) {
                        $query = DB::table('league_refer_bonus')->where('refer_id', $result->id);
                        if (!empty(@$formData['start_date']) && !empty($formData['end_date'])) {
                            $query->whereBetween('league_refer_bonus.created', [$formData['start_date'], $formData['end_date']]);
                        }
                        return $query->sum('amount');
                    })
                    ->addColumn('deposit', function ($result) use ($formData) {
                        $query = DB::table('transactions')->join('registerusers', 'registerusers.id', '=', 'transactions.userid')->where('registerusers.refer_id', $result->id)->where('type', '=', 'add fund')->where('paymentstatus', '=', 'confirmed');
                        if (!empty(@$formData['start_date']) && !empty($formData['end_date'])) {
                            $query->whereBetween('transactions.created', [$formData['start_date'], $formData['end_date']]);
                        }
                        return $query->sum('amount');
                    })
                    ->addColumn('invest', function ($result) use ($formData) {
                        // echo $formData['start_date']; exit;
                        // return 0;
                        $query =    DB::table('registerusers')
                            ->join('leaugestransactions', 'registerusers.id', '=', 'leaugestransactions.user_id')
                            ->join('matchchallenges', 'leaugestransactions.challengeid', '=', 'matchchallenges.id')
                            ->where('matchchallenges.status', '!=', 'canceled')
                            ->where('registerusers.refer_id', $result->id);
                        if (!empty(@$formData['start_date']) && !empty($formData['end_date'])) {
                            $query->whereBetween('leaugestransactions.created_at', [$formData['start_date'], $formData['end_date']]);
                        }
                        $total_joinlegue = $query->select(DB::raw("SUM(leaugestransactions.winning+leaugestransactions.balance) as total_amount"))
                            ->first();

                        return $total_joinlegue->total_amount;
                    })
                    ->addColumn('action', function ($request) {})
                    ->escapeColumns([])
                    ->make(true);
            } //end
        }

        return view("admin.$this->model.report");
    } //End if

    //Add Yoububer
    public function add(Request $request)
    {
        $formData = Input::all();

        if (!empty($formData)) {
            $message    =    array(
                'image.max' =>    MAX_IMAGE_SIZE,
            );
            $validate    =    array(
                'username' =>    'required|regex:/^[\pL\s\-]+$/u',
                'mobile'   =>    "required|integer|unique:registerusers,mobile|digits:10",
                'email'       =>    "required|email|unique:registerusers,email,NULL,id",
                'dob'       =>    'required',
                'gender'   =>    'required',
                'password' =>    'required|min:6',
                'c_password' =>    'required|same:password',
                'city'     =>    'required',
                'state'    =>    'required',
                'country'  =>    'required',
                'team'     =>    'required',
                //	'youtuber_commission'     =>	'required',
                'youtuber_commission_type'     =>    'required',
            );
            $validator = Validator::make(Input::all(), $validate, $message);
            if ($validator->fails()) {
                return Redirect::back()->withErrors($validator)->withInput();
            } else {
                $input  = $request->all();
                if ($input['base64image'] || $input['base64image'] != '0') {

                    $destinationPath = 'uploads/user/';

                    $image_parts = explode(";base64,", $formData['base64image']);
                    $image_type_aux = explode("image/", $image_parts[0]);
                    $image_type = $image_type_aux[1];

                    $image_base64 = base64_decode($image_parts[1]);
                    // dd($image_base64);
                    // $fileName = 'Gamechela-team-'.str_replace(' ', '-', $formData['team_key']);
                    $fileName = BRAND['name'] . '-profile-' . $image_type;

                    // dd($fileName);
                    // $imageName = CustomHelper::imageUpload($file,$destinationPath,$fileName);
                    // $filename = BRAND['name'].'-player-'.$image_type;
                    $file = $destinationPath . $fileName;
                    file_put_contents($file, $image_base64);

                    $obj['image'] = $fileName;
                }
                // if($request->file('image')){
                //             $image = $request->file('image');
                //             $destination = 'uploads/user';
                //             $filename = 'profile-'.time();
                //             $obj['image'] = Helpers::imageUpload($image,$destination,$filename);
                //             if($obj['image']==''){
                //                 return redirect()->back()->with('danger','Invalid extension of file you uploaded. You can only upload image or pdf.');
                //             }
                //         }
                $obj['username']     = $formData['username'];
                $obj['mobile']         = $formData['mobile'];
                $obj['email']         = $formData['email'];
                $obj['gender']         = $formData['gender'];
                $obj['password']     = Hash::make($formData['password']);
                $obj['country']     = $formData['country'];
                $obj['state']         = $formData['state'];
                $obj['city']         = $formData['city'];
                $obj['dob']         = date('Y-m-d', strtotime($formData['dob']));
                $obj['team']         = $formData['team'];
                $obj['provider']     = 'web';
                $obj['code']         = rand(1000, 9999);
                $obj['refercode']     = 'FB11-' . rand(100000, 999999);
                $obj['activation_status'] = 'activated';
                $obj['mobile_verify'] = '1';
                $obj['email_verify'] = '1';
                $obj['pan_verify'] = '-1';
                $obj['bank_verify'] = '-1';
                $obj['is_yoububer'] = '1';
                $obj['youtuber_commission'] = $formData['youtuber_commission'];
                //	$obj['youtuber_commission_type'] = $formData['youtuber_commission_type'];
                $obj['player_percentage'] = $formData['player_percentage'];
                //Insert
                //print_r($obj);die;
                DB::table('registerusers')->insert($obj);
                Session::flash('flash_notice',  trans("Successfully Add Yoububer!'"));
                Helpers::logActivity('Successfully Add Yoububer!!', $obj['username']);
                return Redirect::route($this->model . '.view');
            }
        }
        //Get Yoububer List
        $states = DB::table('states')->get();
        return view("admin.$this->model.add", compact( 'states'));
    } //End

    //Edit Yoububer
    public function edit($id = null, Request $request)
    {

        $id = unserialize(base64_decode($id));
        //Get User Data
        $user = DB::table('registerusers')->where('id', $id)->first();
        $formData = Input::all();
        //Insert Data
        if (!empty($formData)) {
            $message    =    array(
                'image.max'    =>    MAX_IMAGE_SIZE,
            );
            $validate    =    array(
                'username' =>    'required|regex:/^[\pL\s\-]+$/u',
                'mobile'   =>    "required|integer|unique:registerusers,mobile,$id",
                'email'       =>    "required|email|unique:registerusers,email,$id",
                'dob'       =>    'required',
                'gender'   =>    'required',
                'city'     =>    'required',
                'state'    =>    'required',
                'country'  =>    'required',
                'team'     =>    'required',
                //	'youtuber_commission'     =>	'required',
                'youtuber_commission_type'     =>    'required',
            );
            $validator = Validator::make(Input::all(), $validate, $message);
            if ($validator->fails()) {
                return Redirect::back()->withErrors($validator)->withInput();
            } else {
                $input = $request->all();

                if ($input['base64image'] || $input['base64image'] != '0') {
                    // echo "string"; die();
                    $folderPath = 'uploads/user/';
                    // dd($folderPath);
                    // $folderPath = public_path('images/');
                    $image_parts = explode(";base64,", $input['base64image']);
                    if ($image_parts[0] === "") {
                        // echo "string"; die();
                        if (input::hasFile('image')) {
                            // echo "string"; die();
                            $extension  =   Input::file('image')->getClientOriginalExtension();
                            $img_ext    =   explode(",", IMAGE_EXTENSION);
                            if (in_array($extension, $img_ext)) {
                                $fileName           =   time() . '-Profile.' . $extension;
                                if (Input::file('image')->move('uploads/user/', $fileName)) {
                                    $obj['image']     =   $fileName;
                                    // dd($obj['image']);
                                }
                                // @unlink('uploads/user/' . $oldimage);
                            } else {
                                Session::flash('error',  trans("$this->model.INVALID_IMAGE_EXTENSION"));
                                return Redirect::back();
                            }
                        }
                    } else {
                        $image_type_aux = explode("image/", $image_parts[0]);
                        // dd($image_parts);
                        $image_type = $image_type_aux[1];
                        // dd($image_type);
                        $image_base64 = base64_decode($image_parts[1]);
                        // $file = $folderPath . uniqid() . '.png';
                        $filename           =   time() . '-Profile.' . $image_type;
                        // $filename = time() . '.'. $image_type;
                        $file = $folderPath . $filename;
                        $obj['image'] = $filename;
                        // dd($file);
                        file_put_contents($file, $image_base64);
                        // dd($file);

                        // $playerdetail = new Players;
                        $obj['image'] = $filename;
                        // dd($playerdetail);
                        // $playerdetail->save();
                    }
                }
                //Set Value
                $obj['username']     = $formData['username'];
                $obj['mobile']         = $formData['mobile'];
                $obj['email']         = $formData['email'];
                $obj['gender']         = $formData['gender'];
                $obj['country']     = $formData['country'];
                $obj['state']         = $formData['state'];
                $obj['city']         = $formData['city'];
                $obj['dob']         = date('Y-m-d', strtotime($formData['dob']));
                $obj['team']         = $formData['team'];
                $obj['youtuber_commission_type'] = $formData['youtuber_commission_type'];
                //	$obj['youtuber_commission'] 	 = $formData['youtuber_commission'];
                $obj['player_percentage']      = $formData['player_percentage'];
                //Update
                DB::table('registerusers')->where('id', $id)->update($obj);
                Session::flash('flash_notice',  trans("Successfully Update Yoububer!"));
                Helpers::logActivity('Successfully Update Yoububer!', $obj['username']);
                return Redirect::route("$this->model.view");
            }
        }
        //Get Avater List
        $states = DB::table('states')->get();
        return view("admin.$this->model.edit", compact( 'user', 'states'));
    } //End


    //Youtubers Login Detail Show

    //Youtubers User List Show
    public function users()
    {
        //Get Ajax Data
        $formData = Input::all();
        if (isset($formData) && !empty($formData)) {
            return Datatables::of(DB::table('registerusers as r')
                ->groupBy('r.id')
                //->where('is_yoububer','1')
                ->where('refer_id', Session::get('id'))
                ->select('r.id', 'r.refer_id', 'r.username', 'r.team')
                ->orderBy('id', 'DESC')
                ->get())
                ->addIndexColumn()
                ->escapeColumns([])
                ->make(true);
        } //end

        return view("admin.$this->model.youtubers_user_list");
    } //End Function

    //Youtubers Matches List Show
    public function matches()
    {
        //Get Ajax Data
        $formData = Input::all();
        if (isset($formData) && !empty($formData)) {
            return Datatables::of(DB::table('registerusers as r')
                ->leftJoin('joinedleauges as jl', 'jl.userid', '=', 'r.id')
                ->leftJoin('listmatches as lm', 'jl.matchkey', '=', 'lm.matchkey')
                ->groupBy('r.id')
                //->where('is_yoububer','1')
                ->where('refer_id', Session::get('id'))
                ->select('r.id', 'r.refer_id', 'lm.start_date', 'lm.name', 'jl.challengeid')
                ->orderBy('id', 'DESC')
                ->get())
                ->addIndexColumn()
                ->addColumn('start_date', function ($result) {
                    return date("Y M d", strtotime($result->start_date));
                })
                ->addColumn('action', function ($result) {
                    return '<a href="' . route($this->model . '.user_chalange', base64_encode(serialize($result->challengeid))) . '" class="btn btn-primary"><i class="fa fa-eye" aria-hidden="true" data-toggle="tooltip" title="" data-original-title="View" ></i></a>';
                })
                ->escapeColumns([])
                ->make(true);
        } //end

        return view("admin.$this->model.youtubers_match_list");
    } //End Function

    ///User Chalange
    public function user_chalange($id = null)
    {

        $id = unserialize(base64_decode($id));
        //Get Ajax Data
        $formData = Input::all();
        if (isset($formData) && !empty($formData)) {
            return Datatables::of(DB::table('challenges as c')
                ->where('id', $id)
                ->select('c.id', 'c.entryfee', 'c.win_amount', 'c.maximum_user', 'c.minimum_user', 'c.challenge_type')
                ->orderBy('id', 'DESC')
                ->get())
                ->addIndexColumn()
                ->addColumn('entryfee', function ($result) {
                    return '₹ ' . $result->entryfee;
                })->addColumn('win_amount', function ($result) {
                    return '₹ ' . $result->win_amount;
                })
                ->escapeColumns([])
                ->make(true);
        } //end
        //View Page
        return view("admin.$this->model.youtubers_user_chalange", compact('id'));
    } //End Function

    // Promoters Data Download CSV
    public function downloadPromoters()
    {

        $fileName = 'promoters_' . date("YmdHis") . '.csv';
        $usersdata =  DB::table('registerusers as r')
            ->where('r.is_yoububer', '=', '1')
            ->leftJoin('userbalances as ub', 'ub.user_id', '=', 'r.id')
            ->groupBy('r.id')
            ->select('r.*', 'ub.id as userbalances_id', 'ub.balance', 'ub.winning', 'ub.bonus')
            ->orderBy('id', 'DESC')
            ->get();
        // var_dump($usersdata);exit;
        $headers = array(
            "Content-type"        => "text/csv",
            "Content-Disposition" => "attachment; filename=$fileName",
            "Pragma"              => "no-cache",
            "Cache-Control"       => "must-revalidate, post-check=0, pre-check=0",
            "Expires"             => "0"
        );

        $columns = array('Total  Referral', 'Team Name', 'Email', 'Mobile Number', 'Balance', 'Winning', 'Bonus', 'Promoter Commission Type', 'Promoter Commission');
        $callback = function () use ($usersdata, $columns) {
            $file = fopen('php://output', 'w');
            fputcsv($file, $columns);
            foreach ($usersdata as $user) {
                $row = array();
                if ($user->youtuber_commission_type == 1) {
                    $youtuber_commission_type = "Flat Amount";
                } else {
                    $youtuber_commission_type = "Revenue Amount";
                }
                if (!empty($user->balance)) {
                    $balance = $user->balance;
                } else {
                    $balance = 0;
                }

                if (!empty($user->winning)) {
                    $winning = $user->winning;
                } else {
                    $winning = 0;
                }
                if (!empty($user->bonus)) {
                    $bonus = $user->bonus;
                } else {
                    $bonus = 0;
                }
                $row["total_referral"] = $user->refer_id;
                $row["team"] = $user->team;
                $row["email"] = $user->email;
                $row["mobile"] = $user->mobile;
                $row["balance"] = $balance;
                $row["winning"] = $winning;
                $row["bonus"] = $bonus;
                $row["youtuber_commission_type"] = $youtuber_commission_type;
                $row["player_percentage"] = $user->player_percentage;
                fputcsv($file, array($row['total_referral'], $row['team'], $row['email'], $row['mobile'], $row['balance'], $row['winning'], $row['bonus'], $row['youtuber_commission_type'], $row['player_percentage']));
            }

            fclose($file);
        };
        // var_dump("test");exit;
        return response()->stream($callback, 200, $headers);
    }
    //End Function


    public function promoterwinningcreate(Request $request)
    {

        $result = DB::table('promoter_winning')
            ->where('match_id', @$request->matchkey)
            ->join('listmatches', 'promoter_winning.match_id', 'listmatches.matchkey')
            ->select('promoter_winning.*', 'listmatches.name as matchname', 'listmatches.name as matchname', 'listmatches.matchkey as matchkey', 'listmatches.sport_type', 'listmatches.status')
            ->orderBy('id', 'DESC')
            //->groupBy('match_id')
            ->get();

        $formData = Input::all();
        // if(isset($formData) && !empty($formData)){
        // //	print_r($formData);exit;
        // 			$query= DB::table('promoter_winning')
        // 					->where('match_id',$formData['matchkey'])
        // 					->join('listmatches','promoter_winning.match_id','listmatches.matchkey')
        // 					->select('promoter_winning.*','listmatches.name as matchname','listmatches.name as matchname','listmatches.matchkey as matchkey','listmatches.sport_type','listmatches.status')
        // 					->orderBy('id', 'DESC')
        // 					->get();
        // 	return Datatables::of($query)
        //          ->addIndexColumn()
        //          ->addColumn('matchname',function ($result){
        // 							return  $result->matchname;
        //          })
        //          ->addColumn('teamname',function ($result){
        // 							return  $result->teamname;
        //          })
        //          ->addColumn('entryfees',function ($result){
        // 							return  $result->entryfees;
        //          })
        //          ->addColumn('winnigamount',function ($result){
        // 							return  $result->winnigamount;
        //          })
        //          ->addColumn('sport',function ($result){
        // 							return  $result->sport;
        //          })
        //          ->addColumn('teamnumber',function ($result){
        // 							return  $result->teamnumber;
        //          })
        //          ->addColumn('youwon',function ($result){
        // 							return  $result->youwon;
        //          })
        //          ->addColumn('point',function ($result){
        // 							return  $result->point;
        //          })
        //          ->addColumn('rank',function ($result){
        // 							return  $result->rank;
        //          })
        //          ->addColumn('action', function ($result) {
        // 							return '<a href="" class="btn btn-primary btn-sm col-md-2">Ss</a>';
        // 					// url(admin/Youtuber/Youtuber-winning-screenshot',[$data->match_id,$data->user_id])}}
        //           })
        //           ->escapeColumns([])
        //           ->make(true);
        //
        //
        //
        // }
        $matchkey = @$request->matchkey;

        $findalllistmatches = DB::table('listmatches')
            ->select('listmatches.name as matchname', 'listmatches.matchkey as matchkey', 'listmatches.sport_type', 'listmatches.status', 'listmatches.matchkey', 'start_date')
            ->Where('start_date', '>=', date('Y-m-d H:i:s', strtotime('-1 month')))
            ->Where('final_status', 'winnerdeclared')
            ->orderBY('start_date', 'desc')
            ->get();
        //echo '<pre>'; print_r($findalllistmatches);exit;
        return view("admin.$this->model.addwinning", compact('findalllistmatches', 'matchkey', 'result'));
    }


    public function youtuberDelete($id = '')
    {
        DB::table('promoter_winning')->where('id', $id)->delete();
        return Redirect::back();
    }


    public function promoterdelete($matchkey = 0)
    {

        DB::table('promoter_winning')->where('match_id', $matchkey)->delete();
        Session::flash('flash_notice',  trans("Successfully delete Yoububer Winning!'"));
        Helpers::logActivity('Successfully delete Yoububer Winning!!');
        return Redirect::route($this->model . '.winningcreate');
    }
    public function youtuberEdit($id = '')
    {
        $formdata = Input::all();
        $editresult =    DB::table('promoter_winning')->where('id', $id)->first();
        $findalllistmatches = DB::table('listmatches')
            ->select('listmatches.name as matchname', 'listmatches.matchkey as matchkey', 'listmatches.sport_type', 'listmatches.status', 'listmatches.matchkey')
            ->Where('final_status', 'winnerdeclared')
            ->orderBY('start_date', 'desc')->get();

        $result = DB::table('promoter_winning')
            ->where('match_id', @$formdata['matchkey'])
            ->join('listmatches', 'promoter_winning.match_id', 'listmatches.matchkey')
            ->select('promoter_winning.*', 'listmatches.name as matchname', 'listmatches.name as matchname', 'listmatches.matchkey as matchkey', 'listmatches.sport_type', 'listmatches.status')
            ->orderBy('id', 'DESC')
            ->get();
        return view("admin.$this->model.addwinning", compact('findalllistmatches', 'result', 'editresult'));
    }

    //Add Yoububer winnig store

    public function promoterwinningstore(Request $request)
    {
        // dd('here store');
        $formData = Input::all();
        // dd($formData);
        //Insert Data
        if (!empty($formData)) {
            $message    =    array(
                'image.max' =>    MAX_IMAGE_SIZE,
            );
            $validate    =    array(
                'match_id' =>    'required',
                'teamname'   =>    "required",
                'entryfees'       =>    "required",
                'winnigamount'       =>    'required',
                'sport'   =>    'required',
                'teamnumber' =>    'required',
                //	'youwon' =>	'required',
                'point'     =>    'required',
                'rank'    =>    'required',
            );
            $validator = Validator::make(Input::all(), $validate, $message);
            if ($validator->fails()) {
                return Redirect::back()->withErrors($validator)->withInput();
            } else {
                $input  = $request->all();
                // dd($input);

                $teamNameCheck = DB::table('registerusers')->where('team', $input['teamname'])->first();

                // dd($teamNameCheck);

                if ($teamNameCheck == null) {
                    Session::flash('flash_notice', 'User Team Name Wrong !');
                    return redirect()->back();
                } else {
                    $obj['user_id']         = $teamNameCheck->id;
                }

                $obj['match_id']     = $formData['match_id'];

                $one = 1;
                $DataCount =  DB::table('promoter_winning')->count();
                $keyNum = $DataCount + $one;
                $systemKey = $keyNum;


                $obj['teamname']         = $formData['teamname'];
                $obj['entryfees']         = $formData['entryfees'];
                $obj['winnigamount']         = $formData['winnigamount'];
                $obj['sport']     = $formData['sport'];
                $obj['teamnumber']     = $formData['teamnumber'];
                $obj['youwon']         = $formData['youwon'];
                $obj['point']         = $formData['point'];
                $obj['rank']         = $formData['rank'];
                $obj['sport_number']         = $formData['sport_number'];
                $obj['fantasy_type']         = $formData['fantasy_type'];
                $obj['sport_type']         = $formData['sport_type'];
                $obj['investment']         = @$formData['investment'];
                $obj['totalwinning']         = @$formData['totalwinning'];
                $obj['profit']         = @$formData['profit'];
                // dd($obj);
                if (!empty($formData['winningid'])) {
                    $checkexit =    DB::table('promoter_winning')->where('id', $formData['winningid'])->first();
                }



                if (empty($checkexit)) {

                    if ($formData['sport_number'] > 1) {
                        for ($i = 1; $i <= $formData['sport_number']; $i++) {
                            DB::table('promoter_winning')->insert($obj);
                        }
                    } else {

                        DB::table('promoter_winning')->insert($obj);
                    }
                } else {

                    // if($formData['sport_number']>1){
                    // 		DB::table('promoter_winning')->where('match_id',$formData['match_id'])->delete();
                    // 		for($i=1;$i<=$formData['sport_number'];$i++){
                    // 							DB::table('promoter_winning')->insert($obj);
                    // 				//DB::table('promoter_winning')->where('id',$formData['winningid'])->update($obj);
                    // 	}
                    // }else {
                    // 	DB::table('promoter_winning')->where('id',$formData['winningid'])->update($obj);
                    // }

                    DB::table('promoter_winning')->where('id', $formData['winningid'])->update($obj);
                }

                // Insert
                // print_r('store data ');die;
                Session::flash('flash_notice',  trans("Successfully Add Yoububer Winning!'"));
                Helpers::logActivity('Successfully Add Yoububer Winning!!');
                return Redirect::route($this->model . '.winningcreate', ['matchkey=' . $formData['match_id']]);
            }
        }
    } //End

    public function promoterwinningscreenshot(Request $request)
    {
        // dd($request->all());
        if ($request->matchkey == null) {
            Session::flash('flash_notice', 'please Match id and select !');

            return redirect()->back();
        }
        // else if($request->userid == null){
        // 	Session::flash('flash_notice', 'user name select !');
        // 	return redirect()->back();
        //
        // }
        else {
            $userdata = DB::table('promoter_winning')->where('match_id', $request->matchkey)->first();
            if (empty($userdata)) {
                Session::flash('flash_notice', 'please Match id and select !');

                return redirect()->back();
            }

            $match_key = str_replace('_2', '', $request->matchkey);
            $matchkey = $match_key;
            $findmatch_runs_data = DB::table('matchruns')->where('matchkey', $matchkey)->first();
            if (empty($findmatch_runs_data)) {
                Session::flash('flash_notice', 'data not found');

                return redirect()->back();
            }

            if (! empty($findmatch_runs_data)) {
                $Json['Team1'] = $findmatch_runs_data->teams1;
                $Json['Team2'] = $findmatch_runs_data->teams2;
                $Json['Team1_Totalovers'] = $findmatch_runs_data->overs1;
                $Json['Team1_Totalruns'] = $findmatch_runs_data->runs1;
                $Json['Team1_Totalwickets'] = $findmatch_runs_data->wickets1;
                $Json['Team2_Totalwickets'] = $findmatch_runs_data->wickets2;
                $Json['Team2_Totalovers'] = $findmatch_runs_data->overs2;
                $Json['Team2_Totalruns'] = $findmatch_runs_data->runs2;
                $Json['winning_status'] = $findmatch_runs_data->winning_status;

                if ($findmatch_runs_data->winning_status == '0') {
                    $Json['Winning_Status'] = '';
                } else {
                    $Json['Winning_Status'] = $findmatch_runs_data->winning_status;
                }
            } else {
                if (! empty($findmatch_runs_data->teams1)) {
                    $Json['Team1'] = @$findmatch_runs_data->teams1;
                } else {
                    $Json['Team1'] = '';
                }

                if (! empty($findmatch_runs_data->teams2)) {
                    $Json['Team2'] = @$findmatch_runs_data->teams2;
                } else {
                    $Json['Team2'] = '';
                }

                $Json['Team1_Totalovers'] = '0';
                $Json['Team1_Totalruns'] = '0';
                $Json['Team1_Totalwickets'] = '0';
                $Json['Team2_Totalwickets'] = '0';
                $Json['Team2_Totalovers'] = '0';
                $Json['Team2_Totalruns'] = '0';
                $Json['Winning _Status'] = '0';

                // $Json['scorecard_url'] = 'http://app.exchange22.com/admin/get-scorecards-view/'.$matchkey;
                // $Json['scorecard_url'] = '';
            }

            $contests = DB::table('promoter_winning')
                ->where('match_id', $request->matchkey)
                ->get()
                ->chunk(4);
            $num_contests = 1;
            $num_teams = 1;
            if (!empty($request->matchkey)) {
                $num_contests = DB::table('promoter_winning')
                    ->where('match_id', $request->matchkey)
                    // ->groupby('teamnumber');
                    ->count();
                $num_teams = count(DB::table('promoter_winning')
                    ->where('match_id', $request->matchkey)
                    ->groupby('teamnumber')
                    ->get());

                $invertmentprofile = DB::table('promoter_winning')
                    ->where('match_id', $request->matchkey)
                    // ->groupby('teamnumber');
                    ->first();
            }
            //	 echo "<pre>"; print_r($contests); exit;

            return view("admin.$this->model.promoterss", compact('findmatch_runs_data', 'contests', 'num_contests', 'num_teams', 'invertmentprofile'));
        }
    }

    public function getteamUser(Request $req)
    {
        $teamNameCheck = DB::table('registerusers')->where('team', $req->teamname)->first();
        // dd($teamNameCheck);
        $teamNameUserId = $teamNameCheck->id ?? "null";
        // dd($teamNameUserId);

        if ($teamNameUserId == "null") {
            return response()->json(array('status' => "failed", "msg" => ""));
        } else {
            return response()->json(array('status' => "succcess", "msg" => $teamNameUserId));
        }
    }

    public function allusercommission(Request $request)
    {
        //Get Ajax Data
        if ($request->isMethod('post')) {
            $formData = Input::all();
            $limit  = $request->input('length');
            $start  = $request->input('start');

            if (isset($formData) && !empty($formData)) {
                $where_condition = '';
                $where_operation = '';
                $where_value = '';
                if ($formData['users_type'] == 'active') {
                    $where_condition = "r.activation_status";
                    $where_operation = "=";
                    $where_value = "activated";
                } elseif ($formData['users_type'] == 'deactive') {
                    $where_condition = "r.activation_status";
                    $where_operation = "=";
                    $where_value = "deactivated";
                } else {
                    $where_condition = "r.email";
                    $where_operation = "!=";
                    $where_value = "";
                }
                return Datatables::of(DB::table('league_refer_bonus as lf')
                    ->join('registerusers as r', 'r.id', '=', 'lf.refer_id')
                    //	->where('r.refer_id','!=','0')
                    ->where(function ($query) use ($formData) {
                        if (isset($formData['email']))
                            $query->where('r.email', $formData['email']);
                        if (isset($formData['mobile']))
                            $query->where('r.mobile', $formData['mobile']);
                    })

                    ->orderBy('id', 'DESC')
                    ->select('r.team', 'r.email', 'r.mobile', 'r.id', 'r.refercode', 'lf.user_id')
                    ->selectRaw('sum(lf.amount) as amount')
                    ->groupBy('lf.refer_id')
                    //->limit(100)
                    ->get())
                    ->addIndexColumn()
                    ->addColumn('username', function ($result) {
                        return $result->team;
                    })
                    ->addColumn('email', function ($result) {
                        return $result->email;
                    })
                    ->addColumn('mobile', function ($result) {
                        return $result->mobile;
                    })
                    ->addColumn('refercode', function ($result) {
                        return $result->refercode;
                    })
                    ->addColumn('refercount', function ($result) use ($formData) {
                        $query = DB::table('registerusers')->where('refer_id', $result->id);
                        if (!empty(@$formData['start_date']) && !empty($formData['end_date'])) {
                            $query->whereBetween('registerusers.created_at', [$formData['start_date'], $formData['end_date']]);
                        }
                        return $query->count('id');
                    })
                    ->addColumn('earn', function ($result) use ($formData) {
                        return $result->amount;
                        // $query = DB::table('league_refer_bonus')->where('refer_id', $result->id);
                        // if(!empty(@$formData['start_date']) && !empty($formData['end_date'])) {
                        // 	$query->whereBetween('league_refer_bonus.created', [$formData['start_date'], $formData['end_date']]);
                        // }
                        // return $query->sum('amount');
                    })
                    ->addColumn('deposit', function ($result) use ($formData) {
                        $query = DB::table('transactions')
                            //->join('registerusers','registerusers.id','=','transactions.userid')
                            ->where('transactions.userid', $result->user_id)->where('type', '=', 'add fund')->where('paymentstatus', '=', 'confirmed');
                        if (!empty(@$formData['start_date']) && !empty($formData['end_date'])) {
                            $query->whereBetween('transactions.created', [$formData['start_date'], $formData['end_date']]);
                        }
                        return $query->sum('amount');
                    })
                    ->addColumn('invest', function ($result) use ($formData) {
                        $query =    DB::table('leaugestransactions')
                            //->join('leaugestransactions', 'registerusers.id', '=', 'leaugestransactions.user_id')
                            ->join('matchchallenges', 'leaugestransactions.challengeid', '=', 'matchchallenges.id')
                            ->where('matchchallenges.status', '!=', 'canceled')
                            ->where('leaugestransactions.user_id', $result->user_id);
                        if (!empty(@$formData['start_date']) && !empty($formData['end_date'])) {
                            $query->whereBetween('leaugestransactions.created_at', [$formData['start_date'], $formData['end_date']]);
                        }
                        $total_joinlegue = $query->select(DB::raw("SUM(leaugestransactions.winning+leaugestransactions.balance) as total_amount"))
                            ->first();

                        return number_format($total_joinlegue->total_amount, 2);
                    })
                    // ->addColumn('action',function ($request) {
                    //
                    // })
                    ->escapeColumns([])
                    ->make(true);
            } //end
        }

        //View Page
        return view("admin.$this->model.user_commission_report");
    } //End if


    public function allusercommissionreportdownload(Request $request)
    {
        $formData = $request->all();
        $output1 = "";
        $output1 .= '"Team name",';
        $output1 .= '"Mobile Number",';
        $output1 .= '"Refer Code",';
        $output1 .= '"Total Refers",';
        $output1 .= '"Total Earn",';
        $output1 .= '"User Deposit",';
        $output1 .= '"User Investment",';
        $output1 .= "\n";
        $query =  DB::table('league_refer_bonus as lf')
            ->join('registerusers as r', 'r.id', '=', 'lf.refer_id')
            ->where(function ($query) use ($formData) {
                if (isset($formData['email']))
                    $query->where('r.email', $formData['email']);
                if (isset($formData['mobile']))
                    $query->where('r.mobile', $formData['mobile']);
            })

            ->orderBy('id', 'DESC')
            ->select('r.team', 'r.email', 'r.mobile', 'r.id', 'r.refercode', 'lf.user_id')
            ->selectRaw('sum(lf.amount) as amount')
            ->groupBy('lf.refer_id')
            //->limit(100)
            ->get();


        if (!empty($query)) {
            foreach ($query as $get) {
                $query = DB::table('registerusers')->where('refer_id', $get->id);
                if (!empty(@$formData['start_date']) && !empty($formData['end_date'])) {
                    $query->whereBetween('registerusers.created_at', [$formData['start_date'], $formData['end_date']]);
                }
                $refercount = $query->count('id');
                $totaldeposit = DB::table('transactions')
                    ->where('transactions.userid', $get->user_id)->where('type', '=', 'add fund')->where('paymentstatus', '=', 'confirmed');
                if (!empty(@$formData['start_date']) && !empty($formData['end_date'])) {
                    $query->whereBetween('transactions.created', [$formData['start_date'], $formData['end_date']]);
                }
                $deposit = $totaldeposit->sum('amount');

                $query = DB::table('leaugestransactions')
                    ->join('matchchallenges', 'leaugestransactions.challengeid', '=', 'matchchallenges.id')
                    ->where('matchchallenges.status', '!=', 'canceled')
                    ->where('leaugestransactions.user_id', $get->user_id);
                if (!empty(@$formData['start_date']) && !empty($formData['end_date'])) {
                    $query->whereBetween('leaugestransactions.created_at', [$formData['start_date'], $formData['end_date']]);
                }
                $total_joinlegue = $query->select(DB::raw("SUM(leaugestransactions.winning+leaugestransactions.balance) as total_amount"))
                    ->first();
                $totalinvestment =     number_format($total_joinlegue->total_amount, 2);

                $output1 .= '"' . $get->team . '",';
                $output1 .= '"' . $get->mobile . '",';
                $output1 .= '"' . $get->refercode . '",';
                $output1 .= '"' . $refercount . '",';
                $output1 .= '"' . $get->amount . '",';
                $output1 .= '"' . $deposit . '",';
                $output1 .= '"' . $totalinvestment . '",';
                $output1 .= "\n";
            }
        }
        $filename =  "user_commission.csv";
        header('Content-type: application/csv');
        header('Content-Disposition: attachment; filename=' . $filename);
        echo $output1;
        exit;
    }
} //End Class
