<?php

namespace App\Http\Controllers\Api\V1;

use App\Http\Controllers\Controller;
use App\Http\Controllers\BaseController;
use Illuminate\Http\Request;
use JWTFactory;
use JWTAuth;
use App\User;
use App\Model\OTP;
use App\Model\Address;
use App\Model\EmailAction;
use App\Model\EmailTemplate;
use App\libraries\CustomHelper;
use Str,Auth,Blade,Config,Cache,Cookie,DB,File,Hash,Input,Mail,Redirect,Response,Session,URL,View,Validator;
use Carbon\Carbon;

class AddressController extends BaseController
{
  /*
  * add address
  */
  public function add_address(Request $request)
  {
    $formData				=	Input::all();
    $message = array();
    $validate = array(
        'user_id'=> 'required',
        'address_type'=> 'required',
        'address_name'=> 'required',
        'area'=> 'required',
        'pin_code'=> 'required',
        'address'=> 'required'
      );
    if ( isset($formData['address_type']) && ($formData['address_type'] == SHOP OR $formData['address_type'] == BUNGALOW)) {
      $validate['full_name'] = "required";
      //$validate['email'] = "required|string|email|unique:users,email,NULL,id,is_deleted,0";
      //$validate['phone'] = "required|integer|unique:users,phone,NULL,id,is_deleted,0";
      $validate['email'] = "required|email";
      $validate['phone'] = "required|integer";
    }
    $validator = Validator::make(Input::all(),$validate,$message);
    if ($validator->fails()) {
      $message = "Please fill all required fields.";
      $messages = $validator->errors()->getMessages();
      $messages = array_reverse($messages);
      foreach ($messages as $key => $value) {
        $message = $value[0];
      }
      return Response::json(["status"=>"error","message"=>$message]);
    }else {
      $obj  = new Address;
      $obj->user_id = $formData['user_id'];
      $obj->address_type_id = $formData['address_type'];
      $obj->address_name = $formData['address_name'];
      $obj->area = $formData['area'];
      $obj->pin_code = $formData['pin_code'];
      $obj->address = $formData['address'];
      if ($formData['address_type'] == BUILDING OR $formData['address_type'] == CHAWL) {
        $obj->save();
      }
      // for add customer data to user table too
      if ($formData['address_type'] == SHOP OR $formData['address_type'] == BUNGALOW) {
        $obj->save();

        $customer  = new User;
        $slug = $this->getSlug($formData['full_name'], 'slug','users',60);

        $customer->full_name = $formData['full_name'] ?? "";
        $customer->email = $formData['email'] ?? "";
        $customer->phone = $formData['phone'] ?? "";
        $customer->delivery_charge = $formData['delivery_charge'] ?? 0;
        $customer->address_id = $obj->id;
        $customer->vendor_id = $formData['user_id'] ?? 0;
        $customer->is_billing_on = $formData['is_billing_on'] ?? 1;
        $customer->payer_type = $formData['payer_type'] ?? 0;
        $customer->slug			 		      =	$slug;
        $customer->user_role_id		    =  	USER;
        $customer->active				      =  	ACTIVE;
        $customer->is_verified			  =  	ACTIVE;
        $customer->phone_verify			  =  	ACTIVE;
        $customer->is_deleted			    =  	INACTIVE;
        $customer->save();
      }
      if($obj){
        return Response::json(["status"=>"success",'customer_id' => $customer->id ?? 0,'address_id' => $obj->id,"message"=>"Record saved successfully."]);
      }else {
        return Response::json(["status"=>"error","message"=>"Failed to save the record."]);
      }
    }
  } // end

  /*
  * get address for edit
  */
  public function get_address(Request $request)
  {
    $formData       = Input::all();
    $message = array();
    $validate = array(
        'user_id'=> 'required',
        'address_type'=> 'required',
        'address_id'=> 'required',
      );//End
    $validator = Validator::make(Input::all(),$validate,$message);
    if ($validator->fails()) {
      $message = "Please fill all required fields.";
      $messages = $validator->errors()->getMessages();
      $messages = array_reverse($messages);
      foreach ($messages as $key => $value) {
        $message = $value[0];
      }
      return Response::json(["status"=>"error","message"=>$message]);
    }else {
      if ($formData['address_type'] == BUILDING OR $formData['address_type'] == CHAWL) {
        $query = Address::where('id',$formData['address_id'])
                ->where('user_id',$formData['user_id'])
                ->where('address_type_id',$formData['address_type'])
                ->where('is_deleted','!=',ACTIVE)
                ->where('active', ACTIVE)
                ->first();
      }
      // for add customer data to user table too
      if ($formData['address_type'] == SHOP OR $formData['address_type'] == BUNGALOW) {
        $query = DB::table("users as u")
        ->join('address as add','u.address_id','=','add.id')
        ->join('address_type as at','at.id','=','add.address_type_id')
        ->select('u.id as customer_id','u.full_name','u.delivery_charge','u.email','u.phone','u.is_billing_on','u.payer_type','add.id as address_id','add.address_type_id','add.address',
        'add.area','add.address_name','add.address','add.pin_code')
        ->where('add.id',$formData['address_id'])
        ->where('add.user_id',$formData['user_id'])
        ->where('add.address_type_id',$formData['address_type'])
        ->where('add.is_deleted','!=',ACTIVE)
        ->where('add.active', ACTIVE)
        ->first();
      }
      $response = $query ?? array();
      return Response::json(["status"=>"success","data"=>$response]);

    }
  } // end

  /*
  * update address
  */
  public function update_address(Request $request)
  {
    $formData       = Input::all();
    $message = array();
    $validate = array(
        'user_id'=> 'required',
        'address_id'=> 'required',
        'address_type'=> 'required',
        'address_name'=> 'required',
        'area'=> 'required',
        'pin_code'=> 'required',
        'address'=> 'required'
      );
    if ( isset($formData['address_type']) && ($formData['address_type'] == SHOP OR $formData['address_type'] == BUNGALOW)) {
      $customer_id = $formData['customer_id'];
      $validate['customer_id'] = "required";
      $validate['full_name'] = "required";
      //$validate['email'] = "required|email|unique:users,email,$customer_id,id,is_deleted,0";
      //$validate['phone'] = "required|integer|unique:users,phone,$customer_id,id,is_deleted,0";
      $validate['email'] = "required|email";
      $validate['phone'] = "required|integer";
    }
    $validator = Validator::make(Input::all(),$validate,$message);
    if ($validator->fails()) {
      $message = "Please fill all required fields.";
      $messages = $validator->errors()->getMessages();
      $messages = array_reverse($messages);
      foreach ($messages as $key => $value) {
        $message = $value[0];
      }
      return Response::json(["status"=>"error","message"=>$message]);
    }else {
      $obj  = Address::findOrFail($formData['address_id']);
      $obj->user_id = $formData['user_id'];
      $obj->address_type_id = $formData['address_type'];
      $obj->address_name = $formData['address_name'];
      $obj->area = $formData['area'];
      $obj->pin_code = $formData['pin_code'];
      $obj->address = $formData['address'];
      if ($formData['address_type'] == BUILDING OR $formData['address_type'] == CHAWL) {
        $obj->save();
      }
      // for add customer data to user table too
      if ($formData['address_type'] == SHOP OR $formData['address_type'] == BUNGALOW) {
        $obj->save();

        $customer  = User::findOrFail($customer_id);
        $customer->full_name = $formData['full_name'] ?? "";
        $customer->email = $formData['email'] ?? "";
        $customer->phone = $formData['phone'] ?? "";
        $customer->delivery_charge = $formData['delivery_charge'] ?? 0;
        $customer->address_id = $obj->id;
        $customer->vendor_id = $formData['user_id'] ?? 0;
        $customer->is_billing_on = $formData['is_billing_on'] ?? 1;
        $customer->payer_type = $formData['payer_type'] ?? 0;
        $customer->save();
      }
      if($obj){
        return Response::json(["status"=>"success","message"=>"Record updated successfully."]);
      }else {
        return Response::json(["status"=>"error","message"=>"Failed to save the record."]);
      }
    }
  } // end

  /*
  * get address for edit
  */
  public function get_area(Request $request)
  {
    $formData       = Input::all();
    $message = array();
    $validate = array(
        'user_id'=> 'required',
        'address_type'=> 'required',
        'area'=> 'required',
      );
    $validator = Validator::make(Input::all(),$validate,$message);
    if ($validator->fails()) {
      $message = "Please fill all required fields.";
      $messages = $validator->errors()->getMessages();
      $messages = array_reverse($messages);
      foreach ($messages as $key => $value) {
        $message = $value[0];
      }
      return Response::json(["status"=>"error","message"=>$message]);
    }else {
      $query = Address::select('area','pin_code')
              ->where('user_id',$formData['user_id'])
              ->where('address_type_id',$formData['address_type'])
              ->where('is_deleted','!=',ACTIVE)
              ->where('active', ACTIVE)
              ->where('area', 'like', '%' . $formData['area'] . '%')
              ->groupBy('area')
              ->get();
      $response = $query ?? array();
      return Response::json(["status"=>"success","data"=>$response]);
    }
  } // end
  public function delete_address(){
    $formData = Input::all();
    $message = array();
    $validate = array(
        'address_id'=> 'required',
      );
    $validator = Validator::make(Input::all(),$validate,$message);
    if ($validator->fails()) {
      $message = "Please fill all required fields.";
      $messages = $validator->errors()->getMessages();
      $messages = array_reverse($messages);
      foreach ($messages as $key => $value) {
        $message = $value[0];
      }
      return Response::json(["status"=>"error","message"=>$message]);
    }else {
      $address_id       = $formData['address_id'];
      Address::where('id',$address_id)->update(array('is_deleted'=>ACTIVE));
      return Response::json(["status"=>"success","message"=>"Address deleted successfully."]);
    }
	} // end delete_address()

  /*
  * manage customers
  */
  public function get_address_customers(Request $request)
  {
    $formData				=	Input::all();
    $validator = Validator::make($request->all(), [
        'user_id'=> 'required',
        'address_id'=> 'required',

    ]);
    if ($validator->fails()) {
      $message = "Please fill all required fields.";
      $messages = $validator->errors()->getMessages();
      $messages = array_reverse($messages);
      foreach ($messages as $key => $value) {
        $message = $value[0];
      }
      return Response::json(["status"=>"error","message"=>$message]);
    }else {
      $response =array();
      $query = DB::table("users as u");
      $query->join('address as add','u.address_id','=','add.id')
      ->join('address_type as at','at.id','=','add.address_type_id');
      // filter by payment_option
      if (isset($formData['payment_option']) && ($formData['payment_option']==1 || $formData['payment_option'] == 2)) {
        $query->join('customers_newspapers as cn','u.id','=','cn.customer_id');
      }
      $query->select('u.full_name','u.id as customer_id','flat_number','add.id as address_id','add.address_type_id','add.address')
      ->where('u.is_deleted','!=',ACTIVE)
      ->where('u.user_role_id', USER)
      ->where('u.active', ACTIVE)
      ->where('add.is_deleted','!=',ACTIVE)
      ->where('add.active', ACTIVE)
      ->orderBy('add.address_name', 'ASC')
      ->groupBy('u.id');
      $query->where('u.vendor_id',$formData['user_id']);
      $query->where('u.address_id',$formData['address_id']);
      // filter by payment_option
      if (isset($formData['payment_option']) && ($formData['payment_option']==1 || $formData['payment_option'] == 2)) {
        $query->where('cn.payment_option',$formData['payment_option']);
      }
      $result = $query->get();
      if (!empty($result)) {
        foreach ($result as $key => $value) {
          $customers = DB::table("users as u")
          ->join('customers_newspapers as cn','u.id','=','cn.customer_id')
          ->where('cn.address_id',$value->address_id)
          ->where('cn.customer_id',$value->customer_id)
          ->where('u.vendor_id',$formData['user_id'])
          ->count();
          $result[$key]->units = $customers ?? 0;
        }
        $response['result'] = $result;
        //pr($response);die;
        return Response::json(["status"=>"success","data"=>$response]);
      }else {
        return Response::json(["status"=>"error","message"=>"No record found."]);
      }
    }
  } // end

} // end AddressController class
