<?php

namespace App\Http\Controllers\Api\V1;

use App\Http\Controllers\Controller;
use App\Http\Controllers\BaseController;
use Illuminate\Http\Request;
use JWTFactory;
use JWTAuth;
use App\User;
use App\Model\OTP;
use App\Model\Address;
use App\Model\EmailAction;
use App\Model\EmailTemplate;
use App\libraries\CustomHelper;
use Str,Auth,Blade,Config,Cache,Cookie,DB,File,Hash,Input,Mail,Redirect,Response,Session,URL,View,Validator;
use Carbon\Carbon;

class AddressTypeController extends BaseController
{
  /*
  * add address
  */
  public function manageCustomers(Request $request)
  {
    $formData				=	Input::all();
    $validator = Validator::make($request->all(), [
        'user_id'=> 'required',
        'address_type'=> 'required',

    ]);
    if ($validator->fails()) {
      $message = "Please fill all required fields.";
      $messages = $validator->errors()->getMessages();
      $messages = array_reverse($messages);
      foreach ($messages as $key => $value) {
        $message = $value[0];
      }
      /*  if (isset($message['user_id']) && !empty($message['user_id'])) {
        $message = $message['user_id'][0];
      }
      if (isset($message['address_type']) && !empty($message['address_type'])) {
        $message = $message['address_type'][0];
      } */
      return Response::json(["status"=>"error","message"=>$message]);
    }else {
      $response =array();
      $query = DB::table("users as u");
      $query->join('address as add','u.id','=','add.user_id')
      ->join('address_type as at','at.id','=','add.address_type_id')
      ->select('add.id as address_id','add.address_type_id','add.address',
      'add.area','add.address_name','add.address','add.pin_code')
      ->where('u.is_deleted','!=',ACTIVE)
      ->where('u.user_role_id', USER)
      ->where('u.active', ACTIVE)
      ->orderBy('add.address_name', 'ASC');
      $query->where('u.vendor_id',$formData['user_id']);
      $query->where('at.id',$formData['address_type']);
      // filter by area
      if (isset($formData['area']) && !empty($formData['area'])) {
        $query->where('add.area', 'like', '%' . $formData['area'] . '%');
      }
      $result = $query->get();

      if (!empty($result)) {
          $address_ids = array();
        if ($formData['address_type'] == BUILDING OR $formData['address_type'] == CHAWL) {
          foreach ($result as $key => $value) {
            $customers = DB::table("users as u")->where('u.user_role_id', USER)->where('u.is_deleted','!=',ACTIVE)->where('u.active', ACTIVE)->where('u.address_id',$value->address_id)->count();
            $result[$key]->no_of_customers = $customers ?? 0;
            array_push($address_ids, $value->address_id);
          }
        }
        if ($formData['address_type'] == SHOP OR $formData['address_type'] == BUNGALOW) {
          foreach ($result as $key => $value) {
            $customers = DB::table("users as u")->where('u.user_role_id', USER)->where('u.is_deleted','!=',ACTIVE)->where('u.active', ACTIVE)->where('u.address_id',$value->address_id)->count();
            $result[$key]->no_of_customers = $customers ?? 0;
            array_push($address_ids, $value->address_id);
          }
        }
        if (count($address_ids)) {
          $total_customers = DB::table("users as u")->whereIn('u.address_id',$address_ids)->where('u.user_role_id', USER)->where('u.is_deleted','!=',ACTIVE)->where('u.active', ACTIVE)->count();
        }
        $response['total_customers'] = $total_customers ?? 0;
        $response['result'] = $result;
        //pr($response);die;
        return Response::json(["status"=>"success","data"=>$response]);
      }else {
        return Response::json(["status"=>"error","message"=>"No record found."]);
      }
    }
  } // end
  /*
  * get customers
  */
  public function getCustomers(Request $request)
  {
    $formData				=	Input::all();
    $validator = Validator::make($request->all(), [
        'user_id'=> 'required',
        'address_type'=> 'required',

    ]);
    if ($validator->fails()) {
      $message = "Please fill all required fields.";
      $messages = $validator->errors()->getMessages();
      $messages = array_reverse($messages);
      foreach ($messages as $key => $value) {
        $message = $value[0];
      }
      /*  if (isset($message['user_id']) && !empty($message['user_id'])) {
        $message = $message['user_id'][0];
      }
      if (isset($message['address_type']) && !empty($message['address_type'])) {
        $message = $message['address_type'][0];
      } */
      return Response::json(["status"=>"error","message"=>$message]);
    }else {
      $query = DB::table("users as u");
      $query->join('address as add','u.id','=','add.user_id')
      ->join('address_type as at','at.id','=','add.address_type_id')
      ->select('u.id','u.full_name','u.email','u.active','u.newspaper_agency_name','u.delivery_charge',
      'u.is_verified','u.phone','u.vendor_id','add.address_type_id','add.address',
      'add.area','add.address_name','add.address','add.pin_code','at.name as address_type_name')
      ->where('u.is_deleted','!=',ACTIVE)
      ->where('u.user_role_id', USER)
      ->orderBy('u.id', 'DESC');
      $query->where('u.vendor_id',$formData['user_id']);
      $result = $query->get();
      pr($result);die;
      if (!empty($result)) {
        $response['result'] = $result;
        return Response::json(["status"=>"success","data"=>$response]);
      }else {
        return Response::json(["status"=>"error","message"=>"No user found."]);
      }
    }
  } // end

} // end AddressController class
