<?php

namespace App\Http\Controllers\Api\V1;

use App\Http\Controllers\Controller;
use App\Http\Controllers\BaseController;
use Illuminate\Http\Request;
use JWTFactory;
use JWTAuth;
use App\User;
use App\Model\OTP;
use App\Model\Address;
use App\Model\EmailAction;
use App\Model\EmailTemplate;
use App\Model\Billings;
use App\Model\BillingHistory;
use App\Model\Payment;
use App\Model\BillURL;
use App\Model\ReportProblem;
use App\libraries\CustomHelper;
use Str,Auth,Blade,Config,Cache,Cookie,DB,File,Hash,Input,Mail,Redirect,Response,Session,URL,View,Validator;
use Carbon\Carbon;

class BillController extends BaseController
{
  /*
  * get billings list
  */
  public function index(Request $request)
  {
    $formData				=	Input::all();
    $validator = Validator::make($request->all(), [
        'user_id'=> 'required',
        'address_type'=> 'required',

    ]);
    if ($validator->fails()) {
      $message = "Please fill all required fields.";
      $messages = $validator->errors()->getMessages();
      $messages = array_reverse($messages);
      foreach ($messages as $key => $value) {
        $message = $value[0];
      }
      return Response::json(["status"=>"error","message"=>$message]);
    }else {
      $response =array();
      $language_id = $formData['language_id'] ?? Config::get('default_language.language_code');
      $response['areas'] = CustomHelper::getVendorAreas($formData['user_id']);

      $query = DB::table("users as u");
      $query->join('address as add','u.id','=','add.user_id')
      ->join('address_type as at','at.id','=','add.address_type_id')
      ->select('add.id as address_id','add.address_type_id','add.address_name')
      ->where('u.user_role_id', VENDOR)
      ->where('u.is_deleted','!=',ACTIVE)
      ->where('u.active', ACTIVE)
      ->where('add.is_deleted','!=',ACTIVE)
      ->where('add.active', ACTIVE)
      ->orderBy('add.address_name', 'ASC');
      $query->where('u.id',$formData['user_id']);
      $query->where('at.id',$formData['address_type']);
      // filter by area
      if (isset($formData['area']) && !empty($formData['area'])) {
        $query->where('add.area', 'like', '%' . $formData['area'] . '%');
      }
      $result = $query->get();
      // $query = DB::getQueryLog();
      // $query = end($query);
       //pr($result);die();
      if (!empty($result)) {

        /*####### Check monthly newspaper record start #######*/
        $cnp_query = DB::table("customers_newspapers as cnp");
        $cnp_query->join('users as u','cnp.customer_id','=','u.id')
          ->join('address as add','u.address_id','=','add.id')
          ->join('address_type as at','at.id','=','add.address_type_id')
          ->where('u.user_role_id', USER)
          ->where('u.vendor_id', $formData['user_id'])
          ->where('u.is_deleted','!=',ACTIVE)
          ->where('u.active', ACTIVE)
          ->where('cnp.status', ACTIVE)
          ->where('cnp.is_deleted', INACTIVE)
          ->where('add.is_deleted','!=',ACTIVE)
          ->where('add.active', ACTIVE)
          ->where('add.address_type_id',$formData['address_type'])
          ->select('u.id as customer_id','add.id as address_id','add.address_type_id','cnp.newspaper_id','cnp.payment_option','cnp.delivery_day_type')
          ->orderBy('add.address_name', 'ASC');
        //$cnp_query->groupBy('u.id');
        $cnp_result = $cnp_query->get();
        if (!empty($cnp_result)) {
          $insertMonthlyBill = array();
          foreach ($cnp_result as $cnp_key => $cnp_value) {
            $date = date('d-m-Y');
            $dateArray = date_parse_from_format('d-m-Y', $date);
            $check_bill = DB::table('monthly_bill')
                          ->where('customer_id',$cnp_value->customer_id)
                          ->where('newspaper_id',$cnp_value->newspaper_id)
                          ->where('month',$dateArray['month'])
                          ->where('year',$dateArray['year'])
                          ->first();
              if (empty($check_bill)) {
                $insertMonthlyBill[] = array(
                  'customer_id'=> $cnp_value->customer_id,
                  'newspaper_id'=> $cnp_value->newspaper_id,
                  'month'=> $dateArray['month'],
                  'year'=> $dateArray['year'],
                  'delivery_day_type'=> $cnp_value->delivery_day_type,
                  'is_coupon_type'=> $cnp_value->payment_option,
                  'total_days'=> serialize(array()),
                  'holidays'=> serialize(array()),
                  'created_at'=> date('Y-m-d H:i:s'),
                );
              }
          }
          if (isset($insertMonthlyBill) && !empty($insertMonthlyBill)) {
            DB::table('monthly_bill')->insert($insertMonthlyBill);
          }
        }
        /*####### Check monthly newspaper record end #######*/

        if ($formData['address_type'] == BUILDING OR $formData['address_type'] == CHAWL) {
          foreach ($result as $main_key => $main_value) {
            $bill_query = DB::table("users as u");
            $bill_query->join('address as add','u.address_id','=','add.id')
            ->join('address_type as at','at.id','=','add.address_type_id')
            ->join('billings as bil','u.id','=','bil.customer_id')
            ->select(DB::raw('SUM(bil.total_amount) As total_collection'),DB::raw('SUM(bil.due_amount) As due_collection'))
            ->where('u.user_role_id', USER)
            ->where('u.is_deleted','!=',ACTIVE)
            ->where('u.active', ACTIVE)
            ->where('add.is_deleted','!=',ACTIVE)
            ->where('add.active', ACTIVE)
            ->orderBy('add.address_name', 'ASC');
            $bill_query->where('add.id',$main_value->address_id);
            $bill_query->where('at.id',$formData['address_type']);
            $bill_result = $bill_query->first();
            $result[$main_key]->total_collection = $bill_result->total_collection ?? 0;
            $result[$main_key]->due_collection = $bill_result->due_collection ?? 0;
          }
          $address_ids = array();
            foreach ($result as $key => $value) {
              $customers = DB::table("users as u")->where('u.user_role_id', USER)->where('u.is_deleted','!=',ACTIVE)->where('u.active', ACTIVE)->where('u.address_id',$value->address_id)->count();
              $result[$key]->no_of_customers = $customers ?? 0;
              array_push($address_ids, $value->address_id);
            }

          if (count($address_ids)) {
            $total_customers = DB::table("users as u")->whereIn('u.address_id',$address_ids)->where('u.user_role_id', USER)->where('u.is_deleted','!=',ACTIVE)->where('u.active', ACTIVE)->count();
          }
          $response['total_customers'] = $total_customers ?? 0;
        }

        if ($formData['address_type'] == SHOP OR $formData['address_type'] == BUNGALOW) {
          $query = DB::table("users as u");
          $query->join('address as add','u.address_id','=','add.id')
          ->join('address_type as at','at.id','=','add.address_type_id')
          ->join('customers_newspapers as cnp','u.id','=','cnp.customer_id')
          ->leftjoin('billings as bil','u.id','=','bil.customer_id')
          ->select('bil.id as bill_id','bil.created_at','bil.updated_at','u.id as customer_id','u.full_name','u.phone','u.flat_number','bil.total_amount','add.address_name','add.area','bil.paid_amount','bil.due_amount','bil.is_sent','bil.bill_status','bil.is_manual','bil.month','bil.year','bil.previous_month_due')
          ->where('u.user_role_id', USER)
          ->where('u.vendor_id', $formData['user_id'])
          ->where('u.is_deleted','!=',ACTIVE)
          ->where('u.active', ACTIVE)
          ->where('add.is_deleted','!=',ACTIVE)
          ->where('add.active', ACTIVE)
          ->orderBy('add.address_name', 'ASC')
          ->orderBy('bil.id', 'desc');
          $query->where('add.address_type_id',$formData['address_type']);
          // filter by status
          if (isset($formData['area']) && !empty($formData['area'])) {
            $query->where('add.area', 'like', '%' . $formData['area'] . '%');
          }
          $query->groupBy(['u.id','bil.customer_id']);
          $result = $query->get();
           //pr($result);die();
          if (!empty($result)) {
            foreach ($result as $main_key => $main_value) {
              $language_id = $formData['language_id'] ?? Config::get('default_language.language_code');
              $newspaper_result  = DB::table('monthly_bill as mb')
              				->join('dropdown_managers as dm','mb.newspaper_id','=','dm.id')
              				->join('dropdown_manager_descriptions as dmd','dm.id','=','dmd.parent_id')
                      ->where("dm.dropdown_type","newspapers")
                      ->where('dm.status',ACTIVE)
                      ->where('dmd.language_id',$language_id)
                      ->where('mb.customer_id',$main_value->customer_id)
                      ->where('mb.month',$main_value->month)
                      ->where('mb.year',$main_value->year)
              				->select('dmd.name as newspaper_name')
              				->get();
              $result[$main_key]->newspapers = $newspaper_result ?? array();
            }
          }

        }

        $response['result'] = $result;
        //pr($response);die;
        return Response::json(["status"=>"success","data"=>$response]);
      }else {
        return Response::json(["status"=>"error","message"=>"No record found."]);
      }
    }
  } // end
  /*
  * get bill of customers of a address
  */
  public function get_address_customers_bill(Request $request)
  {
    $formData				=	Input::all();
    $validator = Validator::make($request->all(), [
        'user_id'=> 'required',
        'address_id'=> 'required',
    ]);
    if ($validator->fails()) {
      $message = "Please fill all required fields.";
      $messages = $validator->errors()->getMessages();
      $messages = array_reverse($messages);
      foreach ($messages as $key => $value) {
        $message = $value[0];
      }
      return Response::json(["status"=>"error","message"=>$message]);
    }else {
      $response =array();

      $query = DB::table("users as u");
      $query->join('address as add','u.address_id','=','add.id')
      ->join('address_type as at','at.id','=','add.address_type_id')
      ->join('billings as bil','u.id','=','bil.customer_id')
      ->select('bil.id as bill_id','bil.created_at','bil.updated_at','u.id as customer_id','u.full_name','u.phone','u.flat_number','bil.total_amount','add.address_name','add.area','bil.paid_amount','bil.due_amount','bil.previous_month_due','bil.is_sent','bil.bill_status','bil.is_manual','bil.month','bil.year','bil.delivery_charge')
      ->where('u.user_role_id', USER)
      ->where('u.is_deleted','!=',ACTIVE)
      ->where('u.active', ACTIVE)
      ->where('add.is_deleted','!=',ACTIVE)
      ->where('add.active', ACTIVE);
      $query->where('add.id',$formData['address_id']);
      // filter by status
      // bill_status = 5 means bill not sent is_sent=0
      if (isset($formData['bill_status']) && $formData['bill_status'] !="" && $formData['bill_status'] == 4) {
        $query->where('bil.is_sent',INACTIVE);
      }else if (isset($formData['bill_status']) && $formData['bill_status'] !="" && $formData['bill_status'] != 4) {
        $query->where('bil.bill_status',$formData['bill_status']);
        $query->where('bil.is_sent',ACTIVE);
      }
      
      $query->orderBy('add.address_name', 'ASC');
      $query->groupBy(['u.id','bil.customer_id']);
      $result = $query->get();
       //$query = DB::getQueryLog();
       //$query = end($query);
       //pr($query);die();
      if (!empty($result)) {
        foreach ($result as $main_key => $main_value) {
          $language_id = $formData['language_id'] ?? Config::get('default_language.language_code');
          $newspaper_result  = DB::table('monthly_bill as mb')
          				->join('dropdown_managers as dm','mb.newspaper_id','=','dm.id')
          				->join('dropdown_manager_descriptions as dmd','dm.id','=','dmd.parent_id')
                  ->where("dm.dropdown_type","newspapers")
                  ->where('dm.status',ACTIVE)
                  ->where('dmd.language_id',$language_id)
                  ->where('mb.customer_id',$main_value->customer_id)
                  ->where('mb.month',$main_value->month)
                  ->where('mb.year',$main_value->year)
          				->select('dmd.name as newspaper_name')
          				->get();
          $result[$main_key]->newspapers = $newspaper_result ?? array();
        }
        $response['result'] = $result;
        //pr($response);die;
        return Response::json(["status"=>"success","data"=>$response]);
      }else {
        return Response::json(["status"=>"error","message"=>"No record found."]);
      }
    }
  } // end

  /*
  * update bill amount of a customer of a address
  */
  public function update_bill_amount(Request $request)
  {
    $formData				=	Input::all();
    $validator = Validator::make($request->all(), [
        'user_id'=> 'required',
        'customer_id'=> 'required',
        'bill_id'=> 'required',
        'amount'=> 'required',
    ]);
    if ($validator->fails()) {
      $message = "Please fill all required fields.";
      $messages = $validator->errors()->getMessages();
      $messages = array_reverse($messages);
      foreach ($messages as $key => $value) {
        $message = $value[0];
      }
      return Response::json(["status"=>"error","message"=>$message]);
    }else {
      $response =array();
      $result  = DB::table('billings as bil')
              ->join('users as u','bil.customer_id','=','u.id')
              ->where('bil.id',$formData['bill_id'])
              ->where('u.vendor_id',$formData['user_id'])
              ->where('bil.customer_id',$formData['customer_id'])
              ->select('bil.*')
              ->first();
      if (!empty($result)) {
        $updateBillData = array(
          'total_amount'=>$formData['amount'],
          'due_amount'=>$formData['amount'] - $result->paid_amount,
        );
        $obj = DB::table('billings')
            ->where('id',$formData['bill_id'])
            ->where('customer_id',$formData['customer_id'])
            ->update($updateBillData);
        // update bill status by store procedure
        $ress= DB::select('call manage_bill_status(?)',array($formData['bill_id']));
        if ($obj) {
          return Response::json(["status"=>"success","message"=>"Bill Updated"]);
        }else {
          return Response::json(["status"=>"error","message"=>"Something went wrong."]);
        }
      }else {
        return Response::json(["status"=>"success","message"=>"No Record Found"]);
      }

    }
  } // end
  /*
  * update paid bill amount of a customer of a address
  */
  public function update_collection_amount(Request $request)
  {
    $formData				=	Input::all();
    $validator = Validator::make($request->all(), [
        'user_id'=> 'required',
        'customer_id'=> 'required',
        'bill_id'=> 'required',
        'amount'=> 'required',
    ]);
    if ($validator->fails()) {
      $message = "Please fill all required fields.";
      $messages = $validator->errors()->getMessages();
      $messages = array_reverse($messages);
      foreach ($messages as $key => $value) {
        $message = $value[0];
      }
      return Response::json(["status"=>"error","message"=>$message]);
    }else {
      $response =array();
      $result  = DB::table('billings as bil')
              ->join('users as u','bil.customer_id','=','u.id')
              ->where('bil.id',$formData['bill_id'])
              ->where('u.vendor_id',$formData['user_id'])
              ->where('bil.customer_id',$formData['customer_id'])
              ->select('bil.*')
              ->first();
      //Email Data Get 
      $emailresult  = DB::table('users')
              ->where('id',$formData['customer_id'])
              ->select('email','full_name','phone')
              ->first(); 

      $venderresult  = DB::table('users')
              ->where('id',$formData['user_id'])
              ->select('full_name','phone','newspaper_agency_name')
              ->first();
      $formData['customer_id']  ;    
      if (!empty($result)) {
        $obj = Billings::findOrFail($formData['bill_id']);
        $obj->paid_amount += $formData['amount'];
        $obj->due_amount = $obj->total_amount - $obj->paid_amount;
        $obj->save();
        if ($obj) {
          $orderId = CustomHelper::generateOrderId();
          $payment                   = new Payment;
          $payment->order_id         = $orderId;
          $payment->txn_id           = 'cash-'.$formData['customer_id'].Str::random();
          $payment->customer_id      = $formData['customer_id'];
          $payment->payment_id      = $formData['bill_id'];
          $payment->payment_mode     = 2;
          $payment->txn_type          = 2;
          $payment->currency_code    = "INR";
          $payment->payment_status   = "Completed";
          $payment->amount           = $formData['amount'];
          $payment->description      = 'Cash Rs '.$formData['amount'].' collected.';
          $payment->save();

          //Send Mail
          $settingsEmail       = Config::get('Site.email');
          $subject          =   "Collection Amount Reminder For ".$emailresult->full_name;
          $messageBody      =   '<table border="0" cellpadding="0" cellspacing="0" width="100%"> 
                                  <tbody>
                                    <tr>
                                      <td style="padding:15px 15px; background: #2b3643; color: #fff;  border-radius: 5px 5px 0px 0px;" valign="top">
                                      <table align="center" border="0" cellpadding="0" cellspacing="0" width="100%">
                                        <tbody>
                                          <tr>
                                            <td style="font-size: 20px; color: #fff; font-weight: 500;">'.$venderresult->newspaper_agency_name.'</td>
                                          </tr>
                                        </tbody>
                                      </table>
                                      </td>
                                    </tr>
                                  </tbody>
                                </table>
                                 <br> 
                                <table border="0" cellpadding="0" cellspacing="0" width="100%">
                                  <tbody>
                                    <tr>
                                      <td style="padding:15px 15px; background: #2b3643; color: #fff;  border-radius: 5px 5px 0px 0px;" valign="top">
                                      <table align="center" border="0" cellpadding="0" cellspacing="0" width="100%">
                                        <tbody>
                                          <tr>
                                            <td style="text-align: color: #fff;">Powered by Newskart</td>
                                          </tr>
                                        </tbody>
                                      </table>
                                      </td>
                                    </tr>
                                  </tbody>
                                </table><br>
                                  Dear Customer,<br> 
                                  INR '.$formData['amount'].' has been received by your vendor '.$venderresult->full_name.' via cash.<br> 
                                  Thanks
                                  <p style="font-size: 15px; padding: 15px 0px; line-height: 24px;"><span style="font-weight: bold;">Newskart : Empowering Vendors &amp; Readers</span></p>';
          $mail       =   $this->sendMail($emailresult->email,$emailresult->full_name,$subject,$messageBody,$settingsEmail);
          // update bill status by store procedure
          $ress= DB::select('call manage_bill_status(?)',array($formData['bill_id']));

          return Response::json(["status"=>"success","message"=>"Bill Collection Updated"]);
        }else {
          return Response::json(["status"=>"error","message"=>"Something went wrong."]);
        }
      }else {
        return Response::json(["status"=>"success","message"=>"No Record Found"]);
      }

    }
  } // end

  /*
  * send bill
  */
  public function send_bill(Request $request)
  {
    $formData				=	Input::all();
    $validator = Validator::make($request->all(), [
        'user_id'     => 'required',
        'customer_id' => 'required',
        'bill_id'     => 'required',
        'amount'      => 'required',
    ]);
    if ($validator->fails()) {
      $message = "Please fill all required fields.";
      $messages = $validator->errors()->getMessages();
      $messages = array_reverse($messages);
      foreach ($messages as $key => $value) {
        $message = $value[0];
      }
      return Response::json(["status"=>"error","message"=>$message]);
    }else {

      $response =array();
      $result  = DB::table('billings as bil')
              ->join('users as u','bil.customer_id','=','u.id')
              ->join('users as v','u.vendor_id','=','v.id')
              ->where('bil.id',$formData['bill_id'])
              ->where('u.vendor_id',$formData['user_id'])
              ->where('bil.customer_id',$formData['customer_id'])
             // ->where('bil.is_sent',INACTIVE)
              ->select('bil.*','u.full_name','v.full_name as vendor_name','v.newspaper_agency_name','u.phone','u.email')
              ->first();
      if (!empty($result)) {
        $obj = Billings::findOrFail($formData['bill_id']);
        $obj->total_amount = $formData['amount'];
        $obj->due_amount = $obj->total_amount-$obj->paid_amount;
        $obj->save();

        if ($obj) {
          $dateObj   = \DateTime::createFromFormat('!m', $result->month);
          $monthName = $dateObj->format('F');
          $month_year = $monthName.'-'.$result->year;
          $random_string = Str::random();
          $URL = route('pay_bill',[$month_year,base64_encode($formData['customer_id']),$random_string]);
          // short the url
          $URL = CustomHelper::create_bitly_url($URL,'json');

          $obj2 = new BillURL;
          $obj2->bill_id = $formData['bill_id'];
          $obj2->customer_id = $formData['customer_id'];
          $obj2->validate_string = $random_string;
          $obj2->month   = $result->month;
          $obj2->year    = $result->year;
          $obj2->amount    = $formData['amount'];
          $obj2->url = $URL;
          $obj2->save();

          //Set Customer Id
          $costome_id='C'.$formData['customer_id'].Str::random(3);
          //Get Vendor Phone No
          $vendor_result  = DB::table('users as u')
              ->where('u.id',$formData['user_id'])
              ->select('u.full_name','v.full_name as vendor_name','v.newspaper_agency_name','u.phone','u.email')
              ->first();

          //$click_link 			= '<a target="_blank" style="font-weight:bold;text-decoration:none;color:#4286f4;" href="' . $URL . '">Click Here</a>';
          $click_link = '<a target="_blank" href="' . $URL . '" style=" display: inline-block; text-decoration: none;color:#fff">Pay Bill Now</a>';

          /*######## send sms #########*/
          //$message =  "Your newspaper bill for ".$monthName."-".$result->year." is Rs ".$formData['amount'].". Your vendor is ".$result->vendor_name.". To pay online from mobile phone click on link ".$URL.".";

          $message = "Hi ".$result->full_name." ,<br> Your Newspaper bill for ".$monthName."-".$result->year." is Rs. ".$formData['amount'].".<br> Click on this link to pay online from your phone : ".$URL.". <br>
          Id:".$costome_id."<br> Thanks - ".$result->newspaper_agency_name.".<br> For Customer support please contact : ".$vendor_result->phone.".<br> Powered by ".Config('Site.title')."";
          //echo $message;die;
          CustomHelper::send_sms($result->phone,$message);
          /*######## send sms #########*/

          $is_manual = 1;
          if ($result->total_amount == $formData['amount']) {
            $is_manual = 0;
          }
          DB::table('billings')
                  ->where('id',$formData['bill_id'])
                  ->where('customer_id',$formData['customer_id'])
                  ->where('is_sent',INACTIVE)
                  ->update(['is_sent'=>ACTIVE,'is_manual'=>$is_manual]);

          // send mail to customer
          $settingsEmail 			=	Config::get('Site.email');
          $full_name				  =	$result->full_name;
          $vendor_name				=	$result->vendor_name;
          $email				      =	$result->email;
    			$route_url      		=  	$URL;
    			$link 					    =   $route_url;
    			$click_link 			  = '<a target="_blank" style="font-weight:bold;text-decoration:none;color:#4286f4;" href="' . $link . '">Click Here</a>';

    			$emailActions		= 	EmailAction::where('action','=','send_bill')->get()->toArray();

    			$emailTemplates	= 	EmailTemplate::where('action','=','send_bill')
    											    ->get(array('name','subject','action','body'))->toArray();
    			$cons 					= 	explode(',',$emailActions[0]['options']);

    			$constants 			= 	array();

    			foreach($cons as $key => $val){
    				$constants[] 	= 	'{'.$val.'}';
    			}
          
    			//$subject 				= 	$emailTemplates[0]['subject'];
          $subject    =   "Bill For ".$monthName."-".$result->year;
    			$rep_Array 	= 	array($result->newspaper_agency_name,$full_name,$vendor_name,$monthName,$result->year,$formData['amount'],$costome_id,$click_link,$route_url);
    			$messageBody= 	str_replace($constants, $rep_Array, $emailTemplates[0]['body']);
    			$mail				= 	$this->sendMail($email,$full_name,$subject,$messageBody,$settingsEmail);

          return Response::json(["status"=>"success","message"=>"Bill sent"]);
        }else {
          return Response::json(["status"=>"error","message"=>"Something went wrong."]);
        }
      }else {
        return Response::json(["status"=>"success","message"=>"No Record Found"]);
      }

    }
  } // end

  /*
  * function to generate bill
  */
  public function regenerate_bill(Request $request)
  {
    $formData				=	Input::all();
    $validator = Validator::make($request->all(), [
        'user_id'     => 'required',
        'customer_id' => 'required',
        //'bill_id'     => 'required',
    ]);
    if ($validator->fails()) {
      $message = "Please fill all required fields.";
      $messages = $validator->errors()->getMessages();
      $messages = array_reverse($messages);
      foreach ($messages as $key => $value) {
        $message = $value[0];
      }
      return Response::json(["status"=>"error","message"=>$message]);
    }else {
      $response =array();
      $query = DB::table("customers_newspapers as cnp");
      $query->join('users as u','cnp.customer_id','=','u.id')
      ->select('cnp.*')
      ->where('u.is_deleted',INACTIVE)
      ->where('u.user_role_id', USER)
      ->where('u.active', ACTIVE)
      ->where('u.vendor_id', $formData['user_id'])
      ->where('u.id', $formData['customer_id'])
      ->where('cnp.is_deleted',INACTIVE)
      ->where('cnp.status', ACTIVE)
      ->where('cnp.start_date', '<=', date('Y-m-d')) // check paper start date
      ->orderBy('u.id', 'ASC');
      $newpaperData = $query->get();
      if (!empty($newpaperData)) {
        $customer_id = $formData['customer_id'];
        $vendor_id = $formData['user_id'];
        foreach ($newpaperData as $key => $value) {
        $last_billing_date_result = DB::table('last_billing_date')->where('customer_id',$customer_id)->where('newspaper_id',$value->newspaper_id)->orderBy('id','desc')->first();
        if (!empty($last_billing_date_result)) {
          $previous_bill_date = $last_billing_date_result->previous_bill_date;
        }
          if (isset($value->delivery_day_type) && $value->delivery_day_type == ALL_DAYS) {
            /*##############  Calculation of holidays start  ###############*/
            /*###### find stop delivery date #######*/
            $stop_delivery_query = DB::table("stop_newspaper_delivery as snd");
            $stop_delivery_query->join('stop_delivery_meta as sdm','snd.id','=','sdm.snd_id')
            ->join('users as u','snd.customer_id','=','u.id')
            ->select('sdm.from_date','sdm.to_date')
            ->where('snd.is_deleted',INACTIVE)
            ->where('snd.active', ACTIVE);
            if (isset($previous_bill_date) && !empty($previous_bill_date)) {
              $stop_delivery_query->where('sdm.from_date', '>=', $previous_bill_date);
            }else {
              $stop_delivery_query->where('sdm.from_date', '>=', $value->start_date);
            }
            $stop_delivery_query->where('sdm.to_date', '<=', date('Y-m-d'))
            ->where('u.id', $value->customer_id)
            ->where('u.vendor_id', $vendor_id)
            ->where('sdm.newspaper_id', $value->newspaper_id);
            $stop_delivery_result = $stop_delivery_query->get();
            $stop_delivery_date_array = array();
            if (count($stop_delivery_result)) {
              foreach ($stop_delivery_result as $stop_delivery_key => $stop_delivery_value) {
                $dates = CustomHelper::getDatesBwTwoDates($stop_delivery_value->from_date,$stop_delivery_value->to_date);
                if (!empty($dates)) {
                  foreach ($dates as $dates_key => $dates_value) {
                    array_push($stop_delivery_date_array,$dates_value);
                  }
                }
              }
            }
            /*###### find stop delivery date #######*/

            /*###### find holiday #######*/
            /*$holiday_query = DB::table("holidays as hd");
            $holiday_query->select('hd.from_date','hd.to_date','hd.type','hd.user_id')
            ->where('hd.is_deleted',INACTIVE);
            $holiday_query->where('hd.active', ACTIVE);
            if (isset($previous_bill_date) && !empty($previous_bill_date)) {
              $holiday_query->where('hd.from_date', '>=', $previous_bill_date);
            }else {
              $holiday_query->where('hd.from_date', '>=', $value->start_date);
            }
            $holiday_query->where('hd.to_date', '<=', date('Y-m-d'))
            ->where('hd.type', ACTIVE)
            ->where('hd.user_id', $vendor_id)
            ->orWhere('hd.newspaper_id', $value->newspaper_id);
            $holiday_result = $holiday_query->get();*/
            if (isset($previous_bill_date) && !empty($previous_bill_date)) {
              $holiday_date_from = $previous_bill_date;
            }else {
              $holiday_date_from = $value->start_date;
            }
            $holiday_result = DB::select("select `hd`.`from_date`, `hd`.`to_date`, `hd`.`type`, `hd`.`user_id` from `holidays` as `hd` where `hd`.`is_deleted` = 0 and `hd`.`active` = 1 and `hd`.`from_date` >= '".$holiday_date_from."' and `hd`.`to_date` <= '".date('Y-m-d')."' and (`hd`.`type` = 1 or (`hd`.`type` = 2 AND `hd`.`user_id` = ".$vendor_id." AND `hd`.`newspaper_id` = ".$value->newspaper_id.") OR (`hd`.`type` = 3 AND `hd`.`user_id` = ".$vendor_id."))");

            $holiday_date_array = array();
            $total_holiday_array = array();
            if (count($holiday_result)) {
              foreach ($holiday_result as $holiday_key => $holiday_value) {
                $dates = CustomHelper::getDatesBwTwoDates($holiday_value->from_date,$holiday_value->to_date);
                if (!empty($dates)) {
                  foreach ($dates as $dates_key => $dates_value) {
                    array_push($holiday_date_array,$dates_value);
                  }
                }
              }
            }
            /*###### find holiday #######*/
          // get date array b/w start and today
          if (isset($previous_bill_date) && !empty($previous_bill_date)) {
            $begin = new \DateTime($previous_bill_date);
          }else {
            $begin = new \DateTime($value->start_date);
          }
          $end = new \DateTime(date("Y-m-d"));
          $end = $end->modify('+1 day');

          $interval = new \DateInterval('P1D');
          $daterange = new \DatePeriod($begin, $interval ,$end);
          $total_holidays = array();
          $total_days = array();
          foreach($daterange as $date){
            $date = $date->format("Y-m-d");
            array_push($total_days,$date);
          }

          // get total holiday = stop delivery days + holidays
          $total_holidays = array_unique(array_merge($stop_delivery_date_array, $holiday_date_array));
          $total_holidays = array_values($total_holidays);
          //pr($total_holidays);die;
          // find intersect of both array
          $grand_total_holidays_days = array();
          $grand_total_holidays_days = array_intersect($total_holidays, $total_days);
          // re-order keys
          $grand_total_holidays_days = array_values($grand_total_holidays_days);
          // total working days
          $total_working_days=array_diff($total_days,$grand_total_holidays_days);
          $total_working_days = array_values($total_working_days);
          $count_total_days = count($total_days);

          $newpaperData[$key]->total_days = serialize($total_days);
          $newpaperData[$key]->holidays = serialize($grand_total_holidays_days);
          /*##############  Calculation of holidays end  ###############*/

            if (isset($value->paper_data) && !empty($value->paper_data)) {
              $paper_data = unserialize($value->paper_data);
            }
            $holiday_price_sum = 0;
            if (count($grand_total_holidays_days)) {
              foreach ($grand_total_holidays_days as $holi_key => $holi_value) {
                $day_name =  date('D', strtotime($holi_value));
                switch ($day_name) {
                  case "Sun":
                      $holiday_price_sum += $this->getDayPrice($paper_data,1);
                      break;
                  case "Mon":
                      $holiday_price_sum += $this->getDayPrice($paper_data,2);
                      break;
                  case "Tue":
                      $holiday_price_sum += $this->getDayPrice($paper_data,3);
                      break;
                  case "Wed":
                      $holiday_price_sum += $this->getDayPrice($paper_data,4);
                      break;
                  case "Thu":
                      $holiday_price_sum += $this->getDayPrice($paper_data,5);
                      break;
                  case "Fri":
                      $holiday_price_sum += $this->getDayPrice($paper_data,6);
                      break;
                  case "Sat":
                      $holiday_price_sum += $this->getDayPrice($paper_data,7);
                      break;
                }
              }
            }
            $total_price_sum = 0;
            if (count($total_days)) {
              foreach ($total_days as $total_key => $total_value) {
                $day_name =  date('D', strtotime($total_value));
                switch ($day_name) {
                  case "Sun":
                      $total_price_sum += $this->getDayPrice($paper_data,1);
                      break;
                  case "Mon":
                      $total_price_sum += $this->getDayPrice($paper_data,2);
                      break;
                  case "Tue":
                      $total_price_sum += $this->getDayPrice($paper_data,3);
                      break;
                  case "Wed":
                      $total_price_sum += $this->getDayPrice($paper_data,4);
                      break;
                  case "Thu":
                      $total_price_sum += $this->getDayPrice($paper_data,5);
                      break;
                  case "Fri":
                      $total_price_sum += $this->getDayPrice($paper_data,6);
                      break;
                  case "Sat":
                      $total_price_sum += $this->getDayPrice($paper_data,7);
                      break;
                }
              }
            }
            // check paper for coupon type and set amount zero for that
            if (isset($value->payment_option) && $value->payment_option == 2) {
              $total_price_sum = 0;
              $holiday_price_sum = 0;
            }

            $newpaperData[$key]->monthly_paper_bill = ($total_price_sum*$value->qty) - $holiday_price_sum;
            $newpaperData[$key]->holiday_price_sum = $holiday_price_sum;
          }elseif (isset($value->delivery_day_type) && $value->delivery_day_type == SPECIFIC_DAYS) {
            $paper_data = unserialize($value->paper_data);
            // get date array b/w start and today
            if (isset($previous_bill_date) && !empty($previous_bill_date)) {
              $begin = new \DateTime($previous_bill_date);
            }else {
              $begin = new \DateTime($value->start_date);
            }
            $end = new \DateTime(date('Y-m-d'));
            $end = $end->modify('+1 day');

            $interval = new \DateInterval('P1D');
            $daterange = new \DatePeriod($begin, $interval ,$end);
            $total_days = array();
            if (!empty($daterange)) {
              foreach($daterange as $date){
                $date = $date->format("Y-m-d");
                array_push($total_days,$date);
              }
            }

            $total_price_sum = 0;
            if (count($total_days)) {
              foreach ($total_days as $total_key => $total_value) {
                $day_name =  date('D', strtotime($total_value));
                switch ($day_name) {
                  case "Sun":
                      $total_price_sum += $this->getDayPrice($paper_data,1);
                      break;
                  case "Mon":
                      $total_price_sum += $this->getDayPrice($paper_data,2);
                      break;
                  case "Tue":
                      $total_price_sum += $this->getDayPrice($paper_data,3);
                      break;
                  case "Wed":
                      $total_price_sum += $this->getDayPrice($paper_data,4);
                      break;
                  case "Thu":
                      $total_price_sum += $this->getDayPrice($paper_data,5);
                      break;
                  case "Fri":
                      $total_price_sum += $this->getDayPrice($paper_data,6);
                      break;
                  case "Sat":
                      $total_price_sum += $this->getDayPrice($paper_data,7);
                      break;
                }
              }
            }
            if (isset($value->payment_option) && $value->payment_option == 2) {
              $total_price_sum = 0;
            }
            $newpaperData[$key]->per_paper_bill_amount = $total_price_sum;
            $newpaperData[$key]->monthly_paper_bill = $total_price_sum;
          }elseif (isset($value->delivery_day_type) && $value->delivery_day_type == WEEKLY) {
            //echo 3333;die;
            if (isset($value->paper_data) && !empty($value->paper_data)) {
              // check paper for coupon type and set amount zero for that
              if (isset($value->payment_option) && $value->payment_option == 2) {
                $per_paper_bill_amount = 0;
              }else {
                $paper_data = unserialize($value->paper_data);
                $per_paper_bill_amount =0;
                foreach ($paper_data as $paper_data_key => $paper_data_value) {
                  $per_paper_bill_amount += ($paper_data_value->price*$value->qty);
                }
              }
              $newpaperData[$key]->per_paper_bill_amount = $per_paper_bill_amount;
              $newpaperData[$key]->monthly_paper_bill = $per_paper_bill_amount*4;
            }
          }elseif (isset($value->delivery_day_type) && $value->delivery_day_type == ONCE_IN_MONTH) {
            //echo 444;die;
            if (isset($value->paper_data) && !empty($value->paper_data)) {
              // check paper for coupon type and set amount zero for that
              if (isset($value->payment_option) && $value->payment_option == 2) {
                $per_paper_bill_amount = 0;
              }else {
                $paper_data = unserialize($value->paper_data);
                //pr($paper_data);die;
                $per_paper_bill_amount =0;
                foreach ($paper_data as $paper_data_key => $paper_data_value) {
                  $per_paper_bill_amount += ($paper_data_value->price*$value->qty);
                }
              }
              $newpaperData[$key]->per_paper_bill_amount = $per_paper_bill_amount;
              $newpaperData[$key]->monthly_paper_bill = $per_paper_bill_amount*1;
            }
          }elseif (isset($value->delivery_day_type) && $value->delivery_day_type == TWICE_IN_MONTH) {
            //echo 555;die;
            if (isset($value->paper_data) && !empty($value->paper_data)) {
              // check paper for coupon type and set amount zero for that
              if (isset($value->payment_option) && $value->payment_option == 2) {
                $per_paper_bill_amount = 0;
              }else {
                $paper_data = unserialize($value->paper_data);
                $per_paper_bill_amount =0;
                foreach ($paper_data as $paper_data_key => $paper_data_value) {
                  $per_paper_bill_amount += ($paper_data_value->price*$value->qty);
                }
              }
              $newpaperData[$key]->per_paper_bill_amount = $per_paper_bill_amount;
              $newpaperData[$key]->monthly_paper_bill = $per_paper_bill_amount*1;
            }
          }

          $previous_date = date('d-m-Y');
          $dateArray = date_parse_from_format('d-m-Y', $previous_date);

         $current_month = $dateArray["month"];
         $current_year = $dateArray["year"];
          if (!empty($last_billing_date_result)) {
            $insert_last_bill_data = array(
              'month'=> $current_month,
              'year'=> $current_year,
              'previous_bill_date'=> date("Y-m-d", strtotime("+1 day")),
              'updated_at'=> date('Y-m-d H:i:s'),
            );
            DB::table('last_billing_date')->where("customer_id",$value->customer_id)->where('newspaper_id',$value->newspaper_id)->update($insert_last_bill_data);
          }else{
            $insert_last_bill_data = array(
              'customer_id'=> $value->customer_id,
              'newspaper_id'=> $value->newspaper_id,
              'month'=> $current_month,
              'year'=> $current_year,
              'previous_bill_date'=> date("Y-m-d", strtotime("+1 day")),
              'created_at'=> date('Y-m-d H:i:s'),
              'updated_at'=> date('Y-m-d H:i:s'),
            );
            DB::table('last_billing_date')->insert($insert_last_bill_data);
          }
          $check_bill = DB::table('monthly_bill')
                        ->where('customer_id',$value->customer_id)
                        ->where('newspaper_id',$value->newspaper_id)
                        ->where('month',$current_month)
                        ->where('year',$current_year)
                        ->first();
          if (!empty($check_bill)) {
            $updateMonthlyBill = array(
              'total_bill_amount'=> $check_bill->total_bill_amount + $value->monthly_paper_bill,
              'delivery_day_type'=> $value->delivery_day_type,
              'is_coupon_type'=> $value->payment_option,
              'total_coupons'=> $value->total_coupon,
              'total_days'=> $value->total_days ?? serialize(array()),
              'holidays'=> $value->holidays ?? serialize(array()),
              'updated_at'=> date('Y-m-d H:i:s'),
            );
            DB::table('monthly_bill')
            ->where('customer_id',$value->customer_id)
            ->where('newspaper_id',$value->newspaper_id)
            ->where('month',$current_month)
            ->where('year',$current_year)->update($updateMonthlyBill);
            // Call the store procedure for update billings
            $ress= DB::select('call regenerate_bill(?,?,?,?)',array($value->customer_id,$value->monthly_paper_bill,$current_month,$current_year));
          }else {
            $insertMonthlyBill[] = array(
              'customer_id'=> $value->customer_id,
              'newspaper_id'=> $value->newspaper_id,
              'month'=> $current_month,
              'year'=> $current_year,
              'total_bill_amount'=> $value->monthly_paper_bill,
              'delivery_day_type'=> $value->delivery_day_type,
              'is_coupon_type'=> $value->payment_option,
              'total_coupons'=> $value->total_coupon,
              'total_days'=> $value->total_days ?? serialize(array()),
              'holidays'=> $value->holidays ?? serialize(array()),
              'created_at'=> date('Y-m-d H:i:s'),
            );
          }
        } // end foreach
        if (isset($insertMonthlyBill) && !empty($insertMonthlyBill)) {
          DB::table('monthly_bill')->insert($insertMonthlyBill);
        }
        return Response::json(["status"=>"success","message"=>"Bill regenerated successful"]);
      }else {
        return Response::json(["status"=>"error","message"=>"No Record Found"]);
      }
    }
  } // end
  /*
  * function to generate bill
  */
  public function regenerate_bill_latest(Request $request)
  {
    $formData				=	Input::all();
    $validator = Validator::make($request->all(), [
        'user_id'     => 'required',
        'customer_id' => 'required',
        //'bill_id'     => 'required',
    ]);
    if ($validator->fails()) {
      $message = "Please fill all required fields.";
      $messages = $validator->errors()->getMessages();
      $messages = array_reverse($messages);
      foreach ($messages as $key => $value) {
        $message = $value[0];
      }
      return Response::json(["status"=>"error","message"=>$message]);
    }else {
        $response =array();
        $query = DB::table("customers_newspapers as cnp");
        $query->join('users as u','cnp.customer_id','=','u.id')
        ->select('cnp.*')
        ->where('u.is_deleted',INACTIVE)
        ->where('u.user_role_id', USER)
        ->where('u.active', ACTIVE)
        ->where('cnp.is_deleted',INACTIVE)
        ->where('cnp.status', ACTIVE)
        ->where('u.id', $formData['customer_id'])
        //->where('cnp.start_date', '<=', date('Y-m-d', strtotime("-".BILLING_CYCLE." days"))) // check atleast 30 days interval
        //->whereRaw("DAY(start_date) = DAY(CURDATE())") // check current day
        ->orderBy('u.id', 'ASC');
        $newpaperData = $query->get();
        if (!empty($newpaperData)) {
          foreach ($newpaperData as $key => $value) {
            $vendor_id = $formData['user_id'];
            if ($vendor_id) {
              /*###### find stop delivery date #######*/
              $stop_delivery_query = DB::table("stop_newspaper_delivery as snd");
              $stop_delivery_query->join('stop_delivery_meta as sdm','snd.id','=','sdm.snd_id')
              ->join('users as u','snd.customer_id','=','u.id')
              ->select('sdm.from_date','sdm.to_date')
              ->where('snd.is_deleted',INACTIVE)
              ->where('snd.active', ACTIVE)
              ->where('sdm.from_date', '>=', $value->start_date);
              $stop_delivery_query->where('sdm.to_date', '<=', date('Y-m-d'))
              ->where('u.id', $value->customer_id)
              ->where('u.vendor_id', $vendor_id)
              ->where('sdm.newspaper_id', $value->newspaper_id);
              $stop_delivery_result = $stop_delivery_query->get();

              $stop_delivery_date_array = array();
              if (count($stop_delivery_result)) {
                foreach ($stop_delivery_result as $stop_delivery_key => $stop_delivery_value) {
                  $dates = CustomHelper::getDatesBwTwoDates($stop_delivery_value->from_date,$stop_delivery_value->to_date);
                  if (!empty($dates)) {
                    foreach ($dates as $dates_key => $dates_value) {
                      array_push($stop_delivery_date_array,$dates_value);
                    }
                  }
                }
              }
              /*###### find stop delivery date #######*/

              /*###### find holiday #######*/
              $holiday_query = DB::table("holidays as hd");
              $holiday_query->select('hd.from_date','hd.to_date','hd.type','hd.user_id')
              ->where('hd.is_deleted',INACTIVE)
              ->where('hd.active', ACTIVE)
              ->where('hd.from_date', '>=', $value->start_date)
              ->where('hd.to_date', '<=', date('Y-m-d'))
              ->where('hd.user_id', $vendor_id)
              ->where('hd.type', ACTIVE)
              ->where('hd.newspaper_id', $value->newspaper_id);
              $holiday_result = $holiday_query->get();

              $holiday_date_array = array();
              $total_holiday_array = array();
              if (count($holiday_result)) {
                foreach ($holiday_result as $holiday_key => $holiday_value) {
                  $dates = CustomHelper::getDatesBwTwoDates($holiday_value->from_date,$holiday_value->to_date);
                  if (!empty($dates)) {
                    foreach ($dates as $dates_key => $dates_value) {
                      array_push($holiday_date_array,$dates_value);
                    }
                  }
                }
              }
              /*###### find holiday #######*/
            }
            // get date array b/w start and today
            //$begin = new \DateTime($value->start_date); // earlier was this for new bill
            $begin = new \DateTime($value->start_date); // now this for previous bill date and today
            $end = new \DateTime(date('Y-m-d'));
            $end = $end->modify( '+1 day' );

            $interval = new \DateInterval('P1D');
            $daterange = new \DatePeriod($begin, $interval ,$end);
            $total_holidays = array();
            $total_days = array();
            foreach($daterange as $date){
              $date = $date->format("Y-m-d");
              array_push($total_days,$date);
            }
            // get total holiday = stop delivery days + holidays
            $total_holidays = array_unique(array_merge($stop_delivery_date_array, $holiday_date_array));
            $total_holidays = array_values($total_holidays);

            // find intersect of both array
            $grand_total_holidays_days = array();
            $grand_total_holidays_days = array_intersect($total_holidays, $total_days);
            // re-order keys
            $grand_total_holidays_days = array_values($grand_total_holidays_days);
            // total working days
            $total_working_days=array_diff($total_days,$grand_total_holidays_days);
            $total_working_days = array_values($total_working_days);
            $count_total_days = count($total_days);

            $newpaperData[$key]->total_days = serialize($total_days);
            $newpaperData[$key]->holidays = serialize($grand_total_holidays_days);

            if (isset($value->delivery_day_type) && $value->delivery_day_type == ALL_DAYS) {
              if (isset($value->paper_data) && !empty($value->paper_data)) {
                $paper_data = unserialize($value->paper_data);
                $per_paper_bill_amount =0;
                foreach ($paper_data as $paper_data_key => $paper_data_value) {
                  $per_paper_bill_amount += ($paper_data_value->price*$value->qty);
                }
                $newpaperData[$key]->per_paper_bill_amount = $per_paper_bill_amount;
                $newpaperData[$key]->monthly_paper_bill = $per_paper_bill_amount*$count_total_days;
              }
              $get_day_price = $this->getDayPrice($paper_data,1);
              $holiday_price_sum = 0;
              if (count($grand_total_holidays_days)) {
                foreach ($grand_total_holidays_days as $holi_key => $holi_value) {
                  $day_name =  date('D', strtotime($holi_value));
                  switch ($day_name) {
                    case "Sun":
                        $holiday_price_sum += $this->getDayPrice($paper_data,1);
                        break;
                    case "Mon":
                        $holiday_price_sum += $this->getDayPrice($paper_data,2);
                        break;
                    case "Tue":
                        $holiday_price_sum += $this->getDayPrice($paper_data,3);
                        break;
                    case "Wed":
                        $holiday_price_sum += $this->getDayPrice($paper_data,4);
                        break;
                    case "Thu":
                        $holiday_price_sum += $this->getDayPrice($paper_data,5);
                        break;
                    case "Fri":
                        $holiday_price_sum += $this->getDayPrice($paper_data,6);
                        break;
                    case "Sat":
                        $holiday_price_sum += $this->getDayPrice($paper_data,7);
                        break;
                  }
                }
              }
              $total_price_sum = 0;
              if (count($total_days)) {
                foreach ($total_days as $total_key => $total_value) {
                  $day_name =  date('D', strtotime($total_value));
                  switch ($day_name) {
                    case "Sun":
                        $total_price_sum += $this->getDayPrice($paper_data,1);
                        break;
                    case "Mon":
                        $total_price_sum += $this->getDayPrice($paper_data,2);
                        break;
                    case "Tue":
                        $total_price_sum += $this->getDayPrice($paper_data,3);
                        break;
                    case "Wed":
                        $total_price_sum += $this->getDayPrice($paper_data,4);
                        break;
                    case "Thu":
                        $total_price_sum += $this->getDayPrice($paper_data,5);
                        break;
                    case "Fri":
                        $total_price_sum += $this->getDayPrice($paper_data,6);
                        break;
                    case "Sat":
                        $total_price_sum += $this->getDayPrice($paper_data,7);
                        break;
                  }
                }
              }
              $newpaperData[$key]->monthly_paper_bill = $total_price_sum - $holiday_price_sum;
              $newpaperData[$key]->holiday_price_sum = $holiday_price_sum;
            }elseif (isset($value->delivery_day_type) && $value->delivery_day_type == SPECIFIC_DAYS) {
              //echo 22;die;
            }elseif (isset($value->delivery_day_type) && $value->delivery_day_type == WEEKLY) {
              if (isset($value->paper_data) && !empty($value->paper_data)) {
                $paper_data = unserialize($value->paper_data);
                $per_paper_bill_amount =0;
                foreach ($paper_data as $paper_data_key => $paper_data_value) {
                  $per_paper_bill_amount += ($paper_data_value->price*$value->qty);
                }
                $newpaperData[$key]->per_paper_bill_amount = $per_paper_bill_amount;
                $newpaperData[$key]->monthly_paper_bill = $per_paper_bill_amount*4;
              }
            }elseif (isset($value->delivery_day_type) && $value->delivery_day_type == ONCE_IN_MONTH) {
              if (isset($value->paper_data) && !empty($value->paper_data)) {
                $paper_data = unserialize($value->paper_data);
                //pr($paper_data);die;
                $per_paper_bill_amount =0;
                foreach ($paper_data as $paper_data_key => $paper_data_value) {
                  $per_paper_bill_amount += ($paper_data_value->price*$value->qty);
                }
                $newpaperData[$key]->per_paper_bill_amount = $per_paper_bill_amount;
                $newpaperData[$key]->monthly_paper_bill = $per_paper_bill_amount*1;
              }
            }elseif (isset($value->delivery_day_type) && $value->delivery_day_type == TWICE_IN_MONTH) {
              if (isset($value->paper_data) && !empty($value->paper_data)) {
                $paper_data = unserialize($value->paper_data);
                $per_paper_bill_amount =0;
                foreach ($paper_data as $paper_data_key => $paper_data_value) {
                  $per_paper_bill_amount += ($paper_data_value->price*$value->qty);
                }
                $newpaperData[$key]->per_paper_bill_amount = $per_paper_bill_amount;
                $newpaperData[$key]->monthly_paper_bill = $per_paper_bill_amount*1;
              }
            }
            //$date = date('d-m-Y',strtotime('-1 day'));
            $date = date('d-m-Y');
            $dateArray = date_parse_from_format('d-m-Y', $date);
            $check_bill = DB::table('monthly_bill')
                          ->where('customer_id',$value->customer_id)
                          ->where('newspaper_id',$value->newspaper_id)
                          ->where('month',$dateArray['month'])
                          ->where('year',$dateArray['year'])
                          ->first();
            //pr($check_bill);die;
            if (!empty($check_bill)) {
              $updateMonthlyBill = array(
                'total_bill_amount'=> $value->monthly_paper_bill,
                'delivery_day_type'=> $value->delivery_day_type,
                'is_coupon_type'=> $value->payment_option,
                'total_coupons'=> $value->total_coupon,
                'total_days'=> $value->total_days,
                'holidays'=> $value->holidays,
                'updated_at'=> date('Y-m-d H:i:s'),
              );

              DB::table('monthly_bill')
              ->where('customer_id',$value->customer_id)
              ->where('newspaper_id',$value->newspaper_id)
              ->where('month',$dateArray['month'])
              ->where('year',$dateArray['year'])->update($updateMonthlyBill);
            }else {
              $insertMonthlyBill[] = array(
                'customer_id'=> $value->customer_id,
                'newspaper_id'=> $value->newspaper_id,
                'month'=> $dateArray['month'],
                'year'=> $dateArray['year'],
                'total_bill_amount'=> $value->monthly_paper_bill,
                'delivery_day_type'=> $value->delivery_day_type,
                'is_coupon_type'=> $value->payment_option,
                'total_coupons'=> $value->total_coupon,
                'total_days'=> $value->total_days,
                'holidays'=> $value->holidays,
                'created_at'=> date('Y-m-d H:i:s'),
              );
            }
            $check_bill = DB::table('last_billing_date')
                          ->where('customer_id',$value->customer_id)
                          ->where('month',$dateArray['month'])
                          ->where('year',$dateArray['year'])
                          ->orderBy('id','desc')
                          ->first();
            if (!empty($check_bill)) {
              $updateMonthlyBill = array(
                'month'=> $dateArray['month'],
                'year'=> $dateArray['year'],
                'previous_bill_date'=> date('Y-m-d'),
                'updated_at'=> date('Y-m-d H:i:s'),
              );
              DB::table('monthly_bill')
              ->where('customer_id',$value->customer_id)
              ->where('newspaper_id',$value->newspaper_id)
              ->where('month',$dateArray['month'])
              ->where('year',$dateArray['year'])->update($updateMonthlyBill);
            }
          } // end foreach
          /*$summedArray = array();
          foreach ($newpaperData as $key => $value) {
            if(isset($summedArray[$value->customer_id])) {
              $summedArray[$value->customer_id] += $value->monthly_paper_bill;
            } else {
              $summedArray[$value->customer_id] = $value->monthly_paper_bill;
            }
          }*/
          //pr($insertMonthlyBill);die;
          //$response = $newpaperData;
          if (isset($insertMonthlyBill) && !empty($insertMonthlyBill)) {
            DB::table('monthly_bill')->insert($insertMonthlyBill);
          }
          return Response::json(["status"=>"success","data"=>$response]);
        }
    }
  } // end

  /*
  * function to get particular day price
  */
  public function getDayPrice($paper_data,$day_number)
  {
    $price = 0;
    if (count($paper_data)) {
      foreach ($paper_data as $key => $value) {

        if (isset($value->day) && $value->day == $day_number) {
          //pr($value);
          return $value->price;
        }
      }
    }else {
      return $price;
    }
  } // end

  /*
  * get bill detail
  */
  public function bill_detail(Request $request)
  {
    $formData				=	Input::all();
    $validator = Validator::make($request->all(), [
        'user_id'     => 'required',
        'customer_id' => 'required',
        'bill_id'     => 'required',
    ]);
    if ($validator->fails()) {
      $message = "Please fill all required fields.";
      $messages = $validator->errors()->getMessages();
      $messages = array_reverse($messages);
      foreach ($messages as $key => $value) {
        $message = $value[0];
      }
      return Response::json(["status"=>"error","message"=>$message]);
    }else {
      $response = array();
      $language_id = $formData['language_id'] ?? Config::get('default_language.language_code');
      $result  = DB::table('billings as bil')
              ->join('users as u','bil.customer_id','=','u.id')
              ->join('address as add','u.address_id','=','add.id')
              ->where('bil.id',$formData['bill_id'])
              ->where('u.vendor_id',$formData['user_id'])
              ->where('bil.customer_id',$formData['customer_id'])
              ->select('bil.*','u.full_name','u.flat_number','u.phone','u.email','add.address_name')
              ->first();
      if (!empty($result)) {
        $monthly_bill = DB::table('monthly_bill as mb')
                      ->join('dropdown_managers as dm','mb.newspaper_id','=','dm.id')
                      ->join('dropdown_manager_descriptions as dmd','dm.id','=','dmd.parent_id')
                      ->where("dm.dropdown_type","newspapers")
                      ->where('dm.status',ACTIVE)
                      ->where('dmd.language_id',$language_id)
                      ->where('mb.customer_id',$formData['customer_id'])
                      ->where('mb.month',$result->month)
                      ->where('mb.year',$result->year)
                      ->select('mb.total_bill_amount','mb.is_coupon_type','dmd.name as newspaper_name')
                      ->get();
        $result->newpaperData = $monthly_bill ?? array();
        $response['result'] = $result;
        //pr($response);die;
        return Response::json(["status"=>"success","data"=>$response]);
      }else {
        return Response::json(["status"=>"error","message"=>"No Record Found"]);
      }
    }
  } // end bill_detail

  /*
  * get bill history
  */
  public function bill_history(Request $request)
  {
    $formData				=	Input::all();
    $validator = Validator::make($request->all(), [
        'user_id'     => 'required',
        'customer_id' => 'required',
        'bill_id'     => 'required',
    ]);
    if ($validator->fails()) {
      $message = "Please fill all required fields.";
      $messages = $validator->errors()->getMessages();
      $messages = array_reverse($messages);
      foreach ($messages as $key => $value) {
        $message = $value[0];
      }
      return Response::json(["status"=>"error","message"=>$message]);
    }else {
      $response = array();
      $language_id = $formData['language_id'] ?? Config::get('default_language.language_code');
      $result  = DB::table('billings as bil')
              ->join('users as u','bil.customer_id','=','u.id')
              ->join('address as add','u.address_id','=','add.id')
              ->where('bil.id',$formData['bill_id'])
              ->where('u.vendor_id',$formData['user_id'])
              ->where('bil.customer_id',$formData['customer_id'])
              ->select('bil.*','u.full_name','u.flat_number','u.phone','u.email','add.address_name')
              ->first();
      if (!empty($result)) {
        $monthly_bill = DB::table('monthly_bill as mb')
                      ->join('dropdown_managers as dm','mb.newspaper_id','=','dm.id')
                      ->join('dropdown_manager_descriptions as dmd','dm.id','=','dmd.parent_id')
                      ->where("dm.dropdown_type","newspapers")
                      ->where('dm.status',ACTIVE)
                      ->where('dmd.language_id',$language_id)
                      ->where('mb.customer_id',$formData['customer_id'])
                      ->where('mb.month',$result->month)
                      ->where('mb.year',$result->year)
                      ->select('mb.total_bill_amount','mb.is_coupon_type','dmd.name as newspaper_name')
                      ->get();
        $result->newpaperData = $monthly_bill ?? array();
        $response['result'] = $result;
        //pr($response);die;
        return Response::json(["status"=>"success","data"=>$response]);
      }else {
        return Response::json(["status"=>"error","message"=>"No Record Found"]);
      }
    }
  } // end bill_history

  /*
  * get issue list
  */
  public function get_issues(Request $request)
  {
    $formData				=	Input::all();
    $validator = Validator::make($request->all(), [
        'user_id'     => 'required',
        'customer_id' => 'required',
        'bill_id'     => 'required',
    ]);
    if ($validator->fails()) {
      $message = "Please fill all required fields.";
      $messages = $validator->errors()->getMessages();
      $messages = array_reverse($messages);
      foreach ($messages as $key => $value) {
        $message = $value[0];
      }
      return Response::json(["status"=>"error","message"=>$message]);
    }else {
      $response = array();
      $language_id = $formData['language_id'] ?? Config::get('default_language.language_code');
      $result  = DB::table('billings as bil')
              ->join('users as u','bil.customer_id','=','u.id')
              ->join('address as add','u.address_id','=','add.id')
              ->where('bil.id',$formData['bill_id'])
              ->where('u.vendor_id',$formData['user_id'])
              ->where('bil.customer_id',$formData['customer_id'])
              ->select('bil.*','u.full_name','u.flat_number','u.phone','u.email','add.address_name')
              ->first();
      if (!empty($result)) {
        $monthly_bill = DB::table('issues as is')
                      ->select('is.id as issue_id','is.title')
                      ->get();
        $result->issueList = $monthly_bill ?? array();
        $response['result'] = $result;
        //pr($response);die;
        return Response::json(["status"=>"success","data"=>$response]);
      }else {
        return Response::json(["status"=>"error","message"=>"No Record Found"]);
      }
    }
  } // end get_issues

  /*
  * report problem
  */
  public function report_problem(Request $request)
  {
    $formData				=	Input::all();
    $validator      = Validator::make($request->all(), [
      'user_id'     => 'required',
      'customer_id' => 'required',
      'bill_id'     => 'required',
      'issue_id'    => 'required',
    ]);
    if ($validator->fails()) {
      $message = "Please fill all required fields.";
      $messages = $validator->errors()->getMessages();
      $messages = array_reverse($messages);
      foreach ($messages as $key => $value) {
        $message = $value[0];
      }
      return Response::json(["status"=>"error","message"=>$message]);
    }else {
      $response = array();
      $result  = DB::table('billings as bil')
              ->join('users as u','bil.customer_id','=','u.id')
              ->where('bil.id',$formData['bill_id'])
              ->where('u.vendor_id',$formData['user_id'])
              ->where('bil.customer_id',$formData['customer_id'])
              ->select('bil.*')
              ->first();
      if (!empty($result)) {
        $report               = new ReportProblem;
        $report->bill_id      = $formData['bill_id'];
        $report->customer_id  = $formData['customer_id'];
        $report->issue_id     = $formData['issue_id'] ?? 0;
        $report->description  = $formData['description'] ?? "";
        $report->month        = $result->month;
        $report->year         = $result->year;
        $report->amount       = $result->total_amount;
        $report->save();
        return Response::json(["status"=>"success","message"=>"Report has successfully sent,we will check and update you."]);
      }else {
        return Response::json(["status"=>"error","message"=>"No Record Found"]);
      }
    }
  } // end report_problem
  /*
  * get bank transfer list
  */
  public function bank_transfer(Request $request)
  {
    $formData				=	Input::all();
    $validator = Validator::make($request->all(), [
        'user_id'     => 'required',
        'is_today'     => 'required',
    ]);
    if ($validator->fails()) {
      $message = "Please fill all required fields.";
      $messages = $validator->errors()->getMessages();
      $messages = array_reverse($messages);
      foreach ($messages as $key => $value) {
        $message = $value[0];
      }
      return Response::json(["status"=>"error","message"=>$message]);
    }else {
      $response = array();
      $query  = DB::table('payments as p')
              ->join('users as u','p.customer_id','=','u.id')
              ->where('u.vendor_id',$formData['user_id'])
              ->where('p.payment_mode',1);
              if (isset($formData['is_today']) && $formData['is_today']==1) {
                $query->whereDate('p.created_at',Carbon::today());
              }
        $result =   $query->select('p.id',DB::raw('p.amount*.97 as amount'),'p.payment_status','p.txn_id','p.created_at','u.full_name as customer_name')
              ->get();
      if (!empty($result)) {
        return Response::json(["status"=>"success","data"=>$result]);
      }else {
        return Response::json(["status"=>"error","message"=>"No Record Found"]);
      }
    }
  } // end bank_transfer

  /*
  * resend bill
  */
  public function resend_bill(Request $request)
  {
    $formData				=	Input::all();
    $validator = Validator::make($request->all(), [
        'user_id'     => 'required',
        'customer_id' => 'required',
        'bill_id'     => 'required',
        //'amount'      => 'required',
    ]);
    if ($validator->fails()) {
      $message = "Please fill all required fields.";
      $messages = $validator->errors()->getMessages();
      $messages = array_reverse($messages);
      foreach ($messages as $key => $value) {
        $message = $value[0];
      }
      return Response::json(["status"=>"error","message"=>$message]);
    }else {
      $response =array();
      $result  = DB::table('billings as bil')
              ->join('users as u','bil.customer_id','=','u.id')
              ->join('users as v','u.vendor_id','=','v.id')
              ->where('bil.id',$formData['bill_id'])
              ->where('u.vendor_id',$formData['user_id'])
              ->where('bil.customer_id',$formData['customer_id'])
              ->select('bil.*','u.full_name','v.full_name as vendor_name','v.newspaper_agency_name','u.phone','u.email')
              ->first();
      if (!empty($result)) {
        $obj = Billings::findOrFail($formData['bill_id']);
        if ($obj) {
          $dateObj   = \DateTime::createFromFormat('!m', $result->month);
          $monthName = $dateObj->format('F');
          $month_year = $monthName.'-'.$result->year;
          $random_string = Str::random();
          $URL = route('pay_bill',[$month_year,base64_encode($formData['customer_id']),$random_string]);
          // short the url
          $URL = CustomHelper::create_bitly_url($URL,'json');

          $obj2 = BillURL::where('bill_id',$formData['bill_id'])
                          ->where('month',$result->month)
                          ->where('year',$result->year)
                          ->where('is_expired',INACTIVE)
                          ->first();
          if (!empty($obj2)) {
            DB::table('bill_url')->where('bill_id',$formData['bill_id'])
                            ->where('month',$result->month)
                            ->where('year',$result->year)
                            ->where('is_expired',INACTIVE)
                            ->update(['is_expired'=>1]);
          }
          $obj2 = new BillURL;
          $obj2->bill_id = $formData['bill_id'];
          $obj2->month   = $result->month;
          $obj2->year    = $result->year;
          $obj2->customer_id    = $formData['customer_id'];
          $obj2->validate_string    = $random_string;
          $obj2->amount  = $result->due_amount;
          $obj2->url     = $URL;
          $obj2->save();

           //Set Customer Id
          $costome_id='C'.$formData['customer_id'].Str::random(3);
          //Get Vendor Phone No
          $vendor_result  = DB::table('users as u')
              ->where('u.id',$formData['user_id'])
              ->select('u.full_name','v.full_name as vendor_name','v.newspaper_agency_name','u.Phone','u.email')
              ->first();

          $click_link 			= '<a target="_blank" style="font-weight:bold;text-decoration:none;color:#4286f4;" href="' . $URL . '">Click Here</a>';
          /*######## send sms #########*/
          //$message =  "Your newspaper bill for ".$monthName."-".$result->year." is Rs ".$result->due_amount.". Your vendor is ".$result->vendor_name.". To pay online from mobile phone click on link ".$URL.".";
          $message = "Hi ".$result->full_name." ,<br> Your Newspaper bill for ".$monthName."-".$result->year." is Rs. ".$result->due_amount.".<br> Click on this link to pay online from your phone : ".$URL.". Id : ".$costome_id.".<br>  Thanks ".$result->newspaper_agency_name.".<br> For Customer support please contact : ".$vendor_result->phone.".<br> Powered by ".Config('Site.title')."";
          //echo $message;die;
          CustomHelper::send_sms($result->phone,$message);
          /*######## send sms #########*/

          // send mail to customer
          $settingsEmail 			=	Config::get('Site.email');
          $full_name				  =	$result->full_name;
          $vendor_name				=	$result->vendor_name;
          $email				      =	$result->email;
    			$route_url      		=  	$URL;
    			$link 					    =   $route_url;
    			//$click_link 			  = '<a target="_blank" style="font-weight:bold;text-decoration:none;color:#4286f4;" href="' . $link . '">Click Here</a>';
          $click_link = '<a target="_blank" href="' . $link . '" style=" display: inline-block; text-decoration: none;color:#fff">Pay Bill Now</a>';
    			$emailActions			   = 	EmailAction::where('action','=','send_bill')->get()->toArray();

    			$emailTemplates			= 	EmailTemplate::where('action','=','send_bill')
    											->get(array('name','subject','action','body'))->toArray();

    			$cons 					= 	explode(',',$emailActions[0]['options']);

    			$constants 				= 	array();

    			foreach($cons as $key => $val){
    				$constants[] 		= 	'{'.$val.'}';
    			}

    			//$subject 				= 	$emailTemplates[0]['subject'];
          $subject          =   "Bill Reminder For ".$monthName."-".$result->year;
    			$rep_Array 				= 	array($result->newspaper_agency_name,$full_name,$vendor_name,$monthName,$result->year,$result->due_amount,$click_link,$route_url,$result->newspaper_agency_name);
    			$messageBody			= 	str_replace($constants, $rep_Array, $emailTemplates[0]['body']);
          //pr($messageBody);die;
    			$mail					= 	$this->sendMail($email,$full_name,$subject,$messageBody,$settingsEmail);

          return Response::json(["status"=>"success","message"=>"Bill reminder sent"]);
        }else {
          return Response::json(["status"=>"error","message"=>"Something went wrong."]);
        }
      }else {
        return Response::json(["status"=>"success","message"=>"No Record Found"]);
      }

    }
  } // end resend_bill
  /*
  * get bill history list
  */
  public function history(Request $request)
  {
    $formData				=	Input::all();
    $validator = Validator::make($request->all(), [
        'user_id'         => 'required',
        'customer_id'     => 'required',
        //'bill_id'         => 'required',
    ]);
    if ($validator->fails()) {
      $message = "Please fill all required fields.";
      $messages = $validator->errors()->getMessages();
      $messages = array_reverse($messages);
      foreach ($messages as $key => $value) {
        $message = $value[0];
      }
      return Response::json(["status"=>"error","message"=>$message]);
    }else {
      $response = array();
      $bill_result = DB::table("billings")
                      ->where("customer_id",$formData["customer_id"])
                      ->orderBy('year','desc')
                      ->orderBy('month','desc')
                      ->groupBy(['year','month'])
                      ->take(12)
                      ->get();
                      //pr($bill_result);die;
      if (!empty($bill_result)) {
        foreach ($bill_result as $bill_key => $bill_value) {
          $payment_result  = DB::table('payments as p')
                  ->where("p.payment_status","Completed")
                  ->whereIn("p.payment_mode",[1,2,3]) // cash, online, bank
                  ->where("p.txn_type",2) // credit
                  ->where('p.customer_id',$bill_value->customer_id)
                  ->whereMonth("created_at",$bill_value->month)
                  ->whereYear("created_at",$bill_value->year)
                  ->sum("p.amount");
                  // $query = DB::getQueryLog();
                  // $query = end($query);
                  //  pr($query);die();
        $bill_result[$bill_key]->total_collection = $payment_result ?? 0;
                  //pr($payment_result);die;
        }
      }
      $response = $bill_result;
      if (!empty($response)) {
        return Response::json(["status"=>"success","data"=>$response]);
      }else {
        return Response::json(["status"=>"error","message"=>"No Record Found"]);
      }
    }
  } // end history

  /*
  * send bill to multiple customer
  */
  public function send_multiple_bill(Request $request)
  {
    $formData				=	Input::all();
    $validator = Validator::make($request->all(), [
        'user_id'     => 'required',
        'bill_data'     => 'required',
    ]);
    if ($validator->fails()) {
      $message = "Please fill all required fields.";
      $messages = $validator->errors()->getMessages();
      $messages = array_reverse($messages);
      foreach ($messages as $key => $value) {
        $message = $value[0];
      }
      return Response::json(["status"=>"error","message"=>$message]);
    }else {
      $response =array();
      $bill_data = json_decode($formData['bill_data']);
      //pr($bill_data);die;
      if (!empty($bill_data) && is_array($bill_data)) {
        foreach ($bill_data as $key => $value) {
          $result  = DB::table('billings as bil')
                  ->join('users as u','bil.customer_id','=','u.id')
                  ->join('users as v','u.vendor_id','=','v.id')
                  ->where('bil.id',$value->bill_id)
                  ->where('u.vendor_id',$formData['user_id'])
                  ->where('bil.customer_id',$value->customer_id)
                  ->select('bil.*','u.full_name','v.full_name as vendor_name','u.phone','u.email','v.newspaper_agency_name')
                  ->orderBy('bil.id','desc')
                  ->first();

          if (!empty($result)) {
            $obj = Billings::findOrFail($value->bill_id);
            if ($obj) {
              $dateObj   = \DateTime::createFromFormat('!m', $result->month);
              $monthName = $dateObj->format('F');
              $month_year = $monthName.'-'.$result->year;
              $random_string = Str::random();
              $URL = route('pay_bill',[$month_year,base64_encode($value->customer_id),$random_string]);
              $URL = CustomHelper::create_bitly_url($URL,'json');

              $obj2 = BillURL::where('bill_id',$value->bill_id)
                              ->where('month',$result->month)
                              ->where('year',$result->year)
                              ->where('is_expired',INACTIVE)
                              ->first();
              if (!empty($obj2)) {
                DB::table('bill_url')->where('bill_id',$value->bill_id)
                                ->where('month',$result->month)
                                ->where('year',$result->year)
                                ->where('is_expired',INACTIVE)
                                ->update(['is_expired'=>1]);
              }
              $obj2 = new BillURL;
              $obj2->bill_id = $value->bill_id;
              $obj2->month   = $result->month;
              $obj2->year    = $result->year;
              $obj2->customer_id    = $value->customer_id;
              $obj2->validate_string    = $random_string;
              $obj2->amount  = $result->total_amount;
              $obj2->url     = $URL;
              $obj2->save();

               //Set Customer Id
                $costome_id='C'.$value->customer_id.Str::random(3);
                //Get Vendor Phone No
                $vendor_result  = DB::table('users as u')
                    ->where('u.id',$formData['user_id'])
                    ->select('u.full_name','v.full_name as vendor_name','v.newspaper_agency_name','u.Phone','u.email')
                    ->first();

              DB::table('billings')->where('id',$value->bill_id)->where('customer_id',$value->customer_id)->update(['is_sent'=>ACTIVE]);

              $click_link 			= '<a target="_blank" style="font-weight:bold;text-decoration:none;color:#4286f4;" href="' . $URL . '">Click Here</a>';
              /*######## send sms #########*/
              // $message =  "Your newspaper bill for ".$monthName."-".$result->year." is Rs ".$result->total_amount.". Your vendor is ".$result->vendor_name.". To pay online from mobile phone click on link ".$URL.".";
              $message = "Hi ".$result->full_name." ,<br> Your Newspaper bill for ".$monthName."-".$result->year." is Rs. ".$result->total_amount.".<br> Click on this link to pay online from your phone : ".$URL.".<br> Id: ".$costome_id.".<br>  Thanks ".$result->newspaper_agency_name.".<br> For Customer support please contact : ".$vendor_result->Phone.".<br> Powered by ".Config('Site.title')."";
              //echo $message;die;
              CustomHelper::send_sms($result->phone,$message);
              /*######## send sms #########*/

              // send mail to customer
              $settingsEmail 			=	Config::get('Site.email');
              $full_name				  =	$result->full_name;
              $vendor_name				=	$result->vendor_name;
              $email				      =	$result->email;
        			$route_url      		=  	$URL;
        			$link 					    =   $route_url;

              $click_link = '<a target="_blank" href="' . $link . '" style=" display: inline-block; text-decoration: none;color:#fff">Pay Bill Now</a>';
              $emailActions        =  EmailAction::where('action','=','send_bill')->get()->toArray();

              $emailTemplates     =   EmailTemplate::where('action','=','send_bill')
                              ->get(array('name','subject','action','body'))->toArray();

              $cons           =   explode(',',$emailActions[0]['options']);

              $constants        =   array();

              foreach($cons as $key => $val){
                $constants[]    =   '{'.$val.'}';
              }

              //$subject        =   $emailTemplates[0]['subject'];
              $subject          =   "Bill Reminder For ".$monthName."-".$result->year;
              $rep_Array        =   array($result->newspaper_agency_name,$full_name,$vendor_name,$monthName,$result->year,$result->total_amount,$click_link,$route_url);
              $messageBody      =   str_replace($constants, $rep_Array, $emailTemplates[0]['body']);
              //pr($messageBody);die;
              $mail         =   $this->sendMail($email,$full_name,$subject,$messageBody,$settingsEmail);

            }
          }
        }
        return Response::json(["status"=>"success","message"=>"Bill Sent"]);
      }

    }
  } // end send_multiple_bill

} // end BillController class
