<?php

namespace App\Http\Controllers\Api\V1;

use App\Http\Controllers\Controller;
use App\Http\Controllers\BaseController;
use Illuminate\Http\Request;
use JWTFactory;
use JWTAuth;
use App\User;
use App\Model\OTP;
use App\Model\Address;
use App\Model\EmailAction;
use App\Model\EmailTemplate;
use App\libraries\CustomHelper;
use Str,Auth,Blade,Config,Cache,Cookie,DB,File,Hash,Input,Mail,Redirect,Response,Session,URL,View,Validator;
use Carbon\Carbon;

class CustomerController extends BaseController
{
  /*
  * add address
  */
  public function add_customer(Request $request)
  {
    $formData				=	Input::all();
    $message = array();
    $validate = array(
        'user_id'=> 'required',
        'address_id'=> 'required',
        'full_name'=> 'required',
        'flat_number'=>'required',
        //'email'=> "required|string|email|unique:users,email,NULL,id,is_deleted,0",
        //'phone'=> "required|integer|unique:users,phone,NULL,id,is_deleted,0",
        'delivery_charge'=>'required',
      );
    $validator = Validator::make(Input::all(),$validate,$message);
    if ($validator->fails()) {
      $message = "Please fill all required fields.";
      $messages = $validator->errors()->getMessages();
      $messages = array_reverse($messages);
      foreach ($messages as $key => $value) {
        $message = $value[0];
      }
      return Response::json(["status"=>"error","message"=>$message]);
    }else {
        $slug = $this->getSlug($formData['full_name'], 'slug','users',60);
        //pr($slug);die;
        $customer  = new User;
        $validateString				=	 md5(time() . Input::get('email'));
        $customer->validate_string	  =	  $validateString;
        $customer->full_name          = $formData['full_name'] ?? "";
        $customer->email              = $formData['email'] ?? "";
        $customer->phone              = $formData['phone'] ?? "";
        $customer->flat_number        = $formData['flat_number'] ?? "";
        $customer->delivery_charge    = $formData['delivery_charge'] ?? 0;
        $customer->address_id         = $formData['address_id'];
        $customer->vendor_id          = $formData['user_id'] ?? 0;
        $customer->is_billing_on      = $formData['is_billing_on'] ?? 1;
        $customer->payer_type         = $formData['payer_type'] ?? 0;
        $customer->slug			 		      =	$slug;
        $customer->user_role_id		    =  	USER;
        $customer->active				      =  	ACTIVE;
        $customer->is_verified			  =  	ACTIVE;
        $customer->phone_verify			  =  	ACTIVE;
        $customer->is_deleted			    =  	INACTIVE;
        $customer->save();
      if($customer){
        return Response::json(["status"=>"success","customer_id"=>$customer->id,"message"=>"Customer added successfully."]);
      }else {
        return Response::json(["status"=>"error","message"=>"Failed to save the record."]);
      }
    }
  } // end

  /*
  * get address for edit
  */
  public function get_customer(Request $request)
  {
    $formData       = Input::all();
    $message = array();
    $validate = array(
        'customer_id'=> 'required',
      );
    $validator = Validator::make(Input::all(),$validate,$message);
    if ($validator->fails()) {
      $message = "Please fill all required fields.";
      $messages = $validator->errors()->getMessages();
      $messages = array_reverse($messages);
      foreach ($messages as $key => $value) {
        $message = $value[0];
      }
      return Response::json(["status"=>"error","message"=>$message]);
    }else {
      $customer_id       = $formData['customer_id'];
      $customer  = User::findOrFail($customer_id);
      $response = $customer ?? array();
      return Response::json(["status"=>"success","data"=>$response]);
    }
  } // end

  /*
  * update address
  */
  public function update_customer(Request $request)
  {
    $formData       = Input::all();
    $customer_id = $formData['customer_id'];
    $message = array();
    $validate = array(
      'user_id'=> 'required',
      'address_id'=> 'required',
      'full_name'=> 'required',
      'flat_number'=>'required',
      //'email'=> "required|email|unique:users,email,$customer_id,id,is_deleted,0",
      //'phone'=> "required|integer|unique:users,phone,$customer_id,id,is_deleted,0",
      'delivery_charge'=>'required',
      );
    $validator = Validator::make(Input::all(),$validate,$message);
    if ($validator->fails()) {
      $message = "Please fill all required fields.";
      $messages = $validator->errors()->getMessages();
      $messages = array_reverse($messages);
      foreach ($messages as $key => $value) {
        $message = $value[0];
      }
      return Response::json(["status"=>"error","message"=>$message]);
    }else {
        $customer  = User::findOrFail($customer_id);
        $customer->full_name = $formData['full_name'] ?? "";
        $customer->email = $formData['email'] ?? "";
        $customer->phone = $formData['phone'] ?? "";
        $customer->flat_number = $formData['flat_number'] ?? "";
        $customer->delivery_charge = $formData['delivery_charge'] ?? 0;
        $customer->address_id = $formData['address_id'];
        $customer->vendor_id = $formData['user_id'] ?? 0;
        $customer->is_billing_on = $formData['is_billing_on'] ?? 1;
        $customer->payer_type         = $formData['payer_type'] ?? 0;
        $customer->save();
      if($customer){
        return Response::json(["status"=>"success","message"=>"Customer updated successfully."]);
      }else {
        return Response::json(["status"=>"error","message"=>"Failed to update the record."]);
      }
    }
  } // end
  /**
	 * Function for mark a customer as deleted
	 *
	 */
	public function delete_customer(){
    $formData = Input::all();
    $message = array();
    $validate = array(
        'customer_id'=> 'required',
      );
    $validator = Validator::make(Input::all(),$validate,$message);
    if ($validator->fails()) {
      $message = "Please fill all required fields.";
      $messages = $validator->errors()->getMessages();
      $messages = array_reverse($messages);
      foreach ($messages as $key => $value) {
        $message = $value[0];
      }
      return Response::json(["status"=>"error","message"=>$message]);
    }else {
      $customer_id       = $formData['customer_id'];
      $userModel		=	User::where('id',$customer_id)->update(array('is_deleted'=>ACTIVE));
      return Response::json(["status"=>"success","message"=>"Customer deleted successfully."]);
    }
	} // end delete_customer()
  /**
	 * Function to get customer_detail
	 *
	 */
	public function get_customer_detail(){
    $formData = Input::all();
    $message = array();
    $validate = array(
        'customer_id'=> 'required',
      );
    $validator = Validator::make(Input::all(),$validate,$message);
    if ($validator->fails()) {
      $message = "Please fill all required fields.";
      $messages = $validator->errors()->getMessages();
      $messages = array_reverse($messages);
      foreach ($messages as $key => $value) {
        $message = $value[0];
      }
      return Response::json(["status"=>"error","message"=>$message]);
    }else {
      $customer_id  = $formData['customer_id'];
      $query = DB::table("users as u");
      $query->where('u.user_role_id', USER)
      ->select('u.full_name','u.phone','u.email','u.flat_number')
      ->where('u.is_deleted',INACTIVE)
      ->where('u.active', ACTIVE);
      $query->where('u.id',$formData['customer_id']);
      $customerData = $query->first();
      if (!empty($customerData)) {
        $response['customerData'] = $customerData;
        $language_id = $formData['language_id'] ?? Config::get('default_language.language_code');
        $paper_query = DB::table("customers_newspapers as cnp");
        $paper_query->select('cnp.id','cnp.newspaper_id','cnp.qty','cnp.delivery_day_type','dmd.name as newspaper_name','cnp.payment_option','cnp.paper_data')
        ->join("dropdown_managers as dm",'cnp.newspaper_id','=','dm.id')
        ->join('dropdown_manager_descriptions as dmd','dm.id','=','dmd.parent_id')
        ->where("dm.dropdown_type","newspapers")
        ->where('dm.status',ACTIVE)
        ->where('dmd.language_id',$language_id)
        ->where('cnp.is_deleted',INACTIVE)
        ->where('cnp.status', ACTIVE);
        $paper_query->groupBy('cnp.newspaper_id');
        $paper_query->where('cnp.customer_id',$formData['customer_id']);
        $newpaperData = $paper_query->get();
        if (!empty($newpaperData)) {
          foreach ($newpaperData as $key => $value) {
            if (!empty($value->paper_data)) {
              $newpaperData[$key]->paper_data = unserialize($value->paper_data);
            }else {
              $newpaperData[$key]->paper_data = array();
            }
          }
        }
        //pr($newpaperData);die;
        $response['newpaperData'] = $newpaperData;
        return Response::json(["status"=>"success","data"=>$response]);
      }else {
        return Response::json(["status"=>"error","message"=>"No Record Found"]);
      }
    }
	} // end customer_detail()


} // end CustomerController class
