<?php

namespace App\Http\Controllers\Api\V1;

use App\Http\Controllers\Controller;
use App\Http\Controllers\BaseController;
use Illuminate\Http\Request;
use JWTFactory;
use JWTAuth;
use App\User;
use App\Model\OTP;
use App\Model\CustomerNewspaper;
use App\Model\Address;
use App\Model\EmailAction;
use App\Model\EmailTemplate;
use App\libraries\CustomHelper;
use Str,Auth,Blade,Config,Cache,Cookie,DB,File,Hash,Input,Mail,Redirect,Response,Session,URL,View,Validator;
use Carbon\Carbon;

class CustomerNewspaperController extends BaseController
{
  /*
  * add address
  */
  public function add(Request $request)
  {
    $formData				=	Input::all();
    $message = array();
    $validate = array(
        'customer_id'=> 'required',
        'newspaper_id'=> 'required',
        'payment_option'=> 'required',
        'delivery_day_type'=> 'required',
        'qty'=> 'required',
        'paper_data'=> 'required',
      );
      if ( isset($formData['payment_option']) && $formData['payment_option'] == 2 ) {
        $validate['total_coupon'] = "required";
        $validate['coupon_description'] = "required";
      }
      $validator = Validator::make(Input::all(),$validate,$message);
    if ($validator->fails()) {
      $message = "Please fill all required fields.";
      $messages = $validator->errors()->getMessages();
      $messages = array_reverse($messages);
      foreach ($messages as $key => $value) {
        $message = $value[0];
      }
      return Response::json(["status"=>"error","message"=>$message]);
    }else {
        $newspaper = DB::table('newspaper')->select('day_price_type')->where('newspaper_id',$formData['newspaper_id'])->first();
        $customer = DB::table('users')->select('address_id')->where('id',$formData['customer_id'])->first();
        $obj  = new CustomerNewspaper;

        $paper_data = (array)json_decode($formData['paper_data']);
        $delivery_data = (array)json_decode($formData['delivery_data']);
        $obj->customer_id           = $formData['customer_id'] ?? 0;
        $obj->address_id           = $customer->address_id ?? 0;
        $obj->newspaper_id          = $formData['newspaper_id'] ?? 0;
        $obj->payment_option        = $formData['payment_option'] ?? 0;
        $obj->delivery_day_type     = $formData['delivery_day_type'] ?? 0;
        $obj->delivery_data         = serialize($delivery_data);
        $obj->qty                   = $formData['qty'] ?? 1;
        $obj->total_coupon          = $formData['total_coupon'] ?? 0;
        $obj->coupon_description    = $formData['coupon_description'] ?? "";
        $obj->start_date            = $formData['start_date'] ?? "";
        $obj->coupon_start_date     = $formData['coupon_start_date'] ?? "";
        $obj->coupon_end_date       = $formData['coupon_end_date'] ?? "";
        $obj->paper_data            = serialize($paper_data);
        $obj->status				        =  	ACTIVE;
        $obj->is_deleted			      =  	INACTIVE;
        $obj->save();
      if($obj){
        return Response::json(["status"=>"success","message"=>"Paper added successfully."]);
      }else {
        return Response::json(["status"=>"error","message"=>"Failed to save the record."]);
      }
    }
  } // end

  /*
  * get address for edit
  */
  public function get(Request $request)
  {
    $formData       = Input::all();
    $message = array();
    $validate = array(
        'customer_newspaper_id'=> 'required',
      );
    $validator = Validator::make(Input::all(),$validate,$message);
    if ($validator->fails()) {
      $message = "Please fill all required fields.";
      $messages = $validator->errors()->getMessages();
      $messages = array_reverse($messages);
      foreach ($messages as $key => $value) {
        $message = $value[0];
      }
      return Response::json(["status"=>"error","message"=>$message]);
    }else {
      $obj_id       = $formData['customer_newspaper_id'];
      $obj  = CustomerNewspaper::where('id',$obj_id)->where('customer_id',$formData['customer_id'])->first();
      if (!empty($obj)) {
        $obj->paper_data = unserialize($obj->paper_data);
        $obj->delivery_data = unserialize($obj->delivery_data);
      }
      $response = $obj ?? array();
      return Response::json(["status"=>"success","data"=>$response]);
    }
  } // end

  /*
  * update address
  */
  public function update(Request $request)
  {
    $formData				=	Input::all();
    $message = array();
    $validate = array(
        'customer_newspaper_id'=> 'required',
        'customer_id'=> 'required',
        'newspaper_id'=> 'required',
        'payment_option'=> 'required',
        'delivery_day_type'=> 'required',
        'qty'=> 'required',
        //'paper_data'=> 'required',
      );
      if ( isset($formData['payment_option']) && $formData['payment_option'] == 2 ) {
        $validate['total_coupon'] = "required";
        $validate['coupon_description'] = "required";
      }
      $validator = Validator::make(Input::all(),$validate,$message);
    if ($validator->fails()) {
      $message = "Please fill all required fields.";
      $messages = $validator->errors()->getMessages();
      $messages = array_reverse($messages);
      foreach ($messages as $key => $value) {
        $message = $value[0];
      }
      return Response::json(["status"=>"error","message"=>$message]);
    }else {
        $newspaper = DB::table('newspaper')->select('day_price_type')->where('newspaper_id',$formData['newspaper_id'])->first();
        $customer = DB::table('users')->select('address_id')->where('id',$formData['customer_id'])->first();
        $obj  = CustomerNewspaper::where('id',$formData['customer_newspaper_id'])->where('customer_id',$formData['customer_id'])->first();
        if (empty($obj)) {
          return Response::json(["status"=>"error","message"=>"No record found."]);
        }
        if (isset($formData['paper_data'])) {
          $paper_data = (array)json_decode($formData['paper_data']);
        }
        $delivery_data = (array)json_decode($formData['delivery_data']);
        $collected_coupons = isset($formData['collected_coupons']) && $formData['collected_coupons']>0 ? $formData['collected_coupons'] : 0;
        $obj->customer_id           = $formData['customer_id'] ?? 0;
        $obj->address_id           = $customer->address_id ?? 0;
        $obj->newspaper_id          = $formData['newspaper_id'] ?? 0;
        $obj->payment_option        = $formData['payment_option'] ?? 0;
        $obj->delivery_day_type     = $formData['delivery_day_type'] ?? 0;
        $obj->delivery_data         = serialize($delivery_data);
        $obj->qty                   = $formData['qty'] ?? 1;
        $obj->total_coupon          = $formData['total_coupon'] ?? 0;
        $obj->coupon_description    = $formData['coupon_description'] ?? "";
        $obj->start_date            = $formData['start_date'] ?? "";
        $obj->coupon_start_date     = $formData['coupon_start_date'] ?? "";
        $obj->coupon_end_date       = $formData['coupon_end_date'] ?? "";
        $obj->collected_coupons     = $obj->collected_coupons + $collected_coupons;
        $obj->pending_coupons       = $obj->total_coupon - $obj->collected_coupons;
        //$obj->paper_data            = serialize($paper_data);
        $obj->save();
      if($obj){
        return Response::json(["status"=>"success","message"=>"Paper updated successfully."]);
      }else {
        return Response::json(["status"=>"error","message"=>"Failed to save the record."]);
      }
    }
  } // end
  /**
	 * Function for mark as delete
	 *
	 * @return redirect page.
	 */
	public function delete(){
    $formData = Input::all();
    $message = array();
    $validate = array(
        'customer_id'=> 'required',
      );
    $validator = Validator::make(Input::all(),$validate,$message);
    if ($validator->fails()) {
      $message = "Please fill all required fields.";
      $messages = $validator->errors()->getMessages();
      $messages = array_reverse($messages);
      foreach ($messages as $key => $value) {
        $message = $value[0];
      }
      return Response::json(["status"=>"error","message"=>$message]);
    }else {
      CustomerNewspaper::where('id',$formData['customer_newspaper_id'])->where('customer_id',$formData['customer_id'])->update(array('is_deleted'=>ACTIVE));
      return Response::json(["status"=>"success","message"=>"Paper deleted successfully."]);
    }
	} // end delete()

  /*
  * get customers papers
  */
  public function getCustomersPapers(Request $request)
  {
    $formData       = Input::all();
    $message = array();
    $validate = array(
        'customer_id'=> 'required',
      );
    $validator = Validator::make(Input::all(),$validate,$message);
    if ($validator->fails()) {
      $message = "Please fill all required fields.";
      $messages = $validator->errors()->getMessages();
      $messages = array_reverse($messages);
      foreach ($messages as $key => $value) {
        $message = $value[0];
      }
      return Response::json(["status"=>"error","message"=>$message]);
    }else {
    	$language_id = $formData['language_id'] ?? Config::get('default_language.language_code');
      $obj  = DB::table('customers_newspapers as cnp')
      				->join('dropdown_managers as dm','cnp.newspaper_id','=','dm.id')
      				->join('dropdown_manager_descriptions as dmd','dm.id','=','dmd.parent_id')
              ->where("dm.dropdown_type","newspapers")
              ->where('dm.status',ACTIVE)
              ->where('dmd.language_id',$language_id)
      				->where('cnp.customer_id',$formData['customer_id'])
      				->where('cnp.status',ACTIVE)
      				->where('cnp.is_deleted',INACTIVE)
      				->select('cnp.*','dmd.name as newspaper_name')
      				->get();
      if (!empty($obj)) {
        foreach ($obj as $key => $value) {
          if(isset($value->paper_data) && !empty($value->paper_data)){
            $obj[$key]->paper_data = unserialize($value->paper_data);
          }
          if(isset($value->delivery_data) && !empty($value->delivery_data)){
            $obj[$key]->delivery_data = unserialize($value->delivery_data);
          }
        }
      }
      $response = $obj ?? array();
      return Response::json(["status"=>"success","data"=>$response]);
    }
  } // end

} // end CustomerNewspaperController class
