<?php

namespace App\Http\Controllers\Api\V1;

use App\Http\Controllers\Controller;
use App\Http\Controllers\BaseController;
use Illuminate\Http\Request;
use App\User;
use App\libraries\CustomHelper;
use App\Services\Input;
use Carbon\Carbon;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Support\Facades\Response;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\View;

class HomeController extends BaseController
{
  /*
  * get home data
  */
  public function index(Request $request)
  {
    $formData				=	Input::all();
    $validator = Validator::make($request->all(), [
        'user_id'=> 'required',

    ]);
    if ($validator->fails()) {
      $message = "Please fill all required fields.";
      $message = $validator->errors()->getMessages();
      if (isset($message['user_id']) && !empty($message['user_id'])) {
        $message = $message['user_id'][0];
      }
      return Response::json(["status"=>"error","message"=>$message]);
    }else {
      $userData = User::findOrFail($formData['user_id']);
      if (!empty($userData)) {
       // print_r('expression');die;
        $vendor_id = $formData['user_id'];
        $response['userData'] = $userData;
        $response['cash_collection'] = DB::table("payments as p")
                                        ->join("users as c","p.customer_id","=","c.id")
                                        ->where("c.vendor_id",$vendor_id)
                                        ->where("p.payment_status","Completed")
                                        ->where("p.payment_mode",2) // cash
                                        ->where("p.txn_type",2) // credit
                                        ->whereDate('p.created_at', '>=', Carbon::now()->subDays(30))
                                        ->sum("p.amount");
        $response['online_collection'] = DB::table("payments as p")
                                        ->join("users as c","p.customer_id","=","c.id")
                                        ->where("c.vendor_id",$vendor_id)
                                        ->where("p.payment_status","Completed")
                                        ->where("p.payment_mode",1) // online
                                        ->where("p.txn_type",2) // credit
                                        ->whereDate('p.created_at', '>=', Carbon::now()->subDays(30))
                                        ->sum("p.amount");
        $response['due_amount'] = DB::table("billings as bil")
                                      ->join("users as c","bil.customer_id","=","c.id")
                                      ->where("c.vendor_id",$vendor_id)
                                      ->where("bil.is_carry_forward",INACTIVE)
                                      ->where("bil.bill_status","!=",ACTIVE)
                                      ->groupBy(["bil.customer_id"])
                                      ->orderBy("bil.month","desc")
                                      ->orderBy("bil.year","desc")
                                      ->whereDate('bil.created_at', '>=', Carbon::now()->subDays(30))
                                      ->sum("bil.due_amount");
        $response['bank_transfer'] = DB::table("payments as p")
                                        ->join("users as c","p.customer_id","=","c.id")
                                        ->where("c.vendor_id",$vendor_id)
                                        ->where("p.payment_status","Completed")
                                        ->where("p.payment_mode",3) // bank
                                        ->where("p.txn_type",2) // credit
                                        ->whereDate('p.created_at', '>=', Carbon::now()->subDays(30))
                                        ->sum("p.amount");
        return Response::json(["status"=>"success","data"=>$response]);
      }else {
        return Response::json(["status"=>"error","message"=>"No user found."]);
      }
    }
  } // end
  /*
  * manage customers
  */
  public function manageCustomers(Request $request)
  {
    $formData				=	Input::all();
    $validator = Validator::make($request->all(), [
        'user_id'=> 'required',
        'address_type'=> 'required',

    ]);
    if ($validator->fails()) {
      $message = "Please fill all required fields.";
      $messages = $validator->errors()->getMessages();
      $messages = array_reverse($messages);
      foreach ($messages as $key => $value) {
        $message = $value[0];
      }
      /*  if (isset($message['user_id']) && !empty($message['user_id'])) {
        $message = $message['user_id'][0];
      }
      if (isset($message['address_type']) && !empty($message['address_type'])) {
        $message = $message['address_type'][0];
      } */
      return Response::json(["status"=>"error","message"=>$message]);
    }else {
      $response =array();
      $response['areas'] = CustomHelper::getVendorAreas($formData['user_id']);

      $query = DB::table("users as u");
      $query->join('address as add','u.id','=','add.user_id')
      ->join('address_type as at','at.id','=','add.address_type_id');
      // filter by payment_option
      // if (isset($formData['payment_option']) && ($formData['payment_option']==1 || $formData['payment_option'] == 2)) {
      //   $query->join('customers_newspapers as cn','c.id','=','cn.customer_id');
      // }
      $query->select('add.id as address_id','add.address_type_id','add.address',
      'add.area','add.address_name','add.address','add.pin_code')
      ->where('u.user_role_id', VENDOR)
      ->where('u.is_deleted','!=',ACTIVE)
      ->where('u.active', ACTIVE)
      ->where('add.is_deleted','!=',ACTIVE)
      ->where('add.active', ACTIVE)
      ->orderBy('add.address_name', 'ASC');
      $query->where('u.id',$formData['user_id']);
      $query->where('at.id',$formData['address_type']);
      // filter by area
      if (isset($formData['area']) && !empty($formData['area'])) {
        $query->where('add.area', 'like', '%' . $formData['area'] . '%');
      }
      // filter by payment_option
      // if (isset($formData['payment_option']) && ($formData['payment_option']==1 || $formData['payment_option'] == 2)) {
      //   $query->where('cn.payment_option',$formData['payment_option']);
      // }
      $result = $query->get();
      // $query = DB::getQueryLog();
      // $query = end($query);
       //pr($result);die();
      if (!empty($result)) {
          $address_ids = array();
        if ($formData['address_type'] == BUILDING OR $formData['address_type'] == CHAWL) {
          foreach ($result as $key => $value) {
            $customers = DB::table("users as u")
                      ->join('address as add','u.address_id','=','add.id')
                      ->join('address_type as at','at.id','=','add.address_type_id')
                      ->where('u.user_role_id', USER)
                      ->where('u.vendor_id',$formData['user_id'])
                      ->where('u.is_deleted','!=',ACTIVE)
                      ->where('u.active', ACTIVE)
                      ->where('u.address_id',$value->address_id)
                      ->where('add.active', ACTIVE)
                      ->where('add.is_deleted','!=',ACTIVE)
                      ->count();
            $result[$key]->no_of_customers = $customers ?? 0;
            array_push($address_ids, $value->address_id);
          }
        }
        if ($formData['address_type'] == SHOP OR $formData['address_type'] == BUNGALOW) {
          foreach ($result as $key => $value) {
            $c_query = DB::table("users as u")
                            ->join('address as add','u.address_id','=','add.id')
                            ->join('address_type as at','at.id','=','add.address_type_id');
                            if (isset($formData['payment_option']) && ($formData['payment_option']==1 || $formData['payment_option'] == 2)) {
                              $c_query->join('customers_newspapers as cn','u.id','=','cn.customer_id');
                            }
                            $c_query->select("u.id as customer_id","add.id as address_id")
                            ->where('u.user_role_id', USER)
                            ->where('u.vendor_id',$formData['user_id'])
                            ->where('u.is_deleted','!=',ACTIVE)
                            ->where('u.active', ACTIVE)
                            ->where('u.address_id',$value->address_id)
                            ->where('add.active', ACTIVE)
                            ->where('add.is_deleted','!=',ACTIVE);
                            if (isset($formData['payment_option']) && ($formData['payment_option']==1 || $formData['payment_option'] == 2)) {
                              $c_query->where('cn.payment_option',$formData['payment_option']);
                            }
            $customersData =  $c_query->first();
            // $query = DB::getQueryLog();
            // $query = end($query);
            //  pr($query);die();

            if (!empty($customersData)) {
              $customers = count((array)$customersData);
              $result[$key]->no_of_customers = $customers ?? 0;
              $result[$key]->customer_id = $customersData->customer_id ?? 0;
              $result[$key]->no_of_customers = $customers ?? 0;
              array_push($address_ids, $customersData->address_id);
              $units_query = DB::table("customers_newspapers as cnp")
                          ->where('cnp.is_deleted','!=',ACTIVE)
                          ->where('cnp.status', ACTIVE);
                          $units_query->where('cnp.address_id',$value->address_id);
                          if (isset($formData['payment_option']) && ($formData['payment_option']==1 || $formData['payment_option'] == 2)) {
                            $units_query->where('cnp.payment_option',$formData['payment_option']);
                          }
              $units =  $units_query->count();
              $result[$key]->no_of_units = $units ?? 0;
            }else {
              unset($result[$key]);
            }

          }
           if(!empty($result)) { //print_r(json_decode(json_encode($result)), true); exit;
              $result = json_decode(json_encode($result), true);
              $result = array_values($result);// print_r($result); exit;
            }
        }
        //pr((array)$result);die;
        //$result = array_values((array)$result);
        if (count($address_ids)) {
          $address_ids = array_unique(array_filter($address_ids));
          //pr($address_ids);die;
          $total_customers_query = DB::table("users as u");
                                // if (isset($formData['payment_option']) && ($formData['payment_option']==1 || $formData['payment_option'] == 2)) {
                                //   $total_customers_query->join('customers_newspapers as cn','u.id','=','cn.customer_id');
                                // }
                                $total_customers_query->whereIn('u.address_id',$address_ids)
                                ->where('u.user_role_id', USER)
                                ->where('u.is_deleted','!=',ACTIVE)
                                ->where('u.active', ACTIVE);
                                // if (isset($formData['payment_option']) && ($formData['payment_option']==1 || $formData['payment_option'] == 2)) {
                                //   $total_customers_query->where('cn.payment_option',$formData['payment_option']);
                                // }
            $total_customers =    $total_customers_query->count();
          //   $query = DB::getQueryLog();
          //   $query = end($query);
          //    pr($query);die();
          // pr($total_customers);die;
        }
        $response['total_customers'] = $total_customers ?? 0;
        $response['result'] = $result;
        //pr($response);die;
        return Response::json(["status"=>"success","data"=>$response]);
      }else {
        return Response::json(["status"=>"error","message"=>"No record found."]);
      }
    }
  } // end

  /*
  * get notifications
  */
  public function get_notifications(Request $request)
  {
    $formData				=	Input::all();
    $validator = Validator::make($request->all(), [
        'user_id'=> 'required',

    ]);
    if ($validator->fails()) {
      $message = "Please fill all required fields.";
      $message = $validator->errors()->getMessages();
      if (isset($message['user_id']) && !empty($message['user_id'])) {
        $message = $message['user_id'][0];
      }
      return Response::json(["status"=>"error","message"=>$message]);
    }else {
      $response = array();
      $result = DB::table('notifications')->select('description','created_at')->where("user_id",$formData['user_id'])->where('is_deleted',0)->orderBy('id','desc')->take(10)->get();
      $response = $result ?? array();
      return Response::json(["status"=>"success","data"=>$response]);
    }
  } // end

} // end HomeController class
