<?php

namespace App\Http\Controllers\Api\V1;

use App\Http\Controllers\Controller;
use App\Http\Controllers\BaseController;
use Illuminate\Http\Request;
use JWTFactory;
use JWTAuth;
use App\User;
use App\Model\OTP;
use App\Model\Address;
use App\Model\EmailAction;
use App\Model\EmailTemplate;
use App\Model\Billings;
use App\Model\BillingHistory;
use App\Model\Payment;
use App\Model\BillURL;
use App\Model\ReportProblem;
use App\libraries\CustomHelper;
use Str,Auth,Blade,Config,Cache,Cookie,DB,File,Hash,Input,Mail,Redirect,Response,Session,URL,View,Validator;
use Carbon\Carbon;

class MonthlyStatementController extends BaseController
{
  /*
  * get bill detail
  */
  public function index(Request $request)
  {
    $formData				=	Input::all();
    $validator = Validator::make($request->all(), [
        'user_id'     => 'required',
    ]);
    if ($validator->fails()) {
      $message = "Please fill all required fields.";
      $messages = $validator->errors()->getMessages();
      $messages = array_reverse($messages);
      foreach ($messages as $key => $value) {
        $message = $value[0];
      }
      return Response::json(["status"=>"error","message"=>$message]);
    }else {
      $response = array();
      $language_id = $formData['language_id'] ?? Config::get('default_language.language_code');
      $result  = DB::table('billings as bil')
              ->join('users as u','bil.customer_id','=','u.id')
              ->join('address as add','u.address_id','=','add.id')
              ->where('u.vendor_id',$formData['user_id'])
              ->select('bil.month','bil.year')
              ->orderBy('year','desc')
              ->orderBy('month','desc')
              ->groupBy(['year','month'])
              ->get();
      if (!empty($result)) {
        foreach ($result as $key => $value) {
          $dateObj   = \DateTime::createFromFormat('!m', $value->month);
          $result[$key]->name = $dateObj->format('F');
        }
        $response = $result;
        //pr($response);die;
        return Response::json(["status"=>"success","data"=>$response]);
      }else {
        return Response::json(["status"=>"error","message"=>"No Record Found"]);
      }
    }
  } // end bill_detail

  /*
  * view the monthly statement
  */
  public function view(Request $request)
  {
    $formData				=	Input::all();
    $validator = Validator::make($request->all(), [
        'user_id'     => 'required',
        'month'       => 'required',
        'year'        => 'required',
    ]);
    if ($validator->fails()) {
      $message = "Please fill all required fields.";
      $messages = $validator->errors()->getMessages();
      $messages = array_reverse($messages);
      foreach ($messages as $key => $value) {
        $message = $value[0];
      }
      return Response::json(["status"=>"error","message"=>$message]);
    }else {
      $response = array();
      $language_id = $formData['language_id'] ?? Config::get('default_language.language_code');
      $result  = DB::table('billings as bil')
              ->join('users as u','bil.customer_id','=','u.id')
              ->join('address as add','u.address_id','=','add.id')
              ->where('u.vendor_id',$formData['user_id'])
              ->where('bil.month',$formData['month'])
              ->where('bil.year',$formData['year'])
              ->select('bil.*','add.id as address_id','add.address_name','u.flat_number','u.full_name','u.payer_type')
              ->orderBy('year','desc')
              ->orderBy('month','desc')
              ->get();
            //pr($result);die;
      if (!empty($result)) {
        $address_array = [];
        $result2 = [];
        $customer_ids = [];
        $result2['billed_customers'] =0;
        // date string for getting previous month
        $datestring = $formData['year']."-".$formData['month']." first day of last month";
        $dt=date_create($datestring);
        $previous_year =  $dt->format('Y');
        $previous_month =  $dt->format('m');
        $result2['totalDays'] =cal_days_in_month(CAL_GREGORIAN, $previous_month, $previous_year);

        /*###### find holiday #######*/
        $holiday_query = DB::table("holidays as hd");
        $holiday_query->select('hd.from_date','hd.to_date','hd.type','hd.user_id')
        ->where('hd.is_deleted',INACTIVE)
        ->where('hd.active', ACTIVE)
        ->where('hd.user_id', $formData['user_id'])
        ->whereRaw("(YEAR(from_date) = '2019' AND MONTH(from_date) = '04') AND (YEAR(to_date) = '2019' AND MONTH(to_date) = '04')")
        //->where('hd.to_date', '<=', date('Y-m-d'))
        ->orWhere('hd.type', ACTIVE);
        $holiday_result = $holiday_query->get();
        $holiday_date_array = array();
        $total_holiday_array = array();
        if (count($holiday_result)) {
          foreach ($holiday_result as $holiday_key => $holiday_value) {
            $dates = CustomHelper::getDatesBwTwoDates($holiday_value->from_date,$holiday_value->to_date);
            if (!empty($dates)) {
              foreach ($dates as $dates_key => $dates_value) {
                array_push($holiday_date_array,$dates_value);
              }
            }
          }
        }
        $vendor_total_holidays = 0;
        if (count($holiday_date_array)) {
          $holiday_date_array = array_unique($holiday_date_array);
          $vendor_total_holidays = count($holiday_date_array);
        }
        /*###### find holiday #######*/
        $result2['vendor_total_holidays'] =$vendor_total_holidays;
        $i=1;
        $count = 1;
        foreach ($result as $key => $value) {
          // push the customer id
          array_push($customer_ids,$value->customer_id);
          $address_array[$value->address_id]['address_id'] = $value->address_id;
          $address_array[$value->address_id]['address_name'] = $value->address_name;
          if(isset($address_array[$value->address_id]['no_of_customers'])) {
            $address_array[$value->address_id]['no_of_customers'] = $address_array[$value->address_id]['no_of_customers'] + 1;
          } else {
            $address_array[$value->address_id]['no_of_customers'] = 1;
          }
          $address_array[$value->address_id]['customers'][] = $value;
          if(isset($value->paid_amount) && $value->paid_amount > 0) {
            $result2['billed_customers'] = $count;
          }
          $result2['total_customers'] = $count;
          $count++;
        }
        // append customers newspapers
        foreach ($result as $main_key => $main_value) {
          $newspaper_result  = DB::table('monthly_bill as mb')
          				->join('dropdown_managers as dm','mb.newspaper_id','=','dm.id')
          				->join('dropdown_manager_descriptions as dmd','dm.id','=','dmd.parent_id')
                  ->where("dm.dropdown_type","newspapers")
                  ->where('dm.status',ACTIVE)
                  ->where('dmd.language_id',$language_id)
                  ->where('mb.customer_id',$main_value->customer_id)
                  ->where('mb.month',$main_value->month)
                  ->where('mb.year',$main_value->year)
          				->select('dmd.name as newspaper_name')
          				->get();
          $result[$main_key]->newspaperData = $newspaper_result ?? array();
        }
        //pr($result);die;
        $result2['unbilled_customers'] = $result2['total_customers'] - $result2['billed_customers'];
        if (count($customer_ids)) {
          $vendor_holiday = $customer_ids;
        }
        $result2['addressData'] = array_values($address_array);
        $response = $result2;
        return Response::json(["status"=>"success","data"=>$response]);
      }else {
        return Response::json(["status"=>"error","message"=>"No Record Found"]);
      }
    }
  } // end view

  /*
  * download the monthly statement
  */
  public function download(Request $request)
  {
    $formData				=	Input::all();
    $validator = Validator::make($request->all(), [
        'user_id'     => 'required',
        'month'       => 'required',
        'year'        => 'required',
    ]);
    if ($validator->fails()) {
      $message = "Please fill all required fields.";
      $messages = $validator->errors()->getMessages();
      $messages = array_reverse($messages);
      foreach ($messages as $key => $value) {
        $message = $value[0];
      }
      return Response::json(["status"=>"error","message"=>$message]);
    }else {
      $response = array();
      $language_id = $formData['language_id'] ?? Config::get('default_language.language_code');
      $result  = DB::table('billings as bil')
              ->join('users as u','bil.customer_id','=','u.id')
              ->join('address as add','u.address_id','=','add.id')
              ->where('u.vendor_id',$formData['user_id'])
              ->where('bil.month',$formData['month'])
              ->where('bil.year',$formData['year'])
              ->select('bil.*','add.id as address_id','add.address_name','u.flat_number','u.full_name','u.payer_type')
              ->orderBy('year','desc')
              ->orderBy('month','desc')
              ->get();
            //pr($result);die;
      if (!empty($result)) {
        $address_array = [];
        $result2 = [];
        $customer_ids = [];
        $result2['billed_customers'] =0;
        // date string for getting previous month
        $datestring = $formData['year']."-".$formData['month']." first day of last month";
        $dt=date_create($datestring);
        $previous_year =  $dt->format('Y');
        $previous_month =  $dt->format('m');
        $result2['totalDays'] =cal_days_in_month(CAL_GREGORIAN, $previous_month, $previous_year);

        /*###### find holiday #######*/
        $holiday_query = DB::table("holidays as hd");
        $holiday_query->select('hd.from_date','hd.to_date','hd.type','hd.user_id')
        ->where('hd.is_deleted',INACTIVE)
        ->where('hd.active', ACTIVE)
        ->where('hd.user_id', $formData['user_id'])
        ->whereRaw("(YEAR(from_date) = '2019' AND MONTH(from_date) = '04') AND (YEAR(to_date) = '2019' AND MONTH(to_date) = '04')")
        //->where('hd.to_date', '<=', date('Y-m-d'))
        ->orWhere('hd.type', ACTIVE);
        $holiday_result = $holiday_query->get();
        $holiday_date_array = array();
        $total_holiday_array = array();
        if (count($holiday_result)) {
          foreach ($holiday_result as $holiday_key => $holiday_value) {
            $dates = CustomHelper::getDatesBwTwoDates($holiday_value->from_date,$holiday_value->to_date);
            if (!empty($dates)) {
              foreach ($dates as $dates_key => $dates_value) {
                array_push($holiday_date_array,$dates_value);
              }
            }
          }
        }
        $vendor_total_holidays = 0;
        if (count($holiday_date_array)) {
          $holiday_date_array = array_unique($holiday_date_array);
          $vendor_total_holidays = count($holiday_date_array);
        }
        /*###### find holiday #######*/
        $result2['vendor_total_holidays'] =$vendor_total_holidays;
        $i=1;
        $count = 1;
        foreach ($result as $key => $value) {
          // push the customer id
          array_push($customer_ids,$value->customer_id);
          $address_array[$value->address_id]['address_id'] = $value->address_id;
          $address_array[$value->address_id]['address_name'] = $value->address_name;
          if(isset($address_array[$value->address_id]['no_of_customers'])) {
            $address_array[$value->address_id]['no_of_customers'] = $address_array[$value->address_id]['no_of_customers'] + 1;
          } else {
            $address_array[$value->address_id]['no_of_customers'] = 1;
          }
          $address_array[$value->address_id]['customers'][] = $value;
          if(isset($value->paid_amount) && $value->paid_amount > 0) {
            $result2['billed_customers'] = $count;
          }
          $result2['total_customers'] = $count;
          $count++;
        }
        // append customers newspapers
        foreach ($result as $main_key => $main_value) {
          $newspaper_result  = DB::table('monthly_bill as mb')
          				->join('dropdown_managers as dm','mb.newspaper_id','=','dm.id')
          				->join('dropdown_manager_descriptions as dmd','dm.id','=','dmd.parent_id')
                  ->where("dm.dropdown_type","newspapers")
                  ->where('dm.status',ACTIVE)
                  ->where('dmd.language_id',$language_id)
                  ->where('mb.customer_id',$main_value->customer_id)
                  ->where('mb.month',$main_value->month)
                  ->where('mb.year',$main_value->year)
          				->select('dmd.name as newspaper_name')
          				->get();
          $result[$main_key]->newspaperData = $newspaper_result ?? array();
        }
        //pr($result);die;
        $result2['unbilled_customers'] = $result2['total_customers'] - $result2['billed_customers'];
        if (count($customer_ids)) {
          $vendor_holiday = $customer_ids;
        }
        $result2['addressData'] = array_values($address_array);
        // make directory of each vendor using vendor id
        $dir_name = base_path().'/pdf/vendor_'.$formData['user_id'];
        if (!file_exists($dir_name)) {
            mkdir($dir_name,0777, true);
        }
        $dateObj   = \DateTime::createFromFormat('!m', $formData['month']);
        $monthName = $dateObj->format('F');
        $filName = "Bill_".$monthName."_".$formData['year'].".pdf";
        $file_location = $dir_name."/".$filName;
        $result2['monthName'] = $monthName;
        $result2['year'] = $formData['year'];

        $only_file_path = 'pdf/vendor_'.$formData['user_id'].'/'.$filName;
        $check_bill = DB::table("monthly_statement")
            ->where("vendor_id",$formData["user_id"])
            ->where("month",$formData["month"])
            ->where("year",$formData["year"])
            ->first();
      //   /*#############*/
      //   return view('bill/bill',compact('result2'));
      //   $pdf = \PDF::loadView('bill/bill',compact('result2'))->download($file_location);
      // echo $file_location;  die;
      // /*#############*/
        if (!empty($check_bill)) {
          $only_file_path = $check_bill->path;
        }else {
          $insert = array(
            "vendor_id"=>$formData['user_id'],
            "month"=>$formData['month'],
            "year"=>$formData['year'],
            "path"=>$only_file_path,
            "created_at"=>Date("Y-m-d H:i:s"),
          );
          DB::table("monthly_statement")->insert($insert);
          if (!file_exists($file_location)) {
            $pdf = \PDF::loadView('bill/bill',compact('result2'))->save($file_location);
            chmod($file_location, 0777);
          }
        }
        $url = WEBSITE_URL.$only_file_path;
        return Response::json(["status"=>"success","data"=>$url]);
      }else {
        return Response::json(["status"=>"error","message"=>"No Record Found"]);
      }
    }
  } // end download()

  /*
  * send the monthly statement
  */
  public function send(Request $request)
  {
    $formData				=	Input::all();
    $validator = Validator::make($request->all(), [
        'user_id'     => 'required',
        'month'       => 'required',
        'year'        => 'required',
        //'email'        => 'required',
    ]);
    if ($validator->fails()) {
      $message = "Please fill all required fields.";
      $messages = $validator->errors()->getMessages();
      $messages = array_reverse($messages);
      foreach ($messages as $key => $value) {
        $message = $value[0];
      }
      return Response::json(["status"=>"error","message"=>$message]);
    }else {
      $response = array();
      $language_id = $formData['language_id'] ?? Config::get('default_language.language_code');
      $result  = DB::table('billings as bil')
              ->join('users as u','bil.customer_id','=','u.id')
              ->join('address as add','u.address_id','=','add.id')
              ->where('u.vendor_id',$formData['user_id'])
              ->where('bil.month',$formData['month'])
              ->where('bil.year',$formData['year'])
              ->select('bil.*','add.id as address_id','add.address_name','u.flat_number','u.full_name','u.payer_type')
              ->orderBy('year','desc')
              ->orderBy('month','desc')
              ->get();

      // get vendor data
      $vendorData = User::where("id",$formData['user_id'])->where('is_deleted',INACTIVE)->where('active',ACTIVE)->first();
      if (!empty($result)) {
        $address_array = [];
        $result2 = [];
        $customer_ids = [];
        $result2['billed_customers'] =0;
        // date string for getting previous month
        $datestring = $formData['year']."-".$formData['month']." first day of last month";
        $dt=date_create($datestring);
        $previous_year =  $dt->format('Y');
        $previous_month =  $dt->format('m');
        $result2['totalDays'] =cal_days_in_month(CAL_GREGORIAN, $previous_month, $previous_year);

        /*###### find holiday #######*/
        $holiday_query = DB::table("holidays as hd");
        $holiday_query->select('hd.from_date','hd.to_date','hd.type','hd.user_id')
        ->where('hd.is_deleted',INACTIVE)
        ->where('hd.active', ACTIVE)
        ->where('hd.user_id', $formData['user_id'])
        ->whereRaw("(YEAR(from_date) = '2019' AND MONTH(from_date) = '04') AND (YEAR(to_date) = '2019' AND MONTH(to_date) = '04')")
        //->where('hd.to_date', '<=', date('Y-m-d'))
        ->orWhere('hd.type', ACTIVE);
        $holiday_result = $holiday_query->get();
        $holiday_date_array = array();
        $total_holiday_array = array();
        if (count($holiday_result)) {
          foreach ($holiday_result as $holiday_key => $holiday_value) {
            $dates = CustomHelper::getDatesBwTwoDates($holiday_value->from_date,$holiday_value->to_date);
            if (!empty($dates)) {
              foreach ($dates as $dates_key => $dates_value) {
                array_push($holiday_date_array,$dates_value);
              }
            }
          }
        }
        $vendor_total_holidays = 0;
        if (count($holiday_date_array)) {
          $holiday_date_array = array_unique($holiday_date_array);
          $vendor_total_holidays = count($holiday_date_array);
        }
        /*###### find holiday #######*/
        $result2['vendor_total_holidays'] =$vendor_total_holidays;
        $i=1;
        $count = 1;
        foreach ($result as $key => $value) {
          // push the customer id
          array_push($customer_ids,$value->customer_id);
          $address_array[$value->address_id]['address_id'] = $value->address_id;
          $address_array[$value->address_id]['address_name'] = $value->address_name;
          if(isset($address_array[$value->address_id]['no_of_customers'])) {
            $address_array[$value->address_id]['no_of_customers'] = $address_array[$value->address_id]['no_of_customers'] + 1;
          } else {
            $address_array[$value->address_id]['no_of_customers'] = 1;
          }
          $address_array[$value->address_id]['customers'][] = $value;
          if(isset($value->paid_amount) && $value->paid_amount > 0) {
            $result2['billed_customers'] = $count;
          }
          $result2['total_customers'] = $count;
          $count++;
        }
        // append customers newspapers
        foreach ($result as $main_key => $main_value) {
          $newspaper_result  = DB::table('monthly_bill as mb')
          				->join('dropdown_managers as dm','mb.newspaper_id','=','dm.id')
          				->join('dropdown_manager_descriptions as dmd','dm.id','=','dmd.parent_id')
                  ->where("dm.dropdown_type","newspapers")
                  ->where('dm.status',ACTIVE)
                  ->where('dmd.language_id',$language_id)
                  ->where('mb.customer_id',$main_value->customer_id)
                  ->where('mb.month',$main_value->month)
                  ->where('mb.year',$main_value->year)
          				->select('dmd.name as newspaper_name')
          				->get();
          $result[$main_key]->newspaperData = $newspaper_result ?? array();
        }
        //pr($result);die;
        $result2['unbilled_customers'] = $result2['total_customers'] - $result2['billed_customers'];
        if (count($customer_ids)) {
          $vendor_holiday = $customer_ids;
        }
        $result2['addressData'] = array_values($address_array);
        // make directory of each vendor using vendor id
        $dir_name = base_path().'/pdf/vendor_'.$formData['user_id'];
        if (!file_exists($dir_name)) {
            mkdir($dir_name,0777, true);
        }
        $dateObj   = \DateTime::createFromFormat('!m', $formData['month']);
        $monthName = $dateObj->format('F');
        $filName = "Bill_".$monthName."_".$formData['year'].".pdf";
        $file_location = $dir_name."/".$filName;
        $result2['monthName'] = $monthName;
        $result2['year'] = $formData['year'];

        $only_file_path = 'pdf/vendor_'.$formData['user_id'].'/'.$filName;
        $check_bill = DB::table("monthly_statement")
            ->where("vendor_id",$formData["user_id"])
            ->where("month",$formData["month"])
            ->where("year",$formData["year"])
            ->first();
        if (!empty($check_bill)) {
          $file_location = $dir_name.$check_bill->path;
        }else {
          $insert = array(
            "vendor_id"=>$formData['user_id'],
            "month"=>$formData['month'],
            "year"=>$formData['year'],
            "path"=>$only_file_path,
            "created_at"=>Date("Y-m-d H:i:s"),
          );
          DB::table("monthly_statement")->insert($insert);
          if (!file_exists($file_location)) {
            $pdf = \PDF::loadView('bill/bill',compact('result2'))->save($file_location);
            chmod($file_location, 0777);
          }
        }
        $url = WEBSITE_URL.$only_file_path;
        // send mail to customer
        $settingsEmail 			=	Config::get('Site.email');
        $full_name				  =	$vendorData->full_name;
        if (isset($formData['email']) && !empty($formData['email'])) {
          $email = $formData['email'];
        }else {
          $email				      =	$vendorData->email;
        }
        $route_url      		=  	$url;
        $link 					    =   $route_url;
        $click_link 			  = '<a target="_blank" style="font-weight:bold;text-decoration:none;color:#4286f4;" href="' . $link . '">Click Here</a>';

        $emailActions			   = 	EmailAction::where('action','=','monthly_statement')->get()->toArray();

        $emailTemplates			= 	EmailTemplate::where('action','=','monthly_statement')
                        ->get(array('name','subject','action','body'))->toArray();

        $cons 					= 	explode(',',$emailActions[0]['options']);

        $constants 				= 	array();

        foreach($cons as $key => $val){
          $constants[] 		= 	'{'.$val.'}';
        }

        //$subject 				= 	$emailTemplates[0]['subject'];
        $subject          =   "Bill Statement For ".$monthName."-".$formData['year'];
        $rep_Array 				= 	array($full_name,$monthName,$formData['year'],$click_link,$route_url);
        $messageBody			= 	str_replace($constants, $rep_Array, $emailTemplates[0]['body']);
        //pr($messageBody);die;
        $mail					= 	$this->sendMail($email,$full_name,$subject,$messageBody,$settingsEmail);
        return Response::json(["status"=>"success","message"=>"Email sent"]);
      }else {
        return Response::json(["status"=>"error","message"=>"No Record Found"]);
      }
    }
  } // end send()


} // end MonthlyStatementController class
