<?php

namespace App\Http\Controllers\Api\V1;

use App\Http\Controllers\Controller;
use App\Http\Controllers\BaseController;
use Illuminate\Http\Request;
use JWTFactory;
use JWTAuth;
use App\User;
use App\Model\OTP;
use App\Model\EmailAction;
use App\Model\EmailTemplate;
use App\libraries\CustomHelper;
use Str,Auth,Blade,Config,Cache,Cookie,DB,File,Hash,Input,Mail,Redirect,Response,Session,URL,View,Validator;
use Carbon\Carbon;

class SocialLoginController extends BaseController
{
  public function login(Request $request)
  {
      $validator = Validator::make($request->all(), [
          'provider' => 'required',
          'provider_id'=> 'required'
      ]);
      if ($validator->fails()) {
        $message = "Please fill all required fields.";
        $message = $validator->errors()->getMessages();
        if (isset($message['provider']) && !empty($message['provider'])) {
          $message = $message['provider'][0];
        }
        if (isset($message['provider_id']) && !empty($message['provider_id'])) {
          $message = $message['provider_id'][0];
        }
        return Response::json(["status"=>"error","message"=>$message]);
      }
      $formData				=	Input::all();
      $loginData	=	User::where('provider',$formData['provider'])->where('provider_id',$formData['provider_id'])->where('user_role_id',VENDOR)->first();
      if(!empty($loginData)){
         $token = JWTAuth::fromUser($loginData);
        return response()->json(['status'=>'success','message'=>'Logged in successfully.','data'=>$loginData,"token"=>@$token]);
        die;
       }else{
        return response()->json(['status'=>'error','message'=>trans("Please register first.")]);
        die;
      }
  } // end

} // end SocialLoginController class
