<?php

namespace App\Http\Controllers\Api\V1;

use App\Http\Controllers\Controller;
use App\Http\Controllers\BaseController;
use Illuminate\Http\Request;
use JWTFactory;
use JWTAuth;
use App\User;
use App\Model\OTP;
use App\Model\Address;
use App\Model\EmailAction;
use App\Model\EmailTemplate;
use App\Model\Stop_newspaper_delivery;
use App\Model\Holiday;
use App\libraries\CustomHelper;
use Str,Auth,Blade,Config,Cache,Cookie,DB,File,Hash,Input,Mail,Redirect,Response,Session,URL,View,Validator;
use Carbon\Carbon;

class StopNewspaperDeliveryController extends BaseController
{
  /*
  * search address or customer
  */
  public function search_address_customer(Request $request)
  {
    $formData       = Input::all();
    $message = array();
    $validate = array(
        'user_id'=> 'required',
        'search_data'=> 'required',
      );
    $validator = Validator::make(Input::all(),$validate,$message);
    if ($validator->fails()) {
      $message = "Please fill all required fields.";
      $messages = $validator->errors()->getMessages();
      $messages = array_reverse($messages);
      foreach ($messages as $key => $value) {
        $message = $value[0];
      }
      return Response::json(["status"=>"error","message"=>$message]);
    }else {
      $address_query = Address::select('address_name','id as address_id','address_type_id')
              ->where('user_id',$formData['user_id'])
              ->where('is_deleted','!=',ACTIVE)
              ->where('active', ACTIVE)
              ->where('address_name', 'like', '%' . $formData['search_data'] . '%')
              ->groupBy('id')
              ->get();
      if (count($address_query)) {
        foreach ($address_query as $key => $value) {
          $address_query[$key]->search_type = 1;
        }
      }
      $customer_query = User::select('full_name','id as customer_id')
              ->where('vendor_id',$formData['user_id'])
              ->where('is_deleted','!=',ACTIVE)
              ->where('active', ACTIVE)
              ->where('user_role_id', USER)
              ->where('full_name', 'like', '%' . $formData['search_data'] . '%')
              ->groupBy('id')
              ->get();
      if (count($customer_query)) {
        foreach ($customer_query as $key => $value) {
          $customer_query[$key]->search_type = 2;
        }
      }
      // merge both results,
      foreach($address_query as $address_query) {
          $customer_query->add($address_query);
      }
      $result = $customer_query->toArray();
      $response = $result ?? array();
      return Response::json(["status"=>"success","data"=>$response]);
    }
  } // end
  /*
  * choose search option
  */
  public function choose_search_option(Request $request)
  {
    $formData       = Input::all();
    $message = array();
    $validate = array(
        'user_id'=> 'required',
        'search_type'=> 'required',
      );
      if ( isset($formData['search_type']) && ($formData['search_type'] == 1)) {
        $validate['address_type_id'] = "required";
        if ($formData['search_type'] == 1 && (@$formData['address_type_id'] == BUILDING OR @$formData['address_type_id'] == CHAWL)) {
          $validate['address_id'] = "required";
        }
      }else {
        $validate['customer_id'] = "required";
      }
    $validator = Validator::make(Input::all(),$validate,$message);
    if ($validator->fails()) {
      $message = "Please fill all required fields.";
      $messages = $validator->errors()->getMessages();
      $messages = array_reverse($messages);
      foreach ($messages as $key => $value) {
        $message = $value[0];
      }
      return Response::json(["status"=>"error","message"=>$message]);
    }else {
      $response = array();
      $language_id = $formData['language_id'] ?? Config::get('default_language.language_code');
      // for customer type
      if ($formData['search_type'] == 2 OR (@$formData['address_type_id'] == SHOP OR @$formData['address_type_id'] == BUNGALOW)) {
        $query = DB::table("users as u")
        ->join('address as add','u.address_id','=','add.id')
        ->select('u.id as customer_id','u.full_name','u.flat_number','add.id as address_id','add.address_name')
        ->where('add.user_id',$formData['user_id'])
        ->where('u.id',$formData['customer_id'])
        ->where('add.is_deleted','!=',ACTIVE)
        ->where('add.active', ACTIVE)
        ->where('u.user_role_id', USER)
        ->first();
        if (!empty($query)) {
          $response['customerData'] = $query;
          $paper_query = DB::table("customers_newspapers as cnp");
          $paper_query->select('cnp.id as customer_newspaper_id','cnp.newspaper_id','dmd.name as newspaper_name')
          ->join("dropdown_managers as dm",'cnp.newspaper_id','=','dm.id')
          ->join('dropdown_manager_descriptions as dmd','dm.id','=','dmd.parent_id')
          ->where("dm.dropdown_type","newspapers")
          ->where('dm.status',ACTIVE)
          ->where('dmd.language_id',$language_id)
          ->where('cnp.is_deleted',INACTIVE)
          ->where('cnp.status', ACTIVE);
          $paper_query->groupBy('cnp.newspaper_id');
          $paper_query->where('cnp.customer_id',$formData['customer_id']);
          $newspaperData = $paper_query->get();
          $response['newspaperData'] = $newspaperData;
          //pr($response);die;
        }
      } elseif ($formData['search_type'] == 1 && ($formData['address_type_id'] == BUILDING OR  $formData['address_type_id'] == CHAWL)) {
        $query = DB::table("users as u")
        ->join('address as add','u.address_id','=','add.id')
        ->select('u.id as customer_id','u.flat_number')
        ->where('u.address_id',$formData['address_id'])
        ->where('add.address_type_id',$formData['address_type_id'])
        ->where('add.is_deleted','!=',ACTIVE)
        ->where('add.active', ACTIVE)
        ->where('u.user_role_id', USER)
        ->where('u.vendor_id', $formData['user_id'])
        ->get();
        $response['flatData'] = $query;
      }
      return Response::json(["status"=>"success","data"=>$response]);
    }
  } // end
  /*
  * get customer paper data
  * this is for when choose building then flat number
  */
  public function get_flat_customer_paper_data(Request $request)
  {
    $formData       = Input::all();
    $message = array();
    $validate = array(
        'user_id'=> 'required',
        'customer_id'=> 'required',
      );
    $validator = Validator::make(Input::all(),$validate,$message);
    if ($validator->fails()) {
      $message = "Please fill all required fields.";
      $messages = $validator->errors()->getMessages();
      $messages = array_reverse($messages);
      foreach ($messages as $key => $value) {
        $message = $value[0];
      }
      return Response::json(["status"=>"error","message"=>$message]);
    }else {
      $response = array();
      $language_id = $formData['language_id'] ?? Config::get('default_language.language_code');
      // for customer type
      if ($formData['customer_id']) {
        $query = DB::table("users as u")
        ->join('address as add','u.address_id','=','add.id')
        ->select('u.id as customer_id','u.full_name','u.flat_number','add.address_name')
        ->where('add.user_id',$formData['user_id'])
        ->where('u.id',$formData['customer_id'])
        ->where('add.is_deleted','!=',ACTIVE)
        ->where('add.active', ACTIVE)
        ->where('u.user_role_id', USER)
        ->first();
        if (!empty($query)) {
          $response['customerData'] = $query;
          $paper_query = DB::table("customers_newspapers as cnp");
          $paper_query->select('cnp.id as customer_newspaper_id','cnp.newspaper_id','dmd.name as newspaper_name')
          ->join("dropdown_managers as dm",'cnp.newspaper_id','=','dm.id')
          ->join('dropdown_manager_descriptions as dmd','dm.id','=','dmd.parent_id')
          ->where("dm.dropdown_type","newspapers")
          ->where('dm.status',ACTIVE)
          ->where('dmd.language_id',$language_id)
          ->where('cnp.is_deleted',INACTIVE)
          ->where('cnp.status', ACTIVE);
          $paper_query->groupBy('cnp.newspaper_id');
          $paper_query->where('cnp.customer_id',$formData['customer_id']);
          $newspaperData = $paper_query->get();
          $response['newspaperData'] = $newspaperData;
          //pr($response);die;
        }
      }
      return Response::json(["status"=>"success","data"=>$response]);
    }
  } // end
  /*
  * add
  */
  public function add(Request $request)
  {
    $formData       = Input::all();
    $message = array();
    $validate = array(
        'address_id'=> 'required',
        'customer_id'=> 'required',
        //'caption'=> 'required',
      );
      if (isset($formData['is_same_date']) && ($formData['is_same_date'] == 1)) {
        $validate['from_date'] = 'required';
        $validate['to_date'] = 'required';
      }
    $validator = Validator::make(Input::all(),$validate,$message);
    if ($validator->fails()) {
      $message = "Please fill all required fields.";
      $messages = $validator->errors()->getMessages();
      $messages = array_reverse($messages);
      foreach ($messages as $key => $value) {
        $message = $value[0];
      }
      return Response::json(["status"=>"error","message"=>$message]);
    }else {
      $language_id = $formData['language_id'] ?? Config::get('default_language.language_code');
      if (!isset($formData['newspaperData']) OR empty($formData['newspaperData'])) {
        return Response::json(["status"=>"error","message"=>"Sorry, you have no to stop."]);
      }
      $paper_data = json_decode($formData['newspaperData']);
      foreach ($paper_data as $key => $value) {
        $check_already_stop = DB::table("stop_newspaper_delivery as snd")
                            ->join("stop_delivery_meta as sdm",'snd.id','=','sdm.snd_id')
                            ->join("dropdown_managers as dm",'sdm.newspaper_id','=','dm.id')
                            ->join('dropdown_manager_descriptions as dmd','dm.id','=','dmd.parent_id')
                            ->select('dmd.name as newspaper_name','sdm.from_date','sdm.to_date')
                            ->where("dm.dropdown_type","newspapers")
                            ->where('dm.status',ACTIVE)
                            ->where('dmd.language_id',$language_id)
                            ->where("snd.customer_id",$formData['customer_id'])
                            ->where('sdm.newspaper_id',$value->newspaper_id)
                            ->first();
        if (!empty($check_already_stop)) {
          return Response::json(["status"=>"error","message"=>"$check_already_stop->newspaper_name has been already stopped.","data"=>$check_already_stop]);
        }
      }
      $obj                = new Stop_newspaper_delivery;
      $obj->address_id    = $formData['address_id'];
      $obj->customer_id   = $formData['customer_id'];
      $obj->active        = ACTIVE;
      $obj->is_same_date  = $formData['is_same_date'] ?? 0;
      $obj->save();
      foreach ($paper_data as $key => $value) {
        $insert_data = array(
          "newspaper_id" => $value->newspaper_id,
          "snd_id" => $obj->id,
          "caption" => $formData['caption'] ?? ""
        );
        if (isset($formData['is_same_date']) && ($formData['is_same_date'] == 1)) {
          $insert_data['from_date'] = $formData['from_date'];
          $insert_data['to_date'] = $formData['to_date'];
          $insert_data['total_leave'] = CustomHelper::countDays($formData['from_date'],$formData['to_date']);
        }else {
          $insert_data['from_date'] = $value->from_date;
          $insert_data['to_date'] = $value->to_date;
          $insert_data['total_leave'] = CustomHelper::countDays($value->from_date,$value->to_date);
        }
        DB::table("stop_delivery_meta")->insert($insert_data);
      }
      if($obj){
        return Response::json(["status"=>"success","message"=>"Record added successfully."]);
      }else {
        return Response::json(["status"=>"error","message"=>"Failed to save the record."]);
      }
    }
  } // end

  /*
  * get get stop delivery list
  */
  public function index(Request $request)
  {
    $formData       = Input::all();
    $message = array();
    $validate = array(
        'user_id'=> 'required',
      );
    $validator = Validator::make(Input::all(),$validate,$message);
    if ($validator->fails()) {
      $message = "Please fill all required fields.";
      $messages = $validator->errors()->getMessages();
      $messages = array_reverse($messages);
      foreach ($messages as $key => $value) {
        $message = $value[0];
      }
      return Response::json(["status"=>"error","message"=>$message]);
    }else {
      $language_id = $formData['language_id'] ?? Config::get('default_language.language_code');
      $query = DB::table("stop_newspaper_delivery as snd")
              ->join("users as u",'snd.customer_id','=','u.id')
              ->join('address as add','u.address_id','=','add.id')
              ->select('snd.id as snd_id','u.id as customer_id','u.full_name','u.flat_number','add.id as address_id','add.address_name','add.address_type_id')
              ->where('add.user_id',$formData['user_id'])
              ->where('add.is_deleted','!=',ACTIVE)
              ->where('add.active', ACTIVE)
              ->where('snd.active', ACTIVE)
              ->where('snd.is_deleted', INACTIVE)
              ->where('u.user_role_id', USER)
              ->where('u.vendor_id',$formData['user_id'])
              ->get();
      if (!empty($query)) {
        $dates = array();
        foreach ($query as $key => $value) {
          $newspaperData = DB::table("stop_delivery_meta")->select('from_date','to_date')->where("snd_id",$value->snd_id)->get();
          $totol_papers = $newspaperData ? count($newspaperData) : 0;
          if (!empty($newspaperData)) {
            foreach ($newspaperData as $key2 => $value2) {
              array_push($dates,$value2->from_date);
              array_push($dates,$value2->to_date);
            }
          }
          $query[$key]->start_date = min($dates);
          $query[$key]->end_date = max($dates);
          $query[$key]->totol_papers = $totol_papers;
        }
      }
      $response['results'] = $query ?? array();
      return Response::json(["status"=>"success","data"=>$response]);
    }
  } // end

  /*
  * get preview stop delivery
  */
  public function preview(Request $request)
  {
    $formData       = Input::all();
    $message = array();
    $validate = array(
        'user_id'=> 'required',
        'snd_id'=> 'required',
      );
    $validator = Validator::make(Input::all(),$validate,$message);
    if ($validator->fails()) {
      $message = "Please fill all required fields.";
      $messages = $validator->errors()->getMessages();
      $messages = array_reverse($messages);
      foreach ($messages as $key => $value) {
        $message = $value[0];
      }
      return Response::json(["status"=>"error","message"=>$message]);
    }else {
      $language_id = $formData['language_id'] ?? Config::get('default_language.language_code');
      $query = DB::table("stop_newspaper_delivery as snd")
              ->join("users as u",'snd.customer_id','=','u.id')
              ->join('address as add','u.address_id','=','add.id')
              ->select('snd.id as snd_id ','u.id as customer_id','u.full_name','u.flat_number','add.id as address_id','add.address_name','add.address_type_id')
              ->where('add.user_id',$formData['user_id'])
              ->where('add.is_deleted','!=',ACTIVE)
              ->where('add.active', ACTIVE)
              ->where('u.user_role_id', USER)
              ->where('u.vendor_id',$formData['user_id'])
              ->where('snd.active',ACTIVE)
              ->where('snd.is_deleted',INACTIVE)
              ->where('snd.id',$formData['snd_id'])
              ->first();
      $response['customerData'] = $query ?? array();
      if (!empty($query)) {
        $newspaperData = DB::table("stop_delivery_meta as sdm")
                ->join("stop_newspaper_delivery as snd",'sdm.snd_id','=','snd.id')
                ->join("dropdown_managers as dm",'sdm.newspaper_id','=','dm.id')
                ->join('dropdown_manager_descriptions as dmd','dm.id','=','dmd.parent_id')
                ->where("dm.dropdown_type","newspapers")
                ->where('dm.status',ACTIVE)
                ->where('dmd.language_id',$language_id)
                ->select('dmd.name as newspaper_name','snd.customer_id','snd.address_id','snd.is_same_date','sdm.newspaper_id','sdm.from_date','sdm.to_date','sdm.caption','sdm.total_leave')
                ->where('snd.active',ACTIVE)
                ->where('snd.is_deleted',INACTIVE)
                ->where('snd.id',$formData['snd_id'])
                ->get();
        $response['newspaperData'] = $newspaperData;
      }
      return Response::json(["status"=>"success","data"=>$response]);
    }
  } // end

  /*
  * get for edit
  */
  public function get(Request $request)
  {
    $formData       = Input::all();
    $message = array();
    $validate = array(
        'user_id'=> 'required',
        'snd_id'=> 'required',
      );
    $validator = Validator::make(Input::all(),$validate,$message);
    if ($validator->fails()) {
      $message = "Please fill all required fields.";
      $messages = $validator->errors()->getMessages();
      $messages = array_reverse($messages);
      foreach ($messages as $key => $value) {
        $message = $value[0];
      }
      return Response::json(["status"=>"error","message"=>$message]);
    }else {
      $language_id = $formData['language_id'] ?? Config::get('default_language.language_code');
      $query = DB::table("stop_newspaper_delivery as snd")
              ->join("users as u",'snd.customer_id','=','u.id')
              ->join('address as add','u.address_id','=','add.id')
              ->select('snd.id as snd_id ','snd.is_same_date','u.id as customer_id','u.full_name','u.flat_number','add.id as address_id','add.address_name','add.address_type_id')
              ->where('add.user_id',$formData['user_id'])
              ->where('add.is_deleted','!=',ACTIVE)
              ->where('add.active', ACTIVE)
              ->where('u.user_role_id', USER)
              ->where('u.vendor_id',$formData['user_id'])
              ->where('snd.active',ACTIVE)
              ->where('snd.is_deleted',INACTIVE)
              ->where('snd.id',$formData['snd_id'])
              ->first();
      $response['customerData'] = $query ?? array();
      if (!empty($query)) {
        $newspaperData = DB::table("stop_delivery_meta as sdm")
                ->join("stop_newspaper_delivery as snd",'sdm.snd_id','=','snd.id')
                ->join("dropdown_managers as dm",'sdm.newspaper_id','=','dm.id')
                ->join('dropdown_manager_descriptions as dmd','dm.id','=','dmd.parent_id')
                ->where("dm.dropdown_type","newspapers")
                ->where('dm.status',ACTIVE)
                ->where('dmd.language_id',$language_id)
                ->select('dmd.name as newspaper_name','sdm.newspaper_id','sdm.from_date','sdm.to_date','sdm.caption')
                ->where('snd.active',ACTIVE)
                ->where('snd.is_deleted',INACTIVE)
                ->where('snd.id',$formData['snd_id'])
                ->get();
        $response['newspaperData'] = $newspaperData;
      }
      return Response::json(["status"=>"success","data"=>$response]);
    }
  } // end

  /*
  * add
  */
  public function update(Request $request)
  {
    $formData       = Input::all();
    $message = array();
    $validate = array(
        'user_id'=> 'required',
        'customer_id'=> 'required',
        'snd_id'=> 'required',
      );
    $validator = Validator::make(Input::all(),$validate,$message);
    if ($validator->fails()) {
      $message = "Please fill all required fields.";
      $messages = $validator->errors()->getMessages();
      $messages = array_reverse($messages);
      foreach ($messages as $key => $value) {
        $message = $value[0];
      }
      return Response::json(["status"=>"error","message"=>$message]);
    }else {
      $language_id = $formData['language_id'] ?? Config::get('default_language.language_code');
      if (!isset($formData['newspaperData']) OR empty($formData['newspaperData'])) {
        return Response::json(["status"=>"error","message"=>"Sorry, you have no to stop."]);
      }
      $paper_data = json_decode($formData['newspaperData']);

      $obj   = Stop_newspaper_delivery::find($formData['snd_id']);
      if (empty($obj)) {
        return Response::json(["status"=>"error","message"=>"Sorry, record can not update."]);
      }
      $newspaper_ids = array();
      foreach ($paper_data as $key => $value) {
        array_push($newspaper_ids,$value->newspaper_id);
      }
      $meta_data = DB::table("stop_delivery_meta")->where("snd_id",$obj->id)->whereIn('newspaper_id',$newspaper_ids)->delete();
      foreach ($paper_data as $key => $value) {
        $insert_data = array(
          "newspaper_id" => $value->newspaper_id,
          "snd_id" => $obj->id,
          "caption" => $value->caption ?? ""
        );
        if (isset($formData['is_same_date']) && ($formData['is_same_date'] == 1)) {
          $insert_data['from_date'] = $formData['from_date'];
          $insert_data['to_date'] = $formData['to_date'];
          $insert_data['total_leave'] = CustomHelper::countDays($formData['from_date'],$formData['to_date']);
        }else {
          $insert_data['from_date'] = $value->from_date;
          $insert_data['to_date'] = $value->to_date;
          $insert_data['total_leave'] = CustomHelper::countDays($value->from_date,$value->to_date);
        }
        DB::table("stop_delivery_meta")->insert($insert_data);
      }
      if($obj){
        return Response::json(["status"=>"success","message"=>"Record updated successfully."]);
      }else {
        return Response::json(["status"=>"error","message"=>"Failed to save the record."]);
      }
    }
  } // end

  public function delete(){
    $formData = Input::all();
    $message = array();
    $validate = array(
        'customer_id'=> 'required',
        'snd_id'=> 'required',
      );
    $validator = Validator::make(Input::all(),$validate,$message);
    if ($validator->fails()) {
      $message = "Please fill all required fields.";
      $messages = $validator->errors()->getMessages();
      $messages = array_reverse($messages);
      foreach ($messages as $key => $value) {
        $message = $value[0];
      }
      return Response::json(["status"=>"error","message"=>$message]);
    }else {
      $snd_id       = $formData['snd_id'];
      $res = Stop_newspaper_delivery::where('id',$snd_id)->where('customer_id',$formData['customer_id'])->update(array('is_deleted'=>ACTIVE));
      if ($res) {
        return Response::json(["status"=>"success","message"=>"Record deleted successfully."]);
      }else {
        return Response::json(["status"=>"error","message"=>"Sorry, try later."]);
      }
    }
	} // end delete()

} // end StopNewspaperDeliveryController class
