<?php

namespace App\Http\Controllers;

use App\Model\DropDown;
use App\Model\Notification;
use App\Model\UserActivity;
use App\Http\Controllers\upload;
use App\Model\NotificationSetting;
use App\libraries\CustomHelper as CustomHelper;
use App\model\CarDetail;
use App\Services\Input;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\View;
use Yajra\DataTables\Facades\DataTables;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Str;
//~ use Twilio;

/**
 * Base Controller
 *
 * Add your methods in the class below
 *
 * This is the base controller called everytime on every request
 */
/* function trans($msg)
 {
 return __($msg);
 } */
class BaseController extends Controller
{

    /**
     * function for construct
     *
     */
    // public function __construct() {
    // 	if (!empty($_SERVER['HTTP_CLIENT_IP'])) {
    // 		$ip = $_SERVER['HTTP_CLIENT_IP'];
    // 	} elseif (!empty($_SERVER['HTTP_X_FORWARDED_FOR'])) {
    // 		$ip = $_SERVER['HTTP_X_FORWARDED_FOR'];
    // 	} else {
    // 		$ip = $_SERVER['REMOTE_ADDR'];
    // 	}

    // 	if(isset($_COOKIE['timezone'])){
    // 		date_default_timezone_get($_COOKIE['timezone']);
    // 	}
    // 	//~ setcookie("test_cookie", "testing", time() + 3600, '/');
    // 	// echo $ip;
    // 	View::share('ip', $ip);
    // 	//~ if($ip =='192.168.10.64'){
    // 		//~ date_default_timezone_set('Asia/Kolkata');
    // 	//~ }else{
    // 		//~ date_default_timezone_set('Australia/Adelaide');
    // 	//~ }
    // 	//~ echo date('Y-m-d H:i A');die;

    // 	date_default_timezone_set('Asia/Kolkata');

    // 	if(Request::segment(1) == 'admin'){

    // 	}
    // 	/* For set default language id*/
    // 	if(!Session::has('currentLanguageId')){
    // 		Session::put('currentLanguageId', Config::get('default_language.language_code'));
    // 	}
    // 	// if (!Cache::has('languages')){
    // 	// 	$languages			=	DB::table('languages')->where('is_active',1)->pluck('title', 'lang_code');
    // 	// 	Cache::forever('languages', $languages);

    // 	// 	$languageDetails	=	DB::table('languages')->where('is_active',1)->pluck('id', 'lang_code');
    // 	// 	Cache::forever('languageDetails', $languageDetails);
    // 	// }
    // 	if(Request::segment(1) == 'admin'){
    // 	}
    // 		App::setLocale('en');
    // 	/* For set meta data */
    // 	if(Request::segment(1) != 'admin'){
    // 		$seo_page_file_path = Request::segment(1);
    // 		if($seo_page_file_path == 'pages'){
    // 			$pagePath				= 	Request::segment(2);
    // 			$seoData				=	DB::table('cms_pages')->select('meta_title','meta_description','meta_keywords')->where('slug',$pagePath)->first();

    // 			if(!empty($seoData)){
    // 				$title				=	$seoData->meta_title;
    // 				$metaKeywords		=	$seoData->meta_keywords;
    // 				$metaDescription	=	$seoData->meta_description;
    // 			}else{
    // 				$title				=	Config::get("Site.title");
    // 				$metaKeywords		=	Config::get("Site.meta_keywords");
    // 				$metaDescription	=	Config::get("Site.meta_description");
    // 			}
    // 		}else{
    // 			$seoData				=	DB::table('metas')->select('meta_title','description','meta_keyword')->where('page_id',$seo_page_file_path)->first();

    // 			if(!empty($seoData)){
    // 				$title				=	$seoData->meta_title;
    // 				$metaKeywords		=	$seoData->meta_keyword;
    // 				$metaDescription	=	$seoData->description;
    // 			}else{
    // 				$title				=	Config::get("Site.title");
    // 				$metaKeywords		=	Config::get("Site.meta_keywords");
    // 				$metaDescription	=	Config::get("Site.meta_description");
    // 			}
    // 		}
    // 		$blocks_how		=	Block::getResult('search-apartments-page',array('id','description','block','block_name','page'));

    // 		View::share('pageTitle', $title);
    // 		View::share('metaKeywords', $metaKeywords);
    // 		View::share('metaDescription', $metaDescription);
    // 		if(Config::get('Debug.version') == null){
    // 			$version = "1.0";
    // 		}else{
    // 			$version = Config::get('Debug.version');
    // 		}
    // 		View::share('version', '?v='.$version);
    // 		View::share('blocks_how', $blocks_how);
    // 		/* For set meta data */
    // 	}
    // 	CustomHelper::globalXssClean();

    // }// end function __construct()

    // /**
    //  * Setup the layout used by the controller.
    //  *
    //  * @return layout
    //  */




    // protected function setupLayout(){
    // 	if(request()->segment(1) != 'admin'){

    // 	}
    // 	if ( ! is_null($this->layout))
    // 	{
    // 		$this->layout = View::make($this->layout);
    // 	}
    // }//end setupLayout()

    /**
     * Function to make slug according model from any certain field
     *
     * @param title     as value of field
     * @param modelName as section model name
     * @param limit 	as limit of characters
     *
     * @return string
     */


    // here we give scratch cards to the users
    /*public function scratchCardsGiveaway(){
		date_default_timezone_set("Asia/Kolkata");
		$users = DB::table('registerusers')->get();
		// echo "<pre/>";
		// print_r($users);die;

		foreach ($users as $key => $value) {
			$array = array();
			$array['user_id'] = $value->id;
			$array['coupon_type'] = COUPON_TYPE_DAILY;
			$array['active'] = ACTIVE_COUPON_CODE;
			$array['is_scratched'] = NOT_SCRATCHED;
			$array['created_at'] = date('Y-m-d H:i:s');
			DB::table('scratch_cards')->insert($array);
		}
	}*/

    /**
     * Function to make slug according model from any certain field
     *

     *
     * @return string
     */


    public function getSlug($title, $fieldName = '', $tableName, $limit = 60)
    {
        $slug         =    substr(Str::slug($title), 0, $limit);
        $slug         =    Str::slug($title);
        $DB         =     DB::table($tableName);
        if ($fieldName == "page") {
            $slugCount     =     count($DB->whereRaw("page REGEXP '^{$slug}(-[0-9]*)?$'")->get());
            return    $slug;
        } else {
            if ($tableName == "blocks") {
                $slugCount     =     count($DB->whereRaw("block REGEXP '^{$slug}(-[0-9]*)?$'")->get());
            } else {
                $slugCount     =     count($DB->whereRaw("slug REGEXP '^{$slug}(-[0-9]*)?$'")->get());
            }
            return ($slugCount > 0) ? $slug . "-" . $slugCount : $slug;
        }
    } //end getSlug()

    /**
     * Function to search result in database
     *

     */
    public function search($data)
    {
        unset($data['display']);
        unset($data['_token']);
        $ret    =    '';
        if (!empty($data)) {
            foreach ($data as $fieldName => $fieldValue) {
                $ret    .=    "where('$fieldName', 'LIKE',  '%' . $fieldValue . '%')";
            }
            return $ret;
        }
    } //end search()

    /**
     * Function to send email form website
     *
     * @param string $to            as to address
     * @param string $fullName      as full name of receiver
     * @param string $subject       as subject
     * @param string $messageBody   as message body
     *
     * @return void
     */
    public function sendMail($to, $fullName, $subject, $messageBody, $from = '', $files = false, $path = '', $attachmentName = '')
    {

        $data                =    array();
        $data['to']            =    $to;
        $data['from']        =    (!empty($from) ? 'Bill@newskart.co.in' : config()->get("Site.email"));
        $data['fullName']    =    $fullName;
        $data['subject']    =    $subject;
        $data['filepath']    =    $path;
        $data['attachmentName']    =    $attachmentName;

        if ($files === false) {
            if (is_array($data['to'])) {

                foreach ($data['to'] as $key => $email) {
                    $data['email']    = $email;
                    Mail::send('emails.template', array('messageBody' => $messageBody), function ($message) use ($data) {
                        $message->to($data['email'], $data['fullName'])->from($data['from'])->subject($data['subject']);
                    });
                }
            } else {

                Mail::send('emails.template', array('messageBody' => $messageBody), function ($message) use ($data) {
                    $message->to($data['to'], $data['fullName'])->from($data['from'])->subject($data['subject']);
                });
            }
        } else {
            if ($attachmentName != '') {
                Mail::send('emails.template', array('messageBody' => $messageBody), function ($message) use ($data) {
                    $message->to($data['to'], $data['fullName'])->from($data['from'])->subject($data['subject'])->attach($data['filepath'], array('as' => $data['attachmentName']));
                });
            } else {
                Mail::send('emails.template', array('messageBody' => $messageBody), function ($message) use ($data) {
                    $message->to($data['to'], $data['fullName'])->from($data['from'])->subject($data['subject'])->attach($data['filepath']);
                });
            }
        }


        DB::table('email_logs')->insert(
            array(
                'email_to'     => $data['to'],
                'email_from' => $data['from'],
                'subject'     => $data['subject'],
                'message'     =>    $messageBody,
                'created_at' => DB::raw('NOW()')
            )
        );
    } //end sendMail()

    /**
     * Function for user profile
     *
     * param userId as user id
     */
    public function userProfile($userId)
    {
        $results                 =    array();
        $results[0]['User']             =     DB::table('users')->where('id', $userId)->first();
        $results[0]['UserProfile']     =     DB::table('user_profiles')->where('user_id', $userId)->get();
        foreach ($results as &$row) {

            if (isset($row['UserProfile']) && (is_array($row))) {
                if (!empty($row['UserProfile'])) {
                    foreach ($row['UserProfile'] as $details) {
                        $fields = explode('.', $details->field_name);
                        $results[0]['User']->$fields[1]    = $details->field_value;
                    }
                    unset($row['UserProfile']);
                }
            }
        }
        return $results[0]['User'];
    } // end userProfile()

    /**
     * Function to convert video in mp4
     *
     * param source target width and height
     */
    public function convertToMp4($source, $target, $width, $height)
    {
        $commandString     = FFMPEG_CONVERT_COMMAND . 'ffmpeg -i ' . $source . ' -vcodec libx264  -speed 8 -qscale 1  -r 30  -ar 44100 -async 1  -f mp4 ' . $target;
        $command         = exec($commandString);
    } //end convertToMp4()

    /**
     * Function to convert video in webm
     *
     * param source target width and height
     */
    public function convertToWebm($source, $target, $width, $height)
    {
        $commandString     = FFMPEG_CONVERT_COMMAND . 'ffmpeg -i ' . $source . ' -vcodec libvpx -speed 8 -acodec libvorbis -qscale 1  -r 30 -ar 44100 -async 1  -f webm ' . $target;
        $command         = exec($commandString);
    } //end convertToWebm()


    /**
     *  Function to generate thumbnails from video
     *
     * param source target width and height
     */
    public function generateThumbnail($source, $target, $width = '', $height = '')
    {
        $commandString     = FFMPEG_CONVERT_COMMAND . 'ffmpeg -i ' . $source . ' -f mjpeg -ss 00:00:01 -frames 1 -vf scale=' . $width . ':' . $height . ' ' . $target;
        $command         = exec($commandString);
    } // end generateThumbnail()

    /* Function to delete file
	 *
	 *@param $mainPath and $fileName
	 *
	 */
    public function deleteFileRecursive($mainPath, $fileName)
    {
        $commandString     =    exec('find ' . $mainPath . ' -type f -name ' . $fileName . '.* -exec rm -rf {} \;');
    } // end deleteFileRecursive()

    /*
	 * Function to upload file from ckeditor
	 *
	 * @param null
	 *
	 */
    public function uploder()
    {
        require_once 'upload_class.php';
        if (isset($_GET['CKEditorFuncNum'])) {
            // where you have put class.upload.php
            $msg = '';                                     // Will be returned empty if no problems
            $callback = ($_GET['CKEditorFuncNum']);        // Tells CKeditor which function you are executing
            if ($_FILES['upload']['type'] == 'image/jpeg' || $_FILES['upload']['type'] == 'image/jpg' || $_FILES['upload']['type'] == 'image/gif' || $_FILES['upload']['type'] == 'image/png') {

                $handle = new upload($_FILES['upload']);       // Create a new upload object
                if ($handle->uploaded) {
                    $handle->image_resize         = false;
                    $handle->process(CK_EDITOR_ROOT_PATH);  // directory for the uploaded image
                    $image_url = CK_EDITOR_URL . $handle->file_dst_name;          // URL for the uploaded image
                    if ($handle->processed) {
                        $handle->clean();
                    } else {
                        $msg =  'error : ' . $handle->error;
                    }
                }
            } else {
                $msg =  'error : Please select image file';
            }
            $output = '<script type="text/javascript">window.parent.CKEDITOR.tools.callFunction(' . $callback . ', "' . $image_url . '","' . $msg . '");</script>';
            echo $output;
            exit;
        } else {
            $this->redirect('/');
        }
    } // end uploder()

    /**
     * Function to get masters
     *
     * @param string $type as type
     *
     * @return $masters
     */
    // public function getMasters($type= null){
    // 	$masters	=	DropDown::where('dropdown_type',$type)->where('parent_category',0)->lists('name', 'id')->toArray();
    // 	return $masters;
    // }//end getMasters()


    /**
     * Function for global xss clean

     */
    // public function globalXssClean(){
    // 	// Recursive cleaning for array [] inputs, not just strings.
    // 	$sanitized = static::arrayStripTags(Input::all());
    // 	//~ $sanitized = static::arrayStripTags($formData);
    // 	Input::merge($sanitized);
    // }// end globalXssClean()


    /**
     * Function for strip and trime data
     *
     * @param array
     *
     * @return array.
     */
    public function arrayStripTags($array)
    {
        $result = array();
        foreach ($array as $key => $value) {
            // Don't allow tags on key either, maybe useful for dynamic forms.
            $key = strip_tags($key, ALLOWED_TAGS_XSS);
            // If the value is an array, we will just recurse back into the
            // function to keep stripping the tags out of the array,
            // otherwise we will set the stripped value.
            if (is_array($value)) {
                $result[$key] = static::arrayStripTags($value);
            } else {
                // I am using strip_tags(), you may use htmlentities(),
                // also I am doing trim() here, you may remove it, if you wish.
                $result[$key] = trim(strip_tags($value, ALLOWED_TAGS_XSS));
            }
        }
        return $result;
    } // end arrayStripTags()

    /******************************** Notification Section ********************************************/
    /**
     * 	Function for Add signle notification
     *
     * @param $userId 			As User Id
     * @param $userRoleId 		As User Role Id
     * @param $notificationType As notification Type
     * @param $title 			As title
     * @param $parentTableId 	As Parent Table Id
     * @param $message 			As message
     * @param $parentUrl 		As parent Url
     * @param $createdBy 		As created By
     * @param $createdRoleId 	As created Role Id
     *
     * @return void
     */
    // public function addSingleNotification($userId='0',$userRoleId='0',$notificationType='',$title = '',$parentTableId=0,$parentUrl='',$message='',$createdBy=0,$createdRoleId=0){
    // 	/** Get Notification Permission **/
    // 	$notificationData		= 	array();
    // 	$allowedNotifications	=	NotificationSetting::where('user_id',$userId)
    // 													->where('last_profile_type',$userRoleId)
    // 													->pluck('notification_type');

    // 	if(!empty($allowedNotifications)){
    // 		$allowedNotifications			=	explode(",",$allowedNotifications);
    // 		if(in_array($notificationType,$allowedNotifications)){
    // 			$postJobObj 					=   new Notification;
    // 			$postJobObj->created_by			=	(!empty($createdBy)) ? $createdBy : Auth::user()->id;
    // 			//~ $postJobObj->created_role_id	=	(!empty($createdRoleId)) ? $createdRoleId : Auth::user()->user_role_id;
    // 			$postJobObj->created_role_id	=	(!empty($createdRoleId)) ? $createdRoleId : Auth::user()->last_profile_type;
    // 			$postJobObj->user_id			=	$userId;
    // 			$postJobObj->user_role_id		=	$userRoleId;
    // 			$postJobObj->title				=	$title;
    // 			$postJobObj->parent_table_id	=	$parentTableId;
    // 			$postJobObj->notification_type	=	$notificationType;
    // 			$postJobObj->message			=	$message;
    // 			$postJobObj->url				=	urldecode($parentUrl);
    // 			$postJobObj->save();

    // 			$postJobObj['id']				=	$postJobObj->id;
    // 			$postJobObj['created']			=	strtotime(date(DATE_FORMAT_WITH_SECOND));
    // 			$postJobObj['is_seen']			=	NOT_SEEN;
    // 			$newData['Notification']		=	$postJobObj->toArray();
    // 			$notificationData[$postJobObj->user_id] = $newData;
    // 		}
    // 	}
    // 	return $notificationData;
    // }// end addSingleNotification()

    /**
     * Function for save user last activity

     * return string
     */
    public function userActivity($sectionId, $activityType, $activityMsg, $userId = 0)
    {
        if (Auth::check() && !empty($userId))
            $userId    =    Auth::user()->id;
        $userActivity                    =    new UserActivity;
        $userActivity->user_id            =    $userId;
        $userActivity->section_id        =    $sectionId;
        $userActivity->activity_type    =    $activityType;
        $userActivity->activity_msg        =    $activityMsg;
        $userActivity->save();
    } // end userActivity()


    /**
     * Function for delete notification when delete parent table data
     *
     * @param $parentTableId 	as parent table id (job or package)
     * @param $notificationType as type
     *
     * return null
     */
    // public function deleteNotification($parentTableId = 0 , $notificationType = 0){
    // 	if(!empty($parentTableId) && !empty($notificationType)){
    // 		Notification::where('parent_table_id',$parentTableId)
    // 					->where('notification_type',$notificationType)
    // 					->delete();
    // 	}
    // 	return ;
    // }// end deleteNotification()

    /**
     * Function to edit media
     *
     * */
    // public function editMediaMasterFuction(){
    // 	if(!empty($formData['image'])){
    // 		$extension 				=	Input::get('image');
    // 		$ext	=	explode('.',$extension );
    // 		$img_origin_ext		=	$ext[1];
    // 		$img_ext = explode(",",IMAGE_EXTENSION);
    // 		if(in_array($img_origin_ext,$img_ext)){
    // 			$fileName				=	time().'-user-image.'.$ext[1];

    // 			if(!empty($formData['media_id'])){
    // 				$mediaFiles	=	Media::where('id',$formData['media_id'])->first();
    // 				if(!empty($mediaFiles)){
    // 					$oldFileName	=	$mediaFiles['image'];

    // 					if($mediaFiles['media_type'] == 'user'){
    // 						$oldPath	=  USER_PROFILE_IMAGE_ROOT_PATH.$oldFileName;
    // 						if (file_exists($oldPath)){
    // 							copy($oldPath, USER_PROFILE_IMAGE_ROOT_PATH.$fileName);
    // 							$obj->image		=	$fileName;
    // 						}else{
    // 							Session::flash('error',  trans("File does not exist in directory.Please upload new image."));
    // 							return Redirect::back()->withInput();
    // 						}
    // 					}
    // 					if($mediaFiles['media_type'] == 'slider'){
    // 						$oldPath	=  SLIDER_ROOT_PATH.$oldFileName;
    // 						if (file_exists($oldPath)){
    // 							copy($oldPath, USER_PROFILE_IMAGE_ROOT_PATH.$fileName);
    // 							$obj->image		=	$fileName;
    // 						}else{
    // 							Session::flash('error',  trans("File does not exist in directory.Please upload new image."));
    // 							return Redirect::back()->withInput();
    // 						}
    // 					}
    // 					if($mediaFiles['media_type'] == 'testimonial'){
    // 						$oldPath	=  TESTIMONIAL_IMAGE_ROOT_PATH.$oldFileName;
    // 						if (file_exists($oldPath)){
    // 							copy($oldPath, USER_PROFILE_IMAGE_ROOT_PATH.$fileName);
    // 							$obj->image		=	$fileName;
    // 						}else{
    // 							Session::flash('error',  trans("File does not exist in directory.Please upload new image."));
    // 							return Redirect::back()->withInput();
    // 						}
    // 					}
    // 					if($mediaFiles['media_type'] == 'media'){
    // 						$oldPath	=  MEDIA_IMAGE_URL_ROOT_PATH.$oldFileName;
    // 						if (file_exists($oldPath)){
    // 							copy($oldPath, USER_PROFILE_IMAGE_ROOT_PATH.$fileName);
    // 							$obj->image		=	$fileName;
    // 						}else{
    // 							Session::flash('error',  trans("File does not exist in directory.Please upload new image."));
    // 							return Redirect::back()->withInput();
    // 						}
    // 					}
    // 				}else{
    // 					Session::flash('error',  trans("File does not exist in directory.Please upload new image."));
    // 					return Redirect::back()->withInput();
    // 				}
    // 			}
    // 		}else{
    // 			Session::flash('error',  trans($this->model.'Invalid Image Extension'));
    // 			return Redirect::back()->withInput();
    // 		}
    // 	}
    // }//end editMediaMasterFuction()

    /**
     * Method for used update discount

     */
    // public function dealer_discount()
    // {

    // 		$formData				=	Input::all();

    // 		if(!empty($formData)){
    //       $message	=	array(
    //             'dealer_discount_percent.numeric'               => 'Discount percent should be number.',
    //             'dealer_discount_percent.required'              => 'Please enter discount percent.',
    //             'dealer_discount_percent.max'              		=> 'Discount percent can not be greater than 100%.',
    //           );
    // 			$validate	=	array(
    // 					'dealer_discount_percent'				    =>	'required|numeric|max:100',
    // 			);
    // 			$validator = Validator::make(Input::all(),$validate,$message);

    // 			if ($validator->fails()){
    // 				$allErrors 		= 	$validator->errors()->toArray();
    // 				return response()->json(['status'=>'error','error'=>$allErrors]);
    // 				die;
    // 			}else{
    // 				if(count($formData['ids']) > 0){
    // 					$ids_array = explode(",",$formData['ids']);
    // 					$ids = array_unique($ids_array);
    // 					$filter_ids = array_filter($ids);
    // 					//pr($filter_ids);die;
    // 					CarDetail::whereIn('id', $filter_ids)->update(array('dealer_discount_percent' => $formData['dealer_discount_percent']));

    // 					foreach ($filter_ids as $key => $car_detail_id) {
    // 						$model 																=	CarDetail::findOrFail($car_detail_id);
    // 						$priceData = CustomHelper::calculateOfferPrice($model);
    // 						$model->offer_price									  =	isset($priceData['offer_price']) && $priceData['offer_price'] > 0 ? $priceData['offer_price'] : 0;
    // 						$model->original_price								=	isset($priceData['original_price']) && $priceData['original_price'] > 0 ? $priceData['original_price'] : 0;
    // 						$model->drive_away_price							=	isset($priceData['drive_away_price']) && $priceData['drive_away_price'] > 0 ? $priceData['drive_away_price'] : 0;
    // 						$model->total_gst							        =	isset($priceData['total_gst']) && $priceData['total_gst'] > 0 ? $priceData['total_gst'] : 0;
    // 						$model->discount_amount							  =	isset($priceData['discount_amount']) && $priceData['discount_amount'] > 0 ? $priceData['discount_amount'] : 0;
    // 						$model->automotive_commision					=	isset($priceData['automotive_commision']) && $priceData['automotive_commision'] > 0 ? $priceData['automotive_commision'] : 0;
    // 						$model->save();
    // 					}

    // 				}
    // 				session::flash('flash_notice','You have successfully the discount percentage.');
    //         return response()->json(['status'=>'success',trans("You have successfully the discount percentage.")]);
    // 				 die;
    // 			}
    // 		}else{
    // 			return response()->json(['status'=>'empty']);
    // 			die;
    // 		}
    // }

    /*
	* function to validate discount period
    * @return bool
	*/
    public function validateDiscountPeriod($diff_in_hours = 0): bool
    {
        if (isset($diff_in_hours) && config()->get('Discount.period') > 0 && $diff_in_hours > config()->get('Discount.period')) {
            Session::flash('error',  config()->get('Discount.period_message'));
            return true;
        } else {
            return false;
        }
    } // end

    ///Send Push Notification
    // public static function sendnotification($title,$message,$include_image,$regId){
    // 		require_once('./sendnotification/firebase.php');
    // 	    require_once('./sendnotification/push.php');
    // 		if($regId!=""){
    // 			$findappids = DB::table('androidappid')->where('userid',$regId)->get();
    // 			if(!empty($findappids)){
    // 				foreach($findappids as $app){
    // 					$firebase = new Firebase();
    // 					$push = new Push();
    // 					$payload = array();
    // 					$payload['team'] = 'India';
    // 					$payload['score'] = '5.6';
    // 					$push->setTitle($title);
    // 					$push->setMessage($message);
    // 					$push_type='individual';
    // 					if ($include_image!="") {
    // 						$push->setImage($include_image);
    // 					} else {
    // 						$push->setImage('');
    // 					}
    // 					$push->setIsBackground(FALSE);
    // 					$push->setPayload($payload);
    // 					$json = '';
    // 					$response = '';
    // 					if ($push_type == 'topic') {
    // 						$json = $push->getPush();
    // 						$response = $firebase->sendToTopic('global', $json);
    // 					} else if ($push_type == 'individual') {
    // 						$json = $push->getPush();
    // 						$response = $firebase->send($app->appkey, $json);
    // 					}
    // 				}
    // 			}
    // 		}
    // 	}

}// end BaseController class
