<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;
use App\Http\Controllers\BaseController;
use App\Model\AdminUser;
use App\Models\User;
use App\Models\Payment;
use App\Model\EmailAction;
use App\Model\EmailTemplate;
use App\libraries\CustomHelper;
use mjanssen\BreadcrumbsBundle\Breadcrumbs;
use Twilio\Rest\Client;
use App\Services\Input;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Support\Facades\Response;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\View;
use Yajra\DataTables\Facades\DataTables;
use Illuminate\Support\Str;

class BillPaymentController extends BaseController
{
  public function __construct() {
  }
  /*
  * Function to return view of bill page
  */
    public function index($month_year,$customer_id,$validate_string)
    {
      $result = array();
      $result = DB::table("bill_url")
              ->where("customer_id",base64_decode($customer_id))
              ->where("validate_string",$validate_string)
              ->where('is_expired',INACTIVE)
              ->orderBy('id','desc')
              ->first();
      //pr($result);die;
      if (empty($result)) {
        Session::flash('error',  trans("Link Expired."));
        return Redirect::route('Bill.link_expired');
      }
      $bill_data = DB::table("bill_url as bu")
              ->join('billings as bil','bu.bill_id','=','bil.id')
              ->join('users as c','bu.customer_id','=','c.id')
              ->where("bu.validate_string",$validate_string)
              ->where('bu.is_expired',INACTIVE)
              ->select('bil.*','c.full_name','c.phone','c.email','c.vendor_id')
              ->orderBy('bu.id','desc')
              ->first();
      if (empty($bill_data)) {
        Session::flash('error',  trans("No bill link found."));
        return Redirect::route('Bill.link_expired');
      }
      $vendor_data = User::find($bill_data->vendor_id);
      //pr($vendor_data);die;
      //pr($vendor_data);die;
      return view('bill.index',compact('result','month_year','bill_data','vendor_data','customer_id','validate_string'));
    } // end index()

  /*
  * Function to return view of do payment
  */
    public function do_payment($bill_url_id,$customer_id,$validate_string)
    {

      $formData = Input::all();
      $result = array();
      $vendorSplit = array();
      $admin_bank_detail = CustomHelper::getBankDetail(0,1);
      $admin_fulldata = DB::table("users as u")
                          ->join("address as add","u.address_id","=","add.id")
                          ->join("states as s","u.state_id","=","s.id")
                          ->join("cities as c","u.city_id","=","c.id")
                          ->where("u.user_role_id",SUPER_ADMIN)
                          ->select("u.id","u.full_name","u.vendor_commission","u.cashfree_vendor_id","u.email","u.phone","u.flat_number","u.newspaper_agency_name","add.address","add.pin_code","s.name as state_name","c.name as city_name")
                          ->first();
                          //pr($admin_bank_detail);die;
      if (isset($admin_bank_detail->cashfree_vendor_id) && !empty($admin_bank_detail->cashfree_vendor_id)) {
        // $vendorSplit[] = array(
        //   "vendorId" => $admin_bank_detail->cashfree_vendor_id,
        //   "commission" => $admin_bank_detail->vendor_commission,
        // );
      }else {
        $cashfree_vendor_id = "VDR".sprintf("%s%06d", date("dmHi"), $admin_fulldata->id);
        $post_data = [
          "vendorId"      =>  $cashfree_vendor_id,
          "name"          =>  $admin_fulldata->full_name,
          "email"         =>  $admin_fulldata->email,
          "phone"         =>  $admin_fulldata->phone,
          "bankAccount"   =>  $admin_bank_detail->account_number,
          "accountHolder"    =>  $admin_bank_detail->account_holder_name,
          "ifsc"          =>  $admin_bank_detail->ifsc,
          "address1"      =>  config()->get("Site.title"),
          "address2"      =>  $admin_fulldata->address,
          "city"          =>  $admin_fulldata->city_name,
          "state"         =>  $admin_fulldata->state_name,
          "pincode"       =>  $admin_fulldata->pin_code,
        ];
        $post_url = "/ces/v1/addVendor";
        $res = CustomHelper::cashfree_split($post_url,$post_data);
        if (!empty($res) && @$res->status == "SUCCESS") {
          // $vendorSplit[] = array(
          //   "vendorId" => $cashfree_vendor_id,
          //   "commission" => $admin_bank_detail->vendor_commission,
          // );
          DB::table("users")->where("id",$admin_fulldata->id)->update(["cashfree_vendor_id"=>$cashfree_vendor_id]);
        }else {
          Session::flash('error',  trans(@$res->message));
        }
        //pr($post_data);die;
      }
      $vendor_data = CustomHelper::checkUserParent($customer_id,1);
      $vendor_fulldata = DB::table("users as u")
                          ->join("address as add","u.address_id","=","add.id")
                          ->join("states as s","u.state_id","=","s.id")
                          ->join("cities as c","u.city_id","=","c.id")
                          ->where("u.user_role_id",VENDOR)
                          ->select("u.id","u.full_name","u.vendor_commission","u.cashfree_vendor_id","u.email","u.phone","u.flat_number","u.newspaper_agency_name","add.address","add.pin_code","s.name as state_name","c.name as city_name")
                          ->first();
                          //pr($vendor_fulldata);die;
      if ($vendor_data) {
        $vendor_bank_detail = CustomHelper::getBankDetail($vendor_data->id);
        if (!empty($vendor_bank_detail)) {
          if (isset($vendor_bank_detail->cashfree_vendor_id) && !empty($vendor_bank_detail->cashfree_vendor_id)) {
            // vendor commission
            if (isset($vendor_bank_detail->vendor_commission) && $vendor_bank_detail->vendor_commission >= 0) {
              $vendorSplit[] = array(
                "vendorId" => $vendor_bank_detail->cashfree_vendor_id,
                "commission" => (100-$vendor_bank_detail->vendor_commission),
              );
              // admin commission
              $vendorSplit[] = array(
                "vendorId" => $admin_bank_detail->cashfree_vendor_id,
                "commission" => isset($vendor_bank_detail->vendor_commission) && $vendor_bank_detail->vendor_commission >= 0 ? $vendor_bank_detail->vendor_commission : 0,
              );
            }else{
              $vendorSplit[] = array(
                "vendorId" => $vendor_bank_detail->cashfree_vendor_id,
                "commission" => 100,
              );
              // admin commission
              $vendorSplit[] = array(
                "vendorId" => $admin_bank_detail->cashfree_vendor_id,
                "commission" => 0,
              );
            }

          }else {
            $cashfree_vendor_id = "VDR".sprintf("%s%06d", date("dmHi"), $vendor_fulldata->id);
            $post_data = [
              "vendorId"      =>  $cashfree_vendor_id,
              "name"          =>  $vendor_fulldata->full_name,
              "email"         =>  $vendor_fulldata->email,
              "phone"         =>  $vendor_fulldata->phone,
              "bankAccount"   =>  $vendor_bank_detail->account_number,
              "accountHolder"    =>  $vendor_bank_detail->account_holder_name,
              "ifsc"          =>  $vendor_bank_detail->ifsc,
              "address1"      =>  $vendor_fulldata->flat_number." ".$vendor_fulldata->newspaper_agency_name,
              "address2"      =>  $vendor_fulldata->address,
              "city"          =>  $vendor_fulldata->city_name,
              "state"         =>  $vendor_fulldata->state_name,
              "pincode"       =>  $vendor_fulldata->pin_code,
            ];
            $post_url = "/ces/v1/addVendor";
            $res = CustomHelper::cashfree_split($post_url,$post_data);
            if (!empty($res) && @$res->status == "SUCCESS") {
              // vendor commission
              if (isset($vendor_bank_detail->vendor_commission) && $vendor_bank_detail->vendor_commission >= 0) {
                $vendorSplit[] = array(
                  "vendorId" => $vendor_bank_detail->cashfree_vendor_id,
                  "commission" => (100-$vendor_bank_detail->vendor_commission),
                );
                // admin commission
                $vendorSplit[] = array(
                  "vendorId" => $admin_bank_detail->cashfree_vendor_id,
                  "commission" => isset($vendor_bank_detail->vendor_commission) && $vendor_bank_detail->vendor_commission >= 0 ? $vendor_bank_detail->vendor_commission : 0,
                );
              }else{
                $vendorSplit[] = array(
                  "vendorId" => $vendor_bank_detail->cashfree_vendor_id,
                  "commission" => 100,
                );
                // admin commission
                $vendorSplit[] = array(
                  "vendorId" => $admin_bank_detail->cashfree_vendor_id,
                  "commission" => 0,
                );
              }
              DB::table("users")->where("id",$vendor_fulldata->id)->update(["cashfree_vendor_id"=>$cashfree_vendor_id]);
            }else {
              Session::flash('error',  trans(@$res->message));
            }
          }
        }
      }
      //pr($vendorSplit);die;
      $vendorSplit = json_encode($vendorSplit);
      $vendorSplit = base64_encode($vendorSplit);
      $result = DB::table("bill_url")
              ->where("id",$bill_url_id)
              ->where("customer_id",base64_decode($customer_id))
              ->where("validate_string",$validate_string)
              ->where('is_expired',INACTIVE)
              ->orderBy('id','desc')
              ->first();
      if (empty($result)) {
        Session::flash('error',  trans("Link Expired."));
        return Redirect::route('Bill.link_expired');
      }
      $bill_data = DB::table("bill_url as bu")
              ->join('billings as bil','bu.bill_id','=','bil.id')
              ->join('users as c','bu.customer_id','=','c.id')
              ->join('users as v','c.vendor_id','=','v.id')
              ->where("bu.id",$bill_url_id)
              ->where("bu.validate_string",$validate_string)
              ->where('bu.is_expired',INACTIVE)
              ->select('bil.*','bu.customer_id', 'c.full_name','c.phone','c.email','v.full_name as vendor_name','v.email as vendor_email','c.vendor_id','v.newspaper_agency_name')
              ->orderBy('bu.id','desc')
              ->first();
      if (empty($bill_data)) {
        Session::flash('error',  trans("Link Expired."));
        return Redirect::route('Bill.link_expired');
      }
      $vendor_data = User::find($bill_data->vendor_id);
      /*######### Send mail vendor for schedule payment start ######*/
      if (!empty($formData) && isset($formData['payment_mode']) && $formData['payment_mode'] == 2) {

         //Send Notification
          $title='Payment schedule with '.$bill_data->full_name;
          $msg="Hey,you have schedule bill payment with ".$bill_data->full_name. " On ". $formData['schedule_date']." be ready for that.";
          $image='';

          $this->sendnotification("Schedule Bill",$msg,$image,$bill_data->customer_id);

        $notificationData = array(
          "user_id"=> $vendor_data->id,
          "title"=>$title,
          "description"=> $msg,
          "status"=>ACTIVE,
          "created_at"=>date("Y-m-d H:i:s")
        );
        DB::table('notifications')->insert($notificationData);

        $settingsEmail 			=	config()->get('Site.email');
        $full_name				  =	$vendor_data->full_name;
        $email				      =	$vendor_data->email;
        $emailActions			  = 	EmailAction::where('action','=','schedule_payment')->get()->toArray();

        $emailTemplates			= 	EmailTemplate::where('action','=','schedule_payment')
                        ->get(array('name','subject','action','body'))->toArray();

       $cons 					      = 	explode(',',$emailActions[0]['options']);

        $constants 				= 	array();

        foreach($cons as $key => $val){
          $constants[] 		= 	'{'.$val.'}';
        }

        //$subject 				= 	$emailTemplates[0]['subject'];
        $subject          =   "Bill Collection From ".$bill_data->full_name. " On ". $formData['schedule_date'];
        $rep_Array 				= 	array($vendor_data->newspaper_agency_name,$full_name,$result->amount,$bill_data->full_name,$formData['schedule_date']);
        $messageBody			= 	str_replace($constants, $rep_Array, $emailTemplates[0]['body']);
        $this->sendMail($email,$full_name,$subject,$messageBody,$settingsEmail);
        //Session::flash('success',  trans("Schedule Payment done."));
        DB::table("bill_url")->where("id",$bill_url_id)->update(['is_expired'=>1]);
        return Redirect::route('Bill.schedule_payment');
      }
      /*######### Send mail vendor for schedule payment end ######*/

      if (CASHFREE_MODE == 0) {
				$appId = CASHFREE_WEB_APP_ID_TEST;
				$secretKey = CASHFREE_WEB_SECRET_KEY_TEST;
				$action_url = "https://test.cashfree.com/billpay/checkout/post/submit";
			}else {
				$appId = CASHFREE_WEB_APP_ID_LIVE;
				$secretKey = CASHFREE_WEB_SECRET_KEY_LIVE;
        $action_url = "https://www.cashfree.com/checkout/post/submit";
			}

      $orderId = CustomHelper::generateOrderId();
			$postData = array(
			  "appId" => $appId,
			  "orderId" => $orderId,
			  "orderAmount" => $result->amount,
			  "orderCurrency" => 'INR',
			  "orderNote" => "Bill Payment of ".$result->month."-".$result->year,
			  "customerName" => $bill_data->full_name,
			  "customerPhone" => $bill_data->phone,
			  "customerEmail" => $bill_data->email,
			  "returnUrl" => route('Bill.return_url'),
			  "notifyUrl" => route('Bill.notify_url'),
			  "vendorSplit" => $vendorSplit,
			);
      ksort($postData);
 			 $signatureData = "";
 			 foreach ($postData as $key => $value){
 			      $signatureData .= $key.$value;
 			 }
 			 $signature = hash_hmac('sha256', $signatureData, $secretKey,true);
 			 $signature = base64_encode($signature);

       $obj                   = new Payment;
       $obj->order_id         = $orderId;
       $obj->customer_id      = $bill_data->customer_id;
       $obj->txn_id           = Str::random();
       $obj->payment_mode     = 1;
       $obj->txn_type         = 2;
       $obj->currency_code    = "INR";
       $obj->payment_status   = "Pending";
       $obj->amount           = $result->amount;
       $obj->payment_id       = $bill_data->id;
       $obj->description      = "Bill payment received form ".$bill_data->full_name;
       $obj->save();

      return view('bill.pay_form',compact('result','month_year','bill_data','vendor_data','signature','postData','action_url','vendorSplit'));
    } // end index()

  /*
  * return url function
  */
  public function return_url()
  {
    if (!empty($_POST)) {
      if (CASHFREE_MODE == 0) {
				$appId = CASHFREE_WEB_APP_ID_TEST;
				$secretKey = CASHFREE_WEB_SECRET_KEY_TEST;
				$url = "https://ces-gamma.cashfree.com";
			}else {
				$appId = CASHFREE_WEB_APP_ID_LIVE;
				$secretKey = CASHFREE_WEB_SECRET_KEY_LIVE;
        $url = "https://ces-api.cashfree.com";
			}
      $orderId = $_POST["orderId"];
       $orderAmount = $_POST["orderAmount"];
       $referenceId = $_POST["referenceId"];
       $txStatus = $_POST["txStatus"];
       $paymentMode = $_POST["paymentMode"];
       $txMsg = $_POST["txMsg"];
       $txTime = $_POST["txTime"];
       $signature = $_POST["signature"];
       $data = $orderId.$orderAmount.$referenceId.$txStatus.$paymentMode.$txMsg.$txTime;
       $hash_hmac = hash_hmac('sha256', $data, $secretKey, true) ;
       $computedSignature = base64_encode($hash_hmac);
       if ($signature == $computedSignature) {
          $obj = Payment::where('order_id',$orderId)->where("payment_status","Pending")->first();
          if (!empty($obj)) {
            if (isset($_POST['txStatus']) && $_POST['txStatus'] == "SUCCESS") {
              $obj->payment_status = "Completed";
              $obj->save();

              $bill_obj = DB::table("billings as bil")
                        ->join("users as c","bil.customer_id","=","c.id")
                        ->where('bil.customer_id',$obj->customer_id)
                        ->where('bil.id',$obj->payment_id)
                        ->select('bil.*','c.full_name','c.email','c.phone','c.vendor_id')
                        ->orderBy('bil.id','desc')
                        ->first();
              //pr($bill_obj);die;
              if (!empty($bill_obj)) {
                $bill_obj_update = array(
                  "due_amount"=> $bill_obj->total_amount -($bill_obj->paid_amount+$obj->amount),
                  "paid_amount"=> $bill_obj->paid_amount + $obj->amount,
                );
                $bill_url = DB::table("bill_url")
                    ->where('customer_id',$obj->customer_id)
                    ->where('is_expired',0)
                    ->orderBy('id','desc')
                    ->first();
                DB::table("billings")
                    ->where('customer_id',$obj->customer_id)
                    ->where('id',$obj->payment_id)
                    ->update($bill_obj_update);
                DB::table("bill_url")
                    ->where('customer_id',$obj->customer_id)
                    ->where('is_expired',0)
                    ->orderBy('id','desc')
                    ->update(['is_expired'=>1]);
                // update bill status by store procedure
                $ress= DB::select('call manage_bill_status(?)',array($bill_obj->id));
              }
              //Send Notification
              $title='Bill Paid by '.$bill_obj->full_name;
              $msg="Hey,you have received bill payment of amount ".$obj->amount." from ".$bill_obj->full_name;
              $image='';

              $this->sendnotification("Payment Successful",$msg,$image,$obj->customer_id);

              $notificationData = array(
                "user_id"=> $bill_obj->vendor_id,
                "title"=> $title,
                "description"=> $msg,
                "status"=>ACTIVE,
                "created_at"=>date("Y-m-d H:i:s")
              );
              DB::table('notifications')->insert($notificationData);

              //Agencay Name
              $agency_name=DB::table("users as u")
                        ->where('u.id',$bill_obj->vendor_id)
                        ->select('c.full_name','c.email','c.phone','c.newspaper_agency_name')
                        ->first();

              /*######### Send mail reciept to customer start #####*/
              // send mail to customer
              $settingsEmail 			=	config()->get('Site.email');
              $full_name				  =	$bill_obj->full_name;
              $email				      =	$bill_obj->email;
              $dateObj            = \DateTime::createFromFormat('!m', $bill_obj->month);
              $monthName          = $dateObj->format('F');
              $month_year         = $monthName.'-'.$bill_obj->year;
        			$emailActions			  = 	EmailAction::where('action','=','bill_receipt')->get()->toArray();

        			$emailTemplates			= 	EmailTemplate::where('action','=','bill_receipt')
        											       ->get(array('name','subject','action','body'))->toArray();
              $cons 					      = 	explode(',',$emailActions[0]['options']);

        			$constants 				= 	array();

        			foreach($cons as $key => $val){
        				$constants[] 		= 	'{'.$val.'}';
        			}

        			//$subject 				= 	$emailTemplates[0]['subject'];
              $subject          =   "Bill Payment For ".$month_year. " Success";
        			$rep_Array 				= 	array($agency_name->newspaper_agency_name,$full_name,$monthName,$bill_obj->year,$bill_url->amount);
        			$messageBody			= 	str_replace($constants, $rep_Array, $emailTemplates[0]['body']);
        			$this->sendMail($email,$full_name,$subject,$messageBody,$settingsEmail);
              /*######### Send mail reciept to customer end ######*/
              Session::flash('success',  trans("Payment Successfully done."));
              return Redirect::route('Bill.payment_success');
            }
          }else {
            Session::flash('error',  trans("No Record Found."));
            return Redirect::route('home');
          }
        } else {
          Session::flash('error',  trans("Something went wrong."));
          return Redirect::route('home');
       }
    }
  } // end
  /*
  * notify url function
  */
  public function notify_url()
  {
    if (!empty($_POST)) {
      if (CASHFREE_MODE == 0) {
				$appId = CASHFREE_WEB_APP_ID_TEST;
				$secretKey = CASHFREE_WEB_SECRET_KEY_TEST;
				$url = "https://ces-gamma.cashfree.com";
			}else {
				$appId = CASHFREE_WEB_APP_ID_LIVE;
				$secretKey = CASHFREE_WEB_SECRET_KEY_LIVE;
        $url = "https://ces-api.cashfree.com";
			}

      $orderId = $_POST["orderId"];
       $orderAmount = $_POST["orderAmount"];
       $referenceId = $_POST["referenceId"];
       $txStatus = $_POST["txStatus"];
       $paymentMode = $_POST["paymentMode"];
       $txMsg = $_POST["txMsg"];
       $txTime = $_POST["txTime"];
       $signature = $_POST["signature"];
       $data = $orderId.$orderAmount.$referenceId.$txStatus.$paymentMode.$txMsg.$txTime;
       $hash_hmac = hash_hmac('sha256', $data, $secretKey, true) ;
       $computedSignature = base64_encode($hash_hmac);
       if ($signature == $computedSignature) {
          $obj = Payment::where('order_id',$orderId)->where("payment_status","Pending")->first();
          if (!empty($obj)) {
            if (isset($_POST['txStatus']) && $_POST['txStatus'] == "SUCCESS") {
              $obj->payment_status = "Completed";
              $obj->save();

              $bill_obj = DB::table("billings as bil")
                        ->join("users as c","bil.customer_id","=","c.id")
                        ->where('bil.customer_id',$obj->customer_id)
                        ->where('bil.id',$obj->payment_id)
                        ->select('bil.*','c.full_name','c.email','c.phone','c.vendor_id')
                        ->orderBy('bil.id','desc')
                        ->first();
              //pr($bill_obj);die;
              if (!empty($bill_obj)) {
                $bill_obj_update = array(
                  "due_amount"=> $bill_obj->total_amount -($bill_obj->paid_amount+$obj->amount),
                  "paid_amount"=> $bill_obj->paid_amount + $obj->amount,
                );
                $bill_url = DB::table("bill_url")
                    ->where('customer_id',$obj->customer_id)
                    ->where('is_expired',0)
                    ->orderBy('id','desc')
                    ->first();
                DB::table("billings")
                    ->where('customer_id',$obj->customer_id)
                    ->where('id',$obj->payment_id)
                    ->update($bill_obj_update);
                DB::table("bill_url")
                    ->where('customer_id',$obj->customer_id)
                    ->where('is_expired',0)
                    ->orderBy('id','desc')
                    ->update(['is_expired'=>1]);
                // update bill status by store procedure
                $ress= DB::select('call manage_bill_status(?)',array($bill_obj->id));

                 //Send Notification
                $title='Bill Paid by '.$bill_obj->full_name;
                $msg= "Hey,you have received bill payment of amount ".$obj->amount." from ".$bill_obj->full_name;
                $image='';
                //Send Notification  Function
                $this->sendnotification("Title",$msg,$image,$obj->customer_id);
                //Insert Data In Notification
                $notificationData = array(
                  "user_id"=> $bill_obj->vendor_id,
                  "title"=> $title,
                  "description"=> $msg,
                  "status"=>ACTIVE,
                  "created_at"=>date("Y-m-d H:i:s")
                );
                DB::table('notifications')->insert($notificationData);
              }

               //Agencay Name
              $agency_name=DB::table("users as u")
                        ->where('u.id',$bill_obj->vendor_id)
                        ->select('c.full_name','c.email','c.phone','c.newspaper_agency_name')
                        ->first();

              /*######### Send mail reciept to customer start #####*/
              // send mail to customer
              $settingsEmail 			=	config()->get('Site.email');
              $full_name				  =	$bill_obj->full_name;
              $email				      =	$bill_obj->email;
              $dateObj            = \DateTime::createFromFormat('!m', $bill_obj->month);
              $monthName          = $dateObj->format('F');
              $month_year         = $monthName.'-'.$bill_obj->year;
        			$emailActions			  = 	EmailAction::where('action','=','bill_receipt')->get()->toArray();

        			$emailTemplates			= 	EmailTemplate::where('action','=','bill_receipt')
        											->get(array('name','subject','action','body'))->toArray();

             $cons 					      = 	explode(',',$emailActions[0]['options']);

        			$constants 				= 	array();

        			foreach($cons as $key => $val){
        				$constants[] 		= 	'{'.$val.'}';
        			}

        			//$subject 				= 	$emailTemplates[0]['subject'];
              $subject          =   "Bill Payment For ".$month_year. " Success";
        			$rep_Array 				= 	array($agency_name->newspaper_agency_name,$full_name,$monthName,$bill_obj->year,$bill_url->amount);
        			$messageBody			= 	str_replace($constants, $rep_Array, $emailTemplates[0]['body']);
        			$this->sendMail($email,$full_name,$subject,$messageBody,$settingsEmail);
              /*######### Send mail reciept to customer end ######*/
              return Redirect::route('home');
            }
          }else {
            return Redirect::route('home');
          }
        } else {
          return Redirect::route('home');
       }
    }
  } // end

  /*
  * link expired
  */
  public function link_expired()
  {
    return view("pages.link_expired");
  } // end


  /*
  * bill history
  */
  public function bill_history()
  {

    $billing_detail = [];
    $user_id = 381;
    if (!empty($_REQUEST['customer_id']) && $_REQUEST['customer_id']!='') {

      $user_id = $_REQUEST['customer_id'];
      $user_id = substr($user_id, 0, -3);
     $user_id = substr($user_id, 1);

      //Billing Detail
      $billing_detail=DB::table('billings')
                        ->leftJoin('billing_history','billing_history.bill_id','=','billings.id')
                        ->select('billings.*','billing_history.bill_id','billing_history.mode','billing_history.description','billing_history.amount as billing_history_amount')
                ->where('billings.customer_id',$user_id)->limit(50)
                ->get();

    }

    return view('pages.bill_history',compact('user_id','billing_detail'));

  } // end


  /*
  * bill_details
  */
  public function bill_details($id=null)
    {

        // LOGIC FOR REAL ID if CID IS C+[main id]+[random 3 digit] => C+381+568 => C381568 => we will get only 381 afer remove first and last 3 characters

     $id = substr($id, 0, -3);
     $id = substr($id, 1);


       $formData  = Input::all();
        $usersQuery = DB::table('billings')
                        ->leftJoin('billing_history','billing_history.bill_id','=','billings.id')
                        ->select('billings.*','billing_history.bill_id','billing_history.mode','billing_history.description','billing_history.amount as billing_history_amount','billings.bill_status')
                ->where('billings.customer_id',$id);

        if(!empty($formData["start_date"]) && !empty($formData["end_date"])){
         $usersQuery->whereRaw("date(billings.created_at) >= '" . $formData["start_date"] . "' AND date(billings.created_at) <= '" . $formData["end_date"] . "'");
        }
        $users=$usersQuery->get();

      return Datatables::of($users)

              ->addColumn('created_at', function ($result) {
                return date("F/Y", strtotime($result->created_at));
                })

              ->addColumn('bill_status', function ($result) {
                if($result->bill_status==ZERO) {
                  $status='<div><span class="label label-primary">Unpaid</span></div>';
                }else if($result->bill_status==ONE){
                    $status='<div><span class="label label-success">fully paid</span></div>';
                }else if($result->bill_status==TWO) {
                   $status='<div><span class="label label-info">partial paid</span></div>';
                }
                return $status;
                })
                ->escapeColumns([])
                ->make(true);
    }// end


  /*
  * payment success page
  */
  public function payment_success()
  {
    return view("pages.payment_success");
  } // end
  /*
  * payment schedule page
  */
  public function schedule_payment()
  {
    return view("pages.schedule");
  } // end

  /*
  * function to render bill view page
  */
  public function bill_report()
  {
    return view("bill.bill_report");
  } // end

  /*
  * function to get bill report
  */
  public function get_bill_report()
  {
    if (request()->ajax()){
      $phone = Input::get("phone");
      if (!empty($phone)) {
        $bill_result = DB::table("users as c")
                    ->join("billings as bil","c.id","=","bil.customer_id")
                    ->where('c.phone',$phone)
                    ->select('bil.*','c.full_name','c.email','c.phone')
                    ->orderBy('bil.year','desc')
                    ->orderBy('bil.month','desc')
                    ->groupBy(['bil.year','month'])
                    ->take(12)
                    ->get();
                    //pr($bill_result);die;
        if (!empty($bill_result)) {
            $i=1;
            $html = '';
            $html .= '<div id="accordion">';

            foreach ($bill_result as $bill_key => $bill_value) {
              $payment_result  = DB::table('payments as p')
                      ->where("p.payment_status","Completed")
                      ->whereIn("p.payment_mode",[1,2,3]) // cash, online, bank
                      ->where("p.txn_type",2) // credit
                      ->where('p.customer_id',$bill_value->customer_id)
                      ->where('p.payment_id',$bill_value->id)
                      ->get();

                    $html .= '<div class="card">';
                               $html .= '<div class="card-header" id="heading_"'.$i.'">';
                                    $html .= '<h5 class="mb-0">';
                                      $html .= '<button class="btn btn-link" data-toggle="collapse" data-target="#collapse_"'.$i.'" aria-expanded="true" aria-controls="collapse_"'.$i.'">';
                                        $dateObj   = \DateTime::createFromFormat('!m', $bill_value->month);
                                        $monthName = $dateObj->format('F'); // March
                                        $html .= 'Bill of '.$monthName.'-'.$bill_value->year.'';
                                      $html .= '</button>';
                                        $html .='<span style="float:right">Total : Rs '.$bill_value->total_amount.'</span>';
                                    $html .= '</h5>';
                                  $html .= '</div>';
                                  $html .= '<div id="collapse_"'.$i.'" class="collapse show" aria-labelledby="heading_"'.$i.'" data-parent="#accordion">';
                                    $html .= '<div class="card-body">';
                                    if (!empty($payment_result)) {
                                      foreach ($payment_result as $payment_key => $payment_value) {
                                        $html .= '('.++$payment_key.') Payment of Rs '.$payment_value->amount.' has paid on '.date("F j, Y, g:i a",strtotime($payment_value->created_at)).'<br>';
                                      }
                                    }else{
                                      $html .= 'No Payment Found';
                                    }
                                    $html .= '</div>';
                                  $html .= '</div>';
                                $html .= '</div>';
                      // $query = DB::getQueryLog();
                      // $query = end($query);
                      //  pr($query);die();
            $bill_result[$bill_key]->payments = $payment_result ?? array();
            //pr($payment_result);die;
            $i++;
            }
            $html .= '</div>';
          }
          if (count($bill_result) > 0) {
            return Response::json(["status"=>"success","data"=>$html]);
          }else {
            return Response::json(["status"=>"error","message"=>"No Record Found"]);
          }
      }else{
        $res = array(
          "status"=>"error",
          "message"=>"Please enter number"
        );
        return Response::json($res);
      }
    }
  } // end

}
