<?php
namespace App\Http\Controllers;
use DB;
use Session;
use bcrypt;
use Config;
use Redirect;
use Hash;
use Mail;
use Carbon\Carbon;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Http\Requests;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\Input;
use App\Helpers\Helpers;
class Cricketapi2Controller extends Controller {
	public function accessrules(){
		header('Access-Control-Allow-Origin: *');
		header("Access-Control-Allow-Credentials: true");
		header('Access-Control-Allow-Methods: GET, PUT, POST, DELETE, OPTIONS');
		header('Access-Control-Max-Age: 1000');
		header('Access-Control-Allow-Headers: Authorization');
		header('Access-Control-Allow-Headers: Origin, Content-Type, X-Auth-Token');
	}

	public static function genrateToken() {

			//    return '7c8cb3eb2eabe5deb3d5c3ffddfd08e6';
			// return 'a60b8484584f8b3f1286edd7ec080957';
			//

				// Focus11 With live score card and Commentry
 			 // return 'd93c8357bb3dcb7e5c4c7d8dd40ed886';
      exit;
        $ch = curl_init();

        curl_setopt($ch, CURLOPT_URL, CRICKET_API_URL."v2/auth");
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, "access_key=".CRICKET_ACCESS_KEY."&secret_key=".CRICKET_SECRET_KEY."");
        curl_setopt($ch, CURLOPT_POST, 1);

        $headers = array();
        $headers[] = "Content-Type: application/x-www-form-urlencoded";
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

        $result = curl_exec($ch);
        if (curl_errno($ch)) {
            echo 'Error:' . curl_error($ch);
        }
        curl_close ($ch);
        $result = json_decode($result);
        if($result->status=='ok') {
            $response = $result->response;
            $token = $response->token;
            return $token;
        }
    }

		public static function get_live_commentries_data($matchkey,$inning) {
	    $token = Cricketapi2Controller::genrateToken();
	      $curl = curl_init();
				// $url = CRICKET_API_URL."v2/matches/55831/innings/".$inning."/commentary?token=".$token."";
	      $url = CRICKET_API_URL."v2/matches/".$matchkey."/innings/".$inning."/commentary?token=".$token."";

				// echo $url; exit;
	      curl_setopt_array($curl, array(
	        CURLOPT_URL => $url,
	        CURLOPT_RETURNTRANSFER => true,
	        CURLOPT_ENCODING => "",
	        CURLOPT_MAXREDIRS => 10,
	        CURLOPT_TIMEOUT => 30,
	        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
	        CURLOPT_CUSTOMREQUEST => "GET",
	        CURLOPT_HTTPHEADER => array(
	          "Cache-Control: no-cache",
	          "Postman-Token: cc748f1a-a898-463c-900c-47e74ac7b2c4"
	        ),
	      ));

	      $response = curl_exec($curl);
	      $err = curl_error($curl);

	      curl_close($curl);
	      if ($err) {
	        echo "cURL Error #:" . $err; exit;
	      } else {
	        $result = json_decode($response);
					// dd($result);
	        if($result->status=='ok') {
	          $response = $result->response;
	          return $response;
	        }
	      }
	    }
			public static function get_live_api_data($matchkey) {
									$token = Cricketapi2Controller::genrateToken();
							        $curl = curl_init();
											// echo CRICKET_API_URL."v2/matches/".$matchkey."/scorecard?token=".$token."";
											// die;
										  curl_setopt_array($curl, array(
							          CURLOPT_URL => CRICKET_API_URL."v2/matches/".$matchkey."/live?token=".$token."",
							          CURLOPT_RETURNTRANSFER => true,
							          CURLOPT_ENCODING => "",
							          CURLOPT_MAXREDIRS => 10,
							          CURLOPT_TIMEOUT => 30,
							          CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
							          CURLOPT_CUSTOMREQUEST => "GET",
							          CURLOPT_HTTPHEADER => array(
							            "Cache-Control: no-cache"
							          ),
							        ));

							        $response = curl_exec($curl);
							        $err = curl_error($curl);

							        curl_close($curl);

							        if ($err) {
							          echo "cURL Error #:" . $err;
							        } else {
							        	$result = json_decode($response);
							        	// print_r($result); exit;
							        	if($result->status=="ok") {
							        		$response = $result->response;
							            	//$data = $response->items;
							            	return $response;
							        	}
							        }
								}
	public static function getMatches() {
		$token = Cricketapi2Controller::genrateToken();
        $curl = curl_init();
				// echo CRICKET_API_URL."v2/matches/?token=".$token."&status=1&per_page=50&=&paged=1";
				// die;
        curl_setopt_array($curl, array(
          CURLOPT_URL => CRICKET_API_URL."v2/matches/?token=".$token."&status=1&per_page=50&=&paged=1&pre_squad=true",
          CURLOPT_RETURNTRANSFER => true,
          CURLOPT_ENCODING => "",
          CURLOPT_MAXREDIRS => 10,
          CURLOPT_TIMEOUT => 30,
          CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
          CURLOPT_CUSTOMREQUEST => "GET",
          CURLOPT_HTTPHEADER => array(
            "Cache-Control: no-cache"
          ),
        ));

        $response = curl_exec($curl);
        $err = curl_error($curl);

        curl_close($curl);

        if ($err) {
          echo "cURL Error #:" . $err;
        } else {
        	$result = json_decode($response);
        //	echo '<pre>';print_r($result); exit;

        	if($result->status=="ok") {
        		$response = $result->response;
            	$data = $response->items;
            	return $data;
        	}
        }
	}


  public static function get_live_score_data($matchkey,$comp_id) {
    $token = Cricketapi2Controller::genrateToken();
      $curl = curl_init();
      $url = CRICKET_API_URL."v2/matches/".$matchkey."/scorecard?token=".$token."";
      // echo $url; exit;
      curl_setopt_array($curl, array(
        CURLOPT_URL => CRICKET_API_URL."v2/matches/".$matchkey."/scorecard?token=".$token."",
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_ENCODING => "",
        CURLOPT_MAXREDIRS => 10,
        CURLOPT_TIMEOUT => 30,
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLOPT_CUSTOMREQUEST => "GET",
        CURLOPT_HTTPHEADER => array(
          "Cache-Control: no-cache",
          "Postman-Token: cc748f1a-a898-463c-900c-47e74ac7b2c4"
        ),
      ));

      $response = curl_exec($curl);
      $err = curl_error($curl);

      curl_close($curl);
      if ($err) {
        echo "cURL Error #:" . $err; exit;
      } else {
        $result = json_decode($response);
        if($result->status=='ok') {
          $response = $result->response;
          return $response;
        }
      }
    }


	public static function get_match_squad($match_id, $comp_id) {
		$token = Cricketapi2Controller::genrateToken();
        $curl = curl_init();
				// echo CRICKET_API_URL."v2/competitions/".$comp_id."/squads/".$match_id."?token=".$token."&status=1&per_page=50&=&paged=1";
				// exit;
        curl_setopt_array($curl, array(
          CURLOPT_URL => CRICKET_API_URL."v2/competitions/".$comp_id."/squads/".$match_id."?token=".$token."&status=1&per_page=50&=&paged=1",
          CURLOPT_RETURNTRANSFER => true,
          CURLOPT_ENCODING => "",
          CURLOPT_MAXREDIRS => 10,
          CURLOPT_TIMEOUT => 30,
          CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
          CURLOPT_CUSTOMREQUEST => "GET",
          CURLOPT_HTTPHEADER => array(
            "Cache-Control: no-cache"
          ),
        ));

        $response = curl_exec($curl);
        $err = curl_error($curl);

        curl_close($curl);

        if ($err) {
          echo "cURL Error #:" . $err;
        } else {
        	$result = json_decode($response);
				//	 echo "<pre>"; print_r($result); exit;
        	if(@$result->status=="ok") {
        		$response = $result->response;
            	return $response;
        	}
        }
	}

	public static function get_match_playing_players($api_unique_id) {
		// dd('sdfasfa123');
		// print_r($api_unique_id);exit;
			// $api_unique_id='66041';
      $token = Cricketapi2Controller::genrateToken();
       // echo CRICKET_API_URL."/v2/matches/".$api_unique_id."/squads?token=".$token.""; exit;
        $curl = curl_init();

        curl_setopt_array($curl, array(
          CURLOPT_URL => CRICKET_API_URL."/v2/matches/".$api_unique_id."/squads?token=".$token."",
          CURLOPT_RETURNTRANSFER => true,
          CURLOPT_ENCODING => "",
          CURLOPT_MAXREDIRS => 10,
          CURLOPT_TIMEOUT => 30,
          CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
          CURLOPT_CUSTOMREQUEST => "GET",
          CURLOPT_HTTPHEADER => array(
            "Cache-Control: no-cache"
          ),
        ));

        $response = curl_exec($curl);
        $err = curl_error($curl);
        // print_r($response); exit;
        curl_close($curl);

        if ($err) {
          echo "cURL Error #:" . $err;
        } else {
          $result = json_decode($response);
					// echo "<pre>"; print_r($result); exit;
					if(@$result->status=="ok") {
            $response = $result->response;
            $teama_players = $response->teama->squads;
            $teamb_players = $response->teamb->squads;
            $players = array_merge($teama_players, $teamb_players);

						 // echo "<pre>"; print_r($players); exit;
						$playing_players=array();
						if(empty($players)){
							$playing_players["lineup_player"]=array();
							$playing_players['response']= $result->response;
						}else{

						foreach ($players as $player) {
							if($player->playing11=="true") {
								$playing_players["lineup_player"][] = $player->player_id;
							}
            }
						$playing_players["lineup_player"]= empty($playing_players["lineup_player"]) ? array(): $playing_players["lineup_player"];
						$playing_players['response']= $result->response;
					}

  				// echo "<pre>"; print_r($playing_players); exit;
            return $playing_players;

          }
					//oldcode 28-10-23
          // if(@$result->status=="ok") {
          //   $response = $result->response;
          //   $teama_players = $response->teama->squads;
          //   $teamb_players = $response->teamb->squads;
          //   $players = array_merge($teama_players, $teamb_players);
          //   $playing_players = array();
					// 	 // echo "<pre>"; print_r($players); exit;
          //   foreach ($players as $player) {
          //     if($player->playing11=="true") {
					// 			$playing_players[] = $player->player_id;
          //     }
          //   }
					// 	// dd($playing_players);
          //   return $playing_players;
          // }
        }
    }

    public static function get_match_details($api_unique_id) {
      $token = Cricketapi2Controller::genrateToken();
		// 			echo CRICKET_API_URL."v2/matches/".$api_unique_id."/scorecard?token=".$token."";
		// exit;
      $curl = curl_init();
      $url = CRICKET_API_URL."v2/matches/".$api_unique_id."/scorecard?token=".$token."";
        // echo $url; exit;
      curl_setopt_array($curl, array(
        CURLOPT_URL => CRICKET_API_URL."v2/matches/".$api_unique_id."/scorecard?token=".$token."",
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_ENCODING => "",
        CURLOPT_MAXREDIRS => 10,
        CURLOPT_TIMEOUT => 30,
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLOPT_CUSTOMREQUEST => "GET",
        CURLOPT_HTTPHEADER => array(
          "Cache-Control: no-cache",
          "Postman-Token: cc748f1a-a898-463c-900c-47e74ac7b2c4"
        ),
      ));

      $response = curl_exec($curl);
      $err = curl_error($curl);

      // print_r($response);die;

      curl_close($curl);
      // print_r($response);die;
      if ($err) {
        echo "cURL Error #:" . $err; exit;
      } else {
        $result = json_decode($response);
        if(@$result->status=='ok') {
          $response = $result->response;
          return $response;
        }else {
					if(@$result->status=='forbidden' && @$result->response !='You have no access to this match')
					{
		            $image = "";
   					   	$titleget ='Token Expired';
     						$msg ='Focus11 Token has been expired';
                 $userdata=array(4873,22490);
                 foreach($userdata as $userid){
                 	Helpers::sendnotification($titleget,$msg,$image,$userid);
                 }
					}

        }
      }
    }

}
?>
