<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;
use App\Http\Controllers\BaseController;
use Illuminate\Http\Request;
use JWTFactory;
use JWTAuth;
use App\User;
use App\Model\OTP;
use App\Model\Address;
use App\Model\EmailAction;
use App\Model\EmailTemplate;
use App\libraries\CustomHelper;
use App\Services\Input;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Support\Facades\Response;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\View;
use Yajra\DataTables\Facades\DataTables;

class CronjobController extends BaseController
{
  /*
  * function to generate bill
  */
  public function generateBill()
  {

    $response =array();
    $query = DB::table("customers_newspapers as cnp");
    $query->join('users as u','cnp.customer_id','=','u.id')
    ->select('cnp.*')
    ->where('u.is_deleted',INACTIVE)
    ->where('u.user_role_id', USER)
    ->where('u.active', ACTIVE)
    ->where('cnp.is_deleted',INACTIVE)
    ->where('cnp.status', ACTIVE)
    ->where('cnp.start_date', '<=', date('Y-m-d')) // check paper start date
    ->orderBy('u.id', 'ASC');
    $newpaperData = $query->get();
    //pr($newpaperData);die;
    if (!empty($newpaperData)) {
      foreach ($newpaperData as $key => $value) {
        $last_billing_date_result = DB::table('last_billing_date')->where('customer_id',$customer_id)->where('newspaper_id',$value->newspaper_id)->orderBy('id','desc')->first();
        if (!empty($last_billing_date_result)) {
          $previous_bill_date = $last_billing_date_result->previous_bill_date;
        }

        $vendor_id = CustomHelper::checkUserParent($value->customer_id);
        if (isset($value->delivery_day_type) && $value->delivery_day_type == ALL_DAYS) {

          /*##############  Calculation of holidays start  ###############*/

          /*###### find stop delivery date #######*/
          $stop_delivery_query = DB::table("stop_newspaper_delivery as snd");
          $stop_delivery_query->join('stop_delivery_meta as sdm','snd.id','=','sdm.snd_id')
          ->join('users as u','snd.customer_id','=','u.id')
          ->select('sdm.from_date','sdm.to_date')
          ->where('snd.is_deleted',INACTIVE)
          ->where('snd.active', ACTIVE);
          if (isset($previous_bill_date) && !empty($previous_bill_date)) {
            $stop_delivery_query->where('sdm.from_date', '>=', $previous_bill_date);
          }else {
            $stop_delivery_query->where('sdm.from_date', '>=', $value->start_date);
          }
          $stop_delivery_query->where('sdm.to_date', '<', date('Y-m-d'))
          ->where('u.id', $value->customer_id)
          ->where('u.vendor_id', $vendor_id)
          ->where('sdm.newspaper_id', $value->newspaper_id);
          $stop_delivery_result = $stop_delivery_query->get();
          $stop_delivery_date_array = array();
          if (count($stop_delivery_result)) {
            foreach ($stop_delivery_result as $stop_delivery_key => $stop_delivery_value) {
              $dates = CustomHelper::getDatesBwTwoDates($stop_delivery_value->from_date,$stop_delivery_value->to_date);
              if (!empty($dates)) {
                foreach ($dates as $dates_key => $dates_value) {
                  array_push($stop_delivery_date_array,$dates_value);
                }
              }
            }
          }
          /*###### find stop delivery date #######*/

          /*###### find holiday #######*/
          /*$holiday_query = DB::table("holidays as hd");
          $holiday_query->select('hd.from_date','hd.to_date','hd.type','hd.user_id')
          ->where('hd.is_deleted',INACTIVE);
          $holiday_query->where('hd.active', ACTIVE);
          if (isset($previous_bill_date) && !empty($previous_bill_date)) {
            $holiday_query->where('hd.from_date', '>=', $previous_bill_date);
          }else {
            $holiday_query->where('hd.from_date', '>=', $value->start_date);
          }
          $holiday_query->where('hd.to_date', '<=', date('Y-m-d'))
          ->where('hd.user_id', $vendor_id)
          ->orWhere('hd.type', ACTIVE)
          ->orWhere('hd.newspaper_id', $value->newspaper_id);
          $holiday_result = $holiday_query->get();
          */
          if (isset($previous_bill_date) && !empty($previous_bill_date)) {
            $holiday_date_from = $previous_bill_date;
          }else {
            $holiday_date_from = $value->start_date;
          }
          $holiday_result = DB::select("select `hd`.`from_date`, `hd`.`to_date`, `hd`.`type`, `hd`.`user_id` from `holidays` as `hd` where `hd`.`is_deleted` = 0 and `hd`.`active` = 1 and `hd`.`from_date` >= '".$holiday_date_from."' and `hd`.`to_date` < '".date('Y-m-d')."' and (`hd`.`type` = 1 or (`hd`.`type` = 2 AND `hd`.`user_id` = ".$vendor_id." AND `hd`.`newspaper_id` = ".$value->newspaper_id.") OR (`hd`.`type` = 3 AND `hd`.`user_id` = ".$vendor_id."))");

          $holiday_date_array = array();
          $total_holiday_array = array();
          if (count($holiday_result)) {
            foreach ($holiday_result as $holiday_key => $holiday_value) {
              $dates = CustomHelper::getDatesBwTwoDates($holiday_value->from_date,$holiday_value->to_date);
              if (!empty($dates)) {
                foreach ($dates as $dates_key => $dates_value) {
                  array_push($holiday_date_array,$dates_value);
                }
              }
            }
          }
          /*###### find holiday #######*/
        // get date array b/w start and today
        if (isset($previous_bill_date) && !empty($previous_bill_date)) {
          $begin = new \DateTime($previous_bill_date);
        }else {
          $begin = new \DateTime($value->start_date);
        }
        $end = new \DateTime(date('Y-m-d'));
        $end = $end->modify('-1 day');

        $interval = new \DateInterval('P1D');
        $daterange = new \DatePeriod($begin, $interval ,$end);
        $total_holidays = array();
        $total_days = array();
        foreach($daterange as $date){
          $date = $date->format("Y-m-d");
          array_push($total_days,$date);
        }
        // get total holiday = stop delivery days + holidays
        $total_holidays = array_unique(array_merge($stop_delivery_date_array, $holiday_date_array));
        $total_holidays = array_values($total_holidays);

        // find intersect of both array
        $grand_total_holidays_days = array();
        $grand_total_holidays_days = array_intersect($total_holidays, $total_days);
        // re-order keys
        $grand_total_holidays_days = array_values($grand_total_holidays_days);
        // total working days
        $total_working_days=array_diff($total_days,$grand_total_holidays_days);
        $total_working_days = array_values($total_working_days);
        $count_total_days = count($total_days);

        $newpaperData[$key]->total_days = serialize($total_days);
        $newpaperData[$key]->holidays = serialize($grand_total_holidays_days);
        /*##############  Calculation of holidays end  ###############*/

          if (isset($value->paper_data) && !empty($value->paper_data)) {
            $paper_data = unserialize($value->paper_data);
          }
          $holiday_price_sum = 0;
          if (count($grand_total_holidays_days)) {
            foreach ($grand_total_holidays_days as $holi_key => $holi_value) {
              $day_name =  date('D', strtotime($holi_value));
              switch ($day_name) {
                case "Sun":
                    $holiday_price_sum += $this->getDayPrice($paper_data,1);
                    break;
                case "Mon":
                    $holiday_price_sum += $this->getDayPrice($paper_data,2);
                    break;
                case "Tue":
                    $holiday_price_sum += $this->getDayPrice($paper_data,3);
                    break;
                case "Wed":
                    $holiday_price_sum += $this->getDayPrice($paper_data,4);
                    break;
                case "Thu":
                    $holiday_price_sum += $this->getDayPrice($paper_data,5);
                    break;
                case "Fri":
                    $holiday_price_sum += $this->getDayPrice($paper_data,6);
                    break;
                case "Sat":
                    $holiday_price_sum += $this->getDayPrice($paper_data,7);
                    break;
              }
            }
          }
          $total_price_sum = 0;
          if (count($total_days)) {
            foreach ($total_days as $total_key => $total_value) {
              $day_name =  date('D', strtotime($total_value));
              switch ($day_name) {
                case "Sun":
                    $total_price_sum += $this->getDayPrice($paper_data,1);
                    break;
                case "Mon":
                    $total_price_sum += $this->getDayPrice($paper_data,2);
                    break;
                case "Tue":
                    $total_price_sum += $this->getDayPrice($paper_data,3);
                    break;
                case "Wed":
                    $total_price_sum += $this->getDayPrice($paper_data,4);
                    break;
                case "Thu":
                    $total_price_sum += $this->getDayPrice($paper_data,5);
                    break;
                case "Fri":
                    $total_price_sum += $this->getDayPrice($paper_data,6);
                    break;
                case "Sat":
                    $total_price_sum += $this->getDayPrice($paper_data,7);
                    break;
              }
            }
          }
          // check paper for coupon type and set amount zero for that
          if (isset($value->payment_option) && $value->payment_option == 2) {
            $total_price_sum = 0;
            $holiday_price_sum = 0;
          }
          $newpaperData[$key]->monthly_paper_bill = ($total_price_sum*$value->qty) - $holiday_price_sum;
          $newpaperData[$key]->holiday_price_sum = $holiday_price_sum;
        }elseif (isset($value->delivery_day_type) && $value->delivery_day_type == SPECIFIC_DAYS) {
          //$paper_data = unserialize('a:4:{i:0;O:8:"stdClass":2:{s:5:"price";i:5;s:3:"day";s:1:"2";}i:1;O:8:"stdClass":2:{s:5:"price";i:5;s:3:"day";s:1:"3";}i:2;O:8:"stdClass":2:{s:5:"price";i:5;s:3:"day";s:1:"6";}i:3;O:8:"stdClass":2:{s:5:"price";i:5;s:3:"day";s:1:"7";}}');
          $paper_data = unserialize($value->paper_data);
          // get date array b/w start and today
          if (isset($previous_bill_date) && !empty($previous_bill_date)) {
            $begin = new \DateTime($previous_bill_date);
          }else {
            $begin = new \DateTime($value->start_date);
          }
          $end = new \DateTime(date('Y-m-d'));
          $end = $end->modify('-1 day');

          $interval = new \DateInterval('P1D');
          $daterange = new \DatePeriod($begin, $interval ,$end);
          $total_days = array();
          if (!empty($daterange)) {
            foreach($daterange as $date){
              $date = $date->format("Y-m-d");
              array_push($total_days,$date);
            }
          }
          $total_price_sum = 0;
          if (count($total_days)) {
            foreach ($total_days as $total_key => $total_value) {
              $day_name =  date('D', strtotime($total_value));
              switch ($day_name) {
                case "Sun":
                    $total_price_sum += $this->getDayPrice($paper_data,1);
                    break;
                case "Mon":
                    $total_price_sum += $this->getDayPrice($paper_data,2);
                    break;
                case "Tue":
                    $total_price_sum += $this->getDayPrice($paper_data,3);
                    break;
                case "Wed":
                    $total_price_sum += $this->getDayPrice($paper_data,4);
                    break;
                case "Thu":
                    $total_price_sum += $this->getDayPrice($paper_data,5);
                    break;
                case "Fri":
                    $total_price_sum += $this->getDayPrice($paper_data,6);
                    break;
                case "Sat":
                    $total_price_sum += $this->getDayPrice($paper_data,7);
                    break;
              }
            }
          }
          if (isset($value->payment_option) && $value->payment_option == 2) {
            $total_price_sum = 0;
          }
          $newpaperData[$key]->per_paper_bill_amount = $total_price_sum;
          $newpaperData[$key]->monthly_paper_bill = $total_price_sum;
        }elseif (isset($value->delivery_day_type) && $value->delivery_day_type == WEEKLY) {
          //echo 3333;die;
          if (isset($value->paper_data) && !empty($value->paper_data)) {
            // check paper for coupon type and set amount zero for that
            if (isset($value->payment_option) && $value->payment_option == 2) {
              $per_paper_bill_amount = 0;
            }else {
              $paper_data = unserialize($value->paper_data);
              $per_paper_bill_amount =0;
              foreach ($paper_data as $paper_data_key => $paper_data_value) {
                $per_paper_bill_amount += ($paper_data_value->price*$value->qty);
              }
            }
            $newpaperData[$key]->per_paper_bill_amount = $per_paper_bill_amount;
            $newpaperData[$key]->monthly_paper_bill = $per_paper_bill_amount*4;
          }
        }elseif (isset($value->delivery_day_type) && $value->delivery_day_type == ONCE_IN_MONTH) {
          //echo 444;die;
          if (isset($value->paper_data) && !empty($value->paper_data)) {
            // check paper for coupon type and set amount zero for that
            if (isset($value->payment_option) && $value->payment_option == 2) {
              $per_paper_bill_amount = 0;
            }else {
              $paper_data = unserialize($value->paper_data);
              //pr($paper_data);die;
              $per_paper_bill_amount =0;
              foreach ($paper_data as $paper_data_key => $paper_data_value) {
                $per_paper_bill_amount += ($paper_data_value->price*$value->qty);
              }
            }
            $newpaperData[$key]->per_paper_bill_amount = $per_paper_bill_amount;
            $newpaperData[$key]->monthly_paper_bill = $per_paper_bill_amount*1;
          }
        }elseif (isset($value->delivery_day_type) && $value->delivery_day_type == TWICE_IN_MONTH) {
          //echo 555;die;
          if (isset($value->paper_data) && !empty($value->paper_data)) {
            // check paper for coupon type and set amount zero for that
            if (isset($value->payment_option) && $value->payment_option == 2) {
              $per_paper_bill_amount = 0;
            }else {
              $paper_data = unserialize($value->paper_data);
              $per_paper_bill_amount =0;
              foreach ($paper_data as $paper_data_key => $paper_data_value) {
                $per_paper_bill_amount += ($paper_data_value->price*$value->qty);
              }
            }
            $newpaperData[$key]->per_paper_bill_amount = $per_paper_bill_amount;
            $newpaperData[$key]->monthly_paper_bill = $per_paper_bill_amount*1;
          }
        }

        // get previous day or last date of previous month
        //$previous_date = date('d-m-Y',strtotime('-1 day'));
        //$dateArray = date_parse_from_format('d-m-Y', $previous_date);
          $till_today = new \DateTime();
          $interval = new \DateInterval('P1M');//2 months
          $previous_month_date_array = $till_today->sub($interval);
          $previous_month_date = $previous_month_date_array->format('Y-m-d');
          $previous_month_date=strtotime($previous_month_date);
          $previous_month=date("m",$previous_month_date);
          $previous_year=date("Y",$previous_month_date);

      /*  $until = new \DateTime();
        $interval = new \DateInterval('P2M');//2 months
        $second_previous_date_array = $until->sub($interval);
        $second_previous_date = $second_previous_date_array->format('Y-m-d');
        $second_previous_date=strtotime($second_previous_date);
        $second_previous_month=date("m",$second_previous_date);
        $second_previous_year=date("Y",$second_previous_date);

        // check billing of last month due amount if then carry forword
        $last_month_due = 0;
        $last_month_bill_result = DB::table("billings")
                                      ->where("customer_id",$value->customer_id)
                                      ->where("month",$second_previous_month)
                                      ->where("year",$second_previous_year)
                                      ->where("is_carry_forword",INACTIVE)
                                      ->first();
        if (!empty($last_month_bill_result)) {
          $last_month_due = $last_month_bill_result->due_amount;
          // update to carry forworded
          DB::table("billings")
              ->where("customer_id",$value->customer_id)
              ->where("month",$second_previous_month)
              ->where("year",$second_previous_year)
              ->where("is_carry_forword",INACTIVE)
              ->update(["is_carry_forword"=>ACTIVE]);
        } */
        if (!empty($last_billing_date_result)) {
          $insert_last_bill_data = array(
            'month'=> $previous_month,
            'year'=> $previous_year,
            'previous_bill_date'=> date('Y-m-d'),
            'updated_at'=> date('Y-m-d H:i:s'),
          );
          DB::table('last_billing_date')->where("customer_id",$value->customer_id)->update($insert_last_bill_data);
        }else {
          $insert_last_bill_data = array(
            'customer_id'=> $value->customer_id,
            'month'=> $previous_month,
            'year'=> $previous_year,
            'previous_bill_date'=> date('Y-m-d'),
            'created_at'=> date('Y-m-d H:i:s'),
            'updated_at'=> date('Y-m-d H:i:s'),
          );
          DB::table('last_billing_date')->insert($insert_last_bill_data);
        }
        $check_bill = DB::table('monthly_bill')
                      ->where('customer_id',$value->customer_id)
                      ->where('newspaper_id',$value->newspaper_id)
                      ->where('month',$previous_month)
                      ->where('year',$previous_year)
                      ->first();
        if (!empty($check_bill)) {
          $updateMonthlyBill = array(
            'total_bill_amount'=> $value->monthly_paper_bill,
            'delivery_day_type'=> $value->delivery_day_type,
            'is_coupon_type'=> $value->payment_option,
            'total_coupons'=> $value->total_coupon,
            'total_days'=> $value->total_days ?? serialize(array()),
            'holidays'=> $value->holidays ?? serialize(array()),
            'updated_at'=> date('Y-m-d H:i:s'),
          );
          DB::table('monthly_bill')
          ->where('customer_id',$value->customer_id)
          ->where('newspaper_id',$value->newspaper_id)
          ->where('month',$previous_month)
          ->where('year',$previous_year)->update($updateMonthlyBill);
        }else {
          $insertMonthlyBill[] = array(
            'customer_id'=> $value->customer_id,
            'newspaper_id'=> $value->newspaper_id,
            'month'=> $previous_month,
            'year'=> $previous_year,
            'total_bill_amount'=> $value->monthly_paper_bill,
            'delivery_day_type'=> $value->delivery_day_type,
            'is_coupon_type'=> $value->payment_option,
            'total_coupons'=> $value->total_coupon,
            'total_days'=> $value->total_days ?? serialize(array()),
            'holidays'=> $value->holidays ?? serialize(array()),
            'created_at'=> date('Y-m-d H:i:s'),
          );
        }
      } // end foreach
      if (isset($insertMonthlyBill) && !empty($insertMonthlyBill)) {
        DB::table('monthly_bill')->insert($insertMonthlyBill);
      }
      return Response::json(["status"=>"success","data"=>$response]);
    }
  } // end

  /*
  * function to get particular day price
  */
  public function getDayPrice($paper_data,$day_number)
  {
    $price = 0;
    if (count($paper_data)) {
      foreach ($paper_data as $key => $value) {
        if (isset($value->day) && $value->day == $day_number) {
          return $value->price;
        }
      }
    }else {
      return $price;
    }
  } // end

} // end CronjobController class
