<?php
namespace App\Http\Controllers;
// use Excel;
use Carbon\Carbon;
use Illuminate\Support\Facades\Storage;
use App\Http\Controllers\BaseController;
use App\global_constants;
use App\Http\Requests;
use Illuminate\Http\Request;
use App\Helpers\Helpers;
use DateTime;
use App\Services\Input;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\View;
use Yajra\DataTables\Facades\DataTables;
class DigilockerController extends BaseController {

    public function aadhar_verify_webhook(Request $request)
    {
          return $this->aadhar_verify_webhook_forP($request);
      }

      public function aadhar_verify_webhook_forP(Request $request)
      {

          $request_data = $request->all();

          $insertget_id = DB::table('adhar_digilocker_res_log')->insertGetId(['response'=>json_encode($request_data)]);

          if(isset($request_data['parsed_details']))
          {
              unset($request_data['download_url']);
              $pht_image = @$request_data['parsed_details']['pht'] ?? "";
              unset($request_data['parsed_details']['pht']);
              $parsed_details = $request_data['parsed_details'];

              $request_data_d = json_encode($request_data);

              $reference_id = $request_data['reference_id'];
              $status = $request_data['status'];

              $array_update = array(
                'reference_id'=>$reference_id,
                'response'=> $request_data_d
              );
              DB::connection('mysql-write')->table('adhar_digilocker_response')->insert($array_update);

              $getdetail = DB::table('adhar_card_details_idfy')->where('reference_id',$reference_id)->first();
              $user_id = @$getdetail->user_id;

              //image upload aws server
              $imageName = '';
              $imageName = 'pancard-'.rand(1000,9999).''.time().'.jpg';
              $imsrc = base64_decode($pht_image);
              file_put_contents(PLAYER_IMAGE_ROOT_PATH.$imageName, $imsrc);
              Helpers::aws_upload_image(PLAYER_IMAGE_ROOT_PATH.$imageName, "uploads/users/",$imageName);
              $data['image'] =$imageName;
              if(file_exists(PLAYER_IMAGE_ROOT_PATH.$imageName)) {
                  unlink(PLAYER_IMAGE_ROOT_PATH.$imageName);
              }

              $adhar_card_details_idfy = array(
                    'country'=>$parsed_details['country'],
                    'dist'=>$parsed_details['dist'],
                    'dob'=>$parsed_details['dob'],
                    'gender'=>$parsed_details['gender'],
                    'name'=>$parsed_details['name'],
                    'pincode'=>$parsed_details['pc'],
                    'state'=>$parsed_details['state'],
                    'street'=>$parsed_details['street'],
                    'uid'=>$parsed_details['uid'],
                    'vtc'=>$parsed_details['vtc'],
                    'co'=>$parsed_details['co'],
                    'status_idfy'=>$status,
                    'image_pht'=>$imageName
              );

              // if($user_id == 8012507)
              // {
              //     $parsed_details['state'] = 'Assam';
              // }

              $in_banned_state = 0;
              if(in_array(strtoupper($parsed_details['state']),BANNED_STATES))
              {
                  $in_banned_state = 1;
              }

              $user_dob = $parsed_details['dob'];

              $birthdate = new DateTime($user_dob);
              $today   = new DateTime('today');
              $age = $birthdate->diff($today)->y;


              $name = str_replace(' ','',$parsed_details['name']);
              $adhar4digit = substr($parsed_details['uid'], 8);
              $unique_id = date('Ymd',strtotime($parsed_details['dob'])).'-'.$adhar4digit.'-'.$parsed_details['state'].$name;
              // echo  $unique_id;
              // die;

              $adhar_card_details_update = array();

              $adhar_card_details_update = array(
                  //'userid'=>$user_id,
                  'adhar_number'=>$parsed_details['uid'].'_'.$user_id,
                  'idfy_reference_id'=>$reference_id,
                  'verified_by_idfy'=>1
              );

              $verify_status = 1;
              $comment ='';
              if($status == "SUCCESS")
              {
                  if($in_banned_state == 1)
                  {
                      $verify_status = 2;
                      $comment = 'Adhar from banned state ('.$parsed_details['state'].')';
                  }

                  if($age < 18)
                  {
                      $verify_status = 2;
                      // $comment = 'Age minor ('.$age.')';
                      $comment = "You are not eligible to play fantasy as you are under the age of 18";
                  }

                  //adhar_card_details_idfy update
                  $adhar_card_details_idfy['status'] = $verify_status;
                  $adhar_card_details_idfy['unique_id'] = $unique_id;

                  // adhar card detail update
                  $adhar_card_details_update['status']=$verify_status;
                  $adhar_card_details_update['comment']=$comment;

                }
                else
                {
                    $verify_status = 2;
                    $comment ='Rejected from digilocker.';

                    //adhar_card_details_idfy update
                    $adhar_card_details_idfy['status'] = $verify_status;
                    $adhar_card_details_idfy['unique_id'] = $unique_id;

                    // adhar card detail update
                    $adhar_card_details_update['status']=$verify_status;
                    $adhar_card_details_update['comment']=$comment;
                }

                // \Log::info(json_encode($request->all()).'pinkytestnew');
                // die;

                $checkUniqueidData = DB::table('adhar_card_details_idfy')->where('unique_id',$unique_id)->where('user_id','!=',$user_id)->where('status',1)->first();

                if(!empty($checkUniqueidData))
                {
                    $verify_status = 2;
                    $comment ='Another user verified by this adhar.';


                    //adhar_card_details_idfy update
                    $adhar_card_details_idfy['status'] = $verify_status;
                    $adhar_card_details_idfy['unique_id'] = $unique_id;

                    // adhar card detail update
                    $adhar_card_details_update['status']=$verify_status;
                    $adhar_card_details_update['comment']=$comment;
                }

                if($verify_status == 1)
                {
                    $pancard = DB::table('pancard')->where('userid',$user_id)->where('status',1)->first();

                    if(!empty($pancard))
                    {
                        $name_not_match_withPAN = $this->matchNameIDFY($parsed_details['name'],$pancard->pan_name,$user_id);
                        if($name_not_match_withPAN == 1)
                        {
                              $verify_status = 2;
                              $comment ='Name not matched.';

                              //adhar_card_details_idfy update
                              $adhar_card_details_idfy['status'] = $verify_status;
                              $adhar_card_details_idfy['unique_id'] = $unique_id;

                              // adhar card detail update
                              $adhar_card_details_update['status']=$verify_status;
                              $adhar_card_details_update['comment']=$comment;
                        }
                    }
                }
                $adhar_card_details_update['user_name']=$parsed_details['name'];
                DB::connection('mysql-write')->table('adhar_card_details_idfy')->where('reference_id',$reference_id)->where('user_id',$user_id)->update($adhar_card_details_idfy);

                DB::connection('mysql-write')->table('registerusers')->where('id',$user_id)->update(array('aadhar_verify'=>$verify_status));

                $userAdharAlreadyexists = DB::table('adhar_card_details')->where('userid',$user_id)->first();

                if(!empty($userAdharAlreadyexists))
                {

                    DB::connection('mysql-write')->table('adhar_card_details')->where('userid',$user_id)->update($adhar_card_details_update);
                }
                else
                {
                    $adhar_card_details_update['userid'] = $user_id;
                    DB::connection('mysql-write')->table('adhar_card_details')->insert($adhar_card_details_update);
                }


                $st = '';
                if($verify_status==1){
                  $st='Verified';
                  Helpers::kycOffer($user_id,'aadhar');

                  DB::connection('mysql-write')->table('registerusers')->where('id',$user_id)->update(array("state" => $parsed_details['state']));

                }
                if($verify_status==2){
                  $st='rejected';
                }
                $notificationdata = array();
                $notificationdata['userid'] = $user_id;
                $notificationdata['title'] = 'Your Aadhar card verification request is '.$st;
                if($st!='Verified'){
                  $notificationdata['title'] = 'Your Aadhar card request is '.$st.' Due to '.$comment;
                }
                DB::connection('mysql-write')->table('notifications')->insert($notificationdata);
                //push notifications//
                $titleget = 'Verification Request!';
                Helpers::sendnotification($titleget,$notificationdata['title'],'',$user_id);

                DB::connection('mysql-write')->table('adhar_digilocker_res_log')->where('id',$insertget_id)->update(['status'=>1]);

                return "updated";
              }
      }

       public function pan_verify_webhook(Request $request) {
          // \Log::info(json_encode($request->all()).'_DigilockerLivePANind_pan_checkPINKY');
          // die;

          $response = (object)json_decode(json_encode($request->all()));

          if(@$response->type)
          {
              if($response->type == "validate_bank_account")
              {
                  $this->bank_verify_webhook($request);
                  exit;
              } else if (strtolower(@$response->type) == "aadhaar_lite") {
                  $r = $this->aadharWebhook($response);
                  exit;
              }
              // elseif (strtolower(@$response->type) == "dummy_pan_verification") {
              //     $r = $this->pan_verify_webhook_dummy($response);
              //     exit;
              // }

              exit;

              $array_update = array(
                  'request_id'=>$response->request_id,
                  'response'=>json_encode($request->all())
              );
              DB::connection('mysql-write')->table('pan_digilocker_response')->insert($array_update);

              $value = DB::table("pancard_idfy as pi")
                  ->join("pancard as p", "p.id", "=", "pi.pancard_table_id")
                  ->selectRaw("p.pan_number, p.pan_name, p.userid, pi.*")
                  ->where("pi.request_id",  $response->request_id)
                  ->first();

              if(empty($value))
              {
                  \Log::info($response->request_id.'_DigilockerPANRequestNotFound');
                  exit;
              }

              if(@$response->status == "completed") {
                $comment = "";
                $status = 1;
                $pan_dob = "";
                $verified_by_api = 1;
                $pan_state = "";
                $pan_name_update = $value->pan_name;

                $aadhar_linked = 0;

                if(@$response->result->source_output->status == "id_found") {

                  $dob = @$response->result->source_output->dob ?? "";
                  $full_name = @$response->result->source_output->full_name ?? "";
                  $pan_state = @$response->result->source_output->address->state ?? "";
                  $aadhar_linked = @$response->result->source_output->aadhaar_linked ?? 0;

                  if($dob == '')
                  {
                      $adhar_card_details_idfy_res =  DB::table('adhar_card_details_idfy')->where('user_id',$value->userid)->where('status',1)->first();
                      if(!empty($adhar_card_details_idfy_res) && ($adhar_card_details_idfy_res->dob !=''))
                      {
                          $dob = $adhar_card_details_idfy_res->dob;
                      }
                  }

                  if($full_name == '')
                  {
                      $full_name = @$response->result->source_output->name_on_card ? $response->result->source_output->name_on_card :  "";
                  }

                  /* shufling name code start*/
                  $full_name_A = explode(' ',strtoupper($full_name));
                  $value_pan_name = @$value->pan_name ? explode(' ',$value->pan_name) : array();

                  $pannamenotmatch = 0;

                  if(!empty($dob)) {
                      $birthdate = new DateTime($dob);
                      $today   = new DateTime('today');
                      $age = $birthdate->diff($today)->y;
                      if($age < 18) {
                        $comment = "Minor age below 18years";
                        $status = 2;
                        $verified_by_api = 0;
                      }

                      $pan_dob = $dob;
                  }

                  if(($pan_state != '') && ($status==1))
                  {
                    if(in_array(strtoupper($pan_state),BANNED_STATES))
                    {
                      $comment = "State is in banned state.";
                      $status = 2;
                      $verified_by_api = 0;
                    }
                  }
                  if($status==1)
                  {
                        // if($value->userid ==5266014 || $value->userid ==245 || $value->userid ==1321)
                        // {

                        $adhar_card_detailsP = DB::table('adhar_card_details')->where('userid',$value->userid)->where('status',1)->first();
                        if(!empty($adhar_card_detailsP))
                        {
                            $pannamenotmatch = $this->matchNameIDFY($adhar_card_detailsP->user_name,$full_name,$value->userid);

                            if($pannamenotmatch == 1)
                            {
                              $comment = "PAN NAME not matched";
                              $status = 2;
                              $verified_by_api = 0;
                            }
                            else
                            {
                                $comment = "";
                                $status = 1;
                                $verified_by_api = 1;
                                $pan_name_update = $full_name;
                            }
                        }
                        // }
                        // else {
                        //
                        //     if(count($value_pan_name)>0)
                        //     {
                        //       foreach($value_pan_name as $pname_A)
                        //       {
                        //           if(!in_array(trim(strtoupper($pname_A)),$full_name_A))
                        //           {
                        //             $pannamenotmatch = 1;
                        //           }
                        //       }
                        //     }
                        //
                        //       /* shufling name code end*/
                        //
                        //         /* 80% match name code start*/
                        //
                        //     $percentstring = round((similar_text($value->pan_name,$full_name)/ strlen($value->pan_name)) * 100, 2);
                        //     if($pannamenotmatch == 1 && $percentstring < 80)
                        //     {
                        //       $comment = "PAN NAME not matched";
                        //       $status = 2;
                        //       $verified_by_api = 0;
                        //     }
                        //
                        //   }
                        /* 80% match name code end*/
                        // if(strtolower($full_name) != strtolower(@$value->pan_name)) {
                        //   $comment = "PAN NAME not matched";
                        //   $status = 2;
                        //   $verified_by_api = 0;
                        // }
                    }
                }
                else {
                    $comment = "PAN data not found on digilocker";
                    $status = 2;
                    $verified_by_api = 0;
                }

                DB::connection('mysql-write')->table("pancard_idfy")->where("id", $value->id)
                  ->update([
                      "status" => $status,
                      "response" => json_encode($response)
                  ]);

                $update_pancard = [
                    "status" => $status,
                    "comment" => $comment,
                    "pan_dob" => $pan_dob,
                    "verified_by_api" => $verified_by_api,
                    "pan_name" => $pan_name_update,
                    "aadhaar_linked_checkByIDFY" => $aadhar_linked
                ];

                DB::connection('mysql-write')->table("pancard")->where("id", $value->pancard_table_id)
                  ->update($update_pancard);

                DB::connection('mysql-write')->table("registerusers")->where("id", $value->userid)
                  ->update([
                    "pan_verify" => $status
                  ]);

                $st = '';
                if($status==1){
                  $st='Verified';
                }
                if($status==2){
                  $st='rejected';
                }
                $notificationdata = array();
                $notificationdata['userid'] = $value->userid;
                $notificationdata['title'] = 'Your PAN verification request is '.$st;
                if($st!='Verified'){
                  $notificationdata['title'] = 'Your PAN request is '.$st.' Due to '.$comment;
                }
                DB::connection('mysql-write')->table('notifications')->insert($notificationdata);
                //push notifications//
                $titleget = 'Verification Request!';
                Helpers::sendnotification($titleget,$notificationdata['title'],'',$value->userid);

              }
              else if(@$response->status == "failed") {

                $status = 2;
                $comment = 'Rejected.';
                $verified_by_api = 0;

                DB::connection('mysql-write')->table("pancard_idfy")->where("id", $value->id)
                  ->update([
                    "status" => $status,
                    "response" => json_encode($response)
                  ]);
                $update_pancard = [
                    "status" => $status,
                    "comment" => $comment,
                    "verified_by_api" => $verified_by_api
                  ];
                DB::connection('mysql-write')->table("pancard")->where("id", $value->pancard_table_id)
                  ->update($update_pancard);

                DB::connection('mysql-write')->table("registerusers")->where("id", $value->userid)
                  ->update([
                    "pan_verify" => $status
                  ]);

                $st = '';
                if($status==1){
                  $st='Verified';
                }
                if($status==2){
                  $st='rejected';
                }
                $notificationdata = array();
                $notificationdata['userid'] = $value->userid;
                $notificationdata['title'] = 'Your PAN verification request is '.$st;
                if($st!='Verified'){
                  $notificationdata['title'] = 'Your PAN request is '.$st.' Due to '.$comment;
                }
                DB::connection('mysql-write')->table('notifications')->insert($notificationdata);
                //push notifications//
                $titleget = 'Verification Request!';
                Helpers::sendnotification($titleget,$notificationdata['title'],'',$value->userid);
              }
          }
      }

    public function getBankDetailByIFSC($ifsc=''){
  		  $curl = curl_init();

  		  curl_setopt_array($curl, array(
  		  CURLOPT_URL => 'https://ifsc.razorpay.com/'.$ifsc,
  		  CURLOPT_RETURNTRANSFER => true,
  		  CURLOPT_ENCODING => '',
  		  CURLOPT_MAXREDIRS => 10,
  		  CURLOPT_TIMEOUT => 0,
  		  CURLOPT_FOLLOWLOCATION => true,
  		  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
  		  CURLOPT_CUSTOMREQUEST => 'GET',
  		  ));

  		  $response = curl_exec($curl);

  		  curl_close($curl);
  		  return $result = json_decode($response);
  	}

   public function aadharWebhook($input) {
      // \Log::info("aadharWebhook". json_encode($input));
      $request_id = @$input->request_id ?? "";

      DB::table("adhar_digilocker_res_log")->insert(["response" => json_encode($input)]);
      $array_update = array(
        'reference_id'=>$request_id,
        'response'=> json_encode($input)
      );
      DB::table('adhar_digilocker_response')->insert($array_update);

      $idfy_aadhar_response = DB::connection('mysql-write')->table("adhar_card_details_idfy")
        ->where("reference_id", $request_id)
        ->first();
      if(empty($idfy_aadhar_response)) {
        return 1;
      }

      // Check if user data exist in table / if not return 0
      $adharUser = DB::table("adhar_card_details")->where("userid", $idfy_aadhar_response->user_id)->first();

      if(empty($adharUser)){
          return 0;
      }

      $user_id = $idfy_aadhar_response->user_id;
      $titleget = 'Verification Request!';
      $notificationdata = array();
      $notificationdata['userid'] = $user_id;

      if(@$input->status == "failed") {
        if(@$input->error != "") {
          if($input->error == "INSUFFICIENT_CREDITS") {
            return 0;
          }
        }

        DB::connection('mysql-write')->table("adhar_card_details_idfy")
          ->where("id", $idfy_aadhar_response->id)
          ->update(["status" => 2, "status_idfy" => @$input->message ?? ""]);

        DB::table("adhar_card_details")->where("userid", $idfy_aadhar_response->user_id)
          ->update(["status" => 2, "comment" => "Your Aadhaar card request is rejected. Please use a valid number to proceed."]);

        DB::table('registerusers')->where('id',$idfy_aadhar_response->user_id)->update(array('aadhar_verify'=>2));

        $notificationdata['title'] = "Your Aadhaar card request is rejected. Please use a valid number to proceed.";
        DB::connection('mysql-write')->table('notifications')->insert($notificationdata);
        Helpers::sendnotification($titleget,$notificationdata['title'],'',$user_id);

        return 0;
      }

      if(@$input->status != "completed" || @$input->result->source_output->status != "id_found") {
        DB::connection('mysql-write')->table("adhar_card_details_idfy")
          ->where("id", $idfy_aadhar_response->id)
          ->update(["status" => 2, "status_idfy" => @$input->result->source_output->status ?? ""]);

        DB::table("adhar_card_details")->where("userid", $idfy_aadhar_response->user_id)
          ->update(["status" => 2, "comment" => "Your Aadhaar card request is rejected. Please use a valid number to proceed."]);

        DB::table('registerusers')->where('id',$idfy_aadhar_response->user_id)->update(array('aadhar_verify'=>2));

        $notificationdata['title'] = "Your Aadhaar card request is rejected. Please use a valid number to proceed.";
        DB::connection('mysql-write')->table('notifications')->insert($notificationdata);
        Helpers::sendnotification($titleget,$notificationdata['title'],'',$user_id);

        return 0;
      }

      $source_output = @$input->result->source_output ?? "";
      if(empty($source_output)) {
        return 0;
      }

      if(@$source_output->age_band->lower_limit < 18) {
        return 0;
        DB::connection('mysql-write')->table("adhar_card_details_idfy")
          ->where("id", $idfy_aadhar_response->id)
          ->update(["status" => 2, "status_idfy" => "Lower Age Limit"]);

        DB::table("adhar_card_details")->where("userid", $idfy_aadhar_response->user_id)
          ->update(["status" => 2, "comment" => "Lower Age Limit"]);

        DB::table('registerusers')->where('id',$idfy_aadhar_response->user_id)->update(array('aadhar_verify'=>2));

        $notificationdata['title'] = 'Your Aadhar card request is rejected due to Lower Age Limit.';
        DB::connection('mysql-write')->table('notifications')->insert($notificationdata);
        Helpers::sendnotification($titleget,$notificationdata['title'],'',$user_id);

        return 0;
      }

      if(@$source_output->state != "" && in_array(strtoupper($source_output->state),BANNED_STATES)) {
        DB::connection('mysql-write')->table("adhar_card_details_idfy")
          ->where("id", $idfy_aadhar_response->id)
          ->update(["status" => 2, "status_idfy" => "Banned State(".$source_output->state.")"]);

        DB::table("adhar_card_details")->where("userid", $idfy_aadhar_response->user_id)
          ->update(["status" => 2, "comment" => "You are not eligible to play fantasy sports, Because it is banned in your state."]);

        DB::table('registerusers')->where('id',$idfy_aadhar_response->user_id)->update(array('aadhar_verify'=>2));

        $notificationdata['title'] = 'Your Aadhar card request is rejected due to You are not eligible to play fantasy sports, Because it is banned in your state.';
        DB::connection('mysql-write')->table('notifications')->insert($notificationdata);
        Helpers::sendnotification($titleget,$notificationdata['title'],'',$user_id);

        return 0;
      }

      // Create unique id and check if unique id already exist then hit error
      $adhar4digit = substr($adharUser->adhar_number, -4);
      $adharUserName = str_replace(' ','',$adharUser->user_name);
      $uniqueId = date('Ymd',strtotime($idfy_aadhar_response->dob)).'-'.$adhar4digit.'-'.$source_output->state.$adharUserName;
      // $uniqueId = substr($adharUser->adhar_number, -4).substr($source_output->mobile_number, -3).strtolower($source_output->state);

      // Check unique id already exist or not
      $checkUniqueId = DB::connection('mysql-write')->table("adhar_card_details_idfy")
        ->where("unique_id", $uniqueId)
        ->where("user_id", "!=", $idfy_aadhar_response->user_id)
        ->where("status", "<>", 2)
        ->first();

      if(!empty($checkUniqueId)){
          DB::connection('mysql-write')->table("adhar_card_details_idfy")
            ->where("id", $idfy_aadhar_response->id)
            ->update(["status" => 2, "status_idfy" => "Another user verified by this adhar."]);

          DB::table("adhar_card_details")->where("userid", $idfy_aadhar_response->user_id)
            ->update(["status" => 2, "comment" => "Another user verified by this adhar."]);

          DB::table('registerusers')->where('id',$idfy_aadhar_response->user_id)->update(array('aadhar_verify'=>2));

          $notificationdata['title'] = 'Your Aadhar card request is rejected due to Another user verified by this adhar.';
          DB::connection('mysql-write')->table('notifications')->insert($notificationdata);
          Helpers::sendnotification($titleget,$notificationdata['title'],'',$user_id);

          return 0;
      }

      DB::connection('mysql-write')->table("adhar_card_details_idfy")
        ->where("id", $idfy_aadhar_response->id)
        ->update(["status" => 1, "unique_id" => $uniqueId, "status_idfy" => "SUCCESS"]);

      DB::table("adhar_card_details")->where("userid", $idfy_aadhar_response->user_id)
        ->update(["status" => 1, "comment" => "Approved by IDFY", "verified_by_idfy" => 1]);

      DB::table('registerusers')->where('id',$idfy_aadhar_response->user_id)->update(
        array('aadhar_verify'=>1,'state'=>$source_output->state)
      );

      $notificationdata['title'] = 'Your Aadhar card verification request is approved.';
      DB::connection('mysql-write')->table('notifications')->insert($notificationdata);
      Helpers::sendnotification($titleget,$notificationdata['title'],'',$user_id);

      return 1;

  }
}
?>
