<?php
namespace App\Http\Controllers;
use DB;
use Session;
use bcrypt;
use Config;
use Redirect;
use Hash;
use App\global_constants;
use Mail;
use Carbon\Carbon;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Http\Requests;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\Input;
class FootballController extends Controller {
	public function accessrules(){
		header('Access-Control-Allow-Origin: *');
		header("Access-Control-Allow-Credentials: true");
		header('Access-Control-Allow-Methods: GET, PUT, POST, DELETE, OPTIONS');
		header('Access-Control-Max-Age: 1000');
		header('Access-Control-Allow-Headers: Authorization');
		header('Access-Control-Allow-Headers: Origin, Content-Type, X-Auth-Token');
	}

	public static function genrateToken() {
		return "8b510d5fe1749b667021b0ac2f1ccfde";
		return ENTITY_SPORT_TOKEN_FOOTBALL;
	}

	public static function getMatches(){
    $token = FootballController::genrateToken();
    // echo ENTITY_SPORT_API_URL_FOOTBALL."matches/?token=".$token."&status=1&per_page=50&=&paged=1"; exit;
        $curl = curl_init();

        curl_setopt_array($curl, array(
          CURLOPT_URL => ENTITY_SPORT_API_URL_FOOTBALL."matches/?token=".$token."&status=1&per_page=20&=&paged=1&pre_squad=true",
          CURLOPT_RETURNTRANSFER => true,
          CURLOPT_ENCODING => "",
          CURLOPT_MAXREDIRS => 10,
          CURLOPT_TIMEOUT => 60,
          CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
          CURLOPT_CUSTOMREQUEST => "GET",
          CURLOPT_HTTPHEADER => array(
            "Cache-Control: no-cache"
          ),
        ));

        $response = curl_exec($curl);
        $err = curl_error($curl);

        curl_close($curl);

        if ($err) {
          echo "cURL Error #:" . $err;
        } else {
          $result = json_decode($response);
          // print_r($result); exit;
          if($result->status=="ok") {
            $response = $result->response;
              $data = $response->items;
              return $data;
          }
        }
  }

	public static function get_match_squad($match_id, $comp_id) {
		$token = FootballController::genrateToken();
        $curl = curl_init();
 // echo ENTITY_SPORT_API_URL_FOOTBALL."matches/".$match_id."/newfantasy?token=".$token."&status=1&per_page=100&=&paged=1";
        curl_setopt_array($curl, array(
          CURLOPT_URL => ENTITY_SPORT_API_URL_FOOTBALL."matches/".$match_id."/newfantasy?token=".$token."&status=1&per_page=100&=&paged=1",
          CURLOPT_RETURNTRANSFER => true,
          CURLOPT_ENCODING => "",
          CURLOPT_MAXREDIRS => 10,
          CURLOPT_TIMEOUT => 30,
          CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
          CURLOPT_CUSTOMREQUEST => "GET",
          CURLOPT_HTTPHEADER => array(
            "Cache-Control: no-cache"
          ),
        ));

        $response = curl_exec($curl);
        $err = curl_error($curl);

        curl_close($curl);
        if ($err) {
          echo "cURL Error #:" . $err;
        } else {
        	$result = json_decode($response);
					// var_dump($result);exit;
        	if(@$result->status=="ok") {
        		$response = $result->response;
            	return $response;
        	}
        }
	}


  public static function get_live_score_data($matchkey,$comp_id) {
    $token = FootballController::genrateToken();
      $curl = curl_init();


      $url = ENTITY_SPORT_API_URL_FOOTBALL."matches/".$matchkey."/statsv2?token=".$token."";

      curl_setopt_array($curl, array(
        CURLOPT_URL => ENTITY_SPORT_API_URL_FOOTBALL."matches/".$matchkey."/statsv2?token=".$token."",
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_ENCODING => "",
        CURLOPT_MAXREDIRS => 10,
        CURLOPT_TIMEOUT => 30,
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLOPT_CUSTOMREQUEST => "GET",
        CURLOPT_HTTPHEADER => array(
          "Cache-Control: no-cache",
          "Postman-Token: cc748f1a-a898-463c-900c-47e74ac7b2c4"
        ),
      ));

      $response = curl_exec($curl);
      $err = curl_error($curl);


      curl_close($curl);
      if ($err) {
        echo "cURL Error #:" . $err; exit;
      } else {
        $result = json_decode($response);
        if($result->status=='ok') {
          $response = $result->response;
          return $response;
        }
      }
    }


	public static function get_match_details($match_id) {
		$token = FootballController::genrateToken();
        $curl = curl_init();

        curl_setopt_array($curl, array(
          CURLOPT_URL => ENTITY_SPORT_API_URL_FOOTBALL."/matches/".$match_id."/info?token=".$token,
          CURLOPT_RETURNTRANSFER => true,
          CURLOPT_ENCODING => "",
          CURLOPT_MAXREDIRS => 10,
          CURLOPT_TIMEOUT => 30,
          CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
          CURLOPT_CUSTOMREQUEST => "GET",
          CURLOPT_HTTPHEADER => array(
            "Cache-Control: no-cache"
          ),
        ));

        $response = curl_exec($curl);
        $err = curl_error($curl);

        curl_close($curl);

        if ($err) {
          echo "cURL Error #:" . $err;
        } else {
        	$result = json_decode($response);
        	if($result->status=="ok") {
        		$response = $result->response;
            	return $response;
        	}
        }
	}

	public static function get_match_score($match_id) {
		$token = FootballController::genrateToken();
        $curl = curl_init();
 //echo ENTITY_SPORT_API_URL_FOOTBALL."/matches/".$match_id."/newfantasy?token=".$token; exit;
        curl_setopt_array($curl, array(
          CURLOPT_URL => ENTITY_SPORT_API_URL_FOOTBALL."/matches/".$match_id."/newfantasy?token=".$token,
          CURLOPT_RETURNTRANSFER => true,
          CURLOPT_ENCODING => "",
          CURLOPT_MAXREDIRS => 10,
          CURLOPT_TIMEOUT => 30,
          CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
          CURLOPT_CUSTOMREQUEST => "GET",
          CURLOPT_HTTPHEADER => array(
            "Cache-Control: no-cache"
          ),
        ));

        $response = curl_exec($curl);
        $err = curl_error($curl);

        curl_close($curl);
        // echo ENTITY_SPORT_API_URL_FOOTBALL."/matches/".$match_id."/newfantasy?token=".$token; exit;
        if ($err) {
          echo "cURL Error #:" . $err;
        } else {
        	$result = json_decode($response);

        	if(@$result->status=="ok") {
        		$response = $result->response;
            	return $response;
        	}
        }
	}

    public static function get_match_playing_players($api_unique_id) {
        $token = FootballController::genrateToken();
        // echo ENTITY_SPORT_API_URL_FOOTBALL."/matches/".$api_unique_id."/info?token=".$token.""; exit;
        $curl = curl_init();

        curl_setopt_array($curl, array(
            CURLOPT_URL => ENTITY_SPORT_API_URL_FOOTBALL."/matches/".$api_unique_id."/info?token=".$token."",
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => "",
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 30,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => "GET",
            CURLOPT_HTTPHEADER => array(
                "Cache-Control: no-cache"
            ),
        ));

        $response = curl_exec($curl);
        $err = curl_error($curl);
        // print_r($response); exit;
        curl_close($curl);

        if ($err) {
            echo "cURL Error #:" . $err;
        } else {
            $result = json_decode($response);
            if($result->status=="ok" && isset($result->response->items->lineup) && !empty($result->response->items->lineup)) {
                $response = $result->response->items->lineup;
                $playing_players = array();
                if(isset($response->home->lineup->player) && isset($response->away->lineup->player)) {
                    $teama_players = $response->home->lineup->player;
                    $teamb_players = $response->away->lineup->player;
                    $players = array_merge($teama_players, $teamb_players);
                    foreach ($players as $player) {
                        $playing_players[] = $player->pid;
                    }
                }
                return $playing_players;
            }
        }
    }

    public static function get_tournament_matches() {
      $curl = curl_init();

      curl_setopt_array($curl, array(
        CURLOPT_URL => "http://api.rglabs.net/api/football/get_tournament_matches",
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_ENCODING => "",
        CURLOPT_MAXREDIRS => 10,
        CURLOPT_TIMEOUT => 0,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLOPT_CUSTOMREQUEST => "GET",
      ));

      $response = curl_exec($curl);

      curl_close($curl);
      return json_decode($response, true);

    }

    public static function get_tournament_team($tour, $team) {
      $curl = curl_init();
      // echo "http://api.rglabs.net/api/football/get_tournament_team/".$tour."/".$team; exit;
      curl_setopt_array($curl, array(
        CURLOPT_URL => "http://api.rglabs.net/api/football/get_tournament_team/".$tour."/".$team,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_ENCODING => "",
        CURLOPT_MAXREDIRS => 10,
        CURLOPT_TIMEOUT => 0,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLOPT_CUSTOMREQUEST => "GET",
      ));

      $response = curl_exec($curl);
      // print_r($response); exit;
      curl_close($curl);
      return json_decode($response, true);
    }

    public static function getmatchdetails($matchkey) {
      if($matchkey=='1158671669221527660') {

        // echo "http://api.rglabs.net/api/football/getmatchdetails/".$matchkey; exit;
      }
      $curl = curl_init();

      curl_setopt_array($curl, array(
        CURLOPT_URL => "http://api.rglabs.net/api/football/getmatchdetails/".$matchkey,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_ENCODING => "",
        CURLOPT_MAXREDIRS => 10,
        CURLOPT_TIMEOUT => 0,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLOPT_CUSTOMREQUEST => "GET",
      ));

      $response = curl_exec($curl);
      if($matchkey=='1158671669221527660') {
        // print_r($response);// exit;
        // echo "http://api.rglabs.net/api/football/getmatchdetails/".$matchkey; exit;
      }
      curl_close($curl);
      return json_decode($response, true);
    }

    public static function getmatchcredit($matchkey) {
      if($matchkey=='1158671669221527660') {

      }
        // echo "http://api.rglabs.net/api/football/getmatchcredit/".$matchkey; exit;
      $curl = curl_init();

      curl_setopt_array($curl, array(
        CURLOPT_URL => "http://api.rglabs.net/api/football/getmatchcredit/".$matchkey,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_ENCODING => "",
        CURLOPT_MAXREDIRS => 10,
        CURLOPT_TIMEOUT => 0,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLOPT_CUSTOMREQUEST => "GET",
      ));

      $response = curl_exec($curl);
      if($matchkey=='1158671669221527660') {
        // print_r($response);// exit;
        // echo "http://api.rglabs.net/api/football/getmatchdetails/".$matchkey; exit;
      }
      curl_close($curl);
      return json_decode($response, true);
    }

}
