<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;
use App\Http\Controllers\BaseController;
use App\Model\AdminUser;
use App\Model\User;
use App\Model\Media;
use App\Model\Slider;
use App\Model\CarMake;
use App\Model\CarModel;
use App\Model\Block;
use App\Model\BlockDescription;
use App\Model\Cms;
use App\Model\CmsDescription;
use App\Model\Testimonial;
use App\Model\EmailAction;
use App\Model\EmailTemplate;
use App\Model\Contact;
use App\Model\Faq;
use App\libraries\CustomHelper;
use mjanssen\BreadcrumbsBundle\Breadcrumbs;
use Str,Auth,Blade,Config,Cache,Cookie,DB,File,Hash,Input,Mail,Redirect,Request,Response,Session,URL,View,Validator;


class HomeController extends BaseController
{


  public function __construct() {
  }
  /*
  * Function to return view of home page
  */
    public function index()
    {
      $results = array();
      return view('welcome',compact('results'));
    } // end index()

    /*
    * Function to return view of login
    */
    public function login()
    {
        return view('admin/Login/login');
    } // end login()
    /*
    * Function to return view of dealer_login
    */
    public function dealer_login()
    {
        return view('pages/dealer_login');
    } // end dealer_login()

    /**
   * Function to verify user if not verified
   *
   * @param $encId as validate String
   *
   * @return void()
   */
      public function user_verification($validateString = NULL) {
      if(isset($validateString) && !empty($validateString) && $validateString != NULL){
        $userInfo		=	User::where('validate_string',$validateString)->first();
        if (isset($userInfo) && !empty($userInfo)) {
          $is_verified	=	$userInfo->is_verified;
          if(isset($is_verified) && $is_verified	==	ACTIVE){
            return Redirect::route('home')->with('flash_notice', trans('messages.user.already_verified'));
          }else{
            User::where('validate_string', '=', $validateString)->update(array('is_verified' => ACTIVE,'validate_string'=>''));
            /*Send mail to user for verification mail */

            $settingsEmail 			=	Config::get('Site.email');
            $full_name				=	$userInfo->full_name;
            $email					=	$userInfo->email;
            $route_url      		=  	route('login');
            $link 					=   $route_url;
            $click_link 			= '<a target="_blank" style="font-weight:bold;text-decoration:none;color:#4286f4;" href="' . $link . '">' . trans('messages.user.click_here') . '</a>';

            $emailActions			= 	EmailAction::where('action','=','thanks_for_registration')->get()->toArray();

            $emailTemplates			= 	EmailTemplate::where('action','=','thanks_for_registration')
                            ->get(array('name','subject','action','body'))->toArray();

            $cons 					= 	explode(',',$emailActions[0]['options']);

            $constants 				= 	array();

            foreach($cons as $key => $val){
              $constants[] 		= 	'{'.$val.'}';
            }

            $subject 				= 	$emailTemplates[0]['subject'];
            $rep_Array 				= 	array($full_name,$click_link,$route_url);
            $messageBody			= 	str_replace($constants, $rep_Array, $emailTemplates[0]['body']);

            $mail					= 	$this->sendMail($email,$full_name,$subject,$messageBody,$settingsEmail);

            /*Send mail to user for verification mail */
            Session::flash('flash_notice',trans("messages.user.verified_success_message"));
            return Redirect::route("home");
          }
        }else{
          return Redirect::route('home')->with('error', trans('messages.Sorry_you_are_using_wrong_link'));
        }
      }else{
        return Redirect::route('home')->with('error', trans('messages.Sorry_you_are_using_wrong_link'));
      }

    } // end user_verification()


/**
   * Function to verify user if not verified
   *
   * @param $encId as validate String
   *
   * @return void()
   */
  public function send_verifylink_again($encId = null) {
  if (!empty($encId)) {
    $userInfo		=	User::where('validate_string',$encId)->first();
    if (!empty($userInfo)) {
      $validateString =  $userInfo->validate_string;
              $full_name 	=	$userInfo->full_name;
              $email 		= 	$userInfo->email;
      /*Send mail to user for resend verification mail */
      $settingsEmail 			=	Config::get('Site.email');
      $full_name				=	$full_name;
      $validateStr 			=  $validateString;
      $route_url      		=  	route('email_verify',$validateStr);
      $link 					=   $route_url;
      $click_link 			= '<a target="_blank" style="font-weight:bold;text-decoration:none;color:#4286f4;" href="' . $link . '">Click Here</a>';

      $emailActions			= 	EmailAction::where('action','=','resend_verification_link')->get()->toArray();

      $emailTemplates			= 	EmailTemplate::where('action','=','resend_verification_link')
                      ->get(array('name','subject','action','body'))->toArray();

      $cons 					= 	explode(',',$emailActions[0]['options']);

      $constants 				= 	array();

      foreach($cons as $key => $val){
        $constants[] 		= 	'{'.$val.'}';
      }

      $subject 				= 	$emailTemplates[0]['subject'];
      $rep_Array 				= 	array($full_name,$click_link,$route_url);
      $messageBody			= 	str_replace($constants, $rep_Array, $emailTemplates[0]['body']);

      $mail					= 	$this->sendMail($email,$full_name,$subject,$messageBody,$settingsEmail);
      Session::flash('flash_notice',trans("Email verification link has been sent on your email address."));
      return Redirect::route("home");
      /*Send mail to user for resend verification mail */
    }else{
      Session::flash('flash_notice',trans("messages.Login.logout"));
      return Redirect::route("home");
    }
      }
}


/**
   * Fiunction for forgot password
   *
   * @param null
   *
   * @return void()
   */
  public function forgot_password() {
  /***** if auth login already ***** */
  if(Auth::check()){
    if(Auth::user()){
      return Redirect::route('home.index');
    }
  }

  $validator = Validator::make(
          Input::all(),
          array(
            'email' => 'required|email',
          )
        );
  if ($validator->fails()){
    return Redirect::back()
      ->withErrors($validator)->withInput()->with(compact(''));
  }else{
    $email							=	Input::get('email');
    $userDetail						=	AdminUser::where('email',$email)->first();
    if(!empty($userDetail) && ($userDetail->user_role_id == MEMBER)){
      if($userDetail->active == ACTIVE ){
        if($userDetail->is_verified == ACTIVE ){
          if($userDetail->is_deleted == INACTIVE ){

            $forgot_password_validate_string	= 	md5($userDetail->email);
            $reset_password_link_time		 	=	time();
            AdminUser::where('email',$email)->update(array('forgot_password_validate_string'=>$forgot_password_validate_string,'reset_password_link_time'=>$reset_password_link_time));

            $settingsEmail 		=  	Config::get('Site.email');
            $email 				=  	$userDetail->email;
            $username			=  	$userDetail->username;
            $full_name			=  	$userDetail->full_name;
            $route_url      	=  	route('home.resetpassword',$forgot_password_validate_string);

            $varify_link   		=   $route_url;

            $emailActions		=	EmailAction::where('action','=','forgot_password')->get()->toArray();
            $emailTemplates		=	EmailTemplate::where('action','=','forgot_password')->get(array('name','subject','action','body'))->toArray();
            $cons = explode(',',$emailActions[0]['options']);
            $constants = array();

            foreach($cons as $key=>$val){
              $constants[] = '{'.$val.'}';
            }
            $subject 			=  	$emailTemplates[0]['subject'];
            $rep_Array 			= 	array($full_name,$varify_link,$route_url);
            $messageBody		=  	str_replace($constants, $rep_Array, $emailTemplates[0]['body']);

            $this->sendMail($email,$full_name,$subject,$messageBody,$settingsEmail);
            Session::flash('flash_notice', trans('messages.login.forgot_password_mail_send'));
            return response()->json(['status'=>'success','message'=>trans("messages.login.forgot_password_mail_send")]);
            return Redirect::route('home.index');
            die;
          }else{
            return response()->json(['status'=>'error','message'=>trans("messages.login.account_deleted")]);
            die;
          }
        }else{
          return response()->json(['status'=>'error','message'=>trans("messages.login.not_verified")]);
          die;
        }
      }else{
        return response()->json(['status'=>'error','message'=>trans("messages.login.account_deactive")]);
        die;
      }
    }else{
      $errorMessage = trans("messages.forgot_email_error.if_account_associated") .'<strong>' .' ' .$email.'</strong>,'. trans("messages.forgot_email_error.you_will_get_link");
      return response()->json(['status'=>'error','message'=>$errorMessage]);
      die;
    }
  }

}


/**
 * function for Used to reset password
 *
 * @param $validate_string as string validate
 *
 * @return void
 */
public function resetpassword($validate_string = null){
  if($validate_string!="" && $validate_string!=null){
    $userDetail	=	User::where('active',ACTIVE)->where('forgot_password_validate_string',$validate_string)->first();
    if(!empty($userDetail)){
      return View::make('elements.resetpassword' ,compact('validate_string'));
    }else{
      return Redirect::route('home.index')
          ->with('error', trans('messages.Sorry_you_are_using_wrong_link'));
    }
  }else{
    return Redirect::route('home.index')->with('error', trans('messages.Sorry_you_are_using_wrong_link'));
  }
}//end resetpassword()


/**
 * Function is used for save reset password
 *
 * @param $validate_string as validator string
 *
 * @return view page.
 */
public function resetPasswordSave($validate_string=null){
  $newPassword		=	Input::get('new_password');
  $validate_string	=	Input::get('validate_string');

  $messages = array(
    'new_password.required' 				=> 	trans('messages.reset_password_message'),
    'new_password.regex' 					=> 	trans('messages.password.regex_message'),
    'new_password_confirmation.required' 	=> 	trans('messages.confirm_password_message'),
    'new_password.confirmed' 				=> 	trans('messages.reset_password_comfrom__match_message'),
    'new_password.min' 						=> 	trans('messages.password_help_message'),
  );

  $validator = Validator::make(
    Input::all(),
    array(
      'new_password'				=>	'required|regex:^(?=.*[A-Za-z])(?=.*\d)(?=.*[$@$!%*#?&])[A-Za-z\d$@$!%*#?&]{8,}$^',
      'new_password_confirmation' 	=>	'required|same:new_password',
    ),$messages
  );
  $newPassword		=	Hash::make($newPassword);

  if ($validator->fails()){
    $allErrors 		= 	$validator->errors()->toArray();
      return response()->json(['status'=>'error','error'=>$allErrors]);
      die;
  }else{
    $userInfo = User::where('forgot_password_validate_string',$validate_string)->first();
    if(isset($userInfo) && !empty($userInfo)){
      User::where('forgot_password_validate_string',$validate_string)
        ->update(array(
            'password'							=>	$newPassword,
            'forgot_password_validate_string'	=>	''
        ));
      $settingsEmail 		= 	Config::get('Site.email');
      $action				= 	"reset_password";
      $emailActions		=	EmailAction::where('action','=','reset_password')->get()->toArray();
      $emailTemplates		=	EmailTemplate::where('action','=','reset_password')->get(array('name','subject','action','body'))->toArray();
      $cons 				= 	explode(',',$emailActions[0]['options']);
      $constants 			= 	array();
      foreach($cons as $key=>$val){
        $constants[] 	= 	'{'.$val.'}';
      }
      $subject 			=  	$emailTemplates[0]['subject'];
      $rep_Array 			=  	array($userInfo->full_name);
      $messageBody		=  	str_replace($constants, $rep_Array, $emailTemplates[0]['body']);
      $this->sendMail($userInfo->email,$userInfo->full_name,$subject,$messageBody,$settingsEmail);
      Session::flash('flash_notice', trans('messages.Login.reset_password_message_success'));
      return response()->json(['status'=>'success','message'=>trans("messages.Login.reset_password_message_success")]);
      return Redirect::route('home.index');
    }else{
      return Redirect::route('home.index')->with('error', trans('messages.Sorry_you_are_using_wrong_link'));
    }
  }
}// end resetPasswordSave()

 /**
* Function use for subscribe for newsletter
*
* @param null

* @return void.
*/
public function subscriber() {

$object	=	new NewsLettersubscriber;
$email				=	Input::get('email');
$message	=	array(
      'email.required' 	=>	trans('messages.email.REQUIRED_ERROR'),
      'email.email' 		=>	trans('messages.email.VALID_EMAIL_ERROR'),
      'email.unique' 		=>	trans('messages.email_subscribe.UNIQUE_EMAIL_ERROR'),
);
$validate	=	array(
      'email' 			=>	'required|email|unique:newsletter_subscribers,email,NULL,id'
);
$validator = Validator::make(Input::all(),$validate,$message);
if ($validator->fails()){
    $allErrors 		= 	$validator->errors()->toArray();
    return response()->json(['status'=>'error','error'=>$allErrors]);
    die;
}else{

  $user_id	=	Auth::user('id');

  if($user_id != '' && $user_id > 0){
    $object->user_id		=	$user_id;
  }else{
    $object->user_id		=	0;
  }

  /*create a new subscriber for newsletter*/

  $encId			=	md5(time() . Input::get('email'));

  $object->email	  		=  Input::get('email');
  $object->name	  		=  Input::get('name');
  $object->is_verified 	=  ACTIVE;
  $object->status 		=  ACTIVE;
  $object->enc_id 		=  $encId;
  $object->created_at 	= new DateTime();
  $object->updated_at 	= new DateTime();
  $object->save();

  $users	=	User::where('email',$email)->first();

  //mail email and password to new registered user
  $settingsEmail 			=	Config::get('Site.email');
  $full_name				=	isset($users->full_name)?$users->full_name:'Guest';
  $email					=	$email;
  $route_url      		=  	route('newsletter.unsubscribe',$encId);
  $click_link   			=   $route_url;
  $unsubscribe_link = '<a target="_blank" style="font-weight:bold;text-decoration:none;color:#428bca;" href="' . $click_link . '">' .('(unsubscribe)') . '</a>';
  $emailActions			= 	EmailAction::where('action','=','newsletter_subscription')->get()->toArray();
  $emailTemplates			= 	EmailTemplate::where('action','=','newsletter_subscription')
                  ->get(array('name','subject','action','body'))->toArray();

  $cons 					= 	explode(',',$emailActions[0]['options']);
  $constants 				= 	array();

  foreach($cons as $key => $val){
    $constants[] 		= 	'{'.$val.'}';
  }

  $subject 				= 	$emailTemplates[0]['subject'];
  $rep_Array 				= 	array($full_name,$unsubscribe_link,$route_url);
  $messageBody			= 	str_replace($constants, $rep_Array, $emailTemplates[0]['body']);

  $mail					= 	$this->sendMail($email,$full_name,$subject,$messageBody,$settingsEmail);
  Session::flash('flash_notice', trans("messages.NewsLettersubscriber.subscribe"));
  return response()->json(['status'=>'success']);

}
} // end subscriber()

/**
* Function to unsubscribe from newsletter
*
* @param enc_id for enc id for newsletter

* @return void.
*/
public function unsubscribe_newsletter($enc_id = null,$status = null){

$user   =  NewsLettersubscriber::where('status',ACTIVE)->where('enc_id',$enc_id)->first();

if(!empty($user)){
  $status	=	$user->status;
  if($status	==	1) {

    $email	=	$user->email;
    $enc_id	=	$user->enc_id;

    $userArray	=	NewsLettersubscriber::where('email',$email)->where('enc_id',$enc_id)->first();

    if(!empty($userArray)){
      $id = $userArray->id;
      NewsLettersubscriber::where('id', '=', $id)->update(array('status' => INACTIVE));
      Session::flash('flash_notice', trans("messages.NewsLettersubscriber.unsubscribe"));
      return Redirect::route('home.index');
    }
  }else{
    Session::flash('error', trans("messages.NewsLettersubscriber.invalidlink"));
    return Redirect::back();
  }
  }else{
    Session::flash('error', trans("messages.NewsLettersubscriber.invalidlink"));
    return Redirect::back();
  }
}// end unsubscribe_newsletter()


    /*
    * Function to return view of privacy policy
    */
    public function privacyPolicy()
    {
      $result = Cms::where('slug','privacy-policy')->where('is_active',ACTIVE)->first();
        return view('pages/cms/privacy_policy',compact('result'));
    } // end privacyPolicy()
    /*
    * Function to return view of services
    */
    public function services()
    {
      $result = Cms::where('slug','services')->where('is_active',ACTIVE)->first();
      return view('pages/cms/services',compact('result'));
    } // end services()

    /*
    * Function to return view of terms and conditions
    */
    public function termsAndConditions()
    {
      $result = Cms::where('slug','terms-and-conditions')->where('is_active',ACTIVE)->first();
        return view('pages/cms/terms_conditions',compact('result'));
    } // end termsAndConditions()
    /*
    * Function to return view of about us
    */
    public function aboutUs()
    {
      $result = Cms::where('slug','about-us')->where('is_active',ACTIVE)->first();
      return view('pages/cms/about_us',compact('result'));
    } // end aboutUs()
    /*
    * Function to return view of contact us
    */
    public function contactUs()
    {
        $result = [];
        return view('pages/cms/contact_us',compact('result'));
    } // end contactUs()
    /*
    * Function to  save contact us
    */
    public function contactUsSave()
    {
      $formData				=	Input::all();
      //pr($formData);die;
      if(!empty($formData)){

        $message	=	array(
              'name.required'      => 'Please enter name.',
              'name.regex'          => 'Name should have alphabets only.',
              'email.required'     => 'Please enter email.',
              'email.email'        => 'Please enter a valid email.',
              'phone.required'     => 'Please enter phone number.',
              'subject.required'   => 'Please enter subject.',
              'message.required'   => 'Please enter message.',

            );
        $validate	=	array(
            'name'			           =>	'required|regex:/^[\pL\s\-]+$/u',
            'email' 				       =>	'required|email',
            'phone' 				       =>	'required',
            'subject' 				     =>	'required',
            'message' 				     =>	'required',
          );

        $validator = Validator::make(Input::all(),$validate,$message);

        if ($validator->fails()){
           return Redirect::back()->withErrors($validator)->withInput();
        }else{

          $obj 						       =	new Contact;
          $obj->email 				  =	strip_tags(Input::get('email'));
          $obj->name			     =	strip_tags(Input::get('name'));
          $obj->phone			     =	strip_tags(Input::get('phone'));
          $obj->subject			     =	strip_tags(Input::get('subject'));
          $obj->message			     =	strip_tags(Input::get('message'));

          $obj->save();
          ##### send email to user from admin,to inform user that your message has been received successfully #####

  				$emailActions		=  EmailAction::where('action','=','contact_us')->get()->toArray();
  				$emailTemplates		=  EmailTemplate::where('action','=','contact_us')->get(array('name','subject','action','body'))->toArray();
  				$cons 				=  explode(',',$emailActions[0]['options']);
  				$constants 			=  array();

  				foreach($cons as $key=>$val){
  					$constants[] 	= '{'.$val.'}';
  				}

  				$name				=	 $obj->name;
  				$email				=	 $obj->email;
  				$phone				=	 $obj->phone;
  				$subject				=	 $obj->subject;
  				$message			=	 $obj->message;

  				$subject 			=   isset($name) && !empty($name) ? ucwords($name).' Want to Contact You' : $emailTemplates[0]['subject'];

  				$rep_Array 			=  array($name,$email,$phone,$subject,$message);
  				$messageBody		=  str_replace($constants, $rep_Array, $emailTemplates[0]['body']);

  				$this->sendMail(Config::get("Site.contact_email"),$name,$subject,$messageBody,Config::get("Site.contact_email"));

          Session::flash('flash_notices',  trans("Thank you for contact with us.Our team will contact you soon."));
          return Redirect::route('home');
        }
      }
    } // end contactUsSave()
    /*
    * Function to return view of how_it_works
    */
    public function how_it_works()
    {
      $result = Cms::where('slug','how-it-works')->where('is_active',ACTIVE)->first();
      return view('pages/cms/how_it_works',compact('result'));
    } // end how_it_works()
    /*
    * Function to return view of testimonials
    */
    public function testimonials()
    {
      $results = Testimonial::where('is_active', ACTIVE)->orderBy('updated_at','DESC')->get();
        return view('pages/cms/testimonials',compact('results'));
    } // end testimonials()
    /*
    * Function to return view of faq
    */
    public function faq()
    {
      $results = Faq::where('status',ACTIVE)->where('is_answered',ACTIVE)->orderBy('updated_at','DESC')->get();
        return view('pages/cms/faq',compact('results'));
    } // end faq()

    /*
    * Function to  save contact us
    */
    public function faqSave()
    {
      $formData				=	Input::all();
      //pr($formData);die;
      if(!empty($formData)){

        $message	=	array(
              'name.required'      => 'Please enter name.',
              'name.regex'          => 'Name should have alphabets only.',
              'email.required'     => 'Please enter email.',
              'email.email'        => 'Please enter a valid email.',
              'question.required'   => 'Please enter question.',

            );
        $validate	=	array(
            'name'			           =>	'required|regex:/^[\pL\s\-]+$/u',
            'email' 				       =>	'required|email',
            'question' 				     =>	'required',
          );

        $validator = Validator::make(Input::all(),$validate,$message);

        if ($validator->fails()){
           return Redirect::back()->withErrors($validator)->withInput();
        }else{

          $obj 						       =	new Faq;
          $obj->email 				   =	strip_tags(Input::get('email'));
          $obj->name			       =	strip_tags(Input::get('name'));
          $obj->question			   =	strip_tags(Input::get('question'));

          $obj->save();
          ##### send email to user from admin,to inform user that your message has been received successfully #####

  				$emailActions		=  EmailAction::where('action','=','faq')->get()->toArray();
  				$emailTemplates		=  EmailTemplate::where('action','=','faq')->get(array('name','subject','action','body'))->toArray();
  				$cons 				=  explode(',',$emailActions[0]['options']);
  				$constants 			=  array();

  				foreach($cons as $key=>$val){
  					$constants[] 	= '{'.$val.'}';
  				}

  				$name				=	 $obj->name;
  				$email				=	 $obj->email;
  				$question				=	 $obj->question;

  				$subject 			=  isset($name) && !empty($name) ? ucwords($name).' Has Asked a Question' : $emailTemplates[0]['subject'];

  				$rep_Array 			=  array($name,$email,$question);
  				$messageBody		=  str_replace($constants, $rep_Array, $emailTemplates[0]['body']);

  				$this->sendMail(Config::get("Site.contact_email"),$name,$subject,$messageBody,Config::get("Site.email"));

          Session::flash('flash_notices',  trans("Thank you for contact with us."));
          return Redirect::route('home');
        }
      }
    } // end faqSave()

}
