<?php
namespace App\Http\Controllers;

use App\Http\Requests;
use Illuminate\Http\Request;
use App\Model\EmailAction;
use App\Model\EmailTemplate;
use App\model\Contract;
use App\model\CarDetail;
use App\model\Payment as PaymentData; // for payment model
use Str,Auth,Blade,Config,Cache,Cookie,DB,File,Hash,Input,Mail,Redirect,Response,Session,URL,View,Validator;

//-------------------------
//All Paypal Details class
//-------------------------
use PayPal\Rest\ApiContext;
use PayPal\Auth\OAuthTokenCredential;
use PayPal\Api\Amount;
use PayPal\Api\Details;
use PayPal\Api\Item;
use PayPal\Api\ItemList;
use PayPal\Api\Payer;
use PayPal\Api\Payment; // for paypal api
use PayPal\Api\RedirectUrls;
use PayPal\Api\ExecutePayment;
use PayPal\Api\PaymentExecution;
use PayPal\Api\Transaction;

class PaypalController extends BaseController
{
    private $_api_context;
    public function __construct()
    {
        //------------------------
        //setup PayPal api context
        //------------------------
        $paypal_conf = Config::get('paypal');
        $this->_api_context = new ApiContext(new OAuthTokenCredential($paypal_conf['client_id'], $paypal_conf['secret']));
        $this->_api_context->setConfig($paypal_conf['settings']);

    }

    public function addPayment()
    {

        $contract_id = Session::get('contract_id');
  			if(!empty($contract_id)){
  				$contract = Contract::where('user_id', '=', Auth::user()->id)->where('contract_id',$contract_id)->where('payment_status', INACTIVE)->where('contract_complete_status', INACTIVE)->where('is_accepted', ACTIVE)->first();
  				if(!empty($contract)){
  					$carData = CarDetail::where('id', $contract->car_detail_id)->where('sold_status', INACTIVE)->first();
  					if (!empty($carData)) {
  							return view('addPayment',compact('contract_id','carData','contract'));
  					}else {
  						Session::flash('errorss',  trans("Sorry,for Inconvenience car has been sold or reserved.You can book another best one."));
  						return Redirect::route('car_listing');
  					}
  				}else {
  					Session::flash('errorss',  trans("Something went wrong."));
  					return Redirect::back();
  				}
  			}else{
  				Session::flash('errorss',  trans("Session Expired."));
  				return Redirect::route('car_listing');
  			}
    }

    /*
    * function to make payment
    */
    public function postPaymentWithpaypal(Request $request)
    {

			$contract_id = Session::get('contract_id');
        if(!empty($contract_id)){
          $contract = Contract::where('user_id', '=', Auth::user()->id)->where('contract_id',$contract_id)->where('payment_status', INACTIVE)->where('contract_complete_status', INACTIVE)->where('is_accepted', ACTIVE)->first();
          if (isset($contract->contract_deposit_amount_paid) && !empty($contract->contract_deposit_amount_paid)) {
    				if(!empty($contract)){
    					$carData = CarDetail::where('id', $contract->car_detail_id)->where('sold_status', INACTIVE)->first();
    					if (!empty($carData)) {
                $payer = new Payer();
                $payer->setPaymentMethod('paypal');

                 $item_1 = new Item();

                $item_1->setName($contract->car_model) //item name
                    ->setCurrency(PAYMENT_CURRENCY) // set currency
                    ->setQuantity(1)
                    ->setSku($contract->contract_id) // Similar to `item_number` in Classic API
                    ->setPrice($contract->contract_deposit_amount_paid); //unit price

                $item_list = new ItemList();
                $item_list->setItems(array($item_1));

                $amount = new Amount();
                $amount->setCurrency(PAYMENT_CURRENCY) // set currency
                    ->setTotal($contract->contract_deposit_amount_paid);

                $transaction = new Transaction();
                $transaction->setAmount($amount)
                    ->setItemList($item_list)
                    ->setDescription('Payment for new car purchase.');

                $redirect_urls = new RedirectUrls();
                $redirect_urls->setReturnUrl(URL::route('payment_status')) //Specify return URL
                    ->setCancelUrl(URL::route('payment_status'));

                $payment = new Payment();
                $payment->setIntent('Sale')
                    ->setPayer($payer)
                    ->setRedirectUrls($redirect_urls)
                    ->setTransactions(array($transaction));

                try
                {
                    $payment->create($this->_api_context);
                }
                catch (PayPal\Exception\PayPalConnectionException $ex)
                {
                    if (\Config::get('app.debug'))
                    {
                        Session::flash('errorss','Connection timeout');
                        return Redirect::route('addPayment');
                    }
                    else
                    {
                        Session::flash('errorss','Some error occur, sorry for inconvenient');
                        return Redirect::route('addPayment');
                    }
                }

                foreach($payment->getLinks() as $link)
                {
                    if($link->getRel() == 'approval_url')
                    {
                        $redirect_url = $link->getHref();
                        break;
                    }
                }
                // save data to db
                $trasactionData = @$transaction->item_list->items[0];
                if ($payment && !empty($trasactionData)) {
                  $obj  = new PaymentData;
                  $obj->contract_id = @$trasactionData->sku;
                  $obj->amount = @$trasactionData->price;
                  $obj->txn_id = '';
                  $obj->payment_id = $payment->getId();
                  $obj->description = 'car payment by paypal for '.$trasactionData->name;
                  $obj->currency_code = @$trasactionData->currency;
                  $obj->payment_status = 'Incompleted';
                  $obj->save();
                }

                // add payment ID to session
                Session::put('paypal_payment_id', $payment->getId());

                if(isset($redirect_url))
                {
                    // redirect to paypal
                  return Redirect::away($redirect_url);
                }
                  Session::flash('errorss','Unknown error occurred');
                 return Redirect::route('addPayment');
    					}else {
    						Session::flash('errorss',  trans("Sorry,for Inconvenience car has been sold or reserved.You can book another best one."));
    						return Redirect::route('car_listing');
    					}
    				}else {
    					Session::flash('errorss',  trans("Something went wrong."));
    					return Redirect::back();
    				}
          }else {
            Session::flash('errorss',  trans("Please pay a valid amount."));
            return Redirect::back();
          }
  			}else{
  				Session::flash('errorss',  trans("Session Expired."));
  				return Redirect::route('car_listing');
  			}
    } //end postPaymentWithpaypal()

    /*
    * function to check ipn
    */
    public function getPaymentStatus()
    {
        // Get the payment ID before session clear
        $payment_id = Session::get('paypal_payment_id');
        $contract_id = Session::get('contract_id');
        // clear the session payment ID
        Session::forget('paypal_payment_id');
        if (empty(Input::get('PayerID')) || empty(Input::get('token')))
        {
            Session::flash('errorss','Payment failed');
            return Redirect::route('addPayment');
        }
        $payment = Payment::get($payment_id, $this->_api_context);

        $execution = new PaymentExecution();
        $execution->setPayerId(Input::get('PayerID'));

        //---Execute the payment ---//
        $result = $payment->execute($execution, $this->_api_context);
        //get txn_id from result data
        $saleData = @$result->transactions[0]->related_resources[0]->sale;
        $txn_id = @$saleData->id;
        $payment_status =  @$saleData->state;
        if ($result->getState() == 'approved') {
            // Here Write your database logic like that insert record or value in database if you want
            $obj = PaymentData::where('payment_id', $payment_id)->first();
            if (!empty($obj)) {
              $obj->txn_id = $txn_id;
              $obj->payment_status = 'Completed';
            }else {
              $obj  = new PaymentData;
              $obj->contract_id = @$trasactionData->sku;
              $obj->amount = @$saleData->amount->total;
              $obj->txn_id = $txn_id;
              $obj->payment_id = $payment_id;
              $obj->description = 'car payment by paypal';
              $obj->currency_code = @$saleData->amount->currency;
              $obj->payment_status = 'Completed';
            }

            $contract = Contract::where('user_id', '=', Auth::user()->id)->where('contract_id',$contract_id)->where('payment_status', INACTIVE)->where('contract_complete_status', INACTIVE)->where('is_accepted', ACTIVE)->where('contract_deposit_amount_paid', @$saleData->amount->total)->first();

            if (isset($contract['dealer_data'])) {
              $dealerData = unserialize($contract['dealer_data']);
            }
            // check paypal payment status
            if ($payment_status == "completed") {
  						if(!empty($contract)){
                $carData = CarDetail::where('id', $contract->car_detail_id)->where('sold_status', INACTIVE)->first();
      					if (!empty($carData)) {
                  $current_date = date('Y-m-d H:i:s');
                  $tenDays = date('Y-m-d H:i:s', strtotime($current_date. ' + 10 days'));
                  Contract::where('user_id', '=', Auth::user()->id)->where('contract_id',$contract_id)->where('car_detail_id', $contract->car_detail_id)->update(array('payment_mode' => 'paypal','contract_complete_status' => ACTIVE,'contract_date' => strtotime($current_date),'contract_estimated_delivery_date'=>strtotime($tenDays),'contract_actual_delivery_date'=>strtotime($tenDays), 'payment_status' => ACTIVE,'txn_id' => $txn_id));

                  if(!empty($saleData->amount->total) && $contract->contract_sale_amount == @$saleData->amount->total){
                    CarDetail::where('id', $contract->car_detail_id)->update(array('sold_status'=>ONE));
                  }else {
                    CarDetail::where('id', $contract->car_detail_id)->update(array('sold_status'=>TWO));
                  }
                  // update payment table
                  $obj->save();
                  // update payment table

                  if (!empty($dealerData)) {
                    $remaining_amount = "$".($contract->contract_sale_amount - $contract->contract_deposit_amount_paid);
                    $booking_message = "Congratulations on being the most recent owner of a new ".@$contract->car_model.".Your car will be delivered by ".@$dealerData->name." at ".@$dealerData->dealer_street_number.", ".@$dealerData->dealer_street_name.", ".@$dealerData->dealer_post_code.".Please contact ".@$dealerData->dealer_main_contact_name." at '".@$dealerData->dealer_phone_number."' Contract Id '".@$contract->contract_id."' & Order Id '".@$contract->order_id."' for reference.Automotiv will confirm your delivery date. At this point,the estimated delivery will be ".date('d-m-Y',strtotime($tenDays))." as some time is required to prepare your shiny new car and also register it.Should you wish to have a specific pick up date, a special number plate, please call us let us know on 1300 XXX XXX. Or drop us an email at automitv@automitiv.com.We know you are excited to pick up your car and so are we to see you ride your new set of wheels. So please have the following ready by the ".date('d-m-Y',strtotime($tenDays)).". 1. Balance of payment of ".@$remaining_amount.".2. Certificate of currency with Financial Interest noted (if Financing) 3. CTP Green Slip";
                  }else {
                    $booking_message = 'Your car has been successfully booked.';
                  }
                  //pr($booking_message);die;

                  /*###################### Send mail to User, Dealer, Admin #######################*/
                  $emails = array();
                  $userDetail = Auth::user();
                  $dealer_email = $dealerData->email;
                  array_push($emails,$dealer_email);
                  $car_booking_validate_string	= 	md5($userDetail->email).'-'.time();
                  Contract::where('contract_id',$contract_id)->update(array('car_booking_validate_string'=>$car_booking_validate_string));

                  $settingsEmail 		=  	Config::get('Site.email');
                  array_push($emails,$settingsEmail);
                  $user_email 				=  	$userDetail->email;
                  array_push($emails,$user_email);
                  $username			=  	$userDetail->username;
                  $full_name			=  	$userDetail->first_name;
                  $route_url      	=  	route('Car_Booking_Mail',$car_booking_validate_string);
                  $varify_link   		=   $route_url;
                  $reference_code = $contract->order_id;

                  $emailActions		=	EmailAction::where('action','=','car_booking')->get()->toArray();
                  $emailTemplates		=	EmailTemplate::where('action','=','car_booking')->get(array('name','subject','action','body'))->toArray();
                  $cons = explode(',',$emailActions[0]['options']);
                  $constants = array();

                  foreach($cons as $key=>$val){
                    $constants[] = '{'.$val.'}';
                  }
                  
                  $subject 			=  	'Congratulations on the purchase of your new '. $contract->car_make.'/'.$contract->car_model.' Ref# '. $contract->order_id;
                  $rep_Array 			= 	array($full_name,$varify_link,$route_url,$reference_code,$contract->car_make,$contract->car_model);
                  $messageBody		=  	str_replace($constants, $rep_Array, $emailTemplates[0]['body']);
                  foreach ($emails as $email_key => $email_value) {
                    $this->sendMail($email_value,$full_name,$subject,$messageBody,$settingsEmail);
                  }
                  /*###################### Send mail to User, Dealer, Admin #######################*/

                  // remove contact_id
                  Session::forget('contract_id');

                  Session::flash('flash_notices',$booking_message);
                  return Redirect::route('my_orders');
                }else {
                  // car has been sold and paypal payment success also

                  /*###################### Send mail to User, Dealer, Admin #######################*/
                  $emails = array();
                  $userDetail = Auth::user();
                  $dealer_email = $dealerData->email;
                  array_push($emails,$dealer_email);
                  $car_booking_validate_string	= 	md5($userDetail->email).'-'.time();
                  Contract::where('contract_id',$contract_id)->update(array('car_booking_validate_string'=>$car_booking_validate_string,'contract_complete_status'=>THREE,'payment_status'=>ACTIVE,'txn_id'=>$txn_id));

                  $settingsEmail 		=  	Config::get('Site.email');
                  array_push($emails,$settingsEmail);
                  $user_email 				=  	$userDetail->email;
                  array_push($emails,$user_email);
                  $username			=  	$userDetail->username;
                  $full_name			=  	$userDetail->first_name;
                  $route_url      	=  	route('Car_Booking_Mail',$car_booking_validate_string);
                  $varify_link   		=   $route_url;
                  $reference_code = $contract->order_id;

                  $emailActions		=	EmailAction::where('action','=','car_booking_fail')->get()->toArray();
                  $emailTemplates		=	EmailTemplate::where('action','=','car_booking_fail')->get(array('name','subject','action','body'))->toArray();
                  $cons = explode(',',$emailActions[0]['options']);
                  $constants = array();

                  foreach($cons as $key=>$val){
                    $constants[] = '{'.$val.'}';
                  }
                  $subject 			=  	$emailTemplates[0]['subject'];
                  $rep_Array 			= 	array($full_name,$reference_code,$txn_id,$varify_link,$route_url);
                  $messageBody		=  	str_replace($constants, $rep_Array, $emailTemplates[0]['body']);
                  foreach ($emails as $email_key => $email_value) {
                    $this->sendMail($email_value,$full_name,$subject,$messageBody,$settingsEmail);
                  }
                  /*###################### Send mail to User, Dealer, Admin #######################*/

                  Session::flash('errorss',  trans("errorss,for Inconvenience car has been sold or reserved.You can book another best one."));
  								return Redirect::route('car_listing');
                }
              }else{
    						Session::flash('errorss',  trans("Session Expired due to late payment."));
    						return Redirect::route('car_listing');
    					}
            }else {
              Session::flash('errorss','Payment Failed.');
              return Redirect::route('car_listing');
            }
        }else {
          Session::flash('errorss','Payment Failed.');
          return Redirect::route('car_listing');
        }
        Session::flash('errorss','Payment failed');

	      return Redirect::route('addPayment');
    } //end getPaymentStatus()
}
