<?php
namespace App\Http\Controllers;

use App\Http\Requests;
use Illuminate\Http\Request;
use App\Model\Payment;
use App\Model\Contract;
use App\Model\CarDetail;
use Exception;
use Str,Auth,Blade,Config,Cache,Cookie,DB,File,Hash,Input,Mail,Redirect,Response,Session,URL,View,Validator;
class PaypalPaymentController extends Controller
{

  /** @var bool Indicates if the sandbox endpoint is used. */
  private $use_sandbox = false;
  /** @var bool Indicates if the local certificates are used. */
  private $use_local_certs = true;
  /** Production Postback URL */
  const VERIFY_URI = 'https://ipnpb.paypal.com/cgi-bin/webscr';
  /** Sandbox Postback URL */
  const SANDBOX_VERIFY_URI = 'https://ipnpb.sandbox.paypal.com/cgi-bin/webscr';
  /** Response from PayPal indicating validation was successful */
  const VALID = 'VERIFIED';
  /** Response from PayPal indicating validation failed */
  const INVALID = 'INVALID';

    public function index()
    {
      return view('paypal/index');
    }

    /*
    * function to pay
    */
    public function pay(Request $request)
    {
      $formData = Input::all();

      // Check if paypal request or response
        if(!empty($formData)){
          //check matching contract found or not the amount & contract_id basis
          $contractData = Contract::where('contract_id', $formData['item_number'])->where('user_id', Auth::user()->id)->where('payment_status', INACTIVE)->where('contract_complete_status', INACTIVE)->where('contract_deposit_amount_paid', $formData['amount'])->first();
          if (!empty($contractData)) {
            // check the car is not to be sold or reserved
            $carData = CarDetail::where('id', $contractData->car_detail_id)->where('sold_status', INACTIVE)->first();
            if (!empty($carData)) {
              $paypal_email = PAYPAL_EMAIL;
              $item_name = isset($carData->engine_code) && $carData->engine_code ? $carData->engine_code : '';
              //Set variables for paypal form
                $returnURL = route("Paypal.success"); //payment success url
                $cancelURL = route("Paypal.cancel"); //payment cancel url
                $notifyURL = route("Paypal.ipn"); //ipn url

                $querystring = '';

              	// Firstly Append paypal account to querystring
              	$querystring .= "?business=".urlencode($paypal_email)."&";
              	$querystring .= "amount=".urlencode($formData['amount'])."&";

              	//loop for posted values and append to querystring
              	foreach($_POST as $key => $value){
              		$value = urlencode(stripslashes($value));
              		$querystring .= "$key=$value&";
              	}

              	// Append paypal return addresses
              	$querystring .= "return=".urlencode(stripslashes($returnURL))."&";
              	$querystring .= "cancel_return=".urlencode(stripslashes($cancelURL))."&";
              	$querystring .= "notify_url=".urlencode($notifyURL);

              	// Append querystring with custom field

              	// Redirect to paypal IPN
                if(PAYPAL_MODE == ZERO){
                	header('location:https://www.sandbox.paypal.com/cgi-bin/webscr'.$querystring);
                }else{
                  header('location:https://www.paypal.com/cgi-bin/webscr/'.$querystring);
                }
              	exit();
            }else{
        			Session::flash('errorss',  trans("Sorry, Car has been sold or reserved."));
        			return Redirect::route('car_listing');
        		}
          }else{
      			Session::flash('errorss',  trans("Sorry, No data found for car to be paid."));
      			return Redirect::route('car_listing');
      		}
        }
    }

    public function success(){
      return view('paypal/payment-successful');
    } // end success()

    public function cancel()
    {
      return view('paypal/payment-cancelled');
    }

    /**
     * Sets the IPN verification to sandbox mode (for use when testing,
     * should not be enabled in production).
     * @return void
     */
    public function useSandbox()
    {
        $this->use_sandbox = true;
    }
    /**
     * Sets curl to use php curl's built in certs (may be required in some
     * environments).
     * @return void
     */
    public function usePHPCerts()
    {
        $this->use_local_certs = false;
    }
    /**
     * Determine endpoint to post the verification data to.
     *
     * @return string
     */
    public function getPaypalUri()
    {
        if ($this->use_sandbox) {
            return self::SANDBOX_VERIFY_URI;
        } else {
            return self::VERIFY_URI;
        }
    }

    /**
     * Verification Function
     * Sends the incoming post data back to PayPal using the cURL library.
     *
     * @return bool
     * @throws Exception
     */
    public function ipn()
    {
      //pr($_REQUEST);die;
    $data = json_encode($_REQUEST);
      $myfile = fopen(app_path()."/ipn_text.php", "w") or die("Unable to open file!");
      $txt = date('Y-m-d H:i:s')."rahul123455566 \n";
      fwrite($myfile, $data);
      fclose($myfile);

        if ( ! count($_POST)) {
            throw new Exception("Missing POST Data");
        }
        $raw_post_data = file_get_contents('php://input');
        $raw_post_array = explode('&', $raw_post_data);
        $myPost = array();
        foreach ($raw_post_array as $keyval) {
            $keyval = explode('=', $keyval);
            if (count($keyval) == 2) {
                // Since we do not want the plus in the datetime string to be encoded to a space, we manually encode it.
                if ($keyval[0] === 'payment_date') {
                    if (substr_count($keyval[1], '+') === 1) {
                        $keyval[1] = str_replace('+', '%2B', $keyval[1]);
                    }
                }
                $myPost[$keyval[0]] = urldecode($keyval[1]);
            }
        }
        // Build the body of the verification post request, adding the _notify-validate command.
        $req = 'cmd=_notify-validate';
        $get_magic_quotes_exists = false;
        if (function_exists('get_magic_quotes_gpc')) {
            $get_magic_quotes_exists = true;
        }
        foreach ($myPost as $key => $value) {
            if ($get_magic_quotes_exists == true && get_magic_quotes_gpc() == 1) {
                $value = urlencode(stripslashes($value));
            } else {
                $value = urlencode($value);
            }
            $req .= "&$key=$value";
        }
        // Post the data back to PayPal, using curl. Throw exceptions if errors occur.
        $ch = curl_init($this->getPaypalUri());
        curl_setopt($ch, CURLOPT_HTTP_VERSION, CURL_HTTP_VERSION_1_1);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $req);
        curl_setopt($ch, CURLOPT_SSLVERSION, 6);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 1);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 2);
        // This is often required if the server is missing a global cert bundle, or is using an outdated one.
        if ($this->use_local_certs) {
            curl_setopt($ch, CURLOPT_CAINFO, __DIR__ . "/cert/cacert.pem");
        }
        curl_setopt($ch, CURLOPT_FORBID_REUSE, 1);
        curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 30);
        curl_setopt($ch, CURLOPT_HTTPHEADER, array(
            'User-Agent: PHP-IPN-Verification-Script',
            'Connection: Close',
        ));
        $res = curl_exec($ch);
        if ( ! ($res)) {
            $errno = curl_errno($ch);
            $errstr = curl_error($ch);
            curl_close($ch);
            throw new Exception("cURL error: [$errno] $errstr");
        }
        $info = curl_getinfo($ch);
        $http_code = $info['http_code'];
        if ($http_code != 200) {
            throw new Exception("PayPal responded with http code $http_code");
        }
        curl_close($ch);
        // Check if PayPal verifies the IPN data, and if so, return true.
        if ($res == self::VALID) {
            return true;
        } else {
            return false;
        }

      //return view('paypal/ipn');
    }



  function check_txnid($tnxid){
      return true;
      $valid_txnid = true;
      //get result set
      $result = Payment::where('txn_id', $tnxid)->first();
      if (!empty($result)) {
          $valid_txnid = false;
      }
      return $valid_txnid;
  }

  function check_price($price, $id){
      $valid_price = false;
      //you could use the below to check whether the correct price has been paid for the product

      $result = Contract::where('contract_id', $id)->first();
      if (!empty($result)) {
            $num = (float)$result['contract_deposit_amount_paid'];
            if($num == $price){
                $valid_price = true;
            }
      }
      return $valid_price;
      return true;
  }

  function updatePayments($data){

      if (is_array($data)) {
        if(!empty($data) && $data['st'] == "Completed"){
          $obj  = new Payment;
          $obj->contract_id = $data['item_number'];
          $obj->amount = $data['amt'];
          $obj->txn_id = $data['tx'];
          $obj->description = isset($data['item_name']) ? $data['item_name'] : '';
          $obj->currency_code = $data['cc'];
          $obj->payment_status = $data['st'];
          $obj->save();
        }
      }

  }
}
