<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Http\Response;
use Illuminate\Support\Facades\Input;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\DB;
use GuzzleHttp\Client;
use GuzzleHttp\Exception\RequestException;
use App\Helpers\Helpers;
use App\RegisterUser;
use App\PhonepeAccessToken;





class WebhookController extends Controller
{
  public function handleKyc(Request $request)
  {
    // Log::info('Received KYC for webhook:', $request->all());

    \Log::info("Received KYC for webhook: " . json_encode($request->all()));

    $data = $request->all();

    if (isset($data["serverCheckData"]) && $data['serverCheckData']['docType']  == "PAN") {

      $userExists = DB::table('pancard')->where('userid', $data['task_id'])->where('status', "0")->exists();
      $userData = DB::table("registerusers")->where("id", $data['task_id'])->first();

      if ($userExists) {

        $status = 0;
        if ($data['serverCheckData']['status'] == "SUCCESS") {
          $status = 1;
          DB::table("registerusers")->where("id", $data['task_id'])->update(["pan_verify" => "1"]);
        } else if ($data['serverCheckData']['status'] == "FAILURE" || $data['serverCheckData']['status'] == "REJECTED") {
          $status = 2;
          DB::table('registerusers')->where("id", $data['task_id'])->update(["pan_verify" => $status]);
        } else {
          DB::table('registerusers')->where('id', $data['task_id'])->update(['pan_verify' => '0']);
          $status = 0;
        }

        DB::table('pancard')->where('userid', $data['task_id'])->update(['pan_name' => $userData->username, 'pan_dob' => $userData->dob, 'status' => $status, 'idfy_webhook_response' => json_encode($request->all())]);
      }
    }

    if (isset($data["serverCheckData"]) && $data['serverCheckData']['docType']  == "UPI") {
      $userExists = DB::table('upi_verify')->where('user_id', $data['task_id'])->where('status', "0")->exists();
      if ($userExists) {
        if ($data['serverCheckData']['status'] == "SUCCESS") {
          $status = 1;
          DB::table("registerusers")->where("id", $data['task_id'])->update(["upi_verify" => $status]);
        } else if ($data['serverCheckData']['status'] == "FAILURE" || $data['serverCheckData']['status'] == "REJECTED") {
          $status = 2;
          DB::table('registerusers')->where("id", $data['task_id'])->update(["upi_verify" => $status]);
        } else {
          $status = 0;
          DB::table('registerusers')->where('id', $data['task_id'])->update(['upi_verify' => $status]);
        }
        DB::table('upi_verify')->where('user_id', $data['task_id'])->update(['status' => $status, 'idfy_webhook_response' => json_encode($request->all())]);
      }
    }

    if (isset($data["serverCheckData"]) && $data['serverCheckData']['docType']  == "BANK") {
      $userExists = DB::table('bank')->where('user_id', $data['task_id'])->where('status', "0")->exists();
      if ($userExists) {
        $status = 0;
        if ($data['serverCheckData']['status'] == "SUCCESS") {
          $status = 1;
          DB::table("registerusers")->where("id", $data['task_id'])->update(["bank_verify" => $status]);
        } else if ($data['serverCheckData']['status'] == "FAILURE" || $data['serverCheckData']['status'] == "REJECTED") {
          $status = 2;
          DB::table('registerusers')->where("id", $data['task_id'])->update(["bank_verify" => $status]);
        } else {
          $status = 0;
          DB::table('registerusers')->where('id', $data['task_id'])->update(['bank_verify' => $status]);
        }
        DB::table('bank')->where('user_id', $data['task_id'])->update(['status' => $status, 'idfy_bank_response' => json_encode($request->all())]);
      }
    }

    return response()->json(['status' => 'success', 'data' => $data]);
  }

  public function callback()
  {
    // $this->checkOrderStatus();
    return view("payment");
  }

  public function checkOrderStatus(Request $request)
  {

    $yesterday = \Carbon\Carbon::now()->subHours(24);

    if ($request->isMethod("POST")) {
      $data = $request->all();
      $authHeader = $request->header('Authorization');
      $check = hash('256', 'testuser:testpassword123');
      if($authHeader != $check) {
        return response()->json(['status' => 0, 'error' => 'Authorization token is invalid'], 401);
      }
      if (isset($data['event']) && isset($data['payload']) && isset($data['payload']['orderId'])) {
        $id = $data['payload']['orderId'];
        $transactions = DB::table("transactions")->where("phonepay_id", $id)->first();
        if(!$transactions) {
          return false;
        }
        if ($data['event'] == "checkout.order.completed") {
          $this->successOrder($transactions);
        } else if ($data['event'] == "checkout.order.failed") {
          DB::table('transactions')->where('id', $transactions->id)->update(['paymentstatus' => 'failed']);
        }
        return true;
      } else {
        $transactions = DB::table("transactions")->where("transaction_by", 'PHONEPE')->where("paymentstatus", "pending")->where("created_at", ">", $yesterday)->whereRaw("phonepay_id IS NOT NULL")->orderBy("created_at", "DESC")->get();
      }
    } else {
      $transactions = DB::table("transactions")->where("transaction_by", 'PHONEPE')->where("paymentstatus", "pending")->where("created_at", ">", $yesterday)->whereRaw("phonepay_id IS NOT NULL")->orderBy("created_at", "DESC")->get();
    }

    foreach ($transactions as $t) {

      $client = new Client();

      $prev = PhonepeAccessToken::first() ?? new PhonepeAccessToken();
        $threeMinutesLater = now()->addMinutes(3)->timestamp;

        if (!$prev->expires_at || $prev->expires_at <= $threeMinutesLater) {
          $tokenResponse = $client->post('https://api-preprod.phonepe.com/apis/pg-sandbox/v1/oauth/token', [
            'form_params' => [
              'client_id'      => env("PHONEPE_CLIENT_ID"),
              'client_version' => env("PHONEPE_CLIENT_VERSION"),
              'client_secret'  => env('PHONEPE_CLIENT_SECRET'),
              'grant_type'     =>  env('PHONEPE_GRANT_TYPE'),
            ],
          ]);
    
          
            $tokenBody = $tokenResponse->getBody()->getContents();
            $tokenData = json_decode($tokenBody, true);
            $accessToken = $tokenData['access_token'] ?? null;

        } else {
          $accessToken = $prev->access_token;
        }
        $orderId = $t->transaction_id;
        $orderResponse = $client->get('https://api-preprod.phonepe.com/apis/pg-sandbox/checkout/v2/order/' . $orderId . '/status', [
          'headers' => [
            'Content-Type'  => 'application/json',
            'Authorization' => 'O-Bearer ' . $accessToken,
            'X-MERCHANT-ID' => env("PHONEPE_MERCHANT_ID"),
          ]
        ]);
        if ($orderResponse->getStatusCode() === 200) {
          $body = $orderResponse->getBody()->getContents();
          $data = json_decode($body, true);

          if ($data['state'] == "COMPLETED" && isset($data['paymentDetails']) && $data['paymentDetails'][0]['state'] == "COMPLETED") {
            $this->successOrder($t);
          } else {
            DB::table('transactions')->where('id', $t->id)->update(['paymentstatus' => 'failed']);
          }
        } else {
        }
      
    }
    return true;
  }


  private function successOrder($t)
  {
    $orderId = $t->transaction_id;
    $paymentId = $t->phonepay_id;
    $orderAmount = $t->amount;
    $transaction_row = $t;

    if (!empty($transaction_row)) {
      $userBalance1 = DB::table('userbalances')->where('user_id', $transaction_row->userid)->first();
      if (empty($userBalance1)) {
        DB::table('userbalances')->insert(['user_id' => $transaction_row->userid]);
      }
      $userBalance1 = DB::table('userbalances')->where('user_id', $transaction_row->userid)->first();

      $updatetrans = array(
        'paymentstatus' => 'confirmed',
        'phonepay_id' => $paymentId,
        'bal_gst_bonus_amt' => $userBalance1->gst_bonus,
        'bal_bonus_amt' => $userBalance1->bonus,
        'bal_win_amt' => $userBalance1->winning,
        'bal_fund_amt' => $userBalance1->balance,
        'bal_affi_amt' => $userBalance1->affiliation_commission,
        'addfund_amt' => $transaction_row->amount,
        'total_available_amt' => $userBalance1->bonus + $userBalance1->gst_bonus + $userBalance1->winning + $userBalance1->balance + $userBalance1->affiliation_commission + $transaction_row->amount,
      );

      DB::table('transactions')->where('id', $transaction_row->id)->where('transaction_id', $orderId)->update($updatetrans);
      //TDS Calculation
      // $session_year = date("Y");
      $session_year = Helpers::getCurrentSessionYear();
      // if(date("Y-m-d H:i:s") > '2024-03-31 23:59:59')
      // {
      //   $session_year = "2024";
      // }
      $registerusers_session = DB::table("registerusers_session")
        ->where("user_id", $transaction_row->userid)
        ->where("session_year", $session_year)
        ->first();
      if (empty($registerusers_session)) {
        DB::table("registerusers_session")->insert([
          "session_year" => $session_year,
          "user_id" => $transaction_row->userid,
        ]);
        sleep(1);
        $registerusers_session = DB::table("registerusers_session")
          ->where("user_id", $transaction_row->userid)
          ->where("session_year", $session_year)
          ->first();
      }
      $amount = $orderAmount;
      $add_Fund     = round(($amount / 128) * 100, 2);
      $GSTAmount    = round($orderAmount - $add_Fund, 2);
      $gstamount =  $GSTAmount;

      DB::table("registerusers_session")
        ->where("id", $registerusers_session->id)
        ->update([
          "total_deposit" => $registerusers_session->total_deposit + $transaction_row->amount
        ]);

      $user_id = $getdata['userid'] = $transaction_row->userid;
      $add_Fund     = round(($amount / 128) * 100, 2);
      $userBalance = DB::table('userbalances')->where('user_id', $user_id)->first();
      $userdata = DB::table('registerusers')->where('id', $getdata['userid'])->first();
      $referid = $userdata->refer_id;
      $userBalanceReffred = DB::table('userbalances')->where('user_id', $referid)->first();
      $referdata = DB::table('registerusers')->where('id', $referid)->where('refer_to_join', 0)->first();
      /* Insert IN Bonus */
      $promo = DB::table('user_promo')->where('user_id', $user_id)->orderBy('id', 'DESC')->first();

      $bonusAmount = 0;
      $first_deposit = 0;
      $add_fund_count = 0;
      $promocode = "";

      //FEFER BONUS AMOUNT
      $is_code_exist = RegisterUser::where('id', $transaction_row->userid)->first();
      if (!empty($is_code_exist) && $is_code_exist->refer_to_join != 1) {
        if (1) {
          $refer_bal = DB::table('userbalances')->where('user_id', $is_code_exist->id)->first();
          $bns_amt['bonus'] = $refer_bal->bonus + 250;
          // DB::table('userbalances')->where('user_id', $is_code_exist->id)->update($bns_amt);
          // DB::table('registerusers')->where('id',$referid)->update(['refer_to_join'=>1]);
          $trans = DB::table('transactions');
          $ins_tran['userid'] = $is_code_exist->id;
          $ins_tran['refer_id'] = $transaction_row->userid;
          $ins_tran['transaction_id'] = "PlaynWin11" . '-Refer-' . time();
          $ins_tran['type'] = 'Refer Bonus';
          $ins_tran['transaction_by'] = "PlaynWin";
          $ins_tran['paymentstatus'] = 'confirmed';
          $ins_tran['total_available_amt'] = $refer_bal->winning + $refer_bal->balance + $refer_bal->bonus;
          $ins_tran['bal_bonus_amt'] = $refer_bal->bonus;
          $ins_tran['bonus_amt'] = 250;
          $ins_tran['amount'] = 250;
          //$trans->insert($ins_tran);
        }
      }

      $countFund = $trans = DB::table('transactions')->where('userid', $user_id)->where('paymentstatus', 'confirmed')->where('type', 'add fund')->count();
      if ($countFund == 1) {
        //  if($add_Fund>=1 && $add_Fund>=5000) {
        // if($amount>=1 && $amount>=5000) {
        //   $bonusAmount = 5000;
        // }
        if ($amount >= 1 && $amount >= 500) {
          $bonusAmount = 500;
        } elseif ($amount >= 1 && $amount < 500) {
          $bonusAmount = $transaction_row->amount;
        }
      }

      if ($bonusAmount != 0) {
        // find balance details //
        $finduser_bal = DB::table('userbalances')->where('user_id', $user_id)->first();
        if (!empty($finduser_bal)) {
          $new_total_available_amt = $finduser_bal->balance + $finduser_bal->winning + $finduser_bal->bonus + $finduser_bal->gst_bonus + $finduser_bal->affiliation_commission;
          $new_bal_fund_amt = $finduser_bal->balance;
          $new_bal_win_amt = $finduser_bal->winning;
          $new_bal_bonus_amt = $finduser_bal->bonus;
          $new_bal_gst_bonus_amt = $finduser_bal->gst_bonus;
          $new_bal_affi_amt = $finduser_bal->affiliation_commission;
          // $datainseert2['user_id'] = $user_id;
          // $datainseert2['refer_id']= $referid;
          // $datainseert['balance'] = $userBalance->balance+$amount;

          $datainseert2['bonus'] = $finduser_bal->bonus + $bonusAmount;

          // if($promocode != '' && ($promocode == 'GURUJI3' || $promocode == 'GURUJI2' || $promocode == 'GURUJI1' || strtolower($promocode) == 'ganesha' || @$offers->btype == 'deposit')){
          //   $datainseert2['balance'] = $finduser_bal->balance+$bonusAmount;
          // }else{
          //   $datainseert2['bonus'] = $finduser_bal->bonus+$bonusAmount;
          // }


          //if($getdata['paymentby']=='cashfree') {
          if ($first_deposit == 0) //for first deposit
          {
            DB::table('userbalances')->where('user_id', $user_id)->update($datainseert2);
          }
          //}
          $ntxnid = strtoupper("PlaynWin11") . 'BONUS-' . time();
          $newtransactionsdata['userid'] = $user_id;
          $newtransactionsdata['type'] = 'Bonus add during add fund';
          $newtransactionsdata['transaction_id'] = $ntxnid;
          $newtransactionsdata['transaction_by'] = 'PLAYNWIN11';
          $newtransactionsdata['amount'] = $bonusAmount;
          $newtransactionsdata['bonus_amt'] = $bonusAmount;
          $newtransactionsdata['paymentstatus'] = 'confirmed';
          $newtransactionsdata['bal_fund_amt'] = $new_bal_fund_amt;
          $newtransactionsdata['bal_win_amt'] = $new_bal_win_amt;
          $newtransactionsdata['bal_bonus_amt'] = $new_bal_bonus_amt + $bonusAmount;
          $newtransactionsdata['bal_gst_bonus_amt'] = $new_bal_gst_bonus_amt;
          $newtransactionsdata['bal_affi_amt'] = $new_bal_affi_amt;
          $newtransactionsdata['total_available_amt'] = $new_total_available_amt + $bonusAmount;
          //print_r($newtransactionsdata); exit;

          if ($first_deposit == 0) //for first deposit
          {
            DB::table('transactions')->insert($newtransactionsdata);
          }
        }
      }
      /* Bonus Credit */
      /* Insert IN Balance */
      if (!empty($userBalance)) {
        $userBalance = DB::table('userbalances')->where('user_id', $user_id)->first();
        $datainseert['user_id'] = $user_id;
        $datainseert['refer_id'] = $referid;
        $datainseert['balance'] = $userBalance->balance + $amount;
        // $datainseert['bonus'] = $userBalance->bonus+$bonusAmount;
        DB::table('userbalances')->where('user_id', $getdata['userid'])->update($datainseert);

        $findlastow = DB::table('userbalances')->where('user_id', $user_id)->first();

        $add_Fund     = round(($amount / 128) * 100, 2);
        $GSTAmount    = round($orderAmount - $add_Fund, 2);
        $gstamount = $GSTAmount;
        if (!empty($findlastow)) {
          $total_available_amt = $findlastow->balance + $findlastow->winning + $findlastow->bonus + $findlastow->gst_bonus + $findlastow->affiliation_commission - $gstamount;

          $bal_fund_amt = $findlastow->balance - $gstamount;
          $bal_win_amt = $findlastow->winning;
          $bal_gst_bonus_amt = $findlastow->gst_bonus;
          $bal_bonus_amt = $findlastow->bonus;
          $bal_affi_amt = $findlastow->affiliation_commission;
        }

        $transactionsdata['userid'] = $user_id;
        $transactionsdata['paymentstatus'] = 'confirmed';
        $transactionsdata['type'] = 'GST Deduction as per new government rule';
        $transactionsdata['transaction_id'] = 'PLAYNWIN11-GSTDEDUCT-' . rand(0000, 9999) . $user_id;
        $transactionsdata['transaction_by'] = 'wallet';
        $transactionsdata['amount'] = $gstamount;
        $transactionsdata['bal_fund_amt'] = $bal_fund_amt;
        $transactionsdata['bal_win_amt'] = $bal_win_amt;
        $transactionsdata['bal_bonus_amt'] = $bal_bonus_amt;
        $transactionsdata['bal_gst_bonus_amt'] = $bal_gst_bonus_amt;
        $transactionsdata['bal_affi_amt'] = $bal_affi_amt;
        $transactionsdata['cons_amount'] = $gstamount;
        $transactionsdata['total_available_amt'] = $total_available_amt;

        DB::table('transactions')->insert($transactionsdata);

        $datainseert['balance'] = $findlastow->balance - $gstamount;
        DB::table('userbalances')->where('user_id', $getdata['userid'])->update($datainseert);
        //GST Report
        $user_data = DB::table('registerusers')->where('id', $user_id)->first();
        $igst = 0;
        $cgst = 0;
        $sgst = 0;
        if (!empty($user_data) || strtolower($user_data->state) == 'Gujarat') {
          $igst = 0;
          $cgst = $gstamount;
          $sgst = $gstamount;
        } else {
          $igst = $gstamount;
          $cgst = 0;
          $sgst = 0;
        }
        $GST_entry = array(
          //"league_tran_id"=>$user_id.rand(11,999),
          "user_id" => $user_id,
          "deposit_amount" => $amount,
          "gst_amount" => $gstamount,
          "wallet_amount" => $amount,
          "order_id" => $paymentId,
          "transaction_id" => $transaction_row->id,
          //"transaction_id"=>$user_id.time().rand(11,99),
          // "state"=> $user_data->state,
          "igst" => $igst,
          "cgst" => $cgst,
          "sgst" =>  $sgst,
          "transaction_by" => 'PHONEPAY',
          "ip" => @$transaction_row->ip,
          "transactions_date" => date('Y-m-d H:i:s'),
          "state" => @$transaction_row->state,
        );
        DB::table('deposit_gst')->insert($GST_entry);

        //GST Rebat
        $findlastow = DB::table('userbalances')->where('user_id', $user_id)->first();
        if (!empty($findlastow)) {
          $total_available_amt = $findlastow->balance + $findlastow->winning + $findlastow->bonus + $findlastow->gst_bonus + $findlastow->affiliation_commission + $gstamount;
          $bal_fund_amt = $findlastow->balance + $gstamount;
          $bal_win_amt = $findlastow->winning;
          $bal_gst_bonus_amt = $findlastow->gst_bonus;
          $bal_bonus_amt = $findlastow->bonus;
          $bal_affi_amt = $findlastow->affiliation_commission;
        }

        //$datainseert['balance'] = $findlastow->balance+$gstamount;
        $datainseert['gst_bonus'] = $findlastow->gst_bonus;
        DB::table('userbalances')->where('user_id', $getdata['userid'])->update($datainseert);
      }


      //Offer Promo code//

      if (!empty($promo) && @$promo->status == 0) {
        $promocode = $promo->promo_code;

        $offerAmount = 0;
        $bonustype = "";
        if ($promocode != "") {
          // $offers= DB::table('offers')
          //   ->where('code',$promocode)
          //   ->where('minamount','<=', $amount)
          //   ->where('maxamount','>=', $amount)
          //   ->where('expire_date','>=', date('Y-m-d H:i:s'))
          //   ->where('status', 1)
          //   ->first();

          $offers = DB::table('offers')
            ->leftjoin('offer_csv_users', 'offers.id', '=', 'offer_csv_users.offer_id')
            ->where('offers.code', $promocode)
            ->where('offers.minamount', '<=', $amount)
            ->where('offers.maxamount', '>=', $amount)
            ->where('offers.status', 1)
            ->where('offers.expire_date', '>=', date('Y-m-d H:i:s'))
            ->where(function ($query) use ($user_id) {
              $query->where(function ($q) use ($user_id) {
                $q->where('offers.is_for_all', 0)
                  ->where('offer_csv_users.user_id', $user_id);
              })
                ->orWhere('offers.is_for_all', 1);
            })
            ->first();


          //check first deposit
          if (!empty($offers->first_deposit) && @$offers->first_deposit == 1) {
            $user_first_deposit_check = DB::table('transactions')->where('userid', $user_id)->where('type', 'add fund')->where('paymentstatus', 'confirmed')->get();

            $add_fund_count = $user_first_deposit_check->count();
            if ($add_fund_count > 1) {
              $first_deposit = 1;
            }
          }
          // foreach($offers as $o){
          $used = DB::table('user_promo')->where('promo_code', $promocode)->where('user_id', $user_id)->where('status', 1)->count();

          if (!empty($offers) && $offers->per_user_count <= $used) {

            $bonusAmount1 = $offers->bonus;
            $bonus_type = $offers->bonus_type;
            if ($bonus_type == 'rs') {

              $offerAmount = $bonusAmount1;
            } else {
              $offerAmount = (($amount * $bonusAmount1) / 100);
            }
            if ($offers->btype == 'deposit') {
              $bonustype = 'Amount';
            } else {
              $bonustype = 'Bonus';
            }

            if ($offerAmount) {
              $usedoffer['offer_id'] = $promocode;
              $usedoffer['user_id'] = $user_id;
              DB::table('usedoffers')->insert($usedoffer);
              DB::table('user_promo')->where('id', $promo->id)->update(array("status" => 1, 'amount' => $offerAmount, 'bonustype' => $bonustype));
            }
          }
        }


        if ($offerAmount != 0) {
          // find balance details //
          $finduser_bal = DB::table('userbalances')->where('user_id', $user_id)->first();
          if (!empty($finduser_bal)) {
            $new_total_available_amt = $finduser_bal->balance + $finduser_bal->winning + $finduser_bal->bonus + $finduser_bal->gst_bonus + $finduser_bal->affiliation_commission;
            $new_bal_fund_amt = $finduser_bal->balance;
            $new_bal_win_amt = $finduser_bal->winning;
            $new_bal_bonus_amt = $finduser_bal->bonus;
            $new_bal_gst_bonus_amt = $finduser_bal->gst_bonus;
            $new_bal_affi_amt = $finduser_bal->affiliation_commission;

            $bonusAmount_balance = 0;
            $bonusAmount_winning = 0;
            $bonusAmount_bonus = 0;
            $bonusAmount_gst_bonus = 0;
            $bonusAmount_affiliation_commission = 0;



            if ($offers->btype == 'balance' || $offers->btype == 'deposit') {
              $datainseert2['balance'] = $finduser_bal->balance + $offerAmount;
              $bonusAmount_balance = $offerAmount;
            } elseif ($offers->btype == 'winning') {
              $datainseert2['winning'] = $finduser_bal->winning + $offerAmount;
              $bonusAmount_winning = $offerAmount;
            } elseif ($offers->btype == 'bonus') {
              $datainseert2['bonus'] = $finduser_bal->bonus + $offerAmount;
              $bonusAmount_bonus = $offerAmount;
            } elseif ($offers->btype == 'gst_bonus') {
              $datainseert2['gst_bonus'] = $finduser_bal->gst_bonus + $offerAmount;
              $bonusAmount_gst_bonus = $offerAmount;
            } elseif ($offers->btype == 'affiliation_commission') {
              $datainseert2['affiliation_commission'] = $finduser_bal->affiliation_commission + $offerAmount;
              $bonusAmount_affiliation_commission = $offerAmount;
            } else {
              $datainseert2['bonus'] = $finduser_bal->bonus + $offerAmount;
              $bonusAmount_bonus = $offerAmount;
            }

            if ($first_deposit == 0) //for first deposit
            {
              DB::table('userbalances')->where('user_id', $user_id)->update($datainseert2);
            }
            //}
            $ntxnid = strtoupper("PlaynWin11") . 'OFFERBONUS-' . time();
            $newtransactionsdata['userid'] = $user_id;
            $newtransactionsdata['type'] = 'Offer Bonus add during add fund';
            $newtransactionsdata['transaction_id'] = $ntxnid;
            $newtransactionsdata['transaction_by'] = 'PLAYNWIN11';
            $newtransactionsdata['amount'] = $offerAmount;
            $newtransactionsdata['bonus_amt'] = $offerAmount;
            $newtransactionsdata['paymentstatus'] = 'confirmed';
            $newtransactionsdata['bal_fund_amt'] = $new_bal_fund_amt + $bonusAmount_balance;
            $newtransactionsdata['bal_win_amt'] = $new_bal_win_amt + $bonusAmount_winning;
            $newtransactionsdata['bal_bonus_amt'] = $new_bal_bonus_amt + $bonusAmount_bonus;
            $newtransactionsdata['bal_gst_bonus_amt'] = $new_bal_gst_bonus_amt + $bonusAmount_gst_bonus;
            $newtransactionsdata['bal_affi_amt'] = $new_bal_affi_amt + $bonusAmount_affiliation_commission;
            $newtransactionsdata['total_available_amt'] = $new_total_available_amt + $offerAmount;

            if ($first_deposit == 0) //for first deposit
            {
              DB::table('transactions')->insert($newtransactionsdata);
            }
          }
        }
      }
      $transactionsgstrebat['userid'] = $user_id;
      $transactionsgstrebat['paymentstatus'] = 'confirmed';
      $transactionsgstrebat['type'] = 'Real Cash Bonus from PLAYNWIN11';
      $transactionsgstrebat['transaction_id'] = 'PLAYNWIN11-RCBONUS-' . rand(0000, 9999) . $user_id;
      $transactionsgstrebat['transaction_by'] = 'PLAYNWIN11';
      $transactionsgstrebat['amount'] = $gstamount;
      $transactionsgstrebat['bal_win_amt'] = $bal_win_amt;
      $transactionsgstrebat['bal_bonus_amt'] = $bal_bonus_amt;
      $transactionsgstrebat['bal_fund_amt'] = $bal_fund_amt;
      $transactionsgstrebat['bal_gst_bonus_amt'] = $bal_gst_bonus_amt;
      $transactionsgstrebat['bal_affi_amt'] = $bal_affi_amt;
      $transactionsgstrebat['addfund_amt'] = $gstamount;
      // $transactionsgstrebat['gst_bonus_amt'] = $gstamount;
      $transactionsgstrebat['total_available_amt'] = $total_available_amt;
      DB::table('transactions')->insert($transactionsgstrebat);

      //$datainseert['balance'] = $findlastow->balance+$gstamount;
      $datainseert['bonus'] = $findlastow->bonus + $gstamount;
      DB::table('userbalances')->where('user_id', $getdata['userid'])->update($datainseert);

      return true;
    } else {
      return false;
    }
  }

  public function phonepe_cron()
  {

    $order_id = "";
    if (isset($_GET['order_id']) && !empty($_GET['order_id'])) {
      $order_id = $_GET['order_id'];
    }
    if (!empty($order_id)) {
      $transactions = DB::table('transactions')
        ->where('transaction_id', $order_id)
        ->where('type', 'Add Fund')
        ->where('transaction_by', 'PHONEPAY')
        ->where('paymentstatus', 'pending')
        ->orderBY('id', 'DESC')
        ->get();
    } else {
      $transactions = DB::table('transactions')
        ->where('type', 'Add Fund')
        ->where('transaction_by', 'PHONEPAY')
        ->where('paymentstatus', 'pending')
        ->where('created_at', '<=', date('Y-m-d H:i:s', strtotime("-30 Min")))
        ->orderBY('id', 'ASC')->limit(10)->get();
    }
    //echo '<pre>';
    //print_r($transactions);die;
    $salt_index = 1;
    $salt_key = "949c8603-4d8b-4323-a335-eb1a90f20af0";
    if (count($transactions) > 0) {
      foreach ($transactions as $key => $row) {
        $transaction_id = $row->transaction_id;
        $merchant_id = 'PlaynWin11ONLINE';
        $checksum = hash('sha256', '/pg/v1/status/' . $merchant_id . '/' . $transaction_id . $salt_key);
        $xVerify = $checksum . '###' . $salt_index;
        //echo $xVerify;die;
        $curl = curl_init();
        curl_setopt_array($curl, [
          CURLOPT_URL => "https://api.phonepe.com/apis/hermes/pg/v1/status/" . $merchant_id . "/" . $transaction_id,
          CURLOPT_RETURNTRANSFER => true,
          CURLOPT_ENCODING => "",
          CURLOPT_MAXREDIRS => 10,
          CURLOPT_TIMEOUT => 30,
          CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
          CURLOPT_CUSTOMREQUEST => "GET",
          CURLOPT_HTTPHEADER => [
            "Content-Type: application/json",
            "X-MERCHANT-ID:" . $merchant_id,
            "X-VERIFY:" . $xVerify,
            "accept: application/json"
          ],
        ]);

        $response = curl_exec($curl);

        $err = curl_error($curl);

        curl_close($curl);

        if ($err) {
          return $row->id . " cURL Error #:" . $err . '<br>';
        } else {
          $phonepe_response = json_decode($response, true);
          print_r($phonepe_response);
          die;
          $success = $phonepe_response['success'];
          $status = $phonepe_response['code'];
          if ($success == true && $status == 'PAYMENT_SUCCESS') {
            //$this->update_transaction_status($row->id, 'SUCCESS', $phonepe_response);
            return 'success' . $row->id . '<br>';
          } else {
            //  $this->update_transaction_status($row->id, 'FAIL', $phonepe_response);
            return 'fail' . $row->id . '<br>';
          }
        }

        sleep(1);
      }
    } else {
      return 'No Pending Transactions Found!';
    }
    return true;
  }


  public function phonepe_notify($return_transaction_id, Request $request)
  {
    //echo 'hi';die;
    //\Log::info("phonepe_notify : ".json_encode($request->all())); //die;
    $post = $request->all();
    $phonepe_response = json_decode(base64_decode($post['response']), true);
    //code
    $success = $phonepe_response['success'];
    $status = $phonepe_response['code'];
    $message = $phonepe_response['message'];
    $response_data = $phonepe_response['data'];

    $orderAmount = $response_data['amount'] / 100;
    $transaction_id = $response_data['merchantTransactionId'];
    $phone_pe_transaction_id = $response_data['transactionId'];
    $transaction_row = DB::table('transactions')->where('transaction_id', $transaction_id)->where('paymentstatus', 'pending')->first();
    if (!empty($transaction_row) && $transaction_row->transaction_id == $return_transaction_id && $transaction_row->paid_amount == $orderAmount) {
      if ($success == true && $status == 'PAYMENT_SUCCESS') {
        $this->update_transaction_status($transaction_row->id, 'SUCCESS', $phonepe_response);
      } else {
        $this->update_transaction_status($transaction_row->id, 'FAIL', $phonepe_response);
      }
    }
    die;
  }
}
