<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Support\Facades\Session;

class AuthMain
{
    /**
     * Run the request filter.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @return mixed
     */
    public function handle($request, Closure $next){

        if (Auth::guard('youtober')->check()) {
            return $next($request);
        }elseif (Auth::guest()){
            if(Auth::user()->user_type==SUPER_ADMIN){
                return $next($request);
            }else if(Auth::user()->user_type==SUB_ADMIN){
                return $next($request);
            }else{
                Session::flash('error', trans("user not found!"));
			    return Redirect::route('Admin.login');
            }
		}else{
			return $next($request);
		}
    }
}
