<?php

namespace App\Http\Middleware;

use Closure;
Use Auth;
Use Redirect;

class ServiceProvider 
{
    /**
     * Run the request filter.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @return mixed
     */
    public function handle($request, Closure $next)
    {
		if (Auth::guest())
		{
			return Redirect::to('/');
		}else{
            if (Auth::check() && Auth::user()->user_role_id == SERVICE_PROVIDER) {
                return $next($request);
            }else{
                return Redirect::to('/');
            }
        }        
    }
}
