<?php
namespace App\Services;

use Illuminate\Support\Facades\Request;
class Input
{

    public static function all()
    {
        return Request::all(); // Access the current request data
    }

    public static function get($key, $default = null)
    {
        return Request::input($key, $default); // Get a specific input value
    }

    public static function only(array $keys)
    {
        return Request::only($keys); // Get specific input values
    }

    public static function except($keys)
    {
        return Request::except($keys); // Get all except specific input values
    }

    public static function hasFile($key)
    {
        return Request::hasFile($key); // Check if the request contains a file
    }

    // Retrieve an uploaded file
    public static function file($key)
    {
        return Request::file($key); // Retrieve the uploaded file
    }
}

