<?php
//use Illuminate\Support\Facades\Config;
//use Illuminate\Database\Capsule\Manager as DB;
return [

    /*
    |--------------------------------------------------------------------------
    | Third Party Services
    |--------------------------------------------------------------------------
    |
    | This file is for storing the credentials for third party services such
    | as Stripe, Mailgun, SparkPost and others. This file provides a sane
    | default location for this type of information, allowing packages
    | to have a conventional place to find your various credentials.
    |
    */

    'mailgun' => [
        'domain' => env('MAILGUN_DOMAIN'),
        'secret' => env('MAILGUN_SECRET'),
    ],

    'ses' => [
        'key' => env('SES_KEY'),
        'secret' => env('SES_SECRET'),
        'region' => 'us-east-1',
    ],

    'sparkpost' => [
        'secret' => env('SPARKPOST_SECRET'),
    ],

    'stripe' => [
        'model' => App\User::class,
        'key' => Config('Payment.stripe_key_id'),
        'secret' => Config('Payment.stripe_secret_id'),
    ],

    'facebook' => [
      'client_id' => Config('Social.fb_app_id'),
      'client_secret' => Config('Social.fb_secret_id'),
      'redirect' => env ( 'FB_REDIRECT' )
    ],

    'google' => [
        'client_id' => Config('Social.google_app_id'),
        'client_secret' => Config('Social.google_secret_id'),
        'redirect' => env ( 'GOOGLE_REDIRECT' )
    ],

];
