

$(document).ready(function(){
		/**
		* function for get state list according to country
		* */
		$("#country").change(function(){
			var country_id =  $("#country").val();
			
			$.ajax({
				url: getStateUrl,
				data: {'country_id' : country_id},
				type: "post",
				headers: {
					'X-CSRF-TOKEN': csrf_token
				},
				dataType: "json",
				beforeSend:function(){
					$("#overlay").show();
				},
				success: function(data){
					
					$("#overlay").hide();
					$('#state').empty();
					$('#state').append('<option value=""> Please Select State </option>');
					$.each(data, function(key, value) {
						$('#state').append('<option value="'+ key +'">'+ value +'</option>');
					});
					$('#city').empty();
					
					$('#city').append('<option value=""> Please Select City </option>');
				}
			});	
		});
	
		/**
		* function for get city list according to country
		* */
		$("#state").change(function(){
			var country_id 	=  $("#country").val();
			var state_id 	=	$("#state").val();
			$.ajax({
				url: getCityUrl,
				data: {'country_id' : country_id, 'state_id':state_id },
				type: "post",
				headers: {
					'X-CSRF-TOKEN': csrf_token
				},
				dataType: "json",
				beforeSend:function(){
					$("#overlay").show();
				},
				success: function(data){
					$("#overlay").hide();
					$('#city').empty();
					$('#city').append('<option value=""> Please Select City </option>');
					$.each(data, function(key, value) {
						$('#city').append('<option value="'+ key +'">'+ value +'</option>');
					});
				}
			});	
		});
	});
	
