@extends('admin.layouts.default')
@section('content')
 <!-- DATATABLE GLOBAL SCRIPTS -->
 <link rel="stylesheet" href="{{asset('assets/css/admin/datatable.css')}}" />
 <script src="{{asset('assets/js/admin/datatable.js')}}"></script>
<!-- DATATABLE GLOBAL SCRIPTS -->
<script>
	$(document).ready(function(){
		$('[data-toggle="tooltip"]').tooltip();
	});
</script>

<div class="portlet box green">
	<div class="portlet-title">
		<div class="caption">
			<i class="fa fa-money"></i>{{trans("Admin Earning Report")}}
		</div>
	</div>

	<div class="portlet-body table-responsive">
		<table class="table table-striped table-bordered table-hover" id="dataList">
			<thead>
				<tr>
					<th>{{ trans('messages.global.id') }}</th>
					<th> Txn Id </th>
					<th> Amount </th>
					<th> Currency Code </th>
					<th> Payment Status </th>
				</tr>
			</thead>
		</table>
	</div>
</div>
<!-- END EXAMPLE TABLE PORTLET-->
<script type="text/javascript">
$(document).ready(function() {
    $('#dataList').DataTable({
    	order: [0, 'desc'],
        "processing": true,
        "serverSide": true,
        "ajax":{
        	url:"{{route($modelName.'.index')}}",
        	type: "POST",
        },
        "columns": [
            {data: 'id', name: 'id'},
            {data: 'txn_id', name: 'txn_id'},
            {data: 'amount', name: 'amount'},
            {data: 'currency_code', name: 'currency_code'},
            {data: 'payment_status', name: 'payment_status', orderable: false, searchable: false},
        ]
    });
});
</script>
@endsection
