@extends('admin.layouts.default')
@section('content')
    <script type="text/javascript">
        $(document).ready(function() {
            $('[data-toggle="tooltip"]').tooltip();
        });
    </script>

    <!--********************************** Content body start  ***********************************-->
    <div class="container-fluid">
        <div class="row page-titles mx-0" data-aos="fade-up">
            <div class="col-sm-6 p-md-0">
                <!-- <div class="welcome-text">
                        <h4>Add Offers</h4>
                        <span class="ml-1">Layout</span>
                    </div> -->
            </div>

            <div class="col-sm-6 p-md-0 justify-content-sm-end mt-2 mt-sm-0 d-flex">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item active"><a href="{{ route($modelName . '.viewOffers') }}">View all offers</a>
                    </li>
                    <li class="breadcrumb-item">Add</li>
                </ol>
            </div>
        </div>
        <!-- row -->
        <div class="row">
            <div class="col-xl-12 col-xxl-12">
                <div class="card" data-aos="fade-up">
                    <div class="card-header">
                        <h4 class="card-title">Add New Offer</h4>
                    </div>
                    <div class="card-body">
                        <div class="basic-form">
                            <form id="offersAddForm" action="{{ route($modelName . '.addOffers') }}" method="POST"
                                enctype="multipart/form-data">
                                @csrf
                                <div class="form-row">
                                    <div class="form-group col-md-6">
                                        <label class="lbl_frm py-2">Minimum Amount</label>
                                        <input id="minamount" type="text" placeholder="Enter minimum amount here"
                                            name="minamount" class="form-control in_text" value="">
                                        <!-- <div class="error-message help-inline row col-md-6 px-0"> -->
                                        @if ($message = session()->get('success'))
                                            <div class="error-message help-inline">
                                                {{ $message }}
                                            </div>
                                        @endif
                                        <!-- </div> -->
                                    </div>
                                    <div class="form-group col-md-6">
                                        <label class="lbl_frm py-2">Maximum Amount</label>
                                        <input id="maxamount" type="text" placeholder="Enter maximum amount here"
                                            name="maxamount" class="form-control in_text" value="">
                                        <div class="error-message help-inline row col-md-6 px-0">
                                            <?php echo $errors->first('maxamount'); ?>
                                        </div>
                                    </div>
                                    <div class="form-group col-md-6">
                                        <label class="lbl_frm py-2">Bonus</label>
                                        <input class="form-control in_text" autocomplete="off"
                                            placeholder="Enter bonus here" id="bonus" name="bonus" type="text"
                                            value="">
                                        <!-- <div class="error-message help-inline row col-md-6 px-0"> -->
                                        @if ($message = session()->get('successs'))
                                            <div class="error-message help-inline">
                                                {{ $message }}
                                            </div>
                                        @endif
                                        <!-- </div> -->
                                    </div>
                                </div>
                                <div class="form-row">
                                    <div class="form-group col-md-6">
                                        <fieldset class="form-group">
                                            <div class="row mx-0">
                                                <label class="lbl_frm py-2">Bonus Type</label>
                                                <div class="col-sm-9 px-0">
                                                    <div class="form-check frm_chk py-2">
                                                        <input class="form-check-input" type="radio" name="bonus_type"
                                                            id="bonus_type" value="per">
                                                        <label class="form-check-label">
                                                            Percentage
                                                        </label>
                                                    </div>
                                                    <div class="form-check frm_chk py-2">
                                                        <input class="form-check-input" type="radio" name="bonus_type"
                                                            id="bonus_type" value="rs">
                                                        <label class="form-check-label">
                                                            Rupees
                                                        </label>
                                                    </div>
                                                    <div class="error-message help-inline px-0">
                                                        <?php echo $errors->first('bonus_type'); ?>
                                                    </div>
                                                </div>
                                            </div>
                                        </fieldset>
                                    </div>
                                    <div class="form-group col-md-6">
                                        <label class="lbl_frm py-2">Promo Code</label>
                                        <input class="form-control in_text" autocomplete="off"
                                            placeholder="Enter promo code here" id="code" name="code" type="text"
                                            value="">
                                        <div class="error-message help-inline row col-md-6 px-0">
                                            <?php echo $errors->first('code'); ?>
                                        </div>
                                    </div>
                                </div>

                                <div class="form-row">
                                    <div class="form-group col-md-6">
                                        <fieldset class="form-group">
                                            <div class="row mx-0">
                                                <label class="lbl_frm py-2">Bonus Credit wallet</label>
                                                <div class="col-sm-9 px-0">
                                                    <div class="form-check frm_chk py-2">
                                                        <input class="form-check-input" type="radio" name="btype"
                                                            id="" value="deposit">
                                                        <label class="form-check-label">
                                                            Deposit
                                                        </label>
                                                    </div>
                                                    <div class="form-check frm_chk py-2">
                                                        <input class="form-check-input" type="radio" name="btype"
                                                            id="btype" value="bonus">
                                                        <label class="form-check-label">
                                                            Bonus
                                                        </label>
                                                    </div>
                                                    <div class="error-message help-inline px-0">
                                                        <?php echo $errors->first('bonus_type'); ?>
                                                    </div>
                                                </div>
                                            </div>
                                        </fieldset>
                                    </div>
                                </div>

                                <div class="form-row">
                                    <div class="form-group col-md-6">
                                        <label class="lbl_frm py-2">Expire Date</label>
                                        <input class="form-control datetimepickerget in_text" autocomplete="off"
                                            placeholder="Enter expire date here" id="expire_date" name="expire_date"
                                            type="text" value="">
                                        <div class="error-message help-inline row col-md-6 px-0">
                                            <?php echo $errors->first('expire_date'); ?>
                                        </div>
                                    </div>
                                    <div class="form-group col-md-6">
                                        <label class="lbl_frm py-2">Description</label>
                                        <input class="form-control in_text" autocomplete="off"
                                            placeholder="Enter description here" id="description" name="description"
                                            type="text" value="">
                                        <div class="error-message help-inline row col-md-6 px-0">
                                            <?php echo $errors->first('description'); ?>
                                        </div>
                                    </div>
                                </div>
                                <div class="form-row">
                                    <div class="form-group col-md-6">
                                        <label class="lbl_frm py-2">First Deposit</label>
                                        <div form-check frm_chk py-2>
                                            <input class="form-check-input" value="1" type="checkbox"
                                                name="first_deposit" id="first_deposit">
                                        </div>
                                    </div>
                                </div>
                                <div class="py-2">
                                    <button type="submit" class="btn btn-primary mr-2">Submit</button>
                                    <button class="btn btn-gray" type="button" id="cancel_btn">Cancel</button>
                                </div>
                        </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!--**********************************
        Content body end
            ***********************************-->

    <script type="text/javascript">
        $(document).ready(function() {
            $(document).on("click", "#cancel_btn", function() {
                let href = $(".breadcrumb-item.active a").attr("href");
                window.location = href;
            });
        });
    </script>
@endsection
