@extends('admin.layouts.default')
@section('content')
<!-- DATATABLE GLOBAL SCRIPTS -->
<link rel="stylesheet" href="{{asset('assets/css/admin/datatable.css')}}" />
<script src="{{asset('assets/js/admin/datatable.js')}}"></script>
<!-- DATATABLE GLOBAL SCRIPTS -->
<script>
  $(document).ready(function(){
    $('[data-toggle="tooltip"]').tooltip();
  });
</script>
<style type="text/css">
  /* Chrome, Safari, Edge, Opera */
input::-webkit-outer-spin-button,
input::-webkit-inner-spin-button {
  -webkit-appearance: none;
  margin: 0;
}

/* Firefox */
input[type=number] {
  -moz-appearance:textfield;
}

input[type=number] {
  display: inline-block;
}
.rangeUpdate {
  display: block;
}

</style>

<div class="alert" id="bsalert">
  <a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a>
  <div class="alert-msg"></div>
</div>


<div class="container-fluid">
    <div class="row page-titles mx-0" data-aos="fade-up">
        <div class="col-sm-6 p-md-0">
            <!-- <div class="welcome-text">
                <h4>Bonus list</h4>
            </div> -->
        </div>
        <div class="col-sm-6 p-md-0 justify-content-sm-end mt-2 mt-sm-0 d-flex">
            <!-- <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="javascript:void(0)">Datatable</a></li>
                <li class="breadcrumb-item active"><a href="javascript:void(0)">bonus</a></li>
            </ol> -->
        </div>
    </div>
    <div class="row">
      <div class="col-12">
          <div class="card" data-aos="fade-up">
             <div class="card-header">
              <h4>Scratch Card Manage</h4>
                <!-- <a href="{{route('Advertisments.add')}}" class="btn btn-primary btn-sm"> Add New {{$modelName}}</a> -->
              </div>
              <div class="card-body">
                  <div class="table-responsive">
                      <table id="dataList" class="display" style="min-width: 845px">
                          <thead>
                              <tr>
                              <th>S No.</th>
                              <th>Name</th>
                              <th>status</th>
                              <th>Range Value</th>
                          </tr>
                          </thead>
                          <tfoot>
                              <tr>
                              <th>S No.</th>
                              <th>Name</th>
                              <th>status</th>
                              <th>Range Value</th>
                          </tr>
                          </tfoot>
                      </table>
                  </div>
              </div>
          </div>
        </div>
    </div>
</div>
<script type="text/javascript">
$(document).ready(function() {
    $("#bsalert").hide();

    $('#dataList').DataTable({
      order: [0, 'desc'],
        "processing": true,
        "serverSide": true,
        "ajax":{
          url:"{{route($modelName.'.scratchManage')}}",
          type: "POST",
          data : {"_token": "{{ csrf_token() }}"}
        },
        "columns": [
            {data: 'DT_RowIndex', name: 'DT_RowIndex'},
            {data: 'name', name: 'name'},
            {data: 'value', name: 'value'},
            {data: 'range', name: 'range'},
        ]
    });

    $(document).on('click', '.rangeUpdate', function(event){
        event.preventDefault();
        var min = $(this).closest("form").find("input[name='min']").val();
        var max = $(this).closest("form").find("input[name='max']").val();
        var id = $(this).closest("form").find("input[name='id']").val();
        var data = {"_token": "{{ csrf_token() }}", "min": min, "max": max, "id": id};
        $.ajax({
            url: "{{route($modelName.'.scratchRangeUpdate')}}",
            type: "post",
            data: data,
            success: function(result){
                res = JSON.parse(result);
                if(res.status == 200){
                  $(document).find("#bsalert .alert-msg").text(res.message);
                  $(document).find("#bsalert").addClass("alert-success");
                  $(document).find("#bsalert").show();
                  setTimeout(function(){ $(document).find("#bsalert").hide(); }, 3000);
                }
            },
            error: function(error){
                $(document).find("#bsalert .alert-msg").text("Something went wrong!");
                $(document).find("#bsalert").addClass("alert-warning");
                $(document).find("#bsalert").show();
                setTimeout(function(){ $(document).find("#bsalert").hide(); }, 5000);
            }
        });
    });

    $(document).on('click', '.updateStatus', function(event){
        event.preventDefault();
        if(!confirm("Are you sure want to update status?")){
            return false;
        }
        else{
            var id = $(this).data("id");
            var status = $(this).data("status");
            var data = {"_token": "{{ csrf_token() }}", "status": status, "id": id};
            $.ajax({
                url: "{{route($modelName.'.scratchUpdateStatus')}}",
                type: "post",
                data: data,
                success: function(result){
                    res = JSON.parse(result);
                    if(res.status == 200){
                      $(document).find("#bsalert .alert-msg").text(res.message);
                      $(document).find("#bsalert").addClass("alert-info");
                      $(document).find("#bsalert").show();
                      setTimeout(function(){ $(document).find("#bsalert").hide(); window.location.reload(); }, 1000);
                    }
                },
                error: function(error){
                    $(document).find("#bsalert .alert-msg").text("Something went wrong!");
                    $(document).find("#bsalert").addClass("alert-warning");
                    $(document).find("#bsalert").show();
                    setTimeout(function(){ $(document).find("#bsalert").hide(); }, 5000);
                }
            });
        }

    });

});

/*function toggleAlert(){
    $(".alert").toggleClass('in out');
    return false;
}

$("#btn").on("click", toggleAlert);
$('#bsalert').on('close.bs.alert', toggleAlert)*/
</script>
@endsection
