@extends('admin.layouts.default')
@section('content')
    <!-- DATATABLE GLOBAL SCRIPTS -->
    <link rel="stylesheet" href="{{ asset('assets/css/admin/datatable.css') }}" />
    <script src="{{ asset('assets/js/admin/datatable.js') }}"></script>
    <!-- DATATABLE GLOBAL SCRIPTS -->
    <script>
        $(document).ready(function() {
            $('[data-toggle="tooltip"]').tooltip();
        });
    </script>
    <?php
    date_default_timezone_set('Asia/Kolkata'); ?>

    <div class="container-fluid">
        <div class="row page-titles mx-0" data-aos="fade-up">
            <div class="col-sm-6 p-md-0">
                <!-- <div class="welcome-text">
                    <h4>Paytm Withdraw Requests</h4>
                </div> -->
            </div>
            <div class="col-sm-6 p-md-0 justify-content-sm-end mt-2 mt-sm-0 d-flex">
                <!-- <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="javascript:void(0)">Paytm Withdraw Requests</a></li>
                </ol> -->
            </div>
        </div>
        <div class="row">
            <div class="col-12">
                <div class="card" data-aos="fade-up">
                    <div class="card-header">
                        <div class="card-body p-0">
                            <div class="basic-form">
                                <div class="form-row">
                                    <div class="col-md-8">
                                        <div class="form-group">
                                            <h4>Upload User CSV</h4>
                                        </div>
                                    </div>

                                </div>
                                <form id="filterdata"
                                    action="{{ route($modelName . '.upload_offer_csv', base64_encode(serialize($id))) }}"
                                    method="post" enctype="multipart/form-data">
                                    @csrf
                                    @php
                                        $transactionby = '';
                                    @endphp
                                    <div class="form-row">
                                        <div class="form-group col-md-3">
                                            <label>Upload CSV</lable>
                                                <input type='file' id="offer_csv_users" accept=".csv"
                                                    name="offer_csv_users" class="form-control" />
                                                <input type="hidden" name="offer_id" value="<?php echo $offer->id; ?>" />
                                        </div>
                                        <div class="form-group col-md-3">
                                            <input style="margin-top: 30px;margin-left: 10px;" class="form-check-input"
                                                value="1" type="checkbox" name="delete_previous_csv"
                                                id="delete_previous_csv">
                                            <label style="margin-top: 27px;margin-left: 30px;">Delete Previous CSV </label>


                                        </div>
                                        <div class="form-group col-md-3">
                                            <p class="fund" style="margin-top: -20px;">&nbsp</p>
                                            <button type="submit" value="submit"
                                                class="btn btn-primary show-data">Submit</button>&nbsp;&nbsp;
                                            <a href="{{ route($modelName . '.upload_offer_csv', base64_encode(serialize($id))) }}"
                                                class="btn btn-primary reset-data">Reset</a>
                                        </div>

                                        <div class="form-group col-md-3">
                                            <p class="fund" style="margin-top: -20px;">&nbsp</p>

                                            <a href="<?php echo WEBSITE_UPLOADS_URL . 'sample_upload_offer_csv.csv'; ?>" class="btn btn-primary reset-data">Download Sample
                                                CSV</a>
                                        </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="card-body">
                    <div class="table-responsive">
                        <table id="dataList" class="display" style="min-width: 845px">
                            <thead>
                                <tr>
                                    <th>S No.</th>
                                    <th>Mobile</th>
                                    <th>Username</th>
                                    <th>Team</th>
                                    <th>Comment</th>
                                    <th>Date</th>
                                </tr>
                            </thead>

                            <tfoot>
                                <tr>
                                    <th>S No.</th>
                                    <th>Mobile</th>
                                    <th>Username</th>
                                    <th>Team</th>
                                    <th>Comment</th>
                                    <th>Date</th>
                                </tr>
                            </tfoot>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
    </div>

    <script type="text/javascript">
        $(document).ready(function() {
            var users_type = '';
            usersWalletData(users_type);
        });
    </script>
    <script type="text/javascript">
        function usersWalletData(users_type) {

            let offer_id = '<?php echo $id; ?>';
            let end_date = '';
            let start_date = '';
            var data = {
                "_token": "{{ csrf_token() }}",
                "offer_id": offer_id
            };

            $('#dataList').DataTable({
                //order: [1, 'DESC'],
                "processing": true,
                "serverSide": true,
                "ajax": {
                    url: "{{ route($modelName . '.get_upload_offer_csv') }}",
                    type: "POST",
                    data: data
                },
                "columns": [{
                        data: 'DT_RowIndex',
                        name: 'DT_RowIndex'
                    },
                    {
                        data: 'mobile',
                        name: 'mobile'
                    },
                    {
                        data: 'username',
                        name: 'username'
                    },
                    {
                        data: 'team',
                        name: 'team'
                    },
                    {
                        data: 'comment',
                        name: 'comment'
                    },
                    {
                        data: 'created',
                        name: 'created'
                    },
                ]
            });
        }
    </script>
@endsection
