@extends('admin.layouts.default')
@section('content')
    <!-- DATATABLE GLOBAL SCRIPTS -->
    <link rel="stylesheet" href="{{ asset('assets/css/admin/datatable.css') }}" />
    <script src="{{ asset('assets/js/admin/datatable.js') }}"></script>
    <!-- DATATABLE GLOBAL SCRIPTS -->
    <script>
        $(document).ready(function() {
            $('[data-toggle="tooltip"]').tooltip();
        });
    </script>
    <!-- <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.1.3/css/bootstrap.min.css" integrity="sha384-MCw98/SFnGE8fJT3GXwEOngsV7Zt27NXFoaoApmYm81iuXoPkFOJwJ8ERdknLPMO" crossorigin="anonymous"> -->
    <style type="text/css">
        th {
            color: #30323f;
        }

        .pagination {
            display: inline-block;
            padding-left: 0;
            margin: 20px 0;
            border-radius: 4px;
            margin-right: 20px;
        }

        .pagination>li {
            display: inline;
        }

        .pagination>li.active>span {
            background-color: #30323f;
            color: white;
        }

        .pagination>li>a,
        .pagination>li>span,
        .pagination>.disabled>a {
            background-color: #393e45;
            border-color: #4a5059;
        }

        .pagination>li>a,
        .pagination>li>span {
            position: relative;
            float: left;
            padding: 6px 12px;
            margin-left: -1px;
            line-height: 1.42857143;
            color: #337ab7;
            text-decoration: none;
            background-color: #fff;
            border: 1px solid #ddd;
            border-top-color: rgb(221, 221, 221);
            border-right-color: rgb(221, 221, 221);
            border-bottom-color: rgb(221, 221, 221);
            border-left-color: rgb(221, 221, 221);
        }

        @media only screen and (max-width: 600px) {}
    </style>

    <div class="container-fluid">
        <div class="row page-titles mx-0" data-aos="fade-up">
            <div class="col-sm-6 p-md-0">
                <!-- <div class="welcome-text">
                        <h4>GST Report</h4>
                    </div> -->
            </div>
            <div class="col-sm-6 p-md-0 justify-content-sm-end mt-2 mt-sm-0 d-flex">
                <!-- <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a href="javascript:void(0)">GST Report</a></li>
                    </ol> -->
            </div>
        </div>
        <div class="row">
            <div class="col-12">
                <div class="card" data-aos="fade-up">


                    <div class="card-header">
                        <h4>Deposit GST Report</h4>
                    </div>

                    <div class="card-body">

                        <div class="basic-form">
                            <form action="$modelName.'.gst_report_deposit'" id="searchGstForm" enctype="multipart/form-data"
                                method="GET">
                                @php

                                    $start_date = @$_GET['start_date'] != '' ? $_GET['start_date'] : '';
                                    $end_date = @$_GET['end_date'] != '' ? $_GET['end_date'] : '';
                                    $matchkey = @$_GET['matchkey'] != '' ? $_GET['matchkey'] : '';
                                    $sport_type = @$_GET['sport_type'] != '' ? $_GET['sport_type'] : '';
                                    $transaction_by = @$_GET['transaction_by'] != '' ? $_GET['transaction_by'] : '';
                                    $challenge_id = @$_GET['challenge_id'] != '' ? $_GET['challenge_id'] : '';

                                @endphp
                                <div class="form-row">

                                    <div class="form-group col-md-2 mb-0">
                                        <label>Start Date</label>
                                        <div class="form-group col-md-6">
                                            <input type="text" name="start_date" id="start_date"
                                                class="pull-left form-control datetimepickerget w-95"
                                                value="{{ !empty($start_date) ? $start_date : date('Y-m-01') }}"
                                                autocomplete="off">
                                        </div>
                                    </div>

                                    <div class="form-group col-md-2 mb-0">
                                        <label>End Date</label>
                                        <div class="form-group col-md-6">
                                            <input type="text" name="end_date" id="end_date"
                                                class="pull-left form-control datetimepickerget w-95"
                                                value="{{ isset($end_date) && !empty($end_date) ? $end_date : date('Y-m-d') }}"
                                                autocomplete="off">
                                        </div>
                                    </div>

                                    <!-- <div class="form-group col-md-2 mb-0">
                                        <label>Match Id</label>
                                        <div class="form-group col-md-6">
                                            <input type="text" name="matchkey" id="matchkey" class="pull-left form-control w-95" value="{{ isset($matchkey) && !empty($matchkey) ? $matchkey : '' }}">
                                        </div>
                                    </div>

                                    <div class="form-group col-md-2 mb-0">
                                        <label>Challenge Id</label>
                                        <div class="form-group col-md-6">
                                            <input type="text" name="challenge_id" id="challenge_id" class="pull-left form-control w-95" value="{{ isset($challenge_id) && !empty($challenge_id) ? $challenge_id : '' }}">
                                        </div>
                                    </div>-->

                                    <div class="form-group col-md-2 mb-0">
                                        <label>Transaction Type</label>
                                        <div class="form-group col-md-6">
                                            <select class="form-control" name="transaction_by" id="transaction_by">
                                                <option value="">Select Transaction Type</option>

                                                <!-- @foreach ($sport_type_arr as $key => $value)
    <option value="{{ $key }}" {{ $sport_type == $key ? 'selected' : '' }}>{{ $value }}</option>
    @endforeach-->

                                                <option value="SONICPAY"
                                                    {{ $transaction_by == 'SONICPAY' ? 'selected' : '' }}> SONICPAY</option>
                                                <option value="SubPaisa"
                                                    {{ $transaction_by == 'SubPaisa' ? 'selected' : '' }}>SubPaisa</option>
                                                <option value="admin" {{ $transaction_by == 'admin' ? 'selected' : '' }}>
                                                    Admin</option>
                                                <option value="PHONEPAY"
                                                    {{ $transaction_by == 'PHONEPAY' ? 'selected' : '' }}>PHONEPAY</option>
                                                <option value="RAZORPAY"
                                                    {{ $transaction_by == 'RAZORPAY' ? 'selected' : '' }}>RAZORPAY</option>
                                            </select>
                                        </div>
                                    </div>
                                </div>
                        </div>
                    </div>
                    <div class="card-footer py-4">
                        <button name="get-report" id="get-report" type="submit" class="btn btn-primary">Get Deposit GST
                            Report</button>
                    </div>
                    </form>

                    <div class="card-footer py-4">
                        <form id="Downlode_GSTForm" action="{{ route('Analytics.gst_report_deposit') }}" method="get">
                            <input type="hidden" name="start_date" id="download_start_date"
                                value="{{ !empty($start_date) ? $start_date : date('Y-m-01') }}">
                            <input type="hidden" name="end_date" id="download_end_date"
                                value="{{ !empty($end_date) ? $end_date : date('Y-m-t') }}">
                            <input type="hidden" name="transaction_by" id="download_transaction_by"
                                value="{{ !empty($transaction_by) ? $transaction_by : '' }}">

                            <input type="hidden" name="download" value="download">
                            <button id="Downlode_GSTBtn" class="btn btn-primary gst-download" style="display:none;">Download
                                Deposit GST Report
                            </button>
                        </form>
                    </div>


                    <div id="datatablediv" class="card-body">
                        <div class="table-responsive">

                            <table id="dataList" class="table table-striped" class="display" style="min-width: 845px"
                                style="display: none;">
                                <thead>
                                    <tr>
                                        <th>S. NO</th>
                                        <th>CUSTOMER ID</th>
                                        <th>Name</th>
                                        <th>Email</th>
                                        <th>Mobile</th>
                                        <th>State</th>
                                        <th>Pan Number</th>
                                        <th>Team Name</th>
                                        <th>Add Fund</th>
                                        <th>Gst Amount</th>
                                        <!-- <th>IGST</th>
                                            <th>SGST</th>
                                            <th>CGST</th> -->
                                        <th>Wallet Amount</th>
                                        <th>Transaction By</th>
                                        <th>Transaction DATE</th>
                                        <th>Total Tax to Pay</th>
                                        <th>IP Address</th>
                                    </tr>
                                </thead>

                                <tbody>

                                </tbody>

                                <tr>
                                    <th>Total</th>
                                    <th></th>
                                    <th></th>
                                    <th></th>
                                    <th></th>
                                    <th></th>
                                    <th></th>
                                    <th></th>
                                    <th></th>
                                    <th></th>
                                    <!-- <th>{{ $totalTax->igst ?? 0 }}</th>
                                        <th>{{ $totalTax->sgst ?? 0 }}</th>
                                        <th>{{ $totalTax->cgst ?? 0 }}</th> -->
                                    <th></th>
                                    <th></th>
                                    <th></th>
                                    <th></th>
                                    <th>{{ round($totalTax->igst + $totalTax->cgst, 2) ?? 0 }}</th>
                                </tr>
                            </table>

                        </div>
                    </div>



                </div>
            </div>
        </div>
    </div>

    <script type="text/javascript">
        $(document).ready(function() {
            var start_date = $('#start_date').val();

            var end_date = $('#end_date').val();

            if (start_date) {
                $('#Downlode_GSTBtn').show();
            } else if (end_date) {
                $('#Downlode_GSTBtn').show();
            } else {
                $('#Downlode_GSTBtn').hide();
            }
            //var transaction_by = "cashfree";
            var transaction_by = $('#transaction_by').val();
            // alert(transaction_by);
            /*  var matchkey = $('#matchkey').val();
              var challenge_id = $('#challenge_id').val();
              var sport_type = $('#sport_type').val();*/
            $.fn.dataTable.ext.errMode = 'none';
            $('#dataList').DataTable({
                // order: [0, 'desc'],
                "processing": true,
                "serverSide": true,
                "searching": false,
                "ajax": {
                    //"url": '?start_date='+start_date+'&end_date='+end_date+'&matchkey='+matchkey+'&challenge_id='+challenge_id+'&sport_type='+sport_type,
                    "url": '<?php echo url()->asset('admin/analytics/gst_report_deposit'); ?>?start_date=' + start_date + '&end_date=' + end_date +
                        '&transaction_by=' + transaction_by,
                    "dataType": "json",
                    "type": "POST",
                    "data": {
                        _token: "{{ csrf_token() }}"
                    }
                },
                "columns": [{
                        "data": "s_no"
                    },
                    {
                        "data": "CustomerID"
                    },
                    {
                        "data": "user_username"
                    },
                    {
                        "data": "email"
                    },
                    {
                        "data": "mobile"
                    },
                    {
                        "data": "state"
                    },
                    {
                        "data": "pan_number"
                    },
                    {
                        "data": "teamname"
                    },
                    {
                        "data": "deposit_amount"
                    },
                    {
                        "data": "gst_amount"
                    },
                    // { "data": "igst"},
                    // { "data": "sgst"},
                    // { "data": "cgst"},
                    {
                        "data": "wallet_amount"
                    },
                    {
                        "data": "transaction_by"
                    },
                    {
                        "data": "InvoiceDate"
                    },
                    {
                        "data": "total_tax"
                    },
                    {
                        "data": "ip_address"
                    },

                ]

            });
        });
    </script>
    <style type="text/css">
        #dataList_wrapper {
            overflow-x: scroll;
        }
    </style>


    <script type="text/javascript">
        //datepicket without time
        $(document).ready(function() {
            $('#end_date,#start_date, #start_date_summary, #end_date_summary').datetimepicker({
                timepicker: false,
                format: 'Y-m-d',
                closeOnDateSelect: true,
            });
        });

        $(document).on('click', '#Downlode_GSTBtn', function(event) {
            var start_date = $('#start_date').val();
            $('#download_start_date').val(start_date);
            var end_date = $('#end_date').val();
            $('#download_end_date').val(end_date);
            var transaction_by = $('#transaction_by').val();
            $('#download_transaction_by').val(transaction_by);
            $("#Downlode_GSTForm").submit();
        });
    </script>
@endsection
