@extends('admin.layouts.default')
@section('content')

<script>
    $(document).ready(function(){
      $('[data-toggle="tooltip"]').tooltip();
    });
  </script>

<div class="container-fluid">
    <div class="row page-titles mx-0" data-aos="fade-up">
        <div class="col-sm-6 p-md-0">
            <!-- <div class="welcome-text">
                <h4>All Registered Users Wallet List</h4>
            </div> -->
        </div>
        <!-- <div class="col-sm-6 p-md-0 justify-content-sm-end mt-2 mt-sm-0 d-flex">
            <ol class="breadcrumb">
              <li class="breadcrumb-item">Transaction Manager</li>
                <li class="breadcrumb-item">User Record By Month</li>
            </ol>
        </div> -->
    </div>
    <div class="row">
        <div class="col-12">
            <div class="card" data-aos="fade-up">

                <div class="card-body" style="background-color: beige;">
                    <h4>User Report Date Wise</h4>
                    <form action="{{route('Analytics.user_transactions_reconcilation')}}" method="post">
                        <div class="form-row">
                            <div class="form-group col-md-2 mb-md-0 mb-2">
                                <div class="form-group col-md-6">
                                    <input type="text" class="form-control" name="email" value="{{old('email')}}" required placeholder="Email/mobile">
                                    @if($errors->has('email'))
                                    <span class="text-danger">{{ $errors->first('email') }}</span>
                                    @endif
                                    {{-- @if(session()->has('success'))
                                        <span style="color:red;">{{session('success')}}</span>
                                    @endif --}}
                                </div>
                            </div>
                            <div class="form-group col-md-2 mb-md-0 mb-2">
                                <div class="form-group col-md-6">
                                    <input type="text" class="form-control datetimepickerget" name="start_date" id="start_date" value="{{old('start_date')}}" required autocomplete="off" placeholder="Start Date">
                                    @if($errors->has('start_date'))
                                    <div class="text-danger">{{ $errors->first('start_date') }}</div>
                                    @endif
                                </div>
                            </div>
                            <div class="form-group col-md-2 mb-md-0 mb-2">
                                <div class="form-group col-md-6">

                                    <input type="text" class="form-control datetimepickerget" name="end_date" id="end_date" value="{{old('end_date')}}" required autocomplete="off" placeholder="End Date">
                                    @if($errors->has('end_date'))
                                    <div class="text-danger">{{ $errors->first('end_date') }}</div>
                                    @endif
                                </div>
                            </div>
                            <div class="form-group col-md-2 mb-md-0 mb-2">
                                <div class="form-group col-md-6">
                                    <input type="submit" class="btn btn-lg btn-success" value="Submit">
                                </div>
                            </div>
                        </div>
                    </form>
                </div>


            </div>

        </div>
    </div>

    @if(isset($query) || !empty($query))
    <div class="row">
        <div class="col-6">
            <div class="card" data-aos="fade-up">

                <div class="card-body">


                    <table class="table">
                     <thead>
                     </thead>
                     <tbody>
                        <tr>
                            <td><strong>Opening Balance</strong></td>
                            <td><strong>{{ $openingBalance->total_available_amt ?? 0 }}</strong></td>
                        </tr>
                    @foreach($query as $row)
                        <tr>
                            <td>{{ $row->type}}</td>
                            @if($row->transaction_by == 'wallet')
                            <td style="color:red">-{{ $row->amount}}</td>
                            @else
                            <td style="color:green">{{ $row->amount}}</td>
                            @endif
                        </tr>
                    @endforeach


                    <tr>
                        <td><strong>Total</strong></td>
                        <td><strong>{{ $closingBalance ?? 0}}</strong></td>
                    </tr>

                     <tr>
                        <td><strong>Projected available amount</strong></td>
                        <td><strong>{{ @$openingBalance->total_available_amt + $closingBalance ?? 0}}</strong></td>
                    </tr>

                     <tr>
                        <td><strong>Available Bal</strong></td>
                        <td><strong>{{ $currentBalance->total_available_amt ?? 0}}</strong></td>
                    </tr>

                    <tr>
                        <td style="color:red;"><strong>Difference</strong></td>
                        <td style="color:red;"><strong>{{ number_format(@$currentBalance->total_available_amt - (@$openingBalance->total_available_amt + $closingBalance),2) ?? 0}}</strong></td>
                    </tr>

                    </tbody>
                    </table>


                </div>
            </div>
        </div>
    </div>

    @endif

</div>
<script type="text/javascript">

        //datepicket without time
        $(document).ready(function(){
            $('#end_date,#start_date').datetimepicker({
                timepicker: false,
                format:'Y-m-d',
                closeOnDateSelect:true,
            });
        });
</script>
@endsection
