@extends('admin.layouts.default')

@section('content')

<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/cropperjs/1.5.6/cropper.css"/>

<div class="container-fluid">
    <div class="row page-titles mx-0" data-aos="fade-up">
        <div class="col-sm-6 p-md-0 justify-content-sm-end mt-2 mt-sm-0 d-flex"></div>
        <div class="col-sm-6 p-md-0 justify-content-sm-end mt-2 mt-sm-0 d-flex">
            <ol class="breadcrumb">
                <li class="breadcrumb-item active">
                    <a href="{{ route($modelName . '.view') }}">All Bonus</a>
                </li>
                <li class="breadcrumb-item">Add</li>
            </ol>
        </div>
    </div>

    <div class="row">
        <div class="col-xl-12 col-xxl-12">
            <div class="card" data-aos="fade-up">
                <div class="card-header">
                    <h4 class="card-title">Add Bonus</h4>
                </div>
                <div class="card-body">
                    <div class="basic-form">
                        <form id="playerAddForm" action="{{ route($modelName . '.add') }}" method="POST" enctype="multipart/form-data">
                            @csrf

                            <div class="form-row">
                                <div class="form-group col-md-6">
                                    <label class="lbl_frm py-2">Bonus Name</label>
                                    <input type="text" class="form-control in_text" name="type" placeholder="Enter bonus name here" value="{{ old('type') }}">
                                    @error('type') <div class="error-message help-inline">{{ $message }}</div> @enderror
                                </div>

                                <div class="form-group col-md-6">
                                    <label class="lbl_frm py-2">Bonus Price</label>
                                    <input type="text" class="form-control in_text" name="price" placeholder="Enter bonus price here" value="{{ old('price') }}">
                                    @error('price') <div class="error-message help-inline">{{ $message }}</div> @enderror
                                </div>
                            </div>

                            <div class="form-row">
                                <div class="form-group col-md-6">
                                    <label class="lbl_frm py-2">Bonus Type</label>
                                    <select class="form-control in_text sport_types" name="bonus_type">
                                        <option value="">Select Bonus Type</option>
                                        <option value="Amount">Amount</option>
                                        <option value="Percentage">Percentage</option>
                                    </select>
                                    @error('bonus_type') <div class="error-message help-inline">{{ $message }}</div> @enderror
                                </div>

                                <div class="form-group col-md-6">
                                    <label class="lbl_frm py-2">Select Bonus Status</label>
                                    <select class="form-control in_text sport_types" name="status">
                                        <option value="">Select Status</option>
                                        <option value="1">Active</option>
                                        <option value="0">Inactive</option>
                                    </select>
                                    @error('status') <div class="error-message help-inline">{{ $message }}</div> @enderror
                                </div>
                            </div>

                            <div class="form-row">
                                <div class="form-group col-md-6">
                                    <label class="lbl_frm py-2">First Deposit</label>
                                    <input type="checkbox" class="form-check-input" id="myCheck" onclick="checkBoxcheck()">
                                    <input type="hidden" id="text" name="first_deposit" value="0">
                                </div>

                                <div class="form-group col-md-6">
                                    <label class="lbl_frm py-2">First Deposit Condition</label>
                                    <textarea class="form-control in_text" name="first_dep_condition" rows="3"></textarea>
                                </div>
                            </div>

                            <div class="form-row" id="maxlimit" style="display: none;">
                                <div class="form-group col-md-6">
                                    <label class="lbl_frm py-2">Max Deposit Limit</label>
                                    <input type="number" class="form-control in_text" name="max_deposit_limit" placeholder="Enter Max Deposit Limit">
                                </div>
                            </div>

                            <div class="py-2">
                                <button type="submit" class="btn btn-primary mr-2">Submit</button>
                                <button type="button" class="btn btn-gray" id="cancel_btn">Cancel</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Modal for Image Cropper -->
<div class="modal fade bd-example-modal-lg imagecrop" id="model" tabindex="-1" data-backdrop="static" role="dialog">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">New Image</h5>
            </div>
            <div class="modal-body">
                <div class="img-container">
                    <div class="row">
                        <div class="col-md-11">
                            <img id="image" src="https://avatars0.githubusercontent.com/u/3456749">
                        </div>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                <button type="button" class="btn btn-primary crop" id="crop">Crop</button>
            </div>
        </div>
    </div>
</div>

<script src="https://cdnjs.cloudflare.com/ajax/libs/cropperjs/1.5.6/cropper.js"></script>

<script>
    $(document).ready(function() {
        $("#cancel_btn").click(function() {
            window.location.href = $(".breadcrumb-item.active a").attr("href");
        });
    });

    function checkBoxcheck() {
        var checkBox = document.getElementById("myCheck");
        var text = document.getElementById("text");
        var maxlimit = document.getElementById("maxlimit");

        if (checkBox.checked) {
            text.value = '1';
            maxlimit.style.display = "block";
        } else {
            text.value = '0';
            maxlimit.style.display = "none";
        }
    }

    var $modal = $('.imagecrop');
    var image = document.getElementById('image');
    var cropper;

    $("body").on("change", ".imageUpload", function(e) {
        var files = e.target.files;
        var done = function(url) {
            image.src = url;
            $modal.modal('show');
        };
        if (files && files.length > 0) {
            var reader = new FileReader();
            reader.onload = function(e) {
                done(reader.result);
            };
            reader.readAsDataURL(files[0]);
        }
    });

    $modal.on('shown.bs.modal', function() {
        cropper = new Cropper(image, { aspectRatio: 1, viewMode: 1 });
    }).on('hidden.bs.modal', function() {
        cropper.destroy();
        cropper = null;
    });

    $("body").on("click", "#crop", function() {
        var canvas = cropper.getCroppedCanvas({ width: 160, height: 160 });
        canvas.toBlob(function(blob) {
            var reader = new FileReader();
            reader.readAsDataURL(blob);
        });
    });
</script>

@endsection
