@extends('admin.layouts.default')
@section('content')
    <!-- DATATABLE GLOBAL SCRIPTS -->
    <link rel="stylesheet" href="{{ asset('assets/css/admin/datatable.css') }}" />
    <script src="{{ asset('assets/js/admin/datatable.js') }}"></script>
    <!-- DATATABLE GLOBAL SCRIPTS -->
    <script>
        $(document).ready(function() {
            $('[data-toggle="tooltip"]').tooltip();
        });
    </script>

    <div class="container-fluid">
        <div class="row page-titles mx-0" data-aos="fade-up">
            <div class="col-sm-6 p-md-0">
                <!-- <div class="welcome-text">
                    <h4>Admin Wallet</h4>
                </div> -->
            </div>
            <div class="col-sm-6 p-md-0 justify-content-sm-end mt-2 mt-sm-0 d-flex">
                <!-- <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="javascript:void(0)">Bank Withdraw Requests</a></li>
                </ol> -->
            </div>
        </div>
        <div class="row">
            <div class="col-12">
                <div class="card" data-aos="fade-up">
                    <div class="card-header">

                        <div class="card-body p-0">
                            <div class="basic-form">
                                <form action="{{ route($modelName . '.profilt_loss_report') }}" id="filterdata" method="GET"
                                    enctype="multipart/form-data">
                                    @php

                                        $start_date = '';
                                        if (isset($_GET['start_date'])) {
                                            $start_date = $_GET['start_date'];
                                        }

                                        $end_date = '';
                                        if (isset($_GET['end_date'])) {
                                            $end_date = $_GET['end_date'];
                                        }
                                    @endphp
                                    <div class="form-row">

                                        <div class="form-group col-md-2">
                                            <label> Start Date</lable>
                                                <input type="text" name="start_date" id="start_date"
                                                    class="form-control datetimepickerget" value="<?php if (!empty($start_date)) {
                                                        echo $start_date;
                                                    } ?>"
                                                    placeholder="Start date" autocomplete="off">
                                        </div>
                                        <div class="form-group col-md-2">
                                            <label> End Date</lable>
                                                <input type="text" name="end_date" id="end_date"
                                                    class="form-control datetimepickerget" value="<?php if (!empty($end_date)) {
                                                        echo $end_date;
                                                    } ?>"
                                                    placeholder="End Date" autocomplete="off">
                                        </div>
                                        <div class="form-group col-md-2">
                                            <p class="fund" style="margin-top: -14px;">&nbsp</p>
                                            <button type="submit" value="submit"
                                                class="btn btn-primary show-data">Submit</button>
                                            <a href="{{ route($modelName . '.profilt_loss_report') }}"
                                                class="btn btn-primary reset-data">Reset</a>
                                        </div>
                                </form>

                            </div>
                        </div>
                    </div>
                    <a href="{{ route($modelName . '.profilt_loss_report_download', 'start_date=' . $start_date . '&end_date=' . $end_date) }}"
                        class="btn btn-success">Download Report</a>

                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table  table-striped table-bordered dataex-fixh-basic dataTable" id="adminwallet"
                            role="grid" aria-describedby="DataTables_Table_0_info">
                            <thead>
                                <tr>
                                    <th>S No.</th>
                                    <th>Date</th>
                                    <th>Company Loss</th>
                                    <th>Company Profit</th>
                                    <!-- <th>promo Code Amount</th> -->
                                    <th>Affiliation Commission</th>
                                    <th>Bot Loss</th>
                                    <th>Total InvestMent</th>
                                    <th>Total Winning</th>
                                </tr>
                            </thead>

                            <tbody>

                            </tbody>
                            <tr>
                                <th>Total</th>
                                <th>Promo Code Amount {{ $promoamount }}</th>
                                <th>{{ $totalloss ?? 0 }}</th>
                                <th>{{ $totalprofit ?? 0 }}</th>
                                <th>{{ $totalaff ?? 0 }}</th>
                                <th>{{ $totalbotloss ?? 0 }}</th>
                                <th></th>
                                <th></th>
                            </tr>

                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
    </div>



    <script type="text/javascript">
        $(document).ready(function() {
            var start_date = $('#start_date').val();
            var end_date = $('#end_date').val();
            //$.fn.dataTable.ext.errMode = 'none';
            $('#adminwallet').DataTable({
                //       "columnDefs": [
                // { "orderable": false, "targets": -1 }
                //   ],
                "order": [
                    [1, 'desc']
                ],
                "processing": true,
                "serverSide": true,
                "ajax": {
                    "url": '<?php echo url()->asset('admin/bonus/user_profit_loss'); ?>?&start_date=' + start_date + '&end_date=' + end_date,
                    "dataType": "json",
                    "type": "POST",
                    "data": {
                        _token: "{{ csrf_token() }}"
                    }
                },

                "columns": [{
                        "data": "id",
                        orderable: false
                    },
                    {
                        "data": "start_date"
                    },
                    {
                        "data": "company_loss"
                    },
                    {
                        "data": "company_earn"
                    },
                    //{ "data": "promocodeamount" },
                    {
                        "data": "affiliation_commission"
                    },
                    {
                        "data": "bot_loss"
                    },
                    {
                        "data": "total_investment"
                    },
                    {
                        "data": "total_winning"
                    }
                ],
                'createdRow': function(row, data, dataIndex) {
                    if (data.status == 0) {
                        $(row).addClass('inactive-record-status');
                    }
                }

            });
            $('#adminwallet_filter').hide();

        });
    </script>
@endsection
