@extends('admin.layouts.default')
@section('content')
    <script type="text/javascript">
        $(document).ready(function() {
            $('[data-toggle="tooltip"]').tooltip();
        });
    </script>

    <!--**********************************
        Content body start
    ***********************************-->
    <div class="container-fluid">
        <div class="row page-titles mx-0" data-aos="fade-up">
            <div class="col-sm-6 p-md-0">
                <!-- <div class="welcome-text">
                    <h4>Create Challenge</h4>
                    <span class="ml-1">Layout</span>
                </div> -->
            </div>
            <div class="col-sm-6 p-md-0 justify-content-sm-end mt-2 mt-sm-0 d-flex">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item active"><a href="{{ route($modelName . '.view_challenges') }}">All Master
                            Leauge</a></li>
                    <li class="breadcrumb-item">Contest Matches</a></li>
                </ol>

            </div>

        </div>
        <div class="col-sm-6 mb-3">
            <a href="{{ route($modelName . '.global_challenge') }}" class="btn btn-primary btn-sm"> Add New Master League</a>
        </div>
        <!-- row -->
        <div class="row">
            <div class="col-xl-12 col-xxl-12">
                <div class="card" data-aos="fade-up">
                    <div class="card-header">
                        <h4 class="card-title">Contest Matches</h4>
                    </div>
                    <div class="card-body">
                        <div class="basic-form">
                            <form action="{{ route($modelName . '.create_challenge') }}" method="GET" id="challengeAddForm"
                                class="form-inline">
                                @php$matches = '';
                                    $getmatchid = '';
                                @endphp
                                @if (isset($_GET['matchid']))
                                    @php $getmatchid = $_GET['matchid']; @endphp
                                @endif
                                <div class="form-group col-md-6">
                                    <label class="sr-only">Email</label>
                                    <select class="form-control-plaintext" name="matchid" id="matchid_select"
                                        onchange="this.form.submit()">
                                        <option value=""> Select Match </option>
                                        @if (!empty($findalllistmatches))
                                            @foreach ($findalllistmatches as $matches)
                                                <option value='{{ $matches->matchkey }},{{ $matches->sport_type }}'
                                                    {{ isset($getmatchid) && $matches->matchkey == $getmatchid ? 'selected' : '' }}>
                                                    {{ ucwords($matches->matchname) }}</option>
                                            @endforeach
                                        @endif
                                    </select>
                                </div>
                                <!--  <button type="submit" class="btn btn-primary mb-2">Search</button> -->
                                <button class="btn btn-primary mb-2" type="submit"><i
                                        class="fa fa-repeat mr-2"></i>Reset</button>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <?php if(!empty($matchid)) { ?>
        <div class="card-header">
            <div class="card-title">All Leagues
                <br>
                <!-- <b>Bots Created : <?php echo @DB::table('bots_teams')->where('matchkey', $matchid)->count(); ?></b> -->
            </div>
            <a href="{{ route($modelName . '.add_match_challenge', $matchid) }}" class="btn btn-primary btn-sm">Add New
                League</a>
            <!-- <a href="{{ route('Matches.setflaxibleleague', [$matchid]) }}" class="btn btn-success btn-sm">Set Flaxible
                Manually</a> -->
            <a href="{{ route('Matches.editleaguesformatch', [$matchid, $sport_type]) }}"
                class="btn btn-primary btn-sm">Contest Matches</a>
            <a href="{{ route('Challenges.addmatchBots', [$matchid, $sport_type]) }}" class="btn btn-primary btn-sm">Update
                Bots</a>

            <!-- <a href="{{ route($modelName . '.import_match_data', $matchid) }}" class="btn btn-primary btn-sm">Import from Master League</a>  -->
        </div>
        <?php } ?>
        @if (isset($allchallenges) && count($allchallenges) > 0)
            <div class="col-xl-12 col-xxl-12 px-0">
                <div class="card" data-aos="fade-up">

                    <div class="card-body">
                        <div class="d-flex flex-wrap social-network-stats">
                            <?php $matchkey = ''; ?>
                            @if (!empty($allchallenges))
                                @foreach ($allchallenges as $challenge)
                                    <?php $matchkey = $challenge->matchkey; ?>
                                    <div class="item flex-sm-fill league_box">
                                        <span class="text-dark title p-3">Win Amount:
                                            <i class="fa fa-inr ml-4"></i>{{ $challenge->win_amount }}</span>
                                        <!-- <a href="{{ route($modelName . '.addBotsInChallenges', $challenge->id) }}"><button
                                                class="btn btn-dark" style="float:right"> Add Bots</button></a> -->

                                        <!-- <span class="social-icon youtube ml-3">
                                <i class="fa fa-youtube-play"></i>
                            </span> -->
                                        <div class="table-responsive mt-3">
                                            <table>
                                                <tbody>

                                                    <tr>
                                                        <td class="p-3">
                                                            <span class="text-dark h4">League Size:</span>
                                                        </td>
                                                        <td class="text-dark h4 p-3">
                                                            @if ($challenge->challenge_type == 'money')
                                                                {{ $challenge->maximum_user }}
                                                            @else
                                                                {{ $challenge->winning_percentage . ' % (of Total Users)' }}
                                                            @endif
                                                        </td>
                                                    </tr>
                                                    <tr>
                                                        <td class="p-3">
                                                            <span class="text-dark h4">Entry Fee:</span>
                                                        </td>
                                                        <td class="text-dark h4 p-3"><i
                                                                class="fa fa-inr"></i>{{ $challenge->entryfee }}</td>
                                                    </tr>
                                                    <tr>
                                                        <td class="p-3">
                                                            <span class="text-dark h4">League Type: </span>
                                                        </td>
                                                        <td class="text-dark h4 p-3">
                                                            @if ($challenge->challenge_type == 'money')
                                                                {{ 'Amount Based' }}
                                                            @else
                                                                {{ 'Percentage Based' }}
                                                            @endif
                                                        </td>
                                                    </tr>
                                                </tbody>
                                            </table>
                                            <?php $findteam = '';
                                            if ($challenge->created_by != 0) {
                                                $findteamaname = DB::table('registerusers')
                                                    ->where('id', $challenge->created_by)
                                                    ->select('team')
                                                    ->first();
                                                $findteam = isset($findteamaname->team) && !empty($findteamaname->team) ? $findteamaname->team : '';
                                            } ?>

                                            <td>{{ $findteam }}</td>
                                            </tr>
                                            <?php

                                            $findjoinedleauges = DB::table('joinedleauges')
                                                ->where('challengeid', $challenge->id)
                                                ->get();
                                            ?>

                                            <div class="modal fade" id="exampleModal_{{ $challenge->id }}" tabindex="-1"
                                                role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">

                                                <div class="modal-dialog modal-dialog-centered modal-lg" role="document">
                                                    <div class="modal-content">
                                                        <div class="modal-header">

                                                            <h5 class="modal-title" id="exampleModalLabel">Contest In
                                                                Details</h5>
                                                            <button type="button" class="close" data-dismiss="modal"
                                                                aria-label="Close">
                                                                <span aria-hidden="true">&times;</span>
                                                            </button>
                                                        </div>
                                                        <div class="modal-body">
                                                            <table>
                                                                <tbody>
                                                                    <tr>
                                                                        <td class="p-3">
                                                                            <span class="text-dark h4">Entry fee:</span>
                                                                        </td>
                                                                        <td class="text-dark h4 p-3">
                                                                            {{ $challenge->entryfee }}</td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td class="p-3">
                                                                            <span class="text-dark h4">Win Amount:</span>
                                                                        </td>
                                                                        <td class="text-dark h4 p-3">
                                                                            {{ $challenge->win_amount }}</td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td class="p-3">
                                                                            <span class="text-dark h4">Confirmed
                                                                                League:</span>
                                                                        </td>
                                                                        <td class="text-dark h4 p-3">
                                                                            <?php echo $challenge->confirmed_challenge == 1 ? 'Yes' : 'No'; ?>
                                                                        </td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td class="p-3">
                                                                            <span class="text-dark h4">Multi Entry:</span>
                                                                        </td>
                                                                        <td class="text-dark h4 p-3">
                                                                            <?php echo $challenge->multi_entry == 1 ? 'Yes' : 'No'; ?>
                                                                        </td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td class="p-3">
                                                                            <span class="text-dark h4">Is Team
                                                                                offer:</span>
                                                                        </td>

                                                                        <td class="text-dark h4 p-3">
                                                                            <?php echo $challenge->is_offer_team == 1 ? 'Yes' : 'No'; ?>
                                                                        </td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td class="p-3">
                                                                            <span class="text-dark h4">Is Team
                                                                                Number:</span>
                                                                        </td>
                                                                        <td class="text-dark h4 p-3"><?php echo !empty($challenge->offer_team_no) ? $challenge->offer_team_no : 0; ?>
                                                                        </td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td class="p-3">
                                                                            <span class="text-dark h4">Auto Repeat:</span>
                                                                        </td>
                                                                        <td class="text-dark h4 p-3">
                                                                            <?php echo $challenge->is_running == 1 ? 'Yes' : 'No'; ?>
                                                                        </td>
                                                                    </tr>
                                                                    @if ($challenge->challenge_type == 'money')
                                                                        @if ($challenge->marathon != 1)
                                                                            <tr>
                                                                                <td class="p-3">
                                                                                    <span class="text-dark h4">Price
                                                                                        Card:</span>
                                                                                </td class="p-3">
                                                                                <td class="p-3 text-dark h4"><a
                                                                                        href="{{ route($modelName . '.add_match_pricecard', base64_encode(serialize($challenge->id))) }}"
                                                                                        style="text-decoration:underline;">Add/Edit</a>
                                                                                </td>
                                                                            </tr>
                                                                        @else
                                                                            <tr>
                                                                                <td class="p-3">
                                                                                    <span class="text-dark h4">Price
                                                                                        Card:</span>
                                                                                </td>
                                                                                <td class="p-3 text-dark h4"><a
                                                                                        href="{{ route($modelName . '.add_match_pricecard', base64_encode(serialize($challenge->id))) }}"
                                                                                        style="text-decoration:underline;">Add/Edit</a>
                                                                                </td>
                                                                            </tr>
                                                                        @endif
                                                                    @endif
                                                                    <tr>
                                                                        <td class="p-3">
                                                                            <span class="text-dark h4">Created Date:</span>
                                                                        </td>
                                                                        <td class="text-dark h4">
                                                                            {{ date('d-M-y', strtotime($challenge->created_at)) }}
                                                                        </td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td class="p-3">
                                                                            <span class="text-dark h4">Created By:</span>
                                                                        </td>
                                                                        <?php $findteam = '';
                                                                        if ($challenge->created_by != 0) {
                                                                            $findteamaname = DB::table('registerusers')
                                                                                ->where('id', $challenge->created_by)
                                                                                ->select('team')
                                                                                ->first();
                                                                            $findteam = isset($findteamaname->team) && !empty($findteamaname->team) ? $findteamaname->team : '';
                                                                        } ?>

                                                                        <td class="p-3 text-dark h4">{{ $findteam }}
                                                                        </td>
                                                                    </tr>
                                                                    <?php
                                                                    $findjoinedleauges = DB::table('joinedleauges')
                                                                        ->where('challengeid', $challenge->id)
                                                                        ->get();
                                                                    ?>
                                                                <tbody>

                                                            </table>
                                                        </div>
                                                        <div class="modal-footer">
                                                            <button type="button" class="btn btn-secondary"
                                                                data-dismiss="modal">Close</button>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <tr>
                                                {{-- <td>
                                            <a href="{{ route($modelName . '.edit_bots_data', base64_encode(serialize($challenge->id))) }}" class="btn btn-primary" style="cursor: pointer">
                                                  Update Bots
                                              </a>
                                          </td> --}}

                                                @if (empty($findjoinedleauges[0]))
                                                    <table>
                                                        <tbody>

                                                            <td class="p-3">
                                                                <!--  <button type="submit" class="btn btn-primary mb-2">Edit</button>   -->

                                                                <a href="{{ route($modelName . '.edit_match_challenge', base64_encode(serialize($challenge->id))) }}"
                                                                    class="btn btn-primary btn-lg"
                                                                    style="cursor: pointer">
                                                                    Edit
                                                                </a>

                                                            </td>
                                                            <td class="p-3">
                                                                <a href="{{ route($modelName . '.del_match_challenge', base64_encode(serialize($challenge->id))) }}"
                                                                    class="btn btn-primary btn-lg"
                                                                    style="cursor: pointer">
                                                                    Delete
                                                                </a>
                                                            </td>
                                                            <td class="p-3">
                                                                <button type="button" class="btn btn-primary btn-lg"
                                                                    data-toggle="modal"
                                                                    data-target="#exampleModal_{{ $challenge->id }}"
                                                                    challengeid="<?php echo $challenge->challenge_id; ?>">View
                                                                    Details</button>
                                                            </td>
                                                            <!--  <td>
                                                <button class="btn btn-primary mb-2" type="submit">Delete</button>
                                            </td> -->
                                                        @else
                                                            @if ($challenge->is_flexible == 1)
                                                                <td class="p-3">
                                                                    <a href="{{ route($modelName . '.edit_match_challenge', base64_encode(serialize($challenge->id))) }}"
                                                                        class="btn btn-primary btn-lg"
                                                                        style="cursor: pointer">
                                                                        Edit
                                                                    </a>
                                                                </td>
                                                            @endif
                                                            @if ($challenge->status == 'canceled')
                                                                <td>
                                                                    <a class="btn btn-primary" style="cursor: pointer">
                                                                        League Closed</a>
                                                                </td>
                                                            @else
                                                                <td>
                                                                    <a class="btn btn-primary" style="cursor: pointer">
                                                                        League Joined </a>
                                                                </td>
                                                            @endif
                                                @endif
                                            </tr>
                                            <tr>
                                                <td>
                                                    <a href="{{ route($modelName . '.edit_bots_data', base64_encode(serialize($challenge->id))) }}"
                                                        class="btn btn-primary" style="cursor: pointer">
                                                        Update Bots
                                                    </a>
                                                </td>

                                                <td>
                                                    <form
                                                        action="{{ route('AutoBotsController.fillBotsTeamByChallengeId') }}"
                                                        method="GET" id="challengeAddForm" class="form-inline">


                                                        <input type="hidden" name="challenge_id" class="form-control"
                                                            value="{{ $challenge->id }}" required>
                                                        <input type="number" name="number_of_bots" class="form-control"
                                                            value="0" min="0" style="width:50px">
                                                        <button class="btn btn-primary" type="submit"> Fill Bots</button>


                                                    </form> 
                                                    {{-- <a href="{{ route('AutoBotsController.fillBotsTeamByChallengeId', $challenge->id) }}" class="btn btn-primary" style="cursor: pointer">
                                                  Fill Bots
                                              </a> --}}
                                                </td>
                                            </tr>
                                            </tbody>
                                            </table>
                                        </div>
                                    </div>
                                @endforeach
                            @endif
                        </div>
                    </div>
                </div>
            </div>
    </div>
@else
    @endif



    <!--**********************************
        Content body end
    ***********************************-->
@endsection
